/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: transmit.c,v 1.24 2003/05/26 20:25:17 carstenklapp Exp $";

/*
 Uptime Client v5.0 beta
 
 $Id: transmit.c,v 1.24 2003/05/26 20:25:17 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    transmit.c
 */

/* Common system includes */
#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>

#if defined __NetBSD__
#   include <sys/socket.h>
typedef u_int8_t sa_family_t;   /* sa_family_t */
#endif /* NetBSD */

#if !defined PLATFORM_WINNT
#   include <sys/types.h>       /* size_t */
#   include <sys/socket.h>
#endif /* !PLATFORM_WINNT */

#if !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
#   include <netinet/in.h>
#   include <arpa/inet.h>       /* htons(), in_addr_t */
#endif
/* Some Linux with old system headers might need this */
/* #if defined PLATFORM_LINUX
typedef uint32_t in_addr_t;
                           #endif *//* PLATFORM_LINUX */

/* Satisfy our own needs */
#include "base64.h"
#include "network.h"
#include "options.h"
#include "stats.h"
#include "transmit.h"
#include "uplog.h"      /* wrapper for <syslog.h> */
#include "version.h"

#include "locale.h"     /* gettext */

/* local */ char *udp_post(const char *hostname, const char *data);
char  *www_post(const char *hostname, const char *url,
                const char *proxyusername, const char *proxypassword,
                const char *data);

/**
 * @desc    Actual function that makes the connection via UDP to the
 *          Uptimes Project server after it composed the packet
 *          to send upstream. (Protocol 5)
 */
char  *
udp_post(const char *hostname, const char *data)
{
    int    sock;
    struct sockaddr_in lsin;
    struct hostent *he;

   /* char udp_post_error[255] = ""; */

    sock = socket(AF_INET, SOCK_DGRAM, 0);
    if (sock < 0) {
       /* sprintf(udp_post_error, "001 ERROR: Can't create UDP socket: %s",
          strerror(errno)); */
        return strerror(errno);
    }

    memset(&lsin, 0, sizeof(lsin));
    lsin.sin_family = (sa_family_t) AF_INET;

    lsin.sin_addr.s_addr = (in_addr_t) inet_addr(hostname);
    lsin.sin_port = htons(cfg_udpport);

    if ((int)lsin.sin_addr.s_addr == -1) {
        he = gethostbyname(hostname);
        if (!he) {
            if (close(sock))
                uplog(LOG_ERR, "%s", strerror(errno));
            return _("002 ERROR: Can't resolve hostname of uptime server");
        }
        memcpy(&lsin.sin_addr, he->h_addr, (size_t) he->h_length);
    }

   /* Connect to Uptime Server */
#if defined PARANOID
    if (close(sock))
        uplog(LOG_ERR, "%s", strerror(errno));
    return
        _
        ("000 NOTE: PARANOID MODE ENABLED, not connecting to Uptime Server via UDP");
#endif /* PARANOID */
    if (connect(sock, (struct sockaddr *)&lsin, (int)sizeof(lsin)) < 0) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return _("003 ERROR: Can't connect to Uptime Server via UDP");
    }

   /* Sending actual data */
    if (socket_write(sock, data, strlen(data)) < 0) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return _("004 ERROR: Can't send data via UDP");
    }
   /* UDP don't wait for no reply */
    if (close(sock))
        uplog(LOG_ERR, "%s", strerror(errno));
   /* return something, else Solaris 7 returns the first error message */
    return _("000 OK");
}

/**
 * @desc    Actual function that makes the connection via HTTP to the
 *          Uptimes Project server after it composed the packet
 *          to send upstream. (Protocol 4)
 */
char  *
www_post(const char *hostname, const char *url, const char *proxyusername,
         const char *proxypassword, const char *data)
{
    int    sock;
    struct sockaddr_in lsin;
    struct hostent *he;
    char   auth[128];
    char   header[512];
    int    n;
    char   rec[4096];
    char  *s;
    static char *s2;

   /* Create socket */
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        return _("005 ERROR: Can't create HTTP socket");
    }

    memset(&lsin, 0, sizeof(lsin));
    lsin.sin_family = AF_INET;

   /* Direct connect or through a proxy server? */
    lsin.sin_addr.s_addr = (in_addr_t) inet_addr(cfg_proxyserver);
    lsin.sin_port = htons(cfg_proxyport);

    if ((int)lsin.sin_addr.s_addr == -1) {
       /* Resolve host */
        he = gethostbyname(cfg_proxyserver);
        if (!he) {
            if (close(sock))
                uplog(LOG_ERR, "%s", strerror(errno));
            return _("006 ERROR: Can't resolve hostname of proxyserver");
        }
        memcpy(&lsin.sin_addr, he->h_addr, (size_t) he->h_length);
    }

   /* ... and proxy username and password */
    sprintf(auth, "%255s:%255s", proxyusername, proxypassword);

    if (!s2)
        s2 = base64_encode(auth);

   /* Connect to Uptime Server */
#if defined PARANOID
    if (close(sock))
        uplog(LOG_ERR, "%s", strerror(errno));
    return
        _
        ("000 NOTE: PARANOID MODE ENABLED, avoiding connection to Proxy Server via HTTP");
#endif /* PARANOID */
    if (connect(sock, (struct sockaddr *)&lsin, (int)sizeof(lsin)) < 0) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return _("007 ERROR: Can't connect to Proxy Server via HTTP");
    }

   /* Prepare header for send POST */
    sprintf(header,
            "POST http://%s%s HTTP/1.1\r\nHost: %s\r\nProxy-Connection: Close\r\nUser-Agent: upclient/%s/uptime-client-%s\r\n%sContent-type: application/x-www-form-urlencoded\r\nContent-length: %d\r\n\r\n",
            hostname, url, hostname, PROXY_PROTOCOL, UPCLIENT_VERSION,
            (have_proxyuser) ? "Proxy-Authorization: Basic %s\r\n" : "",
            strlen(data) - 1);
    if (have_proxyuser) {
        sprintf(header, header, s2);
        free(s2);
        s2 = NULL;
    }

   /* Print the header that will be send */
    if (verbose > 2) {
        uplog(LOG_INFO, "%s HTTP header:\n%s", _("verbose 3:"), header);
    }

    if (socket_write(sock, header, strlen(header)) < 0) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return _("008 ERROR: Can't send HTTP header");
    }

   /* Sending actual data */
    if (socket_write(sock, data, strlen(data)) < 0) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return _("009 ERROR: Can't send data via HTTP");
    }
   /* Wait for reply */
    n = socket_read(sock, rec, sizeof(rec) - 1);
    if (n < 0) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return _("010 ERROR: Can't receive data via HTTP");
    }
    rec[n] = '\0';
    s = strstr(rec, "\r\n\r\n");
    if (s) {
        if (close(sock))
            uplog(LOG_ERR, "%s", strerror(errno));
        return s + 4;
    }

   /* Always cleanup your own mess */
    if (close(sock))
        uplog(LOG_ERR, "%s", strerror(errno));

    return _("011 ERROR: No HTTP result received");
}

/**
 * @desc    Send our little update to the Uptimes Project(tm) server
 */
void
send_update(void)
{
    char  *ret;
    unsigned long uptimeminutes = 0;
    double UsagePercent = -1.0;
    double IdlePercent = -1.0;
    double loadavg = -1.0;
    static char osname[OS_SIZE] = "";
    static char osversion[OSVERSION_SIZE] = "";
    static char cpu[CPU_SIZE] = "";
    char   data[256];
    char   sentmsg[256] = "";

   /* Get the machine's uptime and other stats */
    getstats(&uptimeminutes, &UsagePercent, &IdlePercent, osname, osversion,
             cpu, &loadavg);
#if !defined DEBUG
    if (verbose > 2) {
#endif /* DEBUG */
        uplog(LOG_INFO,
              _
              ("%s Stats calculated: uptime %ld min., usage %.1f, idle %.1f, OS %s, OS version %s, CPU %s, load-average %.2f.\n"),
#if defined DEBUG
              (verbose > 2) ? _("verbose 3:") : "DEBUG:",
#else
              _("verbose 3:"),
#endif /* DEBUG */
              uptimeminutes, UsagePercent, IdlePercent, osname, osversion, cpu,
              loadavg);
#if !defined DEBUG
    }
#endif /* DEBUG */

   /* Create packet */
    if (have_proxyserver) {     /* using protocol 4 */
#if defined PLATFORM_WINNT
       /* the sprintf(data, "%sfoo", data); doesn't work for bcb5. This is a
          temp solution */
        sprintf(data, "auth=%s&uptime=%ld&os=%s&osversion=%s&cpu=%s\n",
                cfg_authkey, uptimeminutes, osname, osversion, cpu);
#else
        sprintf(data, "auth=%s&uptime=%ld", cfg_authkey, uptimeminutes);

        if (cfg_SendUsage)
            sprintf(data, "%s&load=%.1f", data, UsagePercent);

        if (cfg_SendIdle)
            sprintf(data, "%s&idle=%.1f", data, IdlePercent);

        if (cfg_sendosname)
            sprintf(data, "%s&os=%s", data, osname);

        if (cfg_sendosversion)
            sprintf(data, "%s&osversion=%s", data, osversion);

        if (cfg_sendcpu || cfg_sendcpudetail)
            sprintf(data, "%s&cpu=%s", data, cpu);

        sprintf(data, "%s\n", data);
#endif
    }
    else {      /* using protocol 5 */
#if defined PLATFORM_WINNT
       /* the sprintf(data, "%sfoo", data); doesn't work for bcb5. This is a
          temp solution */
        sprintf(data, "%s|%ld|||%s|%s|%s|upclient/%s/uptime-client-%s",
                cfg_authkey, uptimeminutes, osname, osversion, cpu, PROTOCOL,
                UPCLIENT_VERSION);
#else
        sprintf(data, "%s|%ld", cfg_authkey, uptimeminutes);
        if (cfg_SendUsage)
            sprintf(data, "%s|%.1f", data, UsagePercent);
        else
            sprintf(data, "%s|", data);

        if (cfg_SendIdle)
            sprintf(data, "%s|%.1f", data, IdlePercent);
        else
            sprintf(data, "%s|", data);

        sprintf(data, "%s|%s", data, cfg_sendosname ? osname : "");
        sprintf(data, "%s|%s", data, cfg_sendosversion ? osversion : "");
        sprintf(data, "%s|%s", data,
                (cfg_sendcpu || cfg_sendcpudetail) ? cpu : "");
        sprintf(data, "%s|upclient/%s/uptime-client-%s", data, PROTOCOL,
                UPCLIENT_VERSION);
#endif
    }

   /* Send packet */
    if (have_proxyserver) {     /* protocol 4 */
        ret =
            www_post(cfg_upserver, "/server.html",
                     (have_proxyuser) ? cfg_proxyuser : NULL,
                     (have_proxyuser) ? cfg_proxypass : NULL, data);
    }
    else {
        ret = udp_post(cfg_upserver, data);     /* protocol 5 */
    }

    if (verbose > 0) {
/* Only log what was transmitted. */
        if (cfg_SendUsage)
            sprintf(sentmsg, _("%s, usage %.1f"), sentmsg, UsagePercent);
        if (cfg_SendIdle)
            sprintf(sentmsg, _("%s, idle %.1f"), sentmsg, IdlePercent);
        if (verbose > 1) {
            if (cfg_sendosname)
                sprintf(sentmsg, _("%s, OS %s"), sentmsg, osname);
            if (cfg_sendosversion)
                sprintf(sentmsg, _("%s, OS version %s"), sentmsg, osversion);
            if (cfg_sendcpu || cfg_sendcpudetail)
                sprintf(sentmsg, _("%s, CPU %s"), sentmsg, cpu);
        }
        if (cfg_sendloadavg)
            sprintf(sentmsg, _("%s, load-average %.2f"), sentmsg, loadavg);

        uplog(LOG_INFO,
              _
              ("Uptime sent to %s with protocol %s. Stats: uptime %ld min.%s."),
              cfg_upserver, have_proxyserver ? PROXY_PROTOCOL : PROTOCOL,
              uptimeminutes, sentmsg);
        if (verbose > 2) {
            uplog(LOG_INFO, "%s %s [%s]", _("verbose 3:"), _("data:"), data);
        }
    }
#if defined PARANOID
    uplog(LOG_INFO, _("Paranoid mode enabled, no data packet sent"));
#endif /* PARANOID */
    if (verbose > 2) {
        if (have_proxyserver) {
            uplog(LOG_INFO, "%s %s", _("Result:"), ret);
        }
        else {
            uplog(LOG_INFO,
                  _("Using Protocol 5 (UDP) so server will never respond: %s"),
                  ret);
        }
    }
}
