/*
 Uptime Client v5.0 beta

 $Id: stats-w2k.c,v 1.18 2002/12/22 17:53:42 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats-w2k.c
 *
 * @desc        Retrieve stats for the Windows NT4/2000 platforms
 */

#if defined PLATFORM_WINNT

/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: stats-w2k.c,v 1.18 2002/12/22 17:53:42 carstenklapp Exp $";

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"

/* System includes */
#include <pdh.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <windows.h>

#if !defined SECONDS_PER_MINUTE
#   define SECONDS_PER_MINUTE 60;
#endif /* !defined SECONDS_PER_MINUTE */

/**
 * @desc    Verbose level 3 logging of calulations
 */
void
logcalc(char *whatwascalculateddesc, char *value)
{
#if defined DEBUG
    uplog(LOG_DEBUG, _("%s calculated: %s"), whatwascalculateddesc, value);
#endif /* DEBUG */
}

/**
 * @desc    Get statistics
 */
void
getstats(unsigned long *uptimeminutes, double *UsagePercent,
         double *IdlePercent, char *os, char *osversion, char *cpu,
         double *loadavg)
{
    HQUERY myQuery;
    HCOUNTER hPdhCounter;
    PDH_STATUS nStatusCode;
    PDH_FMT_COUNTERVALUE pdhfmtcv;
    LONGLONG lUptime;
    OSVERSIONINFO osVersionInfo;
    SYSTEM_INFO si;
    int    success = 0; /* false */

   /* open query to get perfomance data */
    if (PdhOpenQuery(NULL, 0, &myQuery) == ERROR_SUCCESS) {
       /* add system uptime to the query */
        if (PdhAddCounter
            (myQuery, "\\\\.\\System\\System Up Time", 0,
             &hPdhCounter) == ERROR_SUCCESS) {
           /* execute query */
            if (PdhCollectQueryData(myQuery) == ERROR_SUCCESS) {
                nStatusCode =
                    PdhGetFormattedCounterValue(hPdhCounter, PDH_FMT_LARGE,
                                                NULL, &pdhfmtcv);

                if (nStatusCode == ERROR_SUCCESS && pdhfmtcv.CStatus == 0) {
                    lUptime = pdhfmtcv.largeValue;
                    lUptime /= SECONDS_PER_MINUTE;      /* convert to minutes; */

                   /* convert 64-bits value -> 32 bits value... inaccurate when 
                      system longer up than 136 years */
                    *uptimeminutes = (unsigned long)lUptime;

                    success = 1;
                }
            }
        }
       /* close query */
        PdhCloseQuery(myQuery);
    }

   /* when failing... which should *never* happen return 0 for uptime */
    if (!success) {
        *uptimeminutes = 0;
    }

    if (cfg_sendosname) {
       /* this *must* be windows if its built against PLATFORM_WINNT */
        strcpy(osname, "Windows");
        logcalc(_("OS"), osname);
    }

    if (cfg_sendosversion) {
       /* retrieve os version */
        osVersionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
        GetVersionEx(&osVersionInfo);

        switch (osVersionInfo.dwMajorVersion) {
            case 5:
                strcpy(osversion, "2000");
                break;
            case 4:
                if (osVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
                    strcpy(osversion, "NT");
                }
                else {
                    strcpy(osversion,
                           (osVersionInfo.dwMinorVersion == 0 ? "95" : "98"));
                }
                break;
            case 3:
                if (osVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
                    strcpy(osversion, "NT 3.x");
                }
                else {
                   /* This should only happen if Win32s is installed, should
                      never happen */
                    strcpy(osversion, "3.x");
                }
                break;
            default:
                strcpy(osversion, "unknown");
        }
        logcalc(_("OS version"), osversion);
    }

    if (cfg_sendcpu || cfg_sendcpudetail) {
       /* retrieve system info */
        GetSystemInfo(&si);
        if (si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_ALPHA) {
            strcpy(cpu, "alpha");
        }
        else {
            if (si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL) {
                sprintf(cpu, "i%d86", si.wProcessorLevel);
            }
            else {
                strcpy(cpu, "unknown");
            }
        }
        logcalc(_("CPU"), cpu);
    }
}
#endif /* PLATFORM_WINNT */
