/*
 Uptime Client v5.0 beta
 
 $Id: stats-uxw.c,v 1.18 2002/12/22 17:53:42 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats-uxw.c
 *
 * @desc        Retrieve stats for the UnixWare platform
 */

#if defined PLATFORM_UNIXWARE

/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: stats-uxw.c,v 1.18 2002/12/22 17:53:42 carstenklapp Exp $";

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/utsname.h>
#include <sysexits.h>

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"
#include "uplog.h"      /* wrapper for <syslog.h> */

#if !defined HOURS_PER_DAY
#   define HOURS_PER_DAY 60;
#endif /* !defined HOURS_PER_DAY */
#if !defined MINUTES_PER_HOUR
#   define MINUTES_PER_HOUR 60;
#endif /* !defined MINUTES_PER_HOUR */
#if !defined SECONDS_PER_MINUTE
#   define SECONDS_PER_MINUTE 60;
#endif /* !defined SECONDS_PER_MINUTE */

/**
 * @desc    Verbose level 3 logging of calulations
 */
void
logcalc(char *whatwascalculateddesc, char *value)
{
#if defined DEBUG
    uplog(LOG_DEBUG, _("%s calculated: %s"), whatwascalculateddesc, value);
#endif /* DEBUG */
}

/**
 * @desc    Get statistics
 */
void
getstats(unsigned long *uptime, double *UsagePercent, double *IdlePercent,
         char *osname, char *osversion, char *cpu, double *loadavg)
{
    struct utsname uts;
    FILE  *fp;
    char   dummy_str[100];
    int    days;
    char   uptime_today[10];
    unsigned long uptime_mins;
    int    temp;
    char   sar_cmd[40];
    int    pct_idle;
    int    i;

   /* Get uptime */
    fp = popen("/usr/bin/uptime", "r");
    if (!fp)
        exit(EX_OSFILE);

    if (fscanf
        (fp, "%s %s %d %s %s %s", dummy_str, dummy_str, &days, dummy_str,
         uptime_today, dummy_str) < 2)
        exit(EX_UNAVAILABLE);   /* FIXME: is this ok? */
    fclose(fp);
    uptime_mins = days * HOURS_PER_DAY * MINUTES_PER_HOUR;
    temp = atoi(strtok(uptime_today, ":"));
    uptime_mins += temp * SECONDS_PER_MINUTE;
    temp = atoi(strtok(0, ":"));
    *uptimeminutes = uptime_mins + temp;

    if (cfg_SendIdle) {
       /* Get idle time for the current interval */
        sprintf(sar_cmd, "/usr/bin/sar %d 1", cfg_interval);
        fp = popen(sar_cmd, "r");
        fgets(dummy_str, sizeof(dummy_str), fp);        /* blank */
        fgets(dummy_str, sizeof(dummy_str), fp);        /* same as "uname -a" */
        fgets(dummy_str, sizeof(dummy_str), fp);        /* blank */
        fgets(dummy_str, sizeof(dummy_str), fp);        /* header line */
        fscanf(fp, "%s %d %d %d %d", dummy_str, &temp, &temp, &temp, &pct_idle);
        fclose(fp);

       /* First time through, init idle array to the first idle value we
          capture.  That seems most fair. */
        if (past_idle_times[0] == -1)
            for (i = 0; i < NUM_IDLE_ELEMENTS; ++i)
                past_idle_times[i] = pct_idle;

       /* Add interval to idle array, and calculate the average idle time. */
        temp = 0;
        for (i = 1; i < NUM_IDLE_ELEMENTS; ++i)
            temp += (past_idle_times[i - 1] = past_idle_times[i]);

        temp += (past_idle_times[NUM_IDLE_ELEMENTS - 1] = pct_idle);
        *IdlePercent = temp / (NUM_IDLE_ELEMENTS);
    }

    if (cfg_SendUsage) {
       /* unimplemented */
    }

    if (cfg_sendloadavg) {
       /* unimplemented */
    }

    if (cfg_sendosname || cfg_sendcpu) {
       /* Get os info & CPU info */
        uname(&uts);
    }

    if (cfg_sendosname) {
        strncpy(osname, uts.sysname, OS_SIZE - 1);
        if (strcmp(osname, "UNIX_SV") == 0) {
            strcpy(osname, "UnixWare"); /* Change a stupid OS name to something 
                                           marginally less stupid. */
        }
        logcalc(_("OS"), osname);
        if (cfg_sendosversion) {
           /* strncpy(osversion, uts.release, OSVERSION_SIZE - 1); */
            strncpy(osversion, uts.version, OSVERSION_SIZE - 1);
            logcalc(_("OS version"), osversion);
        }
    }

    if (cfg_sendcpu) {
        strncpy(cpu, uts.machine, CPU_SIZE - 1);
        logcalc(_("CPU"), cpu);
    }
}
#endif /* PLATFORM_UNIXWARE */
