/*
 Uptime Client v5.0 beta

 $Id: stats-ult.c,v 1.19 2002/12/22 17:53:42 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats-ult.c
 *
 * @desc        Retrieve stats for the Ultrix & Irix platforms
 */

#if defined PLATFORM_ULTRIX

/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: stats-ult.c,v 1.19 2002/12/22 17:53:42 carstenklapp Exp $";

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"
#include "uplog.h"      /* wrapper for <syslog.h> */

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <nlist.h>
#include <string.h>
#include <sysexits.h>
#include <sys/utsname.h>
#include <sys/cpudata.h>
#include <sys/fixpoint.h>

#if !defined SECONDS_PER_MINUTE
#   define SECONDS_PER_MINUTE 60;
#endif /* !defined SECONDS_PER_MINUTE */

/**
 * @desc    Verbose level 3 logging of calulations
 */
void
logcalc(char *whatwascalculateddesc, char *value)
{
#if defined DEBUG
    uplog(LOG_DEBUG, _("%s calculated: %s"), whatwascalculateddesc, value);
#endif /* DEBUG */
}

/**
 * @desc    Get statistics
 */
void
getstats(unsigned long *uptimeminutes, double *UsagePercent,
         double *IdlePercent, char *osname, char *osversion, char *cpu,
         double *loadavg)
{
    struct utsname uts;
    time_t now, boottime;
    int    fd, up, id, avenrun[3];
    long   cpudata_offset;
    struct nlist names[2];
    struct cpudata cpudata;

   /* Open file descriptor to /dev/kmem first */
    if ((fd = open("/dev/kmem", O_RDONLY)) < 0)
        exit(EX_IOERR);
   /* Make sure second nlist name pointer is a NULL so nlist(3) knows when to
      stop. */
    names[1].n_name = NULL;

   /* Get uptime */
    time(&now);
    names[0].n_name = "boottime";
    if (nlist("/vmunix", names) != 0)
        exit(EX_OSFILE);
    if (lseek(fd, names[0].n_value, SEEK_SET) == -1)
        exit(EX_OSFILE);
    if (read(fd, &boottime, sizeof(boottime)) < 0)
        exit(EX_OSFILE);
    *uptimeminutes = (now - boottime) / SECONDS_PER_MINUTE;

    if (cfg_sendloadavg) {
        names[0].n_name = "avenrun";
        if (nlist("/vmunix", names) != 0)
            exit(EX_OSFILE);
        if (lseek(fd, names[0].n_value, SEEK_SET) == -1)
            exit(EX_OSFILE);
        if (read(fd, avenrun, sizeof(avenrun)) < 0)
            exit(EX_OSFILE);
       /* Use the 3rd element (15 minute Load-average) */
        *loadavg = FIX_TO_DBL(avenrun[2]);
    }

    if (cfg_SendIdle) {
        names[0].n_name = "cpudata";
        if (nlist("/vmunix", names) != 0)
            exit(EX_OSFILE);
        if ((fd = open("/dev/kmem", O_RDONLY)) < 0)
            exit(EX_IOERR);
        if (lseek(fd, names[0].n_value, SEEK_SET) == -1)
            exit(EX_OSFILE);
        if (read(fd, &cpudata_offset, sizeof(cpudata_offset)) < 0)
            exit(EX_OSFILE);
        if (lseek(fd, cpudata_offset, SEEK_SET) == -1)
            exit(EX_OSFILE);
        if (read(fd, &cpudata, sizeof(cpudata)) < 0)
            exit(EX_OSFILE);
        id = cpudata.cpu_cptime[CP_IDLE];
        *IdlePercent =
            (int)(100.0 * cpudata.cpu_cptime[CP_IDLE] /
                  (cpudata.cpu_cptime[0] + cpudata.cpu_cptime[1] +
                   cpudata.cpu_cptime[2] + cpudata.cpu_cptime[3]));
       /* Check for wrap-around */
        if (*IdlePercent < 0 || *IdlePercent > 100)
            *IdlePercent = -1;
    }

    if (cfg_SendUsage) {
        names[0].n_name = "cpudata";
        if (nlist("/vmunix", names) != 0)
            exit(EX_OSFILE);
        if ((fd = open("/dev/kmem", O_RDONLY)) < 0)
            exit(EX_IOERR);
        if (lseek(fd, names[0].n_value, SEEK_SET) == -1)
            exit(EX_OSFILE);
        if (read(fd, &cpudata_offset, sizeof(cpudata_offset)) < 0)
            exit(EX_OSFILE);
        if (lseek(fd, cpudata_offset, SEEK_SET) == -1)
            exit(EX_OSFILE);
        if (read(fd, &cpudata, sizeof(cpudata)) < 0)
            exit(EX_OSFILE);
        id = cpudata.cpu_cptime[CP_IDLE];
       /* Fixme: use (cpudata.cpu_cptime[0] + ...) instead of (1 -
          cpudata.cpu_cptime[CP_IDLE]) */
        *UsagePercent =
            (int)(100.0 *
                  (1 -
                   cpudata.cpu_cptime[CP_IDLE] / (cpudata.cpu_cptime[0] +
                                                  cpudata.cpu_cptime[1] +
                                                  cpudata.cpu_cptime[2] +
                                                  cpudata.cpu_cptime[3])));
       /* Check for wrap-around */
        if (*UsagePercent < 0 || *UsagePercent > 100)
            *UsagePercent = -1;
    }

    if (cfg_sendosname || cfg_sendcpu) {
        uname(&uts);
    }

    if (cfg_sendosname) {
        strncpy(osname, uts.sysname, OS_SIZE - 1);
       /* Make "ULTRIX" look prettier */
        if (strcmp(osname, "ULTRIX") == 0) {
            strncpy(osname, "Ultrix", OS_SIZE - 1);
        }
        logcalc(_("OS"), osname);
        if (cfg_sendosversion) {
            strncpy(osversion, uts.release, OSVERSION_SIZE - 1);
            logcalc(_("OS version"), osversion);
        }
    }

    if (cfg_sendcpu) {
        strncpy(cpu, uts.machine, CPU_SIZE - 1);
       /* Make "RISC" look prettier under Ultrix */
        if (strcmp(osname, "Ultrix") == 0 && strcmp(cpu, "RISC") == 0) {
            strncpy(cpu, "MIPS", CPU_SIZE - 1);
        }
        logcalc(_("CPU"), cpu);
    }

   /* Close the kernel file descriptor */
    close(fd);
}
#endif /* PLATFORM_ULTRIX */
