/*
 Uptime Client v5.0 beta

 $Id: stats-mach.c,v 1.15 2003/05/26 19:54:04 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats-mach.c
 *
 * @desc        Retrieve idle stats from mach kernel
 */

#if defined __MACH__

/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: stats-mach.c,v 1.15 2003/05/26 19:54:04 carstenklapp Exp $";

                                                    /* #include <mach/mach.h> *//* replaced by following
                                                       two lines */
#include <mach/host_info.h>
#include <mach/error.h>
#include "uplog.h"
#include "stats.h"

void
getLoadIdle(double *UsagePercent, double *IdlePercent)
{
    static host_cpu_load_info_data_t previouscpuloadinfo;
    static host_cpu_load_info_data_t currentcpuloadinfo;
    static int initialized = 0;

    register kern_return_t kr;
    register int state;
    int    count;
    register float cputime = 0.0;
    register float nonidlecpu = 0.0;
    register float idlecpu = 0.0;
    host_load_info_data_t loadinfo;

    if (!initialized) {
        initialized = 1;
        sleep(1);       /* avoid wierd negative idle values first time around */
    }

    count = HOST_LOAD_INFO_COUNT;
    kr = host_statistics(mach_host_self(), HOST_LOAD_INFO,
                         (host_info_t) & loadinfo, &count);
    if (kr != KERN_SUCCESS)
        uplog(LOG_ERR, "Unable to get host_load_info");

    count = HOST_CPU_LOAD_INFO_COUNT;
    kr = host_statistics(mach_host_self(), HOST_CPU_LOAD_INFO,
                         (host_info_t) & currentcpuloadinfo, &count);
    if (kr != KERN_SUCCESS)
        uplog(LOG_ERR, "Unable to get host_cpu_load_info");

    for (state = 0; state < CPU_STATE_MAX; state++) {
        cputime +=
            (float)(currentcpuloadinfo.cpu_ticks[state] -
                    previouscpuloadinfo.cpu_ticks[state]);
        if (!(state == CPU_STATE_IDLE)) {
            nonidlecpu +=
                (float)(currentcpuloadinfo.cpu_ticks[state] -
                        previouscpuloadinfo.cpu_ticks[state]);
        }
    }
    idlecpu = 100 * (((float)
                      (currentcpuloadinfo.cpu_ticks[CPU_STATE_IDLE] -
                       previouscpuloadinfo.cpu_ticks[CPU_STATE_IDLE])) /
                     cputime);
    nonidlecpu = 100. * (float)(nonidlecpu / cputime);

   /* store values for next calculation interval */
    for (state = 0; state < CPU_STATE_MAX; state++) {
        previouscpuloadinfo.cpu_ticks[state] =
            currentcpuloadinfo.cpu_ticks[state];
    }

    *UsagePercent = (double)nonidlecpu;
    *IdlePercent = (double)idlecpu;

#if defined DEBUG
    uplog(LOG_DEBUG, "getLoadIdle() load=%.1f idle=%.1f", (float)nonidlecpu,
          (float)idlecpu);
#endif /* DEBUG */
}

#endif /* __MACH__ */
