/*
 Uptime Client v5.0 beta
 
 $Id: stats-aix.c,v 1.18 2002/11/30 02:27:15 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    stats-aix.c
 *
 * @desc        Retrieve stats for the AIX platform
 */

#if defined PLATFORM_AIX

/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: stats-aix.c,v 1.18 2002/11/30 02:27:15 carstenklapp Exp $";

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"
#include "uplog.h"      /* wrapper for <syslog.h> */

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <utmp.h>
#include <fcntl.h>
#include <sysexits.h>
#include <sys/nlist.h>
#include <sys/select.h>
#include <sys/sysinfo.h>
#include <sys/systemcfg.h>

/**
 * @desc    DEBUG logging of calulations
 */
void
logcalc(char *whatwascalculateddesc, char *value)
{
#if defined DEBUG
    uplog(LOG_DEBUG, _("%s calculated: %s"), whatwascalculateddesc, value);
#endif /* DEBUG */
}

/**
 * @desc    Get statistics
 */
void
getstats(unsigned long *uptimeminutes, double *UsagePercent,
         double *IdlePercent, char *osname, char *osversion, char *cpu,
         double *loadavg)
{
    struct utmp ut;
    struct sysinfo sys;
    struct utsname uts;
    struct nlist kernelnames[2];
    int    fd, bytes, avenrun[3];
    time_t prtime;

   /* get uptime from utmp: */
    if ((fd = open(UTMP_FILE, O_RDONLY)) < 0) {
        perror("open");
        exit(EX_OSFILE);
    }
    while ((bytes = read(fd, &ut, sizeof(ut)))) {
        if (bytes == -1) {
            perror("read");
            exit(EX_OSFILE);
        }
        if (ut.ut_type == BOOT_TIME) {
            time(&prtime);
            *uptimeminutes = (prtime - ut.ut_time) / 60;
            break;
        }
    }
   /* open /dev/kmem for reading Load-average and idle: */
    if ((fd = open("/dev/kmem", O_RDONLY)) < 0) {
        perror("open");
        exit(EX_IOERR);
    }

    if (cfg_sendloadavg) {
        kernelnames[1].n_name = NULL;
        kernelnames[0].n_name = "avenrun";

        if (knlist(kernelnames, 1, sizeof(struct nlist)) == -1) {
            perror("knlist");
            exit(EX_IOERR);
        }
        if (lseek(fd, kernelnames->n_value, SEEK_SET) == -1) {
            perror("lseek");
            exit(EX_IOERR);
        }
        if (read(fd, avenrun, sizeof(avenrun)) < 0) {
            perror("read");
            exit(EX_IOERR);
        }
        *loadavg = avenrun[2] / 65536.0;
    }

    if (cfg_SendUsage) {
        kernelnames[1].n_name = NULL;
        kernelnames[0].n_name = "sysinfo";

        if (knlist(kernelnames, 1, sizeof(struct nlist)) == -1) {
            perror("knlist");
            exit(EX_IOERR);
        }
        if (lseek(fd, kernelnames->n_value, SEEK_SET) == -1) {
            perror("lseek");
            exit(EX_IOERR);
        }
        if (read(fd, &sys, sizeof(sys)) < 0) {
            perror("read");
            exit(EX_IOERR);
        }
        *UsagePercent =
            (double)(100.0 * ((double)sys.runocc / (prtime - ut.ut_time)));
    }

    if (cfg_SendIdle) {
        kernelnames[1].n_name = NULL;
        kernelnames[0].n_name = "sysinfo";

        if (knlist(kernelnames, 1, sizeof(struct nlist)) == -1) {
            perror("knlist");
            exit(EX_IOERR);
        }
        if (lseek(fd, kernelnames->n_value, SEEK_SET) == -1) {
            perror("lseek");
            exit(EX_IOERR);
        }
        if (read(fd, &sys, sizeof(sys)) < 0) {
            perror("read");
            exit(EX_IOERR);
        }
        *IdlePercent =
            (double)(100.0 *
                     (1.0 - ((double)sys.runocc / (prtime - ut.ut_time))));
    }

    if (cfg_sendosname) {
        uname(&uts);
        strncpy(osname, uts.sysname, OS_SIZE - 1);
        logcalc(_("OS"), osname);
        if (cfg_sendosversion) {
            strncpy(osversion, uts.version, OSVERSION_SIZE - 1);
            logcalc(_("OS version"), osversion);
        }
    }

    if (cfg_sendcpu) {
       /* rs1, rs2 and rsc architectures: */
        if (__power_rs1())
            strncpy(cpu, "power_rs1", CPU_SIZE - 1);
        else if (__power_rsc())
            strncpy(cpu, "power_rsc", CPU_SIZE - 1);
        else if (__power_rs2())
            strncpy(cpu, "power_rs2", CPU_SIZE - 1);
       /* powerpc: */
        else if (__power_601())
            strncpy(cpu, "power_601", CPU_SIZE - 1);
        else if (__power_603())
            strncpy(cpu, "power_603", CPU_SIZE - 1);
        else if (__power_604())
            strncpy(cpu, "power_604", CPU_SIZE - 1);
        else if (__power_620())
            strncpy(cpu, "power_620", CPU_SIZE - 1);
       /* any rs or ppc not listed above: */
        else if (__power_rs())
            strncpy(cpu, "power_rs", CPU_SIZE - 1);
        else
            strncpy(cpu, "power_pc", CPU_SIZE - 1);
        logcalc(_("CPU"), cpu);
    }

   /* close /dev/kmem: */
    close(fd);
}
#endif /* PLATFORM_AIX */
