/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: options.c,v 1.34 2003/05/26 19:54:04 carstenklapp Exp $";

/*
 Uptime Client v5.0 beta
 
 $Id: options.c,v 1.34 2003/05/26 19:54:04 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    options.c
 *
 * @desc        Options file parsing
 */

/* System includes */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* My includes */
#include "locale.h"     /* gettext */
#include "options.h"
#include "uplog.h"      /* wrapper for <syslog.h> */

/* Include if not compiling on WinNT or BeOS */
#if !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
#   include <sysexits.h>
#elif
#   include "compat/sysexits.h"
#endif

/**
 * Magic Numbers
 * Timer interval limits in seconds.
 * Minimum value is enforced. A warning is logged if greater than upper limit.
 */
#define MINIMUM_INTERVAL  30    /* enforced */
#define DEFAULT_INTERVAL 300
#define UPPER_INTERVAL   600    /* warning if exceeded */

/* Macros */
#define MAX_LINE_LEN  1024
#define MAX_KEY_LEN     64
#define MAX_VAL_LEN    256

#define LINE_ERR        0
#define LINE_EMPTY      1
#define LINE_COMMENT    2
#define LINE_OPTION     3

/**
 * Global variables, very ugly, watch through sunglasses!
 *
 * These are the configuration options available.
 */
char   cfg_authkey[AUTHKEY_REQUIRED_LEN + 1] = "";
char   cfg_upserver[UPSERVER_MAXLEN + 1] = "uptimes.wonko.com";
long int cfg_interval = DEFAULT_INTERVAL;
char   cfg_pidfile[PIDFILE_MAXLEN + 1] = PIDFILE;
char   cfg_proxyserver[PROXYSERVER_MAXLEN + 1] = "";
in_port_t cfg_udpport = 49153;
in_port_t cfg_proxyport = 8080;
char   cfg_proxyuser[PROXYUSER_MAXLEN + 1] = "";
char   cfg_proxypass[PROXYPASS_MAXLEN + 1] = "";

#if defined PLATFORM_SOLARIS
unsigned short int cfg_SendIdle = 0;
#else
unsigned short int cfg_SendIdle = 1;
#endif /* PLATFORM_SOLARIS */
#if defined PLATFORM_UNIXWARE
unsigned short int cfg_SendUsage = 0;
#else
unsigned short int cfg_SendUsage = 1;
#endif /* PLATFORM_UNIXWARE */
unsigned short int cfg_sendosname = 1;
unsigned short int cfg_sendosversion = 1;
unsigned short int cfg_sendcpu = 1;
unsigned short int cfg_sendcpudetail = 1;
unsigned short int cfg_sendloadavg = 0; /* unimplemented */

/**
 * Global variables, very ugly, watch through sunglasses!
 *
 * These are some booleans set to reflect the configuration
 * options.
 */
unsigned short int have_proxyserver = 0;
unsigned short int have_proxyport = 0;
unsigned short int have_proxyuser = 0;
unsigned short int have_proxypass = 0;

unsigned short int verbose = 0;

#if defined DEBUG
/**
 * @desc    Print options
 */
static void
print_options(void)
{
    uplog(LOG_DEBUG, "cfg_authkey:         [%s]", cfg_authkey);
    uplog(LOG_DEBUG, "cfg_interval:        [%d]", cfg_interval);
    uplog(LOG_DEBUG, "cfg_upserver:        [%s]", cfg_upserver);
    uplog(LOG_DEBUG, "cfg_proxyserver:     [%s]", cfg_proxyserver);
    uplog(LOG_DEBUG, "cfg_proxyport:       [%d]", cfg_proxyport);
    uplog(LOG_DEBUG, "cfg_udpport:         [%d]", cfg_udpport);
    uplog(LOG_DEBUG, "cfg_proxyuser:       [%s]", cfg_proxyuser);
    uplog(LOG_DEBUG, "cfg_proxypass:       [%s]", cfg_proxypass);
    uplog(LOG_DEBUG, "cfg_pidfile:         [%s]", cfg_pidfile);
    uplog(LOG_DEBUG, "cfg_SendIdle: [%d]", cfg_SendIdle);
    uplog(LOG_DEBUG, "cfg_SendUsage: [%d]", cfg_SendUsage);
    uplog(LOG_DEBUG, "cfg_sendosname:      [%d]", cfg_sendosname);
    uplog(LOG_DEBUG, "cfg_sendosversion:   [%d]", cfg_sendosversion);
    uplog(LOG_DEBUG, "cfg_sendcpu:         [%d]", cfg_sendcpu);
    uplog(LOG_DEBUG, "cfg_sendcpudetail:   [%d]", cfg_sendcpudetail);
    uplog(LOG_DEBUG, "cfg_sendloadavg:     [%d]", cfg_sendloadavg);
}
#endif /* DEBUG */

/**
 * @desc    Process key/value pair
 */
static int
process_option(const char *key, const char *value)
{
    if (strcmp(key, "AuthKey") == 0) {
        if (strlen(value) == AUTHKEY_REQUIRED_LEN) {
            strncpy(cfg_authkey, value, AUTHKEY_REQUIRED_LEN);
            cfg_authkey[AUTHKEY_REQUIRED_LEN] = 0;
        }
        else {
            uplog(LOG_ERR, _("%s AuthKey is not %d bytes long! (%s)\n"),
                  _("FATAL ERROR:"), AUTHKEY_REQUIRED_LEN, CONFIGFILE);
            printf(_("%s AuthKey is not %d bytes long! (%s)\n"),
                   _("FATAL ERROR:"), AUTHKEY_REQUIRED_LEN, CONFIGFILE);
#if !defined PARANOID
            exit(EX_DATAERR);
#else /* PARANOID */
            uplog(LOG_ERR, "%s %s\n", _("FATAL ERROR:"),
                  _("Ignoring due to Paranoid Mode Enabled."));
            printf("%s %s\n", _("FATAL ERROR:"),
                   _("Ignoring due to Paranoid Mode Enabled."));
#endif /* PARANOID */
        }
    }
    else if (strcmp(key, "Interval") == 0) {

        /**
         * Send the uptime at most once every 30 seconds
         * Send the uptime at least once every 10 minutes
         */
        if (atol(value) < MINIMUM_INTERVAL) {
#if !defined PARANOID
           /* is there an existing value? (i.e. we are here because of an HUP) */
            if (cfg_interval > (MINIMUM_INTERVAL - 1)) {
                uplog(LOG_NOTICE, _("%s %s Using previous value %d (%s).\n"),
                      _("NOTE:"),
                      _("Uptime reporting interval is less than 30 seconds."),
                      cfg_interval, CONFIGFILE);
            }
            else {
                cfg_interval = DEFAULT_INTERVAL;
                uplog(LOG_NOTICE, _("%s %s Using default value of %d (%s).\n"),
                      _("NOTE:"),
                      _("Uptime reporting interval is less than 30 seconds."),
                      cfg_interval, CONFIGFILE);
                printf(_("%s %s Using default value of %ld (%s).\n"),
                       _("NOTE:"),
                       _("Uptime reporting interval is less than 30 seconds."),
                       cfg_interval, CONFIGFILE);
            }
           /* exit(EX_USAGE); */
#else /* PARANOID */
           /* use it anyway because we are paranoid */
            cfg_interval = atol(value);
            uplog(LOG_NOTICE, "%s %s %s\n", _("NOTE:"),
                  _("Uptime reporting interval is less than 30 seconds."),
                  _("Ignoring due to Paranoid Mode Enabled."));
            printf("%s %s %s\n", _("NOTE:"),
                   _("Uptime reporting interval is less than 30 seconds."),
                   _("Ignoring due to Paranoid Mode Enabled."));
#endif /* PARANOID */
        }
        if (atol(value) > UPPER_INTERVAL) {
            uplog(LOG_WARNING, "%s %s %s (%s)\n", _("WARNING:"),
                  _("Uptime reporting interval is larger than 10 minutes."),
                  _
                  ("An interval between 30 seconds and 10 minutes is recommended."),
                  CONFIGFILE);
            printf("%s %s %s (%s)\n", _("WARNING:"),
                   _("Uptime reporting interval is larger than 10 minutes."),
                   _
                   ("An interval between 30 seconds and 10 minutes is recommended."),
                   CONFIGFILE);
            cfg_interval = atol(value);
        }
        else {
           /* OK to go. */
            if (atol(value) > (MINIMUM_INTERVAL - 1)) {
                cfg_interval = atol(value);
            }   /* else just keep the old value. */
        }
    }
    else if (strcmp(key, "UptimeServer") == 0) {
        strncpy(cfg_upserver, value, UPSERVER_MAXLEN);
        cfg_upserver[UPSERVER_MAXLEN] = 0;
    }
    else if (strcmp(key, "ProxyServer") == 0) {
        strncpy(cfg_proxyserver, value, PROXYSERVER_MAXLEN);
        cfg_proxyserver[PROXYSERVER_MAXLEN] = 0;
        have_proxyserver = 1;
    }
    else if (strcmp(key, "ProxyPort") == 0) {
        cfg_proxyport = (in_port_t) atol(value);
        if (!(cfg_proxyport >= 1 && cfg_proxyport <= 65535)) {
            uplog(LOG_ERR, "%s ProxyPort %s (%s)\n", _("FATAL ERROR:"),
                  _("must be in the <1 - 65535> range."), CONFIGFILE);
            printf("%s ProxyPort %s (%s)\n", _("FATAL ERROR:"),
                   _("must be in the <1 - 65535> range."), CONFIGFILE);
            exit(EX_USAGE);
        }
        have_proxyserver = 1;
    }
    else if (strcmp(key, "ProxyUsername") == 0) {
        strncpy(cfg_proxyuser, value, PROXYUSER_MAXLEN);
        cfg_proxyuser[PROXYUSER_MAXLEN] = 0;
        have_proxyserver = 1;
    }
    else if (strcmp(key, "ProxyPassword") == 0) {
        strncpy(cfg_proxypass, value, PROXYPASS_MAXLEN);
        cfg_proxypass[PROXYPASS_MAXLEN] = 0;
        have_proxyserver = 1;
    }
    else if (strcmp(key, "PidFile") == 0) {
        strncpy(cfg_pidfile, value, PIDFILE_MAXLEN);
        cfg_pidfile[PIDFILE_MAXLEN] = 0;

    }
    else if (strcmp(key, "SendIdle") == 0) {
        cfg_SendIdle = (unsigned short int)atol(value);
    }
    else if (strcmp(key, "SendUsage") == 0) {
        cfg_SendUsage = (unsigned short int)atol(value);
    }
    else if (strcmp(key, "SendLoadAvg") == 0) {
        cfg_sendloadavg = (unsigned short int)atol(value);
    }
    else if (strcmp(key, "SendOSName") == 0) {
        cfg_sendosname = (unsigned short int)atol(value);
    }
    else if (strcmp(key, "SendOSVersion") == 0) {
        cfg_sendosversion = (unsigned short int)atol(value);
    }
    else if (strcmp(key, "SendCPU") == 0) {
        cfg_sendcpu = (unsigned short int)atol(value);
    }
    else if (strcmp(key, "SendCPUDetail") == 0) {
        cfg_sendcpudetail = (unsigned short int)atol(value);
        if (!(cfg_sendcpudetail == 0 || cfg_sendcpudetail == 1)) {
            uplog(LOG_ERR, "%s SendCPUDetail %s (%s)\n", _("FATAL ERROR:"),
                  _("must be in the <0 - 1> range."), CONFIGFILE);
            printf("%s SendCPUDetail %s (%s)\n", _("FATAL ERROR:"),
                   _("must be in the <0 - 1> range."), CONFIGFILE);
            exit(EX_USAGE);
        }
    }
    else if (key[0] != '#') {
        if (verbose > 2) {
            fprintf(stderr, "upclient: %s config '%s' = '%s'\n",
                    _("verbose 3:"), key, value);
            uplog(LOG_INFO, "%s config '%s' = '%s'\n", _("verbose 3:"), key,
                  value);
        }
        return 0;
    }
    if (verbose > 2) {
        fprintf(stderr, "upclient: %s config '%s' = '%s'\n", _("verbose 3:"),
                key, value);
        uplog(LOG_INFO, "%s config '%s' = '%s'\n", _("verbose 3:"), key, value);
    }
    return 1;
}

/**
 * @desc    isblank() for Solaris
 */
#if defined PLATFORM_SOLARIS
static int
isblank(const char chr)
{
    return (chr == ' ' || chr == '\t');
}
#endif /* PLATFORM_SOLARIS */

/**
 * @desc    Skip white space
 */
static int
skipwhite(const char *line, int pos)
{
    while (isblank((unsigned char)line[pos]))
        pos++;
    return pos;
}

/**
 * @desc    Is it an empty line?
 */
static int
isemptyline(const char *line)
{
    return (line[skipwhite(line, 0)] == '\n');
}

/**
 * @desc    Is it a comment line?
 */
static int
iscommentline(const char *line)
{
    return (line[skipwhite(line, 0)] == '#');
}

/**
 * @desc    Is it a valid end of line?
 */
static int
isvalideol(const char *line, int pos)
{
    pos = skipwhite(line, pos);

    if (line[pos] == '\n')
        return 1;

    if (line[pos] == '#' && line[strlen(line) - 1] == '\n')
        return 1;

    return 0;
}

/**
 * @desc    Get key
 */
static int
getkey(const char *line, int pos, char *key)
{
    int    i = 0;

    pos = skipwhite(line, pos);

   /* cast to unsigned for Solaris */
    while (isalnum((unsigned char)line[pos]) && i < MAX_KEY_LEN) {
        key[i] = line[pos];
        i++;
        pos++;
    }
    key[i] = '\0';

    if (isblank((unsigned char)line[pos]) || (unsigned char)line[pos] == '=')
        return pos;
    else
        return 0;
}

/**
 * @desc    Get sign
 */
static int
getsign(const char *line, int pos, int sign)
{       /* const char or int for arg 3? */
    pos = skipwhite(line, pos);
    if (line[pos] == sign)
        return pos + 1;
    return 0;
}

/**
 * @desc    Get value of the key
 */
static int
getval(const char *line, int pos, char *value)
{
    int    i = 0;

    pos = skipwhite(line, pos);

   /* cast to unsigned for Solaris */
    while (isgraph((unsigned char)line[pos]) && line[pos] != '#' &&
           i < MAX_VAL_LEN) {
        value[i] = line[pos];
        i++;
        pos++;
    }
    value[i] = '\0';

    if (isblank((unsigned char)line[pos]) || (unsigned char)line[pos] == '#' ||
        (unsigned char)line[pos] == '\n')
        return pos;
    else
        return 0;
}

/**
 * @desc    Parse config file line
 */
static int
parseline(const char *line, char *key, char *value)
{
    int    linepos = 0;

    if (isemptyline(line))
        return LINE_EMPTY;

    if (iscommentline(line))
        return LINE_COMMENT;

    linepos = getkey(line, 0, key);
    linepos = getsign(line, linepos, '=');
   /* options.c:410: warning: passing arg 3 of `getsign' with different width
      due to prototype */
    linepos = getval(line, linepos, value);

    if (!isvalideol(line, linepos))
        return LINE_ERR;

    return LINE_OPTION;
}

/**
 * @desc    Read and parse config file, activate options
 *
 * @caller  main()
 *
 * @param   none
 *
 * @return  true
 */
extern void
read_config(void)
{
    FILE  *fp;
    char   line[MAX_LINE_LEN];
    char   key[MAX_KEY_LEN];
    char   value[MAX_VAL_LEN];
    int    linenr = 1;
    int    linetype;

    if (verbose > 2) {
        uplog(LOG_INFO, "%s %s %s", _("verbose 3:"), _("Reading configfile:"),
              CONFIGFILE);
        fprintf(stderr, "upclient: %s %s %s\n", _("verbose 3:"),
                _("Reading configfile:"), CONFIGFILE);
    }

   /* Try to open config file as specified during compile */
    if (!(fp = fopen(CONFIGFILE, "r"))) {
        fprintf(stderr, "upclient: %s %s\n",
                _("Could not open config file for reading:"), CONFIGFILE);
        uplog(LOG_ERR, "%s %s", _("Could not open config file for reading:"),
              CONFIGFILE);

       /* Try to open a config file in current directory */
        if (fp = fopen("upclient.conf", "r")) {
            printf("upclient: %s %s\n", _("Using config file found in:"),
                   _("current directory"));
            uplog(LOG_INFO, "%s %s", _("Using config file found in:"),
                  _("current directory"));
        }
        else if (fp = fopen("/etc/upclient.conf", "r")) {
           /* Failed, now try to open a config file in /etc */
            printf("upclient: %s %s\n", _("Using config file found in:"),
                   "/etc");
            uplog(LOG_INFO, "%s %s", _("Using config file found in:"), "/etc");
        }
        else if (fp = fopen("/usr/local/etc/upclient.conf", "r")) {
           /* Failed, now try to open a config file in /usr/local/etc */
            printf("upclient: %s %s\n", _("Using config file found in:"),
                   "/usr/local/etc");
            uplog(LOG_INFO, "%s %s\n", _("Using config file found in:"),
                  "/usr/local/etc");
        }
        else if (fp = fopen("/usr/pkg/etc/upclient.conf", "r")) {
           /* Failed, now try to open a config file for NetBSD */
            printf("upclient: %s %s\n", _("Using config file found in:"),
                   "/usr/pkg/etc");
            uplog(LOG_INFO, "%s %s\n", _("Using config file found in:"),
                  "/usr/pkg/etc");
        }
        else {

            printf("%s %s \n- %s %s", _("FATAL ERROR:"),
                   _("Could not find config file in:"), _("current directory"),
                   "\n- /etc\n- /usr/local/etc\n- /usr/pkg/etc\n");
            uplog(LOG_ERR, "%s %s \n- %s %s", _("FATAL ERROR:"),
                  _("Could not find config file in:"), _("current directory"),
                  "\n- /etc\n- /usr/local/etc\n- /usr/pkg/etc\n");
            exit(EX_OSFILE);
        }
    }

   /* Read & parse config file */
    while (!feof(fp)) {
       /* Read one line */
        fgets(line, MAX_LINE_LEN, fp);

       /* We got a problem Houston */
        if (line[strlen(line) - 1] != '\n') {
            printf(_("upclient: %s Config file line %d too long.\n"),
                   _("FATAL ERROR:"), linenr);
            uplog(LOG_ERR, _("%s Config file line %d too long."),
                  _("FATAL ERROR:"), linenr);
            exit(EX_DATAERR);
        }

       /* Parse rule */
        linetype = parseline(line, key, value);

        if (linetype == LINE_ERR) {
            uplog(LOG_WARNING, _("%s Error in %s line %d:\n  content: %s"),
                  _("WARNING:"), CONFIGFILE, linenr, line);
            printf(_("upclient: %s Error in %s line %d:\n  content: %s\n"),
                   _("WARNING:"), CONFIGFILE, linenr, line);
        }

       /* If the line is an option, process it */
        if (linetype == LINE_OPTION) {
            if (!process_option(key, value)) {
                uplog(LOG_WARNING,
                      _("%s Error in %s line %d:\n  key: %s, value: %s"),
                      _("WARNING:"), CONFIGFILE, linenr, key, value);
                printf(_
                       ("upclient: %s Error in %s line %d:\n  key: %s, value: %s\n"),
                       _("WARNING:"), CONFIGFILE, linenr, key, value);
            }
        }

       /* The core functionality of this algorithm */
        linenr++;
    }

#if defined DEBUG
    print_options();
#endif /* DEBUG */

   /* Clean up the mess we made */
    if (fclose(fp))
        uplog(LOG_ERR, "%s", strerror(errno));

   /* Life is giving and taking */
   /* return 1; */
}
