/*
 Uptime Client v5.0 beta 

 $Id: network.h,v 1.10 2002/11/06 01:33:39 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    network.h
 */

#if !defined NETWORK_H
#define NETWORK_H 1

#include <stdlib.h>
#include <sys/types.h>  /* size_t */

#if defined PLATFORM_WINNT
    /* translate some socket functions */
#   define close(X)     closesocket(X)
#   define read(X,Y,Z)  recv(X,Y,Z,MSG_PEEK)
#   define write(X,Y,Z) send(X,Y,Z,0)
#   define ssize_t      int
#endif /* PLATFORM_WINNT */

#if defined PLATFORM_BEOS
    /* translate some socket functions */
#   define close(X)     closesocket(X)
#   define read(X,Y,Z)  recv(X,Y,Z,0)
#   define write(X,Y,Z) send(X,Y,Z,0)
#endif

extern int socket_write(int, const char *, size_t);
extern int socket_read(int, char *, size_t);

#if defined PLATFORM_WINNT
extern void startWinsock(void);
#endif /* PLATFORM_WINNT */

#endif /* !NETWORK_H */
