/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: network.c,v 1.13 2002/11/06 01:33:38 carstenklapp Exp $";

/*
 Uptime Client v5.0 beta

 $Id: network.c,v 1.13 2002/11/06 01:33:38 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    network.c
 *
 * @desc        Networking functions
 */

/* My includes */
#include "network.h"

/* System includes */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>  /* size_t */
#if !defined PLATFORM_WINNT
#   include <unistd.h>
#else /* PLATFORM_WINNT */
#   include <windows.h>
#endif /* PLATFORM_WINNT */

/**
 * @desc    Wrapper function for writing to our file descriptor
 */
int
socket_write(int fd, const char *buf, size_t nbytes)
{
    ssize_t write_ret;
    size_t nwritten;

    nwritten = 0;
    while (nwritten < nbytes) {
        write_ret = write(fd, buf + nwritten, nbytes - nwritten);
        if (write_ret <= 0) {
            return -1;
        }
        nwritten += write_ret;
    }
    return (int)nwritten;
}

/**
 * @desc    Wrapper function for reading from our file descriptor
 */
int
socket_read(int fd, char *buf, size_t nbytes)
{
    ssize_t read_ret;
    size_t nread;

    nread = 0;
    while (nread < nbytes) {
        read_ret = read(fd, buf + nread, nbytes - nread);
        if (read_ret < 0) {
            return -1;
        }
        if (read_ret == 0) {
            return (int)nread;
        }
        nread += read_ret;
    }
    return (int)nread;
}

#if defined PLATFORM_WINNT
void
startWinsock(void)
{
   /* ensures winsock dll gets loaded if it wasn't already */
    WSADATA wsaData;
    int    err;
    WORD   wVersionRequested = 0x0101;

    if (WSAStartup(wVersionRequested, &wsaData) != 0) {
        printf("Cannot load WINSOCK.DLL nor WSOCK32.DLL\n");
    }
}
#endif /* PLATFORM_WINNT */
