/*@unused@*/ static const char rcsid[] =
    "@(#)$Id: base64.c,v 1.17 2002/11/19 01:02:30 carstenklapp Exp $";

/*
 Uptime Client v5.0 beta

 $Id: base64.c,v 1.17 2002/11/19 01:02:30 carstenklapp Exp $

 Logs system uptime and statistics with Uptimes Project servers

 Copyright (C) 1999-2002 Martijn Broenland, Alex C. de Haas, Carsten Klapp

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 Carsten Klapp <carstenklapp@users.sourceforge.net>
 Alex C. de Haas <alex@uptimes.net>
 Martijn Broenland <tgm@uptimes.net>
 */

/**
 * @filename    base64.c
 *
 * @desc        Base64 encoding
 */

/* System includes */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* Include if not compiling on WinNT or BeOS */
#if !defined PLATFORM_WINNT && !defined PLATFORM_BEOS
#   include <sysexits.h>
#elif
#   include "compat/sysexits.h"
#endif /* !PLATFORM_WINNT && !PLATFORM_BEOS */

/* My includes */
#include "base64.h"
#include "uplog.h"
#include "locale.h"     /* gettext */

/* Base64 table (-: */
static char base64_table[] = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
    'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
    'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '\0'
};

/* Padding character */
static char base64_pad = '=';

/**
 * @desc    Base64 encode a neat little string
 */
unsigned char *
base64_encode(const unsigned char *string)
{
    int    length;
    int    i;
    const unsigned char *current;
    unsigned char *result;

    length = (int)strlen((const char *)string);
    i = 0;
    current = string;

    result = (unsigned char *)malloc(((length + 3 - length % 3)
                                      * 4 / 3 + 1) * sizeof(char));

    if (result == NULL) {
        uplog(LOG_ERR, "%s base64_encode(): %s", _("FATAL ERROR:"),
              _("Out of memory"));
        exit(EX_OSERR);
    }

    while (length > 2) {        /* keep going until we have less than 24 bits */
        result[i++] = base64_table[current[0] >> 2];
        result[i++] =
            base64_table[((current[0] & 0x03) << 4) + (current[1] >> 4)];
        result[i++] =
            base64_table[((current[1] & 0x0f) << 2) + (current[2] >> 6)];
        result[i++] = base64_table[current[2] & 0x3f];

        current += 3;
        length -= 3;    /* we just handle 3 octets of data */
    }

    /** 
     * now deal with the tail end of things 
     */
    if (length != 0) {
        result[i++] = base64_table[current[0] >> 2];
        if (length > 1) {
            result[i++] =
                base64_table[((current[0] & 0x03) << 4) + (current[1] >> 4)];
            result[i++] = base64_table[(current[1] & 0x0f) << 2];
            result[i++] = base64_pad;
        }
        else {
            result[i++] = base64_table[(current[0] & 0x03) << 4];
            result[i++] = base64_pad;
            result[i++] = base64_pad;
        }
    }
    result[i] = '\0';
#if defined DEBUG
    uplog(LOG_DEBUG, _("%s calculated: %s"), "base64_encode()", result);
#endif /* DEBUG */

    return result;
}
