
Add `List.zonk` to the codebase:

```unison
List.zonk : [a] -> [a]
List.zonk xs = xs

Text.zonk : Text -> Text
Text.zonk txt = txt ++ "!! "
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      List.zonk : [a] -> [a]
      Text.zonk : Text -> Text

```
Now, typecheck a file with a reference to `Blah.zonk` (which doesn't exist in the codebase). This should fail:

```unison
-- should not typecheck as there's no `Blah.zonk` in the codebase
> Blah.zonk [1,2,3]
```

```ucm

  I'm not sure what Blah.zonk means at line 2, columns 3-12
  
      2 | > Blah.zonk [1,2,3]
  
  Whatever it is, it has a type that conforms to [Nat] -> o.
  

```
Here's another example, just checking that TDNR works for definitions in the same file:

```unison
foo.bar.baz = 42

qux.baz = "hello"

ex = baz ++ ", world!"

> ex
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      ex          : Text
      foo.bar.baz : Nat
      qux.baz     : Text
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    7 | > ex
          ⧩
          "hello, world!"

```
Here's another example, checking that TDNR works when multiple codebase definitions have matching names:

```unison
ex = zonk "hi"

> ex
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      ex : Text
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    3 | > ex
          ⧩
          "hi!! "

```
Last example, showing that TDNR works when there are multiple matching names in both the file and the codebase:

```unison
woot.zonk = "woot"
woot2.zonk = 9384

ex = zonk "hi" -- should resolve to Text.zonk, from the codebase
      ++ zonk   -- should resolve to the local `woot.zonk` from this file

> ex
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      ex         : Text
      woot.zonk  : Text
      woot2.zonk : Nat
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    7 | > ex
          ⧩
          "hi!! woot"

```
