
```unison
printLine : Text ->{IO} ()
printLine msg =
  putBytes.impl (stdHandle StdOut) (Text.toUtf8 (msg ++ "\n"))
  ()

-- An unannotated main function
main1 = '(printLine "\nhello world!")

-- Another variation
main2 _ = printLine "🌹"

-- An annotated main function
main3 : '{IO} ()
main3 _ = printLine "🦄 ☁️  🌈"
```

Testing a few variations here:

* Should be able to run annotated and unannotated main functions in the current file.
* Should be able to run annotated and unannotated main functions from the codebase.

```ucm
.> run main1

.> run main2

.> run main3

.> add

  ⍟ I've added these definitions:
  
    main1     : '{IO} ()
    main2     : ∀ _. _ ->{IO} ()
    main3     : '{IO} ()
    printLine : Text ->{IO} ()

.> rename.term main1 code.main1

  Done.

.> rename.term main2 code.main2

  Done.

.> rename.term main3 code.main3

  Done.

```
The renaming just ensures that when running `code.main1`, it has to get that main from the codebase rather than the scratch file:

```ucm
.> run code.main1

.> run code.main2

.> run code.main3

```
Now testing a few variations that should NOT typecheck.

```unison
main4 : Nat ->{IO} Nat
main4 n = n

main5 : Nat ->{IO} ()
main5 _ = ()
```

This shouldn't work since `main4` and `main5` don't have the right type.

```ucm
.> run main4

  😶
  
  I found this function:
  
    main4 : Nat ->{IO} Nat
  
  but in order for me to `run` it it needs to have the type:
  
    main4 : '{IO} ()

```
```ucm
.> run main5

  😶
  
  I found this function:
  
    main5 : Nat ->{IO} ()
  
  but in order for me to `run` it it needs to have the type:
  
    main5 : '{IO} ()

```
