Previously, the `alias.term` and `alias.type` would fail if the source argument was hash-only, and there was no way to create an alias for a definition that didn't already have a name.  Also, the `replace.term` and `replace.type` _only_ worked on hashes, and they had to be _full_ hashes.

With this PR, the source of an alias can be a short hash (even of a definition that doesn't currently have a name in the namespace) along with a name or hash-qualified name from the current namespace as usual, and the arguments to `replace.term` and `replace.type` can be a short hash, a name, or a hash-qualified name.

Let's make some hash-only aliases, now that we can. :mad-with-power-emoji:

```ucm
.> alias.type ##Nat Cat

  Done.

.> alias.term ##Nat.+ please_fix_763.+

  Done.

```
And some functions that use them:
```unison
f = 3
g = 4
h = f + 1

> h
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⍟ These new definitions are ok to `add`:
    
      f : Cat
      g : Cat
      h : Cat
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    5 | > h
          ⧩
          4

```
```ucm
.> add

  ⍟ I've added these definitions:
  
    f : Cat
    g : Cat
    h : Cat

```
We used to have to know the full hash for a definition to be able to use the `replace.*` commands, but now we don't:
```ucm
.> names g

  Term
  Hash:   #52addbrohu
  Names:  g

.> replace.term f g

  Done.

.> names g

  Term
  Hash:   #52addbrohu
  Names:  f g

.> view.patch

  Edited Terms: f#msp7bv40rv -> f
  
  Tip: To remove entries from a patch, use
       delete.term-replacement or delete.type-replacement, as
       appropriate.

```
The value of `h` should have been updated too:
```unison
> h
```

```ucm

  ✅
  
  scratch.u changed.
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    1 | > h
          ⧩
          5

```
