```unison
id x = x

id2 x =
  z = 384849
  id x
```

```ucm

  I found and typechecked these definitions in scratch.u. If you
  do an `add` or `update`, here's how your codebase would
  change:
  
    ⊡ Previously added definitions will be ignored: id
    
    ⍟ These new definitions are ok to `add`:
    
      id2 : x -> x

```
```ucm
  ☝️  The namespace .scratch is empty.

.scratch> add

  ⍟ I've added these definitions:
  
    id  : x -> x
    id2 : x -> x

```
```unison
> id2 "hi"
```

```ucm

  ✅
  
  scratch.u changed.
  
  Now evaluating any watch expressions (lines starting with
  `>`)... Ctrl+C cancels.

    1 | > id2 "hi"
          ⧩
          "hi"

```
