/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.deployment.internal;

import javax.annotation.Nullable;
import org.gradle.deployment.internal.ContinuousExecutionGate;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentInternal;

class GateControllingDeployment
implements DeploymentInternal {
    private final ContinuousExecutionGate.GateKeeper gateKeeper;
    private final DeploymentInternal delegate;

    GateControllingDeployment(ContinuousExecutionGate continuousExecutionGate, DeploymentInternal delegate) {
        this.gateKeeper = continuousExecutionGate.createGateKeeper();
        this.delegate = delegate;
    }

    @Override
    public Deployment.Status status() {
        this.gateKeeper.open();
        Deployment.Status status = this.delegate.status();
        if (!status.hasChanged()) {
            this.gateKeeper.close();
        }
        return status;
    }

    @Override
    public void outOfDate() {
        this.delegate.outOfDate();
    }

    @Override
    public void upToDate(@Nullable Throwable failure) {
        this.delegate.upToDate(failure);
        this.gateKeeper.close();
    }
}

