#!/bin/sh

UGREP=../../src/ugrep

cat > _ug <<END
#compdef ug ug+ ugrep ugrep+

# zsh completions for 'ugrep'
# Autogenerated from ugrep --help

local matchers='(--extended-regexp --fixed-strings --basic-regexp --perl-regexp --fuzzy -E -F -G -P -Z)'
local arguments=(
'(-e --regexp -f --file)1: :_guard "^-*" pattern'
'*: :_files'
END

# get -t (--file-type=) TYPES arguments
export TYPES=$($UGREP -tlist 2>&1 | sed -E -e 's/[ ]*([0-9A-Za-z+]+).*/\1/' -e '/FILE/d' -e '/^ /d' | tr '\n' ' ')

# get --encoding=ENCODING arguments
export ENCODING=$($UGREP --encoding=list 2>&1 | sed -e 's/^.[a-z].*are//' -e '/help/d' -e "s/ '//g" -e "s/',\?/ /g" | tr '\n' ' ')

# generate --help
# add { and } to enclose options line
# remove cluttering [-e] PATTERN [OPTIONS] [WHAT], ... and ]=, etc
# replace space with , to separate options in { } and change = to =- to make = mandatory
# keep option line and description's first sentence up to period, remove ` ' from descriptions, remove 4 spaces indent
# strip { } from single option
# append indented description to the option line
# enclose description in brackets '[description]:message:action
# change --hexdump, --sort, -Z and --fuzzy to append - to take arguments
# add ':message:action' to -DACTION and -dACTION
# add ':message:( )' to -e, -f, -g, -J, -K, -M, -m, -N, -O,--file-extention
# add ':message:action' to -t,--file-type=TYPES and --encoding=ENCODING
# add ':message:action' to --hexdump
# add ':message:action' to --sort=KEY
# add ':message:action' to -Z,--fuzzy=
# add $matchers to options that are exclusive -E -F -G -P -Z
# add '(1)*' to options that are repeatable
# add '(-)' to {--help,-?} to kill completion
# add final quote
$UGREP --help 2>&1 \
    | sed -E -e 's/^[ ]{4}-/    \{-/' -e "/^[ ]{4}\{/s/$/\}/" \
    | sed -E -e '/^[ ]{4}\{/s/ \[-e\]|[ ]?\[[^]]+\]|[ ]?[A-Z]{3,}| \.\.\.|[],:]//g' \
    | sed -E -e '/^[ ]{4}\{/s/ -/,-/g' -e '/^[ ]{4}\{/s/=/=-/g' \
    | sed -E -e '/^[ ]{4}\{/,/^[ ]{12}.*\./!d' -e 's/^([ ]{12}[^.]*\.)( .*)?$/\1/' -e $'/^[ ]{12}/s/[`\']//g' -e 's/^[ ]{4}//' \
    | sed -E -e 's/\{([^,}]+)\}/\1/' \
    | sed -e :a -e '$!N;s/\n[ ]\{7\}//;ta' -e 'P;D' \
    | sed -E -e "s/ /'[/" -e "s/\.?$/\]/" \
    | sed -E -e "s/--hexdump/--hexdump=-/" -e "s/--sort'/--sort=-'/" -e "s/-Z,--fuzzy/-Z-,--fuzzy=-/" \
    | sed -E -e "/\{-D/s/$/:ACTION:(read skip)/" -e "/\{-d/s/$/:ACTION:(read recurse skip)/" \
    | sed -E -e "/\{-g/s/$/:GLOB:( )/" -e "/\{-[eMN]/s/$/:PATTERN:( )/" -e "/\{-f/s/$/:FILE:_files/" -e "/\{-J/s/$/:NUM:( )/" -e "/\{-[Km]/s/$/:MIN,MAX:( )/" -e "/\{-O/s/$/:EXT:( )/" \
    | sed -E -e "/\{-t/s/$/:TYPES:($TYPES)/" -e "/--encoding/s/$/:ENCODING:($ENCODING)/" \
    | sed -E -e "/--hexdump/s/$/:NUM:(1a 2a 4ah 6ah 8ah 1aC1 2aC1 4ahC1 6ahC1 8ahC1)/" \
    | sed -E -e "/\{-m/s/$/::(1 1, 1,10)/" \
    | sed -E -e "/--sort=/s/$/:KEY:(name best size changed created used rname rbest rsize rchanged rcreated rused)/" \
    | sed -E -e "/\{-Z/s/$/:DIST:(1 +1 -1 \\\\~1 +-1 +~1 +-~1 -~1 best1 best+1 best-1 best~1 best+-1 best+~1 best+-~1 best-~1)/" \
    | sed -E -e '/\{-[EFGPZ]/s/^/$matchers/' \
    | sed -E -e "/\{-[efgtMO]/s/^/'(1)*'/" -e "/^--and/s/^/'(1)*'/" -e "/^--exclude/s/^/'(1)*'/" -e "/^--include/s/^/'(1)*'/" -e "/^--ignore-files/s/^/'(1)*'/" \
    | sed -E -e "/\{--help/s/^/'(-)'/" \
    | sed -E -e "s/$/'/" \
    >> _ug

cat >> _ug <<END
)
_arguments -s -S \$arguments
END

cp -f _ug _ug+
cp -f _ug _ugrep
cp -f _ug _ugrep+

cat _ug
