	incdir	"Amiga:Includes/"
	include	"misc/DeliPlayer.i"
	include "exec/exec.i"
	include "misc/devpacmacros.i"
;
;
	SECTION Player,Code
;
;

	PLAYERHEADER PlayerTagArray

	dc.b '$VER: Art Of Noise 4 voices replayer (20060410)',0
	even

PlayerTagArray
	dc.l	DTP_RequestDTVersion,16
	dc.l	DTP_PlayerVersion,1
	dc.l	DTP_PlayerName,PName
	dc.l	DTP_Creator,CName
	dc.l	DTP_ModuleName,MNamePTR
	dc.l	DTP_DeliBase,delibase
	dc.l	DTP_Check2,Chk
	dc.l	DTP_StartInt,ALLOCCIAB
	dc.l	DTP_StopInt,FREECIAB
	dc.l	DTP_InitPlayer,InitPlay
	dc.l	DTP_EndPlayer,EndPlay
	dc.l	DTP_InitSound,InitSnd
	dc.l	DTP_EndSound,EndSnd
	dc.l	DTP_Flags,PLYF_SONGEND
	dc.l	TAG_DONE

*-----------------------------------------------------------------------*
;
; Player/Creatorname und lokale Daten
MNamePTR:
	dc.l	MName

PName	dc.b 'ArtOfNoise (4ch)',0
CName	dc.b 'by Bastian Spiegel (Twice/Lego)',10
	dc.b "Stonecracker decruncher routine by Marcus 'Cozine' Ottosson",10 
	dc.b "+ Jouni 'Mr.Spiv' Korhonen",10
	dc.b 'adapted for UADE by mld',0
MName:	ds.b 32
	dc.b 0
	even
delibase	dc.l 0


*-----------------------------------------------------------------------*
;
; Testet auf Modul

Chk						; AON4 ?
	move.l	dtg_ChkData(a5),a0
	move.l	a0,mod				; save Pointer
	cmp.l	#"S404",(a0)			; packed with stonecracker???
	bne.s	Chkunp				; nope
	bsr	stc_decrunch
	move.l	stc_unpackeddata,mod
	move.l	mod,a0
Chkunp:	moveq	#-1,d0				; no (default)
	cmp.l	#"AON4",(a0)
	bne.s	ChkEnd
	move.l	#"NAME",d0
	move.l	#"INFO",d1
	bsr.b	cpyMName
chkok	moveq	#0,d0				; Modul identified
ChkEnd
	rts

cpyMName:
	MOVEA.L	A0,A1
.search	CMP.L	(A1),D0
	BEQ.B	.ok
	CMP.L	(A1),D1
	beq	.end
	ADDQ.L	#2,A1
	BRA.B	.search
.ok	ADDQ.L	#8,A1
    
	move.l	-4(a1),d0				; quick and dirty
	beq	.end
	subq.b	#1,d0	
	cmp.b	#32,d0
	ble.b	.cpy	
	moveq	#32,d0
.cpy	lea.l	MName,a0
.loop	move.b	(a1)+,(a0)+	
	dbra	d0,.loop	
.end	rts

*-----------------------------------------------------------------------*
;
; Init Player

InitPlay
	move.l	dtg_AudioAlloc(a5),a0		; Function
	jsr	(a0)				; returncode is already set !
	rts

*-----------------------------------------------------------------------*
;
; End Player

EndPlay
	jsr	AON_END
	move.l	dtg_AudioFree(a5),a0		; Function
	jsr	(a0)
	bsr	 FreeModmem
	rts

*-----------------------------------------------------------------------*
;
; Init Module

InitSnd
	move.l	mod,a0
	;lea	buffers,a1			
	moveq	#0,d0				;start Pos
	moveq	#$28,d1				;Mixrate
	jsr	AON_init			;init Aon Player
	rts

*-----------------------------------------------------------------------*
;
; SongEnd

AON_Songend
    movem.l d0-a6,-(a7)
    move.l delibase,a5
    move.l dtg_Songend(a5),a0
    jsr (a0)
    movem.l (a7)+,d0-a6
    rts

*-----------------------------------------------------------------------*
;
; Clean up Module

EndSnd
	jsr	AON_END		;End
	rts

; Stonecracker decruncher...
;-----------------------------------------------------
; a4=crunched data ptr
;ls_decrunchs404
stc_decrunch:
			movem.l	d0-a6,-(sp)
			clr.l	(a0)		; 'S404' lschen
			move.l	8(a0),d0	; original-length
			move.l	d0,stc_unpackedlen

			moveq	#memf_chip,d1
			CALLEXEC AllocMem
			tst.l	d0
			beq.b	.nomem

			move.l	d0,stc_unpackeddata
			move.l	d0,a0			; unpacked mod
			move.l	mod,a1			; packed mod

			movem.l	d0-a6,-(sp)
			bsr	decrunchS404	; file decrunchen
			movem.l	(sp)+,d0-a6
.nomem	
			movem.l	(sp)+,d0-a6
decrend:		rts

FreeModmem:
		    	move.l	stc_unpackedlen,d0
			move.l	stc_unpackeddata,a0
			cmp.l	#0,a0
			beq	FreeModmemEnd
			CALLEXEC FreeMem
			move.l	#0,a0
FreeModmemEnd:		rts
;-----------------------------------------------------------------------------
;- S404 highly optimized data decruncher v1.1 turbo
;- 27.11.93 by Marcus 'Cozine' Ottosson
;-----------------------------------------------------------------------------
;- Based on S404 data_decruncher v0.2
;- (c) 1993 by Jouni 'Mr.Spiv' Korhonen (SWSW)
;-----------------------------------------------------------------------------
;- call with registers: a0 = destination address
;-                      a1 = crunched data
;-----------------------------------------------------------------------------
; uses d0-a6
decrunchS404:
_l0:		addq	#8,a1			; Skip ID string & security
						; length..
		move.l	a0,a5
		add.l	(a1)+,a0
		add.l	(a1),a1
		moveq	#0,d4
		moveq	#16,d5
		movem.w	(a1),d2/d6/d7
		not.w	d4
		lea	_loff6(pc),a3
		lea	_llen5a(pc),a4
		moveq	#1,d0
		moveq	#-1,d3
		bra.s	_ltest1

_lins:		subq.w	#8,d7
		bpl.s	_lins2
_lins1:		move.w	d7,d1
		addq.w	#8,d7
		lsl.l	d7,d6
		move.w	-(a1),d6
		neg.w	d1
		lsl.l	d1,d6
		addq.w	#8,d7
		swap	d6
		move.b	d6,-(a0)
		swap	d6
		cmp.l	a0,a5
		dbhs	d7,_lmain
		bra.s	_lexma

_lins2:		rol.w	#8,d6
		move.b	d6,-(a0)
_ltest1:	cmp.l	a0,a5
		dbhs	d7,_lmain
_lexma		bhs.s	_lexit

_lmain1:	move.w	-(a1),d6
		moveq	#15,d7
_lmain:		add.w	d6,d6
		bcc.s	_lins

		dbf	d7,_llen1
		move.w	-(a1),d6
		moveq	#15,d7
_llen1:		add.w	d6,d6
		bcs.s	_llen6
		dbf	d7,_llen2
		move.w	-(a1),d6
		moveq	#15,d7
_llen2:		moveq	#2,d1
		moveq	#2,d3
		add.w	d6,d6
		bcs.s	_llen5
		dbf	d7,_llen3
		move.w	-(a1),d6
		moveq	#15,d7
_llen3:		add.w	d6,d6
		bcc.s	_llen4
		moveq	#4,d1
		moveq	#6,d3
		lea	_llen3a(pc),a6
		bra.s	_lbits
_llen3a:	add.w	d1,d3
		cmp.w	#15,d1
		blo.s	_loff1

		moveq	#5,d1
		moveq	#14,d3
		lea	_llen3b(pc),a6
		bra.s	_lbits

_llen4:		moveq	#21,d3
_lloop:		moveq	#8,d1
_llen5:		move.l	a4,a6
		bra.s	_lbits
_llen5a:	add.w	d1,d3
		not.b	d1
		dbeq	d7,_loff2
		bne.s	_loff2a	
		beq.s	_lloop

_loff6:		add.w	d1,a2
		move.b	(a2),-(a0)
_lcopy:		move.b	-(a2),-(a0)
		dbf	d3,_lcopy
_ltest:		cmp.l	a0,a5
		dbhs	d7,_lmain
		blo.s	_lmain1
_lexit:		rts

_llen6:		dbf	d7,_llen7
		move.w	-(a1),d6
		moveq	#15,d7
_llen7:		add.w	d6,d6
		addx.w	d0,d3
_loff1:		dbf	d7,_loff2
_loff2a:	move.w	-(a1),d6
		moveq	#15,d7
_loff2:		add.w	d6,d6
		bcs.s	_loff3

		dbf	d7,_loff4
		move.w	-(a1),d6
		moveq	#15,d7
_loff4:		moveq	#9,d1
		lea	32(a0),a2
		add.w	d6,d6
		bcc.s	_loff5
		moveq	#5,d1
		move.l	a0,a2
		bra.s	_loff5
_loff3:		lea	544(a0),a2
		move.w	d2,d1
_loff5:		move.l	a3,a6

_lbits:		and.l	d4,d6
		sub.w	d1,d7
		bpl.s	_lbits2
		add.w	d7,d1
		lsl.l	d1,d6
		move.w	d7,d1
		move.w	-(a1),d6
		neg.w	d1
		add.w	d5,d7
_lbits2:	lsl.l	d1,d6
		move.l	d6,d1
		swap.w	d1
		jmp	(a6)

_lpins2:	moveq	#-1,d3
		bra.w	_lins2

_l2ins2:	rol.w	#8,d6
		move.b	d6,-(a0)
_l2ins1:	lsl.l	d7,d6
		move.w	-(a1),d6
		lsl.l	d1,d6
		swap	d6
		move.b	d6,-(a0)
		swap	d6
		subq.w	#2,d3
		bgt.s	_l2ins2
		beq.s	_lpins2
		addq.w	#8,d7
		bra.s	_ltest

_llen3b:	add.w	d1,d3
		move.b	_lnewd1(pc,d7),d1
		bpl.s	_l2ins1
		subq.w	#8,d7
		dbf	d3,_l2ins2

_lnewd1:	dc.b	$08,$07,$06,$05,$04,$03,$02,$01
		dc.b	$88,$87,$86,$85,$84,$83,$82,$81


;-----------------------------------------------------


;****; AON replayer Programm ;********************************************

	SECTION "  0",CODE_C
PLAYERSTART
ALLOCCIAB	MOVEM.L	D1-A6,-(A7)
	LEA	L_302(PC),A0
	LEA	L_30E(PC),A1
	MOVE.L	A1,(A0)
	MOVEA.L	4.L,A6
	MOVEQ	#0,D0
	LEA	L_2E6(PC),A1
	JSR	-$01F2(A6)
	LEA	L_2F4(PC),A1
	MOVE.L	D0,(A1)
	BEQ.W	L_2DE
	MOVEA.L	D0,A6
	LEA	L_2F8(PC),A1		; TimerIntServerB
	LEA	L_498(PC),A0		; aon_playciab
	MOVE.L	A0,$0012(A1)
	MOVEQ	#1,D0
	JSR	-6(A6)
	TST.L	D0
	BNE.W	L_2DE
	MOVE.B	#$0079,$00BFD600.L
	MOVE.B	#$0012,$00BFD700.L
	BSET	#0,$00BFDF00.L
	MOVEM.L	(A7)+,D1-A6
	RTS	
FREECIAB	MOVEM.L	D1-A6,-(A7)
	BCLR	#0,$00BFDF00.L
	MOVEA.L	L_2F4(PC),A6
	LEA	L_2F8(PC),A1
	MOVEQ	#1,D0
	JSR	-$000C(A6)
	MOVEM.L	(A7)+,D1-A6
	MOVEQ	#0,D0
	RTS	
L_2DE	MOVEQ	#-1,D0
	MOVEM.L	(A7)+,D1-A6
	RTS	
L_2E6	DC.B	'ciab.resource',0
L_2F4	DC.W	0
	DC.W	0
L_2F8	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	$263
L_302	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
L_30E	DC.B	'ArtOfNoise- 4ch-player',0
	DC.B	0
AON_INIT
	;LEA	L_0+$1F80(PC),A0
	MOVEM.L	D1-A6,-(A7)
	CMPI.L	#$414F4E34,(A0)
	BNE.W	L_45C
	LEA	L_1BB0(PC),A6		;aon_data
	MOVE.W	#$0245,D7
L_340	CLR.B	(A6,D7.W)
	DBRA	D7,L_340
	MOVE.B	#6,$0020(A6)		;Speed
	MOVE.B	D0,$0027(A6)		;Startpos
	MOVE.L	A0,$023A(A6)		;ModuleStart

	MOVE.L	#$494E464F,D0		; "INFO"
	BSR.W	L_44E
	MOVE.L	A1,$0028(A6)
	MOVE.L	#$41525047,D0		;"ARPG"
	BSR.W	L_44E
	MOVE.L	A1,$002C(A6)
	MOVE.L	#$504C5354,D0		;"PLST"
	BSR.W	L_44E
	MOVE.L	A1,$0030(A6)
	MOVE.L	#$50415454,D0		;"PATT"
	BSR.W	L_44E
	MOVE.L	A1,$0034(A6)		;"INST"
	MOVE.L	#$494E5354,D0
	BSR.W	L_44E
	LEA	$013A(A6),A2		; aon_instrstarts
	MOVEQ	#$003C,D7
L_39E	MOVE.L	A1,(A2)+
	LEA	$0020(A1),A1
	DBRA	D7,L_39E
	MOVE.L	#$574C454E,D0		;"WLEN"
	BSR.W	L_44E
	MOVEA.L	A1,A3
	MOVE.L	#$57415645,D0		;"WAVE"
	BSR.W	L_44E
	LEA	$003A(A6),A2
	MOVE.L	A1,D0
	MOVEQ	#$003F,D7
L_3C6	MOVE.L	D0,(A2)+
	ADD.L	(A3)+,D0
	DBRA	D7,L_3C6
	LEA	L_1DF6(PC),A0
	MOVE.W	#$0061,D7
L_3D6	CLR.L	(A0)+
	DBRA	D7,L_3D6
	LEA	L_1DF6(PC),A0
	MOVEQ	#$0040,D0		; Trackvol
	MOVEQ	#3,D7
L_3E4	CLR.L	2(A0)
	CLR.W	6(A0)
	CLR.W	8(A0)
	CLR.L	$000A(A0)
	CLR.W	$000E(A0)
	CLR.L	$0010(A0)
	CLR.B	$0014(A0)
	CLR.W	$001E(A0)
	CLR.L	$003C(A0)
	CLR.L	$0040(A0)
	CLR.L	$0034(A0)
	CLR.L	$0038(A0)
	CLR.B	$004A(A0)
	CLR.B	$0049(A0)
	CLR.B	$0048(A0)
	CLR.B	$0052(A0)
	MOVE.W	D0,$0060(A0)
	LEA	$0062(A0),A0
	DBRA	D7,L_3E4
	;BSET	#1,$00BFE001.L
	;BSR.W	ALLOCCIAB
	;TST.W	D0
	;BMI.W	L_45C
	BSR.W	L_F92			;Reset Timer
	MOVEM.L	(A7)+,D1-A6
	MOVEQ	#0,D0
	RTS	

aon_searchchunk
L_44E	MOVEA.L	A0,A1

.search
L_450	CMP.L	(A1),D0
	BEQ.B	L_458
	ADDQ.L	#2,A1
	BRA.B	L_450
.ok
L_458	ADDQ.L	#8,A1
	RTS	

AON_NOTINITIALIZED
L_45C	MOVEM.L	(A7)+,D1-A6
	MOVEQ	#-1,D0
	RTS	
	LEA	L_12AA(PC),A0
	RTS	

AON_END
    	; BSR.W	FREECIAB
	MOVE.W	#$00FF,$00DFF09E.L
	MOVE.W	#$000F,$00DFF096.L
	CLR.W	$00DFF0A8.L
	CLR.W	$00DFF0B8.L
	CLR.W	$00DFF0C8.L
	CLR.W	$00DFF0D8.L
	RTS	
aon_playciab
L_498	MOVEM.L	D1-A6,-(A7)
	LEA	L_1BB0(PC),A6		;aon_data
	TST.B	$0243(A6)
	BEQ.B	L_4BA
	CMPI.B	#1,$0243(A6)
	BEQ.B	L_4C0
	BSR.W	L_552
L_4B2	MOVEM.L	(A7)+,D1-A6
	MOVEQ	#0,D0
	RTS	
L_4BA	BSR.W	L_4C6
	BRA.B	L_4B2
L_4C0	BSR.W	L_542
	BRA.B	L_4B2
L_4C6	ADDQ.B	#1,$0021(A6)
	MOVE.B	$0020(A6),D0
	BEQ.B	L_4E0
	CMP.B	$0021(A6),D0
	BHI.W	L_4E0
	CLR.B	$0021(A6)
	BSR.W	L_56C
L_4E0	BRA.W	L_4E4
L_4E4	MOVEQ	#0,D7
	MOVE.B	$0027(A6),D7
	MOVEA.L	$0030(A6),A1
	MOVEQ	#0,D0
	MOVE.B	(A1,D7.W),D0
	MOVE.B	D0,$0242(A6)
	LEA	L_CBE(PC),A1
	LEA	L_1DF6(PC),A4
	JSR	(A1)
	LEA	$0062(A4),A4
	JSR	(A1)
	LEA	$0062(A4),A4
	JSR	(A1)
	LEA	$0062(A4),A4
	JSR	(A1)
	MOVEQ	#0,D1
	MOVEQ	#0,D7
	LEA	$0548(A1),A1
	LEA	L_1DF6(PC),A4
	LEA	$00DFF0A0.L,A5
	JSR	(A1)
	JSR	(A1)
	JSR	(A1)
	JSR	(A1)
	MOVE.W	D1,-$004A(A5)
	ORI.W	#-$8000,D1
	MOVE.W	D1,$0244(A6)
	MOVE.B	#1,$0243(A6)
	RTS	
L_542	MOVE.B	#2,$0243(A6)
	MOVE.W	$0244(A6),$00DFF096.L
	RTS	
L_552	CLR.B	$0243(A6)
	LEA	L_1DF6(PC),A4
	LEA	$00DFF0A0.L,A5
	LEA	L_128C(PC),A1
	JSR	(A1)
	JSR	(A1)
	JSR	(A1)
	JMP	(A1)
L_56C	CMPI.B	#-1,$0022(A6)
	BEQ.W	L_5EC
L_576	TST.B	$0039(A6)
	BMI.B	L_586
	BEQ.B	L_586
	SUBQ.B	#1,$0039(A6)
	BRA.W	L_630
L_586	MOVE.B	#-1,$0039(A6)
	LEA	L_1DF6(PC),A4
	LEA	L_13B0(PC),A5
	MOVEQ	#0,D0
	MOVE.B	$0242(A6),D0
	MOVEA.L	$0034(A6),A0
	MOVEQ	#$000A,D1
	LSL.L	D1,D0
	LEA	(A0,D0.L),A0
	MOVE.W	$0022(A6),D1
	ADD.W	D1,D1
	ADD.W	D1,D1
	LEA	(A0,D1.L),A0
	BSR.W	L_632
	LEA	$0062(A4),A4
	ADDQ.L	#4,A0
	BSR.W	L_632
	LEA	$0062(A4),A4
	ADDQ.L	#4,A0
	BSR.W	L_632
	LEA	$0062(A4),A4
	ADDQ.L	#4,A0
	BSR.W	L_632
	TST.B	$0026(A6)
	BEQ.B	L_5E6
	CLR.B	$0026(A6)
	MOVE.B	$0024(A6),$0023(A6)
	BRA.B	L_630
L_5E6	ADDQ.B	#4,$0023(A6)
	BNE.B	L_630
L_5EC	CLR.B	$0039(A6)
	CLR.W	$0024(A6)
	ADDQ.B	#1,$0027(A6)
	MOVEA.L	$0028(A6),A3
	MOVE.B	1(A3),D0
	CMP.B	$0027(A6),D0
	BHI.W	L_60E
	MOVE.B	2(A3),$0027(A6)

	jsr	AON_Songend
	
L_60E	TST.B	$0022(A6)
	BEQ.B	L_630
	CLR.B	$0022(A6)
	MOVEQ	#0,D7
	MOVE.B	$0027(A6),D7
	MOVEA.L	$0030(A6),A1
	MOVEQ	#0,D0
	MOVE.B	(A1,D7.W),D0
	MOVE.B	D0,$0242(A6)
	BRA.W	L_576
L_630	RTS	
L_632	MOVE.B	2(A0),$0056(A4)
	ANDI.B	#$003F,$0056(A4)
	MOVE.W	2(A0),D0
	ANDI.W	#$3FFF,D0
	MOVE.B	D0,D1
	MOVE.B	D0,$0057(A4)
	CMPI.B	#$000D,$0056(A4)
	BNE.B	L_662
	CMPI.B	#-4,$0023(A6)
	BNE.B	L_662
	MOVE.B	#-8,$0023(A6)
L_662	ANDI.B	#-$0010,D0
	ANDI.B	#$000F,D1
	CLR.B	$0015(A4)
	CMPI.B	#$0010,$0056(A4)
	BNE.B	L_684
	MOVE.B	$0057(A4),D2
	ANDI.B	#$000F,D2
	MOVE.B	D2,$0015(A4)
	BRA.B	L_6D0
L_684	CMPI.W	#$0EC0,D0
	BNE.B	L_690
	MOVE.B	D1,$0015(A4)
	BRA.B	L_6D0
L_690	CMPI.W	#$0EE0,D0
	BNE.B	L_6A2
	TST.B	$0039(A6)
	BPL.B	L_6A2
	MOVE.B	D1,$0039(A6)
	BRA.B	L_6D0
L_6A2	CMPI.W	#$0E60,D0
	BNE.B	L_6D0
	CMPI.B	#-$0010,$0025(A6)
	BEQ.B	L_6D0
	TST.B	D1
	BEQ.B	L_6D0
	TST.B	$0025(A6)
	BNE.B	L_6BE
	MOVE.B	D1,$0025(A6)
L_6BE	SUBQ.B	#1,$0025(A6)
	BNE.B	L_6CA
	MOVE.B	#-$0010,$0025(A6)
L_6CA	MOVE.B	#-1,$0026(A6)
L_6D0	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D5
	MOVE.B	1(A0),D1
	ANDI.B	#$003F,D1
	SUBQ.B	#1,D1
	BPL.B	L_724
	TST.L	$0010(A4)
	BEQ.W	L_B4E
	MOVEA.L	$0010(A4),A2
	MOVE.B	(A0),D2
	ANDI.B	#$003F,D2
	BEQ.W	L_A22
	MOVEQ	#1,D5
	CMPI.B	#3,$0056(A4)
	BEQ.W	L_A22
	CMPI.B	#5,$0056(A4)
	BEQ.W	L_A22
	CMPI.B	#$001B,$0056(A4)
	BEQ.W	L_A22
	CMPI.B	#$001C,$0056(A4)
	BEQ.W	L_A22
	BRA.B	L_798
L_724	MOVE.B	(A0),D2
	ANDI.B	#$003F,D2
	BNE.B	L_756
	ADD.B	D1,D1
	ADD.B	D1,D1
	LEA	$013A(A6),A2
	MOVEA.L	(A2,D1.W),A2
	TST.B	0(A2)
	BNE.W	L_A18
	CMPA.L	$0010(A4),A2
	BEQ.W	L_A18
	MOVE.L	A2,$0010(A4)
	MOVE.B	#1,0(A4)
	BRA.W	L_94E
L_756	CLR.L	$0058(A4)
	ADD.B	D1,D1
	ADD.B	D1,D1
	LEA	$013A(A6),A2
	MOVEA.L	(A2,D1.W),A2
	CMPA.L	$0010(A4),A2
	BNE.B	L_794
	CMPI.B	#3,$0056(A4)
	BEQ.W	L_A18
	CMPI.B	#5,$0056(A4)
	BEQ.W	L_A18
	CMPI.B	#$001B,$0056(A4)
	BEQ.W	L_A18
	CMPI.B	#$001C,$0056(A4)
	BEQ.W	L_A18
L_794	MOVE.L	A2,$0010(A4)
L_798	CLR.B	$0054(A4)
	BSR.W	L_B62
	TST.B	0(A2)
	BEQ.W	L_916
	MOVE.B	#1,$0016(A4)
	MOVE.W	$0056(A4),D0
	MOVE.B	D0,D1
	ANDI.B	#-$0010,D0
	CMPI.W	#$0E90,D0
	BNE.B	L_7C6
	ANDI.B	#$000F,D1
	MOVE.B	D1,$0015(A4)
L_7C6	LEA	$003A(A6),A3
	MOVE.B	(A0),D2
	ANDI.B	#$003F,D2
	BEQ.W	L_A18
	CLR.W	$001E(A4)
	MOVEQ	#0,D3
	CMPI.B	#$0011,$0056(A4)
	BNE.B	L_7E6
	MOVE.B	$0057(A4),D3
L_7E6	BTST	#4,D3
	BNE.W	L_8C4
	CMPI.W	#$0ED0,D0
	BNE.B	L_7FE
	ANDI.B	#$000F,D1
	MOVE.B	D1,$0015(A4)
	BRA.B	L_804
L_7FE	MOVE.B	#3,0(A4)
L_804	MOVEQ	#0,D0
	MOVE.B	3(A2),D0
	MOVE.B	D0,$005F(A4)
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	(A3,D0.L),D1
	CMP.L	2(A4),D1
	BNE.B	L_828
	CLR.B	0(A4)
	TST.B	$004B(A4)
	BNE.W	L_8C4
L_828	MOVE.L	D1,2(A4)
	MOVEQ	#0,D0
	MOVE.B	4(A2),D0
	CMPI.B	#9,$0056(A4)
	BNE.B	L_858
	MOVEQ	#0,D2
	MOVE.B	$0057(A4),D2
	MULU	D0,D2
	ADD.L	D1,D2
	MOVE.L	D2,D1
	TST.B	$0052(A4)
	BEQ.B	L_858
	MOVE.L	D1,$0034(A4)
	MOVE.L	D1,$000A(A4)
	BRA.W	L_8C4
L_858	TST.B	$0052(A4)
	BNE.B	L_8C4
	MOVE.L	D1,$0034(A4)
	MOVE.W	6(A4),8(A4)
	MOVE.W	D0,6(A4)
	MOVE.W	D0,$000E(A4)
	ADD.W	D0,D0
	MOVE.L	D0,$0044(A4)
	MOVEQ	#0,D2
	MOVE.B	$000F(A2),D2
	MULU	D0,D2
	ADD.L	D1,D2
	MOVE.L	D2,$000A(A4)
	MOVEQ	#0,D2
	MOVE.B	$000E(A2),D2
	MULU	D0,D2
	ADD.L	D1,D2
	MOVE.L	D2,$0038(A4)
	MOVEQ	#0,D2
	MOVE.B	$000F(A2),D2
	MULU	D0,D2
	ADD.L	D1,D2
	MOVE.L	D2,$003C(A4)
	MOVEQ	#0,D2
	MOVE.B	$0010(A2),D2
	ADD.B	$000F(A2),D2
	MULU	D0,D2
	ADD.L	D1,D2
	MOVE.L	D2,$0040(A4)
	MOVE.B	$000D(A2),$0048(A4)
	MOVE.B	$000D(A2),$0049(A4)
	MOVE.B	$0011(A2),$004A(A4)
L_8C4	CLR.B	$0051(A4)
	CMPI.B	#3,$000C(A2)
	BEQ.B	L_90C
	MOVEQ	#0,D1
	MOVE.B	$000B(A2),D1
	MOVE.W	D1,$001A(A4)
	MOVEQ	#0,D1
	MOVE.B	$000A(A2),D1
	BNE.B	L_8EA
	MOVE.W	#-2,$001A(A4)
	BRA.B	L_908
L_8EA	MOVE.L	A2,-(A7)
	BSR.W	L_E42
	MOVEA.L	(A7)+,A2
	MOVE.B	$000C(A2),D0
	ROR.B	#3,D0
	ANDI.B	#-$0061,$0018(A4)
	OR.B	D0,$0018(A4)
	MOVE.B	#1,$0054(A4)
L_908	BRA.W	L_A18
L_90C	MOVE.B	#$0021,$0051(A4)
	BRA.W	L_A18
L_916	MOVE.B	#$0021,$0051(A4)
	CLR.B	$0016(A4)
	MOVE.W	$0056(A4),D0
	MOVE.B	D0,D1
	ANDI.B	#-$0010,D0
	CMPI.W	#$0ED0,D0
	BNE.B	L_93A
	ANDI.B	#$000F,D1
	MOVE.B	D1,$0015(A4)
	BRA.B	L_94E
L_93A	CMPI.W	#$0E90,D0
	BNE.B	L_948
	ANDI.B	#$000F,D1
	MOVE.B	D1,$0015(A4)
L_948	MOVE.B	#3,0(A4)
L_94E	LEA	$003A(A6),A3
	MOVE.B	(A0),D2
	ANDI.B	#$003F,D2
	BEQ.B	L_95E
	CLR.W	$001E(A4)
L_95E	MOVEQ	#0,D0
	MOVE.B	3(A2),D0
	MOVE.B	D0,$005F(A4)
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	(A3,D0.L),D1
	MOVE.L	8(A2),D4
	MOVE.W	6(A4),8(A4)
	MOVE.W	D4,6(A4)
	TST.L	$0010(A2)
	BNE.B	L_998
	MOVE.L	A2,-(A7)
	LEA	L_12AE(PC),A2
	MOVE.L	A2,$000A(A4)
	MOVEA.L	(A7)+,A2
	MOVE.W	#1,$000E(A4)
	BRA.B	L_9D2
L_998	MOVE.L	$000C(A2),D2
	TST.B	$0241(A6)
	BNE.B	L_9B2
	TST.L	D2
	BNE.B	L_9B2
	MOVE.L	D1,$000A(A4)
	MOVE.W	$0012(A2),$000E(A4)
	BRA.B	L_9D2
L_9B2	MOVE.L	D2,D3
	ADD.L	D2,D2
	ADD.L	D1,D2
	MOVE.L	D2,$000A(A4)
	MOVEQ	#0,D2
	MOVE.W	$0012(A2),D2
	MOVE.W	D2,$000E(A4)
	TST.B	$0241(A6)
	BNE.B	L_9D2
	ADD.W	D3,D2
	MOVE.W	D2,6(A4)
L_9D2	MOVE.L	4(A2),D2
	ADD.L	D2,D2
	MOVE.L	$0058(A4),D4
	LSR.L	#1,D4
	SUB.W	D4,6(A4)
	CMPI.B	#9,$0056(A4)
	BNE.B	L_A0E
	MOVEQ	#0,D3
	MOVE.B	$0057(A4),D3
	LSL.W	#8,D3
	MOVE.L	D3,D4
	LSR.L	#1,D4
	SUB.W	D4,6(A4)
	BPL.B	L_A0A
	MOVE.L	$000A(A4),2(A4)
	MOVE.W	$000E(A4),6(A4)
	BRA.B	L_A18
L_A0A	ADD.L	D3,$0058(A4)
L_A0E	ADD.L	D1,D2
	ADD.L	$0058(A4),D2
	MOVE.L	D2,2(A4)
L_A18	TST.B	D5
	BNE.B	L_A22
	MOVE.B	1(A2),$0014(A4)
L_A22	MOVEQ	#0,D0
	MOVE.B	(A0),D0
	ANDI.B	#$003F,D0
	BNE.B	L_A3E
	MOVE.B	1(A4),D0
	BEQ.W	L_B4E
	CMPI.W	#$003C,D0
	BGT.W	L_B4E
	BRA.B	L_A4E
L_A3E	CLR.B	$005E(A4)
	MOVE.B	D0,1(A4)
	CMPI.W	#$003C,D0
	BGT.W	L_B4E
L_A4E	MOVEA.L	$002C(A6),A3
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVE.B	2(A0),D2
	MOVE.B	1(A0),D3
	ANDI.B	#-$0040,D2
	ANDI.B	#-$0040,D3
	ROL.B	#6,D2
	ROL.B	#4,D3
	OR.B	D2,D3
	LEA	(A3,D3.L),A3
	MOVEQ	#0,D2
	MOVE.B	2(A2),D2
	ADD.W	D2,D2
	MOVE.W	(A5,D2.L),D2
	SUBQ.B	#1,D0
	ADD.W	D0,D0
	ADD.W	D0,D2
	CMPI.B	#$001B,$0056(A4)
	BEQ.W	L_AA6
	CMPI.B	#$001C,$0056(A4)
	BEQ.W	L_AA6
	CMPI.B	#5,$0056(A4)
	BEQ.B	L_AA6
	CMPI.B	#3,$0056(A4)
	BNE.B	L_ACA
L_AA6	MOVE.B	(A0),D0
	ANDI.B	#$003F,D0
	BEQ.B	L_ACA
	MOVE.B	#1,$005E(A4)
	LEA	L_13D0(PC),A1
	MOVE.W	(A1,D2.L),D1
	MOVE.W	$001C(A4),D0
	ADD.W	$001E(A4),D0
	SUB.W	D1,D0
	MOVE.W	D0,$001E(A4)
L_ACA	LEA	$0022(A4),A1
	CMPI.W	#-1,2(A1)
	BNE.B	L_ADE
	CLR.W	$0020(A4)
	CLR.B	$0033(A4)
L_ADE	TST.B	$0056(A4)
	BNE.B	L_B0E
	TST.B	$0057(A4)
	BEQ.B	L_B0E
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	$0057(A4),D0
	MOVE.B	D0,D1
	ANDI.B	#-$0010,D0
	ANDI.B	#$000F,D1
	LSR.B	#4,D0
	ADD.W	D0,D0
	ADD.W	D1,D1
	MOVE.W	D2,(A1)+
	ADD.W	D2,D0
	ADD.W	D2,D1
	MOVE.W	D0,(A1)+
	MOVE.W	D1,(A1)+
	BRA.B	L_B4A
L_B0E	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	(A3)+,D0
	MOVE.B	D0,D1
	LSR.B	#4,D0
	BEQ.B	L_B50
	ANDI.B	#$000F,D1
	ADD.W	D1,D1
	ADD.W	D2,D1
	MOVE.W	D1,(A1)+
	SUBQ.B	#1,D0
	BEQ.B	L_B4A
L_B28	MOVEQ	#0,D1
	MOVEQ	#0,D3
	MOVE.B	(A3)+,D1
	MOVE.B	D1,D3
	LSR.B	#4,D1
	ANDI.B	#$000F,D3
	ADD.W	D1,D1
	ADD.W	D3,D3
	ADD.W	D2,D1
	MOVE.W	D1,(A1)+
	SUBQ.B	#1,D0
	BEQ.B	L_B4A
	ADD.W	D2,D3
	MOVE.W	D3,(A1)+
	SUBQ.B	#1,D0
	BNE.B	L_B28
L_B4A	MOVE.W	#-1,(A1)
L_B4E	RTS	
L_B50	CLR.W	$0020(A4)
	MOVE.B	$0032(A4),$0033(A4)
	SUBQ.B	#1,$0033(A4)
	MOVE.W	D2,(A1)+
	BRA.B	L_B4A
L_B62	CMPI.B	#$0011,$0056(A4)
	BNE.B	L_B74
	MOVE.B	$0057(A4),D3
	BTST	#0,D3
	BNE.B	L_B96
L_B74	MOVE.B	$001C(A2),$0050(A4)
	MOVE.B	$001D(A2),D0
	BEQ.B	L_B98
	MOVE.B	D0,$004C(A4)
	MOVE.B	$001F(A2),$004D(A4)
	MOVE.B	$001E(A2),$004E(A4)
	MOVE.B	#1,$004F(A4)
L_B96	RTS	
L_B98	MOVE.B	#$007F,$0050(A4)
	CLR.B	$004F(A4)
	RTS	
L_BA4	CLR.B	$0053(A4)
	TST.B	0(A4)
	BNE.W	L_CB0
	TST.B	$0016(A4)
	BEQ.W	L_C58
	TST.L	2(A4)
	BEQ.W	L_CB0
	TST.B	$0052(A4)
	BNE.W	L_C58
	ADDQ.B	#1,$0048(A4)
	MOVE.B	$0049(A4),D0
	CMP.B	$0048(A4),D0
	BGT.W	L_C58
	CLR.B	$0048(A4)
	MOVE.L	$0044(A4),D0
	ADD.L	D0,$0034(A4)
	TST.L	D0
	BPL.B	L_BF4
	MOVE.L	$003C(A4),D0
	CMP.L	$0034(A4),D0
	BLE.B	L_C4C
	BRA.B	L_BFE
L_BF4	MOVE.L	$0038(A4),D0
	CMP.L	$0034(A4),D0
	BGT.B	L_C4C
L_BFE	TST.B	$004A(A4)
	BEQ.B	L_C22
	CMPI.B	#1,$004A(A4)
	BEQ.B	L_C30
	MOVE.L	$0040(A4),$0038(A4)
	MOVE.L	$0044(A4),D0
	SUB.L	D0,$0034(A4)
	NEG.L	D0
	MOVE.L	D0,$0044(A4)
	BRA.B	L_C4C
L_C22	MOVE.L	$003C(A4),$0034(A4)
	MOVE.L	$0040(A4),$0038(A4)
	BRA.B	L_C4C
L_C30	MOVE.L	$0040(A4),$0034(A4)
	MOVE.L	$0044(A4),D0
	BMI.B	L_C44
	NEG.L	D0
	TST.B	$0052(A4)
	BNE.B	L_C4C
L_C44	ADD.L	D0,$0034(A4)
	MOVE.L	D0,$0044(A4)
L_C4C	MOVE.B	#1,0(A4)
	MOVE.L	$0034(A4),$000A(A4)
L_C58	TST.B	$004F(A4)
	BEQ.B	L_C92
	MOVEQ	#0,D0
	MOVE.B	$0050(A4),D0
	CMPI.B	#1,$004F(A4)
	BNE.B	L_C7C
	ADD.B	$004C(A4),D0
	BPL.B	L_C8E
	MOVEQ	#$007F,D0
	MOVE.B	#2,$004F(A4)
	BRA.B	L_C8E
L_C7C	SUB.B	$004D(A4),D0
	CMP.B	$004E(A4),D0
	BGT.B	L_C8E
	MOVE.B	$004E(A4),D0
	CLR.B	$004F(A4)
L_C8E	MOVE.B	D0,$0050(A4)
L_C92	CMPI.B	#$0021,$0051(A4)
	BEQ.B	L_CB0
	CMPI.W	#-1,$001A(A4)
	BNE.W	L_CAC
	MOVE.B	#1,$0051(A4)
	BRA.B	L_CB0
L_CAC	SUBQ.W	#1,$001A(A4)
L_CB0	CMPI.B	#1,$0051(A4)
	BNE.B	L_CBC
	BRA.W	L_E66
L_CBC	RTS	
L_CBE	TST.B	$0054(A4)
	BNE.B	L_CCA
	MOVE.B	#$0021,$0051(A4)
L_CCA	ADDQ.B	#1,$0033(A4)
	MOVE.B	$0032(A4),D0
	CMP.B	$0033(A4),D0
	BGT.B	L_D08
	CLR.B	$0033(A4)
L_CDC	MOVE.W	$0020(A4),D1
	LEA	$0022(A4),A3
	MOVEQ	#0,D7
	MOVE.W	(A3,D1.W),D7
	BPL.B	L_CF2
	CLR.W	$0020(A4)
	BRA.B	L_CDC
L_CF2	LEA	L_13D0(PC),A3
	MOVE.W	(A3,D7.L),D0
	MOVE.W	D0,$001C(A4)
	ADDQ.B	#2,$0021(A4)
	ANDI.B	#$000F,$0021(A4)
L_D08	LEA	L_BA4(PC),A2
	MOVE.L	A2,-(A7)
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	$0057(A4),D1
	MOVE.B	$0056(A4),D0
	BEQ.W	L_DFC
	TST.B	$0021(A6)
	BEQ.B	L_D5C
	CMPI.B	#1,D0
	BEQ.W	L_DFE
	CMPI.B	#2,D0
	BEQ.W	L_E04
	CMPI.B	#3,D0
	BEQ.W	L_E0A
	CMPI.B	#4,D0
	BEQ.W	L_E3C
	CMPI.B	#5,D0
	BEQ.W	L_EDE
	CMPI.B	#6,D0
	BEQ.W	L_EEA
	CMPI.B	#$000A,D0
	BEQ.W	L_EF6
L_D5C	CMPI.B	#$000B,D0
	BEQ.W	L_F24
	CMPI.B	#$000C,D0
	BEQ.W	L_F32
	CMPI.B	#$000D,D0
	BEQ.W	L_F38
	CMPI.B	#$000E,D0
	BEQ.W	L_FAA
	CMPI.B	#$000F,D0
	BEQ.W	L_F5C
	CMPI.B	#$0010,D0
	BEQ.W	L_10B8
	CMPI.B	#$0012,D0
	BEQ.W	L_10D6
	CMPI.B	#$0013,D0
	BEQ.W	L_10E4
	CMPI.B	#$0014,D0
	BEQ.W	L_10F0
	CMPI.B	#$0015,D0
	BEQ.W	L_10FC
	CMPI.B	#$0016,D0
	BEQ.W	L_113A
	CMPI.B	#$0017,D0
	BEQ.W	L_1168
	CMPI.B	#$0018,D0
	BEQ.W	L_116E
	CMPI.B	#$0019,D0
	BEQ.W	L_1174
	CMPI.B	#$001A,D0
	BEQ.W	L_1192
	CMPI.B	#$001B,D0
	BEQ.W	L_11A6
	CMPI.B	#$001C,D0
	BEQ.W	L_11B2
	CMPI.B	#$001D,D0
	BEQ.W	L_11BE
	CMPI.B	#$001E,D0
	BEQ.W	L_11C4
	CMPI.B	#$0021,D0
	BEQ.W	L_11D6
L_DFC	RTS	
L_DFE	SUB.W	D1,$001E(A4)
	RTS	
L_E04	ADD.W	D1,$001E(A4)
	RTS	
L_E0A	TST.B	D1
	BEQ.B	L_E12
	MOVE.B	D1,$005C(A4)
L_E12	TST.B	$005E(A4)
	BEQ.B	L_E3A
	MOVE.B	$005C(A4),D1
	TST.W	$001E(A4)
	BEQ.B	L_DFC
	BPL.B	L_E30
	ADD.W	D1,$001E(A4)
	BMI.B	L_DFC
	CLR.W	$001E(A4)
	RTS	
L_E30	SUB.W	D1,$001E(A4)
	BPL.B	L_DFC
	CLR.W	$001E(A4)
L_E3A	RTS	
L_E3C	MOVE.B	#1,$0051(A4)
L_E42	TST.B	D1
	BEQ.B	L_E64
	MOVE.B	D1,D2
	ANDI.B	#-$0010,D1
	LSR.B	#4,D1
	BEQ.B	L_E54
	MOVE.B	D1,$0017(A4)
L_E54	ANDI.B	#$000F,D2
	BEQ.B	L_E64
	ANDI.B	#-$0010,$0018(A4)
	OR.B	D2,$0018(A4)
L_E64	RTS	
L_E66	TST.B	$0053(A4)
	BNE.B	L_EDC
	MOVE.B	#1,$0053(A4)
	MOVEQ	#0,D2
	MOVE.B	$0018(A4),D2
	ANDI.B	#$0060,D2
	BEQ.B	L_E90
	CMPI.B	#$0020,D2
	BEQ.B	L_E8A
	LEA	L_1B90(PC),A2
	BRA.B	L_E94
L_E8A	LEA	L_1B70(PC),A2
	BRA.B	L_E94
L_E90	LEA	L_1B50(PC),A2
L_E94	MOVE.B	$0019(A4),D2
	MOVEQ	#0,D0
	MOVE.B	(A2,D2.W),D2
	MOVE.B	$0018(A4),D0
	ANDI.B	#$000F,D0
	MULU	D0,D2
	LSR.W	#7,D2
	MOVE.W	$001C(A4),D0
	BTST	#7,$0018(A4)
	BEQ.B	L_EBA
	SUB.W	D2,D0
	BRA.B	L_EBC
L_EBA	ADD.W	D2,D0
L_EBC	MOVE.W	D0,$001C(A4)
	MOVE.B	$0017(A4),D0
	ADD.B	D0,$0019(A4)
	BTST	#5,$0019(A4)
	BEQ.B	L_EDC
	ANDI.B	#$001F,$0019(A4)
	BCHG	#7,$0018(A4)
L_EDC	RTS	
L_EDE	MOVE.W	D1,-(A7)
	MOVEQ	#0,D1
	BSR.W	L_E12
	MOVE.W	(A7)+,D1
	BRA.B	L_EF6
L_EEA	MOVE.W	D1,-(A7)
	BSR.W	L_E66
	MOVE.W	(A7)+,D1
	BRA.W	L_EF6
L_EF6	MOVE.B	D1,D2
	ANDI.B	#$000F,D1
	ANDI.B	#-$0010,D2
	LSR.B	#4,D2
	TST.B	D2
	BNE.B	L_F10
	SUB.B	D1,$0014(A4)
	BPL.B	L_F10
	CLR.B	$0014(A4)
L_F10	ADD.B	D2,$0014(A4)
	CMPI.B	#$0040,$0014(A4)
	BLS.B	L_F22
	MOVE.B	#$0040,$0014(A4)
L_F22	RTS	
L_F24	SUBQ.B	#1,D1
	MOVE.B	D1,$0027(A6)
	MOVE.W	#-$0100,$0022(A6)
	RTS	
L_F32	MOVE.B	D1,$0014(A4)
	RTS	
L_F38	MOVE.B	D1,D0
	ANDI.B	#$000F,D1
	ANDI.B	#-$0010,D0
	LSR.B	#1,D0
	MOVE.B	D0,D2
	LSR.B	#3,D2
	ADD.B	D2,D0
	ADD.B	D2,D0
	ADD.B	D1,D0
	ADD.B	D0,D0
	ADD.B	D0,D0
	ORI.W	#-$0100,D0
	MOVE.W	D0,$0022(A6)
	RTS	
L_F5C	TST.B	D1
	BEQ.B	L_F8E
	CMPI.B	#$0020,D1
	BHI.B	L_F6C
	MOVE.B	D1,$0020(A6)
L_F6A	RTS	
L_F6C	CMPI.B	#-$0038,D1
	BHI.B	L_F6A
	MOVE.L	#$0009052D,D0
	DIVU	D1,D0
	MOVE.B	D1,$023F(A6)
	MOVE.B	D0,$00BFD600.L
	LSR.W	#8,D0
	MOVE.B	D0,$00BFD700.L
	RTS	
L_F8E	CLR.B	$0020(A6)
L_F92	MOVE.B	#$007D,$023F(A6)
	MOVE.B	#$0079,$00BFD600.L
	MOVE.B	#$0012,$00BFD700.L
	RTS	
L_FAA	MOVE.B	D1,D0
	ANDI.B	#$000F,D1
	ANDI.B	#-$0010,D0
	BEQ.B	L_1002
	CMPI.B	#$0010,D0
	BEQ.B	L_101A
	CMPI.B	#$0020,D0
	BEQ.B	L_1026
	CMPI.B	#$0040,D0
	BEQ.B	L_1032
	CMPI.B	#$0050,D0
	BEQ.W	L_1044
	CMPI.B	#$0060,D0
	BEQ.W	L_105A
	CMPI.B	#-$0070,D0
	BEQ.W	L_1060
	CMPI.B	#-$0060,D0
	BEQ.W	L_107A
	CMPI.B	#-$0050,D0
	BEQ.W	L_1094
	CMPI.B	#-$0040,D0
	BEQ.W	L_10A6
	CMPI.B	#-$0030,D0
	BEQ.W	L_1060
	RTS	
L_1002	TST.B	D1
	BEQ.B	L_1010
	BSET	#1,$00BFE001.L
	RTS	
L_1010	BCLR	#1,$00BFE001.L
	RTS	
L_101A	TST.B	$0021(A6)
	BNE.B	L_1024
	SUB.W	D1,$001E(A4)
L_1024	RTS	
L_1026	TST.B	$0021(A6)
	BNE.B	L_1030
	ADD.W	D1,$001E(A4)
L_1030	RTS	
L_1032	ANDI.B	#3,D1
	ROR.B	#3,D1
	ANDI.B	#-$0061,$0018(A4)
	OR.B	D1,$0018(A4)
	RTS	
L_1044	MOVE.B	$0023(A6),D0
	SUBQ.B	#4,D0
	CMP.B	$0024(A6),D0
	BEQ.B	L_1058
	MOVE.B	D0,$0024(A6)
	CLR.B	$0025(A6)
L_1058	RTS	
L_105A	TST.B	D1
	BEQ.B	L_1044
	RTS	
L_1060	TST.B	$0015(A4)
	BNE.B	L_1074
	MOVE.B	#3,0(A4)
	MOVE.B	#-$0011,$0056(A4)
	RTS	
L_1074	SUBQ.B	#1,$0015(A4)
	RTS	
L_107A	TST.B	$0021(A6)
	BNE.B	L_1092
	ADD.B	D1,$0014(A4)
	CMPI.B	#$0040,$0014(A4)
	BLE.B	L_1092
	MOVE.B	#$0040,$0014(A4)
L_1092	RTS	
L_1094	TST.B	$0021(A6)
	BNE.B	L_10A4
	SUB.B	D1,$0014(A4)
	BPL.B	L_10A4
	CLR.B	$0014(A4)
L_10A4	RTS	
L_10A6	TST.B	$0015(A4)
	BNE.B	L_10B2
	CLR.B	$0014(A4)
	RTS	
L_10B2	SUBQ.B	#1,$0015(A4)
	RTS	
L_10B8	TST.B	$0015(A4)
	BNE.B	L_10D0
	ANDI.B	#-$0010,D1
	LSR.B	#4,D1
	ADD.B	D1,D1
	ADD.B	D1,D1
	ADDQ.B	#4,D1
	MOVE.B	D1,$0014(A4)
	RTS	
L_10D0	SUBQ.B	#1,$0015(A4)
	RTS	
L_10D6	MOVE.B	D1,D2
	ANDI.B	#-$0010,D1
	LSR.B	#4,D1
	MOVE.B	D1,$0049(A4)
	RTS	
L_10E4	ANDI.B	#$000F,D1
	BEQ.B	L_10EE
	MOVE.B	D1,$0032(A4)
L_10EE	RTS	
L_10F0	MOVE.W	D1,-(A7)
	BSR.W	L_E66
	MOVE.W	(A7)+,D1
	BRA.W	L_F32
L_10FC	LEA	L_112A(PC),A0
	MOVE.W	D1,D2
	LSR.B	#4,D1
	ANDI.B	#$000F,D2
	MOVE.B	(A0,D1.W),D1
	BPL.B	L_1116
	NEG.B	D1
	BSR.W	L_1094
	BRA.B	L_111A
L_1116	BSR.W	L_107A
L_111A	TST.B	$0021(A6)
	BEQ.B	L_1128
	MOVEQ	#0,D1
	MOVE.B	D2,D1
	BSR.W	L_DFE
L_1128	RTS	
L_112A	ORI.B	#3,D1
	SUBI.B	#7,D5
	DC.W	-$707
	DC.B	-6
	DC.B	-5
	DC.B	-4
	DC.B	-3
	DC.B	-2
	DC.B	-1
L_113A	LEA	L_112A(PC),A0
	MOVE.W	D1,D2
	LSR.B	#4,D1
	ANDI.B	#$000F,D2
	MOVE.B	(A0,D1.W),D1
	BPL.B	L_1154
	NEG.B	D1
	BSR.W	L_1094
	BRA.B	L_1158
L_1154	BSR.W	L_107A
L_1158	TST.B	$0021(A6)
	BEQ.B	L_1166
	MOVEQ	#0,D1
	MOVE.B	D2,D1
	BSR.W	L_E04
L_1166	RTS	
L_1168	MOVE.B	D1,$0240(A6)
	RTS	
L_116E	MOVE.B	D1,$0241(A6)
	RTS	
L_1174	MOVE.W	D1,-(A7)
	BSR.W	L_E66
	MOVE.W	(A7)+,D1
L_117C	MOVEQ	#0,D2
	MOVE.B	D1,D2
	LSR.B	#4,D2
	BEQ.B	L_118A
	MOVE.W	D2,D1
	BRA.W	L_107A
L_118A	ANDI.B	#$000F,D1
	BRA.W	L_1094
L_1192	MOVE.W	D1,D2
	LSR.W	#4,D1
	LSL.W	#3,D1
	BSR.W	L_E04
	MOVE.W	D2,D1
	ANDI.W	#$000F,D1
	BRA.W	L_EF6
L_11A6	MOVE.W	D1,-(A7)
	BSR.W	L_E12
	MOVE.W	(A7)+,D1
	BRA.W	L_F32
L_11B2	MOVE.W	D1,-(A7)
	BSR.W	L_E12
	MOVE.W	(A7)+,D1
	BRA.W	L_117C
L_11BE	MOVE.W	D1,$0060(A4)
	RTS	
L_11C4	MOVE.B	D1,D2
	ANDI.B	#$000F,D1
	MOVE.B	D1,$004B(A4)
	LSR.B	#4,D2
	MOVE.B	D2,$0052(A4)
	RTS	
L_11D6	TST.B	$0021(A6)
	BEQ.B	L_11DE
	RTS	
L_11DE	LEA	L_12AA(PC),A0
	MOVE.B	D1,(A0)
	RTS	
	TST.B	$0021(A6)
	BEQ.B	L_11EE
	RTS	
L_11EE	LEA	L_12AB(PC),A0
	MOVE.B	D1,(A0)
	RTS	
	TST.B	$0021(A6)
	BEQ.B	L_11FE
	RTS	
L_11FE	LEA	L_12AC(PC),A0
	MOVE.B	D1,(A0)
	RTS	
	MOVE.W	$0056(A4),D0
	ANDI.W	#$0FF0,D0
	CMPI.W	#$0ED0,D0
	BEQ.W	L_1280
	BTST	#1,0(A4)
	BEQ.B	L_123C
	TST.B	$0240(A6)
	BEQ.B	L_123A
	CMPI.W	#$00FF,8(A4)
	BHI.B	L_123A
	TST.W	8(A4)
	BEQ.B	L_123A
	CMPI.W	#$00FF,6(A4)
	BLE.B	L_123C
L_123A	BSET	D7,D1
L_123C	MOVE.W	$001C(A4),D0
	ADD.W	$001E(A4),D0
	CMPI.W	#$0067,D0
	BCC.B	L_124C
	MOVEQ	#$0067,D0
L_124C	MOVE.W	D0,6(A5)
	MOVEQ	#0,D0
	MOVE.B	$0014(A4),D0
	MOVEQ	#0,D2
	MOVE.B	$0050(A4),D2
	LSR.B	#1,D2
	MULU	D2,D0
	LSR.W	#6,D0
	MULU	$0060(A4),D0
	LSR.W	#6,D0
	MOVE.B	D0,9(A5)
	BTST	#1,0(A4)
	BEQ.B	L_1280
	MOVE.L	2(A4),0(A5)
	MOVE.W	6(A4),4(A5)
L_1280	ADDQ.B	#1,D7
	LEA	$0062(A4),A4
	LEA	$0010(A5),A5
	RTS	
L_128C	MOVE.W	$0056(A4),D0
	ANDI.W	#$0FF0,D0
	CMPI.W	#$0ED0,D0
	BEQ.B	L_1280
	MOVE.L	$000A(A4),(A5)
	MOVE.W	$000E(A4),4(A5)
	CLR.B	0(A4)
	BRA.B	L_1280
L_12AA	DC.B	0
L_12AB	DC.B	0
L_12AC	DC.W	0
L_12AE	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.B	'@@'
L_13B0	DC.B	0
	DC.B	0
	DC.W	$78
	DC.W	$F0
	DC.W	$168
	DC.W	$1E0
	DC.W	$258
	DC.W	$2D0
	DC.W	$348
	DC.W	$3C0
	DC.W	$438
	DC.W	$4B0
	DC.W	$528
	DC.W	$5A0
	DC.W	$618
	DC.W	$690
	DC.W	$708
L_13D0	DC.W	$D60
	DC.W	$CA0
	DC.W	$BE8
	DC.W	$B40
	DC.W	$A98
	DC.W	$A00
	DC.W	$970
	DC.W	$8E8
	DC.W	$868
	DC.W	$7F0
	DC.W	$780
	DC.W	$714
	DC.W	$6B0
	DC.W	$650
	DC.W	$5F4
	DC.W	$5A0
	DC.W	$54C
	DC.W	$500
	DC.W	$4B8
	DC.W	$474
	DC.W	$434
	DC.W	$3F8
	DC.W	$3C0
	DC.W	$38A
	DC.W	$358
	DC.W	$328
	DC.W	$2FA
	DC.W	$2D0
	DC.W	$2A6
	DC.W	$280
	DC.W	$25C
	DC.W	$23A
	DC.W	$21A
	DC.W	$1FC
	DC.W	$1E0
	DC.W	$1C5
	DC.W	$1AC
	DC.W	$194
	DC.W	$17D
	DC.W	$168
	DC.W	$153
	DC.W	$140
	DC.W	$12E
	DC.W	$11D
	DC.W	$10D
	DC.W	$FE
	DC.W	$F0
	DC.W	$E2
	DC.W	$D6
	DC.W	$CA
	DC.W	$BE
	DC.W	$B4
	DC.W	$AA
	DC.W	$A0
	DC.W	$97
	DC.W	$8F
	DC.W	$87
	DC.W	$7F
	DC.W	$78
	DC.W	$71
	DC.W	$D48
	DC.W	$C88
	DC.W	$BD4
	DC.W	$B2C
	DC.W	$A88
	DC.W	$9F4
	DC.W	$964
	DC.W	$8DC
	DC.W	$85C
	DC.W	$7E4
	DC.W	$774
	DC.W	$708
	DC.W	$6A4
	DC.W	$644
	DC.W	$5EA
	DC.W	$596
	DC.W	$544
	DC.W	$4FA
	DC.W	$4B2
	DC.W	$46E
	DC.W	$42E
	DC.W	$3F2
	DC.W	$3BA
	DC.W	$384
	DC.W	$352
	DC.W	$322
	DC.W	$2F5
	DC.W	$2CB
	DC.W	$2A2
	DC.W	$27D
	DC.W	$259
	DC.W	$237
	DC.W	$217
	DC.W	$1F9
	DC.W	$1DD
	DC.W	$1C2
	DC.W	$1A9
	DC.W	$191
	DC.W	$17B
	DC.W	$165
	DC.W	$151
	DC.W	$13E
	DC.W	$12C
	DC.W	$11C
	DC.W	$10C
	DC.W	$FD
	DC.W	$EF
	DC.W	$E1
	DC.W	$D5
	DC.W	$C9
	DC.W	$BD
	DC.W	$B3
	DC.W	$A9
	DC.W	$9F
	DC.W	$96
	DC.W	$8E
	DC.W	$86
	DC.W	$7E
	DC.W	$77
	DC.W	$71
	DC.W	$D30
	DC.W	$C70
	DC.W	$BC0
	DC.W	$B14
	DC.W	$A78
	DC.W	$9E0
	DC.W	$954
	DC.W	$8CC
	DC.W	$850
	DC.W	$7D8
	DC.W	$768
	DC.W	$6FC
	DC.W	$698
	DC.W	$638
	DC.W	$5E0
	DC.W	$58A
	DC.W	$53C
	DC.W	$4F0
	DC.W	$4AA
	DC.W	$466
	DC.W	$428
	DC.W	$3EC
	DC.W	$3B4
	DC.W	$37E
	DC.W	$34C
	DC.W	$31C
	DC.W	$2F0
	DC.W	$2C5
	DC.W	$29E
	DC.W	$278
	DC.W	$255
	DC.W	$233
	DC.W	$214
	DC.W	$1F6
	DC.W	$1DA
	DC.W	$1BF
	DC.W	$1A6
	DC.W	$18E
	DC.W	$178
	DC.W	$163
	DC.W	$14F
	DC.W	$13C
	DC.W	$12A
	DC.W	$11A
	DC.W	$10A
	DC.W	$FB
	DC.W	$ED
	DC.W	$E0
	DC.W	$D3
	DC.W	$C7
	DC.W	$BC
	DC.W	$B1
	DC.W	$A7
	DC.W	$9E
	DC.W	$95
	DC.W	$8D
	DC.W	$85
	DC.W	$7D
	DC.W	$76
	DC.W	$70
	DC.W	$D18
	DC.W	$C5C
	DC.W	$BA8
	DC.W	$B00
	DC.W	$A64
	DC.W	$9D0
	DC.W	$940
	DC.W	$8BC
	DC.W	$840
	DC.W	$7C8
	DC.W	$758
	DC.W	$6F0
	DC.W	$68C
	DC.W	$62E
	DC.W	$5D4
	DC.W	$580
	DC.W	$532
	DC.W	$4E8
	DC.W	$4A0
	DC.W	$45E
	DC.W	$420
	DC.W	$3E4
	DC.W	$3AC
	DC.W	$378
	DC.W	$346
	DC.W	$317
	DC.W	$2EA
	DC.W	$2C0
	DC.W	$299
	DC.W	$274
	DC.W	$250
	DC.W	$22F
	DC.W	$210
	DC.W	$1F2
	DC.W	$1D6
	DC.W	$1BC
	DC.W	$1A3
	DC.W	$18B
	DC.W	$175
	DC.W	$160
	DC.W	$14C
	DC.W	$13A
	DC.W	$128
	DC.W	$118
	DC.W	$108
	DC.W	$F9
	DC.W	$EB
	DC.W	$DE
	DC.W	$D1
	DC.W	$C6
	DC.W	$BB
	DC.W	$B0
	DC.W	$A6
	DC.W	$9D
	DC.W	$94
	DC.W	$8C
	DC.W	$84
	DC.W	$7D
	DC.W	$76
	DC.W	$6F
	DC.W	$D00
	DC.W	$C44
	DC.W	$B94
	DC.W	$AEC
	DC.W	$A50
	DC.W	$9BC
	DC.W	$930
	DC.W	$8AC
	DC.W	$830
	DC.W	$7BC
	DC.W	$74C
	DC.W	$6E4
	DC.W	$680
	DC.W	$622
	DC.W	$5CA
	DC.W	$576
	DC.W	$528
	DC.W	$4DE
	DC.W	$498
	DC.W	$456
	DC.W	$418
	DC.W	$3DE
	DC.W	$3A6
	DC.W	$372
	DC.W	$340
	DC.W	$311
	DC.W	$2E5
	DC.W	$2BB
	DC.W	$294
	DC.W	$26F
	DC.W	$24C
	DC.W	$22B
	DC.W	$20C
	DC.W	$1EF
	DC.W	$1D3
	DC.W	$1B9
	DC.W	$1A0
	DC.W	$188
	DC.W	$172
	DC.W	$15E
	DC.W	$14A
	DC.W	$138
	DC.W	$126
	DC.W	$116
	DC.W	$106
	DC.W	$F7
	DC.W	$E9
	DC.W	$DC
	DC.W	$D0
	DC.W	$C4
	DC.W	$B9
	DC.W	$AF
	DC.W	$A5
	DC.W	$9C
	DC.W	$93
	DC.W	$8B
	DC.W	$83
	DC.W	$7C
	DC.W	$75
	DC.W	$6E
	DC.W	$CE8
	DC.W	$C2C
	DC.W	$B80
	DC.W	$AD8
	DC.W	$A3C
	DC.W	$9AC
	DC.W	$920
	DC.W	$89C
	DC.W	$820
	DC.W	$7AC
	DC.W	$73C
	DC.W	$6D4
	DC.W	$674
	DC.W	$616
	DC.W	$5C0
	DC.W	$56C
	DC.W	$51E
	DC.W	$4D6
	DC.W	$490
	DC.W	$44E
	DC.W	$410
	DC.W	$3D6
	DC.W	$39E
	DC.W	$36A
	DC.W	$33A
	DC.W	$30B
	DC.W	$2E0
	DC.W	$2B6
	DC.W	$28F
	DC.W	$26B
	DC.W	$248
	DC.W	$227
	DC.W	$208
	DC.W	$1EB
	DC.W	$1CF
	DC.W	$1B5
	DC.W	$19D
	DC.W	$186
	DC.W	$170
	DC.W	$15B
	DC.W	$148
	DC.W	$135
	DC.W	$124
	DC.W	$114
	DC.W	$104
	DC.W	$F5
	DC.W	$E8
	DC.W	$DB
	DC.W	$CE
	DC.W	$C3
	DC.W	$B8
	DC.W	$AE
	DC.W	$A4
	DC.W	$9B
	DC.W	$92
	DC.W	$8A
	DC.W	$82
	DC.W	$7B
	DC.W	$74
	DC.W	$6D
	DC.W	$CD0
	DC.W	$C18
	DC.W	$B68
	DC.W	$AC4
	DC.W	$A2C
	DC.W	$998
	DC.W	$910
	DC.W	$88C
	DC.W	$810
	DC.W	$79C
	DC.W	$730
	DC.W	$6C8
	DC.W	$668
	DC.W	$60C
	DC.W	$5B4
	DC.W	$562
	DC.W	$516
	DC.W	$4CC
	DC.W	$488
	DC.W	$446
	DC.W	$408
	DC.W	$3CE
	DC.W	$398
	DC.W	$364
	DC.W	$334
	DC.W	$306
	DC.W	$2DA
	DC.W	$2B1
	DC.W	$28B
	DC.W	$266
	DC.W	$244
	DC.W	$223
	DC.W	$204
	DC.W	$1E7
	DC.W	$1CC
	DC.W	$1B2
	DC.W	$19A
	DC.W	$183
	DC.W	$16D
	DC.W	$159
	DC.W	$145
	DC.W	$133
	DC.W	$122
	DC.W	$112
	DC.W	$102
	DC.W	$F4
	DC.W	$E6
	DC.W	$D9
	DC.W	$CD
	DC.W	$C1
	DC.W	$B7
	DC.W	$AC
	DC.W	$A3
	DC.W	$9A
	DC.W	$91
	DC.W	$89
	DC.W	$81
	DC.W	$7A
	DC.W	$73
	DC.W	$6D
	DC.W	$CB8
	DC.W	$C00
	DC.W	$B54
	DC.W	$AB0
	DC.W	$A18
	DC.W	$988
	DC.W	$8FC
	DC.W	$87C
	DC.W	$804
	DC.W	$790
	DC.W	$724
	DC.W	$6BC
	DC.W	$65C
	DC.W	$600
	DC.W	$5AA
	DC.W	$558
	DC.W	$50C
	DC.W	$4C4
	DC.W	$47E
	DC.W	$43E
	DC.W	$402
	DC.W	$3C8
	DC.W	$392
	DC.W	$35E
	DC.W	$32E
	DC.W	$300
	DC.W	$2D5
	DC.W	$2AC
	DC.W	$286
	DC.W	$262
	DC.W	$23F
	DC.W	$21F
	DC.W	$201
	DC.W	$1E4
	DC.W	$1C9
	DC.W	$1AF
	DC.W	$197
	DC.W	$180
	DC.W	$16B
	DC.W	$156
	DC.W	$143
	DC.W	$131
	DC.W	$120
	DC.W	$110
	DC.W	$100
	DC.W	$F2
	DC.W	$E4
	DC.W	$D8
	DC.W	$CC
	DC.W	$C0
	DC.W	$B5
	DC.W	$AB
	DC.W	$A1
	DC.W	$98
	DC.W	$90
	DC.W	$88
	DC.W	$80
	DC.W	$79
	DC.W	$72
	DC.W	$6C
	DC.W	$E2C
	DC.W	$D60
	DC.W	$CA0
	DC.W	$BE8
	DC.W	$B40
	DC.W	$A98
	DC.W	$A00
	DC.W	$970
	DC.W	$8E8
	DC.W	$868
	DC.W	$7F0
	DC.W	$780
	DC.W	$716
	DC.W	$6B0
	DC.W	$650
	DC.W	$5F4
	DC.W	$5A0
	DC.W	$54C
	DC.W	$500
	DC.W	$4B8
	DC.W	$474
	DC.W	$434
	DC.W	$3F8
	DC.W	$3C0
	DC.W	$38B
	DC.W	$358
	DC.W	$328
	DC.W	$2FA
	DC.W	$2D0
	DC.W	$2A6
	DC.W	$280
	DC.W	$25C
	DC.W	$23A
	DC.W	$21A
	DC.W	$1FC
	DC.W	$1E0
	DC.W	$1C5
	DC.W	$1AC
	DC.W	$194
	DC.W	$17D
	DC.W	$168
	DC.W	$153
	DC.W	$140
	DC.W	$12E
	DC.W	$11D
	DC.W	$10D
	DC.W	$FE
	DC.W	$F0
	DC.W	$E2
	DC.W	$D6
	DC.W	$CA
	DC.W	$BE
	DC.W	$B4
	DC.W	$AA
	DC.W	$A0
	DC.W	$97
	DC.W	$8F
	DC.W	$87
	DC.W	$7F
	DC.W	$78
	DC.W	$E10
	DC.W	$D48
	DC.W	$C88
	DC.W	$BD4
	DC.W	$B2C
	DC.W	$A8C
	DC.W	$9F0
	DC.W	$964
	DC.W	$8DC
	DC.W	$85C
	DC.W	$7E4
	DC.W	$774
	DC.W	$708
	DC.W	$6A4
	DC.W	$644
	DC.W	$5EA
	DC.W	$596
	DC.W	$546
	DC.W	$4F8
	DC.W	$4B2
	DC.W	$46E
	DC.W	$42E
	DC.W	$3F2
	DC.W	$3BA
	DC.W	$384
	DC.W	$352
	DC.W	$322
	DC.W	$2F5
	DC.W	$2CB
	DC.W	$2A3
	DC.W	$27C
	DC.W	$259
	DC.W	$237
	DC.W	$217
	DC.W	$1F9
	DC.W	$1DD
	DC.W	$1C2
	DC.W	$1A9
	DC.W	$191
	DC.W	$17B
	DC.W	$165
	DC.W	$151
	DC.W	$13E
	DC.W	$12C
	DC.W	$11C
	DC.W	$10C
	DC.W	$FD
	DC.W	$EE
	DC.W	$E1
	DC.W	$D4
	DC.W	$C8
	DC.W	$BD
	DC.W	$B3
	DC.W	$A9
	DC.W	$9F
	DC.W	$96
	DC.W	$8E
	DC.W	$86
	DC.W	$7E
	DC.W	$77
	DC.W	$DF8
	DC.W	$D30
	DC.W	$C70
	DC.W	$BC0
	DC.W	$B14
	DC.W	$A78
	DC.W	$9E0
	DC.W	$954
	DC.W	$8CC
	DC.W	$850
	DC.W	$7D8
	DC.W	$768
	DC.W	$6FC
	DC.W	$698
	DC.W	$638
	DC.W	$5E0
	DC.W	$58A
	DC.W	$53C
	DC.W	$4F0
	DC.W	$4AA
	DC.W	$466
	DC.W	$428
	DC.W	$3EC
	DC.W	$3B4
	DC.W	$37E
	DC.W	$34C
	DC.W	$31C
	DC.W	$2F0
	DC.W	$2C5
	DC.W	$29E
	DC.W	$278
	DC.W	$255
	DC.W	$233
	DC.W	$214
	DC.W	$1F6
	DC.W	$1DA
	DC.W	$1BF
	DC.W	$1A6
	DC.W	$18E
	DC.W	$178
	DC.W	$163
	DC.W	$14F
	DC.W	$13C
	DC.W	$12A
	DC.W	$11A
	DC.W	$10A
	DC.W	$FB
	DC.W	$ED
	DC.W	$DF
	DC.W	$D3
	DC.W	$C7
	DC.W	$BC
	DC.W	$B1
	DC.W	$A7
	DC.W	$9E
	DC.W	$95
	DC.W	$8D
	DC.W	$85
	DC.W	$7D
	DC.W	$76
	DC.W	$DDC
	DC.W	$D18
	DC.W	$C5C
	DC.W	$BA8
	DC.W	$B00
	DC.W	$A64
	DC.W	$9D0
	DC.W	$940
	DC.W	$8BC
	DC.W	$840
	DC.W	$7C8
	DC.W	$758
	DC.W	$6EE
	DC.W	$68C
	DC.W	$62E
	DC.W	$5D4
	DC.W	$580
	DC.W	$532
	DC.W	$4E8
	DC.W	$4A0
	DC.W	$45E
	DC.W	$420
	DC.W	$3E4
	DC.W	$3AC
	DC.W	$377
	DC.W	$346
	DC.W	$317
	DC.W	$2EA
	DC.W	$2C0
	DC.W	$299
	DC.W	$274
	DC.W	$250
	DC.W	$22F
	DC.W	$210
	DC.W	$1F2
	DC.W	$1D6
	DC.W	$1BC
	DC.W	$1A3
	DC.W	$18B
	DC.W	$175
	DC.W	$160
	DC.W	$14C
	DC.W	$13A
	DC.W	$128
	DC.W	$118
	DC.W	$108
	DC.W	$F9
	DC.W	$EB
	DC.W	$DE
	DC.W	$D1
	DC.W	$C6
	DC.W	$BB
	DC.W	$B0
	DC.W	$A6
	DC.W	$9D
	DC.W	$94
	DC.W	$8C
	DC.W	$84
	DC.W	$7D
	DC.W	$76
	DC.W	$DC4
	DC.W	$D00
	DC.W	$C44
	DC.W	$B94
	DC.W	$AEC
	DC.W	$A50
	DC.W	$9BC
	DC.W	$930
	DC.W	$8AC
	DC.W	$830
	DC.W	$7B8
	DC.W	$74C
	DC.W	$6E2
	DC.W	$680
	DC.W	$622
	DC.W	$5CA
	DC.W	$576
	DC.W	$528
	DC.W	$4DE
	DC.W	$498
	DC.W	$456
	DC.W	$418
	DC.W	$3DC
	DC.W	$3A6
	DC.W	$371
	DC.W	$340
	DC.W	$311
	DC.W	$2E5
	DC.W	$2BB
	DC.W	$294
	DC.W	$26F
	DC.W	$24C
	DC.W	$22B
	DC.W	$20C
	DC.W	$1EE
	DC.W	$1D3
	DC.W	$1B9
	DC.W	$1A0
	DC.W	$188
	DC.W	$172
	DC.W	$15E
	DC.W	$14A
	DC.W	$138
	DC.W	$126
	DC.W	$116
	DC.W	$106
	DC.W	$F7
	DC.W	$E9
	DC.W	$DC
	DC.W	$D0
	DC.W	$C4
	DC.W	$B9
	DC.W	$AF
	DC.W	$A5
	DC.W	$9C
	DC.W	$93
	DC.W	$8B
	DC.W	$83
	DC.W	$7B
	DC.W	$75
	DC.W	$DAC
	DC.W	$CE8
	DC.W	$C2C
	DC.W	$B80
	DC.W	$AD8
	DC.W	$A3C
	DC.W	$9AC
	DC.W	$920
	DC.W	$89C
	DC.W	$820
	DC.W	$7AC
	DC.W	$73C
	DC.W	$6D6
	DC.W	$674
	DC.W	$616
	DC.W	$5C0
	DC.W	$56C
	DC.W	$51E
	DC.W	$4D6
	DC.W	$490
	DC.W	$44E
	DC.W	$410
	DC.W	$3D6
	DC.W	$39E
	DC.W	$36B
	DC.W	$33A
	DC.W	$30B
	DC.W	$2E0
	DC.W	$2B6
	DC.W	$28F
	DC.W	$26B
	DC.W	$248
	DC.W	$227
	DC.W	$208
	DC.W	$1EB
	DC.W	$1CF
	DC.W	$1B5
	DC.W	$19D
	DC.W	$186
	DC.W	$170
	DC.W	$15B
	DC.W	$148
	DC.W	$135
	DC.W	$124
	DC.W	$114
	DC.W	$104
	DC.W	$F5
	DC.W	$E8
	DC.W	$DB
	DC.W	$CE
	DC.W	$C3
	DC.W	$B8
	DC.W	$AE
	DC.W	$A4
	DC.W	$9B
	DC.W	$92
	DC.W	$8A
	DC.W	$82
	DC.W	$7B
	DC.W	$74
	DC.W	$D90
	DC.W	$CD0
	DC.W	$C18
	DC.W	$B68
	DC.W	$AC4
	DC.W	$A2C
	DC.W	$998
	DC.W	$910
	DC.W	$88C
	DC.W	$810
	DC.W	$79C
	DC.W	$730
	DC.W	$6C8
	DC.W	$668
	DC.W	$60C
	DC.W	$5B4
	DC.W	$562
	DC.W	$516
	DC.W	$4CC
	DC.W	$488
	DC.W	$446
	DC.W	$408
	DC.W	$3CE
	DC.W	$398
	DC.W	$364
	DC.W	$334
	DC.W	$306
	DC.W	$2DA
	DC.W	$2B1
	DC.W	$28B
	DC.W	$266
	DC.W	$244
	DC.W	$223
	DC.W	$204
	DC.W	$1E7
	DC.W	$1CC
	DC.W	$1B2
	DC.W	$19A
	DC.W	$183
	DC.W	$16D
	DC.W	$159
	DC.W	$145
	DC.W	$133
	DC.W	$122
	DC.W	$112
	DC.W	$102
	DC.W	$F4
	DC.W	$E6
	DC.W	$D9
	DC.W	$CD
	DC.W	$C1
	DC.W	$B7
	DC.W	$AC
	DC.W	$A3
	DC.W	$9A
	DC.W	$91
	DC.W	$89
	DC.W	$81
	DC.W	$7A
	DC.W	$73
	DC.W	$D78
	DC.W	$CB8
	DC.W	$C00
	DC.W	$B54
	DC.W	$AB0
	DC.W	$A18
	DC.W	$988
	DC.W	$8FC
	DC.W	$87C
	DC.W	$804
	DC.W	$790
	DC.W	$724
	DC.W	$6BC
	DC.W	$65C
	DC.W	$600
	DC.W	$5AA
	DC.W	$558
	DC.W	$50C
	DC.W	$4C4
	DC.W	$47E
	DC.W	$43E
	DC.W	$402
	DC.W	$3C8
	DC.W	$392
	DC.W	$35E
	DC.W	$32E
	DC.W	$300
	DC.W	$2D5
	DC.W	$2AC
	DC.W	$286
	DC.W	$262
	DC.W	$23F
	DC.W	$21F
	DC.W	$201
	DC.W	$1E4
	DC.W	$1C9
	DC.W	$1AF
	DC.W	$197
	DC.W	$180
	DC.W	$16B
	DC.W	$156
	DC.W	$143
	DC.W	$131
	DC.W	$120
	DC.W	$110
	DC.W	$100
	DC.W	$F2
	DC.W	$E4
	DC.W	$D8
	DC.W	$CB
	DC.W	$C0
	DC.W	$B5
	DC.W	$AB
	DC.W	$A1
	DC.W	$98
	DC.W	$90
	DC.W	$88
	DC.W	$80
	DC.W	$79
	DC.W	$72
L_1B50	DC.W	$18
	DC.B	'1Jax'
	DC.W	-$725F
	DC.W	-$4B3B
	DC.W	-$2B20
	DC.W	-$140C
	DC.W	-$503
	DC.W	-3
	DC.W	-$50C
	DC.W	-$1420
	DC.W	-$2B3B
	DC.W	-$4B5F
	DC.W	-$7288
	DC.B	'aJ1'
	DC.B	$18
L_1B70	DC.W	-8
	DC.W	-$F18
	DC.W	-$1F28
	DC.W	-$2F38
	DC.W	-$3F48
	DC.W	-$4F58
	DC.W	-$5F68
	DC.W	-$6F78
	DC.W	-$7F88
	DC.B	'ph`XPH@80( '
	DC.B	$18
	DC.W	$1008
L_1B90	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
	DC.W	-1
L_1BB0	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
L_1DF6	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0
	DC.W	0

mod:	dc.l	0

stc_unpackeddata	dc.l	0; adresse des ungepackten stc-files
stc_unpackedlen		dc.l	0; lnge des ungepackten stc-files

