#!/usr/bin/env ruby

require 'optparse'
require 'fileutils'

=begin
:title: Documentao do t2t-make

 = t2tmake.rb (0.8beta)
 Programa para o processamento automatico de arquivos utilizando
 o txt2tags <t2t> (http://txt2tags.org)
 
 == download e instalao
 Existem duas maneiras de baixar este programa:
 - Na rea de arquivos da lista[http://groups.yahoo.com/group/txt2tags-br].
   dos usurios do txt2tags (em portugus)
 - Na pgina[http://txt2tags-win.sourceforge.net/t2tmake.zip] em portugus do txt2tags.

 ===requisitos
 - txt2tags ( claro, sem ele este programa no existiria);
 - ruby 1.6.8+ ( lgico, seno este programa no roda);
 - python 1.5+ (sim, sim, para o txt2tags rodar);
 
 ===instalao: (t2t)
 - txt2tags: verifique o site http://txt2tags.org;
 - python: verifique o site www.python.org;
 
 ===instalao (ruby)
 - Windows:
   Baixe de http://rubyinstaller.sourceforge.net e execute o
   programa de instalao.
 - Linux:
   A maioria das grandes distribuies j possuem o pacote em
   algum CD. Siga os procedimentos normais de instalao. Caso
   no exista para a sua, baixe os fontes de
   http://www.ruby-lang.org/en/ e siga os procedimentos.
 - Mac OSX:
   As verses atuais j trazem o Ruby. Caso contrrio seria
   necessrio baixar os fontes de http://www.ruby-lang.org/en/
   e compilar.
 - Cygwin:
   Rode o programa de setup, e instale a verso compilada do
   Ruby (1.6.8).
 - Outros:
   No tenho idia. S vendo.
 
 ===instalao (programa)
 - apenas copie o programa para o local de sua preferncia (em
   um local onde ele possa ser executado sem especificar o
   caminho  uma boa idia)
 
 ==caractersticas
 - processa apenas os arquivos necessrios (atualizados ou inexistentes);
 - permite o processamento recursivo (subdiretrios);
 - gera log dos arquivos para facilitar a atualizao de sites;
 - roda em Windows, Linux, Cygwin, (etc?)
 - opo para adequao de indexes localizados para o Apache,
   index-ptbr.t2t => index.html.ptbr
 - aceita opes a partir de um arquivo de configurao (+veja observaes abaixo+)
 - permite listar os rtulos existentes no arquivo de configurao  

 ===Obs: 
 ==== --batch filename rtulo
 - deve ser a ltima opo da linha de comando
 - as opes anteriores mantidas so: --clean --all
 - o arquivo contendo as opes  um arquivo texto no seguinte formato:
 - os rtulos devem estar entre chaves
 - deixar uma linha em branco para separar os rtulos
 - caminhos contendo espaoes devero estar entre aspas "caminho"
	[rotulo]
	--opo
	...
	--opo
 ex.:

 [txt2tags-win]
 --L10N
 --type html
 --sdir "C:/Arquivos de programas/Apache Group/Apache/htdocs/txt2tags-win"
 --ddir "C:/Arquivos de programas/Apache Group/Apache/htdocs/txt2tags-win"
 -r


 ==por fazer:
 - incluso de opes de pesquisa (--todo e --find text|ER)
 - incluso de opes de alterao (--subs texto:texto)
 - aceitar outras opes para enviar ao t2t
 - ??
 
 = copyright
 (C) 2003 por Guaracy Monteiro (http://ruby-ptbr.rubyforge.org/)
 
 = licenas
 GPL + Ruby (ou seja, faa o uso que desejar)
 
 = historico
 [A]lterao; Correo de [B]ugs; [N]ovo

 25/08/2003
 - lanamento (testes iniciais no Mandrake 9.1 e Windows 2000 utilizando
   ruby 1.8 e no Cygwin utilizando ruby 1.6.8)
 30/08/2003
 - [A]alteraes nos comentrios do programa para a gerao automtica 
   da documentao pelo rdoc;
 - [A]alteraes em nomes de variveis e mtodos do programa
   bem como de opes aceitas pelo mesmos e respectivas rotinas;
 - [B]passagem de diretrio com espaos para o txt2tags;
 - [N]opo L10N para arquivos de indices do Apache. Executada
   apenas para --type html
   index-en.t2t, index-ptbr.t2t => index.html.en, index.html.ptbr;
 - [N]opo --batch filename label. Abre um arquivo de configurao
   (default => t2t-make.conf), procura pelo rtulo especificado e
   passa para a linha de comandos as opes encontradas no arquivo
   (encerra na primeira linha em branco);
 - [N]opo -L. Utilizada em conjunto com a opo --batch e serve
   para apenas listar os rtulos encontrados no arquivo sem a
   execuo do mesmo;
 - [A]separao da rotina para interpretar a linha de comandos
   para facilitar a execuo de arquivos de lotes;
 - [N]opo --ext extenso para gerar arquivo com extenso
   diferente da padro;
 - [N]opo --all para forar a atualizao de todos os arquivos
 09/07/2004
 - [A]correes diversas para atualizao
 10/07/2004
 - [A]utilizao de optparse para verificao das opes
 - [A]excluso do parmetro -L
 - [N]parmetro -b/--batch lista rtulo em caso de omisso ou erro
 - [A]alterao dos mtodos para tratamento de arquivos batch
 - [N]lanamento da verso 1.0rc
 - [A]excluso do mtodo usage (incorporado na verificao dos parmetros)
 - [A]alteraes em diversas partes do programa por conta da 'optparse'
 - [N] salvo a data e os dados so adicionados no logfile
=end

# verso do programa
$VERSAO = "1.0rc"

#++ >> ATENO <<
# A constante $T2T contm o caminho para o txt2tags e
# deve ser alterada conforme o seu sistema
# Alguns exemplos:
# $T2T = 'python C:/utils/txt2tags.py'
# $T2T = 'E:/utils/txt2tags/txt2tags.exe'
# $T2T = /usr/local/bin/txt2tags

if RUBY_PLATFORM =~ /mswin/
  $T2T = 'C:/Arquivos de programas/txt2tags/txt2tags.exe'
  $POPEN = true
else
  $T2T = 'txt2tags'
  $POPEN = true #false
end

$flags = ''

$IDX_SRC = 0		# indice para caminho dos fontes
$IDX_DSTDIR = 1		# indice para caminho dos destinos
$IDX_DSTFILE = 2	# indice para nome do arquivo destino


# Tipos vlidos para o txt2tags
$tipos = %w(html xhtml sgml tex man mgp moin pm6 txt)

# Mostra uma mensagem de erro e aborta o programa
# ---
def abort(msg)
  puts "Abnormal program termination!"
  puts msg
  exit
end

# Retorna uma string com a verso do programa
# ---
def version
  print "\nt2tmake.rb version #{$VERSAO}\n"
  print "(c) 2003 by Guaracy B. Monteiro\n\n"
end


# Pesquisa um diretrio e executa um bloco passado para
# cada arquivo que coincidir com a mscara especificada
# Se _recursive_ for igual a +verdadeiro+, a pesquisa
# ser efetuada em toda a rvore do diretrio informado
#---
def dir_recurse(dirname, mask, recursive, &action)
  d = Dir.pwd
  Dir.chdir(dirname)
  Dir["#{mask}"].each do |file|
    action.call("#{dirname}/#{file}")
  end
  return if !recursive
  Dir.open(dirname) do |dir|
    dir.each do |file|
      if FileTest.directory?("#{dirname}/#{file}")
        next if file =~ /^\.\.?$/
        dir_recurse("#{dirname}/#{file}", mask, recursive, &action)
      end
    end
  end
  Dir.chdir(d)
end

# Recebe uma matriz com o caminho completo e nome dos 
# arquivos, a especificao do diretrio original, a 
# especificao do diretrio destino e o tipo (extenso) 
# dos arquivos destinos.
# Retorna uma matriz onde cada elemento contm:
# - caminho completo e nome dos arquivos de origem
# - caminho completo do destino
# - nome e extenso do arquivo destino correspondente
# ---
def gen_destfiles(files, srcdir, dst_dir, type)
  basedir = srcdir.size
  files.collect do |filedir|
    dir = dst_dir + File.dirname(filedir)[basedir..-1]
    file = File.basename(filedir,'.t2t')
    if !@l10n.nil?
      if type == 'html' and file =~ /^index\-/
        file = file.split('-',2)
        file = sprintf("%s.%s.%s", file[0] , type, file[1])
      else
        file << ".#{type}"
      end
    else
      file << ".#{type}"
    end
    [filedir, dir, file]
  end
end

# Rotina para a verificar se o arquivo fonte  mais
# atual que o arquivo destino ou se este no existe.
# Se for confirmada a condio, o programa executar
# o txt2tags para que a atualizao do destino seja
# feita, bem como ir gravar no arquivo +logfile+ o
# caminho completo e nome do arquivo destino que
# foi alterado.
# ---
def make(files, logfile)
  if !@log_fn.nil?
		logfile = File.new(logfile,"a") 
		logfile.puts Time.new.strftime("# %c\n")
	end
  files.each do |data|
    src = data[$IDX_SRC]
    dstdir = data[$IDX_DSTDIR]
    dst = "#{dstdir}/#{data[$IDX_DSTFILE]}"
    begin
      if !FileTest.exist?(dstdir)
			  FileUtils.mkdir_p(dstdir)
      end
    rescue => erro
      abort("Can't create directory - #{dstdir}")
    end
    if !@all.nil? or !File.exist?(dst) or File.stat(src).mtime > File.stat(dst).mtime
      puts "Processing - #{src}"
      cmd = "\"#{$T2T}\" #{$flags} -o \"#{dst}\" \"#{src}\""
      if $POPEN
        IO.popen(cmd) { |res|
          puts res.readlines
        }
      else
        if !system(cmd)
          abort("Error while executin - '#{$T2T}'")
        end
      end
      logfile.puts dst if !@log_fn.nil?
    else
      puts"Nothing to be done for - #{data[$IDX_DSTFILE]} #{src}"
    end
  end
end

# Remove todos os arquivos com uma determinada
# extenso em um diretrio destino baseado em
# uma lista de arquivos fontes especificadas
# ---
def clean(files, type, dst_dir)
  puts "Cleaning..."
  files.each do |data|
    dst = "#{data[$IDX_DSTDIR]}/#{data[$IDX_DSTFILE]}"
    if File.exist?(dst)
      puts "deleting - #{dst}"
      File.delete(dst)
    end
  end
end

# Mostra rtulos vlidos em arquivo batch e encerra
# ---
def abort_batch_labels(conf_file, data, msg)
    puts msg unless msg.empty?
    puts "Valid labels for #{conf_file}:"
    data.each do |line|
      puts "#{line}" if line =~ /^\[.+\]\s*/ 
    end
    exit
end

# Pocessamento de arquivos com instrues
# ---
def batch(file,label,msg="")
  conf_file = File.expand_path(file)
  conf_file += "/t2t-make.conf" if FileTest.directory?(conf_file)
  if !FileTest.exist?(conf_file)
    puts "Can't find file #{conf_file}"
    exit
  end
  data = IO.readlines(conf_file)
  data.collect! do |linha| linha.chop end
  if label.nil?
    abort_batch_labels(conf_file,data,msg)
  end
  idx = data.index("[#{label}]")
  if idx.nil?
    abort_batch_labels(conf_file,data,"Can't find label - '#{label}'")
  end
  for i in (idx+1)..(data.size-1)
    break if data[i] == ''
    abort("Malformated line\nfile : #{conf_file}\nlabel : [#{label}]\nline -  #{data[i]}\nin") if data[i] !~ /^\-/
      ARGV << data[i].split(nil,2)
  end
  ARGV.flatten!
end

# Rotina principal do programa, encarregada de verificar
# os argumentos especificados na linha de comando.
# ---
def parse_args
    ARGV.options do
      |opts|
      opts.on_tail
      opts.on_tail("common options:")
      opts.on_tail("-h", "--help", "show this message") do
        puts opts
        exit
      end
      opts.on_tail("-V", "--version", "show version") do
        puts "t2tmake #{$VERSION}"
        exit
      end
      opts.on_head("specific options:")  
      opts.on("-t", "--type=TARGET", String, "set target (txt2tags) document type",$tipos.join(",")) do |x|@type=x
        if !@type.nil?
          if !$tipos.include?(@type)
            puts "'#{@type}' is not a valid target type. Valid types are:"
            puts $tipos.join(' | ')
            exit
          end
        end
      end
      # formal argument cannot be an instance variable: {|@ext|}
      opts.on("-e", "--ext=EXT", String, "set output file extension") {|x|@ext=x}
      opts.on("-r", "--recusive", "recursive directory processing.") {|x|@recursive=x}
      opts.on("-s", "--sdir=DIR", String, "especify source directory","default => actual_directory (pwd)") {|x|@src_dir=x}
      opts.on("-d", "--ddir=DIR", String, "set target directory","default => actual_directory./_<type>") {|x|@dst_dir=x}
      opts.on("-l", "--log[=FILE]", "log changes (processed files)","default => target_directory/t2tmake.log") {|x|@log_fn=x;@log_fn ||= ''}
      opts.on("--L10N", "Apache localization", "index-en.t2t => index.html.en") {|x|@l10n=x}
      opts.on("-a", "--all", "force to process all files") {|x|@all=x}
      opts.on("-c", "--clean", "erase all target files before processing") {|x|@clean=x}
      opts.on("-b", "--batch=FILE[,LABEL]",Array,"use options from an specified 'label'","stored in a batch file;","without LABEL, list all labels") do |x,y|@batch,@label=x,y
        if @label.nil?
          batch(@batch,@label,"No label specified.")
          exit
        end
      end
      opts.parse!
    end
end

# Verificar a validade dos argumentos passados para o programa
# e toma as providencias necessrias como ajustar nomes de 
# diretrios, montar a lista de arquivos e chamar o mtodo 
# responsvel para execuo dos procedimentos desejados pelo 
# usurio.
# ---
def main
  # warning: instance variable @foo not initialized
  @batch = nil
  @type = nil
  @src_dir = nil
  @dst_dir = nil
  @ext = nil
  @recursive = nil
  @clean = nil
  @log_fn = nil
  @log_fn = nil

#  if ARGV.empty?
#    ARGV.push("--help")
#  end
  fbatch = false
  while true do
    parse_args
    if !@batch.nil?
      abort("Nested batch files not allowed.") if fbatch
      ARGV.clear
      batch(@batch,@label)
      @batch=nil
      fbatch = true
      next
    else
      break
    end
  end
	
	@type='html' if @type.nil?
	
  if @src_dir.nil?
    src_dir = Dir.pwd
  else
    src_dir = @src_dir.gsub(/[\"\']/,'')
    src_dir = File.expand_path(src_dir)
  end
	
  if @dst_dir.nil?
    dst_dir = src_dir + "/_#{@type}"
  else
    dst_dir = @dst_dir.gsub(/[\"\']/,'')
    dst_dir = File.expand_path(dst_dir)
  end
  if !FileTest.exist?(dst_dir)
		FileUtils.mkdir_p(dst_dir)
  end

  files = []	
	
  ext = (@ext.nil?) ? (@type) : (@ext)
  dir_recurse(src_dir, "*.t2t", !@recursive.nil?) { |file| files << file }
  files = gen_destfiles(files, src_dir, dst_dir, ext)
  if !@clean.nil?
    clean(files, type, dst_dir)
    return
  end
	if !@log_fn.nil?
		logfile = (@log_fn.empty?) ? ("#{dst_dir}/t2tmake.log") : (File.expand_path(@log_fn))
		if !FileTest.exist?(File.dirname(logfile))
			begin
				Dir.mkdir("#{File.dirname(logfile)}")
			rescue => erro
				abort("#{erro}\nCan't create logfile - #{logfile}")
			end
		end
	else
		logfile = ""
	end

  make(files, "#{logfile}")
	
end


=begin

  #clean no usa log
  $flags = $flags + "-t #{$OPT_type} "
  end
=end

# inicio do programa
main
puts "Done."

