// DVB-CISSA test vectors
// From ETSI TS 103 127, Annex B: CISSA Test Vectors for TS level scrambling

#include "tsTSPacket.h"
struct TV_DVB_CISSA {
    uint8_t      key[16];
    ts::TSPacket plain;
    ts::TSPacket cipher;
};

static const TV_DVB_CISSA tv_dvb_cissa[] = {
    {
        // Test Case 1: No Adaptation Field
        {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF},
        {{
            0x47, 0x60, 0x80, 0x11, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
            0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72,
            0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65,
            0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74,
            0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49, 0x50, 0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61,
            0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2F, 0x64, 0x65, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65,
            0x72, 0x2E, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70,
            0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20,
            0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73,
            0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68,
            0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49, 0x50, 0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D,
            0x62, 0x6C, 0x65, 0x72, 0x2F, 0x64, 0x65, 0x73, 0x63, 0x72, 0x61, 0x6D,
        }},
        {{
            0x47, 0x60, 0x80, 0x91, 0x15, 0xCE, 0x67, 0xE0, 0xCB, 0x01, 0xB5, 0x3C, 0xE7, 0x60, 0x54, 0xE5,
            0x7A, 0x4A, 0xD1, 0x20, 0xA0, 0xDF, 0xA4, 0xEA, 0xAA, 0xE9, 0x32, 0xC6, 0x78, 0x3F, 0x51, 0xAE,
            0x19, 0xFA, 0xEE, 0x10, 0x8B, 0xDB, 0x78, 0xF3, 0x11, 0x3E, 0xC2, 0xB5, 0x72, 0xCC, 0x20, 0x85,
            0x00, 0xA5, 0x2C, 0xEC, 0xA1, 0x14, 0x12, 0x6C, 0x58, 0x24, 0x4D, 0xF5, 0x63, 0xE7, 0xA9, 0xB4,
            0xE0, 0x41, 0xCB, 0xC3, 0xFB, 0xFF, 0xFB, 0xD8, 0x3C, 0x8F, 0xBF, 0xFB, 0x10, 0xE8, 0x3E, 0xA3,
            0x82, 0x04, 0xBA, 0xD7, 0x02, 0xFB, 0x01, 0xA2, 0x7B, 0x62, 0x2C, 0x4F, 0x85, 0xAA, 0xB6, 0xAA,
            0x75, 0x55, 0x97, 0x20, 0xD6, 0x5A, 0xB8, 0x44, 0xCE, 0xA2, 0x8C, 0xF2, 0xE1, 0xFE, 0x5E, 0x7A,
            0xC1, 0x9D, 0x44, 0x81, 0x89, 0x19, 0xC2, 0x32, 0x49, 0xF1, 0x40, 0x75, 0x7B, 0x5D, 0x16, 0xC0,
            0xAF, 0x45, 0xB2, 0x5F, 0x50, 0x9B, 0x9D, 0xA0, 0x61, 0x97, 0x12, 0xC5, 0x9F, 0x0B, 0x39, 0xB0,
            0x6F, 0x1F, 0xBE, 0x90, 0x12, 0x3F, 0x21, 0x29, 0x83, 0x93, 0x6A, 0x95, 0x31, 0x7F, 0xCB, 0x62,
            0xF4, 0x34, 0x6A, 0x1B, 0x1E, 0x16, 0x48, 0x40, 0x30, 0x3A, 0xFF, 0x83, 0x8A, 0x01, 0x9B, 0xF8,
            0x10, 0xA8, 0xE0, 0xB2, 0x2F, 0x64, 0x65, 0x73, 0x63, 0x72, 0x61, 0x6D,
        }},
    },
    {
        // Test Case 2: 7-byte Adaptation Field
        {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF},
        {{
            0x47, 0x60, 0x80, 0x31, 0x06, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0x68, 0x69, 0x73, 0x20,
            0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20, 0x75,
            0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E, 0x67,
            0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F, 0x72,
            0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49, 0x50,
            0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2F, 0x64, 0x65, 0x73,
            0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2E, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69,
            0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20, 0x75, 0x73,
            0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E, 0x67, 0x20,
            0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x73,
            0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49, 0x50, 0x54,
            0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2F,
        }},
        {{
            0x47, 0x60, 0x80, 0xB1, 0x06, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x15, 0xCE, 0x67, 0xE0, 0xCB,
            0x01, 0xB5, 0x3C, 0xE7, 0x60, 0x54, 0xE5, 0x7A, 0x4A, 0xD1, 0x20, 0xA0, 0xDF, 0xA4, 0xEA, 0xAA,
            0xE9, 0x32, 0xC6, 0x78, 0x3F, 0x51, 0xAE, 0x19, 0xFA, 0xEE, 0x10, 0x8B, 0xDB, 0x78, 0xF3, 0x11,
            0x3E, 0xC2, 0xB5, 0x72, 0xCC, 0x20, 0x85, 0x00, 0xA5, 0x2C, 0xEC, 0xA1, 0x14, 0x12, 0x6C, 0x58,
            0x24, 0x4D, 0xF5, 0x63, 0xE7, 0xA9, 0xB4, 0xE0, 0x41, 0xCB, 0xC3, 0xFB, 0xFF, 0xFB, 0xD8, 0x3C,
            0x8F, 0xBF, 0xFB, 0x10, 0xE8, 0x3E, 0xA3, 0x82, 0x04, 0xBA, 0xD7, 0x02, 0xFB, 0x01, 0xA2, 0x7B,
            0x62, 0x2C, 0x4F, 0x85, 0xAA, 0xB6, 0xAA, 0x75, 0x55, 0x97, 0x20, 0xD6, 0x5A, 0xB8, 0x44, 0xCE,
            0xA2, 0x8C, 0xF2, 0xE1, 0xFE, 0x5E, 0x7A, 0xC1, 0x9D, 0x44, 0x81, 0x89, 0x19, 0xC2, 0x32, 0x49,
            0xF1, 0x40, 0x75, 0x7B, 0x5D, 0x16, 0xC0, 0xAF, 0x45, 0xB2, 0x5F, 0x50, 0x9B, 0x9D, 0xA0, 0x61,
            0x97, 0x12, 0xC5, 0x9F, 0x0B, 0x39, 0xB0, 0x6F, 0x1F, 0xBE, 0x90, 0x12, 0x3F, 0x21, 0x29, 0x83,
            0x93, 0x6A, 0x95, 0x31, 0x7F, 0xCB, 0x62, 0xF4, 0x34, 0x6A, 0x1B, 0x1E, 0x16, 0x48, 0x40, 0x30,
            0x3A, 0xFF, 0x83, 0x8A, 0x01, 0x9B, 0xF8, 0x10, 0xA8, 0xE0, 0xB2, 0x2F,
        }},
    },
    {
        // Test Case 3: 8-byte Adaptation Field
        {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF},
        {{
            0x47, 0x60, 0x80, 0x31, 0x07, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0x68, 0x69, 0x73,
            0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20,
            0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E,
            0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F,
            0x72, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49,
            0x50, 0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2F, 0x64, 0x65,
            0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2E, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20,
            0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20, 0x75,
            0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E, 0x67,
            0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F, 0x72,
            0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49, 0x50,
            0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72,
        }},
        {{
            0x47, 0x60, 0x80, 0xB1, 0x07, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x15, 0xCE, 0x67, 0xE0,
            0xCB, 0x01, 0xB5, 0x3C, 0xE7, 0x60, 0x54, 0xE5, 0x7A, 0x4A, 0xD1, 0x20, 0xA0, 0xDF, 0xA4, 0xEA,
            0xAA, 0xE9, 0x32, 0xC6, 0x78, 0x3F, 0x51, 0xAE, 0x19, 0xFA, 0xEE, 0x10, 0x8B, 0xDB, 0x78, 0xF3,
            0x11, 0x3E, 0xC2, 0xB5, 0x72, 0xCC, 0x20, 0x85, 0x00, 0xA5, 0x2C, 0xEC, 0xA1, 0x14, 0x12, 0x6C,
            0x58, 0x24, 0x4D, 0xF5, 0x63, 0xE7, 0xA9, 0xB4, 0xE0, 0x41, 0xCB, 0xC3, 0xFB, 0xFF, 0xFB, 0xD8,
            0x3C, 0x8F, 0xBF, 0xFB, 0x10, 0xE8, 0x3E, 0xA3, 0x82, 0x04, 0xBA, 0xD7, 0x02, 0xFB, 0x01, 0xA2,
            0x7B, 0x62, 0x2C, 0x4F, 0x85, 0xAA, 0xB6, 0xAA, 0x75, 0x55, 0x97, 0x20, 0xD6, 0x5A, 0xB8, 0x44,
            0xCE, 0xA2, 0x8C, 0xF2, 0xE1, 0xFE, 0x5E, 0x7A, 0xC1, 0x9D, 0x44, 0x81, 0x89, 0x19, 0xC2, 0x32,
            0x49, 0xF1, 0x40, 0x75, 0x7B, 0x5D, 0x16, 0xC0, 0xAF, 0x45, 0xB2, 0x5F, 0x50, 0x9B, 0x9D, 0xA0,
            0x61, 0x97, 0x12, 0xC5, 0x9F, 0x0B, 0x39, 0xB0, 0x6F, 0x1F, 0xBE, 0x90, 0x12, 0x3F, 0x21, 0x29,
            0x83, 0x93, 0x6A, 0x95, 0x31, 0x7F, 0xCB, 0x62, 0xF4, 0x34, 0x6A, 0x1B, 0x1E, 0x16, 0x48, 0x40,
            0x30, 0x3A, 0xFF, 0x83, 0x8A, 0x01, 0x9B, 0xF8, 0x10, 0xA8, 0xE0, 0xB2,
        }},
    },
    {
        // Test Case 4: 9-byte Adaptation Field
        {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF},
        {{
            0x47, 0x60, 0x80, 0x31, 0x08, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 0x68, 0x69,
            0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64,
            0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
            0x6E, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74,
            0x6F, 0x72, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20,
            0x49, 0x50, 0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2F, 0x64,
            0x65, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65, 0x72, 0x2E, 0x20, 0x54, 0x68, 0x69, 0x73,
            0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6C, 0x6F, 0x61, 0x64, 0x20,
            0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6E,
            0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x63, 0x74, 0x6F,
            0x72, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x56, 0x42, 0x20, 0x49,
            0x50, 0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65,
        }},
        {{
            0x47, 0x60, 0x80, 0xB1, 0x08, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x15, 0xCE, 0x67,
            0xE0, 0xCB, 0x01, 0xB5, 0x3C, 0xE7, 0x60, 0x54, 0xE5, 0x7A, 0x4A, 0xD1, 0x20, 0xA0, 0xDF, 0xA4,
            0xEA, 0xAA, 0xE9, 0x32, 0xC6, 0x78, 0x3F, 0x51, 0xAE, 0x19, 0xFA, 0xEE, 0x10, 0x8B, 0xDB, 0x78,
            0xF3, 0x11, 0x3E, 0xC2, 0xB5, 0x72, 0xCC, 0x20, 0x85, 0x00, 0xA5, 0x2C, 0xEC, 0xA1, 0x14, 0x12,
            0x6C, 0x58, 0x24, 0x4D, 0xF5, 0x63, 0xE7, 0xA9, 0xB4, 0xE0, 0x41, 0xCB, 0xC3, 0xFB, 0xFF, 0xFB,
            0xD8, 0x3C, 0x8F, 0xBF, 0xFB, 0x10, 0xE8, 0x3E, 0xA3, 0x82, 0x04, 0xBA, 0xD7, 0x02, 0xFB, 0x01,
            0xA2, 0x7B, 0x62, 0x2C, 0x4F, 0x85, 0xAA, 0xB6, 0xAA, 0x75, 0x55, 0x97, 0x20, 0xD6, 0x5A, 0xB8,
            0x44, 0xCE, 0xA2, 0x8C, 0xF2, 0xE1, 0xFE, 0x5E, 0x7A, 0xC1, 0x9D, 0x44, 0x81, 0x89, 0x19, 0xC2,
            0x32, 0x49, 0xF1, 0x40, 0x75, 0x7B, 0x5D, 0x16, 0xC0, 0xAF, 0x45, 0xB2, 0x5F, 0x50, 0x9B, 0x9D,
            0xA0, 0x61, 0x97, 0x12, 0xC5, 0x9F, 0x0B, 0x39, 0xB0, 0x6F, 0x1F, 0xBE, 0x90, 0x12, 0x3F, 0x21,
            0x29, 0x83, 0x93, 0x6A, 0x95, 0x31, 0x7F, 0xCB, 0x62, 0xF4, 0x34, 0x6A, 0x1B, 0x42, 0x20, 0x49,
            0x50, 0x54, 0x56, 0x20, 0x73, 0x63, 0x72, 0x61, 0x6D, 0x62, 0x6C, 0x65,
        }},
    },
};
