//----------------------------------------------------------------------------
//
// TSDuck - The MPEG Transport Stream Toolkit
// Copyright (c) 2005-2020, Thierry Lelegard
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
//    this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
// THE POSSIBILITY OF SUCH DAMAGE.
//
//----------------------------------------------------------------------------
//!
//!  @file
//!  Sources of time information for transport streams.
//!
//----------------------------------------------------------------------------

#pragma once
#include "tsTypedEnumeration.h"

namespace ts {
    //!
    //! Sources of time information for transport streams.
    //!
    enum class TimeSource : uint8_t {
        UNDEFINED = 0,  //!< Undefined source of time information.
        HARDWARE,       //!< Hardware-generated time, any local hardware (NIC for instance).
        KERNEL,         //!< OS kernel time stamp.
        TSP,            //!< Application time stamp, generated by tsp when the chunk of TS packets is received.
        RTP,            //!< RTP (Real Time Protocol) time stamp.
        SRT,            //!< SRT (Secure Reliable Transport) source time.
        M2TS,           //!< M2TS Bluray-style time stamp.
        PCR,            //!< PCR (Program Clock Reference), the transport stream system clock.
        DTS,            //!< DTS (Decoding Time Stamp), in a video or audio stream.
        PTS,            //!< PTS (Presentation Time Stamp), in a video or audio stream.
    };

    //!
    //! Enumeration description of ts::TimeSource.
    //!
    TSDUCKDLL extern const TypedEnumeration<TimeSource> TimeSourceEnum;
}
