//----------------------------------------------------------------------------
//
// TSDuck - The MPEG Transport Stream Toolkit
// Copyright (c) 2005-2020, Thierry Lelegard
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
//    this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
// THE POSSIBILITY OF SUCH DAMAGE.
//
//----------------------------------------------------------------------------
//!
//!  @file
//!  Representation of an AVC_timing_and_HRD_descriptor
//!
//----------------------------------------------------------------------------

#pragma once
#include "tsAbstractDescriptor.h"
#include "tsVariable.h"

namespace ts {
    //!
    //! Representation of an AVC_timing_and_HRD_descriptor.
    //!
    //! This MPG-defined descriptor is not defined in ISO/IEC 13818-1,
    //! ITU-T Rec. H.222.0. See its "Amendment 3: Transport of AVC video
    //! over ITU-T Rec. H.222.0 | ISO/IEC 13818-1 streams" (document W5771),
    //! section 2.6.56.
    //! @ingroup descriptor
    //!
    class TSDUCKDLL AVCTimingAndHRDDescriptor : public AbstractDescriptor
    {
    public:
        // Public members:
        bool               hrd_management_valid;           //!< See ISO/IEC 13818-1, Amendment 3.
        Variable<uint32_t> N_90khz;                        //!< See ISO/IEC 13818-1, Amendment 3.
        Variable<uint32_t> K_90khz;                        //!< See ISO/IEC 13818-1, Amendment 3.
        Variable<uint32_t> num_units_in_tick;              //!< See ISO/IEC 13818-1, Amendment 3.
        bool               fixed_frame_rate;               //!< See ISO/IEC 13818-1, Amendment 3.
        bool               temporal_poc;                   //!< See ISO/IEC 13818-1, Amendment 3.
        bool               picture_to_display_conversion;  //!< See ISO/IEC 13818-1, Amendment 3.

        //!
        //! Default constructor.
        //!
        AVCTimingAndHRDDescriptor();

        //!
        //! Constructor from a binary descriptor
        //! @param [in,out] duck TSDuck execution context.
        //! @param [in] bin A binary descriptor to deserialize.
        //!
        AVCTimingAndHRDDescriptor(DuckContext& duck, const Descriptor& bin);

        // Inherited methods
        virtual void serialize(DuckContext&, Descriptor&) const override;
        virtual void deserialize(DuckContext&, const Descriptor&) override;
        DeclareLegacyDisplayDescriptor();

    protected:
        // Inherited methods
        virtual void clearContent() override;
        virtual void buildXML(DuckContext&, xml::Element*) const override;
        virtual bool analyzeXML(DuckContext& duck, const xml::Element* element) override;
    };
}
