//----------------------------------------------------------------------------
//
// TSDuck - The MPEG Transport Stream Toolkit
// Copyright (c) 2005-2020, Thierry Lelegard
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
//    this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
// THE POSSIBILITY OF SUCH DAMAGE.
//
//----------------------------------------------------------------------------

// Automatically generated file, do not modify.
// See tscharset --generate-arib-b24-encoding-table
// Generated 2020/04/24

#include "tsARIBCharset.h"

const size_t ts::ARIBCharset::ENCODING_COUNT = 6647;
const ts::ARIBCharset::EncoderEntry ts::ARIBCharset::ENCODING_TABLE[6647] = {
    {0x00000021, 0x4A21213B}, {0x0000005C, 0xC2214001}, {0x0000005D, 0x4A215D21}, {0x000000A2, 0xC2217102},
    {0x000000A5, 0x4A215C01}, {0x000000A7, 0xC2217801}, {0x000000A8, 0xC2212F01}, {0x000000AC, 0xC2224C01},
    {0x000000B0, 0xC2216B01}, {0x000000B1, 0xC2215E01}, {0x000000B2, 0xC27C5502}, {0x000000B4, 0xC2212D01},
    {0x000000B6, 0xC2227901}, {0x000000BC, 0xC27D5401}, {0x000000BD, 0xC27D5001}, {0x000000BE, 0xC27D5501},
    {0x000000D7, 0xC2215F01}, {0x000000F7, 0xC2216001}, {0x00000391, 0xC2262111}, {0x000003A3, 0xC2263207},
    {0x000003B1, 0xC2264111}, {0x000003C3, 0xC2265207}, {0x00000401, 0xC2272701}, {0x00000410, 0xC2272106},
    {0x00000416, 0xC227281A}, {0x00000430, 0xC2275106}, {0x00000436, 0xC227581A}, {0x00000451, 0xC2275701},
    {0x00000FD6, 0xC27B2D01}, {0x00002010, 0xC2213E01}, {0x00002015, 0xC2213D01}, {0x00002016, 0xC2214201},
    {0x00002018, 0xC2214602}, {0x0000201C, 0xC2214802}, {0x00002020, 0xC2227702}, {0x00002025, 0xC2214501},
    {0x00002026, 0xC2214401}, {0x00002030, 0xC2227301}, {0x00002032, 0xC2216C02}, {0x0000203B, 0xC2222801},
    {0x0000203C, 0xC27D6E01}, {0x0000203E, 0x4A217E01}, {0x00002049, 0xC27D6F01}, {0x00002103, 0xC2216E01},
    {0x00002113, 0xC27D4701}, {0x00002116, 0xC27D2D01}, {0x00002121, 0xC27D2E01}, {0x0000212B, 0xC2227201},
    {0x0000213B, 0xC27C7B01}, {0x00002150, 0xC27D5C01}, {0x00002151, 0xC27D5E02}, {0x00002153, 0xC27D5202},
    {0x00002155, 0xC27D5606}, {0x0000215B, 0xC27D5D01}, {0x00002160, 0xC27E210C}, {0x00002189, 0xC27D5101},
    {0x00002190, 0xC2222B02}, {0x00002192, 0xC2222A01}, {0x00002193, 0xC2222D01}, {0x000021D2, 0xC2224D01},
    {0x000021D4, 0xC2224E01}, {0x00002200, 0xC2224F01}, {0x00002202, 0xC2225F01}, {0x00002203, 0xC2225001},
    {0x00002207, 0xC2226001}, {0x00002208, 0xC2223A01}, {0x0000220B, 0xC2223B01}, {0x0000221A, 0xC2226501},
    {0x0000221D, 0xC2226701}, {0x0000221E, 0xC2216701}, {0x00002220, 0xC2225C01}, {0x00002227, 0xC2224A02},
    {0x00002229, 0xC2224101}, {0x0000222A, 0xC2224001}, {0x0000222B, 0xC2226902}, {0x00002234, 0xC2216801},
    {0x00002235, 0xC2226801}, {0x0000223D, 0xC2226601}, {0x00002252, 0xC2226201}, {0x00002260, 0xC2216201},
    {0x00002261, 0xC2226101}, {0x00002266, 0xC2216502}, {0x0000226A, 0xC2226302}, {0x00002282, 0xC2223E02},
    {0x00002286, 0xC2223C02}, {0x000022A5, 0xC2225D01}, {0x00002312, 0xC2225E01}, {0x00002460, 0xC27E6110},
    {0x00002470, 0xC27E2D10}, {0x00002488, 0xC27C3109}, {0x00002491, 0xC27A4D03}, {0x000024B9, 0xC27B3E01},
    {0x000024C8, 0xC27B3F01}, {0x000024EB, 0xC27E7B02}, {0x00002500, 0xC2282101}, {0x00002501, 0xC2282C01},
    {0x00002502, 0xC2282201}, {0x00002503, 0xC2282D01}, {0x0000250C, 0xC2282301}, {0x0000250F, 0xC2282E01},
    {0x00002510, 0xC2282401}, {0x00002513, 0xC2282F01}, {0x00002514, 0xC2282601}, {0x00002517, 0xC2283101},
    {0x00002518, 0xC2282501}, {0x0000251B, 0xC2283001}, {0x0000251C, 0xC2282701}, {0x0000251D, 0xC2283C01},
    {0x00002520, 0xC2283701}, {0x00002523, 0xC2283201}, {0x00002524, 0xC2282901}, {0x00002525, 0xC2283E01},
    {0x00002528, 0xC2283901}, {0x0000252B, 0xC2283401}, {0x0000252C, 0xC2282801}, {0x0000252F, 0xC2283801},
    {0x00002530, 0xC2283D01}, {0x00002533, 0xC2283301}, {0x00002534, 0xC2282A01}, {0x00002537, 0xC2283A01},
    {0x00002538, 0xC2283F01}, {0x0000253B, 0xC2283501}, {0x0000253C, 0xC2282B01}, {0x0000253F, 0xC2283B01},
    {0x00002542, 0xC2284001}, {0x0000254B, 0xC2283601}, {0x000025A0, 0xC2222301}, {0x000025A1, 0xC2222201},
    {0x000025B2, 0xC2222501}, {0x000025B3, 0xC2222401}, {0x000025B6, 0xC27C5001}, {0x000025BC, 0xC2222701},
    {0x000025BD, 0xC2222601}, {0x000025C0, 0xC27C5101}, {0x000025C6, 0xC2222101}, {0x000025C7, 0xC2217E01},
    {0x000025CB, 0xC2217B01}, {0x000025CE, 0xC2217D01}, {0x000025CF, 0xC2217C01}, {0x000025EF, 0xC2227E01},
    {0x00002600, 0xC27D6003}, {0x00002603, 0xC27D7301}, {0x00002605, 0xC2217A01}, {0x00002606, 0xC2217901},
    {0x0000260E, 0xC27B4B01}, {0x00002613, 0xC27B2601}, {0x00002614, 0xC27D7101}, {0x00002616, 0xC27D6402},
    {0x00002640, 0xC2216A01}, {0x00002642, 0xC2216901}, {0x00002660, 0xC27D6B01}, {0x00002663, 0xC27D6A01},
    {0x00002665, 0xC27D6901}, {0x00002666, 0xC27D6801}, {0x00002668, 0xC27B3101}, {0x0000266A, 0xC2227601},
    {0x0000266C, 0xC27D7A01}, {0x0000266D, 0xC2227501}, {0x0000266F, 0xC2227401}, {0x00002693, 0xC27B3501},
    {0x0000269E, 0xC27D7802}, {0x000026A1, 0xC27D7501}, {0x000026BE, 0xC27D3001}, {0x000026BF, 0xC27A6701},
    {0x000026C4, 0xC27D6301}, {0x000026C5, 0xC27D7001}, {0x000026C6, 0xC27D7201}, {0x000026C7, 0xC27D7401},
    {0x000026C8, 0xC27D7601}, {0x000026C9, 0xC27D6602}, {0x000026CB, 0xC27D6C01}, {0x000026CC, 0xC27A2102},
    {0x000026CF, 0xC27A2403}, {0x000026D2, 0xC27A2801}, {0x000026D3, 0xC27A2A02}, {0x000026D5, 0xC27A2901},
    {0x000026D6, 0xC27A340C}, {0x000026E3, 0xC27B2101}, {0x000026E8, 0xC27B2901}, {0x000026E9, 0xC27B2C01},
    {0x000026EA, 0xC27B2E03}, {0x000026ED, 0xC27B3203}, {0x000026F0, 0xC27B3706}, {0x000026F6, 0xC27B4001},
    {0x000026F7, 0xC27B4604}, {0x000026FB, 0xC27B4C04}, {0x000026FF, 0xC27B5101}, {0x00002708, 0xC27B3601},
    {0x00002757, 0xC27A2301}, {0x00002776, 0xC27E710A}, {0x000027A1, 0xC27C2101}, {0x000027D0, 0xC27C5401},
    {0x00002A00, 0xC27D6D01}, {0x00002B05, 0xC27C2203}, {0x00002B1B, 0xC27A6001}, {0x00002B24, 0xC27A6101},
    {0x00002B2E, 0xC27C2601}, {0x00002B2F, 0xC27C2501}, {0x00002B55, 0xC27A4001}, {0x00002B56, 0xC27B2204},
    {0x00003000, 0xC2212103}, {0x00003003, 0xC2213701}, {0x00003005, 0xC2213903}, {0x00003008, 0xC221520A},
    {0x00003012, 0xC2222901}, {0x00003013, 0xC2222E01}, {0x00003014, 0xC2214C02}, {0x00003016, 0xC27C5202},
    {0x0000301C, 0xC2214101}, {0x00003036, 0xC27D2F01}, {0x00003041, 0xC2242153}, {0x0000309B, 0xC2212B02},
    {0x0000309D, 0xC2213502}, {0x000030A1, 0xC2252156}, {0x000030FB, 0xC2212601}, {0x000030FC, 0xC2213C01},
    {0x000030FD, 0xC2213302}, {0x0000322A, 0xC27D2107}, {0x00003231, 0xC27C4D01}, {0x00003232, 0xC27C4C01},
    {0x00003233, 0xC27C4A01}, {0x00003236, 0xC27C4B01}, {0x00003237, 0xC27D2801}, {0x00003239, 0xC27C4E01},
    {0x00003244, 0xC27C4F01}, {0x00003245, 0xC27B2B01}, {0x00003246, 0xC27B2A01}, {0x00003247, 0xC27C7801},
    {0x00003248, 0xC27A4108}, {0x00003251, 0xC27E3D04}, {0x00003255, 0xC27E5B06}, {0x0000325B, 0xC27E7D01},
    {0x0000328B, 0xC27B2701}, {0x00003299, 0xC27A7301}, {0x00003371, 0xC27D4D01}, {0x0000337B, 0xC27D2C01},
    {0x0000337C, 0xC27D2B01}, {0x0000337D, 0xC27D2A01}, {0x0000337E, 0xC27D2901}, {0x0000338F, 0xC27D4802},
    {0x0000339D, 0xC27C2D01}, {0x0000339E, 0xC27D4B01}, {0x000033A0, 0xC27C2E01}, {0x000033A1, 0xC27C2B01},
    {0x000033A2, 0xC27D4C01}, {0x000033A4, 0xC27C2F01}, {0x000033A5, 0xC27C2C01}, {0x000033CA, 0xC27D4A01},
    {0x00003402, 0xC2752101}, {0x0000351F, 0xC2752A01}, {0x000037E2, 0xC2754101}, {0x00003EDA, 0xC2757401},
    {0x00004093, 0xC2757801}, {0x00004103, 0xC2757E01}, {0x00004246, 0xC2762601}, {0x00004E00, 0xC2306C01},
    {0x00004E01, 0xC2437A01}, {0x00004E03, 0xC23C3701}, {0x00004E07, 0xC24B7C01}, {0x00004E08, 0xC23E6601},
    {0x00004E09, 0xC23B3001}, {0x00004E0A, 0xC23E6501}, {0x00004E0B, 0xC2323C01}, {0x00004E0D, 0xC2495401},
    {0x00004E0E, 0xC24D3F01}, {0x00004E10, 0xC2502201}, {0x00004E11, 0xC2312F01}, {0x00004E14, 0xC2336E01},
    {0x00004E15, 0xC2502301}, {0x00004E16, 0xC2402401}, {0x00004E17, 0xC2524201}, {0x00004E18, 0xC2355601},
    {0x00004E19, 0xC24A3A01}, {0x00004E1E, 0xC23E6701}, {0x00004E21, 0xC24E3E01}, {0x00004E26, 0xC24A4201},
    {0x00004E2A, 0xC2502401}, {0x00004E2D, 0xC2436601}, {0x00004E31, 0xC2502501}, {0x00004E32, 0xC2367A01},
    {0x00004E36, 0xC2502601}, {0x00004E38, 0xC2345D01}, {0x00004E39, 0xC2433001}, {0x00004E3B, 0xC23C6701},
    {0x00004E3C, 0xC2502701}, {0x00004E3F, 0xC2502801}, {0x00004E42, 0xC2502901}, {0x00004E43, 0xC2473501},
    {0x00004E45, 0xC2355701}, {0x00004E4B, 0xC2473701}, {0x00004E4D, 0xC2466301}, {0x00004E4E, 0xC2384301},
    {0x00004E4F, 0xC24B3301}, {0x00004E55, 0xC2694901}, {0x00004E56, 0xC2502A01}, {0x00004E57, 0xC23E6801},
    {0x00004E58, 0xC2502B01}, {0x00004E59, 0xC2323501}, {0x00004E5D, 0xC2366501}, {0x00004E5E, 0xC2387001},
    {0x00004E5F, 0xC24C6901}, {0x00004E62, 0xC2562601}, {0x00004E71, 0xC24D7001}, {0x00004E73, 0xC2467D01},
    {0x00004E7E, 0xC2342501}, {0x00004E80, 0xC2353501}, {0x00004E82, 0xC2502C01}, {0x00004E85, 0xC2502D01},
    {0x00004E86, 0xC24E3B01}, {0x00004E88, 0xC24D3D01}, {0x00004E89, 0xC2416801}, {0x00004E8A, 0xC2502F01},
    {0x00004E8B, 0xC23B7601}, {0x00004E8C, 0xC2467301}, {0x00004E8E, 0xC2503201}, {0x00004E91, 0xC2313E01},
    {0x00004E92, 0xC2385F01}, {0x00004E94, 0xC2385E01}, {0x00004E95, 0xC2306601}, {0x00004E98, 0xC24F4B01},
    {0x00004E99, 0xC24F4A01}, {0x00004E9B, 0xC23A3301}, {0x00004E9C, 0xC2302101}, {0x00004E9E, 0xC2503303},
    {0x00004EA1, 0xC24B3401}, {0x00004EA2, 0xC2503601}, {0x00004EA4, 0xC2387201}, {0x00004EA5, 0xC2306701},
    {0x00004EA6, 0xC24B7201}, {0x00004EA8, 0xC2357C01}, {0x00004EAB, 0xC2357D02}, {0x00004EAD, 0xC2446201},
    {0x00004EAE, 0xC24E3C01}, {0x00004EB0, 0xC2503701}, {0x00004EB3, 0xC2503801}, {0x00004EB6, 0xC2503901},
    {0x00004EBA, 0xC23F4D01}, {0x00004EC0, 0xC23D3A01}, {0x00004EC1, 0xC23F4E01}, {0x00004EC2, 0xC2503E01},
    {0x00004EC4, 0xC2503C01}, {0x00004EC6, 0xC2503D01}, {0x00004EC7, 0xC2355801}, {0x00004ECA, 0xC23A2301},
    {0x00004ECB, 0xC2327001}, {0x00004ECD, 0xC2503B01}, {0x00004ECE, 0xC2503A01}, {0x00004ECF, 0xC24A2901},
    {0x00004ED4, 0xC23B4601}, {0x00004ED5, 0xC23B4501}, {0x00004ED6, 0xC2423E01}, {0x00004ED7, 0xC2503F01},
    {0x00004ED8, 0xC2495501}, {0x00004ED9, 0xC2406701}, {0x00004EDD, 0xC2213801}, {0x00004EDE, 0xC2504001},
    {0x00004EDF, 0xC2504201}, {0x00004EE3, 0xC2426501}, {0x00004EE4, 0xC24E6101}, {0x00004EE5, 0xC2304A01},
    {0x00004EED, 0xC2504101}, {0x00004EEE, 0xC2323E01}, {0x00004EF0, 0xC2364401}, {0x00004EF2, 0xC2436701},
    {0x00004EF6, 0xC2376F01}, {0x00004EF7, 0xC2504301}, {0x00004EFB, 0xC2472401}, {0x00004EFD, 0xC2752301},
    {0x00004EFF, 0xC2752401}, {0x00004F01, 0xC2346B01}, {0x00004F09, 0xC2504401}, {0x00004F0A, 0xC2304B01},
    {0x00004F0D, 0xC2386001}, {0x00004F0E, 0xC2346C01}, {0x00004F0F, 0xC2497A01}, {0x00004F10, 0xC2483201},
    {0x00004F11, 0xC2355901}, {0x00004F1A, 0xC2327101}, {0x00004F1C, 0xC2506701}, {0x00004F1D, 0xC2454101},
    {0x00004F2F, 0xC2476C01}, {0x00004F30, 0xC2504601}, {0x00004F34, 0xC2483C01}, {0x00004F36, 0xC24E6201},
    {0x00004F38, 0xC23F2D01}, {0x00004F3A, 0xC23B4701}, {0x00004F3C, 0xC23B7701}, {0x00004F3D, 0xC2324001},
    {0x00004F43, 0xC2445101}, {0x00004F46, 0xC2432201}, {0x00004F47, 0xC2504A01}, {0x00004F4D, 0xC2304C01},
    {0x00004F4E, 0xC2446301}, {0x00004F4F, 0xC23D3B01}, {0x00004F50, 0xC23A3401}, {0x00004F51, 0xC24D2401},
    {0x00004F53, 0xC2424E01}, {0x00004F55, 0xC2323F01}, {0x00004F57, 0xC2504901}, {0x00004F59, 0xC24D3E01},
    {0x00004F5A, 0xC2504501}, {0x00004F5B, 0xC2504701}, {0x00004F5C, 0xC23A6E01}, {0x00004F5D, 0xC2504801},
    {0x00004F5E, 0xC2552401}, {0x00004F69, 0xC2505001}, {0x00004F6F, 0xC2505301}, {0x00004F70, 0xC2505101},
    {0x00004F73, 0xC2324201}, {0x00004F75, 0xC24A3B01}, {0x00004F76, 0xC2504B01}, {0x00004F7B, 0xC2504F01},
    {0x00004F7C, 0xC2387301}, {0x00004F7F, 0xC23B4801}, {0x00004F83, 0xC2342601}, {0x00004F86, 0xC2505401},
    {0x00004F88, 0xC2504C01}, {0x00004F8B, 0xC24E6301}, {0x00004F8D, 0xC23B7801}, {0x00004F8F, 0xC2504D01},
    {0x00004F91, 0xC2505201}, {0x00004F96, 0xC2505501}, {0x00004F98, 0xC2504E01}, {0x00004F9A, 0xC2752501},
    {0x00004F9B, 0xC2362101}, {0x00004F9D, 0xC2304D01}, {0x00004FA0, 0xC2362201}, {0x00004FA1, 0xC2324101},
    {0x00004FAB, 0xC2552501}, {0x00004FAD, 0xC24B7901}, {0x00004FAE, 0xC2496E01}, {0x00004FAF, 0xC2387401},
    {0x00004FB5, 0xC23F2F01}, {0x00004FB6, 0xC24E3701}, {0x00004FBF, 0xC24A5801}, {0x00004FC2, 0xC2373801},
    {0x00004FC3, 0xC2422501}, {0x00004FC4, 0xC2326401}, {0x00004FC9, 0xC2752601}, {0x00004FCA, 0xC23D5301},
    {0x00004FCE, 0xC2505901}, {0x00004FD0, 0xC2505E01}, {0x00004FD1, 0xC2505C01}, {0x00004FD4, 0xC2505701},
    {0x00004FD7, 0xC2422F01}, {0x00004FD8, 0xC2505A01}, {0x00004FDA, 0xC2505D01}, {0x00004FDB, 0xC2505B01},
    {0x00004FDD, 0xC24A5D01}, {0x00004FDF, 0xC2505801}, {0x00004FE1, 0xC23F2E01}, {0x00004FE3, 0xC24B7301},
    {0x00004FE4, 0xC2505F02}, {0x00004FEE, 0xC23D2401}, {0x00004FEF, 0xC2506D01}, {0x00004FF3, 0xC2475001},
    {0x00004FF5, 0xC2493601}, {0x00004FF6, 0xC2506801}, {0x00004FF8, 0xC24A7001}, {0x00004FFA, 0xC2323601},
    {0x00004FFE, 0xC2506C01}, {0x00005005, 0xC2506601}, {0x00005006, 0xC2506F01}, {0x00005009, 0xC2415201},
    {0x0000500B, 0xC2384401}, {0x0000500D, 0xC2475C01}, {0x0000500F, 0xC2604701}, {0x00005011, 0xC2506E01},
    {0x00005012, 0xC2455D01}, {0x00005014, 0xC2506301}, {0x00005016, 0xC2387601}, {0x00005019, 0xC2387501},
    {0x0000501A, 0xC2506101}, {0x0000501F, 0xC23C5A01}, {0x00005021, 0xC2506901}, {0x00005023, 0xC24A6F01},
    {0x00005024, 0xC2434D01}, {0x00005025, 0xC2506501}, {0x00005026, 0xC2377101}, {0x00005028, 0xC2506201},
    {0x00005029, 0xC2506A01}, {0x0000502A, 0xC2506401}, {0x0000502B, 0xC24E5101}, {0x0000502C, 0xC2506B01},
    {0x0000502D, 0xC24F4101}, {0x00005036, 0xC2366601}, {0x00005039, 0xC2377001}, {0x00005043, 0xC2507001},
    {0x00005047, 0xC2507101}, {0x00005048, 0xC2507501}, {0x00005049, 0xC2304E01}, {0x0000504F, 0xC24A5001},
    {0x00005050, 0xC2507401}, {0x00005055, 0xC2507301}, {0x00005056, 0xC2507701}, {0x0000505A, 0xC2507601},
    {0x0000505C, 0xC2446401}, {0x00005065, 0xC2377201}, {0x0000506C, 0xC2507801}, {0x00005072, 0xC23C4501},
    {0x00005074, 0xC2422601}, {0x00005075, 0xC2446501}, {0x00005076, 0xC2367601}, {0x00005078, 0xC2507901},
    {0x0000507D, 0xC2353601}, {0x00005080, 0xC2507A01}, {0x00005085, 0xC2507C01}, {0x0000508D, 0xC24B3501},
    {0x00005091, 0xC2376601}, {0x00005098, 0xC23B3101}, {0x00005099, 0xC2487701}, {0x0000509A, 0xC2507B01},
    {0x0000509C, 0xC2752701}, {0x000050AC, 0xC23A4501}, {0x000050AD, 0xC24D4301}, {0x000050B2, 0xC2507E01},
    {0x000050B3, 0xC2512301}, {0x000050B4, 0xC2507D01}, {0x000050B5, 0xC23A4401}, {0x000050B7, 0xC23D7D01},
    {0x000050BE, 0xC2373901}, {0x000050C2, 0xC2512401}, {0x000050C5, 0xC2364F01}, {0x000050C9, 0xC2512102},
    {0x000050CD, 0xC2462F01}, {0x000050CF, 0xC2417C01}, {0x000050D1, 0xC2362301}, {0x000050D5, 0xC24B4D01},
    {0x000050D6, 0xC2512501}, {0x000050DA, 0xC24E3D01}, {0x000050DE, 0xC2512601}, {0x000050E3, 0xC2512901},
    {0x000050E5, 0xC2512701}, {0x000050E7, 0xC2414E01}, {0x000050ED, 0xC2512801}, {0x000050EE, 0xC2512A01},
    {0x000050F5, 0xC2512C01}, {0x000050F9, 0xC2512B01}, {0x000050FB, 0xC24A4801}, {0x00005100, 0xC2353701},
    {0x00005101, 0xC2512E02}, {0x00005104, 0xC2322F01}, {0x00005109, 0xC2512D01}, {0x00005112, 0xC23C7401},
    {0x00005114, 0xC2513201}, {0x00005115, 0xC2513101}, {0x00005116, 0xC2513001}, {0x00005118, 0xC2505601},
    {0x0000511A, 0xC2513301}, {0x0000511E, 0xC2752801}, {0x0000511F, 0xC23D7E01}, {0x00005121, 0xC2513401},
    {0x0000512A, 0xC24D2501}, {0x00005132, 0xC24C5901}, {0x00005137, 0xC2513601}, {0x0000513A, 0xC2513501},
    {0x0000513B, 0xC2513801}, {0x0000513C, 0xC2513701}, {0x0000513F, 0xC2513902}, {0x00005141, 0xC2307401},
    {0x00005143, 0xC2383501}, {0x00005144, 0xC2373B01}, {0x00005145, 0xC23D3C01}, {0x00005146, 0xC2437B01},
    {0x00005147, 0xC2362401}, {0x00005148, 0xC2406801}, {0x00005149, 0xC2387701}, {0x0000514B, 0xC2396E01},
    {0x0000514C, 0xC2513C01}, {0x0000514D, 0xC24C4801}, {0x0000514E, 0xC2454601}, {0x00005150, 0xC23B7901},
    {0x00005152, 0xC2513B01}, {0x00005154, 0xC2513D01}, {0x0000515A, 0xC2455E01}, {0x0000515C, 0xC2337501},
    {0x00005162, 0xC2513E01}, {0x00005165, 0xC2467E01}, {0x00005168, 0xC2413401}, {0x00005169, 0xC2514002},
    {0x0000516B, 0xC2482C01}, {0x0000516C, 0xC2387801}, {0x0000516D, 0xC24F3B01}, {0x0000516E, 0xC2514201},
    {0x00005171, 0xC2362601}, {0x00005175, 0xC24A3C01}, {0x00005176, 0xC2423601}, {0x00005177, 0xC2367101},
    {0x00005178, 0xC2453501}, {0x0000517C, 0xC2377301}, {0x00005180, 0xC2514301}, {0x00005182, 0xC2514401},
    {0x00005185, 0xC2466201}, {0x00005186, 0xC2315F01}, {0x00005189, 0xC2514701}, {0x0000518A, 0xC23A7D01},
    {0x0000518C, 0xC2514601}, {0x0000518D, 0xC23A4601}, {0x0000518F, 0xC2514801}, {0x00005190, 0xC2666E01},
    {0x00005191, 0xC2514901}, {0x00005192, 0xC24B4101}, {0x00005193, 0xC2514A01}, {0x00005195, 0xC2514B02},
    {0x00005197, 0xC23E6901}, {0x00005199, 0xC23C4C01}, {0x000051A0, 0xC2342701}, {0x000051A2, 0xC2514F01},
    {0x000051A4, 0xC2514D01}, {0x000051A5, 0xC24C3D01}, {0x000051A6, 0xC2514E01}, {0x000051A8, 0xC2495A01},
    {0x000051A9, 0xC2515003}, {0x000051AC, 0xC2455F01}, {0x000051B0, 0xC2515601}, {0x000051B1, 0xC2515402},
    {0x000051B3, 0xC2515301}, {0x000051B4, 0xC23A6301}, {0x000051B5, 0xC2515701}, {0x000051B6, 0xC24C6A01},
    {0x000051B7, 0xC24E6401}, {0x000051BC, 0xC2752901}, {0x000051BD, 0xC2515801}, {0x000051C4, 0xC2402801},
    {0x000051C5, 0xC2515901}, {0x000051C6, 0xC23D5A01}, {0x000051C9, 0xC2515A01}, {0x000051CB, 0xC2437C01},
    {0x000051CC, 0xC24E3F01}, {0x000051CD, 0xC2456001}, {0x000051D6, 0xC2524501}, {0x000051DB, 0xC2515B01},
    {0x000051DC, 0xC2742501}, {0x000051DD, 0xC2364501}, {0x000051E0, 0xC2515C01}, {0x000051E1, 0xC24B5E01},
    {0x000051E6, 0xC23D6801}, {0x000051E7, 0xC2427C01}, {0x000051E9, 0xC2515E01}, {0x000051EA, 0xC2466401},
    {0x000051ED, 0xC2515F01}, {0x000051F0, 0xC2516001}, {0x000051F1, 0xC2332E01}, {0x000051F5, 0xC2516101},
    {0x000051F6, 0xC2362701}, {0x000051F8, 0xC2464C01}, {0x000051F9, 0xC2317A01}, {0x000051FA, 0xC23D5001},
    {0x000051FD, 0xC2482101}, {0x000051FE, 0xC2516201}, {0x00005200, 0xC2456101}, {0x00005203, 0xC23F4F01},
    {0x00005204, 0xC2516301}, {0x00005206, 0xC24A2C01}, {0x00005207, 0xC2405A01}, {0x00005208, 0xC2342201},
    {0x0000520A, 0xC2342901}, {0x0000520B, 0xC2516401}, {0x0000520E, 0xC2516601}, {0x00005211, 0xC2373A01},
    {0x00005214, 0xC2516501}, {0x00005217, 0xC24E7301}, {0x0000521D, 0xC23D6901}, {0x00005224, 0xC2483D01},
    {0x00005225, 0xC24A4C01}, {0x00005227, 0xC2516701}, {0x00005229, 0xC24D7801}, {0x0000522A, 0xC2516801},
    {0x0000522E, 0xC2516901}, {0x00005230, 0xC2457E01}, {0x00005233, 0xC2516A01}, {0x00005236, 0xC2402901},
    {0x00005237, 0xC23A7E01}, {0x00005238, 0xC2377401}, {0x00005239, 0xC2516B01}, {0x0000523A, 0xC23B4901},
    {0x0000523B, 0xC2396F01}, {0x00005243, 0xC2446601}, {0x00005244, 0xC2516D01}, {0x00005247, 0xC2422701},
    {0x0000524A, 0xC23A6F01}, {0x0000524B, 0xC2516E02}, {0x0000524D, 0xC2413001}, {0x0000524F, 0xC2516C01},
    {0x00005254, 0xC2517101}, {0x00005256, 0xC24B3601}, {0x0000525B, 0xC2396401}, {0x0000525E, 0xC2517001},
    {0x00005263, 0xC2377501}, {0x00005264, 0xC23A5E01}, {0x00005265, 0xC2476D01}, {0x00005269, 0xC2517401},
    {0x0000526A, 0xC2517201}, {0x0000526F, 0xC2497B01}, {0x00005270, 0xC23E6A01}, {0x00005271, 0xC2517B01},
    {0x00005272, 0xC2336401}, {0x00005273, 0xC2517501}, {0x00005274, 0xC2517301}, {0x00005275, 0xC2414F01},
    {0x0000527D, 0xC2517701}, {0x0000527F, 0xC2517601}, {0x00005283, 0xC2334401}, {0x00005287, 0xC2376001},
    {0x00005288, 0xC2517C01}, {0x00005289, 0xC24E2D01}, {0x0000528D, 0xC2517801}, {0x00005291, 0xC2517D01},
    {0x00005292, 0xC2517A01}, {0x00005294, 0xC2517901}, {0x0000529B, 0xC24E4F01}, {0x0000529F, 0xC2387901},
    {0x000052A0, 0xC2324301}, {0x000052A3, 0xC24E7401}, {0x000052A9, 0xC23D7501}, {0x000052AA, 0xC2455801},
    {0x000052AB, 0xC2396501}, {0x000052AC, 0xC2522202}, {0x000052B1, 0xC24E6501}, {0x000052B4, 0xC24F2B01},
    {0x000052B5, 0xC2522501}, {0x000052B9, 0xC2387A01}, {0x000052BC, 0xC2522401}, {0x000052BE, 0xC2332F01},
    {0x000052C1, 0xC2522601}, {0x000052C3, 0xC24B5601}, {0x000052C5, 0xC2443C01}, {0x000052C7, 0xC24D2601},
    {0x000052C9, 0xC24A5901}, {0x000052CD, 0xC2522701}, {0x000052D2, 0xC2705501}, {0x000052D5, 0xC2463001},
    {0x000052D7, 0xC2522801}, {0x000052D8, 0xC2342A01}, {0x000052D9, 0xC24C3301}, {0x000052DD, 0xC23E2101},
    {0x000052DE, 0xC2522901}, {0x000052DF, 0xC24A6701}, {0x000052E0, 0xC2522D01}, {0x000052E2, 0xC2402A01},
    {0x000052E3, 0xC2522A01}, {0x000052E4, 0xC2365001}, {0x000052E6, 0xC2522B01}, {0x000052E7, 0xC2342B01},
    {0x000052F2, 0xC2372E01}, {0x000052F3, 0xC2522E01}, {0x000052F5, 0xC2522F01}, {0x000052F8, 0xC2523002},
    {0x000052FA, 0xC23C5B01}, {0x000052FE, 0xC2387B01}, {0x000052FF, 0xC24C5E01}, {0x00005301, 0xC24C6801},
    {0x00005302, 0xC2467701}, {0x00005305, 0xC24A7101}, {0x00005306, 0xC2523201}, {0x00005307, 0xC2752B01},
    {0x00005308, 0xC2523301}, {0x0000530D, 0xC2523501}, {0x0000530F, 0xC2523701}, {0x00005310, 0xC2523601},
    {0x00005315, 0xC2523801}, {0x00005316, 0xC2323D01}, {0x00005317, 0xC24B4C01}, {0x00005319, 0xC23A7C01},
    {0x0000531A, 0xC2523901}, {0x0000531D, 0xC2415901}, {0x00005320, 0xC23E2201}, {0x00005321, 0xC2362901},
    {0x00005323, 0xC2523A01}, {0x0000532A, 0xC2485B01}, {0x0000532F, 0xC2523B01}, {0x00005331, 0xC2523C01},
    {0x00005333, 0xC2523D01}, {0x00005338, 0xC2523E01}, {0x00005339, 0xC2492401}, {0x0000533A, 0xC2366801},
    {0x0000533B, 0xC2306501}, {0x0000533F, 0xC2463F01}, {0x00005340, 0xC2523F01}, {0x00005341, 0xC23D3D01},
    {0x00005343, 0xC2406901}, {0x00005345, 0xC2524101}, {0x00005346, 0xC2524001}, {0x00005347, 0xC23E2301},
    {0x00005348, 0xC2386101}, {0x00005349, 0xC2524301}, {0x0000534A, 0xC2483E01}, {0x0000534D, 0xC2524401},
    {0x00005351, 0xC2485C01}, {0x00005352, 0xC2423401}, {0x00005353, 0xC2426E01}, {0x00005354, 0xC2362801},
    {0x00005357, 0xC2466E01}, {0x00005358, 0xC2433101}, {0x0000535A, 0xC2476E01}, {0x0000535C, 0xC24B4E01},
    {0x0000535E, 0xC2524601}, {0x00005360, 0xC2406A01}, {0x00005361, 0xC2752C01}, {0x00005366, 0xC2373501},
    {0x00005369, 0xC2524701}, {0x0000536C, 0xC2752D01}, {0x0000536E, 0xC2524801}, {0x0000536F, 0xC2312C01},
    {0x00005370, 0xC2307501}, {0x00005371, 0xC2346D01}, {0x00005373, 0xC2422801}, {0x00005374, 0xC2355101},
    {0x00005375, 0xC24D7101}, {0x00005377, 0xC2524B01}, {0x00005378, 0xC2323701}, {0x0000537B, 0xC2524A01},
    {0x0000537F, 0xC2362A01}, {0x00005382, 0xC2524C01}, {0x00005384, 0xC24C7101}, {0x00005396, 0xC2524D01},
    {0x00005398, 0xC24E5201}, {0x0000539A, 0xC2387C01}, {0x0000539F, 0xC2383601}, {0x000053A0, 0xC2524E01},
    {0x000053A5, 0xC2525001}, {0x000053A6, 0xC2524F01}, {0x000053A8, 0xC23F5F01}, {0x000053A9, 0xC2313901},
    {0x000053AD, 0xC2315E01}, {0x000053AE, 0xC2525101}, {0x000053B0, 0xC2525201}, {0x000053B3, 0xC2383701},
    {0x000053B6, 0xC2525301}, {0x000053BB, 0xC2356E01}, {0x000053C2, 0xC23B3201}, {0x000053C3, 0xC2525401},
    {0x000053C8, 0xC24B7401}, {0x000053C9, 0xC23A3501}, {0x000053CA, 0xC2355A01}, {0x000053CB, 0xC24D2701},
    {0x000053CC, 0xC2415001}, {0x000053CD, 0xC2483F01}, {0x000053CE, 0xC23C7D01}, {0x000053D4, 0xC23D4701},
    {0x000053D6, 0xC23C6801}, {0x000053D7, 0xC23C7501}, {0x000053D9, 0xC23D7601}, {0x000053DB, 0xC2484001},
    {0x000053DF, 0xC2525701}, {0x000053E1, 0xC2314301}, {0x000053E2, 0xC2415101}, {0x000053E3, 0xC2387D01},
    {0x000053E4, 0xC2384501}, {0x000053E5, 0xC2366701}, {0x000053E8, 0xC2525B01}, {0x000053E9, 0xC2432101},
    {0x000053EA, 0xC2427E01}, {0x000053EB, 0xC2362B01}, {0x000053EC, 0xC23E2401}, {0x000053ED, 0xC2525C01},
    {0x000053EE, 0xC2525A01}, {0x000053EF, 0xC2324401}, {0x000053F0, 0xC2426601}, {0x000053F1, 0xC23C3801},
    {0x000053F2, 0xC23B4B01}, {0x000053F3, 0xC2312601}, {0x000053F6, 0xC2337001}, {0x000053F7, 0xC2396601},
    {0x000053F8, 0xC23B4A01}, {0x000053FA, 0xC2525D01}, {0x00005401, 0xC2525E01}, {0x00005403, 0xC2354901},
    {0x00005404, 0xC2334601}, {0x00005408, 0xC2396701}, {0x00005409, 0xC2354801}, {0x0000540A, 0xC2445F01},
    {0x0000540B, 0xC2312501}, {0x0000540C, 0xC2463101}, {0x0000540D, 0xC24C3E01}, {0x0000540E, 0xC2392101},
    {0x0000540F, 0xC24D7901}, {0x00005410, 0xC2454701}, {0x00005411, 0xC2387E01}, {0x0000541B, 0xC2372F01},
    {0x0000541D, 0xC2526701}, {0x0000541F, 0xC2366301}, {0x00005420, 0xC24B4A01}, {0x00005426, 0xC2485D01},
    {0x00005429, 0xC2526601}, {0x0000542B, 0xC2345E01}, {0x0000542C, 0xC2526102}, {0x0000542E, 0xC2526401},
    {0x00005436, 0xC2526501}, {0x00005438, 0xC2355B01}, {0x00005439, 0xC23F6101}, {0x0000543B, 0xC24A2D01},
    {0x0000543C, 0xC2526301}, {0x0000543D, 0xC2525F01}, {0x0000543E, 0xC2386301}, {0x00005440, 0xC2526001},
    {0x00005442, 0xC24F2401}, {0x00005446, 0xC24A7201}, {0x00005448, 0xC2446801}, {0x00005449, 0xC2386201},
    {0x0000544A, 0xC2397001}, {0x0000544D, 0xC2753001}, {0x0000544E, 0xC2526801}, {0x00005451, 0xC2465D01},
    {0x0000545F, 0xC2526C01}, {0x00005468, 0xC23C7E01}, {0x0000546A, 0xC23C7601}, {0x00005470, 0xC2526F01},
    {0x00005471, 0xC2526D01}, {0x00005473, 0xC24C2301}, {0x00005475, 0xC2526A01}, {0x00005476, 0xC2527301},
    {0x00005477, 0xC2526E01}, {0x0000547B, 0xC2527101}, {0x0000547C, 0xC2384601}, {0x0000547D, 0xC24C3F01},
    {0x00005480, 0xC2527201}, {0x00005484, 0xC2527401}, {0x00005486, 0xC2527601}, {0x0000548B, 0xC23A7001},
    {0x0000548C, 0xC24F4201}, {0x0000548E, 0xC2526B01}, {0x0000548F, 0xC2526901}, {0x00005490, 0xC2527501},
    {0x00005492, 0xC2527001}, {0x00005496, 0xC2753101}, {0x0000549C, 0xC2753201}, {0x000054A2, 0xC2527801},
    {0x000054A4, 0xC2532301}, {0x000054A5, 0xC2527A01}, {0x000054A8, 0xC2527E01}, {0x000054A9, 0xC2753301},
    {0x000054AB, 0xC2532101}, {0x000054AC, 0xC2527B01}, {0x000054AF, 0xC2533E01}, {0x000054B2, 0xC23A6901},
    {0x000054B3, 0xC2333101}, {0x000054B8, 0xC2527901}, {0x000054BC, 0xC2532501}, {0x000054BD, 0xC2307601},
    {0x000054BE, 0xC2532401}, {0x000054C0, 0xC2302501}, {0x000054C1, 0xC2494A01}, {0x000054C2, 0xC2532201},
    {0x000054C4, 0xC2527C01}, {0x000054C7, 0xC2527701}, {0x000054C8, 0xC2527D01}, {0x000054C9, 0xC23A4801},
    {0x000054D8, 0xC2532601}, {0x000054E1, 0xC2307701}, {0x000054E2, 0xC2532F01}, {0x000054E5, 0xC2532702},
    {0x000054E8, 0xC23E2501}, {0x000054E9, 0xC24B6901}, {0x000054ED, 0xC2532D01}, {0x000054EE, 0xC2532C01},
    {0x000054F2, 0xC2452F01}, {0x000054FA, 0xC2532E01}, {0x000054FD, 0xC2532B01}, {0x00005504, 0xC2313401},
    {0x00005506, 0xC23A3601}, {0x00005507, 0xC23F3001}, {0x0000550E, 0xC2753401}, {0x0000550F, 0xC2532901},
    {0x00005510, 0xC2456201}, {0x00005514, 0xC2532A01}, {0x00005516, 0xC2302201}, {0x0000552E, 0xC2533401},
    {0x0000552F, 0xC24D2301}, {0x00005531, 0xC23E2701}, {0x00005533, 0xC2533A01}, {0x00005538, 0xC2533901},
    {0x00005539, 0xC2533001}, {0x0000553E, 0xC2424301}, {0x00005540, 0xC2533101}, {0x00005544, 0xC2426F01},
    {0x00005545, 0xC2533601}, {0x00005546, 0xC23E2601}, {0x0000554A, 0xC2753501}, {0x0000554C, 0xC2533301},
    {0x0000554F, 0xC24C6401}, {0x00005553, 0xC2373C01}, {0x00005556, 0xC2533702}, {0x0000555C, 0xC2533501},
    {0x0000555D, 0xC2533B01}, {0x00005563, 0xC2533201}, {0x0000557B, 0xC2534101}, {0x0000557C, 0xC2534601},
    {0x0000557E, 0xC2534201}, {0x00005580, 0xC2533D01}, {0x00005583, 0xC2534701}, {0x00005584, 0xC2413101},
    {0x00005587, 0xC2534901}, {0x00005589, 0xC2392201}, {0x0000558A, 0xC2533F01}, {0x0000558B, 0xC2437D01},
    {0x00005598, 0xC2534301}, {0x00005599, 0xC2533C01}, {0x0000559A, 0xC2342D01}, {0x0000559C, 0xC2346E01},
    {0x0000559D, 0xC2336501}, {0x0000559E, 0xC2534401}, {0x0000559F, 0xC2534001}, {0x000055A7, 0xC2377601},
    {0x000055A8, 0xC2534A01}, {0x000055A9, 0xC2534801}, {0x000055AA, 0xC2415301}, {0x000055AB, 0xC2354A01},
    {0x000055AC, 0xC2362C01}, {0x000055AE, 0xC2534501}, {0x000055B0, 0xC2367401}, {0x000055B6, 0xC2314401},
    {0x000055C4, 0xC2534E01}, {0x000055C5, 0xC2534C01}, {0x000055C7, 0xC2542701}, {0x000055D4, 0xC2535101},
    {0x000055DA, 0xC2534B01}, {0x000055DC, 0xC2534F01}, {0x000055DF, 0xC2534D01}, {0x000055E3, 0xC23B4C01},
    {0x000055E4, 0xC2535001}, {0x000055F7, 0xC2535301}, {0x000055F9, 0xC2535801}, {0x000055FD, 0xC2535601},
    {0x000055FE, 0xC2535501}, {0x00005606, 0xC2433201}, {0x00005609, 0xC2324501}, {0x00005614, 0xC2535201},
    {0x00005616, 0xC2535401}, {0x00005617, 0xC23E2801}, {0x00005618, 0xC2313301}, {0x0000561B, 0xC2535701},
    {0x00005629, 0xC2325E01}, {0x0000562F, 0xC2536201}, {0x00005631, 0xC23E7C01}, {0x00005632, 0xC2535E01},
    {0x00005634, 0xC2535C01}, {0x00005636, 0xC2535D01}, {0x00005638, 0xC2535F01}, {0x00005642, 0xC2313D01},
    {0x0000564C, 0xC2413901}, {0x0000564E, 0xC2535901}, {0x00005650, 0xC2535A01}, {0x0000565B, 0xC2337A01},
    {0x00005664, 0xC2536101}, {0x00005668, 0xC2346F01}, {0x0000566A, 0xC2536401}, {0x0000566B, 0xC2536001},
    {0x0000566C, 0xC2536301}, {0x00005672, 0xC2753601}, {0x00005674, 0xC24A2E01}, {0x00005678, 0xC2465501},
    {0x0000567A, 0xC2483801}, {0x00005680, 0xC2536601}, {0x00005686, 0xC2536501}, {0x00005687, 0xC2334501},
    {0x0000568A, 0xC2536701}, {0x0000568F, 0xC2536A01}, {0x00005694, 0xC2536901}, {0x000056A0, 0xC2536801},
    {0x000056A2, 0xC2473901}, {0x000056A5, 0xC2536B01}, {0x000056AE, 0xC2536C01}, {0x000056B4, 0xC2536E01},
    {0x000056B6, 0xC2536D01}, {0x000056BC, 0xC2537001}, {0x000056C0, 0xC2537301}, {0x000056C1, 0xC2537101},
    {0x000056C2, 0xC2536F01}, {0x000056C3, 0xC2537201}, {0x000056C8, 0xC2537401}, {0x000056CE, 0xC2537501},
    {0x000056D1, 0xC2537601}, {0x000056D3, 0xC2537701}, {0x000056D7, 0xC2537801}, {0x000056D8, 0xC2514501},
    {0x000056DA, 0xC23C7C01}, {0x000056DB, 0xC23B4D01}, {0x000056DE, 0xC2327301}, {0x000056E0, 0xC2307801},
    {0x000056E3, 0xC2434401}, {0x000056E4, 0xC2753701}, {0x000056EE, 0xC2537901}, {0x000056F0, 0xC23A2401},
    {0x000056F2, 0xC2304F01}, {0x000056F3, 0xC23F5E01}, {0x000056F9, 0xC2537A01}, {0x000056FA, 0xC2384701},
    {0x000056FD, 0xC2397101}, {0x000056FF, 0xC2537C01}, {0x00005700, 0xC2537B01}, {0x00005703, 0xC24A6001},
    {0x00005704, 0xC2537D01}, {0x00005708, 0xC2542101}, {0x00005709, 0xC2537E01}, {0x0000570B, 0xC2542201},
    {0x0000570D, 0xC2542301}, {0x0000570F, 0xC2377701}, {0x00005712, 0xC2316001}, {0x00005713, 0xC2542401},
    {0x00005716, 0xC2542601}, {0x00005718, 0xC2542501}, {0x0000571C, 0xC2542801}, {0x0000571F, 0xC2455A01},
    {0x00005726, 0xC2542901}, {0x00005727, 0xC2303501}, {0x00005728, 0xC23A5F01}, {0x0000572D, 0xC2373D01},
    {0x00005730, 0xC2434F01}, {0x00005733, 0xC2753802}, {0x00005737, 0xC2542A02}, {0x0000573B, 0xC2542D01},
    {0x00005740, 0xC2542E01}, {0x00005742, 0xC23A6401}, {0x00005747, 0xC2365101}, {0x0000574A, 0xC24B3701},
    {0x0000574E, 0xC2542C01}, {0x0000574F, 0xC2542F01}, {0x00005750, 0xC23A4101}, {0x00005751, 0xC2392301},
    {0x00005761, 0xC2543301}, {0x00005764, 0xC23A2501}, {0x00005766, 0xC2433301}, {0x00005769, 0xC2543001},
    {0x0000576A, 0xC2445A01}, {0x0000577F, 0xC2543401}, {0x00005782, 0xC23F6201}, {0x00005788, 0xC2543201},
    {0x00005789, 0xC2543501}, {0x0000578B, 0xC2373F01}, {0x00005793, 0xC2543601}, {0x000057A0, 0xC2543701},
    {0x000057A2, 0xC2392401}, {0x000057A3, 0xC2334001}, {0x000057A4, 0xC2543901}, {0x000057AA, 0xC2543A01},
    {0x000057B0, 0xC2543B01}, {0x000057B3, 0xC2543801}, {0x000057B7, 0xC2754501}, {0x000057C0, 0xC2543101},
    {0x000057C3, 0xC2543C01}, {0x000057C6, 0xC2543D01}, {0x000057CB, 0xC24B6401}, {0x000057CE, 0xC23E6B01},
    {0x000057D2, 0xC2543F02}, {0x000057D4, 0xC2543E01}, {0x000057D6, 0xC2544201}, {0x000057DC, 0xC2473801},
    {0x000057DF, 0xC2306801}, {0x000057E0, 0xC2495601}, {0x000057E3, 0xC2544301}, {0x000057F4, 0xC23E7D01},
    {0x000057F7, 0xC23C3901}, {0x000057F9, 0xC2475D01}, {0x000057FA, 0xC2347001}, {0x000057FC, 0xC23A6B01},
    {0x00005800, 0xC24B5901}, {0x00005802, 0xC2463201}, {0x00005805, 0xC2377801}, {0x00005806, 0xC2424F01},
    {0x0000580A, 0xC2544101}, {0x0000580B, 0xC2544401}, {0x00005815, 0xC2424401}, {0x00005819, 0xC2544501},
    {0x0000581D, 0xC2544601}, {0x00005821, 0xC2544801}, {0x00005824, 0xC2446901}, {0x0000582A, 0xC2342E01},
    {0x0000582F, 0xC2742101}, {0x00005830, 0xC2316101}, {0x00005831, 0xC24A7301}, {0x00005834, 0xC23E6C01},
    {0x00005835, 0xC2454801}, {0x0000583A, 0xC23A6601}, {0x0000583D, 0xC2544E01}, {0x00005840, 0xC24A3D01},
    {0x00005841, 0xC24E5D01}, {0x0000584A, 0xC2327401}, {0x0000584B, 0xC2544A01}, {0x00005851, 0xC2413A01},
    {0x00005852, 0xC2544D01}, {0x00005854, 0xC2456301}, {0x00005857, 0xC2454901}, {0x00005858, 0xC2456401},
    {0x00005859, 0xC2483901}, {0x0000585A, 0xC2444D01}, {0x0000585E, 0xC23A4901}, {0x00005862, 0xC2544901},
    {0x00005869, 0xC2317601}, {0x0000586B, 0xC2453601}, {0x00005870, 0xC2544B01}, {0x00005872, 0xC2544701},
    {0x00005875, 0xC23F5001}, {0x00005879, 0xC2544F01}, {0x0000587E, 0xC23D4E01}, {0x00005880, 0xC2753B01},
    {0x00005883, 0xC2362D01}, {0x00005885, 0xC2545001}, {0x00005893, 0xC24A6801}, {0x00005897, 0xC2417D01},
    {0x0000589C, 0xC2444601}, {0x0000589F, 0xC2545201}, {0x000058A8, 0xC24B4F01}, {0x000058AB, 0xC2545301},
    {0x000058AE, 0xC2545801}, {0x000058B3, 0xC24A2F01}, {0x000058B8, 0xC2545701}, {0x000058B9, 0xC2545101},
    {0x000058BA, 0xC2545401}, {0x000058BB, 0xC2545601}, {0x000058BE, 0xC23A2601}, {0x000058C1, 0xC24A4901},
    {0x000058C5, 0xC2545901}, {0x000058C7, 0xC2434501}, {0x000058CA, 0xC2327501}, {0x000058CC, 0xC23E6D01},
    {0x000058D1, 0xC2545B01}, {0x000058D3, 0xC2545A01}, {0x000058D5, 0xC2396801}, {0x000058D7, 0xC2545C01},
    {0x000058D8, 0xC2545E01}, {0x000058D9, 0xC2545D01}, {0x000058DC, 0xC2546001}, {0x000058DE, 0xC2545501},
    {0x000058DF, 0xC2546201}, {0x000058E4, 0xC2546101}, {0x000058E5, 0xC2545F01}, {0x000058EB, 0xC23B4E01},
    {0x000058EC, 0xC23F5101}, {0x000058EE, 0xC2415401}, {0x000058EF, 0xC2546301}, {0x000058F0, 0xC2403C01},
    {0x000058F1, 0xC2306D01}, {0x000058F2, 0xC2476401}, {0x000058F7, 0xC2445B01}, {0x000058F9, 0xC2546501},
    {0x000058FA, 0xC2546401}, {0x000058FB, 0xC2546603}, {0x00005902, 0xC2546901}, {0x00005909, 0xC24A5101},
    {0x0000590A, 0xC2546A01}, {0x0000590F, 0xC2324601}, {0x00005910, 0xC2546B01}, {0x00005915, 0xC24D3C01},
    {0x00005916, 0xC2333001}, {0x00005918, 0xC2524901}, {0x00005919, 0xC23D4801}, {0x0000591A, 0xC2423F01},
    {0x0000591B, 0xC2546C01}, {0x0000591C, 0xC24C6B01}, {0x00005922, 0xC24C3401}, {0x00005925, 0xC2546E01},
    {0x00005927, 0xC2426701}, {0x00005929, 0xC2453701}, {0x0000592A, 0xC2424001}, {0x0000592B, 0xC2495701},
    {0x0000592C, 0xC2546F02}, {0x0000592E, 0xC2317B01}, {0x00005931, 0xC23C3A01}, {0x00005932, 0xC2547101},
    {0x00005937, 0xC2305001}, {0x00005938, 0xC2547201}, {0x0000593E, 0xC2547301}, {0x00005944, 0xC2316201},
    {0x00005947, 0xC2347101}, {0x00005948, 0xC2466001}, {0x00005949, 0xC24A7401}, {0x0000594E, 0xC2547701},
    {0x0000594F, 0xC2415501}, {0x00005950, 0xC2547601}, {0x00005951, 0xC2374001}, {0x00005954, 0xC24B5B01},
    {0x00005955, 0xC2547501}, {0x00005957, 0xC2456501}, {0x00005958, 0xC2547901}, {0x0000595A, 0xC2547801},
    {0x00005960, 0xC2547B01}, {0x00005962, 0xC2547A01}, {0x00005965, 0xC2317C01}, {0x00005967, 0xC2547C01},
    {0x00005968, 0xC23E2901}, {0x00005969, 0xC2547E01}, {0x0000596A, 0xC2432501}, {0x0000596C, 0xC2547D01},
    {0x0000596E, 0xC24A3301}, {0x00005973, 0xC23D7701}, {0x00005974, 0xC2455B01}, {0x00005978, 0xC2552101},
    {0x0000597D, 0xC2392501}, {0x00005981, 0xC2552201}, {0x00005982, 0xC2472101}, {0x00005983, 0xC2485E01},
    {0x00005984, 0xC24C5101}, {0x0000598A, 0xC2472501}, {0x0000598D, 0xC2552B01}, {0x00005993, 0xC2353801},
    {0x00005996, 0xC24D4501}, {0x00005999, 0xC24C2F01}, {0x0000599B, 0xC2562C01}, {0x0000599D, 0xC2552301},
    {0x000059A3, 0xC2552601}, {0x000059A5, 0xC2424501}, {0x000059A8, 0xC24B3801}, {0x000059AC, 0xC2454A01},
    {0x000059B2, 0xC2552701}, {0x000059B9, 0xC24B6501}, {0x000059BB, 0xC23A4A01}, {0x000059BE, 0xC23E2A01},
    {0x000059C6, 0xC2552801}, {0x000059C9, 0xC23B5001}, {0x000059CB, 0xC23B4F01}, {0x000059D0, 0xC2303901},
    {0x000059D1, 0xC2384801}, {0x000059D3, 0xC2402B01}, {0x000059D4, 0xC2305101}, {0x000059D9, 0xC2552C02},
    {0x000059DC, 0xC2552A01}, {0x000059E4, 0xC2753C01}, {0x000059E5, 0xC2313801}, {0x000059E6, 0xC2342F01},
    {0x000059E8, 0xC2552901}, {0x000059EA, 0xC24C4501}, {0x000059EB, 0xC2493101}, {0x000059F6, 0xC2302801},
    {0x000059FB, 0xC2307901}, {0x000059FF, 0xC23B5101}, {0x00005A01, 0xC2305201}, {0x00005A03, 0xC2302301},
    {0x00005A09, 0xC2553201}, {0x00005A11, 0xC2553001}, {0x00005A18, 0xC24C3C01}, {0x00005A1A, 0xC2553301},
    {0x00005A1C, 0xC2553101}, {0x00005A1F, 0xC2552F01}, {0x00005A20, 0xC23F3101}, {0x00005A23, 0xC2753D01},
    {0x00005A25, 0xC2552E01}, {0x00005A29, 0xC24A5A01}, {0x00005A2F, 0xC2386401}, {0x00005A35, 0xC2553702},
    {0x00005A3C, 0xC23E2B01}, {0x00005A40, 0xC2553401}, {0x00005A41, 0xC24F2C01}, {0x00005A46, 0xC2474C01},
    {0x00005A49, 0xC2553601}, {0x00005A55, 0xC2753E01}, {0x00005A5A, 0xC23A2701}, {0x00005A62, 0xC2553901},
    {0x00005A66, 0xC2495801}, {0x00005A6A, 0xC2553A01}, {0x00005A6C, 0xC2553501}, {0x00005A7F, 0xC24C3B01},
    {0x00005A92, 0xC2475E01}, {0x00005A9A, 0xC2553B01}, {0x00005A9B, 0xC2493201}, {0x00005ABC, 0xC2553C01},
    {0x00005ABD, 0xC2554001}, {0x00005ABE, 0xC2553D01}, {0x00005AC1, 0xC2324701}, {0x00005AC2, 0xC2553F01},
    {0x00005AC9, 0xC23C3B01}, {0x00005ACB, 0xC2553E01}, {0x00005ACC, 0xC2377901}, {0x00005AD0, 0xC2554C01},
    {0x00005AD6, 0xC2554501}, {0x00005AD7, 0xC2554201}, {0x00005AE1, 0xC2436401}, {0x00005AE3, 0xC2554101},
    {0x00005AE6, 0xC2554301}, {0x00005AE9, 0xC2554401}, {0x00005AFA, 0xC2554602}, {0x00005B09, 0xC2347201},
    {0x00005B0B, 0xC2554901}, {0x00005B0C, 0xC2554801}, {0x00005B16, 0xC2554A01}, {0x00005B22, 0xC23E6E01},
    {0x00005B2A, 0xC2554D01}, {0x00005B2C, 0xC2445C01}, {0x00005B30, 0xC2314501}, {0x00005B32, 0xC2554B01},
    {0x00005B36, 0xC2554E01}, {0x00005B3E, 0xC2554F01}, {0x00005B40, 0xC2555201}, {0x00005B43, 0xC2555001},
    {0x00005B45, 0xC2555101}, {0x00005B50, 0xC23B5201}, {0x00005B51, 0xC2555301}, {0x00005B54, 0xC2392601},
    {0x00005B55, 0xC2555401}, {0x00005B57, 0xC23B7A01}, {0x00005B58, 0xC2423801}, {0x00005B5A, 0xC2555502},
    {0x00005B5C, 0xC23B5A01}, {0x00005B5D, 0xC2392701}, {0x00005B5F, 0xC24C5201}, {0x00005B63, 0xC2352801},
    {0x00005B64, 0xC2384901}, {0x00005B65, 0xC2555701}, {0x00005B66, 0xC2335801}, {0x00005B69, 0xC2555801},
    {0x00005B6B, 0xC2423901}, {0x00005B70, 0xC2555901}, {0x00005B71, 0xC2562301}, {0x00005B73, 0xC2555A01},
    {0x00005B75, 0xC2555B01}, {0x00005B78, 0xC2555C01}, {0x00005B7A, 0xC2555E01}, {0x00005B80, 0xC2555F01},
    {0x00005B83, 0xC2556001}, {0x00005B85, 0xC2427001}, {0x00005B87, 0xC2312701}, {0x00005B88, 0xC23C6901},
    {0x00005B89, 0xC2304201}, {0x00005B8B, 0xC2415701}, {0x00005B8C, 0xC2343001}, {0x00005B8D, 0xC23C3501},
    {0x00005B8F, 0xC2392801}, {0x00005B95, 0xC2456601}, {0x00005B97, 0xC23D2101}, {0x00005B98, 0xC2343101},
    {0x00005B99, 0xC2436801}, {0x00005B9A, 0xC2446A01}, {0x00005B9B, 0xC2303801}, {0x00005B9C, 0xC2353901},
    {0x00005B9D, 0xC24A7501}, {0x00005B9F, 0xC23C4201}, {0x00005BA2, 0xC2355201}, {0x00005BA3, 0xC2406B01},
    {0x00005BA4, 0xC23C3C01}, {0x00005BA5, 0xC24D2801}, {0x00005BA6, 0xC2556101}, {0x00005BAE, 0xC2355C01},
    {0x00005BB0, 0xC23A4B01}, {0x00005BB3, 0xC2333201}, {0x00005BB4, 0xC2316301}, {0x00005BB5, 0xC23E2C01},
    {0x00005BB6, 0xC2324801}, {0x00005BB8, 0xC2556201}, {0x00005BB9, 0xC24D4601}, {0x00005BBF, 0xC23D4901},
    {0x00005BC2, 0xC23C6401}, {0x00005BC3, 0xC2556301}, {0x00005BC4, 0xC2347301}, {0x00005BC5, 0xC2465201},
    {0x00005BC6, 0xC24C2901}, {0x00005BC7, 0xC2556401}, {0x00005BC9, 0xC2556501}, {0x00005BCC, 0xC2495901},
    {0x00005BD0, 0xC2556701}, {0x00005BD2, 0xC2342801}, {0x00005BD3, 0xC2367701}, {0x00005BD4, 0xC2556601},
    {0x00005BDB, 0xC2343201}, {0x00005BDD, 0xC23F3201}, {0x00005BDE, 0xC2556B01}, {0x00005BDF, 0xC23B2101},
    {0x00005BE1, 0xC2324901}, {0x00005BE2, 0xC2556A01}, {0x00005BE4, 0xC2556801}, {0x00005BE5, 0xC2556C01},
    {0x00005BE6, 0xC2556901}, {0x00005BE7, 0xC2472B01}, {0x00005BE8, 0xC25C4D01}, {0x00005BE9, 0xC23F3301},
    {0x00005BEB, 0xC2556D01}, {0x00005BEC, 0xC2753F01}, {0x00005BEE, 0xC24E4001}, {0x00005BF0, 0xC2556E01},
    {0x00005BF3, 0xC2557001}, {0x00005BF5, 0xC2437E01}, {0x00005BF6, 0xC2556F01}, {0x00005BF8, 0xC2402301},
    {0x00005BFA, 0xC23B7B01}, {0x00005BFE, 0xC2425001}, {0x00005BFF, 0xC23C7701}, {0x00005C01, 0xC2497501},
    {0x00005C02, 0xC2406C01}, {0x00005C04, 0xC23C4D01}, {0x00005C05, 0xC2557101}, {0x00005C06, 0xC23E2D01},
    {0x00005C07, 0xC2557202}, {0x00005C09, 0xC2305301}, {0x00005C0A, 0xC2423A01}, {0x00005C0B, 0xC23F5201},
    {0x00005C0D, 0xC2557401}, {0x00005C0E, 0xC2463301}, {0x00005C0F, 0xC23E2E01}, {0x00005C11, 0xC23E2F01},
    {0x00005C13, 0xC2557501}, {0x00005C16, 0xC2406D01}, {0x00005C1A, 0xC23E3001}, {0x00005C20, 0xC2557601},
    {0x00005C22, 0xC2557701}, {0x00005C24, 0xC24C6001}, {0x00005C28, 0xC2557801}, {0x00005C2D, 0xC2364601},
    {0x00005C31, 0xC23D2201}, {0x00005C38, 0xC2557902}, {0x00005C3A, 0xC23C5C01}, {0x00005C3B, 0xC23F2C01},
    {0x00005C3C, 0xC2467401}, {0x00005C3D, 0xC23F5401}, {0x00005C3E, 0xC2487801}, {0x00005C3F, 0xC2472201},
    {0x00005C40, 0xC2364901}, {0x00005C41, 0xC2557B01}, {0x00005C45, 0xC2356F01}, {0x00005C46, 0xC2557C01},
    {0x00005C48, 0xC2367E01}, {0x00005C4A, 0xC2464F01}, {0x00005C4B, 0xC2323001}, {0x00005C4D, 0xC23B5301},
    {0x00005C4E, 0xC2557D01}, {0x00005C4F, 0xC2562201}, {0x00005C50, 0xC2562101}, {0x00005C51, 0xC2367D01},
    {0x00005C53, 0xC2557E01}, {0x00005C55, 0xC2453801}, {0x00005C5E, 0xC2423001}, {0x00005C60, 0xC2454B01},
    {0x00005C61, 0xC23C4801}, {0x00005C64, 0xC2415801}, {0x00005C65, 0xC24D7A01}, {0x00005C6C, 0xC2562401},
    {0x00005C6E, 0xC2562501}, {0x00005C6F, 0xC2465601}, {0x00005C71, 0xC23B3301}, {0x00005C76, 0xC2562701},
    {0x00005C79, 0xC2562801}, {0x00005C8C, 0xC2562901}, {0x00005C90, 0xC2347401}, {0x00005C91, 0xC2562A01},
    {0x00005C94, 0xC2562B01}, {0x00005CA1, 0xC2322C01}, {0x00005CA8, 0xC2413B01}, {0x00005CA9, 0xC2346401},
    {0x00005CAB, 0xC2562D01}, {0x00005CAC, 0xC24C2801}, {0x00005CB1, 0xC2425201}, {0x00005CB3, 0xC2335901},
    {0x00005CB6, 0xC2562F01}, {0x00005CB7, 0xC2563101}, {0x00005CB8, 0xC2345F01}, {0x00005CBB, 0xC2562E01},
    {0x00005CBC, 0xC2563001}, {0x00005CBE, 0xC2563301}, {0x00005CC5, 0xC2563201}, {0x00005CC7, 0xC2563401},
    {0x00005CD9, 0xC2563501}, {0x00005CE0, 0xC2463D01}, {0x00005CE1, 0xC2362E01}, {0x00005CE8, 0xC2326501},
    {0x00005CE9, 0xC2563601}, {0x00005CEA, 0xC2563B01}, {0x00005CED, 0xC2563901}, {0x00005CEF, 0xC24A7701},
    {0x00005CF0, 0xC24A7601}, {0x00005CF6, 0xC2456701}, {0x00005CFA, 0xC2563801}, {0x00005CFB, 0xC23D5401},
    {0x00005CFD, 0xC2563701}, {0x00005D07, 0xC23F7201}, {0x00005D0B, 0xC2563C01}, {0x00005D0E, 0xC23A6A01},
    {0x00005D11, 0xC2564201}, {0x00005D14, 0xC2564301}, {0x00005D15, 0xC2563D01}, {0x00005D16, 0xC2333301},
    {0x00005D17, 0xC2563E01}, {0x00005D18, 0xC2564701}, {0x00005D19, 0xC2564601}, {0x00005D1A, 0xC2564501},
    {0x00005D1B, 0xC2564101}, {0x00005D1F, 0xC2564001}, {0x00005D22, 0xC2564401}, {0x00005D29, 0xC24A7801},
    {0x00005D4B, 0xC2564B01}, {0x00005D4C, 0xC2564801}, {0x00005D4E, 0xC2564A01}, {0x00005D50, 0xC24D7201},
    {0x00005D52, 0xC2564901}, {0x00005D5C, 0xC2563F01}, {0x00005D69, 0xC23F7301}, {0x00005D6C, 0xC2564C01},
    {0x00005D6F, 0xC23A3701}, {0x00005D73, 0xC2564D01}, {0x00005D76, 0xC2564E01}, {0x00005D82, 0xC2565101},
    {0x00005D84, 0xC2565001}, {0x00005D87, 0xC2564F01}, {0x00005D8B, 0xC2456801}, {0x00005D8C, 0xC2563A01},
    {0x00005D90, 0xC2565701}, {0x00005D9D, 0xC2565301}, {0x00005DA2, 0xC2565201}, {0x00005DAC, 0xC2565401},
    {0x00005DAE, 0xC2565501}, {0x00005DB7, 0xC2565801}, {0x00005DBA, 0xC24E6601}, {0x00005DBC, 0xC2565901},
    {0x00005DBD, 0xC2565601}, {0x00005DC9, 0xC2565A01}, {0x00005DCC, 0xC2346001}, {0x00005DCD, 0xC2565B01},
    {0x00005DD2, 0xC2565D01}, {0x00005DD3, 0xC2565C01}, {0x00005DD6, 0xC2565E01}, {0x00005DDB, 0xC2565F01},
    {0x00005DDD, 0xC2406E01}, {0x00005DDE, 0xC23D2301}, {0x00005DE1, 0xC23D6401}, {0x00005DE3, 0xC2416301},
    {0x00005DE5, 0xC2392901}, {0x00005DE6, 0xC23A3801}, {0x00005DE7, 0xC2392A01}, {0x00005DE8, 0xC2357001},
    {0x00005DEB, 0xC2566001}, {0x00005DEE, 0xC23A3901}, {0x00005DF1, 0xC2384A01}, {0x00005DF2, 0xC2566101},
    {0x00005DF3, 0xC24C2601}, {0x00005DF4, 0xC2474301}, {0x00005DF5, 0xC2566201}, {0x00005DF7, 0xC2392B01},
    {0x00005DFB, 0xC2342C01}, {0x00005DFD, 0xC2432701}, {0x00005DFE, 0xC2365201}, {0x00005E02, 0xC23B5401},
    {0x00005E03, 0xC2495B01}, {0x00005E06, 0xC2484101}, {0x00005E0B, 0xC2566301}, {0x00005E0C, 0xC2347501},
    {0x00005E11, 0xC2566601}, {0x00005E16, 0xC2442101}, {0x00005E19, 0xC2566501}, {0x00005E1A, 0xC2566401},
    {0x00005E1B, 0xC2566701}, {0x00005E1D, 0xC2446B01}, {0x00005E25, 0xC23F6301}, {0x00005E2B, 0xC23B5501},
    {0x00005E2D, 0xC2404A01}, {0x00005E2F, 0xC2425301}, {0x00005E30, 0xC2352201}, {0x00005E33, 0xC2442201},
    {0x00005E36, 0xC2566802}, {0x00005E38, 0xC23E6F01}, {0x00005E3D, 0xC24B3901}, {0x00005E40, 0xC2566C01},
    {0x00005E43, 0xC2566B01}, {0x00005E44, 0xC2566A01}, {0x00005E45, 0xC2497D01}, {0x00005E47, 0xC2567301},
    {0x00005E4C, 0xC24B5A01}, {0x00005E4E, 0xC2566D01}, {0x00005E54, 0xC2566F01}, {0x00005E55, 0xC24B6B01},
    {0x00005E57, 0xC2566E01}, {0x00005E5F, 0xC2567001}, {0x00005E61, 0xC2482801}, {0x00005E62, 0xC2567101},
    {0x00005E63, 0xC24A3E01}, {0x00005E64, 0xC2567201}, {0x00005E72, 0xC2343301}, {0x00005E73, 0xC24A3F01},
    {0x00005E74, 0xC2472F01}, {0x00005E75, 0xC2567402}, {0x00005E78, 0xC2392C01}, {0x00005E79, 0xC2343401},
    {0x00005E7A, 0xC2567601}, {0x00005E7B, 0xC2383801}, {0x00005E7C, 0xC24D4401}, {0x00005E7D, 0xC24D2901},
    {0x00005E7E, 0xC2347601}, {0x00005E7F, 0xC2567801}, {0x00005E81, 0xC2442301}, {0x00005E83, 0xC2392D01},
    {0x00005E84, 0xC23E3101}, {0x00005E87, 0xC2485F01}, {0x00005E8A, 0xC23E3201}, {0x00005E8F, 0xC23D7801},
    {0x00005E95, 0xC2446C01}, {0x00005E96, 0xC24A7901}, {0x00005E97, 0xC2453901}, {0x00005E9A, 0xC2392E01},
    {0x00005E9C, 0xC2495C01}, {0x00005EA0, 0xC2567901}, {0x00005EA6, 0xC2455901}, {0x00005EA7, 0xC23A4201},
    {0x00005EAB, 0xC2384B01}, {0x00005EAC, 0xC2754201}, {0x00005EAD, 0xC2446D01}, {0x00005EB5, 0xC2304301},
    {0x00005EB6, 0xC23D6E01}, {0x00005EB7, 0xC2392F01}, {0x00005EB8, 0xC24D4701}, {0x00005EC1, 0xC2567A02},
    {0x00005EC3, 0xC2475101}, {0x00005EC8, 0xC2567C01}, {0x00005EC9, 0xC24E7701}, {0x00005ECA, 0xC24F2D01},
    {0x00005ECF, 0xC2567E01}, {0x00005ED0, 0xC2567D01}, {0x00005ED3, 0xC2334701}, {0x00005ED6, 0xC2572101},
    {0x00005EDA, 0xC2572402}, {0x00005EDD, 0xC2572301}, {0x00005EDF, 0xC2494001}, {0x00005EE0, 0xC23E3301},
    {0x00005EE1, 0xC2572701}, {0x00005EE2, 0xC2572601}, {0x00005EE3, 0xC2572201}, {0x00005EE8, 0xC2572802},
    {0x00005EEC, 0xC2572A01}, {0x00005EF0, 0xC2572D01}, {0x00005EF1, 0xC2572B01}, {0x00005EF3, 0xC2572C01},
    {0x00005EF4, 0xC2572E01}, {0x00005EF6, 0xC2316401}, {0x00005EF7, 0xC2446E01}, {0x00005EF8, 0xC2572F01},
    {0x00005EFA, 0xC2377A01}, {0x00005EFB, 0xC2327601}, {0x00005EFC, 0xC2473601}, {0x00005EFE, 0xC2573001},
    {0x00005EFF, 0xC2467B01}, {0x00005F01, 0xC24A5B01}, {0x00005F03, 0xC2573101}, {0x00005F04, 0xC24F2E01},
    {0x00005F09, 0xC2573201}, {0x00005F0A, 0xC24A4001}, {0x00005F0B, 0xC2573501}, {0x00005F0C, 0xC2502101},
    {0x00005F0D, 0xC2503101}, {0x00005F0F, 0xC23C3001}, {0x00005F10, 0xC2467501}, {0x00005F11, 0xC2573601},
    {0x00005F13, 0xC2355D01}, {0x00005F14, 0xC2442401}, {0x00005F15, 0xC2307A01}, {0x00005F16, 0xC2573701},
    {0x00005F17, 0xC24A2601}, {0x00005F18, 0xC2393001}, {0x00005F1B, 0xC2435001}, {0x00005F1F, 0xC2446F01},
    {0x00005F25, 0xC24C6F01}, {0x00005F26, 0xC2383901}, {0x00005F27, 0xC2384C01}, {0x00005F29, 0xC2573801},
    {0x00005F2D, 0xC2573901}, {0x00005F2F, 0xC2573F01}, {0x00005F31, 0xC23C6501}, {0x00005F34, 0xC2754301},
    {0x00005F35, 0xC2442501}, {0x00005F37, 0xC2362F01}, {0x00005F38, 0xC2573A01}, {0x00005F3C, 0xC2492B01},
    {0x00005F3E, 0xC2434601}, {0x00005F41, 0xC2573B01}, {0x00005F45, 0xC2754401}, {0x00005F48, 0xC2573C01},
    {0x00005F4A, 0xC2363001}, {0x00005F4C, 0xC2573D01}, {0x00005F4E, 0xC2573E01}, {0x00005F51, 0xC2574001},
    {0x00005F53, 0xC2457601}, {0x00005F56, 0xC2574102}, {0x00005F59, 0xC2574301}, {0x00005F5C, 0xC2573401},
    {0x00005F5D, 0xC2573301}, {0x00005F61, 0xC2574401}, {0x00005F62, 0xC2374101}, {0x00005F66, 0xC2492701},
    {0x00005F69, 0xC23A4C01}, {0x00005F6A, 0xC2493701}, {0x00005F6B, 0xC2442601}, {0x00005F6C, 0xC2494B01},
    {0x00005F6D, 0xC2574501}, {0x00005F70, 0xC23E3401}, {0x00005F71, 0xC2314601}, {0x00005F73, 0xC2574601},
    {0x00005F77, 0xC2574701}, {0x00005F79, 0xC24C7201}, {0x00005F7C, 0xC2486001}, {0x00005F7F, 0xC2574A01},
    {0x00005F80, 0xC2317D01}, {0x00005F81, 0xC2402C01}, {0x00005F82, 0xC2574901}, {0x00005F83, 0xC2574801},
    {0x00005F84, 0xC2374201}, {0x00005F85, 0xC2425401}, {0x00005F87, 0xC2574E01}, {0x00005F88, 0xC2574C01},
    {0x00005F8A, 0xC2574B01}, {0x00005F8B, 0xC24E2701}, {0x00005F8C, 0xC2386501}, {0x00005F90, 0xC23D7901},
    {0x00005F91, 0xC2574D01}, {0x00005F92, 0xC2454C01}, {0x00005F93, 0xC23D3E01}, {0x00005F97, 0xC2464001},
    {0x00005F98, 0xC2575101}, {0x00005F99, 0xC2575001}, {0x00005F9E, 0xC2574F01}, {0x00005FA0, 0xC2575201},
    {0x00005FA1, 0xC2386601}, {0x00005FA8, 0xC2575301}, {0x00005FA9, 0xC2497C01}, {0x00005FAA, 0xC23D5B01},
    {0x00005FAD, 0xC2575401}, {0x00005FAE, 0xC2487901}, {0x00005FB3, 0xC2464101}, {0x00005FB4, 0xC2442701},
    {0x00005FB9, 0xC2453001}, {0x00005FBC, 0xC2575501}, {0x00005FBD, 0xC2352B01}, {0x00005FC3, 0xC23F3401},
    {0x00005FC5, 0xC2492C01}, {0x00005FCC, 0xC2347701}, {0x00005FCD, 0xC2472601}, {0x00005FD6, 0xC2575601},
    {0x00005FD7, 0xC23B5601}, {0x00005FD8, 0xC24B3A02}, {0x00005FDC, 0xC2317E01}, {0x00005FDD, 0xC2575B01},
    {0x00005FE0, 0xC2436901}, {0x00005FE4, 0xC2575801}, {0x00005FEB, 0xC2327701}, {0x00005FF0, 0xC2582D01},
    {0x00005FF1, 0xC2575A01}, {0x00005FF5, 0xC2473001}, {0x00005FF8, 0xC2575901}, {0x00005FFB, 0xC2575701},
    {0x00005FFD, 0xC2397A01}, {0x00005FFF, 0xC2575D01}, {0x0000600E, 0xC2576301}, {0x0000600F, 0xC2576901},
    {0x00006010, 0xC2576101}, {0x00006012, 0xC2455C01}, {0x00006015, 0xC2576601}, {0x00006016, 0xC2495D01},
    {0x00006017, 0xC2754601}, {0x00006019, 0xC2576001}, {0x0000601B, 0xC2576501}, {0x0000601C, 0xC24E6701},
    {0x0000601D, 0xC23B5701}, {0x00006020, 0xC2425501}, {0x00006021, 0xC2575E01}, {0x00006025, 0xC2355E01},
    {0x00006026, 0xC2576801}, {0x00006027, 0xC2402D01}, {0x00006028, 0xC2316501}, {0x00006029, 0xC2576201},
    {0x0000602A, 0xC2327801}, {0x0000602B, 0xC2576701}, {0x0000602F, 0xC2363101}, {0x00006031, 0xC2576401},
    {0x0000603A, 0xC2576A01}, {0x00006041, 0xC2576C01}, {0x00006042, 0xC2577601}, {0x00006043, 0xC2577401},
    {0x00006046, 0xC2577101}, {0x0000604A, 0xC2577001}, {0x0000604B, 0xC24E7801}, {0x0000604D, 0xC2577201},
    {0x00006050, 0xC2363201}, {0x00006052, 0xC2393101}, {0x00006055, 0xC23D7A01}, {0x00006059, 0xC2577901},
    {0x0000605A, 0xC2576B01}, {0x0000605F, 0xC2576F01}, {0x00006060, 0xC2575F01}, {0x00006062, 0xC2327A01},
    {0x00006063, 0xC2577301}, {0x00006064, 0xC2577501}, {0x00006065, 0xC2435101}, {0x00006068, 0xC23A2801},
    {0x00006069, 0xC2323801}, {0x0000606A, 0xC2576D01}, {0x0000606B, 0xC2577801}, {0x0000606C, 0xC2577701},
    {0x0000606D, 0xC2363301}, {0x0000606F, 0xC2422901}, {0x00006070, 0xC2336601}, {0x00006075, 0xC2374301},
    {0x00006077, 0xC2576E01}, {0x00006081, 0xC2577A01}, {0x00006083, 0xC2577D01}, {0x00006084, 0xC2582101},
    {0x00006089, 0xC23C3D01}, {0x0000608B, 0xC2582701}, {0x0000608C, 0xC2447001}, {0x0000608D, 0xC2577B01},
    {0x00006092, 0xC2582501}, {0x00006094, 0xC2327901}, {0x00006096, 0xC2582302}, {0x0000609A, 0xC2577E01},
    {0x0000609B, 0xC2582201}, {0x0000609F, 0xC2386701}, {0x000060A0, 0xC24D2A01}, {0x000060A3, 0xC2343501},
    {0x000060A6, 0xC2315901}, {0x000060A7, 0xC2582601}, {0x000060A9, 0xC2473A01}, {0x000060AA, 0xC2302D01},
    {0x000060B2, 0xC2486101}, {0x000060B3, 0xC2575C01}, {0x000060B4, 0xC2582C01}, {0x000060B5, 0xC2583001},
    {0x000060B6, 0xC24C6501}, {0x000060B8, 0xC2582901}, {0x000060BC, 0xC2456901}, {0x000060BD, 0xC2582E01},
    {0x000060C5, 0xC23E7001}, {0x000060C6, 0xC2582F01}, {0x000060C7, 0xC2465701}, {0x000060D1, 0xC24F4701},
    {0x000060D3, 0xC2582B01}, {0x000060D8, 0xC2583101}, {0x000060DA, 0xC2397B01}, {0x000060DC, 0xC2404B01},
    {0x000060DF, 0xC2305401}, {0x000060E0, 0xC2582A01}, {0x000060E1, 0xC2582801}, {0x000060E3, 0xC2415A01},
    {0x000060E7, 0xC2577C01}, {0x000060E8, 0xC23B3401}, {0x000060F0, 0xC2424601}, {0x000060F1, 0xC2583D01},
    {0x000060F3, 0xC2415B01}, {0x000060F4, 0xC2583801}, {0x000060F6, 0xC2583502}, {0x000060F9, 0xC23C6601},
    {0x000060FA, 0xC2583901}, {0x000060FB, 0xC2583C01}, {0x00006100, 0xC2583701}, {0x00006101, 0xC23D2501},
    {0x00006103, 0xC2583A01}, {0x00006106, 0xC2583401}, {0x00006108, 0xC24C7C01}, {0x00006109, 0xC24C7B01},
    {0x0000610D, 0xC2583E02}, {0x0000610F, 0xC2305501}, {0x00006115, 0xC2583301}, {0x0000611A, 0xC2367201},
    {0x0000611B, 0xC2302601}, {0x0000611F, 0xC2343601}, {0x00006121, 0xC2583B01}, {0x00006127, 0xC2584301},
    {0x00006128, 0xC2584201}, {0x0000612C, 0xC2584701}, {0x00006130, 0xC2754801}, {0x00006134, 0xC2584801},
    {0x0000613C, 0xC2584601}, {0x0000613D, 0xC2584901}, {0x0000613E, 0xC2584101}, {0x0000613F, 0xC2584501},
    {0x00006142, 0xC2584A01}, {0x00006144, 0xC2584B01}, {0x00006147, 0xC2584001}, {0x00006148, 0xC23B7C01},
    {0x0000614A, 0xC2584401}, {0x0000614B, 0xC2425601}, {0x0000614C, 0xC2393201}, {0x0000614D, 0xC2583201},
    {0x0000614E, 0xC23F3501}, {0x00006153, 0xC2585801}, {0x00006155, 0xC24A6901}, {0x00006158, 0xC2584E03},
    {0x0000615D, 0xC2585701}, {0x0000615F, 0xC2585601}, {0x00006162, 0xC24B7D01}, {0x00006163, 0xC2343701},
    {0x00006165, 0xC2585401}, {0x00006167, 0xC2374501}, {0x00006168, 0xC2333401}, {0x0000616B, 0xC2585101},
    {0x0000616E, 0xC24E3801}, {0x0000616F, 0xC2585301}, {0x00006170, 0xC2305601}, {0x00006171, 0xC2585501},
    {0x00006173, 0xC2584C01}, {0x00006174, 0xC2585201}, {0x00006175, 0xC2585901}, {0x00006176, 0xC2374401},
    {0x00006177, 0xC2584D01}, {0x0000617E, 0xC24D5D01}, {0x00006182, 0xC24D2B01}, {0x00006187, 0xC2585C01},
    {0x0000618A, 0xC2586001}, {0x0000618E, 0xC2417E01}, {0x00006190, 0xC24E7901}, {0x00006191, 0xC2586101},
    {0x00006194, 0xC2585E01}, {0x00006196, 0xC2585B01}, {0x00006199, 0xC2585A01}, {0x0000619A, 0xC2585F01},
    {0x000061A4, 0xC24A3001}, {0x000061A7, 0xC2463401}, {0x000061A9, 0xC2374601}, {0x000061AB, 0xC2586201},
    {0x000061AC, 0xC2585D01}, {0x000061AE, 0xC2586301}, {0x000061B2, 0xC2377B01}, {0x000061B6, 0xC2323101},
    {0x000061BA, 0xC2586B01}, {0x000061BE, 0xC2343801}, {0x000061C3, 0xC2586901}, {0x000061C6, 0xC2586A01},
    {0x000061C7, 0xC23A2901}, {0x000061C8, 0xC2586801}, {0x000061C9, 0xC2586601}, {0x000061CA, 0xC2586501},
    {0x000061CB, 0xC2586C01}, {0x000061CC, 0xC2586401}, {0x000061CD, 0xC2586E01}, {0x000061D0, 0xC2327B01},
    {0x000061E3, 0xC2587001}, {0x000061E6, 0xC2586F01}, {0x000061F2, 0xC2442801}, {0x000061F4, 0xC2587301},
    {0x000061F6, 0xC2587101}, {0x000061F7, 0xC2586701}, {0x000061F8, 0xC2377C01}, {0x000061FA, 0xC2587201},
    {0x000061FC, 0xC2587601}, {0x000061FD, 0xC2587501}, {0x000061FE, 0xC2587701}, {0x000061FF, 0xC2587401},
    {0x00006200, 0xC2587801}, {0x00006208, 0xC2587902}, {0x0000620A, 0xC24A6A01}, {0x0000620C, 0xC2587C01},
    {0x0000620D, 0xC2587B01}, {0x0000620E, 0xC23D3F01}, {0x00006210, 0xC2402E01}, {0x00006211, 0xC2326601},
    {0x00006212, 0xC2327C01}, {0x00006214, 0xC2587D01}, {0x00006216, 0xC2303F01}, {0x0000621A, 0xC2404C01},
    {0x0000621B, 0xC2587E01}, {0x0000621D, 0xC26C4301}, {0x0000621E, 0xC2592101}, {0x0000621F, 0xC2376101},
    {0x00006221, 0xC2592201}, {0x00006226, 0xC2406F01}, {0x0000622A, 0xC2592301}, {0x0000622E, 0xC2592401},
    {0x0000622F, 0xC2353A01}, {0x00006230, 0xC2592501}, {0x00006232, 0xC2592602}, {0x00006234, 0xC2425701},
    {0x00006238, 0xC2384D01}, {0x0000623B, 0xC24C6101}, {0x0000623F, 0xC24B3C01}, {0x00006240, 0xC23D6A01},
    {0x00006241, 0xC2592801}, {0x00006247, 0xC2407001}, {0x00006248, 0xC26E3D01}, {0x00006249, 0xC2486201},
    {0x0000624B, 0xC23C6A01}, {0x0000624D, 0xC23A4D01}, {0x0000624E, 0xC2592901}, {0x00006253, 0xC2424701},
    {0x00006255, 0xC24A2701}, {0x00006258, 0xC2427101}, {0x0000625B, 0xC2592C01}, {0x0000625E, 0xC2592A01},
    {0x00006260, 0xC2592D01}, {0x00006263, 0xC2592B01}, {0x00006268, 0xC2592E01}, {0x0000626E, 0xC24A3101},
    {0x00006271, 0xC2303701}, {0x00006276, 0xC2495E01}, {0x00006279, 0xC2486301}, {0x0000627C, 0xC2592F01},
    {0x0000627E, 0xC2593201}, {0x0000627F, 0xC23E3501}, {0x00006280, 0xC2353B01}, {0x00006282, 0xC2593001},
    {0x00006283, 0xC2593701}, {0x00006284, 0xC23E3601}, {0x00006289, 0xC2593101}, {0x0000628A, 0xC2474401},
    {0x00006291, 0xC24D5E01}, {0x00006292, 0xC2593302}, {0x00006294, 0xC2593801}, {0x00006295, 0xC2456A01},
    {0x00006296, 0xC2593501}, {0x00006297, 0xC2393301}, {0x00006298, 0xC2405E01}, {0x0000629B, 0xC2594601},
    {0x0000629C, 0xC2483401}, {0x0000629E, 0xC2427201}, {0x000062AB, 0xC2486401}, {0x000062AC, 0xC25A2D01},
    {0x000062B1, 0xC24A7A01}, {0x000062B5, 0xC2447101}, {0x000062B9, 0xC24B7501}, {0x000062BB, 0xC2593B01},
    {0x000062BC, 0xC2322101}, {0x000062BD, 0xC2436A01}, {0x000062C2, 0xC2594401}, {0x000062C5, 0xC2433401},
    {0x000062C6, 0xC2593E01}, {0x000062C7, 0xC2594501}, {0x000062C8, 0xC2594001}, {0x000062C9, 0xC2594701},
    {0x000062CA, 0xC2594301}, {0x000062CC, 0xC2594201}, {0x000062CD, 0xC2476F01}, {0x000062CF, 0xC2593C01},
    {0x000062D0, 0xC2327D01}, {0x000062D1, 0xC2593A01}, {0x000062D2, 0xC2357101}, {0x000062D3, 0xC2427301},
    {0x000062D4, 0xC2593601}, {0x000062D7, 0xC2593901}, {0x000062D8, 0xC2393401}, {0x000062D9, 0xC2405B01},
    {0x000062DB, 0xC23E3701}, {0x000062DC, 0xC2594101}, {0x000062DD, 0xC2475201}, {0x000062E0, 0xC2357201},
    {0x000062E1, 0xC2334801}, {0x000062EC, 0xC2336701}, {0x000062ED, 0xC23F2101}, {0x000062EE, 0xC2594901},
    {0x000062EF, 0xC2594E01}, {0x000062F1, 0xC2594A01}, {0x000062F3, 0xC2377D01}, {0x000062F5, 0xC2594F01},
    {0x000062F6, 0xC23B2201}, {0x000062F7, 0xC2396901}, {0x000062FE, 0xC23D2601}, {0x000062FF, 0xC2593D01},
    {0x00006301, 0xC23B7D01}, {0x00006302, 0xC2594C01}, {0x00006307, 0xC23B5801}, {0x00006308, 0xC2594D01},
    {0x00006309, 0xC2304401}, {0x0000630C, 0xC2594801}, {0x00006311, 0xC2442901}, {0x00006319, 0xC2357301},
    {0x0000631F, 0xC2363401}, {0x00006327, 0xC2594B01}, {0x00006328, 0xC2302701}, {0x0000632B, 0xC23A4301},
    {0x0000632F, 0xC23F3601}, {0x0000633A, 0xC2447201}, {0x0000633D, 0xC2485401}, {0x0000633E, 0xC2595101},
    {0x0000633F, 0xC2415E01}, {0x00006349, 0xC2422A01}, {0x0000634C, 0xC23B2B01}, {0x0000634D, 0xC2595201},
    {0x0000634F, 0xC2595401}, {0x00006350, 0xC2595001}, {0x00006355, 0xC24A6101}, {0x00006357, 0xC2443D01},
    {0x0000635C, 0xC2415C01}, {0x00006367, 0xC24A7B01}, {0x00006368, 0xC23C4E01}, {0x00006369, 0xC2596001},
    {0x0000636B, 0xC2595F01}, {0x0000636E, 0xC23F7801}, {0x00006372, 0xC2377E01}, {0x00006376, 0xC2595901},
    {0x00006377, 0xC23E3901}, {0x0000637A, 0xC2466801}, {0x0000637B, 0xC2473101}, {0x00006380, 0xC2595701},
    {0x00006383, 0xC2415D01}, {0x00006388, 0xC23C7801}, {0x00006389, 0xC2595C01}, {0x0000638C, 0xC23E3801},
    {0x0000638E, 0xC2595601}, {0x0000638F, 0xC2595B01}, {0x00006392, 0xC2475301}, {0x00006396, 0xC2595501},
    {0x00006398, 0xC2372101}, {0x0000639B, 0xC2335D01}, {0x0000639F, 0xC2595D01}, {0x000063A0, 0xC24E2B01},
    {0x000063A1, 0xC23A4E01}, {0x000063A2, 0xC2433501}, {0x000063A3, 0xC2595A01}, {0x000063A5, 0xC2405C01},
    {0x000063A7, 0xC2393501}, {0x000063A8, 0xC23F6401}, {0x000063A9, 0xC2316601}, {0x000063AA, 0xC2413C01},
    {0x000063AB, 0xC2595801}, {0x000063AC, 0xC2354501}, {0x000063B2, 0xC2374701}, {0x000063B4, 0xC2444F01},
    {0x000063B5, 0xC2595E01}, {0x000063BB, 0xC2415F01}, {0x000063BE, 0xC2596101}, {0x000063C0, 0xC2596301},
    {0x000063C3, 0xC2423701}, {0x000063C4, 0xC2596901}, {0x000063C6, 0xC2596401}, {0x000063C9, 0xC2596601},
    {0x000063CF, 0xC2494101}, {0x000063D0, 0xC2447301}, {0x000063D2, 0xC2596701}, {0x000063D6, 0xC24D2C01},
    {0x000063DA, 0xC24D4801}, {0x000063DB, 0xC2343901}, {0x000063E1, 0xC2302E01}, {0x000063E3, 0xC2596501},
    {0x000063E9, 0xC2596201}, {0x000063EE, 0xC2347801}, {0x000063F4, 0xC2316701}, {0x000063F6, 0xC2596801},
    {0x000063FA, 0xC24D4901}, {0x00006406, 0xC2596C01}, {0x0000640D, 0xC2423B01}, {0x0000640F, 0xC2597301},
    {0x00006413, 0xC2596D01}, {0x00006416, 0xC2596A01}, {0x00006417, 0xC2597101}, {0x0000641C, 0xC2595301},
    {0x00006426, 0xC2596E01}, {0x00006428, 0xC2597201}, {0x0000642C, 0xC2484201}, {0x0000642D, 0xC2456B01},
    {0x00006434, 0xC2596B01}, {0x00006436, 0xC2596F01}, {0x0000643A, 0xC2374801}, {0x0000643E, 0xC23A7101},
    {0x00006442, 0xC2405D01}, {0x0000644E, 0xC2597701}, {0x00006458, 0xC2452601}, {0x00006467, 0xC2597401},
    {0x00006469, 0xC24B6001}, {0x0000646F, 0xC2597501}, {0x00006476, 0xC2597601}, {0x00006478, 0xC24C4E01},
    {0x0000647A, 0xC2402201}, {0x00006483, 0xC2376201}, {0x00006488, 0xC2597D01}, {0x00006492, 0xC23B3501},
    {0x00006493, 0xC2597A01}, {0x00006495, 0xC2597901}, {0x0000649A, 0xC2473201}, {0x0000649E, 0xC2463501},
    {0x000064A4, 0xC2453101}, {0x000064A5, 0xC2597B01}, {0x000064A9, 0xC2597C01}, {0x000064AB, 0xC2496F01},
    {0x000064AD, 0xC2474501}, {0x000064AE, 0xC23B2301}, {0x000064B0, 0xC2407101}, {0x000064B2, 0xC24B5001},
    {0x000064B9, 0xC2334901}, {0x000064BB, 0xC25A2501}, {0x000064BC, 0xC2597E01}, {0x000064C1, 0xC24D4A01},
    {0x000064C2, 0xC25A2701}, {0x000064C5, 0xC25A2301}, {0x000064C7, 0xC25A2401}, {0x000064CD, 0xC2416001},
    {0x000064D2, 0xC25A2201}, {0x000064D4, 0xC2593F01}, {0x000064D8, 0xC25A2601}, {0x000064DA, 0xC25A2101},
    {0x000064E0, 0xC25A2B02}, {0x000064E2, 0xC2452701}, {0x000064E3, 0xC25A2E01}, {0x000064E6, 0xC23B2401},
    {0x000064E7, 0xC25A2901}, {0x000064EC, 0xC2353C01}, {0x000064EF, 0xC25A2F01}, {0x000064F1, 0xC25A2801},
    {0x000064F2, 0xC25A3301}, {0x000064F4, 0xC25A3201}, {0x000064F6, 0xC25A3101}, {0x000064FA, 0xC25A3401},
    {0x000064FD, 0xC25A3601}, {0x000064FE, 0xC23E7101}, {0x00006500, 0xC25A3501}, {0x00006505, 0xC25A3901},
    {0x00006518, 0xC25A3701}, {0x0000651C, 0xC25A3801}, {0x0000651D, 0xC2597001}, {0x00006523, 0xC25A3B01},
    {0x00006524, 0xC25A3A01}, {0x0000652A, 0xC2597801}, {0x0000652B, 0xC25A3C01}, {0x0000652C, 0xC25A3001},
    {0x0000652F, 0xC23B5901}, {0x00006534, 0xC25A3D02}, {0x00006536, 0xC25A4001}, {0x00006537, 0xC25A3F01},
    {0x00006538, 0xC25A4101}, {0x00006539, 0xC2327E01}, {0x0000653B, 0xC2393601}, {0x0000653E, 0xC24A7C01},
    {0x0000653F, 0xC2402F01}, {0x00006545, 0xC2384E01}, {0x00006548, 0xC25A4301}, {0x0000654D, 0xC25A4601},
    {0x0000654F, 0xC2495201}, {0x00006551, 0xC2355F01}, {0x00006555, 0xC25A4501}, {0x00006556, 0xC25A4401},
    {0x00006557, 0xC2475401}, {0x00006558, 0xC25A4701}, {0x00006559, 0xC2363501}, {0x0000655D, 0xC25A4901},
    {0x0000655E, 0xC25A4801}, {0x00006562, 0xC2343A01}, {0x00006563, 0xC23B3601}, {0x00006566, 0xC2465801},
    {0x0000656C, 0xC2374901}, {0x00006570, 0xC23F7401}, {0x00006572, 0xC25A4A01}, {0x00006574, 0xC2403001},
    {0x00006575, 0xC2452801}, {0x00006577, 0xC2495F01}, {0x00006578, 0xC25A4B01}, {0x00006582, 0xC25A4C02},
    {0x00006587, 0xC24A3801}, {0x00006588, 0xC2555D01}, {0x00006589, 0xC2404601}, {0x0000658C, 0xC2494C01},
    {0x0000658E, 0xC23A5801}, {0x00006590, 0xC2486501}, {0x00006591, 0xC2484301}, {0x00006597, 0xC2454D01},
    {0x00006599, 0xC24E4101}, {0x0000659B, 0xC25A4F01}, {0x0000659C, 0xC23C5001}, {0x0000659F, 0xC25A5001},
    {0x000065A1, 0xC2303601}, {0x000065A4, 0xC2365401}, {0x000065A5, 0xC2404D01}, {0x000065A7, 0xC2496001},
    {0x000065AB, 0xC25A5101}, {0x000065AC, 0xC23B4201}, {0x000065AD, 0xC2434701}, {0x000065AF, 0xC23B5B01},
    {0x000065B0, 0xC23F3701}, {0x000065B7, 0xC25A5201}, {0x000065B9, 0xC24A7D01}, {0x000065BC, 0xC2317701},
    {0x000065BD, 0xC23B5C01}, {0x000065C1, 0xC25A5501}, {0x000065C3, 0xC25A5301}, {0x000065C4, 0xC25A5601},
    {0x000065C5, 0xC24E3901}, {0x000065C6, 0xC25A5401}, {0x000065CB, 0xC2407B01}, {0x000065CC, 0xC25A5701},
    {0x000065CF, 0xC2423201}, {0x000065D2, 0xC25A5801}, {0x000065D7, 0xC2347A01}, {0x000065D9, 0xC25A5A01},
    {0x000065DB, 0xC25A5901}, {0x000065E0, 0xC25A5B02}, {0x000065E2, 0xC2347B01}, {0x000065E5, 0xC2467C01},
    {0x000065E6, 0xC2433601}, {0x000065E7, 0xC2356C01}, {0x000065E8, 0xC23B5D01}, {0x000065E9, 0xC2416101},
    {0x000065EC, 0xC23D5C01}, {0x000065ED, 0xC2303001}, {0x000065F1, 0xC25A5D01}, {0x000065FA, 0xC2322201},
    {0x000065FB, 0xC25A6101}, {0x00006602, 0xC2393701}, {0x00006603, 0xC25A6001}, {0x00006606, 0xC23A2B01},
    {0x00006607, 0xC23E3A01}, {0x0000660A, 0xC25A5F01}, {0x0000660C, 0xC23E3B01}, {0x0000660E, 0xC24C4001},
    {0x0000660F, 0xC23A2A01}, {0x00006613, 0xC2305701}, {0x00006614, 0xC2404E01}, {0x0000661C, 0xC25A6601},
    {0x0000661F, 0xC2403101}, {0x00006620, 0xC2314701}, {0x00006624, 0xC2754901}, {0x00006625, 0xC23D5501},
    {0x00006627, 0xC24B6601}, {0x00006628, 0xC23A7201}, {0x0000662D, 0xC23E3C01}, {0x0000662F, 0xC2402701},
    {0x00006634, 0xC25A6501}, {0x00006635, 0xC25A6302}, {0x0000663C, 0xC2436B01}, {0x0000663F, 0xC25B2601},
    {0x00006641, 0xC25A6A01}, {0x00006642, 0xC23B7E01}, {0x00006643, 0xC2393801}, {0x00006644, 0xC25A6801},
    {0x00006649, 0xC25A6901}, {0x0000664B, 0xC23F3801}, {0x0000664F, 0xC25A6701}, {0x00006652, 0xC23B2F01},
    {0x0000665D, 0xC25A6C01}, {0x0000665E, 0xC25A6B01}, {0x0000665F, 0xC25A7001}, {0x00006662, 0xC25A7101},
    {0x00006664, 0xC25A6D01}, {0x00006666, 0xC2332201}, {0x00006667, 0xC25A6E02}, {0x00006669, 0xC2485501},
    {0x0000666E, 0xC2496101}, {0x0000666F, 0xC2374A01}, {0x00006670, 0xC25A7201}, {0x00006674, 0xC2403201},
    {0x00006676, 0xC23E3D01}, {0x0000667A, 0xC2435201}, {0x00006681, 0xC2364701}, {0x00006683, 0xC25A7301},
    {0x00006684, 0xC25A7701}, {0x00006687, 0xC2324B01}, {0x00006688, 0xC25A7401}, {0x00006689, 0xC25A7601},
    {0x0000668E, 0xC25A7501}, {0x00006691, 0xC23D6B01}, {0x00006696, 0xC2434801}, {0x00006697, 0xC2304501},
    {0x00006698, 0xC25A7801}, {0x0000669D, 0xC25A7901}, {0x000066A2, 0xC2442A01}, {0x000066A6, 0xC24E7101},
    {0x000066AB, 0xC23B4301}, {0x000066AE, 0xC24A6B01}, {0x000066B4, 0xC24B3D01}, {0x000066B8, 0xC25B2201},
    {0x000066B9, 0xC25A7B01}, {0x000066BC, 0xC25A7E01}, {0x000066BE, 0xC25A7D01}, {0x000066C1, 0xC25A7A01},
    {0x000066C4, 0xC25B2101}, {0x000066C7, 0xC2465E01}, {0x000066C8, 0xC2754A01}, {0x000066C9, 0xC25A7C01},
    {0x000066D6, 0xC25B2301}, {0x000066D9, 0xC23D6C01}, {0x000066DA, 0xC25B2401}, {0x000066DC, 0xC24D4B01},
    {0x000066DD, 0xC2477801}, {0x000066E0, 0xC25B2501}, {0x000066E6, 0xC25B2701}, {0x000066E9, 0xC25B2801},
    {0x000066F0, 0xC25B2901}, {0x000066F2, 0xC2364A01}, {0x000066F3, 0xC2314801}, {0x000066F4, 0xC2393901},
    {0x000066F5, 0xC25B2A01}, {0x000066F7, 0xC25B2B01}, {0x000066F8, 0xC23D7101}, {0x000066F9, 0xC2416201},
    {0x000066FA, 0xC2754C02}, {0x000066FC, 0xC2525801}, {0x000066FD, 0xC2413E01}, {0x000066FE, 0xC2413D01},
    {0x000066FF, 0xC2425801}, {0x00006700, 0xC23A4701}, {0x00006703, 0xC2507201}, {0x00006708, 0xC2376E01},
    {0x00006709, 0xC24D2D01}, {0x0000670B, 0xC24A7E01}, {0x0000670D, 0xC2497E01}, {0x0000670F, 0xC25B2C01},
    {0x00006714, 0xC23A7301}, {0x00006715, 0xC2443F01}, {0x00006716, 0xC25B2D01}, {0x00006717, 0xC24F2F01},
    {0x0000671B, 0xC24B3E01}, {0x0000671D, 0xC2442B01}, {0x0000671E, 0xC25B2E01}, {0x0000671F, 0xC2347C01},
    {0x00006726, 0xC25B2F02}, {0x00006728, 0xC24C5A01}, {0x0000672A, 0xC24C2401}, {0x0000672B, 0xC24B7601},
    {0x0000672C, 0xC24B5C01}, {0x0000672D, 0xC23B2501}, {0x0000672E, 0xC25B3201}, {0x00006731, 0xC23C6B01},
    {0x00006734, 0xC24B5101}, {0x00006736, 0xC25B3401}, {0x00006737, 0xC25B3701}, {0x00006738, 0xC25B3601},
    {0x0000673A, 0xC2347901}, {0x0000673D, 0xC2356001}, {0x0000673F, 0xC25B3301}, {0x00006741, 0xC25B3501},
    {0x00006746, 0xC25B3801}, {0x00006749, 0xC23F7901}, {0x0000674E, 0xC24D7B01}, {0x0000674F, 0xC2304901},
    {0x00006750, 0xC23A6001}, {0x00006751, 0xC2423C01}, {0x00006753, 0xC23C5D01}, {0x00006756, 0xC23E7301},
    {0x00006759, 0xC25B3B01}, {0x0000675C, 0xC2454E01}, {0x0000675E, 0xC25B3901}, {0x0000675F, 0xC2422B01},
    {0x00006760, 0xC25B3A01}, {0x00006761, 0xC23E7201}, {0x00006762, 0xC24C5D01}, {0x00006763, 0xC25B3C02},
    {0x00006765, 0xC24D6801}, {0x0000676A, 0xC25B4201}, {0x0000676D, 0xC2393A01}, {0x0000676F, 0xC2475501},
    {0x00006770, 0xC25B3F01}, {0x00006771, 0xC2456C01}, {0x00006772, 0xC25A5E01}, {0x00006773, 0xC25A6201},
    {0x00006775, 0xC2354F01}, {0x00006777, 0xC2474701}, {0x0000677C, 0xC25B4101}, {0x0000677E, 0xC23E3E01},
    {0x0000677F, 0xC2484401}, {0x00006785, 0xC25B4701}, {0x00006787, 0xC2487A01}, {0x00006789, 0xC25B3E01},
    {0x0000678B, 0xC25B4401}, {0x0000678C, 0xC25B4301}, {0x00006790, 0xC2404F01}, {0x00006795, 0xC24B6D01},
    {0x00006797, 0xC24E5301}, {0x0000679A, 0xC24B6701}, {0x0000679C, 0xC2324C01}, {0x0000679D, 0xC23B5E01},
    {0x000067A0, 0xC24F4801}, {0x000067A1, 0xC25B4601}, {0x000067A2, 0xC23F7501}, {0x000067A6, 0xC25B4501},
    {0x000067A9, 0xC25B4001}, {0x000067AF, 0xC2384F01}, {0x000067B3, 0xC25B4C01}, {0x000067B4, 0xC25B4A01},
    {0x000067B6, 0xC2324D01}, {0x000067B7, 0xC25B4801}, {0x000067B8, 0xC25B4E01}, {0x000067B9, 0xC25B5401},
    {0x000067C1, 0xC2424801}, {0x000067C4, 0xC24A4101}, {0x000067C6, 0xC25B5601}, {0x000067CA, 0xC2492201},
    {0x000067CE, 0xC25B5501}, {0x000067CF, 0xC2477001}, {0x000067D0, 0xC24B3F01}, {0x000067D1, 0xC2343B01},
    {0x000067D3, 0xC2407701}, {0x000067D4, 0xC23D4001}, {0x000067D8, 0xC2445301}, {0x000067DA, 0xC24D2E01},
    {0x000067DD, 0xC25B5101}, {0x000067DE, 0xC25B5001}, {0x000067E2, 0xC25B5201}, {0x000067E4, 0xC25B4F01},
    {0x000067E7, 0xC25B5701}, {0x000067E9, 0xC25B4D01}, {0x000067EC, 0xC25B4B01}, {0x000067EE, 0xC25B5301},
    {0x000067EF, 0xC25B4901}, {0x000067F1, 0xC2436C01}, {0x000067F3, 0xC24C7801}, {0x000067F4, 0xC23C4601},
    {0x000067F5, 0xC23A7401}, {0x000067FB, 0xC23A3A01}, {0x000067FE, 0xC24B6F01}, {0x000067FF, 0xC2334101},
    {0x00006802, 0xC2444E01}, {0x00006803, 0xC2464A01}, {0x00006804, 0xC2314901}, {0x00006813, 0xC2407201},
    {0x00006816, 0xC2403401}, {0x00006817, 0xC2372A01}, {0x0000681E, 0xC25B5901}, {0x00006821, 0xC2393B01},
    {0x00006822, 0xC2337C01}, {0x00006829, 0xC25B5B01}, {0x0000682A, 0xC2337401}, {0x0000682B, 0xC25B6101},
    {0x00006832, 0xC25B5E01}, {0x00006834, 0xC2407301}, {0x00006838, 0xC2334B01}, {0x00006839, 0xC23A2C01},
    {0x0000683C, 0xC2334A01}, {0x0000683D, 0xC23A4F01}, {0x00006840, 0xC25B5C01}, {0x00006841, 0xC2376501},
    {0x00006842, 0xC2374B01}, {0x00006843, 0xC2456D01}, {0x00006846, 0xC25B5A01}, {0x00006848, 0xC2304601},
    {0x0000684D, 0xC25B5D01}, {0x0000684E, 0xC25B5F01}, {0x00006850, 0xC2364D01}, {0x00006851, 0xC2372C01},
    {0x00006852, 0xC2754E01}, {0x00006853, 0xC2343C01}, {0x00006854, 0xC2354B01}, {0x00006859, 0xC25B6201},
    {0x0000685C, 0xC23A7901}, {0x0000685D, 0xC24B7101}, {0x0000685F, 0xC23B3701}, {0x00006863, 0xC25B6301},
    {0x00006867, 0xC2493001}, {0x00006874, 0xC25B6F01}, {0x00006876, 0xC2323301}, {0x00006877, 0xC25B6401},
    {0x0000687E, 0xC25B7501}, {0x0000687F, 0xC25B6501}, {0x00006881, 0xC24E4201}, {0x00006883, 0xC25B6C01},
    {0x00006885, 0xC2475F01}, {0x0000688D, 0xC25B7401}, {0x0000688F, 0xC25B6701}, {0x00006893, 0xC2303401},
    {0x00006894, 0xC25B6901}, {0x00006897, 0xC2393C01}, {0x0000689B, 0xC25B6B01}, {0x0000689D, 0xC25B6A01},
    {0x0000689F, 0xC25B6601}, {0x000068A0, 0xC25B7101}, {0x000068A2, 0xC23E3F01}, {0x000068A6, 0xC2546D01},
    {0x000068A7, 0xC2386801}, {0x000068A8, 0xC24D7C01}, {0x000068AD, 0xC25B6801}, {0x000068AF, 0xC2447401},
    {0x000068B0, 0xC2332301}, {0x000068B1, 0xC23A2D01}, {0x000068B3, 0xC25B6001}, {0x000068B5, 0xC25B7001},
    {0x000068B6, 0xC2336101}, {0x000068B9, 0xC25B6E01}, {0x000068BA, 0xC25B7201}, {0x000068BC, 0xC2456E01},
    {0x000068C4, 0xC2347E01}, {0x000068C6, 0xC25C3201}, {0x000068C9, 0xC24C4901}, {0x000068CA, 0xC25B7701},
    {0x000068CB, 0xC2347D01}, {0x000068CD, 0xC25B7E01}, {0x000068D2, 0xC24B4001}, {0x000068D4, 0xC25C2101},
    {0x000068D5, 0xC25C2301}, {0x000068D7, 0xC25C2701}, {0x000068D8, 0xC25B7901}, {0x000068DA, 0xC2432A01},
    {0x000068DF, 0xC2456F01}, {0x000068E0, 0xC25C2B01}, {0x000068E1, 0xC25B7C01}, {0x000068E3, 0xC25C2801},
    {0x000068E7, 0xC25C2201}, {0x000068EE, 0xC23F3901}, {0x000068EF, 0xC25C2C01}, {0x000068F2, 0xC2403301},
    {0x000068F9, 0xC25C2A01}, {0x000068FA, 0xC2343D01}, {0x00006900, 0xC24F5001}, {0x00006901, 0xC25B7601},
    {0x00006904, 0xC25C2601}, {0x00006905, 0xC2305801}, {0x00006908, 0xC25B7801}, {0x0000690B, 0xC24C3A01},
    {0x0000690C, 0xC25B7D01}, {0x0000690D, 0xC23F2201}, {0x0000690E, 0xC2444701}, {0x0000690F, 0xC25B7301},
    {0x00006911, 0xC2755001}, {0x00006912, 0xC25C2501}, {0x00006919, 0xC23F7A01}, {0x0000691A, 0xC25C2F01},
    {0x0000691B, 0xC2337101}, {0x0000691C, 0xC2382101}, {0x00006921, 0xC25C3101}, {0x00006922, 0xC25B7A01},
    {0x00006923, 0xC25C3001}, {0x00006925, 0xC25C2901}, {0x00006926, 0xC25B7B01}, {0x00006928, 0xC25C2D01},
    {0x0000692A, 0xC25C2E01}, {0x00006930, 0xC25C3F01}, {0x00006934, 0xC2464E01}, {0x00006936, 0xC25C2401},
    {0x00006939, 0xC25C3B01}, {0x0000693B, 0xC2755101}, {0x0000693D, 0xC25C3D01}, {0x0000693F, 0xC2445801},
    {0x0000694A, 0xC24D4C01}, {0x00006953, 0xC2497601}, {0x00006954, 0xC25C3801}, {0x00006955, 0xC2424A01},
    {0x00006959, 0xC25C3E01}, {0x0000695A, 0xC2413F01}, {0x0000695C, 0xC25C3501}, {0x0000695D, 0xC25C4201},
    {0x0000695E, 0xC25C4101}, {0x00006960, 0xC2466F01}, {0x00006961, 0xC25C4001}, {0x00006962, 0xC2466A01},
    {0x0000696A, 0xC25C4401}, {0x0000696B, 0xC25C3701}, {0x0000696D, 0xC2364801}, {0x0000696E, 0xC25C3A01},
    {0x0000696F, 0xC23D5D01}, {0x00006973, 0xC2476001}, {0x00006974, 0xC25C3C01}, {0x00006975, 0xC2364B01},
    {0x00006977, 0xC25C3401}, {0x00006978, 0xC25C3601}, {0x00006979, 0xC25C3301}, {0x0000697C, 0xC24F3001},
    {0x0000697D, 0xC2335A01}, {0x0000697E, 0xC25C3901}, {0x00006981, 0xC25C4301}, {0x00006982, 0xC2333501},
    {0x0000698A, 0xC23A6701}, {0x0000698E, 0xC2315D01}, {0x00006991, 0xC25C5401}, {0x00006994, 0xC24F3101},
    {0x00006995, 0xC25C5701}, {0x0000699B, 0xC23F3A01}, {0x0000699C, 0xC25C5601}, {0x000069A0, 0xC25C5501},
    {0x000069A7, 0xC25C5201}, {0x000069AE, 0xC25C4601}, {0x000069B1, 0xC25C6301}, {0x000069B2, 0xC25C4501},
    {0x000069B4, 0xC25C5801}, {0x000069BB, 0xC25C5001}, {0x000069BE, 0xC25C4B01}, {0x000069BF, 0xC25C4801},
    {0x000069C1, 0xC25C4901}, {0x000069C3, 0xC25C5101}, {0x000069C7, 0xC2742201}, {0x000069CA, 0xC25C4E01},
    {0x000069CB, 0xC2393D01}, {0x000069CC, 0xC2444801}, {0x000069CD, 0xC2416401}, {0x000069CE, 0xC25C4C01},
    {0x000069D0, 0xC25C4701}, {0x000069D3, 0xC25C4A01}, {0x000069D8, 0xC24D4D01}, {0x000069D9, 0xC24B6A01},
    {0x000069DD, 0xC25C4F01}, {0x000069DE, 0xC25C5901}, {0x000069E7, 0xC25C6101}, {0x000069E8, 0xC25C5A01},
    {0x000069EB, 0xC25C6701}, {0x000069ED, 0xC25C6501}, {0x000069F2, 0xC25C6001}, {0x000069F9, 0xC25C5F01},
    {0x000069FB, 0xC2445001}, {0x000069FD, 0xC2416501}, {0x000069FF, 0xC25C5D01}, {0x00006A02, 0xC25C5B01},
    {0x00006A05, 0xC25C6201}, {0x00006A0A, 0xC25C6801}, {0x00006A0B, 0xC2487501}, {0x00006A0C, 0xC25C6E01},
    {0x00006A12, 0xC25C6901}, {0x00006A13, 0xC25C6C01}, {0x00006A14, 0xC25C6601}, {0x00006A17, 0xC2437401},
    {0x00006A19, 0xC2493801}, {0x00006A1B, 0xC25C5C01}, {0x00006A1E, 0xC25C6401}, {0x00006A1F, 0xC23E4001},
    {0x00006A21, 0xC24C4F01}, {0x00006A22, 0xC25C7801}, {0x00006A23, 0xC25C6B01}, {0x00006A29, 0xC2382201},
    {0x00006A2A, 0xC2322301}, {0x00006A2B, 0xC2335F01}, {0x00006A2E, 0xC25C5301}, {0x00006A35, 0xC23E4101},
    {0x00006A36, 0xC25C7001}, {0x00006A38, 0xC25C7701}, {0x00006A39, 0xC23C7901}, {0x00006A3A, 0xC2337201},
    {0x00006A3D, 0xC2432E01}, {0x00006A44, 0xC25C6D01}, {0x00006A45, 0xC2755201}, {0x00006A47, 0xC25C7201},
    {0x00006A48, 0xC25C7601}, {0x00006A4B, 0xC2363601}, {0x00006A58, 0xC2354C01}, {0x00006A59, 0xC25C7401},
    {0x00006A5F, 0xC2352101}, {0x00006A61, 0xC2464B01}, {0x00006A62, 0xC25C7301}, {0x00006A66, 0xC25C7501},
    {0x00006A72, 0xC25C6F01}, {0x00006A78, 0xC25C7101}, {0x00006A7F, 0xC2336001}, {0x00006A80, 0xC2434901},
    {0x00006A84, 0xC25C7C01}, {0x00006A8D, 0xC25C7A01}, {0x00006A8E, 0xC2386901}, {0x00006A90, 0xC25C7901},
    {0x00006A91, 0xC2755301}, {0x00006A97, 0xC25D2101}, {0x00006A9C, 0xC25B5801}, {0x00006AA0, 0xC25C7B01},
    {0x00006AA2, 0xC25C7D02}, {0x00006AAA, 0xC25D2C01}, {0x00006AAC, 0xC25D2801}, {0x00006AAE, 0xC25B6D01},
    {0x00006AB3, 0xC25D2701}, {0x00006AB8, 0xC25D2601}, {0x00006ABB, 0xC25D2301}, {0x00006AC1, 0xC25C6A01},
    {0x00006AC2, 0xC25D2501}, {0x00006AC3, 0xC25D2401}, {0x00006AD1, 0xC25D2A01}, {0x00006AD3, 0xC24F2601},
    {0x00006ADA, 0xC25D2D01}, {0x00006ADB, 0xC2367B01}, {0x00006ADE, 0xC25D2901}, {0x00006ADF, 0xC25D2B01},
    {0x00006AE8, 0xC2482701}, {0x00006AEA, 0xC25D2E01}, {0x00006AFA, 0xC25D3201}, {0x00006AFB, 0xC25D2F01},
    {0x00006B04, 0xC24D7301}, {0x00006B05, 0xC25D3001}, {0x00006B0A, 0xC25C5E01}, {0x00006B12, 0xC25D3301},
    {0x00006B16, 0xC25D3401}, {0x00006B1D, 0xC2313501}, {0x00006B1F, 0xC25D3601}, {0x00006B20, 0xC2376701},
    {0x00006B21, 0xC23C2101}, {0x00006B23, 0xC2365501}, {0x00006B27, 0xC2322401}, {0x00006B32, 0xC24D5F01},
    {0x00006B37, 0xC25D3801}, {0x00006B38, 0xC25D3701}, {0x00006B39, 0xC25D3A01}, {0x00006B3A, 0xC2353D01},
    {0x00006B3D, 0xC2365601}, {0x00006B3E, 0xC2343E01}, {0x00006B43, 0xC25D3D01}, {0x00006B47, 0xC25D3C01},
    {0x00006B49, 0xC25D3E01}, {0x00006B4C, 0xC2324E01}, {0x00006B4E, 0xC2433701}, {0x00006B50, 0xC25D3F01},
    {0x00006B53, 0xC2343F01}, {0x00006B54, 0xC25D4101}, {0x00006B59, 0xC25D4001}, {0x00006B5B, 0xC25D4201},
    {0x00006B5F, 0xC25D4301}, {0x00006B61, 0xC25D4401}, {0x00006B62, 0xC23B5F01}, {0x00006B63, 0xC2403501},
    {0x00006B64, 0xC23A2101}, {0x00006B66, 0xC2497001}, {0x00006B69, 0xC24A6201}, {0x00006B6A, 0xC24F4401},
    {0x00006B6F, 0xC23B7501}, {0x00006B73, 0xC23A5001}, {0x00006B74, 0xC24E7201}, {0x00006B78, 0xC25D4502},
    {0x00006B7B, 0xC23B6001}, {0x00006B7F, 0xC25D4702}, {0x00006B83, 0xC25D4A01}, {0x00006B84, 0xC25D4901},
    {0x00006B86, 0xC24B5801}, {0x00006B89, 0xC23D5E01}, {0x00006B8A, 0xC23C6C01}, {0x00006B8B, 0xC23B4401},
    {0x00006B8D, 0xC25D4B01}, {0x00006B95, 0xC25D4D01}, {0x00006B96, 0xC23F2301}, {0x00006B98, 0xC25D4C01},
    {0x00006B9E, 0xC25D4E01}, {0x00006BA4, 0xC25D4F01}, {0x00006BAA, 0xC25D5002}, {0x00006BAF, 0xC25D5201},
    {0x00006BB1, 0xC25D5401}, {0x00006BB2, 0xC25D5301}, {0x00006BB3, 0xC25D5501}, {0x00006BB4, 0xC2322501},
    {0x00006BB5, 0xC2434A01}, {0x00006BB7, 0xC25D5601}, {0x00006BBA, 0xC23B2601}, {0x00006BBB, 0xC2334C01},
    {0x00006BBC, 0xC25D5701}, {0x00006BBF, 0xC2454201}, {0x00006BC0, 0xC2544C01}, {0x00006BC5, 0xC2352301},
    {0x00006BC6, 0xC25D5801}, {0x00006BCB, 0xC25D5901}, {0x00006BCD, 0xC24A6C01}, {0x00006BCE, 0xC24B6801},
    {0x00006BD2, 0xC2464701}, {0x00006BD3, 0xC25D5A01}, {0x00006BD4, 0xC2486601}, {0x00006BD8, 0xC2487B01},
    {0x00006BDB, 0xC24C5301}, {0x00006BDF, 0xC25D5B01}, {0x00006BEB, 0xC25D5D01}, {0x00006BEC, 0xC25D5C01},
    {0x00006BEF, 0xC25D5F01}, {0x00006BF1, 0xC2755801}, {0x00006BF3, 0xC25D5E01}, {0x00006C08, 0xC25D6101},
    {0x00006C0F, 0xC23B6101}, {0x00006C11, 0xC24C3101}, {0x00006C13, 0xC25D6202}, {0x00006C17, 0xC2352401},
    {0x00006C1B, 0xC25D6401}, {0x00006C23, 0xC25D6601}, {0x00006C24, 0xC25D6501}, {0x00006C34, 0xC23F6501},
    {0x00006C37, 0xC2493901}, {0x00006C38, 0xC2314A01}, {0x00006C3E, 0xC2484501}, {0x00006C40, 0xC2447501},
    {0x00006C41, 0xC23D4101}, {0x00006C42, 0xC2356101}, {0x00006C4E, 0xC2484601}, {0x00006C50, 0xC23C2E01},
    {0x00006C55, 0xC25D6801}, {0x00006C57, 0xC2344001}, {0x00006C5A, 0xC2317801}, {0x00006C5D, 0xC2467201},
    {0x00006C5E, 0xC25D6701}, {0x00006C5F, 0xC2393E01}, {0x00006C60, 0xC2435301}, {0x00006C62, 0xC25D6901},
    {0x00006C68, 0xC25D7101}, {0x00006C6A, 0xC25D6A01}, {0x00006C70, 0xC2424101}, {0x00006C72, 0xC2356201},
    {0x00006C73, 0xC25D7201}, {0x00006C7A, 0xC2376801}, {0x00006C7D, 0xC2352501}, {0x00006C7E, 0xC25D7001},
    {0x00006C81, 0xC25D6E01}, {0x00006C82, 0xC25D6B01}, {0x00006C83, 0xC24D6001}, {0x00006C88, 0xC2444001},
    {0x00006C8C, 0xC2465901}, {0x00006C8D, 0xC25D6C01}, {0x00006C90, 0xC25D7401}, {0x00006C92, 0xC25D7301},
    {0x00006C93, 0xC2372301}, {0x00006C96, 0xC2322D01}, {0x00006C99, 0xC23A3B01}, {0x00006C9A, 0xC25D6D01},
    {0x00006C9B, 0xC25D6F01}, {0x00006CA1, 0xC24B5701}, {0x00006CA2, 0xC2427401}, {0x00006CAB, 0xC24B7701},
    {0x00006CAE, 0xC25D7C01}, {0x00006CB1, 0xC25D7D01}, {0x00006CB3, 0xC2324F01}, {0x00006CB8, 0xC24A2801},
    {0x00006CB9, 0xC24C7D01}, {0x00006CBA, 0xC25E2101}, {0x00006CBB, 0xC23C2301}, {0x00006CBC, 0xC23E4201},
    {0x00006CBD, 0xC25D7801}, {0x00006CBE, 0xC25D7E01}, {0x00006CBF, 0xC2316801}, {0x00006CC1, 0xC2363701},
    {0x00006CC4, 0xC25D7501}, {0x00006CC5, 0xC25D7A01}, {0x00006CC9, 0xC2407401}, {0x00006CCA, 0xC2477101},
    {0x00006CCC, 0xC2486701}, {0x00006CD3, 0xC25D7701}, {0x00006CD5, 0xC24B2101}, {0x00006CD7, 0xC25D7901},
    {0x00006CD9, 0xC25E2401}, {0x00006CDB, 0xC25E2201}, {0x00006CDD, 0xC25D7B01}, {0x00006CE0, 0xC2755901},
    {0x00006CE1, 0xC24B2201}, {0x00006CE2, 0xC2474801}, {0x00006CE3, 0xC2356301}, {0x00006CE5, 0xC2452501},
    {0x00006CE8, 0xC2436D01}, {0x00006CEA, 0xC25E2501}, {0x00006CEF, 0xC25E2301}, {0x00006CF0, 0xC2425901},
    {0x00006CF1, 0xC25D7601}, {0x00006CF3, 0xC2314B01}, {0x00006D0B, 0xC24D4E01}, {0x00006D0C, 0xC25E3001},
    {0x00006D12, 0xC25E2F01}, {0x00006D17, 0xC2407601}, {0x00006D19, 0xC25E2C01}, {0x00006D1B, 0xC24D6C01},
    {0x00006D1E, 0xC2463601}, {0x00006D1F, 0xC25E2601}, {0x00006D25, 0xC2444501}, {0x00006D29, 0xC2314C01},
    {0x00006D2A, 0xC2393F01}, {0x00006D2B, 0xC25E2901}, {0x00006D2E, 0xC2755A01}, {0x00006D32, 0xC23D2701},
    {0x00006D33, 0xC25E2E01}, {0x00006D35, 0xC25E2D01}, {0x00006D36, 0xC25E2801}, {0x00006D38, 0xC25E2B01},
    {0x00006D3B, 0xC2336801}, {0x00006D3D, 0xC25E2A01}, {0x00006D3E, 0xC2474901}, {0x00006D41, 0xC24E2E01},
    {0x00006D44, 0xC23E7401}, {0x00006D45, 0xC2407501}, {0x00006D59, 0xC25E3601}, {0x00006D5A, 0xC25E3401},
    {0x00006D5C, 0xC2494D01}, {0x00006D63, 0xC25E3101}, {0x00006D64, 0xC25E3301}, {0x00006D66, 0xC2313A01},
    {0x00006D69, 0xC2394001}, {0x00006D6A, 0xC24F3201}, {0x00006D6C, 0xC2333D01}, {0x00006D6E, 0xC2496201},
    {0x00006D74, 0xC24D6101}, {0x00006D77, 0xC2332401}, {0x00006D78, 0xC23F3B01}, {0x00006D79, 0xC25E3501},
    {0x00006D85, 0xC25E3A01}, {0x00006D88, 0xC23E4301}, {0x00006D8C, 0xC24D3001}, {0x00006D8E, 0xC25E3701},
    {0x00006D93, 0xC25E3201}, {0x00006D95, 0xC25E3801}, {0x00006D99, 0xC24E5E01}, {0x00006D9B, 0xC2457301},
    {0x00006D9C, 0xC2464201}, {0x00006DAF, 0xC2333601}, {0x00006DB2, 0xC2315501}, {0x00006DB5, 0xC25E3E01},
    {0x00006DB8, 0xC25E4101}, {0x00006DBC, 0xC24E4301}, {0x00006DBF, 0xC2755C01}, {0x00006DC0, 0xC24D6401},
    {0x00006DC5, 0xC25E4801}, {0x00006DC6, 0xC25E4201}, {0x00006DC7, 0xC25E3F01}, {0x00006DCA, 0xC2755D01},
    {0x00006DCB, 0xC24E5401}, {0x00006DCC, 0xC25E4501}, {0x00006DD1, 0xC23D4A01}, {0x00006DD2, 0xC25E4701},
    {0x00006DD5, 0xC25E4C01}, {0x00006DD8, 0xC2457101}, {0x00006DD9, 0xC25E4A01}, {0x00006DDE, 0xC25E4401},
    {0x00006DE1, 0xC2433801}, {0x00006DE4, 0xC25E4B01}, {0x00006DE6, 0xC25E4001}, {0x00006DE8, 0xC25E4601},
    {0x00006DEA, 0xC25E4D01}, {0x00006DEB, 0xC2307C01}, {0x00006DEC, 0xC25E4301}, {0x00006DEE, 0xC25E4E01},
    {0x00006DF1, 0xC23F3C01}, {0x00006DF3, 0xC23D5F01}, {0x00006DF5, 0xC24A2501}, {0x00006DF7, 0xC23A2E01},
    {0x00006DF8, 0xC2755E01}, {0x00006DF9, 0xC25E3B01}, {0x00006DFA, 0xC25E4901}, {0x00006DFB, 0xC2453A01},
    {0x00006E05, 0xC2403601}, {0x00006E07, 0xC2336901}, {0x00006E08, 0xC23A5101}, {0x00006E09, 0xC23E4401},
    {0x00006E0A, 0xC25E3D01}, {0x00006E0B, 0xC23D4201}, {0x00006E13, 0xC2374C01}, {0x00006E15, 0xC25E3C01},
    {0x00006E19, 0xC25E5201}, {0x00006E1A, 0xC23D6D01}, {0x00006E1B, 0xC2383A01}, {0x00006E1D, 0xC25E6101},
    {0x00006E1F, 0xC25E5B01}, {0x00006E20, 0xC2357401}, {0x00006E21, 0xC2454F01}, {0x00006E23, 0xC25E5601},
    {0x00006E24, 0xC25E5F01}, {0x00006E25, 0xC2302F01}, {0x00006E26, 0xC2313201}, {0x00006E29, 0xC2323901},
    {0x00006E2B, 0xC25E5801}, {0x00006E2C, 0xC2422C01}, {0x00006E2D, 0xC25E4F01}, {0x00006E2E, 0xC25E5101},
    {0x00006E2F, 0xC2394101}, {0x00006E38, 0xC25E6201}, {0x00006E3A, 0xC25E5D01}, {0x00006E3E, 0xC25E5501},
    {0x00006E43, 0xC25E5C01}, {0x00006E4A, 0xC24C2B01}, {0x00006E4D, 0xC25E5A01}, {0x00006E4E, 0xC25E5E01},
    {0x00006E56, 0xC2385001}, {0x00006E58, 0xC23E4501}, {0x00006E5B, 0xC2433901}, {0x00006E5F, 0xC25E5401},
    {0x00006E67, 0xC24D2F01}, {0x00006E6B, 0xC25E5701}, {0x00006E6E, 0xC25E5001}, {0x00006E6F, 0xC2457201},
    {0x00006E72, 0xC25E5301}, {0x00006E76, 0xC25E5901}, {0x00006E7E, 0xC24F5101}, {0x00006E7F, 0xC23C3E01},
    {0x00006E80, 0xC24B7E01}, {0x00006E82, 0xC25E6301}, {0x00006E8C, 0xC2482E01}, {0x00006E8F, 0xC25E6F01},
    {0x00006E90, 0xC2383B01}, {0x00006E96, 0xC23D6001}, {0x00006E98, 0xC25E6501}, {0x00006E9C, 0xC24E2F01},
    {0x00006E9D, 0xC2394201}, {0x00006E9F, 0xC25E7201}, {0x00006EA2, 0xC2306E01}, {0x00006EA5, 0xC25E7001},
    {0x00006EAA, 0xC25E6401}, {0x00006EAF, 0xC25E6A01}, {0x00006EB2, 0xC25E6C01}, {0x00006EB6, 0xC24D4F01},
    {0x00006EB7, 0xC25E6701}, {0x00006EBA, 0xC2452E01}, {0x00006EBD, 0xC25E6901}, {0x00006EC2, 0xC25E7101},
    {0x00006EC4, 0xC25E6B01}, {0x00006EC5, 0xC24C4701}, {0x00006EC9, 0xC25E6601}, {0x00006ECB, 0xC23C2201},
    {0x00006ECC, 0xC25E7E01}, {0x00006ED1, 0xC2336A01}, {0x00006ED3, 0xC25E6801}, {0x00006ED4, 0xC25E6D02},
    {0x00006EDD, 0xC2426C01}, {0x00006EDE, 0xC2425A01}, {0x00006EEC, 0xC25E7601}, {0x00006EEF, 0xC25E7C01},
    {0x00006EF2, 0xC25E7A01}, {0x00006EF4, 0xC2452901}, {0x00006EF7, 0xC25F2301}, {0x00006EF8, 0xC25E7701},
    {0x00006EFE, 0xC25E7801}, {0x00006EFF, 0xC25E6001}, {0x00006F01, 0xC2357901}, {0x00006F02, 0xC2493A01},
    {0x00006F06, 0xC23C3F01}, {0x00006F09, 0xC2397701}, {0x00006F0F, 0xC24F3301}, {0x00006F11, 0xC25E7401},
    {0x00006F13, 0xC25F2201}, {0x00006F14, 0xC2316901}, {0x00006F15, 0xC2416601}, {0x00006F20, 0xC2477901},
    {0x00006F22, 0xC2344101}, {0x00006F23, 0xC24E7A01}, {0x00006F2B, 0xC24C2101}, {0x00006F2C, 0xC2445201},
    {0x00006F31, 0xC25E7B01}, {0x00006F32, 0xC25E7D01}, {0x00006F38, 0xC2413201}, {0x00006F3E, 0xC25F2101},
    {0x00006F3F, 0xC25E7901}, {0x00006F41, 0xC25E7301}, {0x00006F45, 0xC2344301}, {0x00006F54, 0xC2376901},
    {0x00006F58, 0xC25F2F01}, {0x00006F5B, 0xC25F2A01}, {0x00006F5C, 0xC2407801}, {0x00006F5E, 0xC2756001},
    {0x00006F5F, 0xC2336301}, {0x00006F64, 0xC23D6101}, {0x00006F66, 0xC25F3301}, {0x00006F6D, 0xC25F2C01},
    {0x00006F6E, 0xC2442C01}, {0x00006F6F, 0xC25F2901}, {0x00006F70, 0xC2445901}, {0x00006F74, 0xC25F4C01},
    {0x00006F78, 0xC25F2601}, {0x00006F7A, 0xC25F2501}, {0x00006F7C, 0xC25F2E01}, {0x00006F80, 0xC25F2801},
    {0x00006F81, 0xC25F2701}, {0x00006F82, 0xC25F2D01}, {0x00006F84, 0xC2402101}, {0x00006F86, 0xC25F2401},
    {0x00006F8E, 0xC25F3001}, {0x00006F91, 0xC25F3101}, {0x00006F97, 0xC2344201}, {0x00006FA1, 0xC25F3601},
    {0x00006FA3, 0xC25F3501}, {0x00006FA4, 0xC25F3701}, {0x00006FAA, 0xC25F3A01}, {0x00006FB1, 0xC2454301},
    {0x00006FB3, 0xC25F3401}, {0x00006FB9, 0xC25F3801}, {0x00006FC0, 0xC2376301}, {0x00006FC1, 0xC2427901},
    {0x00006FC2, 0xC25F3201}, {0x00006FC3, 0xC2473B01}, {0x00006FC6, 0xC25F3901}, {0x00006FD4, 0xC25F3E01},
    {0x00006FD5, 0xC25F3C01}, {0x00006FD8, 0xC25F3F01}, {0x00006FDB, 0xC25F4201}, {0x00006FDF, 0xC25F3B01},
    {0x00006FE0, 0xC2396A01}, {0x00006FE1, 0xC2472801}, {0x00006FE4, 0xC25E3901}, {0x00006FEB, 0xC24D7401},
    {0x00006FEC, 0xC25F3D01}, {0x00006FEE, 0xC25F4101}, {0x00006FEF, 0xC2427501}, {0x00006FF1, 0xC25F4001},
    {0x00006FF3, 0xC25F2B01}, {0x00006FF6, 0xC26F6901}, {0x00006FF9, 0xC2756101}, {0x00006FFA, 0xC25F4501},
    {0x00006FFE, 0xC25F4901}, {0x00007001, 0xC25F4701}, {0x00007009, 0xC25F4301}, {0x0000700B, 0xC25F4401},
    {0x0000700F, 0xC25F4801}, {0x00007011, 0xC25F4601}, {0x00007015, 0xC2494E01}, {0x00007018, 0xC25F4E01},
    {0x0000701A, 0xC25F4B01}, {0x0000701B, 0xC25F4A01}, {0x0000701D, 0xC25F4D01}, {0x0000701E, 0xC2465401},
    {0x0000701F, 0xC25F4F01}, {0x00007026, 0xC2437501}, {0x00007027, 0xC2426D01}, {0x0000702C, 0xC2402501},
    {0x00007030, 0xC25F5001}, {0x00007032, 0xC25F5201}, {0x0000703E, 0xC25F5101}, {0x0000704C, 0xC25E7501},
    {0x00007051, 0xC25F5301}, {0x00007058, 0xC2466701}, {0x00007063, 0xC25F5401}, {0x00007064, 0xC2756201},
    {0x0000706B, 0xC2325001}, {0x0000706F, 0xC2457401}, {0x00007070, 0xC2332501}, {0x00007078, 0xC2356401},
    {0x0000707C, 0xC23C5E01}, {0x0000707D, 0xC23A5201}, {0x00007089, 0xC24F2701}, {0x0000708A, 0xC23F6601},
    {0x0000708E, 0xC2316A01}, {0x00007092, 0xC25F5601}, {0x00007099, 0xC25F5501}, {0x000070AC, 0xC25F5901},
    {0x000070AD, 0xC2433A01}, {0x000070AE, 0xC25F5C01}, {0x000070AF, 0xC25F5701}, {0x000070B3, 0xC25F5B01},
    {0x000070B8, 0xC25F5A01}, {0x000070B9, 0xC2454001}, {0x000070BA, 0xC2305901}, {0x000070C8, 0xC24E7501},
    {0x000070CB, 0xC25F5E01}, {0x000070CF, 0xC2312801}, {0x000070D9, 0xC25F6001}, {0x000070DD, 0xC25F5F01},
    {0x000070DF, 0xC25F5D01}, {0x000070F1, 0xC25F5801}, {0x000070F9, 0xC24B2301}, {0x000070FD, 0xC25F6201},
    {0x00007109, 0xC25F6101}, {0x00007114, 0xC2316B01}, {0x00007119, 0xC25F6401}, {0x0000711A, 0xC24A3201},
    {0x0000711C, 0xC25F6301}, {0x00007121, 0xC24C3501}, {0x00007126, 0xC23E4701}, {0x00007136, 0xC2413301},
    {0x0000713C, 0xC23E4601}, {0x00007147, 0xC2756501}, {0x00007149, 0xC24E7B01}, {0x0000714C, 0xC25F6A01},
    {0x0000714E, 0xC2407901}, {0x00007155, 0xC25F6601}, {0x00007156, 0xC25F6B01}, {0x00007159, 0xC2316C01},
    {0x00007162, 0xC25F6901}, {0x00007164, 0xC2476101}, {0x00007165, 0xC25F6501}, {0x00007166, 0xC25F6801},
    {0x00007167, 0xC23E4801}, {0x00007169, 0xC2485101}, {0x0000716C, 0xC25F6C01}, {0x0000716E, 0xC23C5101},
    {0x0000717D, 0xC2407A01}, {0x00007184, 0xC25F6F01}, {0x00007188, 0xC25F6701}, {0x0000718A, 0xC2372701},
    {0x0000718F, 0xC25F6D01}, {0x00007194, 0xC24D5001}, {0x00007195, 0xC25F7001}, {0x00007199, 0xC2742601},
    {0x0000719F, 0xC23D4F01}, {0x000071A8, 0xC25F7101}, {0x000071AC, 0xC25F7201}, {0x000071B1, 0xC2472E01},
    {0x000071B9, 0xC25F7401}, {0x000071BE, 0xC25F7501}, {0x000071C1, 0xC2756601}, {0x000071C3, 0xC2473301},
    {0x000071C8, 0xC2457501}, {0x000071C9, 0xC25F7701}, {0x000071CE, 0xC25F7901}, {0x000071D0, 0xC24E5501},
    {0x000071D2, 0xC25F7601}, {0x000071D4, 0xC25F7801}, {0x000071D5, 0xC2316D01}, {0x000071D7, 0xC25F7301},
    {0x000071DF, 0xC2535B01}, {0x000071E0, 0xC25F7A01}, {0x000071E5, 0xC2416701}, {0x000071E6, 0xC23B3801},
    {0x000071E7, 0xC25F7C01}, {0x000071EC, 0xC25F7B01}, {0x000071ED, 0xC23F2401}, {0x000071EE, 0xC2525901},
    {0x000071F5, 0xC25F7D01}, {0x000071F9, 0xC2602101}, {0x000071FB, 0xC25F6E01}, {0x000071FC, 0xC25F7E01},
    {0x000071FF, 0xC2602201}, {0x00007200, 0xC2756701}, {0x00007206, 0xC2477A01}, {0x0000720D, 0xC2602301},
    {0x00007210, 0xC2602401}, {0x0000721B, 0xC2602501}, {0x00007228, 0xC2602601}, {0x0000722A, 0xC2445E01},
    {0x0000722C, 0xC2602801}, {0x0000722D, 0xC2602701}, {0x00007230, 0xC2602901}, {0x00007232, 0xC2602A01},
    {0x00007235, 0xC23C5F01}, {0x00007236, 0xC2496301}, {0x0000723A, 0xC24C6C01}, {0x0000723B, 0xC2602B02},
    {0x0000723D, 0xC2415601}, {0x0000723E, 0xC23C2401}, {0x0000723F, 0xC2602D02}, {0x00007246, 0xC2602F01},
    {0x00007247, 0xC24A5201}, {0x00007248, 0xC2484701}, {0x0000724B, 0xC2603001}, {0x0000724C, 0xC2475701},
    {0x00007252, 0xC2442D01}, {0x00007258, 0xC2603101}, {0x00007259, 0xC2326701}, {0x0000725B, 0xC2356D01},
    {0x0000725D, 0xC24C4601}, {0x0000725F, 0xC24C3601}, {0x00007261, 0xC2323401}, {0x00007262, 0xC24F3401},
    {0x00007267, 0xC24B5201}, {0x00007269, 0xC24A2A01}, {0x00007272, 0xC2403701}, {0x00007274, 0xC2603201},
    {0x00007279, 0xC2464301}, {0x0000727D, 0xC2382301}, {0x0000727E, 0xC2603301}, {0x00007280, 0xC23A5401},
    {0x00007281, 0xC2603501}, {0x00007282, 0xC2603401}, {0x00007287, 0xC2603601}, {0x00007292, 0xC2603701},
    {0x00007296, 0xC2603801}, {0x000072A0, 0xC2353E01}, {0x000072A2, 0xC2603901}, {0x000072A7, 0xC2603A01},
    {0x000072AC, 0xC2382401}, {0x000072AF, 0xC2484801}, {0x000072B2, 0xC2603C01}, {0x000072B6, 0xC23E7501},
    {0x000072B9, 0xC2603B01}, {0x000072C2, 0xC2363801}, {0x000072C3, 0xC2603D01}, {0x000072C4, 0xC2603F01},
    {0x000072C6, 0xC2603E01}, {0x000072CE, 0xC2604001}, {0x000072D0, 0xC2385101}, {0x000072D2, 0xC2604101},
    {0x000072D7, 0xC2366901}, {0x000072D9, 0xC2414001}, {0x000072DB, 0xC2397D01}, {0x000072E0, 0xC2604302},
    {0x000072E2, 0xC2604201}, {0x000072E9, 0xC23C6D01}, {0x000072EC, 0xC2464801}, {0x000072ED, 0xC2363901},
    {0x000072F7, 0xC2604601}, {0x000072F8, 0xC2432C01}, {0x000072F9, 0xC2604501}, {0x000072FC, 0xC24F3501},
    {0x000072FD, 0xC2476201}, {0x0000730A, 0xC2604901}, {0x00007316, 0xC2604B01}, {0x00007317, 0xC2604801},
    {0x0000731B, 0xC24C5401}, {0x0000731C, 0xC2604A01}, {0x0000731D, 0xC2604C01}, {0x0000731F, 0xC24E4401},
    {0x00007325, 0xC2605001}, {0x00007329, 0xC2604F01}, {0x0000732A, 0xC2437601}, {0x0000732B, 0xC2472D01},
    {0x0000732E, 0xC2382501}, {0x0000732F, 0xC2604E01}, {0x00007334, 0xC2604D01}, {0x00007336, 0xC24D3102},
    {0x0000733E, 0xC2605101}, {0x0000733F, 0xC2316E01}, {0x00007344, 0xC2397601}, {0x00007345, 0xC23B6201},
    {0x0000734E, 0xC2605202}, {0x00007357, 0xC2605501}, {0x00007363, 0xC23D4301}, {0x00007368, 0xC2605701},
    {0x0000736A, 0xC2605601}, {0x00007370, 0xC2605801}, {0x00007372, 0xC2334D01}, {0x00007375, 0xC2605A01},
    {0x00007378, 0xC2605901}, {0x0000737A, 0xC2605C01}, {0x0000737B, 0xC2605B01}, {0x00007384, 0xC2383C01},
    {0x00007387, 0xC24E2801}, {0x00007389, 0xC2364C01}, {0x0000738B, 0xC2322601}, {0x00007396, 0xC2366A01},
    {0x0000739F, 0xC2756801}, {0x000073A8, 0xC2756901}, {0x000073A9, 0xC2346101}, {0x000073B2, 0xC24E6801},
    {0x000073B3, 0xC2605E01}, {0x000073BB, 0xC2606001}, {0x000073C0, 0xC2606101}, {0x000073C2, 0xC2325101},
    {0x000073C8, 0xC2605D01}, {0x000073C9, 0xC2756A01}, {0x000073CA, 0xC23B3901}, {0x000073CD, 0xC2444101},
    {0x000073CE, 0xC2605F01}, {0x000073D6, 0xC2756B01}, {0x000073DE, 0xC2606401}, {0x000073E0, 0xC23C6E01},
    {0x000073E5, 0xC2606201}, {0x000073EA, 0xC2373E01}, {0x000073ED, 0xC2484901}, {0x000073EE, 0xC2606301},
    {0x000073F1, 0xC2607E01}, {0x000073F8, 0xC2606901}, {0x000073FE, 0xC2383D01}, {0x00007403, 0xC2356501},
    {0x00007405, 0xC2606601}, {0x00007406, 0xC24D7D01}, {0x00007409, 0xC24E3001}, {0x0000741B, 0xC2756C01},
    {0x00007421, 0xC2756D01}, {0x00007422, 0xC2427601}, {0x00007425, 0xC2606801}, {0x00007426, 0xC2756F01},
    {0x0000742A, 0xC2757001}, {0x0000742C, 0xC2757101}, {0x00007432, 0xC2606A01}, {0x00007433, 0xC24E5601},
    {0x00007434, 0xC2365701}, {0x00007435, 0xC2487C01}, {0x00007436, 0xC2474A01}, {0x00007439, 0xC2757201},
    {0x0000743A, 0xC2606B01}, {0x0000743F, 0xC2606D01}, {0x00007441, 0xC2607001}, {0x0000744B, 0xC2757301},
    {0x00007455, 0xC2606C01}, {0x00007459, 0xC2606F01}, {0x0000745A, 0xC2386A01}, {0x0000745B, 0xC2314D01},
    {0x0000745C, 0xC2607101}, {0x0000745E, 0xC23F7001}, {0x0000745F, 0xC2606E01}, {0x00007460, 0xC24E5C01},
    {0x00007463, 0xC2607401}, {0x00007464, 0xC2742401}, {0x00007469, 0xC2607201}, {0x0000746A, 0xC2607501},
    {0x0000746F, 0xC2606701}, {0x00007470, 0xC2607301}, {0x00007473, 0xC23A3C01}, {0x00007476, 0xC2607601},
    {0x0000747E, 0xC2607701}, {0x00007483, 0xC24D7E01}, {0x0000748B, 0xC2607801}, {0x0000749E, 0xC2607901},
    {0x000074A2, 0xC2606501}, {0x000074A7, 0xC2607A01}, {0x000074B0, 0xC2344401}, {0x000074BD, 0xC23C2501},
    {0x000074CA, 0xC2607B01}, {0x000074CF, 0xC2607C01}, {0x000074D4, 0xC2607D01}, {0x000074DC, 0xC2313B01},
    {0x000074E0, 0xC2612101}, {0x000074E2, 0xC2493B01}, {0x000074E3, 0xC2612201}, {0x000074E6, 0xC2342401},
    {0x000074E7, 0xC2612301}, {0x000074E9, 0xC2612401}, {0x000074EE, 0xC2612501}, {0x000074F0, 0xC2612702},
    {0x000074F2, 0xC2612601}, {0x000074F6, 0xC2495301}, {0x000074F7, 0xC2612A01}, {0x000074F8, 0xC2612901},
    {0x00007503, 0xC2612C01}, {0x00007504, 0xC2612B01}, {0x00007505, 0xC2612D01}, {0x0000750C, 0xC2612E01},
    {0x0000750D, 0xC2613001}, {0x0000750E, 0xC2612F01}, {0x00007511, 0xC2397901}, {0x00007513, 0xC2613201},
    {0x00007515, 0xC2613101}, {0x00007518, 0xC2344501}, {0x0000751A, 0xC23F5301}, {0x0000751C, 0xC2453C01},
    {0x0000751E, 0xC2613301}, {0x0000751F, 0xC2403801}, {0x00007523, 0xC23B3A01}, {0x00007525, 0xC2317901},
    {0x00007526, 0xC2613401}, {0x00007528, 0xC24D5101}, {0x0000752B, 0xC24A6301}, {0x0000752C, 0xC2613501},
    {0x00007530, 0xC2454401}, {0x00007531, 0xC24D3301}, {0x00007532, 0xC2394301}, {0x00007533, 0xC23F3D01},
    {0x00007537, 0xC2434B01}, {0x00007538, 0xC2523401}, {0x0000753A, 0xC2442E01}, {0x0000753B, 0xC2326801},
    {0x0000753C, 0xC2613601}, {0x00007544, 0xC2613701}, {0x00007546, 0xC2613C01}, {0x00007549, 0xC2613A01},
    {0x0000754A, 0xC2613901}, {0x0000754B, 0xC25A4201}, {0x0000754C, 0xC2332601}, {0x0000754D, 0xC2613801},
    {0x0000754F, 0xC2305A01}, {0x00007551, 0xC2482A01}, {0x00007554, 0xC2484A01}, {0x00007559, 0xC24E3101},
    {0x0000755A, 0xC2613D01}, {0x0000755B, 0xC2613B01}, {0x0000755C, 0xC2435C01}, {0x0000755D, 0xC2402601},
    {0x00007560, 0xC2482B01}, {0x00007562, 0xC2492D01}, {0x00007564, 0xC2613F01}, {0x00007565, 0xC24E2C01},
    {0x00007566, 0xC2374D01}, {0x00007567, 0xC2614001}, {0x00007569, 0xC2613E01}, {0x0000756A, 0xC2485601},
    {0x0000756B, 0xC2614101}, {0x0000756D, 0xC2614201}, {0x00007570, 0xC2305B01}, {0x00007573, 0xC23E7601},
    {0x00007574, 0xC2614701}, {0x00007575, 0xC2757501}, {0x00007576, 0xC2614401}, {0x00007577, 0xC2466D01},
    {0x00007578, 0xC2614301}, {0x0000757F, 0xC2352601}, {0x00007581, 0xC2757601}, {0x00007582, 0xC2614A01},
    {0x00007586, 0xC2614502}, {0x00007589, 0xC2614901}, {0x0000758A, 0xC2614801}, {0x0000758B, 0xC2492501},
    {0x0000758E, 0xC2414201}, {0x0000758F, 0xC2414101}, {0x00007591, 0xC2353F01}, {0x00007594, 0xC2614B01},
    {0x0000759A, 0xC2614C01}, {0x0000759D, 0xC2614D01}, {0x000075A3, 0xC2614F01}, {0x000075A5, 0xC2614E01},
    {0x000075AB, 0xC2315601}, {0x000075B1, 0xC2615701}, {0x000075B2, 0xC2486801}, {0x000075B3, 0xC2615101},
    {0x000075B5, 0xC2615301}, {0x000075B8, 0xC2615501}, {0x000075B9, 0xC23F3E01}, {0x000075BC, 0xC2615601},
    {0x000075BD, 0xC2615401}, {0x000075BE, 0xC23C4001}, {0x000075C2, 0xC2615001}, {0x000075C3, 0xC2615201},
    {0x000075C5, 0xC2494201}, {0x000075C7, 0xC23E4901}, {0x000075CA, 0xC2615901}, {0x000075CD, 0xC2615801},
    {0x000075D2, 0xC2615A01}, {0x000075D4, 0xC23C2601}, {0x000075D5, 0xC23A2F01}, {0x000075D8, 0xC2457701},
    {0x000075D9, 0xC2615B01}, {0x000075DB, 0xC2444B01}, {0x000075DE, 0xC2615D01}, {0x000075E2, 0xC24E2101},
    {0x000075E3, 0xC2615C01}, {0x000075E9, 0xC2416901}, {0x000075F0, 0xC2616201}, {0x000075F2, 0xC2616402},
    {0x000075F4, 0xC2435401}, {0x000075FA, 0xC2616301}, {0x000075FC, 0xC2616001}, {0x000075FE, 0xC2615E02},
    {0x00007601, 0xC2616101}, {0x00007609, 0xC2616801}, {0x0000760B, 0xC2616601}, {0x0000760D, 0xC2616701},
    {0x0000761F, 0xC2616901}, {0x00007620, 0xC2616B03}, {0x00007624, 0xC2616E01}, {0x00007627, 0xC2616A01},
    {0x00007630, 0xC2617001}, {0x00007634, 0xC2616F01}, {0x0000763B, 0xC2617101}, {0x00007642, 0xC24E4501},
    {0x00007646, 0xC2617401}, {0x00007647, 0xC2617202}, {0x0000764C, 0xC2346201}, {0x00007652, 0xC24C7E01},
    {0x00007656, 0xC24A4A01}, {0x00007658, 0xC2617601}, {0x0000765C, 0xC2617501}, {0x00007661, 0xC2617702},
    {0x00007667, 0xC2617C01}, {0x00007668, 0xC2617903}, {0x0000766C, 0xC2617D01}, {0x00007670, 0xC2617E01},
    {0x00007672, 0xC2622101}, {0x00007676, 0xC2622201}, {0x00007678, 0xC2622301}, {0x0000767A, 0xC2482F01},
    {0x0000767B, 0xC2455001}, {0x0000767C, 0xC2622401}, {0x0000767D, 0xC2477201}, {0x0000767E, 0xC2493401},
    {0x00007680, 0xC2622501}, {0x00007683, 0xC2622601}, {0x00007684, 0xC2452A01}, {0x00007686, 0xC2332701},
    {0x00007687, 0xC2394401}, {0x00007688, 0xC2622701}, {0x0000768B, 0xC2622801}, {0x0000768E, 0xC2622901},
    {0x00007690, 0xC23B2901}, {0x00007693, 0xC2622B01}, {0x00007696, 0xC2622A01}, {0x00007699, 0xC2622C02},
    {0x000076AE, 0xC2486901}, {0x000076B0, 0xC2622E01}, {0x000076B4, 0xC2622F01}, {0x000076B7, 0xC2736901},
    {0x000076B8, 0xC2623003}, {0x000076BF, 0xC23B2E01}, {0x000076C2, 0xC2623301}, {0x000076C3, 0xC2475601},
    {0x000076C6, 0xC24B5F01}, {0x000076C8, 0xC2314E01}, {0x000076CA, 0xC2315701}, {0x000076CD, 0xC2623401},
    {0x000076D2, 0xC2623601}, {0x000076D6, 0xC2623501}, {0x000076D7, 0xC2457001}, {0x000076DB, 0xC2403901},
    {0x000076DC, 0xC25D3901}, {0x000076DE, 0xC2623701}, {0x000076DF, 0xC24C4101}, {0x000076E1, 0xC2623801},
    {0x000076E3, 0xC2344601}, {0x000076E4, 0xC2485701}, {0x000076E5, 0xC2623901}, {0x000076E7, 0xC2623A01},
    {0x000076EA, 0xC2623B01}, {0x000076EE, 0xC24C5C01}, {0x000076F2, 0xC24C5501}, {0x000076F4, 0xC2443E01},
    {0x000076F8, 0xC2416A01}, {0x000076FB, 0xC2623D01}, {0x000076FE, 0xC23D6201}, {0x00007701, 0xC23E4A01},
    {0x00007704, 0xC2624001}, {0x00007707, 0xC2623F01}, {0x00007708, 0xC2623E01}, {0x00007709, 0xC2487D01},
    {0x0000770B, 0xC2344701}, {0x0000770C, 0xC2382901}, {0x0000771B, 0xC2624601}, {0x0000771E, 0xC2624301},
    {0x0000771F, 0xC23F3F01}, {0x00007720, 0xC24C3201}, {0x00007724, 0xC2624201}, {0x00007725, 0xC2624402},
    {0x00007729, 0xC2624101}, {0x00007737, 0xC2624702}, {0x0000773A, 0xC2442F01}, {0x0000773C, 0xC2346301},
    {0x00007740, 0xC2436501}, {0x00007747, 0xC2624901}, {0x0000775A, 0xC2624A01}, {0x0000775B, 0xC2624D01},
    {0x00007761, 0xC23F6701}, {0x00007763, 0xC2464401}, {0x00007765, 0xC2624E01}, {0x00007766, 0xC24B5301},
    {0x00007768, 0xC2624B01}, {0x0000776B, 0xC2624C01}, {0x00007772, 0xC2757701}, {0x00007779, 0xC2625101},
    {0x0000777E, 0xC2625001}, {0x0000777F, 0xC2624F01}, {0x0000778B, 0xC2625301}, {0x0000778E, 0xC2625201},
    {0x00007791, 0xC2625401}, {0x0000779E, 0xC2625601}, {0x000077A0, 0xC2625501}, {0x000077A5, 0xC24A4D01},
    {0x000077AC, 0xC23D5601}, {0x000077AD, 0xC24E4601}, {0x000077B0, 0xC2625701}, {0x000077B3, 0xC2463701},
    {0x000077B6, 0xC2625801}, {0x000077B9, 0xC2625901}, {0x000077BB, 0xC2625D01}, {0x000077BC, 0xC2625B02},
    {0x000077BF, 0xC2625A01}, {0x000077C7, 0xC2625E01}, {0x000077CD, 0xC2625F01}, {0x000077D7, 0xC2626001},
    {0x000077DA, 0xC2626101}, {0x000077DB, 0xC24C3701}, {0x000077DC, 0xC2626201}, {0x000077E2, 0xC24C7001},
    {0x000077E3, 0xC2626301}, {0x000077E5, 0xC2434E01}, {0x000077E7, 0xC2476A01}, {0x000077E9, 0xC2366B01},
    {0x000077ED, 0xC2433B01}, {0x000077EE, 0xC2626401}, {0x000077EF, 0xC2363A01}, {0x000077F3, 0xC2405001},
    {0x000077FC, 0xC2626501}, {0x00007802, 0xC23A3D01}, {0x0000780C, 0xC2626601}, {0x00007812, 0xC2626701},
    {0x00007814, 0xC2382601}, {0x00007815, 0xC23A5501}, {0x00007820, 0xC2626901}, {0x00007825, 0xC2455601},
    {0x00007826, 0xC23A5601}, {0x00007827, 0xC2354E01}, {0x00007832, 0xC24B2401}, {0x00007834, 0xC2474B01},
    {0x0000783A, 0xC2455701}, {0x0000783F, 0xC2395C01}, {0x00007845, 0xC2626B01}, {0x0000785D, 0xC23E4B01},
    {0x0000786B, 0xC24E3201}, {0x0000786C, 0xC2394501}, {0x0000786F, 0xC2382701}, {0x00007872, 0xC2482301},
    {0x00007874, 0xC2626D01}, {0x0000787C, 0xC2626F01}, {0x00007881, 0xC2386B01}, {0x00007886, 0xC2626E01},
    {0x00007887, 0xC2447601}, {0x0000788C, 0xC2627101}, {0x0000788D, 0xC2333701}, {0x0000788E, 0xC2626C01},
    {0x00007891, 0xC2486A01}, {0x00007893, 0xC2313001}, {0x00007895, 0xC23A6C01}, {0x00007897, 0xC24F5201},
    {0x0000789A, 0xC2627001}, {0x000078A3, 0xC2627201}, {0x000078A7, 0xC24A4B01}, {0x000078A9, 0xC2405901},
    {0x000078AA, 0xC2627401}, {0x000078AF, 0xC2627501}, {0x000078B5, 0xC2627301}, {0x000078BA, 0xC2334E01},
    {0x000078BC, 0xC2627B01}, {0x000078BE, 0xC2627A01}, {0x000078C1, 0xC23C2701}, {0x000078C5, 0xC2627C01},
    {0x000078C6, 0xC2627701}, {0x000078C8, 0xC2757901}, {0x000078CA, 0xC2627D01}, {0x000078CB, 0xC2627801},
    {0x000078D0, 0xC2485801}, {0x000078D1, 0xC2627601}, {0x000078D4, 0xC2627901}, {0x000078DA, 0xC2632201},
    {0x000078E0, 0xC2757A01}, {0x000078E7, 0xC2632101}, {0x000078E8, 0xC24B6101}, {0x000078EC, 0xC2627E01},
    {0x000078EF, 0xC2306B01}, {0x000078F4, 0xC2632401}, {0x000078FD, 0xC2632301}, {0x00007901, 0xC23E4C01},
    {0x00007907, 0xC2632501}, {0x0000790E, 0xC2414301}, {0x00007911, 0xC2632701}, {0x00007912, 0xC2632601},
    {0x00007919, 0xC2632801}, {0x00007926, 0xC2626801}, {0x0000792A, 0xC2626A01}, {0x0000792B, 0xC2632A01},
    {0x0000792C, 0xC2632901}, {0x0000793A, 0xC23C2801}, {0x0000793C, 0xC24E6901}, {0x0000793E, 0xC23C5201},
    {0x00007940, 0xC2632B01}, {0x00007941, 0xC2373701}, {0x00007947, 0xC2354001}, {0x00007948, 0xC2352701},
    {0x00007949, 0xC23B6301}, {0x00007950, 0xC24D3401}, {0x00007953, 0xC2633101}, {0x00007955, 0xC2633001},
    {0x00007956, 0xC2414401}, {0x00007957, 0xC2632D01}, {0x0000795A, 0xC2632F01}, {0x0000795D, 0xC23D4B01},
    {0x0000795E, 0xC23F4001}, {0x0000795F, 0xC2632E01}, {0x00007960, 0xC2632C01}, {0x00007962, 0xC2472A01},
    {0x00007965, 0xC23E4D01}, {0x00007968, 0xC2493C01}, {0x0000796D, 0xC23A5701}, {0x00007977, 0xC2457801},
    {0x0000797A, 0xC2633201}, {0x0000797F, 0xC2633301}, {0x00007980, 0xC2634901}, {0x00007981, 0xC2365801},
    {0x00007984, 0xC24F3D01}, {0x00007985, 0xC2413501}, {0x0000798A, 0xC2633401}, {0x0000798D, 0xC2325201},
    {0x0000798E, 0xC2447701}, {0x0000798F, 0xC24A2101}, {0x0000799D, 0xC2633501}, {0x000079A6, 0xC2357A01},
    {0x000079A7, 0xC2633601}, {0x000079AA, 0xC2633801}, {0x000079AE, 0xC2633901}, {0x000079B0, 0xC2472901},
    {0x000079B3, 0xC2633A01}, {0x000079B9, 0xC2633B02}, {0x000079BD, 0xC2365901}, {0x000079BE, 0xC2325301},
    {0x000079BF, 0xC2464501}, {0x000079C0, 0xC23D2801}, {0x000079C1, 0xC23B6401}, {0x000079C9, 0xC2633D01},
    {0x000079CB, 0xC23D2901}, {0x000079D1, 0xC2324A01}, {0x000079D2, 0xC2494301}, {0x000079D5, 0xC2633E01},
    {0x000079D8, 0xC2486B01}, {0x000079DA, 0xC2762201}, {0x000079DF, 0xC2414501}, {0x000079E1, 0xC2634101},
    {0x000079E3, 0xC2634201}, {0x000079E4, 0xC2476901}, {0x000079E6, 0xC23F4101}, {0x000079E7, 0xC2633F01},
    {0x000079E9, 0xC2436101}, {0x000079EC, 0xC2634001}, {0x000079F0, 0xC23E4E01}, {0x000079FB, 0xC2305C01},
    {0x00007A00, 0xC2352901}, {0x00007A08, 0xC2634301}, {0x00007A0B, 0xC2447801}, {0x00007A0D, 0xC2634401},
    {0x00007A0E, 0xC2404701}, {0x00007A14, 0xC24C2D01}, {0x00007A17, 0xC2492301}, {0x00007A18, 0xC2634502},
    {0x00007A1A, 0xC2435501}, {0x00007A1C, 0xC24E4701}, {0x00007A1E, 0xC2762301}, {0x00007A1F, 0xC2634801},
    {0x00007A20, 0xC2634701}, {0x00007A2E, 0xC23C6F01}, {0x00007A31, 0xC2634A01}, {0x00007A32, 0xC2307001},
    {0x00007A37, 0xC2634D01}, {0x00007A3B, 0xC2634B01}, {0x00007A3C, 0xC2325401}, {0x00007A3D, 0xC2374E01},
    {0x00007A3E, 0xC2634C01}, {0x00007A3F, 0xC2394601}, {0x00007A40, 0xC2397201}, {0x00007A42, 0xC24A6601},
    {0x00007A43, 0xC2634E01}, {0x00007A46, 0xC24B5401}, {0x00007A49, 0xC2635001}, {0x00007A4D, 0xC2405101},
    {0x00007A4E, 0xC2314F01}, {0x00007A4F, 0xC2323A01}, {0x00007A50, 0xC2302C01}, {0x00007A57, 0xC2634F01},
    {0x00007A61, 0xC2635102}, {0x00007A63, 0xC23E7701}, {0x00007A69, 0xC2635301}, {0x00007A6B, 0xC2334F01},
    {0x00007A70, 0xC2635501}, {0x00007A74, 0xC2376A01}, {0x00007A76, 0xC2356601}, {0x00007A79, 0xC2635601},
    {0x00007A7A, 0xC2367501}, {0x00007A7D, 0xC2635701}, {0x00007A7F, 0xC2407C01}, {0x00007A81, 0xC2464D01},
    {0x00007A83, 0xC2406001}, {0x00007A84, 0xC23A7501}, {0x00007A88, 0xC2635801}, {0x00007A92, 0xC2436201},
    {0x00007A93, 0xC2416B01}, {0x00007A95, 0xC2635A01}, {0x00007A96, 0xC2635C01}, {0x00007A97, 0xC2635901},
    {0x00007A98, 0xC2635B01}, {0x00007A9F, 0xC2372201}, {0x00007AA9, 0xC2635D01}, {0x00007AAA, 0xC2372601},
    {0x00007AAE, 0xC2356701}, {0x00007AAF, 0xC24D5201}, {0x00007AB0, 0xC2635F01}, {0x00007AB6, 0xC2636001},
    {0x00007ABA, 0xC2312E01}, {0x00007ABF, 0xC2636301}, {0x00007AC3, 0xC2337601}, {0x00007AC4, 0xC2636201},
    {0x00007AC5, 0xC2636101}, {0x00007AC7, 0xC2636501}, {0x00007AC8, 0xC2635E01}, {0x00007ACA, 0xC2636601},
    {0x00007ACB, 0xC24E2901}, {0x00007ACD, 0xC2636701}, {0x00007ACF, 0xC2636801}, {0x00007AD2, 0xC2547401},
    {0x00007AD3, 0xC2636A01}, {0x00007AD5, 0xC2636901}, {0x00007AD9, 0xC2636B02}, {0x00007ADC, 0xC24E3501},
    {0x00007ADD, 0xC2636D01}, {0x00007ADF, 0xC2706F01}, {0x00007AE0, 0xC23E4F01}, {0x00007AE1, 0xC2636E02},
    {0x00007AE3, 0xC23D5701}, {0x00007AE5, 0xC2463801}, {0x00007AE6, 0xC2637001}, {0x00007AEA, 0xC2432801},
    {0x00007AED, 0xC2637101}, {0x00007AEF, 0xC2433C01}, {0x00007AF0, 0xC2637201}, {0x00007AF6, 0xC2362501},
    {0x00007AF8, 0xC2513F01}, {0x00007AF9, 0xC2435D01}, {0x00007AFA, 0xC23C3301}, {0x00007AFF, 0xC2344801},
    {0x00007B02, 0xC2637301}, {0x00007B04, 0xC2642201}, {0x00007B06, 0xC2637601}, {0x00007B08, 0xC2356801},
    {0x00007B0A, 0xC2637501}, {0x00007B0B, 0xC2642401}, {0x00007B0F, 0xC2637401}, {0x00007B11, 0xC23E5001},
    {0x00007B18, 0xC2637802}, {0x00007B1B, 0xC2452B01}, {0x00007B1E, 0xC2637A01}, {0x00007B20, 0xC2335E01},
    {0x00007B25, 0xC23F5A01}, {0x00007B26, 0xC2496401}, {0x00007B28, 0xC2637C01}, {0x00007B2C, 0xC2426801},
    {0x00007B33, 0xC2637701}, {0x00007B35, 0xC2637B01}, {0x00007B36, 0xC2637D01}, {0x00007B39, 0xC23A7B01},
    {0x00007B45, 0xC2642601}, {0x00007B46, 0xC2492E01}, {0x00007B48, 0xC2482601}, {0x00007B49, 0xC2457901},
    {0x00007B4B, 0xC2365A01}, {0x00007B4C, 0xC2642501}, {0x00007B4D, 0xC2642301}, {0x00007B4F, 0xC2483501},
    {0x00007B50, 0xC2637E01}, {0x00007B51, 0xC2435E01}, {0x00007B52, 0xC2457B01}, {0x00007B54, 0xC2457A01},
    {0x00007B56, 0xC23A7601}, {0x00007B5D, 0xC2643801}, {0x00007B65, 0xC2642801}, {0x00007B67, 0xC2642A01},
    {0x00007B6C, 0xC2642D01}, {0x00007B6E, 0xC2642E01}, {0x00007B70, 0xC2642B02}, {0x00007B74, 0xC2642901},
    {0x00007B75, 0xC2642701}, {0x00007B7A, 0xC2642101}, {0x00007B7F, 0xC2762401}, {0x00007B86, 0xC24A4F01},
    {0x00007B87, 0xC2325501}, {0x00007B8B, 0xC2643501}, {0x00007B8D, 0xC2643201}, {0x00007B8F, 0xC2643701},
    {0x00007B92, 0xC2643601}, {0x00007B94, 0xC2477301}, {0x00007B95, 0xC24C2701}, {0x00007B97, 0xC23B3B01},
    {0x00007B98, 0xC2643001}, {0x00007B99, 0xC2643901}, {0x00007B9A, 0xC2643401}, {0x00007B9C, 0xC2643301},
    {0x00007B9D, 0xC2642F01}, {0x00007B9F, 0xC2643101}, {0x00007BA1, 0xC2344901}, {0x00007BAA, 0xC2433D01},
    {0x00007BAD, 0xC2407D01}, {0x00007BB1, 0xC2482201}, {0x00007BB4, 0xC2643E01}, {0x00007BB8, 0xC2482401},
    {0x00007BC0, 0xC2406101}, {0x00007BC1, 0xC2643B01}, {0x00007BC4, 0xC2484F01}, {0x00007BC6, 0xC2643F01},
    {0x00007BC7, 0xC24A5301}, {0x00007BC9, 0xC2435B01}, {0x00007BCB, 0xC2643A01}, {0x00007BCC, 0xC2643C01},
    {0x00007BCF, 0xC2643D01}, {0x00007BDD, 0xC2644001}, {0x00007BE0, 0xC23C4401}, {0x00007BE4, 0xC2464601},
    {0x00007BE5, 0xC2644501}, {0x00007BE6, 0xC2644401}, {0x00007BE9, 0xC2644101}, {0x00007BED, 0xC24F3601},
    {0x00007BF3, 0xC2644A01}, {0x00007BF6, 0xC2644E01}, {0x00007BF7, 0xC2644B01}, {0x00007C00, 0xC2644701},
    {0x00007C07, 0xC2644801}, {0x00007C0D, 0xC2644D01}, {0x00007C11, 0xC2644201}, {0x00007C12, 0xC2525501},
    {0x00007C13, 0xC2644901}, {0x00007C14, 0xC2644301}, {0x00007C17, 0xC2644C01}, {0x00007C1F, 0xC2645201},
    {0x00007C21, 0xC2344A01}, {0x00007C23, 0xC2644F01}, {0x00007C27, 0xC2645001}, {0x00007C2A, 0xC2645101},
    {0x00007C2B, 0xC2645401}, {0x00007C31, 0xC2762501}, {0x00007C37, 0xC2645301}, {0x00007C38, 0xC2487601},
    {0x00007C3D, 0xC2645501}, {0x00007C3E, 0xC24E7C01}, {0x00007C3F, 0xC24A6D01}, {0x00007C40, 0xC2645A01},
    {0x00007C43, 0xC2645701}, {0x00007C4C, 0xC2645601}, {0x00007C4D, 0xC2405201}, {0x00007C4F, 0xC2645901},
    {0x00007C50, 0xC2645B01}, {0x00007C54, 0xC2645801}, {0x00007C56, 0xC2645F01}, {0x00007C58, 0xC2645C01},
    {0x00007C5F, 0xC2645D01}, {0x00007C60, 0xC2644601}, {0x00007C64, 0xC2645E01}, {0x00007C65, 0xC2646001},
    {0x00007C6C, 0xC2646101}, {0x00007C73, 0xC24A4601}, {0x00007C75, 0xC2646201}, {0x00007C7E, 0xC24C6201},
    {0x00007C81, 0xC2364E01}, {0x00007C82, 0xC2372901}, {0x00007C83, 0xC2646301}, {0x00007C89, 0xC24A3401},
    {0x00007C8B, 0xC23F6801}, {0x00007C8D, 0xC24C3001}, {0x00007C90, 0xC2646401}, {0x00007C92, 0xC24E3301},
    {0x00007C95, 0xC2477401}, {0x00007C97, 0xC2414601}, {0x00007C98, 0xC2473401}, {0x00007C9B, 0xC23D4D01},
    {0x00007C9F, 0xC2304001}, {0x00007CA1, 0xC2646901}, {0x00007CA2, 0xC2646701}, {0x00007CA4, 0xC2646501},
    {0x00007CA5, 0xC2342101}, {0x00007CA7, 0xC23E5101}, {0x00007CA8, 0xC2646A01}, {0x00007CAB, 0xC2646801},
    {0x00007CAD, 0xC2646601}, {0x00007CAE, 0xC2646E01}, {0x00007CB1, 0xC2646D01}, {0x00007CB2, 0xC2646C01},
    {0x00007CB3, 0xC2646B01}, {0x00007CB9, 0xC2646F01}, {0x00007CBD, 0xC2647001}, {0x00007CBE, 0xC2403A01},
    {0x00007CC0, 0xC2647101}, {0x00007CC2, 0xC2647301}, {0x00007CC5, 0xC2647201}, {0x00007CCA, 0xC2385201},
    {0x00007CCE, 0xC2413801}, {0x00007CD2, 0xC2647501}, {0x00007CD6, 0xC2457C01}, {0x00007CD8, 0xC2647401},
    {0x00007CDC, 0xC2647601}, {0x00007CDE, 0xC24A3501}, {0x00007CDF, 0xC2416C01}, {0x00007CE0, 0xC2394701},
    {0x00007CE2, 0xC2647701}, {0x00007CE7, 0xC24E4801}, {0x00007CEF, 0xC2647901}, {0x00007CF2, 0xC2647A01},
    {0x00007CF4, 0xC2647B01}, {0x00007CF6, 0xC2647C01}, {0x00007CF8, 0xC23B6501}, {0x00007CFA, 0xC2647D01},
    {0x00007CFB, 0xC2374F01}, {0x00007CFE, 0xC2356A01}, {0x00007D00, 0xC2352A01}, {0x00007D02, 0xC2652101},
    {0x00007D04, 0xC24C7301}, {0x00007D05, 0xC2394801}, {0x00007D06, 0xC2647E01}, {0x00007D0A, 0xC2652401},
    {0x00007D0B, 0xC24C6601}, {0x00007D0D, 0xC2473C01}, {0x00007D10, 0xC2493301}, {0x00007D14, 0xC23D6301},
    {0x00007D15, 0xC2652301}, {0x00007D17, 0xC23C5301}, {0x00007D18, 0xC2394901}, {0x00007D19, 0xC23B6601},
    {0x00007D1A, 0xC2356901}, {0x00007D1B, 0xC24A3601}, {0x00007D1C, 0xC2652201}, {0x00007D20, 0xC2414701},
    {0x00007D21, 0xC24B4201}, {0x00007D22, 0xC23A7701}, {0x00007D2B, 0xC23B6701}, {0x00007D2C, 0xC2445D01},
    {0x00007D2E, 0xC2652701}, {0x00007D2F, 0xC24E5F01}, {0x00007D30, 0xC23A5901}, {0x00007D32, 0xC2652801},
    {0x00007D33, 0xC23F4201}, {0x00007D35, 0xC2652A01}, {0x00007D39, 0xC23E5201}, {0x00007D3A, 0xC23A3001},
    {0x00007D3F, 0xC2652901}, {0x00007D42, 0xC23D2A01}, {0x00007D43, 0xC2383E01}, {0x00007D44, 0xC2414801},
    {0x00007D45, 0xC2652501}, {0x00007D46, 0xC2652B01}, {0x00007D4B, 0xC2652601}, {0x00007D4C, 0xC2375001},
    {0x00007D4E, 0xC2652E01}, {0x00007D4F, 0xC2653201}, {0x00007D50, 0xC2376B01}, {0x00007D56, 0xC2652D01},
    {0x00007D5B, 0xC2653601}, {0x00007D5E, 0xC2394A01}, {0x00007D61, 0xC24D6D01}, {0x00007D62, 0xC2303C01},
    {0x00007D63, 0xC2653301}, {0x00007D66, 0xC2356B01}, {0x00007D68, 0xC2653001}, {0x00007D6E, 0xC2653101},
    {0x00007D71, 0xC2457D01}, {0x00007D72, 0xC2652F01}, {0x00007D73, 0xC2652C01}, {0x00007D75, 0xC2332801},
    {0x00007D76, 0xC2406401}, {0x00007D79, 0xC2382801}, {0x00007D7D, 0xC2653801}, {0x00007D89, 0xC2653501},
    {0x00007D8B, 0xC2762701}, {0x00007D8F, 0xC2653701}, {0x00007D93, 0xC2653401}, {0x00007D99, 0xC2375101},
    {0x00007D9A, 0xC2423301}, {0x00007D9B, 0xC2653901}, {0x00007D9C, 0xC2416E01}, {0x00007D9F, 0xC2654601},
    {0x00007DA2, 0xC2654201}, {0x00007DA3, 0xC2653C01}, {0x00007DAB, 0xC2654001}, {0x00007DAC, 0xC23C7A01},
    {0x00007DAD, 0xC2305D01}, {0x00007DAE, 0xC2653B01}, {0x00007DAF, 0xC2654301}, {0x00007DB0, 0xC2654701},
    {0x00007DB1, 0xC2394B01}, {0x00007DB2, 0xC24C5601}, {0x00007DB4, 0xC2445601}, {0x00007DB5, 0xC2653D01},
    {0x00007DB8, 0xC2654501}, {0x00007DBA, 0xC2653A01}, {0x00007DBB, 0xC2433E01}, {0x00007DBD, 0xC2653F01},
    {0x00007DBE, 0xC2303D01}, {0x00007DBF, 0xC24C4A01}, {0x00007DC7, 0xC2653E01}, {0x00007DCA, 0xC2365B01},
    {0x00007DCB, 0xC2486C01}, {0x00007DCF, 0xC2416D01}, {0x00007DD1, 0xC24E5001}, {0x00007DD2, 0xC23D6F01},
    {0x00007DD5, 0xC2656E01}, {0x00007DD8, 0xC2654801}, {0x00007DDA, 0xC2407E01}, {0x00007DDC, 0xC2654401},
    {0x00007DDD, 0xC2654901}, {0x00007DDE, 0xC2654B01}, {0x00007DE0, 0xC2447901}, {0x00007DE1, 0xC2654E01},
    {0x00007DE4, 0xC2654A01}, {0x00007DE8, 0xC24A5401}, {0x00007DE9, 0xC2344B01}, {0x00007DEC, 0xC24C4B01},
    {0x00007DEF, 0xC2305E01}, {0x00007DF2, 0xC2654D01}, {0x00007DF4, 0xC24E7D01}, {0x00007DFB, 0xC2654C01},
    {0x00007E01, 0xC2316F01}, {0x00007E04, 0xC2466C01}, {0x00007E05, 0xC2654F01}, {0x00007E09, 0xC2655601},
    {0x00007E0A, 0xC2655001}, {0x00007E0B, 0xC2655701}, {0x00007E12, 0xC2655301}, {0x00007E1B, 0xC2477B01},
    {0x00007E1E, 0xC23C4A01}, {0x00007E1F, 0xC2655501}, {0x00007E21, 0xC2655201}, {0x00007E22, 0xC2655801},
    {0x00007E23, 0xC2655101}, {0x00007E26, 0xC23D4401}, {0x00007E2B, 0xC24B2501}, {0x00007E2E, 0xC23D4C01},
    {0x00007E31, 0xC2655401}, {0x00007E32, 0xC2656001}, {0x00007E35, 0xC2655C01}, {0x00007E37, 0xC2655F01},
    {0x00007E39, 0xC2655D01}, {0x00007E3A, 0xC2656101}, {0x00007E3B, 0xC2655B01}, {0x00007E3D, 0xC2654101},
    {0x00007E3E, 0xC2405301}, {0x00007E41, 0xC2484B01}, {0x00007E43, 0xC2655E01}, {0x00007E46, 0xC2655901},
    {0x00007E4A, 0xC2412101}, {0x00007E4B, 0xC2375201}, {0x00007E4D, 0xC23D2B01}, {0x00007E54, 0xC23F2501},
    {0x00007E55, 0xC2413601}, {0x00007E56, 0xC2656401}, {0x00007E59, 0xC2656602}, {0x00007E5D, 0xC2656301},
    {0x00007E5E, 0xC2656501}, {0x00007E66, 0xC2655A01}, {0x00007E67, 0xC2656201}, {0x00007E69, 0xC2656A01},
    {0x00007E6A, 0xC2656901}, {0x00007E6D, 0xC24B7A01}, {0x00007E70, 0xC2372B01}, {0x00007E79, 0xC2656801},
    {0x00007E7B, 0xC2656C01}, {0x00007E7C, 0xC2656B01}, {0x00007E7D, 0xC2656F01}, {0x00007E7F, 0xC2657101},
    {0x00007E82, 0xC23B3C01}, {0x00007E83, 0xC2656D01}, {0x00007E88, 0xC2657202}, {0x00007E8C, 0xC2657401},
    {0x00007E8E, 0xC2657A01}, {0x00007E8F, 0xC2453B01}, {0x00007E90, 0xC2657601}, {0x00007E92, 0xC2657501},
    {0x00007E93, 0xC2657702}, {0x00007E96, 0xC2657901}, {0x00007E9B, 0xC2657B02}, {0x00007F36, 0xC2344C01},
    {0x00007F38, 0xC2657D01}, {0x00007F3A, 0xC2657E01}, {0x00007F45, 0xC2662101}, {0x00007F4C, 0xC2662203},
    {0x00007F50, 0xC2662502}, {0x00007F54, 0xC2662801}, {0x00007F55, 0xC2662701}, {0x00007F58, 0xC2662901},
    {0x00007F5F, 0xC2662A02}, {0x00007F67, 0xC2662E01}, {0x00007F68, 0xC2662C02}, {0x00007F6A, 0xC23A6101},
    {0x00007F6B, 0xC2375301}, {0x00007F6E, 0xC2435601}, {0x00007F70, 0xC2483301}, {0x00007F72, 0xC23D7001},
    {0x00007F75, 0xC2474D01}, {0x00007F77, 0xC2486D01}, {0x00007F78, 0xC2662F01}, {0x00007F79, 0xC2586D01},
    {0x00007F82, 0xC2663001}, {0x00007F83, 0xC2663201}, {0x00007F85, 0xC24D6501}, {0x00007F86, 0xC2663101},
    {0x00007F87, 0xC2663401}, {0x00007F88, 0xC2663301}, {0x00007F8A, 0xC24D5301}, {0x00007F8C, 0xC2663501},
    {0x00007F8E, 0xC2487E01}, {0x00007F94, 0xC2663601}, {0x00007F9A, 0xC2663901}, {0x00007F9D, 0xC2663801},
    {0x00007F9E, 0xC2663701}, {0x00007FA1, 0xC2762801}, {0x00007FA3, 0xC2663A01}, {0x00007FA4, 0xC2373201},
    {0x00007FA8, 0xC2412201}, {0x00007FA9, 0xC2354101}, {0x00007FAE, 0xC2663E01}, {0x00007FAF, 0xC2663B01},
    {0x00007FB2, 0xC2663C01}, {0x00007FB6, 0xC2663F01}, {0x00007FB8, 0xC2664001}, {0x00007FB9, 0xC2663D01},
    {0x00007FBD, 0xC2312901}, {0x00007FC1, 0xC2322701}, {0x00007FC5, 0xC2664202}, {0x00007FCA, 0xC2664401},
    {0x00007FCC, 0xC24D6201}, {0x00007FD2, 0xC23D2C01}, {0x00007FD4, 0xC2664601}, {0x00007FD5, 0xC2664501},
    {0x00007FE0, 0xC23F6901}, {0x00007FE1, 0xC2664701}, {0x00007FE6, 0xC2664801}, {0x00007FE9, 0xC2664901},
    {0x00007FEB, 0xC2346501}, {0x00007FF0, 0xC2344D01}, {0x00007FF3, 0xC2664A01}, {0x00007FF9, 0xC2664B01},
    {0x00007FFB, 0xC24B5D01}, {0x00007FFC, 0xC24D6301}, {0x00008000, 0xC24D5401}, {0x00008001, 0xC24F3701},
    {0x00008003, 0xC2394D01}, {0x00008004, 0xC2664E01}, {0x00008005, 0xC23C5401}, {0x00008006, 0xC2664D01},
    {0x0000800B, 0xC2664F01}, {0x0000800C, 0xC23C2901}, {0x00008010, 0xC2425101}, {0x00008012, 0xC2665001},
    {0x00008015, 0xC2394C01}, {0x00008017, 0xC24C5701}, {0x00008018, 0xC2665102}, {0x0000801C, 0xC2665301},
    {0x00008021, 0xC2665401}, {0x00008028, 0xC2665501}, {0x00008033, 0xC23C2A01}, {0x00008036, 0xC24C6D01},
    {0x0000803B, 0xC2665701}, {0x0000803D, 0xC2433F01}, {0x0000803F, 0xC2665601}, {0x00008046, 0xC2665901},
    {0x0000804A, 0xC2665801}, {0x00008052, 0xC2665A01}, {0x00008056, 0xC2403B01}, {0x00008058, 0xC2665B01},
    {0x0000805A, 0xC2665C01}, {0x0000805E, 0xC24A3901}, {0x0000805F, 0xC2665D01}, {0x00008061, 0xC2416F01},
    {0x00008062, 0xC2665E01}, {0x00008068, 0xC2665F01}, {0x0000806F, 0xC24E7E01}, {0x00008070, 0xC2666201},
    {0x00008072, 0xC2666101}, {0x00008073, 0xC2666001}, {0x00008074, 0xC2443001}, {0x00008076, 0xC2666301},
    {0x00008077, 0xC23F2601}, {0x00008079, 0xC2666401}, {0x0000807D, 0xC2666501}, {0x0000807E, 0xC24F3801},
    {0x0000807F, 0xC2666601}, {0x00008084, 0xC2666701}, {0x00008085, 0xC2666901}, {0x00008086, 0xC2666801},
    {0x00008087, 0xC2482501}, {0x00008089, 0xC2467901}, {0x0000808B, 0xC24F3E01}, {0x0000808C, 0xC2482901},
    {0x00008093, 0xC2666B01}, {0x00008096, 0xC23E5301}, {0x00008098, 0xC2492A01}, {0x0000809A, 0xC2666C01},
    {0x0000809B, 0xC2666A01}, {0x0000809D, 0xC2344E01}, {0x000080A1, 0xC2385401}, {0x000080A2, 0xC23B6801},
    {0x000080A5, 0xC2486E01}, {0x000080A9, 0xC2382A01}, {0x000080AA, 0xC24B4301}, {0x000080AC, 0xC2666F01},
    {0x000080AD, 0xC2666D01}, {0x000080AF, 0xC2394E01}, {0x000080B1, 0xC2394F01}, {0x000080B2, 0xC2306901},
    {0x000080B4, 0xC23A6801}, {0x000080BA, 0xC2475901}, {0x000080C3, 0xC2305F01}, {0x000080C4, 0xC2667401},
    {0x000080C6, 0xC2434001}, {0x000080CC, 0xC2475801}, {0x000080CE, 0xC2425B01}, {0x000080D6, 0xC2667601},
    {0x000080D9, 0xC2667201}, {0x000080DA, 0xC2667501}, {0x000080DB, 0xC2667001}, {0x000080DD, 0xC2667301},
    {0x000080DE, 0xC24B2601}, {0x000080E1, 0xC2385501}, {0x000080E4, 0xC2307D01}, {0x000080E5, 0xC2667101},
    {0x000080EF, 0xC2667801}, {0x000080F1, 0xC2667901}, {0x000080F4, 0xC2463901}, {0x000080F8, 0xC2363B01},
    {0x000080FC, 0xC2672601}, {0x000080FD, 0xC2473D01}, {0x00008102, 0xC23B6901}, {0x00008105, 0xC2363C01},
    {0x00008106, 0xC2404801}, {0x00008107, 0xC24F4601}, {0x00008108, 0xC24C2E01}, {0x00008109, 0xC2667701},
    {0x0000810A, 0xC2405401}, {0x00008118, 0xC2762901}, {0x0000811A, 0xC2355301}, {0x0000811B, 0xC2667A01},
    {0x00008123, 0xC2667C01}, {0x00008129, 0xC2667B01}, {0x0000812F, 0xC2667D01}, {0x00008131, 0xC2432601},
    {0x00008133, 0xC2473E01}, {0x00008139, 0xC2443101}, {0x0000813A, 0xC2762A01}, {0x0000813E, 0xC2672301},
    {0x00008146, 0xC2672201}, {0x0000814B, 0xC2667E01}, {0x0000814E, 0xC23F5501}, {0x00008150, 0xC2496501},
    {0x00008151, 0xC2672501}, {0x00008153, 0xC2672401}, {0x00008154, 0xC2395001}, {0x00008155, 0xC24F5301},
    {0x0000815F, 0xC2673501}, {0x00008165, 0xC2672902}, {0x0000816B, 0xC23C7001}, {0x0000816E, 0xC2672801},
    {0x00008170, 0xC2397801}, {0x00008171, 0xC2672701}, {0x00008174, 0xC2672B01}, {0x00008178, 0xC2443201},
    {0x00008179, 0xC24A2201}, {0x0000817A, 0xC2412301}, {0x0000817F, 0xC2425C01}, {0x00008180, 0xC2672F01},
    {0x00008182, 0xC2673001}, {0x00008183, 0xC2672C01}, {0x00008188, 0xC2672D01}, {0x0000818A, 0xC2672E01},
    {0x0000818F, 0xC2395101}, {0x00008193, 0xC2673601}, {0x00008195, 0xC2673201}, {0x0000819A, 0xC2496601},
    {0x0000819C, 0xC24B6C01}, {0x0000819D, 0xC2492801}, {0x000081A0, 0xC2673101}, {0x000081A3, 0xC2673401},
    {0x000081A4, 0xC2673301}, {0x000081A8, 0xC24B4401}, {0x000081A9, 0xC2673701}, {0x000081B0, 0xC2673801},
    {0x000081B3, 0xC2413701}, {0x000081B5, 0xC2673901}, {0x000081B8, 0xC2673B01}, {0x000081BA, 0xC2673F01},
    {0x000081BD, 0xC2673C01}, {0x000081BE, 0xC2673A01}, {0x000081BF, 0xC2473F01}, {0x000081C0, 0xC2673D01},
    {0x000081C2, 0xC2673E01}, {0x000081C6, 0xC2323201}, {0x000081C8, 0xC2674501}, {0x000081C9, 0xC2674001},
    {0x000081CD, 0xC2674101}, {0x000081D1, 0xC2674201}, {0x000081D3, 0xC2422101}, {0x000081D8, 0xC2674401},
    {0x000081D9, 0xC2674301}, {0x000081DA, 0xC2674601}, {0x000081DF, 0xC2674702}, {0x000081E3, 0xC23F4301},
    {0x000081E5, 0xC2326901}, {0x000081E7, 0xC2674901}, {0x000081E8, 0xC24E5701}, {0x000081EA, 0xC23C2B01},
    {0x000081ED, 0xC23D2D01}, {0x000081F3, 0xC23B6A01}, {0x000081F4, 0xC2435701}, {0x000081FA, 0xC2674A02},
    {0x000081FC, 0xC2313101}, {0x000081FE, 0xC2674C01}, {0x00008201, 0xC2674D02}, {0x00008205, 0xC2674F01},
    {0x00008207, 0xC2675001}, {0x00008208, 0xC2363D01}, {0x00008209, 0xC25A2A01}, {0x0000820A, 0xC2675101},
    {0x0000820C, 0xC2406501}, {0x0000820D, 0xC2675201}, {0x0000820E, 0xC23C4B01}, {0x00008210, 0xC2675301},
    {0x00008212, 0xC2503001}, {0x00008216, 0xC2675401}, {0x00008217, 0xC24A5E01}, {0x00008218, 0xC2345C01},
    {0x0000821B, 0xC2412401}, {0x0000821C, 0xC23D5801}, {0x0000821E, 0xC2497101}, {0x0000821F, 0xC23D2E01},
    {0x00008229, 0xC2675501}, {0x0000822A, 0xC2395201}, {0x0000822B, 0xC2675601}, {0x0000822C, 0xC2484C01},
    {0x0000822E, 0xC2676401}, {0x00008233, 0xC2675801}, {0x00008235, 0xC2424901}, {0x00008236, 0xC2477501},
    {0x00008237, 0xC2383F01}, {0x00008238, 0xC2675701}, {0x00008239, 0xC2412501}, {0x00008240, 0xC2675901},
    {0x00008247, 0xC2447A01}, {0x00008258, 0xC2675B01}, {0x00008259, 0xC2675A01}, {0x0000825A, 0xC2675D01},
    {0x0000825D, 0xC2675C01}, {0x0000825F, 0xC2675E01}, {0x00008262, 0xC2676001}, {0x00008264, 0xC2675F01},
    {0x00008266, 0xC2344F01}, {0x00008268, 0xC2676101}, {0x0000826A, 0xC2676202}, {0x0000826E, 0xC23A3101},
    {0x0000826F, 0xC24E4901}, {0x00008271, 0xC2676501}, {0x00008272, 0xC23F2701}, {0x00008276, 0xC2317001},
    {0x00008277, 0xC2676602}, {0x0000827E, 0xC2676801}, {0x0000828B, 0xC2307201}, {0x0000828D, 0xC2676901},
    {0x00008292, 0xC2676A01}, {0x00008299, 0xC2496701}, {0x0000829D, 0xC23C4701}, {0x0000829F, 0xC2676C01},
    {0x000082A5, 0xC2332901}, {0x000082A6, 0xC2303201}, {0x000082AB, 0xC2676B01}, {0x000082AC, 0xC2676E01},
    {0x000082AD, 0xC2474E01}, {0x000082AE, 0xC2762C01}, {0x000082AF, 0xC23F4401}, {0x000082B1, 0xC2325601},
    {0x000082B3, 0xC24B2701}, {0x000082B8, 0xC2375D01}, {0x000082B9, 0xC2365C01}, {0x000082BB, 0xC2676D01},
    {0x000082BD, 0xC2326A01}, {0x000082C5, 0xC2342301}, {0x000082D1, 0xC2317101}, {0x000082D2, 0xC2677201},
    {0x000082D3, 0xC24E6A01}, {0x000082D4, 0xC2425D01}, {0x000082D7, 0xC2494401}, {0x000082D9, 0xC2677E01},
    {0x000082DB, 0xC2325701}, {0x000082DC, 0xC2677C01}, {0x000082DE, 0xC2677A01}, {0x000082DF, 0xC2677101},
    {0x000082E1, 0xC2676F01}, {0x000082E3, 0xC2677001}, {0x000082E5, 0xC23C6301}, {0x000082E6, 0xC2366C01},
    {0x000082E7, 0xC2437701}, {0x000082EB, 0xC2465101}, {0x000082F1, 0xC2315101}, {0x000082F3, 0xC2677401},
    {0x000082F4, 0xC2677301}, {0x000082F9, 0xC2677901}, {0x000082FA, 0xC2677501}, {0x000082FB, 0xC2677801},
    {0x00008302, 0xC24C5001}, {0x00008303, 0xC2677701}, {0x00008304, 0xC2325801}, {0x00008305, 0xC2337D01},
    {0x00008306, 0xC2677B01}, {0x00008309, 0xC2677D01}, {0x0000830E, 0xC2375401}, {0x00008316, 0xC2682301},
    {0x00008317, 0xC2682C02}, {0x0000831C, 0xC2302B01}, {0x00008323, 0xC2683401}, {0x00008328, 0xC2307101},
    {0x0000832B, 0xC2682B01}, {0x0000832F, 0xC2682A01}, {0x00008331, 0xC2682501}, {0x00008332, 0xC2682401},
    {0x00008334, 0xC2682201}, {0x00008335, 0xC2682101}, {0x00008336, 0xC2436301}, {0x00008338, 0xC2427B01},
    {0x00008339, 0xC2682701}, {0x00008340, 0xC2682601}, {0x00008345, 0xC2682901}, {0x00008349, 0xC2417001},
    {0x0000834A, 0xC2375501}, {0x0000834F, 0xC2314101}, {0x00008350, 0xC2682801}, {0x00008352, 0xC2395301},
    {0x00008358, 0xC2417101}, {0x00008373, 0xC2683A01}, {0x00008375, 0xC2683B01}, {0x00008377, 0xC2325901},
    {0x0000837B, 0xC2322E01}, {0x0000837C, 0xC2683801}, {0x00008385, 0xC2682E01}, {0x00008387, 0xC2683601},
    {0x00008389, 0xC2683D01}, {0x0000838A, 0xC2683701}, {0x0000838E, 0xC2683501}, {0x00008393, 0xC2677601},
    {0x00008396, 0xC2683301}, {0x0000839A, 0xC2682F01}, {0x0000839E, 0xC2345001}, {0x0000839F, 0xC2683101},
    {0x000083A0, 0xC2683C01}, {0x000083A2, 0xC2683201}, {0x000083A8, 0xC2683E01}, {0x000083AA, 0xC2683001},
    {0x000083AB, 0xC2477C01}, {0x000083B1, 0xC24D6901}, {0x000083B5, 0xC2683901}, {0x000083BD, 0xC2684F01},
    {0x000083C1, 0xC2684701}, {0x000083C5, 0xC23F7B01}, {0x000083CA, 0xC2354601}, {0x000083CC, 0xC2365D01},
    {0x000083CE, 0xC2684201}, {0x000083D3, 0xC2325B01}, {0x000083D6, 0xC23E5401}, {0x000083D8, 0xC2684501},
    {0x000083DC, 0xC23A5A01}, {0x000083DF, 0xC2455101}, {0x000083E0, 0xC2684A01}, {0x000083E9, 0xC24A6E01},
    {0x000083EB, 0xC2684101}, {0x000083EF, 0xC2325A01}, {0x000083F0, 0xC2385601}, {0x000083F1, 0xC2492901},
    {0x000083F2, 0xC2684B01}, {0x000083F4, 0xC2683F01}, {0x000083F7, 0xC2684801}, {0x000083FB, 0xC2685201},
    {0x000083FD, 0xC2684301}, {0x00008403, 0xC2684401}, {0x00008404, 0xC2463A01}, {0x00008407, 0xC2684901},
    {0x0000840B, 0xC2684601}, {0x0000840C, 0xC24B2801}, {0x0000840D, 0xC2684C01}, {0x0000840E, 0xC2306001},
    {0x00008413, 0xC2684001}, {0x00008420, 0xC2684E01}, {0x00008422, 0xC2684D01}, {0x00008429, 0xC2476B01},
    {0x0000842A, 0xC2685401}, {0x0000842C, 0xC2685F01}, {0x00008431, 0xC2337E01}, {0x00008435, 0xC2686201},
    {0x00008438, 0xC2685001}, {0x0000843C, 0xC2685501}, {0x0000843D, 0xC24D6E01}, {0x00008446, 0xC2685E01},
    {0x00008449, 0xC24D5501}, {0x0000844E, 0xC24E2A01}, {0x00008457, 0xC2437801}, {0x0000845B, 0xC2336B01},
    {0x00008461, 0xC2497201}, {0x00008462, 0xC2686401}, {0x00008463, 0xC2462101}, {0x00008466, 0xC2303101},
    {0x00008469, 0xC2685D01}, {0x0000846B, 0xC2685901}, {0x0000846C, 0xC2417201}, {0x0000846D, 0xC2685301},
    {0x0000846E, 0xC2685B01}, {0x0000846F, 0xC2686001}, {0x00008471, 0xC2472C01}, {0x00008475, 0xC2302A01},
    {0x00008477, 0xC2685801}, {0x00008479, 0xC2686101}, {0x0000847A, 0xC2497801}, {0x00008482, 0xC2685C01},
    {0x00008484, 0xC2685701}, {0x0000848B, 0xC23E5501}, {0x00008490, 0xC23D2F01}, {0x00008494, 0xC23C2C01},
    {0x00008499, 0xC24C5801}, {0x0000849C, 0xC2494701}, {0x0000849F, 0xC2686701}, {0x000084A1, 0xC2687001},
    {0x000084AD, 0xC2685A01}, {0x000084B2, 0xC2337701}, {0x000084B8, 0xC23E7801}, {0x000084B9, 0xC2686501},
    {0x000084BB, 0xC2686A01}, {0x000084BC, 0xC2417301}, {0x000084BF, 0xC2686601}, {0x000084C1, 0xC2686D01},
    {0x000084C4, 0xC2435F01}, {0x000084C6, 0xC2686E01}, {0x000084C9, 0xC24D5601}, {0x000084CA, 0xC2686301},
    {0x000084CB, 0xC2333801}, {0x000084CD, 0xC2686901}, {0x000084D0, 0xC2686C01}, {0x000084D1, 0xC24C2C01},
    {0x000084D6, 0xC2686F01}, {0x000084D9, 0xC2686801}, {0x000084DA, 0xC2686B01}, {0x000084DC, 0xC2762E01},
    {0x000084EC, 0xC24B2901}, {0x000084EE, 0xC24F2101}, {0x000084F4, 0xC2687301}, {0x000084FC, 0xC2687A01},
    {0x000084FF, 0xC2687201}, {0x00008500, 0xC23C4301}, {0x00008506, 0xC2685101}, {0x00008511, 0xC24A4E01},
    {0x00008513, 0xC24C2201}, {0x00008514, 0xC2687901}, {0x00008515, 0xC2687801}, {0x00008517, 0xC2687402},
    {0x0000851A, 0xC2313601}, {0x0000851F, 0xC2687701}, {0x00008521, 0xC2687101}, {0x00008526, 0xC2445501},
    {0x0000852C, 0xC2687601}, {0x0000852D, 0xC2307E01}, {0x00008535, 0xC2422201}, {0x0000853D, 0xC24A4301},
    {0x00008540, 0xC2687B01}, {0x00008541, 0xC2692101}, {0x00008543, 0xC2485901}, {0x00008548, 0xC2687E01},
    {0x00008549, 0xC23E5601}, {0x0000854A, 0xC23C4901}, {0x0000854B, 0xC2692301}, {0x0000854E, 0xC2363E01},
    {0x00008555, 0xC2692401}, {0x00008557, 0xC2497901}, {0x00008558, 0xC2687D01}, {0x00008559, 0xC2763001},
    {0x0000855A, 0xC2685601}, {0x00008563, 0xC2687C01}, {0x00008568, 0xC24F4F01}, {0x00008569, 0xC2462201},
    {0x0000856A, 0xC2497301}, {0x0000856D, 0xC2692B01}, {0x00008577, 0xC2693101}, {0x0000857E, 0xC2693201},
    {0x00008580, 0xC2692501}, {0x00008584, 0xC2477601}, {0x00008587, 0xC2692F01}, {0x00008588, 0xC2692701},
    {0x0000858A, 0xC2692901}, {0x00008590, 0xC2693301}, {0x00008591, 0xC2692801}, {0x00008594, 0xC2692C01},
    {0x00008597, 0xC2317201}, {0x00008599, 0xC2466501}, {0x0000859B, 0xC2692D01}, {0x0000859C, 0xC2693001},
    {0x000085A4, 0xC2692601}, {0x000085A6, 0xC2412601}, {0x000085A8, 0xC2692A01}, {0x000085A9, 0xC23B2701},
    {0x000085AA, 0xC23F4501}, {0x000085AB, 0xC2373001}, {0x000085AC, 0xC24C7401}, {0x000085AE, 0xC24C7901},
    {0x000085AF, 0xC23D7201}, {0x000085B9, 0xC2693701}, {0x000085BA, 0xC2693501}, {0x000085C1, 0xC24F4E01},
    {0x000085C9, 0xC2693401}, {0x000085CD, 0xC24D7501}, {0x000085CE, 0xC2763101}, {0x000085CF, 0xC2693601},
    {0x000085D0, 0xC2693801}, {0x000085D5, 0xC2693901}, {0x000085DC, 0xC2693C01}, {0x000085DD, 0xC2693A01},
    {0x000085E4, 0xC2462301}, {0x000085E5, 0xC2693B01}, {0x000085E9, 0xC2484D01}, {0x000085EA, 0xC2692E01},
    {0x000085F7, 0xC23D7301}, {0x000085F9, 0xC2693D01}, {0x000085FA, 0xC2694201}, {0x000085FB, 0xC2417401},
    {0x000085FE, 0xC2694101}, {0x00008602, 0xC2692201}, {0x00008606, 0xC2694301}, {0x00008607, 0xC2414901},
    {0x0000860A, 0xC2693E01}, {0x0000860B, 0xC2694001}, {0x00008613, 0xC2693F01}, {0x00008616, 0xC25D3101},
    {0x00008617, 0xC25D2201}, {0x0000861A, 0xC2694501}, {0x00008622, 0xC2694401}, {0x0000862D, 0xC24D7601},
    {0x0000862F, 0xC2623C01}, {0x00008630, 0xC2694601}, {0x0000863F, 0xC2694701}, {0x0000864D, 0xC2694801},
    {0x0000864E, 0xC2385701}, {0x00008650, 0xC2355401}, {0x00008654, 0xC2694A01}, {0x00008655, 0xC2515D01},
    {0x0000865A, 0xC2357501}, {0x0000865C, 0xC24E3A01}, {0x0000865E, 0xC2367301}, {0x0000865F, 0xC2694B01},
    {0x00008667, 0xC2694C01}, {0x0000866B, 0xC2436E01}, {0x00008671, 0xC2694D01}, {0x00008679, 0xC2467A01},
    {0x0000867B, 0xC2303A01}, {0x0000868A, 0xC2326301}, {0x0000868B, 0xC2695202}, {0x00008693, 0xC2694E01},
    {0x00008695, 0xC23B3D01}, {0x000086A3, 0xC2694F01}, {0x000086A4, 0xC2474201}, {0x000086A9, 0xC2695002},
    {0x000086AB, 0xC2695B01}, {0x000086AF, 0xC2695501}, {0x000086B0, 0xC2695801}, {0x000086B6, 0xC2695401},
    {0x000086C4, 0xC2695601}, {0x000086C6, 0xC2695701}, {0x000086C7, 0xC23C5801}, {0x000086C9, 0xC2695901},
    {0x000086CB, 0xC2434101}, {0x000086CD, 0xC2375601}, {0x000086CE, 0xC2334201}, {0x000086D4, 0xC2695C01},
    {0x000086D9, 0xC2333F01}, {0x000086DB, 0xC2696101}, {0x000086DE, 0xC2695D01}, {0x000086DF, 0xC2696001},
    {0x000086E4, 0xC2483A01}, {0x000086E9, 0xC2695E01}, {0x000086EC, 0xC2695F01}, {0x000086ED, 0xC2494801},
    {0x000086EE, 0xC2485A01}, {0x000086EF, 0xC2696201}, {0x000086F8, 0xC2427D01}, {0x000086F9, 0xC2696C01},
    {0x000086FB, 0xC2696801}, {0x000086FE, 0xC2326B01}, {0x00008700, 0xC2696601}, {0x00008702, 0xC24B2A01},
    {0x00008703, 0xC2696701}, {0x00008706, 0xC2696401}, {0x00008708, 0xC2696501}, {0x00008709, 0xC2696A01},
    {0x0000870A, 0xC2696D01}, {0x0000870D, 0xC2696B01}, {0x00008711, 0xC2696901}, {0x00008712, 0xC2696301},
    {0x00008718, 0xC2435801}, {0x0000871A, 0xC2697401}, {0x0000871C, 0xC24C2A01}, {0x00008725, 0xC2697201},
    {0x00008729, 0xC2697301}, {0x00008734, 0xC2696E01}, {0x00008737, 0xC2697001}, {0x0000873B, 0xC2697101},
    {0x0000873F, 0xC2696F01}, {0x00008749, 0xC2406601}, {0x0000874B, 0xC24F3901}, {0x0000874C, 0xC2697801},
    {0x0000874E, 0xC2697901}, {0x00008753, 0xC26A2101}, {0x00008755, 0xC23F2A01}, {0x00008757, 0xC2697B01},
    {0x00008759, 0xC2697E01}, {0x0000875F, 0xC2697601}, {0x00008760, 0xC2697501}, {0x00008763, 0xC26A2201},
    {0x00008766, 0xC2325C01}, {0x00008768, 0xC2697C01}, {0x0000876A, 0xC26A2301}, {0x0000876E, 0xC2697D01},
    {0x00008774, 0xC2697A01}, {0x00008776, 0xC2443301}, {0x00008778, 0xC2697701}, {0x0000877F, 0xC2476801},
    {0x00008782, 0xC26A2701}, {0x0000878D, 0xC24D3B01}, {0x0000879F, 0xC26A2601}, {0x000087A2, 0xC26A2501},
    {0x000087AB, 0xC26A2E01}, {0x000087AF, 0xC26A2801}, {0x000087B3, 0xC26A3001}, {0x000087BA, 0xC24D6601},
    {0x000087BB, 0xC26A3301}, {0x000087BD, 0xC26A2A01}, {0x000087C0, 0xC26A2B01}, {0x000087C4, 0xC26A2F01},
    {0x000087C6, 0xC26A3201}, {0x000087C7, 0xC26A3101}, {0x000087CB, 0xC26A2901}, {0x000087D0, 0xC26A2C01},
    {0x000087D2, 0xC26A3D01}, {0x000087E0, 0xC26A3601}, {0x000087EC, 0xC2763301}, {0x000087EF, 0xC26A3401},
    {0x000087F2, 0xC26A3501}, {0x000087F6, 0xC26A3A02}, {0x000087F9, 0xC2332A01}, {0x000087FB, 0xC2354201},
    {0x000087FE, 0xC26A3901}, {0x00008805, 0xC26A2401}, {0x0000880B, 0xC2763401}, {0x0000880D, 0xC26A3801},
    {0x0000880E, 0xC26A3C01}, {0x0000880F, 0xC26A3701}, {0x00008811, 0xC26A3E01}, {0x00008815, 0xC26A4001},
    {0x00008816, 0xC26A3F01}, {0x00008821, 0xC26A4201}, {0x00008822, 0xC26A4101}, {0x00008823, 0xC2695A01},
    {0x00008827, 0xC26A4601}, {0x00008831, 0xC26A4301}, {0x00008836, 0xC26A4401}, {0x00008839, 0xC26A4501},
    {0x0000883B, 0xC26A4701}, {0x00008840, 0xC2376C01}, {0x00008842, 0xC26A4901}, {0x00008844, 0xC26A4801},
    {0x00008846, 0xC23D3001}, {0x0000884C, 0xC2395401}, {0x0000884D, 0xC25E2701}, {0x00008852, 0xC26A4A01},
    {0x00008853, 0xC23D5101}, {0x00008857, 0xC2333901}, {0x00008859, 0xC26A4B01}, {0x0000885B, 0xC2315201},
    {0x0000885D, 0xC23E5701}, {0x0000885E, 0xC26A4C01}, {0x00008861, 0xC2395501}, {0x00008862, 0xC26A4D01},
    {0x00008863, 0xC2306101}, {0x00008868, 0xC2493D01}, {0x0000886B, 0xC26A4E01}, {0x00008870, 0xC23F6A01},
    {0x00008872, 0xC26A5501}, {0x00008875, 0xC26A5201}, {0x00008877, 0xC2436F01}, {0x0000887D, 0xC26A5301},
    {0x0000887E, 0xC26A5001}, {0x0000887F, 0xC2365E01}, {0x00008881, 0xC26A4F01}, {0x00008882, 0xC26A5601},
    {0x00008888, 0xC2373601}, {0x0000888B, 0xC2425E01}, {0x0000888D, 0xC26A5C01}, {0x00008892, 0xC26A5801},
    {0x00008896, 0xC2423501}, {0x00008897, 0xC26A5701}, {0x00008899, 0xC26A5A01}, {0x0000889E, 0xC26A5101},
    {0x000088A2, 0xC26A5B01}, {0x000088A4, 0xC26A5D01}, {0x000088AB, 0xC2486F01}, {0x000088AE, 0xC26A5901},
    {0x000088B0, 0xC26A5E01}, {0x000088B1, 0xC26A6001}, {0x000088B4, 0xC2385301}, {0x000088B5, 0xC26A5401},
    {0x000088B7, 0xC2304101}, {0x000088BF, 0xC26A5F01}, {0x000088C1, 0xC23A5B01}, {0x000088C2, 0xC24E7601},
    {0x000088C3, 0xC26A6102}, {0x000088C5, 0xC2417501}, {0x000088CF, 0xC24E2201}, {0x000088D4, 0xC26A6301},
    {0x000088D5, 0xC24D3501}, {0x000088D8, 0xC26A6402}, {0x000088DC, 0xC24A6401}, {0x000088DD, 0xC26A6601},
    {0x000088DF, 0xC23A4001}, {0x000088E1, 0xC24E2301}, {0x000088E8, 0xC26A6B01}, {0x000088F2, 0xC26A6C01},
    {0x000088F3, 0xC23E5801}, {0x000088F4, 0xC26A6A01}, {0x000088F5, 0xC2763501}, {0x000088F8, 0xC24D6701},
    {0x000088F9, 0xC26A6701}, {0x000088FC, 0xC26A6901}, {0x000088FD, 0xC2403D01}, {0x000088FE, 0xC23F7E01},
    {0x00008902, 0xC26A6801}, {0x00008904, 0xC26A6D01}, {0x00008907, 0xC24A2301}, {0x0000890A, 0xC26A6F01},
    {0x0000890C, 0xC26A6E01}, {0x00008910, 0xC2336C01}, {0x00008912, 0xC24B2B01}, {0x00008913, 0xC26A7001},
    {0x0000891D, 0xC26A7C01}, {0x0000891E, 0xC26A7201}, {0x00008925, 0xC26A7301}, {0x0000892A, 0xC26A7402},
    {0x00008936, 0xC26A7901}, {0x00008938, 0xC26A7A01}, {0x0000893B, 0xC26A7801}, {0x00008941, 0xC26A7601},
    {0x00008943, 0xC26A7101}, {0x00008944, 0xC26A7701}, {0x0000894C, 0xC26A7B01}, {0x0000894D, 0xC2703701},
    {0x00008956, 0xC2322801}, {0x0000895E, 0xC26A7E01}, {0x0000895F, 0xC2365F01}, {0x00008960, 0xC26A7D01},
    {0x00008964, 0xC26B2201}, {0x00008966, 0xC26B2101}, {0x0000896A, 0xC26B2401}, {0x0000896D, 0xC26B2301},
    {0x0000896F, 0xC26B2501}, {0x00008972, 0xC23D3101}, {0x00008974, 0xC26B2601}, {0x00008977, 0xC26B2701},
    {0x0000897E, 0xC26B2801}, {0x0000897F, 0xC2403E01}, {0x00008981, 0xC24D5701}, {0x00008983, 0xC26B2901},
    {0x00008986, 0xC24A2401}, {0x00008987, 0xC2474601}, {0x00008988, 0xC26B2A01}, {0x0000898A, 0xC26B2B01},
    {0x0000898B, 0xC2382B01}, {0x0000898F, 0xC2352C01}, {0x00008993, 0xC26B2C01}, {0x00008996, 0xC23B6B01},
    {0x00008997, 0xC2474101}, {0x00008998, 0xC26B2D01}, {0x0000899A, 0xC2335001}, {0x000089A1, 0xC26B2E01},
    {0x000089A6, 0xC26B3001}, {0x000089A7, 0xC24D7701}, {0x000089A9, 0xC26B2F01}, {0x000089AA, 0xC23F4601},
    {0x000089AC, 0xC26B3101}, {0x000089AF, 0xC26B3201}, {0x000089B2, 0xC26B3301}, {0x000089B3, 0xC2345101},
    {0x000089BA, 0xC26B3401}, {0x000089BD, 0xC26B3501}, {0x000089BF, 0xC26B3602}, {0x000089D2, 0xC2335101},
    {0x000089DA, 0xC26B3801}, {0x000089DC, 0xC26B3902}, {0x000089E3, 0xC2327201}, {0x000089E6, 0xC23F2801},
    {0x000089E7, 0xC26B3B01}, {0x000089F4, 0xC26B3C01}, {0x000089F8, 0xC26B3D01}, {0x00008A00, 0xC2384001},
    {0x00008A02, 0xC2447B01}, {0x00008A03, 0xC26B3E01}, {0x00008A08, 0xC2375701}, {0x00008A0A, 0xC23F5601},
    {0x00008A0C, 0xC26B4101}, {0x00008A0E, 0xC2462401}, {0x00008A10, 0xC26B4001}, {0x00008A13, 0xC2373101},
    {0x00008A16, 0xC26B3F01}, {0x00008A17, 0xC2427701}, {0x00008A18, 0xC2352D01}, {0x00008A1B, 0xC26B4201},
    {0x00008A1D, 0xC26B4301}, {0x00008A1F, 0xC23E5901}, {0x00008A23, 0xC2376D01}, {0x00008A25, 0xC26B4401},
    {0x00008A2A, 0xC24B2C01}, {0x00008A2D, 0xC2405F01}, {0x00008A31, 0xC2357601}, {0x00008A33, 0xC24C7501},
    {0x00008A34, 0xC2414A01}, {0x00008A36, 0xC26B4501}, {0x00008A3A, 0xC23F4701}, {0x00008A3B, 0xC2437001},
    {0x00008A3C, 0xC23E5A01}, {0x00008A41, 0xC26B4601}, {0x00008A46, 0xC26B4901}, {0x00008A48, 0xC26B4A01},
    {0x00008A50, 0xC23A3E01}, {0x00008A51, 0xC2424201}, {0x00008A52, 0xC26B4801}, {0x00008A54, 0xC23E5B01},
    {0x00008A55, 0xC2493E01}, {0x00008A5B, 0xC26B4701}, {0x00008A5E, 0xC23B6C01}, {0x00008A60, 0xC2315301},
    {0x00008A62, 0xC26B4E01}, {0x00008A63, 0xC2375801}, {0x00008A66, 0xC23B6E01}, {0x00008A69, 0xC23B6D01},
    {0x00008A6B, 0xC24F4D01}, {0x00008A6C, 0xC26B4D01}, {0x00008A6D, 0xC26B4C01}, {0x00008A6E, 0xC2412701},
    {0x00008A70, 0xC2354D01}, {0x00008A71, 0xC24F4301}, {0x00008A72, 0xC2333A01}, {0x00008A73, 0xC23E5C01},
    {0x00008A79, 0xC2752E01}, {0x00008A7C, 0xC26B4B01}, {0x00008A82, 0xC26B5001}, {0x00008A84, 0xC26B5101},
    {0x00008A85, 0xC26B4F01}, {0x00008A87, 0xC2385801}, {0x00008A89, 0xC24D4001}, {0x00008A8C, 0xC23B6F01},
    {0x00008A8D, 0xC2472701}, {0x00008A91, 0xC26B5401}, {0x00008A93, 0xC2404001}, {0x00008A95, 0xC2434201},
    {0x00008A98, 0xC24D3601}, {0x00008A9A, 0xC26B5701}, {0x00008A9E, 0xC2386C01}, {0x00008AA0, 0xC2403F01},
    {0x00008AA1, 0xC26B5301}, {0x00008AA3, 0xC26B5801}, {0x00008AA4, 0xC2386D01}, {0x00008AA5, 0xC26B5502},
    {0x00008AA8, 0xC26B5201}, {0x00008AAC, 0xC2406201}, {0x00008AAD, 0xC2464901}, {0x00008AB0, 0xC2432F01},
    {0x00008AB2, 0xC2325D01}, {0x00008AB9, 0xC2487001}, {0x00008ABC, 0xC2354301}, {0x00008ABF, 0xC2443401},
    {0x00008AC2, 0xC26B5B01}, {0x00008AC4, 0xC26B5901}, {0x00008AC7, 0xC2434C01}, {0x00008ACB, 0xC2404101},
    {0x00008ACC, 0xC2345201}, {0x00008ACD, 0xC26B5A01}, {0x00008ACF, 0xC23F5B01}, {0x00008AD2, 0xC24E4A01},
    {0x00008AD6, 0xC24F4001}, {0x00008ADA, 0xC26B5C01}, {0x00008ADB, 0xC26B6701}, {0x00008ADC, 0xC2443501},
    {0x00008ADE, 0xC26B6601}, {0x00008AE0, 0xC26B6301}, {0x00008AE1, 0xC26B6B01}, {0x00008AE2, 0xC26B6401},
    {0x00008AE4, 0xC26B6001}, {0x00008AE6, 0xC2447C01}, {0x00008AE7, 0xC26B5F01}, {0x00008AEB, 0xC26B5D01},
    {0x00008AED, 0xC24D2101}, {0x00008AEE, 0xC23B7001}, {0x00008AF1, 0xC26B6101}, {0x00008AF3, 0xC26B5E01},
    {0x00008AF6, 0xC2763701}, {0x00008AF7, 0xC26B6501}, {0x00008AF8, 0xC23D7401}, {0x00008AFA, 0xC2384101},
    {0x00008AFE, 0xC2427A01}, {0x00008B00, 0xC24B4501}, {0x00008B01, 0xC2315A01}, {0x00008B02, 0xC2306201},
    {0x00008B04, 0xC2462501}, {0x00008B07, 0xC26B6901}, {0x00008B0C, 0xC26B6801}, {0x00008B0E, 0xC2466601},
    {0x00008B10, 0xC26B6D01}, {0x00008B14, 0xC26B6201}, {0x00008B16, 0xC26B6C01}, {0x00008B17, 0xC26B6E01},
    {0x00008B19, 0xC2382C01}, {0x00008B1A, 0xC26B6A01}, {0x00008B1B, 0xC2395601}, {0x00008B1D, 0xC23C5501},
    {0x00008B20, 0xC26B6F01}, {0x00008B21, 0xC24D5801}, {0x00008B26, 0xC26B7201}, {0x00008B28, 0xC26B7501},
    {0x00008B2B, 0xC26B7301}, {0x00008B2C, 0xC2493501}, {0x00008B33, 0xC26B7001}, {0x00008B39, 0xC2366001},
    {0x00008B3E, 0xC26B7401}, {0x00008B41, 0xC26B7601}, {0x00008B49, 0xC26B7A01}, {0x00008B4C, 0xC26B7701},
    {0x00008B4E, 0xC26B7901}, {0x00008B4F, 0xC26B7801}, {0x00008B56, 0xC26B7B01}, {0x00008B58, 0xC23C3101},
    {0x00008B5A, 0xC26B7D01}, {0x00008B5B, 0xC26B7C01}, {0x00008B5C, 0xC2496801}, {0x00008B5F, 0xC26C2101},
    {0x00008B66, 0xC2375901}, {0x00008B6B, 0xC26B7E01}, {0x00008B6C, 0xC26C2201}, {0x00008B6F, 0xC26C2301},
    {0x00008B70, 0xC2354401}, {0x00008B71, 0xC2664101}, {0x00008B72, 0xC23E7901}, {0x00008B74, 0xC26C2401},
    {0x00008B77, 0xC2386E01}, {0x00008B7D, 0xC26C2501}, {0x00008B80, 0xC26C2601}, {0x00008B83, 0xC23B3E01},
    {0x00008B8A, 0xC25A4E01}, {0x00008B8C, 0xC26C2701}, {0x00008B8E, 0xC26C2801}, {0x00008B90, 0xC23D3201},
    {0x00008B92, 0xC26C2902}, {0x00008B96, 0xC26C2B01}, {0x00008B99, 0xC26C2C02}, {0x00008C37, 0xC2432B01},
    {0x00008C3A, 0xC26C2E01}, {0x00008C3F, 0xC26C3001}, {0x00008C41, 0xC26C2F01}, {0x00008C46, 0xC2462601},
    {0x00008C48, 0xC26C3101}, {0x00008C4A, 0xC24B2D01}, {0x00008C4C, 0xC26C3201}, {0x00008C4E, 0xC26C3301},
    {0x00008C50, 0xC26C3401}, {0x00008C55, 0xC26C3501}, {0x00008C5A, 0xC2465A01}, {0x00008C61, 0xC23E5D01},
    {0x00008C62, 0xC26C3601}, {0x00008C6A, 0xC2396B01}, {0x00008C6B, 0xC2502E01}, {0x00008C6C, 0xC26C3701},
    {0x00008C78, 0xC26C3801}, {0x00008C79, 0xC2493F01}, {0x00008C7A, 0xC26C3901}, {0x00008C7C, 0xC26C4101},
    {0x00008C82, 0xC26C3A01}, {0x00008C85, 0xC26C3C01}, {0x00008C89, 0xC26C3B01}, {0x00008C8A, 0xC26C3D01},
    {0x00008C8C, 0xC24B4601}, {0x00008C8D, 0xC26C3E02}, {0x00008C94, 0xC26C4001}, {0x00008C98, 0xC26C4201},
    {0x00008C9D, 0xC2332D01}, {0x00008C9E, 0xC2446701}, {0x00008CA0, 0xC2496901}, {0x00008CA1, 0xC23A6201},
    {0x00008CA2, 0xC2395701}, {0x00008CA7, 0xC2494F01}, {0x00008CA8, 0xC2325F01}, {0x00008CA9, 0xC2484E01},
    {0x00008CAA, 0xC26C4501}, {0x00008CAB, 0xC2345301}, {0x00008CAC, 0xC2405501}, {0x00008CAD, 0xC26C4401},
    {0x00008CAE, 0xC26C4901}, {0x00008CAF, 0xC2437901}, {0x00008CB0, 0xC24C6301}, {0x00008CB2, 0xC26C4702},
    {0x00008CB4, 0xC2352E01}, {0x00008CB6, 0xC26C4A01}, {0x00008CB7, 0xC2476301}, {0x00008CB8, 0xC2425F01},
    {0x00008CBB, 0xC2487101}, {0x00008CBC, 0xC2453D01}, {0x00008CBD, 0xC26C4601}, {0x00008CBF, 0xC24B4701},
    {0x00008CC0, 0xC2326C01}, {0x00008CC1, 0xC26C4C01}, {0x00008CC2, 0xC24F2801}, {0x00008CC3, 0xC2444201},
    {0x00008CC4, 0xC24F4501}, {0x00008CC7, 0xC23B7101}, {0x00008CC8, 0xC26C4B01}, {0x00008CCA, 0xC2423101},
    {0x00008CCD, 0xC26C5C01}, {0x00008CCE, 0xC2412801}, {0x00008CD1, 0xC2467801}, {0x00008CD3, 0xC2495001},
    {0x00008CDA, 0xC26C4F01}, {0x00008CDB, 0xC23B3F01}, {0x00008CDC, 0xC23B7201}, {0x00008CDE, 0xC23E5E01},
    {0x00008CE0, 0xC2476501}, {0x00008CE2, 0xC2382D01}, {0x00008CE3, 0xC26C4E01}, {0x00008CE4, 0xC26C4D01},
    {0x00008CE6, 0xC2496A01}, {0x00008CEA, 0xC23C4101}, {0x00008CED, 0xC2455201}, {0x00008CFA, 0xC26C5102},
    {0x00008CFC, 0xC2395801}, {0x00008CFD, 0xC26C5001}, {0x00008D04, 0xC26C5302}, {0x00008D07, 0xC26C5601},
    {0x00008D08, 0xC2422301}, {0x00008D0A, 0xC26C5501}, {0x00008D0B, 0xC2346601}, {0x00008D0D, 0xC26C5801},
    {0x00008D0F, 0xC26C5701}, {0x00008D10, 0xC26C5901}, {0x00008D13, 0xC26C5B01}, {0x00008D14, 0xC26C5D01},
    {0x00008D16, 0xC26C5E01}, {0x00008D64, 0xC2405601}, {0x00008D66, 0xC23C4F01}, {0x00008D67, 0xC26C5F01},
    {0x00008D6B, 0xC2335201}, {0x00008D6D, 0xC26C6001}, {0x00008D70, 0xC2417601}, {0x00008D71, 0xC26C6101},
    {0x00008D73, 0xC26C6201}, {0x00008D74, 0xC2496B01}, {0x00008D77, 0xC2352F01}, {0x00008D81, 0xC26C6301},
    {0x00008D85, 0xC2443601}, {0x00008D8A, 0xC2315B01}, {0x00008D99, 0xC26C6401}, {0x00008DA3, 0xC23C7101},
    {0x00008DA8, 0xC23F7601}, {0x00008DB3, 0xC2422D01}, {0x00008DBA, 0xC26C6701}, {0x00008DBE, 0xC26C6601},
    {0x00008DC2, 0xC26C6501}, {0x00008DCB, 0xC26C6D01}, {0x00008DCC, 0xC26C6B01}, {0x00008DCE, 0xC2763801},
    {0x00008DCF, 0xC26C6801}, {0x00008DD6, 0xC26C6A01}, {0x00008DDA, 0xC26C6901}, {0x00008DDB, 0xC26C6C01},
    {0x00008DDD, 0xC2357701}, {0x00008DDF, 0xC26C7001}, {0x00008DE1, 0xC2405701}, {0x00008DE3, 0xC26C7101},
    {0x00008DE8, 0xC2385901}, {0x00008DEA, 0xC26C6E02}, {0x00008DEF, 0xC24F2901}, {0x00008DF3, 0xC2443701},
    {0x00008DF5, 0xC2412901}, {0x00008DFC, 0xC26C7201}, {0x00008DFF, 0xC26C7501}, {0x00008E08, 0xC26C7302},
    {0x00008E0A, 0xC24D5901}, {0x00008E0F, 0xC2462701}, {0x00008E10, 0xC26C7801}, {0x00008E1D, 0xC26C7602},
    {0x00008E1F, 0xC26C7901}, {0x00008E2A, 0xC26D2901}, {0x00008E30, 0xC26C7C01}, {0x00008E34, 0xC26C7D01},
    {0x00008E35, 0xC26C7B01}, {0x00008E42, 0xC26C7A01}, {0x00008E44, 0xC2447D01}, {0x00008E47, 0xC26D2101},
    {0x00008E48, 0xC26D2501}, {0x00008E49, 0xC26D2201}, {0x00008E4A, 0xC26C7E01}, {0x00008E4C, 0xC26D2301},
    {0x00008E50, 0xC26D2401}, {0x00008E55, 0xC26D2B01}, {0x00008E59, 0xC26D2601}, {0x00008E5F, 0xC2405801},
    {0x00008E60, 0xC26D2801}, {0x00008E63, 0xC26D2A01}, {0x00008E64, 0xC26D2701}, {0x00008E72, 0xC26D2D01},
    {0x00008E74, 0xC23D3301}, {0x00008E76, 0xC26D2C01}, {0x00008E7C, 0xC26D2E01}, {0x00008E81, 0xC26D2F01},
    {0x00008E84, 0xC26D3201}, {0x00008E85, 0xC26D3101}, {0x00008E87, 0xC26D3001}, {0x00008E8A, 0xC26D3401},
    {0x00008E8B, 0xC26D3301}, {0x00008E8D, 0xC24C7601}, {0x00008E91, 0xC26D3601}, {0x00008E93, 0xC26D3501},
    {0x00008E94, 0xC26D3701}, {0x00008E99, 0xC26D3801}, {0x00008EA1, 0xC26D3A01}, {0x00008EAA, 0xC26D3901},
    {0x00008EAB, 0xC23F4801}, {0x00008EAC, 0xC26D3B01}, {0x00008EAF, 0xC2366D01}, {0x00008EB0, 0xC26D3C01},
    {0x00008EB1, 0xC26D3E01}, {0x00008EBE, 0xC26D3F01}, {0x00008EC5, 0xC26D4001}, {0x00008EC6, 0xC26D3D01},
    {0x00008EC8, 0xC26D4101}, {0x00008ECA, 0xC23C5601}, {0x00008ECB, 0xC26D4201}, {0x00008ECC, 0xC2353001},
    {0x00008ECD, 0xC2373301}, {0x00008ED2, 0xC2382E01}, {0x00008EDB, 0xC26D4301}, {0x00008EDF, 0xC2467001},
    {0x00008EE2, 0xC2453E01}, {0x00008EE3, 0xC26D4401}, {0x00008EEB, 0xC26D4701}, {0x00008EF8, 0xC23C3401},
    {0x00008EFB, 0xC26D4601}, {0x00008EFC, 0xC26D4501}, {0x00008EFD, 0xC2375A01}, {0x00008EFE, 0xC26D4801},
    {0x00008F03, 0xC2335301}, {0x00008F05, 0xC26D4A01}, {0x00008F09, 0xC23A5C01}, {0x00008F0A, 0xC26D4901},
    {0x00008F0C, 0xC26D5201}, {0x00008F12, 0xC26D4C01}, {0x00008F13, 0xC26D4E01}, {0x00008F14, 0xC24A6501},
    {0x00008F15, 0xC26D4B01}, {0x00008F19, 0xC26D4D01}, {0x00008F1B, 0xC26D5101}, {0x00008F1C, 0xC26D4F01},
    {0x00008F1D, 0xC2353101}, {0x00008F1F, 0xC26D5001}, {0x00008F26, 0xC26D5301}, {0x00008F29, 0xC2475A01},
    {0x00008F2A, 0xC24E5801}, {0x00008F2F, 0xC23D3401}, {0x00008F33, 0xC26D5401}, {0x00008F38, 0xC24D2201},
    {0x00008F39, 0xC26D5601}, {0x00008F3B, 0xC26D5501}, {0x00008F3E, 0xC26D5901}, {0x00008F3F, 0xC24D4101},
    {0x00008F42, 0xC26D5801}, {0x00008F44, 0xC2336D01}, {0x00008F45, 0xC26D5701}, {0x00008F46, 0xC26D5C01},
    {0x00008F49, 0xC26D5B01}, {0x00008F4C, 0xC26D5A01}, {0x00008F4D, 0xC2453201}, {0x00008F4E, 0xC26D5D01},
    {0x00008F57, 0xC26D5E01}, {0x00008F5C, 0xC26D5F01}, {0x00008F5F, 0xC2396C01}, {0x00008F61, 0xC2372501},
    {0x00008F62, 0xC26D6003}, {0x00008F9B, 0xC23F4901}, {0x00008F9C, 0xC26D6301}, {0x00008F9E, 0xC23C2D01},
    {0x00008F9F, 0xC26D6401}, {0x00008FA3, 0xC26D6501}, {0x00008FA7, 0xC2522101}, {0x00008FA8, 0xC2517E01},
    {0x00008FAD, 0xC26D6601}, {0x00008FAE, 0xC2657001}, {0x00008FAF, 0xC26D6701}, {0x00008FB0, 0xC2432401},
    {0x00008FB1, 0xC23F2B01}, {0x00008FB2, 0xC2474001}, {0x00008FB7, 0xC26D6801}, {0x00008FBA, 0xC24A5501},
    {0x00008FBB, 0xC2445401}, {0x00008FBC, 0xC2397E01}, {0x00008FBF, 0xC2432901}, {0x00008FC2, 0xC2312A01},
    {0x00008FC4, 0xC24B7801}, {0x00008FC5, 0xC23F5701}, {0x00008FCE, 0xC2375E01}, {0x00008FD1, 0xC2366101},
    {0x00008FD4, 0xC24A5601}, {0x00008FDA, 0xC26D6901}, {0x00008FE2, 0xC26D6B01}, {0x00008FE5, 0xC26D6A01},
    {0x00008FE6, 0xC2326001}, {0x00008FE9, 0xC2467601}, {0x00008FEA, 0xC26D6C01}, {0x00008FEB, 0xC2477701},
    {0x00008FED, 0xC2453301}, {0x00008FEF, 0xC26D6D01}, {0x00008FF0, 0xC23D5201}, {0x00008FF4, 0xC26D6F01},
    {0x00008FF6, 0xC2763A01}, {0x00008FF7, 0xC24C4201}, {0x00008FF8, 0xC26D7E01}, {0x00008FF9, 0xC26D7102},
    {0x00008FFD, 0xC2444901}, {0x00009000, 0xC2426001}, {0x00009001, 0xC2417701}, {0x00009003, 0xC2462801},
    {0x00009005, 0xC26D7001}, {0x00009006, 0xC2355501}, {0x0000900B, 0xC26D7901}, {0x0000900D, 0xC26D7601},
    {0x0000900E, 0xC26E2501}, {0x0000900F, 0xC2462901}, {0x00009010, 0xC2436001}, {0x00009011, 0xC26D7301},
    {0x00009013, 0xC2447E01}, {0x00009014, 0xC2455301}, {0x00009015, 0xC26D7401}, {0x00009016, 0xC26D7801},
    {0x00009017, 0xC23F6001}, {0x00009019, 0xC2476701}, {0x0000901A, 0xC2444C01}, {0x0000901D, 0xC2404201},
    {0x0000901E, 0xC26D7701}, {0x0000901F, 0xC2422E01}, {0x00009020, 0xC2422401}, {0x00009021, 0xC26D7501},
    {0x00009022, 0xC2302901}, {0x00009023, 0xC24F2201}, {0x00009027, 0xC26D7A01}, {0x0000902E, 0xC2426101},
    {0x00009031, 0xC23D3501}, {0x00009032, 0xC23F4A01}, {0x00009035, 0xC26D7C01}, {0x00009036, 0xC26D7B01},
    {0x00009038, 0xC2306F01}, {0x00009039, 0xC26D7D01}, {0x0000903C, 0xC2492F01}, {0x0000903E, 0xC26E2701},
    {0x00009041, 0xC2465B01}, {0x00009042, 0xC23F6B01}, {0x00009045, 0xC2435901}, {0x00009047, 0xC2367801},
    {0x00009049, 0xC26E2601}, {0x0000904A, 0xC24D3701}, {0x0000904B, 0xC2313F01}, {0x0000904D, 0xC24A5701},
    {0x0000904E, 0xC2326101}, {0x0000904F, 0xC26E2104}, {0x00009053, 0xC2463B01}, {0x00009054, 0xC2432301},
    {0x00009055, 0xC2306301}, {0x00009056, 0xC26E2801}, {0x00009058, 0xC26E2901}, {0x00009059, 0xC2742301},
    {0x0000905C, 0xC2423D01}, {0x0000905E, 0xC26E2A01}, {0x00009060, 0xC2317301}, {0x00009061, 0xC2414C01},
    {0x00009063, 0xC2382F01}, {0x00009065, 0xC24D5A01}, {0x00009068, 0xC26E2B01}, {0x00009069, 0xC2452C01},
    {0x0000906D, 0xC2417801}, {0x0000906E, 0xC23C5701}, {0x0000906F, 0xC26E2C01}, {0x00009072, 0xC26E2F01},
    {0x00009075, 0xC23D6501}, {0x00009076, 0xC26E2D01}, {0x00009077, 0xC2412B01}, {0x00009078, 0xC2412A01},
    {0x0000907A, 0xC2306401}, {0x0000907C, 0xC24E4B01}, {0x0000907D, 0xC26E3101}, {0x0000907F, 0xC2487201},
    {0x00009080, 0xC26E3301}, {0x00009081, 0xC26E3201}, {0x00009082, 0xC26E3001}, {0x00009083, 0xC2636401},
    {0x00009084, 0xC2345401}, {0x00009087, 0xC26D6E01}, {0x00009089, 0xC26E3501}, {0x0000908A, 0xC26E3401},
    {0x0000908F, 0xC26E3601}, {0x00009091, 0xC24D3801}, {0x000090A3, 0xC2466101}, {0x000090A6, 0xC24B2E01},
    {0x000090A8, 0xC26E3701}, {0x000090AA, 0xC23C5901}, {0x000090AF, 0xC26E3801}, {0x000090B1, 0xC26E3901},
    {0x000090B5, 0xC26E3A01}, {0x000090B8, 0xC2452101}, {0x000090C1, 0xC2306A01}, {0x000090CA, 0xC2395901},
    {0x000090CE, 0xC24F3A01}, {0x000090DB, 0xC26E3E01}, {0x000090DD, 0xC2763B01}, {0x000090E1, 0xC2373401},
    {0x000090E2, 0xC26E3B01}, {0x000090E4, 0xC26E3C01}, {0x000090E8, 0xC2497401}, {0x000090ED, 0xC2335401},
    {0x000090F5, 0xC24D3901}, {0x000090F7, 0xC2363F01}, {0x000090FD, 0xC2455401}, {0x00009102, 0xC26E3F01},
    {0x00009112, 0xC26E4001}, {0x00009119, 0xC26E4101}, {0x00009127, 0xC2763C01}, {0x0000912D, 0xC2452201},
    {0x00009130, 0xC26E4301}, {0x00009132, 0xC26E4201}, {0x00009149, 0xC2465301}, {0x0000914A, 0xC26E4401},
    {0x0000914B, 0xC23D3601}, {0x0000914C, 0xC23C6001}, {0x0000914D, 0xC2475B01}, {0x0000914E, 0xC2437101},
    {0x00009152, 0xC23C7201}, {0x00009154, 0xC23F6C01}, {0x00009156, 0xC26E4501}, {0x00009158, 0xC26E4601},
    {0x00009162, 0xC23F5D01}, {0x00009163, 0xC26E4701}, {0x00009165, 0xC26E4801}, {0x00009169, 0xC26E4901},
    {0x0000916A, 0xC24D6F01}, {0x0000916C, 0xC23D3701}, {0x00009172, 0xC26E4B01}, {0x00009173, 0xC26E4A01},
    {0x00009175, 0xC2395A01}, {0x00009177, 0xC2397301}, {0x00009178, 0xC23B4001}, {0x00009182, 0xC26E4E01},
    {0x00009187, 0xC23D6601}, {0x00009189, 0xC26E4D01}, {0x0000918B, 0xC26E4C01}, {0x0000918D, 0xC2426901},
    {0x00009190, 0xC2386F01}, {0x00009192, 0xC2404301}, {0x00009197, 0xC2483001}, {0x0000919C, 0xC23D3901},
    {0x000091A2, 0xC26E4F01}, {0x000091A4, 0xC23E5F01}, {0x000091AA, 0xC26E5201}, {0x000091AB, 0xC26E5001},
    {0x000091AF, 0xC26E5101}, {0x000091B2, 0xC2763E01}, {0x000091B4, 0xC26E5401}, {0x000091B5, 0xC26E5301},
    {0x000091B8, 0xC23E7A01}, {0x000091BA, 0xC26E5501}, {0x000091C0, 0xC26E5602}, {0x000091C6, 0xC2485001},
    {0x000091C7, 0xC23A5301}, {0x000091C8, 0xC23C6101}, {0x000091C9, 0xC26E5801}, {0x000091CB, 0xC26E5901},
    {0x000091CC, 0xC24E2401}, {0x000091CD, 0xC23D4501}, {0x000091CE, 0xC24C6E01}, {0x000091CF, 0xC24E4C01},
    {0x000091D0, 0xC26E5A01}, {0x000091D1, 0xC2366201}, {0x000091D6, 0xC26E5B01}, {0x000091D8, 0xC2452301},
    {0x000091DB, 0xC26E5E01}, {0x000091DC, 0xC2337801}, {0x000091DD, 0xC23F4B01}, {0x000091DF, 0xC26E5C01},
    {0x000091E1, 0xC26E5D01}, {0x000091E3, 0xC2446001}, {0x000091E6, 0xC24B5501}, {0x000091E7, 0xC2367C01},
    {0x000091F5, 0xC26E6002}, {0x000091FC, 0xC26E5F01}, {0x000091FF, 0xC26E6301}, {0x0000920D, 0xC2465F01},
    {0x0000920E, 0xC2334301}, {0x00009211, 0xC26E6701}, {0x00009214, 0xC26E6401}, {0x00009215, 0xC26E6601},
    {0x0000921E, 0xC26E6201}, {0x00009229, 0xC26F4F01}, {0x0000922C, 0xC26E6501}, {0x00009233, 0xC2763F01},
    {0x00009234, 0xC24E6B01}, {0x00009237, 0xC2385A01}, {0x0000923F, 0xC26E6F01}, {0x00009244, 0xC2453401},
    {0x00009245, 0xC26E6A01}, {0x00009248, 0xC26E6D01}, {0x00009249, 0xC26E6B01}, {0x0000924B, 0xC26E7001},
    {0x00009250, 0xC26E7101}, {0x00009257, 0xC26E6901}, {0x0000925A, 0xC26E7601}, {0x0000925B, 0xC2317401},
    {0x0000925E, 0xC26E6801}, {0x00009262, 0xC2482D01}, {0x00009264, 0xC26E6C01}, {0x00009266, 0xC23E6001},
    {0x00009271, 0xC2395B01}, {0x0000927E, 0xC24B4801}, {0x00009280, 0xC2366401}, {0x00009283, 0xC23D4601},
    {0x00009285, 0xC2463C01}, {0x00009288, 0xC2764001}, {0x00009291, 0xC2412D01}, {0x00009293, 0xC26E7401},
    {0x00009295, 0xC26E6E01}, {0x00009296, 0xC26E7301}, {0x00009298, 0xC24C4301}, {0x0000929A, 0xC2443801},
    {0x0000929B, 0xC26E7501}, {0x0000929C, 0xC26E7201}, {0x000092AD, 0xC2412C01}, {0x000092B7, 0xC26E7901},
    {0x000092B9, 0xC26E7801}, {0x000092CF, 0xC26E7701}, {0x000092D2, 0xC24B2F01}, {0x000092E4, 0xC23D7B01},
    {0x000092E9, 0xC26E7A01}, {0x000092EA, 0xC24A5F01}, {0x000092ED, 0xC2315401}, {0x000092F2, 0xC2494601},
    {0x000092F3, 0xC2437201}, {0x000092F8, 0xC2357801}, {0x000092FA, 0xC26E7C01}, {0x000092FC, 0xC2395D01},
    {0x00009306, 0xC23B2C01}, {0x0000930F, 0xC26E7B01}, {0x00009310, 0xC23F6D01}, {0x00009318, 0xC23F6E01},
    {0x00009319, 0xC26F2101}, {0x0000931A, 0xC26F2301}, {0x00009320, 0xC23E7B01}, {0x00009321, 0xC2764101},
    {0x00009322, 0xC26F2201}, {0x00009323, 0xC26F2401}, {0x00009326, 0xC2365301}, {0x00009328, 0xC2494501},
    {0x0000932B, 0xC23C6201}, {0x0000932C, 0xC24F2301}, {0x0000932E, 0xC26E7E01}, {0x0000932F, 0xC23A7801},
    {0x00009332, 0xC24F3F01}, {0x00009335, 0xC26F2601}, {0x0000933A, 0xC26F2501}, {0x0000933B, 0xC26F2701},
    {0x00009344, 0xC26E7D01}, {0x00009348, 0xC2764201}, {0x0000934B, 0xC2466901}, {0x0000934D, 0xC2455501},
    {0x00009354, 0xC2445701}, {0x00009356, 0xC26F2C01}, {0x0000935B, 0xC2434301}, {0x0000935C, 0xC26F2801},
    {0x00009360, 0xC26F2901}, {0x0000936C, 0xC2372D01}, {0x0000936E, 0xC26F2B01}, {0x00009375, 0xC2383001},
    {0x0000937C, 0xC26F2A01}, {0x0000937E, 0xC23E6101}, {0x0000938C, 0xC2337901}, {0x00009394, 0xC26F3001},
    {0x00009396, 0xC23A3F01}, {0x00009397, 0xC2417901}, {0x0000939A, 0xC2444A01}, {0x000093A7, 0xC2333B01},
    {0x000093AC, 0xC26F2E02}, {0x000093AE, 0xC2444301}, {0x000093B0, 0xC26F2D01}, {0x000093B9, 0xC26F3101},
    {0x000093C3, 0xC26F3701}, {0x000093C8, 0xC26F3A01}, {0x000093D0, 0xC26F3901}, {0x000093D1, 0xC2452D01},
    {0x000093D6, 0xC26F3202}, {0x000093D8, 0xC26F3601}, {0x000093DD, 0xC26F3801}, {0x000093E1, 0xC2364001},
    {0x000093E4, 0xC26F3B01}, {0x000093E5, 0xC26F3501}, {0x000093E8, 0xC26F3401}, {0x00009403, 0xC26F3F01},
    {0x00009407, 0xC26F4001}, {0x00009410, 0xC26F4101}, {0x00009413, 0xC26F3E01}, {0x00009414, 0xC26F3D01},
    {0x00009418, 0xC23E6201}, {0x00009419, 0xC2462A01}, {0x0000941A, 0xC26F3C01}, {0x00009421, 0xC26F4501},
    {0x0000942B, 0xC26F4301}, {0x00009435, 0xC26F4401}, {0x00009436, 0xC26F4201}, {0x00009438, 0xC2427801},
    {0x0000943A, 0xC26F4601}, {0x00009441, 0xC26F4701}, {0x00009444, 0xC26F4901}, {0x00009451, 0xC2345501},
    {0x00009452, 0xC26F4801}, {0x00009453, 0xC24C7A01}, {0x0000945A, 0xC26F5401}, {0x0000945B, 0xC26F4A01},
    {0x0000945E, 0xC26F4D01}, {0x00009460, 0xC26F4B01}, {0x00009462, 0xC26F4C01}, {0x0000946A, 0xC26F4E01},
    {0x00009470, 0xC26F5001}, {0x00009475, 0xC26F5101}, {0x00009477, 0xC26F5201}, {0x0000947C, 0xC26F5501},
    {0x0000947D, 0xC26F5301}, {0x0000947E, 0xC26F5601}, {0x0000947F, 0xC26F5801}, {0x00009481, 0xC26F5701},
    {0x00009577, 0xC2443901}, {0x00009580, 0xC24C6701}, {0x00009582, 0xC26F5901}, {0x00009583, 0xC2412E01},
    {0x00009587, 0xC26F5A01}, {0x00009589, 0xC24A4401}, {0x0000958A, 0xC26F5B01}, {0x0000958B, 0xC2332B01},
    {0x0000958F, 0xC2313C01}, {0x00009591, 0xC2345701}, {0x00009592, 0xC2764301}, {0x00009593, 0xC2345601},
    {0x00009594, 0xC26F5C01}, {0x00009596, 0xC26F5D01}, {0x00009598, 0xC26F5E02}, {0x000095A0, 0xC26F6001},
    {0x000095A2, 0xC2345801}, {0x000095A3, 0xC2335501}, {0x000095A4, 0xC2395E01}, {0x000095A5, 0xC2483601},
    {0x000095A7, 0xC26F6201}, {0x000095A8, 0xC26F6101}, {0x000095AD, 0xC26F6301}, {0x000095B2, 0xC2315C01},
    {0x000095B9, 0xC26F6601}, {0x000095BB, 0xC26F6501}, {0x000095BC, 0xC26F6401}, {0x000095BE, 0xC26F6701},
    {0x000095C3, 0xC26F6A01}, {0x000095C7, 0xC2304701}, {0x000095CA, 0xC26F6801}, {0x000095CC, 0xC26F6C01},
    {0x000095CD, 0xC26F6B01}, {0x000095D4, 0xC26F6E01}, {0x000095D5, 0xC26F6D01}, {0x000095D6, 0xC26F6F01},
    {0x000095D8, 0xC2462E01}, {0x000095DC, 0xC26F7001}, {0x000095E1, 0xC26F7101}, {0x000095E2, 0xC26F7301},
    {0x000095E5, 0xC26F7201}, {0x0000961C, 0xC2496C01}, {0x00009621, 0xC26F7401}, {0x00009628, 0xC26F7501},
    {0x0000962A, 0xC23A6501}, {0x0000962E, 0xC26F7602}, {0x00009632, 0xC24B4901}, {0x0000963B, 0xC2414B01},
    {0x0000963F, 0xC2302401}, {0x00009640, 0xC2424B01}, {0x00009642, 0xC26F7801}, {0x00009644, 0xC2496D01},
    {0x0000964B, 0xC26F7B01}, {0x0000964C, 0xC26F7901}, {0x0000964D, 0xC2395F01}, {0x0000964F, 0xC26F7A01},
    {0x00009650, 0xC2384201}, {0x0000965B, 0xC24A4501}, {0x0000965C, 0xC26F7D01}, {0x0000965D, 0xC2702101},
    {0x0000965E, 0xC26F7E01}, {0x0000965F, 0xC2702201}, {0x00009662, 0xC2312101}, {0x00009663, 0xC23F5801},
    {0x00009664, 0xC23D7C01}, {0x00009665, 0xC2345901}, {0x00009666, 0xC2702301}, {0x0000966A, 0xC2476601},
    {0x0000966C, 0xC2702501}, {0x00009670, 0xC2312201}, {0x00009672, 0xC2702401}, {0x00009673, 0xC2444401},
    {0x00009675, 0xC24E4D01}, {0x00009676, 0xC2462B01}, {0x00009677, 0xC26F7C01}, {0x00009678, 0xC24E2601},
    {0x0000967A, 0xC2383101}, {0x0000967D, 0xC24D5B01}, {0x00009685, 0xC2367901}, {0x00009686, 0xC24E3401},
    {0x00009688, 0xC2372801}, {0x0000968A, 0xC2426201}, {0x0000968B, 0xC2672101}, {0x0000968D, 0xC2702601},
    {0x0000968E, 0xC2332C01}, {0x0000968F, 0xC23F6F01}, {0x00009694, 0xC2335601}, {0x00009695, 0xC2702801},
    {0x00009697, 0xC2702901}, {0x00009698, 0xC2702701}, {0x00009699, 0xC2376401}, {0x0000969B, 0xC23A5D01},
    {0x0000969C, 0xC23E6301}, {0x000096A0, 0xC2312301}, {0x000096A3, 0xC24E5901}, {0x000096A7, 0xC2702B01},
    {0x000096A8, 0xC26E2E01}, {0x000096AA, 0xC2702A01}, {0x000096B0, 0xC2702E01}, {0x000096B1, 0xC2702C02},
    {0x000096B4, 0xC2702F01}, {0x000096B6, 0xC2703001}, {0x000096B7, 0xC24E6C01}, {0x000096B8, 0xC2703102},
    {0x000096BB, 0xC2404901}, {0x000096BC, 0xC2483B01}, {0x000096C0, 0xC23F7D01}, {0x000096C1, 0xC2346701},
    {0x000096C4, 0xC24D3A01}, {0x000096C5, 0xC2326D01}, {0x000096C6, 0xC23D3801}, {0x000096C7, 0xC2385B01},
    {0x000096C9, 0xC2703501}, {0x000096CB, 0xC2703401}, {0x000096CC, 0xC23B7301}, {0x000096CD, 0xC2703601},
    {0x000096CE, 0xC2703301}, {0x000096D1, 0xC23B2801}, {0x000096D5, 0xC2703A01}, {0x000096D6, 0xC26A2D01},
    {0x000096D9, 0xC2525601}, {0x000096DB, 0xC23F7701}, {0x000096DC, 0xC2703801}, {0x000096DE, 0xC2764401},
    {0x000096E2, 0xC24E2501}, {0x000096E3, 0xC2467101}, {0x000096E8, 0xC2312B01}, {0x000096EA, 0xC2406301},
    {0x000096EB, 0xC23C3601}, {0x000096F0, 0xC24A3701}, {0x000096F2, 0xC2314001}, {0x000096F6, 0xC24E6D01},
    {0x000096F7, 0xC24D6B01}, {0x000096F9, 0xC2703B01}, {0x000096FB, 0xC2454501}, {0x00009700, 0xC23C7B01},
    {0x00009704, 0xC2703C01}, {0x00009706, 0xC2703D01}, {0x00009707, 0xC23F4C01}, {0x00009708, 0xC2703E01},
    {0x0000970A, 0xC24E6E01}, {0x0000970D, 0xC2703901}, {0x0000970E, 0xC2704001}, {0x0000970F, 0xC2704201},
    {0x00009711, 0xC2704101}, {0x00009713, 0xC2703F01}, {0x00009716, 0xC2704301}, {0x00009719, 0xC2704401},
    {0x0000971C, 0xC2417A01}, {0x0000971E, 0xC2326201}, {0x00009724, 0xC2704501}, {0x00009727, 0xC24C3801},
    {0x0000972A, 0xC2704601}, {0x00009730, 0xC2704701}, {0x00009732, 0xC24F2A01}, {0x00009738, 0xC25B3101},
    {0x00009739, 0xC2704801}, {0x0000973D, 0xC2704902}, {0x00009742, 0xC2704E01}, {0x00009744, 0xC2704B01},
    {0x00009746, 0xC2704C01}, {0x00009748, 0xC2704D01}, {0x00009749, 0xC2704F01}, {0x00009752, 0xC2404401},
    {0x00009756, 0xC24C7701}, {0x00009759, 0xC2404501}, {0x0000975C, 0xC2705001}, {0x0000975E, 0xC2487301},
    {0x00009760, 0xC2705101}, {0x00009761, 0xC2735301}, {0x00009762, 0xC24C4C01}, {0x00009764, 0xC2705201},
    {0x00009766, 0xC2705301}, {0x00009768, 0xC2705401}, {0x00009769, 0xC2335701}, {0x0000976B, 0xC2705601},
    {0x0000976D, 0xC23F5901}, {0x00009771, 0xC2705701}, {0x00009774, 0xC2372401}, {0x00009779, 0xC2705801},
    {0x0000977A, 0xC2705C01}, {0x0000977C, 0xC2705A01}, {0x00009781, 0xC2705B01}, {0x00009784, 0xC2337301},
    {0x00009785, 0xC2705901}, {0x00009786, 0xC2705D01}, {0x0000978B, 0xC2705E01}, {0x0000978D, 0xC2304801},
    {0x0000978F, 0xC2705F02}, {0x00009798, 0xC23E6401}, {0x0000979C, 0xC2706101}, {0x000097A0, 0xC2354701},
    {0x000097A3, 0xC2706401}, {0x000097A6, 0xC2706301}, {0x000097A8, 0xC2706201}, {0x000097AB, 0xC26B7101},
    {0x000097AD, 0xC24A5C01}, {0x000097B3, 0xC2706502}, {0x000097C3, 0xC2706701}, {0x000097C6, 0xC2706801},
    {0x000097C8, 0xC2706901}, {0x000097CB, 0xC2706A01}, {0x000097D3, 0xC2345A01}, {0x000097DC, 0xC2706B01},
    {0x000097ED, 0xC2706C01}, {0x000097EE, 0xC2472301}, {0x000097F2, 0xC2706E01}, {0x000097F3, 0xC2323B01},
    {0x000097F5, 0xC2707101}, {0x000097F6, 0xC2707001}, {0x000097FB, 0xC2312401}, {0x000097FF, 0xC2364101},
    {0x00009801, 0xC24A4701}, {0x00009802, 0xC2443A01}, {0x00009803, 0xC23A2201}, {0x00009805, 0xC2396001},
    {0x00009806, 0xC23D6701}, {0x00009808, 0xC23F5C01}, {0x0000980C, 0xC2707301}, {0x0000980F, 0xC2707201},
    {0x00009810, 0xC24D4201}, {0x00009811, 0xC2346801}, {0x00009812, 0xC2485201}, {0x00009813, 0xC2465C01},
    {0x00009817, 0xC23F7C01}, {0x00009818, 0xC24E4E01}, {0x0000981A, 0xC2375B01}, {0x00009821, 0xC2707601},
    {0x00009824, 0xC2707501}, {0x0000982C, 0xC24B4B01}, {0x0000982D, 0xC2462C01}, {0x00009834, 0xC2315001},
    {0x00009837, 0xC2707701}, {0x00009838, 0xC2707401}, {0x0000983B, 0xC2495101}, {0x0000983C, 0xC24D6A01},
    {0x0000983D, 0xC2707801}, {0x00009846, 0xC2707901}, {0x0000984B, 0xC2707B01}, {0x0000984C, 0xC2426A01},
    {0x0000984D, 0xC2335B02}, {0x0000984F, 0xC2707A01}, {0x00009854, 0xC2346901}, {0x00009855, 0xC2383201},
    {0x00009858, 0xC2346A01}, {0x0000985B, 0xC2453F01}, {0x0000985E, 0xC24E6001}, {0x00009867, 0xC2385C01},
    {0x0000986B, 0xC2707C01}, {0x0000986F, 0xC2707D02}, {0x00009871, 0xC2712101}, {0x00009873, 0xC2712301},
    {0x00009874, 0xC2712201}, {0x000098A8, 0xC2497701}, {0x000098AA, 0xC2712401}, {0x000098AF, 0xC2712501},
    {0x000098B1, 0xC2712601}, {0x000098B6, 0xC2712701}, {0x000098C3, 0xC2712901}, {0x000098C4, 0xC2712801},
    {0x000098C6, 0xC2712A01}, {0x000098DB, 0xC2487401}, {0x000098DC, 0xC2664C01}, {0x000098DF, 0xC23F2901},
    {0x000098E2, 0xC2353201}, {0x000098E9, 0xC2712B01}, {0x000098EB, 0xC2712C01}, {0x000098ED, 0xC2522C01},
    {0x000098EE, 0xC25D3B01}, {0x000098EF, 0xC2485301}, {0x000098F2, 0xC2307B01}, {0x000098F4, 0xC2303B01},
    {0x000098FC, 0xC23B7401}, {0x000098FD, 0xC24B3001}, {0x000098FE, 0xC23E7E01}, {0x00009903, 0xC2712D01},
    {0x00009905, 0xC24C5F01}, {0x00009909, 0xC2712E01}, {0x0000990A, 0xC24D5C01}, {0x0000990C, 0xC2314201},
    {0x00009910, 0xC23B4101}, {0x00009912, 0xC2712F01}, {0x00009913, 0xC2326E01}, {0x00009914, 0xC2713001},
    {0x00009918, 0xC2713101}, {0x0000991D, 0xC2713302}, {0x00009920, 0xC2713601}, {0x00009921, 0xC2713201},
    {0x00009924, 0xC2713501}, {0x00009928, 0xC2345B01}, {0x0000992C, 0xC2713701}, {0x0000992E, 0xC2713801},
    {0x0000993D, 0xC2713902}, {0x00009940, 0xC2764601}, {0x00009942, 0xC2713B01}, {0x00009945, 0xC2713D01},
    {0x00009949, 0xC2713C01}, {0x0000994B, 0xC2713F01}, {0x0000994C, 0xC2714201}, {0x00009950, 0xC2713E01},
    {0x00009951, 0xC2714002}, {0x00009955, 0xC2714301}, {0x00009957, 0xC2364201}, {0x00009996, 0xC23C7301},
    {0x00009997, 0xC2714402}, {0x00009999, 0xC2396101}, {0x000099A5, 0xC2714601}, {0x000099A8, 0xC2333E01},
    {0x000099AC, 0xC2474F01}, {0x000099AD, 0xC2714702}, {0x000099B3, 0xC2435A01}, {0x000099B4, 0xC2466B01},
    {0x000099BC, 0xC2714901}, {0x000099C1, 0xC2477D01}, {0x000099C4, 0xC2424C01}, {0x000099C5, 0xC2315801},
    {0x000099C6, 0xC2366E01}, {0x000099C8, 0xC2366F01}, {0x000099D0, 0xC2437301}, {0x000099D1, 0xC2714E01},
    {0x000099D2, 0xC2367001}, {0x000099D5, 0xC2326F01}, {0x000099D8, 0xC2714D01}, {0x000099DB, 0xC2714B01},
    {0x000099DD, 0xC2714C01}, {0x000099DF, 0xC2714A01}, {0x000099E2, 0xC2715801}, {0x000099ED, 0xC2714F02},
    {0x000099F1, 0xC2715102}, {0x000099F8, 0xC2715401}, {0x000099FB, 0xC2715301}, {0x000099FF, 0xC23D5901},
    {0x00009A01, 0xC2715501}, {0x00009A05, 0xC2715701}, {0x00009A0E, 0xC2353301}, {0x00009A0F, 0xC2715601},
    {0x00009A12, 0xC2417B01}, {0x00009A13, 0xC2383301}, {0x00009A19, 0xC2715901}, {0x00009A28, 0xC2424D01},
    {0x00009A2B, 0xC2715A01}, {0x00009A30, 0xC2462D01}, {0x00009A37, 0xC2715B01}, {0x00009A3E, 0xC2716001},
    {0x00009A40, 0xC2715E01}, {0x00009A42, 0xC2715D01}, {0x00009A43, 0xC2715F01}, {0x00009A45, 0xC2715C01},
    {0x00009A4D, 0xC2716201}, {0x00009A55, 0xC2716101}, {0x00009A57, 0xC2716401}, {0x00009A5A, 0xC2364301},
    {0x00009A5B, 0xC2716301}, {0x00009A5F, 0xC2716501}, {0x00009A62, 0xC2716601}, {0x00009A64, 0xC2716801},
    {0x00009A65, 0xC2716701}, {0x00009A69, 0xC2716901}, {0x00009A6A, 0xC2716B01}, {0x00009A6B, 0xC2716A01},
    {0x00009AA8, 0xC2397C01}, {0x00009AAD, 0xC2716C01}, {0x00009AB0, 0xC2716D01}, {0x00009AB8, 0xC2333C01},
    {0x00009ABC, 0xC2716E01}, {0x00009AC0, 0xC2716F01}, {0x00009AC4, 0xC23F7101}, {0x00009ACF, 0xC2717001},
    {0x00009AD1, 0xC2717101}, {0x00009AD3, 0xC2717202}, {0x00009AD8, 0xC2396201}, {0x00009AD9, 0xC2764701},
    {0x00009ADE, 0xC2717402}, {0x00009AE2, 0xC2717602}, {0x00009AE6, 0xC2717801}, {0x00009AEA, 0xC2483101},
    {0x00009AEB, 0xC2717A01}, {0x00009AED, 0xC2492601}, {0x00009AEE, 0xC2717B01}, {0x00009AEF, 0xC2717901},
    {0x00009AF1, 0xC2717D01}, {0x00009AF4, 0xC2717C01}, {0x00009AF7, 0xC2717E01}, {0x00009AFB, 0xC2722101},
    {0x00009B06, 0xC2722201}, {0x00009B18, 0xC2722301}, {0x00009B1A, 0xC2722401}, {0x00009B1F, 0xC2722501},
    {0x00009B22, 0xC2722602}, {0x00009B25, 0xC2722801}, {0x00009B27, 0xC2722904}, {0x00009B2E, 0xC2722D02},
    {0x00009B31, 0xC25D3501}, {0x00009B32, 0xC2722F01}, {0x00009B3B, 0xC2647801}, {0x00009B3C, 0xC2353401},
    {0x00009B41, 0xC2332101}, {0x00009B42, 0xC23A3201}, {0x00009B43, 0xC2723101}, {0x00009B44, 0xC2723001},
    {0x00009B45, 0xC24C2501}, {0x00009B4D, 0xC2723302}, {0x00009B4F, 0xC2723201}, {0x00009B51, 0xC2723501},
    {0x00009B54, 0xC24B6201}, {0x00009B58, 0xC2723601}, {0x00009B5A, 0xC2357B01}, {0x00009B6F, 0xC24F2501},
    {0x00009B74, 0xC2723701}, {0x00009B83, 0xC2723901}, {0x00009B8E, 0xC2303E01}, {0x00009B91, 0xC2723A01},
    {0x00009B92, 0xC24A2B01}, {0x00009B93, 0xC2723801}, {0x00009B96, 0xC2723B02}, {0x00009B9F, 0xC2723D02},
    {0x00009BA8, 0xC2723F01}, {0x00009BAA, 0xC24B6E01}, {0x00009BAB, 0xC23B2D01}, {0x00009BAD, 0xC23A7A01},
    {0x00009BAE, 0xC2412F01}, {0x00009BB4, 0xC2724001}, {0x00009BB9, 0xC2724301}, {0x00009BC0, 0xC2724101},
    {0x00009BC6, 0xC2724401}, {0x00009BC9, 0xC2387101}, {0x00009BCA, 0xC2724201}, {0x00009BCF, 0xC2724501},
    {0x00009BD1, 0xC2724602}, {0x00009BD4, 0xC2724B01}, {0x00009BD6, 0xC23B2A01}, {0x00009BDB, 0xC2426401},
    {0x00009BE1, 0xC2724C01}, {0x00009BE2, 0xC2724901}, {0x00009BE3, 0xC2724801}, {0x00009BE4, 0xC2724A01},
    {0x00009BE8, 0xC2375F01}, {0x00009BF0, 0xC2725001}, {0x00009BF1, 0xC2724F01}, {0x00009BF2, 0xC2724E01},
    {0x00009BF5, 0xC2303301}, {0x00009C04, 0xC2725A01}, {0x00009C06, 0xC2725601}, {0x00009C08, 0xC2725701},
    {0x00009C09, 0xC2725301}, {0x00009C0A, 0xC2725901}, {0x00009C0C, 0xC2725501}, {0x00009C0D, 0xC2336201},
    {0x00009C10, 0xC24F4C01}, {0x00009C12, 0xC2725801}, {0x00009C13, 0xC2725401}, {0x00009C14, 0xC2725201},
    {0x00009C15, 0xC2725101}, {0x00009C1B, 0xC2725C01}, {0x00009C21, 0xC2725F01}, {0x00009C24, 0xC2725E01},
    {0x00009C25, 0xC2725D01}, {0x00009C2D, 0xC2494901}, {0x00009C2E, 0xC2725B01}, {0x00009C2F, 0xC2307301},
    {0x00009C30, 0xC2726001}, {0x00009C32, 0xC2726201}, {0x00009C39, 0xC2336F01}, {0x00009C3A, 0xC2724D01},
    {0x00009C3B, 0xC2313701}, {0x00009C3E, 0xC2726401}, {0x00009C46, 0xC2726301}, {0x00009C47, 0xC2726101},
    {0x00009C48, 0xC2432D01}, {0x00009C52, 0xC24B7001}, {0x00009C57, 0xC24E5A01}, {0x00009C5A, 0xC2726501},
    {0x00009C60, 0xC2726601}, {0x00009C67, 0xC2726701}, {0x00009C76, 0xC2726801}, {0x00009C78, 0xC2726901},
    {0x00009CE5, 0xC2443B01}, {0x00009CE7, 0xC2726A01}, {0x00009CE9, 0xC2483701}, {0x00009CEB, 0xC2726F01},
    {0x00009CEC, 0xC2726B01}, {0x00009CF0, 0xC2726C01}, {0x00009CF3, 0xC24B3101}, {0x00009CF4, 0xC24C4401},
    {0x00009CF6, 0xC2465001}, {0x00009D03, 0xC2727001}, {0x00009D06, 0xC2727101}, {0x00009D07, 0xC2463E01},
    {0x00009D08, 0xC2726E01}, {0x00009D09, 0xC2726D01}, {0x00009D0E, 0xC2322A01}, {0x00009D12, 0xC2727901},
    {0x00009D15, 0xC2727801}, {0x00009D1B, 0xC2317501}, {0x00009D1F, 0xC2727601}, {0x00009D23, 0xC2727501},
    {0x00009D26, 0xC2727301}, {0x00009D28, 0xC2337B01}, {0x00009D2A, 0xC2727201}, {0x00009D2B, 0xC23C3201},
    {0x00009D2C, 0xC2322901}, {0x00009D3B, 0xC2396301}, {0x00009D3E, 0xC2727C01}, {0x00009D3F, 0xC2727B01},
    {0x00009D41, 0xC2727A01}, {0x00009D44, 0xC2727701}, {0x00009D46, 0xC2727D01}, {0x00009D48, 0xC2727E01},
    {0x00009D50, 0xC2732501}, {0x00009D51, 0xC2732401}, {0x00009D59, 0xC2732601}, {0x00009D5C, 0xC2312D01},
    {0x00009D5D, 0xC2732102}, {0x00009D60, 0xC2397401}, {0x00009D61, 0xC24C3901}, {0x00009D64, 0xC2732301},
    {0x00009D6C, 0xC24B3201}, {0x00009D6F, 0xC2732B01}, {0x00009D72, 0xC2732701}, {0x00009D7A, 0xC2732C01},
    {0x00009D87, 0xC2732901}, {0x00009D89, 0xC2732801}, {0x00009D8F, 0xC2375C01}, {0x00009D9A, 0xC2732D01},
    {0x00009DA4, 0xC2732E01}, {0x00009DA9, 0xC2732F01}, {0x00009DAB, 0xC2732A01}, {0x00009DAF, 0xC2727401},
    {0x00009DB2, 0xC2733001}, {0x00009DB4, 0xC2446101}, {0x00009DB8, 0xC2733401}, {0x00009DBA, 0xC2733501},
    {0x00009DBB, 0xC2733301}, {0x00009DC1, 0xC2733201}, {0x00009DC2, 0xC2733801}, {0x00009DC4, 0xC2733101},
    {0x00009DC6, 0xC2733601}, {0x00009DCF, 0xC2733701}, {0x00009DD3, 0xC2733A01}, {0x00009DD7, 0xC2764901},
    {0x00009DD9, 0xC2733901}, {0x00009DE6, 0xC2733C01}, {0x00009DED, 0xC2733D01}, {0x00009DEF, 0xC2733E01},
    {0x00009DF2, 0xC24F4901}, {0x00009DF8, 0xC2733B01}, {0x00009DF9, 0xC2426B01}, {0x00009DFA, 0xC23A6D01},
    {0x00009DFD, 0xC2733F01}, {0x00009E1A, 0xC2734002}, {0x00009E1E, 0xC2734201}, {0x00009E75, 0xC2734301},
    {0x00009E78, 0xC2383401}, {0x00009E79, 0xC2734401}, {0x00009E7D, 0xC2734501}, {0x00009E7F, 0xC23C2F01},
    {0x00009E81, 0xC2734601}, {0x00009E88, 0xC2734701}, {0x00009E8B, 0xC2734802}, {0x00009E91, 0xC2734C01},
    {0x00009E92, 0xC2734A01}, {0x00009E93, 0xC24F3C01}, {0x00009E95, 0xC2734B01}, {0x00009E97, 0xC24E6F01},
    {0x00009E9D, 0xC2734D01}, {0x00009E9F, 0xC24E5B01}, {0x00009EA5, 0xC2734E01}, {0x00009EA6, 0xC2477E01},
    {0x00009EA9, 0xC2734F01}, {0x00009EAA, 0xC2735101}, {0x00009EAD, 0xC2735201}, {0x00009EB4, 0xC2764A02},
    {0x00009EB8, 0xC2735001}, {0x00009EB9, 0xC2396D01}, {0x00009EBA, 0xC24C4D01}, {0x00009EBB, 0xC24B6301},
    {0x00009EBC, 0xC2567701}, {0x00009EBE, 0xC25D6001}, {0x00009EBF, 0xC24B7B01}, {0x00009EC4, 0xC2322B01},
    {0x00009ECC, 0xC2735401}, {0x00009ECD, 0xC2355001}, {0x00009ECE, 0xC2735503}, {0x00009ED2, 0xC2397501},
    {0x00009ED4, 0xC2735801}, {0x00009ED8, 0xC2605401}, {0x00009ED9, 0xC24C5B01}, {0x00009EDB, 0xC2426301},
    {0x00009EDC, 0xC2735901}, {0x00009EDD, 0xC2735B01}, {0x00009EDE, 0xC2735A01}, {0x00009EE0, 0xC2735C01},
    {0x00009EE5, 0xC2735D01}, {0x00009EE8, 0xC2735E01}, {0x00009EEF, 0xC2735F01}, {0x00009EF4, 0xC2736001},
    {0x00009EF6, 0xC2736102}, {0x00009EF9, 0xC2736301}, {0x00009EFB, 0xC2736403}, {0x00009F07, 0xC2736702},
    {0x00009F0E, 0xC2452401}, {0x00009F13, 0xC2385D01}, {0x00009F15, 0xC2736A01}, {0x00009F20, 0xC2414D01},
    {0x00009F21, 0xC2736B01}, {0x00009F2C, 0xC2736C01}, {0x00009F3B, 0xC2492101}, {0x00009F3E, 0xC2736D01},
    {0x00009F4A, 0xC2736E01}, {0x00009F4B, 0xC2633701}, {0x00009F4E, 0xC26C5A01}, {0x00009F4F, 0xC2706D01},
    {0x00009F52, 0xC2736F01}, {0x00009F54, 0xC2737001}, {0x00009F5F, 0xC2737203}, {0x00009F62, 0xC24E7001},
    {0x00009F63, 0xC2737101}, {0x00009F66, 0xC2737502}, {0x00009F6A, 0xC2737801}, {0x00009F6C, 0xC2737701},
    {0x00009F72, 0xC2737A01}, {0x00009F76, 0xC2737B01}, {0x00009F77, 0xC2737901}, {0x00009F8D, 0xC24E3601},
    {0x00009F95, 0xC2737C01}, {0x00009F9C, 0xC2737D01}, {0x00009F9D, 0xC2635401}, {0x00009FA0, 0xC2737E01},
    {0x00009FC4, 0xC2754F01}, {0x00009FC5, 0xC2762101}, {0x00009FC6, 0xC2757D01}, {0x0000E0C9, 0xB97A2106},
    {0x0000E0D0, 0xB97A2804}, {0x0000E0D8, 0xB97A3002}, {0x0000E0DC, 0xB97A3415}, {0x0000E0F8, 0xB97A5008},
    {0x0000E180, 0xB97A581B}, {0x0000E19C, 0xB97A7401}, {0x0000E1A7, 0xB97B2107}, {0x0000E1B0, 0xB97B2A03},
    {0x0000E1B4, 0xB97B2E02}, {0x0000E1B8, 0xB97B3203}, {0x0000E1BE, 0xB97B3806}, {0x0000E1C6, 0xB97B400B},
    {0x0000E1D2, 0xB97B4C06}, {0x0000E28F, 0xB97C3001}, {0x0000E290, 0xB97C3A10}, {0x0000E2A0, 0xB97C4F01},
    {0x0000E2A1, 0xB97C5401}, {0x0000E2A4, 0xB97C571F}, {0x0000E2C3, 0xB97C7803}, {0x0000E2CC, 0xB97D3017},
    {0x0000E2E5, 0xB97D5101}, {0x0000E2E6, 0xB97D5C01}, {0x0000E2E7, 0xB97D5E02}, {0x0000E2F9, 0xB97D7802},
    {0x0000FA10, 0xC2753A01}, {0x0000FA11, 0xC2754001}, {0x0000FA45, 0xC2755B01}, {0x0000FA46, 0xC2755F01},
    {0x0000FA4A, 0xC2756E01}, {0x0000FA6B, 0xC2754701}, {0x0000FA6C, 0xC2756301}, {0x0000FA6D, 0xC2762B01},
    {0x0000FF01, 0xC2212A01}, {0x0000FF03, 0xC2217401}, {0x0000FF04, 0xC2217001}, {0x0000FF05, 0xC2217301},
    {0x0000FF06, 0xC2217501}, {0x0000FF08, 0xC2214A02}, {0x0000FF0A, 0xC2217601}, {0x0000FF0B, 0xC2215C01},
    {0x0000FF0C, 0xC2212401}, {0x0000FF0D, 0xC2215D01}, {0x0000FF0E, 0xC2212501}, {0x0000FF0F, 0xC2213F01},
    {0x0000FF10, 0xC223300A}, {0x0000FF1A, 0xC2212702}, {0x0000FF1C, 0xC2216301}, {0x0000FF1D, 0xC2216101},
    {0x0000FF1E, 0xC2216401}, {0x0000FF1F, 0xC2212901}, {0x0000FF20, 0xC2217701}, {0x0000FF21, 0xC223411A},
    {0x0000FF3B, 0xC2214E01}, {0x0000FF3D, 0xC2214F01}, {0x0000FF3E, 0xC2213001}, {0x0000FF3F, 0xC2213201},
    {0x0000FF40, 0xC2212E01}, {0x0000FF41, 0xC223611A}, {0x0000FF5B, 0xC2215001}, {0x0000FF5C, 0xC2214301},
    {0x0000FF5D, 0xC2215101}, {0x0000FF61, 0x4921213F}, {0x0000FFE3, 0xC2213101}, {0x0000FFE5, 0xC2216F01},
    {0x0001F100, 0xC27C3001}, {0x0001F101, 0xC27C400A}, {0x0001F110, 0xC27E411A}, {0x0001F12A, 0xC27D3A01},
    {0x0001F12B, 0xC27C7701}, {0x0001F12C, 0xC27C7601}, {0x0001F12D, 0xC27C5701}, {0x0001F131, 0xC27A5E01},
    {0x0001F13D, 0xC27A5F01}, {0x0001F13F, 0xC27A5201}, {0x0001F142, 0xC27A5901}, {0x0001F146, 0xC27A5301},
    {0x0001F14A, 0xC27A5001}, {0x0001F14B, 0xC27A5401}, {0x0001F14C, 0xC27A5101}, {0x0001F14D, 0xC27A5D01},
    {0x0001F14E, 0xC27A7201}, {0x0001F157, 0xC27B3D01}, {0x0001F15F, 0xC27B4101}, {0x0001F179, 0xC27B4501},
    {0x0001F17B, 0xC27B4A01}, {0x0001F17C, 0xC27B5001}, {0x0001F17F, 0xC27A3001}, {0x0001F18A, 0xC27A3101},
    {0x0001F18B, 0xC27B4201}, {0x0001F18C, 0xC27B4401}, {0x0001F18D, 0xC27B4301}, {0x0001F190, 0xC27C7901},
    {0x0001F200, 0xC27A7401}, {0x0001F210, 0xC27A5504}, {0x0001F214, 0xC27A5A03}, {0x0001F217, 0xC27A6205},
    {0x0001F21C, 0xC27A680A}, {0x0001F226, 0xC27C7A01}, {0x0001F227, 0xC27D3B03}, {0x0001F22A, 0xC27D3F08},
    {0x0001F240, 0xC27D3109}, {0x00020158, 0xC2752201}, {0x00020BB7, 0xC2752F01}, {0x000233CC, 0xC2755501},
    {0x000233FE, 0xC2755601}, {0x000235C4, 0xC2755701}, {0x000242EE, 0xC2756401},
};

// Number of encodable characters: 7701
// Number of slices of contiguous Unicode points: 6647
// Number of single-character slices: 6390
// Maximum slice size: 86
