#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2021
#define LARGE_STATE_COUNT 496
#define SYMBOL_COUNT 348
#define ALIAS_COUNT 3
#define TOKEN_COUNT 155
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 132

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym___extension__ = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym_COLON_COLON = 47,
  anon_sym_LBRACK_LBRACK = 48,
  anon_sym_RBRACK_RBRACK = 49,
  anon_sym___declspec = 50,
  anon_sym___based = 51,
  anon_sym___cdecl = 52,
  anon_sym___clrcall = 53,
  anon_sym___stdcall = 54,
  anon_sym___fastcall = 55,
  anon_sym___thiscall = 56,
  anon_sym___vectorcall = 57,
  sym_ms_restrict_modifier = 58,
  sym_ms_unsigned_ptr_modifier = 59,
  sym_ms_signed_ptr_modifier = 60,
  anon_sym__unaligned = 61,
  anon_sym___unaligned = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_signed = 65,
  anon_sym_unsigned = 66,
  anon_sym_long = 67,
  anon_sym_short = 68,
  anon_sym_LBRACK = 69,
  anon_sym_RBRACK = 70,
  anon_sym_EQ = 71,
  anon_sym_static = 72,
  anon_sym_auto = 73,
  anon_sym_register = 74,
  anon_sym_inline = 75,
  anon_sym___inline = 76,
  anon_sym___inline__ = 77,
  anon_sym___forceinline = 78,
  anon_sym_thread_local = 79,
  anon_sym___thread = 80,
  anon_sym_const = 81,
  anon_sym_constexpr = 82,
  anon_sym_volatile = 83,
  anon_sym_restrict = 84,
  anon_sym___restrict__ = 85,
  anon_sym__Atomic = 86,
  anon_sym__Noreturn = 87,
  anon_sym_noreturn = 88,
  sym_primitive_type = 89,
  anon_sym_enum = 90,
  anon_sym_COLON = 91,
  anon_sym_struct = 92,
  anon_sym_union = 93,
  anon_sym_if = 94,
  anon_sym_else = 95,
  anon_sym_switch = 96,
  anon_sym_case = 97,
  anon_sym_default = 98,
  anon_sym_while = 99,
  anon_sym_do = 100,
  anon_sym_for = 101,
  anon_sym_return = 102,
  anon_sym_break = 103,
  anon_sym_continue = 104,
  anon_sym_goto = 105,
  anon_sym___try = 106,
  anon_sym___except = 107,
  anon_sym___finally = 108,
  anon_sym___leave = 109,
  anon_sym_QMARK = 110,
  anon_sym_STAR_EQ = 111,
  anon_sym_SLASH_EQ = 112,
  anon_sym_PERCENT_EQ = 113,
  anon_sym_PLUS_EQ = 114,
  anon_sym_DASH_EQ = 115,
  anon_sym_LT_LT_EQ = 116,
  anon_sym_GT_GT_EQ = 117,
  anon_sym_AMP_EQ = 118,
  anon_sym_CARET_EQ = 119,
  anon_sym_PIPE_EQ = 120,
  anon_sym_DASH_DASH = 121,
  anon_sym_PLUS_PLUS = 122,
  anon_sym_sizeof = 123,
  anon_sym___alignof__ = 124,
  anon_sym___alignof = 125,
  anon_sym__alignof = 126,
  anon_sym_alignof = 127,
  anon_sym__Alignof = 128,
  anon_sym_offsetof = 129,
  anon_sym__Generic = 130,
  anon_sym_asm = 131,
  anon_sym___asm__ = 132,
  anon_sym_DOT = 133,
  anon_sym_DASH_GT = 134,
  sym_number_literal = 135,
  anon_sym_L_SQUOTE = 136,
  anon_sym_u_SQUOTE = 137,
  anon_sym_U_SQUOTE = 138,
  anon_sym_u8_SQUOTE = 139,
  anon_sym_SQUOTE = 140,
  aux_sym_char_literal_token1 = 141,
  anon_sym_L_DQUOTE = 142,
  anon_sym_u_DQUOTE = 143,
  anon_sym_U_DQUOTE = 144,
  anon_sym_u8_DQUOTE = 145,
  anon_sym_DQUOTE = 146,
  aux_sym_string_literal_token1 = 147,
  sym_escape_sequence = 148,
  sym_system_lib_string = 149,
  sym_true = 150,
  sym_false = 151,
  anon_sym_NULL = 152,
  anon_sym_nullptr = 153,
  sym_comment = 154,
  sym_translation_unit = 155,
  sym_preproc_include = 156,
  sym_preproc_def = 157,
  sym_preproc_function_def = 158,
  sym_preproc_params = 159,
  sym_preproc_call = 160,
  sym_preproc_if = 161,
  sym_preproc_ifdef = 162,
  sym_preproc_else = 163,
  sym_preproc_elif = 164,
  sym_preproc_elifdef = 165,
  sym_preproc_if_in_field_declaration_list = 166,
  sym_preproc_ifdef_in_field_declaration_list = 167,
  sym_preproc_else_in_field_declaration_list = 168,
  sym_preproc_elif_in_field_declaration_list = 169,
  sym_preproc_elifdef_in_field_declaration_list = 170,
  sym_preproc_if_in_enumerator_list = 171,
  sym_preproc_ifdef_in_enumerator_list = 172,
  sym_preproc_else_in_enumerator_list = 173,
  sym_preproc_elif_in_enumerator_list = 174,
  sym_preproc_elifdef_in_enumerator_list = 175,
  sym_preproc_if_in_enumerator_list_no_comma = 176,
  sym_preproc_ifdef_in_enumerator_list_no_comma = 177,
  sym_preproc_else_in_enumerator_list_no_comma = 178,
  sym_preproc_elif_in_enumerator_list_no_comma = 179,
  sym_preproc_elifdef_in_enumerator_list_no_comma = 180,
  sym__preproc_expression = 181,
  sym_preproc_parenthesized_expression = 182,
  sym_preproc_defined = 183,
  sym_preproc_unary_expression = 184,
  sym_preproc_call_expression = 185,
  sym_preproc_argument_list = 186,
  sym_preproc_binary_expression = 187,
  sym_function_definition = 188,
  sym__old_style_function_definition = 189,
  sym_declaration = 190,
  sym_type_definition = 191,
  sym__type_definition_type = 192,
  sym__type_definition_declarators = 193,
  sym__declaration_modifiers = 194,
  sym__declaration_specifiers = 195,
  sym_linkage_specification = 196,
  sym_attribute_specifier = 197,
  sym_attribute = 198,
  sym_attribute_declaration = 199,
  sym_ms_declspec_modifier = 200,
  sym_ms_based_modifier = 201,
  sym_ms_call_modifier = 202,
  sym_ms_unaligned_ptr_modifier = 203,
  sym_ms_pointer_modifier = 204,
  sym_declaration_list = 205,
  sym__declarator = 206,
  sym__declaration_declarator = 207,
  sym__field_declarator = 208,
  sym__type_declarator = 209,
  sym__abstract_declarator = 210,
  sym_parenthesized_declarator = 211,
  sym_parenthesized_field_declarator = 212,
  sym_parenthesized_type_declarator = 213,
  sym_abstract_parenthesized_declarator = 214,
  sym_attributed_declarator = 215,
  sym_attributed_field_declarator = 216,
  sym_attributed_type_declarator = 217,
  sym_pointer_declarator = 218,
  sym_pointer_field_declarator = 219,
  sym_pointer_type_declarator = 220,
  sym_abstract_pointer_declarator = 221,
  sym_function_declarator = 222,
  sym__function_declaration_declarator = 223,
  sym_function_field_declarator = 224,
  sym_function_type_declarator = 225,
  sym_abstract_function_declarator = 226,
  sym__old_style_function_declarator = 227,
  sym_array_declarator = 228,
  sym_array_field_declarator = 229,
  sym_array_type_declarator = 230,
  sym_abstract_array_declarator = 231,
  sym_init_declarator = 232,
  sym_compound_statement = 233,
  sym_storage_class_specifier = 234,
  sym_type_qualifier = 235,
  sym__type_specifier = 236,
  sym_sized_type_specifier = 237,
  sym_enum_specifier = 238,
  sym_enumerator_list = 239,
  sym_struct_specifier = 240,
  sym_union_specifier = 241,
  sym_field_declaration_list = 242,
  sym__field_declaration_list_item = 243,
  sym_field_declaration = 244,
  sym__field_declaration_declarator = 245,
  sym_bitfield_clause = 246,
  sym_enumerator = 247,
  sym_variadic_parameter = 248,
  sym_parameter_list = 249,
  sym__old_style_parameter_list = 250,
  sym_parameter_declaration = 251,
  sym_attributed_statement = 252,
  sym_labeled_statement = 253,
  sym__top_level_expression_statement = 254,
  sym_expression_statement = 255,
  sym_if_statement = 256,
  sym_else_clause = 257,
  sym_switch_statement = 258,
  sym_case_statement = 259,
  sym_while_statement = 260,
  sym_do_statement = 261,
  sym_for_statement = 262,
  sym__for_statement_body = 263,
  sym_return_statement = 264,
  sym_break_statement = 265,
  sym_continue_statement = 266,
  sym_goto_statement = 267,
  sym_seh_try_statement = 268,
  sym_seh_except_clause = 269,
  sym_seh_finally_clause = 270,
  sym_seh_leave_statement = 271,
  sym__expression = 272,
  sym__expression_not_binary = 273,
  sym__string = 274,
  sym_comma_expression = 275,
  sym_conditional_expression = 276,
  sym_assignment_expression = 277,
  sym_pointer_expression = 278,
  sym_unary_expression = 279,
  sym_binary_expression = 280,
  sym_update_expression = 281,
  sym_cast_expression = 282,
  sym_type_descriptor = 283,
  sym_sizeof_expression = 284,
  sym_alignof_expression = 285,
  sym_offsetof_expression = 286,
  sym_generic_expression = 287,
  sym_subscript_expression = 288,
  sym_call_expression = 289,
  sym_gnu_asm_expression = 290,
  sym_gnu_asm_qualifier = 291,
  sym_gnu_asm_output_operand_list = 292,
  sym_gnu_asm_output_operand = 293,
  sym_gnu_asm_input_operand_list = 294,
  sym_gnu_asm_input_operand = 295,
  sym_gnu_asm_clobber_list = 296,
  sym_gnu_asm_goto_list = 297,
  sym_argument_list = 298,
  sym_field_expression = 299,
  sym_compound_literal_expression = 300,
  sym_parenthesized_expression = 301,
  sym_initializer_list = 302,
  sym_initializer_pair = 303,
  sym_subscript_designator = 304,
  sym_subscript_range_designator = 305,
  sym_field_designator = 306,
  sym_char_literal = 307,
  sym_concatenated_string = 308,
  sym_string_literal = 309,
  sym_null = 310,
  sym__empty_declaration = 311,
  sym_macro_type_specifier = 312,
  aux_sym_translation_unit_repeat1 = 313,
  aux_sym_preproc_params_repeat1 = 314,
  aux_sym_preproc_if_repeat1 = 315,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 316,
  aux_sym_preproc_if_in_enumerator_list_repeat1 = 317,
  aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1 = 318,
  aux_sym_preproc_argument_list_repeat1 = 319,
  aux_sym__old_style_function_definition_repeat1 = 320,
  aux_sym_declaration_repeat1 = 321,
  aux_sym_type_definition_repeat1 = 322,
  aux_sym__type_definition_type_repeat1 = 323,
  aux_sym__type_definition_declarators_repeat1 = 324,
  aux_sym__declaration_specifiers_repeat1 = 325,
  aux_sym_attribute_declaration_repeat1 = 326,
  aux_sym_attributed_declarator_repeat1 = 327,
  aux_sym_pointer_declarator_repeat1 = 328,
  aux_sym_function_declarator_repeat1 = 329,
  aux_sym_sized_type_specifier_repeat1 = 330,
  aux_sym_enumerator_list_repeat1 = 331,
  aux_sym__field_declaration_declarator_repeat1 = 332,
  aux_sym_parameter_list_repeat1 = 333,
  aux_sym__old_style_parameter_list_repeat1 = 334,
  aux_sym_case_statement_repeat1 = 335,
  aux_sym_generic_expression_repeat1 = 336,
  aux_sym_gnu_asm_expression_repeat1 = 337,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 338,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 339,
  aux_sym_gnu_asm_clobber_list_repeat1 = 340,
  aux_sym_gnu_asm_goto_list_repeat1 = 341,
  aux_sym_argument_list_repeat1 = 342,
  aux_sym_initializer_list_repeat1 = 343,
  aux_sym_initializer_pair_repeat1 = 344,
  aux_sym_char_literal_repeat1 = 345,
  aux_sym_concatenated_string_repeat1 = 346,
  aux_sym_string_literal_repeat1 = 347,
  alias_sym_field_identifier = 348,
  alias_sym_statement_identifier = 349,
  alias_sym_type_identifier = 350,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym___extension__] = "__extension__",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_static] = "static",
  [anon_sym_auto] = "auto",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym___inline] = "__inline",
  [anon_sym___inline__] = "__inline__",
  [anon_sym___forceinline] = "__forceinline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym___thread] = "__thread",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_COLON] = ":",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym___try] = "__try",
  [anon_sym___except] = "__except",
  [anon_sym___finally] = "__finally",
  [anon_sym___leave] = "__leave",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym___alignof__] = "__alignof__",
  [anon_sym___alignof] = "__alignof",
  [anon_sym__alignof] = "_alignof",
  [anon_sym_alignof] = "alignof",
  [anon_sym__Alignof] = "_Alignof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_translation_unit] = "translation_unit",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym_preproc_elifdef_in_field_declaration_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list_no_comma] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list_no_comma] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list_no_comma] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = "preproc_elifdef",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym__old_style_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__type_definition_type] = "_type_definition_type",
  [sym__type_definition_declarators] = "_type_definition_declarators",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__declaration_declarator] = "_declaration_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym__function_declaration_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym__old_style_function_declarator] = "function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym__type_specifier] = "_type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym__field_declaration_declarator] = "_field_declaration_declarator",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_parameter_list] = "parameter_list",
  [sym__old_style_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_body] = "_for_statement_body",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_seh_try_statement] = "seh_try_statement",
  [sym_seh_except_clause] = "seh_except_clause",
  [sym_seh_finally_clause] = "seh_finally_clause",
  [sym_seh_leave_statement] = "seh_leave_statement",
  [sym__expression] = "_expression",
  [sym__expression_not_binary] = "_expression_not_binary",
  [sym__string] = "_string",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_alignof_expression] = "alignof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_subscript_range_designator] = "subscript_range_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_macro_type_specifier] = "macro_type_specifier",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = "preproc_if_in_enumerator_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = "preproc_if_in_enumerator_list_no_comma_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym__old_style_function_definition_repeat1] = "_old_style_function_definition_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__type_definition_type_repeat1] = "_type_definition_type_repeat1",
  [aux_sym__type_definition_declarators_repeat1] = "_type_definition_declarators_repeat1",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_function_declarator_repeat1] = "function_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym__field_declaration_declarator_repeat1] = "_field_declaration_declarator_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym__old_style_parameter_list_repeat1] = "_old_style_parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_char_literal_repeat1] = "char_literal_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym___extension__] = anon_sym___extension__,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_auto] = anon_sym_auto,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym___inline] = anon_sym___inline,
  [anon_sym___inline__] = anon_sym___inline__,
  [anon_sym___forceinline] = anon_sym___forceinline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym___thread] = anon_sym___thread,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym___try] = anon_sym___try,
  [anon_sym___except] = anon_sym___except,
  [anon_sym___finally] = anon_sym___finally,
  [anon_sym___leave] = anon_sym___leave,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym___alignof__] = anon_sym___alignof__,
  [anon_sym___alignof] = anon_sym___alignof,
  [anon_sym__alignof] = anon_sym__alignof,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym__Alignof] = anon_sym__Alignof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_field_declaration_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list_no_comma] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list_no_comma] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list_no_comma] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = sym_preproc_elifdef,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym__old_style_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__type_definition_type] = sym__type_definition_type,
  [sym__type_definition_declarators] = sym__type_definition_declarators,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__declaration_declarator] = sym__declaration_declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym__function_declaration_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym__old_style_function_declarator] = sym_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym__type_specifier] = sym__type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym__field_declaration_declarator] = sym__field_declaration_declarator,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym__old_style_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_body] = sym__for_statement_body,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_seh_try_statement] = sym_seh_try_statement,
  [sym_seh_except_clause] = sym_seh_except_clause,
  [sym_seh_finally_clause] = sym_seh_finally_clause,
  [sym_seh_leave_statement] = sym_seh_leave_statement,
  [sym__expression] = sym__expression,
  [sym__expression_not_binary] = sym__expression_not_binary,
  [sym__string] = sym__string,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_subscript_range_designator] = sym_subscript_range_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_macro_type_specifier] = sym_macro_type_specifier,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = aux_sym_preproc_if_in_enumerator_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym__old_style_function_definition_repeat1] = aux_sym__old_style_function_definition_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__type_definition_type_repeat1] = aux_sym__type_definition_type_repeat1,
  [aux_sym__type_definition_declarators_repeat1] = aux_sym__type_definition_declarators_repeat1,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_function_declarator_repeat1] = aux_sym_function_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym__field_declaration_declarator_repeat1] = aux_sym__field_declaration_declarator_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym__old_style_parameter_list_repeat1] = aux_sym__old_style_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_char_literal_repeat1] = aux_sym_char_literal_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___extension__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_auto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___leave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_definition_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_definition_declarators] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declaration_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_body] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__expression_not_binary] = {
    .visible = false,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_range_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_macro_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_declaration_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_char_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_body = 5,
  field_clobbers = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_declarator = 10,
  field_designator = 11,
  field_directive = 12,
  field_end = 13,
  field_field = 14,
  field_filter = 15,
  field_function = 16,
  field_goto_labels = 17,
  field_index = 18,
  field_initializer = 19,
  field_input_operands = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_operand = 25,
  field_operator = 26,
  field_output_operands = 27,
  field_parameters = 28,
  field_path = 29,
  field_prefix = 30,
  field_register = 31,
  field_right = 32,
  field_size = 33,
  field_start = 34,
  field_symbol = 35,
  field_type = 36,
  field_underlying_type = 37,
  field_update = 38,
  field_value = 39,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_body] = "body",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_end] = "end",
  [field_field] = "field",
  [field_filter] = "filter",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_right] = "right",
  [field_size] = "size",
  [field_start] = "start",
  [field_symbol] = "symbol",
  [field_type] = "type",
  [field_underlying_type] = "underlying_type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 3, .length = 1},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 8, .length = 1},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 1},
  [26] = {.index = 30, .length = 1},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 3},
  [31] = {.index = 39, .length = 1},
  [32] = {.index = 40, .length = 1},
  [33] = {.index = 41, .length = 3},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 2},
  [36] = {.index = 48, .length = 5},
  [37] = {.index = 53, .length = 3},
  [38] = {.index = 56, .length = 2},
  [39] = {.index = 58, .length = 2},
  [40] = {.index = 60, .length = 1},
  [41] = {.index = 61, .length = 2},
  [42] = {.index = 63, .length = 1},
  [43] = {.index = 64, .length = 2},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 2},
  [46] = {.index = 70, .length = 2},
  [47] = {.index = 72, .length = 2},
  [48] = {.index = 74, .length = 2},
  [49] = {.index = 76, .length = 2},
  [50] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 1},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 3},
  [56] = {.index = 87, .length = 1},
  [57] = {.index = 88, .length = 1},
  [58] = {.index = 89, .length = 1},
  [59] = {.index = 90, .length = 2},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 3},
  [62] = {.index = 96, .length = 3},
  [63] = {.index = 99, .length = 2},
  [64] = {.index = 101, .length = 3},
  [65] = {.index = 104, .length = 2},
  [66] = {.index = 106, .length = 5},
  [67] = {.index = 111, .length = 3},
  [68] = {.index = 114, .length = 5},
  [69] = {.index = 119, .length = 2},
  [70] = {.index = 121, .length = 2},
  [71] = {.index = 123, .length = 3},
  [72] = {.index = 126, .length = 2},
  [73] = {.index = 128, .length = 2},
  [74] = {.index = 130, .length = 1},
  [75] = {.index = 131, .length = 2},
  [76] = {.index = 133, .length = 2},
  [77] = {.index = 135, .length = 2},
  [78] = {.index = 137, .length = 3},
  [79] = {.index = 140, .length = 2},
  [80] = {.index = 142, .length = 2},
  [81] = {.index = 144, .length = 2},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 2},
  [84] = {.index = 149, .length = 2},
  [85] = {.index = 151, .length = 4},
  [86] = {.index = 155, .length = 1},
  [87] = {.index = 156, .length = 2},
  [88] = {.index = 158, .length = 1},
  [89] = {.index = 159, .length = 1},
  [90] = {.index = 160, .length = 4},
  [91] = {.index = 164, .length = 4},
  [92] = {.index = 168, .length = 2},
  [93] = {.index = 170, .length = 2},
  [94] = {.index = 172, .length = 3},
  [95] = {.index = 175, .length = 5},
  [96] = {.index = 180, .length = 3},
  [97] = {.index = 183, .length = 2},
  [98] = {.index = 185, .length = 1},
  [100] = {.index = 186, .length = 2},
  [101] = {.index = 188, .length = 2},
  [102] = {.index = 190, .length = 2},
  [103] = {.index = 192, .length = 3},
  [104] = {.index = 195, .length = 2},
  [105] = {.index = 197, .length = 2},
  [106] = {.index = 199, .length = 2},
  [107] = {.index = 201, .length = 2},
  [108] = {.index = 203, .length = 3},
  [109] = {.index = 206, .length = 2},
  [110] = {.index = 208, .length = 1},
  [111] = {.index = 209, .length = 5},
  [112] = {.index = 214, .length = 2},
  [113] = {.index = 216, .length = 3},
  [114] = {.index = 219, .length = 2},
  [115] = {.index = 219, .length = 2},
  [116] = {.index = 221, .length = 3},
  [117] = {.index = 224, .length = 2},
  [118] = {.index = 226, .length = 1},
  [119] = {.index = 227, .length = 4},
  [120] = {.index = 231, .length = 3},
  [121] = {.index = 234, .length = 2},
  [122] = {.index = 236, .length = 2},
  [123] = {.index = 35, .length = 1},
  [124] = {.index = 238, .length = 5},
  [125] = {.index = 243, .length = 4},
  [126] = {.index = 247, .length = 2},
  [127] = {.index = 249, .length = 2},
  [128] = {.index = 251, .length = 2},
  [129] = {.index = 253, .length = 5},
  [130] = {.index = 258, .length = 2},
  [131] = {.index = 260, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 0, .inherited = true},
    {field_declarator, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [3] =
    {field_type, 0},
  [4] =
    {field_directive, 0},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_name, 1},
  [9] =
    {field_body, 1},
  [10] =
    {field_value, 1},
  [11] =
    {field_declarator, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [13] =
    {field_argument, 0},
    {field_operator, 1},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
  [17] =
    {field_type, 1},
  [18] =
    {field_path, 1},
  [19] =
    {field_argument, 1},
    {field_directive, 0},
  [21] =
    {field_declarator, 1},
    {field_type, 0},
  [23] =
    {field_parameters, 0},
  [24] =
    {field_declarator, 0},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_name, 1},
  [29] =
    {field_name, 2},
  [30] =
    {field_body, 2},
  [31] =
    {field_condition, 1},
    {field_consequence, 2},
  [33] =
    {field_body, 2},
    {field_condition, 1},
  [35] =
    {field_label, 1},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_label, 0},
  [40] =
    {field_declarator, 1},
  [41] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [44] =
    {field_declarator, 0},
    {field_parameters, 1},
  [46] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [48] =
    {field_body, 2},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [53] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [56] =
    {field_name, 1},
    {field_value, 2},
  [58] =
    {field_name, 1},
    {field_parameters, 2},
  [60] =
    {field_condition, 1},
  [61] =
    {field_alternative, 2},
    {field_name, 1},
  [63] =
    {field_type, 0, .inherited = true},
  [64] =
    {field_declarator, 2},
    {field_type, 0},
  [66] =
    {field_left, 0},
    {field_right, 2},
  [68] =
    {field_type, 1},
    {field_value, 3},
  [70] =
    {field_declarator, 2},
    {field_type, 1},
  [72] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [74] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [76] =
    {field_name, 2},
    {field_prefix, 0},
  [78] =
    {field_name, 1},
    {field_underlying_type, 3},
  [80] =
    {field_body, 3},
    {field_name, 2},
  [82] =
    {field_name, 3},
  [83] =
    {field_body, 3},
  [84] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [87] =
    {field_initializer, 0},
  [88] =
    {field_type, 2},
  [89] =
    {field_assembly_code, 2},
  [90] =
    {field_name, 0},
    {field_type, 2},
  [92] =
    {field_declarator, 2},
  [93] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [96] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [99] =
    {field_declarator, 0},
    {field_value, 2},
  [101] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [104] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [106] =
    {field_body, 3},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [111] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [114] =
    {field_body, 3},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [119] =
    {field_argument, 0},
    {field_index, 2},
  [121] =
    {field_alternative, 3},
    {field_condition, 0},
  [123] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [126] =
    {field_alternative, 3},
    {field_condition, 1},
  [128] =
    {field_alternative, 3},
    {field_name, 1},
  [130] =
    {field_size, 1},
  [131] =
    {field_declarator, 3},
    {field_type, 1},
  [133] =
    {field_declarator, 3, .inherited = true},
    {field_type, 2, .inherited = true},
  [135] =
    {field_name, 0},
    {field_value, 2},
  [137] =
    {field_body, 4},
    {field_name, 1},
    {field_underlying_type, 3},
  [140] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [142] =
    {field_body, 4},
    {field_name, 3},
  [144] =
    {field_body, 1},
    {field_condition, 3},
  [146] =
    {field_update, 2},
  [147] =
    {field_initializer, 0},
    {field_update, 2},
  [149] =
    {field_condition, 1},
    {field_initializer, 0},
  [151] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [155] =
    {field_operand, 1},
  [156] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [158] =
    {field_assembly_code, 3},
  [159] =
    {field_declarator, 3},
  [160] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
    {field_type, 0, .inherited = true},
  [164] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [168] =
    {field_declarator, 0},
    {field_size, 2},
  [170] =
    {field_declarator, 1},
    {field_declarator, 2},
  [172] =
    {field_body, 4},
    {field_declarator, 3},
    {field_type, 1, .inherited = true},
  [175] =
    {field_body, 4},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [180] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [183] =
    {field_alternative, 4},
    {field_condition, 1},
  [185] =
    {field_size, 2},
  [186] =
    {field_body, 2},
    {field_filter, 1},
  [188] =
    {field_declarator, 0},
    {field_declarator, 2, .inherited = true},
  [190] =
    {field_condition, 1},
    {field_update, 3},
  [192] =
    {field_condition, 1},
    {field_initializer, 0},
    {field_update, 3},
  [195] =
    {field_initializer, 0},
    {field_update, 3},
  [197] =
    {field_condition, 2},
    {field_initializer, 0},
  [199] =
    {field_member, 4},
    {field_type, 2},
  [201] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [203] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [206] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [208] =
    {field_declarator, 4},
  [209] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 0, .inherited = true},
  [214] =
    {field_declarator, 0},
    {field_size, 3},
  [216] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
  [219] =
    {field_designator, 0},
    {field_value, 2},
  [221] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [224] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [226] =
    {field_register, 1},
  [227] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [231] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [234] =
    {field_constraint, 0},
    {field_value, 2},
  [236] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [238] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [243] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [247] =
    {field_end, 3},
    {field_start, 1},
  [249] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [251] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [253] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [258] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [260] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [7] = {
    [1] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [0] = sym_primitive_type,
  },
  [24] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [2] = alias_sym_type_identifier,
  },
  [29] = {
    [1] = alias_sym_statement_identifier,
  },
  [31] = {
    [0] = alias_sym_statement_identifier,
  },
  [37] = {
    [2] = alias_sym_field_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [0] = alias_sym_field_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [53] = {
    [3] = alias_sym_type_identifier,
  },
  [78] = {
    [1] = alias_sym_type_identifier,
  },
  [80] = {
    [3] = alias_sym_type_identifier,
  },
  [99] = {
    [1] = alias_sym_field_identifier,
  },
  [106] = {
    [4] = alias_sym_field_identifier,
  },
  [114] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 5,
  [7] = 7,
  [8] = 5,
  [9] = 5,
  [10] = 10,
  [11] = 3,
  [12] = 10,
  [13] = 3,
  [14] = 2,
  [15] = 10,
  [16] = 3,
  [17] = 2,
  [18] = 18,
  [19] = 2,
  [20] = 10,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 22,
  [26] = 23,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 28,
  [31] = 23,
  [32] = 28,
  [33] = 33,
  [34] = 28,
  [35] = 29,
  [36] = 29,
  [37] = 23,
  [38] = 33,
  [39] = 22,
  [40] = 33,
  [41] = 33,
  [42] = 29,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 48,
  [51] = 47,
  [52] = 46,
  [53] = 48,
  [54] = 47,
  [55] = 45,
  [56] = 45,
  [57] = 46,
  [58] = 48,
  [59] = 49,
  [60] = 47,
  [61] = 45,
  [62] = 46,
  [63] = 49,
  [64] = 49,
  [65] = 48,
  [66] = 46,
  [67] = 47,
  [68] = 45,
  [69] = 49,
  [70] = 70,
  [71] = 70,
  [72] = 70,
  [73] = 70,
  [74] = 70,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 80,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 104,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 75,
  [157] = 157,
  [158] = 75,
  [159] = 157,
  [160] = 75,
  [161] = 78,
  [162] = 108,
  [163] = 126,
  [164] = 127,
  [165] = 125,
  [166] = 124,
  [167] = 123,
  [168] = 122,
  [169] = 121,
  [170] = 76,
  [171] = 76,
  [172] = 106,
  [173] = 114,
  [174] = 113,
  [175] = 114,
  [176] = 118,
  [177] = 102,
  [178] = 100,
  [179] = 112,
  [180] = 113,
  [181] = 121,
  [182] = 122,
  [183] = 123,
  [184] = 124,
  [185] = 125,
  [186] = 127,
  [187] = 126,
  [188] = 119,
  [189] = 93,
  [190] = 87,
  [191] = 86,
  [192] = 120,
  [193] = 84,
  [194] = 95,
  [195] = 119,
  [196] = 118,
  [197] = 117,
  [198] = 116,
  [199] = 110,
  [200] = 96,
  [201] = 97,
  [202] = 98,
  [203] = 99,
  [204] = 117,
  [205] = 109,
  [206] = 108,
  [207] = 116,
  [208] = 101,
  [209] = 110,
  [210] = 104,
  [211] = 109,
  [212] = 107,
  [213] = 77,
  [214] = 105,
  [215] = 103,
  [216] = 115,
  [217] = 94,
  [218] = 93,
  [219] = 91,
  [220] = 87,
  [221] = 112,
  [222] = 90,
  [223] = 88,
  [224] = 83,
  [225] = 82,
  [226] = 81,
  [227] = 108,
  [228] = 80,
  [229] = 79,
  [230] = 107,
  [231] = 77,
  [232] = 103,
  [233] = 85,
  [234] = 79,
  [235] = 80,
  [236] = 90,
  [237] = 81,
  [238] = 88,
  [239] = 82,
  [240] = 83,
  [241] = 112,
  [242] = 86,
  [243] = 115,
  [244] = 105,
  [245] = 104,
  [246] = 101,
  [247] = 89,
  [248] = 115,
  [249] = 105,
  [250] = 99,
  [251] = 95,
  [252] = 100,
  [253] = 102,
  [254] = 106,
  [255] = 94,
  [256] = 84,
  [257] = 91,
  [258] = 85,
  [259] = 98,
  [260] = 97,
  [261] = 83,
  [262] = 82,
  [263] = 96,
  [264] = 89,
  [265] = 81,
  [266] = 78,
  [267] = 84,
  [268] = 86,
  [269] = 87,
  [270] = 95,
  [271] = 100,
  [272] = 102,
  [273] = 106,
  [274] = 113,
  [275] = 114,
  [276] = 76,
  [277] = 121,
  [278] = 122,
  [279] = 123,
  [280] = 124,
  [281] = 101,
  [282] = 125,
  [283] = 127,
  [284] = 79,
  [285] = 99,
  [286] = 126,
  [287] = 120,
  [288] = 119,
  [289] = 118,
  [290] = 117,
  [291] = 116,
  [292] = 98,
  [293] = 97,
  [294] = 110,
  [295] = 109,
  [296] = 120,
  [297] = 107,
  [298] = 77,
  [299] = 103,
  [300] = 94,
  [301] = 93,
  [302] = 91,
  [303] = 90,
  [304] = 88,
  [305] = 85,
  [306] = 78,
  [307] = 89,
  [308] = 96,
  [309] = 145,
  [310] = 141,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 315,
  [318] = 318,
  [319] = 133,
  [320] = 320,
  [321] = 134,
  [322] = 135,
  [323] = 316,
  [324] = 136,
  [325] = 138,
  [326] = 139,
  [327] = 142,
  [328] = 128,
  [329] = 151,
  [330] = 152,
  [331] = 153,
  [332] = 155,
  [333] = 140,
  [334] = 152,
  [335] = 314,
  [336] = 149,
  [337] = 150,
  [338] = 315,
  [339] = 314,
  [340] = 137,
  [341] = 132,
  [342] = 151,
  [343] = 153,
  [344] = 318,
  [345] = 148,
  [346] = 147,
  [347] = 145,
  [348] = 130,
  [349] = 316,
  [350] = 313,
  [351] = 312,
  [352] = 311,
  [353] = 146,
  [354] = 320,
  [355] = 318,
  [356] = 129,
  [357] = 320,
  [358] = 314,
  [359] = 131,
  [360] = 148,
  [361] = 311,
  [362] = 312,
  [363] = 318,
  [364] = 142,
  [365] = 144,
  [366] = 313,
  [367] = 150,
  [368] = 129,
  [369] = 131,
  [370] = 143,
  [371] = 316,
  [372] = 146,
  [373] = 316,
  [374] = 133,
  [375] = 144,
  [376] = 130,
  [377] = 134,
  [378] = 135,
  [379] = 136,
  [380] = 137,
  [381] = 138,
  [382] = 139,
  [383] = 147,
  [384] = 313,
  [385] = 132,
  [386] = 313,
  [387] = 320,
  [388] = 141,
  [389] = 312,
  [390] = 155,
  [391] = 311,
  [392] = 128,
  [393] = 154,
  [394] = 320,
  [395] = 143,
  [396] = 312,
  [397] = 311,
  [398] = 140,
  [399] = 318,
  [400] = 314,
  [401] = 149,
  [402] = 154,
  [403] = 315,
  [404] = 131,
  [405] = 142,
  [406] = 157,
  [407] = 148,
  [408] = 155,
  [409] = 134,
  [410] = 135,
  [411] = 138,
  [412] = 132,
  [413] = 139,
  [414] = 136,
  [415] = 415,
  [416] = 416,
  [417] = 141,
  [418] = 137,
  [419] = 149,
  [420] = 146,
  [421] = 152,
  [422] = 143,
  [423] = 133,
  [424] = 154,
  [425] = 144,
  [426] = 147,
  [427] = 145,
  [428] = 151,
  [429] = 130,
  [430] = 129,
  [431] = 140,
  [432] = 153,
  [433] = 128,
  [434] = 434,
  [435] = 435,
  [436] = 435,
  [437] = 435,
  [438] = 434,
  [439] = 435,
  [440] = 435,
  [441] = 434,
  [442] = 434,
  [443] = 434,
  [444] = 435,
  [445] = 434,
  [446] = 446,
  [447] = 447,
  [448] = 157,
  [449] = 157,
  [450] = 157,
  [451] = 75,
  [452] = 452,
  [453] = 452,
  [454] = 452,
  [455] = 452,
  [456] = 452,
  [457] = 452,
  [458] = 458,
  [459] = 452,
  [460] = 452,
  [461] = 461,
  [462] = 452,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 480,
  [485] = 485,
  [486] = 486,
  [487] = 480,
  [488] = 485,
  [489] = 478,
  [490] = 478,
  [491] = 485,
  [492] = 486,
  [493] = 486,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 496,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 500,
  [505] = 505,
  [506] = 500,
  [507] = 503,
  [508] = 501,
  [509] = 501,
  [510] = 503,
  [511] = 501,
  [512] = 512,
  [513] = 503,
  [514] = 501,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 501,
  [520] = 520,
  [521] = 500,
  [522] = 503,
  [523] = 523,
  [524] = 503,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 495,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 495,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 532,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 547,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 561,
  [565] = 565,
  [566] = 566,
  [567] = 563,
  [568] = 568,
  [569] = 566,
  [570] = 570,
  [571] = 571,
  [572] = 560,
  [573] = 554,
  [574] = 548,
  [575] = 561,
  [576] = 549,
  [577] = 550,
  [578] = 562,
  [579] = 565,
  [580] = 547,
  [581] = 566,
  [582] = 563,
  [583] = 552,
  [584] = 553,
  [585] = 555,
  [586] = 586,
  [587] = 548,
  [588] = 588,
  [589] = 586,
  [590] = 549,
  [591] = 550,
  [592] = 552,
  [593] = 553,
  [594] = 555,
  [595] = 556,
  [596] = 586,
  [597] = 557,
  [598] = 558,
  [599] = 599,
  [600] = 556,
  [601] = 557,
  [602] = 562,
  [603] = 565,
  [604] = 558,
  [605] = 563,
  [606] = 561,
  [607] = 560,
  [608] = 558,
  [609] = 557,
  [610] = 556,
  [611] = 555,
  [612] = 553,
  [613] = 552,
  [614] = 547,
  [615] = 550,
  [616] = 548,
  [617] = 561,
  [618] = 618,
  [619] = 560,
  [620] = 561,
  [621] = 560,
  [622] = 599,
  [623] = 558,
  [624] = 624,
  [625] = 625,
  [626] = 557,
  [627] = 560,
  [628] = 556,
  [629] = 555,
  [630] = 553,
  [631] = 552,
  [632] = 547,
  [633] = 550,
  [634] = 549,
  [635] = 548,
  [636] = 554,
  [637] = 563,
  [638] = 565,
  [639] = 562,
  [640] = 546,
  [641] = 548,
  [642] = 642,
  [643] = 549,
  [644] = 550,
  [645] = 547,
  [646] = 552,
  [647] = 553,
  [648] = 555,
  [649] = 556,
  [650] = 557,
  [651] = 558,
  [652] = 652,
  [653] = 549,
  [654] = 563,
  [655] = 586,
  [656] = 586,
  [657] = 565,
  [658] = 562,
  [659] = 562,
  [660] = 565,
  [661] = 461,
  [662] = 662,
  [663] = 663,
  [664] = 663,
  [665] = 665,
  [666] = 666,
  [667] = 663,
  [668] = 663,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 684,
  [686] = 447,
  [687] = 446,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 690,
  [694] = 688,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 688,
  [699] = 690,
  [700] = 700,
  [701] = 691,
  [702] = 702,
  [703] = 695,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 695,
  [708] = 691,
  [709] = 695,
  [710] = 688,
  [711] = 711,
  [712] = 691,
  [713] = 690,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 669,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 683,
  [736] = 736,
  [737] = 737,
  [738] = 669,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 741,
  [743] = 741,
  [744] = 740,
  [745] = 741,
  [746] = 740,
  [747] = 740,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 748,
  [754] = 754,
  [755] = 750,
  [756] = 756,
  [757] = 757,
  [758] = 748,
  [759] = 759,
  [760] = 748,
  [761] = 748,
  [762] = 762,
  [763] = 763,
  [764] = 669,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 446,
  [774] = 774,
  [775] = 447,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 767,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 763,
  [790] = 770,
  [791] = 791,
  [792] = 769,
  [793] = 777,
  [794] = 794,
  [795] = 795,
  [796] = 768,
  [797] = 774,
  [798] = 766,
  [799] = 799,
  [800] = 778,
  [801] = 772,
  [802] = 802,
  [803] = 771,
  [804] = 804,
  [805] = 765,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 799,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 144,
  [847] = 847,
  [848] = 848,
  [849] = 137,
  [850] = 154,
  [851] = 143,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 131,
  [858] = 142,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 863,
  [866] = 863,
  [867] = 863,
  [868] = 727,
  [869] = 722,
  [870] = 772,
  [871] = 771,
  [872] = 872,
  [873] = 765,
  [874] = 766,
  [875] = 767,
  [876] = 768,
  [877] = 769,
  [878] = 770,
  [879] = 763,
  [880] = 778,
  [881] = 777,
  [882] = 774,
  [883] = 883,
  [884] = 884,
  [885] = 736,
  [886] = 733,
  [887] = 723,
  [888] = 888,
  [889] = 889,
  [890] = 737,
  [891] = 732,
  [892] = 671,
  [893] = 670,
  [894] = 726,
  [895] = 799,
  [896] = 724,
  [897] = 729,
  [898] = 861,
  [899] = 862,
  [900] = 154,
  [901] = 855,
  [902] = 902,
  [903] = 860,
  [904] = 845,
  [905] = 137,
  [906] = 848,
  [907] = 852,
  [908] = 855,
  [909] = 909,
  [910] = 853,
  [911] = 847,
  [912] = 859,
  [913] = 862,
  [914] = 854,
  [915] = 143,
  [916] = 847,
  [917] = 845,
  [918] = 861,
  [919] = 142,
  [920] = 852,
  [921] = 859,
  [922] = 922,
  [923] = 853,
  [924] = 856,
  [925] = 848,
  [926] = 854,
  [927] = 142,
  [928] = 928,
  [929] = 902,
  [930] = 902,
  [931] = 856,
  [932] = 902,
  [933] = 144,
  [934] = 131,
  [935] = 154,
  [936] = 137,
  [937] = 143,
  [938] = 131,
  [939] = 860,
  [940] = 144,
  [941] = 94,
  [942] = 102,
  [943] = 106,
  [944] = 89,
  [945] = 95,
  [946] = 78,
  [947] = 85,
  [948] = 91,
  [949] = 93,
  [950] = 100,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 769,
  [960] = 778,
  [961] = 763,
  [962] = 774,
  [963] = 963,
  [964] = 770,
  [965] = 777,
  [966] = 768,
  [967] = 767,
  [968] = 766,
  [969] = 765,
  [970] = 771,
  [971] = 772,
  [972] = 771,
  [973] = 766,
  [974] = 768,
  [975] = 975,
  [976] = 769,
  [977] = 770,
  [978] = 978,
  [979] = 975,
  [980] = 763,
  [981] = 975,
  [982] = 106,
  [983] = 102,
  [984] = 94,
  [985] = 767,
  [986] = 100,
  [987] = 772,
  [988] = 95,
  [989] = 989,
  [990] = 765,
  [991] = 78,
  [992] = 777,
  [993] = 93,
  [994] = 89,
  [995] = 995,
  [996] = 91,
  [997] = 85,
  [998] = 778,
  [999] = 975,
  [1000] = 774,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1019,
  [1022] = 1022,
  [1023] = 1022,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 768,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 767,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 769,
  [1041] = 1034,
  [1042] = 1031,
  [1043] = 1029,
  [1044] = 1044,
  [1045] = 766,
  [1046] = 1031,
  [1047] = 1047,
  [1048] = 765,
  [1049] = 1049,
  [1050] = 774,
  [1051] = 771,
  [1052] = 1035,
  [1053] = 770,
  [1054] = 1031,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 777,
  [1060] = 1029,
  [1061] = 763,
  [1062] = 1062,
  [1063] = 772,
  [1064] = 1064,
  [1065] = 1033,
  [1066] = 778,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1034,
  [1070] = 1070,
  [1071] = 1035,
  [1072] = 1072,
  [1073] = 1029,
  [1074] = 963,
  [1075] = 1031,
  [1076] = 1076,
  [1077] = 1035,
  [1078] = 1031,
  [1079] = 1079,
  [1080] = 1033,
  [1081] = 1034,
  [1082] = 1082,
  [1083] = 1068,
  [1084] = 1084,
  [1085] = 1033,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1087,
  [1097] = 1087,
  [1098] = 1087,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1102,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1087,
  [1112] = 1112,
  [1113] = 739,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 864,
  [1117] = 1117,
  [1118] = 883,
  [1119] = 909,
  [1120] = 922,
  [1121] = 928,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1129,
  [1133] = 835,
  [1134] = 1129,
  [1135] = 1129,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 843,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1142,
  [1145] = 1142,
  [1146] = 1146,
  [1147] = 1142,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1148,
  [1151] = 1140,
  [1152] = 1146,
  [1153] = 1142,
  [1154] = 1143,
  [1155] = 1143,
  [1156] = 1143,
  [1157] = 1148,
  [1158] = 1142,
  [1159] = 1146,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1173,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1179,
  [1195] = 1191,
  [1196] = 1196,
  [1197] = 717,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1193,
  [1201] = 1161,
  [1202] = 1193,
  [1203] = 1172,
  [1204] = 1171,
  [1205] = 1205,
  [1206] = 1161,
  [1207] = 1207,
  [1208] = 1186,
  [1209] = 1185,
  [1210] = 1183,
  [1211] = 1211,
  [1212] = 1182,
  [1213] = 1181,
  [1214] = 1178,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1177,
  [1218] = 1218,
  [1219] = 1193,
  [1220] = 1211,
  [1221] = 1168,
  [1222] = 717,
  [1223] = 843,
  [1224] = 1008,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1175,
  [1228] = 1226,
  [1229] = 1226,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1225,
  [1235] = 841,
  [1236] = 1180,
  [1237] = 1237,
  [1238] = 1162,
  [1239] = 831,
  [1240] = 1232,
  [1241] = 1017,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1163,
  [1245] = 1226,
  [1246] = 1207,
  [1247] = 1164,
  [1248] = 1170,
  [1249] = 811,
  [1250] = 1225,
  [1251] = 1012,
  [1252] = 1169,
  [1253] = 812,
  [1254] = 1237,
  [1255] = 1232,
  [1256] = 1256,
  [1257] = 1166,
  [1258] = 813,
  [1259] = 1192,
  [1260] = 834,
  [1261] = 835,
  [1262] = 1225,
  [1263] = 816,
  [1264] = 1165,
  [1265] = 818,
  [1266] = 1174,
  [1267] = 1267,
  [1268] = 1014,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1270,
  [1272] = 1270,
  [1273] = 1270,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1276,
  [1279] = 1276,
  [1280] = 1276,
  [1281] = 864,
  [1282] = 1277,
  [1283] = 1277,
  [1284] = 1277,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1289,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1289,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1304,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1304,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1309,
  [1312] = 1312,
  [1313] = 1304,
  [1314] = 1304,
  [1315] = 1309,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1309,
  [1320] = 1304,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1338,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1327,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1346,
  [1347] = 1327,
  [1348] = 1348,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1327,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1357,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1357,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1366,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1357,
  [1370] = 1370,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1373,
  [1376] = 1376,
  [1377] = 1373,
  [1378] = 1376,
  [1379] = 1373,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1376,
  [1384] = 1381,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1387,
  [1388] = 1376,
  [1389] = 1381,
  [1390] = 1390,
  [1391] = 1381,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1397,
  [1402] = 1402,
  [1403] = 1396,
  [1404] = 1396,
  [1405] = 1397,
  [1406] = 1402,
  [1407] = 1396,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1397,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1402,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1402,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1428,
  [1429] = 1429,
  [1430] = 1430,
  [1431] = 1431,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1446,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1444,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1458,
  [1459] = 1459,
  [1460] = 1459,
  [1461] = 1459,
  [1462] = 1462,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1444,
  [1467] = 1467,
  [1468] = 1459,
  [1469] = 1469,
  [1470] = 1459,
  [1471] = 1444,
  [1472] = 1444,
  [1473] = 1473,
  [1474] = 1474,
  [1475] = 1475,
  [1476] = 1476,
  [1477] = 1459,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1444,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1505,
  [1511] = 1504,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1514,
  [1518] = 1514,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1502,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1514,
  [1527] = 1503,
  [1528] = 1525,
  [1529] = 1529,
  [1530] = 1504,
  [1531] = 1505,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1503,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1514,
  [1539] = 1539,
  [1540] = 1507,
  [1541] = 1507,
  [1542] = 1508,
  [1543] = 1543,
  [1544] = 1502,
  [1545] = 1507,
  [1546] = 1546,
  [1547] = 1508,
  [1548] = 1514,
  [1549] = 1514,
  [1550] = 1508,
  [1551] = 1503,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1505,
  [1556] = 1515,
  [1557] = 1557,
  [1558] = 1525,
  [1559] = 1504,
  [1560] = 1560,
  [1561] = 1507,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1515,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1565,
  [1571] = 1566,
  [1572] = 1572,
  [1573] = 1565,
  [1574] = 1574,
  [1575] = 1566,
  [1576] = 1572,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1568,
  [1585] = 1566,
  [1586] = 1586,
  [1587] = 1572,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1578,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1594,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1577,
  [1601] = 1572,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1580,
  [1605] = 1566,
  [1606] = 1568,
  [1607] = 1594,
  [1608] = 1578,
  [1609] = 1577,
  [1610] = 1413,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1612,
  [1615] = 1581,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1590,
  [1619] = 1565,
  [1620] = 1590,
  [1621] = 1621,
  [1622] = 1594,
  [1623] = 1623,
  [1624] = 1612,
  [1625] = 1572,
  [1626] = 1594,
  [1627] = 1568,
  [1628] = 1578,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1594,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1577,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1578,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1617,
  [1643] = 1581,
  [1644] = 1568,
  [1645] = 1645,
  [1646] = 1590,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1611,
  [1651] = 1617,
  [1652] = 1572,
  [1653] = 1566,
  [1654] = 1612,
  [1655] = 1568,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1640,
  [1660] = 1660,
  [1661] = 1565,
  [1662] = 1577,
  [1663] = 1663,
  [1664] = 1613,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1590,
  [1668] = 1590,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1567,
  [1673] = 1595,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1613,
  [1679] = 1583,
  [1680] = 1611,
  [1681] = 1578,
  [1682] = 1577,
  [1683] = 1565,
  [1684] = 1595,
  [1685] = 1685,
  [1686] = 1580,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1690,
  [1693] = 1693,
  [1694] = 1687,
  [1695] = 1689,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1696,
  [1702] = 1702,
  [1703] = 1688,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1687,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1689,
  [1710] = 1710,
  [1711] = 1702,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1699,
  [1719] = 1719,
  [1720] = 1719,
  [1721] = 1696,
  [1722] = 1702,
  [1723] = 1688,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1699,
  [1728] = 1728,
  [1729] = 1719,
  [1730] = 1702,
  [1731] = 1731,
  [1732] = 1696,
  [1733] = 1691,
  [1734] = 1689,
  [1735] = 1690,
  [1736] = 1710,
  [1737] = 1688,
  [1738] = 1697,
  [1739] = 1739,
  [1740] = 1690,
  [1741] = 1689,
  [1742] = 1717,
  [1743] = 1702,
  [1744] = 1719,
  [1745] = 1716,
  [1746] = 1699,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1697,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1690,
  [1755] = 1699,
  [1756] = 1717,
  [1757] = 1702,
  [1758] = 1758,
  [1759] = 1716,
  [1760] = 1696,
  [1761] = 1761,
  [1762] = 1699,
  [1763] = 1699,
  [1764] = 1687,
  [1765] = 1688,
  [1766] = 1766,
  [1767] = 1691,
  [1768] = 1716,
  [1769] = 1702,
  [1770] = 1697,
  [1771] = 1717,
  [1772] = 1717,
  [1773] = 1773,
  [1774] = 1697,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1791,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1795,
  [1801] = 1801,
  [1802] = 1782,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1783,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1796,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1796,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1795,
  [1820] = 1775,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1793,
  [1825] = 1783,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1796,
  [1833] = 1795,
  [1834] = 1834,
  [1835] = 1783,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 1793,
  [1840] = 1840,
  [1841] = 1787,
  [1842] = 1793,
  [1843] = 1828,
  [1844] = 1844,
  [1845] = 1822,
  [1846] = 1792,
  [1847] = 1781,
  [1848] = 1775,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 1799,
  [1852] = 1852,
  [1853] = 1809,
  [1854] = 1789,
  [1855] = 1834,
  [1856] = 1784,
  [1857] = 1783,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1860,
  [1861] = 1801,
  [1862] = 1008,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 1870,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 1840,
  [1874] = 1874,
  [1875] = 1812,
  [1876] = 1796,
  [1877] = 1877,
  [1878] = 1012,
  [1879] = 1879,
  [1880] = 1782,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1884,
  [1885] = 1809,
  [1886] = 1882,
  [1887] = 1782,
  [1888] = 1888,
  [1889] = 1889,
  [1890] = 1890,
  [1891] = 1795,
  [1892] = 1860,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1879,
  [1896] = 1822,
  [1897] = 1795,
  [1898] = 1805,
  [1899] = 1899,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1791,
  [1904] = 1850,
  [1905] = 1905,
  [1906] = 1906,
  [1907] = 1907,
  [1908] = 1812,
  [1909] = 1799,
  [1910] = 670,
  [1911] = 1801,
  [1912] = 1789,
  [1913] = 1913,
  [1914] = 1860,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1837,
  [1918] = 1838,
  [1919] = 1919,
  [1920] = 1801,
  [1921] = 1799,
  [1922] = 1805,
  [1923] = 1781,
  [1924] = 1806,
  [1925] = 1809,
  [1926] = 1792,
  [1927] = 1796,
  [1928] = 1928,
  [1929] = 1929,
  [1930] = 1930,
  [1931] = 1812,
  [1932] = 1932,
  [1933] = 1933,
  [1934] = 1775,
  [1935] = 1822,
  [1936] = 1936,
  [1937] = 1793,
  [1938] = 1884,
  [1939] = 1939,
  [1940] = 1882,
  [1941] = 1884,
  [1942] = 1796,
  [1943] = 1943,
  [1944] = 1944,
  [1945] = 1883,
  [1946] = 1809,
  [1947] = 1947,
  [1948] = 1837,
  [1949] = 1838,
  [1950] = 1950,
  [1951] = 1882,
  [1952] = 1795,
  [1953] = 1791,
  [1954] = 1792,
  [1955] = 1955,
  [1956] = 1782,
  [1957] = 1957,
  [1958] = 1958,
  [1959] = 1959,
  [1960] = 1960,
  [1961] = 1961,
  [1962] = 1962,
  [1963] = 1963,
  [1964] = 1964,
  [1965] = 1965,
  [1966] = 1966,
  [1967] = 1936,
  [1968] = 1968,
  [1969] = 1837,
  [1970] = 1970,
  [1971] = 1971,
  [1972] = 1882,
  [1973] = 1837,
  [1974] = 1837,
  [1975] = 671,
  [1976] = 1976,
  [1977] = 1782,
  [1978] = 1830,
  [1979] = 1979,
  [1980] = 1778,
  [1981] = 1829,
  [1982] = 1828,
  [1983] = 1829,
  [1984] = 1830,
  [1985] = 1809,
  [1986] = 1834,
  [1987] = 1840,
  [1988] = 1787,
  [1989] = 1894,
  [1990] = 1990,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1787,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1860,
  [1997] = 1860,
  [1998] = 1781,
  [1999] = 1778,
  [2000] = 1806,
  [2001] = 1850,
  [2002] = 1894,
  [2003] = 1805,
  [2004] = 1017,
  [2005] = 1014,
  [2006] = 2006,
  [2007] = 1806,
  [2008] = 1789,
  [2009] = 1783,
  [2010] = 1894,
  [2011] = 1784,
  [2012] = 2012,
  [2013] = 1783,
  [2014] = 1838,
  [2015] = 1778,
  [2016] = 1860,
  [2017] = 2012,
  [2018] = 1778,
  [2019] = 1784,
  [2020] = 1837,
};

static TSCharacterRange sym_number_literal_character_set_13[] = {
  {'0', '9'}, {'B', 'B'}, {'D', 'D'}, {'F', 'F'}, {'L', 'L'}, {'U', 'U'}, {'W', 'W'}, {'b', 'b'},
  {'d', 'd'}, {'f', 'f'}, {'l', 'l'}, {'u', 'u'}, {'w', 'w'},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a},
  {0x66e, 0x66f}, {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710},
  {0x712, 0x72f}, {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a},
  {0x824, 0x824}, {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939},
  {0x93d, 0x93d}, {0x950, 0x950}, {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0},
  {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc},
  {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c},
  {0xa5e, 0xa5e}, {0xa72, 0xa74}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabd, 0xabd}, {0xad0, 0xad0}, {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30},
  {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbd0, 0xbd0}, {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc61}, {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd},
  {0xcdd, 0xcde}, {0xce0, 0xce1}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e},
  {0xd54, 0xd56}, {0xd5f, 0xd61}, {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6},
  {0xe01, 0xe30}, {0xe32, 0xe32}, {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5},
  {0xea7, 0xeb0}, {0xeb2, 0xeb2}, {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47},
  {0xf49, 0xf6c}, {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066},
  {0x106e, 0x1070}, {0x1075, 0x1081}, {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248},
  {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
  {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711},
  {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878},
  {0x1880, 0x18a8}, {0x18aa, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9},
  {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5},
  {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3},
  {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f},
  {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126},
  {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee},
  {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6},
  {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007},
  {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f},
  {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f},
  {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1},
  {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3},
  {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf},
  {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a},
  {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea},
  {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69},
  {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1},
  {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77},
  {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a},
  {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1},
  {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba},
  {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e},
  {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13},
  {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55},
  {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1},
  {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072},
  {0x11075, 0x11075}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176},
  {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x11288, 0x11288},
  {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330},
  {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461},
  {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa},
  {0x116b8, 0x116b8}, {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913},
  {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3},
  {0x11a00, 0x11a00}, {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08},
  {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65},
  {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543},
  {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f},
  {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1},
  {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122},
  {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2f800, 0x2fa1d}, {0x30000, 0x3134a},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5},
  {0xb7, 0xb7}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec},
  {0x2ee, 0x2ee}, {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1},
  {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd},
  {0x5bf, 0x5bf}, {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669},
  {0x66e, 0x6d3}, {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5},
  {0x7fa, 0x7fa}, {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1},
  {0x8e3, 0x963}, {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2},
  {0x9b6, 0x9b9}, {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1},
  {0x9fc, 0x9fc}, {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33},
  {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c},
  {0xa5e, 0xa5e}, {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3},
  {0xab5, 0xab9}, {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff},
  {0xb01, 0xb03}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44},
  {0xb47, 0xb48}, {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83},
  {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa},
  {0xbae, 0xbb9}, {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a},
  {0xc5d, 0xc5d}, {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3},
  {0xcb5, 0xcb9}, {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef},
  {0xcf1, 0xcf2}, {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63},
  {0xd66, 0xd6f}, {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6},
  {0xdca, 0xdca}, {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e},
  {0xe50, 0xe59}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4},
  {0xec6, 0xec6}, {0xec8, 0xecd}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35},
  {0xf37, 0xf37}, {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6},
  {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d},
  {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be},
  {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371},
  {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8},
  {0x1700, 0x1715}, {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7},
  {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e},
  {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b},
  {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c},
  {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba},
  {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x203f, 0x2040}, {0x2054, 0x2054},
  {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107},
  {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f},
  {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d},
  {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6},
  {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c},
  {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d},
  {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827},
  {0xa82c, 0xa82c}, {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953},
  {0xa960, 0xa97c}, {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76},
  {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26},
  {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6},
  {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c},
  {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7},
  {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77},
  {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a},
  {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a},
  {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0},
  {0x102e0, 0x102e0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5},
  {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a},
  {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755},
  {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838},
  {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939},
  {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a},
  {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72},
  {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac},
  {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046},
  {0x11066, 0x11075}, {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147},
  {0x11150, 0x11173}, {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237},
  {0x1123e, 0x1123e}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9},
  {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344},
  {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a},
  {0x11450, 0x11459}, {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd},
  {0x11600, 0x11640}, {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739},
  {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935},
  {0x11937, 0x11938}, {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e},
  {0x11a47, 0x11a47}, {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59},
  {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d},
  {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9},
  {0x11ee0, 0x11ef6}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646},
  {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36},
  {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f},
  {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb},
  {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88},
  {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b},
  {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac},
  {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539},
  {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa},
  {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb},
  {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e},
  {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27},
  {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b},
  {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f},
  {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89},
  {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d},
  {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(120);
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 75,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 124,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 2,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(118);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(43);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(43);
      if (lookahead == '\r') SKIP(1);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(46);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(46);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(45);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(45);
      if (lookahead == '\r') SKIP(5);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(47);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(47);
      if (lookahead == '\r') SKIP(7);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(49);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(49);
      if (lookahead == '\r') SKIP(9);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(52);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(52);
      if (lookahead == '\r') SKIP(11);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(53);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(53);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(57);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(57);
      if (lookahead == '\r') SKIP(15);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(50);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(50);
      if (lookahead == '\r') SKIP(17);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(51);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(51);
      if (lookahead == '\r') SKIP(19);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(48);
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(48);
      if (lookahead == '\r') SKIP(21);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(25);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(25);
      if (lookahead == '\r') SKIP(23);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '\n', 129,
        '!', 68,
        '%', 203,
        '&', 212,
        '(', 185,
        '*', 199,
        '+', 194,
        '-', 189,
        '/', 201,
        '<', 221,
        '=', 69,
        '>', 217,
      );
      if (lookahead == '\\') SKIP(24);
      if (lookahead == '^') ADVANCE(209);
      if (lookahead == '|') ADVANCE(208);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(25);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(56);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(56);
      if (lookahead == '\r') SKIP(26);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(54);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(54);
      if (lookahead == '\r') SKIP(28);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(58);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '/') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(279);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(281);
      if (lookahead != 0) ADVANCE(278);
      END_STATE();
    case 31:
      if (lookahead == '\n') ADVANCE(293);
      if (lookahead == '\r') ADVANCE(292);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      if (lookahead == 'x') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 32:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(36);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(36);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(35);
      if (lookahead == '(') ADVANCE(185);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 35:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '(') ADVANCE(185);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 36:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(55);
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '/') ADVANCE(287);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(290);
      if (lookahead != 0) ADVANCE(291);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(59);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(59);
      if (lookahead == '\r') SKIP(38);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(44);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(44);
      if (lookahead == '\r') SKIP(40);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 42:
      if (lookahead == '\r') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(313);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 75,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 2,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 83,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 232,
        '\\', 41,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 75,
        '&', 211,
        '\'', 277,
        '(', 185,
        '*', 199,
        '+', 196,
        ',', 126,
        '-', 191,
        '.', 96,
        '/', 60,
        '0', 259,
        ':', 67,
        ';', 226,
        'L', 298,
        'U', 300,
        '[', 73,
        '\\', 6,
        ']', 74,
        'u', 302,
        '{', 230,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 79,
        '&', 211,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 199,
        '+', 196,
        ',', 126,
        '-', 191,
        '.', 254,
        '/', 60,
        '0', 259,
        ':', 237,
        ';', 226,
        '=', 235,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 4,
        ']', 234,
        'u', 302,
        '{', 230,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(46);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 77,
        '&', 211,
        '\'', 277,
        '(', 185,
        '*', 199,
        '+', 196,
        '-', 191,
        '.', 96,
        '/', 60,
        '0', 259,
        ';', 226,
        'L', 298,
        'U', 300,
        '[', 73,
        '\\', 8,
        'u', 302,
        '{', 230,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 186,
        '\'', 277,
        '(', 185,
        ')', 127,
        '+', 198,
        '-', 193,
        '.', 96,
        '/', 60,
        '0', 259,
        'L', 306,
        'U', 307,
        '\\', 22,
        'u', 308,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 68,
        '"', 286,
        '#', 83,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 252,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 299,
        'U', 301,
        '[', 233,
        '\\', 10,
        ']', 234,
        '^', 210,
        'u', 303,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 68,
        '#', 83,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 252,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        '[', 233,
        '\\', 18,
        ']', 234,
        '^', 210,
        '{', 230,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 68,
        '#', 83,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 251,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        '[', 232,
        '\\', 20,
        ']', 74,
        '^', 210,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 68,
        '#', 76,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 252,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        '[', 233,
        '\\', 12,
        '^', 210,
        '{', 230,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '!', 68,
        '#', 78,
        '%', 203,
        '&', 212,
        '(', 185,
        ')', 127,
        '*', 199,
        '+', 194,
        ',', 126,
        '-', 189,
        '/', 201,
        ';', 226,
        '<', 221,
        '=', 236,
        '>', 217,
        '[', 233,
        '\\', 14,
        '^', 209,
        '{', 230,
        '|', 208,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 54:
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '<') ADVANCE(70);
      if (lookahead == 'L') ADVANCE(299);
      if (lookahead == 'U') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == 'u') ADVANCE(303);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 55:
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(93);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '}') ADVANCE(231);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(80);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '}') ADVANCE(231);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 58:
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      END_STATE();
    case 59:
      if (lookahead == '(') ADVANCE(185);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 60:
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      END_STATE();
    case 61:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '/') ADVANCE(311);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 63:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 64:
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(257);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(258);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(267);
      END_STATE();
    case 65:
      if (lookahead == '.') ADVANCE(125);
      END_STATE();
    case 66:
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 67:
      if (lookahead == ':') ADVANCE(227);
      END_STATE();
    case 68:
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 69:
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 70:
      if (lookahead == '>') ADVANCE(296);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '>') ADVANCE(297);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 73:
      if (lookahead == '[') ADVANCE(228);
      END_STATE();
    case 74:
      if (lookahead == ']') ADVANCE(229);
      END_STATE();
    case 75:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 79:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 80:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 81:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(83);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 87:
      if (lookahead == 'f') ADVANCE(136);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(130);
      END_STATE();
    case 89:
      if (lookahead == 'f') ADVANCE(138);
      END_STATE();
    case 90:
      if (lookahead == 'f') ADVANCE(140);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 95:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 96:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      END_STATE();
    case 97:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(267);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(264);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(267);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(262);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(292);
      END_STATE();
    case 103:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(98);
      END_STATE();
    case 104:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 105:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 106:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 107:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 108:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 109:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(107);
      END_STATE();
    case 110:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 111:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 113:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 117:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(152);
      END_STATE();
    case 118:
      if (eof) ADVANCE(120);
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 75,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 2,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(118);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 119:
      if (eof) ADVANCE(120);
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 79,
        '&', 211,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 199,
        '+', 196,
        ',', 126,
        '-', 191,
        '.', 254,
        '/', 60,
        '0', 259,
        ':', 237,
        ';', 226,
        '=', 235,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 4,
        ']', 234,
        'u', 302,
        '{', 230,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(119);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 658, lookahead)) ADVANCE(310);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(165);
      if (lookahead == 'n') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(62);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(311);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(62);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(318);
      if (lookahead == '\r') ADVANCE(312);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '\r') ADVANCE(146);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(153);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(151);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(317);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(143);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(152);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(170);
      if (lookahead == 's') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(177);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(249);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (lookahead == '=') ADVANCE(243);
      if (lookahead == '>') ADVANCE(255);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(249);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(249);
      if (lookahead == '=') ADVANCE(243);
      if (lookahead == '>') ADVANCE(255);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(250);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (lookahead == '=') ADVANCE(242);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(250);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(250);
      if (lookahead == '=') ADVANCE(242);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(239);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(241);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(248);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(206);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(206);
      if (lookahead == '=') ADVANCE(246);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(225);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(222);
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(244);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(228);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(65);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(96);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 97,
        '.', 270,
        'B', 266,
        'b', 266,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'X', 100,
        'x', 100,
        'A', 267,
        'C', 267,
        'a', 267,
        'c', 267,
        'D', 267,
        'F', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 97,
        '.', 270,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'A', 267,
        'C', 267,
        'a', 267,
        'c', 267,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 95,
        '.', 270,
        'B', 268,
        'b', 268,
        'X', 64,
        'x', 64,
        'E', 269,
        'P', 269,
        'e', 269,
        'p', 269,
        'D', 272,
        'F', 272,
        'L', 272,
        'U', 272,
        'W', 272,
        'd', 272,
        'f', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 95,
        '.', 270,
        'B', 271,
        'b', 271,
        'X', 100,
        'x', 100,
        'E', 269,
        'P', 269,
        'e', 269,
        'p', 269,
        'D', 272,
        'F', 272,
        'L', 272,
        'U', 272,
        'W', 272,
        'd', 272,
        'f', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(95);
      if (lookahead == '.') ADVANCE(270);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 101,
        'B', 262,
        'D', 262,
        'F', 262,
        'b', 262,
        'd', 262,
        'f', 262,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 99,
        '+', 101,
        '-', 101,
        'E', 263,
        'e', 263,
        'P', 269,
        'p', 269,
        'B', 264,
        'D', 264,
        'F', 264,
        'b', 264,
        'd', 264,
        'f', 264,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(264);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 99,
        'E', 263,
        'e', 263,
        'P', 269,
        'p', 269,
        'B', 264,
        'D', 264,
        'F', 264,
        'b', 264,
        'd', 264,
        'f', 264,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(264);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 270,
        '+', 101,
        '-', 101,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(267);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 270,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'A', 267,
        'C', 267,
        'a', 267,
        'c', 267,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 270,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(267);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '+', 101,
        '-', 101,
        'B', 262,
        'D', 262,
        'F', 262,
        'b', 262,
        'd', 262,
        'f', 262,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(262);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        'E', 263,
        'e', 263,
        'P', 269,
        'p', 269,
        'B', 264,
        'D', 264,
        'F', 264,
        'b', 264,
        'd', 264,
        'f', 264,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(264);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        'B', 272,
        'D', 272,
        'F', 272,
        'L', 272,
        'U', 272,
        'W', 272,
        'b', 272,
        'd', 272,
        'f', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_L_SQUOTE);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_u_SQUOTE);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_U_SQUOTE);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_u8_SQUOTE);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\n') ADVANCE(293);
      if (lookahead == '\r') ADVANCE(292);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      if (lookahead == 'x') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\\') ADVANCE(31);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(289);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(288);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(289);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(288);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(287);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(290);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(31);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(294);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(296);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(282);
      if (lookahead == '\'') ADVANCE(273);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(282);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(284);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(284);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(283);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '8') ADVANCE(304);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(283);
      if (lookahead == '8') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(285);
      if (lookahead == '\'') ADVANCE(276);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(285);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(273);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '8') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(276);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 765, lookahead)) ADVANCE(310);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(318);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(313);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(317);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(316);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(316);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(318);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4);
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'U') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'R') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(28);
      END_STATE();
    case 5:
      if (lookahead == 'A') ADVANCE(29);
      if (lookahead == 'G') ADVANCE(30);
      if (lookahead == 'N') ADVANCE(31);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'l') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(67);
      if (lookahead == 'y') ADVANCE(68);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'L') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'U') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 32:
      ADVANCE_MAP(
        'a', 80,
        'b', 81,
        'c', 82,
        'd', 83,
        'e', 84,
        'f', 85,
        'i', 86,
        'l', 87,
        'r', 88,
        's', 89,
        't', 90,
        'u', 91,
        'v', 92,
      );
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(96);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(118);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(124);
      if (lookahead == 'z') ADVANCE(125);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 73:
      if (lookahead == 'S') ADVANCE(139);
      END_STATE();
    case 74:
      if (lookahead == 'L') ADVANCE(140);
      END_STATE();
    case 75:
      if (lookahead == 'E') ADVANCE(141);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'x') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(157);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(160);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(164);
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(169);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(170);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(175);
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(179);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 106:
      if (lookahead == 'm') ADVANCE(181);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(186);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(187);
      if (lookahead == '3') ADVANCE(188);
      if (lookahead == '6') ADVANCE(189);
      if (lookahead == '8') ADVANCE(190);
      if (lookahead == 'p') ADVANCE(191);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(192);
      END_STATE();
    case 115:
      if (lookahead == '_') ADVANCE(193);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(197);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(200);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 126:
      if (lookahead == 'z') ADVANCE(204);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 135:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(213);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 139:
      if (lookahead == 'E') ADVANCE(215);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 143:
      if (lookahead == 'm') ADVANCE(217);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 147:
      if (lookahead == 'm') ADVANCE(221);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(222);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(227);
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(229);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 161:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(237);
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 163:
      if (lookahead == 'y') ADVANCE(239);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 167:
      if (lookahead == 'g') ADVANCE(243);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_auto);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_primitive_type);
      END_STATE();
    case 172:
      if (lookahead == 'k') ADVANCE(246);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(247);
      if (lookahead == '3') ADVANCE(248);
      if (lookahead == '6') ADVANCE(249);
      if (lookahead == '8') ADVANCE(250);
      if (lookahead == 'p') ADVANCE(251);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 176:
      if (lookahead == 'i') ADVANCE(253);
      END_STATE();
    case 177:
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 179:
      if (lookahead == 'l') ADVANCE(256);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 186:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 187:
      if (lookahead == '6') ADVANCE(259);
      END_STATE();
    case 188:
      if (lookahead == '2') ADVANCE(260);
      END_STATE();
    case 189:
      if (lookahead == '4') ADVANCE(261);
      END_STATE();
    case 190:
      if (lookahead == '_') ADVANCE(262);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 195:
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 197:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 198:
      if (lookahead == 's') ADVANCE(269);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 200:
      if (lookahead == 'r') ADVANCE(271);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 203:
      if (lookahead == '_') ADVANCE(274);
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(277);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(278);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(279);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 210:
      if (lookahead == '1') ADVANCE(282);
      if (lookahead == '3') ADVANCE(283);
      if (lookahead == '6') ADVANCE(284);
      if (lookahead == '8') ADVANCE(285);
      if (lookahead == 'p') ADVANCE(286);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 212:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(291);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(294);
      END_STATE();
    case 220:
      if (lookahead == 'g') ADVANCE(295);
      END_STATE();
    case 221:
      if (lookahead == '_') ADVANCE(296);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(298);
      END_STATE();
    case 224:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 225:
      if (lookahead == 'c') ADVANCE(300);
      END_STATE();
    case 226:
      if (lookahead == 'l') ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 229:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 230:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 231:
      if (lookahead == 'c') ADVANCE(306);
      END_STATE();
    case 232:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 233:
      if (lookahead == 'v') ADVANCE(308);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 236:
      if (lookahead == 'c') ADVANCE(311);
      END_STATE();
    case 237:
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym___try);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 241:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 242:
      if (lookahead == 't') ADVANCE(316);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(318);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(319);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 247:
      if (lookahead == '6') ADVANCE(320);
      END_STATE();
    case 248:
      if (lookahead == '2') ADVANCE(321);
      END_STATE();
    case 249:
      if (lookahead == '4') ADVANCE(322);
      END_STATE();
    case 250:
      if (lookahead == '_') ADVANCE(323);
      END_STATE();
    case 251:
      if (lookahead == 't') ADVANCE(324);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 254:
      if (lookahead == 'l') ADVANCE(327);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(328);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(329);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 259:
      if (lookahead == '_') ADVANCE(331);
      END_STATE();
    case 260:
      if (lookahead == '_') ADVANCE(332);
      END_STATE();
    case 261:
      if (lookahead == '_') ADVANCE(333);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(334);
      END_STATE();
    case 264:
      if (lookahead == 'l') ADVANCE(335);
      END_STATE();
    case 265:
      if (lookahead == 'u') ADVANCE(336);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(337);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(338);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(339);
      END_STATE();
    case 269:
      if (lookahead == 't') ADVANCE(340);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(341);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(342);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 273:
      if (lookahead == 'd') ADVANCE(343);
      END_STATE();
    case 274:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 275:
      if (lookahead == 'f') ADVANCE(344);
      END_STATE();
    case 276:
      if (lookahead == '_') ADVANCE(345);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(346);
      END_STATE();
    case 278:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 279:
      if (lookahead == 'h') ADVANCE(348);
      END_STATE();
    case 280:
      if (lookahead == 'd') ADVANCE(349);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 282:
      if (lookahead == '6') ADVANCE(351);
      END_STATE();
    case 283:
      if (lookahead == '2') ADVANCE(352);
      END_STATE();
    case 284:
      if (lookahead == '4') ADVANCE(353);
      END_STATE();
    case 285:
      if (lookahead == '_') ADVANCE(354);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 288:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(357);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 291:
      if (lookahead == 'o') ADVANCE(358);
      END_STATE();
    case 292:
      if (lookahead == 'c') ADVANCE(359);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(360);
      END_STATE();
    case 294:
      if (lookahead == 'u') ADVANCE(361);
      END_STATE();
    case 295:
      if (lookahead == 'n') ADVANCE(362);
      END_STATE();
    case 296:
      if (lookahead == '_') ADVANCE(363);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(364);
      END_STATE();
    case 298:
      if (lookahead == 'd') ADVANCE(365);
      END_STATE();
    case 299:
      if (lookahead == 'l') ADVANCE(366);
      END_STATE();
    case 300:
      if (lookahead == 'a') ADVANCE(367);
      END_STATE();
    case 301:
      if (lookahead == 's') ADVANCE(368);
      END_STATE();
    case 302:
      if (lookahead == 'p') ADVANCE(369);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(370);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(371);
      END_STATE();
    case 305:
      if (lookahead == 'l') ADVANCE(372);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(376);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_ms_signed_ptr_modifier);
      END_STATE();
    case 311:
      if (lookahead == 'a') ADVANCE(377);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(378);
      END_STATE();
    case 313:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(380);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_ms_unsigned_ptr_modifier);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(381);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 318:
      if (lookahead == 'g') ADVANCE(383);
      END_STATE();
    case 319:
      if (lookahead == 'f') ADVANCE(384);
      END_STATE();
    case 320:
      if (lookahead == '_') ADVANCE(385);
      END_STATE();
    case 321:
      if (lookahead == '_') ADVANCE(386);
      END_STATE();
    case 322:
      if (lookahead == '_') ADVANCE(387);
      END_STATE();
    case 323:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 324:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 325:
      if (lookahead == 'x') ADVANCE(389);
      END_STATE();
    case 326:
      if (lookahead == 'u') ADVANCE(390);
      END_STATE();
    case 327:
      if (lookahead == 't') ADVANCE(391);
      END_STATE();
    case 328:
      if (lookahead == 'd') ADVANCE(392);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 331:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 334:
      if (lookahead == '_') ADVANCE(393);
      END_STATE();
    case 335:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 336:
      if (lookahead == 'r') ADVANCE(395);
      END_STATE();
    case 337:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 338:
      if (lookahead == 'o') ADVANCE(397);
      END_STATE();
    case 339:
      if (lookahead == 'f') ADVANCE(398);
      END_STATE();
    case 340:
      if (lookahead == 'e') ADVANCE(399);
      END_STATE();
    case 341:
      if (lookahead == 'c') ADVANCE(400);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 345:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 349:
      if (lookahead == '_') ADVANCE(401);
      END_STATE();
    case 350:
      if (lookahead == 'f') ADVANCE(402);
      END_STATE();
    case 351:
      if (lookahead == '_') ADVANCE(403);
      END_STATE();
    case 352:
      if (lookahead == '_') ADVANCE(404);
      END_STATE();
    case 353:
      if (lookahead == '_') ADVANCE(405);
      END_STATE();
    case 354:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 355:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(407);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(408);
      END_STATE();
    case 358:
      if (lookahead == 'f') ADVANCE(409);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym__Atomic);
      END_STATE();
    case 360:
      if (lookahead == 'c') ADVANCE(410);
      END_STATE();
    case 361:
      if (lookahead == 'r') ADVANCE(411);
      END_STATE();
    case 362:
      if (lookahead == 'o') ADVANCE(412);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym___asm__);
      END_STATE();
    case 364:
      if (lookahead == 'b') ADVANCE(413);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym___based);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym___cdecl);
      END_STATE();
    case 367:
      if (lookahead == 'l') ADVANCE(414);
      END_STATE();
    case 368:
      if (lookahead == 'p') ADVANCE(415);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 370:
      if (lookahead == 's') ADVANCE(417);
      END_STATE();
    case 371:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 372:
      if (lookahead == 'l') ADVANCE(419);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(420);
      END_STATE();
    case 374:
      if (lookahead == 'e') ADVANCE(421);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym___leave);
      END_STATE();
    case 376:
      if (lookahead == 'i') ADVANCE(422);
      END_STATE();
    case 377:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 378:
      if (lookahead == 'a') ADVANCE(424);
      END_STATE();
    case 379:
      if (lookahead == 'd') ADVANCE(425);
      END_STATE();
    case 380:
      if (lookahead == 'g') ADVANCE(426);
      END_STATE();
    case 381:
      if (lookahead == 'r') ADVANCE(427);
      END_STATE();
    case 382:
      if (lookahead == 'f') ADVANCE(428);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(429);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_alignof);
      END_STATE();
    case 385:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 388:
      if (lookahead == '_') ADVANCE(430);
      END_STATE();
    case 389:
      if (lookahead == 'p') ADVANCE(431);
      END_STATE();
    case 390:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 394:
      if (lookahead == 'g') ADVANCE(433);
      END_STATE();
    case 395:
      if (lookahead == 'n') ADVANCE(434);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_nullptr);
      if (lookahead == '_') ADVANCE(435);
      END_STATE();
    case 397:
      if (lookahead == 'f') ADVANCE(436);
      END_STATE();
    case 398:
      if (lookahead == '_') ADVANCE(437);
      END_STATE();
    case 399:
      if (lookahead == 'r') ADVANCE(438);
      END_STATE();
    case 400:
      if (lookahead == 't') ADVANCE(439);
      END_STATE();
    case 401:
      if (lookahead == 'l') ADVANCE(440);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 403:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 406:
      if (lookahead == '_') ADVANCE(441);
      END_STATE();
    case 407:
      if (lookahead == 'd') ADVANCE(442);
      END_STATE();
    case 408:
      if (lookahead == 'e') ADVANCE(443);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym__Alignof);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym__Generic);
      END_STATE();
    case 411:
      if (lookahead == 'n') ADVANCE(444);
      END_STATE();
    case 412:
      if (lookahead == 'f') ADVANCE(445);
      END_STATE();
    case 413:
      if (lookahead == 'u') ADVANCE(446);
      END_STATE();
    case 414:
      if (lookahead == 'l') ADVANCE(447);
      END_STATE();
    case 415:
      if (lookahead == 'e') ADVANCE(448);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym___except);
      END_STATE();
    case 417:
      if (lookahead == 'i') ADVANCE(449);
      END_STATE();
    case 418:
      if (lookahead == 'l') ADVANCE(450);
      END_STATE();
    case 419:
      if (lookahead == 'y') ADVANCE(451);
      END_STATE();
    case 420:
      if (lookahead == 'n') ADVANCE(452);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym___inline);
      if (lookahead == '_') ADVANCE(453);
      END_STATE();
    case 422:
      if (lookahead == 'c') ADVANCE(454);
      END_STATE();
    case 423:
      if (lookahead == 'l') ADVANCE(455);
      END_STATE();
    case 424:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym___thread);
      END_STATE();
    case 426:
      if (lookahead == 'n') ADVANCE(457);
      END_STATE();
    case 427:
      if (lookahead == 'c') ADVANCE(458);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym__alignof);
      END_STATE();
    case 429:
      if (lookahead == 'e') ADVANCE(459);
      END_STATE();
    case 430:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 431:
      if (lookahead == 'r') ADVANCE(460);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 433:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_noreturn);
      END_STATE();
    case 435:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_offsetof);
      END_STATE();
    case 437:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_register);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_restrict);
      END_STATE();
    case 440:
      if (lookahead == 'o') ADVANCE(462);
      END_STATE();
    case 441:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym__Noreturn);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym___alignof);
      if (lookahead == '_') ADVANCE(463);
      END_STATE();
    case 446:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym___clrcall);
      END_STATE();
    case 448:
      if (lookahead == 'c') ADVANCE(465);
      END_STATE();
    case 449:
      if (lookahead == 'o') ADVANCE(466);
      END_STATE();
    case 450:
      if (lookahead == 'l') ADVANCE(467);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym___finally);
      END_STATE();
    case 452:
      if (lookahead == 'l') ADVANCE(468);
      END_STATE();
    case 453:
      if (lookahead == '_') ADVANCE(469);
      END_STATE();
    case 454:
      if (lookahead == 't') ADVANCE(470);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym___stdcall);
      END_STATE();
    case 456:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 457:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 458:
      if (lookahead == 'a') ADVANCE(473);
      END_STATE();
    case 459:
      if (lookahead == 'd') ADVANCE(474);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_constexpr);
      END_STATE();
    case 461:
      if (lookahead == '_') ADVANCE(475);
      END_STATE();
    case 462:
      if (lookahead == 'c') ADVANCE(476);
      END_STATE();
    case 463:
      if (lookahead == '_') ADVANCE(477);
      END_STATE();
    case 464:
      if (lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym___declspec);
      END_STATE();
    case 466:
      if (lookahead == 'n') ADVANCE(479);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym___fastcall);
      END_STATE();
    case 468:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym___inline__);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_ms_restrict_modifier);
      if (lookahead == '_') ADVANCE(481);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym___thiscall);
      END_STATE();
    case 472:
      if (lookahead == 'd') ADVANCE(482);
      END_STATE();
    case 473:
      if (lookahead == 'l') ADVANCE(483);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym__unaligned);
      END_STATE();
    case 475:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 476:
      if (lookahead == 'a') ADVANCE(484);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym___alignof__);
      END_STATE();
    case 478:
      if (lookahead == '_') ADVANCE(485);
      END_STATE();
    case 479:
      if (lookahead == '_') ADVANCE(486);
      END_STATE();
    case 480:
      if (lookahead == 'n') ADVANCE(487);
      END_STATE();
    case 481:
      if (lookahead == '_') ADVANCE(488);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym___unaligned);
      END_STATE();
    case 483:
      if (lookahead == 'l') ADVANCE(489);
      END_STATE();
    case 484:
      if (lookahead == 'l') ADVANCE(490);
      END_STATE();
    case 485:
      if (lookahead == '_') ADVANCE(491);
      END_STATE();
    case 486:
      if (lookahead == '_') ADVANCE(492);
      END_STATE();
    case 487:
      if (lookahead == 'e') ADVANCE(493);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym___restrict__);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym___vectorcall);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_thread_local);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym___attribute__);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym___extension__);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym___forceinline);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 119},
  [2] = {.lex_state = 45},
  [3] = {.lex_state = 45},
  [4] = {.lex_state = 45},
  [5] = {.lex_state = 45},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 45},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 45},
  [14] = {.lex_state = 45},
  [15] = {.lex_state = 45},
  [16] = {.lex_state = 45},
  [17] = {.lex_state = 45},
  [18] = {.lex_state = 45},
  [19] = {.lex_state = 45},
  [20] = {.lex_state = 45},
  [21] = {.lex_state = 45},
  [22] = {.lex_state = 45},
  [23] = {.lex_state = 119},
  [24] = {.lex_state = 47},
  [25] = {.lex_state = 47},
  [26] = {.lex_state = 119},
  [27] = {.lex_state = 47},
  [28] = {.lex_state = 119},
  [29] = {.lex_state = 119},
  [30] = {.lex_state = 119},
  [31] = {.lex_state = 119},
  [32] = {.lex_state = 119},
  [33] = {.lex_state = 119},
  [34] = {.lex_state = 119},
  [35] = {.lex_state = 119},
  [36] = {.lex_state = 119},
  [37] = {.lex_state = 119},
  [38] = {.lex_state = 119},
  [39] = {.lex_state = 119},
  [40] = {.lex_state = 119},
  [41] = {.lex_state = 119},
  [42] = {.lex_state = 119},
  [43] = {.lex_state = 119},
  [44] = {.lex_state = 119},
  [45] = {.lex_state = 45},
  [46] = {.lex_state = 45},
  [47] = {.lex_state = 45},
  [48] = {.lex_state = 45},
  [49] = {.lex_state = 45},
  [50] = {.lex_state = 119},
  [51] = {.lex_state = 119},
  [52] = {.lex_state = 119},
  [53] = {.lex_state = 119},
  [54] = {.lex_state = 47},
  [55] = {.lex_state = 47},
  [56] = {.lex_state = 119},
  [57] = {.lex_state = 47},
  [58] = {.lex_state = 47},
  [59] = {.lex_state = 119},
  [60] = {.lex_state = 119},
  [61] = {.lex_state = 119},
  [62] = {.lex_state = 119},
  [63] = {.lex_state = 47},
  [64] = {.lex_state = 119},
  [65] = {.lex_state = 119},
  [66] = {.lex_state = 119},
  [67] = {.lex_state = 119},
  [68] = {.lex_state = 119},
  [69] = {.lex_state = 119},
  [70] = {.lex_state = 119},
  [71] = {.lex_state = 119},
  [72] = {.lex_state = 119},
  [73] = {.lex_state = 119},
  [74] = {.lex_state = 119},
  [75] = {.lex_state = 45},
  [76] = {.lex_state = 45},
  [77] = {.lex_state = 45},
  [78] = {.lex_state = 45},
  [79] = {.lex_state = 45},
  [80] = {.lex_state = 45},
  [81] = {.lex_state = 45},
  [82] = {.lex_state = 45},
  [83] = {.lex_state = 45},
  [84] = {.lex_state = 45},
  [85] = {.lex_state = 45},
  [86] = {.lex_state = 45},
  [87] = {.lex_state = 45},
  [88] = {.lex_state = 45},
  [89] = {.lex_state = 45},
  [90] = {.lex_state = 45},
  [91] = {.lex_state = 45},
  [92] = {.lex_state = 119},
  [93] = {.lex_state = 45},
  [94] = {.lex_state = 45},
  [95] = {.lex_state = 45},
  [96] = {.lex_state = 45},
  [97] = {.lex_state = 45},
  [98] = {.lex_state = 45},
  [99] = {.lex_state = 45},
  [100] = {.lex_state = 45},
  [101] = {.lex_state = 45},
  [102] = {.lex_state = 45},
  [103] = {.lex_state = 45},
  [104] = {.lex_state = 45},
  [105] = {.lex_state = 45},
  [106] = {.lex_state = 45},
  [107] = {.lex_state = 45},
  [108] = {.lex_state = 45},
  [109] = {.lex_state = 45},
  [110] = {.lex_state = 45},
  [111] = {.lex_state = 119},
  [112] = {.lex_state = 45},
  [113] = {.lex_state = 45},
  [114] = {.lex_state = 45},
  [115] = {.lex_state = 45},
  [116] = {.lex_state = 45},
  [117] = {.lex_state = 45},
  [118] = {.lex_state = 45},
  [119] = {.lex_state = 45},
  [120] = {.lex_state = 45},
  [121] = {.lex_state = 45},
  [122] = {.lex_state = 45},
  [123] = {.lex_state = 45},
  [124] = {.lex_state = 45},
  [125] = {.lex_state = 45},
  [126] = {.lex_state = 45},
  [127] = {.lex_state = 45},
  [128] = {.lex_state = 45},
  [129] = {.lex_state = 45},
  [130] = {.lex_state = 45},
  [131] = {.lex_state = 45},
  [132] = {.lex_state = 45},
  [133] = {.lex_state = 45},
  [134] = {.lex_state = 45},
  [135] = {.lex_state = 45},
  [136] = {.lex_state = 45},
  [137] = {.lex_state = 45},
  [138] = {.lex_state = 45},
  [139] = {.lex_state = 45},
  [140] = {.lex_state = 45},
  [141] = {.lex_state = 45},
  [142] = {.lex_state = 45},
  [143] = {.lex_state = 45},
  [144] = {.lex_state = 45},
  [145] = {.lex_state = 45},
  [146] = {.lex_state = 45},
  [147] = {.lex_state = 45},
  [148] = {.lex_state = 45},
  [149] = {.lex_state = 45},
  [150] = {.lex_state = 45},
  [151] = {.lex_state = 45},
  [152] = {.lex_state = 45},
  [153] = {.lex_state = 45},
  [154] = {.lex_state = 45},
  [155] = {.lex_state = 45},
  [156] = {.lex_state = 47},
  [157] = {.lex_state = 44},
  [158] = {.lex_state = 119},
  [159] = {.lex_state = 44},
  [160] = {.lex_state = 119},
  [161] = {.lex_state = 47},
  [162] = {.lex_state = 119},
  [163] = {.lex_state = 47},
  [164] = {.lex_state = 47},
  [165] = {.lex_state = 47},
  [166] = {.lex_state = 47},
  [167] = {.lex_state = 47},
  [168] = {.lex_state = 47},
  [169] = {.lex_state = 47},
  [170] = {.lex_state = 47},
  [171] = {.lex_state = 119},
  [172] = {.lex_state = 119},
  [173] = {.lex_state = 47},
  [174] = {.lex_state = 47},
  [175] = {.lex_state = 119},
  [176] = {.lex_state = 47},
  [177] = {.lex_state = 119},
  [178] = {.lex_state = 119},
  [179] = {.lex_state = 119},
  [180] = {.lex_state = 119},
  [181] = {.lex_state = 119},
  [182] = {.lex_state = 119},
  [183] = {.lex_state = 119},
  [184] = {.lex_state = 119},
  [185] = {.lex_state = 119},
  [186] = {.lex_state = 119},
  [187] = {.lex_state = 119},
  [188] = {.lex_state = 47},
  [189] = {.lex_state = 47},
  [190] = {.lex_state = 47},
  [191] = {.lex_state = 47},
  [192] = {.lex_state = 119},
  [193] = {.lex_state = 47},
  [194] = {.lex_state = 119},
  [195] = {.lex_state = 119},
  [196] = {.lex_state = 119},
  [197] = {.lex_state = 119},
  [198] = {.lex_state = 119},
  [199] = {.lex_state = 119},
  [200] = {.lex_state = 47},
  [201] = {.lex_state = 47},
  [202] = {.lex_state = 47},
  [203] = {.lex_state = 47},
  [204] = {.lex_state = 47},
  [205] = {.lex_state = 119},
  [206] = {.lex_state = 119},
  [207] = {.lex_state = 47},
  [208] = {.lex_state = 47},
  [209] = {.lex_state = 47},
  [210] = {.lex_state = 47},
  [211] = {.lex_state = 47},
  [212] = {.lex_state = 119},
  [213] = {.lex_state = 119},
  [214] = {.lex_state = 47},
  [215] = {.lex_state = 119},
  [216] = {.lex_state = 47},
  [217] = {.lex_state = 119},
  [218] = {.lex_state = 119},
  [219] = {.lex_state = 119},
  [220] = {.lex_state = 119},
  [221] = {.lex_state = 47},
  [222] = {.lex_state = 119},
  [223] = {.lex_state = 119},
  [224] = {.lex_state = 47},
  [225] = {.lex_state = 47},
  [226] = {.lex_state = 47},
  [227] = {.lex_state = 47},
  [228] = {.lex_state = 47},
  [229] = {.lex_state = 47},
  [230] = {.lex_state = 47},
  [231] = {.lex_state = 47},
  [232] = {.lex_state = 47},
  [233] = {.lex_state = 119},
  [234] = {.lex_state = 119},
  [235] = {.lex_state = 119},
  [236] = {.lex_state = 47},
  [237] = {.lex_state = 119},
  [238] = {.lex_state = 47},
  [239] = {.lex_state = 119},
  [240] = {.lex_state = 119},
  [241] = {.lex_state = 119},
  [242] = {.lex_state = 119},
  [243] = {.lex_state = 119},
  [244] = {.lex_state = 119},
  [245] = {.lex_state = 119},
  [246] = {.lex_state = 119},
  [247] = {.lex_state = 47},
  [248] = {.lex_state = 119},
  [249] = {.lex_state = 119},
  [250] = {.lex_state = 119},
  [251] = {.lex_state = 47},
  [252] = {.lex_state = 47},
  [253] = {.lex_state = 47},
  [254] = {.lex_state = 47},
  [255] = {.lex_state = 47},
  [256] = {.lex_state = 119},
  [257] = {.lex_state = 47},
  [258] = {.lex_state = 47},
  [259] = {.lex_state = 119},
  [260] = {.lex_state = 119},
  [261] = {.lex_state = 119},
  [262] = {.lex_state = 119},
  [263] = {.lex_state = 119},
  [264] = {.lex_state = 119},
  [265] = {.lex_state = 119},
  [266] = {.lex_state = 119},
  [267] = {.lex_state = 119},
  [268] = {.lex_state = 119},
  [269] = {.lex_state = 119},
  [270] = {.lex_state = 119},
  [271] = {.lex_state = 119},
  [272] = {.lex_state = 119},
  [273] = {.lex_state = 119},
  [274] = {.lex_state = 119},
  [275] = {.lex_state = 119},
  [276] = {.lex_state = 119},
  [277] = {.lex_state = 119},
  [278] = {.lex_state = 119},
  [279] = {.lex_state = 119},
  [280] = {.lex_state = 119},
  [281] = {.lex_state = 119},
  [282] = {.lex_state = 119},
  [283] = {.lex_state = 119},
  [284] = {.lex_state = 119},
  [285] = {.lex_state = 119},
  [286] = {.lex_state = 119},
  [287] = {.lex_state = 119},
  [288] = {.lex_state = 119},
  [289] = {.lex_state = 119},
  [290] = {.lex_state = 119},
  [291] = {.lex_state = 119},
  [292] = {.lex_state = 119},
  [293] = {.lex_state = 119},
  [294] = {.lex_state = 119},
  [295] = {.lex_state = 119},
  [296] = {.lex_state = 47},
  [297] = {.lex_state = 119},
  [298] = {.lex_state = 119},
  [299] = {.lex_state = 119},
  [300] = {.lex_state = 119},
  [301] = {.lex_state = 119},
  [302] = {.lex_state = 119},
  [303] = {.lex_state = 119},
  [304] = {.lex_state = 119},
  [305] = {.lex_state = 119},
  [306] = {.lex_state = 119},
  [307] = {.lex_state = 119},
  [308] = {.lex_state = 119},
  [309] = {.lex_state = 47},
  [310] = {.lex_state = 47},
  [311] = {.lex_state = 119},
  [312] = {.lex_state = 119},
  [313] = {.lex_state = 119},
  [314] = {.lex_state = 119},
  [315] = {.lex_state = 119},
  [316] = {.lex_state = 119},
  [317] = {.lex_state = 119},
  [318] = {.lex_state = 119},
  [319] = {.lex_state = 47},
  [320] = {.lex_state = 119},
  [321] = {.lex_state = 47},
  [322] = {.lex_state = 47},
  [323] = {.lex_state = 119},
  [324] = {.lex_state = 47},
  [325] = {.lex_state = 47},
  [326] = {.lex_state = 47},
  [327] = {.lex_state = 119},
  [328] = {.lex_state = 47},
  [329] = {.lex_state = 47},
  [330] = {.lex_state = 47},
  [331] = {.lex_state = 47},
  [332] = {.lex_state = 47},
  [333] = {.lex_state = 47},
  [334] = {.lex_state = 119},
  [335] = {.lex_state = 119},
  [336] = {.lex_state = 47},
  [337] = {.lex_state = 47},
  [338] = {.lex_state = 119},
  [339] = {.lex_state = 119},
  [340] = {.lex_state = 47},
  [341] = {.lex_state = 47},
  [342] = {.lex_state = 119},
  [343] = {.lex_state = 119},
  [344] = {.lex_state = 119},
  [345] = {.lex_state = 119},
  [346] = {.lex_state = 119},
  [347] = {.lex_state = 119},
  [348] = {.lex_state = 47},
  [349] = {.lex_state = 119},
  [350] = {.lex_state = 119},
  [351] = {.lex_state = 119},
  [352] = {.lex_state = 119},
  [353] = {.lex_state = 47},
  [354] = {.lex_state = 119},
  [355] = {.lex_state = 119},
  [356] = {.lex_state = 47},
  [357] = {.lex_state = 119},
  [358] = {.lex_state = 119},
  [359] = {.lex_state = 119},
  [360] = {.lex_state = 47},
  [361] = {.lex_state = 119},
  [362] = {.lex_state = 119},
  [363] = {.lex_state = 119},
  [364] = {.lex_state = 47},
  [365] = {.lex_state = 47},
  [366] = {.lex_state = 119},
  [367] = {.lex_state = 119},
  [368] = {.lex_state = 119},
  [369] = {.lex_state = 47},
  [370] = {.lex_state = 47},
  [371] = {.lex_state = 119},
  [372] = {.lex_state = 119},
  [373] = {.lex_state = 119},
  [374] = {.lex_state = 119},
  [375] = {.lex_state = 119},
  [376] = {.lex_state = 119},
  [377] = {.lex_state = 119},
  [378] = {.lex_state = 119},
  [379] = {.lex_state = 119},
  [380] = {.lex_state = 119},
  [381] = {.lex_state = 119},
  [382] = {.lex_state = 119},
  [383] = {.lex_state = 47},
  [384] = {.lex_state = 119},
  [385] = {.lex_state = 119},
  [386] = {.lex_state = 119},
  [387] = {.lex_state = 119},
  [388] = {.lex_state = 119},
  [389] = {.lex_state = 119},
  [390] = {.lex_state = 119},
  [391] = {.lex_state = 119},
  [392] = {.lex_state = 119},
  [393] = {.lex_state = 119},
  [394] = {.lex_state = 119},
  [395] = {.lex_state = 119},
  [396] = {.lex_state = 119},
  [397] = {.lex_state = 119},
  [398] = {.lex_state = 119},
  [399] = {.lex_state = 119},
  [400] = {.lex_state = 119},
  [401] = {.lex_state = 119},
  [402] = {.lex_state = 47},
  [403] = {.lex_state = 119},
  [404] = {.lex_state = 119},
  [405] = {.lex_state = 119},
  [406] = {.lex_state = 44},
  [407] = {.lex_state = 119},
  [408] = {.lex_state = 119},
  [409] = {.lex_state = 119},
  [410] = {.lex_state = 119},
  [411] = {.lex_state = 119},
  [412] = {.lex_state = 119},
  [413] = {.lex_state = 119},
  [414] = {.lex_state = 119},
  [415] = {.lex_state = 119},
  [416] = {.lex_state = 119},
  [417] = {.lex_state = 119},
  [418] = {.lex_state = 119},
  [419] = {.lex_state = 119},
  [420] = {.lex_state = 119},
  [421] = {.lex_state = 119},
  [422] = {.lex_state = 119},
  [423] = {.lex_state = 119},
  [424] = {.lex_state = 119},
  [425] = {.lex_state = 119},
  [426] = {.lex_state = 119},
  [427] = {.lex_state = 119},
  [428] = {.lex_state = 119},
  [429] = {.lex_state = 119},
  [430] = {.lex_state = 119},
  [431] = {.lex_state = 119},
  [432] = {.lex_state = 119},
  [433] = {.lex_state = 119},
  [434] = {.lex_state = 119},
  [435] = {.lex_state = 119},
  [436] = {.lex_state = 119},
  [437] = {.lex_state = 119},
  [438] = {.lex_state = 119},
  [439] = {.lex_state = 119},
  [440] = {.lex_state = 119},
  [441] = {.lex_state = 119},
  [442] = {.lex_state = 119},
  [443] = {.lex_state = 119},
  [444] = {.lex_state = 119},
  [445] = {.lex_state = 119},
  [446] = {.lex_state = 119},
  [447] = {.lex_state = 119},
  [448] = {.lex_state = 44},
  [449] = {.lex_state = 44},
  [450] = {.lex_state = 44},
  [451] = {.lex_state = 119},
  [452] = {.lex_state = 49},
  [453] = {.lex_state = 49},
  [454] = {.lex_state = 49},
  [455] = {.lex_state = 49},
  [456] = {.lex_state = 49},
  [457] = {.lex_state = 49},
  [458] = {.lex_state = 119},
  [459] = {.lex_state = 49},
  [460] = {.lex_state = 49},
  [461] = {.lex_state = 49},
  [462] = {.lex_state = 49},
  [463] = {.lex_state = 52},
  [464] = {.lex_state = 119},
  [465] = {.lex_state = 119},
  [466] = {.lex_state = 119},
  [467] = {.lex_state = 119},
  [468] = {.lex_state = 119},
  [469] = {.lex_state = 119},
  [470] = {.lex_state = 119},
  [471] = {.lex_state = 119},
  [472] = {.lex_state = 119},
  [473] = {.lex_state = 119},
  [474] = {.lex_state = 119},
  [475] = {.lex_state = 119},
  [476] = {.lex_state = 119},
  [477] = {.lex_state = 119},
  [478] = {.lex_state = 52},
  [479] = {.lex_state = 52},
  [480] = {.lex_state = 52},
  [481] = {.lex_state = 52},
  [482] = {.lex_state = 52},
  [483] = {.lex_state = 52},
  [484] = {.lex_state = 52},
  [485] = {.lex_state = 52},
  [486] = {.lex_state = 52},
  [487] = {.lex_state = 52},
  [488] = {.lex_state = 52},
  [489] = {.lex_state = 52},
  [490] = {.lex_state = 52},
  [491] = {.lex_state = 52},
  [492] = {.lex_state = 52},
  [493] = {.lex_state = 52},
  [494] = {.lex_state = 52},
  [495] = {.lex_state = 52},
  [496] = {.lex_state = 119},
  [497] = {.lex_state = 119},
  [498] = {.lex_state = 119},
  [499] = {.lex_state = 119},
  [500] = {.lex_state = 119},
  [501] = {.lex_state = 119},
  [502] = {.lex_state = 119},
  [503] = {.lex_state = 119},
  [504] = {.lex_state = 119},
  [505] = {.lex_state = 119},
  [506] = {.lex_state = 119},
  [507] = {.lex_state = 119},
  [508] = {.lex_state = 119},
  [509] = {.lex_state = 119},
  [510] = {.lex_state = 119},
  [511] = {.lex_state = 119},
  [512] = {.lex_state = 119},
  [513] = {.lex_state = 119},
  [514] = {.lex_state = 119},
  [515] = {.lex_state = 119},
  [516] = {.lex_state = 119},
  [517] = {.lex_state = 119},
  [518] = {.lex_state = 119},
  [519] = {.lex_state = 119},
  [520] = {.lex_state = 119},
  [521] = {.lex_state = 119},
  [522] = {.lex_state = 119},
  [523] = {.lex_state = 119},
  [524] = {.lex_state = 119},
  [525] = {.lex_state = 119},
  [526] = {.lex_state = 119},
  [527] = {.lex_state = 53},
  [528] = {.lex_state = 53},
  [529] = {.lex_state = 119},
  [530] = {.lex_state = 119},
  [531] = {.lex_state = 119},
  [532] = {.lex_state = 119},
  [533] = {.lex_state = 57},
  [534] = {.lex_state = 57},
  [535] = {.lex_state = 119},
  [536] = {.lex_state = 119},
  [537] = {.lex_state = 119},
  [538] = {.lex_state = 119},
  [539] = {.lex_state = 53},
  [540] = {.lex_state = 119},
  [541] = {.lex_state = 119},
  [542] = {.lex_state = 119},
  [543] = {.lex_state = 57},
  [544] = {.lex_state = 119},
  [545] = {.lex_state = 119},
  [546] = {.lex_state = 119},
  [547] = {.lex_state = 119},
  [548] = {.lex_state = 119},
  [549] = {.lex_state = 119},
  [550] = {.lex_state = 119},
  [551] = {.lex_state = 119},
  [552] = {.lex_state = 119},
  [553] = {.lex_state = 119},
  [554] = {.lex_state = 119},
  [555] = {.lex_state = 119},
  [556] = {.lex_state = 119},
  [557] = {.lex_state = 119},
  [558] = {.lex_state = 119},
  [559] = {.lex_state = 119},
  [560] = {.lex_state = 119},
  [561] = {.lex_state = 119},
  [562] = {.lex_state = 119},
  [563] = {.lex_state = 119},
  [564] = {.lex_state = 119},
  [565] = {.lex_state = 119},
  [566] = {.lex_state = 119},
  [567] = {.lex_state = 119},
  [568] = {.lex_state = 119},
  [569] = {.lex_state = 119},
  [570] = {.lex_state = 119},
  [571] = {.lex_state = 119},
  [572] = {.lex_state = 119},
  [573] = {.lex_state = 119},
  [574] = {.lex_state = 119},
  [575] = {.lex_state = 119},
  [576] = {.lex_state = 119},
  [577] = {.lex_state = 119},
  [578] = {.lex_state = 119},
  [579] = {.lex_state = 119},
  [580] = {.lex_state = 119},
  [581] = {.lex_state = 119},
  [582] = {.lex_state = 119},
  [583] = {.lex_state = 119},
  [584] = {.lex_state = 119},
  [585] = {.lex_state = 119},
  [586] = {.lex_state = 119},
  [587] = {.lex_state = 119},
  [588] = {.lex_state = 119},
  [589] = {.lex_state = 119},
  [590] = {.lex_state = 119},
  [591] = {.lex_state = 119},
  [592] = {.lex_state = 119},
  [593] = {.lex_state = 119},
  [594] = {.lex_state = 119},
  [595] = {.lex_state = 119},
  [596] = {.lex_state = 119},
  [597] = {.lex_state = 119},
  [598] = {.lex_state = 119},
  [599] = {.lex_state = 119},
  [600] = {.lex_state = 119},
  [601] = {.lex_state = 119},
  [602] = {.lex_state = 119},
  [603] = {.lex_state = 119},
  [604] = {.lex_state = 119},
  [605] = {.lex_state = 119},
  [606] = {.lex_state = 119},
  [607] = {.lex_state = 119},
  [608] = {.lex_state = 119},
  [609] = {.lex_state = 119},
  [610] = {.lex_state = 119},
  [611] = {.lex_state = 119},
  [612] = {.lex_state = 119},
  [613] = {.lex_state = 119},
  [614] = {.lex_state = 119},
  [615] = {.lex_state = 119},
  [616] = {.lex_state = 119},
  [617] = {.lex_state = 119},
  [618] = {.lex_state = 119},
  [619] = {.lex_state = 119},
  [620] = {.lex_state = 119},
  [621] = {.lex_state = 119},
  [622] = {.lex_state = 119},
  [623] = {.lex_state = 119},
  [624] = {.lex_state = 119},
  [625] = {.lex_state = 119},
  [626] = {.lex_state = 119},
  [627] = {.lex_state = 119},
  [628] = {.lex_state = 119},
  [629] = {.lex_state = 119},
  [630] = {.lex_state = 119},
  [631] = {.lex_state = 119},
  [632] = {.lex_state = 119},
  [633] = {.lex_state = 119},
  [634] = {.lex_state = 119},
  [635] = {.lex_state = 119},
  [636] = {.lex_state = 119},
  [637] = {.lex_state = 119},
  [638] = {.lex_state = 119},
  [639] = {.lex_state = 119},
  [640] = {.lex_state = 119},
  [641] = {.lex_state = 119},
  [642] = {.lex_state = 119},
  [643] = {.lex_state = 119},
  [644] = {.lex_state = 119},
  [645] = {.lex_state = 119},
  [646] = {.lex_state = 119},
  [647] = {.lex_state = 119},
  [648] = {.lex_state = 119},
  [649] = {.lex_state = 119},
  [650] = {.lex_state = 119},
  [651] = {.lex_state = 119},
  [652] = {.lex_state = 119},
  [653] = {.lex_state = 119},
  [654] = {.lex_state = 119},
  [655] = {.lex_state = 119},
  [656] = {.lex_state = 119},
  [657] = {.lex_state = 119},
  [658] = {.lex_state = 119},
  [659] = {.lex_state = 119},
  [660] = {.lex_state = 119},
  [661] = {.lex_state = 49},
  [662] = {.lex_state = 49},
  [663] = {.lex_state = 52},
  [664] = {.lex_state = 52},
  [665] = {.lex_state = 49},
  [666] = {.lex_state = 49},
  [667] = {.lex_state = 52},
  [668] = {.lex_state = 52},
  [669] = {.lex_state = 49},
  [670] = {.lex_state = 49},
  [671] = {.lex_state = 49},
  [672] = {.lex_state = 50},
  [673] = {.lex_state = 50},
  [674] = {.lex_state = 50},
  [675] = {.lex_state = 50},
  [676] = {.lex_state = 50},
  [677] = {.lex_state = 50},
  [678] = {.lex_state = 50},
  [679] = {.lex_state = 50},
  [680] = {.lex_state = 50},
  [681] = {.lex_state = 50},
  [682] = {.lex_state = 52},
  [683] = {.lex_state = 49},
  [684] = {.lex_state = 50},
  [685] = {.lex_state = 119},
  [686] = {.lex_state = 119},
  [687] = {.lex_state = 119},
  [688] = {.lex_state = 52},
  [689] = {.lex_state = 52},
  [690] = {.lex_state = 52},
  [691] = {.lex_state = 52},
  [692] = {.lex_state = 50},
  [693] = {.lex_state = 52},
  [694] = {.lex_state = 52},
  [695] = {.lex_state = 52},
  [696] = {.lex_state = 50},
  [697] = {.lex_state = 50},
  [698] = {.lex_state = 52},
  [699] = {.lex_state = 52},
  [700] = {.lex_state = 50},
  [701] = {.lex_state = 52},
  [702] = {.lex_state = 50},
  [703] = {.lex_state = 52},
  [704] = {.lex_state = 50},
  [705] = {.lex_state = 50},
  [706] = {.lex_state = 52},
  [707] = {.lex_state = 52},
  [708] = {.lex_state = 52},
  [709] = {.lex_state = 52},
  [710] = {.lex_state = 52},
  [711] = {.lex_state = 50},
  [712] = {.lex_state = 52},
  [713] = {.lex_state = 52},
  [714] = {.lex_state = 50},
  [715] = {.lex_state = 50},
  [716] = {.lex_state = 50},
  [717] = {.lex_state = 50},
  [718] = {.lex_state = 50},
  [719] = {.lex_state = 50},
  [720] = {.lex_state = 50},
  [721] = {.lex_state = 50},
  [722] = {.lex_state = 50},
  [723] = {.lex_state = 50},
  [724] = {.lex_state = 51},
  [725] = {.lex_state = 52},
  [726] = {.lex_state = 51},
  [727] = {.lex_state = 50},
  [728] = {.lex_state = 49},
  [729] = {.lex_state = 51},
  [730] = {.lex_state = 52},
  [731] = {.lex_state = 52},
  [732] = {.lex_state = 51},
  [733] = {.lex_state = 50},
  [734] = {.lex_state = 52},
  [735] = {.lex_state = 49},
  [736] = {.lex_state = 50},
  [737] = {.lex_state = 50},
  [738] = {.lex_state = 49},
  [739] = {.lex_state = 119},
  [740] = {.lex_state = 52},
  [741] = {.lex_state = 52},
  [742] = {.lex_state = 52},
  [743] = {.lex_state = 52},
  [744] = {.lex_state = 52},
  [745] = {.lex_state = 52},
  [746] = {.lex_state = 52},
  [747] = {.lex_state = 52},
  [748] = {.lex_state = 49},
  [749] = {.lex_state = 52},
  [750] = {.lex_state = 119},
  [751] = {.lex_state = 52},
  [752] = {.lex_state = 52},
  [753] = {.lex_state = 49},
  [754] = {.lex_state = 52},
  [755] = {.lex_state = 52},
  [756] = {.lex_state = 52},
  [757] = {.lex_state = 52},
  [758] = {.lex_state = 49},
  [759] = {.lex_state = 49},
  [760] = {.lex_state = 49},
  [761] = {.lex_state = 49},
  [762] = {.lex_state = 52},
  [763] = {.lex_state = 50},
  [764] = {.lex_state = 49},
  [765] = {.lex_state = 50},
  [766] = {.lex_state = 50},
  [767] = {.lex_state = 50},
  [768] = {.lex_state = 50},
  [769] = {.lex_state = 50},
  [770] = {.lex_state = 50},
  [771] = {.lex_state = 50},
  [772] = {.lex_state = 50},
  [773] = {.lex_state = 52},
  [774] = {.lex_state = 50},
  [775] = {.lex_state = 52},
  [776] = {.lex_state = 52},
  [777] = {.lex_state = 50},
  [778] = {.lex_state = 50},
  [779] = {.lex_state = 52},
  [780] = {.lex_state = 52},
  [781] = {.lex_state = 52},
  [782] = {.lex_state = 52},
  [783] = {.lex_state = 52},
  [784] = {.lex_state = 52},
  [785] = {.lex_state = 52},
  [786] = {.lex_state = 52},
  [787] = {.lex_state = 52},
  [788] = {.lex_state = 52},
  [789] = {.lex_state = 52},
  [790] = {.lex_state = 52},
  [791] = {.lex_state = 52},
  [792] = {.lex_state = 52},
  [793] = {.lex_state = 52},
  [794] = {.lex_state = 52},
  [795] = {.lex_state = 52},
  [796] = {.lex_state = 52},
  [797] = {.lex_state = 52},
  [798] = {.lex_state = 52},
  [799] = {.lex_state = 50},
  [800] = {.lex_state = 52},
  [801] = {.lex_state = 52},
  [802] = {.lex_state = 52},
  [803] = {.lex_state = 52},
  [804] = {.lex_state = 52},
  [805] = {.lex_state = 52},
  [806] = {.lex_state = 52},
  [807] = {.lex_state = 52},
  [808] = {.lex_state = 52},
  [809] = {.lex_state = 52},
  [810] = {.lex_state = 52},
  [811] = {.lex_state = 52},
  [812] = {.lex_state = 52},
  [813] = {.lex_state = 52},
  [814] = {.lex_state = 52},
  [815] = {.lex_state = 52},
  [816] = {.lex_state = 52},
  [817] = {.lex_state = 52},
  [818] = {.lex_state = 52},
  [819] = {.lex_state = 52},
  [820] = {.lex_state = 52},
  [821] = {.lex_state = 52},
  [822] = {.lex_state = 52},
  [823] = {.lex_state = 52},
  [824] = {.lex_state = 52},
  [825] = {.lex_state = 52},
  [826] = {.lex_state = 52},
  [827] = {.lex_state = 52},
  [828] = {.lex_state = 52},
  [829] = {.lex_state = 52},
  [830] = {.lex_state = 52},
  [831] = {.lex_state = 52},
  [832] = {.lex_state = 52},
  [833] = {.lex_state = 52},
  [834] = {.lex_state = 52},
  [835] = {.lex_state = 52},
  [836] = {.lex_state = 52},
  [837] = {.lex_state = 52},
  [838] = {.lex_state = 52},
  [839] = {.lex_state = 52},
  [840] = {.lex_state = 52},
  [841] = {.lex_state = 52},
  [842] = {.lex_state = 52},
  [843] = {.lex_state = 52},
  [844] = {.lex_state = 52},
  [845] = {.lex_state = 52},
  [846] = {.lex_state = 52},
  [847] = {.lex_state = 52},
  [848] = {.lex_state = 52},
  [849] = {.lex_state = 52},
  [850] = {.lex_state = 52},
  [851] = {.lex_state = 52},
  [852] = {.lex_state = 52},
  [853] = {.lex_state = 52},
  [854] = {.lex_state = 52},
  [855] = {.lex_state = 52},
  [856] = {.lex_state = 52},
  [857] = {.lex_state = 52},
  [858] = {.lex_state = 52},
  [859] = {.lex_state = 52},
  [860] = {.lex_state = 52},
  [861] = {.lex_state = 52},
  [862] = {.lex_state = 52},
  [863] = {.lex_state = 52},
  [864] = {.lex_state = 52},
  [865] = {.lex_state = 52},
  [866] = {.lex_state = 52},
  [867] = {.lex_state = 52},
  [868] = {.lex_state = 49},
  [869] = {.lex_state = 49},
  [870] = {.lex_state = 49},
  [871] = {.lex_state = 49},
  [872] = {.lex_state = 52},
  [873] = {.lex_state = 49},
  [874] = {.lex_state = 49},
  [875] = {.lex_state = 49},
  [876] = {.lex_state = 49},
  [877] = {.lex_state = 49},
  [878] = {.lex_state = 49},
  [879] = {.lex_state = 49},
  [880] = {.lex_state = 49},
  [881] = {.lex_state = 49},
  [882] = {.lex_state = 49},
  [883] = {.lex_state = 52},
  [884] = {.lex_state = 52},
  [885] = {.lex_state = 49},
  [886] = {.lex_state = 49},
  [887] = {.lex_state = 49},
  [888] = {.lex_state = 52},
  [889] = {.lex_state = 52},
  [890] = {.lex_state = 49},
  [891] = {.lex_state = 49},
  [892] = {.lex_state = 52},
  [893] = {.lex_state = 52},
  [894] = {.lex_state = 49},
  [895] = {.lex_state = 49},
  [896] = {.lex_state = 49},
  [897] = {.lex_state = 49},
  [898] = {.lex_state = 53},
  [899] = {.lex_state = 57},
  [900] = {.lex_state = 53},
  [901] = {.lex_state = 57},
  [902] = {.lex_state = 49},
  [903] = {.lex_state = 53},
  [904] = {.lex_state = 57},
  [905] = {.lex_state = 53},
  [906] = {.lex_state = 53},
  [907] = {.lex_state = 53},
  [908] = {.lex_state = 53},
  [909] = {.lex_state = 52},
  [910] = {.lex_state = 53},
  [911] = {.lex_state = 57},
  [912] = {.lex_state = 53},
  [913] = {.lex_state = 53},
  [914] = {.lex_state = 53},
  [915] = {.lex_state = 53},
  [916] = {.lex_state = 53},
  [917] = {.lex_state = 53},
  [918] = {.lex_state = 57},
  [919] = {.lex_state = 53},
  [920] = {.lex_state = 57},
  [921] = {.lex_state = 57},
  [922] = {.lex_state = 52},
  [923] = {.lex_state = 57},
  [924] = {.lex_state = 53},
  [925] = {.lex_state = 57},
  [926] = {.lex_state = 57},
  [927] = {.lex_state = 57},
  [928] = {.lex_state = 52},
  [929] = {.lex_state = 49},
  [930] = {.lex_state = 49},
  [931] = {.lex_state = 57},
  [932] = {.lex_state = 49},
  [933] = {.lex_state = 53},
  [934] = {.lex_state = 53},
  [935] = {.lex_state = 57},
  [936] = {.lex_state = 57},
  [937] = {.lex_state = 57},
  [938] = {.lex_state = 57},
  [939] = {.lex_state = 57},
  [940] = {.lex_state = 57},
  [941] = {.lex_state = 119},
  [942] = {.lex_state = 119},
  [943] = {.lex_state = 119},
  [944] = {.lex_state = 119},
  [945] = {.lex_state = 119},
  [946] = {.lex_state = 119},
  [947] = {.lex_state = 119},
  [948] = {.lex_state = 119},
  [949] = {.lex_state = 119},
  [950] = {.lex_state = 119},
  [951] = {.lex_state = 52},
  [952] = {.lex_state = 52},
  [953] = {.lex_state = 52},
  [954] = {.lex_state = 52},
  [955] = {.lex_state = 52},
  [956] = {.lex_state = 52},
  [957] = {.lex_state = 52},
  [958] = {.lex_state = 52},
  [959] = {.lex_state = 50},
  [960] = {.lex_state = 50},
  [961] = {.lex_state = 50},
  [962] = {.lex_state = 50},
  [963] = {.lex_state = 50},
  [964] = {.lex_state = 50},
  [965] = {.lex_state = 50},
  [966] = {.lex_state = 50},
  [967] = {.lex_state = 50},
  [968] = {.lex_state = 50},
  [969] = {.lex_state = 50},
  [970] = {.lex_state = 50},
  [971] = {.lex_state = 50},
  [972] = {.lex_state = 52},
  [973] = {.lex_state = 52},
  [974] = {.lex_state = 52},
  [975] = {.lex_state = 52},
  [976] = {.lex_state = 52},
  [977] = {.lex_state = 52},
  [978] = {.lex_state = 52},
  [979] = {.lex_state = 52},
  [980] = {.lex_state = 52},
  [981] = {.lex_state = 52},
  [982] = {.lex_state = 52},
  [983] = {.lex_state = 52},
  [984] = {.lex_state = 52},
  [985] = {.lex_state = 52},
  [986] = {.lex_state = 52},
  [987] = {.lex_state = 52},
  [988] = {.lex_state = 52},
  [989] = {.lex_state = 52},
  [990] = {.lex_state = 52},
  [991] = {.lex_state = 52},
  [992] = {.lex_state = 52},
  [993] = {.lex_state = 52},
  [994] = {.lex_state = 52},
  [995] = {.lex_state = 52},
  [996] = {.lex_state = 52},
  [997] = {.lex_state = 52},
  [998] = {.lex_state = 52},
  [999] = {.lex_state = 52},
  [1000] = {.lex_state = 52},
  [1001] = {.lex_state = 52},
  [1002] = {.lex_state = 52},
  [1003] = {.lex_state = 52},
  [1004] = {.lex_state = 52},
  [1005] = {.lex_state = 52},
  [1006] = {.lex_state = 52},
  [1007] = {.lex_state = 52},
  [1008] = {.lex_state = 53},
  [1009] = {.lex_state = 52},
  [1010] = {.lex_state = 52},
  [1011] = {.lex_state = 52},
  [1012] = {.lex_state = 53},
  [1013] = {.lex_state = 52},
  [1014] = {.lex_state = 53},
  [1015] = {.lex_state = 52},
  [1016] = {.lex_state = 52},
  [1017] = {.lex_state = 53},
  [1018] = {.lex_state = 49},
  [1019] = {.lex_state = 49},
  [1020] = {.lex_state = 52},
  [1021] = {.lex_state = 49},
  [1022] = {.lex_state = 49},
  [1023] = {.lex_state = 49},
  [1024] = {.lex_state = 49},
  [1025] = {.lex_state = 49},
  [1026] = {.lex_state = 49},
  [1027] = {.lex_state = 49},
  [1028] = {.lex_state = 52},
  [1029] = {.lex_state = 52},
  [1030] = {.lex_state = 49},
  [1031] = {.lex_state = 49},
  [1032] = {.lex_state = 49},
  [1033] = {.lex_state = 49},
  [1034] = {.lex_state = 49},
  [1035] = {.lex_state = 52},
  [1036] = {.lex_state = 49},
  [1037] = {.lex_state = 52},
  [1038] = {.lex_state = 52},
  [1039] = {.lex_state = 49},
  [1040] = {.lex_state = 49},
  [1041] = {.lex_state = 49},
  [1042] = {.lex_state = 49},
  [1043] = {.lex_state = 52},
  [1044] = {.lex_state = 49},
  [1045] = {.lex_state = 49},
  [1046] = {.lex_state = 49},
  [1047] = {.lex_state = 49},
  [1048] = {.lex_state = 49},
  [1049] = {.lex_state = 49},
  [1050] = {.lex_state = 49},
  [1051] = {.lex_state = 49},
  [1052] = {.lex_state = 52},
  [1053] = {.lex_state = 49},
  [1054] = {.lex_state = 49},
  [1055] = {.lex_state = 49},
  [1056] = {.lex_state = 49},
  [1057] = {.lex_state = 49},
  [1058] = {.lex_state = 49},
  [1059] = {.lex_state = 49},
  [1060] = {.lex_state = 52},
  [1061] = {.lex_state = 49},
  [1062] = {.lex_state = 52},
  [1063] = {.lex_state = 49},
  [1064] = {.lex_state = 49},
  [1065] = {.lex_state = 49},
  [1066] = {.lex_state = 49},
  [1067] = {.lex_state = 49},
  [1068] = {.lex_state = 49},
  [1069] = {.lex_state = 49},
  [1070] = {.lex_state = 49},
  [1071] = {.lex_state = 52},
  [1072] = {.lex_state = 52},
  [1073] = {.lex_state = 52},
  [1074] = {.lex_state = 49},
  [1075] = {.lex_state = 49},
  [1076] = {.lex_state = 49},
  [1077] = {.lex_state = 52},
  [1078] = {.lex_state = 49},
  [1079] = {.lex_state = 49},
  [1080] = {.lex_state = 49},
  [1081] = {.lex_state = 49},
  [1082] = {.lex_state = 49},
  [1083] = {.lex_state = 49},
  [1084] = {.lex_state = 49},
  [1085] = {.lex_state = 49},
  [1086] = {.lex_state = 49},
  [1087] = {.lex_state = 49},
  [1088] = {.lex_state = 49},
  [1089] = {.lex_state = 52},
  [1090] = {.lex_state = 49},
  [1091] = {.lex_state = 49},
  [1092] = {.lex_state = 49},
  [1093] = {.lex_state = 49},
  [1094] = {.lex_state = 49},
  [1095] = {.lex_state = 49},
  [1096] = {.lex_state = 49},
  [1097] = {.lex_state = 49},
  [1098] = {.lex_state = 49},
  [1099] = {.lex_state = 52},
  [1100] = {.lex_state = 49},
  [1101] = {.lex_state = 49},
  [1102] = {.lex_state = 52},
  [1103] = {.lex_state = 49},
  [1104] = {.lex_state = 49},
  [1105] = {.lex_state = 52},
  [1106] = {.lex_state = 49},
  [1107] = {.lex_state = 52},
  [1108] = {.lex_state = 52},
  [1109] = {.lex_state = 52},
  [1110] = {.lex_state = 52},
  [1111] = {.lex_state = 49},
  [1112] = {.lex_state = 49},
  [1113] = {.lex_state = 52},
  [1114] = {.lex_state = 49},
  [1115] = {.lex_state = 49},
  [1116] = {.lex_state = 52},
  [1117] = {.lex_state = 49},
  [1118] = {.lex_state = 52},
  [1119] = {.lex_state = 52},
  [1120] = {.lex_state = 52},
  [1121] = {.lex_state = 52},
  [1122] = {.lex_state = 52},
  [1123] = {.lex_state = 52},
  [1124] = {.lex_state = 52},
  [1125] = {.lex_state = 52},
  [1126] = {.lex_state = 52},
  [1127] = {.lex_state = 52},
  [1128] = {.lex_state = 52},
  [1129] = {.lex_state = 52},
  [1130] = {.lex_state = 52},
  [1131] = {.lex_state = 52},
  [1132] = {.lex_state = 52},
  [1133] = {.lex_state = 52},
  [1134] = {.lex_state = 52},
  [1135] = {.lex_state = 52},
  [1136] = {.lex_state = 52},
  [1137] = {.lex_state = 52},
  [1138] = {.lex_state = 52},
  [1139] = {.lex_state = 52},
  [1140] = {.lex_state = 53},
  [1141] = {.lex_state = 52},
  [1142] = {.lex_state = 52},
  [1143] = {.lex_state = 52},
  [1144] = {.lex_state = 52},
  [1145] = {.lex_state = 52},
  [1146] = {.lex_state = 48},
  [1147] = {.lex_state = 52},
  [1148] = {.lex_state = 53},
  [1149] = {.lex_state = 52},
  [1150] = {.lex_state = 53},
  [1151] = {.lex_state = 25},
  [1152] = {.lex_state = 48},
  [1153] = {.lex_state = 52},
  [1154] = {.lex_state = 52},
  [1155] = {.lex_state = 52},
  [1156] = {.lex_state = 52},
  [1157] = {.lex_state = 53},
  [1158] = {.lex_state = 52},
  [1159] = {.lex_state = 48},
  [1160] = {.lex_state = 53},
  [1161] = {.lex_state = 48},
  [1162] = {.lex_state = 53},
  [1163] = {.lex_state = 53},
  [1164] = {.lex_state = 53},
  [1165] = {.lex_state = 53},
  [1166] = {.lex_state = 53},
  [1167] = {.lex_state = 48},
  [1168] = {.lex_state = 53},
  [1169] = {.lex_state = 53},
  [1170] = {.lex_state = 53},
  [1171] = {.lex_state = 48},
  [1172] = {.lex_state = 48},
  [1173] = {.lex_state = 48},
  [1174] = {.lex_state = 53},
  [1175] = {.lex_state = 53},
  [1176] = {.lex_state = 52},
  [1177] = {.lex_state = 48},
  [1178] = {.lex_state = 48},
  [1179] = {.lex_state = 48},
  [1180] = {.lex_state = 53},
  [1181] = {.lex_state = 48},
  [1182] = {.lex_state = 48},
  [1183] = {.lex_state = 48},
  [1184] = {.lex_state = 52},
  [1185] = {.lex_state = 48},
  [1186] = {.lex_state = 48},
  [1187] = {.lex_state = 48},
  [1188] = {.lex_state = 48},
  [1189] = {.lex_state = 48},
  [1190] = {.lex_state = 48},
  [1191] = {.lex_state = 48},
  [1192] = {.lex_state = 53},
  [1193] = {.lex_state = 48},
  [1194] = {.lex_state = 48},
  [1195] = {.lex_state = 48},
  [1196] = {.lex_state = 52},
  [1197] = {.lex_state = 53},
  [1198] = {.lex_state = 52},
  [1199] = {.lex_state = 48},
  [1200] = {.lex_state = 48},
  [1201] = {.lex_state = 48},
  [1202] = {.lex_state = 48},
  [1203] = {.lex_state = 48},
  [1204] = {.lex_state = 48},
  [1205] = {.lex_state = 48},
  [1206] = {.lex_state = 48},
  [1207] = {.lex_state = 53},
  [1208] = {.lex_state = 48},
  [1209] = {.lex_state = 48},
  [1210] = {.lex_state = 48},
  [1211] = {.lex_state = 53},
  [1212] = {.lex_state = 48},
  [1213] = {.lex_state = 48},
  [1214] = {.lex_state = 48},
  [1215] = {.lex_state = 48},
  [1216] = {.lex_state = 48},
  [1217] = {.lex_state = 48},
  [1218] = {.lex_state = 52},
  [1219] = {.lex_state = 48},
  [1220] = {.lex_state = 25},
  [1221] = {.lex_state = 25},
  [1222] = {.lex_state = 25},
  [1223] = {.lex_state = 52},
  [1224] = {.lex_state = 25},
  [1225] = {.lex_state = 25},
  [1226] = {.lex_state = 52},
  [1227] = {.lex_state = 25},
  [1228] = {.lex_state = 52},
  [1229] = {.lex_state = 52},
  [1230] = {.lex_state = 25},
  [1231] = {.lex_state = 25},
  [1232] = {.lex_state = 25},
  [1233] = {.lex_state = 25},
  [1234] = {.lex_state = 25},
  [1235] = {.lex_state = 52},
  [1236] = {.lex_state = 25},
  [1237] = {.lex_state = 53},
  [1238] = {.lex_state = 25},
  [1239] = {.lex_state = 52},
  [1240] = {.lex_state = 25},
  [1241] = {.lex_state = 25},
  [1242] = {.lex_state = 25},
  [1243] = {.lex_state = 25},
  [1244] = {.lex_state = 25},
  [1245] = {.lex_state = 52},
  [1246] = {.lex_state = 25},
  [1247] = {.lex_state = 25},
  [1248] = {.lex_state = 25},
  [1249] = {.lex_state = 52},
  [1250] = {.lex_state = 25},
  [1251] = {.lex_state = 25},
  [1252] = {.lex_state = 25},
  [1253] = {.lex_state = 52},
  [1254] = {.lex_state = 53},
  [1255] = {.lex_state = 25},
  [1256] = {.lex_state = 25},
  [1257] = {.lex_state = 25},
  [1258] = {.lex_state = 52},
  [1259] = {.lex_state = 25},
  [1260] = {.lex_state = 52},
  [1261] = {.lex_state = 52},
  [1262] = {.lex_state = 25},
  [1263] = {.lex_state = 52},
  [1264] = {.lex_state = 25},
  [1265] = {.lex_state = 52},
  [1266] = {.lex_state = 25},
  [1267] = {.lex_state = 25},
  [1268] = {.lex_state = 25},
  [1269] = {.lex_state = 52},
  [1270] = {.lex_state = 52},
  [1271] = {.lex_state = 52},
  [1272] = {.lex_state = 52},
  [1273] = {.lex_state = 52},
  [1274] = {.lex_state = 52},
  [1275] = {.lex_state = 52},
  [1276] = {.lex_state = 52},
  [1277] = {.lex_state = 52},
  [1278] = {.lex_state = 52},
  [1279] = {.lex_state = 52},
  [1280] = {.lex_state = 52},
  [1281] = {.lex_state = 52},
  [1282] = {.lex_state = 52},
  [1283] = {.lex_state = 52},
  [1284] = {.lex_state = 52},
  [1285] = {.lex_state = 52},
  [1286] = {.lex_state = 52},
  [1287] = {.lex_state = 52},
  [1288] = {.lex_state = 52},
  [1289] = {.lex_state = 52},
  [1290] = {.lex_state = 50},
  [1291] = {.lex_state = 52},
  [1292] = {.lex_state = 52},
  [1293] = {.lex_state = 52},
  [1294] = {.lex_state = 50},
  [1295] = {.lex_state = 52},
  [1296] = {.lex_state = 52},
  [1297] = {.lex_state = 52},
  [1298] = {.lex_state = 50},
  [1299] = {.lex_state = 52},
  [1300] = {.lex_state = 50},
  [1301] = {.lex_state = 52},
  [1302] = {.lex_state = 52},
  [1303] = {.lex_state = 52},
  [1304] = {.lex_state = 52},
  [1305] = {.lex_state = 52},
  [1306] = {.lex_state = 52},
  [1307] = {.lex_state = 52},
  [1308] = {.lex_state = 52},
  [1309] = {.lex_state = 52},
  [1310] = {.lex_state = 56},
  [1311] = {.lex_state = 52},
  [1312] = {.lex_state = 52},
  [1313] = {.lex_state = 52},
  [1314] = {.lex_state = 52},
  [1315] = {.lex_state = 52},
  [1316] = {.lex_state = 52},
  [1317] = {.lex_state = 56},
  [1318] = {.lex_state = 52},
  [1319] = {.lex_state = 52},
  [1320] = {.lex_state = 52},
  [1321] = {.lex_state = 52},
  [1322] = {.lex_state = 52},
  [1323] = {.lex_state = 52},
  [1324] = {.lex_state = 52},
  [1325] = {.lex_state = 50},
  [1326] = {.lex_state = 50},
  [1327] = {.lex_state = 52},
  [1328] = {.lex_state = 56},
  [1329] = {.lex_state = 50},
  [1330] = {.lex_state = 50},
  [1331] = {.lex_state = 50},
  [1332] = {.lex_state = 52},
  [1333] = {.lex_state = 52},
  [1334] = {.lex_state = 52},
  [1335] = {.lex_state = 52},
  [1336] = {.lex_state = 50},
  [1337] = {.lex_state = 52},
  [1338] = {.lex_state = 50},
  [1339] = {.lex_state = 50},
  [1340] = {.lex_state = 52},
  [1341] = {.lex_state = 52},
  [1342] = {.lex_state = 52},
  [1343] = {.lex_state = 49},
  [1344] = {.lex_state = 52},
  [1345] = {.lex_state = 50},
  [1346] = {.lex_state = 50},
  [1347] = {.lex_state = 52},
  [1348] = {.lex_state = 50},
  [1349] = {.lex_state = 50},
  [1350] = {.lex_state = 52},
  [1351] = {.lex_state = 50},
  [1352] = {.lex_state = 50},
  [1353] = {.lex_state = 52},
  [1354] = {.lex_state = 52},
  [1355] = {.lex_state = 52},
  [1356] = {.lex_state = 52},
  [1357] = {.lex_state = 119},
  [1358] = {.lex_state = 119},
  [1359] = {.lex_state = 52},
  [1360] = {.lex_state = 52},
  [1361] = {.lex_state = 52},
  [1362] = {.lex_state = 119},
  [1363] = {.lex_state = 52},
  [1364] = {.lex_state = 52},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 52},
  [1367] = {.lex_state = 52},
  [1368] = {.lex_state = 52},
  [1369] = {.lex_state = 119},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 52},
  [1372] = {.lex_state = 52},
  [1373] = {.lex_state = 119},
  [1374] = {.lex_state = 52},
  [1375] = {.lex_state = 119},
  [1376] = {.lex_state = 119},
  [1377] = {.lex_state = 119},
  [1378] = {.lex_state = 119},
  [1379] = {.lex_state = 119},
  [1380] = {.lex_state = 49},
  [1381] = {.lex_state = 54},
  [1382] = {.lex_state = 49},
  [1383] = {.lex_state = 119},
  [1384] = {.lex_state = 54},
  [1385] = {.lex_state = 52},
  [1386] = {.lex_state = 52},
  [1387] = {.lex_state = 49},
  [1388] = {.lex_state = 119},
  [1389] = {.lex_state = 54},
  [1390] = {.lex_state = 119},
  [1391] = {.lex_state = 54},
  [1392] = {.lex_state = 52},
  [1393] = {.lex_state = 52},
  [1394] = {.lex_state = 119},
  [1395] = {.lex_state = 52},
  [1396] = {.lex_state = 119},
  [1397] = {.lex_state = 119},
  [1398] = {.lex_state = 52},
  [1399] = {.lex_state = 52},
  [1400] = {.lex_state = 52},
  [1401] = {.lex_state = 119},
  [1402] = {.lex_state = 119},
  [1403] = {.lex_state = 119},
  [1404] = {.lex_state = 119},
  [1405] = {.lex_state = 119},
  [1406] = {.lex_state = 119},
  [1407] = {.lex_state = 119},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 50},
  [1410] = {.lex_state = 50},
  [1411] = {.lex_state = 119},
  [1412] = {.lex_state = 52},
  [1413] = {.lex_state = 50},
  [1414] = {.lex_state = 119},
  [1415] = {.lex_state = 52},
  [1416] = {.lex_state = 52},
  [1417] = {.lex_state = 119},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 52},
  [1420] = {.lex_state = 50},
  [1421] = {.lex_state = 119},
  [1422] = {.lex_state = 52},
  [1423] = {.lex_state = 52},
  [1424] = {.lex_state = 52},
  [1425] = {.lex_state = 119},
  [1426] = {.lex_state = 52},
  [1427] = {.lex_state = 119},
  [1428] = {.lex_state = 52},
  [1429] = {.lex_state = 119},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 119},
  [1432] = {.lex_state = 52},
  [1433] = {.lex_state = 52},
  [1434] = {.lex_state = 52},
  [1435] = {.lex_state = 52},
  [1436] = {.lex_state = 52},
  [1437] = {.lex_state = 119},
  [1438] = {.lex_state = 52},
  [1439] = {.lex_state = 119},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 52},
  [1442] = {.lex_state = 52},
  [1443] = {.lex_state = 52},
  [1444] = {.lex_state = 52},
  [1445] = {.lex_state = 52},
  [1446] = {.lex_state = 119},
  [1447] = {.lex_state = 119},
  [1448] = {.lex_state = 56},
  [1449] = {.lex_state = 119},
  [1450] = {.lex_state = 52},
  [1451] = {.lex_state = 119},
  [1452] = {.lex_state = 0},
  [1453] = {.lex_state = 56},
  [1454] = {.lex_state = 56},
  [1455] = {.lex_state = 56},
  [1456] = {.lex_state = 56},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 0},
  [1459] = {.lex_state = 52},
  [1460] = {.lex_state = 52},
  [1461] = {.lex_state = 52},
  [1462] = {.lex_state = 56},
  [1463] = {.lex_state = 52},
  [1464] = {.lex_state = 56},
  [1465] = {.lex_state = 50},
  [1466] = {.lex_state = 52},
  [1467] = {.lex_state = 56},
  [1468] = {.lex_state = 52},
  [1469] = {.lex_state = 119},
  [1470] = {.lex_state = 52},
  [1471] = {.lex_state = 52},
  [1472] = {.lex_state = 52},
  [1473] = {.lex_state = 119},
  [1474] = {.lex_state = 119},
  [1475] = {.lex_state = 119},
  [1476] = {.lex_state = 56},
  [1477] = {.lex_state = 52},
  [1478] = {.lex_state = 56},
  [1479] = {.lex_state = 56},
  [1480] = {.lex_state = 52},
  [1481] = {.lex_state = 119},
  [1482] = {.lex_state = 119},
  [1483] = {.lex_state = 52},
  [1484] = {.lex_state = 119},
  [1485] = {.lex_state = 45},
  [1486] = {.lex_state = 119},
  [1487] = {.lex_state = 119},
  [1488] = {.lex_state = 119},
  [1489] = {.lex_state = 119},
  [1490] = {.lex_state = 119},
  [1491] = {.lex_state = 119},
  [1492] = {.lex_state = 119},
  [1493] = {.lex_state = 50},
  [1494] = {.lex_state = 52},
  [1495] = {.lex_state = 119},
  [1496] = {.lex_state = 119},
  [1497] = {.lex_state = 119},
  [1498] = {.lex_state = 52},
  [1499] = {.lex_state = 52},
  [1500] = {.lex_state = 119},
  [1501] = {.lex_state = 52},
  [1502] = {.lex_state = 30},
  [1503] = {.lex_state = 52},
  [1504] = {.lex_state = 52},
  [1505] = {.lex_state = 52},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 52},
  [1508] = {.lex_state = 52},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 52},
  [1511] = {.lex_state = 52},
  [1512] = {.lex_state = 52},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 32},
  [1515] = {.lex_state = 37},
  [1516] = {.lex_state = 52},
  [1517] = {.lex_state = 32},
  [1518] = {.lex_state = 32},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 0},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 30},
  [1523] = {.lex_state = 119},
  [1524] = {.lex_state = 52},
  [1525] = {.lex_state = 37},
  [1526] = {.lex_state = 32},
  [1527] = {.lex_state = 52},
  [1528] = {.lex_state = 37},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 52},
  [1531] = {.lex_state = 52},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 119},
  [1535] = {.lex_state = 52},
  [1536] = {.lex_state = 52},
  [1537] = {.lex_state = 52},
  [1538] = {.lex_state = 32},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 52},
  [1541] = {.lex_state = 52},
  [1542] = {.lex_state = 52},
  [1543] = {.lex_state = 52},
  [1544] = {.lex_state = 30},
  [1545] = {.lex_state = 52},
  [1546] = {.lex_state = 50},
  [1547] = {.lex_state = 52},
  [1548] = {.lex_state = 32},
  [1549] = {.lex_state = 32},
  [1550] = {.lex_state = 52},
  [1551] = {.lex_state = 52},
  [1552] = {.lex_state = 52},
  [1553] = {.lex_state = 50},
  [1554] = {.lex_state = 50},
  [1555] = {.lex_state = 52},
  [1556] = {.lex_state = 37},
  [1557] = {.lex_state = 37},
  [1558] = {.lex_state = 37},
  [1559] = {.lex_state = 52},
  [1560] = {.lex_state = 30},
  [1561] = {.lex_state = 52},
  [1562] = {.lex_state = 50},
  [1563] = {.lex_state = 45},
  [1564] = {.lex_state = 37},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 0},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 0},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 52},
  [1581] = {.lex_state = 45},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 52},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 45},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 0},
  [1599] = {.lex_state = 52},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 52},
  [1604] = {.lex_state = 52},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 0},
  [1611] = {.lex_state = 30},
  [1612] = {.lex_state = 34},
  [1613] = {.lex_state = 52},
  [1614] = {.lex_state = 34},
  [1615] = {.lex_state = 45},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 45},
  [1618] = {.lex_state = 0},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 0},
  [1621] = {.lex_state = 0},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 34},
  [1625] = {.lex_state = 0},
  [1626] = {.lex_state = 0},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 0},
  [1634] = {.lex_state = 0},
  [1635] = {.lex_state = 0},
  [1636] = {.lex_state = 0},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 52},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 0},
  [1641] = {.lex_state = 52},
  [1642] = {.lex_state = 45},
  [1643] = {.lex_state = 45},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 0},
  [1647] = {.lex_state = 0},
  [1648] = {.lex_state = 52},
  [1649] = {.lex_state = 0},
  [1650] = {.lex_state = 30},
  [1651] = {.lex_state = 45},
  [1652] = {.lex_state = 0},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 34},
  [1655] = {.lex_state = 0},
  [1656] = {.lex_state = 0},
  [1657] = {.lex_state = 0},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 0},
  [1662] = {.lex_state = 0},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 52},
  [1665] = {.lex_state = 0},
  [1666] = {.lex_state = 0},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 0},
  [1669] = {.lex_state = 0},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 0},
  [1672] = {.lex_state = 0},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 0},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 52},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 30},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 0},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 0},
  [1686] = {.lex_state = 52},
  [1687] = {.lex_state = 119},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 119},
  [1690] = {.lex_state = 119},
  [1691] = {.lex_state = 52},
  [1692] = {.lex_state = 119},
  [1693] = {.lex_state = 0},
  [1694] = {.lex_state = 119},
  [1695] = {.lex_state = 119},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 0},
  [1698] = {.lex_state = 0},
  [1699] = {.lex_state = 33},
  [1700] = {.lex_state = 119},
  [1701] = {.lex_state = 0},
  [1702] = {.lex_state = 33},
  [1703] = {.lex_state = 0},
  [1704] = {.lex_state = 0},
  [1705] = {.lex_state = 119},
  [1706] = {.lex_state = 119},
  [1707] = {.lex_state = 0},
  [1708] = {.lex_state = 33},
  [1709] = {.lex_state = 119},
  [1710] = {.lex_state = 52},
  [1711] = {.lex_state = 33},
  [1712] = {.lex_state = 0},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 0},
  [1715] = {.lex_state = 0},
  [1716] = {.lex_state = 119},
  [1717] = {.lex_state = 119},
  [1718] = {.lex_state = 33},
  [1719] = {.lex_state = 0},
  [1720] = {.lex_state = 0},
  [1721] = {.lex_state = 0},
  [1722] = {.lex_state = 33},
  [1723] = {.lex_state = 0},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 45},
  [1726] = {.lex_state = 0},
  [1727] = {.lex_state = 33},
  [1728] = {.lex_state = 45},
  [1729] = {.lex_state = 0},
  [1730] = {.lex_state = 33},
  [1731] = {.lex_state = 52},
  [1732] = {.lex_state = 0},
  [1733] = {.lex_state = 52},
  [1734] = {.lex_state = 119},
  [1735] = {.lex_state = 119},
  [1736] = {.lex_state = 52},
  [1737] = {.lex_state = 0},
  [1738] = {.lex_state = 0},
  [1739] = {.lex_state = 0},
  [1740] = {.lex_state = 119},
  [1741] = {.lex_state = 119},
  [1742] = {.lex_state = 119},
  [1743] = {.lex_state = 33},
  [1744] = {.lex_state = 0},
  [1745] = {.lex_state = 119},
  [1746] = {.lex_state = 33},
  [1747] = {.lex_state = 33},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 52},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 52},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 119},
  [1755] = {.lex_state = 33},
  [1756] = {.lex_state = 119},
  [1757] = {.lex_state = 33},
  [1758] = {.lex_state = 45},
  [1759] = {.lex_state = 119},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 33},
  [1762] = {.lex_state = 33},
  [1763] = {.lex_state = 33},
  [1764] = {.lex_state = 119},
  [1765] = {.lex_state = 0},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 52},
  [1768] = {.lex_state = 119},
  [1769] = {.lex_state = 33},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 119},
  [1772] = {.lex_state = 119},
  [1773] = {.lex_state = 0},
  [1774] = {.lex_state = 0},
  [1775] = {.lex_state = 0},
  [1776] = {.lex_state = 44},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 119},
  [1779] = {.lex_state = 44},
  [1780] = {.lex_state = 44},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 34},
  [1784] = {.lex_state = 44},
  [1785] = {.lex_state = 44},
  [1786] = {.lex_state = 0},
  [1787] = {.lex_state = 44},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 44},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 44},
  [1792] = {.lex_state = 52},
  [1793] = {.lex_state = 0},
  [1794] = {.lex_state = 44},
  [1795] = {.lex_state = 34},
  [1796] = {.lex_state = 34},
  [1797] = {.lex_state = 0},
  [1798] = {.lex_state = 44},
  [1799] = {.lex_state = 0},
  [1800] = {.lex_state = 34},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 0},
  [1803] = {.lex_state = 0},
  [1804] = {.lex_state = 0},
  [1805] = {.lex_state = 0},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 34},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 34},
  [1811] = {.lex_state = 119},
  [1812] = {.lex_state = 34},
  [1813] = {.lex_state = 119},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 0},
  [1816] = {.lex_state = 34},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 52},
  [1819] = {.lex_state = 34},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 119},
  [1824] = {.lex_state = 0},
  [1825] = {.lex_state = 34},
  [1826] = {.lex_state = 119},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 44},
  [1829] = {.lex_state = 44},
  [1830] = {.lex_state = 44},
  [1831] = {.lex_state = 44},
  [1832] = {.lex_state = 34},
  [1833] = {.lex_state = 34},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 34},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 52},
  [1838] = {.lex_state = 52},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 44},
  [1841] = {.lex_state = 44},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 44},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 52},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 119},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 52},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 44},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 44},
  [1857] = {.lex_state = 34},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 0},
  [1862] = {.lex_state = 34},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 44},
  [1865] = {.lex_state = 44},
  [1866] = {.lex_state = 44},
  [1867] = {.lex_state = 52},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 44},
  [1870] = {.lex_state = 52},
  [1871] = {.lex_state = 119},
  [1872] = {.lex_state = 44},
  [1873] = {.lex_state = 44},
  [1874] = {.lex_state = 52},
  [1875] = {.lex_state = 34},
  [1876] = {.lex_state = 34},
  [1877] = {.lex_state = 52},
  [1878] = {.lex_state = 34},
  [1879] = {.lex_state = 52},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 52},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 0},
  [1887] = {.lex_state = 0},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 0},
  [1890] = {.lex_state = 52},
  [1891] = {.lex_state = 34},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 52},
  [1895] = {.lex_state = 52},
  [1896] = {.lex_state = 0},
  [1897] = {.lex_state = 34},
  [1898] = {.lex_state = 0},
  [1899] = {.lex_state = 44},
  [1900] = {.lex_state = 44},
  [1901] = {.lex_state = 52},
  [1902] = {.lex_state = 52},
  [1903] = {.lex_state = 44},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 0},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 44},
  [1908] = {.lex_state = 34},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 34},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 44},
  [1913] = {.lex_state = 0},
  [1914] = {.lex_state = 0},
  [1915] = {.lex_state = 0},
  [1916] = {.lex_state = 52},
  [1917] = {.lex_state = 52},
  [1918] = {.lex_state = 52},
  [1919] = {.lex_state = 44},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 0},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 0},
  [1924] = {.lex_state = 0},
  [1925] = {.lex_state = 0},
  [1926] = {.lex_state = 52},
  [1927] = {.lex_state = 34},
  [1928] = {.lex_state = 0},
  [1929] = {.lex_state = 44},
  [1930] = {.lex_state = 52},
  [1931] = {.lex_state = 34},
  [1932] = {.lex_state = 44},
  [1933] = {.lex_state = 0},
  [1934] = {.lex_state = 0},
  [1935] = {.lex_state = 0},
  [1936] = {.lex_state = 52},
  [1937] = {.lex_state = 0},
  [1938] = {.lex_state = 52},
  [1939] = {.lex_state = 44},
  [1940] = {.lex_state = 0},
  [1941] = {.lex_state = 52},
  [1942] = {.lex_state = 34},
  [1943] = {.lex_state = 0},
  [1944] = {.lex_state = 44},
  [1945] = {.lex_state = 0},
  [1946] = {.lex_state = 0},
  [1947] = {.lex_state = 44},
  [1948] = {.lex_state = 52},
  [1949] = {.lex_state = 52},
  [1950] = {.lex_state = 119},
  [1951] = {.lex_state = 0},
  [1952] = {.lex_state = 34},
  [1953] = {.lex_state = 44},
  [1954] = {.lex_state = 52},
  [1955] = {.lex_state = 0},
  [1956] = {.lex_state = 0},
  [1957] = {.lex_state = 0},
  [1958] = {.lex_state = 0},
  [1959] = {.lex_state = 44},
  [1960] = {.lex_state = 0},
  [1961] = {.lex_state = 52},
  [1962] = {.lex_state = 44},
  [1963] = {.lex_state = 0},
  [1964] = {.lex_state = 0},
  [1965] = {.lex_state = 52},
  [1966] = {.lex_state = 44},
  [1967] = {.lex_state = 52},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 52},
  [1970] = {.lex_state = 52},
  [1971] = {.lex_state = 119},
  [1972] = {.lex_state = 0},
  [1973] = {.lex_state = 52},
  [1974] = {.lex_state = 52},
  [1975] = {.lex_state = 34},
  [1976] = {.lex_state = 0},
  [1977] = {.lex_state = 0},
  [1978] = {.lex_state = 44},
  [1979] = {.lex_state = 0},
  [1980] = {.lex_state = 119},
  [1981] = {.lex_state = 44},
  [1982] = {.lex_state = 44},
  [1983] = {.lex_state = 44},
  [1984] = {.lex_state = 44},
  [1985] = {.lex_state = 0},
  [1986] = {.lex_state = 0},
  [1987] = {.lex_state = 44},
  [1988] = {.lex_state = 44},
  [1989] = {.lex_state = 52},
  [1990] = {.lex_state = 119},
  [1991] = {.lex_state = 52},
  [1992] = {.lex_state = 44},
  [1993] = {.lex_state = 44},
  [1994] = {.lex_state = 52},
  [1995] = {.lex_state = 52},
  [1996] = {.lex_state = 0},
  [1997] = {.lex_state = 0},
  [1998] = {.lex_state = 0},
  [1999] = {.lex_state = 119},
  [2000] = {.lex_state = 0},
  [2001] = {.lex_state = 0},
  [2002] = {.lex_state = 52},
  [2003] = {.lex_state = 0},
  [2004] = {.lex_state = 34},
  [2005] = {.lex_state = 34},
  [2006] = {.lex_state = 0},
  [2007] = {.lex_state = 0},
  [2008] = {.lex_state = 44},
  [2009] = {.lex_state = 34},
  [2010] = {.lex_state = 52},
  [2011] = {.lex_state = 44},
  [2012] = {.lex_state = 0},
  [2013] = {.lex_state = 34},
  [2014] = {.lex_state = 52},
  [2015] = {.lex_state = 119},
  [2016] = {.lex_state = 0},
  [2017] = {.lex_state = 0},
  [2018] = {.lex_state = 119},
  [2019] = {.lex_state = 44},
  [2020] = {.lex_state = 52},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym___extension__] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym___attribute__] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym___declspec] = ACTIONS(1),
    [anon_sym___based] = ACTIONS(1),
    [anon_sym___cdecl] = ACTIONS(1),
    [anon_sym___clrcall] = ACTIONS(1),
    [anon_sym___stdcall] = ACTIONS(1),
    [anon_sym___fastcall] = ACTIONS(1),
    [anon_sym___thiscall] = ACTIONS(1),
    [anon_sym___vectorcall] = ACTIONS(1),
    [sym_ms_restrict_modifier] = ACTIONS(1),
    [sym_ms_unsigned_ptr_modifier] = ACTIONS(1),
    [sym_ms_signed_ptr_modifier] = ACTIONS(1),
    [anon_sym__unaligned] = ACTIONS(1),
    [anon_sym___unaligned] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_auto] = ACTIONS(1),
    [anon_sym_register] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym___inline] = ACTIONS(1),
    [anon_sym___inline__] = ACTIONS(1),
    [anon_sym___forceinline] = ACTIONS(1),
    [anon_sym_thread_local] = ACTIONS(1),
    [anon_sym___thread] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_constexpr] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_restrict] = ACTIONS(1),
    [anon_sym___restrict__] = ACTIONS(1),
    [anon_sym__Atomic] = ACTIONS(1),
    [anon_sym__Noreturn] = ACTIONS(1),
    [anon_sym_noreturn] = ACTIONS(1),
    [sym_primitive_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym___try] = ACTIONS(1),
    [anon_sym___except] = ACTIONS(1),
    [anon_sym___finally] = ACTIONS(1),
    [anon_sym___leave] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym___alignof__] = ACTIONS(1),
    [anon_sym___alignof] = ACTIONS(1),
    [anon_sym__alignof] = ACTIONS(1),
    [anon_sym_alignof] = ACTIONS(1),
    [anon_sym__Alignof] = ACTIONS(1),
    [anon_sym_offsetof] = ACTIONS(1),
    [anon_sym__Generic] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym___asm__] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_SQUOTE] = ACTIONS(1),
    [anon_sym_u_SQUOTE] = ACTIONS(1),
    [anon_sym_U_SQUOTE] = ACTIONS(1),
    [anon_sym_u8_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_nullptr] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_translation_unit] = STATE(1836),
    [sym_preproc_include] = STATE(43),
    [sym_preproc_def] = STATE(43),
    [sym_preproc_function_def] = STATE(43),
    [sym_preproc_call] = STATE(43),
    [sym_preproc_if] = STATE(43),
    [sym_preproc_ifdef] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym__old_style_function_definition] = STATE(415),
    [sym_declaration] = STATE(43),
    [sym_type_definition] = STATE(43),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1129),
    [sym_linkage_specification] = STATE(43),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(747),
    [sym_compound_statement] = STATE(43),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(866),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(43),
    [sym_labeled_statement] = STATE(43),
    [sym__top_level_expression_statement] = STATE(43),
    [sym_if_statement] = STATE(43),
    [sym_switch_statement] = STATE(43),
    [sym_case_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_do_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_return_statement] = STATE(43),
    [sym_break_statement] = STATE(43),
    [sym_continue_statement] = STATE(43),
    [sym_goto_statement] = STATE(43),
    [sym__expression] = STATE(1117),
    [sym__expression_not_binary] = STATE(1115),
    [sym__string] = STATE(1115),
    [sym_conditional_expression] = STATE(1115),
    [sym_assignment_expression] = STATE(1115),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(1115),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(1115),
    [sym_cast_expression] = STATE(1115),
    [sym_sizeof_expression] = STATE(1115),
    [sym_alignof_expression] = STATE(1115),
    [sym_offsetof_expression] = STATE(1115),
    [sym_generic_expression] = STATE(1115),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(1115),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(1115),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(1115),
    [sym_concatenated_string] = STATE(1115),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(1115),
    [sym__empty_declaration] = STATE(43),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_translation_unit_repeat1] = STATE(43),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(61),
    [anon_sym_default] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(91),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1787),
    [sym_preproc_elif] = STATE(1787),
    [sym_preproc_elifdef] = STATE(1787),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(109),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1789),
    [sym_preproc_elif] = STATE(1789),
    [sym_preproc_elifdef] = STATE(1789),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(161),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1959),
    [sym_preproc_elif] = STATE(1959),
    [sym_preproc_elifdef] = STATE(1959),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(163),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_preproc_include] = STATE(11),
    [sym_preproc_def] = STATE(11),
    [sym_preproc_function_def] = STATE(11),
    [sym_preproc_call] = STATE(11),
    [sym_preproc_if] = STATE(11),
    [sym_preproc_ifdef] = STATE(11),
    [sym_preproc_else] = STATE(1903),
    [sym_preproc_elif] = STATE(1903),
    [sym_preproc_elifdef] = STATE(1903),
    [sym_function_definition] = STATE(11),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(11),
    [sym_type_definition] = STATE(11),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(11),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(11),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_case_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_goto_statement] = STATE(11),
    [sym_seh_try_statement] = STATE(11),
    [sym_seh_leave_statement] = STATE(11),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(11),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(11),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(165),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_preproc_include] = STATE(13),
    [sym_preproc_def] = STATE(13),
    [sym_preproc_function_def] = STATE(13),
    [sym_preproc_call] = STATE(13),
    [sym_preproc_if] = STATE(13),
    [sym_preproc_ifdef] = STATE(13),
    [sym_preproc_else] = STATE(1953),
    [sym_preproc_elif] = STATE(1953),
    [sym_preproc_elifdef] = STATE(1953),
    [sym_function_definition] = STATE(13),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(13),
    [sym_type_definition] = STATE(13),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(13),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(13),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_case_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_goto_statement] = STATE(13),
    [sym_seh_try_statement] = STATE(13),
    [sym_seh_leave_statement] = STATE(13),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(13),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(13),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1872),
    [sym_preproc_elif] = STATE(1872),
    [sym_preproc_elifdef] = STATE(1872),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(169),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_preproc_include] = STATE(16),
    [sym_preproc_def] = STATE(16),
    [sym_preproc_function_def] = STATE(16),
    [sym_preproc_call] = STATE(16),
    [sym_preproc_if] = STATE(16),
    [sym_preproc_ifdef] = STATE(16),
    [sym_preproc_else] = STATE(1791),
    [sym_preproc_elif] = STATE(1791),
    [sym_preproc_elifdef] = STATE(1791),
    [sym_function_definition] = STATE(16),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(16),
    [sym_type_definition] = STATE(16),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(16),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(16),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_case_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_seh_try_statement] = STATE(16),
    [sym_seh_leave_statement] = STATE(16),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(16),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(16),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(171),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_preproc_include] = STATE(3),
    [sym_preproc_def] = STATE(3),
    [sym_preproc_function_def] = STATE(3),
    [sym_preproc_call] = STATE(3),
    [sym_preproc_if] = STATE(3),
    [sym_preproc_ifdef] = STATE(3),
    [sym_preproc_else] = STATE(1794),
    [sym_preproc_elif] = STATE(1794),
    [sym_preproc_elifdef] = STATE(1794),
    [sym_function_definition] = STATE(3),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(3),
    [sym_type_definition] = STATE(3),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(3),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(3),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_case_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_goto_statement] = STATE(3),
    [sym_seh_try_statement] = STATE(3),
    [sym_seh_leave_statement] = STATE(3),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(3),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(3),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(173),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_preproc_include] = STATE(2),
    [sym_preproc_def] = STATE(2),
    [sym_preproc_function_def] = STATE(2),
    [sym_preproc_call] = STATE(2),
    [sym_preproc_if] = STATE(2),
    [sym_preproc_ifdef] = STATE(2),
    [sym_preproc_else] = STATE(1784),
    [sym_preproc_elif] = STATE(1784),
    [sym_preproc_elifdef] = STATE(1784),
    [sym_function_definition] = STATE(2),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(2),
    [sym_type_definition] = STATE(2),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(2),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(2),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(2),
    [sym_labeled_statement] = STATE(2),
    [sym_expression_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_switch_statement] = STATE(2),
    [sym_case_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_do_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_return_statement] = STATE(2),
    [sym_break_statement] = STATE(2),
    [sym_continue_statement] = STATE(2),
    [sym_goto_statement] = STATE(2),
    [sym_seh_try_statement] = STATE(2),
    [sym_seh_leave_statement] = STATE(2),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(2),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(2),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(175),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1912),
    [sym_preproc_elif] = STATE(1912),
    [sym_preproc_elifdef] = STATE(1912),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(177),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_preproc_include] = STATE(14),
    [sym_preproc_def] = STATE(14),
    [sym_preproc_function_def] = STATE(14),
    [sym_preproc_call] = STATE(14),
    [sym_preproc_if] = STATE(14),
    [sym_preproc_ifdef] = STATE(14),
    [sym_preproc_else] = STATE(2011),
    [sym_preproc_elif] = STATE(2011),
    [sym_preproc_elifdef] = STATE(2011),
    [sym_function_definition] = STATE(14),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(14),
    [sym_type_definition] = STATE(14),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(14),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(14),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_case_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_goto_statement] = STATE(14),
    [sym_seh_try_statement] = STATE(14),
    [sym_seh_leave_statement] = STATE(14),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(14),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(14),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(179),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(2008),
    [sym_preproc_elif] = STATE(2008),
    [sym_preproc_elifdef] = STATE(2008),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(181),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1988),
    [sym_preproc_elif] = STATE(1988),
    [sym_preproc_elifdef] = STATE(1988),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(183),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_preproc_include] = STATE(19),
    [sym_preproc_def] = STATE(19),
    [sym_preproc_function_def] = STATE(19),
    [sym_preproc_call] = STATE(19),
    [sym_preproc_if] = STATE(19),
    [sym_preproc_ifdef] = STATE(19),
    [sym_preproc_else] = STATE(1856),
    [sym_preproc_elif] = STATE(1856),
    [sym_preproc_elifdef] = STATE(1856),
    [sym_function_definition] = STATE(19),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(19),
    [sym_type_definition] = STATE(19),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(19),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(19),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_case_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_goto_statement] = STATE(19),
    [sym_seh_try_statement] = STATE(19),
    [sym_seh_leave_statement] = STATE(19),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(19),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(19),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(185),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1854),
    [sym_preproc_elif] = STATE(1854),
    [sym_preproc_elifdef] = STATE(1854),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(187),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1993),
    [sym_preproc_elif] = STATE(1993),
    [sym_preproc_elifdef] = STATE(1993),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_preproc_include] = STATE(4),
    [sym_preproc_def] = STATE(4),
    [sym_preproc_function_def] = STATE(4),
    [sym_preproc_call] = STATE(4),
    [sym_preproc_if] = STATE(4),
    [sym_preproc_ifdef] = STATE(4),
    [sym_preproc_else] = STATE(1869),
    [sym_preproc_elif] = STATE(1869),
    [sym_preproc_elifdef] = STATE(1869),
    [sym_function_definition] = STATE(4),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(4),
    [sym_type_definition] = STATE(4),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(4),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(4),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(4),
    [sym_labeled_statement] = STATE(4),
    [sym_expression_statement] = STATE(4),
    [sym_if_statement] = STATE(4),
    [sym_switch_statement] = STATE(4),
    [sym_case_statement] = STATE(4),
    [sym_while_statement] = STATE(4),
    [sym_do_statement] = STATE(4),
    [sym_for_statement] = STATE(4),
    [sym_return_statement] = STATE(4),
    [sym_break_statement] = STATE(4),
    [sym_continue_statement] = STATE(4),
    [sym_goto_statement] = STATE(4),
    [sym_seh_try_statement] = STATE(4),
    [sym_seh_leave_statement] = STATE(4),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(4),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(4),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(191),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1841),
    [sym_preproc_elif] = STATE(1841),
    [sym_preproc_elifdef] = STATE(1841),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(193),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_preproc_include] = STATE(17),
    [sym_preproc_def] = STATE(17),
    [sym_preproc_function_def] = STATE(17),
    [sym_preproc_call] = STATE(17),
    [sym_preproc_if] = STATE(17),
    [sym_preproc_ifdef] = STATE(17),
    [sym_preproc_else] = STATE(2019),
    [sym_preproc_elif] = STATE(2019),
    [sym_preproc_elifdef] = STATE(2019),
    [sym_function_definition] = STATE(17),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(17),
    [sym_type_definition] = STATE(17),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(17),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(17),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_case_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_goto_statement] = STATE(17),
    [sym_seh_try_statement] = STATE(17),
    [sym_seh_leave_statement] = STATE(17),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(17),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(17),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(195),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_preproc_include] = STATE(7),
    [sym_preproc_def] = STATE(7),
    [sym_preproc_function_def] = STATE(7),
    [sym_preproc_call] = STATE(7),
    [sym_preproc_if] = STATE(7),
    [sym_preproc_ifdef] = STATE(7),
    [sym_preproc_else] = STATE(1992),
    [sym_preproc_elif] = STATE(1992),
    [sym_preproc_elifdef] = STATE(1992),
    [sym_function_definition] = STATE(7),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(7),
    [sym_type_definition] = STATE(7),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(7),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(7),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_case_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_goto_statement] = STATE(7),
    [sym_seh_try_statement] = STATE(7),
    [sym_seh_leave_statement] = STATE(7),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(7),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(7),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(197),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(150),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1132),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(740),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(865),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_seh_try_statement] = STATE(22),
    [sym_seh_leave_statement] = STATE(22),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(199),
    [aux_sym_preproc_include_token1] = ACTIONS(202),
    [aux_sym_preproc_def_token1] = ACTIONS(205),
    [aux_sym_preproc_if_token1] = ACTIONS(208),
    [aux_sym_preproc_if_token2] = ACTIONS(211),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(213),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(213),
    [aux_sym_preproc_else_token1] = ACTIONS(211),
    [aux_sym_preproc_elif_token1] = ACTIONS(211),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(211),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(211),
    [sym_preproc_directive] = ACTIONS(216),
    [anon_sym_LPAREN2] = ACTIONS(219),
    [anon_sym_BANG] = ACTIONS(222),
    [anon_sym_TILDE] = ACTIONS(222),
    [anon_sym_DASH] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(225),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_AMP] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(231),
    [anon_sym___extension__] = ACTIONS(234),
    [anon_sym_typedef] = ACTIONS(237),
    [anon_sym_extern] = ACTIONS(240),
    [anon_sym___attribute__] = ACTIONS(243),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(246),
    [anon_sym___declspec] = ACTIONS(249),
    [anon_sym___cdecl] = ACTIONS(252),
    [anon_sym___clrcall] = ACTIONS(252),
    [anon_sym___stdcall] = ACTIONS(252),
    [anon_sym___fastcall] = ACTIONS(252),
    [anon_sym___thiscall] = ACTIONS(252),
    [anon_sym___vectorcall] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(255),
    [anon_sym_signed] = ACTIONS(258),
    [anon_sym_unsigned] = ACTIONS(258),
    [anon_sym_long] = ACTIONS(258),
    [anon_sym_short] = ACTIONS(258),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_auto] = ACTIONS(261),
    [anon_sym_register] = ACTIONS(261),
    [anon_sym_inline] = ACTIONS(261),
    [anon_sym___inline] = ACTIONS(261),
    [anon_sym___inline__] = ACTIONS(261),
    [anon_sym___forceinline] = ACTIONS(261),
    [anon_sym_thread_local] = ACTIONS(261),
    [anon_sym___thread] = ACTIONS(261),
    [anon_sym_const] = ACTIONS(264),
    [anon_sym_constexpr] = ACTIONS(264),
    [anon_sym_volatile] = ACTIONS(264),
    [anon_sym_restrict] = ACTIONS(264),
    [anon_sym___restrict__] = ACTIONS(264),
    [anon_sym__Atomic] = ACTIONS(264),
    [anon_sym__Noreturn] = ACTIONS(264),
    [anon_sym_noreturn] = ACTIONS(264),
    [sym_primitive_type] = ACTIONS(267),
    [anon_sym_enum] = ACTIONS(270),
    [anon_sym_struct] = ACTIONS(273),
    [anon_sym_union] = ACTIONS(276),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_switch] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(285),
    [anon_sym_default] = ACTIONS(288),
    [anon_sym_while] = ACTIONS(291),
    [anon_sym_do] = ACTIONS(294),
    [anon_sym_for] = ACTIONS(297),
    [anon_sym_return] = ACTIONS(300),
    [anon_sym_break] = ACTIONS(303),
    [anon_sym_continue] = ACTIONS(306),
    [anon_sym_goto] = ACTIONS(309),
    [anon_sym___try] = ACTIONS(312),
    [anon_sym___leave] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(318),
    [anon_sym_PLUS_PLUS] = ACTIONS(318),
    [anon_sym_sizeof] = ACTIONS(321),
    [anon_sym___alignof__] = ACTIONS(324),
    [anon_sym___alignof] = ACTIONS(324),
    [anon_sym__alignof] = ACTIONS(324),
    [anon_sym_alignof] = ACTIONS(324),
    [anon_sym__Alignof] = ACTIONS(324),
    [anon_sym_offsetof] = ACTIONS(327),
    [anon_sym__Generic] = ACTIONS(330),
    [anon_sym_asm] = ACTIONS(333),
    [anon_sym___asm__] = ACTIONS(333),
    [sym_number_literal] = ACTIONS(336),
    [anon_sym_L_SQUOTE] = ACTIONS(339),
    [anon_sym_u_SQUOTE] = ACTIONS(339),
    [anon_sym_U_SQUOTE] = ACTIONS(339),
    [anon_sym_u8_SQUOTE] = ACTIONS(339),
    [anon_sym_SQUOTE] = ACTIONS(339),
    [anon_sym_L_DQUOTE] = ACTIONS(342),
    [anon_sym_u_DQUOTE] = ACTIONS(342),
    [anon_sym_U_DQUOTE] = ACTIONS(342),
    [anon_sym_u8_DQUOTE] = ACTIONS(342),
    [anon_sym_DQUOTE] = ACTIONS(342),
    [sym_true] = ACTIONS(345),
    [sym_false] = ACTIONS(345),
    [anon_sym_NULL] = ACTIONS(348),
    [anon_sym_nullptr] = ACTIONS(348),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_function_definition] = STATE(28),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym_seh_try_statement] = STATE(28),
    [sym_seh_leave_statement] = STATE(28),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(28),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(28),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(373),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_preproc_include] = STATE(25),
    [sym_preproc_def] = STATE(25),
    [sym_preproc_function_def] = STATE(25),
    [sym_preproc_call] = STATE(25),
    [sym_preproc_if] = STATE(25),
    [sym_preproc_ifdef] = STATE(25),
    [sym_function_definition] = STATE(25),
    [sym__old_style_function_definition] = STATE(337),
    [sym_declaration] = STATE(25),
    [sym_type_definition] = STATE(25),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1135),
    [sym_linkage_specification] = STATE(25),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(744),
    [sym_compound_statement] = STATE(25),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(863),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_case_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_goto_statement] = STATE(25),
    [sym_seh_try_statement] = STATE(25),
    [sym_seh_leave_statement] = STATE(25),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(25),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(25),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(401),
    [aux_sym_preproc_include_token1] = ACTIONS(403),
    [aux_sym_preproc_def_token1] = ACTIONS(405),
    [aux_sym_preproc_if_token1] = ACTIONS(407),
    [aux_sym_preproc_if_token2] = ACTIONS(409),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(411),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(411),
    [sym_preproc_directive] = ACTIONS(413),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym___extension__] = ACTIONS(417),
    [anon_sym_typedef] = ACTIONS(419),
    [anon_sym_extern] = ACTIONS(421),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_switch] = ACTIONS(427),
    [anon_sym_case] = ACTIONS(429),
    [anon_sym_default] = ACTIONS(431),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(443),
    [anon_sym_goto] = ACTIONS(445),
    [anon_sym___try] = ACTIONS(447),
    [anon_sym___leave] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_preproc_include] = STATE(25),
    [sym_preproc_def] = STATE(25),
    [sym_preproc_function_def] = STATE(25),
    [sym_preproc_call] = STATE(25),
    [sym_preproc_if] = STATE(25),
    [sym_preproc_ifdef] = STATE(25),
    [sym_function_definition] = STATE(25),
    [sym__old_style_function_definition] = STATE(337),
    [sym_declaration] = STATE(25),
    [sym_type_definition] = STATE(25),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1135),
    [sym_linkage_specification] = STATE(25),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(744),
    [sym_compound_statement] = STATE(25),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(863),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_case_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_goto_statement] = STATE(25),
    [sym_seh_try_statement] = STATE(25),
    [sym_seh_leave_statement] = STATE(25),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(25),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(25),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(451),
    [aux_sym_preproc_include_token1] = ACTIONS(454),
    [aux_sym_preproc_def_token1] = ACTIONS(457),
    [aux_sym_preproc_if_token1] = ACTIONS(460),
    [aux_sym_preproc_if_token2] = ACTIONS(211),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(463),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(463),
    [sym_preproc_directive] = ACTIONS(466),
    [anon_sym_LPAREN2] = ACTIONS(219),
    [anon_sym_BANG] = ACTIONS(222),
    [anon_sym_TILDE] = ACTIONS(222),
    [anon_sym_DASH] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(225),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_AMP] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym___extension__] = ACTIONS(472),
    [anon_sym_typedef] = ACTIONS(475),
    [anon_sym_extern] = ACTIONS(478),
    [anon_sym___attribute__] = ACTIONS(243),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(246),
    [anon_sym___declspec] = ACTIONS(249),
    [anon_sym___cdecl] = ACTIONS(252),
    [anon_sym___clrcall] = ACTIONS(252),
    [anon_sym___stdcall] = ACTIONS(252),
    [anon_sym___fastcall] = ACTIONS(252),
    [anon_sym___thiscall] = ACTIONS(252),
    [anon_sym___vectorcall] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(481),
    [anon_sym_signed] = ACTIONS(258),
    [anon_sym_unsigned] = ACTIONS(258),
    [anon_sym_long] = ACTIONS(258),
    [anon_sym_short] = ACTIONS(258),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_auto] = ACTIONS(261),
    [anon_sym_register] = ACTIONS(261),
    [anon_sym_inline] = ACTIONS(261),
    [anon_sym___inline] = ACTIONS(261),
    [anon_sym___inline__] = ACTIONS(261),
    [anon_sym___forceinline] = ACTIONS(261),
    [anon_sym_thread_local] = ACTIONS(261),
    [anon_sym___thread] = ACTIONS(261),
    [anon_sym_const] = ACTIONS(264),
    [anon_sym_constexpr] = ACTIONS(264),
    [anon_sym_volatile] = ACTIONS(264),
    [anon_sym_restrict] = ACTIONS(264),
    [anon_sym___restrict__] = ACTIONS(264),
    [anon_sym__Atomic] = ACTIONS(264),
    [anon_sym__Noreturn] = ACTIONS(264),
    [anon_sym_noreturn] = ACTIONS(264),
    [sym_primitive_type] = ACTIONS(267),
    [anon_sym_enum] = ACTIONS(270),
    [anon_sym_struct] = ACTIONS(273),
    [anon_sym_union] = ACTIONS(276),
    [anon_sym_if] = ACTIONS(484),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_case] = ACTIONS(490),
    [anon_sym_default] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(502),
    [anon_sym_return] = ACTIONS(505),
    [anon_sym_break] = ACTIONS(508),
    [anon_sym_continue] = ACTIONS(511),
    [anon_sym_goto] = ACTIONS(514),
    [anon_sym___try] = ACTIONS(517),
    [anon_sym___leave] = ACTIONS(520),
    [anon_sym_DASH_DASH] = ACTIONS(318),
    [anon_sym_PLUS_PLUS] = ACTIONS(318),
    [anon_sym_sizeof] = ACTIONS(321),
    [anon_sym___alignof__] = ACTIONS(324),
    [anon_sym___alignof] = ACTIONS(324),
    [anon_sym__alignof] = ACTIONS(324),
    [anon_sym_alignof] = ACTIONS(324),
    [anon_sym__Alignof] = ACTIONS(324),
    [anon_sym_offsetof] = ACTIONS(327),
    [anon_sym__Generic] = ACTIONS(330),
    [anon_sym_asm] = ACTIONS(333),
    [anon_sym___asm__] = ACTIONS(333),
    [sym_number_literal] = ACTIONS(336),
    [anon_sym_L_SQUOTE] = ACTIONS(339),
    [anon_sym_u_SQUOTE] = ACTIONS(339),
    [anon_sym_U_SQUOTE] = ACTIONS(339),
    [anon_sym_u8_SQUOTE] = ACTIONS(339),
    [anon_sym_SQUOTE] = ACTIONS(339),
    [anon_sym_L_DQUOTE] = ACTIONS(342),
    [anon_sym_u_DQUOTE] = ACTIONS(342),
    [anon_sym_U_DQUOTE] = ACTIONS(342),
    [anon_sym_u8_DQUOTE] = ACTIONS(342),
    [anon_sym_DQUOTE] = ACTIONS(342),
    [sym_true] = ACTIONS(345),
    [sym_false] = ACTIONS(345),
    [anon_sym_NULL] = ACTIONS(348),
    [anon_sym_nullptr] = ACTIONS(348),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(337),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1135),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(744),
    [sym_compound_statement] = STATE(24),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(863),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_case_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_goto_statement] = STATE(24),
    [sym_seh_try_statement] = STATE(24),
    [sym_seh_leave_statement] = STATE(24),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(401),
    [aux_sym_preproc_include_token1] = ACTIONS(403),
    [aux_sym_preproc_def_token1] = ACTIONS(405),
    [aux_sym_preproc_if_token1] = ACTIONS(407),
    [aux_sym_preproc_if_token2] = ACTIONS(525),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(411),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(411),
    [sym_preproc_directive] = ACTIONS(413),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym___extension__] = ACTIONS(417),
    [anon_sym_typedef] = ACTIONS(419),
    [anon_sym_extern] = ACTIONS(421),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_switch] = ACTIONS(427),
    [anon_sym_case] = ACTIONS(429),
    [anon_sym_default] = ACTIONS(431),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(443),
    [anon_sym_goto] = ACTIONS(445),
    [anon_sym___try] = ACTIONS(447),
    [anon_sym___leave] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_preproc_include] = STATE(30),
    [sym_preproc_def] = STATE(30),
    [sym_preproc_function_def] = STATE(30),
    [sym_preproc_call] = STATE(30),
    [sym_preproc_if] = STATE(30),
    [sym_preproc_ifdef] = STATE(30),
    [sym_function_definition] = STATE(30),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(30),
    [sym_type_definition] = STATE(30),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(30),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(30),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(30),
    [sym_labeled_statement] = STATE(30),
    [sym_expression_statement] = STATE(30),
    [sym_if_statement] = STATE(30),
    [sym_switch_statement] = STATE(30),
    [sym_case_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_do_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_return_statement] = STATE(30),
    [sym_break_statement] = STATE(30),
    [sym_continue_statement] = STATE(30),
    [sym_goto_statement] = STATE(30),
    [sym_seh_try_statement] = STATE(30),
    [sym_seh_leave_statement] = STATE(30),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(30),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(30),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_preproc_include] = STATE(29),
    [sym_preproc_def] = STATE(29),
    [sym_preproc_function_def] = STATE(29),
    [sym_preproc_call] = STATE(29),
    [sym_preproc_if] = STATE(29),
    [sym_preproc_ifdef] = STATE(29),
    [sym_function_definition] = STATE(29),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(29),
    [sym_type_definition] = STATE(29),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(29),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(29),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(29),
    [sym_labeled_statement] = STATE(29),
    [sym_expression_statement] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_switch_statement] = STATE(29),
    [sym_case_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_do_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_return_statement] = STATE(29),
    [sym_break_statement] = STATE(29),
    [sym_continue_statement] = STATE(29),
    [sym_goto_statement] = STATE(29),
    [sym_seh_try_statement] = STATE(29),
    [sym_seh_leave_statement] = STATE(29),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(29),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(29),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(541),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(543),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(545),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_preproc_include] = STATE(35),
    [sym_preproc_def] = STATE(35),
    [sym_preproc_function_def] = STATE(35),
    [sym_preproc_call] = STATE(35),
    [sym_preproc_if] = STATE(35),
    [sym_preproc_ifdef] = STATE(35),
    [sym_function_definition] = STATE(35),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(35),
    [sym_type_definition] = STATE(35),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(35),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(35),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(35),
    [sym_labeled_statement] = STATE(35),
    [sym_expression_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_switch_statement] = STATE(35),
    [sym_case_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_do_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_return_statement] = STATE(35),
    [sym_break_statement] = STATE(35),
    [sym_continue_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym_seh_try_statement] = STATE(35),
    [sym_seh_leave_statement] = STATE(35),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(35),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(35),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(547),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(549),
    [aux_sym_preproc_include_token1] = ACTIONS(552),
    [aux_sym_preproc_def_token1] = ACTIONS(555),
    [aux_sym_preproc_if_token1] = ACTIONS(558),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(561),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(561),
    [sym_preproc_directive] = ACTIONS(564),
    [anon_sym_LPAREN2] = ACTIONS(219),
    [anon_sym_BANG] = ACTIONS(222),
    [anon_sym_TILDE] = ACTIONS(222),
    [anon_sym_DASH] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(225),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_AMP] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(567),
    [anon_sym___extension__] = ACTIONS(570),
    [anon_sym_typedef] = ACTIONS(573),
    [anon_sym_extern] = ACTIONS(576),
    [anon_sym___attribute__] = ACTIONS(243),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(246),
    [anon_sym___declspec] = ACTIONS(249),
    [anon_sym___cdecl] = ACTIONS(252),
    [anon_sym___clrcall] = ACTIONS(252),
    [anon_sym___stdcall] = ACTIONS(252),
    [anon_sym___fastcall] = ACTIONS(252),
    [anon_sym___thiscall] = ACTIONS(252),
    [anon_sym___vectorcall] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_RBRACE] = ACTIONS(582),
    [anon_sym_signed] = ACTIONS(258),
    [anon_sym_unsigned] = ACTIONS(258),
    [anon_sym_long] = ACTIONS(258),
    [anon_sym_short] = ACTIONS(258),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_auto] = ACTIONS(261),
    [anon_sym_register] = ACTIONS(261),
    [anon_sym_inline] = ACTIONS(261),
    [anon_sym___inline] = ACTIONS(261),
    [anon_sym___inline__] = ACTIONS(261),
    [anon_sym___forceinline] = ACTIONS(261),
    [anon_sym_thread_local] = ACTIONS(261),
    [anon_sym___thread] = ACTIONS(261),
    [anon_sym_const] = ACTIONS(264),
    [anon_sym_constexpr] = ACTIONS(264),
    [anon_sym_volatile] = ACTIONS(264),
    [anon_sym_restrict] = ACTIONS(264),
    [anon_sym___restrict__] = ACTIONS(264),
    [anon_sym__Atomic] = ACTIONS(264),
    [anon_sym__Noreturn] = ACTIONS(264),
    [anon_sym_noreturn] = ACTIONS(264),
    [sym_primitive_type] = ACTIONS(267),
    [anon_sym_enum] = ACTIONS(270),
    [anon_sym_struct] = ACTIONS(273),
    [anon_sym_union] = ACTIONS(276),
    [anon_sym_if] = ACTIONS(584),
    [anon_sym_switch] = ACTIONS(587),
    [anon_sym_case] = ACTIONS(590),
    [anon_sym_default] = ACTIONS(593),
    [anon_sym_while] = ACTIONS(596),
    [anon_sym_do] = ACTIONS(599),
    [anon_sym_for] = ACTIONS(602),
    [anon_sym_return] = ACTIONS(605),
    [anon_sym_break] = ACTIONS(608),
    [anon_sym_continue] = ACTIONS(611),
    [anon_sym_goto] = ACTIONS(614),
    [anon_sym___try] = ACTIONS(617),
    [anon_sym___leave] = ACTIONS(620),
    [anon_sym_DASH_DASH] = ACTIONS(318),
    [anon_sym_PLUS_PLUS] = ACTIONS(318),
    [anon_sym_sizeof] = ACTIONS(321),
    [anon_sym___alignof__] = ACTIONS(324),
    [anon_sym___alignof] = ACTIONS(324),
    [anon_sym__alignof] = ACTIONS(324),
    [anon_sym_alignof] = ACTIONS(324),
    [anon_sym__Alignof] = ACTIONS(324),
    [anon_sym_offsetof] = ACTIONS(327),
    [anon_sym__Generic] = ACTIONS(330),
    [anon_sym_asm] = ACTIONS(333),
    [anon_sym___asm__] = ACTIONS(333),
    [sym_number_literal] = ACTIONS(336),
    [anon_sym_L_SQUOTE] = ACTIONS(339),
    [anon_sym_u_SQUOTE] = ACTIONS(339),
    [anon_sym_U_SQUOTE] = ACTIONS(339),
    [anon_sym_u8_SQUOTE] = ACTIONS(339),
    [anon_sym_SQUOTE] = ACTIONS(339),
    [anon_sym_L_DQUOTE] = ACTIONS(342),
    [anon_sym_u_DQUOTE] = ACTIONS(342),
    [anon_sym_U_DQUOTE] = ACTIONS(342),
    [anon_sym_u8_DQUOTE] = ACTIONS(342),
    [anon_sym_DQUOTE] = ACTIONS(342),
    [sym_true] = ACTIONS(345),
    [sym_false] = ACTIONS(345),
    [anon_sym_NULL] = ACTIONS(348),
    [anon_sym_nullptr] = ACTIONS(348),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_preproc_include] = STATE(42),
    [sym_preproc_def] = STATE(42),
    [sym_preproc_function_def] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym_preproc_if] = STATE(42),
    [sym_preproc_ifdef] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(42),
    [sym_type_definition] = STATE(42),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(42),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(42),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(42),
    [sym_labeled_statement] = STATE(42),
    [sym_expression_statement] = STATE(42),
    [sym_if_statement] = STATE(42),
    [sym_switch_statement] = STATE(42),
    [sym_case_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_do_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_return_statement] = STATE(42),
    [sym_break_statement] = STATE(42),
    [sym_continue_statement] = STATE(42),
    [sym_goto_statement] = STATE(42),
    [sym_seh_try_statement] = STATE(42),
    [sym_seh_leave_statement] = STATE(42),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(42),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(42),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(623),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_preproc_include] = STATE(36),
    [sym_preproc_def] = STATE(36),
    [sym_preproc_function_def] = STATE(36),
    [sym_preproc_call] = STATE(36),
    [sym_preproc_if] = STATE(36),
    [sym_preproc_ifdef] = STATE(36),
    [sym_function_definition] = STATE(36),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(36),
    [sym_type_definition] = STATE(36),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(36),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(36),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(36),
    [sym_labeled_statement] = STATE(36),
    [sym_expression_statement] = STATE(36),
    [sym_if_statement] = STATE(36),
    [sym_switch_statement] = STATE(36),
    [sym_case_statement] = STATE(36),
    [sym_while_statement] = STATE(36),
    [sym_do_statement] = STATE(36),
    [sym_for_statement] = STATE(36),
    [sym_return_statement] = STATE(36),
    [sym_break_statement] = STATE(36),
    [sym_continue_statement] = STATE(36),
    [sym_goto_statement] = STATE(36),
    [sym_seh_try_statement] = STATE(36),
    [sym_seh_leave_statement] = STATE(36),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(36),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(36),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(625),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(367),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1134),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(746),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(867),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(351),
    [aux_sym_preproc_include_token1] = ACTIONS(353),
    [aux_sym_preproc_def_token1] = ACTIONS(355),
    [aux_sym_preproc_if_token1] = ACTIONS(357),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(359),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(359),
    [sym_preproc_directive] = ACTIONS(361),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(369),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(627),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__old_style_function_definition] = STATE(415),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1129),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(747),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(866),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(44),
    [sym_labeled_statement] = STATE(44),
    [sym__top_level_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym__expression] = STATE(1117),
    [sym__expression_not_binary] = STATE(1115),
    [sym__string] = STATE(1115),
    [sym_conditional_expression] = STATE(1115),
    [sym_assignment_expression] = STATE(1115),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(1115),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(1115),
    [sym_cast_expression] = STATE(1115),
    [sym_sizeof_expression] = STATE(1115),
    [sym_alignof_expression] = STATE(1115),
    [sym_offsetof_expression] = STATE(1115),
    [sym_generic_expression] = STATE(1115),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(1115),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(1115),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(1115),
    [sym_concatenated_string] = STATE(1115),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(1115),
    [sym__empty_declaration] = STATE(44),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_translation_unit_repeat1] = STATE(44),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [ts_builtin_sym_end] = ACTIONS(629),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(61),
    [anon_sym_default] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(91),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__old_style_function_definition] = STATE(415),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1129),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_ms_call_modifier] = STATE(747),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(866),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(44),
    [sym_labeled_statement] = STATE(44),
    [sym__top_level_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym__expression] = STATE(1117),
    [sym__expression_not_binary] = STATE(1115),
    [sym__string] = STATE(1115),
    [sym_conditional_expression] = STATE(1115),
    [sym_assignment_expression] = STATE(1115),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(1115),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(1115),
    [sym_cast_expression] = STATE(1115),
    [sym_sizeof_expression] = STATE(1115),
    [sym_alignof_expression] = STATE(1115),
    [sym_offsetof_expression] = STATE(1115),
    [sym_generic_expression] = STATE(1115),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(1115),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(1115),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(1115),
    [sym_concatenated_string] = STATE(1115),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(1115),
    [sym__empty_declaration] = STATE(44),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym_translation_unit_repeat1] = STATE(44),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [ts_builtin_sym_end] = ACTIONS(631),
    [sym_identifier] = ACTIONS(633),
    [aux_sym_preproc_include_token1] = ACTIONS(636),
    [aux_sym_preproc_def_token1] = ACTIONS(639),
    [aux_sym_preproc_if_token1] = ACTIONS(642),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(645),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(645),
    [sym_preproc_directive] = ACTIONS(648),
    [anon_sym_LPAREN2] = ACTIONS(651),
    [anon_sym_BANG] = ACTIONS(654),
    [anon_sym_TILDE] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(657),
    [anon_sym_PLUS] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(660),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym___extension__] = ACTIONS(663),
    [anon_sym_typedef] = ACTIONS(666),
    [anon_sym_extern] = ACTIONS(669),
    [anon_sym___attribute__] = ACTIONS(672),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(675),
    [anon_sym___declspec] = ACTIONS(678),
    [anon_sym___cdecl] = ACTIONS(681),
    [anon_sym___clrcall] = ACTIONS(681),
    [anon_sym___stdcall] = ACTIONS(681),
    [anon_sym___fastcall] = ACTIONS(681),
    [anon_sym___thiscall] = ACTIONS(681),
    [anon_sym___vectorcall] = ACTIONS(681),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_signed] = ACTIONS(687),
    [anon_sym_unsigned] = ACTIONS(687),
    [anon_sym_long] = ACTIONS(687),
    [anon_sym_short] = ACTIONS(687),
    [anon_sym_static] = ACTIONS(690),
    [anon_sym_auto] = ACTIONS(690),
    [anon_sym_register] = ACTIONS(690),
    [anon_sym_inline] = ACTIONS(690),
    [anon_sym___inline] = ACTIONS(690),
    [anon_sym___inline__] = ACTIONS(690),
    [anon_sym___forceinline] = ACTIONS(690),
    [anon_sym_thread_local] = ACTIONS(690),
    [anon_sym___thread] = ACTIONS(690),
    [anon_sym_const] = ACTIONS(693),
    [anon_sym_constexpr] = ACTIONS(693),
    [anon_sym_volatile] = ACTIONS(693),
    [anon_sym_restrict] = ACTIONS(693),
    [anon_sym___restrict__] = ACTIONS(693),
    [anon_sym__Atomic] = ACTIONS(693),
    [anon_sym__Noreturn] = ACTIONS(693),
    [anon_sym_noreturn] = ACTIONS(693),
    [sym_primitive_type] = ACTIONS(696),
    [anon_sym_enum] = ACTIONS(699),
    [anon_sym_struct] = ACTIONS(702),
    [anon_sym_union] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(711),
    [anon_sym_case] = ACTIONS(714),
    [anon_sym_default] = ACTIONS(717),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_do] = ACTIONS(723),
    [anon_sym_for] = ACTIONS(726),
    [anon_sym_return] = ACTIONS(729),
    [anon_sym_break] = ACTIONS(732),
    [anon_sym_continue] = ACTIONS(735),
    [anon_sym_goto] = ACTIONS(738),
    [anon_sym_DASH_DASH] = ACTIONS(741),
    [anon_sym_PLUS_PLUS] = ACTIONS(741),
    [anon_sym_sizeof] = ACTIONS(744),
    [anon_sym___alignof__] = ACTIONS(747),
    [anon_sym___alignof] = ACTIONS(747),
    [anon_sym__alignof] = ACTIONS(747),
    [anon_sym_alignof] = ACTIONS(747),
    [anon_sym__Alignof] = ACTIONS(747),
    [anon_sym_offsetof] = ACTIONS(750),
    [anon_sym__Generic] = ACTIONS(753),
    [anon_sym_asm] = ACTIONS(756),
    [anon_sym___asm__] = ACTIONS(756),
    [sym_number_literal] = ACTIONS(759),
    [anon_sym_L_SQUOTE] = ACTIONS(762),
    [anon_sym_u_SQUOTE] = ACTIONS(762),
    [anon_sym_U_SQUOTE] = ACTIONS(762),
    [anon_sym_u8_SQUOTE] = ACTIONS(762),
    [anon_sym_SQUOTE] = ACTIONS(762),
    [anon_sym_L_DQUOTE] = ACTIONS(765),
    [anon_sym_u_DQUOTE] = ACTIONS(765),
    [anon_sym_U_DQUOTE] = ACTIONS(765),
    [anon_sym_u8_DQUOTE] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(765),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [anon_sym_NULL] = ACTIONS(771),
    [anon_sym_nullptr] = ACTIONS(771),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_declaration] = STATE(46),
    [sym_type_definition] = STATE(46),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1153),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(46),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(46),
    [sym_labeled_statement] = STATE(46),
    [sym_expression_statement] = STATE(46),
    [sym_if_statement] = STATE(46),
    [sym_switch_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_do_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_return_statement] = STATE(46),
    [sym_break_statement] = STATE(46),
    [sym_continue_statement] = STATE(46),
    [sym_goto_statement] = STATE(46),
    [sym_seh_try_statement] = STATE(46),
    [sym_seh_leave_statement] = STATE(46),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(46),
    [sym_identifier] = ACTIONS(774),
    [aux_sym_preproc_include_token1] = ACTIONS(776),
    [aux_sym_preproc_def_token1] = ACTIONS(776),
    [aux_sym_preproc_if_token1] = ACTIONS(776),
    [aux_sym_preproc_if_token2] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(776),
    [aux_sym_preproc_else_token1] = ACTIONS(776),
    [aux_sym_preproc_elif_token1] = ACTIONS(776),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(776),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(776),
    [sym_preproc_directive] = ACTIONS(776),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(776),
    [anon_sym___clrcall] = ACTIONS(776),
    [anon_sym___stdcall] = ACTIONS(776),
    [anon_sym___fastcall] = ACTIONS(776),
    [anon_sym___thiscall] = ACTIONS(776),
    [anon_sym___vectorcall] = ACTIONS(776),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_declaration] = STATE(47),
    [sym_type_definition] = STATE(47),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1153),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(47),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(47),
    [sym_labeled_statement] = STATE(47),
    [sym_expression_statement] = STATE(47),
    [sym_if_statement] = STATE(47),
    [sym_switch_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_do_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_return_statement] = STATE(47),
    [sym_break_statement] = STATE(47),
    [sym_continue_statement] = STATE(47),
    [sym_goto_statement] = STATE(47),
    [sym_seh_try_statement] = STATE(47),
    [sym_seh_leave_statement] = STATE(47),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(47),
    [sym_identifier] = ACTIONS(774),
    [aux_sym_preproc_include_token1] = ACTIONS(778),
    [aux_sym_preproc_def_token1] = ACTIONS(778),
    [aux_sym_preproc_if_token1] = ACTIONS(778),
    [aux_sym_preproc_if_token2] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(778),
    [aux_sym_preproc_else_token1] = ACTIONS(778),
    [aux_sym_preproc_elif_token1] = ACTIONS(778),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(778),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(778),
    [sym_preproc_directive] = ACTIONS(778),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(778),
    [anon_sym___clrcall] = ACTIONS(778),
    [anon_sym___stdcall] = ACTIONS(778),
    [anon_sym___fastcall] = ACTIONS(778),
    [anon_sym___thiscall] = ACTIONS(778),
    [anon_sym___vectorcall] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(778),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(778),
    [anon_sym_default] = ACTIONS(778),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_declaration] = STATE(47),
    [sym_type_definition] = STATE(47),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1153),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(47),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(47),
    [sym_labeled_statement] = STATE(47),
    [sym_expression_statement] = STATE(47),
    [sym_if_statement] = STATE(47),
    [sym_switch_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_do_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_return_statement] = STATE(47),
    [sym_break_statement] = STATE(47),
    [sym_continue_statement] = STATE(47),
    [sym_goto_statement] = STATE(47),
    [sym_seh_try_statement] = STATE(47),
    [sym_seh_leave_statement] = STATE(47),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(47),
    [sym_identifier] = ACTIONS(780),
    [aux_sym_preproc_include_token1] = ACTIONS(783),
    [aux_sym_preproc_def_token1] = ACTIONS(783),
    [aux_sym_preproc_if_token1] = ACTIONS(783),
    [aux_sym_preproc_if_token2] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(783),
    [aux_sym_preproc_else_token1] = ACTIONS(783),
    [aux_sym_preproc_elif_token1] = ACTIONS(783),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(783),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(783),
    [sym_preproc_directive] = ACTIONS(783),
    [anon_sym_LPAREN2] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym_SEMI] = ACTIONS(797),
    [anon_sym___extension__] = ACTIONS(800),
    [anon_sym_typedef] = ACTIONS(803),
    [anon_sym_extern] = ACTIONS(806),
    [anon_sym___attribute__] = ACTIONS(809),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(812),
    [anon_sym___declspec] = ACTIONS(815),
    [anon_sym___cdecl] = ACTIONS(783),
    [anon_sym___clrcall] = ACTIONS(783),
    [anon_sym___stdcall] = ACTIONS(783),
    [anon_sym___fastcall] = ACTIONS(783),
    [anon_sym___thiscall] = ACTIONS(783),
    [anon_sym___vectorcall] = ACTIONS(783),
    [anon_sym_LBRACE] = ACTIONS(818),
    [anon_sym_signed] = ACTIONS(821),
    [anon_sym_unsigned] = ACTIONS(821),
    [anon_sym_long] = ACTIONS(821),
    [anon_sym_short] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_auto] = ACTIONS(806),
    [anon_sym_register] = ACTIONS(806),
    [anon_sym_inline] = ACTIONS(806),
    [anon_sym___inline] = ACTIONS(806),
    [anon_sym___inline__] = ACTIONS(806),
    [anon_sym___forceinline] = ACTIONS(806),
    [anon_sym_thread_local] = ACTIONS(806),
    [anon_sym___thread] = ACTIONS(806),
    [anon_sym_const] = ACTIONS(824),
    [anon_sym_constexpr] = ACTIONS(824),
    [anon_sym_volatile] = ACTIONS(824),
    [anon_sym_restrict] = ACTIONS(824),
    [anon_sym___restrict__] = ACTIONS(824),
    [anon_sym__Atomic] = ACTIONS(824),
    [anon_sym__Noreturn] = ACTIONS(824),
    [anon_sym_noreturn] = ACTIONS(824),
    [sym_primitive_type] = ACTIONS(827),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_struct] = ACTIONS(833),
    [anon_sym_union] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(839),
    [anon_sym_else] = ACTIONS(783),
    [anon_sym_switch] = ACTIONS(842),
    [anon_sym_case] = ACTIONS(783),
    [anon_sym_default] = ACTIONS(783),
    [anon_sym_while] = ACTIONS(845),
    [anon_sym_do] = ACTIONS(848),
    [anon_sym_for] = ACTIONS(851),
    [anon_sym_return] = ACTIONS(854),
    [anon_sym_break] = ACTIONS(857),
    [anon_sym_continue] = ACTIONS(860),
    [anon_sym_goto] = ACTIONS(863),
    [anon_sym___try] = ACTIONS(866),
    [anon_sym___leave] = ACTIONS(869),
    [anon_sym_DASH_DASH] = ACTIONS(872),
    [anon_sym_PLUS_PLUS] = ACTIONS(872),
    [anon_sym_sizeof] = ACTIONS(875),
    [anon_sym___alignof__] = ACTIONS(878),
    [anon_sym___alignof] = ACTIONS(878),
    [anon_sym__alignof] = ACTIONS(878),
    [anon_sym_alignof] = ACTIONS(878),
    [anon_sym__Alignof] = ACTIONS(878),
    [anon_sym_offsetof] = ACTIONS(881),
    [anon_sym__Generic] = ACTIONS(884),
    [anon_sym_asm] = ACTIONS(887),
    [anon_sym___asm__] = ACTIONS(887),
    [sym_number_literal] = ACTIONS(890),
    [anon_sym_L_SQUOTE] = ACTIONS(893),
    [anon_sym_u_SQUOTE] = ACTIONS(893),
    [anon_sym_U_SQUOTE] = ACTIONS(893),
    [anon_sym_u8_SQUOTE] = ACTIONS(893),
    [anon_sym_SQUOTE] = ACTIONS(893),
    [anon_sym_L_DQUOTE] = ACTIONS(896),
    [anon_sym_u_DQUOTE] = ACTIONS(896),
    [anon_sym_U_DQUOTE] = ACTIONS(896),
    [anon_sym_u8_DQUOTE] = ACTIONS(896),
    [anon_sym_DQUOTE] = ACTIONS(896),
    [sym_true] = ACTIONS(899),
    [sym_false] = ACTIONS(899),
    [anon_sym_NULL] = ACTIONS(902),
    [anon_sym_nullptr] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_declaration] = STATE(47),
    [sym_type_definition] = STATE(47),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1153),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(47),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(47),
    [sym_labeled_statement] = STATE(47),
    [sym_expression_statement] = STATE(47),
    [sym_if_statement] = STATE(47),
    [sym_switch_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_do_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_return_statement] = STATE(47),
    [sym_break_statement] = STATE(47),
    [sym_continue_statement] = STATE(47),
    [sym_goto_statement] = STATE(47),
    [sym_seh_try_statement] = STATE(47),
    [sym_seh_leave_statement] = STATE(47),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(47),
    [sym_identifier] = ACTIONS(774),
    [aux_sym_preproc_include_token1] = ACTIONS(905),
    [aux_sym_preproc_def_token1] = ACTIONS(905),
    [aux_sym_preproc_if_token1] = ACTIONS(905),
    [aux_sym_preproc_if_token2] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(905),
    [aux_sym_preproc_else_token1] = ACTIONS(905),
    [aux_sym_preproc_elif_token1] = ACTIONS(905),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(905),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(905),
    [sym_preproc_directive] = ACTIONS(905),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(905),
    [anon_sym___clrcall] = ACTIONS(905),
    [anon_sym___stdcall] = ACTIONS(905),
    [anon_sym___fastcall] = ACTIONS(905),
    [anon_sym___thiscall] = ACTIONS(905),
    [anon_sym___vectorcall] = ACTIONS(905),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(905),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(905),
    [anon_sym_default] = ACTIONS(905),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_declaration] = STATE(48),
    [sym_type_definition] = STATE(48),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1153),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(48),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(48),
    [sym_labeled_statement] = STATE(48),
    [sym_expression_statement] = STATE(48),
    [sym_if_statement] = STATE(48),
    [sym_switch_statement] = STATE(48),
    [sym_while_statement] = STATE(48),
    [sym_do_statement] = STATE(48),
    [sym_for_statement] = STATE(48),
    [sym_return_statement] = STATE(48),
    [sym_break_statement] = STATE(48),
    [sym_continue_statement] = STATE(48),
    [sym_goto_statement] = STATE(48),
    [sym_seh_try_statement] = STATE(48),
    [sym_seh_leave_statement] = STATE(48),
    [sym__expression] = STATE(1085),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1922),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(335),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(48),
    [sym_identifier] = ACTIONS(774),
    [aux_sym_preproc_include_token1] = ACTIONS(907),
    [aux_sym_preproc_def_token1] = ACTIONS(907),
    [aux_sym_preproc_if_token1] = ACTIONS(907),
    [aux_sym_preproc_if_token2] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(907),
    [aux_sym_preproc_else_token1] = ACTIONS(907),
    [aux_sym_preproc_elif_token1] = ACTIONS(907),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(907),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(907),
    [sym_preproc_directive] = ACTIONS(907),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(907),
    [anon_sym___clrcall] = ACTIONS(907),
    [anon_sym___stdcall] = ACTIONS(907),
    [anon_sym___fastcall] = ACTIONS(907),
    [anon_sym___thiscall] = ACTIONS(907),
    [anon_sym___vectorcall] = ACTIONS(907),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(907),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(907),
    [anon_sym_default] = ACTIONS(907),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym__expression] = STATE(1080),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1898),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [ts_builtin_sym_end] = ACTIONS(909),
    [sym_identifier] = ACTIONS(911),
    [aux_sym_preproc_include_token1] = ACTIONS(905),
    [aux_sym_preproc_def_token1] = ACTIONS(905),
    [aux_sym_preproc_if_token1] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(905),
    [sym_preproc_directive] = ACTIONS(905),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(905),
    [anon_sym___clrcall] = ACTIONS(905),
    [anon_sym___stdcall] = ACTIONS(905),
    [anon_sym___fastcall] = ACTIONS(905),
    [anon_sym___thiscall] = ACTIONS(905),
    [anon_sym___vectorcall] = ACTIONS(905),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(905),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(905),
    [anon_sym_default] = ACTIONS(905),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(915),
    [anon_sym___leave] = ACTIONS(917),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_declaration] = STATE(51),
    [sym_type_definition] = STATE(51),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1144),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(51),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(51),
    [sym_labeled_statement] = STATE(51),
    [sym_expression_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_switch_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_do_statement] = STATE(51),
    [sym_for_statement] = STATE(51),
    [sym_return_statement] = STATE(51),
    [sym_break_statement] = STATE(51),
    [sym_continue_statement] = STATE(51),
    [sym_goto_statement] = STATE(51),
    [sym_seh_try_statement] = STATE(51),
    [sym_seh_leave_statement] = STATE(51),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(51),
    [sym_identifier] = ACTIONS(919),
    [aux_sym_preproc_include_token1] = ACTIONS(783),
    [aux_sym_preproc_def_token1] = ACTIONS(783),
    [aux_sym_preproc_if_token1] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(783),
    [sym_preproc_directive] = ACTIONS(783),
    [anon_sym_LPAREN2] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym_SEMI] = ACTIONS(922),
    [anon_sym___extension__] = ACTIONS(925),
    [anon_sym_typedef] = ACTIONS(928),
    [anon_sym_extern] = ACTIONS(806),
    [anon_sym___attribute__] = ACTIONS(809),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(812),
    [anon_sym___declspec] = ACTIONS(815),
    [anon_sym___cdecl] = ACTIONS(783),
    [anon_sym___clrcall] = ACTIONS(783),
    [anon_sym___stdcall] = ACTIONS(783),
    [anon_sym___fastcall] = ACTIONS(783),
    [anon_sym___thiscall] = ACTIONS(783),
    [anon_sym___vectorcall] = ACTIONS(783),
    [anon_sym_LBRACE] = ACTIONS(931),
    [anon_sym_RBRACE] = ACTIONS(934),
    [anon_sym_signed] = ACTIONS(821),
    [anon_sym_unsigned] = ACTIONS(821),
    [anon_sym_long] = ACTIONS(821),
    [anon_sym_short] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_auto] = ACTIONS(806),
    [anon_sym_register] = ACTIONS(806),
    [anon_sym_inline] = ACTIONS(806),
    [anon_sym___inline] = ACTIONS(806),
    [anon_sym___inline__] = ACTIONS(806),
    [anon_sym___forceinline] = ACTIONS(806),
    [anon_sym_thread_local] = ACTIONS(806),
    [anon_sym___thread] = ACTIONS(806),
    [anon_sym_const] = ACTIONS(824),
    [anon_sym_constexpr] = ACTIONS(824),
    [anon_sym_volatile] = ACTIONS(824),
    [anon_sym_restrict] = ACTIONS(824),
    [anon_sym___restrict__] = ACTIONS(824),
    [anon_sym__Atomic] = ACTIONS(824),
    [anon_sym__Noreturn] = ACTIONS(824),
    [anon_sym_noreturn] = ACTIONS(824),
    [sym_primitive_type] = ACTIONS(827),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_struct] = ACTIONS(833),
    [anon_sym_union] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(936),
    [anon_sym_else] = ACTIONS(783),
    [anon_sym_switch] = ACTIONS(939),
    [anon_sym_case] = ACTIONS(783),
    [anon_sym_default] = ACTIONS(783),
    [anon_sym_while] = ACTIONS(942),
    [anon_sym_do] = ACTIONS(945),
    [anon_sym_for] = ACTIONS(948),
    [anon_sym_return] = ACTIONS(951),
    [anon_sym_break] = ACTIONS(954),
    [anon_sym_continue] = ACTIONS(957),
    [anon_sym_goto] = ACTIONS(960),
    [anon_sym___try] = ACTIONS(963),
    [anon_sym___leave] = ACTIONS(966),
    [anon_sym_DASH_DASH] = ACTIONS(872),
    [anon_sym_PLUS_PLUS] = ACTIONS(872),
    [anon_sym_sizeof] = ACTIONS(875),
    [anon_sym___alignof__] = ACTIONS(878),
    [anon_sym___alignof] = ACTIONS(878),
    [anon_sym__alignof] = ACTIONS(878),
    [anon_sym_alignof] = ACTIONS(878),
    [anon_sym__Alignof] = ACTIONS(878),
    [anon_sym_offsetof] = ACTIONS(881),
    [anon_sym__Generic] = ACTIONS(884),
    [anon_sym_asm] = ACTIONS(887),
    [anon_sym___asm__] = ACTIONS(887),
    [sym_number_literal] = ACTIONS(890),
    [anon_sym_L_SQUOTE] = ACTIONS(893),
    [anon_sym_u_SQUOTE] = ACTIONS(893),
    [anon_sym_U_SQUOTE] = ACTIONS(893),
    [anon_sym_u8_SQUOTE] = ACTIONS(893),
    [anon_sym_SQUOTE] = ACTIONS(893),
    [anon_sym_L_DQUOTE] = ACTIONS(896),
    [anon_sym_u_DQUOTE] = ACTIONS(896),
    [anon_sym_U_DQUOTE] = ACTIONS(896),
    [anon_sym_u8_DQUOTE] = ACTIONS(896),
    [anon_sym_DQUOTE] = ACTIONS(896),
    [sym_true] = ACTIONS(899),
    [sym_false] = ACTIONS(899),
    [anon_sym_NULL] = ACTIONS(902),
    [anon_sym_nullptr] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_declaration] = STATE(51),
    [sym_type_definition] = STATE(51),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1144),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(51),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(51),
    [sym_labeled_statement] = STATE(51),
    [sym_expression_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_switch_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_do_statement] = STATE(51),
    [sym_for_statement] = STATE(51),
    [sym_return_statement] = STATE(51),
    [sym_break_statement] = STATE(51),
    [sym_continue_statement] = STATE(51),
    [sym_goto_statement] = STATE(51),
    [sym_seh_try_statement] = STATE(51),
    [sym_seh_leave_statement] = STATE(51),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(51),
    [sym_identifier] = ACTIONS(969),
    [aux_sym_preproc_include_token1] = ACTIONS(778),
    [aux_sym_preproc_def_token1] = ACTIONS(778),
    [aux_sym_preproc_if_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(778),
    [sym_preproc_directive] = ACTIONS(778),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(778),
    [anon_sym___clrcall] = ACTIONS(778),
    [anon_sym___stdcall] = ACTIONS(778),
    [anon_sym___fastcall] = ACTIONS(778),
    [anon_sym___thiscall] = ACTIONS(778),
    [anon_sym___vectorcall] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(971),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_else] = ACTIONS(778),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(778),
    [anon_sym_default] = ACTIONS(778),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_declaration] = STATE(51),
    [sym_type_definition] = STATE(51),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1144),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(51),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(51),
    [sym_labeled_statement] = STATE(51),
    [sym_expression_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_switch_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_do_statement] = STATE(51),
    [sym_for_statement] = STATE(51),
    [sym_return_statement] = STATE(51),
    [sym_break_statement] = STATE(51),
    [sym_continue_statement] = STATE(51),
    [sym_goto_statement] = STATE(51),
    [sym_seh_try_statement] = STATE(51),
    [sym_seh_leave_statement] = STATE(51),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(51),
    [sym_identifier] = ACTIONS(969),
    [aux_sym_preproc_include_token1] = ACTIONS(905),
    [aux_sym_preproc_def_token1] = ACTIONS(905),
    [aux_sym_preproc_if_token1] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(905),
    [sym_preproc_directive] = ACTIONS(905),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(905),
    [anon_sym___clrcall] = ACTIONS(905),
    [anon_sym___stdcall] = ACTIONS(905),
    [anon_sym___fastcall] = ACTIONS(905),
    [anon_sym___thiscall] = ACTIONS(905),
    [anon_sym___vectorcall] = ACTIONS(905),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(909),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_else] = ACTIONS(905),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(905),
    [anon_sym_default] = ACTIONS(905),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(973),
    [aux_sym_preproc_include_token1] = ACTIONS(783),
    [aux_sym_preproc_def_token1] = ACTIONS(783),
    [aux_sym_preproc_if_token1] = ACTIONS(783),
    [aux_sym_preproc_if_token2] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(783),
    [sym_preproc_directive] = ACTIONS(783),
    [anon_sym_LPAREN2] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym_SEMI] = ACTIONS(976),
    [anon_sym___extension__] = ACTIONS(979),
    [anon_sym_typedef] = ACTIONS(982),
    [anon_sym_extern] = ACTIONS(806),
    [anon_sym___attribute__] = ACTIONS(809),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(812),
    [anon_sym___declspec] = ACTIONS(815),
    [anon_sym___cdecl] = ACTIONS(783),
    [anon_sym___clrcall] = ACTIONS(783),
    [anon_sym___stdcall] = ACTIONS(783),
    [anon_sym___fastcall] = ACTIONS(783),
    [anon_sym___thiscall] = ACTIONS(783),
    [anon_sym___vectorcall] = ACTIONS(783),
    [anon_sym_LBRACE] = ACTIONS(985),
    [anon_sym_signed] = ACTIONS(821),
    [anon_sym_unsigned] = ACTIONS(821),
    [anon_sym_long] = ACTIONS(821),
    [anon_sym_short] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_auto] = ACTIONS(806),
    [anon_sym_register] = ACTIONS(806),
    [anon_sym_inline] = ACTIONS(806),
    [anon_sym___inline] = ACTIONS(806),
    [anon_sym___inline__] = ACTIONS(806),
    [anon_sym___forceinline] = ACTIONS(806),
    [anon_sym_thread_local] = ACTIONS(806),
    [anon_sym___thread] = ACTIONS(806),
    [anon_sym_const] = ACTIONS(824),
    [anon_sym_constexpr] = ACTIONS(824),
    [anon_sym_volatile] = ACTIONS(824),
    [anon_sym_restrict] = ACTIONS(824),
    [anon_sym___restrict__] = ACTIONS(824),
    [anon_sym__Atomic] = ACTIONS(824),
    [anon_sym__Noreturn] = ACTIONS(824),
    [anon_sym_noreturn] = ACTIONS(824),
    [sym_primitive_type] = ACTIONS(827),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_struct] = ACTIONS(833),
    [anon_sym_union] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(988),
    [anon_sym_else] = ACTIONS(783),
    [anon_sym_switch] = ACTIONS(991),
    [anon_sym_case] = ACTIONS(783),
    [anon_sym_default] = ACTIONS(783),
    [anon_sym_while] = ACTIONS(994),
    [anon_sym_do] = ACTIONS(997),
    [anon_sym_for] = ACTIONS(1000),
    [anon_sym_return] = ACTIONS(1003),
    [anon_sym_break] = ACTIONS(1006),
    [anon_sym_continue] = ACTIONS(1009),
    [anon_sym_goto] = ACTIONS(1012),
    [anon_sym___try] = ACTIONS(1015),
    [anon_sym___leave] = ACTIONS(1018),
    [anon_sym_DASH_DASH] = ACTIONS(872),
    [anon_sym_PLUS_PLUS] = ACTIONS(872),
    [anon_sym_sizeof] = ACTIONS(875),
    [anon_sym___alignof__] = ACTIONS(878),
    [anon_sym___alignof] = ACTIONS(878),
    [anon_sym__alignof] = ACTIONS(878),
    [anon_sym_alignof] = ACTIONS(878),
    [anon_sym__Alignof] = ACTIONS(878),
    [anon_sym_offsetof] = ACTIONS(881),
    [anon_sym__Generic] = ACTIONS(884),
    [anon_sym_asm] = ACTIONS(887),
    [anon_sym___asm__] = ACTIONS(887),
    [sym_number_literal] = ACTIONS(890),
    [anon_sym_L_SQUOTE] = ACTIONS(893),
    [anon_sym_u_SQUOTE] = ACTIONS(893),
    [anon_sym_U_SQUOTE] = ACTIONS(893),
    [anon_sym_u8_SQUOTE] = ACTIONS(893),
    [anon_sym_SQUOTE] = ACTIONS(893),
    [anon_sym_L_DQUOTE] = ACTIONS(896),
    [anon_sym_u_DQUOTE] = ACTIONS(896),
    [anon_sym_U_DQUOTE] = ACTIONS(896),
    [anon_sym_u8_DQUOTE] = ACTIONS(896),
    [anon_sym_DQUOTE] = ACTIONS(896),
    [sym_true] = ACTIONS(899),
    [sym_false] = ACTIONS(899),
    [anon_sym_NULL] = ACTIONS(902),
    [anon_sym_nullptr] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_declaration] = STATE(57),
    [sym_type_definition] = STATE(57),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(57),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(57),
    [sym_labeled_statement] = STATE(57),
    [sym_expression_statement] = STATE(57),
    [sym_if_statement] = STATE(57),
    [sym_switch_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_do_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_return_statement] = STATE(57),
    [sym_break_statement] = STATE(57),
    [sym_continue_statement] = STATE(57),
    [sym_goto_statement] = STATE(57),
    [sym_seh_try_statement] = STATE(57),
    [sym_seh_leave_statement] = STATE(57),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(57),
    [sym_identifier] = ACTIONS(1021),
    [aux_sym_preproc_include_token1] = ACTIONS(776),
    [aux_sym_preproc_def_token1] = ACTIONS(776),
    [aux_sym_preproc_if_token1] = ACTIONS(776),
    [aux_sym_preproc_if_token2] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(776),
    [sym_preproc_directive] = ACTIONS(776),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym___extension__] = ACTIONS(417),
    [anon_sym_typedef] = ACTIONS(419),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(776),
    [anon_sym___clrcall] = ACTIONS(776),
    [anon_sym___stdcall] = ACTIONS(776),
    [anon_sym___fastcall] = ACTIONS(776),
    [anon_sym___thiscall] = ACTIONS(776),
    [anon_sym___vectorcall] = ACTIONS(776),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(427),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(443),
    [anon_sym_goto] = ACTIONS(445),
    [anon_sym___try] = ACTIONS(447),
    [anon_sym___leave] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_declaration] = STATE(52),
    [sym_type_definition] = STATE(52),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1144),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(52),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(52),
    [sym_labeled_statement] = STATE(52),
    [sym_expression_statement] = STATE(52),
    [sym_if_statement] = STATE(52),
    [sym_switch_statement] = STATE(52),
    [sym_while_statement] = STATE(52),
    [sym_do_statement] = STATE(52),
    [sym_for_statement] = STATE(52),
    [sym_return_statement] = STATE(52),
    [sym_break_statement] = STATE(52),
    [sym_continue_statement] = STATE(52),
    [sym_goto_statement] = STATE(52),
    [sym_seh_try_statement] = STATE(52),
    [sym_seh_leave_statement] = STATE(52),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(52),
    [sym_identifier] = ACTIONS(969),
    [aux_sym_preproc_include_token1] = ACTIONS(776),
    [aux_sym_preproc_def_token1] = ACTIONS(776),
    [aux_sym_preproc_if_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(776),
    [sym_preproc_directive] = ACTIONS(776),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(776),
    [anon_sym___clrcall] = ACTIONS(776),
    [anon_sym___stdcall] = ACTIONS(776),
    [anon_sym___fastcall] = ACTIONS(776),
    [anon_sym___thiscall] = ACTIONS(776),
    [anon_sym___vectorcall] = ACTIONS(776),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(1023),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(1021),
    [aux_sym_preproc_include_token1] = ACTIONS(778),
    [aux_sym_preproc_def_token1] = ACTIONS(778),
    [aux_sym_preproc_if_token1] = ACTIONS(778),
    [aux_sym_preproc_if_token2] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(778),
    [sym_preproc_directive] = ACTIONS(778),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym___extension__] = ACTIONS(417),
    [anon_sym_typedef] = ACTIONS(419),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(778),
    [anon_sym___clrcall] = ACTIONS(778),
    [anon_sym___stdcall] = ACTIONS(778),
    [anon_sym___fastcall] = ACTIONS(778),
    [anon_sym___thiscall] = ACTIONS(778),
    [anon_sym___vectorcall] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(778),
    [anon_sym_switch] = ACTIONS(427),
    [anon_sym_case] = ACTIONS(778),
    [anon_sym_default] = ACTIONS(778),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(443),
    [anon_sym_goto] = ACTIONS(445),
    [anon_sym___try] = ACTIONS(447),
    [anon_sym___leave] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(1021),
    [aux_sym_preproc_include_token1] = ACTIONS(905),
    [aux_sym_preproc_def_token1] = ACTIONS(905),
    [aux_sym_preproc_if_token1] = ACTIONS(905),
    [aux_sym_preproc_if_token2] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(905),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(905),
    [sym_preproc_directive] = ACTIONS(905),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym___extension__] = ACTIONS(417),
    [anon_sym_typedef] = ACTIONS(419),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(905),
    [anon_sym___clrcall] = ACTIONS(905),
    [anon_sym___stdcall] = ACTIONS(905),
    [anon_sym___fastcall] = ACTIONS(905),
    [anon_sym___thiscall] = ACTIONS(905),
    [anon_sym___vectorcall] = ACTIONS(905),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(905),
    [anon_sym_switch] = ACTIONS(427),
    [anon_sym_case] = ACTIONS(905),
    [anon_sym_default] = ACTIONS(905),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(443),
    [anon_sym_goto] = ACTIONS(445),
    [anon_sym___try] = ACTIONS(447),
    [anon_sym___leave] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_declaration] = STATE(53),
    [sym_type_definition] = STATE(53),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1144),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(53),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(53),
    [sym_labeled_statement] = STATE(53),
    [sym_expression_statement] = STATE(53),
    [sym_if_statement] = STATE(53),
    [sym_switch_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_do_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_return_statement] = STATE(53),
    [sym_break_statement] = STATE(53),
    [sym_continue_statement] = STATE(53),
    [sym_goto_statement] = STATE(53),
    [sym_seh_try_statement] = STATE(53),
    [sym_seh_leave_statement] = STATE(53),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(400),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(53),
    [sym_identifier] = ACTIONS(969),
    [aux_sym_preproc_include_token1] = ACTIONS(907),
    [aux_sym_preproc_def_token1] = ACTIONS(907),
    [aux_sym_preproc_if_token1] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(907),
    [sym_preproc_directive] = ACTIONS(907),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(365),
    [anon_sym_typedef] = ACTIONS(367),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(907),
    [anon_sym___clrcall] = ACTIONS(907),
    [anon_sym___stdcall] = ACTIONS(907),
    [anon_sym___fastcall] = ACTIONS(907),
    [anon_sym___thiscall] = ACTIONS(907),
    [anon_sym___vectorcall] = ACTIONS(907),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(1025),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_else] = ACTIONS(907),
    [anon_sym_switch] = ACTIONS(377),
    [anon_sym_case] = ACTIONS(907),
    [anon_sym_default] = ACTIONS(907),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(393),
    [anon_sym_goto] = ACTIONS(395),
    [anon_sym___try] = ACTIONS(397),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym__expression] = STATE(1080),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1898),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [ts_builtin_sym_end] = ACTIONS(934),
    [sym_identifier] = ACTIONS(1027),
    [aux_sym_preproc_include_token1] = ACTIONS(783),
    [aux_sym_preproc_def_token1] = ACTIONS(783),
    [aux_sym_preproc_if_token1] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(783),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(783),
    [sym_preproc_directive] = ACTIONS(783),
    [anon_sym_LPAREN2] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym_SEMI] = ACTIONS(1030),
    [anon_sym___extension__] = ACTIONS(1033),
    [anon_sym_typedef] = ACTIONS(1036),
    [anon_sym_extern] = ACTIONS(806),
    [anon_sym___attribute__] = ACTIONS(809),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(812),
    [anon_sym___declspec] = ACTIONS(815),
    [anon_sym___cdecl] = ACTIONS(783),
    [anon_sym___clrcall] = ACTIONS(783),
    [anon_sym___stdcall] = ACTIONS(783),
    [anon_sym___fastcall] = ACTIONS(783),
    [anon_sym___thiscall] = ACTIONS(783),
    [anon_sym___vectorcall] = ACTIONS(783),
    [anon_sym_LBRACE] = ACTIONS(1039),
    [anon_sym_signed] = ACTIONS(821),
    [anon_sym_unsigned] = ACTIONS(821),
    [anon_sym_long] = ACTIONS(821),
    [anon_sym_short] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_auto] = ACTIONS(806),
    [anon_sym_register] = ACTIONS(806),
    [anon_sym_inline] = ACTIONS(806),
    [anon_sym___inline] = ACTIONS(806),
    [anon_sym___inline__] = ACTIONS(806),
    [anon_sym___forceinline] = ACTIONS(806),
    [anon_sym_thread_local] = ACTIONS(806),
    [anon_sym___thread] = ACTIONS(806),
    [anon_sym_const] = ACTIONS(824),
    [anon_sym_constexpr] = ACTIONS(824),
    [anon_sym_volatile] = ACTIONS(824),
    [anon_sym_restrict] = ACTIONS(824),
    [anon_sym___restrict__] = ACTIONS(824),
    [anon_sym__Atomic] = ACTIONS(824),
    [anon_sym__Noreturn] = ACTIONS(824),
    [anon_sym_noreturn] = ACTIONS(824),
    [sym_primitive_type] = ACTIONS(827),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_struct] = ACTIONS(833),
    [anon_sym_union] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(1042),
    [anon_sym_else] = ACTIONS(783),
    [anon_sym_switch] = ACTIONS(1045),
    [anon_sym_case] = ACTIONS(783),
    [anon_sym_default] = ACTIONS(783),
    [anon_sym_while] = ACTIONS(1048),
    [anon_sym_do] = ACTIONS(1051),
    [anon_sym_for] = ACTIONS(1054),
    [anon_sym_return] = ACTIONS(1057),
    [anon_sym_break] = ACTIONS(1060),
    [anon_sym_continue] = ACTIONS(1063),
    [anon_sym_goto] = ACTIONS(1066),
    [anon_sym___try] = ACTIONS(1069),
    [anon_sym___leave] = ACTIONS(1072),
    [anon_sym_DASH_DASH] = ACTIONS(872),
    [anon_sym_PLUS_PLUS] = ACTIONS(872),
    [anon_sym_sizeof] = ACTIONS(875),
    [anon_sym___alignof__] = ACTIONS(878),
    [anon_sym___alignof] = ACTIONS(878),
    [anon_sym__alignof] = ACTIONS(878),
    [anon_sym_alignof] = ACTIONS(878),
    [anon_sym__Alignof] = ACTIONS(878),
    [anon_sym_offsetof] = ACTIONS(881),
    [anon_sym__Generic] = ACTIONS(884),
    [anon_sym_asm] = ACTIONS(887),
    [anon_sym___asm__] = ACTIONS(887),
    [sym_number_literal] = ACTIONS(890),
    [anon_sym_L_SQUOTE] = ACTIONS(893),
    [anon_sym_u_SQUOTE] = ACTIONS(893),
    [anon_sym_U_SQUOTE] = ACTIONS(893),
    [anon_sym_u8_SQUOTE] = ACTIONS(893),
    [anon_sym_SQUOTE] = ACTIONS(893),
    [anon_sym_L_DQUOTE] = ACTIONS(896),
    [anon_sym_u_DQUOTE] = ACTIONS(896),
    [anon_sym_U_DQUOTE] = ACTIONS(896),
    [anon_sym_u8_DQUOTE] = ACTIONS(896),
    [anon_sym_DQUOTE] = ACTIONS(896),
    [sym_true] = ACTIONS(899),
    [sym_false] = ACTIONS(899),
    [anon_sym_NULL] = ACTIONS(902),
    [anon_sym_nullptr] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_declaration] = STATE(62),
    [sym_type_definition] = STATE(62),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(62),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(62),
    [sym_labeled_statement] = STATE(62),
    [sym_expression_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_switch_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_do_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_return_statement] = STATE(62),
    [sym_break_statement] = STATE(62),
    [sym_continue_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_seh_try_statement] = STATE(62),
    [sym_seh_leave_statement] = STATE(62),
    [sym__expression] = STATE(1080),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1898),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(62),
    [ts_builtin_sym_end] = ACTIONS(1023),
    [sym_identifier] = ACTIONS(911),
    [aux_sym_preproc_include_token1] = ACTIONS(776),
    [aux_sym_preproc_def_token1] = ACTIONS(776),
    [aux_sym_preproc_if_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(776),
    [sym_preproc_directive] = ACTIONS(776),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(776),
    [anon_sym___clrcall] = ACTIONS(776),
    [anon_sym___stdcall] = ACTIONS(776),
    [anon_sym___fastcall] = ACTIONS(776),
    [anon_sym___thiscall] = ACTIONS(776),
    [anon_sym___vectorcall] = ACTIONS(776),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(915),
    [anon_sym___leave] = ACTIONS(917),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym__expression] = STATE(1080),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1898),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [ts_builtin_sym_end] = ACTIONS(971),
    [sym_identifier] = ACTIONS(911),
    [aux_sym_preproc_include_token1] = ACTIONS(778),
    [aux_sym_preproc_def_token1] = ACTIONS(778),
    [aux_sym_preproc_if_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(778),
    [sym_preproc_directive] = ACTIONS(778),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(778),
    [anon_sym___clrcall] = ACTIONS(778),
    [anon_sym___stdcall] = ACTIONS(778),
    [anon_sym___fastcall] = ACTIONS(778),
    [anon_sym___thiscall] = ACTIONS(778),
    [anon_sym___vectorcall] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(778),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(778),
    [anon_sym_default] = ACTIONS(778),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(915),
    [anon_sym___leave] = ACTIONS(917),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym__expression] = STATE(1065),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1805),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(339),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(1021),
    [aux_sym_preproc_include_token1] = ACTIONS(907),
    [aux_sym_preproc_def_token1] = ACTIONS(907),
    [aux_sym_preproc_if_token1] = ACTIONS(907),
    [aux_sym_preproc_if_token2] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(907),
    [sym_preproc_directive] = ACTIONS(907),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym___extension__] = ACTIONS(417),
    [anon_sym_typedef] = ACTIONS(419),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(907),
    [anon_sym___clrcall] = ACTIONS(907),
    [anon_sym___stdcall] = ACTIONS(907),
    [anon_sym___fastcall] = ACTIONS(907),
    [anon_sym___thiscall] = ACTIONS(907),
    [anon_sym___vectorcall] = ACTIONS(907),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(907),
    [anon_sym_switch] = ACTIONS(427),
    [anon_sym_case] = ACTIONS(907),
    [anon_sym_default] = ACTIONS(907),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(443),
    [anon_sym_goto] = ACTIONS(445),
    [anon_sym___try] = ACTIONS(447),
    [anon_sym___leave] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_declaration] = STATE(50),
    [sym_type_definition] = STATE(50),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(50),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(50),
    [sym_labeled_statement] = STATE(50),
    [sym_expression_statement] = STATE(50),
    [sym_if_statement] = STATE(50),
    [sym_switch_statement] = STATE(50),
    [sym_while_statement] = STATE(50),
    [sym_do_statement] = STATE(50),
    [sym_for_statement] = STATE(50),
    [sym_return_statement] = STATE(50),
    [sym_break_statement] = STATE(50),
    [sym_continue_statement] = STATE(50),
    [sym_goto_statement] = STATE(50),
    [sym_seh_try_statement] = STATE(50),
    [sym_seh_leave_statement] = STATE(50),
    [sym__expression] = STATE(1080),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1898),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(50),
    [ts_builtin_sym_end] = ACTIONS(1025),
    [sym_identifier] = ACTIONS(911),
    [aux_sym_preproc_include_token1] = ACTIONS(907),
    [aux_sym_preproc_def_token1] = ACTIONS(907),
    [aux_sym_preproc_if_token1] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(907),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(907),
    [sym_preproc_directive] = ACTIONS(907),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(907),
    [anon_sym___clrcall] = ACTIONS(907),
    [anon_sym___stdcall] = ACTIONS(907),
    [anon_sym___fastcall] = ACTIONS(907),
    [anon_sym___thiscall] = ACTIONS(907),
    [anon_sym___vectorcall] = ACTIONS(907),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(907),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(907),
    [anon_sym_default] = ACTIONS(907),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(915),
    [anon_sym___leave] = ACTIONS(917),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_declaration] = STATE(67),
    [sym_type_definition] = STATE(67),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(67),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(67),
    [sym_labeled_statement] = STATE(67),
    [sym_expression_statement] = STATE(67),
    [sym_if_statement] = STATE(67),
    [sym_switch_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_do_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_return_statement] = STATE(67),
    [sym_break_statement] = STATE(67),
    [sym_continue_statement] = STATE(67),
    [sym_goto_statement] = STATE(67),
    [sym_seh_try_statement] = STATE(67),
    [sym_seh_leave_statement] = STATE(67),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(358),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(1075),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(1077),
    [anon_sym_else] = ACTIONS(905),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(1079),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(1081),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1083),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_declaration] = STATE(67),
    [sym_type_definition] = STATE(67),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(67),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(67),
    [sym_labeled_statement] = STATE(67),
    [sym_expression_statement] = STATE(67),
    [sym_if_statement] = STATE(67),
    [sym_switch_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_do_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_return_statement] = STATE(67),
    [sym_break_statement] = STATE(67),
    [sym_continue_statement] = STATE(67),
    [sym_goto_statement] = STATE(67),
    [sym_seh_try_statement] = STATE(67),
    [sym_seh_leave_statement] = STATE(67),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(358),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(1075),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(1077),
    [anon_sym_else] = ACTIONS(778),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(1079),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(1081),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1083),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_declaration] = STATE(67),
    [sym_type_definition] = STATE(67),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(67),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(67),
    [sym_labeled_statement] = STATE(67),
    [sym_expression_statement] = STATE(67),
    [sym_if_statement] = STATE(67),
    [sym_switch_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_do_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_return_statement] = STATE(67),
    [sym_break_statement] = STATE(67),
    [sym_continue_statement] = STATE(67),
    [sym_goto_statement] = STATE(67),
    [sym_seh_try_statement] = STATE(67),
    [sym_seh_leave_statement] = STATE(67),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(358),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(1085),
    [anon_sym_LPAREN2] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym_SEMI] = ACTIONS(922),
    [anon_sym___extension__] = ACTIONS(1033),
    [anon_sym_typedef] = ACTIONS(1036),
    [anon_sym_extern] = ACTIONS(806),
    [anon_sym___attribute__] = ACTIONS(809),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(812),
    [anon_sym___declspec] = ACTIONS(815),
    [anon_sym_LBRACE] = ACTIONS(1039),
    [anon_sym_signed] = ACTIONS(821),
    [anon_sym_unsigned] = ACTIONS(821),
    [anon_sym_long] = ACTIONS(821),
    [anon_sym_short] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_auto] = ACTIONS(806),
    [anon_sym_register] = ACTIONS(806),
    [anon_sym_inline] = ACTIONS(806),
    [anon_sym___inline] = ACTIONS(806),
    [anon_sym___inline__] = ACTIONS(806),
    [anon_sym___forceinline] = ACTIONS(806),
    [anon_sym_thread_local] = ACTIONS(806),
    [anon_sym___thread] = ACTIONS(806),
    [anon_sym_const] = ACTIONS(824),
    [anon_sym_constexpr] = ACTIONS(824),
    [anon_sym_volatile] = ACTIONS(824),
    [anon_sym_restrict] = ACTIONS(824),
    [anon_sym___restrict__] = ACTIONS(824),
    [anon_sym__Atomic] = ACTIONS(824),
    [anon_sym__Noreturn] = ACTIONS(824),
    [anon_sym_noreturn] = ACTIONS(824),
    [sym_primitive_type] = ACTIONS(827),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_struct] = ACTIONS(833),
    [anon_sym_union] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(1088),
    [anon_sym_else] = ACTIONS(783),
    [anon_sym_switch] = ACTIONS(1045),
    [anon_sym_while] = ACTIONS(1091),
    [anon_sym_do] = ACTIONS(1051),
    [anon_sym_for] = ACTIONS(1094),
    [anon_sym_return] = ACTIONS(1057),
    [anon_sym_break] = ACTIONS(1060),
    [anon_sym_continue] = ACTIONS(1063),
    [anon_sym_goto] = ACTIONS(1066),
    [anon_sym___try] = ACTIONS(1097),
    [anon_sym___leave] = ACTIONS(966),
    [anon_sym_DASH_DASH] = ACTIONS(872),
    [anon_sym_PLUS_PLUS] = ACTIONS(872),
    [anon_sym_sizeof] = ACTIONS(875),
    [anon_sym___alignof__] = ACTIONS(878),
    [anon_sym___alignof] = ACTIONS(878),
    [anon_sym__alignof] = ACTIONS(878),
    [anon_sym_alignof] = ACTIONS(878),
    [anon_sym__Alignof] = ACTIONS(878),
    [anon_sym_offsetof] = ACTIONS(881),
    [anon_sym__Generic] = ACTIONS(884),
    [anon_sym_asm] = ACTIONS(887),
    [anon_sym___asm__] = ACTIONS(887),
    [sym_number_literal] = ACTIONS(890),
    [anon_sym_L_SQUOTE] = ACTIONS(893),
    [anon_sym_u_SQUOTE] = ACTIONS(893),
    [anon_sym_U_SQUOTE] = ACTIONS(893),
    [anon_sym_u8_SQUOTE] = ACTIONS(893),
    [anon_sym_SQUOTE] = ACTIONS(893),
    [anon_sym_L_DQUOTE] = ACTIONS(896),
    [anon_sym_u_DQUOTE] = ACTIONS(896),
    [anon_sym_U_DQUOTE] = ACTIONS(896),
    [anon_sym_u8_DQUOTE] = ACTIONS(896),
    [anon_sym_DQUOTE] = ACTIONS(896),
    [sym_true] = ACTIONS(899),
    [sym_false] = ACTIONS(899),
    [anon_sym_NULL] = ACTIONS(902),
    [anon_sym_nullptr] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_declaration] = STATE(66),
    [sym_type_definition] = STATE(66),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(66),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(66),
    [sym_labeled_statement] = STATE(66),
    [sym_expression_statement] = STATE(66),
    [sym_if_statement] = STATE(66),
    [sym_switch_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_do_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_return_statement] = STATE(66),
    [sym_break_statement] = STATE(66),
    [sym_continue_statement] = STATE(66),
    [sym_goto_statement] = STATE(66),
    [sym_seh_try_statement] = STATE(66),
    [sym_seh_leave_statement] = STATE(66),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(358),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(1075),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(1077),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(1079),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(1081),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1083),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_declaration] = STATE(65),
    [sym_type_definition] = STATE(65),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1145),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(458),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_compound_statement] = STATE(65),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym_attributed_statement] = STATE(65),
    [sym_labeled_statement] = STATE(65),
    [sym_expression_statement] = STATE(65),
    [sym_if_statement] = STATE(65),
    [sym_switch_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_do_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_return_statement] = STATE(65),
    [sym_break_statement] = STATE(65),
    [sym_continue_statement] = STATE(65),
    [sym_goto_statement] = STATE(65),
    [sym_seh_try_statement] = STATE(65),
    [sym_seh_leave_statement] = STATE(65),
    [sym__expression] = STATE(1033),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_attributed_declarator_repeat1] = STATE(358),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [aux_sym_case_statement_repeat1] = STATE(65),
    [sym_identifier] = ACTIONS(1075),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(1077),
    [anon_sym_else] = ACTIONS(907),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(1079),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(1081),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1083),
    [anon_sym___leave] = ACTIONS(399),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_declaration] = STATE(505),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1147),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(749),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym__for_statement_body] = STATE(1886),
    [sym__expression] = STATE(1039),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1955),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(1100),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1102),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1104),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_declaration] = STATE(505),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1147),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(749),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym__for_statement_body] = STATE(1940),
    [sym__expression] = STATE(1039),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1955),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(1100),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1102),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1104),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_declaration] = STATE(505),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1147),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(749),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym__for_statement_body] = STATE(1951),
    [sym__expression] = STATE(1039),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1955),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(1100),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1102),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1104),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_declaration] = STATE(505),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1147),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(749),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym__for_statement_body] = STATE(1972),
    [sym__expression] = STATE(1039),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1955),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(1100),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1102),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1104),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_declaration] = STATE(505),
    [sym__declaration_modifiers] = STATE(749),
    [sym__declaration_specifiers] = STATE(1147),
    [sym_attribute_specifier] = STATE(749),
    [sym_attribute_declaration] = STATE(749),
    [sym_ms_declspec_modifier] = STATE(749),
    [sym_storage_class_specifier] = STATE(749),
    [sym_type_qualifier] = STATE(749),
    [sym__type_specifier] = STATE(795),
    [sym_sized_type_specifier] = STATE(821),
    [sym_enum_specifier] = STATE(821),
    [sym_struct_specifier] = STATE(821),
    [sym_union_specifier] = STATE(821),
    [sym__for_statement_body] = STATE(1882),
    [sym__expression] = STATE(1039),
    [sym__expression_not_binary] = STATE(700),
    [sym__string] = STATE(700),
    [sym_comma_expression] = STATE(1955),
    [sym_conditional_expression] = STATE(700),
    [sym_assignment_expression] = STATE(700),
    [sym_pointer_expression] = STATE(840),
    [sym_unary_expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_update_expression] = STATE(700),
    [sym_cast_expression] = STATE(700),
    [sym_sizeof_expression] = STATE(700),
    [sym_alignof_expression] = STATE(700),
    [sym_offsetof_expression] = STATE(700),
    [sym_generic_expression] = STATE(700),
    [sym_subscript_expression] = STATE(840),
    [sym_call_expression] = STATE(840),
    [sym_gnu_asm_expression] = STATE(700),
    [sym_field_expression] = STATE(840),
    [sym_compound_literal_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(840),
    [sym_char_literal] = STATE(700),
    [sym_concatenated_string] = STATE(700),
    [sym_string_literal] = STATE(683),
    [sym_null] = STATE(700),
    [sym_macro_type_specifier] = STATE(821),
    [aux_sym__declaration_specifiers_repeat1] = STATE(749),
    [aux_sym_sized_type_specifier_repeat1] = STATE(843),
    [sym_identifier] = ACTIONS(1100),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1102),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1104),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_else_clause] = STATE(87),
    [sym_identifier] = ACTIONS(1106),
    [aux_sym_preproc_include_token1] = ACTIONS(1106),
    [aux_sym_preproc_def_token1] = ACTIONS(1106),
    [aux_sym_preproc_if_token1] = ACTIONS(1106),
    [aux_sym_preproc_if_token2] = ACTIONS(1106),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1106),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1106),
    [aux_sym_preproc_else_token1] = ACTIONS(1106),
    [aux_sym_preproc_elif_token1] = ACTIONS(1106),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1106),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1106),
    [sym_preproc_directive] = ACTIONS(1106),
    [anon_sym_LPAREN2] = ACTIONS(1108),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1108),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_STAR] = ACTIONS(1108),
    [anon_sym_AMP] = ACTIONS(1108),
    [anon_sym_SEMI] = ACTIONS(1108),
    [anon_sym___extension__] = ACTIONS(1106),
    [anon_sym_typedef] = ACTIONS(1106),
    [anon_sym_extern] = ACTIONS(1106),
    [anon_sym___attribute__] = ACTIONS(1106),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1108),
    [anon_sym___declspec] = ACTIONS(1106),
    [anon_sym___cdecl] = ACTIONS(1106),
    [anon_sym___clrcall] = ACTIONS(1106),
    [anon_sym___stdcall] = ACTIONS(1106),
    [anon_sym___fastcall] = ACTIONS(1106),
    [anon_sym___thiscall] = ACTIONS(1106),
    [anon_sym___vectorcall] = ACTIONS(1106),
    [anon_sym_LBRACE] = ACTIONS(1108),
    [anon_sym_signed] = ACTIONS(1106),
    [anon_sym_unsigned] = ACTIONS(1106),
    [anon_sym_long] = ACTIONS(1106),
    [anon_sym_short] = ACTIONS(1106),
    [anon_sym_static] = ACTIONS(1106),
    [anon_sym_auto] = ACTIONS(1106),
    [anon_sym_register] = ACTIONS(1106),
    [anon_sym_inline] = ACTIONS(1106),
    [anon_sym___inline] = ACTIONS(1106),
    [anon_sym___inline__] = ACTIONS(1106),
    [anon_sym___forceinline] = ACTIONS(1106),
    [anon_sym_thread_local] = ACTIONS(1106),
    [anon_sym___thread] = ACTIONS(1106),
    [anon_sym_const] = ACTIONS(1106),
    [anon_sym_constexpr] = ACTIONS(1106),
    [anon_sym_volatile] = ACTIONS(1106),
    [anon_sym_restrict] = ACTIONS(1106),
    [anon_sym___restrict__] = ACTIONS(1106),
    [anon_sym__Atomic] = ACTIONS(1106),
    [anon_sym__Noreturn] = ACTIONS(1106),
    [anon_sym_noreturn] = ACTIONS(1106),
    [sym_primitive_type] = ACTIONS(1106),
    [anon_sym_enum] = ACTIONS(1106),
    [anon_sym_struct] = ACTIONS(1106),
    [anon_sym_union] = ACTIONS(1106),
    [anon_sym_if] = ACTIONS(1106),
    [anon_sym_else] = ACTIONS(1110),
    [anon_sym_switch] = ACTIONS(1106),
    [anon_sym_case] = ACTIONS(1106),
    [anon_sym_default] = ACTIONS(1106),
    [anon_sym_while] = ACTIONS(1106),
    [anon_sym_do] = ACTIONS(1106),
    [anon_sym_for] = ACTIONS(1106),
    [anon_sym_return] = ACTIONS(1106),
    [anon_sym_break] = ACTIONS(1106),
    [anon_sym_continue] = ACTIONS(1106),
    [anon_sym_goto] = ACTIONS(1106),
    [anon_sym___try] = ACTIONS(1106),
    [anon_sym___leave] = ACTIONS(1106),
    [anon_sym_DASH_DASH] = ACTIONS(1108),
    [anon_sym_PLUS_PLUS] = ACTIONS(1108),
    [anon_sym_sizeof] = ACTIONS(1106),
    [anon_sym___alignof__] = ACTIONS(1106),
    [anon_sym___alignof] = ACTIONS(1106),
    [anon_sym__alignof] = ACTIONS(1106),
    [anon_sym_alignof] = ACTIONS(1106),
    [anon_sym__Alignof] = ACTIONS(1106),
    [anon_sym_offsetof] = ACTIONS(1106),
    [anon_sym__Generic] = ACTIONS(1106),
    [anon_sym_asm] = ACTIONS(1106),
    [anon_sym___asm__] = ACTIONS(1106),
    [sym_number_literal] = ACTIONS(1108),
    [anon_sym_L_SQUOTE] = ACTIONS(1108),
    [anon_sym_u_SQUOTE] = ACTIONS(1108),
    [anon_sym_U_SQUOTE] = ACTIONS(1108),
    [anon_sym_u8_SQUOTE] = ACTIONS(1108),
    [anon_sym_SQUOTE] = ACTIONS(1108),
    [anon_sym_L_DQUOTE] = ACTIONS(1108),
    [anon_sym_u_DQUOTE] = ACTIONS(1108),
    [anon_sym_U_DQUOTE] = ACTIONS(1108),
    [anon_sym_u8_DQUOTE] = ACTIONS(1108),
    [anon_sym_DQUOTE] = ACTIONS(1108),
    [sym_true] = ACTIONS(1106),
    [sym_false] = ACTIONS(1106),
    [anon_sym_NULL] = ACTIONS(1106),
    [anon_sym_nullptr] = ACTIONS(1106),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_identifier] = ACTIONS(1112),
    [aux_sym_preproc_include_token1] = ACTIONS(1112),
    [aux_sym_preproc_def_token1] = ACTIONS(1112),
    [aux_sym_preproc_if_token1] = ACTIONS(1112),
    [aux_sym_preproc_if_token2] = ACTIONS(1112),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1112),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1112),
    [aux_sym_preproc_else_token1] = ACTIONS(1112),
    [aux_sym_preproc_elif_token1] = ACTIONS(1112),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1112),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1112),
    [sym_preproc_directive] = ACTIONS(1112),
    [anon_sym_LPAREN2] = ACTIONS(1114),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_TILDE] = ACTIONS(1114),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1114),
    [anon_sym_AMP] = ACTIONS(1114),
    [anon_sym_SEMI] = ACTIONS(1114),
    [anon_sym___extension__] = ACTIONS(1112),
    [anon_sym_typedef] = ACTIONS(1112),
    [anon_sym_extern] = ACTIONS(1112),
    [anon_sym___attribute__] = ACTIONS(1112),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1114),
    [anon_sym___declspec] = ACTIONS(1112),
    [anon_sym___cdecl] = ACTIONS(1112),
    [anon_sym___clrcall] = ACTIONS(1112),
    [anon_sym___stdcall] = ACTIONS(1112),
    [anon_sym___fastcall] = ACTIONS(1112),
    [anon_sym___thiscall] = ACTIONS(1112),
    [anon_sym___vectorcall] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1114),
    [anon_sym_signed] = ACTIONS(1112),
    [anon_sym_unsigned] = ACTIONS(1112),
    [anon_sym_long] = ACTIONS(1112),
    [anon_sym_short] = ACTIONS(1112),
    [anon_sym_static] = ACTIONS(1112),
    [anon_sym_auto] = ACTIONS(1112),
    [anon_sym_register] = ACTIONS(1112),
    [anon_sym_inline] = ACTIONS(1112),
    [anon_sym___inline] = ACTIONS(1112),
    [anon_sym___inline__] = ACTIONS(1112),
    [anon_sym___forceinline] = ACTIONS(1112),
    [anon_sym_thread_local] = ACTIONS(1112),
    [anon_sym___thread] = ACTIONS(1112),
    [anon_sym_const] = ACTIONS(1112),
    [anon_sym_constexpr] = ACTIONS(1112),
    [anon_sym_volatile] = ACTIONS(1112),
    [anon_sym_restrict] = ACTIONS(1112),
    [anon_sym___restrict__] = ACTIONS(1112),
    [anon_sym__Atomic] = ACTIONS(1112),
    [anon_sym__Noreturn] = ACTIONS(1112),
    [anon_sym_noreturn] = ACTIONS(1112),
    [sym_primitive_type] = ACTIONS(1112),
    [anon_sym_enum] = ACTIONS(1112),
    [anon_sym_struct] = ACTIONS(1112),
    [anon_sym_union] = ACTIONS(1112),
    [anon_sym_if] = ACTIONS(1112),
    [anon_sym_else] = ACTIONS(1112),
    [anon_sym_switch] = ACTIONS(1112),
    [anon_sym_case] = ACTIONS(1112),
    [anon_sym_default] = ACTIONS(1112),
    [anon_sym_while] = ACTIONS(1112),
    [anon_sym_do] = ACTIONS(1112),
    [anon_sym_for] = ACTIONS(1112),
    [anon_sym_return] = ACTIONS(1112),
    [anon_sym_break] = ACTIONS(1112),
    [anon_sym_continue] = ACTIONS(1112),
    [anon_sym_goto] = ACTIONS(1112),
    [anon_sym___try] = ACTIONS(1112),
    [anon_sym___leave] = ACTIONS(1112),
    [anon_sym_DASH_DASH] = ACTIONS(1114),
    [anon_sym_PLUS_PLUS] = ACTIONS(1114),
    [anon_sym_sizeof] = ACTIONS(1112),
    [anon_sym___alignof__] = ACTIONS(1112),
    [anon_sym___alignof] = ACTIONS(1112),
    [anon_sym__alignof] = ACTIONS(1112),
    [anon_sym_alignof] = ACTIONS(1112),
    [anon_sym__Alignof] = ACTIONS(1112),
    [anon_sym_offsetof] = ACTIONS(1112),
    [anon_sym__Generic] = ACTIONS(1112),
    [anon_sym_asm] = ACTIONS(1112),
    [anon_sym___asm__] = ACTIONS(1112),
    [sym_number_literal] = ACTIONS(1114),
    [anon_sym_L_SQUOTE] = ACTIONS(1114),
    [anon_sym_u_SQUOTE] = ACTIONS(1114),
    [anon_sym_U_SQUOTE] = ACTIONS(1114),
    [anon_sym_u8_SQUOTE] = ACTIONS(1114),
    [anon_sym_SQUOTE] = ACTIONS(1114),
    [anon_sym_L_DQUOTE] = ACTIONS(1114),
    [anon_sym_u_DQUOTE] = ACTIONS(1114),
    [anon_sym_U_DQUOTE] = ACTIONS(1114),
    [anon_sym_u8_DQUOTE] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1114),
    [sym_true] = ACTIONS(1112),
    [sym_false] = ACTIONS(1112),
    [anon_sym_NULL] = ACTIONS(1112),
    [anon_sym_nullptr] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_identifier] = ACTIONS(1120),
    [aux_sym_preproc_include_token1] = ACTIONS(1120),
    [aux_sym_preproc_def_token1] = ACTIONS(1120),
    [aux_sym_preproc_if_token1] = ACTIONS(1120),
    [aux_sym_preproc_if_token2] = ACTIONS(1120),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1120),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1120),
    [aux_sym_preproc_else_token1] = ACTIONS(1120),
    [aux_sym_preproc_elif_token1] = ACTIONS(1120),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1120),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1120),
    [sym_preproc_directive] = ACTIONS(1120),
    [anon_sym_LPAREN2] = ACTIONS(1122),
    [anon_sym_BANG] = ACTIONS(1122),
    [anon_sym_TILDE] = ACTIONS(1122),
    [anon_sym_DASH] = ACTIONS(1120),
    [anon_sym_PLUS] = ACTIONS(1120),
    [anon_sym_STAR] = ACTIONS(1122),
    [anon_sym_AMP] = ACTIONS(1122),
    [anon_sym_SEMI] = ACTIONS(1122),
    [anon_sym___extension__] = ACTIONS(1120),
    [anon_sym_typedef] = ACTIONS(1120),
    [anon_sym_extern] = ACTIONS(1120),
    [anon_sym___attribute__] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym___declspec] = ACTIONS(1120),
    [anon_sym___cdecl] = ACTIONS(1120),
    [anon_sym___clrcall] = ACTIONS(1120),
    [anon_sym___stdcall] = ACTIONS(1120),
    [anon_sym___fastcall] = ACTIONS(1120),
    [anon_sym___thiscall] = ACTIONS(1120),
    [anon_sym___vectorcall] = ACTIONS(1120),
    [anon_sym_LBRACE] = ACTIONS(1122),
    [anon_sym_signed] = ACTIONS(1120),
    [anon_sym_unsigned] = ACTIONS(1120),
    [anon_sym_long] = ACTIONS(1120),
    [anon_sym_short] = ACTIONS(1120),
    [anon_sym_static] = ACTIONS(1120),
    [anon_sym_auto] = ACTIONS(1120),
    [anon_sym_register] = ACTIONS(1120),
    [anon_sym_inline] = ACTIONS(1120),
    [anon_sym___inline] = ACTIONS(1120),
    [anon_sym___inline__] = ACTIONS(1120),
    [anon_sym___forceinline] = ACTIONS(1120),
    [anon_sym_thread_local] = ACTIONS(1120),
    [anon_sym___thread] = ACTIONS(1120),
    [anon_sym_const] = ACTIONS(1120),
    [anon_sym_constexpr] = ACTIONS(1120),
    [anon_sym_volatile] = ACTIONS(1120),
    [anon_sym_restrict] = ACTIONS(1120),
    [anon_sym___restrict__] = ACTIONS(1120),
    [anon_sym__Atomic] = ACTIONS(1120),
    [anon_sym__Noreturn] = ACTIONS(1120),
    [anon_sym_noreturn] = ACTIONS(1120),
    [sym_primitive_type] = ACTIONS(1120),
    [anon_sym_enum] = ACTIONS(1120),
    [anon_sym_struct] = ACTIONS(1120),
    [anon_sym_union] = ACTIONS(1120),
    [anon_sym_if] = ACTIONS(1120),
    [anon_sym_else] = ACTIONS(1120),
    [anon_sym_switch] = ACTIONS(1120),
    [anon_sym_case] = ACTIONS(1120),
    [anon_sym_default] = ACTIONS(1120),
    [anon_sym_while] = ACTIONS(1120),
    [anon_sym_do] = ACTIONS(1120),
    [anon_sym_for] = ACTIONS(1120),
    [anon_sym_return] = ACTIONS(1120),
    [anon_sym_break] = ACTIONS(1120),
    [anon_sym_continue] = ACTIONS(1120),
    [anon_sym_goto] = ACTIONS(1120),
    [anon_sym___try] = ACTIONS(1120),
    [anon_sym___leave] = ACTIONS(1120),
    [anon_sym_DASH_DASH] = ACTIONS(1122),
    [anon_sym_PLUS_PLUS] = ACTIONS(1122),
    [anon_sym_sizeof] = ACTIONS(1120),
    [anon_sym___alignof__] = ACTIONS(1120),
    [anon_sym___alignof] = ACTIONS(1120),
    [anon_sym__alignof] = ACTIONS(1120),
    [anon_sym_alignof] = ACTIONS(1120),
    [anon_sym__Alignof] = ACTIONS(1120),
    [anon_sym_offsetof] = ACTIONS(1120),
    [anon_sym__Generic] = ACTIONS(1120),
    [anon_sym_asm] = ACTIONS(1120),
    [anon_sym___asm__] = ACTIONS(1120),
    [sym_number_literal] = ACTIONS(1122),
    [anon_sym_L_SQUOTE] = ACTIONS(1122),
    [anon_sym_u_SQUOTE] = ACTIONS(1122),
    [anon_sym_U_SQUOTE] = ACTIONS(1122),
    [anon_sym_u8_SQUOTE] = ACTIONS(1122),
    [anon_sym_SQUOTE] = ACTIONS(1122),
    [anon_sym_L_DQUOTE] = ACTIONS(1122),
    [anon_sym_u_DQUOTE] = ACTIONS(1122),
    [anon_sym_U_DQUOTE] = ACTIONS(1122),
    [anon_sym_u8_DQUOTE] = ACTIONS(1122),
    [anon_sym_DQUOTE] = ACTIONS(1122),
    [sym_true] = ACTIONS(1120),
    [sym_false] = ACTIONS(1120),
    [anon_sym_NULL] = ACTIONS(1120),
    [anon_sym_nullptr] = ACTIONS(1120),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_identifier] = ACTIONS(1124),
    [aux_sym_preproc_include_token1] = ACTIONS(1124),
    [aux_sym_preproc_def_token1] = ACTIONS(1124),
    [aux_sym_preproc_if_token1] = ACTIONS(1124),
    [aux_sym_preproc_if_token2] = ACTIONS(1124),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1124),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1124),
    [aux_sym_preproc_else_token1] = ACTIONS(1124),
    [aux_sym_preproc_elif_token1] = ACTIONS(1124),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1124),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1124),
    [sym_preproc_directive] = ACTIONS(1124),
    [anon_sym_LPAREN2] = ACTIONS(1126),
    [anon_sym_BANG] = ACTIONS(1126),
    [anon_sym_TILDE] = ACTIONS(1126),
    [anon_sym_DASH] = ACTIONS(1124),
    [anon_sym_PLUS] = ACTIONS(1124),
    [anon_sym_STAR] = ACTIONS(1126),
    [anon_sym_AMP] = ACTIONS(1126),
    [anon_sym_SEMI] = ACTIONS(1126),
    [anon_sym___extension__] = ACTIONS(1124),
    [anon_sym_typedef] = ACTIONS(1124),
    [anon_sym_extern] = ACTIONS(1124),
    [anon_sym___attribute__] = ACTIONS(1124),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1126),
    [anon_sym___declspec] = ACTIONS(1124),
    [anon_sym___cdecl] = ACTIONS(1124),
    [anon_sym___clrcall] = ACTIONS(1124),
    [anon_sym___stdcall] = ACTIONS(1124),
    [anon_sym___fastcall] = ACTIONS(1124),
    [anon_sym___thiscall] = ACTIONS(1124),
    [anon_sym___vectorcall] = ACTIONS(1124),
    [anon_sym_LBRACE] = ACTIONS(1126),
    [anon_sym_signed] = ACTIONS(1124),
    [anon_sym_unsigned] = ACTIONS(1124),
    [anon_sym_long] = ACTIONS(1124),
    [anon_sym_short] = ACTIONS(1124),
    [anon_sym_static] = ACTIONS(1124),
    [anon_sym_auto] = ACTIONS(1124),
    [anon_sym_register] = ACTIONS(1124),
    [anon_sym_inline] = ACTIONS(1124),
    [anon_sym___inline] = ACTIONS(1124),
    [anon_sym___inline__] = ACTIONS(1124),
    [anon_sym___forceinline] = ACTIONS(1124),
    [anon_sym_thread_local] = ACTIONS(1124),
    [anon_sym___thread] = ACTIONS(1124),
    [anon_sym_const] = ACTIONS(1124),
    [anon_sym_constexpr] = ACTIONS(1124),
    [anon_sym_volatile] = ACTIONS(1124),
    [anon_sym_restrict] = ACTIONS(1124),
    [anon_sym___restrict__] = ACTIONS(1124),
    [anon_sym__Atomic] = ACTIONS(1124),
    [anon_sym__Noreturn] = ACTIONS(1124),
    [anon_sym_noreturn] = ACTIONS(1124),
    [sym_primitive_type] = ACTIONS(1124),
    [anon_sym_enum] = ACTIONS(1124),
    [anon_sym_struct] = ACTIONS(1124),
    [anon_sym_union] = ACTIONS(1124),
    [anon_sym_if] = ACTIONS(1124),
    [anon_sym_else] = ACTIONS(1124),
    [anon_sym_switch] = ACTIONS(1124),
    [anon_sym_case] = ACTIONS(1124),
    [anon_sym_default] = ACTIONS(1124),
    [anon_sym_while] = ACTIONS(1124),
    [anon_sym_do] = ACTIONS(1124),
    [anon_sym_for] = ACTIONS(1124),
    [anon_sym_return] = ACTIONS(1124),
    [anon_sym_break] = ACTIONS(1124),
    [anon_sym_continue] = ACTIONS(1124),
    [anon_sym_goto] = ACTIONS(1124),
    [anon_sym___try] = ACTIONS(1124),
    [anon_sym___leave] = ACTIONS(1124),
    [anon_sym_DASH_DASH] = ACTIONS(1126),
    [anon_sym_PLUS_PLUS] = ACTIONS(1126),
    [anon_sym_sizeof] = ACTIONS(1124),
    [anon_sym___alignof__] = ACTIONS(1124),
    [anon_sym___alignof] = ACTIONS(1124),
    [anon_sym__alignof] = ACTIONS(1124),
    [anon_sym_alignof] = ACTIONS(1124),
    [anon_sym__Alignof] = ACTIONS(1124),
    [anon_sym_offsetof] = ACTIONS(1124),
    [anon_sym__Generic] = ACTIONS(1124),
    [anon_sym_asm] = ACTIONS(1124),
    [anon_sym___asm__] = ACTIONS(1124),
    [sym_number_literal] = ACTIONS(1126),
    [anon_sym_L_SQUOTE] = ACTIONS(1126),
    [anon_sym_u_SQUOTE] = ACTIONS(1126),
    [anon_sym_U_SQUOTE] = ACTIONS(1126),
    [anon_sym_u8_SQUOTE] = ACTIONS(1126),
    [anon_sym_SQUOTE] = ACTIONS(1126),
    [anon_sym_L_DQUOTE] = ACTIONS(1126),
    [anon_sym_u_DQUOTE] = ACTIONS(1126),
    [anon_sym_U_DQUOTE] = ACTIONS(1126),
    [anon_sym_u8_DQUOTE] = ACTIONS(1126),
    [anon_sym_DQUOTE] = ACTIONS(1126),
    [sym_true] = ACTIONS(1124),
    [sym_false] = ACTIONS(1124),
    [anon_sym_NULL] = ACTIONS(1124),
    [anon_sym_nullptr] = ACTIONS(1124),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_identifier] = ACTIONS(1128),
    [aux_sym_preproc_include_token1] = ACTIONS(1128),
    [aux_sym_preproc_def_token1] = ACTIONS(1128),
    [aux_sym_preproc_if_token1] = ACTIONS(1128),
    [aux_sym_preproc_if_token2] = ACTIONS(1128),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1128),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1128),
    [aux_sym_preproc_else_token1] = ACTIONS(1128),
    [aux_sym_preproc_elif_token1] = ACTIONS(1128),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1128),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1128),
    [sym_preproc_directive] = ACTIONS(1128),
    [anon_sym_LPAREN2] = ACTIONS(1130),
    [anon_sym_BANG] = ACTIONS(1130),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_STAR] = ACTIONS(1130),
    [anon_sym_AMP] = ACTIONS(1130),
    [anon_sym_SEMI] = ACTIONS(1130),
    [anon_sym___extension__] = ACTIONS(1128),
    [anon_sym_typedef] = ACTIONS(1128),
    [anon_sym_extern] = ACTIONS(1128),
    [anon_sym___attribute__] = ACTIONS(1128),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1130),
    [anon_sym___declspec] = ACTIONS(1128),
    [anon_sym___cdecl] = ACTIONS(1128),
    [anon_sym___clrcall] = ACTIONS(1128),
    [anon_sym___stdcall] = ACTIONS(1128),
    [anon_sym___fastcall] = ACTIONS(1128),
    [anon_sym___thiscall] = ACTIONS(1128),
    [anon_sym___vectorcall] = ACTIONS(1128),
    [anon_sym_LBRACE] = ACTIONS(1130),
    [anon_sym_signed] = ACTIONS(1128),
    [anon_sym_unsigned] = ACTIONS(1128),
    [anon_sym_long] = ACTIONS(1128),
    [anon_sym_short] = ACTIONS(1128),
    [anon_sym_static] = ACTIONS(1128),
    [anon_sym_auto] = ACTIONS(1128),
    [anon_sym_register] = ACTIONS(1128),
    [anon_sym_inline] = ACTIONS(1128),
    [anon_sym___inline] = ACTIONS(1128),
    [anon_sym___inline__] = ACTIONS(1128),
    [anon_sym___forceinline] = ACTIONS(1128),
    [anon_sym_thread_local] = ACTIONS(1128),
    [anon_sym___thread] = ACTIONS(1128),
    [anon_sym_const] = ACTIONS(1128),
    [anon_sym_constexpr] = ACTIONS(1128),
    [anon_sym_volatile] = ACTIONS(1128),
    [anon_sym_restrict] = ACTIONS(1128),
    [anon_sym___restrict__] = ACTIONS(1128),
    [anon_sym__Atomic] = ACTIONS(1128),
    [anon_sym__Noreturn] = ACTIONS(1128),
    [anon_sym_noreturn] = ACTIONS(1128),
    [sym_primitive_type] = ACTIONS(1128),
    [anon_sym_enum] = ACTIONS(1128),
    [anon_sym_struct] = ACTIONS(1128),
    [anon_sym_union] = ACTIONS(1128),
    [anon_sym_if] = ACTIONS(1128),
    [anon_sym_else] = ACTIONS(1128),
    [anon_sym_switch] = ACTIONS(1128),
    [anon_sym_case] = ACTIONS(1128),
    [anon_sym_default] = ACTIONS(1128),
    [anon_sym_while] = ACTIONS(1128),
    [anon_sym_do] = ACTIONS(1128),
    [anon_sym_for] = ACTIONS(1128),
    [anon_sym_return] = ACTIONS(1128),
    [anon_sym_break] = ACTIONS(1128),
    [anon_sym_continue] = ACTIONS(1128),
    [anon_sym_goto] = ACTIONS(1128),
    [anon_sym___try] = ACTIONS(1128),
    [anon_sym___leave] = ACTIONS(1128),
    [anon_sym_DASH_DASH] = ACTIONS(1130),
    [anon_sym_PLUS_PLUS] = ACTIONS(1130),
    [anon_sym_sizeof] = ACTIONS(1128),
    [anon_sym___alignof__] = ACTIONS(1128),
    [anon_sym___alignof] = ACTIONS(1128),
    [anon_sym__alignof] = ACTIONS(1128),
    [anon_sym_alignof] = ACTIONS(1128),
    [anon_sym__Alignof] = ACTIONS(1128),
    [anon_sym_offsetof] = ACTIONS(1128),
    [anon_sym__Generic] = ACTIONS(1128),
    [anon_sym_asm] = ACTIONS(1128),
    [anon_sym___asm__] = ACTIONS(1128),
    [sym_number_literal] = ACTIONS(1130),
    [anon_sym_L_SQUOTE] = ACTIONS(1130),
    [anon_sym_u_SQUOTE] = ACTIONS(1130),
    [anon_sym_U_SQUOTE] = ACTIONS(1130),
    [anon_sym_u8_SQUOTE] = ACTIONS(1130),
    [anon_sym_SQUOTE] = ACTIONS(1130),
    [anon_sym_L_DQUOTE] = ACTIONS(1130),
    [anon_sym_u_DQUOTE] = ACTIONS(1130),
    [anon_sym_U_DQUOTE] = ACTIONS(1130),
    [anon_sym_u8_DQUOTE] = ACTIONS(1130),
    [anon_sym_DQUOTE] = ACTIONS(1130),
    [sym_true] = ACTIONS(1128),
    [sym_false] = ACTIONS(1128),
    [anon_sym_NULL] = ACTIONS(1128),
    [anon_sym_nullptr] = ACTIONS(1128),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_identifier] = ACTIONS(1132),
    [aux_sym_preproc_include_token1] = ACTIONS(1132),
    [aux_sym_preproc_def_token1] = ACTIONS(1132),
    [aux_sym_preproc_if_token1] = ACTIONS(1132),
    [aux_sym_preproc_if_token2] = ACTIONS(1132),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1132),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1132),
    [aux_sym_preproc_else_token1] = ACTIONS(1132),
    [aux_sym_preproc_elif_token1] = ACTIONS(1132),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1132),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1132),
    [sym_preproc_directive] = ACTIONS(1132),
    [anon_sym_LPAREN2] = ACTIONS(1134),
    [anon_sym_BANG] = ACTIONS(1134),
    [anon_sym_TILDE] = ACTIONS(1134),
    [anon_sym_DASH] = ACTIONS(1132),
    [anon_sym_PLUS] = ACTIONS(1132),
    [anon_sym_STAR] = ACTIONS(1134),
    [anon_sym_AMP] = ACTIONS(1134),
    [anon_sym_SEMI] = ACTIONS(1134),
    [anon_sym___extension__] = ACTIONS(1132),
    [anon_sym_typedef] = ACTIONS(1132),
    [anon_sym_extern] = ACTIONS(1132),
    [anon_sym___attribute__] = ACTIONS(1132),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1134),
    [anon_sym___declspec] = ACTIONS(1132),
    [anon_sym___cdecl] = ACTIONS(1132),
    [anon_sym___clrcall] = ACTIONS(1132),
    [anon_sym___stdcall] = ACTIONS(1132),
    [anon_sym___fastcall] = ACTIONS(1132),
    [anon_sym___thiscall] = ACTIONS(1132),
    [anon_sym___vectorcall] = ACTIONS(1132),
    [anon_sym_LBRACE] = ACTIONS(1134),
    [anon_sym_signed] = ACTIONS(1132),
    [anon_sym_unsigned] = ACTIONS(1132),
    [anon_sym_long] = ACTIONS(1132),
    [anon_sym_short] = ACTIONS(1132),
    [anon_sym_static] = ACTIONS(1132),
    [anon_sym_auto] = ACTIONS(1132),
    [anon_sym_register] = ACTIONS(1132),
    [anon_sym_inline] = ACTIONS(1132),
    [anon_sym___inline] = ACTIONS(1132),
    [anon_sym___inline__] = ACTIONS(1132),
    [anon_sym___forceinline] = ACTIONS(1132),
    [anon_sym_thread_local] = ACTIONS(1132),
    [anon_sym___thread] = ACTIONS(1132),
    [anon_sym_const] = ACTIONS(1132),
    [anon_sym_constexpr] = ACTIONS(1132),
    [anon_sym_volatile] = ACTIONS(1132),
    [anon_sym_restrict] = ACTIONS(1132),
    [anon_sym___restrict__] = ACTIONS(1132),
    [anon_sym__Atomic] = ACTIONS(1132),
    [anon_sym__Noreturn] = ACTIONS(1132),
    [anon_sym_noreturn] = ACTIONS(1132),
    [sym_primitive_type] = ACTIONS(1132),
    [anon_sym_enum] = ACTIONS(1132),
    [anon_sym_struct] = ACTIONS(1132),
    [anon_sym_union] = ACTIONS(1132),
    [anon_sym_if] = ACTIONS(1132),
    [anon_sym_else] = ACTIONS(1132),
    [anon_sym_switch] = ACTIONS(1132),
    [anon_sym_case] = ACTIONS(1132),
    [anon_sym_default] = ACTIONS(1132),
    [anon_sym_while] = ACTIONS(1132),
    [anon_sym_do] = ACTIONS(1132),
    [anon_sym_for] = ACTIONS(1132),
    [anon_sym_return] = ACTIONS(1132),
    [anon_sym_break] = ACTIONS(1132),
    [anon_sym_continue] = ACTIONS(1132),
    [anon_sym_goto] = ACTIONS(1132),
    [anon_sym___try] = ACTIONS(1132),
    [anon_sym___leave] = ACTIONS(1132),
    [anon_sym_DASH_DASH] = ACTIONS(1134),
    [anon_sym_PLUS_PLUS] = ACTIONS(1134),
    [anon_sym_sizeof] = ACTIONS(1132),
    [anon_sym___alignof__] = ACTIONS(1132),
    [anon_sym___alignof] = ACTIONS(1132),
    [anon_sym__alignof] = ACTIONS(1132),
    [anon_sym_alignof] = ACTIONS(1132),
    [anon_sym__Alignof] = ACTIONS(1132),
    [anon_sym_offsetof] = ACTIONS(1132),
    [anon_sym__Generic] = ACTIONS(1132),
    [anon_sym_asm] = ACTIONS(1132),
    [anon_sym___asm__] = ACTIONS(1132),
    [sym_number_literal] = ACTIONS(1134),
    [anon_sym_L_SQUOTE] = ACTIONS(1134),
    [anon_sym_u_SQUOTE] = ACTIONS(1134),
    [anon_sym_U_SQUOTE] = ACTIONS(1134),
    [anon_sym_u8_SQUOTE] = ACTIONS(1134),
    [anon_sym_SQUOTE] = ACTIONS(1134),
    [anon_sym_L_DQUOTE] = ACTIONS(1134),
    [anon_sym_u_DQUOTE] = ACTIONS(1134),
    [anon_sym_U_DQUOTE] = ACTIONS(1134),
    [anon_sym_u8_DQUOTE] = ACTIONS(1134),
    [anon_sym_DQUOTE] = ACTIONS(1134),
    [sym_true] = ACTIONS(1132),
    [sym_false] = ACTIONS(1132),
    [anon_sym_NULL] = ACTIONS(1132),
    [anon_sym_nullptr] = ACTIONS(1132),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_identifier] = ACTIONS(1136),
    [aux_sym_preproc_include_token1] = ACTIONS(1136),
    [aux_sym_preproc_def_token1] = ACTIONS(1136),
    [aux_sym_preproc_if_token1] = ACTIONS(1136),
    [aux_sym_preproc_if_token2] = ACTIONS(1136),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1136),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1136),
    [aux_sym_preproc_else_token1] = ACTIONS(1136),
    [aux_sym_preproc_elif_token1] = ACTIONS(1136),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1136),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1136),
    [sym_preproc_directive] = ACTIONS(1136),
    [anon_sym_LPAREN2] = ACTIONS(1138),
    [anon_sym_BANG] = ACTIONS(1138),
    [anon_sym_TILDE] = ACTIONS(1138),
    [anon_sym_DASH] = ACTIONS(1136),
    [anon_sym_PLUS] = ACTIONS(1136),
    [anon_sym_STAR] = ACTIONS(1138),
    [anon_sym_AMP] = ACTIONS(1138),
    [anon_sym_SEMI] = ACTIONS(1138),
    [anon_sym___extension__] = ACTIONS(1136),
    [anon_sym_typedef] = ACTIONS(1136),
    [anon_sym_extern] = ACTIONS(1136),
    [anon_sym___attribute__] = ACTIONS(1136),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1138),
    [anon_sym___declspec] = ACTIONS(1136),
    [anon_sym___cdecl] = ACTIONS(1136),
    [anon_sym___clrcall] = ACTIONS(1136),
    [anon_sym___stdcall] = ACTIONS(1136),
    [anon_sym___fastcall] = ACTIONS(1136),
    [anon_sym___thiscall] = ACTIONS(1136),
    [anon_sym___vectorcall] = ACTIONS(1136),
    [anon_sym_LBRACE] = ACTIONS(1138),
    [anon_sym_signed] = ACTIONS(1136),
    [anon_sym_unsigned] = ACTIONS(1136),
    [anon_sym_long] = ACTIONS(1136),
    [anon_sym_short] = ACTIONS(1136),
    [anon_sym_static] = ACTIONS(1136),
    [anon_sym_auto] = ACTIONS(1136),
    [anon_sym_register] = ACTIONS(1136),
    [anon_sym_inline] = ACTIONS(1136),
    [anon_sym___inline] = ACTIONS(1136),
    [anon_sym___inline__] = ACTIONS(1136),
    [anon_sym___forceinline] = ACTIONS(1136),
    [anon_sym_thread_local] = ACTIONS(1136),
    [anon_sym___thread] = ACTIONS(1136),
    [anon_sym_const] = ACTIONS(1136),
    [anon_sym_constexpr] = ACTIONS(1136),
    [anon_sym_volatile] = ACTIONS(1136),
    [anon_sym_restrict] = ACTIONS(1136),
    [anon_sym___restrict__] = ACTIONS(1136),
    [anon_sym__Atomic] = ACTIONS(1136),
    [anon_sym__Noreturn] = ACTIONS(1136),
    [anon_sym_noreturn] = ACTIONS(1136),
    [sym_primitive_type] = ACTIONS(1136),
    [anon_sym_enum] = ACTIONS(1136),
    [anon_sym_struct] = ACTIONS(1136),
    [anon_sym_union] = ACTIONS(1136),
    [anon_sym_if] = ACTIONS(1136),
    [anon_sym_else] = ACTIONS(1136),
    [anon_sym_switch] = ACTIONS(1136),
    [anon_sym_case] = ACTIONS(1136),
    [anon_sym_default] = ACTIONS(1136),
    [anon_sym_while] = ACTIONS(1136),
    [anon_sym_do] = ACTIONS(1136),
    [anon_sym_for] = ACTIONS(1136),
    [anon_sym_return] = ACTIONS(1136),
    [anon_sym_break] = ACTIONS(1136),
    [anon_sym_continue] = ACTIONS(1136),
    [anon_sym_goto] = ACTIONS(1136),
    [anon_sym___try] = ACTIONS(1136),
    [anon_sym___leave] = ACTIONS(1136),
    [anon_sym_DASH_DASH] = ACTIONS(1138),
    [anon_sym_PLUS_PLUS] = ACTIONS(1138),
    [anon_sym_sizeof] = ACTIONS(1136),
    [anon_sym___alignof__] = ACTIONS(1136),
    [anon_sym___alignof] = ACTIONS(1136),
    [anon_sym__alignof] = ACTIONS(1136),
    [anon_sym_alignof] = ACTIONS(1136),
    [anon_sym__Alignof] = ACTIONS(1136),
    [anon_sym_offsetof] = ACTIONS(1136),
    [anon_sym__Generic] = ACTIONS(1136),
    [anon_sym_asm] = ACTIONS(1136),
    [anon_sym___asm__] = ACTIONS(1136),
    [sym_number_literal] = ACTIONS(1138),
    [anon_sym_L_SQUOTE] = ACTIONS(1138),
    [anon_sym_u_SQUOTE] = ACTIONS(1138),
    [anon_sym_U_SQUOTE] = ACTIONS(1138),
    [anon_sym_u8_SQUOTE] = ACTIONS(1138),
    [anon_sym_SQUOTE] = ACTIONS(1138),
    [anon_sym_L_DQUOTE] = ACTIONS(1138),
    [anon_sym_u_DQUOTE] = ACTIONS(1138),
    [anon_sym_U_DQUOTE] = ACTIONS(1138),
    [anon_sym_u8_DQUOTE] = ACTIONS(1138),
    [anon_sym_DQUOTE] = ACTIONS(1138),
    [sym_true] = ACTIONS(1136),
    [sym_false] = ACTIONS(1136),
    [anon_sym_NULL] = ACTIONS(1136),
    [anon_sym_nullptr] = ACTIONS(1136),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_identifier] = ACTIONS(1140),
    [aux_sym_preproc_include_token1] = ACTIONS(1140),
    [aux_sym_preproc_def_token1] = ACTIONS(1140),
    [aux_sym_preproc_if_token1] = ACTIONS(1140),
    [aux_sym_preproc_if_token2] = ACTIONS(1140),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1140),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1140),
    [aux_sym_preproc_else_token1] = ACTIONS(1140),
    [aux_sym_preproc_elif_token1] = ACTIONS(1140),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1140),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1140),
    [sym_preproc_directive] = ACTIONS(1140),
    [anon_sym_LPAREN2] = ACTIONS(1142),
    [anon_sym_BANG] = ACTIONS(1142),
    [anon_sym_TILDE] = ACTIONS(1142),
    [anon_sym_DASH] = ACTIONS(1140),
    [anon_sym_PLUS] = ACTIONS(1140),
    [anon_sym_STAR] = ACTIONS(1142),
    [anon_sym_AMP] = ACTIONS(1142),
    [anon_sym_SEMI] = ACTIONS(1142),
    [anon_sym___extension__] = ACTIONS(1140),
    [anon_sym_typedef] = ACTIONS(1140),
    [anon_sym_extern] = ACTIONS(1140),
    [anon_sym___attribute__] = ACTIONS(1140),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1142),
    [anon_sym___declspec] = ACTIONS(1140),
    [anon_sym___cdecl] = ACTIONS(1140),
    [anon_sym___clrcall] = ACTIONS(1140),
    [anon_sym___stdcall] = ACTIONS(1140),
    [anon_sym___fastcall] = ACTIONS(1140),
    [anon_sym___thiscall] = ACTIONS(1140),
    [anon_sym___vectorcall] = ACTIONS(1140),
    [anon_sym_LBRACE] = ACTIONS(1142),
    [anon_sym_signed] = ACTIONS(1140),
    [anon_sym_unsigned] = ACTIONS(1140),
    [anon_sym_long] = ACTIONS(1140),
    [anon_sym_short] = ACTIONS(1140),
    [anon_sym_static] = ACTIONS(1140),
    [anon_sym_auto] = ACTIONS(1140),
    [anon_sym_register] = ACTIONS(1140),
    [anon_sym_inline] = ACTIONS(1140),
    [anon_sym___inline] = ACTIONS(1140),
    [anon_sym___inline__] = ACTIONS(1140),
    [anon_sym___forceinline] = ACTIONS(1140),
    [anon_sym_thread_local] = ACTIONS(1140),
    [anon_sym___thread] = ACTIONS(1140),
    [anon_sym_const] = ACTIONS(1140),
    [anon_sym_constexpr] = ACTIONS(1140),
    [anon_sym_volatile] = ACTIONS(1140),
    [anon_sym_restrict] = ACTIONS(1140),
    [anon_sym___restrict__] = ACTIONS(1140),
    [anon_sym__Atomic] = ACTIONS(1140),
    [anon_sym__Noreturn] = ACTIONS(1140),
    [anon_sym_noreturn] = ACTIONS(1140),
    [sym_primitive_type] = ACTIONS(1140),
    [anon_sym_enum] = ACTIONS(1140),
    [anon_sym_struct] = ACTIONS(1140),
    [anon_sym_union] = ACTIONS(1140),
    [anon_sym_if] = ACTIONS(1140),
    [anon_sym_else] = ACTIONS(1140),
    [anon_sym_switch] = ACTIONS(1140),
    [anon_sym_case] = ACTIONS(1140),
    [anon_sym_default] = ACTIONS(1140),
    [anon_sym_while] = ACTIONS(1140),
    [anon_sym_do] = ACTIONS(1140),
    [anon_sym_for] = ACTIONS(1140),
    [anon_sym_return] = ACTIONS(1140),
    [anon_sym_break] = ACTIONS(1140),
    [anon_sym_continue] = ACTIONS(1140),
    [anon_sym_goto] = ACTIONS(1140),
    [anon_sym___try] = ACTIONS(1140),
    [anon_sym___leave] = ACTIONS(1140),
    [anon_sym_DASH_DASH] = ACTIONS(1142),
    [anon_sym_PLUS_PLUS] = ACTIONS(1142),
    [anon_sym_sizeof] = ACTIONS(1140),
    [anon_sym___alignof__] = ACTIONS(1140),
    [anon_sym___alignof] = ACTIONS(1140),
    [anon_sym__alignof] = ACTIONS(1140),
    [anon_sym_alignof] = ACTIONS(1140),
    [anon_sym__Alignof] = ACTIONS(1140),
    [anon_sym_offsetof] = ACTIONS(1140),
    [anon_sym__Generic] = ACTIONS(1140),
    [anon_sym_asm] = ACTIONS(1140),
    [anon_sym___asm__] = ACTIONS(1140),
    [sym_number_literal] = ACTIONS(1142),
    [anon_sym_L_SQUOTE] = ACTIONS(1142),
    [anon_sym_u_SQUOTE] = ACTIONS(1142),
    [anon_sym_U_SQUOTE] = ACTIONS(1142),
    [anon_sym_u8_SQUOTE] = ACTIONS(1142),
    [anon_sym_SQUOTE] = ACTIONS(1142),
    [anon_sym_L_DQUOTE] = ACTIONS(1142),
    [anon_sym_u_DQUOTE] = ACTIONS(1142),
    [anon_sym_U_DQUOTE] = ACTIONS(1142),
    [anon_sym_u8_DQUOTE] = ACTIONS(1142),
    [anon_sym_DQUOTE] = ACTIONS(1142),
    [sym_true] = ACTIONS(1140),
    [sym_false] = ACTIONS(1140),
    [anon_sym_NULL] = ACTIONS(1140),
    [anon_sym_nullptr] = ACTIONS(1140),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_identifier] = ACTIONS(1144),
    [aux_sym_preproc_include_token1] = ACTIONS(1144),
    [aux_sym_preproc_def_token1] = ACTIONS(1144),
    [aux_sym_preproc_if_token1] = ACTIONS(1144),
    [aux_sym_preproc_if_token2] = ACTIONS(1144),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1144),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1144),
    [aux_sym_preproc_else_token1] = ACTIONS(1144),
    [aux_sym_preproc_elif_token1] = ACTIONS(1144),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1144),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1144),
    [sym_preproc_directive] = ACTIONS(1144),
    [anon_sym_LPAREN2] = ACTIONS(1146),
    [anon_sym_BANG] = ACTIONS(1146),
    [anon_sym_TILDE] = ACTIONS(1146),
    [anon_sym_DASH] = ACTIONS(1144),
    [anon_sym_PLUS] = ACTIONS(1144),
    [anon_sym_STAR] = ACTIONS(1146),
    [anon_sym_AMP] = ACTIONS(1146),
    [anon_sym_SEMI] = ACTIONS(1146),
    [anon_sym___extension__] = ACTIONS(1144),
    [anon_sym_typedef] = ACTIONS(1144),
    [anon_sym_extern] = ACTIONS(1144),
    [anon_sym___attribute__] = ACTIONS(1144),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1146),
    [anon_sym___declspec] = ACTIONS(1144),
    [anon_sym___cdecl] = ACTIONS(1144),
    [anon_sym___clrcall] = ACTIONS(1144),
    [anon_sym___stdcall] = ACTIONS(1144),
    [anon_sym___fastcall] = ACTIONS(1144),
    [anon_sym___thiscall] = ACTIONS(1144),
    [anon_sym___vectorcall] = ACTIONS(1144),
    [anon_sym_LBRACE] = ACTIONS(1146),
    [anon_sym_signed] = ACTIONS(1144),
    [anon_sym_unsigned] = ACTIONS(1144),
    [anon_sym_long] = ACTIONS(1144),
    [anon_sym_short] = ACTIONS(1144),
    [anon_sym_static] = ACTIONS(1144),
    [anon_sym_auto] = ACTIONS(1144),
    [anon_sym_register] = ACTIONS(1144),
    [anon_sym_inline] = ACTIONS(1144),
    [anon_sym___inline] = ACTIONS(1144),
    [anon_sym___inline__] = ACTIONS(1144),
    [anon_sym___forceinline] = ACTIONS(1144),
    [anon_sym_thread_local] = ACTIONS(1144),
    [anon_sym___thread] = ACTIONS(1144),
    [anon_sym_const] = ACTIONS(1144),
    [anon_sym_constexpr] = ACTIONS(1144),
    [anon_sym_volatile] = ACTIONS(1144),
    [anon_sym_restrict] = ACTIONS(1144),
    [anon_sym___restrict__] = ACTIONS(1144),
    [anon_sym__Atomic] = ACTIONS(1144),
    [anon_sym__Noreturn] = ACTIONS(1144),
    [anon_sym_noreturn] = ACTIONS(1144),
    [sym_primitive_type] = ACTIONS(1144),
    [anon_sym_enum] = ACTIONS(1144),
    [anon_sym_struct] = ACTIONS(1144),
    [anon_sym_union] = ACTIONS(1144),
    [anon_sym_if] = ACTIONS(1144),
    [anon_sym_else] = ACTIONS(1144),
    [anon_sym_switch] = ACTIONS(1144),
    [anon_sym_case] = ACTIONS(1144),
    [anon_sym_default] = ACTIONS(1144),
    [anon_sym_while] = ACTIONS(1144),
    [anon_sym_do] = ACTIONS(1144),
    [anon_sym_for] = ACTIONS(1144),
    [anon_sym_return] = ACTIONS(1144),
    [anon_sym_break] = ACTIONS(1144),
    [anon_sym_continue] = ACTIONS(1144),
    [anon_sym_goto] = ACTIONS(1144),
    [anon_sym___try] = ACTIONS(1144),
    [anon_sym___leave] = ACTIONS(1144),
    [anon_sym_DASH_DASH] = ACTIONS(1146),
    [anon_sym_PLUS_PLUS] = ACTIONS(1146),
    [anon_sym_sizeof] = ACTIONS(1144),
    [anon_sym___alignof__] = ACTIONS(1144),
    [anon_sym___alignof] = ACTIONS(1144),
    [anon_sym__alignof] = ACTIONS(1144),
    [anon_sym_alignof] = ACTIONS(1144),
    [anon_sym__Alignof] = ACTIONS(1144),
    [anon_sym_offsetof] = ACTIONS(1144),
    [anon_sym__Generic] = ACTIONS(1144),
    [anon_sym_asm] = ACTIONS(1144),
    [anon_sym___asm__] = ACTIONS(1144),
    [sym_number_literal] = ACTIONS(1146),
    [anon_sym_L_SQUOTE] = ACTIONS(1146),
    [anon_sym_u_SQUOTE] = ACTIONS(1146),
    [anon_sym_U_SQUOTE] = ACTIONS(1146),
    [anon_sym_u8_SQUOTE] = ACTIONS(1146),
    [anon_sym_SQUOTE] = ACTIONS(1146),
    [anon_sym_L_DQUOTE] = ACTIONS(1146),
    [anon_sym_u_DQUOTE] = ACTIONS(1146),
    [anon_sym_U_DQUOTE] = ACTIONS(1146),
    [anon_sym_u8_DQUOTE] = ACTIONS(1146),
    [anon_sym_DQUOTE] = ACTIONS(1146),
    [sym_true] = ACTIONS(1144),
    [sym_false] = ACTIONS(1144),
    [anon_sym_NULL] = ACTIONS(1144),
    [anon_sym_nullptr] = ACTIONS(1144),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_identifier] = ACTIONS(1148),
    [aux_sym_preproc_include_token1] = ACTIONS(1148),
    [aux_sym_preproc_def_token1] = ACTIONS(1148),
    [aux_sym_preproc_if_token1] = ACTIONS(1148),
    [aux_sym_preproc_if_token2] = ACTIONS(1148),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1148),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1148),
    [aux_sym_preproc_else_token1] = ACTIONS(1148),
    [aux_sym_preproc_elif_token1] = ACTIONS(1148),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1148),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1148),
    [sym_preproc_directive] = ACTIONS(1148),
    [anon_sym_LPAREN2] = ACTIONS(1150),
    [anon_sym_BANG] = ACTIONS(1150),
    [anon_sym_TILDE] = ACTIONS(1150),
    [anon_sym_DASH] = ACTIONS(1148),
    [anon_sym_PLUS] = ACTIONS(1148),
    [anon_sym_STAR] = ACTIONS(1150),
    [anon_sym_AMP] = ACTIONS(1150),
    [anon_sym_SEMI] = ACTIONS(1150),
    [anon_sym___extension__] = ACTIONS(1148),
    [anon_sym_typedef] = ACTIONS(1148),
    [anon_sym_extern] = ACTIONS(1148),
    [anon_sym___attribute__] = ACTIONS(1148),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1150),
    [anon_sym___declspec] = ACTIONS(1148),
    [anon_sym___cdecl] = ACTIONS(1148),
    [anon_sym___clrcall] = ACTIONS(1148),
    [anon_sym___stdcall] = ACTIONS(1148),
    [anon_sym___fastcall] = ACTIONS(1148),
    [anon_sym___thiscall] = ACTIONS(1148),
    [anon_sym___vectorcall] = ACTIONS(1148),
    [anon_sym_LBRACE] = ACTIONS(1150),
    [anon_sym_signed] = ACTIONS(1148),
    [anon_sym_unsigned] = ACTIONS(1148),
    [anon_sym_long] = ACTIONS(1148),
    [anon_sym_short] = ACTIONS(1148),
    [anon_sym_static] = ACTIONS(1148),
    [anon_sym_auto] = ACTIONS(1148),
    [anon_sym_register] = ACTIONS(1148),
    [anon_sym_inline] = ACTIONS(1148),
    [anon_sym___inline] = ACTIONS(1148),
    [anon_sym___inline__] = ACTIONS(1148),
    [anon_sym___forceinline] = ACTIONS(1148),
    [anon_sym_thread_local] = ACTIONS(1148),
    [anon_sym___thread] = ACTIONS(1148),
    [anon_sym_const] = ACTIONS(1148),
    [anon_sym_constexpr] = ACTIONS(1148),
    [anon_sym_volatile] = ACTIONS(1148),
    [anon_sym_restrict] = ACTIONS(1148),
    [anon_sym___restrict__] = ACTIONS(1148),
    [anon_sym__Atomic] = ACTIONS(1148),
    [anon_sym__Noreturn] = ACTIONS(1148),
    [anon_sym_noreturn] = ACTIONS(1148),
    [sym_primitive_type] = ACTIONS(1148),
    [anon_sym_enum] = ACTIONS(1148),
    [anon_sym_struct] = ACTIONS(1148),
    [anon_sym_union] = ACTIONS(1148),
    [anon_sym_if] = ACTIONS(1148),
    [anon_sym_else] = ACTIONS(1148),
    [anon_sym_switch] = ACTIONS(1148),
    [anon_sym_case] = ACTIONS(1148),
    [anon_sym_default] = ACTIONS(1148),
    [anon_sym_while] = ACTIONS(1148),
    [anon_sym_do] = ACTIONS(1148),
    [anon_sym_for] = ACTIONS(1148),
    [anon_sym_return] = ACTIONS(1148),
    [anon_sym_break] = ACTIONS(1148),
    [anon_sym_continue] = ACTIONS(1148),
    [anon_sym_goto] = ACTIONS(1148),
    [anon_sym___try] = ACTIONS(1148),
    [anon_sym___leave] = ACTIONS(1148),
    [anon_sym_DASH_DASH] = ACTIONS(1150),
    [anon_sym_PLUS_PLUS] = ACTIONS(1150),
    [anon_sym_sizeof] = ACTIONS(1148),
    [anon_sym___alignof__] = ACTIONS(1148),
    [anon_sym___alignof] = ACTIONS(1148),
    [anon_sym__alignof] = ACTIONS(1148),
    [anon_sym_alignof] = ACTIONS(1148),
    [anon_sym__Alignof] = ACTIONS(1148),
    [anon_sym_offsetof] = ACTIONS(1148),
    [anon_sym__Generic] = ACTIONS(1148),
    [anon_sym_asm] = ACTIONS(1148),
    [anon_sym___asm__] = ACTIONS(1148),
    [sym_number_literal] = ACTIONS(1150),
    [anon_sym_L_SQUOTE] = ACTIONS(1150),
    [anon_sym_u_SQUOTE] = ACTIONS(1150),
    [anon_sym_U_SQUOTE] = ACTIONS(1150),
    [anon_sym_u8_SQUOTE] = ACTIONS(1150),
    [anon_sym_SQUOTE] = ACTIONS(1150),
    [anon_sym_L_DQUOTE] = ACTIONS(1150),
    [anon_sym_u_DQUOTE] = ACTIONS(1150),
    [anon_sym_U_DQUOTE] = ACTIONS(1150),
    [anon_sym_u8_DQUOTE] = ACTIONS(1150),
    [anon_sym_DQUOTE] = ACTIONS(1150),
    [sym_true] = ACTIONS(1148),
    [sym_false] = ACTIONS(1148),
    [anon_sym_NULL] = ACTIONS(1148),
    [anon_sym_nullptr] = ACTIONS(1148),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_identifier] = ACTIONS(1152),
    [aux_sym_preproc_include_token1] = ACTIONS(1152),
    [aux_sym_preproc_def_token1] = ACTIONS(1152),
    [aux_sym_preproc_if_token1] = ACTIONS(1152),
    [aux_sym_preproc_if_token2] = ACTIONS(1152),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1152),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1152),
    [aux_sym_preproc_else_token1] = ACTIONS(1152),
    [aux_sym_preproc_elif_token1] = ACTIONS(1152),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1152),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1152),
    [sym_preproc_directive] = ACTIONS(1152),
    [anon_sym_LPAREN2] = ACTIONS(1154),
    [anon_sym_BANG] = ACTIONS(1154),
    [anon_sym_TILDE] = ACTIONS(1154),
    [anon_sym_DASH] = ACTIONS(1152),
    [anon_sym_PLUS] = ACTIONS(1152),
    [anon_sym_STAR] = ACTIONS(1154),
    [anon_sym_AMP] = ACTIONS(1154),
    [anon_sym_SEMI] = ACTIONS(1154),
    [anon_sym___extension__] = ACTIONS(1152),
    [anon_sym_typedef] = ACTIONS(1152),
    [anon_sym_extern] = ACTIONS(1152),
    [anon_sym___attribute__] = ACTIONS(1152),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1154),
    [anon_sym___declspec] = ACTIONS(1152),
    [anon_sym___cdecl] = ACTIONS(1152),
    [anon_sym___clrcall] = ACTIONS(1152),
    [anon_sym___stdcall] = ACTIONS(1152),
    [anon_sym___fastcall] = ACTIONS(1152),
    [anon_sym___thiscall] = ACTIONS(1152),
    [anon_sym___vectorcall] = ACTIONS(1152),
    [anon_sym_LBRACE] = ACTIONS(1154),
    [anon_sym_signed] = ACTIONS(1152),
    [anon_sym_unsigned] = ACTIONS(1152),
    [anon_sym_long] = ACTIONS(1152),
    [anon_sym_short] = ACTIONS(1152),
    [anon_sym_static] = ACTIONS(1152),
    [anon_sym_auto] = ACTIONS(1152),
    [anon_sym_register] = ACTIONS(1152),
    [anon_sym_inline] = ACTIONS(1152),
    [anon_sym___inline] = ACTIONS(1152),
    [anon_sym___inline__] = ACTIONS(1152),
    [anon_sym___forceinline] = ACTIONS(1152),
    [anon_sym_thread_local] = ACTIONS(1152),
    [anon_sym___thread] = ACTIONS(1152),
    [anon_sym_const] = ACTIONS(1152),
    [anon_sym_constexpr] = ACTIONS(1152),
    [anon_sym_volatile] = ACTIONS(1152),
    [anon_sym_restrict] = ACTIONS(1152),
    [anon_sym___restrict__] = ACTIONS(1152),
    [anon_sym__Atomic] = ACTIONS(1152),
    [anon_sym__Noreturn] = ACTIONS(1152),
    [anon_sym_noreturn] = ACTIONS(1152),
    [sym_primitive_type] = ACTIONS(1152),
    [anon_sym_enum] = ACTIONS(1152),
    [anon_sym_struct] = ACTIONS(1152),
    [anon_sym_union] = ACTIONS(1152),
    [anon_sym_if] = ACTIONS(1152),
    [anon_sym_else] = ACTIONS(1152),
    [anon_sym_switch] = ACTIONS(1152),
    [anon_sym_case] = ACTIONS(1152),
    [anon_sym_default] = ACTIONS(1152),
    [anon_sym_while] = ACTIONS(1152),
    [anon_sym_do] = ACTIONS(1152),
    [anon_sym_for] = ACTIONS(1152),
    [anon_sym_return] = ACTIONS(1152),
    [anon_sym_break] = ACTIONS(1152),
    [anon_sym_continue] = ACTIONS(1152),
    [anon_sym_goto] = ACTIONS(1152),
    [anon_sym___try] = ACTIONS(1152),
    [anon_sym___leave] = ACTIONS(1152),
    [anon_sym_DASH_DASH] = ACTIONS(1154),
    [anon_sym_PLUS_PLUS] = ACTIONS(1154),
    [anon_sym_sizeof] = ACTIONS(1152),
    [anon_sym___alignof__] = ACTIONS(1152),
    [anon_sym___alignof] = ACTIONS(1152),
    [anon_sym__alignof] = ACTIONS(1152),
    [anon_sym_alignof] = ACTIONS(1152),
    [anon_sym__Alignof] = ACTIONS(1152),
    [anon_sym_offsetof] = ACTIONS(1152),
    [anon_sym__Generic] = ACTIONS(1152),
    [anon_sym_asm] = ACTIONS(1152),
    [anon_sym___asm__] = ACTIONS(1152),
    [sym_number_literal] = ACTIONS(1154),
    [anon_sym_L_SQUOTE] = ACTIONS(1154),
    [anon_sym_u_SQUOTE] = ACTIONS(1154),
    [anon_sym_U_SQUOTE] = ACTIONS(1154),
    [anon_sym_u8_SQUOTE] = ACTIONS(1154),
    [anon_sym_SQUOTE] = ACTIONS(1154),
    [anon_sym_L_DQUOTE] = ACTIONS(1154),
    [anon_sym_u_DQUOTE] = ACTIONS(1154),
    [anon_sym_U_DQUOTE] = ACTIONS(1154),
    [anon_sym_u8_DQUOTE] = ACTIONS(1154),
    [anon_sym_DQUOTE] = ACTIONS(1154),
    [sym_true] = ACTIONS(1152),
    [sym_false] = ACTIONS(1152),
    [anon_sym_NULL] = ACTIONS(1152),
    [anon_sym_nullptr] = ACTIONS(1152),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_identifier] = ACTIONS(1156),
    [aux_sym_preproc_include_token1] = ACTIONS(1156),
    [aux_sym_preproc_def_token1] = ACTIONS(1156),
    [aux_sym_preproc_if_token1] = ACTIONS(1156),
    [aux_sym_preproc_if_token2] = ACTIONS(1156),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1156),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1156),
    [aux_sym_preproc_else_token1] = ACTIONS(1156),
    [aux_sym_preproc_elif_token1] = ACTIONS(1156),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1156),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1156),
    [sym_preproc_directive] = ACTIONS(1156),
    [anon_sym_LPAREN2] = ACTIONS(1158),
    [anon_sym_BANG] = ACTIONS(1158),
    [anon_sym_TILDE] = ACTIONS(1158),
    [anon_sym_DASH] = ACTIONS(1156),
    [anon_sym_PLUS] = ACTIONS(1156),
    [anon_sym_STAR] = ACTIONS(1158),
    [anon_sym_AMP] = ACTIONS(1158),
    [anon_sym_SEMI] = ACTIONS(1158),
    [anon_sym___extension__] = ACTIONS(1156),
    [anon_sym_typedef] = ACTIONS(1156),
    [anon_sym_extern] = ACTIONS(1156),
    [anon_sym___attribute__] = ACTIONS(1156),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1158),
    [anon_sym___declspec] = ACTIONS(1156),
    [anon_sym___cdecl] = ACTIONS(1156),
    [anon_sym___clrcall] = ACTIONS(1156),
    [anon_sym___stdcall] = ACTIONS(1156),
    [anon_sym___fastcall] = ACTIONS(1156),
    [anon_sym___thiscall] = ACTIONS(1156),
    [anon_sym___vectorcall] = ACTIONS(1156),
    [anon_sym_LBRACE] = ACTIONS(1158),
    [anon_sym_signed] = ACTIONS(1156),
    [anon_sym_unsigned] = ACTIONS(1156),
    [anon_sym_long] = ACTIONS(1156),
    [anon_sym_short] = ACTIONS(1156),
    [anon_sym_static] = ACTIONS(1156),
    [anon_sym_auto] = ACTIONS(1156),
    [anon_sym_register] = ACTIONS(1156),
    [anon_sym_inline] = ACTIONS(1156),
    [anon_sym___inline] = ACTIONS(1156),
    [anon_sym___inline__] = ACTIONS(1156),
    [anon_sym___forceinline] = ACTIONS(1156),
    [anon_sym_thread_local] = ACTIONS(1156),
    [anon_sym___thread] = ACTIONS(1156),
    [anon_sym_const] = ACTIONS(1156),
    [anon_sym_constexpr] = ACTIONS(1156),
    [anon_sym_volatile] = ACTIONS(1156),
    [anon_sym_restrict] = ACTIONS(1156),
    [anon_sym___restrict__] = ACTIONS(1156),
    [anon_sym__Atomic] = ACTIONS(1156),
    [anon_sym__Noreturn] = ACTIONS(1156),
    [anon_sym_noreturn] = ACTIONS(1156),
    [sym_primitive_type] = ACTIONS(1156),
    [anon_sym_enum] = ACTIONS(1156),
    [anon_sym_struct] = ACTIONS(1156),
    [anon_sym_union] = ACTIONS(1156),
    [anon_sym_if] = ACTIONS(1156),
    [anon_sym_else] = ACTIONS(1156),
    [anon_sym_switch] = ACTIONS(1156),
    [anon_sym_case] = ACTIONS(1156),
    [anon_sym_default] = ACTIONS(1156),
    [anon_sym_while] = ACTIONS(1156),
    [anon_sym_do] = ACTIONS(1156),
    [anon_sym_for] = ACTIONS(1156),
    [anon_sym_return] = ACTIONS(1156),
    [anon_sym_break] = ACTIONS(1156),
    [anon_sym_continue] = ACTIONS(1156),
    [anon_sym_goto] = ACTIONS(1156),
    [anon_sym___try] = ACTIONS(1156),
    [anon_sym___leave] = ACTIONS(1156),
    [anon_sym_DASH_DASH] = ACTIONS(1158),
    [anon_sym_PLUS_PLUS] = ACTIONS(1158),
    [anon_sym_sizeof] = ACTIONS(1156),
    [anon_sym___alignof__] = ACTIONS(1156),
    [anon_sym___alignof] = ACTIONS(1156),
    [anon_sym__alignof] = ACTIONS(1156),
    [anon_sym_alignof] = ACTIONS(1156),
    [anon_sym__Alignof] = ACTIONS(1156),
    [anon_sym_offsetof] = ACTIONS(1156),
    [anon_sym__Generic] = ACTIONS(1156),
    [anon_sym_asm] = ACTIONS(1156),
    [anon_sym___asm__] = ACTIONS(1156),
    [sym_number_literal] = ACTIONS(1158),
    [anon_sym_L_SQUOTE] = ACTIONS(1158),
    [anon_sym_u_SQUOTE] = ACTIONS(1158),
    [anon_sym_U_SQUOTE] = ACTIONS(1158),
    [anon_sym_u8_SQUOTE] = ACTIONS(1158),
    [anon_sym_SQUOTE] = ACTIONS(1158),
    [anon_sym_L_DQUOTE] = ACTIONS(1158),
    [anon_sym_u_DQUOTE] = ACTIONS(1158),
    [anon_sym_U_DQUOTE] = ACTIONS(1158),
    [anon_sym_u8_DQUOTE] = ACTIONS(1158),
    [anon_sym_DQUOTE] = ACTIONS(1158),
    [sym_true] = ACTIONS(1156),
    [sym_false] = ACTIONS(1156),
    [anon_sym_NULL] = ACTIONS(1156),
    [anon_sym_nullptr] = ACTIONS(1156),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_identifier] = ACTIONS(1160),
    [aux_sym_preproc_include_token1] = ACTIONS(1160),
    [aux_sym_preproc_def_token1] = ACTIONS(1160),
    [aux_sym_preproc_if_token1] = ACTIONS(1160),
    [aux_sym_preproc_if_token2] = ACTIONS(1160),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1160),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1160),
    [aux_sym_preproc_else_token1] = ACTIONS(1160),
    [aux_sym_preproc_elif_token1] = ACTIONS(1160),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1160),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1160),
    [sym_preproc_directive] = ACTIONS(1160),
    [anon_sym_LPAREN2] = ACTIONS(1162),
    [anon_sym_BANG] = ACTIONS(1162),
    [anon_sym_TILDE] = ACTIONS(1162),
    [anon_sym_DASH] = ACTIONS(1160),
    [anon_sym_PLUS] = ACTIONS(1160),
    [anon_sym_STAR] = ACTIONS(1162),
    [anon_sym_AMP] = ACTIONS(1162),
    [anon_sym_SEMI] = ACTIONS(1162),
    [anon_sym___extension__] = ACTIONS(1160),
    [anon_sym_typedef] = ACTIONS(1160),
    [anon_sym_extern] = ACTIONS(1160),
    [anon_sym___attribute__] = ACTIONS(1160),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1162),
    [anon_sym___declspec] = ACTIONS(1160),
    [anon_sym___cdecl] = ACTIONS(1160),
    [anon_sym___clrcall] = ACTIONS(1160),
    [anon_sym___stdcall] = ACTIONS(1160),
    [anon_sym___fastcall] = ACTIONS(1160),
    [anon_sym___thiscall] = ACTIONS(1160),
    [anon_sym___vectorcall] = ACTIONS(1160),
    [anon_sym_LBRACE] = ACTIONS(1162),
    [anon_sym_signed] = ACTIONS(1160),
    [anon_sym_unsigned] = ACTIONS(1160),
    [anon_sym_long] = ACTIONS(1160),
    [anon_sym_short] = ACTIONS(1160),
    [anon_sym_static] = ACTIONS(1160),
    [anon_sym_auto] = ACTIONS(1160),
    [anon_sym_register] = ACTIONS(1160),
    [anon_sym_inline] = ACTIONS(1160),
    [anon_sym___inline] = ACTIONS(1160),
    [anon_sym___inline__] = ACTIONS(1160),
    [anon_sym___forceinline] = ACTIONS(1160),
    [anon_sym_thread_local] = ACTIONS(1160),
    [anon_sym___thread] = ACTIONS(1160),
    [anon_sym_const] = ACTIONS(1160),
    [anon_sym_constexpr] = ACTIONS(1160),
    [anon_sym_volatile] = ACTIONS(1160),
    [anon_sym_restrict] = ACTIONS(1160),
    [anon_sym___restrict__] = ACTIONS(1160),
    [anon_sym__Atomic] = ACTIONS(1160),
    [anon_sym__Noreturn] = ACTIONS(1160),
    [anon_sym_noreturn] = ACTIONS(1160),
    [sym_primitive_type] = ACTIONS(1160),
    [anon_sym_enum] = ACTIONS(1160),
    [anon_sym_struct] = ACTIONS(1160),
    [anon_sym_union] = ACTIONS(1160),
    [anon_sym_if] = ACTIONS(1160),
    [anon_sym_else] = ACTIONS(1160),
    [anon_sym_switch] = ACTIONS(1160),
    [anon_sym_case] = ACTIONS(1160),
    [anon_sym_default] = ACTIONS(1160),
    [anon_sym_while] = ACTIONS(1160),
    [anon_sym_do] = ACTIONS(1160),
    [anon_sym_for] = ACTIONS(1160),
    [anon_sym_return] = ACTIONS(1160),
    [anon_sym_break] = ACTIONS(1160),
    [anon_sym_continue] = ACTIONS(1160),
    [anon_sym_goto] = ACTIONS(1160),
    [anon_sym___try] = ACTIONS(1160),
    [anon_sym___leave] = ACTIONS(1160),
    [anon_sym_DASH_DASH] = ACTIONS(1162),
    [anon_sym_PLUS_PLUS] = ACTIONS(1162),
    [anon_sym_sizeof] = ACTIONS(1160),
    [anon_sym___alignof__] = ACTIONS(1160),
    [anon_sym___alignof] = ACTIONS(1160),
    [anon_sym__alignof] = ACTIONS(1160),
    [anon_sym_alignof] = ACTIONS(1160),
    [anon_sym__Alignof] = ACTIONS(1160),
    [anon_sym_offsetof] = ACTIONS(1160),
    [anon_sym__Generic] = ACTIONS(1160),
    [anon_sym_asm] = ACTIONS(1160),
    [anon_sym___asm__] = ACTIONS(1160),
    [sym_number_literal] = ACTIONS(1162),
    [anon_sym_L_SQUOTE] = ACTIONS(1162),
    [anon_sym_u_SQUOTE] = ACTIONS(1162),
    [anon_sym_U_SQUOTE] = ACTIONS(1162),
    [anon_sym_u8_SQUOTE] = ACTIONS(1162),
    [anon_sym_SQUOTE] = ACTIONS(1162),
    [anon_sym_L_DQUOTE] = ACTIONS(1162),
    [anon_sym_u_DQUOTE] = ACTIONS(1162),
    [anon_sym_U_DQUOTE] = ACTIONS(1162),
    [anon_sym_u8_DQUOTE] = ACTIONS(1162),
    [anon_sym_DQUOTE] = ACTIONS(1162),
    [sym_true] = ACTIONS(1160),
    [sym_false] = ACTIONS(1160),
    [anon_sym_NULL] = ACTIONS(1160),
    [anon_sym_nullptr] = ACTIONS(1160),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_identifier] = ACTIONS(1120),
    [aux_sym_preproc_include_token1] = ACTIONS(1120),
    [aux_sym_preproc_def_token1] = ACTIONS(1120),
    [aux_sym_preproc_if_token1] = ACTIONS(1120),
    [aux_sym_preproc_if_token2] = ACTIONS(1120),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1120),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1120),
    [aux_sym_preproc_else_token1] = ACTIONS(1120),
    [aux_sym_preproc_elif_token1] = ACTIONS(1120),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1120),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1120),
    [sym_preproc_directive] = ACTIONS(1120),
    [anon_sym_LPAREN2] = ACTIONS(1122),
    [anon_sym_BANG] = ACTIONS(1122),
    [anon_sym_TILDE] = ACTIONS(1122),
    [anon_sym_DASH] = ACTIONS(1120),
    [anon_sym_PLUS] = ACTIONS(1120),
    [anon_sym_STAR] = ACTIONS(1122),
    [anon_sym_AMP] = ACTIONS(1122),
    [anon_sym_SEMI] = ACTIONS(1122),
    [anon_sym___extension__] = ACTIONS(1120),
    [anon_sym_typedef] = ACTIONS(1120),
    [anon_sym_extern] = ACTIONS(1120),
    [anon_sym___attribute__] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym___declspec] = ACTIONS(1120),
    [anon_sym___cdecl] = ACTIONS(1120),
    [anon_sym___clrcall] = ACTIONS(1120),
    [anon_sym___stdcall] = ACTIONS(1120),
    [anon_sym___fastcall] = ACTIONS(1120),
    [anon_sym___thiscall] = ACTIONS(1120),
    [anon_sym___vectorcall] = ACTIONS(1120),
    [anon_sym_LBRACE] = ACTIONS(1122),
    [anon_sym_signed] = ACTIONS(1120),
    [anon_sym_unsigned] = ACTIONS(1120),
    [anon_sym_long] = ACTIONS(1120),
    [anon_sym_short] = ACTIONS(1120),
    [anon_sym_static] = ACTIONS(1120),
    [anon_sym_auto] = ACTIONS(1120),
    [anon_sym_register] = ACTIONS(1120),
    [anon_sym_inline] = ACTIONS(1120),
    [anon_sym___inline] = ACTIONS(1120),
    [anon_sym___inline__] = ACTIONS(1120),
    [anon_sym___forceinline] = ACTIONS(1120),
    [anon_sym_thread_local] = ACTIONS(1120),
    [anon_sym___thread] = ACTIONS(1120),
    [anon_sym_const] = ACTIONS(1120),
    [anon_sym_constexpr] = ACTIONS(1120),
    [anon_sym_volatile] = ACTIONS(1120),
    [anon_sym_restrict] = ACTIONS(1120),
    [anon_sym___restrict__] = ACTIONS(1120),
    [anon_sym__Atomic] = ACTIONS(1120),
    [anon_sym__Noreturn] = ACTIONS(1120),
    [anon_sym_noreturn] = ACTIONS(1120),
    [sym_primitive_type] = ACTIONS(1120),
    [anon_sym_enum] = ACTIONS(1120),
    [anon_sym_struct] = ACTIONS(1120),
    [anon_sym_union] = ACTIONS(1120),
    [anon_sym_if] = ACTIONS(1120),
    [anon_sym_else] = ACTIONS(1120),
    [anon_sym_switch] = ACTIONS(1120),
    [anon_sym_case] = ACTIONS(1120),
    [anon_sym_default] = ACTIONS(1120),
    [anon_sym_while] = ACTIONS(1120),
    [anon_sym_do] = ACTIONS(1120),
    [anon_sym_for] = ACTIONS(1120),
    [anon_sym_return] = ACTIONS(1120),
    [anon_sym_break] = ACTIONS(1120),
    [anon_sym_continue] = ACTIONS(1120),
    [anon_sym_goto] = ACTIONS(1120),
    [anon_sym___try] = ACTIONS(1120),
    [anon_sym___leave] = ACTIONS(1120),
    [anon_sym_DASH_DASH] = ACTIONS(1122),
    [anon_sym_PLUS_PLUS] = ACTIONS(1122),
    [anon_sym_sizeof] = ACTIONS(1120),
    [anon_sym___alignof__] = ACTIONS(1120),
    [anon_sym___alignof] = ACTIONS(1120),
    [anon_sym__alignof] = ACTIONS(1120),
    [anon_sym_alignof] = ACTIONS(1120),
    [anon_sym__Alignof] = ACTIONS(1120),
    [anon_sym_offsetof] = ACTIONS(1120),
    [anon_sym__Generic] = ACTIONS(1120),
    [anon_sym_asm] = ACTIONS(1120),
    [anon_sym___asm__] = ACTIONS(1120),
    [sym_number_literal] = ACTIONS(1122),
    [anon_sym_L_SQUOTE] = ACTIONS(1122),
    [anon_sym_u_SQUOTE] = ACTIONS(1122),
    [anon_sym_U_SQUOTE] = ACTIONS(1122),
    [anon_sym_u8_SQUOTE] = ACTIONS(1122),
    [anon_sym_SQUOTE] = ACTIONS(1122),
    [anon_sym_L_DQUOTE] = ACTIONS(1122),
    [anon_sym_u_DQUOTE] = ACTIONS(1122),
    [anon_sym_U_DQUOTE] = ACTIONS(1122),
    [anon_sym_u8_DQUOTE] = ACTIONS(1122),
    [anon_sym_DQUOTE] = ACTIONS(1122),
    [sym_true] = ACTIONS(1120),
    [sym_false] = ACTIONS(1120),
    [anon_sym_NULL] = ACTIONS(1120),
    [anon_sym_nullptr] = ACTIONS(1120),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_identifier] = ACTIONS(1164),
    [aux_sym_preproc_include_token1] = ACTIONS(1164),
    [aux_sym_preproc_def_token1] = ACTIONS(1164),
    [aux_sym_preproc_if_token1] = ACTIONS(1164),
    [aux_sym_preproc_if_token2] = ACTIONS(1164),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1164),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1164),
    [aux_sym_preproc_else_token1] = ACTIONS(1164),
    [aux_sym_preproc_elif_token1] = ACTIONS(1164),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1164),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1164),
    [sym_preproc_directive] = ACTIONS(1164),
    [anon_sym_LPAREN2] = ACTIONS(1166),
    [anon_sym_BANG] = ACTIONS(1166),
    [anon_sym_TILDE] = ACTIONS(1166),
    [anon_sym_DASH] = ACTIONS(1164),
    [anon_sym_PLUS] = ACTIONS(1164),
    [anon_sym_STAR] = ACTIONS(1166),
    [anon_sym_AMP] = ACTIONS(1166),
    [anon_sym_SEMI] = ACTIONS(1166),
    [anon_sym___extension__] = ACTIONS(1164),
    [anon_sym_typedef] = ACTIONS(1164),
    [anon_sym_extern] = ACTIONS(1164),
    [anon_sym___attribute__] = ACTIONS(1164),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1166),
    [anon_sym___declspec] = ACTIONS(1164),
    [anon_sym___cdecl] = ACTIONS(1164),
    [anon_sym___clrcall] = ACTIONS(1164),
    [anon_sym___stdcall] = ACTIONS(1164),
    [anon_sym___fastcall] = ACTIONS(1164),
    [anon_sym___thiscall] = ACTIONS(1164),
    [anon_sym___vectorcall] = ACTIONS(1164),
    [anon_sym_LBRACE] = ACTIONS(1166),
    [anon_sym_signed] = ACTIONS(1164),
    [anon_sym_unsigned] = ACTIONS(1164),
    [anon_sym_long] = ACTIONS(1164),
    [anon_sym_short] = ACTIONS(1164),
    [anon_sym_static] = ACTIONS(1164),
    [anon_sym_auto] = ACTIONS(1164),
    [anon_sym_register] = ACTIONS(1164),
    [anon_sym_inline] = ACTIONS(1164),
    [anon_sym___inline] = ACTIONS(1164),
    [anon_sym___inline__] = ACTIONS(1164),
    [anon_sym___forceinline] = ACTIONS(1164),
    [anon_sym_thread_local] = ACTIONS(1164),
    [anon_sym___thread] = ACTIONS(1164),
    [anon_sym_const] = ACTIONS(1164),
    [anon_sym_constexpr] = ACTIONS(1164),
    [anon_sym_volatile] = ACTIONS(1164),
    [anon_sym_restrict] = ACTIONS(1164),
    [anon_sym___restrict__] = ACTIONS(1164),
    [anon_sym__Atomic] = ACTIONS(1164),
    [anon_sym__Noreturn] = ACTIONS(1164),
    [anon_sym_noreturn] = ACTIONS(1164),
    [sym_primitive_type] = ACTIONS(1164),
    [anon_sym_enum] = ACTIONS(1164),
    [anon_sym_struct] = ACTIONS(1164),
    [anon_sym_union] = ACTIONS(1164),
    [anon_sym_if] = ACTIONS(1164),
    [anon_sym_else] = ACTIONS(1164),
    [anon_sym_switch] = ACTIONS(1164),
    [anon_sym_case] = ACTIONS(1164),
    [anon_sym_default] = ACTIONS(1164),
    [anon_sym_while] = ACTIONS(1164),
    [anon_sym_do] = ACTIONS(1164),
    [anon_sym_for] = ACTIONS(1164),
    [anon_sym_return] = ACTIONS(1164),
    [anon_sym_break] = ACTIONS(1164),
    [anon_sym_continue] = ACTIONS(1164),
    [anon_sym_goto] = ACTIONS(1164),
    [anon_sym___try] = ACTIONS(1164),
    [anon_sym___leave] = ACTIONS(1164),
    [anon_sym_DASH_DASH] = ACTIONS(1166),
    [anon_sym_PLUS_PLUS] = ACTIONS(1166),
    [anon_sym_sizeof] = ACTIONS(1164),
    [anon_sym___alignof__] = ACTIONS(1164),
    [anon_sym___alignof] = ACTIONS(1164),
    [anon_sym__alignof] = ACTIONS(1164),
    [anon_sym_alignof] = ACTIONS(1164),
    [anon_sym__Alignof] = ACTIONS(1164),
    [anon_sym_offsetof] = ACTIONS(1164),
    [anon_sym__Generic] = ACTIONS(1164),
    [anon_sym_asm] = ACTIONS(1164),
    [anon_sym___asm__] = ACTIONS(1164),
    [sym_number_literal] = ACTIONS(1166),
    [anon_sym_L_SQUOTE] = ACTIONS(1166),
    [anon_sym_u_SQUOTE] = ACTIONS(1166),
    [anon_sym_U_SQUOTE] = ACTIONS(1166),
    [anon_sym_u8_SQUOTE] = ACTIONS(1166),
    [anon_sym_SQUOTE] = ACTIONS(1166),
    [anon_sym_L_DQUOTE] = ACTIONS(1166),
    [anon_sym_u_DQUOTE] = ACTIONS(1166),
    [anon_sym_U_DQUOTE] = ACTIONS(1166),
    [anon_sym_u8_DQUOTE] = ACTIONS(1166),
    [anon_sym_DQUOTE] = ACTIONS(1166),
    [sym_true] = ACTIONS(1164),
    [sym_false] = ACTIONS(1164),
    [anon_sym_NULL] = ACTIONS(1164),
    [anon_sym_nullptr] = ACTIONS(1164),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_identifier] = ACTIONS(1168),
    [aux_sym_preproc_include_token1] = ACTIONS(1168),
    [aux_sym_preproc_def_token1] = ACTIONS(1168),
    [aux_sym_preproc_if_token1] = ACTIONS(1168),
    [aux_sym_preproc_if_token2] = ACTIONS(1168),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1168),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1168),
    [aux_sym_preproc_else_token1] = ACTIONS(1168),
    [aux_sym_preproc_elif_token1] = ACTIONS(1168),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1168),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1168),
    [sym_preproc_directive] = ACTIONS(1168),
    [anon_sym_LPAREN2] = ACTIONS(1170),
    [anon_sym_BANG] = ACTIONS(1170),
    [anon_sym_TILDE] = ACTIONS(1170),
    [anon_sym_DASH] = ACTIONS(1168),
    [anon_sym_PLUS] = ACTIONS(1168),
    [anon_sym_STAR] = ACTIONS(1170),
    [anon_sym_AMP] = ACTIONS(1170),
    [anon_sym_SEMI] = ACTIONS(1170),
    [anon_sym___extension__] = ACTIONS(1168),
    [anon_sym_typedef] = ACTIONS(1168),
    [anon_sym_extern] = ACTIONS(1168),
    [anon_sym___attribute__] = ACTIONS(1168),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1170),
    [anon_sym___declspec] = ACTIONS(1168),
    [anon_sym___cdecl] = ACTIONS(1168),
    [anon_sym___clrcall] = ACTIONS(1168),
    [anon_sym___stdcall] = ACTIONS(1168),
    [anon_sym___fastcall] = ACTIONS(1168),
    [anon_sym___thiscall] = ACTIONS(1168),
    [anon_sym___vectorcall] = ACTIONS(1168),
    [anon_sym_LBRACE] = ACTIONS(1170),
    [anon_sym_signed] = ACTIONS(1168),
    [anon_sym_unsigned] = ACTIONS(1168),
    [anon_sym_long] = ACTIONS(1168),
    [anon_sym_short] = ACTIONS(1168),
    [anon_sym_static] = ACTIONS(1168),
    [anon_sym_auto] = ACTIONS(1168),
    [anon_sym_register] = ACTIONS(1168),
    [anon_sym_inline] = ACTIONS(1168),
    [anon_sym___inline] = ACTIONS(1168),
    [anon_sym___inline__] = ACTIONS(1168),
    [anon_sym___forceinline] = ACTIONS(1168),
    [anon_sym_thread_local] = ACTIONS(1168),
    [anon_sym___thread] = ACTIONS(1168),
    [anon_sym_const] = ACTIONS(1168),
    [anon_sym_constexpr] = ACTIONS(1168),
    [anon_sym_volatile] = ACTIONS(1168),
    [anon_sym_restrict] = ACTIONS(1168),
    [anon_sym___restrict__] = ACTIONS(1168),
    [anon_sym__Atomic] = ACTIONS(1168),
    [anon_sym__Noreturn] = ACTIONS(1168),
    [anon_sym_noreturn] = ACTIONS(1168),
    [sym_primitive_type] = ACTIONS(1168),
    [anon_sym_enum] = ACTIONS(1168),
    [anon_sym_struct] = ACTIONS(1168),
    [anon_sym_union] = ACTIONS(1168),
    [anon_sym_if] = ACTIONS(1168),
    [anon_sym_else] = ACTIONS(1168),
    [anon_sym_switch] = ACTIONS(1168),
    [anon_sym_case] = ACTIONS(1168),
    [anon_sym_default] = ACTIONS(1168),
    [anon_sym_while] = ACTIONS(1168),
    [anon_sym_do] = ACTIONS(1168),
    [anon_sym_for] = ACTIONS(1168),
    [anon_sym_return] = ACTIONS(1168),
    [anon_sym_break] = ACTIONS(1168),
    [anon_sym_continue] = ACTIONS(1168),
    [anon_sym_goto] = ACTIONS(1168),
    [anon_sym___try] = ACTIONS(1168),
    [anon_sym___leave] = ACTIONS(1168),
    [anon_sym_DASH_DASH] = ACTIONS(1170),
    [anon_sym_PLUS_PLUS] = ACTIONS(1170),
    [anon_sym_sizeof] = ACTIONS(1168),
    [anon_sym___alignof__] = ACTIONS(1168),
    [anon_sym___alignof] = ACTIONS(1168),
    [anon_sym__alignof] = ACTIONS(1168),
    [anon_sym_alignof] = ACTIONS(1168),
    [anon_sym__Alignof] = ACTIONS(1168),
    [anon_sym_offsetof] = ACTIONS(1168),
    [anon_sym__Generic] = ACTIONS(1168),
    [anon_sym_asm] = ACTIONS(1168),
    [anon_sym___asm__] = ACTIONS(1168),
    [sym_number_literal] = ACTIONS(1170),
    [anon_sym_L_SQUOTE] = ACTIONS(1170),
    [anon_sym_u_SQUOTE] = ACTIONS(1170),
    [anon_sym_U_SQUOTE] = ACTIONS(1170),
    [anon_sym_u8_SQUOTE] = ACTIONS(1170),
    [anon_sym_SQUOTE] = ACTIONS(1170),
    [anon_sym_L_DQUOTE] = ACTIONS(1170),
    [anon_sym_u_DQUOTE] = ACTIONS(1170),
    [anon_sym_U_DQUOTE] = ACTIONS(1170),
    [anon_sym_u8_DQUOTE] = ACTIONS(1170),
    [anon_sym_DQUOTE] = ACTIONS(1170),
    [sym_true] = ACTIONS(1168),
    [sym_false] = ACTIONS(1168),
    [anon_sym_NULL] = ACTIONS(1168),
    [anon_sym_nullptr] = ACTIONS(1168),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(1130),
    [sym_identifier] = ACTIONS(1128),
    [aux_sym_preproc_include_token1] = ACTIONS(1128),
    [aux_sym_preproc_def_token1] = ACTIONS(1128),
    [anon_sym_COMMA] = ACTIONS(1130),
    [anon_sym_RPAREN] = ACTIONS(1130),
    [aux_sym_preproc_if_token1] = ACTIONS(1128),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1128),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1128),
    [sym_preproc_directive] = ACTIONS(1128),
    [anon_sym_LPAREN2] = ACTIONS(1130),
    [anon_sym_BANG] = ACTIONS(1130),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_STAR] = ACTIONS(1130),
    [anon_sym_AMP] = ACTIONS(1130),
    [anon_sym_SEMI] = ACTIONS(1130),
    [anon_sym___extension__] = ACTIONS(1128),
    [anon_sym_typedef] = ACTIONS(1128),
    [anon_sym_extern] = ACTIONS(1128),
    [anon_sym___attribute__] = ACTIONS(1128),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1130),
    [anon_sym___declspec] = ACTIONS(1128),
    [anon_sym___cdecl] = ACTIONS(1128),
    [anon_sym___clrcall] = ACTIONS(1128),
    [anon_sym___stdcall] = ACTIONS(1128),
    [anon_sym___fastcall] = ACTIONS(1128),
    [anon_sym___thiscall] = ACTIONS(1128),
    [anon_sym___vectorcall] = ACTIONS(1128),
    [anon_sym_LBRACE] = ACTIONS(1130),
    [anon_sym_signed] = ACTIONS(1128),
    [anon_sym_unsigned] = ACTIONS(1128),
    [anon_sym_long] = ACTIONS(1128),
    [anon_sym_short] = ACTIONS(1128),
    [anon_sym_static] = ACTIONS(1128),
    [anon_sym_auto] = ACTIONS(1128),
    [anon_sym_register] = ACTIONS(1128),
    [anon_sym_inline] = ACTIONS(1128),
    [anon_sym___inline] = ACTIONS(1128),
    [anon_sym___inline__] = ACTIONS(1128),
    [anon_sym___forceinline] = ACTIONS(1128),
    [anon_sym_thread_local] = ACTIONS(1128),
    [anon_sym___thread] = ACTIONS(1128),
    [anon_sym_const] = ACTIONS(1128),
    [anon_sym_constexpr] = ACTIONS(1128),
    [anon_sym_volatile] = ACTIONS(1128),
    [anon_sym_restrict] = ACTIONS(1128),
    [anon_sym___restrict__] = ACTIONS(1128),
    [anon_sym__Atomic] = ACTIONS(1128),
    [anon_sym__Noreturn] = ACTIONS(1128),
    [anon_sym_noreturn] = ACTIONS(1128),
    [sym_primitive_type] = ACTIONS(1128),
    [anon_sym_enum] = ACTIONS(1128),
    [anon_sym_struct] = ACTIONS(1128),
    [anon_sym_union] = ACTIONS(1128),
    [anon_sym_if] = ACTIONS(1128),
    [anon_sym_else] = ACTIONS(1128),
    [anon_sym_switch] = ACTIONS(1128),
    [anon_sym_case] = ACTIONS(1128),
    [anon_sym_default] = ACTIONS(1128),
    [anon_sym_while] = ACTIONS(1128),
    [anon_sym_do] = ACTIONS(1128),
    [anon_sym_for] = ACTIONS(1128),
    [anon_sym_return] = ACTIONS(1128),
    [anon_sym_break] = ACTIONS(1128),
    [anon_sym_continue] = ACTIONS(1128),
    [anon_sym_goto] = ACTIONS(1128),
    [anon_sym___try] = ACTIONS(1128),
    [anon_sym___except] = ACTIONS(1128),
    [anon_sym___finally] = ACTIONS(1128),
    [anon_sym___leave] = ACTIONS(1128),
    [anon_sym_DASH_DASH] = ACTIONS(1130),
    [anon_sym_PLUS_PLUS] = ACTIONS(1130),
    [anon_sym_sizeof] = ACTIONS(1128),
    [anon_sym___alignof__] = ACTIONS(1128),
    [anon_sym___alignof] = ACTIONS(1128),
    [anon_sym__alignof] = ACTIONS(1128),
    [anon_sym_alignof] = ACTIONS(1128),
    [anon_sym__Alignof] = ACTIONS(1128),
    [anon_sym_offsetof] = ACTIONS(1128),
    [anon_sym__Generic] = ACTIONS(1128),
    [anon_sym_asm] = ACTIONS(1128),
    [anon_sym___asm__] = ACTIONS(1128),
    [sym_number_literal] = ACTIONS(1130),
    [anon_sym_L_SQUOTE] = ACTIONS(1130),
    [anon_sym_u_SQUOTE] = ACTIONS(1130),
    [anon_sym_U_SQUOTE] = ACTIONS(1130),
    [anon_sym_u8_SQUOTE] = ACTIONS(1130),
    [anon_sym_SQUOTE] = ACTIONS(1130),
    [anon_sym_L_DQUOTE] = ACTIONS(1130),
    [anon_sym_u_DQUOTE] = ACTIONS(1130),
    [anon_sym_U_DQUOTE] = ACTIONS(1130),
    [anon_sym_u8_DQUOTE] = ACTIONS(1130),
    [anon_sym_DQUOTE] = ACTIONS(1130),
    [sym_true] = ACTIONS(1128),
    [sym_false] = ACTIONS(1128),
    [anon_sym_NULL] = ACTIONS(1128),
    [anon_sym_nullptr] = ACTIONS(1128),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_identifier] = ACTIONS(1168),
    [aux_sym_preproc_include_token1] = ACTIONS(1168),
    [aux_sym_preproc_def_token1] = ACTIONS(1168),
    [aux_sym_preproc_if_token1] = ACTIONS(1168),
    [aux_sym_preproc_if_token2] = ACTIONS(1168),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1168),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1168),
    [aux_sym_preproc_else_token1] = ACTIONS(1168),
    [aux_sym_preproc_elif_token1] = ACTIONS(1168),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1168),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1168),
    [sym_preproc_directive] = ACTIONS(1168),
    [anon_sym_LPAREN2] = ACTIONS(1170),
    [anon_sym_BANG] = ACTIONS(1170),
    [anon_sym_TILDE] = ACTIONS(1170),
    [anon_sym_DASH] = ACTIONS(1168),
    [anon_sym_PLUS] = ACTIONS(1168),
    [anon_sym_STAR] = ACTIONS(1170),
    [anon_sym_AMP] = ACTIONS(1170),
    [anon_sym_SEMI] = ACTIONS(1170),
    [anon_sym___extension__] = ACTIONS(1168),
    [anon_sym_typedef] = ACTIONS(1168),
    [anon_sym_extern] = ACTIONS(1168),
    [anon_sym___attribute__] = ACTIONS(1168),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1170),
    [anon_sym___declspec] = ACTIONS(1168),
    [anon_sym___cdecl] = ACTIONS(1168),
    [anon_sym___clrcall] = ACTIONS(1168),
    [anon_sym___stdcall] = ACTIONS(1168),
    [anon_sym___fastcall] = ACTIONS(1168),
    [anon_sym___thiscall] = ACTIONS(1168),
    [anon_sym___vectorcall] = ACTIONS(1168),
    [anon_sym_LBRACE] = ACTIONS(1170),
    [anon_sym_signed] = ACTIONS(1168),
    [anon_sym_unsigned] = ACTIONS(1168),
    [anon_sym_long] = ACTIONS(1168),
    [anon_sym_short] = ACTIONS(1168),
    [anon_sym_static] = ACTIONS(1168),
    [anon_sym_auto] = ACTIONS(1168),
    [anon_sym_register] = ACTIONS(1168),
    [anon_sym_inline] = ACTIONS(1168),
    [anon_sym___inline] = ACTIONS(1168),
    [anon_sym___inline__] = ACTIONS(1168),
    [anon_sym___forceinline] = ACTIONS(1168),
    [anon_sym_thread_local] = ACTIONS(1168),
    [anon_sym___thread] = ACTIONS(1168),
    [anon_sym_const] = ACTIONS(1168),
    [anon_sym_constexpr] = ACTIONS(1168),
    [anon_sym_volatile] = ACTIONS(1168),
    [anon_sym_restrict] = ACTIONS(1168),
    [anon_sym___restrict__] = ACTIONS(1168),
    [anon_sym__Atomic] = ACTIONS(1168),
    [anon_sym__Noreturn] = ACTIONS(1168),
    [anon_sym_noreturn] = ACTIONS(1168),
    [sym_primitive_type] = ACTIONS(1168),
    [anon_sym_enum] = ACTIONS(1168),
    [anon_sym_struct] = ACTIONS(1168),
    [anon_sym_union] = ACTIONS(1168),
    [anon_sym_if] = ACTIONS(1168),
    [anon_sym_else] = ACTIONS(1168),
    [anon_sym_switch] = ACTIONS(1168),
    [anon_sym_case] = ACTIONS(1168),
    [anon_sym_default] = ACTIONS(1168),
    [anon_sym_while] = ACTIONS(1168),
    [anon_sym_do] = ACTIONS(1168),
    [anon_sym_for] = ACTIONS(1168),
    [anon_sym_return] = ACTIONS(1168),
    [anon_sym_break] = ACTIONS(1168),
    [anon_sym_continue] = ACTIONS(1168),
    [anon_sym_goto] = ACTIONS(1168),
    [anon_sym___try] = ACTIONS(1168),
    [anon_sym___leave] = ACTIONS(1168),
    [anon_sym_DASH_DASH] = ACTIONS(1170),
    [anon_sym_PLUS_PLUS] = ACTIONS(1170),
    [anon_sym_sizeof] = ACTIONS(1168),
    [anon_sym___alignof__] = ACTIONS(1168),
    [anon_sym___alignof] = ACTIONS(1168),
    [anon_sym__alignof] = ACTIONS(1168),
    [anon_sym_alignof] = ACTIONS(1168),
    [anon_sym__Alignof] = ACTIONS(1168),
    [anon_sym_offsetof] = ACTIONS(1168),
    [anon_sym__Generic] = ACTIONS(1168),
    [anon_sym_asm] = ACTIONS(1168),
    [anon_sym___asm__] = ACTIONS(1168),
    [sym_number_literal] = ACTIONS(1170),
    [anon_sym_L_SQUOTE] = ACTIONS(1170),
    [anon_sym_u_SQUOTE] = ACTIONS(1170),
    [anon_sym_U_SQUOTE] = ACTIONS(1170),
    [anon_sym_u8_SQUOTE] = ACTIONS(1170),
    [anon_sym_SQUOTE] = ACTIONS(1170),
    [anon_sym_L_DQUOTE] = ACTIONS(1170),
    [anon_sym_u_DQUOTE] = ACTIONS(1170),
    [anon_sym_U_DQUOTE] = ACTIONS(1170),
    [anon_sym_u8_DQUOTE] = ACTIONS(1170),
    [anon_sym_DQUOTE] = ACTIONS(1170),
    [sym_true] = ACTIONS(1168),
    [sym_false] = ACTIONS(1168),
    [anon_sym_NULL] = ACTIONS(1168),
    [anon_sym_nullptr] = ACTIONS(1168),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_identifier] = ACTIONS(1172),
    [aux_sym_preproc_include_token1] = ACTIONS(1172),
    [aux_sym_preproc_def_token1] = ACTIONS(1172),
    [aux_sym_preproc_if_token1] = ACTIONS(1172),
    [aux_sym_preproc_if_token2] = ACTIONS(1172),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1172),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1172),
    [aux_sym_preproc_else_token1] = ACTIONS(1172),
    [aux_sym_preproc_elif_token1] = ACTIONS(1172),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1172),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1172),
    [sym_preproc_directive] = ACTIONS(1172),
    [anon_sym_LPAREN2] = ACTIONS(1174),
    [anon_sym_BANG] = ACTIONS(1174),
    [anon_sym_TILDE] = ACTIONS(1174),
    [anon_sym_DASH] = ACTIONS(1172),
    [anon_sym_PLUS] = ACTIONS(1172),
    [anon_sym_STAR] = ACTIONS(1174),
    [anon_sym_AMP] = ACTIONS(1174),
    [anon_sym_SEMI] = ACTIONS(1174),
    [anon_sym___extension__] = ACTIONS(1172),
    [anon_sym_typedef] = ACTIONS(1172),
    [anon_sym_extern] = ACTIONS(1172),
    [anon_sym___attribute__] = ACTIONS(1172),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1174),
    [anon_sym___declspec] = ACTIONS(1172),
    [anon_sym___cdecl] = ACTIONS(1172),
    [anon_sym___clrcall] = ACTIONS(1172),
    [anon_sym___stdcall] = ACTIONS(1172),
    [anon_sym___fastcall] = ACTIONS(1172),
    [anon_sym___thiscall] = ACTIONS(1172),
    [anon_sym___vectorcall] = ACTIONS(1172),
    [anon_sym_LBRACE] = ACTIONS(1174),
    [anon_sym_signed] = ACTIONS(1172),
    [anon_sym_unsigned] = ACTIONS(1172),
    [anon_sym_long] = ACTIONS(1172),
    [anon_sym_short] = ACTIONS(1172),
    [anon_sym_static] = ACTIONS(1172),
    [anon_sym_auto] = ACTIONS(1172),
    [anon_sym_register] = ACTIONS(1172),
    [anon_sym_inline] = ACTIONS(1172),
    [anon_sym___inline] = ACTIONS(1172),
    [anon_sym___inline__] = ACTIONS(1172),
    [anon_sym___forceinline] = ACTIONS(1172),
    [anon_sym_thread_local] = ACTIONS(1172),
    [anon_sym___thread] = ACTIONS(1172),
    [anon_sym_const] = ACTIONS(1172),
    [anon_sym_constexpr] = ACTIONS(1172),
    [anon_sym_volatile] = ACTIONS(1172),
    [anon_sym_restrict] = ACTIONS(1172),
    [anon_sym___restrict__] = ACTIONS(1172),
    [anon_sym__Atomic] = ACTIONS(1172),
    [anon_sym__Noreturn] = ACTIONS(1172),
    [anon_sym_noreturn] = ACTIONS(1172),
    [sym_primitive_type] = ACTIONS(1172),
    [anon_sym_enum] = ACTIONS(1172),
    [anon_sym_struct] = ACTIONS(1172),
    [anon_sym_union] = ACTIONS(1172),
    [anon_sym_if] = ACTIONS(1172),
    [anon_sym_else] = ACTIONS(1172),
    [anon_sym_switch] = ACTIONS(1172),
    [anon_sym_case] = ACTIONS(1172),
    [anon_sym_default] = ACTIONS(1172),
    [anon_sym_while] = ACTIONS(1172),
    [anon_sym_do] = ACTIONS(1172),
    [anon_sym_for] = ACTIONS(1172),
    [anon_sym_return] = ACTIONS(1172),
    [anon_sym_break] = ACTIONS(1172),
    [anon_sym_continue] = ACTIONS(1172),
    [anon_sym_goto] = ACTIONS(1172),
    [anon_sym___try] = ACTIONS(1172),
    [anon_sym___leave] = ACTIONS(1172),
    [anon_sym_DASH_DASH] = ACTIONS(1174),
    [anon_sym_PLUS_PLUS] = ACTIONS(1174),
    [anon_sym_sizeof] = ACTIONS(1172),
    [anon_sym___alignof__] = ACTIONS(1172),
    [anon_sym___alignof] = ACTIONS(1172),
    [anon_sym__alignof] = ACTIONS(1172),
    [anon_sym_alignof] = ACTIONS(1172),
    [anon_sym__Alignof] = ACTIONS(1172),
    [anon_sym_offsetof] = ACTIONS(1172),
    [anon_sym__Generic] = ACTIONS(1172),
    [anon_sym_asm] = ACTIONS(1172),
    [anon_sym___asm__] = ACTIONS(1172),
    [sym_number_literal] = ACTIONS(1174),
    [anon_sym_L_SQUOTE] = ACTIONS(1174),
    [anon_sym_u_SQUOTE] = ACTIONS(1174),
    [anon_sym_U_SQUOTE] = ACTIONS(1174),
    [anon_sym_u8_SQUOTE] = ACTIONS(1174),
    [anon_sym_SQUOTE] = ACTIONS(1174),
    [anon_sym_L_DQUOTE] = ACTIONS(1174),
    [anon_sym_u_DQUOTE] = ACTIONS(1174),
    [anon_sym_U_DQUOTE] = ACTIONS(1174),
    [anon_sym_u8_DQUOTE] = ACTIONS(1174),
    [anon_sym_DQUOTE] = ACTIONS(1174),
    [sym_true] = ACTIONS(1172),
    [sym_false] = ACTIONS(1172),
    [anon_sym_NULL] = ACTIONS(1172),
    [anon_sym_nullptr] = ACTIONS(1172),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_identifier] = ACTIONS(1176),
    [aux_sym_preproc_include_token1] = ACTIONS(1176),
    [aux_sym_preproc_def_token1] = ACTIONS(1176),
    [aux_sym_preproc_if_token1] = ACTIONS(1176),
    [aux_sym_preproc_if_token2] = ACTIONS(1176),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1176),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1176),
    [aux_sym_preproc_else_token1] = ACTIONS(1176),
    [aux_sym_preproc_elif_token1] = ACTIONS(1176),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1176),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1176),
    [sym_preproc_directive] = ACTIONS(1176),
    [anon_sym_LPAREN2] = ACTIONS(1178),
    [anon_sym_BANG] = ACTIONS(1178),
    [anon_sym_TILDE] = ACTIONS(1178),
    [anon_sym_DASH] = ACTIONS(1176),
    [anon_sym_PLUS] = ACTIONS(1176),
    [anon_sym_STAR] = ACTIONS(1178),
    [anon_sym_AMP] = ACTIONS(1178),
    [anon_sym_SEMI] = ACTIONS(1178),
    [anon_sym___extension__] = ACTIONS(1176),
    [anon_sym_typedef] = ACTIONS(1176),
    [anon_sym_extern] = ACTIONS(1176),
    [anon_sym___attribute__] = ACTIONS(1176),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1178),
    [anon_sym___declspec] = ACTIONS(1176),
    [anon_sym___cdecl] = ACTIONS(1176),
    [anon_sym___clrcall] = ACTIONS(1176),
    [anon_sym___stdcall] = ACTIONS(1176),
    [anon_sym___fastcall] = ACTIONS(1176),
    [anon_sym___thiscall] = ACTIONS(1176),
    [anon_sym___vectorcall] = ACTIONS(1176),
    [anon_sym_LBRACE] = ACTIONS(1178),
    [anon_sym_signed] = ACTIONS(1176),
    [anon_sym_unsigned] = ACTIONS(1176),
    [anon_sym_long] = ACTIONS(1176),
    [anon_sym_short] = ACTIONS(1176),
    [anon_sym_static] = ACTIONS(1176),
    [anon_sym_auto] = ACTIONS(1176),
    [anon_sym_register] = ACTIONS(1176),
    [anon_sym_inline] = ACTIONS(1176),
    [anon_sym___inline] = ACTIONS(1176),
    [anon_sym___inline__] = ACTIONS(1176),
    [anon_sym___forceinline] = ACTIONS(1176),
    [anon_sym_thread_local] = ACTIONS(1176),
    [anon_sym___thread] = ACTIONS(1176),
    [anon_sym_const] = ACTIONS(1176),
    [anon_sym_constexpr] = ACTIONS(1176),
    [anon_sym_volatile] = ACTIONS(1176),
    [anon_sym_restrict] = ACTIONS(1176),
    [anon_sym___restrict__] = ACTIONS(1176),
    [anon_sym__Atomic] = ACTIONS(1176),
    [anon_sym__Noreturn] = ACTIONS(1176),
    [anon_sym_noreturn] = ACTIONS(1176),
    [sym_primitive_type] = ACTIONS(1176),
    [anon_sym_enum] = ACTIONS(1176),
    [anon_sym_struct] = ACTIONS(1176),
    [anon_sym_union] = ACTIONS(1176),
    [anon_sym_if] = ACTIONS(1176),
    [anon_sym_else] = ACTIONS(1176),
    [anon_sym_switch] = ACTIONS(1176),
    [anon_sym_case] = ACTIONS(1176),
    [anon_sym_default] = ACTIONS(1176),
    [anon_sym_while] = ACTIONS(1176),
    [anon_sym_do] = ACTIONS(1176),
    [anon_sym_for] = ACTIONS(1176),
    [anon_sym_return] = ACTIONS(1176),
    [anon_sym_break] = ACTIONS(1176),
    [anon_sym_continue] = ACTIONS(1176),
    [anon_sym_goto] = ACTIONS(1176),
    [anon_sym___try] = ACTIONS(1176),
    [anon_sym___leave] = ACTIONS(1176),
    [anon_sym_DASH_DASH] = ACTIONS(1178),
    [anon_sym_PLUS_PLUS] = ACTIONS(1178),
    [anon_sym_sizeof] = ACTIONS(1176),
    [anon_sym___alignof__] = ACTIONS(1176),
    [anon_sym___alignof] = ACTIONS(1176),
    [anon_sym__alignof] = ACTIONS(1176),
    [anon_sym_alignof] = ACTIONS(1176),
    [anon_sym__Alignof] = ACTIONS(1176),
    [anon_sym_offsetof] = ACTIONS(1176),
    [anon_sym__Generic] = ACTIONS(1176),
    [anon_sym_asm] = ACTIONS(1176),
    [anon_sym___asm__] = ACTIONS(1176),
    [sym_number_literal] = ACTIONS(1178),
    [anon_sym_L_SQUOTE] = ACTIONS(1178),
    [anon_sym_u_SQUOTE] = ACTIONS(1178),
    [anon_sym_U_SQUOTE] = ACTIONS(1178),
    [anon_sym_u8_SQUOTE] = ACTIONS(1178),
    [anon_sym_SQUOTE] = ACTIONS(1178),
    [anon_sym_L_DQUOTE] = ACTIONS(1178),
    [anon_sym_u_DQUOTE] = ACTIONS(1178),
    [anon_sym_U_DQUOTE] = ACTIONS(1178),
    [anon_sym_u8_DQUOTE] = ACTIONS(1178),
    [anon_sym_DQUOTE] = ACTIONS(1178),
    [sym_true] = ACTIONS(1176),
    [sym_false] = ACTIONS(1176),
    [anon_sym_NULL] = ACTIONS(1176),
    [anon_sym_nullptr] = ACTIONS(1176),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_identifier] = ACTIONS(1180),
    [aux_sym_preproc_include_token1] = ACTIONS(1180),
    [aux_sym_preproc_def_token1] = ACTIONS(1180),
    [aux_sym_preproc_if_token1] = ACTIONS(1180),
    [aux_sym_preproc_if_token2] = ACTIONS(1180),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1180),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1180),
    [aux_sym_preproc_else_token1] = ACTIONS(1180),
    [aux_sym_preproc_elif_token1] = ACTIONS(1180),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1180),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1180),
    [sym_preproc_directive] = ACTIONS(1180),
    [anon_sym_LPAREN2] = ACTIONS(1182),
    [anon_sym_BANG] = ACTIONS(1182),
    [anon_sym_TILDE] = ACTIONS(1182),
    [anon_sym_DASH] = ACTIONS(1180),
    [anon_sym_PLUS] = ACTIONS(1180),
    [anon_sym_STAR] = ACTIONS(1182),
    [anon_sym_AMP] = ACTIONS(1182),
    [anon_sym_SEMI] = ACTIONS(1182),
    [anon_sym___extension__] = ACTIONS(1180),
    [anon_sym_typedef] = ACTIONS(1180),
    [anon_sym_extern] = ACTIONS(1180),
    [anon_sym___attribute__] = ACTIONS(1180),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1182),
    [anon_sym___declspec] = ACTIONS(1180),
    [anon_sym___cdecl] = ACTIONS(1180),
    [anon_sym___clrcall] = ACTIONS(1180),
    [anon_sym___stdcall] = ACTIONS(1180),
    [anon_sym___fastcall] = ACTIONS(1180),
    [anon_sym___thiscall] = ACTIONS(1180),
    [anon_sym___vectorcall] = ACTIONS(1180),
    [anon_sym_LBRACE] = ACTIONS(1182),
    [anon_sym_signed] = ACTIONS(1180),
    [anon_sym_unsigned] = ACTIONS(1180),
    [anon_sym_long] = ACTIONS(1180),
    [anon_sym_short] = ACTIONS(1180),
    [anon_sym_static] = ACTIONS(1180),
    [anon_sym_auto] = ACTIONS(1180),
    [anon_sym_register] = ACTIONS(1180),
    [anon_sym_inline] = ACTIONS(1180),
    [anon_sym___inline] = ACTIONS(1180),
    [anon_sym___inline__] = ACTIONS(1180),
    [anon_sym___forceinline] = ACTIONS(1180),
    [anon_sym_thread_local] = ACTIONS(1180),
    [anon_sym___thread] = ACTIONS(1180),
    [anon_sym_const] = ACTIONS(1180),
    [anon_sym_constexpr] = ACTIONS(1180),
    [anon_sym_volatile] = ACTIONS(1180),
    [anon_sym_restrict] = ACTIONS(1180),
    [anon_sym___restrict__] = ACTIONS(1180),
    [anon_sym__Atomic] = ACTIONS(1180),
    [anon_sym__Noreturn] = ACTIONS(1180),
    [anon_sym_noreturn] = ACTIONS(1180),
    [sym_primitive_type] = ACTIONS(1180),
    [anon_sym_enum] = ACTIONS(1180),
    [anon_sym_struct] = ACTIONS(1180),
    [anon_sym_union] = ACTIONS(1180),
    [anon_sym_if] = ACTIONS(1180),
    [anon_sym_else] = ACTIONS(1180),
    [anon_sym_switch] = ACTIONS(1180),
    [anon_sym_case] = ACTIONS(1180),
    [anon_sym_default] = ACTIONS(1180),
    [anon_sym_while] = ACTIONS(1180),
    [anon_sym_do] = ACTIONS(1180),
    [anon_sym_for] = ACTIONS(1180),
    [anon_sym_return] = ACTIONS(1180),
    [anon_sym_break] = ACTIONS(1180),
    [anon_sym_continue] = ACTIONS(1180),
    [anon_sym_goto] = ACTIONS(1180),
    [anon_sym___try] = ACTIONS(1180),
    [anon_sym___leave] = ACTIONS(1180),
    [anon_sym_DASH_DASH] = ACTIONS(1182),
    [anon_sym_PLUS_PLUS] = ACTIONS(1182),
    [anon_sym_sizeof] = ACTIONS(1180),
    [anon_sym___alignof__] = ACTIONS(1180),
    [anon_sym___alignof] = ACTIONS(1180),
    [anon_sym__alignof] = ACTIONS(1180),
    [anon_sym_alignof] = ACTIONS(1180),
    [anon_sym__Alignof] = ACTIONS(1180),
    [anon_sym_offsetof] = ACTIONS(1180),
    [anon_sym__Generic] = ACTIONS(1180),
    [anon_sym_asm] = ACTIONS(1180),
    [anon_sym___asm__] = ACTIONS(1180),
    [sym_number_literal] = ACTIONS(1182),
    [anon_sym_L_SQUOTE] = ACTIONS(1182),
    [anon_sym_u_SQUOTE] = ACTIONS(1182),
    [anon_sym_U_SQUOTE] = ACTIONS(1182),
    [anon_sym_u8_SQUOTE] = ACTIONS(1182),
    [anon_sym_SQUOTE] = ACTIONS(1182),
    [anon_sym_L_DQUOTE] = ACTIONS(1182),
    [anon_sym_u_DQUOTE] = ACTIONS(1182),
    [anon_sym_U_DQUOTE] = ACTIONS(1182),
    [anon_sym_u8_DQUOTE] = ACTIONS(1182),
    [anon_sym_DQUOTE] = ACTIONS(1182),
    [sym_true] = ACTIONS(1180),
    [sym_false] = ACTIONS(1180),
    [anon_sym_NULL] = ACTIONS(1180),
    [anon_sym_nullptr] = ACTIONS(1180),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_identifier] = ACTIONS(1184),
    [aux_sym_preproc_include_token1] = ACTIONS(1184),
    [aux_sym_preproc_def_token1] = ACTIONS(1184),
    [aux_sym_preproc_if_token1] = ACTIONS(1184),
    [aux_sym_preproc_if_token2] = ACTIONS(1184),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1184),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1184),
    [aux_sym_preproc_else_token1] = ACTIONS(1184),
    [aux_sym_preproc_elif_token1] = ACTIONS(1184),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1184),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1184),
    [sym_preproc_directive] = ACTIONS(1184),
    [anon_sym_LPAREN2] = ACTIONS(1186),
    [anon_sym_BANG] = ACTIONS(1186),
    [anon_sym_TILDE] = ACTIONS(1186),
    [anon_sym_DASH] = ACTIONS(1184),
    [anon_sym_PLUS] = ACTIONS(1184),
    [anon_sym_STAR] = ACTIONS(1186),
    [anon_sym_AMP] = ACTIONS(1186),
    [anon_sym_SEMI] = ACTIONS(1186),
    [anon_sym___extension__] = ACTIONS(1184),
    [anon_sym_typedef] = ACTIONS(1184),
    [anon_sym_extern] = ACTIONS(1184),
    [anon_sym___attribute__] = ACTIONS(1184),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1186),
    [anon_sym___declspec] = ACTIONS(1184),
    [anon_sym___cdecl] = ACTIONS(1184),
    [anon_sym___clrcall] = ACTIONS(1184),
    [anon_sym___stdcall] = ACTIONS(1184),
    [anon_sym___fastcall] = ACTIONS(1184),
    [anon_sym___thiscall] = ACTIONS(1184),
    [anon_sym___vectorcall] = ACTIONS(1184),
    [anon_sym_LBRACE] = ACTIONS(1186),
    [anon_sym_signed] = ACTIONS(1184),
    [anon_sym_unsigned] = ACTIONS(1184),
    [anon_sym_long] = ACTIONS(1184),
    [anon_sym_short] = ACTIONS(1184),
    [anon_sym_static] = ACTIONS(1184),
    [anon_sym_auto] = ACTIONS(1184),
    [anon_sym_register] = ACTIONS(1184),
    [anon_sym_inline] = ACTIONS(1184),
    [anon_sym___inline] = ACTIONS(1184),
    [anon_sym___inline__] = ACTIONS(1184),
    [anon_sym___forceinline] = ACTIONS(1184),
    [anon_sym_thread_local] = ACTIONS(1184),
    [anon_sym___thread] = ACTIONS(1184),
    [anon_sym_const] = ACTIONS(1184),
    [anon_sym_constexpr] = ACTIONS(1184),
    [anon_sym_volatile] = ACTIONS(1184),
    [anon_sym_restrict] = ACTIONS(1184),
    [anon_sym___restrict__] = ACTIONS(1184),
    [anon_sym__Atomic] = ACTIONS(1184),
    [anon_sym__Noreturn] = ACTIONS(1184),
    [anon_sym_noreturn] = ACTIONS(1184),
    [sym_primitive_type] = ACTIONS(1184),
    [anon_sym_enum] = ACTIONS(1184),
    [anon_sym_struct] = ACTIONS(1184),
    [anon_sym_union] = ACTIONS(1184),
    [anon_sym_if] = ACTIONS(1184),
    [anon_sym_else] = ACTIONS(1184),
    [anon_sym_switch] = ACTIONS(1184),
    [anon_sym_case] = ACTIONS(1184),
    [anon_sym_default] = ACTIONS(1184),
    [anon_sym_while] = ACTIONS(1184),
    [anon_sym_do] = ACTIONS(1184),
    [anon_sym_for] = ACTIONS(1184),
    [anon_sym_return] = ACTIONS(1184),
    [anon_sym_break] = ACTIONS(1184),
    [anon_sym_continue] = ACTIONS(1184),
    [anon_sym_goto] = ACTIONS(1184),
    [anon_sym___try] = ACTIONS(1184),
    [anon_sym___leave] = ACTIONS(1184),
    [anon_sym_DASH_DASH] = ACTIONS(1186),
    [anon_sym_PLUS_PLUS] = ACTIONS(1186),
    [anon_sym_sizeof] = ACTIONS(1184),
    [anon_sym___alignof__] = ACTIONS(1184),
    [anon_sym___alignof] = ACTIONS(1184),
    [anon_sym__alignof] = ACTIONS(1184),
    [anon_sym_alignof] = ACTIONS(1184),
    [anon_sym__Alignof] = ACTIONS(1184),
    [anon_sym_offsetof] = ACTIONS(1184),
    [anon_sym__Generic] = ACTIONS(1184),
    [anon_sym_asm] = ACTIONS(1184),
    [anon_sym___asm__] = ACTIONS(1184),
    [sym_number_literal] = ACTIONS(1186),
    [anon_sym_L_SQUOTE] = ACTIONS(1186),
    [anon_sym_u_SQUOTE] = ACTIONS(1186),
    [anon_sym_U_SQUOTE] = ACTIONS(1186),
    [anon_sym_u8_SQUOTE] = ACTIONS(1186),
    [anon_sym_SQUOTE] = ACTIONS(1186),
    [anon_sym_L_DQUOTE] = ACTIONS(1186),
    [anon_sym_u_DQUOTE] = ACTIONS(1186),
    [anon_sym_U_DQUOTE] = ACTIONS(1186),
    [anon_sym_u8_DQUOTE] = ACTIONS(1186),
    [anon_sym_DQUOTE] = ACTIONS(1186),
    [sym_true] = ACTIONS(1184),
    [sym_false] = ACTIONS(1184),
    [anon_sym_NULL] = ACTIONS(1184),
    [anon_sym_nullptr] = ACTIONS(1184),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_identifier] = ACTIONS(1188),
    [aux_sym_preproc_include_token1] = ACTIONS(1188),
    [aux_sym_preproc_def_token1] = ACTIONS(1188),
    [aux_sym_preproc_if_token1] = ACTIONS(1188),
    [aux_sym_preproc_if_token2] = ACTIONS(1188),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1188),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1188),
    [aux_sym_preproc_else_token1] = ACTIONS(1188),
    [aux_sym_preproc_elif_token1] = ACTIONS(1188),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1188),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1188),
    [sym_preproc_directive] = ACTIONS(1188),
    [anon_sym_LPAREN2] = ACTIONS(1190),
    [anon_sym_BANG] = ACTIONS(1190),
    [anon_sym_TILDE] = ACTIONS(1190),
    [anon_sym_DASH] = ACTIONS(1188),
    [anon_sym_PLUS] = ACTIONS(1188),
    [anon_sym_STAR] = ACTIONS(1190),
    [anon_sym_AMP] = ACTIONS(1190),
    [anon_sym_SEMI] = ACTIONS(1190),
    [anon_sym___extension__] = ACTIONS(1188),
    [anon_sym_typedef] = ACTIONS(1188),
    [anon_sym_extern] = ACTIONS(1188),
    [anon_sym___attribute__] = ACTIONS(1188),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1190),
    [anon_sym___declspec] = ACTIONS(1188),
    [anon_sym___cdecl] = ACTIONS(1188),
    [anon_sym___clrcall] = ACTIONS(1188),
    [anon_sym___stdcall] = ACTIONS(1188),
    [anon_sym___fastcall] = ACTIONS(1188),
    [anon_sym___thiscall] = ACTIONS(1188),
    [anon_sym___vectorcall] = ACTIONS(1188),
    [anon_sym_LBRACE] = ACTIONS(1190),
    [anon_sym_signed] = ACTIONS(1188),
    [anon_sym_unsigned] = ACTIONS(1188),
    [anon_sym_long] = ACTIONS(1188),
    [anon_sym_short] = ACTIONS(1188),
    [anon_sym_static] = ACTIONS(1188),
    [anon_sym_auto] = ACTIONS(1188),
    [anon_sym_register] = ACTIONS(1188),
    [anon_sym_inline] = ACTIONS(1188),
    [anon_sym___inline] = ACTIONS(1188),
    [anon_sym___inline__] = ACTIONS(1188),
    [anon_sym___forceinline] = ACTIONS(1188),
    [anon_sym_thread_local] = ACTIONS(1188),
    [anon_sym___thread] = ACTIONS(1188),
    [anon_sym_const] = ACTIONS(1188),
    [anon_sym_constexpr] = ACTIONS(1188),
    [anon_sym_volatile] = ACTIONS(1188),
    [anon_sym_restrict] = ACTIONS(1188),
    [anon_sym___restrict__] = ACTIONS(1188),
    [anon_sym__Atomic] = ACTIONS(1188),
    [anon_sym__Noreturn] = ACTIONS(1188),
    [anon_sym_noreturn] = ACTIONS(1188),
    [sym_primitive_type] = ACTIONS(1188),
    [anon_sym_enum] = ACTIONS(1188),
    [anon_sym_struct] = ACTIONS(1188),
    [anon_sym_union] = ACTIONS(1188),
    [anon_sym_if] = ACTIONS(1188),
    [anon_sym_else] = ACTIONS(1188),
    [anon_sym_switch] = ACTIONS(1188),
    [anon_sym_case] = ACTIONS(1188),
    [anon_sym_default] = ACTIONS(1188),
    [anon_sym_while] = ACTIONS(1188),
    [anon_sym_do] = ACTIONS(1188),
    [anon_sym_for] = ACTIONS(1188),
    [anon_sym_return] = ACTIONS(1188),
    [anon_sym_break] = ACTIONS(1188),
    [anon_sym_continue] = ACTIONS(1188),
    [anon_sym_goto] = ACTIONS(1188),
    [anon_sym___try] = ACTIONS(1188),
    [anon_sym___leave] = ACTIONS(1188),
    [anon_sym_DASH_DASH] = ACTIONS(1190),
    [anon_sym_PLUS_PLUS] = ACTIONS(1190),
    [anon_sym_sizeof] = ACTIONS(1188),
    [anon_sym___alignof__] = ACTIONS(1188),
    [anon_sym___alignof] = ACTIONS(1188),
    [anon_sym__alignof] = ACTIONS(1188),
    [anon_sym_alignof] = ACTIONS(1188),
    [anon_sym__Alignof] = ACTIONS(1188),
    [anon_sym_offsetof] = ACTIONS(1188),
    [anon_sym__Generic] = ACTIONS(1188),
    [anon_sym_asm] = ACTIONS(1188),
    [anon_sym___asm__] = ACTIONS(1188),
    [sym_number_literal] = ACTIONS(1190),
    [anon_sym_L_SQUOTE] = ACTIONS(1190),
    [anon_sym_u_SQUOTE] = ACTIONS(1190),
    [anon_sym_U_SQUOTE] = ACTIONS(1190),
    [anon_sym_u8_SQUOTE] = ACTIONS(1190),
    [anon_sym_SQUOTE] = ACTIONS(1190),
    [anon_sym_L_DQUOTE] = ACTIONS(1190),
    [anon_sym_u_DQUOTE] = ACTIONS(1190),
    [anon_sym_U_DQUOTE] = ACTIONS(1190),
    [anon_sym_u8_DQUOTE] = ACTIONS(1190),
    [anon_sym_DQUOTE] = ACTIONS(1190),
    [sym_true] = ACTIONS(1188),
    [sym_false] = ACTIONS(1188),
    [anon_sym_NULL] = ACTIONS(1188),
    [anon_sym_nullptr] = ACTIONS(1188),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_identifier] = ACTIONS(1192),
    [aux_sym_preproc_include_token1] = ACTIONS(1192),
    [aux_sym_preproc_def_token1] = ACTIONS(1192),
    [aux_sym_preproc_if_token1] = ACTIONS(1192),
    [aux_sym_preproc_if_token2] = ACTIONS(1192),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1192),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1192),
    [aux_sym_preproc_else_token1] = ACTIONS(1192),
    [aux_sym_preproc_elif_token1] = ACTIONS(1192),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1192),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1192),
    [sym_preproc_directive] = ACTIONS(1192),
    [anon_sym_LPAREN2] = ACTIONS(1194),
    [anon_sym_BANG] = ACTIONS(1194),
    [anon_sym_TILDE] = ACTIONS(1194),
    [anon_sym_DASH] = ACTIONS(1192),
    [anon_sym_PLUS] = ACTIONS(1192),
    [anon_sym_STAR] = ACTIONS(1194),
    [anon_sym_AMP] = ACTIONS(1194),
    [anon_sym_SEMI] = ACTIONS(1194),
    [anon_sym___extension__] = ACTIONS(1192),
    [anon_sym_typedef] = ACTIONS(1192),
    [anon_sym_extern] = ACTIONS(1192),
    [anon_sym___attribute__] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym___declspec] = ACTIONS(1192),
    [anon_sym___cdecl] = ACTIONS(1192),
    [anon_sym___clrcall] = ACTIONS(1192),
    [anon_sym___stdcall] = ACTIONS(1192),
    [anon_sym___fastcall] = ACTIONS(1192),
    [anon_sym___thiscall] = ACTIONS(1192),
    [anon_sym___vectorcall] = ACTIONS(1192),
    [anon_sym_LBRACE] = ACTIONS(1194),
    [anon_sym_signed] = ACTIONS(1192),
    [anon_sym_unsigned] = ACTIONS(1192),
    [anon_sym_long] = ACTIONS(1192),
    [anon_sym_short] = ACTIONS(1192),
    [anon_sym_static] = ACTIONS(1192),
    [anon_sym_auto] = ACTIONS(1192),
    [anon_sym_register] = ACTIONS(1192),
    [anon_sym_inline] = ACTIONS(1192),
    [anon_sym___inline] = ACTIONS(1192),
    [anon_sym___inline__] = ACTIONS(1192),
    [anon_sym___forceinline] = ACTIONS(1192),
    [anon_sym_thread_local] = ACTIONS(1192),
    [anon_sym___thread] = ACTIONS(1192),
    [anon_sym_const] = ACTIONS(1192),
    [anon_sym_constexpr] = ACTIONS(1192),
    [anon_sym_volatile] = ACTIONS(1192),
    [anon_sym_restrict] = ACTIONS(1192),
    [anon_sym___restrict__] = ACTIONS(1192),
    [anon_sym__Atomic] = ACTIONS(1192),
    [anon_sym__Noreturn] = ACTIONS(1192),
    [anon_sym_noreturn] = ACTIONS(1192),
    [sym_primitive_type] = ACTIONS(1192),
    [anon_sym_enum] = ACTIONS(1192),
    [anon_sym_struct] = ACTIONS(1192),
    [anon_sym_union] = ACTIONS(1192),
    [anon_sym_if] = ACTIONS(1192),
    [anon_sym_else] = ACTIONS(1192),
    [anon_sym_switch] = ACTIONS(1192),
    [anon_sym_case] = ACTIONS(1192),
    [anon_sym_default] = ACTIONS(1192),
    [anon_sym_while] = ACTIONS(1192),
    [anon_sym_do] = ACTIONS(1192),
    [anon_sym_for] = ACTIONS(1192),
    [anon_sym_return] = ACTIONS(1192),
    [anon_sym_break] = ACTIONS(1192),
    [anon_sym_continue] = ACTIONS(1192),
    [anon_sym_goto] = ACTIONS(1192),
    [anon_sym___try] = ACTIONS(1192),
    [anon_sym___leave] = ACTIONS(1192),
    [anon_sym_DASH_DASH] = ACTIONS(1194),
    [anon_sym_PLUS_PLUS] = ACTIONS(1194),
    [anon_sym_sizeof] = ACTIONS(1192),
    [anon_sym___alignof__] = ACTIONS(1192),
    [anon_sym___alignof] = ACTIONS(1192),
    [anon_sym__alignof] = ACTIONS(1192),
    [anon_sym_alignof] = ACTIONS(1192),
    [anon_sym__Alignof] = ACTIONS(1192),
    [anon_sym_offsetof] = ACTIONS(1192),
    [anon_sym__Generic] = ACTIONS(1192),
    [anon_sym_asm] = ACTIONS(1192),
    [anon_sym___asm__] = ACTIONS(1192),
    [sym_number_literal] = ACTIONS(1194),
    [anon_sym_L_SQUOTE] = ACTIONS(1194),
    [anon_sym_u_SQUOTE] = ACTIONS(1194),
    [anon_sym_U_SQUOTE] = ACTIONS(1194),
    [anon_sym_u8_SQUOTE] = ACTIONS(1194),
    [anon_sym_SQUOTE] = ACTIONS(1194),
    [anon_sym_L_DQUOTE] = ACTIONS(1194),
    [anon_sym_u_DQUOTE] = ACTIONS(1194),
    [anon_sym_U_DQUOTE] = ACTIONS(1194),
    [anon_sym_u8_DQUOTE] = ACTIONS(1194),
    [anon_sym_DQUOTE] = ACTIONS(1194),
    [sym_true] = ACTIONS(1192),
    [sym_false] = ACTIONS(1192),
    [anon_sym_NULL] = ACTIONS(1192),
    [anon_sym_nullptr] = ACTIONS(1192),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_identifier] = ACTIONS(1176),
    [aux_sym_preproc_include_token1] = ACTIONS(1176),
    [aux_sym_preproc_def_token1] = ACTIONS(1176),
    [aux_sym_preproc_if_token1] = ACTIONS(1176),
    [aux_sym_preproc_if_token2] = ACTIONS(1176),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1176),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1176),
    [aux_sym_preproc_else_token1] = ACTIONS(1176),
    [aux_sym_preproc_elif_token1] = ACTIONS(1176),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1176),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1176),
    [sym_preproc_directive] = ACTIONS(1176),
    [anon_sym_LPAREN2] = ACTIONS(1178),
    [anon_sym_BANG] = ACTIONS(1178),
    [anon_sym_TILDE] = ACTIONS(1178),
    [anon_sym_DASH] = ACTIONS(1176),
    [anon_sym_PLUS] = ACTIONS(1176),
    [anon_sym_STAR] = ACTIONS(1178),
    [anon_sym_AMP] = ACTIONS(1178),
    [anon_sym_SEMI] = ACTIONS(1178),
    [anon_sym___extension__] = ACTIONS(1176),
    [anon_sym_typedef] = ACTIONS(1176),
    [anon_sym_extern] = ACTIONS(1176),
    [anon_sym___attribute__] = ACTIONS(1176),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1178),
    [anon_sym___declspec] = ACTIONS(1176),
    [anon_sym___cdecl] = ACTIONS(1176),
    [anon_sym___clrcall] = ACTIONS(1176),
    [anon_sym___stdcall] = ACTIONS(1176),
    [anon_sym___fastcall] = ACTIONS(1176),
    [anon_sym___thiscall] = ACTIONS(1176),
    [anon_sym___vectorcall] = ACTIONS(1176),
    [anon_sym_LBRACE] = ACTIONS(1178),
    [anon_sym_signed] = ACTIONS(1176),
    [anon_sym_unsigned] = ACTIONS(1176),
    [anon_sym_long] = ACTIONS(1176),
    [anon_sym_short] = ACTIONS(1176),
    [anon_sym_static] = ACTIONS(1176),
    [anon_sym_auto] = ACTIONS(1176),
    [anon_sym_register] = ACTIONS(1176),
    [anon_sym_inline] = ACTIONS(1176),
    [anon_sym___inline] = ACTIONS(1176),
    [anon_sym___inline__] = ACTIONS(1176),
    [anon_sym___forceinline] = ACTIONS(1176),
    [anon_sym_thread_local] = ACTIONS(1176),
    [anon_sym___thread] = ACTIONS(1176),
    [anon_sym_const] = ACTIONS(1176),
    [anon_sym_constexpr] = ACTIONS(1176),
    [anon_sym_volatile] = ACTIONS(1176),
    [anon_sym_restrict] = ACTIONS(1176),
    [anon_sym___restrict__] = ACTIONS(1176),
    [anon_sym__Atomic] = ACTIONS(1176),
    [anon_sym__Noreturn] = ACTIONS(1176),
    [anon_sym_noreturn] = ACTIONS(1176),
    [sym_primitive_type] = ACTIONS(1176),
    [anon_sym_enum] = ACTIONS(1176),
    [anon_sym_struct] = ACTIONS(1176),
    [anon_sym_union] = ACTIONS(1176),
    [anon_sym_if] = ACTIONS(1176),
    [anon_sym_else] = ACTIONS(1176),
    [anon_sym_switch] = ACTIONS(1176),
    [anon_sym_case] = ACTIONS(1176),
    [anon_sym_default] = ACTIONS(1176),
    [anon_sym_while] = ACTIONS(1176),
    [anon_sym_do] = ACTIONS(1176),
    [anon_sym_for] = ACTIONS(1176),
    [anon_sym_return] = ACTIONS(1176),
    [anon_sym_break] = ACTIONS(1176),
    [anon_sym_continue] = ACTIONS(1176),
    [anon_sym_goto] = ACTIONS(1176),
    [anon_sym___try] = ACTIONS(1176),
    [anon_sym___leave] = ACTIONS(1176),
    [anon_sym_DASH_DASH] = ACTIONS(1178),
    [anon_sym_PLUS_PLUS] = ACTIONS(1178),
    [anon_sym_sizeof] = ACTIONS(1176),
    [anon_sym___alignof__] = ACTIONS(1176),
    [anon_sym___alignof] = ACTIONS(1176),
    [anon_sym__alignof] = ACTIONS(1176),
    [anon_sym_alignof] = ACTIONS(1176),
    [anon_sym__Alignof] = ACTIONS(1176),
    [anon_sym_offsetof] = ACTIONS(1176),
    [anon_sym__Generic] = ACTIONS(1176),
    [anon_sym_asm] = ACTIONS(1176),
    [anon_sym___asm__] = ACTIONS(1176),
    [sym_number_literal] = ACTIONS(1178),
    [anon_sym_L_SQUOTE] = ACTIONS(1178),
    [anon_sym_u_SQUOTE] = ACTIONS(1178),
    [anon_sym_U_SQUOTE] = ACTIONS(1178),
    [anon_sym_u8_SQUOTE] = ACTIONS(1178),
    [anon_sym_SQUOTE] = ACTIONS(1178),
    [anon_sym_L_DQUOTE] = ACTIONS(1178),
    [anon_sym_u_DQUOTE] = ACTIONS(1178),
    [anon_sym_U_DQUOTE] = ACTIONS(1178),
    [anon_sym_u8_DQUOTE] = ACTIONS(1178),
    [anon_sym_DQUOTE] = ACTIONS(1178),
    [sym_true] = ACTIONS(1176),
    [sym_false] = ACTIONS(1176),
    [anon_sym_NULL] = ACTIONS(1176),
    [anon_sym_nullptr] = ACTIONS(1176),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_identifier] = ACTIONS(1196),
    [aux_sym_preproc_include_token1] = ACTIONS(1196),
    [aux_sym_preproc_def_token1] = ACTIONS(1196),
    [aux_sym_preproc_if_token1] = ACTIONS(1196),
    [aux_sym_preproc_if_token2] = ACTIONS(1196),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1196),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1196),
    [aux_sym_preproc_else_token1] = ACTIONS(1196),
    [aux_sym_preproc_elif_token1] = ACTIONS(1196),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1196),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1196),
    [sym_preproc_directive] = ACTIONS(1196),
    [anon_sym_LPAREN2] = ACTIONS(1198),
    [anon_sym_BANG] = ACTIONS(1198),
    [anon_sym_TILDE] = ACTIONS(1198),
    [anon_sym_DASH] = ACTIONS(1196),
    [anon_sym_PLUS] = ACTIONS(1196),
    [anon_sym_STAR] = ACTIONS(1198),
    [anon_sym_AMP] = ACTIONS(1198),
    [anon_sym_SEMI] = ACTIONS(1198),
    [anon_sym___extension__] = ACTIONS(1196),
    [anon_sym_typedef] = ACTIONS(1196),
    [anon_sym_extern] = ACTIONS(1196),
    [anon_sym___attribute__] = ACTIONS(1196),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1198),
    [anon_sym___declspec] = ACTIONS(1196),
    [anon_sym___cdecl] = ACTIONS(1196),
    [anon_sym___clrcall] = ACTIONS(1196),
    [anon_sym___stdcall] = ACTIONS(1196),
    [anon_sym___fastcall] = ACTIONS(1196),
    [anon_sym___thiscall] = ACTIONS(1196),
    [anon_sym___vectorcall] = ACTIONS(1196),
    [anon_sym_LBRACE] = ACTIONS(1198),
    [anon_sym_signed] = ACTIONS(1196),
    [anon_sym_unsigned] = ACTIONS(1196),
    [anon_sym_long] = ACTIONS(1196),
    [anon_sym_short] = ACTIONS(1196),
    [anon_sym_static] = ACTIONS(1196),
    [anon_sym_auto] = ACTIONS(1196),
    [anon_sym_register] = ACTIONS(1196),
    [anon_sym_inline] = ACTIONS(1196),
    [anon_sym___inline] = ACTIONS(1196),
    [anon_sym___inline__] = ACTIONS(1196),
    [anon_sym___forceinline] = ACTIONS(1196),
    [anon_sym_thread_local] = ACTIONS(1196),
    [anon_sym___thread] = ACTIONS(1196),
    [anon_sym_const] = ACTIONS(1196),
    [anon_sym_constexpr] = ACTIONS(1196),
    [anon_sym_volatile] = ACTIONS(1196),
    [anon_sym_restrict] = ACTIONS(1196),
    [anon_sym___restrict__] = ACTIONS(1196),
    [anon_sym__Atomic] = ACTIONS(1196),
    [anon_sym__Noreturn] = ACTIONS(1196),
    [anon_sym_noreturn] = ACTIONS(1196),
    [sym_primitive_type] = ACTIONS(1196),
    [anon_sym_enum] = ACTIONS(1196),
    [anon_sym_struct] = ACTIONS(1196),
    [anon_sym_union] = ACTIONS(1196),
    [anon_sym_if] = ACTIONS(1196),
    [anon_sym_else] = ACTIONS(1196),
    [anon_sym_switch] = ACTIONS(1196),
    [anon_sym_case] = ACTIONS(1196),
    [anon_sym_default] = ACTIONS(1196),
    [anon_sym_while] = ACTIONS(1196),
    [anon_sym_do] = ACTIONS(1196),
    [anon_sym_for] = ACTIONS(1196),
    [anon_sym_return] = ACTIONS(1196),
    [anon_sym_break] = ACTIONS(1196),
    [anon_sym_continue] = ACTIONS(1196),
    [anon_sym_goto] = ACTIONS(1196),
    [anon_sym___try] = ACTIONS(1196),
    [anon_sym___leave] = ACTIONS(1196),
    [anon_sym_DASH_DASH] = ACTIONS(1198),
    [anon_sym_PLUS_PLUS] = ACTIONS(1198),
    [anon_sym_sizeof] = ACTIONS(1196),
    [anon_sym___alignof__] = ACTIONS(1196),
    [anon_sym___alignof] = ACTIONS(1196),
    [anon_sym__alignof] = ACTIONS(1196),
    [anon_sym_alignof] = ACTIONS(1196),
    [anon_sym__Alignof] = ACTIONS(1196),
    [anon_sym_offsetof] = ACTIONS(1196),
    [anon_sym__Generic] = ACTIONS(1196),
    [anon_sym_asm] = ACTIONS(1196),
    [anon_sym___asm__] = ACTIONS(1196),
    [sym_number_literal] = ACTIONS(1198),
    [anon_sym_L_SQUOTE] = ACTIONS(1198),
    [anon_sym_u_SQUOTE] = ACTIONS(1198),
    [anon_sym_U_SQUOTE] = ACTIONS(1198),
    [anon_sym_u8_SQUOTE] = ACTIONS(1198),
    [anon_sym_SQUOTE] = ACTIONS(1198),
    [anon_sym_L_DQUOTE] = ACTIONS(1198),
    [anon_sym_u_DQUOTE] = ACTIONS(1198),
    [anon_sym_U_DQUOTE] = ACTIONS(1198),
    [anon_sym_u8_DQUOTE] = ACTIONS(1198),
    [anon_sym_DQUOTE] = ACTIONS(1198),
    [sym_true] = ACTIONS(1196),
    [sym_false] = ACTIONS(1196),
    [anon_sym_NULL] = ACTIONS(1196),
    [anon_sym_nullptr] = ACTIONS(1196),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_identifier] = ACTIONS(1200),
    [aux_sym_preproc_include_token1] = ACTIONS(1200),
    [aux_sym_preproc_def_token1] = ACTIONS(1200),
    [aux_sym_preproc_if_token1] = ACTIONS(1200),
    [aux_sym_preproc_if_token2] = ACTIONS(1200),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1200),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1200),
    [aux_sym_preproc_else_token1] = ACTIONS(1200),
    [aux_sym_preproc_elif_token1] = ACTIONS(1200),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1200),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1200),
    [sym_preproc_directive] = ACTIONS(1200),
    [anon_sym_LPAREN2] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(1202),
    [anon_sym_TILDE] = ACTIONS(1202),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1200),
    [anon_sym_STAR] = ACTIONS(1202),
    [anon_sym_AMP] = ACTIONS(1202),
    [anon_sym_SEMI] = ACTIONS(1202),
    [anon_sym___extension__] = ACTIONS(1200),
    [anon_sym_typedef] = ACTIONS(1200),
    [anon_sym_extern] = ACTIONS(1200),
    [anon_sym___attribute__] = ACTIONS(1200),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1202),
    [anon_sym___declspec] = ACTIONS(1200),
    [anon_sym___cdecl] = ACTIONS(1200),
    [anon_sym___clrcall] = ACTIONS(1200),
    [anon_sym___stdcall] = ACTIONS(1200),
    [anon_sym___fastcall] = ACTIONS(1200),
    [anon_sym___thiscall] = ACTIONS(1200),
    [anon_sym___vectorcall] = ACTIONS(1200),
    [anon_sym_LBRACE] = ACTIONS(1202),
    [anon_sym_signed] = ACTIONS(1200),
    [anon_sym_unsigned] = ACTIONS(1200),
    [anon_sym_long] = ACTIONS(1200),
    [anon_sym_short] = ACTIONS(1200),
    [anon_sym_static] = ACTIONS(1200),
    [anon_sym_auto] = ACTIONS(1200),
    [anon_sym_register] = ACTIONS(1200),
    [anon_sym_inline] = ACTIONS(1200),
    [anon_sym___inline] = ACTIONS(1200),
    [anon_sym___inline__] = ACTIONS(1200),
    [anon_sym___forceinline] = ACTIONS(1200),
    [anon_sym_thread_local] = ACTIONS(1200),
    [anon_sym___thread] = ACTIONS(1200),
    [anon_sym_const] = ACTIONS(1200),
    [anon_sym_constexpr] = ACTIONS(1200),
    [anon_sym_volatile] = ACTIONS(1200),
    [anon_sym_restrict] = ACTIONS(1200),
    [anon_sym___restrict__] = ACTIONS(1200),
    [anon_sym__Atomic] = ACTIONS(1200),
    [anon_sym__Noreturn] = ACTIONS(1200),
    [anon_sym_noreturn] = ACTIONS(1200),
    [sym_primitive_type] = ACTIONS(1200),
    [anon_sym_enum] = ACTIONS(1200),
    [anon_sym_struct] = ACTIONS(1200),
    [anon_sym_union] = ACTIONS(1200),
    [anon_sym_if] = ACTIONS(1200),
    [anon_sym_else] = ACTIONS(1200),
    [anon_sym_switch] = ACTIONS(1200),
    [anon_sym_case] = ACTIONS(1200),
    [anon_sym_default] = ACTIONS(1200),
    [anon_sym_while] = ACTIONS(1200),
    [anon_sym_do] = ACTIONS(1200),
    [anon_sym_for] = ACTIONS(1200),
    [anon_sym_return] = ACTIONS(1200),
    [anon_sym_break] = ACTIONS(1200),
    [anon_sym_continue] = ACTIONS(1200),
    [anon_sym_goto] = ACTIONS(1200),
    [anon_sym___try] = ACTIONS(1200),
    [anon_sym___leave] = ACTIONS(1200),
    [anon_sym_DASH_DASH] = ACTIONS(1202),
    [anon_sym_PLUS_PLUS] = ACTIONS(1202),
    [anon_sym_sizeof] = ACTIONS(1200),
    [anon_sym___alignof__] = ACTIONS(1200),
    [anon_sym___alignof] = ACTIONS(1200),
    [anon_sym__alignof] = ACTIONS(1200),
    [anon_sym_alignof] = ACTIONS(1200),
    [anon_sym__Alignof] = ACTIONS(1200),
    [anon_sym_offsetof] = ACTIONS(1200),
    [anon_sym__Generic] = ACTIONS(1200),
    [anon_sym_asm] = ACTIONS(1200),
    [anon_sym___asm__] = ACTIONS(1200),
    [sym_number_literal] = ACTIONS(1202),
    [anon_sym_L_SQUOTE] = ACTIONS(1202),
    [anon_sym_u_SQUOTE] = ACTIONS(1202),
    [anon_sym_U_SQUOTE] = ACTIONS(1202),
    [anon_sym_u8_SQUOTE] = ACTIONS(1202),
    [anon_sym_SQUOTE] = ACTIONS(1202),
    [anon_sym_L_DQUOTE] = ACTIONS(1202),
    [anon_sym_u_DQUOTE] = ACTIONS(1202),
    [anon_sym_U_DQUOTE] = ACTIONS(1202),
    [anon_sym_u8_DQUOTE] = ACTIONS(1202),
    [anon_sym_DQUOTE] = ACTIONS(1202),
    [sym_true] = ACTIONS(1200),
    [sym_false] = ACTIONS(1200),
    [anon_sym_NULL] = ACTIONS(1200),
    [anon_sym_nullptr] = ACTIONS(1200),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_identifier] = ACTIONS(1204),
    [aux_sym_preproc_include_token1] = ACTIONS(1204),
    [aux_sym_preproc_def_token1] = ACTIONS(1204),
    [aux_sym_preproc_if_token1] = ACTIONS(1204),
    [aux_sym_preproc_if_token2] = ACTIONS(1204),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1204),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1204),
    [aux_sym_preproc_else_token1] = ACTIONS(1204),
    [aux_sym_preproc_elif_token1] = ACTIONS(1204),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1204),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1204),
    [sym_preproc_directive] = ACTIONS(1204),
    [anon_sym_LPAREN2] = ACTIONS(1206),
    [anon_sym_BANG] = ACTIONS(1206),
    [anon_sym_TILDE] = ACTIONS(1206),
    [anon_sym_DASH] = ACTIONS(1204),
    [anon_sym_PLUS] = ACTIONS(1204),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_AMP] = ACTIONS(1206),
    [anon_sym_SEMI] = ACTIONS(1206),
    [anon_sym___extension__] = ACTIONS(1204),
    [anon_sym_typedef] = ACTIONS(1204),
    [anon_sym_extern] = ACTIONS(1204),
    [anon_sym___attribute__] = ACTIONS(1204),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1206),
    [anon_sym___declspec] = ACTIONS(1204),
    [anon_sym___cdecl] = ACTIONS(1204),
    [anon_sym___clrcall] = ACTIONS(1204),
    [anon_sym___stdcall] = ACTIONS(1204),
    [anon_sym___fastcall] = ACTIONS(1204),
    [anon_sym___thiscall] = ACTIONS(1204),
    [anon_sym___vectorcall] = ACTIONS(1204),
    [anon_sym_LBRACE] = ACTIONS(1206),
    [anon_sym_signed] = ACTIONS(1204),
    [anon_sym_unsigned] = ACTIONS(1204),
    [anon_sym_long] = ACTIONS(1204),
    [anon_sym_short] = ACTIONS(1204),
    [anon_sym_static] = ACTIONS(1204),
    [anon_sym_auto] = ACTIONS(1204),
    [anon_sym_register] = ACTIONS(1204),
    [anon_sym_inline] = ACTIONS(1204),
    [anon_sym___inline] = ACTIONS(1204),
    [anon_sym___inline__] = ACTIONS(1204),
    [anon_sym___forceinline] = ACTIONS(1204),
    [anon_sym_thread_local] = ACTIONS(1204),
    [anon_sym___thread] = ACTIONS(1204),
    [anon_sym_const] = ACTIONS(1204),
    [anon_sym_constexpr] = ACTIONS(1204),
    [anon_sym_volatile] = ACTIONS(1204),
    [anon_sym_restrict] = ACTIONS(1204),
    [anon_sym___restrict__] = ACTIONS(1204),
    [anon_sym__Atomic] = ACTIONS(1204),
    [anon_sym__Noreturn] = ACTIONS(1204),
    [anon_sym_noreturn] = ACTIONS(1204),
    [sym_primitive_type] = ACTIONS(1204),
    [anon_sym_enum] = ACTIONS(1204),
    [anon_sym_struct] = ACTIONS(1204),
    [anon_sym_union] = ACTIONS(1204),
    [anon_sym_if] = ACTIONS(1204),
    [anon_sym_else] = ACTIONS(1204),
    [anon_sym_switch] = ACTIONS(1204),
    [anon_sym_case] = ACTIONS(1204),
    [anon_sym_default] = ACTIONS(1204),
    [anon_sym_while] = ACTIONS(1204),
    [anon_sym_do] = ACTIONS(1204),
    [anon_sym_for] = ACTIONS(1204),
    [anon_sym_return] = ACTIONS(1204),
    [anon_sym_break] = ACTIONS(1204),
    [anon_sym_continue] = ACTIONS(1204),
    [anon_sym_goto] = ACTIONS(1204),
    [anon_sym___try] = ACTIONS(1204),
    [anon_sym___leave] = ACTIONS(1204),
    [anon_sym_DASH_DASH] = ACTIONS(1206),
    [anon_sym_PLUS_PLUS] = ACTIONS(1206),
    [anon_sym_sizeof] = ACTIONS(1204),
    [anon_sym___alignof__] = ACTIONS(1204),
    [anon_sym___alignof] = ACTIONS(1204),
    [anon_sym__alignof] = ACTIONS(1204),
    [anon_sym_alignof] = ACTIONS(1204),
    [anon_sym__Alignof] = ACTIONS(1204),
    [anon_sym_offsetof] = ACTIONS(1204),
    [anon_sym__Generic] = ACTIONS(1204),
    [anon_sym_asm] = ACTIONS(1204),
    [anon_sym___asm__] = ACTIONS(1204),
    [sym_number_literal] = ACTIONS(1206),
    [anon_sym_L_SQUOTE] = ACTIONS(1206),
    [anon_sym_u_SQUOTE] = ACTIONS(1206),
    [anon_sym_U_SQUOTE] = ACTIONS(1206),
    [anon_sym_u8_SQUOTE] = ACTIONS(1206),
    [anon_sym_SQUOTE] = ACTIONS(1206),
    [anon_sym_L_DQUOTE] = ACTIONS(1206),
    [anon_sym_u_DQUOTE] = ACTIONS(1206),
    [anon_sym_U_DQUOTE] = ACTIONS(1206),
    [anon_sym_u8_DQUOTE] = ACTIONS(1206),
    [anon_sym_DQUOTE] = ACTIONS(1206),
    [sym_true] = ACTIONS(1204),
    [sym_false] = ACTIONS(1204),
    [anon_sym_NULL] = ACTIONS(1204),
    [anon_sym_nullptr] = ACTIONS(1204),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_identifier] = ACTIONS(1208),
    [aux_sym_preproc_include_token1] = ACTIONS(1208),
    [aux_sym_preproc_def_token1] = ACTIONS(1208),
    [aux_sym_preproc_if_token1] = ACTIONS(1208),
    [aux_sym_preproc_if_token2] = ACTIONS(1208),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1208),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1208),
    [aux_sym_preproc_else_token1] = ACTIONS(1208),
    [aux_sym_preproc_elif_token1] = ACTIONS(1208),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1208),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1208),
    [sym_preproc_directive] = ACTIONS(1208),
    [anon_sym_LPAREN2] = ACTIONS(1210),
    [anon_sym_BANG] = ACTIONS(1210),
    [anon_sym_TILDE] = ACTIONS(1210),
    [anon_sym_DASH] = ACTIONS(1208),
    [anon_sym_PLUS] = ACTIONS(1208),
    [anon_sym_STAR] = ACTIONS(1210),
    [anon_sym_AMP] = ACTIONS(1210),
    [anon_sym_SEMI] = ACTIONS(1210),
    [anon_sym___extension__] = ACTIONS(1208),
    [anon_sym_typedef] = ACTIONS(1208),
    [anon_sym_extern] = ACTIONS(1208),
    [anon_sym___attribute__] = ACTIONS(1208),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1210),
    [anon_sym___declspec] = ACTIONS(1208),
    [anon_sym___cdecl] = ACTIONS(1208),
    [anon_sym___clrcall] = ACTIONS(1208),
    [anon_sym___stdcall] = ACTIONS(1208),
    [anon_sym___fastcall] = ACTIONS(1208),
    [anon_sym___thiscall] = ACTIONS(1208),
    [anon_sym___vectorcall] = ACTIONS(1208),
    [anon_sym_LBRACE] = ACTIONS(1210),
    [anon_sym_signed] = ACTIONS(1208),
    [anon_sym_unsigned] = ACTIONS(1208),
    [anon_sym_long] = ACTIONS(1208),
    [anon_sym_short] = ACTIONS(1208),
    [anon_sym_static] = ACTIONS(1208),
    [anon_sym_auto] = ACTIONS(1208),
    [anon_sym_register] = ACTIONS(1208),
    [anon_sym_inline] = ACTIONS(1208),
    [anon_sym___inline] = ACTIONS(1208),
    [anon_sym___inline__] = ACTIONS(1208),
    [anon_sym___forceinline] = ACTIONS(1208),
    [anon_sym_thread_local] = ACTIONS(1208),
    [anon_sym___thread] = ACTIONS(1208),
    [anon_sym_const] = ACTIONS(1208),
    [anon_sym_constexpr] = ACTIONS(1208),
    [anon_sym_volatile] = ACTIONS(1208),
    [anon_sym_restrict] = ACTIONS(1208),
    [anon_sym___restrict__] = ACTIONS(1208),
    [anon_sym__Atomic] = ACTIONS(1208),
    [anon_sym__Noreturn] = ACTIONS(1208),
    [anon_sym_noreturn] = ACTIONS(1208),
    [sym_primitive_type] = ACTIONS(1208),
    [anon_sym_enum] = ACTIONS(1208),
    [anon_sym_struct] = ACTIONS(1208),
    [anon_sym_union] = ACTIONS(1208),
    [anon_sym_if] = ACTIONS(1208),
    [anon_sym_else] = ACTIONS(1208),
    [anon_sym_switch] = ACTIONS(1208),
    [anon_sym_case] = ACTIONS(1208),
    [anon_sym_default] = ACTIONS(1208),
    [anon_sym_while] = ACTIONS(1208),
    [anon_sym_do] = ACTIONS(1208),
    [anon_sym_for] = ACTIONS(1208),
    [anon_sym_return] = ACTIONS(1208),
    [anon_sym_break] = ACTIONS(1208),
    [anon_sym_continue] = ACTIONS(1208),
    [anon_sym_goto] = ACTIONS(1208),
    [anon_sym___try] = ACTIONS(1208),
    [anon_sym___leave] = ACTIONS(1208),
    [anon_sym_DASH_DASH] = ACTIONS(1210),
    [anon_sym_PLUS_PLUS] = ACTIONS(1210),
    [anon_sym_sizeof] = ACTIONS(1208),
    [anon_sym___alignof__] = ACTIONS(1208),
    [anon_sym___alignof] = ACTIONS(1208),
    [anon_sym__alignof] = ACTIONS(1208),
    [anon_sym_alignof] = ACTIONS(1208),
    [anon_sym__Alignof] = ACTIONS(1208),
    [anon_sym_offsetof] = ACTIONS(1208),
    [anon_sym__Generic] = ACTIONS(1208),
    [anon_sym_asm] = ACTIONS(1208),
    [anon_sym___asm__] = ACTIONS(1208),
    [sym_number_literal] = ACTIONS(1210),
    [anon_sym_L_SQUOTE] = ACTIONS(1210),
    [anon_sym_u_SQUOTE] = ACTIONS(1210),
    [anon_sym_U_SQUOTE] = ACTIONS(1210),
    [anon_sym_u8_SQUOTE] = ACTIONS(1210),
    [anon_sym_SQUOTE] = ACTIONS(1210),
    [anon_sym_L_DQUOTE] = ACTIONS(1210),
    [anon_sym_u_DQUOTE] = ACTIONS(1210),
    [anon_sym_U_DQUOTE] = ACTIONS(1210),
    [anon_sym_u8_DQUOTE] = ACTIONS(1210),
    [anon_sym_DQUOTE] = ACTIONS(1210),
    [sym_true] = ACTIONS(1208),
    [sym_false] = ACTIONS(1208),
    [anon_sym_NULL] = ACTIONS(1208),
    [anon_sym_nullptr] = ACTIONS(1208),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_identifier] = ACTIONS(1200),
    [aux_sym_preproc_include_token1] = ACTIONS(1200),
    [aux_sym_preproc_def_token1] = ACTIONS(1200),
    [aux_sym_preproc_if_token1] = ACTIONS(1200),
    [aux_sym_preproc_if_token2] = ACTIONS(1200),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1200),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1200),
    [aux_sym_preproc_else_token1] = ACTIONS(1200),
    [aux_sym_preproc_elif_token1] = ACTIONS(1200),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1200),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1200),
    [sym_preproc_directive] = ACTIONS(1200),
    [anon_sym_LPAREN2] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(1202),
    [anon_sym_TILDE] = ACTIONS(1202),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1200),
    [anon_sym_STAR] = ACTIONS(1202),
    [anon_sym_AMP] = ACTIONS(1202),
    [anon_sym_SEMI] = ACTIONS(1202),
    [anon_sym___extension__] = ACTIONS(1200),
    [anon_sym_typedef] = ACTIONS(1200),
    [anon_sym_extern] = ACTIONS(1200),
    [anon_sym___attribute__] = ACTIONS(1200),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1202),
    [anon_sym___declspec] = ACTIONS(1200),
    [anon_sym___cdecl] = ACTIONS(1200),
    [anon_sym___clrcall] = ACTIONS(1200),
    [anon_sym___stdcall] = ACTIONS(1200),
    [anon_sym___fastcall] = ACTIONS(1200),
    [anon_sym___thiscall] = ACTIONS(1200),
    [anon_sym___vectorcall] = ACTIONS(1200),
    [anon_sym_LBRACE] = ACTIONS(1202),
    [anon_sym_signed] = ACTIONS(1200),
    [anon_sym_unsigned] = ACTIONS(1200),
    [anon_sym_long] = ACTIONS(1200),
    [anon_sym_short] = ACTIONS(1200),
    [anon_sym_static] = ACTIONS(1200),
    [anon_sym_auto] = ACTIONS(1200),
    [anon_sym_register] = ACTIONS(1200),
    [anon_sym_inline] = ACTIONS(1200),
    [anon_sym___inline] = ACTIONS(1200),
    [anon_sym___inline__] = ACTIONS(1200),
    [anon_sym___forceinline] = ACTIONS(1200),
    [anon_sym_thread_local] = ACTIONS(1200),
    [anon_sym___thread] = ACTIONS(1200),
    [anon_sym_const] = ACTIONS(1200),
    [anon_sym_constexpr] = ACTIONS(1200),
    [anon_sym_volatile] = ACTIONS(1200),
    [anon_sym_restrict] = ACTIONS(1200),
    [anon_sym___restrict__] = ACTIONS(1200),
    [anon_sym__Atomic] = ACTIONS(1200),
    [anon_sym__Noreturn] = ACTIONS(1200),
    [anon_sym_noreturn] = ACTIONS(1200),
    [sym_primitive_type] = ACTIONS(1200),
    [anon_sym_enum] = ACTIONS(1200),
    [anon_sym_struct] = ACTIONS(1200),
    [anon_sym_union] = ACTIONS(1200),
    [anon_sym_if] = ACTIONS(1200),
    [anon_sym_else] = ACTIONS(1200),
    [anon_sym_switch] = ACTIONS(1200),
    [anon_sym_case] = ACTIONS(1200),
    [anon_sym_default] = ACTIONS(1200),
    [anon_sym_while] = ACTIONS(1200),
    [anon_sym_do] = ACTIONS(1200),
    [anon_sym_for] = ACTIONS(1200),
    [anon_sym_return] = ACTIONS(1200),
    [anon_sym_break] = ACTIONS(1200),
    [anon_sym_continue] = ACTIONS(1200),
    [anon_sym_goto] = ACTIONS(1200),
    [anon_sym___try] = ACTIONS(1200),
    [anon_sym___leave] = ACTIONS(1200),
    [anon_sym_DASH_DASH] = ACTIONS(1202),
    [anon_sym_PLUS_PLUS] = ACTIONS(1202),
    [anon_sym_sizeof] = ACTIONS(1200),
    [anon_sym___alignof__] = ACTIONS(1200),
    [anon_sym___alignof] = ACTIONS(1200),
    [anon_sym__alignof] = ACTIONS(1200),
    [anon_sym_alignof] = ACTIONS(1200),
    [anon_sym__Alignof] = ACTIONS(1200),
    [anon_sym_offsetof] = ACTIONS(1200),
    [anon_sym__Generic] = ACTIONS(1200),
    [anon_sym_asm] = ACTIONS(1200),
    [anon_sym___asm__] = ACTIONS(1200),
    [sym_number_literal] = ACTIONS(1202),
    [anon_sym_L_SQUOTE] = ACTIONS(1202),
    [anon_sym_u_SQUOTE] = ACTIONS(1202),
    [anon_sym_U_SQUOTE] = ACTIONS(1202),
    [anon_sym_u8_SQUOTE] = ACTIONS(1202),
    [anon_sym_SQUOTE] = ACTIONS(1202),
    [anon_sym_L_DQUOTE] = ACTIONS(1202),
    [anon_sym_u_DQUOTE] = ACTIONS(1202),
    [anon_sym_U_DQUOTE] = ACTIONS(1202),
    [anon_sym_u8_DQUOTE] = ACTIONS(1202),
    [anon_sym_DQUOTE] = ACTIONS(1202),
    [sym_true] = ACTIONS(1200),
    [sym_false] = ACTIONS(1200),
    [anon_sym_NULL] = ACTIONS(1200),
    [anon_sym_nullptr] = ACTIONS(1200),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(1206),
    [sym_identifier] = ACTIONS(1204),
    [aux_sym_preproc_include_token1] = ACTIONS(1204),
    [aux_sym_preproc_def_token1] = ACTIONS(1204),
    [anon_sym_COMMA] = ACTIONS(1206),
    [anon_sym_RPAREN] = ACTIONS(1206),
    [aux_sym_preproc_if_token1] = ACTIONS(1204),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1204),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1204),
    [sym_preproc_directive] = ACTIONS(1204),
    [anon_sym_LPAREN2] = ACTIONS(1206),
    [anon_sym_BANG] = ACTIONS(1206),
    [anon_sym_TILDE] = ACTIONS(1206),
    [anon_sym_DASH] = ACTIONS(1204),
    [anon_sym_PLUS] = ACTIONS(1204),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_AMP] = ACTIONS(1206),
    [anon_sym_SEMI] = ACTIONS(1206),
    [anon_sym___extension__] = ACTIONS(1204),
    [anon_sym_typedef] = ACTIONS(1204),
    [anon_sym_extern] = ACTIONS(1204),
    [anon_sym___attribute__] = ACTIONS(1204),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1206),
    [anon_sym___declspec] = ACTIONS(1204),
    [anon_sym___cdecl] = ACTIONS(1204),
    [anon_sym___clrcall] = ACTIONS(1204),
    [anon_sym___stdcall] = ACTIONS(1204),
    [anon_sym___fastcall] = ACTIONS(1204),
    [anon_sym___thiscall] = ACTIONS(1204),
    [anon_sym___vectorcall] = ACTIONS(1204),
    [anon_sym_LBRACE] = ACTIONS(1206),
    [anon_sym_signed] = ACTIONS(1204),
    [anon_sym_unsigned] = ACTIONS(1204),
    [anon_sym_long] = ACTIONS(1204),
    [anon_sym_short] = ACTIONS(1204),
    [anon_sym_static] = ACTIONS(1204),
    [anon_sym_auto] = ACTIONS(1204),
    [anon_sym_register] = ACTIONS(1204),
    [anon_sym_inline] = ACTIONS(1204),
    [anon_sym___inline] = ACTIONS(1204),
    [anon_sym___inline__] = ACTIONS(1204),
    [anon_sym___forceinline] = ACTIONS(1204),
    [anon_sym_thread_local] = ACTIONS(1204),
    [anon_sym___thread] = ACTIONS(1204),
    [anon_sym_const] = ACTIONS(1204),
    [anon_sym_constexpr] = ACTIONS(1204),
    [anon_sym_volatile] = ACTIONS(1204),
    [anon_sym_restrict] = ACTIONS(1204),
    [anon_sym___restrict__] = ACTIONS(1204),
    [anon_sym__Atomic] = ACTIONS(1204),
    [anon_sym__Noreturn] = ACTIONS(1204),
    [anon_sym_noreturn] = ACTIONS(1204),
    [sym_primitive_type] = ACTIONS(1204),
    [anon_sym_enum] = ACTIONS(1204),
    [anon_sym_struct] = ACTIONS(1204),
    [anon_sym_union] = ACTIONS(1204),
    [anon_sym_if] = ACTIONS(1204),
    [anon_sym_else] = ACTIONS(1204),
    [anon_sym_switch] = ACTIONS(1204),
    [anon_sym_case] = ACTIONS(1204),
    [anon_sym_default] = ACTIONS(1204),
    [anon_sym_while] = ACTIONS(1204),
    [anon_sym_do] = ACTIONS(1204),
    [anon_sym_for] = ACTIONS(1204),
    [anon_sym_return] = ACTIONS(1204),
    [anon_sym_break] = ACTIONS(1204),
    [anon_sym_continue] = ACTIONS(1204),
    [anon_sym_goto] = ACTIONS(1204),
    [anon_sym___try] = ACTIONS(1204),
    [anon_sym___except] = ACTIONS(1204),
    [anon_sym___finally] = ACTIONS(1204),
    [anon_sym___leave] = ACTIONS(1204),
    [anon_sym_DASH_DASH] = ACTIONS(1206),
    [anon_sym_PLUS_PLUS] = ACTIONS(1206),
    [anon_sym_sizeof] = ACTIONS(1204),
    [anon_sym___alignof__] = ACTIONS(1204),
    [anon_sym___alignof] = ACTIONS(1204),
    [anon_sym__alignof] = ACTIONS(1204),
    [anon_sym_alignof] = ACTIONS(1204),
    [anon_sym__Alignof] = ACTIONS(1204),
    [anon_sym_offsetof] = ACTIONS(1204),
    [anon_sym__Generic] = ACTIONS(1204),
    [anon_sym_asm] = ACTIONS(1204),
    [anon_sym___asm__] = ACTIONS(1204),
    [sym_number_literal] = ACTIONS(1206),
    [anon_sym_L_SQUOTE] = ACTIONS(1206),
    [anon_sym_u_SQUOTE] = ACTIONS(1206),
    [anon_sym_U_SQUOTE] = ACTIONS(1206),
    [anon_sym_u8_SQUOTE] = ACTIONS(1206),
    [anon_sym_SQUOTE] = ACTIONS(1206),
    [anon_sym_L_DQUOTE] = ACTIONS(1206),
    [anon_sym_u_DQUOTE] = ACTIONS(1206),
    [anon_sym_U_DQUOTE] = ACTIONS(1206),
    [anon_sym_u8_DQUOTE] = ACTIONS(1206),
    [anon_sym_DQUOTE] = ACTIONS(1206),
    [sym_true] = ACTIONS(1204),
    [sym_false] = ACTIONS(1204),
    [anon_sym_NULL] = ACTIONS(1204),
    [anon_sym_nullptr] = ACTIONS(1204),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_identifier] = ACTIONS(1212),
    [aux_sym_preproc_include_token1] = ACTIONS(1212),
    [aux_sym_preproc_def_token1] = ACTIONS(1212),
    [aux_sym_preproc_if_token1] = ACTIONS(1212),
    [aux_sym_preproc_if_token2] = ACTIONS(1212),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1212),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1212),
    [aux_sym_preproc_else_token1] = ACTIONS(1212),
    [aux_sym_preproc_elif_token1] = ACTIONS(1212),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1212),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1212),
    [sym_preproc_directive] = ACTIONS(1212),
    [anon_sym_LPAREN2] = ACTIONS(1214),
    [anon_sym_BANG] = ACTIONS(1214),
    [anon_sym_TILDE] = ACTIONS(1214),
    [anon_sym_DASH] = ACTIONS(1212),
    [anon_sym_PLUS] = ACTIONS(1212),
    [anon_sym_STAR] = ACTIONS(1214),
    [anon_sym_AMP] = ACTIONS(1214),
    [anon_sym_SEMI] = ACTIONS(1214),
    [anon_sym___extension__] = ACTIONS(1212),
    [anon_sym_typedef] = ACTIONS(1212),
    [anon_sym_extern] = ACTIONS(1212),
    [anon_sym___attribute__] = ACTIONS(1212),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1214),
    [anon_sym___declspec] = ACTIONS(1212),
    [anon_sym___cdecl] = ACTIONS(1212),
    [anon_sym___clrcall] = ACTIONS(1212),
    [anon_sym___stdcall] = ACTIONS(1212),
    [anon_sym___fastcall] = ACTIONS(1212),
    [anon_sym___thiscall] = ACTIONS(1212),
    [anon_sym___vectorcall] = ACTIONS(1212),
    [anon_sym_LBRACE] = ACTIONS(1214),
    [anon_sym_signed] = ACTIONS(1212),
    [anon_sym_unsigned] = ACTIONS(1212),
    [anon_sym_long] = ACTIONS(1212),
    [anon_sym_short] = ACTIONS(1212),
    [anon_sym_static] = ACTIONS(1212),
    [anon_sym_auto] = ACTIONS(1212),
    [anon_sym_register] = ACTIONS(1212),
    [anon_sym_inline] = ACTIONS(1212),
    [anon_sym___inline] = ACTIONS(1212),
    [anon_sym___inline__] = ACTIONS(1212),
    [anon_sym___forceinline] = ACTIONS(1212),
    [anon_sym_thread_local] = ACTIONS(1212),
    [anon_sym___thread] = ACTIONS(1212),
    [anon_sym_const] = ACTIONS(1212),
    [anon_sym_constexpr] = ACTIONS(1212),
    [anon_sym_volatile] = ACTIONS(1212),
    [anon_sym_restrict] = ACTIONS(1212),
    [anon_sym___restrict__] = ACTIONS(1212),
    [anon_sym__Atomic] = ACTIONS(1212),
    [anon_sym__Noreturn] = ACTIONS(1212),
    [anon_sym_noreturn] = ACTIONS(1212),
    [sym_primitive_type] = ACTIONS(1212),
    [anon_sym_enum] = ACTIONS(1212),
    [anon_sym_struct] = ACTIONS(1212),
    [anon_sym_union] = ACTIONS(1212),
    [anon_sym_if] = ACTIONS(1212),
    [anon_sym_else] = ACTIONS(1212),
    [anon_sym_switch] = ACTIONS(1212),
    [anon_sym_case] = ACTIONS(1212),
    [anon_sym_default] = ACTIONS(1212),
    [anon_sym_while] = ACTIONS(1212),
    [anon_sym_do] = ACTIONS(1212),
    [anon_sym_for] = ACTIONS(1212),
    [anon_sym_return] = ACTIONS(1212),
    [anon_sym_break] = ACTIONS(1212),
    [anon_sym_continue] = ACTIONS(1212),
    [anon_sym_goto] = ACTIONS(1212),
    [anon_sym___try] = ACTIONS(1212),
    [anon_sym___leave] = ACTIONS(1212),
    [anon_sym_DASH_DASH] = ACTIONS(1214),
    [anon_sym_PLUS_PLUS] = ACTIONS(1214),
    [anon_sym_sizeof] = ACTIONS(1212),
    [anon_sym___alignof__] = ACTIONS(1212),
    [anon_sym___alignof] = ACTIONS(1212),
    [anon_sym__alignof] = ACTIONS(1212),
    [anon_sym_alignof] = ACTIONS(1212),
    [anon_sym__Alignof] = ACTIONS(1212),
    [anon_sym_offsetof] = ACTIONS(1212),
    [anon_sym__Generic] = ACTIONS(1212),
    [anon_sym_asm] = ACTIONS(1212),
    [anon_sym___asm__] = ACTIONS(1212),
    [sym_number_literal] = ACTIONS(1214),
    [anon_sym_L_SQUOTE] = ACTIONS(1214),
    [anon_sym_u_SQUOTE] = ACTIONS(1214),
    [anon_sym_U_SQUOTE] = ACTIONS(1214),
    [anon_sym_u8_SQUOTE] = ACTIONS(1214),
    [anon_sym_SQUOTE] = ACTIONS(1214),
    [anon_sym_L_DQUOTE] = ACTIONS(1214),
    [anon_sym_u_DQUOTE] = ACTIONS(1214),
    [anon_sym_U_DQUOTE] = ACTIONS(1214),
    [anon_sym_u8_DQUOTE] = ACTIONS(1214),
    [anon_sym_DQUOTE] = ACTIONS(1214),
    [sym_true] = ACTIONS(1212),
    [sym_false] = ACTIONS(1212),
    [anon_sym_NULL] = ACTIONS(1212),
    [anon_sym_nullptr] = ACTIONS(1212),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_identifier] = ACTIONS(1216),
    [aux_sym_preproc_include_token1] = ACTIONS(1216),
    [aux_sym_preproc_def_token1] = ACTIONS(1216),
    [aux_sym_preproc_if_token1] = ACTIONS(1216),
    [aux_sym_preproc_if_token2] = ACTIONS(1216),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1216),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1216),
    [aux_sym_preproc_else_token1] = ACTIONS(1216),
    [aux_sym_preproc_elif_token1] = ACTIONS(1216),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1216),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1216),
    [sym_preproc_directive] = ACTIONS(1216),
    [anon_sym_LPAREN2] = ACTIONS(1218),
    [anon_sym_BANG] = ACTIONS(1218),
    [anon_sym_TILDE] = ACTIONS(1218),
    [anon_sym_DASH] = ACTIONS(1216),
    [anon_sym_PLUS] = ACTIONS(1216),
    [anon_sym_STAR] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1218),
    [anon_sym_SEMI] = ACTIONS(1218),
    [anon_sym___extension__] = ACTIONS(1216),
    [anon_sym_typedef] = ACTIONS(1216),
    [anon_sym_extern] = ACTIONS(1216),
    [anon_sym___attribute__] = ACTIONS(1216),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1218),
    [anon_sym___declspec] = ACTIONS(1216),
    [anon_sym___cdecl] = ACTIONS(1216),
    [anon_sym___clrcall] = ACTIONS(1216),
    [anon_sym___stdcall] = ACTIONS(1216),
    [anon_sym___fastcall] = ACTIONS(1216),
    [anon_sym___thiscall] = ACTIONS(1216),
    [anon_sym___vectorcall] = ACTIONS(1216),
    [anon_sym_LBRACE] = ACTIONS(1218),
    [anon_sym_signed] = ACTIONS(1216),
    [anon_sym_unsigned] = ACTIONS(1216),
    [anon_sym_long] = ACTIONS(1216),
    [anon_sym_short] = ACTIONS(1216),
    [anon_sym_static] = ACTIONS(1216),
    [anon_sym_auto] = ACTIONS(1216),
    [anon_sym_register] = ACTIONS(1216),
    [anon_sym_inline] = ACTIONS(1216),
    [anon_sym___inline] = ACTIONS(1216),
    [anon_sym___inline__] = ACTIONS(1216),
    [anon_sym___forceinline] = ACTIONS(1216),
    [anon_sym_thread_local] = ACTIONS(1216),
    [anon_sym___thread] = ACTIONS(1216),
    [anon_sym_const] = ACTIONS(1216),
    [anon_sym_constexpr] = ACTIONS(1216),
    [anon_sym_volatile] = ACTIONS(1216),
    [anon_sym_restrict] = ACTIONS(1216),
    [anon_sym___restrict__] = ACTIONS(1216),
    [anon_sym__Atomic] = ACTIONS(1216),
    [anon_sym__Noreturn] = ACTIONS(1216),
    [anon_sym_noreturn] = ACTIONS(1216),
    [sym_primitive_type] = ACTIONS(1216),
    [anon_sym_enum] = ACTIONS(1216),
    [anon_sym_struct] = ACTIONS(1216),
    [anon_sym_union] = ACTIONS(1216),
    [anon_sym_if] = ACTIONS(1216),
    [anon_sym_else] = ACTIONS(1216),
    [anon_sym_switch] = ACTIONS(1216),
    [anon_sym_case] = ACTIONS(1216),
    [anon_sym_default] = ACTIONS(1216),
    [anon_sym_while] = ACTIONS(1216),
    [anon_sym_do] = ACTIONS(1216),
    [anon_sym_for] = ACTIONS(1216),
    [anon_sym_return] = ACTIONS(1216),
    [anon_sym_break] = ACTIONS(1216),
    [anon_sym_continue] = ACTIONS(1216),
    [anon_sym_goto] = ACTIONS(1216),
    [anon_sym___try] = ACTIONS(1216),
    [anon_sym___leave] = ACTIONS(1216),
    [anon_sym_DASH_DASH] = ACTIONS(1218),
    [anon_sym_PLUS_PLUS] = ACTIONS(1218),
    [anon_sym_sizeof] = ACTIONS(1216),
    [anon_sym___alignof__] = ACTIONS(1216),
    [anon_sym___alignof] = ACTIONS(1216),
    [anon_sym__alignof] = ACTIONS(1216),
    [anon_sym_alignof] = ACTIONS(1216),
    [anon_sym__Alignof] = ACTIONS(1216),
    [anon_sym_offsetof] = ACTIONS(1216),
    [anon_sym__Generic] = ACTIONS(1216),
    [anon_sym_asm] = ACTIONS(1216),
    [anon_sym___asm__] = ACTIONS(1216),
    [sym_number_literal] = ACTIONS(1218),
    [anon_sym_L_SQUOTE] = ACTIONS(1218),
    [anon_sym_u_SQUOTE] = ACTIONS(1218),
    [anon_sym_U_SQUOTE] = ACTIONS(1218),
    [anon_sym_u8_SQUOTE] = ACTIONS(1218),
    [anon_sym_SQUOTE] = ACTIONS(1218),
    [anon_sym_L_DQUOTE] = ACTIONS(1218),
    [anon_sym_u_DQUOTE] = ACTIONS(1218),
    [anon_sym_U_DQUOTE] = ACTIONS(1218),
    [anon_sym_u8_DQUOTE] = ACTIONS(1218),
    [anon_sym_DQUOTE] = ACTIONS(1218),
    [sym_true] = ACTIONS(1216),
    [sym_false] = ACTIONS(1216),
    [anon_sym_NULL] = ACTIONS(1216),
    [anon_sym_nullptr] = ACTIONS(1216),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_identifier] = ACTIONS(1220),
    [aux_sym_preproc_include_token1] = ACTIONS(1220),
    [aux_sym_preproc_def_token1] = ACTIONS(1220),
    [aux_sym_preproc_if_token1] = ACTIONS(1220),
    [aux_sym_preproc_if_token2] = ACTIONS(1220),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1220),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1220),
    [aux_sym_preproc_else_token1] = ACTIONS(1220),
    [aux_sym_preproc_elif_token1] = ACTIONS(1220),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1220),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1220),
    [sym_preproc_directive] = ACTIONS(1220),
    [anon_sym_LPAREN2] = ACTIONS(1222),
    [anon_sym_BANG] = ACTIONS(1222),
    [anon_sym_TILDE] = ACTIONS(1222),
    [anon_sym_DASH] = ACTIONS(1220),
    [anon_sym_PLUS] = ACTIONS(1220),
    [anon_sym_STAR] = ACTIONS(1222),
    [anon_sym_AMP] = ACTIONS(1222),
    [anon_sym_SEMI] = ACTIONS(1222),
    [anon_sym___extension__] = ACTIONS(1220),
    [anon_sym_typedef] = ACTIONS(1220),
    [anon_sym_extern] = ACTIONS(1220),
    [anon_sym___attribute__] = ACTIONS(1220),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1222),
    [anon_sym___declspec] = ACTIONS(1220),
    [anon_sym___cdecl] = ACTIONS(1220),
    [anon_sym___clrcall] = ACTIONS(1220),
    [anon_sym___stdcall] = ACTIONS(1220),
    [anon_sym___fastcall] = ACTIONS(1220),
    [anon_sym___thiscall] = ACTIONS(1220),
    [anon_sym___vectorcall] = ACTIONS(1220),
    [anon_sym_LBRACE] = ACTIONS(1222),
    [anon_sym_signed] = ACTIONS(1220),
    [anon_sym_unsigned] = ACTIONS(1220),
    [anon_sym_long] = ACTIONS(1220),
    [anon_sym_short] = ACTIONS(1220),
    [anon_sym_static] = ACTIONS(1220),
    [anon_sym_auto] = ACTIONS(1220),
    [anon_sym_register] = ACTIONS(1220),
    [anon_sym_inline] = ACTIONS(1220),
    [anon_sym___inline] = ACTIONS(1220),
    [anon_sym___inline__] = ACTIONS(1220),
    [anon_sym___forceinline] = ACTIONS(1220),
    [anon_sym_thread_local] = ACTIONS(1220),
    [anon_sym___thread] = ACTIONS(1220),
    [anon_sym_const] = ACTIONS(1220),
    [anon_sym_constexpr] = ACTIONS(1220),
    [anon_sym_volatile] = ACTIONS(1220),
    [anon_sym_restrict] = ACTIONS(1220),
    [anon_sym___restrict__] = ACTIONS(1220),
    [anon_sym__Atomic] = ACTIONS(1220),
    [anon_sym__Noreturn] = ACTIONS(1220),
    [anon_sym_noreturn] = ACTIONS(1220),
    [sym_primitive_type] = ACTIONS(1220),
    [anon_sym_enum] = ACTIONS(1220),
    [anon_sym_struct] = ACTIONS(1220),
    [anon_sym_union] = ACTIONS(1220),
    [anon_sym_if] = ACTIONS(1220),
    [anon_sym_else] = ACTIONS(1220),
    [anon_sym_switch] = ACTIONS(1220),
    [anon_sym_case] = ACTIONS(1220),
    [anon_sym_default] = ACTIONS(1220),
    [anon_sym_while] = ACTIONS(1220),
    [anon_sym_do] = ACTIONS(1220),
    [anon_sym_for] = ACTIONS(1220),
    [anon_sym_return] = ACTIONS(1220),
    [anon_sym_break] = ACTIONS(1220),
    [anon_sym_continue] = ACTIONS(1220),
    [anon_sym_goto] = ACTIONS(1220),
    [anon_sym___try] = ACTIONS(1220),
    [anon_sym___leave] = ACTIONS(1220),
    [anon_sym_DASH_DASH] = ACTIONS(1222),
    [anon_sym_PLUS_PLUS] = ACTIONS(1222),
    [anon_sym_sizeof] = ACTIONS(1220),
    [anon_sym___alignof__] = ACTIONS(1220),
    [anon_sym___alignof] = ACTIONS(1220),
    [anon_sym__alignof] = ACTIONS(1220),
    [anon_sym_alignof] = ACTIONS(1220),
    [anon_sym__Alignof] = ACTIONS(1220),
    [anon_sym_offsetof] = ACTIONS(1220),
    [anon_sym__Generic] = ACTIONS(1220),
    [anon_sym_asm] = ACTIONS(1220),
    [anon_sym___asm__] = ACTIONS(1220),
    [sym_number_literal] = ACTIONS(1222),
    [anon_sym_L_SQUOTE] = ACTIONS(1222),
    [anon_sym_u_SQUOTE] = ACTIONS(1222),
    [anon_sym_U_SQUOTE] = ACTIONS(1222),
    [anon_sym_u8_SQUOTE] = ACTIONS(1222),
    [anon_sym_SQUOTE] = ACTIONS(1222),
    [anon_sym_L_DQUOTE] = ACTIONS(1222),
    [anon_sym_u_DQUOTE] = ACTIONS(1222),
    [anon_sym_U_DQUOTE] = ACTIONS(1222),
    [anon_sym_u8_DQUOTE] = ACTIONS(1222),
    [anon_sym_DQUOTE] = ACTIONS(1222),
    [sym_true] = ACTIONS(1220),
    [sym_false] = ACTIONS(1220),
    [anon_sym_NULL] = ACTIONS(1220),
    [anon_sym_nullptr] = ACTIONS(1220),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_identifier] = ACTIONS(1224),
    [aux_sym_preproc_include_token1] = ACTIONS(1224),
    [aux_sym_preproc_def_token1] = ACTIONS(1224),
    [aux_sym_preproc_if_token1] = ACTIONS(1224),
    [aux_sym_preproc_if_token2] = ACTIONS(1224),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1224),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1224),
    [aux_sym_preproc_else_token1] = ACTIONS(1224),
    [aux_sym_preproc_elif_token1] = ACTIONS(1224),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1224),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1224),
    [sym_preproc_directive] = ACTIONS(1224),
    [anon_sym_LPAREN2] = ACTIONS(1226),
    [anon_sym_BANG] = ACTIONS(1226),
    [anon_sym_TILDE] = ACTIONS(1226),
    [anon_sym_DASH] = ACTIONS(1224),
    [anon_sym_PLUS] = ACTIONS(1224),
    [anon_sym_STAR] = ACTIONS(1226),
    [anon_sym_AMP] = ACTIONS(1226),
    [anon_sym_SEMI] = ACTIONS(1226),
    [anon_sym___extension__] = ACTIONS(1224),
    [anon_sym_typedef] = ACTIONS(1224),
    [anon_sym_extern] = ACTIONS(1224),
    [anon_sym___attribute__] = ACTIONS(1224),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1226),
    [anon_sym___declspec] = ACTIONS(1224),
    [anon_sym___cdecl] = ACTIONS(1224),
    [anon_sym___clrcall] = ACTIONS(1224),
    [anon_sym___stdcall] = ACTIONS(1224),
    [anon_sym___fastcall] = ACTIONS(1224),
    [anon_sym___thiscall] = ACTIONS(1224),
    [anon_sym___vectorcall] = ACTIONS(1224),
    [anon_sym_LBRACE] = ACTIONS(1226),
    [anon_sym_signed] = ACTIONS(1224),
    [anon_sym_unsigned] = ACTIONS(1224),
    [anon_sym_long] = ACTIONS(1224),
    [anon_sym_short] = ACTIONS(1224),
    [anon_sym_static] = ACTIONS(1224),
    [anon_sym_auto] = ACTIONS(1224),
    [anon_sym_register] = ACTIONS(1224),
    [anon_sym_inline] = ACTIONS(1224),
    [anon_sym___inline] = ACTIONS(1224),
    [anon_sym___inline__] = ACTIONS(1224),
    [anon_sym___forceinline] = ACTIONS(1224),
    [anon_sym_thread_local] = ACTIONS(1224),
    [anon_sym___thread] = ACTIONS(1224),
    [anon_sym_const] = ACTIONS(1224),
    [anon_sym_constexpr] = ACTIONS(1224),
    [anon_sym_volatile] = ACTIONS(1224),
    [anon_sym_restrict] = ACTIONS(1224),
    [anon_sym___restrict__] = ACTIONS(1224),
    [anon_sym__Atomic] = ACTIONS(1224),
    [anon_sym__Noreturn] = ACTIONS(1224),
    [anon_sym_noreturn] = ACTIONS(1224),
    [sym_primitive_type] = ACTIONS(1224),
    [anon_sym_enum] = ACTIONS(1224),
    [anon_sym_struct] = ACTIONS(1224),
    [anon_sym_union] = ACTIONS(1224),
    [anon_sym_if] = ACTIONS(1224),
    [anon_sym_else] = ACTIONS(1224),
    [anon_sym_switch] = ACTIONS(1224),
    [anon_sym_case] = ACTIONS(1224),
    [anon_sym_default] = ACTIONS(1224),
    [anon_sym_while] = ACTIONS(1224),
    [anon_sym_do] = ACTIONS(1224),
    [anon_sym_for] = ACTIONS(1224),
    [anon_sym_return] = ACTIONS(1224),
    [anon_sym_break] = ACTIONS(1224),
    [anon_sym_continue] = ACTIONS(1224),
    [anon_sym_goto] = ACTIONS(1224),
    [anon_sym___try] = ACTIONS(1224),
    [anon_sym___leave] = ACTIONS(1224),
    [anon_sym_DASH_DASH] = ACTIONS(1226),
    [anon_sym_PLUS_PLUS] = ACTIONS(1226),
    [anon_sym_sizeof] = ACTIONS(1224),
    [anon_sym___alignof__] = ACTIONS(1224),
    [anon_sym___alignof] = ACTIONS(1224),
    [anon_sym__alignof] = ACTIONS(1224),
    [anon_sym_alignof] = ACTIONS(1224),
    [anon_sym__Alignof] = ACTIONS(1224),
    [anon_sym_offsetof] = ACTIONS(1224),
    [anon_sym__Generic] = ACTIONS(1224),
    [anon_sym_asm] = ACTIONS(1224),
    [anon_sym___asm__] = ACTIONS(1224),
    [sym_number_literal] = ACTIONS(1226),
    [anon_sym_L_SQUOTE] = ACTIONS(1226),
    [anon_sym_u_SQUOTE] = ACTIONS(1226),
    [anon_sym_U_SQUOTE] = ACTIONS(1226),
    [anon_sym_u8_SQUOTE] = ACTIONS(1226),
    [anon_sym_SQUOTE] = ACTIONS(1226),
    [anon_sym_L_DQUOTE] = ACTIONS(1226),
    [anon_sym_u_DQUOTE] = ACTIONS(1226),
    [anon_sym_U_DQUOTE] = ACTIONS(1226),
    [anon_sym_u8_DQUOTE] = ACTIONS(1226),
    [anon_sym_DQUOTE] = ACTIONS(1226),
    [sym_true] = ACTIONS(1224),
    [sym_false] = ACTIONS(1224),
    [anon_sym_NULL] = ACTIONS(1224),
    [anon_sym_nullptr] = ACTIONS(1224),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_identifier] = ACTIONS(1116),
    [aux_sym_preproc_include_token1] = ACTIONS(1116),
    [aux_sym_preproc_def_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token1] = ACTIONS(1116),
    [aux_sym_preproc_if_token2] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1116),
    [aux_sym_preproc_else_token1] = ACTIONS(1116),
    [aux_sym_preproc_elif_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1116),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1116),
    [sym_preproc_directive] = ACTIONS(1116),
    [anon_sym_LPAREN2] = ACTIONS(1118),
    [anon_sym_BANG] = ACTIONS(1118),
    [anon_sym_TILDE] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(1116),
    [anon_sym_PLUS] = ACTIONS(1116),
    [anon_sym_STAR] = ACTIONS(1118),
    [anon_sym_AMP] = ACTIONS(1118),
    [anon_sym_SEMI] = ACTIONS(1118),
    [anon_sym___extension__] = ACTIONS(1116),
    [anon_sym_typedef] = ACTIONS(1116),
    [anon_sym_extern] = ACTIONS(1116),
    [anon_sym___attribute__] = ACTIONS(1116),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1118),
    [anon_sym___declspec] = ACTIONS(1116),
    [anon_sym___cdecl] = ACTIONS(1116),
    [anon_sym___clrcall] = ACTIONS(1116),
    [anon_sym___stdcall] = ACTIONS(1116),
    [anon_sym___fastcall] = ACTIONS(1116),
    [anon_sym___thiscall] = ACTIONS(1116),
    [anon_sym___vectorcall] = ACTIONS(1116),
    [anon_sym_LBRACE] = ACTIONS(1118),
    [anon_sym_signed] = ACTIONS(1116),
    [anon_sym_unsigned] = ACTIONS(1116),
    [anon_sym_long] = ACTIONS(1116),
    [anon_sym_short] = ACTIONS(1116),
    [anon_sym_static] = ACTIONS(1116),
    [anon_sym_auto] = ACTIONS(1116),
    [anon_sym_register] = ACTIONS(1116),
    [anon_sym_inline] = ACTIONS(1116),
    [anon_sym___inline] = ACTIONS(1116),
    [anon_sym___inline__] = ACTIONS(1116),
    [anon_sym___forceinline] = ACTIONS(1116),
    [anon_sym_thread_local] = ACTIONS(1116),
    [anon_sym___thread] = ACTIONS(1116),
    [anon_sym_const] = ACTIONS(1116),
    [anon_sym_constexpr] = ACTIONS(1116),
    [anon_sym_volatile] = ACTIONS(1116),
    [anon_sym_restrict] = ACTIONS(1116),
    [anon_sym___restrict__] = ACTIONS(1116),
    [anon_sym__Atomic] = ACTIONS(1116),
    [anon_sym__Noreturn] = ACTIONS(1116),
    [anon_sym_noreturn] = ACTIONS(1116),
    [sym_primitive_type] = ACTIONS(1116),
    [anon_sym_enum] = ACTIONS(1116),
    [anon_sym_struct] = ACTIONS(1116),
    [anon_sym_union] = ACTIONS(1116),
    [anon_sym_if] = ACTIONS(1116),
    [anon_sym_else] = ACTIONS(1116),
    [anon_sym_switch] = ACTIONS(1116),
    [anon_sym_case] = ACTIONS(1116),
    [anon_sym_default] = ACTIONS(1116),
    [anon_sym_while] = ACTIONS(1116),
    [anon_sym_do] = ACTIONS(1116),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1116),
    [anon_sym_break] = ACTIONS(1116),
    [anon_sym_continue] = ACTIONS(1116),
    [anon_sym_goto] = ACTIONS(1116),
    [anon_sym___try] = ACTIONS(1116),
    [anon_sym___leave] = ACTIONS(1116),
    [anon_sym_DASH_DASH] = ACTIONS(1118),
    [anon_sym_PLUS_PLUS] = ACTIONS(1118),
    [anon_sym_sizeof] = ACTIONS(1116),
    [anon_sym___alignof__] = ACTIONS(1116),
    [anon_sym___alignof] = ACTIONS(1116),
    [anon_sym__alignof] = ACTIONS(1116),
    [anon_sym_alignof] = ACTIONS(1116),
    [anon_sym__Alignof] = ACTIONS(1116),
    [anon_sym_offsetof] = ACTIONS(1116),
    [anon_sym__Generic] = ACTIONS(1116),
    [anon_sym_asm] = ACTIONS(1116),
    [anon_sym___asm__] = ACTIONS(1116),
    [sym_number_literal] = ACTIONS(1118),
    [anon_sym_L_SQUOTE] = ACTIONS(1118),
    [anon_sym_u_SQUOTE] = ACTIONS(1118),
    [anon_sym_U_SQUOTE] = ACTIONS(1118),
    [anon_sym_u8_SQUOTE] = ACTIONS(1118),
    [anon_sym_SQUOTE] = ACTIONS(1118),
    [anon_sym_L_DQUOTE] = ACTIONS(1118),
    [anon_sym_u_DQUOTE] = ACTIONS(1118),
    [anon_sym_U_DQUOTE] = ACTIONS(1118),
    [anon_sym_u8_DQUOTE] = ACTIONS(1118),
    [anon_sym_DQUOTE] = ACTIONS(1118),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [anon_sym_NULL] = ACTIONS(1116),
    [anon_sym_nullptr] = ACTIONS(1116),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_identifier] = ACTIONS(1228),
    [aux_sym_preproc_include_token1] = ACTIONS(1228),
    [aux_sym_preproc_def_token1] = ACTIONS(1228),
    [aux_sym_preproc_if_token1] = ACTIONS(1228),
    [aux_sym_preproc_if_token2] = ACTIONS(1228),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1228),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1228),
    [aux_sym_preproc_else_token1] = ACTIONS(1228),
    [aux_sym_preproc_elif_token1] = ACTIONS(1228),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1228),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1228),
    [sym_preproc_directive] = ACTIONS(1228),
    [anon_sym_LPAREN2] = ACTIONS(1230),
    [anon_sym_BANG] = ACTIONS(1230),
    [anon_sym_TILDE] = ACTIONS(1230),
    [anon_sym_DASH] = ACTIONS(1228),
    [anon_sym_PLUS] = ACTIONS(1228),
    [anon_sym_STAR] = ACTIONS(1230),
    [anon_sym_AMP] = ACTIONS(1230),
    [anon_sym_SEMI] = ACTIONS(1230),
    [anon_sym___extension__] = ACTIONS(1228),
    [anon_sym_typedef] = ACTIONS(1228),
    [anon_sym_extern] = ACTIONS(1228),
    [anon_sym___attribute__] = ACTIONS(1228),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1230),
    [anon_sym___declspec] = ACTIONS(1228),
    [anon_sym___cdecl] = ACTIONS(1228),
    [anon_sym___clrcall] = ACTIONS(1228),
    [anon_sym___stdcall] = ACTIONS(1228),
    [anon_sym___fastcall] = ACTIONS(1228),
    [anon_sym___thiscall] = ACTIONS(1228),
    [anon_sym___vectorcall] = ACTIONS(1228),
    [anon_sym_LBRACE] = ACTIONS(1230),
    [anon_sym_signed] = ACTIONS(1228),
    [anon_sym_unsigned] = ACTIONS(1228),
    [anon_sym_long] = ACTIONS(1228),
    [anon_sym_short] = ACTIONS(1228),
    [anon_sym_static] = ACTIONS(1228),
    [anon_sym_auto] = ACTIONS(1228),
    [anon_sym_register] = ACTIONS(1228),
    [anon_sym_inline] = ACTIONS(1228),
    [anon_sym___inline] = ACTIONS(1228),
    [anon_sym___inline__] = ACTIONS(1228),
    [anon_sym___forceinline] = ACTIONS(1228),
    [anon_sym_thread_local] = ACTIONS(1228),
    [anon_sym___thread] = ACTIONS(1228),
    [anon_sym_const] = ACTIONS(1228),
    [anon_sym_constexpr] = ACTIONS(1228),
    [anon_sym_volatile] = ACTIONS(1228),
    [anon_sym_restrict] = ACTIONS(1228),
    [anon_sym___restrict__] = ACTIONS(1228),
    [anon_sym__Atomic] = ACTIONS(1228),
    [anon_sym__Noreturn] = ACTIONS(1228),
    [anon_sym_noreturn] = ACTIONS(1228),
    [sym_primitive_type] = ACTIONS(1228),
    [anon_sym_enum] = ACTIONS(1228),
    [anon_sym_struct] = ACTIONS(1228),
    [anon_sym_union] = ACTIONS(1228),
    [anon_sym_if] = ACTIONS(1228),
    [anon_sym_else] = ACTIONS(1228),
    [anon_sym_switch] = ACTIONS(1228),
    [anon_sym_case] = ACTIONS(1228),
    [anon_sym_default] = ACTIONS(1228),
    [anon_sym_while] = ACTIONS(1228),
    [anon_sym_do] = ACTIONS(1228),
    [anon_sym_for] = ACTIONS(1228),
    [anon_sym_return] = ACTIONS(1228),
    [anon_sym_break] = ACTIONS(1228),
    [anon_sym_continue] = ACTIONS(1228),
    [anon_sym_goto] = ACTIONS(1228),
    [anon_sym___try] = ACTIONS(1228),
    [anon_sym___leave] = ACTIONS(1228),
    [anon_sym_DASH_DASH] = ACTIONS(1230),
    [anon_sym_PLUS_PLUS] = ACTIONS(1230),
    [anon_sym_sizeof] = ACTIONS(1228),
    [anon_sym___alignof__] = ACTIONS(1228),
    [anon_sym___alignof] = ACTIONS(1228),
    [anon_sym__alignof] = ACTIONS(1228),
    [anon_sym_alignof] = ACTIONS(1228),
    [anon_sym__Alignof] = ACTIONS(1228),
    [anon_sym_offsetof] = ACTIONS(1228),
    [anon_sym__Generic] = ACTIONS(1228),
    [anon_sym_asm] = ACTIONS(1228),
    [anon_sym___asm__] = ACTIONS(1228),
    [sym_number_literal] = ACTIONS(1230),
    [anon_sym_L_SQUOTE] = ACTIONS(1230),
    [anon_sym_u_SQUOTE] = ACTIONS(1230),
    [anon_sym_U_SQUOTE] = ACTIONS(1230),
    [anon_sym_u8_SQUOTE] = ACTIONS(1230),
    [anon_sym_SQUOTE] = ACTIONS(1230),
    [anon_sym_L_DQUOTE] = ACTIONS(1230),
    [anon_sym_u_DQUOTE] = ACTIONS(1230),
    [anon_sym_U_DQUOTE] = ACTIONS(1230),
 