#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2300
#define LARGE_STATE_COUNT 582
#define SYMBOL_COUNT 348
#define ALIAS_COUNT 3
#define TOKEN_COUNT 155
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 127

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym___extension__ = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym_COLON_COLON = 47,
  anon_sym_LBRACK_LBRACK = 48,
  anon_sym_RBRACK_RBRACK = 49,
  anon_sym___declspec = 50,
  anon_sym___based = 51,
  anon_sym___cdecl = 52,
  anon_sym___clrcall = 53,
  anon_sym___stdcall = 54,
  anon_sym___fastcall = 55,
  anon_sym___thiscall = 56,
  anon_sym___vectorcall = 57,
  sym_ms_restrict_modifier = 58,
  sym_ms_unsigned_ptr_modifier = 59,
  sym_ms_signed_ptr_modifier = 60,
  anon_sym__unaligned = 61,
  anon_sym___unaligned = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_signed = 65,
  anon_sym_unsigned = 66,
  anon_sym_long = 67,
  anon_sym_short = 68,
  anon_sym_LBRACK = 69,
  anon_sym_RBRACK = 70,
  anon_sym_EQ = 71,
  anon_sym_static = 72,
  anon_sym_auto = 73,
  anon_sym_register = 74,
  anon_sym_inline = 75,
  anon_sym___inline = 76,
  anon_sym___inline__ = 77,
  anon_sym___forceinline = 78,
  anon_sym_thread_local = 79,
  anon_sym___thread = 80,
  anon_sym_const = 81,
  anon_sym_constexpr = 82,
  anon_sym_volatile = 83,
  anon_sym_restrict = 84,
  anon_sym___restrict__ = 85,
  anon_sym__Atomic = 86,
  anon_sym__Noreturn = 87,
  anon_sym_noreturn = 88,
  sym_primitive_type = 89,
  anon_sym_enum = 90,
  anon_sym_COLON = 91,
  anon_sym_struct = 92,
  anon_sym_union = 93,
  anon_sym_if = 94,
  anon_sym_else = 95,
  anon_sym_switch = 96,
  anon_sym_case = 97,
  anon_sym_default = 98,
  anon_sym_while = 99,
  anon_sym_do = 100,
  anon_sym_for = 101,
  anon_sym_return = 102,
  anon_sym_break = 103,
  anon_sym_continue = 104,
  anon_sym_goto = 105,
  anon_sym___try = 106,
  anon_sym___except = 107,
  anon_sym___finally = 108,
  anon_sym___leave = 109,
  anon_sym_QMARK = 110,
  anon_sym_STAR_EQ = 111,
  anon_sym_SLASH_EQ = 112,
  anon_sym_PERCENT_EQ = 113,
  anon_sym_PLUS_EQ = 114,
  anon_sym_DASH_EQ = 115,
  anon_sym_LT_LT_EQ = 116,
  anon_sym_GT_GT_EQ = 117,
  anon_sym_AMP_EQ = 118,
  anon_sym_CARET_EQ = 119,
  anon_sym_PIPE_EQ = 120,
  anon_sym_DASH_DASH = 121,
  anon_sym_PLUS_PLUS = 122,
  anon_sym_sizeof = 123,
  anon_sym___alignof__ = 124,
  anon_sym___alignof = 125,
  anon_sym__alignof = 126,
  anon_sym_alignof = 127,
  anon_sym__Alignof = 128,
  anon_sym_offsetof = 129,
  anon_sym__Generic = 130,
  anon_sym_asm = 131,
  anon_sym___asm__ = 132,
  anon_sym_DOT = 133,
  anon_sym_DASH_GT = 134,
  sym_number_literal = 135,
  anon_sym_L_SQUOTE = 136,
  anon_sym_u_SQUOTE = 137,
  anon_sym_U_SQUOTE = 138,
  anon_sym_u8_SQUOTE = 139,
  anon_sym_SQUOTE = 140,
  aux_sym_char_literal_token1 = 141,
  anon_sym_L_DQUOTE = 142,
  anon_sym_u_DQUOTE = 143,
  anon_sym_U_DQUOTE = 144,
  anon_sym_u8_DQUOTE = 145,
  anon_sym_DQUOTE = 146,
  aux_sym_string_literal_token1 = 147,
  sym_escape_sequence = 148,
  sym_system_lib_string = 149,
  sym_true = 150,
  sym_false = 151,
  anon_sym_NULL = 152,
  anon_sym_nullptr = 153,
  sym_comment = 154,
  sym_translation_unit = 155,
  sym_preproc_include = 156,
  sym_preproc_def = 157,
  sym_preproc_function_def = 158,
  sym_preproc_params = 159,
  sym_preproc_call = 160,
  sym_preproc_if = 161,
  sym_preproc_ifdef = 162,
  sym_preproc_else = 163,
  sym_preproc_elif = 164,
  sym_preproc_elifdef = 165,
  sym_preproc_if_in_field_declaration_list = 166,
  sym_preproc_ifdef_in_field_declaration_list = 167,
  sym_preproc_else_in_field_declaration_list = 168,
  sym_preproc_elif_in_field_declaration_list = 169,
  sym_preproc_elifdef_in_field_declaration_list = 170,
  sym_preproc_if_in_enumerator_list = 171,
  sym_preproc_ifdef_in_enumerator_list = 172,
  sym_preproc_else_in_enumerator_list = 173,
  sym_preproc_elif_in_enumerator_list = 174,
  sym_preproc_elifdef_in_enumerator_list = 175,
  sym_preproc_if_in_enumerator_list_no_comma = 176,
  sym_preproc_ifdef_in_enumerator_list_no_comma = 177,
  sym_preproc_else_in_enumerator_list_no_comma = 178,
  sym_preproc_elif_in_enumerator_list_no_comma = 179,
  sym_preproc_elifdef_in_enumerator_list_no_comma = 180,
  sym__preproc_expression = 181,
  sym_preproc_parenthesized_expression = 182,
  sym_preproc_defined = 183,
  sym_preproc_unary_expression = 184,
  sym_preproc_call_expression = 185,
  sym_preproc_argument_list = 186,
  sym_preproc_binary_expression = 187,
  sym_function_definition = 188,
  sym__old_style_function_definition = 189,
  sym_declaration = 190,
  sym_type_definition = 191,
  sym__type_definition_type = 192,
  sym__type_definition_declarators = 193,
  sym__declaration_modifiers = 194,
  sym__declaration_specifiers = 195,
  sym_linkage_specification = 196,
  sym_attribute_specifier = 197,
  sym_attribute = 198,
  sym_attribute_declaration = 199,
  sym_ms_declspec_modifier = 200,
  sym_ms_based_modifier = 201,
  sym_ms_call_modifier = 202,
  sym_ms_unaligned_ptr_modifier = 203,
  sym_ms_pointer_modifier = 204,
  sym_declaration_list = 205,
  sym__declarator = 206,
  sym__declaration_declarator = 207,
  sym__field_declarator = 208,
  sym__type_declarator = 209,
  sym__abstract_declarator = 210,
  sym_parenthesized_declarator = 211,
  sym_parenthesized_field_declarator = 212,
  sym_parenthesized_type_declarator = 213,
  sym_abstract_parenthesized_declarator = 214,
  sym_attributed_declarator = 215,
  sym_attributed_field_declarator = 216,
  sym_attributed_type_declarator = 217,
  sym_pointer_declarator = 218,
  sym_pointer_field_declarator = 219,
  sym_pointer_type_declarator = 220,
  sym_abstract_pointer_declarator = 221,
  sym_function_declarator = 222,
  sym__function_declaration_declarator = 223,
  sym_function_field_declarator = 224,
  sym_function_type_declarator = 225,
  sym_abstract_function_declarator = 226,
  sym__old_style_function_declarator = 227,
  sym_array_declarator = 228,
  sym_array_field_declarator = 229,
  sym_array_type_declarator = 230,
  sym_abstract_array_declarator = 231,
  sym_init_declarator = 232,
  sym_compound_statement = 233,
  sym_storage_class_specifier = 234,
  sym_type_qualifier = 235,
  sym__type_specifier = 236,
  sym_sized_type_specifier = 237,
  sym_enum_specifier = 238,
  sym_enumerator_list = 239,
  sym_struct_specifier = 240,
  sym_union_specifier = 241,
  sym_field_declaration_list = 242,
  sym__field_declaration_list_item = 243,
  sym_field_declaration = 244,
  sym__field_declaration_declarator = 245,
  sym_bitfield_clause = 246,
  sym_enumerator = 247,
  sym_variadic_parameter = 248,
  sym_parameter_list = 249,
  sym__old_style_parameter_list = 250,
  sym_parameter_declaration = 251,
  sym_attributed_statement = 252,
  sym_labeled_statement = 253,
  sym__top_level_expression_statement = 254,
  sym_expression_statement = 255,
  sym_if_statement = 256,
  sym_else_clause = 257,
  sym_switch_statement = 258,
  sym_case_statement = 259,
  sym_while_statement = 260,
  sym_do_statement = 261,
  sym_for_statement = 262,
  sym__for_statement_body = 263,
  sym_return_statement = 264,
  sym_break_statement = 265,
  sym_continue_statement = 266,
  sym_goto_statement = 267,
  sym_seh_try_statement = 268,
  sym_seh_except_clause = 269,
  sym_seh_finally_clause = 270,
  sym_seh_leave_statement = 271,
  sym__expression = 272,
  sym__expression_not_binary = 273,
  sym__string = 274,
  sym_comma_expression = 275,
  sym_conditional_expression = 276,
  sym_assignment_expression = 277,
  sym_pointer_expression = 278,
  sym_unary_expression = 279,
  sym_binary_expression = 280,
  sym_update_expression = 281,
  sym_cast_expression = 282,
  sym_type_descriptor = 283,
  sym_sizeof_expression = 284,
  sym_alignof_expression = 285,
  sym_offsetof_expression = 286,
  sym_generic_expression = 287,
  sym_subscript_expression = 288,
  sym_call_expression = 289,
  sym_gnu_asm_expression = 290,
  sym_gnu_asm_qualifier = 291,
  sym_gnu_asm_output_operand_list = 292,
  sym_gnu_asm_output_operand = 293,
  sym_gnu_asm_input_operand_list = 294,
  sym_gnu_asm_input_operand = 295,
  sym_gnu_asm_clobber_list = 296,
  sym_gnu_asm_goto_list = 297,
  sym_argument_list = 298,
  sym_field_expression = 299,
  sym_compound_literal_expression = 300,
  sym_parenthesized_expression = 301,
  sym_initializer_list = 302,
  sym_initializer_pair = 303,
  sym_subscript_designator = 304,
  sym_subscript_range_designator = 305,
  sym_field_designator = 306,
  sym_char_literal = 307,
  sym_concatenated_string = 308,
  sym_string_literal = 309,
  sym_null = 310,
  sym__empty_declaration = 311,
  sym_macro_type_specifier = 312,
  aux_sym_translation_unit_repeat1 = 313,
  aux_sym_preproc_params_repeat1 = 314,
  aux_sym_preproc_if_repeat1 = 315,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 316,
  aux_sym_preproc_if_in_enumerator_list_repeat1 = 317,
  aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1 = 318,
  aux_sym_preproc_argument_list_repeat1 = 319,
  aux_sym__old_style_function_definition_repeat1 = 320,
  aux_sym_declaration_repeat1 = 321,
  aux_sym_type_definition_repeat1 = 322,
  aux_sym__type_definition_type_repeat1 = 323,
  aux_sym__type_definition_declarators_repeat1 = 324,
  aux_sym__declaration_specifiers_repeat1 = 325,
  aux_sym_attribute_declaration_repeat1 = 326,
  aux_sym_attributed_declarator_repeat1 = 327,
  aux_sym_pointer_declarator_repeat1 = 328,
  aux_sym_function_declarator_repeat1 = 329,
  aux_sym_sized_type_specifier_repeat1 = 330,
  aux_sym_enumerator_list_repeat1 = 331,
  aux_sym__field_declaration_declarator_repeat1 = 332,
  aux_sym_parameter_list_repeat1 = 333,
  aux_sym__old_style_parameter_list_repeat1 = 334,
  aux_sym_case_statement_repeat1 = 335,
  aux_sym_generic_expression_repeat1 = 336,
  aux_sym_gnu_asm_expression_repeat1 = 337,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 338,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 339,
  aux_sym_gnu_asm_clobber_list_repeat1 = 340,
  aux_sym_gnu_asm_goto_list_repeat1 = 341,
  aux_sym_argument_list_repeat1 = 342,
  aux_sym_initializer_list_repeat1 = 343,
  aux_sym_initializer_pair_repeat1 = 344,
  aux_sym_char_literal_repeat1 = 345,
  aux_sym_concatenated_string_repeat1 = 346,
  aux_sym_string_literal_repeat1 = 347,
  alias_sym_field_identifier = 348,
  alias_sym_statement_identifier = 349,
  alias_sym_type_identifier = 350,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym___extension__] = "__extension__",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_static] = "static",
  [anon_sym_auto] = "auto",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym___inline] = "__inline",
  [anon_sym___inline__] = "__inline__",
  [anon_sym___forceinline] = "__forceinline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym___thread] = "__thread",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_COLON] = ":",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym___try] = "__try",
  [anon_sym___except] = "__except",
  [anon_sym___finally] = "__finally",
  [anon_sym___leave] = "__leave",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym___alignof__] = "__alignof__",
  [anon_sym___alignof] = "__alignof",
  [anon_sym__alignof] = "_alignof",
  [anon_sym_alignof] = "alignof",
  [anon_sym__Alignof] = "_Alignof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_translation_unit] = "translation_unit",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym_preproc_elifdef_in_field_declaration_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list_no_comma] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list_no_comma] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list_no_comma] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = "preproc_elifdef",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym__old_style_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__type_definition_type] = "_type_definition_type",
  [sym__type_definition_declarators] = "_type_definition_declarators",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__declaration_declarator] = "_declaration_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym__function_declaration_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym__old_style_function_declarator] = "function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym__type_specifier] = "_type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym__field_declaration_declarator] = "_field_declaration_declarator",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_parameter_list] = "parameter_list",
  [sym__old_style_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_body] = "_for_statement_body",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_seh_try_statement] = "seh_try_statement",
  [sym_seh_except_clause] = "seh_except_clause",
  [sym_seh_finally_clause] = "seh_finally_clause",
  [sym_seh_leave_statement] = "seh_leave_statement",
  [sym__expression] = "_expression",
  [sym__expression_not_binary] = "_expression_not_binary",
  [sym__string] = "_string",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_alignof_expression] = "alignof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_subscript_range_designator] = "subscript_range_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_macro_type_specifier] = "macro_type_specifier",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = "preproc_if_in_enumerator_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = "preproc_if_in_enumerator_list_no_comma_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym__old_style_function_definition_repeat1] = "_old_style_function_definition_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__type_definition_type_repeat1] = "_type_definition_type_repeat1",
  [aux_sym__type_definition_declarators_repeat1] = "_type_definition_declarators_repeat1",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_function_declarator_repeat1] = "function_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym__field_declaration_declarator_repeat1] = "_field_declaration_declarator_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym__old_style_parameter_list_repeat1] = "_old_style_parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_char_literal_repeat1] = "char_literal_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym___extension__] = anon_sym___extension__,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_auto] = anon_sym_auto,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym___inline] = anon_sym___inline,
  [anon_sym___inline__] = anon_sym___inline__,
  [anon_sym___forceinline] = anon_sym___forceinline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym___thread] = anon_sym___thread,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym___try] = anon_sym___try,
  [anon_sym___except] = anon_sym___except,
  [anon_sym___finally] = anon_sym___finally,
  [anon_sym___leave] = anon_sym___leave,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym___alignof__] = anon_sym___alignof__,
  [anon_sym___alignof] = anon_sym___alignof,
  [anon_sym__alignof] = anon_sym__alignof,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym__Alignof] = anon_sym__Alignof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_field_declaration_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list_no_comma] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list_no_comma] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list_no_comma] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = sym_preproc_elifdef,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym__old_style_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__type_definition_type] = sym__type_definition_type,
  [sym__type_definition_declarators] = sym__type_definition_declarators,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__declaration_declarator] = sym__declaration_declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym__function_declaration_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym__old_style_function_declarator] = sym_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym__type_specifier] = sym__type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym__field_declaration_declarator] = sym__field_declaration_declarator,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym__old_style_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_body] = sym__for_statement_body,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_seh_try_statement] = sym_seh_try_statement,
  [sym_seh_except_clause] = sym_seh_except_clause,
  [sym_seh_finally_clause] = sym_seh_finally_clause,
  [sym_seh_leave_statement] = sym_seh_leave_statement,
  [sym__expression] = sym__expression,
  [sym__expression_not_binary] = sym__expression_not_binary,
  [sym__string] = sym__string,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_subscript_range_designator] = sym_subscript_range_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_macro_type_specifier] = sym_macro_type_specifier,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = aux_sym_preproc_if_in_enumerator_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym__old_style_function_definition_repeat1] = aux_sym__old_style_function_definition_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__type_definition_type_repeat1] = aux_sym__type_definition_type_repeat1,
  [aux_sym__type_definition_declarators_repeat1] = aux_sym__type_definition_declarators_repeat1,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_function_declarator_repeat1] = aux_sym_function_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym__field_declaration_declarator_repeat1] = aux_sym__field_declaration_declarator_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym__old_style_parameter_list_repeat1] = aux_sym__old_style_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_char_literal_repeat1] = aux_sym_char_literal_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___extension__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_auto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___leave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_definition_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_definition_declarators] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declaration_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_body] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__expression_not_binary] = {
    .visible = false,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_range_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_macro_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_declaration_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_char_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_body = 5,
  field_clobbers = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_declarator = 10,
  field_designator = 11,
  field_directive = 12,
  field_end = 13,
  field_field = 14,
  field_filter = 15,
  field_function = 16,
  field_goto_labels = 17,
  field_index = 18,
  field_initializer = 19,
  field_input_operands = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_operand = 25,
  field_operator = 26,
  field_output_operands = 27,
  field_parameters = 28,
  field_path = 29,
  field_prefix = 30,
  field_register = 31,
  field_right = 32,
  field_size = 33,
  field_start = 34,
  field_symbol = 35,
  field_type = 36,
  field_underlying_type = 37,
  field_update = 38,
  field_value = 39,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_body] = "body",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_end] = "end",
  [field_field] = "field",
  [field_filter] = "filter",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_right] = "right",
  [field_size] = "size",
  [field_start] = "start",
  [field_symbol] = "symbol",
  [field_type] = "type",
  [field_underlying_type] = "underlying_type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 3, .length = 1},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 8, .length = 1},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 1},
  [26] = {.index = 30, .length = 1},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 3},
  [31] = {.index = 39, .length = 1},
  [32] = {.index = 40, .length = 1},
  [33] = {.index = 41, .length = 3},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 2},
  [36] = {.index = 48, .length = 5},
  [37] = {.index = 53, .length = 3},
  [38] = {.index = 56, .length = 2},
  [39] = {.index = 58, .length = 2},
  [40] = {.index = 60, .length = 1},
  [41] = {.index = 61, .length = 2},
  [42] = {.index = 63, .length = 1},
  [43] = {.index = 64, .length = 2},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 2},
  [46] = {.index = 70, .length = 2},
  [47] = {.index = 72, .length = 2},
  [48] = {.index = 74, .length = 2},
  [49] = {.index = 76, .length = 2},
  [50] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 1},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 3},
  [56] = {.index = 87, .length = 1},
  [57] = {.index = 88, .length = 1},
  [58] = {.index = 89, .length = 1},
  [59] = {.index = 90, .length = 2},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 2},
  [62] = {.index = 95, .length = 3},
  [63] = {.index = 98, .length = 3},
  [64] = {.index = 101, .length = 2},
  [65] = {.index = 103, .length = 5},
  [66] = {.index = 108, .length = 3},
  [67] = {.index = 111, .length = 5},
  [68] = {.index = 116, .length = 2},
  [69] = {.index = 118, .length = 2},
  [70] = {.index = 120, .length = 3},
  [71] = {.index = 123, .length = 2},
  [72] = {.index = 125, .length = 2},
  [73] = {.index = 127, .length = 1},
  [74] = {.index = 128, .length = 2},
  [75] = {.index = 130, .length = 2},
  [76] = {.index = 132, .length = 2},
  [77] = {.index = 134, .length = 3},
  [78] = {.index = 137, .length = 2},
  [79] = {.index = 139, .length = 2},
  [80] = {.index = 141, .length = 2},
  [81] = {.index = 143, .length = 1},
  [82] = {.index = 144, .length = 2},
  [83] = {.index = 146, .length = 2},
  [84] = {.index = 148, .length = 4},
  [85] = {.index = 152, .length = 1},
  [86] = {.index = 153, .length = 2},
  [87] = {.index = 155, .length = 1},
  [88] = {.index = 156, .length = 1},
  [89] = {.index = 157, .length = 2},
  [90] = {.index = 159, .length = 2},
  [91] = {.index = 161, .length = 4},
  [92] = {.index = 165, .length = 5},
  [93] = {.index = 170, .length = 3},
  [94] = {.index = 173, .length = 2},
  [95] = {.index = 175, .length = 1},
  [97] = {.index = 176, .length = 2},
  [98] = {.index = 178, .length = 2},
  [99] = {.index = 180, .length = 2},
  [100] = {.index = 182, .length = 3},
  [101] = {.index = 185, .length = 2},
  [102] = {.index = 187, .length = 2},
  [103] = {.index = 189, .length = 2},
  [104] = {.index = 191, .length = 2},
  [105] = {.index = 193, .length = 3},
  [106] = {.index = 196, .length = 2},
  [107] = {.index = 198, .length = 1},
  [108] = {.index = 199, .length = 2},
  [109] = {.index = 201, .length = 2},
  [110] = {.index = 201, .length = 2},
  [111] = {.index = 203, .length = 3},
  [112] = {.index = 206, .length = 2},
  [113] = {.index = 208, .length = 1},
  [114] = {.index = 209, .length = 4},
  [115] = {.index = 213, .length = 3},
  [116] = {.index = 216, .length = 2},
  [117] = {.index = 218, .length = 2},
  [118] = {.index = 35, .length = 1},
  [119] = {.index = 220, .length = 5},
  [120] = {.index = 225, .length = 4},
  [121] = {.index = 229, .length = 2},
  [122] = {.index = 231, .length = 2},
  [123] = {.index = 233, .length = 2},
  [124] = {.index = 235, .length = 5},
  [125] = {.index = 240, .length = 2},
  [126] = {.index = 242, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 0, .inherited = true},
    {field_declarator, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [3] =
    {field_type, 0},
  [4] =
    {field_directive, 0},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_name, 1},
  [9] =
    {field_body, 1},
  [10] =
    {field_value, 1},
  [11] =
    {field_declarator, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [13] =
    {field_argument, 0},
    {field_operator, 1},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
  [17] =
    {field_type, 1},
  [18] =
    {field_path, 1},
  [19] =
    {field_argument, 1},
    {field_directive, 0},
  [21] =
    {field_declarator, 1},
    {field_type, 0},
  [23] =
    {field_parameters, 0},
  [24] =
    {field_declarator, 0},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_name, 1},
  [29] =
    {field_name, 2},
  [30] =
    {field_body, 2},
  [31] =
    {field_condition, 1},
    {field_consequence, 2},
  [33] =
    {field_body, 2},
    {field_condition, 1},
  [35] =
    {field_label, 1},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_label, 0},
  [40] =
    {field_declarator, 1},
  [41] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [44] =
    {field_declarator, 0},
    {field_parameters, 1},
  [46] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [48] =
    {field_body, 2},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [53] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [56] =
    {field_name, 1},
    {field_value, 2},
  [58] =
    {field_name, 1},
    {field_parameters, 2},
  [60] =
    {field_condition, 1},
  [61] =
    {field_alternative, 2},
    {field_name, 1},
  [63] =
    {field_type, 0, .inherited = true},
  [64] =
    {field_declarator, 2},
    {field_type, 0},
  [66] =
    {field_left, 0},
    {field_right, 2},
  [68] =
    {field_type, 1},
    {field_value, 3},
  [70] =
    {field_declarator, 2},
    {field_type, 1},
  [72] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [74] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [76] =
    {field_name, 2},
    {field_prefix, 0},
  [78] =
    {field_name, 1},
    {field_underlying_type, 3},
  [80] =
    {field_body, 3},
    {field_name, 2},
  [82] =
    {field_name, 3},
  [83] =
    {field_body, 3},
  [84] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [87] =
    {field_initializer, 0},
  [88] =
    {field_type, 2},
  [89] =
    {field_assembly_code, 2},
  [90] =
    {field_name, 0},
    {field_type, 2},
  [92] =
    {field_declarator, 2},
  [93] =
    {field_declarator, 0},
    {field_value, 2},
  [95] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [98] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [101] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [103] =
    {field_body, 3},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [108] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [111] =
    {field_body, 3},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [116] =
    {field_argument, 0},
    {field_index, 2},
  [118] =
    {field_alternative, 3},
    {field_condition, 0},
  [120] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [123] =
    {field_alternative, 3},
    {field_condition, 1},
  [125] =
    {field_alternative, 3},
    {field_name, 1},
  [127] =
    {field_size, 1},
  [128] =
    {field_declarator, 3},
    {field_type, 1},
  [130] =
    {field_declarator, 3, .inherited = true},
    {field_type, 2, .inherited = true},
  [132] =
    {field_name, 0},
    {field_value, 2},
  [134] =
    {field_body, 4},
    {field_name, 1},
    {field_underlying_type, 3},
  [137] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [139] =
    {field_body, 4},
    {field_name, 3},
  [141] =
    {field_body, 1},
    {field_condition, 3},
  [143] =
    {field_update, 2},
  [144] =
    {field_initializer, 0},
    {field_update, 2},
  [146] =
    {field_condition, 1},
    {field_initializer, 0},
  [148] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [152] =
    {field_operand, 1},
  [153] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [155] =
    {field_assembly_code, 3},
  [156] =
    {field_declarator, 3},
  [157] =
    {field_declarator, 0},
    {field_size, 2},
  [159] =
    {field_declarator, 1},
    {field_declarator, 2},
  [161] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [165] =
    {field_body, 4},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [170] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [173] =
    {field_alternative, 4},
    {field_condition, 1},
  [175] =
    {field_size, 2},
  [176] =
    {field_body, 2},
    {field_filter, 1},
  [178] =
    {field_declarator, 0},
    {field_declarator, 2, .inherited = true},
  [180] =
    {field_condition, 1},
    {field_update, 3},
  [182] =
    {field_condition, 1},
    {field_initializer, 0},
    {field_update, 3},
  [185] =
    {field_initializer, 0},
    {field_update, 3},
  [187] =
    {field_condition, 2},
    {field_initializer, 0},
  [189] =
    {field_member, 4},
    {field_type, 2},
  [191] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [193] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [196] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [198] =
    {field_declarator, 4},
  [199] =
    {field_declarator, 0},
    {field_size, 3},
  [201] =
    {field_designator, 0},
    {field_value, 2},
  [203] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [206] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [208] =
    {field_register, 1},
  [209] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [213] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [216] =
    {field_constraint, 0},
    {field_value, 2},
  [218] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [220] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [225] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [229] =
    {field_end, 3},
    {field_start, 1},
  [231] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [233] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [235] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [240] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [242] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [7] = {
    [1] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [0] = sym_primitive_type,
  },
  [24] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [2] = alias_sym_type_identifier,
  },
  [29] = {
    [1] = alias_sym_statement_identifier,
  },
  [31] = {
    [0] = alias_sym_statement_identifier,
  },
  [37] = {
    [2] = alias_sym_field_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [0] = alias_sym_field_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [53] = {
    [3] = alias_sym_type_identifier,
  },
  [77] = {
    [1] = alias_sym_type_identifier,
  },
  [79] = {
    [3] = alias_sym_type_identifier,
  },
  [96] = {
    [1] = alias_sym_field_identifier,
  },
  [103] = {
    [4] = alias_sym_field_identifier,
  },
  [109] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 2,
  [6] = 4,
  [7] = 4,
  [8] = 2,
  [9] = 4,
  [10] = 2,
  [11] = 4,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 15,
  [17] = 17,
  [18] = 14,
  [19] = 15,
  [20] = 14,
  [21] = 15,
  [22] = 14,
  [23] = 14,
  [24] = 15,
  [25] = 25,
  [26] = 26,
  [27] = 26,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 28,
  [34] = 26,
  [35] = 26,
  [36] = 36,
  [37] = 36,
  [38] = 32,
  [39] = 30,
  [40] = 28,
  [41] = 30,
  [42] = 30,
  [43] = 28,
  [44] = 32,
  [45] = 28,
  [46] = 32,
  [47] = 36,
  [48] = 36,
  [49] = 30,
  [50] = 36,
  [51] = 32,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 56,
  [60] = 58,
  [61] = 57,
  [62] = 55,
  [63] = 54,
  [64] = 58,
  [65] = 58,
  [66] = 58,
  [67] = 57,
  [68] = 56,
  [69] = 57,
  [70] = 57,
  [71] = 55,
  [72] = 55,
  [73] = 54,
  [74] = 55,
  [75] = 56,
  [76] = 54,
  [77] = 56,
  [78] = 54,
  [79] = 57,
  [80] = 56,
  [81] = 58,
  [82] = 54,
  [83] = 55,
  [84] = 84,
  [85] = 84,
  [86] = 84,
  [87] = 84,
  [88] = 84,
  [89] = 84,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 117,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 97,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 90,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 91,
  [167] = 98,
  [168] = 132,
  [169] = 130,
  [170] = 117,
  [171] = 126,
  [172] = 125,
  [173] = 124,
  [174] = 131,
  [175] = 123,
  [176] = 122,
  [177] = 127,
  [178] = 119,
  [179] = 114,
  [180] = 112,
  [181] = 113,
  [182] = 92,
  [183] = 120,
  [184] = 121,
  [185] = 93,
  [186] = 94,
  [187] = 95,
  [188] = 96,
  [189] = 110,
  [190] = 99,
  [191] = 100,
  [192] = 118,
  [193] = 108,
  [194] = 116,
  [195] = 134,
  [196] = 115,
  [197] = 101,
  [198] = 137,
  [199] = 102,
  [200] = 136,
  [201] = 103,
  [202] = 104,
  [203] = 105,
  [204] = 135,
  [205] = 106,
  [206] = 133,
  [207] = 107,
  [208] = 128,
  [209] = 109,
  [210] = 111,
  [211] = 97,
  [212] = 143,
  [213] = 161,
  [214] = 162,
  [215] = 164,
  [216] = 163,
  [217] = 149,
  [218] = 160,
  [219] = 152,
  [220] = 159,
  [221] = 153,
  [222] = 142,
  [223] = 141,
  [224] = 148,
  [225] = 156,
  [226] = 150,
  [227] = 227,
  [228] = 227,
  [229] = 90,
  [230] = 90,
  [231] = 144,
  [232] = 154,
  [233] = 139,
  [234] = 145,
  [235] = 165,
  [236] = 151,
  [237] = 146,
  [238] = 147,
  [239] = 155,
  [240] = 140,
  [241] = 157,
  [242] = 90,
  [243] = 137,
  [244] = 115,
  [245] = 110,
  [246] = 111,
  [247] = 118,
  [248] = 116,
  [249] = 115,
  [250] = 92,
  [251] = 113,
  [252] = 112,
  [253] = 107,
  [254] = 132,
  [255] = 130,
  [256] = 107,
  [257] = 97,
  [258] = 111,
  [259] = 136,
  [260] = 110,
  [261] = 131,
  [262] = 135,
  [263] = 101,
  [264] = 112,
  [265] = 109,
  [266] = 91,
  [267] = 133,
  [268] = 106,
  [269] = 113,
  [270] = 105,
  [271] = 104,
  [272] = 92,
  [273] = 102,
  [274] = 135,
  [275] = 103,
  [276] = 132,
  [277] = 120,
  [278] = 130,
  [279] = 109,
  [280] = 126,
  [281] = 102,
  [282] = 101,
  [283] = 100,
  [284] = 125,
  [285] = 117,
  [286] = 128,
  [287] = 126,
  [288] = 125,
  [289] = 99,
  [290] = 124,
  [291] = 124,
  [292] = 123,
  [293] = 123,
  [294] = 122,
  [295] = 98,
  [296] = 121,
  [297] = 96,
  [298] = 122,
  [299] = 118,
  [300] = 95,
  [301] = 94,
  [302] = 93,
  [303] = 114,
  [304] = 119,
  [305] = 127,
  [306] = 128,
  [307] = 122,
  [308] = 131,
  [309] = 116,
  [310] = 136,
  [311] = 134,
  [312] = 108,
  [313] = 137,
  [314] = 115,
  [315] = 111,
  [316] = 110,
  [317] = 127,
  [318] = 109,
  [319] = 91,
  [320] = 106,
  [321] = 105,
  [322] = 104,
  [323] = 103,
  [324] = 102,
  [325] = 121,
  [326] = 101,
  [327] = 100,
  [328] = 99,
  [329] = 98,
  [330] = 120,
  [331] = 96,
  [332] = 119,
  [333] = 95,
  [334] = 114,
  [335] = 94,
  [336] = 93,
  [337] = 93,
  [338] = 114,
  [339] = 119,
  [340] = 127,
  [341] = 128,
  [342] = 107,
  [343] = 94,
  [344] = 134,
  [345] = 95,
  [346] = 108,
  [347] = 96,
  [348] = 116,
  [349] = 133,
  [350] = 97,
  [351] = 98,
  [352] = 99,
  [353] = 123,
  [354] = 100,
  [355] = 124,
  [356] = 137,
  [357] = 121,
  [358] = 120,
  [359] = 118,
  [360] = 136,
  [361] = 92,
  [362] = 113,
  [363] = 135,
  [364] = 112,
  [365] = 126,
  [366] = 133,
  [367] = 125,
  [368] = 91,
  [369] = 106,
  [370] = 105,
  [371] = 132,
  [372] = 131,
  [373] = 130,
  [374] = 134,
  [375] = 104,
  [376] = 117,
  [377] = 103,
  [378] = 108,
  [379] = 379,
  [380] = 145,
  [381] = 381,
  [382] = 163,
  [383] = 164,
  [384] = 379,
  [385] = 385,
  [386] = 155,
  [387] = 160,
  [388] = 385,
  [389] = 389,
  [390] = 390,
  [391] = 390,
  [392] = 165,
  [393] = 156,
  [394] = 394,
  [395] = 159,
  [396] = 389,
  [397] = 161,
  [398] = 153,
  [399] = 385,
  [400] = 381,
  [401] = 153,
  [402] = 394,
  [403] = 394,
  [404] = 379,
  [405] = 381,
  [406] = 165,
  [407] = 381,
  [408] = 385,
  [409] = 381,
  [410] = 390,
  [411] = 159,
  [412] = 227,
  [413] = 155,
  [414] = 389,
  [415] = 379,
  [416] = 416,
  [417] = 389,
  [418] = 143,
  [419] = 416,
  [420] = 420,
  [421] = 152,
  [422] = 394,
  [423] = 154,
  [424] = 140,
  [425] = 151,
  [426] = 390,
  [427] = 139,
  [428] = 162,
  [429] = 143,
  [430] = 156,
  [431] = 389,
  [432] = 160,
  [433] = 154,
  [434] = 157,
  [435] = 420,
  [436] = 394,
  [437] = 148,
  [438] = 149,
  [439] = 379,
  [440] = 385,
  [441] = 420,
  [442] = 139,
  [443] = 420,
  [444] = 416,
  [445] = 416,
  [446] = 151,
  [447] = 162,
  [448] = 390,
  [449] = 157,
  [450] = 389,
  [451] = 147,
  [452] = 390,
  [453] = 147,
  [454] = 146,
  [455] = 146,
  [456] = 145,
  [457] = 385,
  [458] = 149,
  [459] = 144,
  [460] = 161,
  [461] = 420,
  [462] = 144,
  [463] = 164,
  [464] = 163,
  [465] = 420,
  [466] = 379,
  [467] = 416,
  [468] = 152,
  [469] = 148,
  [470] = 394,
  [471] = 140,
  [472] = 142,
  [473] = 141,
  [474] = 150,
  [475] = 150,
  [476] = 142,
  [477] = 416,
  [478] = 141,
  [479] = 156,
  [480] = 154,
  [481] = 227,
  [482] = 144,
  [483] = 141,
  [484] = 146,
  [485] = 485,
  [486] = 145,
  [487] = 162,
  [488] = 153,
  [489] = 148,
  [490] = 143,
  [491] = 157,
  [492] = 155,
  [493] = 142,
  [494] = 159,
  [495] = 163,
  [496] = 161,
  [497] = 152,
  [498] = 164,
  [499] = 150,
  [500] = 147,
  [501] = 160,
  [502] = 151,
  [503] = 139,
  [504] = 504,
  [505] = 165,
  [506] = 149,
  [507] = 507,
  [508] = 508,
  [509] = 508,
  [510] = 507,
  [511] = 508,
  [512] = 507,
  [513] = 508,
  [514] = 508,
  [515] = 508,
  [516] = 508,
  [517] = 507,
  [518] = 507,
  [519] = 508,
  [520] = 507,
  [521] = 507,
  [522] = 507,
  [523] = 227,
  [524] = 524,
  [525] = 525,
  [526] = 227,
  [527] = 227,
  [528] = 227,
  [529] = 90,
  [530] = 530,
  [531] = 531,
  [532] = 531,
  [533] = 531,
  [534] = 531,
  [535] = 531,
  [536] = 531,
  [537] = 531,
  [538] = 531,
  [539] = 531,
  [540] = 531,
  [541] = 531,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 553,
  [555] = 555,
  [556] = 556,
  [557] = 556,
  [558] = 555,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 561,
  [563] = 560,
  [564] = 564,
  [565] = 560,
  [566] = 561,
  [567] = 561,
  [568] = 560,
  [569] = 569,
  [570] = 569,
  [571] = 571,
  [572] = 572,
  [573] = 572,
  [574] = 569,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 572,
  [579] = 569,
  [580] = 580,
  [581] = 572,
  [582] = 582,
  [583] = 582,
  [584] = 584,
  [585] = 571,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 588,
  [591] = 591,
  [592] = 588,
  [593] = 593,
  [594] = 594,
  [595] = 588,
  [596] = 588,
  [597] = 594,
  [598] = 594,
  [599] = 599,
  [600] = 588,
  [601] = 588,
  [602] = 594,
  [603] = 603,
  [604] = 604,
  [605] = 594,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 588,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 614,
  [617] = 614,
  [618] = 618,
  [619] = 571,
  [620] = 620,
  [621] = 614,
  [622] = 614,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 614,
  [630] = 630,
  [631] = 631,
  [632] = 571,
  [633] = 614,
  [634] = 634,
  [635] = 635,
  [636] = 614,
  [637] = 611,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 638,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 639,
  [651] = 643,
  [652] = 652,
  [653] = 644,
  [654] = 648,
  [655] = 655,
  [656] = 647,
  [657] = 657,
  [658] = 658,
  [659] = 638,
  [660] = 660,
  [661] = 657,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 645,
  [666] = 666,
  [667] = 655,
  [668] = 668,
  [669] = 669,
  [670] = 662,
  [671] = 671,
  [672] = 639,
  [673] = 668,
  [674] = 674,
  [675] = 675,
  [676] = 643,
  [677] = 677,
  [678] = 668,
  [679] = 663,
  [680] = 639,
  [681] = 669,
  [682] = 658,
  [683] = 647,
  [684] = 664,
  [685] = 655,
  [686] = 668,
  [687] = 647,
  [688] = 666,
  [689] = 668,
  [690] = 690,
  [691] = 643,
  [692] = 639,
  [693] = 648,
  [694] = 664,
  [695] = 663,
  [696] = 658,
  [697] = 638,
  [698] = 660,
  [699] = 657,
  [700] = 662,
  [701] = 660,
  [702] = 663,
  [703] = 645,
  [704] = 664,
  [705] = 648,
  [706] = 666,
  [707] = 666,
  [708] = 655,
  [709] = 669,
  [710] = 645,
  [711] = 711,
  [712] = 668,
  [713] = 652,
  [714] = 669,
  [715] = 677,
  [716] = 643,
  [717] = 647,
  [718] = 669,
  [719] = 658,
  [720] = 638,
  [721] = 660,
  [722] = 657,
  [723] = 662,
  [724] = 724,
  [725] = 668,
  [726] = 662,
  [727] = 643,
  [728] = 674,
  [729] = 658,
  [730] = 638,
  [731] = 639,
  [732] = 648,
  [733] = 645,
  [734] = 734,
  [735] = 660,
  [736] = 657,
  [737] = 648,
  [738] = 724,
  [739] = 639,
  [740] = 677,
  [741] = 643,
  [742] = 648,
  [743] = 669,
  [744] = 655,
  [745] = 666,
  [746] = 664,
  [747] = 647,
  [748] = 663,
  [749] = 662,
  [750] = 643,
  [751] = 662,
  [752] = 657,
  [753] = 674,
  [754] = 660,
  [755] = 639,
  [756] = 648,
  [757] = 645,
  [758] = 758,
  [759] = 663,
  [760] = 638,
  [761] = 658,
  [762] = 658,
  [763] = 663,
  [764] = 647,
  [765] = 664,
  [766] = 666,
  [767] = 655,
  [768] = 669,
  [769] = 664,
  [770] = 647,
  [771] = 660,
  [772] = 657,
  [773] = 652,
  [774] = 655,
  [775] = 666,
  [776] = 674,
  [777] = 658,
  [778] = 638,
  [779] = 660,
  [780] = 657,
  [781] = 662,
  [782] = 663,
  [783] = 664,
  [784] = 666,
  [785] = 655,
  [786] = 669,
  [787] = 734,
  [788] = 668,
  [789] = 677,
  [790] = 711,
  [791] = 542,
  [792] = 792,
  [793] = 793,
  [794] = 793,
  [795] = 795,
  [796] = 793,
  [797] = 793,
  [798] = 793,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 524,
  [814] = 814,
  [815] = 814,
  [816] = 816,
  [817] = 525,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 822,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 819,
  [831] = 831,
  [832] = 819,
  [833] = 833,
  [834] = 826,
  [835] = 835,
  [836] = 836,
  [837] = 818,
  [838] = 826,
  [839] = 839,
  [840] = 818,
  [841] = 826,
  [842] = 842,
  [843] = 843,
  [844] = 826,
  [845] = 818,
  [846] = 822,
  [847] = 847,
  [848] = 822,
  [849] = 819,
  [850] = 850,
  [851] = 822,
  [852] = 819,
  [853] = 818,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 800,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 816,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 795,
  [872] = 799,
  [873] = 800,
  [874] = 792,
  [875] = 800,
  [876] = 800,
  [877] = 816,
  [878] = 878,
  [879] = 879,
  [880] = 879,
  [881] = 802,
  [882] = 882,
  [883] = 882,
  [884] = 879,
  [885] = 882,
  [886] = 879,
  [887] = 801,
  [888] = 882,
  [889] = 879,
  [890] = 882,
  [891] = 891,
  [892] = 891,
  [893] = 893,
  [894] = 891,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 891,
  [899] = 891,
  [900] = 891,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 800,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 901,
  [915] = 904,
  [916] = 916,
  [917] = 865,
  [918] = 918,
  [919] = 907,
  [920] = 909,
  [921] = 910,
  [922] = 911,
  [923] = 902,
  [924] = 913,
  [925] = 912,
  [926] = 903,
  [927] = 862,
  [928] = 906,
  [929] = 859,
  [930] = 858,
  [931] = 905,
  [932] = 864,
  [933] = 866,
  [934] = 904,
  [935] = 869,
  [936] = 905,
  [937] = 906,
  [938] = 912,
  [939] = 913,
  [940] = 902,
  [941] = 911,
  [942] = 910,
  [943] = 909,
  [944] = 907,
  [945] = 903,
  [946] = 901,
  [947] = 916,
  [948] = 870,
  [949] = 868,
  [950] = 860,
  [951] = 821,
  [952] = 811,
  [953] = 953,
  [954] = 954,
  [955] = 842,
  [956] = 809,
  [957] = 803,
  [958] = 836,
  [959] = 823,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 807,
  [964] = 806,
  [965] = 855,
  [966] = 966,
  [967] = 854,
  [968] = 810,
  [969] = 812,
  [970] = 831,
  [971] = 808,
  [972] = 847,
  [973] = 814,
  [974] = 974,
  [975] = 143,
  [976] = 151,
  [977] = 139,
  [978] = 156,
  [979] = 828,
  [980] = 829,
  [981] = 160,
  [982] = 154,
  [983] = 839,
  [984] = 827,
  [985] = 820,
  [986] = 986,
  [987] = 833,
  [988] = 805,
  [989] = 804,
  [990] = 843,
  [991] = 835,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 916,
  [996] = 996,
  [997] = 913,
  [998] = 860,
  [999] = 996,
  [1000] = 994,
  [1001] = 151,
  [1002] = 993,
  [1003] = 992,
  [1004] = 986,
  [1005] = 974,
  [1006] = 1006,
  [1007] = 895,
  [1008] = 953,
  [1009] = 143,
  [1010] = 954,
  [1011] = 960,
  [1012] = 961,
  [1013] = 868,
  [1014] = 962,
  [1015] = 966,
  [1016] = 1016,
  [1017] = 869,
  [1018] = 1018,
  [1019] = 904,
  [1020] = 866,
  [1021] = 1021,
  [1022] = 139,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 870,
  [1026] = 864,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 154,
  [1030] = 160,
  [1031] = 156,
  [1032] = 901,
  [1033] = 903,
  [1034] = 907,
  [1035] = 909,
  [1036] = 910,
  [1037] = 911,
  [1038] = 902,
  [1039] = 912,
  [1040] = 906,
  [1041] = 1041,
  [1042] = 905,
  [1043] = 801,
  [1044] = 525,
  [1045] = 802,
  [1046] = 916,
  [1047] = 1047,
  [1048] = 524,
  [1049] = 1049,
  [1050] = 151,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 996,
  [1054] = 1054,
  [1055] = 143,
  [1056] = 994,
  [1057] = 993,
  [1058] = 992,
  [1059] = 986,
  [1060] = 1060,
  [1061] = 974,
  [1062] = 953,
  [1063] = 954,
  [1064] = 960,
  [1065] = 961,
  [1066] = 962,
  [1067] = 966,
  [1068] = 151,
  [1069] = 1069,
  [1070] = 139,
  [1071] = 994,
  [1072] = 1069,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 996,
  [1078] = 1078,
  [1079] = 954,
  [1080] = 993,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 960,
  [1084] = 966,
  [1085] = 961,
  [1086] = 1069,
  [1087] = 1069,
  [1088] = 992,
  [1089] = 962,
  [1090] = 154,
  [1091] = 1069,
  [1092] = 160,
  [1093] = 156,
  [1094] = 154,
  [1095] = 139,
  [1096] = 143,
  [1097] = 986,
  [1098] = 160,
  [1099] = 156,
  [1100] = 974,
  [1101] = 953,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 92,
  [1118] = 1118,
  [1119] = 113,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 112,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 121,
  [1129] = 131,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 120,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1154,
  [1157] = 1154,
  [1158] = 1154,
  [1159] = 1154,
  [1160] = 1160,
  [1161] = 913,
  [1162] = 903,
  [1163] = 905,
  [1164] = 907,
  [1165] = 901,
  [1166] = 909,
  [1167] = 910,
  [1168] = 911,
  [1169] = 1169,
  [1170] = 902,
  [1171] = 904,
  [1172] = 912,
  [1173] = 1173,
  [1174] = 906,
  [1175] = 112,
  [1176] = 907,
  [1177] = 1177,
  [1178] = 903,
  [1179] = 1179,
  [1180] = 1179,
  [1181] = 121,
  [1182] = 1179,
  [1183] = 1179,
  [1184] = 120,
  [1185] = 92,
  [1186] = 113,
  [1187] = 904,
  [1188] = 901,
  [1189] = 1189,
  [1190] = 131,
  [1191] = 905,
  [1192] = 912,
  [1193] = 909,
  [1194] = 1179,
  [1195] = 910,
  [1196] = 911,
  [1197] = 902,
  [1198] = 906,
  [1199] = 913,
  [1200] = 1200,
  [1201] = 911,
  [1202] = 905,
  [1203] = 1203,
  [1204] = 903,
  [1205] = 1205,
  [1206] = 1173,
  [1207] = 901,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 907,
  [1212] = 909,
  [1213] = 904,
  [1214] = 910,
  [1215] = 902,
  [1216] = 913,
  [1217] = 912,
  [1218] = 906,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1234,
  [1237] = 1237,
  [1238] = 1231,
  [1239] = 1237,
  [1240] = 1233,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1242,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 910,
  [1249] = 911,
  [1250] = 1244,
  [1251] = 902,
  [1252] = 903,
  [1253] = 1244,
  [1254] = 1254,
  [1255] = 913,
  [1256] = 912,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1244,
  [1262] = 904,
  [1263] = 1242,
  [1264] = 901,
  [1265] = 906,
  [1266] = 1173,
  [1267] = 1267,
  [1268] = 1242,
  [1269] = 1247,
  [1270] = 905,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1267,
  [1275] = 1275,
  [1276] = 1272,
  [1277] = 1273,
  [1278] = 1278,
  [1279] = 1260,
  [1280] = 907,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1272,
  [1284] = 1242,
  [1285] = 909,
  [1286] = 1273,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1244,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1273,
  [1294] = 1260,
  [1295] = 1295,
  [1296] = 1272,
  [1297] = 1297,
  [1298] = 1272,
  [1299] = 1299,
  [1300] = 1287,
  [1301] = 1301,
  [1302] = 1273,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1307,
  [1309] = 1304,
  [1310] = 1304,
  [1311] = 1311,
  [1312] = 1303,
  [1313] = 1313,
  [1314] = 1304,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1304,
  [1319] = 1319,
  [1320] = 1303,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1303,
  [1329] = 1329,
  [1330] = 1327,
  [1331] = 1303,
  [1332] = 1332,
  [1333] = 1304,
  [1334] = 1304,
  [1335] = 1304,
  [1336] = 1324,
  [1337] = 1303,
  [1338] = 1338,
  [1339] = 1339,
  [1340] = 878,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1155,
  [1344] = 1344,
  [1345] = 1169,
  [1346] = 1203,
  [1347] = 1209,
  [1348] = 1208,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1125,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1362,
  [1363] = 1118,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1366,
  [1367] = 1367,
  [1368] = 1367,
  [1369] = 1367,
  [1370] = 1361,
  [1371] = 1366,
  [1372] = 1366,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1374,
  [1388] = 1388,
  [1389] = 1389,
  [1390] = 1383,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1391,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1377,
  [1400] = 1377,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1386,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 1377,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1374,
  [1416] = 1374,
  [1417] = 1380,
  [1418] = 1378,
  [1419] = 1376,
  [1420] = 1377,
  [1421] = 1381,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 847,
  [1428] = 1382,
  [1429] = 1395,
  [1430] = 1430,
  [1431] = 1423,
  [1432] = 1432,
  [1433] = 1385,
  [1434] = 1373,
  [1435] = 1396,
  [1436] = 1436,
  [1437] = 1224,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1413,
  [1441] = 1414,
  [1442] = 1230,
  [1443] = 1443,
  [1444] = 1432,
  [1445] = 1410,
  [1446] = 1439,
  [1447] = 1439,
  [1448] = 1403,
  [1449] = 1406,
  [1450] = 1426,
  [1451] = 1118,
  [1452] = 1409,
  [1453] = 1453,
  [1454] = 847,
  [1455] = 1430,
  [1456] = 1219,
  [1457] = 1398,
  [1458] = 1458,
  [1459] = 1459,
  [1460] = 1220,
  [1461] = 1107,
  [1462] = 1132,
  [1463] = 1115,
  [1464] = 1397,
  [1465] = 1424,
  [1466] = 1109,
  [1467] = 1116,
  [1468] = 1468,
  [1469] = 1106,
  [1470] = 1470,
  [1471] = 1458,
  [1472] = 1438,
  [1473] = 1125,
  [1474] = 1458,
  [1475] = 1111,
  [1476] = 1120,
  [1477] = 1439,
  [1478] = 1439,
  [1479] = 1479,
  [1480] = 1458,
  [1481] = 1408,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1482,
  [1485] = 1483,
  [1486] = 1482,
  [1487] = 1483,
  [1488] = 1482,
  [1489] = 1155,
  [1490] = 1483,
  [1491] = 1482,
  [1492] = 1483,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1500,
  [1503] = 1499,
  [1504] = 1500,
  [1505] = 1499,
  [1506] = 1500,
  [1507] = 1499,
  [1508] = 1508,
  [1509] = 1500,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1513,
  [1515] = 1515,
  [1516] = 1513,
  [1517] = 1512,
  [1518] = 1513,
  [1519] = 1513,
  [1520] = 1513,
  [1521] = 1512,
  [1522] = 1512,
  [1523] = 1513,
  [1524] = 1512,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1536,
  [1538] = 1538,
  [1539] = 1536,
  [1540] = 1540,
  [1541] = 1536,
  [1542] = 1536,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1545,
  [1554] = 1545,
  [1555] = 1545,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1545,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 1571,
  [1572] = 1571,
  [1573] = 1571,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1571,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1571,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1585,
  [1590] = 1585,
  [1591] = 1586,
  [1592] = 1587,
  [1593] = 1586,
  [1594] = 1585,
  [1595] = 1595,
  [1596] = 1587,
  [1597] = 1587,
  [1598] = 1586,
  [1599] = 1599,
  [1600] = 1587,
  [1601] = 1586,
  [1602] = 1599,
  [1603] = 1585,
  [1604] = 1583,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1609,
  [1616] = 1616,
  [1617] = 1609,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1609,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1609,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1625,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1656,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1660,
  [1668] = 1656,
  [1669] = 1662,
  [1670] = 1656,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1656,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1610,
  [1681] = 1656,
  [1682] = 1611,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1656,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1637,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1674,
  [1721] = 1721,
  [1722] = 1715,
  [1723] = 1716,
  [1724] = 1717,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1716,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1721,
  [1732] = 1716,
  [1733] = 1721,
  [1734] = 1734,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 1725,
  [1739] = 1739,
  [1740] = 1728,
  [1741] = 1717,
  [1742] = 1742,
  [1743] = 1716,
  [1744] = 1730,
  [1745] = 1736,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1725,
  [1750] = 1736,
  [1751] = 1730,
  [1752] = 1752,
  [1753] = 1736,
  [1754] = 1754,
  [1755] = 1715,
  [1756] = 1725,
  [1757] = 1730,
  [1758] = 1758,
  [1759] = 1717,
  [1760] = 1760,
  [1761] = 1737,
  [1762] = 1737,
  [1763] = 1728,
  [1764] = 1736,
  [1765] = 1765,
  [1766] = 1717,
  [1767] = 1767,
  [1768] = 1730,
  [1769] = 1737,
  [1770] = 1737,
  [1771] = 1716,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1721,
  [1775] = 1775,
  [1776] = 1721,
  [1777] = 1737,
  [1778] = 1778,
  [1779] = 1737,
  [1780] = 1737,
  [1781] = 1728,
  [1782] = 1715,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1737,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1801,
  [1802] = 1802,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1625,
  [1809] = 1809,
  [1810] = 1787,
  [1811] = 1804,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1786,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1804,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1788,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1805,
  [1832] = 1832,
  [1833] = 1833,
  [1834] = 1830,
  [1835] = 1803,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1824,
  [1839] = 1799,
  [1840] = 1840,
  [1841] = 1821,
  [1842] = 1842,
  [1843] = 1803,
  [1844] = 1844,
  [1845] = 1788,
  [1846] = 1804,
  [1847] = 1847,
  [1848] = 1848,
  [1849] = 1824,
  [1850] = 1809,
  [1851] = 1807,
  [1852] = 1806,
  [1853] = 1786,
  [1854] = 1805,
  [1855] = 1824,
  [1856] = 1809,
  [1857] = 1807,
  [1858] = 1806,
  [1859] = 1859,
  [1860] = 1786,
  [1861] = 1824,
  [1862] = 1862,
  [1863] = 1863,
  [1864] = 1809,
  [1865] = 1807,
  [1866] = 1806,
  [1867] = 1799,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 1786,
  [1871] = 1868,
  [1872] = 1806,
  [1873] = 1807,
  [1874] = 1809,
  [1875] = 1875,
  [1876] = 1788,
  [1877] = 1877,
  [1878] = 1833,
  [1879] = 1879,
  [1880] = 1880,
  [1881] = 1786,
  [1882] = 1882,
  [1883] = 1788,
  [1884] = 1879,
  [1885] = 1824,
  [1886] = 1886,
  [1887] = 1830,
  [1888] = 1830,
  [1889] = 1829,
  [1890] = 1793,
  [1891] = 1827,
  [1892] = 1812,
  [1893] = 1824,
  [1894] = 1809,
  [1895] = 1806,
  [1896] = 1807,
  [1897] = 1789,
  [1898] = 1807,
  [1899] = 1806,
  [1900] = 1823,
  [1901] = 1797,
  [1902] = 1801,
  [1903] = 1802,
  [1904] = 1875,
  [1905] = 1821,
  [1906] = 1809,
  [1907] = 1786,
  [1908] = 1908,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1911,
  [1913] = 1913,
  [1914] = 1914,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1918,
  [1919] = 1919,
  [1920] = 1920,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 1923,
  [1924] = 1924,
  [1925] = 1925,
  [1926] = 1926,
  [1927] = 1920,
  [1928] = 1925,
  [1929] = 1929,
  [1930] = 1922,
  [1931] = 1923,
  [1932] = 1925,
  [1933] = 1929,
  [1934] = 1911,
  [1935] = 1910,
  [1936] = 1936,
  [1937] = 1937,
  [1938] = 1922,
  [1939] = 1924,
  [1940] = 1923,
  [1941] = 1921,
  [1942] = 1925,
  [1943] = 1929,
  [1944] = 1922,
  [1945] = 1945,
  [1946] = 1946,
  [1947] = 1936,
  [1948] = 1910,
  [1949] = 1924,
  [1950] = 1923,
  [1951] = 1951,
  [1952] = 1921,
  [1953] = 1918,
  [1954] = 1954,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1913,
  [1959] = 1959,
  [1960] = 1960,
  [1961] = 1924,
  [1962] = 1962,
  [1963] = 1925,
  [1964] = 1964,
  [1965] = 1936,
  [1966] = 1929,
  [1967] = 1921,
  [1968] = 1922,
  [1969] = 1969,
  [1970] = 1936,
  [1971] = 1925,
  [1972] = 1972,
  [1973] = 1913,
  [1974] = 1974,
  [1975] = 1913,
  [1976] = 1922,
  [1977] = 1910,
  [1978] = 1921,
  [1979] = 1920,
  [1980] = 1920,
  [1981] = 1924,
  [1982] = 1982,
  [1983] = 1924,
  [1984] = 1957,
  [1985] = 1923,
  [1986] = 1921,
  [1987] = 1918,
  [1988] = 1988,
  [1989] = 1911,
  [1990] = 1990,
  [1991] = 1913,
  [1992] = 1911,
  [1993] = 1911,
  [1994] = 1913,
  [1995] = 1911,
  [1996] = 1996,
  [1997] = 1913,
  [1998] = 1913,
  [1999] = 1910,
  [2000] = 1929,
  [2001] = 1936,
  [2002] = 1910,
  [2003] = 1913,
  [2004] = 2004,
  [2005] = 1911,
  [2006] = 1920,
  [2007] = 1911,
  [2008] = 1936,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2014,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2015,
  [2024] = 2024,
  [2025] = 2025,
  [2026] = 2026,
  [2027] = 2027,
  [2028] = 2028,
  [2029] = 2027,
  [2030] = 2017,
  [2031] = 2026,
  [2032] = 2032,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2013,
  [2037] = 2037,
  [2038] = 2037,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2014,
  [2042] = 2024,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 2037,
  [2046] = 2046,
  [2047] = 2032,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2013,
  [2051] = 2051,
  [2052] = 2037,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2014,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 2032,
  [2061] = 2013,
  [2062] = 2012,
  [2063] = 2014,
  [2064] = 2037,
  [2065] = 2033,
  [2066] = 2032,
  [2067] = 2013,
  [2068] = 2013,
  [2069] = 2014,
  [2070] = 2070,
  [2071] = 2010,
  [2072] = 2072,
  [2073] = 2032,
  [2074] = 2074,
  [2075] = 2025,
  [2076] = 2076,
  [2077] = 2028,
  [2078] = 2026,
  [2079] = 2027,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2086,
  [2087] = 2033,
  [2088] = 2088,
  [2089] = 2086,
  [2090] = 2028,
  [2091] = 2085,
  [2092] = 2035,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 2095,
  [2096] = 2096,
  [2097] = 802,
  [2098] = 2033,
  [2099] = 2024,
  [2100] = 2100,
  [2101] = 2049,
  [2102] = 2081,
  [2103] = 2103,
  [2104] = 2032,
  [2105] = 2021,
  [2106] = 2106,
  [2107] = 2095,
  [2108] = 2020,
  [2109] = 2109,
  [2110] = 2035,
  [2111] = 2111,
  [2112] = 2095,
  [2113] = 2084,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2015,
  [2117] = 2117,
  [2118] = 2106,
  [2119] = 2119,
  [2120] = 2120,
  [2121] = 2012,
  [2122] = 2058,
  [2123] = 2037,
  [2124] = 2084,
  [2125] = 2125,
  [2126] = 2017,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2085,
  [2130] = 2130,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2021,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2131,
  [2138] = 2033,
  [2139] = 2070,
  [2140] = 2028,
  [2141] = 2086,
  [2142] = 2032,
  [2143] = 2028,
  [2144] = 2086,
  [2145] = 2145,
  [2146] = 2018,
  [2147] = 2147,
  [2148] = 2049,
  [2149] = 2017,
  [2150] = 2053,
  [2151] = 2151,
  [2152] = 2015,
  [2153] = 2014,
  [2154] = 1219,
  [2155] = 2072,
  [2156] = 2084,
  [2157] = 1224,
  [2158] = 2158,
  [2159] = 2055,
  [2160] = 2059,
  [2161] = 2085,
  [2162] = 2081,
  [2163] = 2080,
  [2164] = 2109,
  [2165] = 2147,
  [2166] = 2166,
  [2167] = 2167,
  [2168] = 2168,
  [2169] = 2013,
  [2170] = 2170,
  [2171] = 2051,
  [2172] = 2172,
  [2173] = 2024,
  [2174] = 2120,
  [2175] = 2106,
  [2176] = 2058,
  [2177] = 2177,
  [2178] = 2032,
  [2179] = 2179,
  [2180] = 2084,
  [2181] = 2181,
  [2182] = 2010,
  [2183] = 2072,
  [2184] = 801,
  [2185] = 2185,
  [2186] = 1220,
  [2187] = 2021,
  [2188] = 2188,
  [2189] = 2033,
  [2190] = 2080,
  [2191] = 2032,
  [2192] = 2192,
  [2193] = 2070,
  [2194] = 2194,
  [2195] = 2195,
  [2196] = 2049,
  [2197] = 2106,
  [2198] = 2013,
  [2199] = 2199,
  [2200] = 2120,
  [2201] = 2095,
  [2202] = 2058,
  [2203] = 2203,
  [2204] = 2021,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2207,
  [2208] = 2010,
  [2209] = 2072,
  [2210] = 2033,
  [2211] = 2211,
  [2212] = 2035,
  [2213] = 2213,
  [2214] = 2080,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2017,
  [2219] = 2219,
  [2220] = 2220,
  [2221] = 2081,
  [2222] = 2053,
  [2223] = 2059,
  [2224] = 2015,
  [2225] = 2014,
  [2226] = 2010,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 2115,
  [2230] = 2010,
  [2231] = 2010,
  [2232] = 2010,
  [2233] = 2053,
  [2234] = 2080,
  [2235] = 2085,
  [2236] = 2086,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 2238,
  [2240] = 2240,
  [2241] = 2228,
  [2242] = 2055,
  [2243] = 2028,
  [2244] = 2244,
  [2245] = 2033,
  [2246] = 2055,
  [2247] = 2247,
  [2248] = 2248,
  [2249] = 2082,
  [2250] = 2027,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2037,
  [2255] = 2255,
  [2256] = 2022,
  [2257] = 2058,
  [2258] = 2252,
  [2259] = 2095,
  [2260] = 2035,
  [2261] = 2238,
  [2262] = 2026,
  [2263] = 2263,
  [2264] = 2082,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2128,
  [2268] = 2268,
  [2269] = 2037,
  [2270] = 2270,
  [2271] = 2120,
  [2272] = 2082,
  [2273] = 2273,
  [2274] = 2251,
  [2275] = 2059,
  [2276] = 2058,
  [2277] = 1230,
  [2278] = 2278,
  [2279] = 2027,
  [2280] = 2082,
  [2281] = 2024,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2238,
  [2286] = 2012,
  [2287] = 2181,
  [2288] = 2026,
  [2289] = 2014,
  [2290] = 2238,
  [2291] = 2291,
  [2292] = 2072,
  [2293] = 2238,
  [2294] = 2012,
  [2295] = 2013,
  [2296] = 2227,
  [2297] = 2297,
  [2298] = 2010,
  [2299] = 2219,
};

static inline bool sym_number_literal_character_set_1(int32_t c) {
  return (c < 'b'
    ? (c < 'L'
      ? (c < 'D'
        ? c == 'B'
        : c <= 'F')
      : (c <= 'L' || (c < 'W'
        ? c == 'U'
        : c <= 'W')))
    : (c <= 'b' || (c < 'u'
      ? (c < 'l'
        ? (c >= 'd' && c <= 'f')
        : c <= 'l')
      : (c <= 'u' || c == 'w'))));
}

static inline bool sym_number_literal_character_set_2(int32_t c) {
  return (c < 'b'
    ? (c < 'L'
      ? (c < 'D'
        ? c == 'B'
        : (c <= 'D' || c == 'F'))
      : (c <= 'L' || (c < 'W'
        ? c == 'U'
        : c <= 'W')))
    : (c <= 'b' || (c < 'l'
      ? (c < 'f'
        ? c == 'd'
        : c <= 'f')
      : (c <= 'l' || (c < 'w'
        ? c == 'u'
        : c <= 'w')))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43488
    ? (c < 4159
      ? (c < 2654
        ? (c < 1808
          ? (c < 895
            ? (c < 192
              ? (c < 'a'
                ? (c < 'M'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'K')
                  : (c <= 'T' || (c < '_'
                    ? (c >= 'V' && c <= 'Z')
                    : c <= '_')))
                : (c <= 't' || (c < 181
                  ? (c < 170
                    ? (c >= 'v' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || c == 186))))
              : (c <= 214 || (c < 748
                ? (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))))))
            : (c <= 895 || (c < 1488
              ? (c < 1015
                ? (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))
                : (c <= 1153 || (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))))
              : (c <= 1514 || (c < 1749
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))
                : (c <= 1749 || (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))))))))
          : (c <= 1808 || (c < 2437
            ? (c < 2112
              ? (c < 2042
                ? (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2084
                  ? (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)
                  : (c <= 2084 || c == 2088))))
              : (c <= 2136 || (c < 2308
                ? (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c >= 2208 && c <= 2249)))
                : (c <= 2361 || (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))))))
            : (c <= 2444 || (c < 2544
              ? (c < 2486
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))
                : (c <= 2489 || (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))))
              : (c <= 2545 || (c < 2602
                ? (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))))))))))
        : (c <= 2654 || (c < 3205
          ? (c < 2929
            ? (c < 2809
              ? (c < 2738
                ? (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))
                : (c <= 2739 || (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c >= 2784 && c <= 2785)))))
              : (c <= 2809 || (c < 2866
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))))))
            : (c <= 2929 || (c < 3024
              ? (c < 2972
                ? (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3169 || c == 3200))))))))
          : (c <= 3212 || (c < 3520
            ? (c < 3346
              ? (c < 3293
                ? (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))))))))))))
      : (c <= 4159 || (c < 8126
        ? (c < 6103
          ? (c < 4792
            ? (c < 4304
              ? (c < 4213
                ? (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)))
                : (c <= 4225 || (c < 4295
                  ? (c < 4256
                    ? c == 4238
                    : c <= 4293)
                  : (c <= 4295 || c == 4301))))
              : (c <= 4346 || (c < 4698
                ? (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || c == 4696))
                : (c <= 4701 || (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))))))
            : (c <= 4798 || (c < 5743
              ? (c < 4888
                ? (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))
                : (c <= 4954 || (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))))
              : (c <= 5759 || (c < 5919
                ? (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c >= 5888 && c <= 5905)))
                : (c <= 5937 || (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)
                  : (c <= 6000 || (c >= 6016 && c <= 6067)))))))))
          : (c <= 6103 || (c < 7258
            ? (c < 6656
              ? (c < 6400
                ? (c < 6272
                  ? (c < 6176
                    ? c == 6108
                    : c <= 6264)
                  : (c <= 6312 || (c < 6320
                    ? c == 6314
                    : c <= 6389)))
                : (c <= 6430 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))))
              : (c <= 6678 || (c < 7043
                ? (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))))))
            : (c <= 7293 || (c < 7960
              ? (c < 7406
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))
                : (c <= 7411 || (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))))
              : (c <= 7965 || (c < 8027
                ? (c < 8016
                  ? (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c >= 8118 && c <= 8124)))))))))))
        : (c <= 8126 || (c < 12293
          ? (c < 8517
            ? (c < 8450
              ? (c < 8178
                ? (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))
                : (c <= 8180 || (c < 8319
                  ? (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))))
              : (c <= 8450 || (c < 8484
                ? (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c >= 8472 && c <= 8477)))
                : (c <= 8484 || (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c >= 8508 && c <= 8511)))))))
            : (c <= 8521 || (c < 11631
              ? (c < 11506
                ? (c < 11264
                  ? (c < 8544
                    ? c == 8526
                    : c <= 8584)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))
                : (c <= 11507 || (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))
              : (c <= 11631 || (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))))))
          : (c <= 12295 || (c < 42775
            ? (c < 12784
              ? (c < 12449
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)))
                : (c <= 12538 || (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))))
              : (c <= 12799 || (c < 42512
                ? (c < 42192
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)
                  : (c <= 42237 || (c >= 42240 && c <= 42508)))
                : (c <= 42527 || (c < 42623
                  ? (c < 42560
                    ? (c >= 42538 && c <= 42539)
                    : c <= 42606)
                  : (c <= 42653 || (c >= 42656 && c <= 42735)))))))
            : (c <= 42783 || (c < 43072
              ? (c < 42965
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43015
                  ? (c < 43011
                    ? (c >= 42994 && c <= 43009)
                    : c <= 43013)
                  : (c <= 43018 || (c >= 43020 && c <= 43042)))))
              : (c <= 43123 || (c < 43274
                ? (c < 43259
                  ? (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43396
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43334)
                    : c <= 43388)
                  : (c <= 43442 || c == 43471))))))))))))))
    : (c <= 43492 || (c < 70656
      ? (c < 66940
        ? (c < 64848
          ? (c < 43816
            ? (c < 43705
              ? (c < 43616
                ? (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)))
                : (c <= 43638 || (c < 43697
                  ? (c < 43646
                    ? c == 43642
                    : c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))))
              : (c <= 43709 || (c < 43762
                ? (c < 43739
                  ? (c < 43714
                    ? c == 43712
                    : c <= 43714)
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43793
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)
                  : (c <= 43798 || (c >= 43808 && c <= 43814)))))))
            : (c <= 43822 || (c < 64285
              ? (c < 55243
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44002 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c >= 64275 && c <= 64279)))))
              : (c <= 64285 || (c < 64320
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64287 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c >= 64612 && c <= 64829)))))))))
          : (c <= 64911 || (c < 65596
            ? (c < 65345
              ? (c < 65145
                ? (c < 65137
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c >= 65313 && c <= 65338)))))
              : (c <= 65370 || (c < 65490
                ? (c < 65474
                  ? (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65549
                  ? (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))))))
            : (c <= 65597 || (c < 66432
              ? (c < 66176
                ? (c < 65664
                  ? (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))
                : (c <= 66204 || (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))))
              : (c <= 66461 || (c < 66736
                ? (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))
                : (c <= 66771 || (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 66928 && c <= 66938)))))))))))
        : (c <= 66954 || (c < 68800
          ? (c < 67808
            ? (c < 67463
              ? (c < 67003
                ? (c < 66967
                  ? (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)
                  : (c <= 66977 || (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)))
                : (c <= 67004 || (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c >= 67456 && c <= 67461)))))
              : (c <= 67504 || (c < 67639
                ? (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))))))
            : (c <= 67826 || (c < 68192
              ? (c < 68030
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43494
    ? (c < 4186
      ? (c < 2703
        ? (c < 1969
          ? (c < 908
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))))
              : (c <= 721 || (c < 886
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c >= 904 && c <= 906)))))))
            : (c <= 908 || (c < 1646
              ? (c < 1369
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2185
              ? (c < 2084
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)))
                : (c <= 2084 || (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))))
              : (c <= 2190 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c >= 2693 && c <= 2701)))))))))))
        : (c <= 2705 || (c < 3218
          ? (c < 2958
            ? (c < 2835
              ? (c < 2768
                ? (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)))
                : (c <= 2768 || (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))))
              : (c <= 2856 || (c < 2908
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c >= 2949 && c <= 2954)))))))
            : (c <= 2960 || (c < 3086
              ? (c < 2979
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))))
              : (c <= 3088 || (c < 3165
                ? (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3165 || (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c >= 3214 && c <= 3216)))))))))
          : (c <= 3240 || (c < 3634
            ? (c < 3406
              ? (c < 3313
                ? (c < 3261
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3261 || (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3386 || c == 3389))))
              : (c <= 3406 || (c < 3482
                ? (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c >= 3585 && c <= 3632)))))))
            : (c <= 3634 || (c < 3776
              ? (c < 3724
                ? (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3762
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3760)
                  : (c <= 3762 || c == 3773))))
              : (c <= 3780 || (c < 3913
                ? (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c >= 4176 && c <= 4181)))))))))))))
      : (c <= 4189 || (c < 8130
        ? (c < 6108
          ? (c < 4802
            ? (c < 4682
              ? (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))))
              : (c <= 4685 || (c < 4746
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || c == 4800))))))
            : (c <= 4805 || (c < 5761
              ? (c < 4992
                ? (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))))
              : (c <= 5786 || (c < 5952
                ? (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))))))))
          : (c <= 6108 || (c < 7296
            ? (c < 6688
              ? (c < 6480
                ? (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))))
              : (c <= 6740 || (c < 7086
                ? (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))))))
            : (c <= 7304 || (c < 7968
              ? (c < 7413
                ? (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))
                : (c <= 7414 || (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))))
              : (c <= 8005 || (c < 8029
                ? (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))
                : (c <= 8029 || (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || c == 8126))))))))))
        : (c <= 8132 || (c < 12321
          ? (c < 8526
            ? (c < 8455
              ? (c < 8182
                ? (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))
                : (c <= 8188 || (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || c == 8450))))
              : (c <= 8455 || (c < 8486
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || c == 8484))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))))))
            : (c <= 8526 || (c < 11648
              ? (c < 11520
                ? (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || c == 11631))))
              : (c <= 11670 || (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))))))
          : (c <= 12329 || (c < 42786
            ? (c < 13312
              ? (c < 12540
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))
                : (c <= 12543 || (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))))
              : (c <= 19903 || (c < 42538
                ? (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c >= 42512 && c <= 42527)))
                : (c <= 42539 || (c < 42656
                  ? (c < 42623
                    ? (c >= 42560 && c <= 42606)
                    : c <= 42653)
                  : (c <= 42735 || (c >= 42775 && c <= 42783)))))))
            : (c <= 42888 || (c < 43138
              ? (c < 42994
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c >= 42965 && c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))))
              : (c <= 43187 || (c < 43312
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c >= 43488 && c <= 43492)))))))))))))))
    : (c <= 43503 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43824
            ? (c < 43712
              ? (c < 43642
                ? (c < 43584
                  ? (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)
                  : (c <= 43586 || (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)))
                : (c <= 43642 || (c < 43701
                  ? (c < 43697
                    ? (c >= 43646 && c <= 43695)
                    : c <= 43697)
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))))
              : (c <= 43712 || (c < 43777
                ? (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c >= 43816 && c <= 43822)))))))
            : (c <= 43866 || (c < 64287
              ? (c < 63744
                ? (c < 44032
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < '9'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '7')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(141);
      if (lookahead == '!') ADVANCE(213);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(89);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(221);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(279);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(139)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(52)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(52)
      if (lookahead == '\r') SKIP(1)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(56)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(56)
      if (lookahead == '\r') SKIP(3)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(55)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(55)
      if (lookahead == '\r') SKIP(5)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(58)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(58)
      if (lookahead == '\r') SKIP(7)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(54)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(54)
      if (lookahead == '\r') SKIP(9)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(60)
      if (lookahead == '\r') SKIP(11)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(64)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(64)
      if (lookahead == '\r') SKIP(13)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(65)
      if (lookahead == '\r') SKIP(15)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(71)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(71)
      if (lookahead == '\r') SKIP(17)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(70)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(70)
      if (lookahead == '\r') SKIP(19)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(62)
      if (lookahead == '\r') SKIP(21)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(63)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(63)
      if (lookahead == '\r') SKIP(23)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(61)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(61)
      if (lookahead == '\r') SKIP(25)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(66)
      if (lookahead == '\r') SKIP(27)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(59)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(59)
      if (lookahead == '\r') SKIP(29)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(33)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(33)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(150);
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '%') ADVANCE(229);
      if (lookahead == '&') ADVANCE(238);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '/') ADVANCE(227);
      if (lookahead == '<') ADVANCE(247);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(243);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(235);
      if (lookahead == '|') ADVANCE(234);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(69)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(69)
      if (lookahead == '\r') SKIP(34)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(68)
      if (lookahead == '\r') SKIP(36)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(67)
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '/') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(316);
      if (lookahead != 0) ADVANCE(317);
      END_STATE();
    case 39:
      if (lookahead == '\n') ADVANCE(319);
      if (lookahead == '\r') ADVANCE(318);
      if (lookahead == 'U') ADVANCE(136);
      if (lookahead == 'u') ADVANCE(128);
      if (lookahead == 'x') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(321);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(72)
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '/') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(305);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(307);
      if (lookahead != 0) ADVANCE(304);
      END_STATE();
    case 41:
      if (lookahead == '\n') ADVANCE(143);
      if (lookahead == '\r') ADVANCE(45);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(168);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 42:
      if (lookahead == '\n') ADVANCE(143);
      if (lookahead == '\r') ADVANCE(45);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(168);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 43:
      if (lookahead == '\n') ADVANCE(143);
      if (lookahead == '\r') ADVANCE(44);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') SKIP(47)
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(73)
      END_STATE();
    case 44:
      if (lookahead == '\n') ADVANCE(143);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') SKIP(47)
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(73)
      END_STATE();
    case 45:
      if (lookahead == '\n') ADVANCE(143);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(168);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(73)
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(73)
      if (lookahead == '\r') SKIP(46)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(53)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(53)
      if (lookahead == '\r') SKIP(48)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(57)
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(57)
      if (lookahead == '\r') SKIP(50)
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 52:
      if (lookahead == '!') ADVANCE(213);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(89);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(221);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(279);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 53:
      if (lookahead == '!') ADVANCE(213);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(99);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(221);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(279);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(258);
      if (lookahead == '\\') ADVANCE(49);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 54:
      if (lookahead == '!') ADVANCE(213);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(103);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(221);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(280);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(258);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 55:
      if (lookahead == '!') ADVANCE(212);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(89);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '&') ADVANCE(237);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(222);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == ']') ADVANCE(88);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 56:
      if (lookahead == '!') ADVANCE(212);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(95);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '&') ADVANCE(237);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(222);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(280);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '=') ADVANCE(261);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '}') ADVANCE(257);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 57:
      if (lookahead == '!') ADVANCE(212);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '&') ADVANCE(237);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(222);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 58:
      if (lookahead == '!') ADVANCE(212);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(93);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '&') ADVANCE(237);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(222);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 59:
      if (lookahead == '!') ADVANCE(212);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '+') ADVANCE(224);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == 'L') ADVANCE(333);
      if (lookahead == 'U') ADVANCE(334);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == 'u') ADVANCE(332);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 60:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(99);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(223);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(278);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(325);
      if (lookahead == 'U') ADVANCE(327);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(329);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(60)
      END_STATE();
    case 61:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(103);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(223);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(277);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(325);
      if (lookahead == 'U') ADVANCE(327);
      if (lookahead == '[') ADVANCE(258);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(329);
      if (lookahead == '|') ADVANCE(233);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61)
      END_STATE();
    case 62:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '#') ADVANCE(99);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(223);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(278);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62)
      END_STATE();
    case 63:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '#') ADVANCE(99);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(223);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(277);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(258);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == ']') ADVANCE(88);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 64:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '#') ADVANCE(90);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(223);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(278);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '#') ADVANCE(94);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(229);
      if (lookahead == '&') ADVANCE(238);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '/') ADVANCE(227);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(247);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(243);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '^') ADVANCE(235);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(234);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65)
      END_STATE();
    case 66:
      if (lookahead == '!') ADVANCE(82);
      if (lookahead == '#') ADVANCE(103);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(223);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(278);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(258);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == '|') ADVANCE(233);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66)
      END_STATE();
    case 67:
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67)
      END_STATE();
    case 68:
      if (lookahead == '"') ADVANCE(312);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '<') ADVANCE(84);
      if (lookahead == 'L') ADVANCE(325);
      if (lookahead == 'U') ADVANCE(327);
      if (lookahead == '\\') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(329);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(68)
      END_STATE();
    case 69:
      if (lookahead == '#') ADVANCE(112);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '}') ADVANCE(257);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(69)
      END_STATE();
    case 70:
      if (lookahead == '#') ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '[') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '}') ADVANCE(257);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70)
      END_STATE();
    case 71:
      if (lookahead == '#') ADVANCE(92);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(336);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '[') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(18);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(71)
      END_STATE();
    case 72:
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(72)
      END_STATE();
    case 73:
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') SKIP(47)
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(73)
      END_STATE();
    case 74:
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '/') ADVANCE(341);
      END_STATE();
    case 75:
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '/') ADVANCE(337);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 76:
      if (lookahead == '*') ADVANCE(75);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 77:
      if (lookahead == '*') ADVANCE(75);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 78:
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(283);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(284);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      END_STATE();
    case 79:
      if (lookahead == '.') ADVANCE(146);
      END_STATE();
    case 80:
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(168);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 81:
      if (lookahead == ':') ADVANCE(253);
      END_STATE();
    case 82:
      if (lookahead == '=') ADVANCE(241);
      END_STATE();
    case 83:
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 84:
      if (lookahead == '>') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 85:
      if (lookahead == '>') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 86:
      if (lookahead == 'U') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 87:
      if (lookahead == '[') ADVANCE(254);
      END_STATE();
    case 88:
      if (lookahead == ']') ADVANCE(255);
      END_STATE();
    case 89:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(204);
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 90:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(204);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(206);
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(206);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 95:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 96:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 97:
      if (lookahead == 'd') ADVANCE(110);
      END_STATE();
    case 98:
      if (lookahead == 'd') ADVANCE(102);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(113);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(99);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(114);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(103);
      END_STATE();
    case 104:
      if (lookahead == 'f') ADVANCE(158);
      END_STATE();
    case 105:
      if (lookahead == 'f') ADVANCE(151);
      END_STATE();
    case 106:
      if (lookahead == 'f') ADVANCE(161);
      END_STATE();
    case 107:
      if (lookahead == 'f') ADVANCE(163);
      END_STATE();
    case 108:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(104);
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 111:
      if (lookahead == 'i') ADVANCE(108);
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(109);
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 114:
      if (lookahead == 'l') ADVANCE(111);
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(282);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(284);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(336);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(288);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(318);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(124);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 128:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 129:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(127);
      END_STATE();
    case 130:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(128);
      END_STATE();
    case 131:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(129);
      END_STATE();
    case 132:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 133:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(131);
      END_STATE();
    case 134:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(132);
      END_STATE();
    case 135:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(133);
      END_STATE();
    case 136:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      END_STATE();
    case 137:
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(341);
      if (lookahead == '\r') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(343);
      END_STATE();
    case 138:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(171);
      END_STATE();
    case 139:
      if (eof) ADVANCE(141);
      if (lookahead == '!') ADVANCE(213);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(89);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '&') ADVANCE(239);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '+') ADVANCE(221);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(279);
      if (lookahead == '/') ADVANCE(228);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '<') ADVANCE(246);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(242);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '^') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '|') ADVANCE(233);
      if (lookahead == '}') ADVANCE(257);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(139)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 140:
      if (eof) ADVANCE(141);
      if (lookahead == '!') ADVANCE(212);
      if (lookahead == '"') ADVANCE(312);
      if (lookahead == '#') ADVANCE(95);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(336);
      if (lookahead == '&') ADVANCE(237);
      if (lookahead == '\'') ADVANCE(303);
      if (lookahead == '(') ADVANCE(211);
      if (lookahead == ')') ADVANCE(148);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '+') ADVANCE(222);
      if (lookahead == ',') ADVANCE(147);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(280);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == ':') ADVANCE(263);
      if (lookahead == ';') ADVANCE(252);
      if (lookahead == '=') ADVANCE(261);
      if (lookahead == 'L') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(326);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == 'u') ADVANCE(328);
      if (lookahead == '{') ADVANCE(256);
      if (lookahead == '}') ADVANCE(257);
      if (lookahead == '~') ADVANCE(214);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(140)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(186);
      if (lookahead == 'n') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(101);
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'n') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(337);
      if (lookahead == '\\') ADVANCE(172);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(172);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '\r') ADVANCE(338);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(342);
      if (lookahead != 0) ADVANCE(340);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(80)
      if (lookahead == '\r') ADVANCE(169);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(80)
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(166);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '*' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(166);
      if (lookahead == '\r') ADVANCE(175);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(171);
      if (lookahead == '\r') ADVANCE(176);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(340);
      if (lookahead == '\r') ADVANCE(344);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(342);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(166);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(172);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(171);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(173);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(149);
      if (lookahead == 'n') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(193);
      if (lookahead == 's') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(199);
      if (lookahead == 's') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(203);
      if (lookahead == 'n') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(241);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == '=') ADVANCE(269);
      if (lookahead == '>') ADVANCE(281);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(285);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '=') ADVANCE(269);
      if (lookahead == '>') ADVANCE(281);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(285);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(276);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(285);
      if (lookahead == '=') ADVANCE(268);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(276);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(285);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(276);
      if (lookahead == '=') ADVANCE(268);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(285);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(265);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '/') ADVANCE(341);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(267);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '|') ADVANCE(231);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(231);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(273);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(232);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(232);
      if (lookahead == '=') ADVANCE(272);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(251);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(250);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(249);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(248);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(270);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(271);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(254);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(79);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(282);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(282);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(116);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(282);
      if (sym_number_literal_character_set_1(lookahead)) ADVANCE(298);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(117);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(292);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(291);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(120);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(293);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(284);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(117);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(291);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'A' ||
          lookahead == 'C' ||
          lookahead == 'a' ||
          lookahead == 'c') ADVANCE(293);
      if (('B' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(284);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(115);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(294);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(78);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(295);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(115);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(297);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(120);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(295);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(115);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      if (sym_number_literal_character_set_1(lookahead)) ADVANCE(298);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(121);
      if (lookahead == 'B' ||
          lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'b' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(288);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(288);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(119);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(121);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(290);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(119);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(121);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(291);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(293);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(291);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'A' ||
          lookahead == 'C' ||
          lookahead == 'a' ||
          lookahead == 'c') ADVANCE(293);
      if (('B' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(284);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '.') ADVANCE(296);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(291);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(293);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(286);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(287);
      if (sym_number_literal_character_set_2(lookahead)) ADVANCE(298);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(121);
      if (lookahead == 'B' ||
          lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'b' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(288);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(288);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(295);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(290);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      if (sym_number_literal_character_set_2(lookahead)) ADVANCE(298);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_number_literal);
      if (sym_number_literal_character_set_2(lookahead)) ADVANCE(298);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_L_SQUOTE);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_u_SQUOTE);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_U_SQUOTE);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_u8_SQUOTE);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\n') ADVANCE(319);
      if (lookahead == '\r') ADVANCE(318);
      if (lookahead == 'U') ADVANCE(136);
      if (lookahead == 'u') ADVANCE(128);
      if (lookahead == 'x') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(321);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '/') ADVANCE(341);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\\') ADVANCE(39);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(315);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(317);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(314);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(315);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(314);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(315);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(313);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(316);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(317);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(317);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(39);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(318);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(320);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(308);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(299);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(308);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(310);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(310);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(309);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(300);
      if (lookahead == '8') ADVANCE(330);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(309);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(336);
      if (lookahead == '8') ADVANCE(331);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(311);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(311);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(300);
      if (lookahead == '8') ADVANCE(335);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(299);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\'') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(336);
      if (lookahead == '\\') ADVANCE(86);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(174);
      if (lookahead != 0) ADVANCE(340);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(341);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(340);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(340);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(341);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(340);
      if (lookahead == '\r') ADVANCE(344);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(342);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(341);
      if (lookahead == '\r') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(343);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(340);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(174);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(341);
      if (lookahead == '\\') ADVANCE(137);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'U') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'R') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 5:
      if (lookahead == 'A') ADVANCE(29);
      if (lookahead == 'G') ADVANCE(30);
      if (lookahead == 'N') ADVANCE(31);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'l') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(67);
      if (lookahead == 'y') ADVANCE(68);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'L') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'U') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'b') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(82);
      if (lookahead == 'd') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(84);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'i') ADVANCE(86);
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      if (lookahead == 's') ADVANCE(89);
      if (lookahead == 't') ADVANCE(90);
      if (lookahead == 'u') ADVANCE(91);
      if (lookahead == 'v') ADVANCE(92);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(96);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(118);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(124);
      if (lookahead == 'z') ADVANCE(125);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 73:
      if (lookahead == 'S') ADVANCE(139);
      END_STATE();
    case 74:
      if (lookahead == 'L') ADVANCE(140);
      END_STATE();
    case 75:
      if (lookahead == 'E') ADVANCE(141);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'x') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(157);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(160);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(164);
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(169);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(170);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(175);
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(179);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 106:
      if (lookahead == 'm') ADVANCE(181);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(186);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(187);
      if (lookahead == '3') ADVANCE(188);
      if (lookahead == '6') ADVANCE(189);
      if (lookahead == '8') ADVANCE(190);
      if (lookahead == 'p') ADVANCE(191);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(192);
      END_STATE();
    case 115:
      if (lookahead == '_') ADVANCE(193);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(197);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(200);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 126:
      if (lookahead == 'z') ADVANCE(204);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 135:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(213);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 139:
      if (lookahead == 'E') ADVANCE(215);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 143:
      if (lookahead == 'm') ADVANCE(217);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 147:
      if (lookahead == 'm') ADVANCE(221);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(222);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(227);
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(229);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 161:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(237);
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 163:
      if (lookahead == 'y') ADVANCE(239);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 167:
      if (lookahead == 'g') ADVANCE(243);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_auto);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_primitive_type);
      END_STATE();
    case 172:
      if (lookahead == 'k') ADVANCE(246);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(247);
      if (lookahead == '3') ADVANCE(248);
      if (lookahead == '6') ADVANCE(249);
      if (lookahead == '8') ADVANCE(250);
      if (lookahead == 'p') ADVANCE(251);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 176:
      if (lookahead == 'i') ADVANCE(253);
      END_STATE();
    case 177:
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 179:
      if (lookahead == 'l') ADVANCE(256);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 186:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 187:
      if (lookahead == '6') ADVANCE(259);
      END_STATE();
    case 188:
      if (lookahead == '2') ADVANCE(260);
      END_STATE();
    case 189:
      if (lookahead == '4') ADVANCE(261);
      END_STATE();
    case 190:
      if (lookahead == '_') ADVANCE(262);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 195:
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 197:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 198:
      if (lookahead == 's') ADVANCE(269);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 200:
      if (lookahead == 'r') ADVANCE(271);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 203:
      if (lookahead == '_') ADVANCE(274);
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(277);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(278);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(279);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 210:
      if (lookahead == '1') ADVANCE(282);
      if (lookahead == '3') ADVANCE(283);
      if (lookahead == '6') ADVANCE(284);
      if (lookahead == '8') ADVANCE(285);
      if (lookahead == 'p') ADVANCE(286);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 212:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(291);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(294);
      END_STATE();
    case 220:
      if (lookahead == 'g') ADVANCE(295);
      END_STATE();
    case 221:
      if (lookahead == '_') ADVANCE(296);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(298);
      END_STATE();
    case 224:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 225:
      if (lookahead == 'c') ADVANCE(300);
      END_STATE();
    case 226:
      if (lookahead == 'l') ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 229:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 230:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 231:
      if (lookahead == 'c') ADVANCE(306);
      END_STATE();
    case 232:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 233:
      if (lookahead == 'v') ADVANCE(308);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 236:
      if (lookahead == 'c') ADVANCE(311);
      END_STATE();
    case 237:
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym___try);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 241:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 242:
      if (lookahead == 't') ADVANCE(316);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(318);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(319);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 247:
      if (lookahead == '6') ADVANCE(320);
      END_STATE();
    case 248:
      if (lookahead == '2') ADVANCE(321);
      END_STATE();
    case 249:
      if (lookahead == '4') ADVANCE(322);
      END_STATE();
    case 250:
      if (lookahead == '_') ADVANCE(323);
      END_STATE();
    case 251:
      if (lookahead == 't') ADVANCE(324);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 254:
      if (lookahead == 'l') ADVANCE(327);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(328);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(329);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 259:
      if (lookahead == '_') ADVANCE(331);
      END_STATE();
    case 260:
      if (lookahead == '_') ADVANCE(332);
      END_STATE();
    case 261:
      if (lookahead == '_') ADVANCE(333);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(334);
      END_STATE();
    case 264:
      if (lookahead == 'l') ADVANCE(335);
      END_STATE();
    case 265:
      if (lookahead == 'u') ADVANCE(336);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(337);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(338);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(339);
      END_STATE();
    case 269:
      if (lookahead == 't') ADVANCE(340);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(341);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(342);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 273:
      if (lookahead == 'd') ADVANCE(343);
      END_STATE();
    case 274:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 275:
      if (lookahead == 'f') ADVANCE(344);
      END_STATE();
    case 276:
      if (lookahead == '_') ADVANCE(345);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(346);
      END_STATE();
    case 278:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 279:
      if (lookahead == 'h') ADVANCE(348);
      END_STATE();
    case 280:
      if (lookahead == 'd') ADVANCE(349);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 282:
      if (lookahead == '6') ADVANCE(351);
      END_STATE();
    case 283:
      if (lookahead == '2') ADVANCE(352);
      END_STATE();
    case 284:
      if (lookahead == '4') ADVANCE(353);
      END_STATE();
    case 285:
      if (lookahead == '_') ADVANCE(354);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 288:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(357);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 291:
      if (lookahead == 'o') ADVANCE(358);
      END_STATE();
    case 292:
      if (lookahead == 'c') ADVANCE(359);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(360);
      END_STATE();
    case 294:
      if (lookahead == 'u') ADVANCE(361);
      END_STATE();
    case 295:
      if (lookahead == 'n') ADVANCE(362);
      END_STATE();
    case 296:
      if (lookahead == '_') ADVANCE(363);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(364);
      END_STATE();
    case 298:
      if (lookahead == 'd') ADVANCE(365);
      END_STATE();
    case 299:
      if (lookahead == 'l') ADVANCE(366);
      END_STATE();
    case 300:
      if (lookahead == 'a') ADVANCE(367);
      END_STATE();
    case 301:
      if (lookahead == 's') ADVANCE(368);
      END_STATE();
    case 302:
      if (lookahead == 'p') ADVANCE(369);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(370);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(371);
      END_STATE();
    case 305:
      if (lookahead == 'l') ADVANCE(372);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(376);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_ms_signed_ptr_modifier);
      END_STATE();
    case 311:
      if (lookahead == 'a') ADVANCE(377);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(378);
      END_STATE();
    case 313:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(380);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_ms_unsigned_ptr_modifier);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(381);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 318:
      if (lookahead == 'g') ADVANCE(383);
      END_STATE();
    case 319:
      if (lookahead == 'f') ADVANCE(384);
      END_STATE();
    case 320:
      if (lookahead == '_') ADVANCE(385);
      END_STATE();
    case 321:
      if (lookahead == '_') ADVANCE(386);
      END_STATE();
    case 322:
      if (lookahead == '_') ADVANCE(387);
      END_STATE();
    case 323:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 324:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 325:
      if (lookahead == 'x') ADVANCE(389);
      END_STATE();
    case 326:
      if (lookahead == 'u') ADVANCE(390);
      END_STATE();
    case 327:
      if (lookahead == 't') ADVANCE(391);
      END_STATE();
    case 328:
      if (lookahead == 'd') ADVANCE(392);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 331:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 334:
      if (lookahead == '_') ADVANCE(393);
      END_STATE();
    case 335:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 336:
      if (lookahead == 'r') ADVANCE(395);
      END_STATE();
    case 337:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 338:
      if (lookahead == 'o') ADVANCE(397);
      END_STATE();
    case 339:
      if (lookahead == 'f') ADVANCE(398);
      END_STATE();
    case 340:
      if (lookahead == 'e') ADVANCE(399);
      END_STATE();
    case 341:
      if (lookahead == 'c') ADVANCE(400);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 345:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 349:
      if (lookahead == '_') ADVANCE(401);
      END_STATE();
    case 350:
      if (lookahead == 'f') ADVANCE(402);
      END_STATE();
    case 351:
      if (lookahead == '_') ADVANCE(403);
      END_STATE();
    case 352:
      if (lookahead == '_') ADVANCE(404);
      END_STATE();
    case 353:
      if (lookahead == '_') ADVANCE(405);
      END_STATE();
    case 354:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 355:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(407);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(408);
      END_STATE();
    case 358:
      if (lookahead == 'f') ADVANCE(409);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym__Atomic);
      END_STATE();
    case 360:
      if (lookahead == 'c') ADVANCE(410);
      END_STATE();
    case 361:
      if (lookahead == 'r') ADVANCE(411);
      END_STATE();
    case 362:
      if (lookahead == 'o') ADVANCE(412);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym___asm__);
      END_STATE();
    case 364:
      if (lookahead == 'b') ADVANCE(413);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym___based);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym___cdecl);
      END_STATE();
    case 367:
      if (lookahead == 'l') ADVANCE(414);
      END_STATE();
    case 368:
      if (lookahead == 'p') ADVANCE(415);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 370:
      if (lookahead == 's') ADVANCE(417);
      END_STATE();
    case 371:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 372:
      if (lookahead == 'l') ADVANCE(419);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(420);
      END_STATE();
    case 374:
      if (lookahead == 'e') ADVANCE(421);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym___leave);
      END_STATE();
    case 376:
      if (lookahead == 'i') ADVANCE(422);
      END_STATE();
    case 377:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 378:
      if (lookahead == 'a') ADVANCE(424);
      END_STATE();
    case 379:
      if (lookahead == 'd') ADVANCE(425);
      END_STATE();
    case 380:
      if (lookahead == 'g') ADVANCE(426);
      END_STATE();
    case 381:
      if (lookahead == 'r') ADVANCE(427);
      END_STATE();
    case 382:
      if (lookahead == 'f') ADVANCE(428);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(429);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_alignof);
      END_STATE();
    case 385:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 388:
      if (lookahead == '_') ADVANCE(430);
      END_STATE();
    case 389:
      if (lookahead == 'p') ADVANCE(431);
      END_STATE();
    case 390:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 394:
      if (lookahead == 'g') ADVANCE(433);
      END_STATE();
    case 395:
      if (lookahead == 'n') ADVANCE(434);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_nullptr);
      if (lookahead == '_') ADVANCE(435);
      END_STATE();
    case 397:
      if (lookahead == 'f') ADVANCE(436);
      END_STATE();
    case 398:
      if (lookahead == '_') ADVANCE(437);
      END_STATE();
    case 399:
      if (lookahead == 'r') ADVANCE(438);
      END_STATE();
    case 400:
      if (lookahead == 't') ADVANCE(439);
      END_STATE();
    case 401:
      if (lookahead == 'l') ADVANCE(440);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 403:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 406:
      if (lookahead == '_') ADVANCE(441);
      END_STATE();
    case 407:
      if (lookahead == 'd') ADVANCE(442);
      END_STATE();
    case 408:
      if (lookahead == 'e') ADVANCE(443);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym__Alignof);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym__Generic);
      END_STATE();
    case 411:
      if (lookahead == 'n') ADVANCE(444);
      END_STATE();
    case 412:
      if (lookahead == 'f') ADVANCE(445);
      END_STATE();
    case 413:
      if (lookahead == 'u') ADVANCE(446);
      END_STATE();
    case 414:
      if (lookahead == 'l') ADVANCE(447);
      END_STATE();
    case 415:
      if (lookahead == 'e') ADVANCE(448);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym___except);
      END_STATE();
    case 417:
      if (lookahead == 'i') ADVANCE(449);
      END_STATE();
    case 418:
      if (lookahead == 'l') ADVANCE(450);
      END_STATE();
    case 419:
      if (lookahead == 'y') ADVANCE(451);
      END_STATE();
    case 420:
      if (lookahead == 'n') ADVANCE(452);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym___inline);
      if (lookahead == '_') ADVANCE(453);
      END_STATE();
    case 422:
      if (lookahead == 'c') ADVANCE(454);
      END_STATE();
    case 423:
      if (lookahead == 'l') ADVANCE(455);
      END_STATE();
    case 424:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym___thread);
      END_STATE();
    case 426:
      if (lookahead == 'n') ADVANCE(457);
      END_STATE();
    case 427:
      if (lookahead == 'c') ADVANCE(458);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym__alignof);
      END_STATE();
    case 429:
      if (lookahead == 'e') ADVANCE(459);
      END_STATE();
    case 430:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 431:
      if (lookahead == 'r') ADVANCE(460);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 433:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_noreturn);
      END_STATE();
    case 435:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_offsetof);
      END_STATE();
    case 437:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_register);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_restrict);
      END_STATE();
    case 440:
      if (lookahead == 'o') ADVANCE(462);
      END_STATE();
    case 441:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym__Noreturn);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym___alignof);
      if (lookahead == '_') ADVANCE(463);
      END_STATE();
    case 446:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym___clrcall);
      END_STATE();
    case 448:
      if (lookahead == 'c') ADVANCE(465);
      END_STATE();
    case 449:
      if (lookahead == 'o') ADVANCE(466);
      END_STATE();
    case 450:
      if (lookahead == 'l') ADVANCE(467);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym___finally);
      END_STATE();
    case 452:
      if (lookahead == 'l') ADVANCE(468);
      END_STATE();
    case 453:
      if (lookahead == '_') ADVANCE(469);
      END_STATE();
    case 454:
      if (lookahead == 't') ADVANCE(470);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym___stdcall);
      END_STATE();
    case 456:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 457:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 458:
      if (lookahead == 'a') ADVANCE(473);
      END_STATE();
    case 459:
      if (lookahead == 'd') ADVANCE(474);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_constexpr);
      END_STATE();
    case 461:
      if (lookahead == '_') ADVANCE(475);
      END_STATE();
    case 462:
      if (lookahead == 'c') ADVANCE(476);
      END_STATE();
    case 463:
      if (lookahead == '_') ADVANCE(477);
      END_STATE();
    case 464:
      if (lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym___declspec);
      END_STATE();
    case 466:
      if (lookahead == 'n') ADVANCE(479);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym___fastcall);
      END_STATE();
    case 468:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym___inline__);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_ms_restrict_modifier);
      if (lookahead == '_') ADVANCE(481);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym___thiscall);
      END_STATE();
    case 472:
      if (lookahead == 'd') ADVANCE(482);
      END_STATE();
    case 473:
      if (lookahead == 'l') ADVANCE(483);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym__unaligned);
      END_STATE();
    case 475:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 476:
      if (lookahead == 'a') ADVANCE(484);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym___alignof__);
      END_STATE();
    case 478:
      if (lookahead == '_') ADVANCE(485);
      END_STATE();
    case 479:
      if (lookahead == '_') ADVANCE(486);
      END_STATE();
    case 480:
      if (lookahead == 'n') ADVANCE(487);
      END_STATE();
    case 481:
      if (lookahead == '_') ADVANCE(488);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym___unaligned);
      END_STATE();
    case 483:
      if (lookahead == 'l') ADVANCE(489);
      END_STATE();
    case 484:
      if (lookahead == 'l') ADVANCE(490);
      END_STATE();
    case 485:
      if (lookahead == '_') ADVANCE(491);
      END_STATE();
    case 486:
      if (lookahead == '_') ADVANCE(492);
      END_STATE();
    case 487:
      if (lookahead == 'e') ADVANCE(493);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym___restrict__);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym___vectorcall);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_thread_local);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym___attribute__);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym___extension__);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym___forceinline);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 140},
  [2] = {.lex_state = 55},
  [3] = {.lex_state = 55},
  [4] = {.lex_state = 55},
  [5] = {.lex_state = 55},
  [6] = {.lex_state = 55},
  [7] = {.lex_state = 55},
  [8] = {.lex_state = 55},
  [9] = {.lex_state = 55},
  [10] = {.lex_state = 55},
  [11] = {.lex_state = 55},
  [12] = {.lex_state = 58},
  [13] = {.lex_state = 58},
  [14] = {.lex_state = 58},
  [15] = {.lex_state = 58},
  [16] = {.lex_state = 58},
  [17] = {.lex_state = 58},
  [18] = {.lex_state = 58},
  [19] = {.lex_state = 58},
  [20] = {.lex_state = 58},
  [21] = {.lex_state = 58},
  [22] = {.lex_state = 58},
  [23] = {.lex_state = 58},
  [24] = {.lex_state = 58},
  [25] = {.lex_state = 58},
  [26] = {.lex_state = 55},
  [27] = {.lex_state = 58},
  [28] = {.lex_state = 140},
  [29] = {.lex_state = 57},
  [30] = {.lex_state = 140},
  [31] = {.lex_state = 57},
  [32] = {.lex_state = 140},
  [33] = {.lex_state = 140},
  [34] = {.lex_state = 140},
  [35] = {.lex_state = 57},
  [36] = {.lex_state = 140},
  [37] = {.lex_state = 140},
  [38] = {.lex_state = 140},
  [39] = {.lex_state = 140},
  [40] = {.lex_state = 140},
  [41] = {.lex_state = 140},
  [42] = {.lex_state = 140},
  [43] = {.lex_state = 140},
  [44] = {.lex_state = 140},
  [45] = {.lex_state = 140},
  [46] = {.lex_state = 140},
  [47] = {.lex_state = 140},
  [48] = {.lex_state = 140},
  [49] = {.lex_state = 140},
  [50] = {.lex_state = 140},
  [51] = {.lex_state = 140},
  [52] = {.lex_state = 140},
  [53] = {.lex_state = 140},
  [54] = {.lex_state = 55},
  [55] = {.lex_state = 55},
  [56] = {.lex_state = 55},
  [57] = {.lex_state = 55},
  [58] = {.lex_state = 55},
  [59] = {.lex_state = 58},
  [60] = {.lex_state = 58},
  [61] = {.lex_state = 58},
  [62] = {.lex_state = 58},
  [63] = {.lex_state = 58},
  [64] = {.lex_state = 140},
  [65] = {.lex_state = 140},
  [66] = {.lex_state = 57},
  [67] = {.lex_state = 57},
  [68] = {.lex_state = 140},
  [69] = {.lex_state = 140},
  [70] = {.lex_state = 140},
  [71] = {.lex_state = 57},
  [72] = {.lex_state = 140},
  [73] = {.lex_state = 140},
  [74] = {.lex_state = 140},
  [75] = {.lex_state = 140},
  [76] = {.lex_state = 140},
  [77] = {.lex_state = 57},
  [78] = {.lex_state = 57},
  [79] = {.lex_state = 140},
  [80] = {.lex_state = 140},
  [81] = {.lex_state = 140},
  [82] = {.lex_state = 140},
  [83] = {.lex_state = 140},
  [84] = {.lex_state = 140},
  [85] = {.lex_state = 140},
  [86] = {.lex_state = 140},
  [87] = {.lex_state = 140},
  [88] = {.lex_state = 140},
  [89] = {.lex_state = 140},
  [90] = {.lex_state = 55},
  [91] = {.lex_state = 55},
  [92] = {.lex_state = 55},
  [93] = {.lex_state = 55},
  [94] = {.lex_state = 55},
  [95] = {.lex_state = 55},
  [96] = {.lex_state = 55},
  [97] = {.lex_state = 140},
  [98] = {.lex_state = 55},
  [99] = {.lex_state = 55},
  [100] = {.lex_state = 55},
  [101] = {.lex_state = 55},
  [102] = {.lex_state = 55},
  [103] = {.lex_state = 55},
  [104] = {.lex_state = 55},
  [105] = {.lex_state = 55},
  [106] = {.lex_state = 55},
  [107] = {.lex_state = 55},
  [108] = {.lex_state = 55},
  [109] = {.lex_state = 55},
  [110] = {.lex_state = 55},
  [111] = {.lex_state = 55},
  [112] = {.lex_state = 55},
  [113] = {.lex_state = 55},
  [114] = {.lex_state = 55},
  [115] = {.lex_state = 55},
  [116] = {.lex_state = 55},
  [117] = {.lex_state = 140},
  [118] = {.lex_state = 55},
  [119] = {.lex_state = 55},
  [120] = {.lex_state = 55},
  [121] = {.lex_state = 55},
  [122] = {.lex_state = 55},
  [123] = {.lex_state = 55},
  [124] = {.lex_state = 55},
  [125] = {.lex_state = 55},
  [126] = {.lex_state = 55},
  [127] = {.lex_state = 55},
  [128] = {.lex_state = 55},
  [129] = {.lex_state = 55},
  [130] = {.lex_state = 55},
  [131] = {.lex_state = 55},
  [132] = {.lex_state = 55},
  [133] = {.lex_state = 55},
  [134] = {.lex_state = 55},
  [135] = {.lex_state = 55},
  [136] = {.lex_state = 55},
  [137] = {.lex_state = 55},
  [138] = {.lex_state = 55},
  [139] = {.lex_state = 55},
  [140] = {.lex_state = 55},
  [141] = {.lex_state = 55},
  [142] = {.lex_state = 55},
  [143] = {.lex_state = 55},
  [144] = {.lex_state = 55},
  [145] = {.lex_state = 55},
  [146] = {.lex_state = 55},
  [147] = {.lex_state = 55},
  [148] = {.lex_state = 55},
  [149] = {.lex_state = 55},
  [150] = {.lex_state = 55},
  [151] = {.lex_state = 55},
  [152] = {.lex_state = 55},
  [153] = {.lex_state = 55},
  [154] = {.lex_state = 55},
  [155] = {.lex_state = 55},
  [156] = {.lex_state = 55},
  [157] = {.lex_state = 55},
  [158] = {.lex_state = 58},
  [159] = {.lex_state = 55},
  [160] = {.lex_state = 55},
  [161] = {.lex_state = 55},
  [162] = {.lex_state = 55},
  [163] = {.lex_state = 55},
  [164] = {.lex_state = 55},
  [165] = {.lex_state = 55},
  [166] = {.lex_state = 58},
  [167] = {.lex_state = 58},
  [168] = {.lex_state = 58},
  [169] = {.lex_state = 58},
  [170] = {.lex_state = 58},
  [171] = {.lex_state = 58},
  [172] = {.lex_state = 58},
  [173] = {.lex_state = 58},
  [174] = {.lex_state = 58},
  [175] = {.lex_state = 58},
  [176] = {.lex_state = 58},
  [177] = {.lex_state = 58},
  [178] = {.lex_state = 58},
  [179] = {.lex_state = 58},
  [180] = {.lex_state = 58},
  [181] = {.lex_state = 58},
  [182] = {.lex_state = 58},
  [183] = {.lex_state = 58},
  [184] = {.lex_state = 58},
  [185] = {.lex_state = 58},
  [186] = {.lex_state = 58},
  [187] = {.lex_state = 58},
  [188] = {.lex_state = 58},
  [189] = {.lex_state = 58},
  [190] = {.lex_state = 58},
  [191] = {.lex_state = 58},
  [192] = {.lex_state = 58},
  [193] = {.lex_state = 58},
  [194] = {.lex_state = 58},
  [195] = {.lex_state = 58},
  [196] = {.lex_state = 58},
  [197] = {.lex_state = 58},
  [198] = {.lex_state = 58},
  [199] = {.lex_state = 58},
  [200] = {.lex_state = 58},
  [201] = {.lex_state = 58},
  [202] = {.lex_state = 58},
  [203] = {.lex_state = 58},
  [204] = {.lex_state = 58},
  [205] = {.lex_state = 58},
  [206] = {.lex_state = 58},
  [207] = {.lex_state = 58},
  [208] = {.lex_state = 58},
  [209] = {.lex_state = 58},
  [210] = {.lex_state = 58},
  [211] = {.lex_state = 58},
  [212] = {.lex_state = 58},
  [213] = {.lex_state = 58},
  [214] = {.lex_state = 58},
  [215] = {.lex_state = 58},
  [216] = {.lex_state = 58},
  [217] = {.lex_state = 58},
  [218] = {.lex_state = 58},
  [219] = {.lex_state = 58},
  [220] = {.lex_state = 58},
  [221] = {.lex_state = 58},
  [222] = {.lex_state = 58},
  [223] = {.lex_state = 58},
  [224] = {.lex_state = 58},
  [225] = {.lex_state = 58},
  [226] = {.lex_state = 58},
  [227] = {.lex_state = 53},
  [228] = {.lex_state = 53},
  [229] = {.lex_state = 140},
  [230] = {.lex_state = 57},
  [231] = {.lex_state = 58},
  [232] = {.lex_state = 58},
  [233] = {.lex_state = 58},
  [234] = {.lex_state = 58},
  [235] = {.lex_state = 58},
  [236] = {.lex_state = 58},
  [237] = {.lex_state = 58},
  [238] = {.lex_state = 58},
  [239] = {.lex_state = 58},
  [240] = {.lex_state = 58},
  [241] = {.lex_state = 58},
  [242] = {.lex_state = 140},
  [243] = {.lex_state = 57},
  [244] = {.lex_state = 57},
  [245] = {.lex_state = 140},
  [246] = {.lex_state = 140},
  [247] = {.lex_state = 140},
  [248] = {.lex_state = 140},
  [249] = {.lex_state = 140},
  [250] = {.lex_state = 140},
  [251] = {.lex_state = 140},
  [252] = {.lex_state = 140},
  [253] = {.lex_state = 140},
  [254] = {.lex_state = 140},
  [255] = {.lex_state = 140},
  [256] = {.lex_state = 57},
  [257] = {.lex_state = 57},
  [258] = {.lex_state = 140},
  [259] = {.lex_state = 57},
  [260] = {.lex_state = 140},
  [261] = {.lex_state = 140},
  [262] = {.lex_state = 57},
  [263] = {.lex_state = 140},
  [264] = {.lex_state = 140},
  [265] = {.lex_state = 140},
  [266] = {.lex_state = 140},
  [267] = {.lex_state = 57},
  [268] = {.lex_state = 140},
  [269] = {.lex_state = 140},
  [270] = {.lex_state = 140},
  [271] = {.lex_state = 140},
  [272] = {.lex_state = 140},
  [273] = {.lex_state = 140},
  [274] = {.lex_state = 140},
  [275] = {.lex_state = 140},
  [276] = {.lex_state = 57},
  [277] = {.lex_state = 140},
  [278] = {.lex_state = 57},
  [279] = {.lex_state = 140},
  [280] = {.lex_state = 140},
  [281] = {.lex_state = 140},
  [282] = {.lex_state = 140},
  [283] = {.lex_state = 140},
  [284] = {.lex_state = 140},
  [285] = {.lex_state = 57},
  [286] = {.lex_state = 140},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 57},
  [289] = {.lex_state = 140},
  [290] = {.lex_state = 57},
  [291] = {.lex_state = 140},
  [292] = {.lex_state = 140},
  [293] = {.lex_state = 57},
  [294] = {.lex_state = 57},
  [295] = {.lex_state = 140},
  [296] = {.lex_state = 140},
  [297] = {.lex_state = 140},
  [298] = {.lex_state = 140},
  [299] = {.lex_state = 57},
  [300] = {.lex_state = 140},
  [301] = {.lex_state = 140},
  [302] = {.lex_state = 140},
  [303] = {.lex_state = 140},
  [304] = {.lex_state = 140},
  [305] = {.lex_state = 140},
  [306] = {.lex_state = 140},
  [307] = {.lex_state = 140},
  [308] = {.lex_state = 140},
  [309] = {.lex_state = 57},
  [310] = {.lex_state = 140},
  [311] = {.lex_state = 140},
  [312] = {.lex_state = 140},
  [313] = {.lex_state = 140},
  [314] = {.lex_state = 140},
  [315] = {.lex_state = 57},
  [316] = {.lex_state = 57},
  [317] = {.lex_state = 140},
  [318] = {.lex_state = 57},
  [319] = {.lex_state = 57},
  [320] = {.lex_state = 57},
  [321] = {.lex_state = 57},
  [322] = {.lex_state = 57},
  [323] = {.lex_state = 57},
  [324] = {.lex_state = 57},
  [325] = {.lex_state = 140},
  [326] = {.lex_state = 57},
  [327] = {.lex_state = 57},
  [328] = {.lex_state = 57},
  [329] = {.lex_state = 57},
  [330] = {.lex_state = 140},
  [331] = {.lex_state = 57},
  [332] = {.lex_state = 140},
  [333] = {.lex_state = 57},
  [334] = {.lex_state = 140},
  [335] = {.lex_state = 57},
  [336] = {.lex_state = 140},
  [337] = {.lex_state = 57},
  [338] = {.lex_state = 57},
  [339] = {.lex_state = 57},
  [340] = {.lex_state = 57},
  [341] = {.lex_state = 57},
  [342] = {.lex_state = 140},
  [343] = {.lex_state = 140},
  [344] = {.lex_state = 57},
  [345] = {.lex_state = 140},
  [346] = {.lex_state = 57},
  [347] = {.lex_state = 140},
  [348] = {.lex_state = 140},
  [349] = {.lex_state = 140},
  [350] = {.lex_state = 140},
  [351] = {.lex_state = 140},
  [352] = {.lex_state = 140},
  [353] = {.lex_state = 140},
  [354] = {.lex_state = 140},
  [355] = {.lex_state = 140},
  [356] = {.lex_state = 140},
  [357] = {.lex_state = 57},
  [358] = {.lex_state = 57},
  [359] = {.lex_state = 140},
  [360] = {.lex_state = 140},
  [361] = {.lex_state = 57},
  [362] = {.lex_state = 57},
  [363] = {.lex_state = 140},
  [364] = {.lex_state = 57},
  [365] = {.lex_state = 140},
  [366] = {.lex_state = 140},
  [367] = {.lex_state = 140},
  [368] = {.lex_state = 140},
  [369] = {.lex_state = 140},
  [370] = {.lex_state = 140},
  [371] = {.lex_state = 140},
  [372] = {.lex_state = 57},
  [373] = {.lex_state = 140},
  [374] = {.lex_state = 140},
  [375] = {.lex_state = 140},
  [376] = {.lex_state = 140},
  [377] = {.lex_state = 140},
  [378] = {.lex_state = 140},
  [379] = {.lex_state = 140},
  [380] = {.lex_state = 140},
  [381] = {.lex_state = 140},
  [382] = {.lex_state = 140},
  [383] = {.lex_state = 140},
  [384] = {.lex_state = 140},
  [385] = {.lex_state = 140},
  [386] = {.lex_state = 140},
  [387] = {.lex_state = 140},
  [388] = {.lex_state = 140},
  [389] = {.lex_state = 140},
  [390] = {.lex_state = 140},
  [391] = {.lex_state = 140},
  [392] = {.lex_state = 140},
  [393] = {.lex_state = 140},
  [394] = {.lex_state = 140},
  [395] = {.lex_state = 140},
  [396] = {.lex_state = 140},
  [397] = {.lex_state = 140},
  [398] = {.lex_state = 140},
  [399] = {.lex_state = 140},
  [400] = {.lex_state = 140},
  [401] = {.lex_state = 57},
  [402] = {.lex_state = 140},
  [403] = {.lex_state = 140},
  [404] = {.lex_state = 140},
  [405] = {.lex_state = 140},
  [406] = {.lex_state = 57},
  [407] = {.lex_state = 140},
  [408] = {.lex_state = 140},
  [409] = {.lex_state = 140},
  [410] = {.lex_state = 140},
  [411] = {.lex_state = 57},
  [412] = {.lex_state = 54},
  [413] = {.lex_state = 57},
  [414] = {.lex_state = 140},
  [415] = {.lex_state = 140},
  [416] = {.lex_state = 140},
  [417] = {.lex_state = 140},
  [418] = {.lex_state = 57},
  [419] = {.lex_state = 140},
  [420] = {.lex_state = 140},
  [421] = {.lex_state = 140},
  [422] = {.lex_state = 140},
  [423] = {.lex_state = 140},
  [424] = {.lex_state = 140},
  [425] = {.lex_state = 57},
  [426] = {.lex_state = 140},
  [427] = {.lex_state = 57},
  [428] = {.lex_state = 140},
  [429] = {.lex_state = 140},
  [430] = {.lex_state = 57},
  [431] = {.lex_state = 140},
  [432] = {.lex_state = 57},
  [433] = {.lex_state = 57},
  [434] = {.lex_state = 140},
  [435] = {.lex_state = 140},
  [436] = {.lex_state = 140},
  [437] = {.lex_state = 57},
  [438] = {.lex_state = 57},
  [439] = {.lex_state = 140},
  [440] = {.lex_state = 140},
  [441] = {.lex_state = 140},
  [442] = {.lex_state = 140},
  [443] = {.lex_state = 140},
  [444] = {.lex_state = 140},
  [445] = {.lex_state = 140},
  [446] = {.lex_state = 140},
  [447] = {.lex_state = 57},
  [448] = {.lex_state = 140},
  [449] = {.lex_state = 57},
  [450] = {.lex_state = 140},
  [451] = {.lex_state = 140},
  [452] = {.lex_state = 140},
  [453] = {.lex_state = 57},
  [454] = {.lex_state = 140},
  [455] = {.lex_state = 57},
  [456] = {.lex_state = 57},
  [457] = {.lex_state = 140},
  [458] = {.lex_state = 140},
  [459] = {.lex_state = 140},
  [460] = {.lex_state = 57},
  [461] = {.lex_state = 140},
  [462] = {.lex_state = 57},
  [463] = {.lex_state = 57},
  [464] = {.lex_state = 57},
  [465] = {.lex_state = 140},
  [466] = {.lex_state = 140},
  [467] = {.lex_state = 140},
  [468] = {.lex_state = 57},
  [469] = {.lex_state = 140},
  [470] = {.lex_state = 140},
  [471] = {.lex_state = 57},
  [472] = {.lex_state = 57},
  [473] = {.lex_state = 57},
  [474] = {.lex_state = 140},
  [475] = {.lex_state = 57},
  [476] = {.lex_state = 140},
  [477] = {.lex_state = 140},
  [478] = {.lex_state = 140},
  [479] = {.lex_state = 140},
  [480] = {.lex_state = 140},
  [481] = {.lex_state = 53},
  [482] = {.lex_state = 140},
  [483] = {.lex_state = 140},
  [484] = {.lex_state = 140},
  [485] = {.lex_state = 140},
  [486] = {.lex_state = 140},
  [487] = {.lex_state = 140},
  [488] = {.lex_state = 140},
  [489] = {.lex_state = 140},
  [490] = {.lex_state = 140},
  [491] = {.lex_state = 140},
  [492] = {.lex_state = 140},
  [493] = {.lex_state = 140},
  [494] = {.lex_state = 140},
  [495] = {.lex_state = 140},
  [496] = {.lex_state = 140},
  [497] = {.lex_state = 140},
  [498] = {.lex_state = 140},
  [499] = {.lex_state = 140},
  [500] = {.lex_state = 140},
  [501] = {.lex_state = 140},
  [502] = {.lex_state = 140},
  [503] = {.lex_state = 140},
  [504] = {.lex_state = 140},
  [505] = {.lex_state = 140},
  [506] = {.lex_state = 140},
  [507] = {.lex_state = 140},
  [508] = {.lex_state = 140},
  [509] = {.lex_state = 140},
  [510] = {.lex_state = 140},
  [511] = {.lex_state = 140},
  [512] = {.lex_state = 140},
  [513] = {.lex_state = 140},
  [514] = {.lex_state = 140},
  [515] = {.lex_state = 140},
  [516] = {.lex_state = 140},
  [517] = {.lex_state = 140},
  [518] = {.lex_state = 140},
  [519] = {.lex_state = 140},
  [520] = {.lex_state = 140},
  [521] = {.lex_state = 140},
  [522] = {.lex_state = 140},
  [523] = {.lex_state = 53},
  [524] = {.lex_state = 140},
  [525] = {.lex_state = 140},
  [526] = {.lex_state = 53},
  [527] = {.lex_state = 54},
  [528] = {.lex_state = 53},
  [529] = {.lex_state = 140},
  [530] = {.lex_state = 140},
  [531] = {.lex_state = 60},
  [532] = {.lex_state = 60},
  [533] = {.lex_state = 60},
  [534] = {.lex_state = 60},
  [535] = {.lex_state = 60},
  [536] = {.lex_state = 60},
  [537] = {.lex_state = 60},
  [538] = {.lex_state = 60},
  [539] = {.lex_state = 60},
  [540] = {.lex_state = 60},
  [541] = {.lex_state = 60},
  [542] = {.lex_state = 60},
  [543] = {.lex_state = 140},
  [544] = {.lex_state = 140},
  [545] = {.lex_state = 140},
  [546] = {.lex_state = 140},
  [547] = {.lex_state = 140},
  [548] = {.lex_state = 140},
  [549] = {.lex_state = 140},
  [550] = {.lex_state = 140},
  [551] = {.lex_state = 140},
  [552] = {.lex_state = 140},
  [553] = {.lex_state = 140},
  [554] = {.lex_state = 140},
  [555] = {.lex_state = 140},
  [556] = {.lex_state = 140},
  [557] = {.lex_state = 140},
  [558] = {.lex_state = 140},
  [559] = {.lex_state = 140},
  [560] = {.lex_state = 64},
  [561] = {.lex_state = 64},
  [562] = {.lex_state = 64},
  [563] = {.lex_state = 64},
  [564] = {.lex_state = 64},
  [565] = {.lex_state = 64},
  [566] = {.lex_state = 64},
  [567] = {.lex_state = 64},
  [568] = {.lex_state = 64},
  [569] = {.lex_state = 65},
  [570] = {.lex_state = 65},
  [571] = {.lex_state = 64},
  [572] = {.lex_state = 65},
  [573] = {.lex_state = 65},
  [574] = {.lex_state = 65},
  [575] = {.lex_state = 65},
  [576] = {.lex_state = 65},
  [577] = {.lex_state = 65},
  [578] = {.lex_state = 65},
  [579] = {.lex_state = 65},
  [580] = {.lex_state = 65},
  [581] = {.lex_state = 65},
  [582] = {.lex_state = 140},
  [583] = {.lex_state = 140},
  [584] = {.lex_state = 140},
  [585] = {.lex_state = 65},
  [586] = {.lex_state = 140},
  [587] = {.lex_state = 140},
  [588] = {.lex_state = 140},
  [589] = {.lex_state = 140},
  [590] = {.lex_state = 140},
  [591] = {.lex_state = 140},
  [592] = {.lex_state = 140},
  [593] = {.lex_state = 140},
  [594] = {.lex_state = 140},
  [595] = {.lex_state = 140},
  [596] = {.lex_state = 140},
  [597] = {.lex_state = 140},
  [598] = {.lex_state = 140},
  [599] = {.lex_state = 140},
  [600] = {.lex_state = 140},
  [601] = {.lex_state = 140},
  [602] = {.lex_state = 140},
  [603] = {.lex_state = 140},
  [604] = {.lex_state = 140},
  [605] = {.lex_state = 140},
  [606] = {.lex_state = 140},
  [607] = {.lex_state = 140},
  [608] = {.lex_state = 140},
  [609] = {.lex_state = 140},
  [610] = {.lex_state = 140},
  [611] = {.lex_state = 140},
  [612] = {.lex_state = 140},
  [613] = {.lex_state = 71},
  [614] = {.lex_state = 140},
  [615] = {.lex_state = 140},
  [616] = {.lex_state = 140},
  [617] = {.lex_state = 140},
  [618] = {.lex_state = 140},
  [619] = {.lex_state = 70},
  [620] = {.lex_state = 140},
  [621] = {.lex_state = 140},
  [622] = {.lex_state = 140},
  [623] = {.lex_state = 140},
  [624] = {.lex_state = 140},
  [625] = {.lex_state = 140},
  [626] = {.lex_state = 71},
  [627] = {.lex_state = 140},
  [628] = {.lex_state = 70},
  [629] = {.lex_state = 140},
  [630] = {.lex_state = 140},
  [631] = {.lex_state = 140},
  [632] = {.lex_state = 71},
  [633] = {.lex_state = 140},
  [634] = {.lex_state = 70},
  [635] = {.lex_state = 140},
  [636] = {.lex_state = 140},
  [637] = {.lex_state = 140},
  [638] = {.lex_state = 140},
  [639] = {.lex_state = 140},
  [640] = {.lex_state = 140},
  [641] = {.lex_state = 140},
  [642] = {.lex_state = 140},
  [643] = {.lex_state = 140},
  [644] = {.lex_state = 140},
  [645] = {.lex_state = 140},
  [646] = {.lex_state = 140},
  [647] = {.lex_state = 140},
  [648] = {.lex_state = 140},
  [649] = {.lex_state = 64},
  [650] = {.lex_state = 140},
  [651] = {.lex_state = 140},
  [652] = {.lex_state = 140},
  [653] = {.lex_state = 140},
  [654] = {.lex_state = 140},
  [655] = {.lex_state = 140},
  [656] = {.lex_state = 140},
  [657] = {.lex_state = 140},
  [658] = {.lex_state = 140},
  [659] = {.lex_state = 140},
  [660] = {.lex_state = 140},
  [661] = {.lex_state = 140},
  [662] = {.lex_state = 140},
  [663] = {.lex_state = 140},
  [664] = {.lex_state = 140},
  [665] = {.lex_state = 140},
  [666] = {.lex_state = 140},
  [667] = {.lex_state = 140},
  [668] = {.lex_state = 140},
  [669] = {.lex_state = 140},
  [670] = {.lex_state = 140},
  [671] = {.lex_state = 140},
  [672] = {.lex_state = 140},
  [673] = {.lex_state = 140},
  [674] = {.lex_state = 140},
  [675] = {.lex_state = 140},
  [676] = {.lex_state = 140},
  [677] = {.lex_state = 140},
  [678] = {.lex_state = 140},
  [679] = {.lex_state = 140},
  [680] = {.lex_state = 140},
  [681] = {.lex_state = 140},
  [682] = {.lex_state = 140},
  [683] = {.lex_state = 140},
  [684] = {.lex_state = 140},
  [685] = {.lex_state = 140},
  [686] = {.lex_state = 140},
  [687] = {.lex_state = 140},
  [688] = {.lex_state = 140},
  [689] = {.lex_state = 140},
  [690] = {.lex_state = 140},
  [691] = {.lex_state = 140},
  [692] = {.lex_state = 140},
  [693] = {.lex_state = 140},
  [694] = {.lex_state = 140},
  [695] = {.lex_state = 140},
  [696] = {.lex_state = 140},
  [697] = {.lex_state = 140},
  [698] = {.lex_state = 140},
  [699] = {.lex_state = 140},
  [700] = {.lex_state = 140},
  [701] = {.lex_state = 140},
  [702] = {.lex_state = 140},
  [703] = {.lex_state = 140},
  [704] = {.lex_state = 140},
  [705] = {.lex_state = 140},
  [706] = {.lex_state = 140},
  [707] = {.lex_state = 140},
  [708] = {.lex_state = 140},
  [709] = {.lex_state = 140},
  [710] = {.lex_state = 140},
  [711] = {.lex_state = 140},
  [712] = {.lex_state = 140},
  [713] = {.lex_state = 140},
  [714] = {.lex_state = 140},
  [715] = {.lex_state = 140},
  [716] = {.lex_state = 140},
  [717] = {.lex_state = 140},
  [718] = {.lex_state = 140},
  [719] = {.lex_state = 140},
  [720] = {.lex_state = 140},
  [721] = {.lex_state = 140},
  [722] = {.lex_state = 140},
  [723] = {.lex_state = 140},
  [724] = {.lex_state = 140},
  [725] = {.lex_state = 140},
  [726] = {.lex_state = 140},
  [727] = {.lex_state = 140},
  [728] = {.lex_state = 140},
  [729] = {.lex_state = 140},
  [730] = {.lex_state = 140},
  [731] = {.lex_state = 140},
  [732] = {.lex_state = 140},
  [733] = {.lex_state = 140},
  [734] = {.lex_state = 140},
  [735] = {.lex_state = 140},
  [736] = {.lex_state = 140},
  [737] = {.lex_state = 140},
  [738] = {.lex_state = 140},
  [739] = {.lex_state = 140},
  [740] = {.lex_state = 140},
  [741] = {.lex_state = 140},
  [742] = {.lex_state = 140},
  [743] = {.lex_state = 140},
  [744] = {.lex_state = 140},
  [745] = {.lex_state = 140},
  [746] = {.lex_state = 140},
  [747] = {.lex_state = 140},
  [748] = {.lex_state = 140},
  [749] = {.lex_state = 140},
  [750] = {.lex_state = 140},
  [751] = {.lex_state = 140},
  [752] = {.lex_state = 140},
  [753] = {.lex_state = 140},
  [754] = {.lex_state = 140},
  [755] = {.lex_state = 140},
  [756] = {.lex_state = 140},
  [757] = {.lex_state = 140},
  [758] = {.lex_state = 140},
  [759] = {.lex_state = 140},
  [760] = {.lex_state = 140},
  [761] = {.lex_state = 140},
  [762] = {.lex_state = 140},
  [763] = {.lex_state = 140},
  [764] = {.lex_state = 140},
  [765] = {.lex_state = 140},
  [766] = {.lex_state = 140},
  [767] = {.lex_state = 140},
  [768] = {.lex_state = 140},
  [769] = {.lex_state = 140},
  [770] = {.lex_state = 140},
  [771] = {.lex_state = 140},
  [772] = {.lex_state = 140},
  [773] = {.lex_state = 140},
  [774] = {.lex_state = 140},
  [775] = {.lex_state = 140},
  [776] = {.lex_state = 140},
  [777] = {.lex_state = 140},
  [778] = {.lex_state = 140},
  [779] = {.lex_state = 140},
  [780] = {.lex_state = 140},
  [781] = {.lex_state = 140},
  [782] = {.lex_state = 140},
  [783] = {.lex_state = 140},
  [784] = {.lex_state = 140},
  [785] = {.lex_state = 140},
  [786] = {.lex_state = 140},
  [787] = {.lex_state = 140},
  [788] = {.lex_state = 140},
  [789] = {.lex_state = 140},
  [790] = {.lex_state = 140},
  [791] = {.lex_state = 60},
  [792] = {.lex_state = 60},
  [793] = {.lex_state = 64},
  [794] = {.lex_state = 64},
  [795] = {.lex_state = 60},
  [796] = {.lex_state = 64},
  [797] = {.lex_state = 64},
  [798] = {.lex_state = 64},
  [799] = {.lex_state = 60},
  [800] = {.lex_state = 60},
  [801] = {.lex_state = 60},
  [802] = {.lex_state = 60},
  [803] = {.lex_state = 62},
  [804] = {.lex_state = 62},
  [805] = {.lex_state = 62},
  [806] = {.lex_state = 62},
  [807] = {.lex_state = 62},
  [808] = {.lex_state = 62},
  [809] = {.lex_state = 62},
  [810] = {.lex_state = 62},
  [811] = {.lex_state = 62},
  [812] = {.lex_state = 62},
  [813] = {.lex_state = 140},
  [814] = {.lex_state = 62},
  [815] = {.lex_state = 140},
  [816] = {.lex_state = 60},
  [817] = {.lex_state = 140},
  [818] = {.lex_state = 64},
  [819] = {.lex_state = 64},
  [820] = {.lex_state = 62},
  [821] = {.lex_state = 62},
  [822] = {.lex_state = 64},
  [823] = {.lex_state = 62},
  [824] = {.lex_state = 64},
  [825] = {.lex_state = 64},
  [826] = {.lex_state = 64},
  [827] = {.lex_state = 62},
  [828] = {.lex_state = 62},
  [829] = {.lex_state = 62},
  [830] = {.lex_state = 64},
  [831] = {.lex_state = 62},
  [832] = {.lex_state = 64},
  [833] = {.lex_state = 62},
  [834] = {.lex_state = 64},
  [835] = {.lex_state = 62},
  [836] = {.lex_state = 62},
  [837] = {.lex_state = 64},
  [838] = {.lex_state = 64},
  [839] = {.lex_state = 62},
  [840] = {.lex_state = 64},
  [841] = {.lex_state = 64},
  [842] = {.lex_state = 62},
  [843] = {.lex_state = 62},
  [844] = {.lex_state = 64},
  [845] = {.lex_state = 64},
  [846] = {.lex_state = 64},
  [847] = {.lex_state = 62},
  [848] = {.lex_state = 64},
  [849] = {.lex_state = 64},
  [850] = {.lex_state = 64},
  [851] = {.lex_state = 64},
  [852] = {.lex_state = 64},
  [853] = {.lex_state = 64},
  [854] = {.lex_state = 62},
  [855] = {.lex_state = 62},
  [856] = {.lex_state = 64},
  [857] = {.lex_state = 64},
  [858] = {.lex_state = 63},
  [859] = {.lex_state = 63},
  [860] = {.lex_state = 62},
  [861] = {.lex_state = 64},
  [862] = {.lex_state = 63},
  [863] = {.lex_state = 60},
  [864] = {.lex_state = 62},
  [865] = {.lex_state = 63},
  [866] = {.lex_state = 62},
  [867] = {.lex_state = 60},
  [868] = {.lex_state = 62},
  [869] = {.lex_state = 62},
  [870] = {.lex_state = 62},
  [871] = {.lex_state = 61},
  [872] = {.lex_state = 61},
  [873] = {.lex_state = 60},
  [874] = {.lex_state = 61},
  [875] = {.lex_state = 61},
  [876] = {.lex_state = 61},
  [877] = {.lex_state = 61},
  [878] = {.lex_state = 140},
  [879] = {.lex_state = 64},
  [880] = {.lex_state = 64},
  [881] = {.lex_state = 61},
  [882] = {.lex_state = 64},
  [883] = {.lex_state = 64},
  [884] = {.lex_state = 64},
  [885] = {.lex_state = 64},
  [886] = {.lex_state = 64},
  [887] = {.lex_state = 61},
  [888] = {.lex_state = 64},
  [889] = {.lex_state = 64},
  [890] = {.lex_state = 64},
  [891] = {.lex_state = 60},
  [892] = {.lex_state = 60},
  [893] = {.lex_state = 64},
  [894] = {.lex_state = 60},
  [895] = {.lex_state = 140},
  [896] = {.lex_state = 60},
  [897] = {.lex_state = 64},
  [898] = {.lex_state = 60},
  [899] = {.lex_state = 60},
  [900] = {.lex_state = 60},
  [901] = {.lex_state = 62},
  [902] = {.lex_state = 62},
  [903] = {.lex_state = 62},
  [904] = {.lex_state = 62},
  [905] = {.lex_state = 62},
  [906] = {.lex_state = 62},
  [907] = {.lex_state = 62},
  [908] = {.lex_state = 60},
  [909] = {.lex_state = 62},
  [910] = {.lex_state = 62},
  [911] = {.lex_state = 62},
  [912] = {.lex_state = 62},
  [913] = {.lex_state = 62},
  [914] = {.lex_state = 64},
  [915] = {.lex_state = 64},
  [916] = {.lex_state = 62},
  [917] = {.lex_state = 66},
  [918] = {.lex_state = 64},
  [919] = {.lex_state = 64},
  [920] = {.lex_state = 64},
  [921] = {.lex_state = 64},
  [922] = {.lex_state = 64},
  [923] = {.lex_state = 64},
  [924] = {.lex_state = 64},
  [925] = {.lex_state = 64},
  [926] = {.lex_state = 64},
  [927] = {.lex_state = 66},
  [928] = {.lex_state = 64},
  [929] = {.lex_state = 66},
  [930] = {.lex_state = 66},
  [931] = {.lex_state = 64},
  [932] = {.lex_state = 66},
  [933] = {.lex_state = 66},
  [934] = {.lex_state = 66},
  [935] = {.lex_state = 66},
  [936] = {.lex_state = 66},
  [937] = {.lex_state = 66},
  [938] = {.lex_state = 66},
  [939] = {.lex_state = 66},
  [940] = {.lex_state = 66},
  [941] = {.lex_state = 66},
  [942] = {.lex_state = 66},
  [943] = {.lex_state = 66},
  [944] = {.lex_state = 66},
  [945] = {.lex_state = 66},
  [946] = {.lex_state = 66},
  [947] = {.lex_state = 64},
  [948] = {.lex_state = 66},
  [949] = {.lex_state = 66},
  [950] = {.lex_state = 66},
  [951] = {.lex_state = 66},
  [952] = {.lex_state = 66},
  [953] = {.lex_state = 64},
  [954] = {.lex_state = 64},
  [955] = {.lex_state = 66},
  [956] = {.lex_state = 66},
  [957] = {.lex_state = 66},
  [958] = {.lex_state = 66},
  [959] = {.lex_state = 66},
  [960] = {.lex_state = 64},
  [961] = {.lex_state = 64},
  [962] = {.lex_state = 64},
  [963] = {.lex_state = 66},
  [964] = {.lex_state = 66},
  [965] = {.lex_state = 66},
  [966] = {.lex_state = 64},
  [967] = {.lex_state = 66},
  [968] = {.lex_state = 66},
  [969] = {.lex_state = 66},
  [970] = {.lex_state = 66},
  [971] = {.lex_state = 66},
  [972] = {.lex_state = 66},
  [973] = {.lex_state = 66},
  [974] = {.lex_state = 64},
  [975] = {.lex_state = 64},
  [976] = {.lex_state = 64},
  [977] = {.lex_state = 64},
  [978] = {.lex_state = 64},
  [979] = {.lex_state = 66},
  [980] = {.lex_state = 66},
  [981] = {.lex_state = 64},
  [982] = {.lex_state = 64},
  [983] = {.lex_state = 66},
  [984] = {.lex_state = 66},
  [985] = {.lex_state = 66},
  [986] = {.lex_state = 64},
  [987] = {.lex_state = 66},
  [988] = {.lex_state = 66},
  [989] = {.lex_state = 66},
  [990] = {.lex_state = 66},
  [991] = {.lex_state = 66},
  [992] = {.lex_state = 64},
  [993] = {.lex_state = 64},
  [994] = {.lex_state = 64},
  [995] = {.lex_state = 66},
  [996] = {.lex_state = 64},
  [997] = {.lex_state = 60},
  [998] = {.lex_state = 60},
  [999] = {.lex_state = 65},
  [1000] = {.lex_state = 65},
  [1001] = {.lex_state = 65},
  [1002] = {.lex_state = 65},
  [1003] = {.lex_state = 65},
  [1004] = {.lex_state = 65},
  [1005] = {.lex_state = 65},
  [1006] = {.lex_state = 64},
  [1007] = {.lex_state = 64},
  [1008] = {.lex_state = 65},
  [1009] = {.lex_state = 65},
  [1010] = {.lex_state = 65},
  [1011] = {.lex_state = 65},
  [1012] = {.lex_state = 65},
  [1013] = {.lex_state = 60},
  [1014] = {.lex_state = 65},
  [1015] = {.lex_state = 65},
  [1016] = {.lex_state = 64},
  [1017] = {.lex_state = 60},
  [1018] = {.lex_state = 64},
  [1019] = {.lex_state = 60},
  [1020] = {.lex_state = 60},
  [1021] = {.lex_state = 64},
  [1022] = {.lex_state = 65},
  [1023] = {.lex_state = 64},
  [1024] = {.lex_state = 64},
  [1025] = {.lex_state = 60},
  [1026] = {.lex_state = 60},
  [1027] = {.lex_state = 64},
  [1028] = {.lex_state = 64},
  [1029] = {.lex_state = 65},
  [1030] = {.lex_state = 65},
  [1031] = {.lex_state = 65},
  [1032] = {.lex_state = 60},
  [1033] = {.lex_state = 60},
  [1034] = {.lex_state = 60},
  [1035] = {.lex_state = 60},
  [1036] = {.lex_state = 60},
  [1037] = {.lex_state = 60},
  [1038] = {.lex_state = 60},
  [1039] = {.lex_state = 60},
  [1040] = {.lex_state = 60},
  [1041] = {.lex_state = 64},
  [1042] = {.lex_state = 60},
  [1043] = {.lex_state = 64},
  [1044] = {.lex_state = 64},
  [1045] = {.lex_state = 64},
  [1046] = {.lex_state = 60},
  [1047] = {.lex_state = 64},
  [1048] = {.lex_state = 64},
  [1049] = {.lex_state = 64},
  [1050] = {.lex_state = 71},
  [1051] = {.lex_state = 64},
  [1052] = {.lex_state = 64},
  [1053] = {.lex_state = 71},
  [1054] = {.lex_state = 64},
  [1055] = {.lex_state = 70},
  [1056] = {.lex_state = 71},
  [1057] = {.lex_state = 71},
  [1058] = {.lex_state = 71},
  [1059] = {.lex_state = 71},
  [1060] = {.lex_state = 64},
  [1061] = {.lex_state = 71},
  [1062] = {.lex_state = 71},
  [1063] = {.lex_state = 71},
  [1064] = {.lex_state = 71},
  [1065] = {.lex_state = 71},
  [1066] = {.lex_state = 71},
  [1067] = {.lex_state = 71},
  [1068] = {.lex_state = 70},
  [1069] = {.lex_state = 60},
  [1070] = {.lex_state = 70},
  [1071] = {.lex_state = 70},
  [1072] = {.lex_state = 60},
  [1073] = {.lex_state = 64},
  [1074] = {.lex_state = 64},
  [1075] = {.lex_state = 64},
  [1076] = {.lex_state = 64},
  [1077] = {.lex_state = 70},
  [1078] = {.lex_state = 64},
  [1079] = {.lex_state = 70},
  [1080] = {.lex_state = 70},
  [1081] = {.lex_state = 64},
  [1082] = {.lex_state = 64},
  [1083] = {.lex_state = 70},
  [1084] = {.lex_state = 70},
  [1085] = {.lex_state = 70},
  [1086] = {.lex_state = 60},
  [1087] = {.lex_state = 60},
  [1088] = {.lex_state = 70},
  [1089] = {.lex_state = 70},
  [1090] = {.lex_state = 71},
  [1091] = {.lex_state = 60},
  [1092] = {.lex_state = 71},
  [1093] = {.lex_state = 71},
  [1094] = {.lex_state = 70},
  [1095] = {.lex_state = 71},
  [1096] = {.lex_state = 71},
  [1097] = {.lex_state = 70},
  [1098] = {.lex_state = 70},
  [1099] = {.lex_state = 70},
  [1100] = {.lex_state = 70},
  [1101] = {.lex_state = 70},
  [1102] = {.lex_state = 64},
  [1103] = {.lex_state = 64},
  [1104] = {.lex_state = 64},
  [1105] = {.lex_state = 64},
  [1106] = {.lex_state = 64},
  [1107] = {.lex_state = 64},
  [1108] = {.lex_state = 64},
  [1109] = {.lex_state = 64},
  [1110] = {.lex_state = 64},
  [1111] = {.lex_state = 64},
  [1112] = {.lex_state = 64},
  [1113] = {.lex_state = 64},
  [1114] = {.lex_state = 64},
  [1115] = {.lex_state = 64},
  [1116] = {.lex_state = 64},
  [1117] = {.lex_state = 140},
  [1118] = {.lex_state = 64},
  [1119] = {.lex_state = 140},
  [1120] = {.lex_state = 64},
  [1121] = {.lex_state = 64},
  [1122] = {.lex_state = 140},
  [1123] = {.lex_state = 64},
  [1124] = {.lex_state = 64},
  [1125] = {.lex_state = 64},
  [1126] = {.lex_state = 64},
  [1127] = {.lex_state = 64},
  [1128] = {.lex_state = 140},
  [1129] = {.lex_state = 140},
  [1130] = {.lex_state = 64},
  [1131] = {.lex_state = 64},
  [1132] = {.lex_state = 64},
  [1133] = {.lex_state = 64},
  [1134] = {.lex_state = 64},
  [1135] = {.lex_state = 64},
  [1136] = {.lex_state = 64},
  [1137] = {.lex_state = 64},
  [1138] = {.lex_state = 64},
  [1139] = {.lex_state = 64},
  [1140] = {.lex_state = 64},
  [1141] = {.lex_state = 64},
  [1142] = {.lex_state = 64},
  [1143] = {.lex_state = 64},
  [1144] = {.lex_state = 64},
  [1145] = {.lex_state = 64},
  [1146] = {.lex_state = 140},
  [1147] = {.lex_state = 64},
  [1148] = {.lex_state = 64},
  [1149] = {.lex_state = 64},
  [1150] = {.lex_state = 64},
  [1151] = {.lex_state = 64},
  [1152] = {.lex_state = 64},
  [1153] = {.lex_state = 64},
  [1154] = {.lex_state = 64},
  [1155] = {.lex_state = 64},
  [1156] = {.lex_state = 64},
  [1157] = {.lex_state = 64},
  [1158] = {.lex_state = 64},
  [1159] = {.lex_state = 64},
  [1160] = {.lex_state = 64},
  [1161] = {.lex_state = 62},
  [1162] = {.lex_state = 62},
  [1163] = {.lex_state = 62},
  [1164] = {.lex_state = 62},
  [1165] = {.lex_state = 62},
  [1166] = {.lex_state = 62},
  [1167] = {.lex_state = 62},
  [1168] = {.lex_state = 62},
  [1169] = {.lex_state = 64},
  [1170] = {.lex_state = 62},
  [1171] = {.lex_state = 62},
  [1172] = {.lex_state = 62},
  [1173] = {.lex_state = 62},
  [1174] = {.lex_state = 62},
  [1175] = {.lex_state = 64},
  [1176] = {.lex_state = 64},
  [1177] = {.lex_state = 64},
  [1178] = {.lex_state = 64},
  [1179] = {.lex_state = 64},
  [1180] = {.lex_state = 64},
  [1181] = {.lex_state = 64},
  [1182] = {.lex_state = 64},
  [1183] = {.lex_state = 64},
  [1184] = {.lex_state = 64},
  [1185] = {.lex_state = 64},
  [1186] = {.lex_state = 64},
  [1187] = {.lex_state = 64},
  [1188] = {.lex_state = 64},
  [1189] = {.lex_state = 64},
  [1190] = {.lex_state = 64},
  [1191] = {.lex_state = 64},
  [1192] = {.lex_state = 64},
  [1193] = {.lex_state = 64},
  [1194] = {.lex_state = 64},
  [1195] = {.lex_state = 64},
  [1196] = {.lex_state = 64},
  [1197] = {.lex_state = 64},
  [1198] = {.lex_state = 64},
  [1199] = {.lex_state = 64},
  [1200] = {.lex_state = 64},
  [1201] = {.lex_state = 66},
  [1202] = {.lex_state = 66},
  [1203] = {.lex_state = 64},
  [1204] = {.lex_state = 66},
  [1205] = {.lex_state = 64},
  [1206] = {.lex_state = 66},
  [1207] = {.lex_state = 66},
  [1208] = {.lex_state = 64},
  [1209] = {.lex_state = 64},
  [1210] = {.lex_state = 64},
  [1211] = {.lex_state = 66},
  [1212] = {.lex_state = 66},
  [1213] = {.lex_state = 66},
  [1214] = {.lex_state = 66},
  [1215] = {.lex_state = 66},
  [1216] = {.lex_state = 66},
  [1217] = {.lex_state = 66},
  [1218] = {.lex_state = 66},
  [1219] = {.lex_state = 65},
  [1220] = {.lex_state = 65},
  [1221] = {.lex_state = 64},
  [1222] = {.lex_state = 64},
  [1223] = {.lex_state = 64},
  [1224] = {.lex_state = 65},
  [1225] = {.lex_state = 64},
  [1226] = {.lex_state = 64},
  [1227] = {.lex_state = 64},
  [1228] = {.lex_state = 64},
  [1229] = {.lex_state = 64},
  [1230] = {.lex_state = 65},
  [1231] = {.lex_state = 60},
  [1232] = {.lex_state = 64},
  [1233] = {.lex_state = 60},
  [1234] = {.lex_state = 60},
  [1235] = {.lex_state = 60},
  [1236] = {.lex_state = 60},
  [1237] = {.lex_state = 60},
  [1238] = {.lex_state = 60},
  [1239] = {.lex_state = 60},
  [1240] = {.lex_state = 60},
  [1241] = {.lex_state = 60},
  [1242] = {.lex_state = 60},
  [1243] = {.lex_state = 60},
  [1244] = {.lex_state = 60},
  [1245] = {.lex_state = 64},
  [1246] = {.lex_state = 64},
  [1247] = {.lex_state = 64},
  [1248] = {.lex_state = 60},
  [1249] = {.lex_state = 60},
  [1250] = {.lex_state = 60},
  [1251] = {.lex_state = 60},
  [1252] = {.lex_state = 60},
  [1253] = {.lex_state = 60},
  [1254] = {.lex_state = 60},
  [1255] = {.lex_state = 60},
  [1256] = {.lex_state = 60},
  [1257] = {.lex_state = 60},
  [1258] = {.lex_state = 60},
  [1259] = {.lex_state = 60},
  [1260] = {.lex_state = 60},
  [1261] = {.lex_state = 60},
  [1262] = {.lex_state = 60},
  [1263] = {.lex_state = 60},
  [1264] = {.lex_state = 60},
  [1265] = {.lex_state = 60},
  [1266] = {.lex_state = 60},
  [1267] = {.lex_state = 64},
  [1268] = {.lex_state = 60},
  [1269] = {.lex_state = 64},
  [1270] = {.lex_state = 60},
  [1271] = {.lex_state = 60},
  [1272] = {.lex_state = 64},
  [1273] = {.lex_state = 64},
  [1274] = {.lex_state = 64},
  [1275] = {.lex_state = 60},
  [1276] = {.lex_state = 64},
  [1277] = {.lex_state = 64},
  [1278] = {.lex_state = 60},
  [1279] = {.lex_state = 60},
  [1280] = {.lex_state = 60},
  [1281] = {.lex_state = 60},
  [1282] = {.lex_state = 60},
  [1283] = {.lex_state = 64},
  [1284] = {.lex_state = 60},
  [1285] = {.lex_state = 60},
  [1286] = {.lex_state = 64},
  [1287] = {.lex_state = 64},
  [1288] = {.lex_state = 60},
  [1289] = {.lex_state = 60},
  [1290] = {.lex_state = 60},
  [1291] = {.lex_state = 60},
  [1292] = {.lex_state = 60},
  [1293] = {.lex_state = 64},
  [1294] = {.lex_state = 60},
  [1295] = {.lex_state = 60},
  [1296] = {.lex_state = 64},
  [1297] = {.lex_state = 60},
  [1298] = {.lex_state = 64},
  [1299] = {.lex_state = 60},
  [1300] = {.lex_state = 64},
  [1301] = {.lex_state = 60},
  [1302] = {.lex_state = 64},
  [1303] = {.lex_state = 60},
  [1304] = {.lex_state = 60},
  [1305] = {.lex_state = 60},
  [1306] = {.lex_state = 60},
  [1307] = {.lex_state = 60},
  [1308] = {.lex_state = 60},
  [1309] = {.lex_state = 60},
  [1310] = {.lex_state = 60},
  [1311] = {.lex_state = 60},
  [1312] = {.lex_state = 60},
  [1313] = {.lex_state = 60},
  [1314] = {.lex_state = 60},
  [1315] = {.lex_state = 64},
  [1316] = {.lex_state = 64},
  [1317] = {.lex_state = 60},
  [1318] = {.lex_state = 60},
  [1319] = {.lex_state = 60},
  [1320] = {.lex_state = 60},
  [1321] = {.lex_state = 60},
  [1322] = {.lex_state = 60},
  [1323] = {.lex_state = 60},
  [1324] = {.lex_state = 64},
  [1325] = {.lex_state = 60},
  [1326] = {.lex_state = 60},
  [1327] = {.lex_state = 60},
  [1328] = {.lex_state = 60},
  [1329] = {.lex_state = 60},
  [1330] = {.lex_state = 60},
  [1331] = {.lex_state = 60},
  [1332] = {.lex_state = 64},
  [1333] = {.lex_state = 60},
  [1334] = {.lex_state = 60},
  [1335] = {.lex_state = 60},
  [1336] = {.lex_state = 64},
  [1337] = {.lex_state = 60},
  [1338] = {.lex_state = 64},
  [1339] = {.lex_state = 60},
  [1340] = {.lex_state = 64},
  [1341] = {.lex_state = 64},
  [1342] = {.lex_state = 60},
  [1343] = {.lex_state = 64},
  [1344] = {.lex_state = 60},
  [1345] = {.lex_state = 64},
  [1346] = {.lex_state = 64},
  [1347] = {.lex_state = 64},
  [1348] = {.lex_state = 64},
  [1349] = {.lex_state = 64},
  [1350] = {.lex_state = 64},
  [1351] = {.lex_state = 64},
  [1352] = {.lex_state = 64},
  [1353] = {.lex_state = 64},
  [1354] = {.lex_state = 64},
  [1355] = {.lex_state = 64},
  [1356] = {.lex_state = 64},
  [1357] = {.lex_state = 64},
  [1358] = {.lex_state = 64},
  [1359] = {.lex_state = 64},
  [1360] = {.lex_state = 64},
  [1361] = {.lex_state = 65},
  [1362] = {.lex_state = 64},
  [1363] = {.lex_state = 64},
  [1364] = {.lex_state = 64},
  [1365] = {.lex_state = 64},
  [1366] = {.lex_state = 59},
  [1367] = {.lex_state = 65},
  [1368] = {.lex_state = 65},
  [1369] = {.lex_state = 65},
  [1370] = {.lex_state = 33},
  [1371] = {.lex_state = 59},
  [1372] = {.lex_state = 59},
  [1373] = {.lex_state = 59},
  [1374] = {.lex_state = 59},
  [1375] = {.lex_state = 64},
  [1376] = {.lex_state = 59},
  [1377] = {.lex_state = 59},
  [1378] = {.lex_state = 59},
  [1379] = {.lex_state = 59},
  [1380] = {.lex_state = 59},
  [1381] = {.lex_state = 59},
  [1382] = {.lex_state = 59},
  [1383] = {.lex_state = 59},
  [1384] = {.lex_state = 59},
  [1385] = {.lex_state = 59},
  [1386] = {.lex_state = 59},
  [1387] = {.lex_state = 59},
  [1388] = {.lex_state = 59},
  [1389] = {.lex_state = 64},
  [1390] = {.lex_state = 59},
  [1391] = {.lex_state = 59},
  [1392] = {.lex_state = 59},
  [1393] = {.lex_state = 59},
  [1394] = {.lex_state = 64},
  [1395] = {.lex_state = 59},
  [1396] = {.lex_state = 65},
  [1397] = {.lex_state = 65},
  [1398] = {.lex_state = 65},
  [1399] = {.lex_state = 59},
  [1400] = {.lex_state = 59},
  [1401] = {.lex_state = 64},
  [1402] = {.lex_state = 65},
  [1403] = {.lex_state = 65},
  [1404] = {.lex_state = 64},
  [1405] = {.lex_state = 59},
  [1406] = {.lex_state = 65},
  [1407] = {.lex_state = 59},
  [1408] = {.lex_state = 65},
  [1409] = {.lex_state = 65},
  [1410] = {.lex_state = 65},
  [1411] = {.lex_state = 59},
  [1412] = {.lex_state = 59},
  [1413] = {.lex_state = 65},
  [1414] = {.lex_state = 65},
  [1415] = {.lex_state = 59},
  [1416] = {.lex_state = 59},
  [1417] = {.lex_state = 59},
  [1418] = {.lex_state = 59},
  [1419] = {.lex_state = 59},
  [1420] = {.lex_state = 59},
  [1421] = {.lex_state = 59},
  [1422] = {.lex_state = 59},
  [1423] = {.lex_state = 59},
  [1424] = {.lex_state = 65},
  [1425] = {.lex_state = 59},
  [1426] = {.lex_state = 65},
  [1427] = {.lex_state = 65},
  [1428] = {.lex_state = 59},
  [1429] = {.lex_state = 59},
  [1430] = {.lex_state = 65},
  [1431] = {.lex_state = 59},
  [1432] = {.lex_state = 65},
  [1433] = {.lex_state = 59},
  [1434] = {.lex_state = 59},
  [1435] = {.lex_state = 33},
  [1436] = {.lex_state = 33},
  [1437] = {.lex_state = 33},
  [1438] = {.lex_state = 65},
  [1439] = {.lex_state = 33},
  [1440] = {.lex_state = 33},
  [1441] = {.lex_state = 33},
  [1442] = {.lex_state = 33},
  [1443] = {.lex_state = 33},
  [1444] = {.lex_state = 33},
  [1445] = {.lex_state = 33},
  [1446] = {.lex_state = 33},
  [1447] = {.lex_state = 33},
  [1448] = {.lex_state = 33},
  [1449] = {.lex_state = 33},
  [1450] = {.lex_state = 33},
  [1451] = {.lex_state = 64},
  [1452] = {.lex_state = 33},
  [1453] = {.lex_state = 33},
  [1454] = {.lex_state = 33},
  [1455] = {.lex_state = 33},
  [1456] = {.lex_state = 33},
  [1457] = {.lex_state = 33},
  [1458] = {.lex_state = 33},
  [1459] = {.lex_state = 33},
  [1460] = {.lex_state = 33},
  [1461] = {.lex_state = 64},
  [1462] = {.lex_state = 64},
  [1463] = {.lex_state = 64},
  [1464] = {.lex_state = 33},
  [1465] = {.lex_state = 33},
  [1466] = {.lex_state = 64},
  [1467] = {.lex_state = 64},
  [1468] = {.lex_state = 33},
  [1469] = {.lex_state = 64},
  [1470] = {.lex_state = 33},
  [1471] = {.lex_state = 33},
  [1472] = {.lex_state = 65},
  [1473] = {.lex_state = 64},
  [1474] = {.lex_state = 33},
  [1475] = {.lex_state = 64},
  [1476] = {.lex_state = 64},
  [1477] = {.lex_state = 33},
  [1478] = {.lex_state = 33},
  [1479] = {.lex_state = 33},
  [1480] = {.lex_state = 33},
  [1481] = {.lex_state = 33},
  [1482] = {.lex_state = 64},
  [1483] = {.lex_state = 64},
  [1484] = {.lex_state = 64},
  [1485] = {.lex_state = 64},
  [1486] = {.lex_state = 64},
  [1487] = {.lex_state = 64},
  [1488] = {.lex_state = 64},
  [1489] = {.lex_state = 64},
  [1490] = {.lex_state = 64},
  [1491] = {.lex_state = 64},
  [1492] = {.lex_state = 64},
  [1493] = {.lex_state = 64},
  [1494] = {.lex_state = 64},
  [1495] = {.lex_state = 64},
  [1496] = {.lex_state = 64},
  [1497] = {.lex_state = 64},
  [1498] = {.lex_state = 64},
  [1499] = {.lex_state = 64},
  [1500] = {.lex_state = 64},
  [1501] = {.lex_state = 62},
  [1502] = {.lex_state = 64},
  [1503] = {.lex_state = 64},
  [1504] = {.lex_state = 64},
  [1505] = {.lex_state = 64},
  [1506] = {.lex_state = 64},
  [1507] = {.lex_state = 64},
  [1508] = {.lex_state = 64},
  [1509] = {.lex_state = 64},
  [1510] = {.lex_state = 64},
  [1511] = {.lex_state = 64},
  [1512] = {.lex_state = 64},
  [1513] = {.lex_state = 64},
  [1514] = {.lex_state = 64},
  [1515] = {.lex_state = 64},
  [1516] = {.lex_state = 64},
  [1517] = {.lex_state = 64},
  [1518] = {.lex_state = 64},
  [1519] = {.lex_state = 64},
  [1520] = {.lex_state = 64},
  [1521] = {.lex_state = 64},
  [1522] = {.lex_state = 64},
  [1523] = {.lex_state = 64},
  [1524] = {.lex_state = 64},
  [1525] = {.lex_state = 64},
  [1526] = {.lex_state = 64},
  [1527] = {.lex_state = 64},
  [1528] = {.lex_state = 64},
  [1529] = {.lex_state = 69},
  [1530] = {.lex_state = 64},
  [1531] = {.lex_state = 64},
  [1532] = {.lex_state = 64},
  [1533] = {.lex_state = 64},
  [1534] = {.lex_state = 64},
  [1535] = {.lex_state = 69},
  [1536] = {.lex_state = 64},
  [1537] = {.lex_state = 64},
  [1538] = {.lex_state = 64},
  [1539] = {.lex_state = 64},
  [1540] = {.lex_state = 64},
  [1541] = {.lex_state = 64},
  [1542] = {.lex_state = 64},
  [1543] = {.lex_state = 64},
  [1544] = {.lex_state = 64},
  [1545] = {.lex_state = 64},
  [1546] = {.lex_state = 64},
  [1547] = {.lex_state = 66},
  [1548] = {.lex_state = 66},
  [1549] = {.lex_state = 64},
  [1550] = {.lex_state = 64},
  [1551] = {.lex_state = 62},
  [1552] = {.lex_state = 64},
  [1553] = {.lex_state = 64},
  [1554] = {.lex_state = 64},
  [1555] = {.lex_state = 64},
  [1556] = {.lex_state = 64},
  [1557] = {.lex_state = 64},
  [1558] = {.lex_state = 62},
  [1559] = {.lex_state = 64},
  [1560] = {.lex_state = 62},
  [1561] = {.lex_state = 64},
  [1562] = {.lex_state = 66},
  [1563] = {.lex_state = 69},
  [1564] = {.lex_state = 64},
  [1565] = {.lex_state = 64},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 64},
  [1568] = {.lex_state = 64},
  [1569] = {.lex_state = 64},
  [1570] = {.lex_state = 64},
  [1571] = {.lex_state = 140},
  [1572] = {.lex_state = 140},
  [1573] = {.lex_state = 140},
  [1574] = {.lex_state = 64},
  [1575] = {.lex_state = 64},
  [1576] = {.lex_state = 140},
  [1577] = {.lex_state = 64},
  [1578] = {.lex_state = 64},
  [1579] = {.lex_state = 64},
  [1580] = {.lex_state = 140},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 64},
  [1583] = {.lex_state = 60},
  [1584] = {.lex_state = 64},
  [1585] = {.lex_state = 68},
  [1586] = {.lex_state = 140},
  [1587] = {.lex_state = 140},
  [1588] = {.lex_state = 64},
  [1589] = {.lex_state = 68},
  [1590] = {.lex_state = 68},
  [1591] = {.lex_state = 140},
  [1592] = {.lex_state = 140},
  [1593] = {.lex_state = 140},
  [1594] = {.lex_state = 68},
  [1595] = {.lex_state = 64},
  [1596] = {.lex_state = 140},
  [1597] = {.lex_state = 140},
  [1598] = {.lex_state = 140},
  [1599] = {.lex_state = 60},
  [1600] = {.lex_state = 140},
  [1601] = {.lex_state = 140},
  [1602] = {.lex_state = 60},
  [1603] = {.lex_state = 68},
  [1604] = {.lex_state = 60},
  [1605] = {.lex_state = 66},
  [1606] = {.lex_state = 66},
  [1607] = {.lex_state = 66},
  [1608] = {.lex_state = 66},
  [1609] = {.lex_state = 140},
  [1610] = {.lex_state = 62},
  [1611] = {.lex_state = 62},
  [1612] = {.lex_state = 64},
  [1613] = {.lex_state = 64},
  [1614] = {.lex_state = 64},
  [1615] = {.lex_state = 140},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 140},
  [1618] = {.lex_state = 64},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 66},
  [1621] = {.lex_state = 66},
  [1622] = {.lex_state = 140},
  [1623] = {.lex_state = 66},
  [1624] = {.lex_state = 140},
  [1625] = {.lex_state = 62},
  [1626] = {.lex_state = 64},
  [1627] = {.lex_state = 64},
  [1628] = {.lex_state = 66},
  [1629] = {.lex_state = 66},
  [1630] = {.lex_state = 66},
  [1631] = {.lex_state = 66},
  [1632] = {.lex_state = 140},
  [1633] = {.lex_state = 64},
  [1634] = {.lex_state = 64},
  [1635] = {.lex_state = 0},
  [1636] = {.lex_state = 140},
  [1637] = {.lex_state = 62},
  [1638] = {.lex_state = 64},
  [1639] = {.lex_state = 64},
  [1640] = {.lex_state = 140},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 64},
  [1643] = {.lex_state = 64},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 64},
  [1646] = {.lex_state = 64},
  [1647] = {.lex_state = 64},
  [1648] = {.lex_state = 64},
  [1649] = {.lex_state = 64},
  [1650] = {.lex_state = 64},
  [1651] = {.lex_state = 64},
  [1652] = {.lex_state = 64},
  [1653] = {.lex_state = 64},
  [1654] = {.lex_state = 140},
  [1655] = {.lex_state = 140},
  [1656] = {.lex_state = 64},
  [1657] = {.lex_state = 69},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 66},
  [1660] = {.lex_state = 64},
  [1661] = {.lex_state = 69},
  [1662] = {.lex_state = 64},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 64},
  [1665] = {.lex_state = 140},
  [1666] = {.lex_state = 69},
  [1667] = {.lex_state = 64},
  [1668] = {.lex_state = 64},
  [1669] = {.lex_state = 64},
  [1670] = {.lex_state = 64},
  [1671] = {.lex_state = 140},
  [1672] = {.lex_state = 69},
  [1673] = {.lex_state = 69},
  [1674] = {.lex_state = 62},
  [1675] = {.lex_state = 64},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 69},
  [1678] = {.lex_state = 64},
  [1679] = {.lex_state = 140},
  [1680] = {.lex_state = 66},
  [1681] = {.lex_state = 64},
  [1682] = {.lex_state = 66},
  [1683] = {.lex_state = 69},
  [1684] = {.lex_state = 140},
  [1685] = {.lex_state = 69},
  [1686] = {.lex_state = 0},
  [1687] = {.lex_state = 69},
  [1688] = {.lex_state = 69},
  [1689] = {.lex_state = 69},
  [1690] = {.lex_state = 64},
  [1691] = {.lex_state = 140},
  [1692] = {.lex_state = 140},
  [1693] = {.lex_state = 66},
  [1694] = {.lex_state = 64},
  [1695] = {.lex_state = 140},
  [1696] = {.lex_state = 64},
  [1697] = {.lex_state = 140},
  [1698] = {.lex_state = 140},
  [1699] = {.lex_state = 140},
  [1700] = {.lex_state = 140},
  [1701] = {.lex_state = 64},
  [1702] = {.lex_state = 62},
  [1703] = {.lex_state = 140},
  [1704] = {.lex_state = 140},
  [1705] = {.lex_state = 140},
  [1706] = {.lex_state = 140},
  [1707] = {.lex_state = 140},
  [1708] = {.lex_state = 55},
  [1709] = {.lex_state = 140},
  [1710] = {.lex_state = 140},
  [1711] = {.lex_state = 140},
  [1712] = {.lex_state = 64},
  [1713] = {.lex_state = 64},
  [1714] = {.lex_state = 0},
  [1715] = {.lex_state = 38},
  [1716] = {.lex_state = 64},
  [1717] = {.lex_state = 64},
  [1718] = {.lex_state = 38},
  [1719] = {.lex_state = 40},
  [1720] = {.lex_state = 66},
  [1721] = {.lex_state = 64},
  [1722] = {.lex_state = 38},
  [1723] = {.lex_state = 64},
  [1724] = {.lex_state = 64},
  [1725] = {.lex_state = 38},
  [1726] = {.lex_state = 0},
  [1727] = {.lex_state = 64},
  [1728] = {.lex_state = 40},
  [1729] = {.lex_state = 64},
  [1730] = {.lex_state = 64},
  [1731] = {.lex_state = 64},
  [1732] = {.lex_state = 64},
  [1733] = {.lex_state = 64},
  [1734] = {.lex_state = 62},
  [1735] = {.lex_state = 0},
  [1736] = {.lex_state = 64},
  [1737] = {.lex_state = 41},
  [1738] = {.lex_state = 38},
  [1739] = {.lex_state = 55},
  [1740] = {.lex_state = 40},
  [1741] = {.lex_state = 64},
  [1742] = {.lex_state = 0},
  [1743] = {.lex_state = 64},
  [1744] = {.lex_state = 64},
  [1745] = {.lex_state = 64},
  [1746] = {.lex_state = 0},
  [1747] = {.lex_state = 64},
  [1748] = {.lex_state = 64},
  [1749] = {.lex_state = 38},
  [1750] = {.lex_state = 64},
  [1751] = {.lex_state = 64},
  [1752] = {.lex_state = 64},
  [1753] = {.lex_state = 64},
  [1754] = {.lex_state = 64},
  [1755] = {.lex_state = 38},
  [1756] = {.lex_state = 38},
  [1757] = {.lex_state = 64},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 64},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 41},
  [1762] = {.lex_state = 41},
  [1763] = {.lex_state = 40},
  [1764] = {.lex_state = 64},
  [1765] = {.lex_state = 62},
  [1766] = {.lex_state = 64},
  [1767] = {.lex_state = 62},
  [1768] = {.lex_state = 64},
  [1769] = {.lex_state = 41},
  [1770] = {.lex_state = 41},
  [1771] = {.lex_state = 64},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 0},
  [1774] = {.lex_state = 64},
  [1775] = {.lex_state = 0},
  [1776] = {.lex_state = 64},
  [1777] = {.lex_state = 41},
  [1778] = {.lex_state = 64},
  [1779] = {.lex_state = 41},
  [1780] = {.lex_state = 41},
  [1781] = {.lex_state = 40},
  [1782] = {.lex_state = 38},
  [1783] = {.lex_state = 140},
  [1784] = {.lex_state = 62},
  [1785] = {.lex_state = 41},
  [1786] = {.lex_state = 0},
  [1787] = {.lex_state = 0},
  [1788] = {.lex_state = 43},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 0},
  [1793] = {.lex_state = 0},
  [1794] = {.lex_state = 0},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 0},
  [1797] = {.lex_state = 0},
  [1798] = {.lex_state = 0},
  [1799] = {.lex_state = 55},
  [1800] = {.lex_state = 64},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 0},
  [1803] = {.lex_state = 64},
  [1804] = {.lex_state = 40},
  [1805] = {.lex_state = 55},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 40},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 0},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 40},
  [1819] = {.lex_state = 0},
  [1820] = {.lex_state = 64},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 0},
  [1825] = {.lex_state = 43},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 64},
  [1831] = {.lex_state = 55},
  [1832] = {.lex_state = 55},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 64},
  [1835] = {.lex_state = 64},
  [1836] = {.lex_state = 64},
  [1837] = {.lex_state = 64},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 55},
  [1840] = {.lex_state = 0},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 64},
  [1843] = {.lex_state = 64},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 43},
  [1846] = {.lex_state = 40},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 55},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 0},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 0},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 55},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 0},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 0},
  [1876] = {.lex_state = 43},
  [1877] = {.lex_state = 0},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 0},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 43},
  [1884] = {.lex_state = 0},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 64},
  [1887] = {.lex_state = 64},
  [1888] = {.lex_state = 64},
  [1889] = {.lex_state = 0},
  [1890] = {.lex_state = 0},
  [1891] = {.lex_state = 0},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 0},
  [1896] = {.lex_state = 0},
  [1897] = {.lex_state = 0},
  [1898] = {.lex_state = 0},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 0},
  [1901] = {.lex_state = 0},
  [1902] = {.lex_state = 0},
  [1903] = {.lex_state = 0},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 0},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 0},
  [1908] = {.lex_state = 0},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 0},
  [1911] = {.lex_state = 42},
  [1912] = {.lex_state = 42},
  [1913] = {.lex_state = 42},
  [1914] = {.lex_state = 0},
  [1915] = {.lex_state = 0},
  [1916] = {.lex_state = 0},
  [1917] = {.lex_state = 0},
  [1918] = {.lex_state = 64},
  [1919] = {.lex_state = 0},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 140},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 140},
  [1924] = {.lex_state = 140},
  [1925] = {.lex_state = 140},
  [1926] = {.lex_state = 42},
  [1927] = {.lex_state = 0},
  [1928] = {.lex_state = 140},
  [1929] = {.lex_state = 140},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 140},
  [1932] = {.lex_state = 140},
  [1933] = {.lex_state = 140},
  [1934] = {.lex_state = 42},
  [1935] = {.lex_state = 0},
  [1936] = {.lex_state = 0},
  [1937] = {.lex_state = 55},
  [1938] = {.lex_state = 0},
  [1939] = {.lex_state = 140},
  [1940] = {.lex_state = 140},
  [1941] = {.lex_state = 140},
  [1942] = {.lex_state = 140},
  [1943] = {.lex_state = 140},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 42},
  [1946] = {.lex_state = 64},
  [1947] = {.lex_state = 0},
  [1948] = {.lex_state = 0},
  [1949] = {.lex_state = 140},
  [1950] = {.lex_state = 140},
  [1951] = {.lex_state = 64},
  [1952] = {.lex_state = 140},
  [1953] = {.lex_state = 64},
  [1954] = {.lex_state = 0},
  [1955] = {.lex_state = 0},
  [1956] = {.lex_state = 0},
  [1957] = {.lex_state = 64},
  [1958] = {.lex_state = 42},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 0},
  [1961] = {.lex_state = 140},
  [1962] = {.lex_state = 0},
  [1963] = {.lex_state = 140},
  [1964] = {.lex_state = 140},
  [1965] = {.lex_state = 0},
  [1966] = {.lex_state = 140},
  [1967] = {.lex_state = 140},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 0},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 140},
  [1972] = {.lex_state = 0},
  [1973] = {.lex_state = 42},
  [1974] = {.lex_state = 0},
  [1975] = {.lex_state = 42},
  [1976] = {.lex_state = 0},
  [1977] = {.lex_state = 0},
  [1978] = {.lex_state = 140},
  [1979] = {.lex_state = 0},
  [1980] = {.lex_state = 0},
  [1981] = {.lex_state = 140},
  [1982] = {.lex_state = 64},
  [1983] = {.lex_state = 140},
  [1984] = {.lex_state = 64},
  [1985] = {.lex_state = 140},
  [1986] = {.lex_state = 140},
  [1987] = {.lex_state = 64},
  [1988] = {.lex_state = 55},
  [1989] = {.lex_state = 42},
  [1990] = {.lex_state = 140},
  [1991] = {.lex_state = 42},
  [1992] = {.lex_state = 42},
  [1993] = {.lex_state = 42},
  [1994] = {.lex_state = 42},
  [1995] = {.lex_state = 42},
  [1996] = {.lex_state = 55},
  [1997] = {.lex_state = 42},
  [1998] = {.lex_state = 42},
  [1999] = {.lex_state = 0},
  [2000] = {.lex_state = 140},
  [2001] = {.lex_state = 0},
  [2002] = {.lex_state = 0},
  [2003] = {.lex_state = 42},
  [2004] = {.lex_state = 42},
  [2005] = {.lex_state = 42},
  [2006] = {.lex_state = 0},
  [2007] = {.lex_state = 42},
  [2008] = {.lex_state = 0},
  [2009] = {.lex_state = 0},
  [2010] = {.lex_state = 64},
  [2011] = {.lex_state = 140},
  [2012] = {.lex_state = 53},
  [2013] = {.lex_state = 43},
  [2014] = {.lex_state = 43},
  [2015] = {.lex_state = 53},
  [2016] = {.lex_state = 140},
  [2017] = {.lex_state = 53},
  [2018] = {.lex_state = 64},
  [2019] = {.lex_state = 43},
  [2020] = {.lex_state = 0},
  [2021] = {.lex_state = 0},
  [2022] = {.lex_state = 0},
  [2023] = {.lex_state = 53},
  [2024] = {.lex_state = 53},
  [2025] = {.lex_state = 0},
  [2026] = {.lex_state = 0},
  [2027] = {.lex_state = 0},
  [2028] = {.lex_state = 0},
  [2029] = {.lex_state = 0},
  [2030] = {.lex_state = 53},
  [2031] = {.lex_state = 0},
  [2032] = {.lex_state = 43},
  [2033] = {.lex_state = 0},
  [2034] = {.lex_state = 0},
  [2035] = {.lex_state = 0},
  [2036] = {.lex_state = 43},
  [2037] = {.lex_state = 0},
  [2038] = {.lex_state = 0},
  [2039] = {.lex_state = 0},
  [2040] = {.lex_state = 53},
  [2041] = {.lex_state = 43},
  [2042] = {.lex_state = 53},
  [2043] = {.lex_state = 53},
  [2044] = {.lex_state = 53},
  [2045] = {.lex_state = 0},
  [2046] = {.lex_state = 0},
  [2047] = {.lex_state = 43},
  [2048] = {.lex_state = 0},
  [2049] = {.lex_state = 53},
  [2050] = {.lex_state = 43},
  [2051] = {.lex_state = 64},
  [2052] = {.lex_state = 0},
  [2053] = {.lex_state = 53},
  [2054] = {.lex_state = 64},
  [2055] = {.lex_state = 53},
  [2056] = {.lex_state = 43},
  [2057] = {.lex_state = 64},
  [2058] = {.lex_state = 0},
  [2059] = {.lex_state = 0},
  [2060] = {.lex_state = 43},
  [2061] = {.lex_state = 43},
  [2062] = {.lex_state = 53},
  [2063] = {.lex_state = 43},
  [2064] = {.lex_state = 0},
  [2065] = {.lex_state = 0},
  [2066] = {.lex_state = 43},
  [2067] = {.lex_state = 43},
  [2068] = {.lex_state = 43},
  [2069] = {.lex_state = 43},
  [2070] = {.lex_state = 0},
  [2071] = {.lex_state = 64},
  [2072] = {.lex_state = 64},
  [2073] = {.lex_state = 43},
  [2074] = {.lex_state = 0},
  [2075] = {.lex_state = 0},
  [2076] = {.lex_state = 53},
  [2077] = {.lex_state = 0},
  [2078] = {.lex_state = 0},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 64},
  [2081] = {.lex_state = 53},
  [2082] = {.lex_state = 64},
  [2083] = {.lex_state = 53},
  [2084] = {.lex_state = 43},
  [2085] = {.lex_state = 0},
  [2086] = {.lex_state = 0},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 0},
  [2090] = {.lex_state = 0},
  [2091] = {.lex_state = 0},
  [2092] = {.lex_state = 0},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 0},
  [2096] = {.lex_state = 0},
  [2097] = {.lex_state = 43},
  [2098] = {.lex_state = 0},
  [2099] = {.lex_state = 53},
  [2100] = {.lex_state = 53},
  [2101] = {.lex_state = 53},
  [2102] = {.lex_state = 53},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 43},
  [2105] = {.lex_state = 0},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 0},
  [2108] = {.lex_state = 0},
  [2109] = {.lex_state = 0},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 43},
  [2114] = {.lex_state = 64},
  [2115] = {.lex_state = 64},
  [2116] = {.lex_state = 53},
  [2117] = {.lex_state = 53},
  [2118] = {.lex_state = 0},
  [2119] = {.lex_state = 0},
  [2120] = {.lex_state = 64},
  [2121] = {.lex_state = 53},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 0},
  [2124] = {.lex_state = 43},
  [2125] = {.lex_state = 53},
  [2126] = {.lex_state = 53},
  [2127] = {.lex_state = 53},
  [2128] = {.lex_state = 0},
  [2129] = {.lex_state = 0},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 64},
  [2132] = {.lex_state = 53},
  [2133] = {.lex_state = 0},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 0},
  [2136] = {.lex_state = 0},
  [2137] = {.lex_state = 64},
  [2138] = {.lex_state = 0},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 43},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 64},
  [2147] = {.lex_state = 0},
  [2148] = {.lex_state = 53},
  [2149] = {.lex_state = 53},
  [2150] = {.lex_state = 53},
  [2151] = {.lex_state = 64},
  [2152] = {.lex_state = 53},
  [2153] = {.lex_state = 43},
  [2154] = {.lex_state = 43},
  [2155] = {.lex_state = 64},
  [2156] = {.lex_state = 43},
  [2157] = {.lex_state = 43},
  [2158] = {.lex_state = 64},
  [2159] = {.lex_state = 53},
  [2160] = {.lex_state = 0},
  [2161] = {.lex_state = 0},
  [2162] = {.lex_state = 53},
  [2163] = {.lex_state = 64},
  [2164] = {.lex_state = 0},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 64},
  [2167] = {.lex_state = 0},
  [2168] = {.lex_state = 53},
  [2169] = {.lex_state = 43},
  [2170] = {.lex_state = 64},
  [2171] = {.lex_state = 64},
  [2172] = {.lex_state = 53},
  [2173] = {.lex_state = 53},
  [2174] = {.lex_state = 64},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 53},
  [2178] = {.lex_state = 43},
  [2179] = {.lex_state = 53},
  [2180] = {.lex_state = 43},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 64},
  [2183] = {.lex_state = 64},
  [2184] = {.lex_state = 43},
  [2185] = {.lex_state = 64},
  [2186] = {.lex_state = 43},
  [2187] = {.lex_state = 0},
  [2188] = {.lex_state = 53},
  [2189] = {.lex_state = 0},
  [2190] = {.lex_state = 64},
  [2191] = {.lex_state = 43},
  [2192] = {.lex_state = 0},
  [2193] = {.lex_state = 0},
  [2194] = {.lex_state = 140},
  [2195] = {.lex_state = 53},
  [2196] = {.lex_state = 53},
  [2197] = {.lex_state = 0},
  [2198] = {.lex_state = 43},
  [2199] = {.lex_state = 64},
  [2200] = {.lex_state = 64},
  [2201] = {.lex_state = 0},
  [2202] = {.lex_state = 0},
  [2203] = {.lex_state = 64},
  [2204] = {.lex_state = 0},
  [2205] = {.lex_state = 53},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 53},
  [2208] = {.lex_state = 64},
  [2209] = {.lex_state = 64},
  [2210] = {.lex_state = 0},
  [2211] = {.lex_state = 0},
  [2212] = {.lex_state = 0},
  [2213] = {.lex_state = 0},
  [2214] = {.lex_state = 64},
  [2215] = {.lex_state = 64},
  [2216] = {.lex_state = 0},
  [2217] = {.lex_state = 0},
  [2218] = {.lex_state = 53},
  [2219] = {.lex_state = 140},
  [2220] = {.lex_state = 64},
  [2221] = {.lex_state = 53},
  [2222] = {.lex_state = 53},
  [2223] = {.lex_state = 0},
  [2224] = {.lex_state = 53},
  [2225] = {.lex_state = 43},
  [2226] = {.lex_state = 64},
  [2227] = {.lex_state = 140},
  [2228] = {.lex_state = 140},
  [2229] = {.lex_state = 64},
  [2230] = {.lex_state = 64},
  [2231] = {.lex_state = 64},
  [2232] = {.lex_state = 64},
  [2233] = {.lex_state = 53},
  [2234] = {.lex_state = 64},
  [2235] = {.lex_state = 0},
  [2236] = {.lex_state = 0},
  [2237] = {.lex_state = 0},
  [2238] = {.lex_state = 140},
  [2239] = {.lex_state = 140},
  [2240] = {.lex_state = 0},
  [2241] = {.lex_state = 140},
  [2242] = {.lex_state = 53},
  [2243] = {.lex_state = 0},
  [2244] = {.lex_state = 0},
  [2245] = {.lex_state = 0},
  [2246] = {.lex_state = 53},
  [2247] = {.lex_state = 0},
  [2248] = {.lex_state = 53},
  [2249] = {.lex_state = 64},
  [2250] = {.lex_state = 0},
  [2251] = {.lex_state = 0},
  [2252] = {.lex_state = 0},
  [2253] = {.lex_state = 64},
  [2254] = {.lex_state = 0},
  [2255] = {.lex_state = 140},
  [2256] = {.lex_state = 0},
  [2257] = {.lex_state = 0},
  [2258] = {.lex_state = 0},
  [2259] = {.lex_state = 0},
  [2260] = {.lex_state = 0},
  [2261] = {.lex_state = 140},
  [2262] = {.lex_state = 0},
  [2263] = {.lex_state = 53},
  [2264] = {.lex_state = 64},
  [2265] = {.lex_state = 64},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 0},
  [2268] = {.lex_state = 53},
  [2269] = {.lex_state = 0},
  [2270] = {.lex_state = 64},
  [2271] = {.lex_state = 64},
  [2272] = {.lex_state = 64},
  [2273] = {.lex_state = 140},
  [2274] = {.lex_state = 0},
  [2275] = {.lex_state = 0},
  [2276] = {.lex_state = 0},
  [2277] = {.lex_state = 43},
  [2278] = {.lex_state = 140},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 64},
  [2281] = {.lex_state = 53},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 53},
  [2284] = {.lex_state = 53},
  [2285] = {.lex_state = 140},
  [2286] = {.lex_state = 53},
  [2287] = {.lex_state = 0},
  [2288] = {.lex_state = 0},
  [2289] = {.lex_state = 43},
  [2290] = {.lex_state = 140},
  [2291] = {.lex_state = 0},
  [2292] = {.lex_state = 64},
  [2293] = {.lex_state = 140},
  [2294] = {.lex_state = 53},
  [2295] = {.lex_state = 43},
  [2296] = {.lex_state = 140},
  [2297] = {.lex_state = 53},
  [2298] = {.lex_state = 64},
  [2299] = {.lex_state = 140},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym___extension__] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym___attribute__] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym___declspec] = ACTIONS(1),
    [anon_sym___based] = ACTIONS(1),
    [anon_sym___cdecl] = ACTIONS(1),
    [anon_sym___clrcall] = ACTIONS(1),
    [anon_sym___stdcall] = ACTIONS(1),
    [anon_sym___fastcall] = ACTIONS(1),
    [anon_sym___thiscall] = ACTIONS(1),
    [anon_sym___vectorcall] = ACTIONS(1),
    [sym_ms_restrict_modifier] = ACTIONS(1),
    [sym_ms_unsigned_ptr_modifier] = ACTIONS(1),
    [sym_ms_signed_ptr_modifier] = ACTIONS(1),
    [anon_sym__unaligned] = ACTIONS(1),
    [anon_sym___unaligned] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_auto] = ACTIONS(1),
    [anon_sym_register] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym___inline] = ACTIONS(1),
    [anon_sym___inline__] = ACTIONS(1),
    [anon_sym___forceinline] = ACTIONS(1),
    [anon_sym_thread_local] = ACTIONS(1),
    [anon_sym___thread] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_constexpr] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_restrict] = ACTIONS(1),
    [anon_sym___restrict__] = ACTIONS(1),
    [anon_sym__Atomic] = ACTIONS(1),
    [anon_sym__Noreturn] = ACTIONS(1),
    [anon_sym_noreturn] = ACTIONS(1),
    [sym_primitive_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym___try] = ACTIONS(1),
    [anon_sym___except] = ACTIONS(1),
    [anon_sym___finally] = ACTIONS(1),
    [anon_sym___leave] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym___alignof__] = ACTIONS(1),
    [anon_sym___alignof] = ACTIONS(1),
    [anon_sym__alignof] = ACTIONS(1),
    [anon_sym_alignof] = ACTIONS(1),
    [anon_sym__Alignof] = ACTIONS(1),
    [anon_sym_offsetof] = ACTIONS(1),
    [anon_sym__Generic] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym___asm__] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_SQUOTE] = ACTIONS(1),
    [anon_sym_u_SQUOTE] = ACTIONS(1),
    [anon_sym_U_SQUOTE] = ACTIONS(1),
    [anon_sym_u8_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_nullptr] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_translation_unit] = STATE(2192),
    [sym_preproc_include] = STATE(52),
    [sym_preproc_def] = STATE(52),
    [sym_preproc_function_def] = STATE(52),
    [sym_preproc_call] = STATE(52),
    [sym_preproc_if] = STATE(52),
    [sym_preproc_ifdef] = STATE(52),
    [sym_function_definition] = STATE(52),
    [sym__old_style_function_definition] = STATE(485),
    [sym_declaration] = STATE(52),
    [sym_type_definition] = STATE(52),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1506),
    [sym_linkage_specification] = STATE(52),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(884),
    [sym_compound_statement] = STATE(52),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1156),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(52),
    [sym_labeled_statement] = STATE(52),
    [sym__top_level_expression_statement] = STATE(52),
    [sym_if_statement] = STATE(52),
    [sym_switch_statement] = STATE(52),
    [sym_case_statement] = STATE(52),
    [sym_while_statement] = STATE(52),
    [sym_do_statement] = STATE(52),
    [sym_for_statement] = STATE(52),
    [sym_return_statement] = STATE(52),
    [sym_break_statement] = STATE(52),
    [sym_continue_statement] = STATE(52),
    [sym_goto_statement] = STATE(52),
    [sym__expression] = STATE(1344),
    [sym__expression_not_binary] = STATE(1342),
    [sym__string] = STATE(1342),
    [sym_conditional_expression] = STATE(1342),
    [sym_assignment_expression] = STATE(1342),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(1342),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(1342),
    [sym_cast_expression] = STATE(1342),
    [sym_sizeof_expression] = STATE(1342),
    [sym_alignof_expression] = STATE(1342),
    [sym_offsetof_expression] = STATE(1342),
    [sym_generic_expression] = STATE(1342),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(1342),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(1342),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(1342),
    [sym_concatenated_string] = STATE(1342),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(1342),
    [sym__empty_declaration] = STATE(52),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_translation_unit_repeat1] = STATE(52),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(61),
    [anon_sym_default] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(91),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2017),
    [sym_preproc_elif] = STATE(2017),
    [sym_preproc_elifdef] = STATE(2017),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(109),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2030),
    [sym_preproc_elif] = STATE(2030),
    [sym_preproc_elifdef] = STATE(2030),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(161),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_preproc_include] = STATE(8),
    [sym_preproc_def] = STATE(8),
    [sym_preproc_function_def] = STATE(8),
    [sym_preproc_call] = STATE(8),
    [sym_preproc_if] = STATE(8),
    [sym_preproc_ifdef] = STATE(8),
    [sym_preproc_else] = STATE(2294),
    [sym_preproc_elif] = STATE(2294),
    [sym_preproc_elifdef] = STATE(2294),
    [sym_function_definition] = STATE(8),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(8),
    [sym_type_definition] = STATE(8),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(8),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(8),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(8),
    [sym_labeled_statement] = STATE(8),
    [sym_expression_statement] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_switch_statement] = STATE(8),
    [sym_case_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_do_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_break_statement] = STATE(8),
    [sym_continue_statement] = STATE(8),
    [sym_goto_statement] = STATE(8),
    [sym_seh_try_statement] = STATE(8),
    [sym_seh_leave_statement] = STATE(8),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(8),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(8),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(163),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2149),
    [sym_preproc_elif] = STATE(2149),
    [sym_preproc_elifdef] = STATE(2149),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(165),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_preproc_include] = STATE(3),
    [sym_preproc_def] = STATE(3),
    [sym_preproc_function_def] = STATE(3),
    [sym_preproc_call] = STATE(3),
    [sym_preproc_if] = STATE(3),
    [sym_preproc_ifdef] = STATE(3),
    [sym_preproc_else] = STATE(2121),
    [sym_preproc_elif] = STATE(2121),
    [sym_preproc_elifdef] = STATE(2121),
    [sym_function_definition] = STATE(3),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(3),
    [sym_type_definition] = STATE(3),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(3),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(3),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_case_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_goto_statement] = STATE(3),
    [sym_seh_try_statement] = STATE(3),
    [sym_seh_leave_statement] = STATE(3),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(3),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(3),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_preproc_include] = STATE(10),
    [sym_preproc_def] = STATE(10),
    [sym_preproc_function_def] = STATE(10),
    [sym_preproc_call] = STATE(10),
    [sym_preproc_if] = STATE(10),
    [sym_preproc_ifdef] = STATE(10),
    [sym_preproc_else] = STATE(2012),
    [sym_preproc_elif] = STATE(2012),
    [sym_preproc_elifdef] = STATE(2012),
    [sym_function_definition] = STATE(10),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(10),
    [sym_type_definition] = STATE(10),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(10),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(10),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(10),
    [sym_labeled_statement] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_case_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_goto_statement] = STATE(10),
    [sym_seh_try_statement] = STATE(10),
    [sym_seh_leave_statement] = STATE(10),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(10),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(10),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(169),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2218),
    [sym_preproc_elif] = STATE(2218),
    [sym_preproc_elifdef] = STATE(2218),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(171),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_preproc_include] = STATE(5),
    [sym_preproc_def] = STATE(5),
    [sym_preproc_function_def] = STATE(5),
    [sym_preproc_call] = STATE(5),
    [sym_preproc_if] = STATE(5),
    [sym_preproc_ifdef] = STATE(5),
    [sym_preproc_else] = STATE(2286),
    [sym_preproc_elif] = STATE(2286),
    [sym_preproc_elifdef] = STATE(2286),
    [sym_function_definition] = STATE(5),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(5),
    [sym_type_definition] = STATE(5),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(5),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(5),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(5),
    [sym_labeled_statement] = STATE(5),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_switch_statement] = STATE(5),
    [sym_case_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_goto_statement] = STATE(5),
    [sym_seh_try_statement] = STATE(5),
    [sym_seh_leave_statement] = STATE(5),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(5),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(5),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(173),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2126),
    [sym_preproc_elif] = STATE(2126),
    [sym_preproc_elifdef] = STATE(2126),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(175),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_preproc_include] = STATE(2),
    [sym_preproc_def] = STATE(2),
    [sym_preproc_function_def] = STATE(2),
    [sym_preproc_call] = STATE(2),
    [sym_preproc_if] = STATE(2),
    [sym_preproc_ifdef] = STATE(2),
    [sym_preproc_else] = STATE(2062),
    [sym_preproc_elif] = STATE(2062),
    [sym_preproc_elifdef] = STATE(2062),
    [sym_function_definition] = STATE(2),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(2),
    [sym_type_definition] = STATE(2),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(2),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(2),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(2),
    [sym_labeled_statement] = STATE(2),
    [sym_expression_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_switch_statement] = STATE(2),
    [sym_case_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_do_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_return_statement] = STATE(2),
    [sym_break_statement] = STATE(2),
    [sym_continue_statement] = STATE(2),
    [sym_goto_statement] = STATE(2),
    [sym_seh_try_statement] = STATE(2),
    [sym_seh_leave_statement] = STATE(2),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(2),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(2),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(177),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_preproc_include] = STATE(25),
    [sym_preproc_def] = STATE(25),
    [sym_preproc_function_def] = STATE(25),
    [sym_preproc_call] = STATE(25),
    [sym_preproc_if] = STATE(25),
    [sym_preproc_ifdef] = STATE(25),
    [sym_preproc_else] = STATE(2177),
    [sym_preproc_elif] = STATE(2177),
    [sym_function_definition] = STATE(25),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(25),
    [sym_type_definition] = STATE(25),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(25),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(25),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_case_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_goto_statement] = STATE(25),
    [sym_seh_try_statement] = STATE(25),
    [sym_seh_leave_statement] = STATE(25),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(25),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(25),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(187),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2168),
    [sym_preproc_elif] = STATE(2168),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_preproc_include] = STATE(16),
    [sym_preproc_def] = STATE(16),
    [sym_preproc_function_def] = STATE(16),
    [sym_preproc_call] = STATE(16),
    [sym_preproc_if] = STATE(16),
    [sym_preproc_ifdef] = STATE(16),
    [sym_preproc_else] = STATE(2015),
    [sym_preproc_elif] = STATE(2015),
    [sym_function_definition] = STATE(16),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(16),
    [sym_type_definition] = STATE(16),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(16),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(16),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_case_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_seh_try_statement] = STATE(16),
    [sym_seh_leave_statement] = STATE(16),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(16),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(16),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(231),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2281),
    [sym_preproc_elif] = STATE(2281),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(233),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2024),
    [sym_preproc_elif] = STATE(2024),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(235),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_preproc_include] = STATE(13),
    [sym_preproc_def] = STATE(13),
    [sym_preproc_function_def] = STATE(13),
    [sym_preproc_call] = STATE(13),
    [sym_preproc_if] = STATE(13),
    [sym_preproc_ifdef] = STATE(13),
    [sym_preproc_else] = STATE(2283),
    [sym_preproc_elif] = STATE(2283),
    [sym_function_definition] = STATE(13),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(13),
    [sym_type_definition] = STATE(13),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(13),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(13),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_case_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_goto_statement] = STATE(13),
    [sym_seh_try_statement] = STATE(13),
    [sym_seh_leave_statement] = STATE(13),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(13),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(13),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(237),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_preproc_include] = STATE(15),
    [sym_preproc_def] = STATE(15),
    [sym_preproc_function_def] = STATE(15),
    [sym_preproc_call] = STATE(15),
    [sym_preproc_if] = STATE(15),
    [sym_preproc_ifdef] = STATE(15),
    [sym_preproc_else] = STATE(2116),
    [sym_preproc_elif] = STATE(2116),
    [sym_function_definition] = STATE(15),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(15),
    [sym_type_definition] = STATE(15),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(15),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(15),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_case_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_goto_statement] = STATE(15),
    [sym_seh_try_statement] = STATE(15),
    [sym_seh_leave_statement] = STATE(15),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(15),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(15),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(239),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2042),
    [sym_preproc_elif] = STATE(2042),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(241),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_preproc_else] = STATE(2152),
    [sym_preproc_elif] = STATE(2152),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(24),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_case_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_goto_statement] = STATE(24),
    [sym_seh_try_statement] = STATE(24),
    [sym_seh_leave_statement] = STATE(24),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(243),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2173),
    [sym_preproc_elif] = STATE(2173),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(245),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_preproc_include] = STATE(21),
    [sym_preproc_def] = STATE(21),
    [sym_preproc_function_def] = STATE(21),
    [sym_preproc_call] = STATE(21),
    [sym_preproc_if] = STATE(21),
    [sym_preproc_ifdef] = STATE(21),
    [sym_preproc_else] = STATE(2023),
    [sym_preproc_elif] = STATE(2023),
    [sym_function_definition] = STATE(21),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(21),
    [sym_type_definition] = STATE(21),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(21),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(21),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_case_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_goto_statement] = STATE(21),
    [sym_seh_try_statement] = STATE(21),
    [sym_seh_leave_statement] = STATE(21),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(21),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(21),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(247),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_preproc_include] = STATE(19),
    [sym_preproc_def] = STATE(19),
    [sym_preproc_function_def] = STATE(19),
    [sym_preproc_call] = STATE(19),
    [sym_preproc_if] = STATE(19),
    [sym_preproc_ifdef] = STATE(19),
    [sym_preproc_else] = STATE(2224),
    [sym_preproc_elif] = STATE(2224),
    [sym_function_definition] = STATE(19),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(19),
    [sym_type_definition] = STATE(19),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(19),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(19),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_case_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_goto_statement] = STATE(19),
    [sym_seh_try_statement] = STATE(19),
    [sym_seh_leave_statement] = STATE(19),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(19),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(19),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(249),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2099),
    [sym_preproc_elif] = STATE(2099),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(251),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2284),
    [sym_preproc_elif] = STATE(2284),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(253),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(140),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1502),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(886),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1159),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(255),
    [aux_sym_preproc_include_token1] = ACTIONS(258),
    [aux_sym_preproc_def_token1] = ACTIONS(261),
    [aux_sym_preproc_if_token1] = ACTIONS(264),
    [aux_sym_preproc_if_token2] = ACTIONS(267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(269),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(269),
    [aux_sym_preproc_else_token1] = ACTIONS(267),
    [aux_sym_preproc_elif_token1] = ACTIONS(267),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(267),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(267),
    [sym_preproc_directive] = ACTIONS(272),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym___extension__] = ACTIONS(290),
    [anon_sym_typedef] = ACTIONS(293),
    [anon_sym_extern] = ACTIONS(296),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(338),
    [anon_sym_case] = ACTIONS(341),
    [anon_sym_default] = ACTIONS(344),
    [anon_sym_while] = ACTIONS(347),
    [anon_sym_do] = ACTIONS(350),
    [anon_sym_for] = ACTIONS(353),
    [anon_sym_return] = ACTIONS(356),
    [anon_sym_break] = ACTIONS(359),
    [anon_sym_continue] = ACTIONS(362),
    [anon_sym_goto] = ACTIONS(365),
    [anon_sym___try] = ACTIONS(368),
    [anon_sym___leave] = ACTIONS(371),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(240),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1504),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(889),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1158),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(407),
    [aux_sym_preproc_include_token1] = ACTIONS(410),
    [aux_sym_preproc_def_token1] = ACTIONS(413),
    [aux_sym_preproc_if_token1] = ACTIONS(416),
    [aux_sym_preproc_if_token2] = ACTIONS(267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(419),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(419),
    [aux_sym_preproc_else_token1] = ACTIONS(267),
    [aux_sym_preproc_elif_token1] = ACTIONS(267),
    [sym_preproc_directive] = ACTIONS(422),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(425),
    [anon_sym___extension__] = ACTIONS(428),
    [anon_sym_typedef] = ACTIONS(431),
    [anon_sym_extern] = ACTIONS(434),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(437),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(443),
    [anon_sym_case] = ACTIONS(446),
    [anon_sym_default] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_do] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_return] = ACTIONS(461),
    [anon_sym_break] = ACTIONS(464),
    [anon_sym_continue] = ACTIONS(467),
    [anon_sym_goto] = ACTIONS(470),
    [anon_sym___try] = ACTIONS(473),
    [anon_sym___leave] = ACTIONS(476),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_preproc_include] = STATE(36),
    [sym_preproc_def] = STATE(36),
    [sym_preproc_function_def] = STATE(36),
    [sym_preproc_call] = STATE(36),
    [sym_preproc_if] = STATE(36),
    [sym_preproc_ifdef] = STATE(36),
    [sym_function_definition] = STATE(36),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(36),
    [sym_type_definition] = STATE(36),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(36),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(36),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(36),
    [sym_labeled_statement] = STATE(36),
    [sym_expression_statement] = STATE(36),
    [sym_if_statement] = STATE(36),
    [sym_switch_statement] = STATE(36),
    [sym_case_statement] = STATE(36),
    [sym_while_statement] = STATE(36),
    [sym_do_statement] = STATE(36),
    [sym_for_statement] = STATE(36),
    [sym_return_statement] = STATE(36),
    [sym_break_statement] = STATE(36),
    [sym_continue_statement] = STATE(36),
    [sym_goto_statement] = STATE(36),
    [sym_seh_try_statement] = STATE(36),
    [sym_seh_leave_statement] = STATE(36),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(36),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(36),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_preproc_include] = STATE(35),
    [sym_preproc_def] = STATE(35),
    [sym_preproc_function_def] = STATE(35),
    [sym_preproc_call] = STATE(35),
    [sym_preproc_if] = STATE(35),
    [sym_preproc_ifdef] = STATE(35),
    [sym_function_definition] = STATE(35),
    [sym__old_style_function_definition] = STATE(471),
    [sym_declaration] = STATE(35),
    [sym_type_definition] = STATE(35),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1509),
    [sym_linkage_specification] = STATE(35),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(880),
    [sym_compound_statement] = STATE(35),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1157),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(35),
    [sym_labeled_statement] = STATE(35),
    [sym_expression_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_switch_statement] = STATE(35),
    [sym_case_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_do_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_return_statement] = STATE(35),
    [sym_break_statement] = STATE(35),
    [sym_continue_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym_seh_try_statement] = STATE(35),
    [sym_seh_leave_statement] = STATE(35),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(35),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(35),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(529),
    [aux_sym_preproc_include_token1] = ACTIONS(531),
    [aux_sym_preproc_def_token1] = ACTIONS(533),
    [aux_sym_preproc_if_token1] = ACTIONS(535),
    [aux_sym_preproc_if_token2] = ACTIONS(537),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(539),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(539),
    [sym_preproc_directive] = ACTIONS(541),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym___extension__] = ACTIONS(545),
    [anon_sym_typedef] = ACTIONS(547),
    [anon_sym_extern] = ACTIONS(549),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(555),
    [anon_sym_case] = ACTIONS(557),
    [anon_sym_default] = ACTIONS(559),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(565),
    [anon_sym_return] = ACTIONS(567),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_goto] = ACTIONS(573),
    [anon_sym___try] = ACTIONS(575),
    [anon_sym___leave] = ACTIONS(577),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_preproc_include] = STATE(29),
    [sym_preproc_def] = STATE(29),
    [sym_preproc_function_def] = STATE(29),
    [sym_preproc_call] = STATE(29),
    [sym_preproc_if] = STATE(29),
    [sym_preproc_ifdef] = STATE(29),
    [sym_function_definition] = STATE(29),
    [sym__old_style_function_definition] = STATE(471),
    [sym_declaration] = STATE(29),
    [sym_type_definition] = STATE(29),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1509),
    [sym_linkage_specification] = STATE(29),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(880),
    [sym_compound_statement] = STATE(29),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1157),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(29),
    [sym_labeled_statement] = STATE(29),
    [sym_expression_statement] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_switch_statement] = STATE(29),
    [sym_case_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_do_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_return_statement] = STATE(29),
    [sym_break_statement] = STATE(29),
    [sym_continue_statement] = STATE(29),
    [sym_goto_statement] = STATE(29),
    [sym_seh_try_statement] = STATE(29),
    [sym_seh_leave_statement] = STATE(29),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(29),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(29),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(529),
    [aux_sym_preproc_include_token1] = ACTIONS(531),
    [aux_sym_preproc_def_token1] = ACTIONS(533),
    [aux_sym_preproc_if_token1] = ACTIONS(535),
    [aux_sym_preproc_if_token2] = ACTIONS(581),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(539),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(539),
    [sym_preproc_directive] = ACTIONS(541),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym___extension__] = ACTIONS(545),
    [anon_sym_typedef] = ACTIONS(547),
    [anon_sym_extern] = ACTIONS(549),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(555),
    [anon_sym_case] = ACTIONS(557),
    [anon_sym_default] = ACTIONS(559),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(565),
    [anon_sym_return] = ACTIONS(567),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_goto] = ACTIONS(573),
    [anon_sym___try] = ACTIONS(575),
    [anon_sym___leave] = ACTIONS(577),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_preproc_include] = STATE(30),
    [sym_preproc_def] = STATE(30),
    [sym_preproc_function_def] = STATE(30),
    [sym_preproc_call] = STATE(30),
    [sym_preproc_if] = STATE(30),
    [sym_preproc_ifdef] = STATE(30),
    [sym_function_definition] = STATE(30),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(30),
    [sym_type_definition] = STATE(30),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(30),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(30),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(30),
    [sym_labeled_statement] = STATE(30),
    [sym_expression_statement] = STATE(30),
    [sym_if_statement] = STATE(30),
    [sym_switch_statement] = STATE(30),
    [sym_case_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_do_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_return_statement] = STATE(30),
    [sym_break_statement] = STATE(30),
    [sym_continue_statement] = STATE(30),
    [sym_goto_statement] = STATE(30),
    [sym_seh_try_statement] = STATE(30),
    [sym_seh_leave_statement] = STATE(30),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(30),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(30),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(583),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_preproc_include] = STATE(37),
    [sym_preproc_def] = STATE(37),
    [sym_preproc_function_def] = STATE(37),
    [sym_preproc_call] = STATE(37),
    [sym_preproc_if] = STATE(37),
    [sym_preproc_ifdef] = STATE(37),
    [sym_function_definition] = STATE(37),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(37),
    [sym_type_definition] = STATE(37),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(37),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(37),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(37),
    [sym_labeled_statement] = STATE(37),
    [sym_expression_statement] = STATE(37),
    [sym_if_statement] = STATE(37),
    [sym_switch_statement] = STATE(37),
    [sym_case_statement] = STATE(37),
    [sym_while_statement] = STATE(37),
    [sym_do_statement] = STATE(37),
    [sym_for_statement] = STATE(37),
    [sym_return_statement] = STATE(37),
    [sym_break_statement] = STATE(37),
    [sym_continue_statement] = STATE(37),
    [sym_goto_statement] = STATE(37),
    [sym_seh_try_statement] = STATE(37),
    [sym_seh_leave_statement] = STATE(37),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(37),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(37),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(585),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(587),
    [aux_sym_preproc_include_token1] = ACTIONS(590),
    [aux_sym_preproc_def_token1] = ACTIONS(593),
    [aux_sym_preproc_if_token1] = ACTIONS(596),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(599),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(599),
    [sym_preproc_directive] = ACTIONS(602),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(605),
    [anon_sym___extension__] = ACTIONS(608),
    [anon_sym_typedef] = ACTIONS(611),
    [anon_sym_extern] = ACTIONS(614),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(617),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(622),
    [anon_sym_switch] = ACTIONS(625),
    [anon_sym_case] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(631),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_do] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(640),
    [anon_sym_return] = ACTIONS(643),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(649),
    [anon_sym_goto] = ACTIONS(652),
    [anon_sym___try] = ACTIONS(655),
    [anon_sym___leave] = ACTIONS(658),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_preproc_include] = STATE(35),
    [sym_preproc_def] = STATE(35),
    [sym_preproc_function_def] = STATE(35),
    [sym_preproc_call] = STATE(35),
    [sym_preproc_if] = STATE(35),
    [sym_preproc_ifdef] = STATE(35),
    [sym_function_definition] = STATE(35),
    [sym__old_style_function_definition] = STATE(471),
    [sym_declaration] = STATE(35),
    [sym_type_definition] = STATE(35),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1509),
    [sym_linkage_specification] = STATE(35),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(880),
    [sym_compound_statement] = STATE(35),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1157),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(35),
    [sym_labeled_statement] = STATE(35),
    [sym_expression_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_switch_statement] = STATE(35),
    [sym_case_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_do_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_return_statement] = STATE(35),
    [sym_break_statement] = STATE(35),
    [sym_continue_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym_seh_try_statement] = STATE(35),
    [sym_seh_leave_statement] = STATE(35),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(35),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(35),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(661),
    [aux_sym_preproc_include_token1] = ACTIONS(664),
    [aux_sym_preproc_def_token1] = ACTIONS(667),
    [aux_sym_preproc_if_token1] = ACTIONS(670),
    [aux_sym_preproc_if_token2] = ACTIONS(267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(673),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(673),
    [sym_preproc_directive] = ACTIONS(676),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(679),
    [anon_sym___extension__] = ACTIONS(682),
    [anon_sym_typedef] = ACTIONS(685),
    [anon_sym_extern] = ACTIONS(688),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(691),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(694),
    [anon_sym_switch] = ACTIONS(697),
    [anon_sym_case] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(703),
    [anon_sym_while] = ACTIONS(706),
    [anon_sym_do] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_return] = ACTIONS(715),
    [anon_sym_break] = ACTIONS(718),
    [anon_sym_continue] = ACTIONS(721),
    [anon_sym_goto] = ACTIONS(724),
    [anon_sym___try] = ACTIONS(727),
    [anon_sym___leave] = ACTIONS(730),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(733),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(735),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(39),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_seh_try_statement] = STATE(39),
    [sym_seh_leave_statement] = STATE(39),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(39),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(39),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(737),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(739),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_preproc_include] = STATE(50),
    [sym_preproc_def] = STATE(50),
    [sym_preproc_function_def] = STATE(50),
    [sym_preproc_call] = STATE(50),
    [sym_preproc_if] = STATE(50),
    [sym_preproc_ifdef] = STATE(50),
    [sym_function_definition] = STATE(50),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(50),
    [sym_type_definition] = STATE(50),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(50),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(50),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(50),
    [sym_labeled_statement] = STATE(50),
    [sym_expression_statement] = STATE(50),
    [sym_if_statement] = STATE(50),
    [sym_switch_statement] = STATE(50),
    [sym_case_statement] = STATE(50),
    [sym_while_statement] = STATE(50),
    [sym_do_statement] = STATE(50),
    [sym_for_statement] = STATE(50),
    [sym_return_statement] = STATE(50),
    [sym_break_statement] = STATE(50),
    [sym_continue_statement] = STATE(50),
    [sym_goto_statement] = STATE(50),
    [sym_seh_try_statement] = STATE(50),
    [sym_seh_leave_statement] = STATE(50),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(50),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(50),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(741),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(743),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(745),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_preproc_include] = STATE(47),
    [sym_preproc_def] = STATE(47),
    [sym_preproc_function_def] = STATE(47),
    [sym_preproc_call] = STATE(47),
    [sym_preproc_if] = STATE(47),
    [sym_preproc_ifdef] = STATE(47),
    [sym_function_definition] = STATE(47),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(47),
    [sym_type_definition] = STATE(47),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(47),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(47),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(47),
    [sym_labeled_statement] = STATE(47),
    [sym_expression_statement] = STATE(47),
    [sym_if_statement] = STATE(47),
    [sym_switch_statement] = STATE(47),
    [sym_case_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_do_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_return_statement] = STATE(47),
    [sym_break_statement] = STATE(47),
    [sym_continue_statement] = STATE(47),
    [sym_goto_statement] = STATE(47),
    [sym_seh_try_statement] = STATE(47),
    [sym_seh_leave_statement] = STATE(47),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(47),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(47),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(747),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_preproc_include] = STATE(42),
    [sym_preproc_def] = STATE(42),
    [sym_preproc_function_def] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym_preproc_if] = STATE(42),
    [sym_preproc_ifdef] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(42),
    [sym_type_definition] = STATE(42),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(42),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(42),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(42),
    [sym_labeled_statement] = STATE(42),
    [sym_expression_statement] = STATE(42),
    [sym_if_statement] = STATE(42),
    [sym_switch_statement] = STATE(42),
    [sym_case_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_do_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_return_statement] = STATE(42),
    [sym_break_statement] = STATE(42),
    [sym_continue_statement] = STATE(42),
    [sym_goto_statement] = STATE(42),
    [sym_seh_try_statement] = STATE(42),
    [sym_seh_leave_statement] = STATE(42),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(42),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(42),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(749),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_preproc_include] = STATE(48),
    [sym_preproc_def] = STATE(48),
    [sym_preproc_function_def] = STATE(48),
    [sym_preproc_call] = STATE(48),
    [sym_preproc_if] = STATE(48),
    [sym_preproc_ifdef] = STATE(48),
    [sym_function_definition] = STATE(48),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(48),
    [sym_type_definition] = STATE(48),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(48),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(48),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(48),
    [sym_labeled_statement] = STATE(48),
    [sym_expression_statement] = STATE(48),
    [sym_if_statement] = STATE(48),
    [sym_switch_statement] = STATE(48),
    [sym_case_statement] = STATE(48),
    [sym_while_statement] = STATE(48),
    [sym_do_statement] = STATE(48),
    [sym_for_statement] = STATE(48),
    [sym_return_statement] = STATE(48),
    [sym_break_statement] = STATE(48),
    [sym_continue_statement] = STATE(48),
    [sym_goto_statement] = STATE(48),
    [sym_seh_try_statement] = STATE(48),
    [sym_seh_leave_statement] = STATE(48),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(48),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(48),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(751),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_preproc_include] = STATE(41),
    [sym_preproc_def] = STATE(41),
    [sym_preproc_function_def] = STATE(41),
    [sym_preproc_call] = STATE(41),
    [sym_preproc_if] = STATE(41),
    [sym_preproc_ifdef] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(41),
    [sym_type_definition] = STATE(41),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(41),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(41),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(41),
    [sym_labeled_statement] = STATE(41),
    [sym_expression_statement] = STATE(41),
    [sym_if_statement] = STATE(41),
    [sym_switch_statement] = STATE(41),
    [sym_case_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_do_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_return_statement] = STATE(41),
    [sym_break_statement] = STATE(41),
    [sym_continue_statement] = STATE(41),
    [sym_goto_statement] = STATE(41),
    [sym_seh_try_statement] = STATE(41),
    [sym_seh_leave_statement] = STATE(41),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(41),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(41),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(753),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(755),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(757),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(759),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(761),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_preproc_include] = STATE(49),
    [sym_preproc_def] = STATE(49),
    [sym_preproc_function_def] = STATE(49),
    [sym_preproc_call] = STATE(49),
    [sym_preproc_if] = STATE(49),
    [sym_preproc_ifdef] = STATE(49),
    [sym_function_definition] = STATE(49),
    [sym__old_style_function_definition] = STATE(424),
    [sym_declaration] = STATE(49),
    [sym_type_definition] = STATE(49),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1500),
    [sym_linkage_specification] = STATE(49),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(879),
    [sym_compound_statement] = STATE(49),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1154),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(49),
    [sym_labeled_statement] = STATE(49),
    [sym_expression_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_case_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_do_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_return_statement] = STATE(49),
    [sym_break_statement] = STATE(49),
    [sym_continue_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_seh_try_statement] = STATE(49),
    [sym_seh_leave_statement] = STATE(49),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym__empty_declaration] = STATE(49),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_preproc_if_repeat1] = STATE(49),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(763),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_preproc_include] = STATE(53),
    [sym_preproc_def] = STATE(53),
    [sym_preproc_function_def] = STATE(53),
    [sym_preproc_call] = STATE(53),
    [sym_preproc_if] = STATE(53),
    [sym_preproc_ifdef] = STATE(53),
    [sym_function_definition] = STATE(53),
    [sym__old_style_function_definition] = STATE(485),
    [sym_declaration] = STATE(53),
    [sym_type_definition] = STATE(53),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1506),
    [sym_linkage_specification] = STATE(53),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(884),
    [sym_compound_statement] = STATE(53),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1156),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(53),
    [sym_labeled_statement] = STATE(53),
    [sym__top_level_expression_statement] = STATE(53),
    [sym_if_statement] = STATE(53),
    [sym_switch_statement] = STATE(53),
    [sym_case_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_do_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_return_statement] = STATE(53),
    [sym_break_statement] = STATE(53),
    [sym_continue_statement] = STATE(53),
    [sym_goto_statement] = STATE(53),
    [sym__expression] = STATE(1344),
    [sym__expression_not_binary] = STATE(1342),
    [sym__string] = STATE(1342),
    [sym_conditional_expression] = STATE(1342),
    [sym_assignment_expression] = STATE(1342),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(1342),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(1342),
    [sym_cast_expression] = STATE(1342),
    [sym_sizeof_expression] = STATE(1342),
    [sym_alignof_expression] = STATE(1342),
    [sym_offsetof_expression] = STATE(1342),
    [sym_generic_expression] = STATE(1342),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(1342),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(1342),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(1342),
    [sym_concatenated_string] = STATE(1342),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(1342),
    [sym__empty_declaration] = STATE(53),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_translation_unit_repeat1] = STATE(53),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [ts_builtin_sym_end] = ACTIONS(765),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(61),
    [anon_sym_default] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(91),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_preproc_include] = STATE(53),
    [sym_preproc_def] = STATE(53),
    [sym_preproc_function_def] = STATE(53),
    [sym_preproc_call] = STATE(53),
    [sym_preproc_if] = STATE(53),
    [sym_preproc_ifdef] = STATE(53),
    [sym_function_definition] = STATE(53),
    [sym__old_style_function_definition] = STATE(485),
    [sym_declaration] = STATE(53),
    [sym_type_definition] = STATE(53),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1506),
    [sym_linkage_specification] = STATE(53),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_ms_call_modifier] = STATE(884),
    [sym_compound_statement] = STATE(53),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1156),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(53),
    [sym_labeled_statement] = STATE(53),
    [sym__top_level_expression_statement] = STATE(53),
    [sym_if_statement] = STATE(53),
    [sym_switch_statement] = STATE(53),
    [sym_case_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_do_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_return_statement] = STATE(53),
    [sym_break_statement] = STATE(53),
    [sym_continue_statement] = STATE(53),
    [sym_goto_statement] = STATE(53),
    [sym__expression] = STATE(1344),
    [sym__expression_not_binary] = STATE(1342),
    [sym__string] = STATE(1342),
    [sym_conditional_expression] = STATE(1342),
    [sym_assignment_expression] = STATE(1342),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(1342),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(1342),
    [sym_cast_expression] = STATE(1342),
    [sym_sizeof_expression] = STATE(1342),
    [sym_alignof_expression] = STATE(1342),
    [sym_offsetof_expression] = STATE(1342),
    [sym_generic_expression] = STATE(1342),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(1342),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(1342),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(1342),
    [sym_concatenated_string] = STATE(1342),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(1342),
    [sym__empty_declaration] = STATE(53),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym_translation_unit_repeat1] = STATE(53),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [ts_builtin_sym_end] = ACTIONS(767),
    [sym_identifier] = ACTIONS(769),
    [aux_sym_preproc_include_token1] = ACTIONS(772),
    [aux_sym_preproc_def_token1] = ACTIONS(775),
    [aux_sym_preproc_if_token1] = ACTIONS(778),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(781),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(781),
    [sym_preproc_directive] = ACTIONS(784),
    [anon_sym_LPAREN2] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(796),
    [anon_sym___extension__] = ACTIONS(799),
    [anon_sym_typedef] = ACTIONS(802),
    [anon_sym_extern] = ACTIONS(805),
    [anon_sym___attribute__] = ACTIONS(808),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(811),
    [anon_sym___declspec] = ACTIONS(814),
    [anon_sym___cdecl] = ACTIONS(817),
    [anon_sym___clrcall] = ACTIONS(817),
    [anon_sym___stdcall] = ACTIONS(817),
    [anon_sym___fastcall] = ACTIONS(817),
    [anon_sym___thiscall] = ACTIONS(817),
    [anon_sym___vectorcall] = ACTIONS(817),
    [anon_sym_LBRACE] = ACTIONS(820),
    [anon_sym_signed] = ACTIONS(823),
    [anon_sym_unsigned] = ACTIONS(823),
    [anon_sym_long] = ACTIONS(823),
    [anon_sym_short] = ACTIONS(823),
    [anon_sym_static] = ACTIONS(826),
    [anon_sym_auto] = ACTIONS(826),
    [anon_sym_register] = ACTIONS(826),
    [anon_sym_inline] = ACTIONS(826),
    [anon_sym___inline] = ACTIONS(826),
    [anon_sym___inline__] = ACTIONS(826),
    [anon_sym___forceinline] = ACTIONS(826),
    [anon_sym_thread_local] = ACTIONS(826),
    [anon_sym___thread] = ACTIONS(826),
    [anon_sym_const] = ACTIONS(829),
    [anon_sym_constexpr] = ACTIONS(829),
    [anon_sym_volatile] = ACTIONS(829),
    [anon_sym_restrict] = ACTIONS(829),
    [anon_sym___restrict__] = ACTIONS(829),
    [anon_sym__Atomic] = ACTIONS(829),
    [anon_sym__Noreturn] = ACTIONS(829),
    [anon_sym_noreturn] = ACTIONS(829),
    [sym_primitive_type] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(835),
    [anon_sym_struct] = ACTIONS(838),
    [anon_sym_union] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(844),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_case] = ACTIONS(850),
    [anon_sym_default] = ACTIONS(853),
    [anon_sym_while] = ACTIONS(856),
    [anon_sym_do] = ACTIONS(859),
    [anon_sym_for] = ACTIONS(862),
    [anon_sym_return] = ACTIONS(865),
    [anon_sym_break] = ACTIONS(868),
    [anon_sym_continue] = ACTIONS(871),
    [anon_sym_goto] = ACTIONS(874),
    [anon_sym_DASH_DASH] = ACTIONS(877),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_sizeof] = ACTIONS(880),
    [anon_sym___alignof__] = ACTIONS(883),
    [anon_sym___alignof] = ACTIONS(883),
    [anon_sym__alignof] = ACTIONS(883),
    [anon_sym_alignof] = ACTIONS(883),
    [anon_sym__Alignof] = ACTIONS(883),
    [anon_sym_offsetof] = ACTIONS(886),
    [anon_sym__Generic] = ACTIONS(889),
    [anon_sym_asm] = ACTIONS(892),
    [anon_sym___asm__] = ACTIONS(892),
    [sym_number_literal] = ACTIONS(895),
    [anon_sym_L_SQUOTE] = ACTIONS(898),
    [anon_sym_u_SQUOTE] = ACTIONS(898),
    [anon_sym_U_SQUOTE] = ACTIONS(898),
    [anon_sym_u8_SQUOTE] = ACTIONS(898),
    [anon_sym_SQUOTE] = ACTIONS(898),
    [anon_sym_L_DQUOTE] = ACTIONS(901),
    [anon_sym_u_DQUOTE] = ACTIONS(901),
    [anon_sym_U_DQUOTE] = ACTIONS(901),
    [anon_sym_u8_DQUOTE] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(901),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [anon_sym_NULL] = ACTIONS(907),
    [anon_sym_nullptr] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_declaration] = STATE(57),
    [sym_type_definition] = STATE(57),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1513),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(57),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(57),
    [sym_labeled_statement] = STATE(57),
    [sym_expression_statement] = STATE(57),
    [sym_if_statement] = STATE(57),
    [sym_switch_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_do_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_return_statement] = STATE(57),
    [sym_break_statement] = STATE(57),
    [sym_continue_statement] = STATE(57),
    [sym_goto_statement] = STATE(57),
    [sym_seh_try_statement] = STATE(57),
    [sym_seh_leave_statement] = STATE(57),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(57),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token2] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [aux_sym_preproc_else_token1] = ACTIONS(912),
    [aux_sym_preproc_elif_token1] = ACTIONS(912),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1513),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token2] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [aux_sym_preproc_else_token1] = ACTIONS(914),
    [aux_sym_preproc_elif_token1] = ACTIONS(914),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_declaration] = STATE(55),
    [sym_type_definition] = STATE(55),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1513),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(55),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(55),
    [sym_labeled_statement] = STATE(55),
    [sym_expression_statement] = STATE(55),
    [sym_if_statement] = STATE(55),
    [sym_switch_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_do_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_return_statement] = STATE(55),
    [sym_break_statement] = STATE(55),
    [sym_continue_statement] = STATE(55),
    [sym_goto_statement] = STATE(55),
    [sym_seh_try_statement] = STATE(55),
    [sym_seh_leave_statement] = STATE(55),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token2] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [aux_sym_preproc_else_token1] = ACTIONS(916),
    [aux_sym_preproc_elif_token1] = ACTIONS(916),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1513),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token2] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [aux_sym_preproc_else_token1] = ACTIONS(918),
    [aux_sym_preproc_elif_token1] = ACTIONS(918),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1513),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym__expression] = STATE(1263),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2260),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(920),
    [aux_sym_preproc_include_token1] = ACTIONS(923),
    [aux_sym_preproc_def_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token2] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(923),
    [aux_sym_preproc_else_token1] = ACTIONS(923),
    [aux_sym_preproc_elif_token1] = ACTIONS(923),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(923),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(923),
    [sym_preproc_directive] = ACTIONS(923),
    [anon_sym_LPAREN2] = ACTIONS(925),
    [anon_sym_BANG] = ACTIONS(928),
    [anon_sym_TILDE] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(931),
    [anon_sym_PLUS] = ACTIONS(931),
    [anon_sym_STAR] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(934),
    [anon_sym_SEMI] = ACTIONS(937),
    [anon_sym___extension__] = ACTIONS(940),
    [anon_sym_typedef] = ACTIONS(943),
    [anon_sym_extern] = ACTIONS(946),
    [anon_sym___attribute__] = ACTIONS(949),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(952),
    [anon_sym___declspec] = ACTIONS(955),
    [anon_sym___cdecl] = ACTIONS(923),
    [anon_sym___clrcall] = ACTIONS(923),
    [anon_sym___stdcall] = ACTIONS(923),
    [anon_sym___fastcall] = ACTIONS(923),
    [anon_sym___thiscall] = ACTIONS(923),
    [anon_sym___vectorcall] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(958),
    [anon_sym_signed] = ACTIONS(961),
    [anon_sym_unsigned] = ACTIONS(961),
    [anon_sym_long] = ACTIONS(961),
    [anon_sym_short] = ACTIONS(961),
    [anon_sym_static] = ACTIONS(946),
    [anon_sym_auto] = ACTIONS(946),
    [anon_sym_register] = ACTIONS(946),
    [anon_sym_inline] = ACTIONS(946),
    [anon_sym___inline] = ACTIONS(946),
    [anon_sym___inline__] = ACTIONS(946),
    [anon_sym___forceinline] = ACTIONS(946),
    [anon_sym_thread_local] = ACTIONS(946),
    [anon_sym___thread] = ACTIONS(946),
    [anon_sym_const] = ACTIONS(964),
    [anon_sym_constexpr] = ACTIONS(964),
    [anon_sym_volatile] = ACTIONS(964),
    [anon_sym_restrict] = ACTIONS(964),
    [anon_sym___restrict__] = ACTIONS(964),
    [anon_sym__Atomic] = ACTIONS(964),
    [anon_sym__Noreturn] = ACTIONS(964),
    [anon_sym_noreturn] = ACTIONS(964),
    [sym_primitive_type] = ACTIONS(967),
    [anon_sym_enum] = ACTIONS(970),
    [anon_sym_struct] = ACTIONS(973),
    [anon_sym_union] = ACTIONS(976),
    [anon_sym_if] = ACTIONS(979),
    [anon_sym_else] = ACTIONS(923),
    [anon_sym_switch] = ACTIONS(982),
    [anon_sym_case] = ACTIONS(923),
    [anon_sym_default] = ACTIONS(923),
    [anon_sym_while] = ACTIONS(985),
    [anon_sym_do] = ACTIONS(988),
    [anon_sym_for] = ACTIONS(991),
    [anon_sym_return] = ACTIONS(994),
    [anon_sym_break] = ACTIONS(997),
    [anon_sym_continue] = ACTIONS(1000),
    [anon_sym_goto] = ACTIONS(1003),
    [anon_sym___try] = ACTIONS(1006),
    [anon_sym___leave] = ACTIONS(1009),
    [anon_sym_DASH_DASH] = ACTIONS(1012),
    [anon_sym_PLUS_PLUS] = ACTIONS(1012),
    [anon_sym_sizeof] = ACTIONS(1015),
    [anon_sym___alignof__] = ACTIONS(1018),
    [anon_sym___alignof] = ACTIONS(1018),
    [anon_sym__alignof] = ACTIONS(1018),
    [anon_sym_alignof] = ACTIONS(1018),
    [anon_sym__Alignof] = ACTIONS(1018),
    [anon_sym_offsetof] = ACTIONS(1021),
    [anon_sym__Generic] = ACTIONS(1024),
    [anon_sym_asm] = ACTIONS(1027),
    [anon_sym___asm__] = ACTIONS(1027),
    [sym_number_literal] = ACTIONS(1030),
    [anon_sym_L_SQUOTE] = ACTIONS(1033),
    [anon_sym_u_SQUOTE] = ACTIONS(1033),
    [anon_sym_U_SQUOTE] = ACTIONS(1033),
    [anon_sym_u8_SQUOTE] = ACTIONS(1033),
    [anon_sym_SQUOTE] = ACTIONS(1033),
    [anon_sym_L_DQUOTE] = ACTIONS(1036),
    [anon_sym_u_DQUOTE] = ACTIONS(1036),
    [anon_sym_U_DQUOTE] = ACTIONS(1036),
    [anon_sym_u8_DQUOTE] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [sym_true] = ACTIONS(1039),
    [sym_false] = ACTIONS(1039),
    [anon_sym_NULL] = ACTIONS(1042),
    [anon_sym_nullptr] = ACTIONS(1042),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_declaration] = STATE(62),
    [sym_type_definition] = STATE(62),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1520),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(62),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(62),
    [sym_labeled_statement] = STATE(62),
    [sym_expression_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_switch_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_do_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_return_statement] = STATE(62),
    [sym_break_statement] = STATE(62),
    [sym_continue_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_seh_try_statement] = STATE(62),
    [sym_seh_leave_statement] = STATE(62),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token2] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [aux_sym_preproc_else_token1] = ACTIONS(916),
    [aux_sym_preproc_elif_token1] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1520),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(1047),
    [aux_sym_preproc_include_token1] = ACTIONS(923),
    [aux_sym_preproc_def_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token2] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(923),
    [aux_sym_preproc_else_token1] = ACTIONS(923),
    [aux_sym_preproc_elif_token1] = ACTIONS(923),
    [sym_preproc_directive] = ACTIONS(923),
    [anon_sym_LPAREN2] = ACTIONS(925),
    [anon_sym_BANG] = ACTIONS(928),
    [anon_sym_TILDE] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(931),
    [anon_sym_PLUS] = ACTIONS(931),
    [anon_sym_STAR] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(934),
    [anon_sym_SEMI] = ACTIONS(1050),
    [anon_sym___extension__] = ACTIONS(1053),
    [anon_sym_typedef] = ACTIONS(1056),
    [anon_sym_extern] = ACTIONS(946),
    [anon_sym___attribute__] = ACTIONS(949),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(952),
    [anon_sym___declspec] = ACTIONS(955),
    [anon_sym___cdecl] = ACTIONS(923),
    [anon_sym___clrcall] = ACTIONS(923),
    [anon_sym___stdcall] = ACTIONS(923),
    [anon_sym___fastcall] = ACTIONS(923),
    [anon_sym___thiscall] = ACTIONS(923),
    [anon_sym___vectorcall] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(1059),
    [anon_sym_signed] = ACTIONS(961),
    [anon_sym_unsigned] = ACTIONS(961),
    [anon_sym_long] = ACTIONS(961),
    [anon_sym_short] = ACTIONS(961),
    [anon_sym_static] = ACTIONS(946),
    [anon_sym_auto] = ACTIONS(946),
    [anon_sym_register] = ACTIONS(946),
    [anon_sym_inline] = ACTIONS(946),
    [anon_sym___inline] = ACTIONS(946),
    [anon_sym___inline__] = ACTIONS(946),
    [anon_sym___forceinline] = ACTIONS(946),
    [anon_sym_thread_local] = ACTIONS(946),
    [anon_sym___thread] = ACTIONS(946),
    [anon_sym_const] = ACTIONS(964),
    [anon_sym_constexpr] = ACTIONS(964),
    [anon_sym_volatile] = ACTIONS(964),
    [anon_sym_restrict] = ACTIONS(964),
    [anon_sym___restrict__] = ACTIONS(964),
    [anon_sym__Atomic] = ACTIONS(964),
    [anon_sym__Noreturn] = ACTIONS(964),
    [anon_sym_noreturn] = ACTIONS(964),
    [sym_primitive_type] = ACTIONS(967),
    [anon_sym_enum] = ACTIONS(970),
    [anon_sym_struct] = ACTIONS(973),
    [anon_sym_union] = ACTIONS(976),
    [anon_sym_if] = ACTIONS(1062),
    [anon_sym_else] = ACTIONS(923),
    [anon_sym_switch] = ACTIONS(1065),
    [anon_sym_case] = ACTIONS(923),
    [anon_sym_default] = ACTIONS(923),
    [anon_sym_while] = ACTIONS(1068),
    [anon_sym_do] = ACTIONS(1071),
    [anon_sym_for] = ACTIONS(1074),
    [anon_sym_return] = ACTIONS(1077),
    [anon_sym_break] = ACTIONS(1080),
    [anon_sym_continue] = ACTIONS(1083),
    [anon_sym_goto] = ACTIONS(1086),
    [anon_sym___try] = ACTIONS(1089),
    [anon_sym___leave] = ACTIONS(1092),
    [anon_sym_DASH_DASH] = ACTIONS(1012),
    [anon_sym_PLUS_PLUS] = ACTIONS(1012),
    [anon_sym_sizeof] = ACTIONS(1015),
    [anon_sym___alignof__] = ACTIONS(1018),
    [anon_sym___alignof] = ACTIONS(1018),
    [anon_sym__alignof] = ACTIONS(1018),
    [anon_sym_alignof] = ACTIONS(1018),
    [anon_sym__Alignof] = ACTIONS(1018),
    [anon_sym_offsetof] = ACTIONS(1021),
    [anon_sym__Generic] = ACTIONS(1024),
    [anon_sym_asm] = ACTIONS(1027),
    [anon_sym___asm__] = ACTIONS(1027),
    [sym_number_literal] = ACTIONS(1030),
    [anon_sym_L_SQUOTE] = ACTIONS(1033),
    [anon_sym_u_SQUOTE] = ACTIONS(1033),
    [anon_sym_U_SQUOTE] = ACTIONS(1033),
    [anon_sym_u8_SQUOTE] = ACTIONS(1033),
    [anon_sym_SQUOTE] = ACTIONS(1033),
    [anon_sym_L_DQUOTE] = ACTIONS(1036),
    [anon_sym_u_DQUOTE] = ACTIONS(1036),
    [anon_sym_U_DQUOTE] = ACTIONS(1036),
    [anon_sym_u8_DQUOTE] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [sym_true] = ACTIONS(1039),
    [sym_false] = ACTIONS(1039),
    [anon_sym_NULL] = ACTIONS(1042),
    [anon_sym_nullptr] = ACTIONS(1042),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1520),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token2] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [aux_sym_preproc_else_token1] = ACTIONS(918),
    [aux_sym_preproc_elif_token1] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1520),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token2] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [aux_sym_preproc_else_token1] = ACTIONS(914),
    [aux_sym_preproc_elif_token1] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_declaration] = STATE(61),
    [sym_type_definition] = STATE(61),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1520),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(61),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(61),
    [sym_labeled_statement] = STATE(61),
    [sym_expression_statement] = STATE(61),
    [sym_if_statement] = STATE(61),
    [sym_switch_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_do_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_return_statement] = STATE(61),
    [sym_break_statement] = STATE(61),
    [sym_continue_statement] = STATE(61),
    [sym_goto_statement] = STATE(61),
    [sym_seh_try_statement] = STATE(61),
    [sym_seh_leave_statement] = STATE(61),
    [sym__expression] = STATE(1242),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2212),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(391),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token2] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [aux_sym_preproc_else_token1] = ACTIONS(912),
    [aux_sym_preproc_elif_token1] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1514),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(1095),
    [aux_sym_preproc_include_token1] = ACTIONS(923),
    [aux_sym_preproc_def_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(923),
    [sym_preproc_directive] = ACTIONS(923),
    [anon_sym_LPAREN2] = ACTIONS(925),
    [anon_sym_BANG] = ACTIONS(928),
    [anon_sym_TILDE] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(931),
    [anon_sym_PLUS] = ACTIONS(931),
    [anon_sym_STAR] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(934),
    [anon_sym_SEMI] = ACTIONS(1098),
    [anon_sym___extension__] = ACTIONS(1101),
    [anon_sym_typedef] = ACTIONS(1104),
    [anon_sym_extern] = ACTIONS(946),
    [anon_sym___attribute__] = ACTIONS(949),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(952),
    [anon_sym___declspec] = ACTIONS(955),
    [anon_sym___cdecl] = ACTIONS(923),
    [anon_sym___clrcall] = ACTIONS(923),
    [anon_sym___stdcall] = ACTIONS(923),
    [anon_sym___fastcall] = ACTIONS(923),
    [anon_sym___thiscall] = ACTIONS(923),
    [anon_sym___vectorcall] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(1107),
    [anon_sym_RBRACE] = ACTIONS(1110),
    [anon_sym_signed] = ACTIONS(961),
    [anon_sym_unsigned] = ACTIONS(961),
    [anon_sym_long] = ACTIONS(961),
    [anon_sym_short] = ACTIONS(961),
    [anon_sym_static] = ACTIONS(946),
    [anon_sym_auto] = ACTIONS(946),
    [anon_sym_register] = ACTIONS(946),
    [anon_sym_inline] = ACTIONS(946),
    [anon_sym___inline] = ACTIONS(946),
    [anon_sym___inline__] = ACTIONS(946),
    [anon_sym___forceinline] = ACTIONS(946),
    [anon_sym_thread_local] = ACTIONS(946),
    [anon_sym___thread] = ACTIONS(946),
    [anon_sym_const] = ACTIONS(964),
    [anon_sym_constexpr] = ACTIONS(964),
    [anon_sym_volatile] = ACTIONS(964),
    [anon_sym_restrict] = ACTIONS(964),
    [anon_sym___restrict__] = ACTIONS(964),
    [anon_sym__Atomic] = ACTIONS(964),
    [anon_sym__Noreturn] = ACTIONS(964),
    [anon_sym_noreturn] = ACTIONS(964),
    [sym_primitive_type] = ACTIONS(967),
    [anon_sym_enum] = ACTIONS(970),
    [anon_sym_struct] = ACTIONS(973),
    [anon_sym_union] = ACTIONS(976),
    [anon_sym_if] = ACTIONS(1112),
    [anon_sym_else] = ACTIONS(923),
    [anon_sym_switch] = ACTIONS(1115),
    [anon_sym_case] = ACTIONS(923),
    [anon_sym_default] = ACTIONS(923),
    [anon_sym_while] = ACTIONS(1118),
    [anon_sym_do] = ACTIONS(1121),
    [anon_sym_for] = ACTIONS(1124),
    [anon_sym_return] = ACTIONS(1127),
    [anon_sym_break] = ACTIONS(1130),
    [anon_sym_continue] = ACTIONS(1133),
    [anon_sym_goto] = ACTIONS(1136),
    [anon_sym___try] = ACTIONS(1139),
    [anon_sym___leave] = ACTIONS(1142),
    [anon_sym_DASH_DASH] = ACTIONS(1012),
    [anon_sym_PLUS_PLUS] = ACTIONS(1012),
    [anon_sym_sizeof] = ACTIONS(1015),
    [anon_sym___alignof__] = ACTIONS(1018),
    [anon_sym___alignof] = ACTIONS(1018),
    [anon_sym__alignof] = ACTIONS(1018),
    [anon_sym_alignof] = ACTIONS(1018),
    [anon_sym__Alignof] = ACTIONS(1018),
    [anon_sym_offsetof] = ACTIONS(1021),
    [anon_sym__Generic] = ACTIONS(1024),
    [anon_sym_asm] = ACTIONS(1027),
    [anon_sym___asm__] = ACTIONS(1027),
    [sym_number_literal] = ACTIONS(1030),
    [anon_sym_L_SQUOTE] = ACTIONS(1033),
    [anon_sym_u_SQUOTE] = ACTIONS(1033),
    [anon_sym_U_SQUOTE] = ACTIONS(1033),
    [anon_sym_u8_SQUOTE] = ACTIONS(1033),
    [anon_sym_SQUOTE] = ACTIONS(1033),
    [anon_sym_L_DQUOTE] = ACTIONS(1036),
    [anon_sym_u_DQUOTE] = ACTIONS(1036),
    [anon_sym_U_DQUOTE] = ACTIONS(1036),
    [anon_sym_u8_DQUOTE] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [sym_true] = ACTIONS(1039),
    [sym_false] = ACTIONS(1039),
    [anon_sym_NULL] = ACTIONS(1042),
    [anon_sym_nullptr] = ACTIONS(1042),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_declaration] = STATE(65),
    [sym_type_definition] = STATE(65),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1523),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(65),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(65),
    [sym_labeled_statement] = STATE(65),
    [sym_expression_statement] = STATE(65),
    [sym_if_statement] = STATE(65),
    [sym_switch_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_do_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_return_statement] = STATE(65),
    [sym_break_statement] = STATE(65),
    [sym_continue_statement] = STATE(65),
    [sym_goto_statement] = STATE(65),
    [sym_seh_try_statement] = STATE(65),
    [sym_seh_leave_statement] = STATE(65),
    [sym__expression] = STATE(1284),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2035),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(1110),
    [sym_identifier] = ACTIONS(1145),
    [aux_sym_preproc_include_token1] = ACTIONS(923),
    [aux_sym_preproc_def_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(923),
    [sym_preproc_directive] = ACTIONS(923),
    [anon_sym_LPAREN2] = ACTIONS(925),
    [anon_sym_BANG] = ACTIONS(928),
    [anon_sym_TILDE] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(931),
    [anon_sym_PLUS] = ACTIONS(931),
    [anon_sym_STAR] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(934),
    [anon_sym_SEMI] = ACTIONS(1148),
    [anon_sym___extension__] = ACTIONS(1151),
    [anon_sym_typedef] = ACTIONS(1154),
    [anon_sym_extern] = ACTIONS(946),
    [anon_sym___attribute__] = ACTIONS(949),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(952),
    [anon_sym___declspec] = ACTIONS(955),
    [anon_sym___cdecl] = ACTIONS(923),
    [anon_sym___clrcall] = ACTIONS(923),
    [anon_sym___stdcall] = ACTIONS(923),
    [anon_sym___fastcall] = ACTIONS(923),
    [anon_sym___thiscall] = ACTIONS(923),
    [anon_sym___vectorcall] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(1157),
    [anon_sym_signed] = ACTIONS(961),
    [anon_sym_unsigned] = ACTIONS(961),
    [anon_sym_long] = ACTIONS(961),
    [anon_sym_short] = ACTIONS(961),
    [anon_sym_static] = ACTIONS(946),
    [anon_sym_auto] = ACTIONS(946),
    [anon_sym_register] = ACTIONS(946),
    [anon_sym_inline] = ACTIONS(946),
    [anon_sym___inline] = ACTIONS(946),
    [anon_sym___inline__] = ACTIONS(946),
    [anon_sym___forceinline] = ACTIONS(946),
    [anon_sym_thread_local] = ACTIONS(946),
    [anon_sym___thread] = ACTIONS(946),
    [anon_sym_const] = ACTIONS(964),
    [anon_sym_constexpr] = ACTIONS(964),
    [anon_sym_volatile] = ACTIONS(964),
    [anon_sym_restrict] = ACTIONS(964),
    [anon_sym___restrict__] = ACTIONS(964),
    [anon_sym__Atomic] = ACTIONS(964),
    [anon_sym__Noreturn] = ACTIONS(964),
    [anon_sym_noreturn] = ACTIONS(964),
    [sym_primitive_type] = ACTIONS(967),
    [anon_sym_enum] = ACTIONS(970),
    [anon_sym_struct] = ACTIONS(973),
    [anon_sym_union] = ACTIONS(976),
    [anon_sym_if] = ACTIONS(1160),
    [anon_sym_else] = ACTIONS(923),
    [anon_sym_switch] = ACTIONS(1163),
    [anon_sym_case] = ACTIONS(923),
    [anon_sym_default] = ACTIONS(923),
    [anon_sym_while] = ACTIONS(1166),
    [anon_sym_do] = ACTIONS(1169),
    [anon_sym_for] = ACTIONS(1172),
    [anon_sym_return] = ACTIONS(1175),
    [anon_sym_break] = ACTIONS(1178),
    [anon_sym_continue] = ACTIONS(1181),
    [anon_sym_goto] = ACTIONS(1184),
    [anon_sym___try] = ACTIONS(1187),
    [anon_sym___leave] = ACTIONS(1190),
    [anon_sym_DASH_DASH] = ACTIONS(1012),
    [anon_sym_PLUS_PLUS] = ACTIONS(1012),
    [anon_sym_sizeof] = ACTIONS(1015),
    [anon_sym___alignof__] = ACTIONS(1018),
    [anon_sym___alignof] = ACTIONS(1018),
    [anon_sym__alignof] = ACTIONS(1018),
    [anon_sym_alignof] = ACTIONS(1018),
    [anon_sym__Alignof] = ACTIONS(1018),
    [anon_sym_offsetof] = ACTIONS(1021),
    [anon_sym__Generic] = ACTIONS(1024),
    [anon_sym_asm] = ACTIONS(1027),
    [anon_sym___asm__] = ACTIONS(1027),
    [sym_number_literal] = ACTIONS(1030),
    [anon_sym_L_SQUOTE] = ACTIONS(1033),
    [anon_sym_u_SQUOTE] = ACTIONS(1033),
    [anon_sym_U_SQUOTE] = ACTIONS(1033),
    [anon_sym_u8_SQUOTE] = ACTIONS(1033),
    [anon_sym_SQUOTE] = ACTIONS(1033),
    [anon_sym_L_DQUOTE] = ACTIONS(1036),
    [anon_sym_u_DQUOTE] = ACTIONS(1036),
    [anon_sym_U_DQUOTE] = ACTIONS(1036),
    [anon_sym_u8_DQUOTE] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [sym_true] = ACTIONS(1039),
    [sym_false] = ACTIONS(1039),
    [anon_sym_NULL] = ACTIONS(1042),
    [anon_sym_nullptr] = ACTIONS(1042),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_declaration] = STATE(66),
    [sym_type_definition] = STATE(66),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1519),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(66),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(66),
    [sym_labeled_statement] = STATE(66),
    [sym_expression_statement] = STATE(66),
    [sym_if_statement] = STATE(66),
    [sym_switch_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_do_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_return_statement] = STATE(66),
    [sym_break_statement] = STATE(66),
    [sym_continue_statement] = STATE(66),
    [sym_goto_statement] = STATE(66),
    [sym_seh_try_statement] = STATE(66),
    [sym_seh_leave_statement] = STATE(66),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(1193),
    [aux_sym_preproc_include_token1] = ACTIONS(923),
    [aux_sym_preproc_def_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token1] = ACTIONS(923),
    [aux_sym_preproc_if_token2] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(923),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(923),
    [sym_preproc_directive] = ACTIONS(923),
    [anon_sym_LPAREN2] = ACTIONS(925),
    [anon_sym_BANG] = ACTIONS(928),
    [anon_sym_TILDE] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(931),
    [anon_sym_PLUS] = ACTIONS(931),
    [anon_sym_STAR] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(934),
    [anon_sym_SEMI] = ACTIONS(1196),
    [anon_sym___extension__] = ACTIONS(1199),
    [anon_sym_typedef] = ACTIONS(1202),
    [anon_sym_extern] = ACTIONS(946),
    [anon_sym___attribute__] = ACTIONS(949),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(952),
    [anon_sym___declspec] = ACTIONS(955),
    [anon_sym___cdecl] = ACTIONS(923),
    [anon_sym___clrcall] = ACTIONS(923),
    [anon_sym___stdcall] = ACTIONS(923),
    [anon_sym___fastcall] = ACTIONS(923),
    [anon_sym___thiscall] = ACTIONS(923),
    [anon_sym___vectorcall] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(1205),
    [anon_sym_signed] = ACTIONS(961),
    [anon_sym_unsigned] = ACTIONS(961),
    [anon_sym_long] = ACTIONS(961),
    [anon_sym_short] = ACTIONS(961),
    [anon_sym_static] = ACTIONS(946),
    [anon_sym_auto] = ACTIONS(946),
    [anon_sym_register] = ACTIONS(946),
    [anon_sym_inline] = ACTIONS(946),
    [anon_sym___inline] = ACTIONS(946),
    [anon_sym___inline__] = ACTIONS(946),
    [anon_sym___forceinline] = ACTIONS(946),
    [anon_sym_thread_local] = ACTIONS(946),
    [anon_sym___thread] = ACTIONS(946),
    [anon_sym_const] = ACTIONS(964),
    [anon_sym_constexpr] = ACTIONS(964),
    [anon_sym_volatile] = ACTIONS(964),
    [anon_sym_restrict] = ACTIONS(964),
    [anon_sym___restrict__] = ACTIONS(964),
    [anon_sym__Atomic] = ACTIONS(964),
    [anon_sym__Noreturn] = ACTIONS(964),
    [anon_sym_noreturn] = ACTIONS(964),
    [sym_primitive_type] = ACTIONS(967),
    [anon_sym_enum] = ACTIONS(970),
    [anon_sym_struct] = ACTIONS(973),
    [anon_sym_union] = ACTIONS(976),
    [anon_sym_if] = ACTIONS(1208),
    [anon_sym_else] = ACTIONS(923),
    [anon_sym_switch] = ACTIONS(1211),
    [anon_sym_case] = ACTIONS(923),
    [anon_sym_default] = ACTIONS(923),
    [anon_sym_while] = ACTIONS(1214),
    [anon_sym_do] = ACTIONS(1217),
    [anon_sym_for] = ACTIONS(1220),
    [anon_sym_return] = ACTIONS(1223),
    [anon_sym_break] = ACTIONS(1226),
    [anon_sym_continue] = ACTIONS(1229),
    [anon_sym_goto] = ACTIONS(1232),
    [anon_sym___try] = ACTIONS(1235),
    [anon_sym___leave] = ACTIONS(1238),
    [anon_sym_DASH_DASH] = ACTIONS(1012),
    [anon_sym_PLUS_PLUS] = ACTIONS(1012),
    [anon_sym_sizeof] = ACTIONS(1015),
    [anon_sym___alignof__] = ACTIONS(1018),
    [anon_sym___alignof] = ACTIONS(1018),
    [anon_sym__alignof] = ACTIONS(1018),
    [anon_sym_alignof] = ACTIONS(1018),
    [anon_sym__Alignof] = ACTIONS(1018),
    [anon_sym_offsetof] = ACTIONS(1021),
    [anon_sym__Generic] = ACTIONS(1024),
    [anon_sym_asm] = ACTIONS(1027),
    [anon_sym___asm__] = ACTIONS(1027),
    [sym_number_literal] = ACTIONS(1030),
    [anon_sym_L_SQUOTE] = ACTIONS(1033),
    [anon_sym_u_SQUOTE] = ACTIONS(1033),
    [anon_sym_U_SQUOTE] = ACTIONS(1033),
    [anon_sym_u8_SQUOTE] = ACTIONS(1033),
    [anon_sym_SQUOTE] = ACTIONS(1033),
    [anon_sym_L_DQUOTE] = ACTIONS(1036),
    [anon_sym_u_DQUOTE] = ACTIONS(1036),
    [anon_sym_U_DQUOTE] = ACTIONS(1036),
    [anon_sym_u8_DQUOTE] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [sym_true] = ACTIONS(1039),
    [sym_false] = ACTIONS(1039),
    [anon_sym_NULL] = ACTIONS(1042),
    [anon_sym_nullptr] = ACTIONS(1042),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_declaration] = STATE(66),
    [sym_type_definition] = STATE(66),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1519),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(66),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(66),
    [sym_labeled_statement] = STATE(66),
    [sym_expression_statement] = STATE(66),
    [sym_if_statement] = STATE(66),
    [sym_switch_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_do_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_return_statement] = STATE(66),
    [sym_break_statement] = STATE(66),
    [sym_continue_statement] = STATE(66),
    [sym_goto_statement] = STATE(66),
    [sym_seh_try_statement] = STATE(66),
    [sym_seh_leave_statement] = STATE(66),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(1241),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token2] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym___extension__] = ACTIONS(545),
    [anon_sym_typedef] = ACTIONS(547),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(555),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(565),
    [anon_sym_return] = ACTIONS(567),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_goto] = ACTIONS(573),
    [anon_sym___try] = ACTIONS(575),
    [anon_sym___leave] = ACTIONS(577),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_declaration] = STATE(74),
    [sym_type_definition] = STATE(74),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1523),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(74),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(74),
    [sym_labeled_statement] = STATE(74),
    [sym_expression_statement] = STATE(74),
    [sym_if_statement] = STATE(74),
    [sym_switch_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_do_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_return_statement] = STATE(74),
    [sym_break_statement] = STATE(74),
    [sym_continue_statement] = STATE(74),
    [sym_goto_statement] = STATE(74),
    [sym_seh_try_statement] = STATE(74),
    [sym_seh_leave_statement] = STATE(74),
    [sym__expression] = STATE(1284),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2035),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(1243),
    [sym_identifier] = ACTIONS(1245),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1247),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1249),
    [anon_sym___leave] = ACTIONS(1251),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1514),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(1253),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1255),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_declaration] = STATE(65),
    [sym_type_definition] = STATE(65),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1523),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(65),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(65),
    [sym_labeled_statement] = STATE(65),
    [sym_expression_statement] = STATE(65),
    [sym_if_statement] = STATE(65),
    [sym_switch_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_do_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_return_statement] = STATE(65),
    [sym_break_statement] = STATE(65),
    [sym_continue_statement] = STATE(65),
    [sym_goto_statement] = STATE(65),
    [sym_seh_try_statement] = STATE(65),
    [sym_seh_leave_statement] = STATE(65),
    [sym__expression] = STATE(1284),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2035),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(1255),
    [sym_identifier] = ACTIONS(1245),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1247),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1249),
    [anon_sym___leave] = ACTIONS(1251),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_declaration] = STATE(66),
    [sym_type_definition] = STATE(66),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1519),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(66),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(66),
    [sym_labeled_statement] = STATE(66),
    [sym_expression_statement] = STATE(66),
    [sym_if_statement] = STATE(66),
    [sym_switch_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_do_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_return_statement] = STATE(66),
    [sym_break_statement] = STATE(66),
    [sym_continue_statement] = STATE(66),
    [sym_goto_statement] = STATE(66),
    [sym_seh_try_statement] = STATE(66),
    [sym_seh_leave_statement] = STATE(66),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(1241),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token2] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym___extension__] = ACTIONS(545),
    [anon_sym_typedef] = ACTIONS(547),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(555),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(565),
    [anon_sym_return] = ACTIONS(567),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_goto] = ACTIONS(573),
    [anon_sym___try] = ACTIONS(575),
    [anon_sym___leave] = ACTIONS(577),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1514),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(1253),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1257),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_declaration] = STATE(70),
    [sym_type_definition] = STATE(70),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1523),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(70),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(70),
    [sym_labeled_statement] = STATE(70),
    [sym_expression_statement] = STATE(70),
    [sym_if_statement] = STATE(70),
    [sym_switch_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_do_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_return_statement] = STATE(70),
    [sym_break_statement] = STATE(70),
    [sym_continue_statement] = STATE(70),
    [sym_goto_statement] = STATE(70),
    [sym_seh_try_statement] = STATE(70),
    [sym_seh_leave_statement] = STATE(70),
    [sym__expression] = STATE(1284),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2035),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(1259),
    [sym_identifier] = ACTIONS(1245),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1247),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1249),
    [anon_sym___leave] = ACTIONS(1251),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_declaration] = STATE(65),
    [sym_type_definition] = STATE(65),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1523),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(65),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(65),
    [sym_labeled_statement] = STATE(65),
    [sym_expression_statement] = STATE(65),
    [sym_if_statement] = STATE(65),
    [sym_switch_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_do_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_return_statement] = STATE(65),
    [sym_break_statement] = STATE(65),
    [sym_continue_statement] = STATE(65),
    [sym_goto_statement] = STATE(65),
    [sym_seh_try_statement] = STATE(65),
    [sym_seh_leave_statement] = STATE(65),
    [sym__expression] = STATE(1284),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2035),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(426),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(1257),
    [sym_identifier] = ACTIONS(1245),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1247),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1249),
    [anon_sym___leave] = ACTIONS(1251),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_declaration] = STATE(72),
    [sym_type_definition] = STATE(72),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1514),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(72),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(72),
    [sym_labeled_statement] = STATE(72),
    [sym_expression_statement] = STATE(72),
    [sym_if_statement] = STATE(72),
    [sym_switch_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_do_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_return_statement] = STATE(72),
    [sym_break_statement] = STATE(72),
    [sym_continue_statement] = STATE(72),
    [sym_goto_statement] = STATE(72),
    [sym_seh_try_statement] = STATE(72),
    [sym_seh_leave_statement] = STATE(72),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(1253),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1243),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1514),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(390),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(1253),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1259),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_declaration] = STATE(71),
    [sym_type_definition] = STATE(71),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1519),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(71),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(71),
    [sym_labeled_statement] = STATE(71),
    [sym_expression_statement] = STATE(71),
    [sym_if_statement] = STATE(71),
    [sym_switch_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_do_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_return_statement] = STATE(71),
    [sym_break_statement] = STATE(71),
    [sym_continue_statement] = STATE(71),
    [sym_goto_statement] = STATE(71),
    [sym_seh_try_statement] = STATE(71),
    [sym_seh_leave_statement] = STATE(71),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(1241),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token2] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym___extension__] = ACTIONS(545),
    [anon_sym_typedef] = ACTIONS(547),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(555),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(565),
    [anon_sym_return] = ACTIONS(567),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_goto] = ACTIONS(573),
    [anon_sym___try] = ACTIONS(575),
    [anon_sym___leave] = ACTIONS(577),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_declaration] = STATE(67),
    [sym_type_definition] = STATE(67),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1519),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(67),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(67),
    [sym_labeled_statement] = STATE(67),
    [sym_expression_statement] = STATE(67),
    [sym_if_statement] = STATE(67),
    [sym_switch_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_do_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_return_statement] = STATE(67),
    [sym_break_statement] = STATE(67),
    [sym_continue_statement] = STATE(67),
    [sym_goto_statement] = STATE(67),
    [sym_seh_try_statement] = STATE(67),
    [sym_seh_leave_statement] = STATE(67),
    [sym__expression] = STATE(1268),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2092),
    [sym_conditional_expression] = STATE(843),
    [sym_assignment_expression] = STATE(843),
    [sym_pointer_expression] = STATE(947),
    [sym_unary_expression] = STATE(843),
    [sym_binary_expression] = STATE(843),
    [sym_update_expression] = STATE(843),
    [sym_cast_expression] = STATE(843),
    [sym_sizeof_expression] = STATE(843),
    [sym_alignof_expression] = STATE(843),
    [sym_offsetof_expression] = STATE(843),
    [sym_generic_expression] = STATE(843),
    [sym_subscript_expression] = STATE(947),
    [sym_call_expression] = STATE(947),
    [sym_gnu_asm_expression] = STATE(843),
    [sym_field_expression] = STATE(947),
    [sym_compound_literal_expression] = STATE(843),
    [sym_parenthesized_expression] = STATE(947),
    [sym_char_literal] = STATE(843),
    [sym_concatenated_string] = STATE(843),
    [sym_string_literal] = STATE(816),
    [sym_null] = STATE(843),
    [sym_macro_type_specifier] = STATE(1137),
    [aux_sym__declaration_specifiers_repeat1] = STATE(893),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1118),
    [aux_sym_case_statement_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(1241),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token2] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym___extension__] = ACTIONS(545),
    [anon_sym_typedef] = ACTIONS(547),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(555),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(565),
    [anon_sym_return] = ACTIONS(567),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_goto] = ACTIONS(573),
    [anon_sym___try] = ACTIONS(575),
    [anon_sym___leave] = ACTIONS(577),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_declaration] = STATE(81),
    [sym_type_definition] = STATE(81),
    [sym__declaration_modifiers] = STATE(893),
    [sym__declaration_specifiers] = STATE(1523),
    [sym_attribute_specifier] = STATE(893),
    [sym_attribute_declaration] = STATE(530),
    [sym_ms_declspec_modifier] = STATE(893),
    [sym_compound_statement] = STATE(81),
    [sym_storage_class_specifier] = STATE(893),
    [sym_type_qualifier] = STATE(893),
    [sym__type_specifier] = STATE(1073),
    [sym_sized_type_specifier] = STATE(1137),
    [sym_enum_specifier] = STATE(1137),
    [sym_struct_specifier] = STATE(1137),
    [sym_union_specifier] = STATE(1137),
    [sym_attributed_statement] = STATE(81),
    [sym_labeled_statement] = STATE(81),
    [sym_expression_statement] = STATE(81),
    [sym_if_statement] = STATE(81),
    [sym_switch_statement] = STATE(81),
    [sym_while_statement] = STATE(81),
    [sym_do_statement] = STATE(81),
    [sym_for_statement] = STATE(81),
    [sym_return_statement] = STATE(81),
    [sym_break_statement] = STATE(81),
    [sym_continue_statement] = STATE(81),
    [sym_goto_statement] = STATE(81),
    [sym_seh_try_statement] = STATE(81),
    [sym_seh_leave_statement] = STATE(81),
    [sym__expression] = STATE(1243),
    [sym__expression_not_binary] = STATE(843),
    [sym__string] = STATE(843),
    [sym_comma_expression] = STATE(2110),
    [sym_conditional_expression] = STATE(843),
    [sym_assi