#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2214
#define LARGE_STATE_COUNT 555
#define SYMBOL_COUNT 342
#define ALIAS_COUNT 3
#define TOKEN_COUNT 155
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 125

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym___extension__ = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym_COLON_COLON = 47,
  anon_sym_LBRACK_LBRACK = 48,
  anon_sym_RBRACK_RBRACK = 49,
  anon_sym___declspec = 50,
  anon_sym___based = 51,
  anon_sym___cdecl = 52,
  anon_sym___clrcall = 53,
  anon_sym___stdcall = 54,
  anon_sym___fastcall = 55,
  anon_sym___thiscall = 56,
  anon_sym___vectorcall = 57,
  sym_ms_restrict_modifier = 58,
  sym_ms_unsigned_ptr_modifier = 59,
  sym_ms_signed_ptr_modifier = 60,
  anon_sym__unaligned = 61,
  anon_sym___unaligned = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_signed = 65,
  anon_sym_unsigned = 66,
  anon_sym_long = 67,
  anon_sym_short = 68,
  anon_sym_LBRACK = 69,
  anon_sym_RBRACK = 70,
  anon_sym_EQ = 71,
  anon_sym_static = 72,
  anon_sym_auto = 73,
  anon_sym_register = 74,
  anon_sym_inline = 75,
  anon_sym___inline = 76,
  anon_sym___inline__ = 77,
  anon_sym___forceinline = 78,
  anon_sym_thread_local = 79,
  anon_sym___thread = 80,
  anon_sym_const = 81,
  anon_sym_constexpr = 82,
  anon_sym_volatile = 83,
  anon_sym_restrict = 84,
  anon_sym___restrict__ = 85,
  anon_sym__Atomic = 86,
  anon_sym__Noreturn = 87,
  anon_sym_noreturn = 88,
  sym_primitive_type = 89,
  anon_sym_enum = 90,
  anon_sym_COLON = 91,
  anon_sym_struct = 92,
  anon_sym_union = 93,
  anon_sym_if = 94,
  anon_sym_else = 95,
  anon_sym_switch = 96,
  anon_sym_case = 97,
  anon_sym_default = 98,
  anon_sym_while = 99,
  anon_sym_do = 100,
  anon_sym_for = 101,
  anon_sym_return = 102,
  anon_sym_break = 103,
  anon_sym_continue = 104,
  anon_sym_goto = 105,
  anon_sym___try = 106,
  anon_sym___except = 107,
  anon_sym___finally = 108,
  anon_sym___leave = 109,
  anon_sym_QMARK = 110,
  anon_sym_STAR_EQ = 111,
  anon_sym_SLASH_EQ = 112,
  anon_sym_PERCENT_EQ = 113,
  anon_sym_PLUS_EQ = 114,
  anon_sym_DASH_EQ = 115,
  anon_sym_LT_LT_EQ = 116,
  anon_sym_GT_GT_EQ = 117,
  anon_sym_AMP_EQ = 118,
  anon_sym_CARET_EQ = 119,
  anon_sym_PIPE_EQ = 120,
  anon_sym_DASH_DASH = 121,
  anon_sym_PLUS_PLUS = 122,
  anon_sym_sizeof = 123,
  anon_sym___alignof__ = 124,
  anon_sym___alignof = 125,
  anon_sym__alignof = 126,
  anon_sym_alignof = 127,
  anon_sym__Alignof = 128,
  anon_sym_offsetof = 129,
  anon_sym__Generic = 130,
  anon_sym_asm = 131,
  anon_sym___asm__ = 132,
  anon_sym_DOT = 133,
  anon_sym_DASH_GT = 134,
  sym_number_literal = 135,
  anon_sym_L_SQUOTE = 136,
  anon_sym_u_SQUOTE = 137,
  anon_sym_U_SQUOTE = 138,
  anon_sym_u8_SQUOTE = 139,
  anon_sym_SQUOTE = 140,
  aux_sym_char_literal_token1 = 141,
  anon_sym_L_DQUOTE = 142,
  anon_sym_u_DQUOTE = 143,
  anon_sym_U_DQUOTE = 144,
  anon_sym_u8_DQUOTE = 145,
  anon_sym_DQUOTE = 146,
  aux_sym_string_literal_token1 = 147,
  sym_escape_sequence = 148,
  sym_system_lib_string = 149,
  sym_true = 150,
  sym_false = 151,
  anon_sym_NULL = 152,
  anon_sym_nullptr = 153,
  sym_comment = 154,
  sym_translation_unit = 155,
  sym_preproc_include = 156,
  sym_preproc_def = 157,
  sym_preproc_function_def = 158,
  sym_preproc_params = 159,
  sym_preproc_call = 160,
  sym_preproc_if = 161,
  sym_preproc_ifdef = 162,
  sym_preproc_else = 163,
  sym_preproc_elif = 164,
  sym_preproc_elifdef = 165,
  sym_preproc_if_in_field_declaration_list = 166,
  sym_preproc_ifdef_in_field_declaration_list = 167,
  sym_preproc_else_in_field_declaration_list = 168,
  sym_preproc_elif_in_field_declaration_list = 169,
  sym_preproc_if_in_enumerator_list = 170,
  sym_preproc_ifdef_in_enumerator_list = 171,
  sym_preproc_else_in_enumerator_list = 172,
  sym_preproc_elif_in_enumerator_list = 173,
  sym_preproc_if_in_enumerator_list_no_comma = 174,
  sym_preproc_ifdef_in_enumerator_list_no_comma = 175,
  sym_preproc_else_in_enumerator_list_no_comma = 176,
  sym_preproc_elif_in_enumerator_list_no_comma = 177,
  sym__preproc_expression = 178,
  sym_preproc_parenthesized_expression = 179,
  sym_preproc_defined = 180,
  sym_preproc_unary_expression = 181,
  sym_preproc_call_expression = 182,
  sym_preproc_argument_list = 183,
  sym_preproc_binary_expression = 184,
  sym_function_definition = 185,
  sym__old_style_function_definition = 186,
  sym_declaration = 187,
  sym__declaration_declarator = 188,
  sym_type_definition = 189,
  sym__type_definition_type = 190,
  sym__type_definition_declarators = 191,
  sym__declaration_modifiers = 192,
  sym__declaration_specifiers = 193,
  sym_linkage_specification = 194,
  sym_attribute_specifier = 195,
  sym_attribute = 196,
  sym_attribute_declaration = 197,
  sym_ms_declspec_modifier = 198,
  sym_ms_based_modifier = 199,
  sym_ms_call_modifier = 200,
  sym_ms_unaligned_ptr_modifier = 201,
  sym_ms_pointer_modifier = 202,
  sym_declaration_list = 203,
  sym__declarator = 204,
  sym__field_declarator = 205,
  sym__type_declarator = 206,
  sym__abstract_declarator = 207,
  sym_parenthesized_declarator = 208,
  sym_parenthesized_field_declarator = 209,
  sym_parenthesized_type_declarator = 210,
  sym_abstract_parenthesized_declarator = 211,
  sym_attributed_declarator = 212,
  sym_attributed_field_declarator = 213,
  sym_attributed_type_declarator = 214,
  sym_pointer_declarator = 215,
  sym_pointer_field_declarator = 216,
  sym_pointer_type_declarator = 217,
  sym_abstract_pointer_declarator = 218,
  sym_function_declarator = 219,
  sym_function_field_declarator = 220,
  sym_function_type_declarator = 221,
  sym_abstract_function_declarator = 222,
  sym__old_style_function_declarator = 223,
  sym_array_declarator = 224,
  sym_array_field_declarator = 225,
  sym_array_type_declarator = 226,
  sym_abstract_array_declarator = 227,
  sym_init_declarator = 228,
  sym_compound_statement = 229,
  sym_storage_class_specifier = 230,
  sym_type_qualifier = 231,
  sym__type_specifier = 232,
  sym_sized_type_specifier = 233,
  sym_enum_specifier = 234,
  sym_enumerator_list = 235,
  sym_struct_specifier = 236,
  sym_union_specifier = 237,
  sym_field_declaration_list = 238,
  sym__field_declaration_list_item = 239,
  sym_field_declaration = 240,
  sym__field_declaration_declarator = 241,
  sym_bitfield_clause = 242,
  sym_enumerator = 243,
  sym_variadic_parameter = 244,
  sym_parameter_list = 245,
  sym__old_style_parameter_list = 246,
  sym_parameter_declaration = 247,
  sym_attributed_statement = 248,
  sym_labeled_statement = 249,
  sym__top_level_expression_statement = 250,
  sym_expression_statement = 251,
  sym_if_statement = 252,
  sym_else_clause = 253,
  sym_switch_statement = 254,
  sym_case_statement = 255,
  sym_while_statement = 256,
  sym_do_statement = 257,
  sym_for_statement = 258,
  sym__for_statement_body = 259,
  sym_return_statement = 260,
  sym_break_statement = 261,
  sym_continue_statement = 262,
  sym_goto_statement = 263,
  sym_seh_try_statement = 264,
  sym_seh_except_clause = 265,
  sym_seh_finally_clause = 266,
  sym_seh_leave_statement = 267,
  sym__expression = 268,
  sym__expression_not_binary = 269,
  sym_comma_expression = 270,
  sym_conditional_expression = 271,
  sym_assignment_expression = 272,
  sym_pointer_expression = 273,
  sym_unary_expression = 274,
  sym_binary_expression = 275,
  sym_update_expression = 276,
  sym_cast_expression = 277,
  sym_type_descriptor = 278,
  sym_sizeof_expression = 279,
  sym_alignof_expression = 280,
  sym_offsetof_expression = 281,
  sym_generic_expression = 282,
  sym_subscript_expression = 283,
  sym_call_expression = 284,
  sym_gnu_asm_expression = 285,
  sym_gnu_asm_qualifier = 286,
  sym_gnu_asm_output_operand_list = 287,
  sym_gnu_asm_output_operand = 288,
  sym_gnu_asm_input_operand_list = 289,
  sym_gnu_asm_input_operand = 290,
  sym_gnu_asm_clobber_list = 291,
  sym_gnu_asm_goto_list = 292,
  sym_argument_list = 293,
  sym_field_expression = 294,
  sym_compound_literal_expression = 295,
  sym_parenthesized_expression = 296,
  sym_initializer_list = 297,
  sym_initializer_pair = 298,
  sym_subscript_designator = 299,
  sym_subscript_range_designator = 300,
  sym_field_designator = 301,
  sym_char_literal = 302,
  sym_concatenated_string = 303,
  sym_string_literal = 304,
  sym_null = 305,
  sym__empty_declaration = 306,
  sym_macro_type_specifier = 307,
  aux_sym_translation_unit_repeat1 = 308,
  aux_sym_preproc_params_repeat1 = 309,
  aux_sym_preproc_if_repeat1 = 310,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 311,
  aux_sym_preproc_if_in_enumerator_list_repeat1 = 312,
  aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1 = 313,
  aux_sym_preproc_argument_list_repeat1 = 314,
  aux_sym__old_style_function_definition_repeat1 = 315,
  aux_sym__declaration_declarator_repeat1 = 316,
  aux_sym_type_definition_repeat1 = 317,
  aux_sym__type_definition_type_repeat1 = 318,
  aux_sym__type_definition_declarators_repeat1 = 319,
  aux_sym__declaration_specifiers_repeat1 = 320,
  aux_sym_attribute_declaration_repeat1 = 321,
  aux_sym_attributed_declarator_repeat1 = 322,
  aux_sym_pointer_declarator_repeat1 = 323,
  aux_sym_sized_type_specifier_repeat1 = 324,
  aux_sym_enumerator_list_repeat1 = 325,
  aux_sym__field_declaration_declarator_repeat1 = 326,
  aux_sym_parameter_list_repeat1 = 327,
  aux_sym__old_style_parameter_list_repeat1 = 328,
  aux_sym_case_statement_repeat1 = 329,
  aux_sym_generic_expression_repeat1 = 330,
  aux_sym_gnu_asm_expression_repeat1 = 331,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 332,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 333,
  aux_sym_gnu_asm_clobber_list_repeat1 = 334,
  aux_sym_gnu_asm_goto_list_repeat1 = 335,
  aux_sym_argument_list_repeat1 = 336,
  aux_sym_initializer_list_repeat1 = 337,
  aux_sym_initializer_pair_repeat1 = 338,
  aux_sym_char_literal_repeat1 = 339,
  aux_sym_concatenated_string_repeat1 = 340,
  aux_sym_string_literal_repeat1 = 341,
  alias_sym_field_identifier = 342,
  alias_sym_statement_identifier = 343,
  alias_sym_type_identifier = 344,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym___extension__] = "__extension__",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_static] = "static",
  [anon_sym_auto] = "auto",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym___inline] = "__inline",
  [anon_sym___inline__] = "__inline__",
  [anon_sym___forceinline] = "__forceinline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym___thread] = "__thread",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_COLON] = ":",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym___try] = "__try",
  [anon_sym___except] = "__except",
  [anon_sym___finally] = "__finally",
  [anon_sym___leave] = "__leave",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym___alignof__] = "__alignof__",
  [anon_sym___alignof] = "__alignof",
  [anon_sym__alignof] = "_alignof",
  [anon_sym_alignof] = "alignof",
  [anon_sym__Alignof] = "_Alignof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_translation_unit] = "translation_unit",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym_preproc_if_in_enumerator_list] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list] = "preproc_elif",
  [sym_preproc_if_in_enumerator_list_no_comma] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list_no_comma] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list_no_comma] = "preproc_elif",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym__old_style_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym__declaration_declarator] = "_declaration_declarator",
  [sym_type_definition] = "type_definition",
  [sym__type_definition_type] = "_type_definition_type",
  [sym__type_definition_declarators] = "_type_definition_declarators",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym__old_style_function_declarator] = "function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym__type_specifier] = "_type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym__field_declaration_declarator] = "_field_declaration_declarator",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_parameter_list] = "parameter_list",
  [sym__old_style_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_body] = "_for_statement_body",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_seh_try_statement] = "seh_try_statement",
  [sym_seh_except_clause] = "seh_except_clause",
  [sym_seh_finally_clause] = "seh_finally_clause",
  [sym_seh_leave_statement] = "seh_leave_statement",
  [sym__expression] = "_expression",
  [sym__expression_not_binary] = "_expression_not_binary",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_alignof_expression] = "alignof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_subscript_range_designator] = "subscript_range_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_macro_type_specifier] = "macro_type_specifier",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = "preproc_if_in_enumerator_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = "preproc_if_in_enumerator_list_no_comma_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym__old_style_function_definition_repeat1] = "_old_style_function_definition_repeat1",
  [aux_sym__declaration_declarator_repeat1] = "_declaration_declarator_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__type_definition_type_repeat1] = "_type_definition_type_repeat1",
  [aux_sym__type_definition_declarators_repeat1] = "_type_definition_declarators_repeat1",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym__field_declaration_declarator_repeat1] = "_field_declaration_declarator_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym__old_style_parameter_list_repeat1] = "_old_style_parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_char_literal_repeat1] = "char_literal_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym___extension__] = anon_sym___extension__,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_auto] = anon_sym_auto,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym___inline] = anon_sym___inline,
  [anon_sym___inline__] = anon_sym___inline__,
  [anon_sym___forceinline] = anon_sym___forceinline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym___thread] = anon_sym___thread,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym___try] = anon_sym___try,
  [anon_sym___except] = anon_sym___except,
  [anon_sym___finally] = anon_sym___finally,
  [anon_sym___leave] = anon_sym___leave,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym___alignof__] = anon_sym___alignof__,
  [anon_sym___alignof] = anon_sym___alignof,
  [anon_sym__alignof] = anon_sym__alignof,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym__Alignof] = anon_sym__Alignof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym_preproc_if_in_enumerator_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list] = sym_preproc_elif,
  [sym_preproc_if_in_enumerator_list_no_comma] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list_no_comma] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list_no_comma] = sym_preproc_elif,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym__old_style_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym__declaration_declarator] = sym__declaration_declarator,
  [sym_type_definition] = sym_type_definition,
  [sym__type_definition_type] = sym__type_definition_type,
  [sym__type_definition_declarators] = sym__type_definition_declarators,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym__old_style_function_declarator] = sym_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym__type_specifier] = sym__type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym__field_declaration_declarator] = sym__field_declaration_declarator,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym__old_style_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_body] = sym__for_statement_body,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_seh_try_statement] = sym_seh_try_statement,
  [sym_seh_except_clause] = sym_seh_except_clause,
  [sym_seh_finally_clause] = sym_seh_finally_clause,
  [sym_seh_leave_statement] = sym_seh_leave_statement,
  [sym__expression] = sym__expression,
  [sym__expression_not_binary] = sym__expression_not_binary,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_subscript_range_designator] = sym_subscript_range_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_macro_type_specifier] = sym_macro_type_specifier,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = aux_sym_preproc_if_in_enumerator_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym__old_style_function_definition_repeat1] = aux_sym__old_style_function_definition_repeat1,
  [aux_sym__declaration_declarator_repeat1] = aux_sym__declaration_declarator_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__type_definition_type_repeat1] = aux_sym__type_definition_type_repeat1,
  [aux_sym__type_definition_declarators_repeat1] = aux_sym__type_definition_declarators_repeat1,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym__field_declaration_declarator_repeat1] = aux_sym__field_declaration_declarator_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym__old_style_parameter_list_repeat1] = aux_sym__old_style_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_char_literal_repeat1] = aux_sym_char_literal_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___extension__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_auto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___leave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_definition_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_definition_declarators] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_body] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__expression_not_binary] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_range_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_macro_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_declaration_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_char_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_body = 5,
  field_clobbers = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_declarator = 10,
  field_designator = 11,
  field_directive = 12,
  field_end = 13,
  field_field = 14,
  field_filter = 15,
  field_function = 16,
  field_goto_labels = 17,
  field_index = 18,
  field_initializer = 19,
  field_input_operands = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_operand = 25,
  field_operator = 26,
  field_output_operands = 27,
  field_parameters = 28,
  field_path = 29,
  field_prefix = 30,
  field_register = 31,
  field_right = 32,
  field_size = 33,
  field_start = 34,
  field_symbol = 35,
  field_type = 36,
  field_underlying_type = 37,
  field_update = 38,
  field_value = 39,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_body] = "body",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_end] = "end",
  [field_field] = "field",
  [field_filter] = "filter",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_right] = "right",
  [field_size] = "size",
  [field_start] = "start",
  [field_symbol] = "symbol",
  [field_type] = "type",
  [field_underlying_type] = "underlying_type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 3, .length = 1},
  [11] = {.index = 11, .length = 1},
  [12] = {.index = 12, .length = 2},
  [13] = {.index = 14, .length = 2},
  [14] = {.index = 16, .length = 1},
  [15] = {.index = 16, .length = 1},
  [16] = {.index = 17, .length = 1},
  [17] = {.index = 8, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 1},
  [22] = {.index = 23, .length = 2},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 1},
  [25] = {.index = 28, .length = 1},
  [26] = {.index = 29, .length = 2},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 1},
  [29] = {.index = 34, .length = 3},
  [30] = {.index = 37, .length = 1},
  [31] = {.index = 38, .length = 1},
  [32] = {.index = 39, .length = 2},
  [33] = {.index = 41, .length = 3},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 2},
  [36] = {.index = 48, .length = 2},
  [37] = {.index = 50, .length = 5},
  [38] = {.index = 55, .length = 3},
  [39] = {.index = 58, .length = 2},
  [40] = {.index = 60, .length = 2},
  [41] = {.index = 62, .length = 1},
  [42] = {.index = 63, .length = 2},
  [43] = {.index = 65, .length = 1},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 2},
  [46] = {.index = 70, .length = 2},
  [47] = {.index = 72, .length = 2},
  [48] = {.index = 74, .length = 2},
  [49] = {.index = 76, .length = 2},
  [50] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 1},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 3},
  [56] = {.index = 87, .length = 1},
  [57] = {.index = 88, .length = 1},
  [58] = {.index = 89, .length = 1},
  [59] = {.index = 90, .length = 2},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 2},
  [62] = {.index = 95, .length = 3},
  [63] = {.index = 98, .length = 2},
  [64] = {.index = 100, .length = 5},
  [65] = {.index = 105, .length = 3},
  [66] = {.index = 108, .length = 5},
  [67] = {.index = 113, .length = 2},
  [68] = {.index = 115, .length = 2},
  [69] = {.index = 117, .length = 3},
  [70] = {.index = 120, .length = 2},
  [71] = {.index = 122, .length = 2},
  [72] = {.index = 124, .length = 2},
  [73] = {.index = 126, .length = 1},
  [74] = {.index = 127, .length = 2},
  [75] = {.index = 129, .length = 2},
  [76] = {.index = 131, .length = 2},
  [77] = {.index = 133, .length = 3},
  [78] = {.index = 136, .length = 2},
  [79] = {.index = 138, .length = 2},
  [80] = {.index = 140, .length = 1},
  [81] = {.index = 141, .length = 2},
  [82] = {.index = 143, .length = 2},
  [83] = {.index = 145, .length = 4},
  [84] = {.index = 149, .length = 1},
  [85] = {.index = 150, .length = 2},
  [86] = {.index = 152, .length = 1},
  [87] = {.index = 153, .length = 1},
  [88] = {.index = 154, .length = 2},
  [89] = {.index = 156, .length = 2},
  [90] = {.index = 158, .length = 5},
  [91] = {.index = 163, .length = 3},
  [92] = {.index = 166, .length = 2},
  [93] = {.index = 168, .length = 1},
  [95] = {.index = 169, .length = 2},
  [96] = {.index = 171, .length = 2},
  [97] = {.index = 173, .length = 2},
  [98] = {.index = 175, .length = 3},
  [99] = {.index = 178, .length = 2},
  [100] = {.index = 180, .length = 2},
  [101] = {.index = 182, .length = 2},
  [102] = {.index = 184, .length = 2},
  [103] = {.index = 186, .length = 3},
  [104] = {.index = 189, .length = 2},
  [105] = {.index = 191, .length = 1},
  [106] = {.index = 192, .length = 2},
  [107] = {.index = 194, .length = 2},
  [108] = {.index = 194, .length = 2},
  [109] = {.index = 196, .length = 3},
  [110] = {.index = 199, .length = 2},
  [111] = {.index = 201, .length = 1},
  [112] = {.index = 202, .length = 4},
  [113] = {.index = 206, .length = 3},
  [114] = {.index = 209, .length = 2},
  [115] = {.index = 211, .length = 2},
  [116] = {.index = 33, .length = 1},
  [117] = {.index = 213, .length = 5},
  [118] = {.index = 218, .length = 4},
  [119] = {.index = 222, .length = 2},
  [120] = {.index = 224, .length = 2},
  [121] = {.index = 226, .length = 2},
  [122] = {.index = 228, .length = 5},
  [123] = {.index = 233, .length = 2},
  [124] = {.index = 235, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 0, .inherited = true},
    {field_declarator, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [3] =
    {field_type, 0},
  [4] =
    {field_directive, 0},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_name, 1},
  [9] =
    {field_body, 1},
  [10] =
    {field_value, 1},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_argument, 0},
    {field_operator, 1},
  [14] =
    {field_arguments, 1},
    {field_function, 0},
  [16] =
    {field_type, 1},
  [17] =
    {field_path, 1},
  [18] =
    {field_argument, 1},
    {field_directive, 0},
  [20] =
    {field_declarator, 1},
    {field_type, 0},
  [22] =
    {field_parameters, 0},
  [23] =
    {field_body, 2},
    {field_value, 1},
  [25] =
    {field_body, 2},
    {field_name, 1},
  [27] =
    {field_name, 2},
  [28] =
    {field_body, 2},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_body, 2},
    {field_condition, 1},
  [33] =
    {field_label, 1},
  [34] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [37] =
    {field_label, 0},
  [38] =
    {field_declarator, 1},
  [39] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [41] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [44] =
    {field_declarator, 0},
    {field_parameters, 1},
  [46] =
    {field_declarator, 0},
    {field_declarator, 1},
  [48] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [50] =
    {field_body, 2},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [55] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [58] =
    {field_name, 1},
    {field_value, 2},
  [60] =
    {field_name, 1},
    {field_parameters, 2},
  [62] =
    {field_condition, 1},
  [63] =
    {field_alternative, 2},
    {field_name, 1},
  [65] =
    {field_type, 0, .inherited = true},
  [66] =
    {field_declarator, 2},
    {field_type, 0},
  [68] =
    {field_left, 0},
    {field_right, 2},
  [70] =
    {field_type, 1},
    {field_value, 3},
  [72] =
    {field_declarator, 2},
    {field_type, 1},
  [74] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [76] =
    {field_name, 2},
    {field_prefix, 0},
  [78] =
    {field_name, 1},
    {field_underlying_type, 3},
  [80] =
    {field_body, 3},
    {field_name, 2},
  [82] =
    {field_name, 3},
  [83] =
    {field_body, 3},
  [84] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [87] =
    {field_initializer, 0},
  [88] =
    {field_type, 2},
  [89] =
    {field_assembly_code, 2},
  [90] =
    {field_name, 0},
    {field_type, 2},
  [92] =
    {field_declarator, 2},
  [93] =
    {field_declarator, 0},
    {field_value, 2},
  [95] =
    {field_declarator, 0},
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
  [98] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [100] =
    {field_body, 3},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [105] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [108] =
    {field_body, 3},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [113] =
    {field_argument, 0},
    {field_index, 2},
  [115] =
    {field_alternative, 3},
    {field_condition, 0},
  [117] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [120] =
    {field_alternative, 3},
    {field_condition, 1},
  [122] =
    {field_alternative, 3},
    {field_name, 1},
  [124] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [126] =
    {field_size, 1},
  [127] =
    {field_declarator, 3},
    {field_type, 1},
  [129] =
    {field_declarator, 3, .inherited = true},
    {field_type, 2, .inherited = true},
  [131] =
    {field_name, 0},
    {field_value, 2},
  [133] =
    {field_body, 4},
    {field_name, 1},
    {field_underlying_type, 3},
  [136] =
    {field_body, 4},
    {field_name, 3},
  [138] =
    {field_body, 1},
    {field_condition, 3},
  [140] =
    {field_update, 2},
  [141] =
    {field_initializer, 0},
    {field_update, 2},
  [143] =
    {field_condition, 1},
    {field_initializer, 0},
  [145] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [149] =
    {field_operand, 1},
  [150] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [152] =
    {field_assembly_code, 3},
  [153] =
    {field_declarator, 3},
  [154] =
    {field_declarator, 1},
    {field_declarator, 2},
  [156] =
    {field_declarator, 0},
    {field_size, 2},
  [158] =
    {field_body, 4},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [163] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [166] =
    {field_alternative, 4},
    {field_condition, 1},
  [168] =
    {field_size, 2},
  [169] =
    {field_body, 2},
    {field_filter, 1},
  [171] =
    {field_declarator, 0},
    {field_declarator, 2, .inherited = true},
  [173] =
    {field_condition, 1},
    {field_update, 3},
  [175] =
    {field_condition, 1},
    {field_initializer, 0},
    {field_update, 3},
  [178] =
    {field_initializer, 0},
    {field_update, 3},
  [180] =
    {field_condition, 2},
    {field_initializer, 0},
  [182] =
    {field_member, 4},
    {field_type, 2},
  [184] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [186] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [189] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [191] =
    {field_declarator, 4},
  [192] =
    {field_declarator, 0},
    {field_size, 3},
  [194] =
    {field_designator, 0},
    {field_value, 2},
  [196] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [199] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [201] =
    {field_register, 1},
  [202] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [206] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [209] =
    {field_constraint, 0},
    {field_value, 2},
  [211] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [213] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [218] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [222] =
    {field_end, 3},
    {field_start, 1},
  [224] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [226] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [228] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [233] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [235] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [7] = {
    [1] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [0] = sym_primitive_type,
  },
  [23] = {
    [1] = alias_sym_type_identifier,
  },
  [24] = {
    [2] = alias_sym_type_identifier,
  },
  [28] = {
    [1] = alias_sym_statement_identifier,
  },
  [30] = {
    [0] = alias_sym_statement_identifier,
  },
  [38] = {
    [2] = alias_sym_field_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [0] = alias_sym_field_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [53] = {
    [3] = alias_sym_type_identifier,
  },
  [77] = {
    [1] = alias_sym_type_identifier,
  },
  [78] = {
    [3] = alias_sym_type_identifier,
  },
  [94] = {
    [1] = alias_sym_field_identifier,
  },
  [101] = {
    [4] = alias_sym_field_identifier,
  },
  [107] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 2,
  [6] = 2,
  [7] = 4,
  [8] = 4,
  [9] = 2,
  [10] = 4,
  [11] = 4,
  [12] = 12,
  [13] = 12,
  [14] = 14,
  [15] = 14,
  [16] = 16,
  [17] = 14,
  [18] = 14,
  [19] = 19,
  [20] = 12,
  [21] = 21,
  [22] = 12,
  [23] = 23,
  [24] = 12,
  [25] = 14,
  [26] = 26,
  [27] = 26,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 28,
  [32] = 26,
  [33] = 29,
  [34] = 29,
  [35] = 30,
  [36] = 28,
  [37] = 28,
  [38] = 29,
  [39] = 30,
  [40] = 30,
  [41] = 41,
  [42] = 29,
  [43] = 28,
  [44] = 41,
  [45] = 26,
  [46] = 41,
  [47] = 47,
  [48] = 30,
  [49] = 49,
  [50] = 41,
  [51] = 41,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 58,
  [60] = 57,
  [61] = 56,
  [62] = 54,
  [63] = 55,
  [64] = 56,
  [65] = 57,
  [66] = 55,
  [67] = 57,
  [68] = 58,
  [69] = 54,
  [70] = 55,
  [71] = 58,
  [72] = 55,
  [73] = 56,
  [74] = 54,
  [75] = 57,
  [76] = 56,
  [77] = 54,
  [78] = 58,
  [79] = 55,
  [80] = 54,
  [81] = 56,
  [82] = 58,
  [83] = 57,
  [84] = 84,
  [85] = 84,
  [86] = 84,
  [87] = 84,
  [88] = 84,
  [89] = 84,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 93,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 107,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 90,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 117,
  [162] = 97,
  [163] = 105,
  [164] = 132,
  [165] = 101,
  [166] = 104,
  [167] = 130,
  [168] = 128,
  [169] = 108,
  [170] = 116,
  [171] = 92,
  [172] = 93,
  [173] = 103,
  [174] = 122,
  [175] = 114,
  [176] = 113,
  [177] = 112,
  [178] = 94,
  [179] = 129,
  [180] = 91,
  [181] = 100,
  [182] = 106,
  [183] = 123,
  [184] = 99,
  [185] = 131,
  [186] = 118,
  [187] = 120,
  [188] = 111,
  [189] = 133,
  [190] = 95,
  [191] = 121,
  [192] = 119,
  [193] = 127,
  [194] = 96,
  [195] = 109,
  [196] = 98,
  [197] = 102,
  [198] = 107,
  [199] = 125,
  [200] = 110,
  [201] = 126,
  [202] = 159,
  [203] = 147,
  [204] = 139,
  [205] = 143,
  [206] = 154,
  [207] = 151,
  [208] = 138,
  [209] = 160,
  [210] = 134,
  [211] = 90,
  [212] = 136,
  [213] = 155,
  [214] = 157,
  [215] = 90,
  [216] = 153,
  [217] = 149,
  [218] = 137,
  [219] = 158,
  [220] = 140,
  [221] = 150,
  [222] = 141,
  [223] = 142,
  [224] = 144,
  [225] = 152,
  [226] = 148,
  [227] = 145,
  [228] = 146,
  [229] = 90,
  [230] = 156,
  [231] = 131,
  [232] = 95,
  [233] = 132,
  [234] = 128,
  [235] = 123,
  [236] = 119,
  [237] = 108,
  [238] = 110,
  [239] = 109,
  [240] = 240,
  [241] = 106,
  [242] = 105,
  [243] = 104,
  [244] = 103,
  [245] = 116,
  [246] = 92,
  [247] = 133,
  [248] = 91,
  [249] = 111,
  [250] = 122,
  [251] = 130,
  [252] = 94,
  [253] = 95,
  [254] = 112,
  [255] = 113,
  [256] = 129,
  [257] = 101,
  [258] = 114,
  [259] = 102,
  [260] = 93,
  [261] = 92,
  [262] = 127,
  [263] = 116,
  [264] = 96,
  [265] = 97,
  [266] = 117,
  [267] = 126,
  [268] = 101,
  [269] = 240,
  [270] = 117,
  [271] = 125,
  [272] = 107,
  [273] = 126,
  [274] = 127,
  [275] = 94,
  [276] = 102,
  [277] = 121,
  [278] = 114,
  [279] = 130,
  [280] = 132,
  [281] = 118,
  [282] = 113,
  [283] = 118,
  [284] = 120,
  [285] = 133,
  [286] = 131,
  [287] = 121,
  [288] = 120,
  [289] = 112,
  [290] = 111,
  [291] = 118,
  [292] = 129,
  [293] = 128,
  [294] = 117,
  [295] = 108,
  [296] = 123,
  [297] = 91,
  [298] = 98,
  [299] = 119,
  [300] = 99,
  [301] = 120,
  [302] = 110,
  [303] = 106,
  [304] = 121,
  [305] = 116,
  [306] = 109,
  [307] = 105,
  [308] = 92,
  [309] = 93,
  [310] = 114,
  [311] = 113,
  [312] = 126,
  [313] = 127,
  [314] = 112,
  [315] = 108,
  [316] = 107,
  [317] = 130,
  [318] = 100,
  [319] = 104,
  [320] = 103,
  [321] = 122,
  [322] = 132,
  [323] = 133,
  [324] = 131,
  [325] = 129,
  [326] = 128,
  [327] = 111,
  [328] = 109,
  [329] = 123,
  [330] = 119,
  [331] = 125,
  [332] = 125,
  [333] = 95,
  [334] = 110,
  [335] = 106,
  [336] = 105,
  [337] = 96,
  [338] = 104,
  [339] = 103,
  [340] = 122,
  [341] = 94,
  [342] = 100,
  [343] = 96,
  [344] = 97,
  [345] = 98,
  [346] = 91,
  [347] = 97,
  [348] = 99,
  [349] = 102,
  [350] = 100,
  [351] = 101,
  [352] = 99,
  [353] = 98,
  [354] = 142,
  [355] = 156,
  [356] = 146,
  [357] = 142,
  [358] = 138,
  [359] = 134,
  [360] = 155,
  [361] = 148,
  [362] = 159,
  [363] = 141,
  [364] = 160,
  [365] = 140,
  [366] = 152,
  [367] = 147,
  [368] = 138,
  [369] = 148,
  [370] = 149,
  [371] = 150,
  [372] = 136,
  [373] = 158,
  [374] = 159,
  [375] = 140,
  [376] = 160,
  [377] = 141,
  [378] = 145,
  [379] = 139,
  [380] = 147,
  [381] = 137,
  [382] = 157,
  [383] = 150,
  [384] = 152,
  [385] = 143,
  [386] = 136,
  [387] = 139,
  [388] = 156,
  [389] = 154,
  [390] = 154,
  [391] = 146,
  [392] = 157,
  [393] = 153,
  [394] = 155,
  [395] = 158,
  [396] = 134,
  [397] = 149,
  [398] = 143,
  [399] = 145,
  [400] = 153,
  [401] = 144,
  [402] = 151,
  [403] = 137,
  [404] = 144,
  [405] = 151,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 407,
  [411] = 406,
  [412] = 412,
  [413] = 409,
  [414] = 407,
  [415] = 415,
  [416] = 406,
  [417] = 415,
  [418] = 406,
  [419] = 419,
  [420] = 412,
  [421] = 421,
  [422] = 419,
  [423] = 408,
  [424] = 415,
  [425] = 408,
  [426] = 409,
  [427] = 419,
  [428] = 412,
  [429] = 408,
  [430] = 421,
  [431] = 419,
  [432] = 419,
  [433] = 421,
  [434] = 412,
  [435] = 419,
  [436] = 406,
  [437] = 409,
  [438] = 415,
  [439] = 407,
  [440] = 415,
  [441] = 421,
  [442] = 409,
  [443] = 412,
  [444] = 421,
  [445] = 406,
  [446] = 240,
  [447] = 407,
  [448] = 408,
  [449] = 415,
  [450] = 412,
  [451] = 409,
  [452] = 408,
  [453] = 407,
  [454] = 145,
  [455] = 152,
  [456] = 142,
  [457] = 140,
  [458] = 143,
  [459] = 240,
  [460] = 149,
  [461] = 148,
  [462] = 150,
  [463] = 134,
  [464] = 151,
  [465] = 155,
  [466] = 466,
  [467] = 158,
  [468] = 153,
  [469] = 144,
  [470] = 146,
  [471] = 141,
  [472] = 154,
  [473] = 159,
  [474] = 147,
  [475] = 475,
  [476] = 160,
  [477] = 136,
  [478] = 138,
  [479] = 157,
  [480] = 156,
  [481] = 139,
  [482] = 482,
  [483] = 482,
  [484] = 482,
  [485] = 482,
  [486] = 486,
  [487] = 482,
  [488] = 486,
  [489] = 486,
  [490] = 486,
  [491] = 482,
  [492] = 486,
  [493] = 486,
  [494] = 482,
  [495] = 482,
  [496] = 486,
  [497] = 486,
  [498] = 498,
  [499] = 499,
  [500] = 240,
  [501] = 240,
  [502] = 240,
  [503] = 90,
  [504] = 504,
  [505] = 240,
  [506] = 506,
  [507] = 506,
  [508] = 506,
  [509] = 506,
  [510] = 506,
  [511] = 506,
  [512] = 506,
  [513] = 506,
  [514] = 506,
  [515] = 506,
  [516] = 506,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 528,
  [530] = 530,
  [531] = 531,
  [532] = 530,
  [533] = 531,
  [534] = 534,
  [535] = 535,
  [536] = 535,
  [537] = 537,
  [538] = 538,
  [539] = 534,
  [540] = 534,
  [541] = 535,
  [542] = 535,
  [543] = 534,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 545,
  [548] = 545,
  [549] = 545,
  [550] = 544,
  [551] = 544,
  [552] = 552,
  [553] = 553,
  [554] = 544,
  [555] = 555,
  [556] = 546,
  [557] = 555,
  [558] = 558,
  [559] = 559,
  [560] = 559,
  [561] = 561,
  [562] = 559,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 559,
  [567] = 567,
  [568] = 546,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 569,
  [574] = 569,
  [575] = 559,
  [576] = 546,
  [577] = 577,
  [578] = 578,
  [579] = 559,
  [580] = 569,
  [581] = 581,
  [582] = 582,
  [583] = 569,
  [584] = 584,
  [585] = 585,
  [586] = 559,
  [587] = 559,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 591,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 591,
  [601] = 595,
  [602] = 602,
  [603] = 603,
  [604] = 591,
  [605] = 591,
  [606] = 606,
  [607] = 591,
  [608] = 591,
  [609] = 609,
  [610] = 610,
  [611] = 591,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 613,
  [620] = 615,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 615,
  [625] = 621,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 622,
  [630] = 617,
  [631] = 617,
  [632] = 626,
  [633] = 622,
  [634] = 615,
  [635] = 622,
  [636] = 614,
  [637] = 617,
  [638] = 638,
  [639] = 638,
  [640] = 640,
  [641] = 613,
  [642] = 626,
  [643] = 623,
  [644] = 617,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 612,
  [649] = 628,
  [650] = 616,
  [651] = 627,
  [652] = 640,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 656,
  [658] = 612,
  [659] = 655,
  [660] = 617,
  [661] = 622,
  [662] = 638,
  [663] = 654,
  [664] = 626,
  [665] = 638,
  [666] = 623,
  [667] = 653,
  [668] = 627,
  [669] = 622,
  [670] = 517,
  [671] = 626,
  [672] = 638,
  [673] = 638,
  [674] = 656,
  [675] = 675,
  [676] = 655,
  [677] = 677,
  [678] = 615,
  [679] = 679,
  [680] = 654,
  [681] = 653,
  [682] = 627,
  [683] = 616,
  [684] = 628,
  [685] = 612,
  [686] = 647,
  [687] = 617,
  [688] = 645,
  [689] = 622,
  [690] = 616,
  [691] = 615,
  [692] = 628,
  [693] = 653,
  [694] = 638,
  [695] = 654,
  [696] = 613,
  [697] = 617,
  [698] = 612,
  [699] = 622,
  [700] = 647,
  [701] = 621,
  [702] = 702,
  [703] = 613,
  [704] = 645,
  [705] = 645,
  [706] = 706,
  [707] = 647,
  [708] = 645,
  [709] = 615,
  [710] = 621,
  [711] = 647,
  [712] = 640,
  [713] = 613,
  [714] = 714,
  [715] = 628,
  [716] = 616,
  [717] = 640,
  [718] = 615,
  [719] = 612,
  [720] = 628,
  [721] = 721,
  [722] = 627,
  [723] = 616,
  [724] = 627,
  [725] = 656,
  [726] = 653,
  [727] = 647,
  [728] = 653,
  [729] = 706,
  [730] = 645,
  [731] = 654,
  [732] = 647,
  [733] = 656,
  [734] = 702,
  [735] = 612,
  [736] = 638,
  [737] = 628,
  [738] = 616,
  [739] = 627,
  [740] = 653,
  [741] = 654,
  [742] = 654,
  [743] = 613,
  [744] = 645,
  [745] = 655,
  [746] = 655,
  [747] = 656,
  [748] = 655,
  [749] = 656,
  [750] = 626,
  [751] = 721,
  [752] = 613,
  [753] = 655,
  [754] = 645,
  [755] = 647,
  [756] = 612,
  [757] = 656,
  [758] = 628,
  [759] = 616,
  [760] = 760,
  [761] = 627,
  [762] = 653,
  [763] = 654,
  [764] = 655,
  [765] = 765,
  [766] = 765,
  [767] = 765,
  [768] = 765,
  [769] = 769,
  [770] = 770,
  [771] = 765,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 787,
  [789] = 498,
  [790] = 499,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 793,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 795,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 794,
  [806] = 799,
  [807] = 807,
  [808] = 808,
  [809] = 799,
  [810] = 799,
  [811] = 793,
  [812] = 793,
  [813] = 813,
  [814] = 814,
  [815] = 794,
  [816] = 816,
  [817] = 795,
  [818] = 795,
  [819] = 819,
  [820] = 820,
  [821] = 794,
  [822] = 799,
  [823] = 793,
  [824] = 824,
  [825] = 825,
  [826] = 795,
  [827] = 794,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 773,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 773,
  [844] = 769,
  [845] = 770,
  [846] = 772,
  [847] = 773,
  [848] = 774,
  [849] = 773,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 851,
  [854] = 852,
  [855] = 851,
  [856] = 852,
  [857] = 852,
  [858] = 775,
  [859] = 776,
  [860] = 852,
  [861] = 851,
  [862] = 851,
  [863] = 863,
  [864] = 863,
  [865] = 863,
  [866] = 863,
  [867] = 867,
  [868] = 863,
  [869] = 869,
  [870] = 870,
  [871] = 863,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 773,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 884,
  [887] = 887,
  [888] = 885,
  [889] = 877,
  [890] = 881,
  [891] = 874,
  [892] = 836,
  [893] = 893,
  [894] = 876,
  [895] = 873,
  [896] = 841,
  [897] = 875,
  [898] = 878,
  [899] = 879,
  [900] = 830,
  [901] = 882,
  [902] = 883,
  [903] = 835,
  [904] = 873,
  [905] = 882,
  [906] = 876,
  [907] = 875,
  [908] = 874,
  [909] = 879,
  [910] = 883,
  [911] = 832,
  [912] = 885,
  [913] = 877,
  [914] = 839,
  [915] = 834,
  [916] = 884,
  [917] = 881,
  [918] = 878,
  [919] = 840,
  [920] = 829,
  [921] = 837,
  [922] = 887,
  [923] = 781,
  [924] = 791,
  [925] = 816,
  [926] = 824,
  [927] = 927,
  [928] = 154,
  [929] = 157,
  [930] = 887,
  [931] = 814,
  [932] = 798,
  [933] = 813,
  [934] = 782,
  [935] = 935,
  [936] = 155,
  [937] = 808,
  [938] = 134,
  [939] = 780,
  [940] = 825,
  [941] = 787,
  [942] = 783,
  [943] = 801,
  [944] = 944,
  [945] = 143,
  [946] = 777,
  [947] = 947,
  [948] = 948,
  [949] = 804,
  [950] = 950,
  [951] = 785,
  [952] = 807,
  [953] = 803,
  [954] = 786,
  [955] = 797,
  [956] = 956,
  [957] = 957,
  [958] = 802,
  [959] = 820,
  [960] = 784,
  [961] = 961,
  [962] = 962,
  [963] = 778,
  [964] = 819,
  [965] = 139,
  [966] = 966,
  [967] = 779,
  [968] = 968,
  [969] = 829,
  [970] = 883,
  [971] = 947,
  [972] = 881,
  [973] = 837,
  [974] = 935,
  [975] = 956,
  [976] = 976,
  [977] = 154,
  [978] = 879,
  [979] = 961,
  [980] = 878,
  [981] = 875,
  [982] = 876,
  [983] = 839,
  [984] = 834,
  [985] = 985,
  [986] = 873,
  [987] = 962,
  [988] = 966,
  [989] = 832,
  [990] = 990,
  [991] = 957,
  [992] = 882,
  [993] = 872,
  [994] = 157,
  [995] = 968,
  [996] = 139,
  [997] = 927,
  [998] = 840,
  [999] = 999,
  [1000] = 143,
  [1001] = 134,
  [1002] = 1002,
  [1003] = 874,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 877,
  [1008] = 944,
  [1009] = 1009,
  [1010] = 948,
  [1011] = 950,
  [1012] = 885,
  [1013] = 155,
  [1014] = 884,
  [1015] = 498,
  [1016] = 775,
  [1017] = 1017,
  [1018] = 776,
  [1019] = 887,
  [1020] = 499,
  [1021] = 966,
  [1022] = 962,
  [1023] = 957,
  [1024] = 966,
  [1025] = 962,
  [1026] = 1026,
  [1027] = 961,
  [1028] = 935,
  [1029] = 927,
  [1030] = 956,
  [1031] = 947,
  [1032] = 968,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 944,
  [1037] = 948,
  [1038] = 950,
  [1039] = 143,
  [1040] = 968,
  [1041] = 134,
  [1042] = 155,
  [1043] = 1026,
  [1044] = 157,
  [1045] = 154,
  [1046] = 139,
  [1047] = 950,
  [1048] = 1048,
  [1049] = 948,
  [1050] = 1026,
  [1051] = 944,
  [1052] = 1052,
  [1053] = 1026,
  [1054] = 1054,
  [1055] = 139,
  [1056] = 1056,
  [1057] = 154,
  [1058] = 157,
  [1059] = 155,
  [1060] = 134,
  [1061] = 143,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 947,
  [1067] = 956,
  [1068] = 927,
  [1069] = 1069,
  [1070] = 957,
  [1071] = 1026,
  [1072] = 1072,
  [1073] = 961,
  [1074] = 1074,
  [1075] = 935,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 108,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1120,
  [1124] = 1124,
  [1125] = 1120,
  [1126] = 1120,
  [1127] = 1120,
  [1128] = 881,
  [1129] = 882,
  [1130] = 884,
  [1131] = 878,
  [1132] = 883,
  [1133] = 877,
  [1134] = 874,
  [1135] = 875,
  [1136] = 876,
  [1137] = 885,
  [1138] = 879,
  [1139] = 873,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 108,
  [1146] = 879,
  [1147] = 882,
  [1148] = 878,
  [1149] = 873,
  [1150] = 875,
  [1151] = 883,
  [1152] = 1142,
  [1153] = 1153,
  [1154] = 876,
  [1155] = 881,
  [1156] = 885,
  [1157] = 884,
  [1158] = 877,
  [1159] = 874,
  [1160] = 1142,
  [1161] = 1142,
  [1162] = 1142,
  [1163] = 875,
  [1164] = 878,
  [1165] = 883,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1140,
  [1169] = 1169,
  [1170] = 881,
  [1171] = 879,
  [1172] = 882,
  [1173] = 876,
  [1174] = 885,
  [1175] = 1175,
  [1176] = 884,
  [1177] = 877,
  [1178] = 874,
  [1179] = 873,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1192,
  [1195] = 1191,
  [1196] = 1189,
  [1197] = 1190,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1140,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1199,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 882,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1205,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1204,
  [1219] = 883,
  [1220] = 1217,
  [1221] = 881,
  [1222] = 879,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1204,
  [1226] = 878,
  [1227] = 1205,
  [1228] = 1211,
  [1229] = 1211,
  [1230] = 1230,
  [1231] = 1224,
  [1232] = 875,
  [1233] = 1205,
  [1234] = 1234,
  [1235] = 1199,
  [1236] = 1236,
  [1237] = 1199,
  [1238] = 1204,
  [1239] = 1199,
  [1240] = 876,
  [1241] = 1211,
  [1242] = 885,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 884,
  [1247] = 1205,
  [1248] = 1204,
  [1249] = 877,
  [1250] = 1250,
  [1251] = 874,
  [1252] = 1252,
  [1253] = 873,
  [1254] = 1211,
  [1255] = 1224,
  [1256] = 1210,
  [1257] = 1257,
  [1258] = 1206,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1261,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1267,
  [1269] = 850,
  [1270] = 1270,
  [1271] = 1267,
  [1272] = 1272,
  [1273] = 1266,
  [1274] = 1266,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1266,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1266,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1267,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1267,
  [1289] = 1275,
  [1290] = 1290,
  [1291] = 1266,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1267,
  [1295] = 1267,
  [1296] = 1267,
  [1297] = 1297,
  [1298] = 1262,
  [1299] = 1121,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1141,
  [1303] = 1303,
  [1304] = 1180,
  [1305] = 1175,
  [1306] = 1166,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1109,
  [1321] = 1103,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1325,
  [1327] = 1318,
  [1328] = 1324,
  [1329] = 1324,
  [1330] = 1325,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1338,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 1331,
  [1345] = 1345,
  [1346] = 1333,
  [1347] = 1347,
  [1348] = 1348,
  [1349] = 1333,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1332,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1359,
  [1360] = 1356,
  [1361] = 1361,
  [1362] = 1333,
  [1363] = 1361,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1331,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1333,
  [1370] = 1370,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1373,
  [1375] = 1372,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1379,
  [1380] = 801,
  [1381] = 1381,
  [1382] = 1331,
  [1383] = 1383,
  [1384] = 1345,
  [1385] = 1347,
  [1386] = 1386,
  [1387] = 1348,
  [1388] = 1381,
  [1389] = 1354,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1368,
  [1395] = 1371,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1337,
  [1399] = 1105,
  [1400] = 1101,
  [1401] = 1102,
  [1402] = 1085,
  [1403] = 1350,
  [1404] = 1404,
  [1405] = 1342,
  [1406] = 1341,
  [1407] = 1340,
  [1408] = 1338,
  [1409] = 1409,
  [1410] = 1336,
  [1411] = 1335,
  [1412] = 1334,
  [1413] = 1339,
  [1414] = 1357,
  [1415] = 1415,
  [1416] = 1343,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1092,
  [1420] = 1358,
  [1421] = 1418,
  [1422] = 1418,
  [1423] = 1423,
  [1424] = 1409,
  [1425] = 801,
  [1426] = 1409,
  [1427] = 1359,
  [1428] = 1081,
  [1429] = 1415,
  [1430] = 1391,
  [1431] = 1431,
  [1432] = 1390,
  [1433] = 1095,
  [1434] = 1111,
  [1435] = 1418,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1365,
  [1439] = 1409,
  [1440] = 1418,
  [1441] = 1396,
  [1442] = 1103,
  [1443] = 1109,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1445,
  [1447] = 1121,
  [1448] = 1444,
  [1449] = 1444,
  [1450] = 1445,
  [1451] = 1444,
  [1452] = 1445,
  [1453] = 1444,
  [1454] = 1445,
  [1455] = 1455,
  [1456] = 1455,
  [1457] = 1457,
  [1458] = 1455,
  [1459] = 1455,
  [1460] = 1460,
  [1461] = 1455,
  [1462] = 1462,
  [1463] = 1462,
  [1464] = 1464,
  [1465] = 1464,
  [1466] = 1464,
  [1467] = 1464,
  [1468] = 1462,
  [1469] = 1464,
  [1470] = 1462,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1471,
  [1475] = 1471,
  [1476] = 1471,
  [1477] = 1477,
  [1478] = 1471,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1480,
  [1484] = 1480,
  [1485] = 1481,
  [1486] = 1486,
  [1487] = 1481,
  [1488] = 1481,
  [1489] = 1480,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1480,
  [1495] = 1495,
  [1496] = 1480,
  [1497] = 1497,
  [1498] = 1480,
  [1499] = 1481,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1504,
  [1505] = 1504,
  [1506] = 1506,
  [1507] = 1504,
  [1508] = 1508,
  [1509] = 1504,
  [1510] = 1510,
  [1511] = 1504,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1514,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1514,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1514,
  [1525] = 1525,
  [1526] = 1514,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1548,
  [1550] = 1550,
  [1551] = 1550,
  [1552] = 1547,
  [1553] = 1547,
  [1554] = 1550,
  [1555] = 1547,
  [1556] = 1547,
  [1557] = 1550,
  [1558] = 1558,
  [1559] = 1550,
  [1560] = 1546,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1571,
  [1575] = 1575,
  [1576] = 1563,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1568,
  [1580] = 1571,
  [1581] = 1581,
  [1582] = 1571,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1571,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1613,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1573,
  [1622] = 1586,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1581,
  [1626] = 1617,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1609,
  [1658] = 1658,
  [1659] = 1624,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1664,
  [1666] = 1664,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1664,
  [1670] = 1670,
  [1671] = 1668,
  [1672] = 1664,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1667,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1664,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1674,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1664,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1668,
  [1696] = 1696,
  [1697] = 1692,
  [1698] = 1693,
  [1699] = 1678,
  [1700] = 1679,
  [1701] = 1701,
  [1702] = 1668,
  [1703] = 1674,
  [1704] = 1674,
  [1705] = 1667,
  [1706] = 1686,
  [1707] = 1686,
  [1708] = 1686,
  [1709] = 1664,
  [1710] = 1674,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1679,
  [1714] = 1692,
  [1715] = 1678,
  [1716] = 1668,
  [1717] = 1693,
  [1718] = 1718,
  [1719] = 1674,
  [1720] = 1692,
  [1721] = 1721,
  [1722] = 1664,
  [1723] = 1723,
  [1724] = 1679,
  [1725] = 1678,
  [1726] = 1678,
  [1727] = 1679,
  [1728] = 1686,
  [1729] = 1693,
  [1730] = 1667,
  [1731] = 1731,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1581,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1740,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1748,
  [1755] = 1755,
  [1756] = 1752,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1732,
  [1762] = 1762,
  [1763] = 1739,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1762,
  [1767] = 1735,
  [1768] = 1732,
  [1769] = 1732,
  [1770] = 1770,
  [1771] = 1758,
  [1772] = 1740,
  [1773] = 1759,
  [1774] = 1738,
  [1775] = 1737,
  [1776] = 1764,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1770,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1770,
  [1784] = 1778,
  [1785] = 1785,
  [1786] = 1750,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1739,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1743,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1787,
  [1800] = 1797,
  [1801] = 1801,
  [1802] = 1802,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1732,
  [1806] = 1743,
  [1807] = 1735,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1735,
  [1815] = 1740,
  [1816] = 1816,
  [1817] = 1811,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1750,
  [1821] = 1813,
  [1822] = 1822,
  [1823] = 1734,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1833,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1832,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 1829,
  [1840] = 1830,
  [1841] = 1829,
  [1842] = 1842,
  [1843] = 1824,
  [1844] = 1835,
  [1845] = 1845,
  [1846] = 1831,
  [1847] = 1826,
  [1848] = 1826,
  [1849] = 1849,
  [1850] = 1835,
  [1851] = 1851,
  [1852] = 1827,
  [1853] = 1831,
  [1854] = 1845,
  [1855] = 1835,
  [1856] = 1856,
  [1857] = 1857,
  [1858] = 1832,
  [1859] = 1859,
  [1860] = 1845,
  [1861] = 1861,
  [1862] = 1845,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1830,
  [1866] = 1832,
  [1867] = 1824,
  [1868] = 1824,
  [1869] = 1869,
  [1870] = 1827,
  [1871] = 1827,
  [1872] = 1827,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1875,
  [1876] = 1824,
  [1877] = 1863,
  [1878] = 1832,
  [1879] = 1879,
  [1880] = 1837,
  [1881] = 1837,
  [1882] = 1830,
  [1883] = 1824,
  [1884] = 1835,
  [1885] = 1845,
  [1886] = 1886,
  [1887] = 1829,
  [1888] = 1833,
  [1889] = 1833,
  [1890] = 1833,
  [1891] = 1831,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1845,
  [1897] = 1897,
  [1898] = 1829,
  [1899] = 1837,
  [1900] = 1829,
  [1901] = 1833,
  [1902] = 1826,
  [1903] = 1903,
  [1904] = 1904,
  [1905] = 1830,
  [1906] = 1845,
  [1907] = 1907,
  [1908] = 1832,
  [1909] = 1833,
  [1910] = 1837,
  [1911] = 1837,
  [1912] = 1833,
  [1913] = 1845,
  [1914] = 1914,
  [1915] = 1833,
  [1916] = 1849,
  [1917] = 1835,
  [1918] = 1918,
  [1919] = 1845,
  [1920] = 1833,
  [1921] = 1826,
  [1922] = 1849,
  [1923] = 1826,
  [1924] = 1831,
  [1925] = 1925,
  [1926] = 1926,
  [1927] = 1927,
  [1928] = 1928,
  [1929] = 1929,
  [1930] = 1930,
  [1931] = 1931,
  [1932] = 1932,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1928,
  [1936] = 1933,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1939,
  [1940] = 1940,
  [1941] = 1934,
  [1942] = 1942,
  [1943] = 1943,
  [1944] = 1928,
  [1945] = 1945,
  [1946] = 1933,
  [1947] = 1947,
  [1948] = 1934,
  [1949] = 1949,
  [1950] = 1928,
  [1951] = 1945,
  [1952] = 1933,
  [1953] = 1947,
  [1954] = 1934,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1958,
  [1959] = 1959,
  [1960] = 1960,
  [1961] = 1961,
  [1962] = 1962,
  [1963] = 1963,
  [1964] = 1964,
  [1965] = 1965,
  [1966] = 1966,
  [1967] = 1967,
  [1968] = 1968,
  [1969] = 1945,
  [1970] = 1970,
  [1971] = 1971,
  [1972] = 1972,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 1926,
  [1977] = 1977,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1981,
  [1982] = 1982,
  [1983] = 1983,
  [1984] = 1928,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 1945,
  [1989] = 1956,
  [1990] = 1933,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 1947,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1359,
  [1998] = 1998,
  [1999] = 1999,
  [2000] = 1927,
  [2001] = 2001,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 2006,
  [2007] = 1934,
  [2008] = 1931,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 1959,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 1966,
  [2020] = 1937,
  [2021] = 1968,
  [2022] = 2022,
  [2023] = 1972,
  [2024] = 2024,
  [2025] = 2025,
  [2026] = 2026,
  [2027] = 1999,
  [2028] = 1927,
  [2029] = 2029,
  [2030] = 1973,
  [2031] = 2029,
  [2032] = 2032,
  [2033] = 1965,
  [2034] = 1970,
  [2035] = 1931,
  [2036] = 776,
  [2037] = 2032,
  [2038] = 2038,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2042,
  [2043] = 2043,
  [2044] = 775,
  [2045] = 1966,
  [2046] = 2046,
  [2047] = 1968,
  [2048] = 1979,
  [2049] = 1977,
  [2050] = 1983,
  [2051] = 1928,
  [2052] = 1959,
  [2053] = 1999,
  [2054] = 1927,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2013,
  [2058] = 1945,
  [2059] = 1931,
  [2060] = 2060,
  [2061] = 1965,
  [2062] = 2012,
  [2063] = 2010,
  [2064] = 2005,
  [2065] = 1933,
  [2066] = 1934,
  [2067] = 2067,
  [2068] = 1358,
  [2069] = 2006,
  [2070] = 1999,
  [2071] = 1999,
  [2072] = 1947,
  [2073] = 1995,
  [2074] = 1999,
  [2075] = 1999,
  [2076] = 1999,
  [2077] = 1996,
  [2078] = 2005,
  [2079] = 2003,
  [2080] = 1996,
  [2081] = 2081,
  [2082] = 1995,
  [2083] = 2003,
  [2084] = 2084,
  [2085] = 1959,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 2006,
  [2089] = 1970,
  [2090] = 1947,
  [2091] = 2006,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2041,
  [2095] = 1934,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 2010,
  [2099] = 1933,
  [2100] = 1956,
  [2101] = 2012,
  [2102] = 2013,
  [2103] = 1959,
  [2104] = 2104,
  [2105] = 1966,
  [2106] = 1968,
  [2107] = 1937,
  [2108] = 1972,
  [2109] = 1977,
  [2110] = 1983,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 1928,
  [2114] = 1945,
  [2115] = 1973,
  [2116] = 1365,
  [2117] = 2029,
  [2118] = 2118,
  [2119] = 2032,
  [2120] = 1965,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 1928,
  [2124] = 2112,
  [2125] = 1970,
  [2126] = 2111,
  [2127] = 2118,
  [2128] = 2018,
  [2129] = 1945,
  [2130] = 2130,
  [2131] = 1968,
  [2132] = 1983,
  [2133] = 2081,
  [2134] = 2041,
  [2135] = 1977,
  [2136] = 2104,
  [2137] = 2092,
  [2138] = 1977,
  [2139] = 2139,
  [2140] = 1983,
  [2141] = 2141,
  [2142] = 1928,
  [2143] = 2143,
  [2144] = 2041,
  [2145] = 2092,
  [2146] = 1970,
  [2147] = 1945,
  [2148] = 2148,
  [2149] = 2149,
  [2150] = 2150,
  [2151] = 1968,
  [2152] = 1956,
  [2153] = 2092,
  [2154] = 2154,
  [2155] = 1962,
  [2156] = 1965,
  [2157] = 1933,
  [2158] = 2056,
  [2159] = 1350,
  [2160] = 2081,
  [2161] = 2097,
  [2162] = 1956,
  [2163] = 2006,
  [2164] = 2164,
  [2165] = 1947,
  [2166] = 1933,
  [2167] = 2032,
  [2168] = 2029,
  [2169] = 1999,
  [2170] = 1995,
  [2171] = 1996,
  [2172] = 2092,
  [2173] = 2022,
  [2174] = 1947,
  [2175] = 1995,
  [2176] = 2003,
  [2177] = 2005,
  [2178] = 1996,
  [2179] = 2179,
  [2180] = 1973,
  [2181] = 1972,
  [2182] = 2006,
  [2183] = 2067,
  [2184] = 1934,
  [2185] = 2003,
  [2186] = 1937,
  [2187] = 2005,
  [2188] = 2010,
  [2189] = 2189,
  [2190] = 1932,
  [2191] = 2006,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2084,
  [2195] = 1931,
  [2196] = 2012,
  [2197] = 2006,
  [2198] = 2013,
  [2199] = 2081,
  [2200] = 2067,
  [2201] = 1959,
  [2202] = 1934,
  [2203] = 2081,
  [2204] = 2010,
  [2205] = 1993,
  [2206] = 2081,
  [2207] = 2207,
  [2208] = 2012,
  [2209] = 2209,
  [2210] = 2193,
  [2211] = 2013,
  [2212] = 1927,
  [2213] = 2192,
};

static inline bool sym_number_literal_character_set_1(int32_t c) {
  return (c < 'b'
    ? (c < 'L'
      ? (c < 'D'
        ? c == 'B'
        : c <= 'F')
      : (c <= 'L' || (c < 'W'
        ? c == 'U'
        : c <= 'W')))
    : (c <= 'b' || (c < 'u'
      ? (c < 'l'
        ? (c >= 'd' && c <= 'f')
        : c <= 'l')
      : (c <= 'u' || c == 'w'))));
}

static inline bool sym_number_literal_character_set_2(int32_t c) {
  return (c < 'b'
    ? (c < 'L'
      ? (c < 'D'
        ? c == 'B'
        : (c <= 'D' || c == 'F'))
      : (c <= 'L' || (c < 'W'
        ? c == 'U'
        : c <= 'W')))
    : (c <= 'b' || (c < 'l'
      ? (c < 'f'
        ? c == 'd'
        : c <= 'f')
      : (c <= 'l' || (c < 'w'
        ? c == 'u'
        : c <= 'w')))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43488
    ? (c < 4159
      ? (c < 2654
        ? (c < 1808
          ? (c < 895
            ? (c < 192
              ? (c < 'a'
                ? (c < 'M'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'K')
                  : (c <= 'T' || (c < '_'
                    ? (c >= 'V' && c <= 'Z')
                    : c <= '_')))
                : (c <= 't' || (c < 181
                  ? (c < 170
                    ? (c >= 'v' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || c == 186))))
              : (c <= 214 || (c < 748
                ? (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))))))
            : (c <= 895 || (c < 1488
              ? (c < 1015
                ? (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))
                : (c <= 1153 || (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))))
              : (c <= 1514 || (c < 1749
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))
                : (c <= 1749 || (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))))))))
          : (c <= 1808 || (c < 2437
            ? (c < 2112
              ? (c < 2042
                ? (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2084
                  ? (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)
                  : (c <= 2084 || c == 2088))))
              : (c <= 2136 || (c < 2308
                ? (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c >= 2208 && c <= 2249)))
                : (c <= 2361 || (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))))))
            : (c <= 2444 || (c < 2544
              ? (c < 2486
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))
                : (c <= 2489 || (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))))
              : (c <= 2545 || (c < 2602
                ? (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))))))))))
        : (c <= 2654 || (c < 3205
          ? (c < 2929
            ? (c < 2809
              ? (c < 2738
                ? (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))
                : (c <= 2739 || (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c >= 2784 && c <= 2785)))))
              : (c <= 2809 || (c < 2866
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))))))
            : (c <= 2929 || (c < 3024
              ? (c < 2972
                ? (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3169 || c == 3200))))))))
          : (c <= 3212 || (c < 3520
            ? (c < 3346
              ? (c < 3293
                ? (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))))))))))))
      : (c <= 4159 || (c < 8126
        ? (c < 6103
          ? (c < 4792
            ? (c < 4304
              ? (c < 4213
                ? (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)))
                : (c <= 4225 || (c < 4295
                  ? (c < 4256
                    ? c == 4238
                    : c <= 4293)
                  : (c <= 4295 || c == 4301))))
              : (c <= 4346 || (c < 4698
                ? (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || c == 4696))
                : (c <= 4701 || (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))))))
            : (c <= 4798 || (c < 5743
              ? (c < 4888
                ? (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))
                : (c <= 4954 || (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))))
              : (c <= 5759 || (c < 5919
                ? (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c >= 5888 && c <= 5905)))
                : (c <= 5937 || (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)
                  : (c <= 6000 || (c >= 6016 && c <= 6067)))))))))
          : (c <= 6103 || (c < 7258
            ? (c < 6656
              ? (c < 6400
                ? (c < 6272
                  ? (c < 6176
                    ? c == 6108
                    : c <= 6264)
                  : (c <= 6312 || (c < 6320
                    ? c == 6314
                    : c <= 6389)))
                : (c <= 6430 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))))
              : (c <= 6678 || (c < 7043
                ? (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))))))
            : (c <= 7293 || (c < 7960
              ? (c < 7406
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))
                : (c <= 7411 || (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))))
              : (c <= 7965 || (c < 8027
                ? (c < 8016
                  ? (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c >= 8118 && c <= 8124)))))))))))
        : (c <= 8126 || (c < 12293
          ? (c < 8517
            ? (c < 8450
              ? (c < 8178
                ? (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))
                : (c <= 8180 || (c < 8319
                  ? (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))))
              : (c <= 8450 || (c < 8484
                ? (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c >= 8472 && c <= 8477)))
                : (c <= 8484 || (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c >= 8508 && c <= 8511)))))))
            : (c <= 8521 || (c < 11631
              ? (c < 11506
                ? (c < 11264
                  ? (c < 8544
                    ? c == 8526
                    : c <= 8584)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))
                : (c <= 11507 || (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))
              : (c <= 11631 || (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))))))
          : (c <= 12295 || (c < 42775
            ? (c < 12784
              ? (c < 12449
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)))
                : (c <= 12538 || (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))))
              : (c <= 12799 || (c < 42512
                ? (c < 42192
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)
                  : (c <= 42237 || (c >= 42240 && c <= 42508)))
                : (c <= 42527 || (c < 42623
                  ? (c < 42560
                    ? (c >= 42538 && c <= 42539)
                    : c <= 42606)
                  : (c <= 42653 || (c >= 42656 && c <= 42735)))))))
            : (c <= 42783 || (c < 43072
              ? (c < 42965
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43015
                  ? (c < 43011
                    ? (c >= 42994 && c <= 43009)
                    : c <= 43013)
                  : (c <= 43018 || (c >= 43020 && c <= 43042)))))
              : (c <= 43123 || (c < 43274
                ? (c < 43259
                  ? (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43396
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43334)
                    : c <= 43388)
                  : (c <= 43442 || c == 43471))))))))))))))
    : (c <= 43492 || (c < 70656
      ? (c < 66940
        ? (c < 64848
          ? (c < 43816
            ? (c < 43705
              ? (c < 43616
                ? (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)))
                : (c <= 43638 || (c < 43697
                  ? (c < 43646
                    ? c == 43642
                    : c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))))
              : (c <= 43709 || (c < 43762
                ? (c < 43739
                  ? (c < 43714
                    ? c == 43712
                    : c <= 43714)
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43793
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)
                  : (c <= 43798 || (c >= 43808 && c <= 43814)))))))
            : (c <= 43822 || (c < 64285
              ? (c < 55243
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44002 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c >= 64275 && c <= 64279)))))
              : (c <= 64285 || (c < 64320
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64287 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c >= 64612 && c <= 64829)))))))))
          : (c <= 64911 || (c < 65596
            ? (c < 65345
              ? (c < 65145
                ? (c < 65137
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c >= 65313 && c <= 65338)))))
              : (c <= 65370 || (c < 65490
                ? (c < 65474
                  ? (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65549
                  ? (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))))))
            : (c <= 65597 || (c < 66432
              ? (c < 66176
                ? (c < 65664
                  ? (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))
                : (c <= 66204 || (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))))
              : (c <= 66461 || (c < 66736
                ? (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))
                : (c <= 66771 || (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 66928 && c <= 66938)))))))))))
        : (c <= 66954 || (c < 68800
          ? (c < 67808
            ? (c < 67463
              ? (c < 67003
                ? (c < 66967
                  ? (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)
                  : (c <= 66977 || (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)))
                : (c <= 67004 || (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c >= 67456 && c <= 67461)))))
              : (c <= 67504 || (c < 67639
                ? (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))))))
            : (c <= 67826 || (c < 68192
              ? (c < 68030
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43494
    ? (c < 4186
      ? (c < 2703
        ? (c < 1969
          ? (c < 908
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? c == '$'
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))))
              : (c <= 721 || (c < 886
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c >= 904 && c <= 906)))))))
            : (c <= 908 || (c < 1646
              ? (c < 1369
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2185
              ? (c < 2084
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)))
                : (c <= 2084 || (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))))
              : (c <= 2190 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c >= 2693 && c <= 2701)))))))))))
        : (c <= 2705 || (c < 3218
          ? (c < 2958
            ? (c < 2835
              ? (c < 2768
                ? (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)))
                : (c <= 2768 || (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))))
              : (c <= 2856 || (c < 2908
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c >= 2949 && c <= 2954)))))))
            : (c <= 2960 || (c < 3086
              ? (c < 2979
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))))
              : (c <= 3088 || (c < 3165
                ? (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3165 || (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c >= 3214 && c <= 3216)))))))))
          : (c <= 3240 || (c < 3634
            ? (c < 3406
              ? (c < 3313
                ? (c < 3261
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3261 || (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3386 || c == 3389))))
              : (c <= 3406 || (c < 3482
                ? (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c >= 3585 && c <= 3632)))))))
            : (c <= 3634 || (c < 3776
              ? (c < 3724
                ? (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3762
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3760)
                  : (c <= 3762 || c == 3773))))
              : (c <= 3780 || (c < 3913
                ? (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c >= 4176 && c <= 4181)))))))))))))
      : (c <= 4189 || (c < 8130
        ? (c < 6108
          ? (c < 4802
            ? (c < 4682
              ? (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))))
              : (c <= 4685 || (c < 4746
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || c == 4800))))))
            : (c <= 4805 || (c < 5761
              ? (c < 4992
                ? (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))))
              : (c <= 5786 || (c < 5952
                ? (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))))))))
          : (c <= 6108 || (c < 7296
            ? (c < 6688
              ? (c < 6480
                ? (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))))
              : (c <= 6740 || (c < 7086
                ? (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))))))
            : (c <= 7304 || (c < 7968
              ? (c < 7413
                ? (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))
                : (c <= 7414 || (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))))
              : (c <= 8005 || (c < 8029
                ? (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))
                : (c <= 8029 || (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || c == 8126))))))))))
        : (c <= 8132 || (c < 12321
          ? (c < 8526
            ? (c < 8455
              ? (c < 8182
                ? (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))
                : (c <= 8188 || (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || c == 8450))))
              : (c <= 8455 || (c < 8486
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || c == 8484))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))))))
            : (c <= 8526 || (c < 11648
              ? (c < 11520
                ? (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || c == 11631))))
              : (c <= 11670 || (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))))))
          : (c <= 12329 || (c < 42786
            ? (c < 13312
              ? (c < 12540
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))
                : (c <= 12543 || (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))))
              : (c <= 19903 || (c < 42538
                ? (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c >= 42512 && c <= 42527)))
                : (c <= 42539 || (c < 42656
                  ? (c < 42623
                    ? (c >= 42560 && c <= 42606)
                    : c <= 42653)
                  : (c <= 42735 || (c >= 42775 && c <= 42783)))))))
            : (c <= 42888 || (c < 43138
              ? (c < 42994
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c >= 42965 && c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))))
              : (c <= 43187 || (c < 43312
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c >= 43488 && c <= 43492)))))))))))))))
    : (c <= 43503 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43824
            ? (c < 43712
              ? (c < 43642
                ? (c < 43584
                  ? (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)
                  : (c <= 43586 || (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)))
                : (c <= 43642 || (c < 43701
                  ? (c < 43697
                    ? (c >= 43646 && c <= 43695)
                    : c <= 43697)
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))))
              : (c <= 43712 || (c < 43777
                ? (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c >= 43816 && c <= 43822)))))))
            : (c <= 43866 || (c < 64287
              ? (c < 63744
                ? (c < 44032
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 43600
    ? (c < 3776
      ? (c < 2738
        ? (c < 1984
          ? (c < 910
            ? (c < 216
              ? (c < 'a'
                ? (c < '9'
                  ? (c < '0'
                    ? c == '$'
                    : c <= '7')
                  : (c <= '9' || (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')))
                : (c <= 'z' || (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))))
              : (c <= 246 || (c < 768
                ? (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))))))
            : (c <= 929 || (c < 1479
              ? (c < 1369
                ? (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))))
              : (c <= 1479 || (c < 1749
                ? (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))
                : (c <= 1756 || (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))))))))
          : (c <= 2037 || (c < 2534
            ? (c < 2437
              ? (c < 2160
                ? (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))
                : (c <= 2183 || (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))
              : (c <= 2444 || (c < 2492
                ? (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))
                : (c <= 2500 || (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))))))))))
        : (c <= 2739 || (c < 3160
          ? (c < 2946
            ? (c < 2835
              ? (c < 2784
                ? (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)))
                : (c <= 2787 || (c < 2817
                  ? (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)
                  : (c <= 2819 || (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)))))
              : (c <= 2856 || (c < 2891
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)))
                : (c <= 2893 || (c < 2911
                  ? (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)))))))
            : (c <= 2947 || (c < 3018
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3090
                ? (c < 3046
                  ? (c < 3031
                    ? c == 3024
                    : c <= 3031)
                  : (c <= 3055 || (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)))
                : (c <= 3112 || (c < 3142
                  ? (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)
                  : (c <= 3144 || (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3274
              ? (c < 3214
                ? (c < 3174
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3171)
                  : (c <= 3183 || (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)))
                : (c <= 3216 || (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3328
                ? (c < 3296
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)
                  : (c <= 3299 || (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3398
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)
                  : (c <= 3400 || (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))))))))))))
      : (c <= 3780 || (c < 8016
        ? (c < 5870
          ? (c < 4682
            ? (c < 3913
              ? (c < 3864
                ? (c < 3792
                  ? (c < 3784
                    ? c == 3782
                    : c <= 3789)
                  : (c <= 3801 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3865 || (c < 3895
                  ? (c < 3893
                    ? (c >= 3872 && c <= 3881)
                    : c <= 3893)
                  : (c <= 3895 || (c < 3902
                    ? c == 3897
                    : c <= 3911)))))
              : (c <= 3948 || (c < 4176
                ? (c < 3993
                  ? (c < 3974
                    ? (c >= 3953 && c <= 3972)
                    : c <= 3991)
                  : (c <= 4028 || (c < 4096
                    ? c == 4038
                    : c <= 4169)))
                : (c <= 4253 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4824
              ? (c < 4752
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))))
              : (c <= 4880 || (c < 5024
                ? (c < 4957
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))))))))
          : (c <= 5880 || (c < 6656
            ? (c < 6159
              ? (c < 6002
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5909)
                    : c <= 5940)
                  : (c <= 5971 || (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)))
                : (c <= 6003 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))))
              : (c <= 6169 || (c < 6448
                ? (c < 6320
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6432
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6443)))
                : (c <= 6459 || (c < 6528
                  ? (c < 6512
                    ? (c >= 6470 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c < 6608
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6618)))))))
            : (c <= 6683 || (c < 7168
              ? (c < 6832
                ? (c < 6783
                  ? (c < 6752
                    ? (c >= 6688 && c <= 6750)
                    : c <= 6780)
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))
                : (c <= 6845 || (c < 6992
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)
                  : (c <= 7001 || (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : c <= 7155)))))
              : (c <= 7223 || (c < 7376
                ? (c < 7296
                  ? (c < 7245
                    ? (c >= 7232 && c <= 7241)
                    : c <= 7293)
                  : (c <= 7304 || (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)))
                : (c <= 7378 || (c < 7960
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7957)
                  : (c <= 7965 || (c < 8008
                    ? (c >= 7968 && c <= 8005)
                    : c <= 8013)))))))))))
        : (c <= 8023 || (c < 11712
          ? (c < 8455
            ? (c < 8160
              ? (c < 8118
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))))
              : (c <= 8172 || (c < 8319
                ? (c < 8255
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8256 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8417
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)
                  : (c <= 8417 || (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)))))))
            : (c <= 8455 || (c < 11264
              ? (c < 8488
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8486
                    ? c == 8484
                    : c <= 8486)))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))))
              : (c <= 11492 || (c < 11631
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || (c < 11568
                    ? c == 11565
                    : c <= 11623)))
                : (c <= 11631 || (c < 11688
                  ? (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)))))))))
          : (c <= 11718 || (c < 42612
            ? (c < 12449
              ? (c < 12321
                ? (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)))
                : (c <= 12335 || (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)))))
              : (c <= 12538 || (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)))))))
            : (c <= 42621 || (c < 43216
              ? (c < 42963
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43052
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)
                  : (c <= 43052 || (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)))))
              : (c <= 43225 || (c < 43392
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43309 || (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)))
                : (c <= 43456 || (c < 43520
                  ? (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)
                  : (c <= 43574 || (c >= 43584 && c <= 43597)))))))))))))))
    : (c <= 43609 || (c < 71453
      ? (c < 67594
        ? (c < 65343
          ? (c < 64298
            ? (c < 43868
              ? (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))))
              : (c <= 43881 || (c < 55243
                ? (c < 44016
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)
                  : (c <= 44025 || (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)))
                : (c <= 55291 || (c < 64256
                  ? (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)
                  : (c <= 64262 || (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)))))))
            : (c <= 64310 || (c < 65056
              ? (c < 64467
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)))
                : (c <= 64605 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)))))
              : (c <= 65071 || (c < 65145
                ? (c < 65137
                  ? (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65151
                  ? (c < 65149
                    ? c == 65147
                    : c <= 65149)
                  : (c <= 65276 || (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)))))))))
          : (c <= 65343 || (c < 66504
            ? (c < 65616
              ? (c < 65498
                ? (c < 65474
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)))))
              : (c <= 65629 || (c < 66272
                ? (c < 66045
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66045 || (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)))
                : (c <= 66272 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66426 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))))))
            : (c <= 66511 || (c < 66967
              ? (c < 66816
                ? (c < 66720
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)))))
              : (c <= 66977 || (c < 67424
                ? (c < 67003
                  ? (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))
                : (c <= 67431 || (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))))))))))
        : (c <= 67637 || (c < 69942
          ? (c < 68416
            ? (c < 68096
              ? (c < 67808
                ? (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))))
              : (c <= 68099 || (c < 68159
                ? (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c < 68152
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68154)))
                : (c <= 68159 || (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))))))
            : (c <= 68437 || (c < 69415
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))))
              : (c <= 69415 || (c < 69734
                ? (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)
                  : (c <= 69572 || (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69702)))
                : (c <= 69749 || (c < 69840
                  ? (c < 69826
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69826)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))))))))
          : (c <= 69951 || (c < 70453
            ? (c < 70280
              ? (c < 70094
                ? (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))
                : (c <= 70106 || (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))))
              : (c <= 70280 || (c < 70400
                ? (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c < 70384
                    ? (c >= 70320 && c <= 70378)
                    : c <= 70393)))
                : (c <= 70403 || (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))))))
            : (c <= 70457 || (c < 70784
              ? (c < 70493
                ? (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))
                : (c <= 70499 || (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))))
              : (c <= 70853 || (c < 71168
                ? (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : c <= 71133)))
                : (c <= 71232 || (c < 71296
                  ? (c < 71248
                    ? c == 71236
                    : c <= 71257)
                  : (c <= 71352 || (c < 71424
                    ? (c >= 71360 && c <= 71369)
                    : c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(144);
      if (lookahead == '!') ADVANCE(219);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(86);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(227);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(222);
      if (lookahead == '.') ADVANCE(285);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(142)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(50)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(50)
      if (lookahead == '\r') SKIP(1)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(54)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(54)
      if (lookahead == '\r') SKIP(3)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(53)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(53)
      if (lookahead == '\r') SKIP(5)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(56)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(56)
      if (lookahead == '\r') SKIP(7)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(52)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(52)
      if (lookahead == '\r') SKIP(9)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(58)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(58)
      if (lookahead == '\r') SKIP(11)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(62)
      if (lookahead == '\r') SKIP(13)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(63)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(63)
      if (lookahead == '\r') SKIP(15)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(68)
      if (lookahead == '\r') SKIP(17)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(67)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(67)
      if (lookahead == '\r') SKIP(19)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(61)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(61)
      if (lookahead == '\r') SKIP(21)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(60)
      if (lookahead == '\r') SKIP(23)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(59)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(59)
      if (lookahead == '\r') SKIP(25)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(64)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(64)
      if (lookahead == '\r') SKIP(27)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(57)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(57)
      if (lookahead == '\r') SKIP(29)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(33)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(33)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(154);
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '%') ADVANCE(235);
      if (lookahead == '&') ADVANCE(244);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == '-') ADVANCE(221);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '<') ADVANCE(253);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(249);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(241);
      if (lookahead == '|') ADVANCE(240);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(66)
      if (lookahead == '\r') SKIP(34)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 36:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '\r') ADVANCE(40);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(174);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(77)
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 37:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '\r') ADVANCE(40);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(174);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(77)
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 38:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '\r') ADVANCE(39);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '\\') SKIP(45)
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(70)
      END_STATE();
    case 39:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '\\') SKIP(45)
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70)
      END_STATE();
    case 40:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(174);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(77)
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(65)
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(42);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(322);
      if (lookahead != 0) ADVANCE(323);
      END_STATE();
    case 42:
      if (lookahead == '\n') ADVANCE(325);
      if (lookahead == '\r') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(139);
      if (lookahead == 'u') ADVANCE(131);
      if (lookahead == 'x') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(327);
      if (lookahead != 0) ADVANCE(324);
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(69)
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '/') ADVANCE(312);
      if (lookahead == '\\') ADVANCE(311);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(313);
      if (lookahead != 0) ADVANCE(310);
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(70)
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(70)
      if (lookahead == '\r') SKIP(44)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(51)
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(51)
      if (lookahead == '\r') SKIP(46)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(55)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(55)
      if (lookahead == '\r') SKIP(48)
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 50:
      if (lookahead == '!') ADVANCE(219);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(86);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(227);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(222);
      if (lookahead == '.') ADVANCE(285);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 51:
      if (lookahead == '!') ADVANCE(219);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(98);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(227);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(222);
      if (lookahead == '.') ADVANCE(285);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(264);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 52:
      if (lookahead == '!') ADVANCE(219);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(104);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(227);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(222);
      if (lookahead == '.') ADVANCE(286);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(264);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 53:
      if (lookahead == '!') ADVANCE(218);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(86);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(223);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 54:
      if (lookahead == '!') ADVANCE(218);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(92);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(223);
      if (lookahead == '.') ADVANCE(286);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '=') ADVANCE(267);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(263);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 55:
      if (lookahead == '!') ADVANCE(218);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(88);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == '-') ADVANCE(223);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 56:
      if (lookahead == '!') ADVANCE(218);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(90);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == '-') ADVANCE(223);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 57:
      if (lookahead == '!') ADVANCE(218);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '+') ADVANCE(230);
      if (lookahead == '-') ADVANCE(225);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == 'L') ADVANCE(339);
      if (lookahead == 'U') ADVANCE(340);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == 'u') ADVANCE(338);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 58:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(98);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(224);
      if (lookahead == '.') ADVANCE(284);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(331);
      if (lookahead == 'U') ADVANCE(333);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(335);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58)
      END_STATE();
    case 59:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(104);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(224);
      if (lookahead == '.') ADVANCE(283);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(331);
      if (lookahead == 'U') ADVANCE(333);
      if (lookahead == '[') ADVANCE(264);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(335);
      if (lookahead == '|') ADVANCE(239);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59)
      END_STATE();
    case 60:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '#') ADVANCE(98);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(224);
      if (lookahead == '.') ADVANCE(283);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == '[') ADVANCE(264);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(60)
      END_STATE();
    case 61:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '#') ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(224);
      if (lookahead == '.') ADVANCE(284);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61)
      END_STATE();
    case 62:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(224);
      if (lookahead == '.') ADVANCE(284);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62)
      END_STATE();
    case 63:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(235);
      if (lookahead == '&') ADVANCE(244);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(221);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '<') ADVANCE(253);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(249);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '^') ADVANCE(241);
      if (lookahead == '|') ADVANCE(240);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 64:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '#') ADVANCE(104);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(224);
      if (lookahead == '.') ADVANCE(284);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == '[') ADVANCE(264);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == '|') ADVANCE(239);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(42);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65)
      END_STATE();
    case 66:
      if (lookahead == '"') ADVANCE(318);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == 'L') ADVANCE(331);
      if (lookahead == 'U') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == 'u') ADVANCE(335);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66)
      END_STATE();
    case 67:
      if (lookahead == '#') ADVANCE(93);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '}') ADVANCE(263);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67)
      END_STATE();
    case 68:
      if (lookahead == '#') ADVANCE(89);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(342);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(18);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(68)
      END_STATE();
    case 69:
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(42);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(69)
      END_STATE();
    case 70:
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '\\') SKIP(45)
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70)
      END_STATE();
    case 71:
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '/') ADVANCE(347);
      END_STATE();
    case 72:
      if (lookahead == '*') ADVANCE(72);
      if (lookahead == '/') ADVANCE(343);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 73:
      if (lookahead == '*') ADVANCE(72);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 74:
      if (lookahead == '*') ADVANCE(72);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 75:
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(289);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(290);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      END_STATE();
    case 76:
      if (lookahead == '.') ADVANCE(149);
      END_STATE();
    case 77:
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(174);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(77)
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 78:
      if (lookahead == ':') ADVANCE(259);
      END_STATE();
    case 79:
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 80:
      if (lookahead == '=') ADVANCE(246);
      END_STATE();
    case 81:
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 82:
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 83:
      if (lookahead == 'U') ADVANCE(138);
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 84:
      if (lookahead == '[') ADVANCE(260);
      END_STATE();
    case 85:
      if (lookahead == ']') ADVANCE(261);
      END_STATE();
    case 86:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(210);
      if (lookahead == 'i') ADVANCE(196);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 87:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(210);
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 88:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'i') ADVANCE(196);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 89:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 90:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(212);
      if (lookahead == 'i') ADVANCE(196);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(212);
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'i') ADVANCE(196);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(188);
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(114);
      END_STATE();
    case 95:
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 96:
      if (lookahead == 'd') ADVANCE(103);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(116);
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(97);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(98);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      END_STATE();
    case 105:
      if (lookahead == 'f') ADVANCE(164);
      END_STATE();
    case 106:
      if (lookahead == 'f') ADVANCE(155);
      END_STATE();
    case 107:
      if (lookahead == 'f') ADVANCE(167);
      END_STATE();
    case 108:
      if (lookahead == 'f') ADVANCE(169);
      END_STATE();
    case 109:
      if (lookahead == 'f') ADVANCE(163);
      END_STATE();
    case 110:
      if (lookahead == 'f') ADVANCE(153);
      END_STATE();
    case 111:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 112:
      if (lookahead == 'f') ADVANCE(159);
      END_STATE();
    case 113:
      if (lookahead == 'i') ADVANCE(105);
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 114:
      if (lookahead == 'i') ADVANCE(106);
      END_STATE();
    case 115:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(113);
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(115);
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(288);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(290);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(342);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(296);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(294);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(324);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 128:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 129:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(127);
      END_STATE();
    case 130:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(128);
      END_STATE();
    case 131:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(129);
      END_STATE();
    case 132:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 133:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(131);
      END_STATE();
    case 134:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(132);
      END_STATE();
    case 135:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(133);
      END_STATE();
    case 136:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      END_STATE();
    case 137:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 138:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 139:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 140:
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(347);
      if (lookahead == '\r') ADVANCE(351);
      if (lookahead == '\\') ADVANCE(349);
      END_STATE();
    case 141:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(177);
      END_STATE();
    case 142:
      if (eof) ADVANCE(144);
      if (lookahead == '!') ADVANCE(219);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(86);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '&') ADVANCE(245);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '+') ADVANCE(227);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(222);
      if (lookahead == '.') ADVANCE(285);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == '=') ADVANCE(268);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == '?') ADVANCE(270);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == '^') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(239);
      if (lookahead == '}') ADVANCE(263);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(142)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 143:
      if (eof) ADVANCE(144);
      if (lookahead == '!') ADVANCE(218);
      if (lookahead == '"') ADVANCE(318);
      if (lookahead == '#') ADVANCE(92);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(342);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(309);
      if (lookahead == '(') ADVANCE(217);
      if (lookahead == ')') ADVANCE(151);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == ',') ADVANCE(150);
      if (lookahead == '-') ADVANCE(223);
      if (lookahead == '.') ADVANCE(286);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == ':') ADVANCE(269);
      if (lookahead == ';') ADVANCE(258);
      if (lookahead == '=') ADVANCE(267);
      if (lookahead == 'L') ADVANCE(330);
      if (lookahead == 'U') ADVANCE(332);
      if (lookahead == '[') ADVANCE(265);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(266);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(263);
      if (lookahead == '~') ADVANCE(220);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(143)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(192);
      if (lookahead == 'n') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(102);
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(100);
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(343);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(347);
      if (lookahead == '\r') ADVANCE(344);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(348);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(77)
      if (lookahead == '\r') ADVANCE(175);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(77)
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '*' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(172);
      if (lookahead == '\r') ADVANCE(181);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(177);
      if (lookahead == '\r') ADVANCE(182);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(346);
      if (lookahead == '\r') ADVANCE(350);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(348);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(172);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(178);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(177);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(179);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'n') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(199);
      if (lookahead == 's') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(205);
      if (lookahead == 's') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(281);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '>') ADVANCE(287);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(281);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(291);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(281);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '>') ADVANCE(287);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(291);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(291);
      if (lookahead == '=') ADVANCE(274);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(291);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == '=') ADVANCE(274);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(291);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(271);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '/') ADVANCE(347);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '/') ADVANCE(347);
      if (lookahead == '=') ADVANCE(272);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(273);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(280);
      if (lookahead == '|') ADVANCE(237);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(237);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(279);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(238);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(238);
      if (lookahead == '=') ADVANCE(278);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(250);
      if (lookahead == '>') ADVANCE(257);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(250);
      if (lookahead == '>') ADVANCE(256);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(255);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(254);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(276);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(277);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(260);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(246);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(76);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(288);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(288);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(119);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(288);
      if (sym_number_literal_character_set_1(lookahead)) ADVANCE(304);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(298);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(123);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(299);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(290);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'A' ||
          lookahead == 'C' ||
          lookahead == 'a' ||
          lookahead == 'c') ADVANCE(299);
      if (('B' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(300);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(75);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(301);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(303);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(123);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(301);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (sym_number_literal_character_set_1(lookahead)) ADVANCE(304);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(124);
      if (lookahead == 'B' ||
          lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'b' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(294);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(294);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(122);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(124);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(295);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(296);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(296);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(122);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(295);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(296);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(296);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(124);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(299);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'A' ||
          lookahead == 'C' ||
          lookahead == 'a' ||
          lookahead == 'c') ADVANCE(299);
      if (('B' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(290);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '.') ADVANCE(302);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(299);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(292);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (sym_number_literal_character_set_2(lookahead)) ADVANCE(304);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(124);
      if (lookahead == 'B' ||
          lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'b' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(294);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(294);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(295);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(301);
      if (lookahead == 'B' ||
          ('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(296);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'W' ||
          lookahead == 'l' ||
          lookahead == 'u' ||
          lookahead == 'w') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(296);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (sym_number_literal_character_set_2(lookahead)) ADVANCE(304);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_number_literal);
      if (sym_number_literal_character_set_2(lookahead)) ADVANCE(304);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_L_SQUOTE);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_u_SQUOTE);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_U_SQUOTE);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_u8_SQUOTE);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\n') ADVANCE(325);
      if (lookahead == '\r') ADVANCE(324);
      if (lookahead == 'U') ADVANCE(139);
      if (lookahead == 'u') ADVANCE(131);
      if (lookahead == 'x') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(327);
      if (lookahead != 0) ADVANCE(324);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '/') ADVANCE(347);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\\') ADVANCE(42);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(321);
      if (lookahead == '/') ADVANCE(323);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(323);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(320);
      if (lookahead == '/') ADVANCE(323);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(321);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(320);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(321);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(322);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(323);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(323);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(42);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(326);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(314);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(314);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(316);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(316);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(315);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(306);
      if (lookahead == '8') ADVANCE(336);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(315);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(342);
      if (lookahead == '8') ADVANCE(337);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(317);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(308);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(317);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(306);
      if (lookahead == '8') ADVANCE(341);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\'') ADVANCE(308);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(342);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(347);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(346);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(346);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(347);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(346);
      if (lookahead == '\r') ADVANCE(350);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(348);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(347);
      if (lookahead == '\r') ADVANCE(351);
      if (lookahead == '\\') ADVANCE(349);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(346);
      if (lookahead == '/') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(180);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(347);
      if (lookahead == '\\') ADVANCE(140);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'U') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'R') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 5:
      if (lookahead == 'A') ADVANCE(29);
      if (lookahead == 'G') ADVANCE(30);
      if (lookahead == 'N') ADVANCE(31);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'l') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(67);
      if (lookahead == 'y') ADVANCE(68);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'L') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'U') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'b') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(82);
      if (lookahead == 'd') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(84);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'i') ADVANCE(86);
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      if (lookahead == 's') ADVANCE(89);
      if (lookahead == 't') ADVANCE(90);
      if (lookahead == 'u') ADVANCE(91);
      if (lookahead == 'v') ADVANCE(92);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(96);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(118);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(124);
      if (lookahead == 'z') ADVANCE(125);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 73:
      if (lookahead == 'S') ADVANCE(139);
      END_STATE();
    case 74:
      if (lookahead == 'L') ADVANCE(140);
      END_STATE();
    case 75:
      if (lookahead == 'E') ADVANCE(141);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'x') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(157);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(160);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(164);
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(169);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(170);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(175);
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(179);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 106:
      if (lookahead == 'm') ADVANCE(181);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(186);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(187);
      if (lookahead == '3') ADVANCE(188);
      if (lookahead == '6') ADVANCE(189);
      if (lookahead == '8') ADVANCE(190);
      if (lookahead == 'p') ADVANCE(191);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(192);
      END_STATE();
    case 115:
      if (lookahead == '_') ADVANCE(193);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(197);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(200);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 126:
      if (lookahead == 'z') ADVANCE(204);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 135:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(213);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 139:
      if (lookahead == 'E') ADVANCE(215);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 143:
      if (lookahead == 'm') ADVANCE(217);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 147:
      if (lookahead == 'm') ADVANCE(221);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(222);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(227);
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(229);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 161:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(237);
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 163:
      if (lookahead == 'y') ADVANCE(239);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 167:
      if (lookahead == 'g') ADVANCE(243);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_auto);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_primitive_type);
      END_STATE();
    case 172:
      if (lookahead == 'k') ADVANCE(246);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(247);
      if (lookahead == '3') ADVANCE(248);
      if (lookahead == '6') ADVANCE(249);
      if (lookahead == '8') ADVANCE(250);
      if (lookahead == 'p') ADVANCE(251);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 176:
      if (lookahead == 'i') ADVANCE(253);
      END_STATE();
    case 177:
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 179:
      if (lookahead == 'l') ADVANCE(256);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 186:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 187:
      if (lookahead == '6') ADVANCE(259);
      END_STATE();
    case 188:
      if (lookahead == '2') ADVANCE(260);
      END_STATE();
    case 189:
      if (lookahead == '4') ADVANCE(261);
      END_STATE();
    case 190:
      if (lookahead == '_') ADVANCE(262);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 195:
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 197:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 198:
      if (lookahead == 's') ADVANCE(269);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 200:
      if (lookahead == 'r') ADVANCE(271);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 203:
      if (lookahead == '_') ADVANCE(274);
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(277);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(278);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(279);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 210:
      if (lookahead == '1') ADVANCE(282);
      if (lookahead == '3') ADVANCE(283);
      if (lookahead == '6') ADVANCE(284);
      if (lookahead == '8') ADVANCE(285);
      if (lookahead == 'p') ADVANCE(286);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 212:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(291);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(294);
      END_STATE();
    case 220:
      if (lookahead == 'g') ADVANCE(295);
      END_STATE();
    case 221:
      if (lookahead == '_') ADVANCE(296);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(298);
      END_STATE();
    case 224:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 225:
      if (lookahead == 'c') ADVANCE(300);
      END_STATE();
    case 226:
      if (lookahead == 'l') ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 229:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 230:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 231:
      if (lookahead == 'c') ADVANCE(306);
      END_STATE();
    case 232:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 233:
      if (lookahead == 'v') ADVANCE(308);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 236:
      if (lookahead == 'c') ADVANCE(311);
      END_STATE();
    case 237:
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym___try);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 241:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 242:
      if (lookahead == 't') ADVANCE(316);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(318);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(319);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 247:
      if (lookahead == '6') ADVANCE(320);
      END_STATE();
    case 248:
      if (lookahead == '2') ADVANCE(321);
      END_STATE();
    case 249:
      if (lookahead == '4') ADVANCE(322);
      END_STATE();
    case 250:
      if (lookahead == '_') ADVANCE(323);
      END_STATE();
    case 251:
      if (lookahead == 't') ADVANCE(324);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 254:
      if (lookahead == 'l') ADVANCE(327);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(328);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(329);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 259:
      if (lookahead == '_') ADVANCE(331);
      END_STATE();
    case 260:
      if (lookahead == '_') ADVANCE(332);
      END_STATE();
    case 261:
      if (lookahead == '_') ADVANCE(333);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(334);
      END_STATE();
    case 264:
      if (lookahead == 'l') ADVANCE(335);
      END_STATE();
    case 265:
      if (lookahead == 'u') ADVANCE(336);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(337);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(338);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(339);
      END_STATE();
    case 269:
      if (lookahead == 't') ADVANCE(340);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(341);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(342);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 273:
      if (lookahead == 'd') ADVANCE(343);
      END_STATE();
    case 274:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 275:
      if (lookahead == 'f') ADVANCE(344);
      END_STATE();
    case 276:
      if (lookahead == '_') ADVANCE(345);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(346);
      END_STATE();
    case 278:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 279:
      if (lookahead == 'h') ADVANCE(348);
      END_STATE();
    case 280:
      if (lookahead == 'd') ADVANCE(349);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 282:
      if (lookahead == '6') ADVANCE(351);
      END_STATE();
    case 283:
      if (lookahead == '2') ADVANCE(352);
      END_STATE();
    case 284:
      if (lookahead == '4') ADVANCE(353);
      END_STATE();
    case 285:
      if (lookahead == '_') ADVANCE(354);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 288:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(357);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 291:
      if (lookahead == 'o') ADVANCE(358);
      END_STATE();
    case 292:
      if (lookahead == 'c') ADVANCE(359);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(360);
      END_STATE();
    case 294:
      if (lookahead == 'u') ADVANCE(361);
      END_STATE();
    case 295:
      if (lookahead == 'n') ADVANCE(362);
      END_STATE();
    case 296:
      if (lookahead == '_') ADVANCE(363);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(364);
      END_STATE();
    case 298:
      if (lookahead == 'd') ADVANCE(365);
      END_STATE();
    case 299:
      if (lookahead == 'l') ADVANCE(366);
      END_STATE();
    case 300:
      if (lookahead == 'a') ADVANCE(367);
      END_STATE();
    case 301:
      if (lookahead == 's') ADVANCE(368);
      END_STATE();
    case 302:
      if (lookahead == 'p') ADVANCE(369);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(370);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(371);
      END_STATE();
    case 305:
      if (lookahead == 'l') ADVANCE(372);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(376);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_ms_signed_ptr_modifier);
      END_STATE();
    case 311:
      if (lookahead == 'a') ADVANCE(377);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(378);
      END_STATE();
    case 313:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(380);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_ms_unsigned_ptr_modifier);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(381);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 318:
      if (lookahead == 'g') ADVANCE(383);
      END_STATE();
    case 319:
      if (lookahead == 'f') ADVANCE(384);
      END_STATE();
    case 320:
      if (lookahead == '_') ADVANCE(385);
      END_STATE();
    case 321:
      if (lookahead == '_') ADVANCE(386);
      END_STATE();
    case 322:
      if (lookahead == '_') ADVANCE(387);
      END_STATE();
    case 323:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 324:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 325:
      if (lookahead == 'x') ADVANCE(389);
      END_STATE();
    case 326:
      if (lookahead == 'u') ADVANCE(390);
      END_STATE();
    case 327:
      if (lookahead == 't') ADVANCE(391);
      END_STATE();
    case 328:
      if (lookahead == 'd') ADVANCE(392);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 331:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 334:
      if (lookahead == '_') ADVANCE(393);
      END_STATE();
    case 335:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 336:
      if (lookahead == 'r') ADVANCE(395);
      END_STATE();
    case 337:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 338:
      if (lookahead == 'o') ADVANCE(397);
      END_STATE();
    case 339:
      if (lookahead == 'f') ADVANCE(398);
      END_STATE();
    case 340:
      if (lookahead == 'e') ADVANCE(399);
      END_STATE();
    case 341:
      if (lookahead == 'c') ADVANCE(400);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 345:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 349:
      if (lookahead == '_') ADVANCE(401);
      END_STATE();
    case 350:
      if (lookahead == 'f') ADVANCE(402);
      END_STATE();
    case 351:
      if (lookahead == '_') ADVANCE(403);
      END_STATE();
    case 352:
      if (lookahead == '_') ADVANCE(404);
      END_STATE();
    case 353:
      if (lookahead == '_') ADVANCE(405);
      END_STATE();
    case 354:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 355:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(407);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(408);
      END_STATE();
    case 358:
      if (lookahead == 'f') ADVANCE(409);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym__Atomic);
      END_STATE();
    case 360:
      if (lookahead == 'c') ADVANCE(410);
      END_STATE();
    case 361:
      if (lookahead == 'r') ADVANCE(411);
      END_STATE();
    case 362:
      if (lookahead == 'o') ADVANCE(412);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym___asm__);
      END_STATE();
    case 364:
      if (lookahead == 'b') ADVANCE(413);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym___based);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym___cdecl);
      END_STATE();
    case 367:
      if (lookahead == 'l') ADVANCE(414);
      END_STATE();
    case 368:
      if (lookahead == 'p') ADVANCE(415);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 370:
      if (lookahead == 's') ADVANCE(417);
      END_STATE();
    case 371:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 372:
      if (lookahead == 'l') ADVANCE(419);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(420);
      END_STATE();
    case 374:
      if (lookahead == 'e') ADVANCE(421);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym___leave);
      END_STATE();
    case 376:
      if (lookahead == 'i') ADVANCE(422);
      END_STATE();
    case 377:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 378:
      if (lookahead == 'a') ADVANCE(424);
      END_STATE();
    case 379:
      if (lookahead == 'd') ADVANCE(425);
      END_STATE();
    case 380:
      if (lookahead == 'g') ADVANCE(426);
      END_STATE();
    case 381:
      if (lookahead == 'r') ADVANCE(427);
      END_STATE();
    case 382:
      if (lookahead == 'f') ADVANCE(428);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(429);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_alignof);
      END_STATE();
    case 385:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 388:
      if (lookahead == '_') ADVANCE(430);
      END_STATE();
    case 389:
      if (lookahead == 'p') ADVANCE(431);
      END_STATE();
    case 390:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 394:
      if (lookahead == 'g') ADVANCE(433);
      END_STATE();
    case 395:
      if (lookahead == 'n') ADVANCE(434);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_nullptr);
      if (lookahead == '_') ADVANCE(435);
      END_STATE();
    case 397:
      if (lookahead == 'f') ADVANCE(436);
      END_STATE();
    case 398:
      if (lookahead == '_') ADVANCE(437);
      END_STATE();
    case 399:
      if (lookahead == 'r') ADVANCE(438);
      END_STATE();
    case 400:
      if (lookahead == 't') ADVANCE(439);
      END_STATE();
    case 401:
      if (lookahead == 'l') ADVANCE(440);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 403:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 406:
      if (lookahead == '_') ADVANCE(441);
      END_STATE();
    case 407:
      if (lookahead == 'd') ADVANCE(442);
      END_STATE();
    case 408:
      if (lookahead == 'e') ADVANCE(443);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym__Alignof);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym__Generic);
      END_STATE();
    case 411:
      if (lookahead == 'n') ADVANCE(444);
      END_STATE();
    case 412:
      if (lookahead == 'f') ADVANCE(445);
      END_STATE();
    case 413:
      if (lookahead == 'u') ADVANCE(446);
      END_STATE();
    case 414:
      if (lookahead == 'l') ADVANCE(447);
      END_STATE();
    case 415:
      if (lookahead == 'e') ADVANCE(448);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym___except);
      END_STATE();
    case 417:
      if (lookahead == 'i') ADVANCE(449);
      END_STATE();
    case 418:
      if (lookahead == 'l') ADVANCE(450);
      END_STATE();
    case 419:
      if (lookahead == 'y') ADVANCE(451);
      END_STATE();
    case 420:
      if (lookahead == 'n') ADVANCE(452);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym___inline);
      if (lookahead == '_') ADVANCE(453);
      END_STATE();
    case 422:
      if (lookahead == 'c') ADVANCE(454);
      END_STATE();
    case 423:
      if (lookahead == 'l') ADVANCE(455);
      END_STATE();
    case 424:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym___thread);
      END_STATE();
    case 426:
      if (lookahead == 'n') ADVANCE(457);
      END_STATE();
    case 427:
      if (lookahead == 'c') ADVANCE(458);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym__alignof);
      END_STATE();
    case 429:
      if (lookahead == 'e') ADVANCE(459);
      END_STATE();
    case 430:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 431:
      if (lookahead == 'r') ADVANCE(460);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 433:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_noreturn);
      END_STATE();
    case 435:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_offsetof);
      END_STATE();
    case 437:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_register);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_restrict);
      END_STATE();
    case 440:
      if (lookahead == 'o') ADVANCE(462);
      END_STATE();
    case 441:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym__Noreturn);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym___alignof);
      if (lookahead == '_') ADVANCE(463);
      END_STATE();
    case 446:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym___clrcall);
      END_STATE();
    case 448:
      if (lookahead == 'c') ADVANCE(465);
      END_STATE();
    case 449:
      if (lookahead == 'o') ADVANCE(466);
      END_STATE();
    case 450:
      if (lookahead == 'l') ADVANCE(467);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym___finally);
      END_STATE();
    case 452:
      if (lookahead == 'l') ADVANCE(468);
      END_STATE();
    case 453:
      if (lookahead == '_') ADVANCE(469);
      END_STATE();
    case 454:
      if (lookahead == 't') ADVANCE(470);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym___stdcall);
      END_STATE();
    case 456:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 457:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 458:
      if (lookahead == 'a') ADVANCE(473);
      END_STATE();
    case 459:
      if (lookahead == 'd') ADVANCE(474);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_constexpr);
      END_STATE();
    case 461:
      if (lookahead == '_') ADVANCE(475);
      END_STATE();
    case 462:
      if (lookahead == 'c') ADVANCE(476);
      END_STATE();
    case 463:
      if (lookahead == '_') ADVANCE(477);
      END_STATE();
    case 464:
      if (lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym___declspec);
      END_STATE();
    case 466:
      if (lookahead == 'n') ADVANCE(479);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym___fastcall);
      END_STATE();
    case 468:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym___inline__);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_ms_restrict_modifier);
      if (lookahead == '_') ADVANCE(481);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym___thiscall);
      END_STATE();
    case 472:
      if (lookahead == 'd') ADVANCE(482);
      END_STATE();
    case 473:
      if (lookahead == 'l') ADVANCE(483);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym__unaligned);
      END_STATE();
    case 475:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 476:
      if (lookahead == 'a') ADVANCE(484);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym___alignof__);
      END_STATE();
    case 478:
      if (lookahead == '_') ADVANCE(485);
      END_STATE();
    case 479:
      if (lookahead == '_') ADVANCE(486);
      END_STATE();
    case 480:
      if (lookahead == 'n') ADVANCE(487);
      END_STATE();
    case 481:
      if (lookahead == '_') ADVANCE(488);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym___unaligned);
      END_STATE();
    case 483:
      if (lookahead == 'l') ADVANCE(489);
      END_STATE();
    case 484:
      if (lookahead == 'l') ADVANCE(490);
      END_STATE();
    case 485:
      if (lookahead == '_') ADVANCE(491);
      END_STATE();
    case 486:
      if (lookahead == '_') ADVANCE(492);
      END_STATE();
    case 487:
      if (lookahead == 'e') ADVANCE(493);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym___restrict__);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym___vectorcall);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_thread_local);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym___attribute__);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym___extension__);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym___forceinline);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 143},
  [2] = {.lex_state = 53},
  [3] = {.lex_state = 53},
  [4] = {.lex_state = 53},
  [5] = {.lex_state = 53},
  [6] = {.lex_state = 53},
  [7] = {.lex_state = 53},
  [8] = {.lex_state = 53},
  [9] = {.lex_state = 53},
  [10] = {.lex_state = 53},
  [11] = {.lex_state = 53},
  [12] = {.lex_state = 56},
  [13] = {.lex_state = 56},
  [14] = {.lex_state = 56},
  [15] = {.lex_state = 56},
  [16] = {.lex_state = 56},
  [17] = {.lex_state = 56},
  [18] = {.lex_state = 56},
  [19] = {.lex_state = 56},
  [20] = {.lex_state = 56},
  [21] = {.lex_state = 56},
  [22] = {.lex_state = 56},
  [23] = {.lex_state = 56},
  [24] = {.lex_state = 56},
  [25] = {.lex_state = 56},
  [26] = {.lex_state = 53},
  [27] = {.lex_state = 56},
  [28] = {.lex_state = 143},
  [29] = {.lex_state = 143},
  [30] = {.lex_state = 143},
  [31] = {.lex_state = 143},
  [32] = {.lex_state = 143},
  [33] = {.lex_state = 143},
  [34] = {.lex_state = 143},
  [35] = {.lex_state = 143},
  [36] = {.lex_state = 143},
  [37] = {.lex_state = 143},
  [38] = {.lex_state = 143},
  [39] = {.lex_state = 143},
  [40] = {.lex_state = 143},
  [41] = {.lex_state = 143},
  [42] = {.lex_state = 143},
  [43] = {.lex_state = 143},
  [44] = {.lex_state = 143},
  [45] = {.lex_state = 55},
  [46] = {.lex_state = 143},
  [47] = {.lex_state = 55},
  [48] = {.lex_state = 143},
  [49] = {.lex_state = 55},
  [50] = {.lex_state = 143},
  [51] = {.lex_state = 143},
  [52] = {.lex_state = 143},
  [53] = {.lex_state = 143},
  [54] = {.lex_state = 53},
  [55] = {.lex_state = 53},
  [56] = {.lex_state = 53},
  [57] = {.lex_state = 53},
  [58] = {.lex_state = 53},
  [59] = {.lex_state = 56},
  [60] = {.lex_state = 56},
  [61] = {.lex_state = 56},
  [62] = {.lex_state = 56},
  [63] = {.lex_state = 56},
  [64] = {.lex_state = 143},
  [65] = {.lex_state = 55},
  [66] = {.lex_state = 55},
  [67] = {.lex_state = 143},
  [68] = {.lex_state = 143},
  [69] = {.lex_state = 143},
  [70] = {.lex_state = 143},
  [71] = {.lex_state = 143},
  [72] = {.lex_state = 143},
  [73] = {.lex_state = 55},
  [74] = {.lex_state = 143},
  [75] = {.lex_state = 143},
  [76] = {.lex_state = 143},
  [77] = {.lex_state = 55},
  [78] = {.lex_state = 55},
  [79] = {.lex_state = 143},
  [80] = {.lex_state = 143},
  [81] = {.lex_state = 143},
  [82] = {.lex_state = 143},
  [83] = {.lex_state = 143},
  [84] = {.lex_state = 143},
  [85] = {.lex_state = 143},
  [86] = {.lex_state = 143},
  [87] = {.lex_state = 143},
  [88] = {.lex_state = 143},
  [89] = {.lex_state = 143},
  [90] = {.lex_state = 53},
  [91] = {.lex_state = 53},
  [92] = {.lex_state = 53},
  [93] = {.lex_state = 143},
  [94] = {.lex_state = 53},
  [95] = {.lex_state = 53},
  [96] = {.lex_state = 53},
  [97] = {.lex_state = 53},
  [98] = {.lex_state = 53},
  [99] = {.lex_state = 53},
  [100] = {.lex_state = 53},
  [101] = {.lex_state = 53},
  [102] = {.lex_state = 53},
  [103] = {.lex_state = 53},
  [104] = {.lex_state = 53},
  [105] = {.lex_state = 53},
  [106] = {.lex_state = 53},
  [107] = {.lex_state = 143},
  [108] = {.lex_state = 53},
  [109] = {.lex_state = 53},
  [110] = {.lex_state = 53},
  [111] = {.lex_state = 53},
  [112] = {.lex_state = 53},
  [113] = {.lex_state = 53},
  [114] = {.lex_state = 53},
  [115] = {.lex_state = 53},
  [116] = {.lex_state = 53},
  [117] = {.lex_state = 53},
  [118] = {.lex_state = 53},
  [119] = {.lex_state = 53},
  [120] = {.lex_state = 53},
  [121] = {.lex_state = 53},
  [122] = {.lex_state = 53},
  [123] = {.lex_state = 53},
  [124] = {.lex_state = 53},
  [125] = {.lex_state = 53},
  [126] = {.lex_state = 53},
  [127] = {.lex_state = 53},
  [128] = {.lex_state = 53},
  [129] = {.lex_state = 53},
  [130] = {.lex_state = 53},
  [131] = {.lex_state = 53},
  [132] = {.lex_state = 53},
  [133] = {.lex_state = 53},
  [134] = {.lex_state = 53},
  [135] = {.lex_state = 56},
  [136] = {.lex_state = 53},
  [137] = {.lex_state = 53},
  [138] = {.lex_state = 53},
  [139] = {.lex_state = 53},
  [140] = {.lex_state = 53},
  [141] = {.lex_state = 53},
  [142] = {.lex_state = 53},
  [143] = {.lex_state = 53},
  [144] = {.lex_state = 53},
  [145] = {.lex_state = 53},
  [146] = {.lex_state = 53},
  [147] = {.lex_state = 53},
  [148] = {.lex_state = 53},
  [149] = {.lex_state = 53},
  [150] = {.lex_state = 53},
  [151] = {.lex_state = 53},
  [152] = {.lex_state = 53},
  [153] = {.lex_state = 53},
  [154] = {.lex_state = 53},
  [155] = {.lex_state = 53},
  [156] = {.lex_state = 53},
  [157] = {.lex_state = 53},
  [158] = {.lex_state = 53},
  [159] = {.lex_state = 53},
  [160] = {.lex_state = 53},
  [161] = {.lex_state = 56},
  [162] = {.lex_state = 56},
  [163] = {.lex_state = 56},
  [164] = {.lex_state = 56},
  [165] = {.lex_state = 56},
  [166] = {.lex_state = 56},
  [167] = {.lex_state = 56},
  [168] = {.lex_state = 56},
  [169] = {.lex_state = 56},
  [170] = {.lex_state = 56},
  [171] = {.lex_state = 56},
  [172] = {.lex_state = 56},
  [173] = {.lex_state = 56},
  [174] = {.lex_state = 56},
  [175] = {.lex_state = 56},
  [176] = {.lex_state = 56},
  [177] = {.lex_state = 56},
  [178] = {.lex_state = 56},
  [179] = {.lex_state = 56},
  [180] = {.lex_state = 56},
  [181] = {.lex_state = 56},
  [182] = {.lex_state = 56},
  [183] = {.lex_state = 56},
  [184] = {.lex_state = 56},
  [185] = {.lex_state = 56},
  [186] = {.lex_state = 56},
  [187] = {.lex_state = 56},
  [188] = {.lex_state = 56},
  [189] = {.lex_state = 56},
  [190] = {.lex_state = 56},
  [191] = {.lex_state = 56},
  [192] = {.lex_state = 56},
  [193] = {.lex_state = 56},
  [194] = {.lex_state = 56},
  [195] = {.lex_state = 56},
  [196] = {.lex_state = 56},
  [197] = {.lex_state = 56},
  [198] = {.lex_state = 56},
  [199] = {.lex_state = 56},
  [200] = {.lex_state = 56},
  [201] = {.lex_state = 56},
  [202] = {.lex_state = 56},
  [203] = {.lex_state = 56},
  [204] = {.lex_state = 56},
  [205] = {.lex_state = 56},
  [206] = {.lex_state = 56},
  [207] = {.lex_state = 56},
  [208] = {.lex_state = 56},
  [209] = {.lex_state = 56},
  [210] = {.lex_state = 56},
  [211] = {.lex_state = 55},
  [212] = {.lex_state = 56},
  [213] = {.lex_state = 56},
  [214] = {.lex_state = 56},
  [215] = {.lex_state = 143},
  [216] = {.lex_state = 56},
  [217] = {.lex_state = 56},
  [218] = {.lex_state = 56},
  [219] = {.lex_state = 56},
  [220] = {.lex_state = 56},
  [221] = {.lex_state = 56},
  [222] = {.lex_state = 56},
  [223] = {.lex_state = 56},
  [224] = {.lex_state = 56},
  [225] = {.lex_state = 56},
  [226] = {.lex_state = 56},
  [227] = {.lex_state = 56},
  [228] = {.lex_state = 56},
  [229] = {.lex_state = 143},
  [230] = {.lex_state = 56},
  [231] = {.lex_state = 143},
  [232] = {.lex_state = 55},
  [233] = {.lex_state = 143},
  [234] = {.lex_state = 143},
  [235] = {.lex_state = 143},
  [236] = {.lex_state = 143},
  [237] = {.lex_state = 143},
  [238] = {.lex_state = 143},
  [239] = {.lex_state = 143},
  [240] = {.lex_state = 51},
  [241] = {.lex_state = 143},
  [242] = {.lex_state = 143},
  [243] = {.lex_state = 143},
  [244] = {.lex_state = 143},
  [245] = {.lex_state = 143},
  [246] = {.lex_state = 143},
  [247] = {.lex_state = 143},
  [248] = {.lex_state = 143},
  [249] = {.lex_state = 143},
  [250] = {.lex_state = 143},
  [251] = {.lex_state = 143},
  [252] = {.lex_state = 143},
  [253] = {.lex_state = 143},
  [254] = {.lex_state = 143},
  [255] = {.lex_state = 143},
  [256] = {.lex_state = 143},
  [257] = {.lex_state = 143},
  [258] = {.lex_state = 143},
  [259] = {.lex_state = 143},
  [260] = {.lex_state = 143},
  [261] = {.lex_state = 143},
  [262] = {.lex_state = 143},
  [263] = {.lex_state = 143},
  [264] = {.lex_state = 143},
  [265] = {.lex_state = 143},
  [266] = {.lex_state = 143},
  [267] = {.lex_state = 143},
  [268] = {.lex_state = 143},
  [269] = {.lex_state = 51},
  [270] = {.lex_state = 143},
  [271] = {.lex_state = 55},
  [272] = {.lex_state = 55},
  [273] = {.lex_state = 143},
  [274] = {.lex_state = 143},
  [275] = {.lex_state = 143},
  [276] = {.lex_state = 143},
  [277] = {.lex_state = 55},
  [278] = {.lex_state = 143},
  [279] = {.lex_state = 143},
  [280] = {.lex_state = 143},
  [281] = {.lex_state = 143},
  [282] = {.lex_state = 143},
  [283] = {.lex_state = 143},
  [284] = {.lex_state = 143},
  [285] = {.lex_state = 143},
  [286] = {.lex_state = 143},
  [287] = {.lex_state = 143},
  [288] = {.lex_state = 55},
  [289] = {.lex_state = 143},
  [290] = {.lex_state = 143},
  [291] = {.lex_state = 55},
  [292] = {.lex_state = 143},
  [293] = {.lex_state = 143},
  [294] = {.lex_state = 55},
  [295] = {.lex_state = 55},
  [296] = {.lex_state = 143},
  [297] = {.lex_state = 143},
  [298] = {.lex_state = 143},
  [299] = {.lex_state = 143},
  [300] = {.lex_state = 143},
  [301] = {.lex_state = 143},
  [302] = {.lex_state = 143},
  [303] = {.lex_state = 143},
  [304] = {.lex_state = 143},
  [305] = {.lex_state = 55},
  [306] = {.lex_state = 143},
  [307] = {.lex_state = 143},
  [308] = {.lex_state = 55},
  [309] = {.lex_state = 55},
  [310] = {.lex_state = 55},
  [311] = {.lex_state = 55},
  [312] = {.lex_state = 55},
  [313] = {.lex_state = 55},
  [314] = {.lex_state = 55},
  [315] = {.lex_state = 143},
  [316] = {.lex_state = 143},
  [317] = {.lex_state = 55},
  [318] = {.lex_state = 143},
  [319] = {.lex_state = 143},
  [320] = {.lex_state = 143},
  [321] = {.lex_state = 143},
  [322] = {.lex_state = 55},
  [323] = {.lex_state = 55},
  [324] = {.lex_state = 55},
  [325] = {.lex_state = 55},
  [326] = {.lex_state = 55},
  [327] = {.lex_state = 55},
  [328] = {.lex_state = 55},
  [329] = {.lex_state = 55},
  [330] = {.lex_state = 55},
  [331] = {.lex_state = 143},
  [332] = {.lex_state = 143},
  [333] = {.lex_state = 143},
  [334] = {.lex_state = 55},
  [335] = {.lex_state = 55},
  [336] = {.lex_state = 55},
  [337] = {.lex_state = 143},
  [338] = {.lex_state = 55},
  [339] = {.lex_state = 55},
  [340] = {.lex_state = 55},
  [341] = {.lex_state = 55},
  [342] = {.lex_state = 143},
  [343] = {.lex_state = 55},
  [344] = {.lex_state = 55},
  [345] = {.lex_state = 55},
  [346] = {.lex_state = 55},
  [347] = {.lex_state = 143},
  [348] = {.lex_state = 55},
  [349] = {.lex_state = 55},
  [350] = {.lex_state = 55},
  [351] = {.lex_state = 55},
  [352] = {.lex_state = 143},
  [353] = {.lex_state = 143},
  [354] = {.lex_state = 143},
  [355] = {.lex_state = 55},
  [356] = {.lex_state = 55},
  [357] = {.lex_state = 55},
  [358] = {.lex_state = 143},
  [359] = {.lex_state = 143},
  [360] = {.lex_state = 143},
  [361] = {.lex_state = 143},
  [362] = {.lex_state = 143},
  [363] = {.lex_state = 55},
  [364] = {.lex_state = 143},
  [365] = {.lex_state = 55},
  [366] = {.lex_state = 143},
  [367] = {.lex_state = 55},
  [368] = {.lex_state = 55},
  [369] = {.lex_state = 55},
  [370] = {.lex_state = 55},
  [371] = {.lex_state = 55},
  [372] = {.lex_state = 143},
  [373] = {.lex_state = 143},
  [374] = {.lex_state = 55},
  [375] = {.lex_state = 143},
  [376] = {.lex_state = 55},
  [377] = {.lex_state = 143},
  [378] = {.lex_state = 55},
  [379] = {.lex_state = 143},
  [380] = {.lex_state = 143},
  [381] = {.lex_state = 143},
  [382] = {.lex_state = 143},
  [383] = {.lex_state = 143},
  [384] = {.lex_state = 55},
  [385] = {.lex_state = 143},
  [386] = {.lex_state = 55},
  [387] = {.lex_state = 55},
  [388] = {.lex_state = 143},
  [389] = {.lex_state = 143},
  [390] = {.lex_state = 55},
  [391] = {.lex_state = 143},
  [392] = {.lex_state = 55},
  [393] = {.lex_state = 143},
  [394] = {.lex_state = 55},
  [395] = {.lex_state = 55},
  [396] = {.lex_state = 55},
  [397] = {.lex_state = 143},
  [398] = {.lex_state = 55},
  [399] = {.lex_state = 143},
  [400] = {.lex_state = 55},
  [401] = {.lex_state = 143},
  [402] = {.lex_state = 55},
  [403] = {.lex_state = 55},
  [404] = {.lex_state = 55},
  [405] = {.lex_state = 143},
  [406] = {.lex_state = 143},
  [407] = {.lex_state = 143},
  [408] = {.lex_state = 143},
  [409] = {.lex_state = 143},
  [410] = {.lex_state = 143},
  [411] = {.lex_state = 143},
  [412] = {.lex_state = 143},
  [413] = {.lex_state = 143},
  [414] = {.lex_state = 143},
  [415] = {.lex_state = 143},
  [416] = {.lex_state = 143},
  [417] = {.lex_state = 143},
  [418] = {.lex_state = 143},
  [419] = {.lex_state = 143},
  [420] = {.lex_state = 143},
  [421] = {.lex_state = 143},
  [422] = {.lex_state = 143},
  [423] = {.lex_state = 143},
  [424] = {.lex_state = 143},
  [425] = {.lex_state = 143},
  [426] = {.lex_state = 143},
  [427] = {.lex_state = 143},
  [428] = {.lex_state = 143},
  [429] = {.lex_state = 143},
  [430] = {.lex_state = 143},
  [431] = {.lex_state = 143},
  [432] = {.lex_state = 143},
  [433] = {.lex_state = 143},
  [434] = {.lex_state = 143},
  [435] = {.lex_state = 143},
  [436] = {.lex_state = 143},
  [437] = {.lex_state = 143},
  [438] = {.lex_state = 143},
  [439] = {.lex_state = 143},
  [440] = {.lex_state = 143},
  [441] = {.lex_state = 143},
  [442] = {.lex_state = 143},
  [443] = {.lex_state = 143},
  [444] = {.lex_state = 143},
  [445] = {.lex_state = 143},
  [446] = {.lex_state = 52},
  [447] = {.lex_state = 143},
  [448] = {.lex_state = 143},
  [449] = {.lex_state = 143},
  [450] = {.lex_state = 143},
  [451] = {.lex_state = 143},
  [452] = {.lex_state = 143},
  [453] = {.lex_state = 143},
  [454] = {.lex_state = 143},
  [455] = {.lex_state = 143},
  [456] = {.lex_state = 143},
  [457] = {.lex_state = 143},
  [458] = {.lex_state = 143},
  [459] = {.lex_state = 51},
  [460] = {.lex_state = 143},
  [461] = {.lex_state = 143},
  [462] = {.lex_state = 143},
  [463] = {.lex_state = 143},
  [464] = {.lex_state = 143},
  [465] = {.lex_state = 143},
  [466] = {.lex_state = 143},
  [467] = {.lex_state = 143},
  [468] = {.lex_state = 143},
  [469] = {.lex_state = 143},
  [470] = {.lex_state = 143},
  [471] = {.lex_state = 143},
  [472] = {.lex_state = 143},
  [473] = {.lex_state = 143},
  [474] = {.lex_state = 143},
  [475] = {.lex_state = 143},
  [476] = {.lex_state = 143},
  [477] = {.lex_state = 143},
  [478] = {.lex_state = 143},
  [479] = {.lex_state = 143},
  [480] = {.lex_state = 143},
  [481] = {.lex_state = 143},
  [482] = {.lex_state = 143},
  [483] = {.lex_state = 143},
  [484] = {.lex_state = 143},
  [485] = {.lex_state = 143},
  [486] = {.lex_state = 143},
  [487] = {.lex_state = 143},
  [488] = {.lex_state = 143},
  [489] = {.lex_state = 143},
  [490] = {.lex_state = 143},
  [491] = {.lex_state = 143},
  [492] = {.lex_state = 143},
  [493] = {.lex_state = 143},
  [494] = {.lex_state = 143},
  [495] = {.lex_state = 143},
  [496] = {.lex_state = 143},
  [497] = {.lex_state = 143},
  [498] = {.lex_state = 143},
  [499] = {.lex_state = 143},
  [500] = {.lex_state = 51},
  [501] = {.lex_state = 51},
  [502] = {.lex_state = 52},
  [503] = {.lex_state = 143},
  [504] = {.lex_state = 143},
  [505] = {.lex_state = 51},
  [506] = {.lex_state = 58},
  [507] = {.lex_state = 58},
  [508] = {.lex_state = 58},
  [509] = {.lex_state = 58},
  [510] = {.lex_state = 58},
  [511] = {.lex_state = 58},
  [512] = {.lex_state = 58},
  [513] = {.lex_state = 58},
  [514] = {.lex_state = 58},
  [515] = {.lex_state = 58},
  [516] = {.lex_state = 58},
  [517] = {.lex_state = 58},
  [518] = {.lex_state = 143},
  [519] = {.lex_state = 143},
  [520] = {.lex_state = 143},
  [521] = {.lex_state = 143},
  [522] = {.lex_state = 143},
  [523] = {.lex_state = 143},
  [524] = {.lex_state = 143},
  [525] = {.lex_state = 143},
  [526] = {.lex_state = 143},
  [527] = {.lex_state = 143},
  [528] = {.lex_state = 143},
  [529] = {.lex_state = 143},
  [530] = {.lex_state = 143},
  [531] = {.lex_state = 143},
  [532] = {.lex_state = 143},
  [533] = {.lex_state = 143},
  [534] = {.lex_state = 62},
  [535] = {.lex_state = 62},
  [536] = {.lex_state = 62},
  [537] = {.lex_state = 143},
  [538] = {.lex_state = 62},
  [539] = {.lex_state = 62},
  [540] = {.lex_state = 62},
  [541] = {.lex_state = 62},
  [542] = {.lex_state = 62},
  [543] = {.lex_state = 62},
  [544] = {.lex_state = 63},
  [545] = {.lex_state = 63},
  [546] = {.lex_state = 62},
  [547] = {.lex_state = 63},
  [548] = {.lex_state = 63},
  [549] = {.lex_state = 63},
  [550] = {.lex_state = 63},
  [551] = {.lex_state = 63},
  [552] = {.lex_state = 63},
  [553] = {.lex_state = 63},
  [554] = {.lex_state = 63},
  [555] = {.lex_state = 143},
  [556] = {.lex_state = 63},
  [557] = {.lex_state = 143},
  [558] = {.lex_state = 143},
  [559] = {.lex_state = 143},
  [560] = {.lex_state = 143},
  [561] = {.lex_state = 143},
  [562] = {.lex_state = 143},
  [563] = {.lex_state = 143},
  [564] = {.lex_state = 143},
  [565] = {.lex_state = 143},
  [566] = {.lex_state = 143},
  [567] = {.lex_state = 143},
  [568] = {.lex_state = 68},
  [569] = {.lex_state = 143},
  [570] = {.lex_state = 143},
  [571] = {.lex_state = 67},
  [572] = {.lex_state = 143},
  [573] = {.lex_state = 143},
  [574] = {.lex_state = 143},
  [575] = {.lex_state = 143},
  [576] = {.lex_state = 67},
  [577] = {.lex_state = 67},
  [578] = {.lex_state = 143},
  [579] = {.lex_state = 143},
  [580] = {.lex_state = 143},
  [581] = {.lex_state = 68},
  [582] = {.lex_state = 143},
  [583] = {.lex_state = 143},
  [584] = {.lex_state = 143},
  [585] = {.lex_state = 143},
  [586] = {.lex_state = 143},
  [587] = {.lex_state = 143},
  [588] = {.lex_state = 143},
  [589] = {.lex_state = 68},
  [590] = {.lex_state = 143},
  [591] = {.lex_state = 143},
  [592] = {.lex_state = 62},
  [593] = {.lex_state = 143},
  [594] = {.lex_state = 143},
  [595] = {.lex_state = 143},
  [596] = {.lex_state = 143},
  [597] = {.lex_state = 143},
  [598] = {.lex_state = 143},
  [599] = {.lex_state = 143},
  [600] = {.lex_state = 143},
  [601] = {.lex_state = 143},
  [602] = {.lex_state = 143},
  [603] = {.lex_state = 143},
  [604] = {.lex_state = 143},
  [605] = {.lex_state = 143},
  [606] = {.lex_state = 143},
  [607] = {.lex_state = 143},
  [608] = {.lex_state = 143},
  [609] = {.lex_state = 143},
  [610] = {.lex_state = 143},
  [611] = {.lex_state = 143},
  [612] = {.lex_state = 143},
  [613] = {.lex_state = 143},
  [614] = {.lex_state = 143},
  [615] = {.lex_state = 143},
  [616] = {.lex_state = 143},
  [617] = {.lex_state = 143},
  [618] = {.lex_state = 143},
  [619] = {.lex_state = 143},
  [620] = {.lex_state = 143},
  [621] = {.lex_state = 143},
  [622] = {.lex_state = 143},
  [623] = {.lex_state = 143},
  [624] = {.lex_state = 143},
  [625] = {.lex_state = 143},
  [626] = {.lex_state = 143},
  [627] = {.lex_state = 143},
  [628] = {.lex_state = 143},
  [629] = {.lex_state = 143},
  [630] = {.lex_state = 143},
  [631] = {.lex_state = 143},
  [632] = {.lex_state = 143},
  [633] = {.lex_state = 143},
  [634] = {.lex_state = 143},
  [635] = {.lex_state = 143},
  [636] = {.lex_state = 143},
  [637] = {.lex_state = 143},
  [638] = {.lex_state = 143},
  [639] = {.lex_state = 143},
  [640] = {.lex_state = 143},
  [641] = {.lex_state = 143},
  [642] = {.lex_state = 143},
  [643] = {.lex_state = 143},
  [644] = {.lex_state = 143},
  [645] = {.lex_state = 143},
  [646] = {.lex_state = 143},
  [647] = {.lex_state = 143},
  [648] = {.lex_state = 143},
  [649] = {.lex_state = 143},
  [650] = {.lex_state = 143},
  [651] = {.lex_state = 143},
  [652] = {.lex_state = 143},
  [653] = {.lex_state = 143},
  [654] = {.lex_state = 143},
  [655] = {.lex_state = 143},
  [656] = {.lex_state = 143},
  [657] = {.lex_state = 143},
  [658] = {.lex_state = 143},
  [659] = {.lex_state = 143},
  [660] = {.lex_state = 143},
  [661] = {.lex_state = 143},
  [662] = {.lex_state = 143},
  [663] = {.lex_state = 143},
  [664] = {.lex_state = 143},
  [665] = {.lex_state = 143},
  [666] = {.lex_state = 143},
  [667] = {.lex_state = 143},
  [668] = {.lex_state = 143},
  [669] = {.lex_state = 143},
  [670] = {.lex_state = 58},
  [671] = {.lex_state = 143},
  [672] = {.lex_state = 143},
  [673] = {.lex_state = 143},
  [674] = {.lex_state = 143},
  [675] = {.lex_state = 143},
  [676] = {.lex_state = 143},
  [677] = {.lex_state = 143},
  [678] = {.lex_state = 143},
  [679] = {.lex_state = 143},
  [680] = {.lex_state = 143},
  [681] = {.lex_state = 143},
  [682] = {.lex_state = 143},
  [683] = {.lex_state = 143},
  [684] = {.lex_state = 143},
  [685] = {.lex_state = 143},
  [686] = {.lex_state = 143},
  [687] = {.lex_state = 143},
  [688] = {.lex_state = 143},
  [689] = {.lex_state = 143},
  [690] = {.lex_state = 143},
  [691] = {.lex_state = 143},
  [692] = {.lex_state = 143},
  [693] = {.lex_state = 143},
  [694] = {.lex_state = 143},
  [695] = {.lex_state = 143},
  [696] = {.lex_state = 143},
  [697] = {.lex_state = 143},
  [698] = {.lex_state = 143},
  [699] = {.lex_state = 143},
  [700] = {.lex_state = 143},
  [701] = {.lex_state = 143},
  [702] = {.lex_state = 143},
  [703] = {.lex_state = 143},
  [704] = {.lex_state = 143},
  [705] = {.lex_state = 143},
  [706] = {.lex_state = 143},
  [707] = {.lex_state = 143},
  [708] = {.lex_state = 143},
  [709] = {.lex_state = 143},
  [710] = {.lex_state = 143},
  [711] = {.lex_state = 143},
  [712] = {.lex_state = 143},
  [713] = {.lex_state = 143},
  [714] = {.lex_state = 143},
  [715] = {.lex_state = 143},
  [716] = {.lex_state = 143},
  [717] = {.lex_state = 143},
  [718] = {.lex_state = 143},
  [719] = {.lex_state = 143},
  [720] = {.lex_state = 143},
  [721] = {.lex_state = 143},
  [722] = {.lex_state = 143},
  [723] = {.lex_state = 143},
  [724] = {.lex_state = 143},
  [725] = {.lex_state = 143},
  [726] = {.lex_state = 143},
  [727] = {.lex_state = 143},
  [728] = {.lex_state = 143},
  [729] = {.lex_state = 143},
  [730] = {.lex_state = 143},
  [731] = {.lex_state = 143},
  [732] = {.lex_state = 143},
  [733] = {.lex_state = 143},
  [734] = {.lex_state = 143},
  [735] = {.lex_state = 143},
  [736] = {.lex_state = 143},
  [737] = {.lex_state = 143},
  [738] = {.lex_state = 143},
  [739] = {.lex_state = 143},
  [740] = {.lex_state = 143},
  [741] = {.lex_state = 143},
  [742] = {.lex_state = 143},
  [743] = {.lex_state = 143},
  [744] = {.lex_state = 143},
  [745] = {.lex_state = 143},
  [746] = {.lex_state = 143},
  [747] = {.lex_state = 143},
  [748] = {.lex_state = 143},
  [749] = {.lex_state = 143},
  [750] = {.lex_state = 143},
  [751] = {.lex_state = 143},
  [752] = {.lex_state = 143},
  [753] = {.lex_state = 143},
  [754] = {.lex_state = 143},
  [755] = {.lex_state = 143},
  [756] = {.lex_state = 143},
  [757] = {.lex_state = 143},
  [758] = {.lex_state = 143},
  [759] = {.lex_state = 143},
  [760] = {.lex_state = 143},
  [761] = {.lex_state = 143},
  [762] = {.lex_state = 143},
  [763] = {.lex_state = 143},
  [764] = {.lex_state = 143},
  [765] = {.lex_state = 62},
  [766] = {.lex_state = 62},
  [767] = {.lex_state = 62},
  [768] = {.lex_state = 62},
  [769] = {.lex_state = 58},
  [770] = {.lex_state = 58},
  [771] = {.lex_state = 62},
  [772] = {.lex_state = 58},
  [773] = {.lex_state = 58},
  [774] = {.lex_state = 58},
  [775] = {.lex_state = 58},
  [776] = {.lex_state = 58},
  [777] = {.lex_state = 61},
  [778] = {.lex_state = 61},
  [779] = {.lex_state = 61},
  [780] = {.lex_state = 61},
  [781] = {.lex_state = 61},
  [782] = {.lex_state = 61},
  [783] = {.lex_state = 61},
  [784] = {.lex_state = 61},
  [785] = {.lex_state = 61},
  [786] = {.lex_state = 61},
  [787] = {.lex_state = 61},
  [788] = {.lex_state = 143},
  [789] = {.lex_state = 143},
  [790] = {.lex_state = 143},
  [791] = {.lex_state = 61},
  [792] = {.lex_state = 62},
  [793] = {.lex_state = 62},
  [794] = {.lex_state = 62},
  [795] = {.lex_state = 62},
  [796] = {.lex_state = 62},
  [797] = {.lex_state = 61},
  [798] = {.lex_state = 61},
  [799] = {.lex_state = 62},
  [800] = {.lex_state = 62},
  [801] = {.lex_state = 61},
  [802] = {.lex_state = 61},
  [803] = {.lex_state = 61},
  [804] = {.lex_state = 61},
  [805] = {.lex_state = 62},
  [806] = {.lex_state = 62},
  [807] = {.lex_state = 61},
  [808] = {.lex_state = 61},
  [809] = {.lex_state = 62},
  [810] = {.lex_state = 62},
  [811] = {.lex_state = 62},
  [812] = {.lex_state = 62},
  [813] = {.lex_state = 61},
  [814] = {.lex_state = 61},
  [815] = {.lex_state = 62},
  [816] = {.lex_state = 61},
  [817] = {.lex_state = 62},
  [818] = {.lex_state = 62},
  [819] = {.lex_state = 61},
  [820] = {.lex_state = 61},
  [821] = {.lex_state = 62},
  [822] = {.lex_state = 62},
  [823] = {.lex_state = 62},
  [824] = {.lex_state = 61},
  [825] = {.lex_state = 61},
  [826] = {.lex_state = 62},
  [827] = {.lex_state = 62},
  [828] = {.lex_state = 62},
  [829] = {.lex_state = 61},
  [830] = {.lex_state = 60},
  [831] = {.lex_state = 62},
  [832] = {.lex_state = 61},
  [833] = {.lex_state = 62},
  [834] = {.lex_state = 61},
  [835] = {.lex_state = 60},
  [836] = {.lex_state = 60},
  [837] = {.lex_state = 61},
  [838] = {.lex_state = 58},
  [839] = {.lex_state = 61},
  [840] = {.lex_state = 61},
  [841] = {.lex_state = 60},
  [842] = {.lex_state = 62},
  [843] = {.lex_state = 58},
  [844] = {.lex_state = 59},
  [845] = {.lex_state = 59},
  [846] = {.lex_state = 59},
  [847] = {.lex_state = 59},
  [848] = {.lex_state = 59},
  [849] = {.lex_state = 59},
  [850] = {.lex_state = 143},
  [851] = {.lex_state = 62},
  [852] = {.lex_state = 62},
  [853] = {.lex_state = 62},
  [854] = {.lex_state = 62},
  [855] = {.lex_state = 62},
  [856] = {.lex_state = 62},
  [857] = {.lex_state = 62},
  [858] = {.lex_state = 59},
  [859] = {.lex_state = 59},
  [860] = {.lex_state = 62},
  [861] = {.lex_state = 62},
  [862] = {.lex_state = 62},
  [863] = {.lex_state = 58},
  [864] = {.lex_state = 58},
  [865] = {.lex_state = 58},
  [866] = {.lex_state = 58},
  [867] = {.lex_state = 62},
  [868] = {.lex_state = 58},
  [869] = {.lex_state = 62},
  [870] = {.lex_state = 58},
  [871] = {.lex_state = 58},
  [872] = {.lex_state = 143},
  [873] = {.lex_state = 61},
  [874] = {.lex_state = 61},
  [875] = {.lex_state = 61},
  [876] = {.lex_state = 61},
  [877] = {.lex_state = 61},
  [878] = {.lex_state = 61},
  [879] = {.lex_state = 61},
  [880] = {.lex_state = 58},
  [881] = {.lex_state = 61},
  [882] = {.lex_state = 61},
  [883] = {.lex_state = 61},
  [884] = {.lex_state = 61},
  [885] = {.lex_state = 61},
  [886] = {.lex_state = 62},
  [887] = {.lex_state = 61},
  [888] = {.lex_state = 62},
  [889] = {.lex_state = 62},
  [890] = {.lex_state = 62},
  [891] = {.lex_state = 62},
  [892] = {.lex_state = 64},
  [893] = {.lex_state = 62},
  [894] = {.lex_state = 62},
  [895] = {.lex_state = 62},
  [896] = {.lex_state = 64},
  [897] = {.lex_state = 62},
  [898] = {.lex_state = 62},
  [899] = {.lex_state = 62},
  [900] = {.lex_state = 64},
  [901] = {.lex_state = 62},
  [902] = {.lex_state = 62},
  [903] = {.lex_state = 64},
  [904] = {.lex_state = 64},
  [905] = {.lex_state = 64},
  [906] = {.lex_state = 64},
  [907] = {.lex_state = 64},
  [908] = {.lex_state = 64},
  [909] = {.lex_state = 64},
  [910] = {.lex_state = 64},
  [911] = {.lex_state = 64},
  [912] = {.lex_state = 64},
  [913] = {.lex_state = 64},
  [914] = {.lex_state = 64},
  [915] = {.lex_state = 64},
  [916] = {.lex_state = 64},
  [917] = {.lex_state = 64},
  [918] = {.lex_state = 64},
  [919] = {.lex_state = 64},
  [920] = {.lex_state = 64},
  [921] = {.lex_state = 64},
  [922] = {.lex_state = 62},
  [923] = {.lex_state = 64},
  [924] = {.lex_state = 64},
  [925] = {.lex_state = 64},
  [926] = {.lex_state = 64},
  [927] = {.lex_state = 62},
  [928] = {.lex_state = 62},
  [929] = {.lex_state = 62},
  [930] = {.lex_state = 64},
  [931] = {.lex_state = 64},
  [932] = {.lex_state = 64},
  [933] = {.lex_state = 64},
  [934] = {.lex_state = 64},
  [935] = {.lex_state = 62},
  [936] = {.lex_state = 62},
  [937] = {.lex_state = 64},
  [938] = {.lex_state = 62},
  [939] = {.lex_state = 64},
  [940] = {.lex_state = 64},
  [941] = {.lex_state = 64},
  [942] = {.lex_state = 64},
  [943] = {.lex_state = 64},
  [944] = {.lex_state = 62},
  [945] = {.lex_state = 62},
  [946] = {.lex_state = 64},
  [947] = {.lex_state = 62},
  [948] = {.lex_state = 62},
  [949] = {.lex_state = 64},
  [950] = {.lex_state = 62},
  [951] = {.lex_state = 64},
  [952] = {.lex_state = 64},
  [953] = {.lex_state = 64},
  [954] = {.lex_state = 64},
  [955] = {.lex_state = 64},
  [956] = {.lex_state = 62},
  [957] = {.lex_state = 62},
  [958] = {.lex_state = 64},
  [959] = {.lex_state = 64},
  [960] = {.lex_state = 64},
  [961] = {.lex_state = 62},
  [962] = {.lex_state = 62},
  [963] = {.lex_state = 64},
  [964] = {.lex_state = 64},
  [965] = {.lex_state = 62},
  [966] = {.lex_state = 62},
  [967] = {.lex_state = 64},
  [968] = {.lex_state = 62},
  [969] = {.lex_state = 58},
  [970] = {.lex_state = 58},
  [971] = {.lex_state = 63},
  [972] = {.lex_state = 58},
  [973] = {.lex_state = 58},
  [974] = {.lex_state = 63},
  [975] = {.lex_state = 63},
  [976] = {.lex_state = 62},
  [977] = {.lex_state = 63},
  [978] = {.lex_state = 58},
  [979] = {.lex_state = 63},
  [980] = {.lex_state = 58},
  [981] = {.lex_state = 58},
  [982] = {.lex_state = 58},
  [983] = {.lex_state = 58},
  [984] = {.lex_state = 58},
  [985] = {.lex_state = 62},
  [986] = {.lex_state = 58},
  [987] = {.lex_state = 63},
  [988] = {.lex_state = 63},
  [989] = {.lex_state = 58},
  [990] = {.lex_state = 62},
  [991] = {.lex_state = 63},
  [992] = {.lex_state = 58},
  [993] = {.lex_state = 62},
  [994] = {.lex_state = 63},
  [995] = {.lex_state = 63},
  [996] = {.lex_state = 63},
  [997] = {.lex_state = 63},
  [998] = {.lex_state = 58},
  [999] = {.lex_state = 62},
  [1000] = {.lex_state = 63},
  [1001] = {.lex_state = 63},
  [1002] = {.lex_state = 62},
  [1003] = {.lex_state = 58},
  [1004] = {.lex_state = 62},
  [1005] = {.lex_state = 62},
  [1006] = {.lex_state = 62},
  [1007] = {.lex_state = 58},
  [1008] = {.lex_state = 63},
  [1009] = {.lex_state = 62},
  [1010] = {.lex_state = 63},
  [1011] = {.lex_state = 63},
  [1012] = {.lex_state = 58},
  [1013] = {.lex_state = 63},
  [1014] = {.lex_state = 58},
  [1015] = {.lex_state = 62},
  [1016] = {.lex_state = 62},
  [1017] = {.lex_state = 62},
  [1018] = {.lex_state = 62},
  [1019] = {.lex_state = 58},
  [1020] = {.lex_state = 62},
  [1021] = {.lex_state = 67},
  [1022] = {.lex_state = 67},
  [1023] = {.lex_state = 68},
  [1024] = {.lex_state = 68},
  [1025] = {.lex_state = 68},
  [1026] = {.lex_state = 58},
  [1027] = {.lex_state = 68},
  [1028] = {.lex_state = 68},
  [1029] = {.lex_state = 68},
  [1030] = {.lex_state = 68},
  [1031] = {.lex_state = 68},
  [1032] = {.lex_state = 67},
  [1033] = {.lex_state = 62},
  [1034] = {.lex_state = 62},
  [1035] = {.lex_state = 62},
  [1036] = {.lex_state = 68},
  [1037] = {.lex_state = 68},
  [1038] = {.lex_state = 68},
  [1039] = {.lex_state = 67},
  [1040] = {.lex_state = 68},
  [1041] = {.lex_state = 67},
  [1042] = {.lex_state = 67},
  [1043] = {.lex_state = 58},
  [1044] = {.lex_state = 67},
  [1045] = {.lex_state = 67},
  [1046] = {.lex_state = 67},
  [1047] = {.lex_state = 67},
  [1048] = {.lex_state = 62},
  [1049] = {.lex_state = 67},
  [1050] = {.lex_state = 58},
  [1051] = {.lex_state = 67},
  [1052] = {.lex_state = 62},
  [1053] = {.lex_state = 58},
  [1054] = {.lex_state = 62},
  [1055] = {.lex_state = 68},
  [1056] = {.lex_state = 62},
  [1057] = {.lex_state = 68},
  [1058] = {.lex_state = 68},
  [1059] = {.lex_state = 68},
  [1060] = {.lex_state = 68},
  [1061] = {.lex_state = 68},
  [1062] = {.lex_state = 62},
  [1063] = {.lex_state = 62},
  [1064] = {.lex_state = 62},
  [1065] = {.lex_state = 62},
  [1066] = {.lex_state = 67},
  [1067] = {.lex_state = 67},
  [1068] = {.lex_state = 67},
  [1069] = {.lex_state = 62},
  [1070] = {.lex_state = 67},
  [1071] = {.lex_state = 58},
  [1072] = {.lex_state = 62},
  [1073] = {.lex_state = 67},
  [1074] = {.lex_state = 62},
  [1075] = {.lex_state = 67},
  [1076] = {.lex_state = 62},
  [1077] = {.lex_state = 62},
  [1078] = {.lex_state = 62},
  [1079] = {.lex_state = 62},
  [1080] = {.lex_state = 62},
  [1081] = {.lex_state = 62},
  [1082] = {.lex_state = 62},
  [1083] = {.lex_state = 62},
  [1084] = {.lex_state = 62},
  [1085] = {.lex_state = 62},
  [1086] = {.lex_state = 62},
  [1087] = {.lex_state = 62},
  [1088] = {.lex_state = 62},
  [1089] = {.lex_state = 62},
  [1090] = {.lex_state = 62},
  [1091] = {.lex_state = 62},
  [1092] = {.lex_state = 62},
  [1093] = {.lex_state = 62},
  [1094] = {.lex_state = 62},
  [1095] = {.lex_state = 62},
  [1096] = {.lex_state = 62},
  [1097] = {.lex_state = 62},
  [1098] = {.lex_state = 62},
  [1099] = {.lex_state = 62},
  [1100] = {.lex_state = 62},
  [1101] = {.lex_state = 62},
  [1102] = {.lex_state = 62},
  [1103] = {.lex_state = 62},
  [1104] = {.lex_state = 62},
  [1105] = {.lex_state = 62},
  [1106] = {.lex_state = 62},
  [1107] = {.lex_state = 62},
  [1108] = {.lex_state = 62},
  [1109] = {.lex_state = 62},
  [1110] = {.lex_state = 62},
  [1111] = {.lex_state = 62},
  [1112] = {.lex_state = 62},
  [1113] = {.lex_state = 62},
  [1114] = {.lex_state = 143},
  [1115] = {.lex_state = 62},
  [1116] = {.lex_state = 62},
  [1117] = {.lex_state = 62},
  [1118] = {.lex_state = 62},
  [1119] = {.lex_state = 62},
  [1120] = {.lex_state = 62},
  [1121] = {.lex_state = 62},
  [1122] = {.lex_state = 62},
  [1123] = {.lex_state = 62},
  [1124] = {.lex_state = 62},
  [1125] = {.lex_state = 62},
  [1126] = {.lex_state = 62},
  [1127] = {.lex_state = 62},
  [1128] = {.lex_state = 61},
  [1129] = {.lex_state = 61},
  [1130] = {.lex_state = 61},
  [1131] = {.lex_state = 61},
  [1132] = {.lex_state = 61},
  [1133] = {.lex_state = 61},
  [1134] = {.lex_state = 61},
  [1135] = {.lex_state = 61},
  [1136] = {.lex_state = 61},
  [1137] = {.lex_state = 61},
  [1138] = {.lex_state = 61},
  [1139] = {.lex_state = 61},
  [1140] = {.lex_state = 61},
  [1141] = {.lex_state = 62},
  [1142] = {.lex_state = 62},
  [1143] = {.lex_state = 62},
  [1144] = {.lex_state = 62},
  [1145] = {.lex_state = 62},
  [1146] = {.lex_state = 62},
  [1147] = {.lex_state = 62},
  [1148] = {.lex_state = 62},
  [1149] = {.lex_state = 62},
  [1150] = {.lex_state = 62},
  [1151] = {.lex_state = 62},
  [1152] = {.lex_state = 62},
  [1153] = {.lex_state = 62},
  [1154] = {.lex_state = 62},
  [1155] = {.lex_state = 62},
  [1156] = {.lex_state = 62},
  [1157] = {.lex_state = 62},
  [1158] = {.lex_state = 62},
  [1159] = {.lex_state = 62},
  [1160] = {.lex_state = 62},
  [1161] = {.lex_state = 62},
  [1162] = {.lex_state = 62},
  [1163] = {.lex_state = 64},
  [1164] = {.lex_state = 64},
  [1165] = {.lex_state = 64},
  [1166] = {.lex_state = 62},
  [1167] = {.lex_state = 62},
  [1168] = {.lex_state = 64},
  [1169] = {.lex_state = 62},
  [1170] = {.lex_state = 64},
  [1171] = {.lex_state = 64},
  [1172] = {.lex_state = 64},
  [1173] = {.lex_state = 64},
  [1174] = {.lex_state = 64},
  [1175] = {.lex_state = 62},
  [1176] = {.lex_state = 64},
  [1177] = {.lex_state = 64},
  [1178] = {.lex_state = 64},
  [1179] = {.lex_state = 64},
  [1180] = {.lex_state = 62},
  [1181] = {.lex_state = 62},
  [1182] = {.lex_state = 62},
  [1183] = {.lex_state = 62},
  [1184] = {.lex_state = 62},
  [1185] = {.lex_state = 62},
  [1186] = {.lex_state = 62},
  [1187] = {.lex_state = 62},
  [1188] = {.lex_state = 62},
  [1189] = {.lex_state = 58},
  [1190] = {.lex_state = 58},
  [1191] = {.lex_state = 58},
  [1192] = {.lex_state = 58},
  [1193] = {.lex_state = 62},
  [1194] = {.lex_state = 58},
  [1195] = {.lex_state = 58},
  [1196] = {.lex_state = 58},
  [1197] = {.lex_state = 58},
  [1198] = {.lex_state = 58},
  [1199] = {.lex_state = 58},
  [1200] = {.lex_state = 58},
  [1201] = {.lex_state = 58},
  [1202] = {.lex_state = 58},
  [1203] = {.lex_state = 58},
  [1204] = {.lex_state = 62},
  [1205] = {.lex_state = 58},
  [1206] = {.lex_state = 62},
  [1207] = {.lex_state = 62},
  [1208] = {.lex_state = 62},
  [1209] = {.lex_state = 58},
  [1210] = {.lex_state = 62},
  [1211] = {.lex_state = 62},
  [1212] = {.lex_state = 58},
  [1213] = {.lex_state = 58},
  [1214] = {.lex_state = 58},
  [1215] = {.lex_state = 58},
  [1216] = {.lex_state = 58},
  [1217] = {.lex_state = 62},
  [1218] = {.lex_state = 62},
  [1219] = {.lex_state = 58},
  [1220] = {.lex_state = 62},
  [1221] = {.lex_state = 58},
  [1222] = {.lex_state = 58},
  [1223] = {.lex_state = 58},
  [1224] = {.lex_state = 58},
  [1225] = {.lex_state = 62},
  [1226] = {.lex_state = 58},
  [1227] = {.lex_state = 58},
  [1228] = {.lex_state = 62},
  [1229] = {.lex_state = 62},
  [1230] = {.lex_state = 58},
  [1231] = {.lex_state = 58},
  [1232] = {.lex_state = 58},
  [1233] = {.lex_state = 58},
  [1234] = {.lex_state = 58},
  [1235] = {.lex_state = 58},
  [1236] = {.lex_state = 58},
  [1237] = {.lex_state = 58},
  [1238] = {.lex_state = 62},
  [1239] = {.lex_state = 58},
  [1240] = {.lex_state = 58},
  [1241] = {.lex_state = 62},
  [1242] = {.lex_state = 58},
  [1243] = {.lex_state = 58},
  [1244] = {.lex_state = 58},
  [1245] = {.lex_state = 58},
  [1246] = {.lex_state = 58},
  [1247] = {.lex_state = 58},
  [1248] = {.lex_state = 62},
  [1249] = {.lex_state = 58},
  [1250] = {.lex_state = 58},
  [1251] = {.lex_state = 58},
  [1252] = {.lex_state = 58},
  [1253] = {.lex_state = 58},
  [1254] = {.lex_state = 62},
  [1255] = {.lex_state = 58},
  [1256] = {.lex_state = 62},
  [1257] = {.lex_state = 58},
  [1258] = {.lex_state = 62},
  [1259] = {.lex_state = 58},
  [1260] = {.lex_state = 58},
  [1261] = {.lex_state = 58},
  [1262] = {.lex_state = 58},
  [1263] = {.lex_state = 58},
  [1264] = {.lex_state = 62},
  [1265] = {.lex_state = 58},
  [1266] = {.lex_state = 58},
  [1267] = {.lex_state = 58},
  [1268] = {.lex_state = 58},
  [1269] = {.lex_state = 62},
  [1270] = {.lex_state = 58},
  [1271] = {.lex_state = 58},
  [1272] = {.lex_state = 58},
  [1273] = {.lex_state = 58},
  [1274] = {.lex_state = 58},
  [1275] = {.lex_state = 62},
  [1276] = {.lex_state = 62},
  [1277] = {.lex_state = 58},
  [1278] = {.lex_state = 58},
  [1279] = {.lex_state = 58},
  [1280] = {.lex_state = 58},
  [1281] = {.lex_state = 62},
  [1282] = {.lex_state = 62},
  [1283] = {.lex_state = 58},
  [1284] = {.lex_state = 58},
  [1285] = {.lex_state = 58},
  [1286] = {.lex_state = 58},
  [1287] = {.lex_state = 58},
  [1288] = {.lex_state = 58},
  [1289] = {.lex_state = 62},
  [1290] = {.lex_state = 58},
  [1291] = {.lex_state = 58},
  [1292] = {.lex_state = 58},
  [1293] = {.lex_state = 58},
  [1294] = {.lex_state = 58},
  [1295] = {.lex_state = 58},
  [1296] = {.lex_state = 58},
  [1297] = {.lex_state = 58},
  [1298] = {.lex_state = 58},
  [1299] = {.lex_state = 62},
  [1300] = {.lex_state = 58},
  [1301] = {.lex_state = 62},
  [1302] = {.lex_state = 62},
  [1303] = {.lex_state = 58},
  [1304] = {.lex_state = 62},
  [1305] = {.lex_state = 62},
  [1306] = {.lex_state = 62},
  [1307] = {.lex_state = 62},
  [1308] = {.lex_state = 62},
  [1309] = {.lex_state = 62},
  [1310] = {.lex_state = 62},
  [1311] = {.lex_state = 62},
  [1312] = {.lex_state = 62},
  [1313] = {.lex_state = 62},
  [1314] = {.lex_state = 62},
  [1315] = {.lex_state = 62},
  [1316] = {.lex_state = 62},
  [1317] = {.lex_state = 62},
  [1318] = {.lex_state = 63},
  [1319] = {.lex_state = 62},
  [1320] = {.lex_state = 62},
  [1321] = {.lex_state = 62},
  [1322] = {.lex_state = 62},
  [1323] = {.lex_state = 62},
  [1324] = {.lex_state = 63},
  [1325] = {.lex_state = 57},
  [1326] = {.lex_state = 57},
  [1327] = {.lex_state = 33},
  [1328] = {.lex_state = 63},
  [1329] = {.lex_state = 63},
  [1330] = {.lex_state = 57},
  [1331] = {.lex_state = 57},
  [1332] = {.lex_state = 57},
  [1333] = {.lex_state = 57},
  [1334] = {.lex_state = 63},
  [1335] = {.lex_state = 63},
  [1336] = {.lex_state = 63},
  [1337] = {.lex_state = 63},
  [1338] = {.lex_state = 63},
  [1339] = {.lex_state = 63},
  [1340] = {.lex_state = 63},
  [1341] = {.lex_state = 63},
  [1342] = {.lex_state = 63},
  [1343] = {.lex_state = 63},
  [1344] = {.lex_state = 57},
  [1345] = {.lex_state = 57},
  [1346] = {.lex_state = 57},
  [1347] = {.lex_state = 57},
  [1348] = {.lex_state = 57},
  [1349] = {.lex_state = 57},
  [1350] = {.lex_state = 63},
  [1351] = {.lex_state = 57},
  [1352] = {.lex_state = 57},
  [1353] = {.lex_state = 57},
  [1354] = {.lex_state = 57},
  [1355] = {.lex_state = 63},
  [1356] = {.lex_state = 57},
  [1357] = {.lex_state = 63},
  [1358] = {.lex_state = 63},
  [1359] = {.lex_state = 63},
  [1360] = {.lex_state = 57},
  [1361] = {.lex_state = 57},
  [1362] = {.lex_state = 57},
  [1363] = {.lex_state = 57},
  [1364] = {.lex_state = 57},
  [1365] = {.lex_state = 63},
  [1366] = {.lex_state = 57},
  [1367] = {.lex_state = 57},
  [1368] = {.lex_state = 57},
  [1369] = {.lex_state = 57},
  [1370] = {.lex_state = 57},
  [1371] = {.lex_state = 57},
  [1372] = {.lex_state = 57},
  [1373] = {.lex_state = 57},
  [1374] = {.lex_state = 57},
  [1375] = {.lex_state = 57},
  [1376] = {.lex_state = 62},
  [1377] = {.lex_state = 62},
  [1378] = {.lex_state = 62},
  [1379] = {.lex_state = 57},
  [1380] = {.lex_state = 63},
  [1381] = {.lex_state = 57},
  [1382] = {.lex_state = 57},
  [1383] = {.lex_state = 62},
  [1384] = {.lex_state = 57},
  [1385] = {.lex_state = 57},
  [1386] = {.lex_state = 57},
  [1387] = {.lex_state = 57},
  [1388] = {.lex_state = 57},
  [1389] = {.lex_state = 57},
  [1390] = {.lex_state = 63},
  [1391] = {.lex_state = 63},
  [1392] = {.lex_state = 57},
  [1393] = {.lex_state = 62},
  [1394] = {.lex_state = 57},
  [1395] = {.lex_state = 57},
  [1396] = {.lex_state = 63},
  [1397] = {.lex_state = 33},
  [1398] = {.lex_state = 33},
  [1399] = {.lex_state = 62},
  [1400] = {.lex_state = 62},
  [1401] = {.lex_state = 62},
  [1402] = {.lex_state = 62},
  [1403] = {.lex_state = 33},
  [1404] = {.lex_state = 33},
  [1405] = {.lex_state = 33},
  [1406] = {.lex_state = 33},
  [1407] = {.lex_state = 33},
  [1408] = {.lex_state = 33},
  [1409] = {.lex_state = 33},
  [1410] = {.lex_state = 33},
  [1411] = {.lex_state = 33},
  [1412] = {.lex_state = 33},
  [1413] = {.lex_state = 33},
  [1414] = {.lex_state = 33},
  [1415] = {.lex_state = 63},
  [1416] = {.lex_state = 33},
  [1417] = {.lex_state = 33},
  [1418] = {.lex_state = 33},
  [1419] = {.lex_state = 62},
  [1420] = {.lex_state = 33},
  [1421] = {.lex_state = 33},
  [1422] = {.lex_state = 33},
  [1423] = {.lex_state = 33},
  [1424] = {.lex_state = 33},
  [1425] = {.lex_state = 33},
  [1426] = {.lex_state = 33},
  [1427] = {.lex_state = 33},
  [1428] = {.lex_state = 62},
  [1429] = {.lex_state = 63},
  [1430] = {.lex_state = 33},
  [1431] = {.lex_state = 33},
  [1432] = {.lex_state = 33},
  [1433] = {.lex_state = 62},
  [1434] = {.lex_state = 62},
  [1435] = {.lex_state = 33},
  [1436] = {.lex_state = 33},
  [1437] = {.lex_state = 33},
  [1438] = {.lex_state = 33},
  [1439] = {.lex_state = 33},
  [1440] = {.lex_state = 33},
  [1441] = {.lex_state = 33},
  [1442] = {.lex_state = 62},
  [1443] = {.lex_state = 62},
  [1444] = {.lex_state = 62},
  [1445] = {.lex_state = 62},
  [1446] = {.lex_state = 62},
  [1447] = {.lex_state = 62},
  [1448] = {.lex_state = 62},
  [1449] = {.lex_state = 62},
  [1450] = {.lex_state = 62},
  [1451] = {.lex_state = 62},
  [1452] = {.lex_state = 62},
  [1453] = {.lex_state = 62},
  [1454] = {.lex_state = 62},
  [1455] = {.lex_state = 62},
  [1456] = {.lex_state = 62},
  [1457] = {.lex_state = 62},
  [1458] = {.lex_state = 62},
  [1459] = {.lex_state = 62},
  [1460] = {.lex_state = 62},
  [1461] = {.lex_state = 62},
  [1462] = {.lex_state = 62},
  [1463] = {.lex_state = 62},
  [1464] = {.lex_state = 62},
  [1465] = {.lex_state = 62},
  [1466] = {.lex_state = 62},
  [1467] = {.lex_state = 62},
  [1468] = {.lex_state = 62},
  [1469] = {.lex_state = 62},
  [1470] = {.lex_state = 62},
  [1471] = {.lex_state = 62},
  [1472] = {.lex_state = 61},
  [1473] = {.lex_state = 62},
  [1474] = {.lex_state = 62},
  [1475] = {.lex_state = 62},
  [1476] = {.lex_state = 62},
  [1477] = {.lex_state = 62},
  [1478] = {.lex_state = 62},
  [1479] = {.lex_state = 62},
  [1480] = {.lex_state = 62},
  [1481] = {.lex_state = 62},
  [1482] = {.lex_state = 62},
  [1483] = {.lex_state = 62},
  [1484] = {.lex_state = 62},
  [1485] = {.lex_state = 62},
  [1486] = {.lex_state = 62},
  [1487] = {.lex_state = 62},
  [1488] = {.lex_state = 62},
  [1489] = {.lex_state = 62},
  [1490] = {.lex_state = 62},
  [1491] = {.lex_state = 62},
  [1492] = {.lex_state = 62},
  [1493] = {.lex_state = 62},
  [1494] = {.lex_state = 62},
  [1495] = {.lex_state = 62},
  [1496] = {.lex_state = 62},
  [1497] = {.lex_state = 62},
  [1498] = {.lex_state = 62},
  [1499] = {.lex_state = 62},
  [1500] = {.lex_state = 62},
  [1501] = {.lex_state = 62},
  [1502] = {.lex_state = 62},
  [1503] = {.lex_state = 62},
  [1504] = {.lex_state = 62},
  [1505] = {.lex_state = 62},
  [1506] = {.lex_state = 62},
  [1507] = {.lex_state = 62},
  [1508] = {.lex_state = 62},
  [1509] = {.lex_state = 62},
  [1510] = {.lex_state = 62},
  [1511] = {.lex_state = 62},
  [1512] = {.lex_state = 61},
  [1513] = {.lex_state = 64},
  [1514] = {.lex_state = 62},
  [1515] = {.lex_state = 62},
  [1516] = {.lex_state = 62},
  [1517] = {.lex_state = 61},
  [1518] = {.lex_state = 62},
  [1519] = {.lex_state = 62},
  [1520] = {.lex_state = 62},
  [1521] = {.lex_state = 62},
  [1522] = {.lex_state = 62},
  [1523] = {.lex_state = 62},
  [1524] = {.lex_state = 62},
  [1525] = {.lex_state = 61},
  [1526] = {.lex_state = 62},
  [1527] = {.lex_state = 62},
  [1528] = {.lex_state = 62},
  [1529] = {.lex_state = 64},
  [1530] = {.lex_state = 61},
  [1531] = {.lex_state = 61},
  [1532] = {.lex_state = 62},
  [1533] = {.lex_state = 62},
  [1534] = {.lex_state = 62},
  [1535] = {.lex_state = 62},
  [1536] = {.lex_state = 62},
  [1537] = {.lex_state = 62},
  [1538] = {.lex_state = 62},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 62},
  [1541] = {.lex_state = 62},
  [1542] = {.lex_state = 62},
  [1543] = {.lex_state = 62},
  [1544] = {.lex_state = 62},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 66},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 143},
  [1551] = {.lex_state = 143},
  [1552] = {.lex_state = 66},
  [1553] = {.lex_state = 66},
  [1554] = {.lex_state = 143},
  [1555] = {.lex_state = 66},
  [1556] = {.lex_state = 66},
  [1557] = {.lex_state = 143},
  [1558] = {.lex_state = 62},
  [1559] = {.lex_state = 143},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 61},
  [1562] = {.lex_state = 62},
  [1563] = {.lex_state = 58},
  [1564] = {.lex_state = 0},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 64},
  [1568] = {.lex_state = 58},
  [1569] = {.lex_state = 62},
  [1570] = {.lex_state = 62},
  [1571] = {.lex_state = 143},
  [1572] = {.lex_state = 62},
  [1573] = {.lex_state = 61},
  [1574] = {.lex_state = 143},
  [1575] = {.lex_state = 62},
  [1576] = {.lex_state = 58},
  [1577] = {.lex_state = 62},
  [1578] = {.lex_state = 62},
  [1579] = {.lex_state = 58},
  [1580] = {.lex_state = 143},
  [1581] = {.lex_state = 61},
  [1582] = {.lex_state = 143},
  [1583] = {.lex_state = 64},
  [1584] = {.lex_state = 64},
  [1585] = {.lex_state = 62},
  [1586] = {.lex_state = 61},
  [1587] = {.lex_state = 64},
  [1588] = {.lex_state = 64},
  [1589] = {.lex_state = 143},
  [1590] = {.lex_state = 64},
  [1591] = {.lex_state = 64},
  [1592] = {.lex_state = 143},
  [1593] = {.lex_state = 62},
  [1594] = {.lex_state = 62},
  [1595] = {.lex_state = 143},
  [1596] = {.lex_state = 62},
  [1597] = {.lex_state = 62},
  [1598] = {.lex_state = 143},
  [1599] = {.lex_state = 62},
  [1600] = {.lex_state = 62},
  [1601] = {.lex_state = 62},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 0},
  [1604] = {.lex_state = 62},
  [1605] = {.lex_state = 62},
  [1606] = {.lex_state = 62},
  [1607] = {.lex_state = 62},
  [1608] = {.lex_state = 143},
  [1609] = {.lex_state = 61},
  [1610] = {.lex_state = 143},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 143},
  [1613] = {.lex_state = 62},
  [1614] = {.lex_state = 143},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 62},
  [1617] = {.lex_state = 62},
  [1618] = {.lex_state = 143},
  [1619] = {.lex_state = 143},
  [1620] = {.lex_state = 143},
  [1621] = {.lex_state = 64},
  [1622] = {.lex_state = 64},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 61},
  [1625] = {.lex_state = 64},
  [1626] = {.lex_state = 62},
  [1627] = {.lex_state = 62},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 61},
  [1630] = {.lex_state = 62},
  [1631] = {.lex_state = 143},
  [1632] = {.lex_state = 61},
  [1633] = {.lex_state = 61},
  [1634] = {.lex_state = 61},
  [1635] = {.lex_state = 143},
  [1636] = {.lex_state = 53},
  [1637] = {.lex_state = 143},
  [1638] = {.lex_state = 143},
  [1639] = {.lex_state = 61},
  [1640] = {.lex_state = 143},
  [1641] = {.lex_state = 61},
  [1642] = {.lex_state = 61},
  [1643] = {.lex_state = 143},
  [1644] = {.lex_state = 61},
  [1645] = {.lex_state = 143},
  [1646] = {.lex_state = 143},
  [1647] = {.lex_state = 61},
  [1648] = {.lex_state = 62},
  [1649] = {.lex_state = 143},
  [1650] = {.lex_state = 143},
  [1651] = {.lex_state = 61},
  [1652] = {.lex_state = 143},
  [1653] = {.lex_state = 61},
  [1654] = {.lex_state = 61},
  [1655] = {.lex_state = 143},
  [1656] = {.lex_state = 61},
  [1657] = {.lex_state = 64},
  [1658] = {.lex_state = 143},
  [1659] = {.lex_state = 64},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 0},
  [1662] = {.lex_state = 0},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 36},
  [1665] = {.lex_state = 36},
  [1666] = {.lex_state = 36},
  [1667] = {.lex_state = 41},
  [1668] = {.lex_state = 62},
  [1669] = {.lex_state = 36},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 62},
  [1672] = {.lex_state = 36},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 62},
  [1675] = {.lex_state = 62},
  [1676] = {.lex_state = 62},
  [1677] = {.lex_state = 41},
  [1678] = {.lex_state = 62},
  [1679] = {.lex_state = 62},
  [1680] = {.lex_state = 36},
  [1681] = {.lex_state = 61},
  [1682] = {.lex_state = 61},
  [1683] = {.lex_state = 61},
  [1684] = {.lex_state = 61},
  [1685] = {.lex_state = 62},
  [1686] = {.lex_state = 62},
  [1687] = {.lex_state = 0},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 36},
  [1690] = {.lex_state = 0},
  [1691] = {.lex_state = 0},
  [1692] = {.lex_state = 43},
  [1693] = {.lex_state = 41},
  [1694] = {.lex_state = 62},
  [1695] = {.lex_state = 62},
  [1696] = {.lex_state = 62},
  [1697] = {.lex_state = 43},
  [1698] = {.lex_state = 41},
  [1699] = {.lex_state = 62},
  [1700] = {.lex_state = 62},
  [1701] = {.lex_state = 62},
  [1702] = {.lex_state = 62},
  [1703] = {.lex_state = 62},
  [1704] = {.lex_state = 62},
  [1705] = {.lex_state = 41},
  [1706] = {.lex_state = 62},
  [1707] = {.lex_state = 62},
  [1708] = {.lex_state = 62},
  [1709] = {.lex_state = 36},
  [1710] = {.lex_state = 62},
  [1711] = {.lex_state = 43},
  [1712] = {.lex_state = 41},
  [1713] = {.lex_state = 62},
  [1714] = {.lex_state = 43},
  [1715] = {.lex_state = 62},
  [1716] = {.lex_state = 62},
  [1717] = {.lex_state = 41},
  [1718] = {.lex_state = 62},
  [1719] = {.lex_state = 62},
  [1720] = {.lex_state = 43},
  [1721] = {.lex_state = 53},
  [1722] = {.lex_state = 36},
  [1723] = {.lex_state = 62},
  [1724] = {.lex_state = 62},
  [1725] = {.lex_state = 62},
  [1726] = {.lex_state = 62},
  [1727] = {.lex_state = 62},
  [1728] = {.lex_state = 62},
  [1729] = {.lex_state = 41},
  [1730] = {.lex_state = 41},
  [1731] = {.lex_state = 143},
  [1732] = {.lex_state = 38},
  [1733] = {.lex_state = 0},
  [1734] = {.lex_state = 0},
  [1735] = {.lex_state = 43},
  [1736] = {.lex_state = 0},
  [1737] = {.lex_state = 0},
  [1738] = {.lex_state = 0},
  [1739] = {.lex_state = 53},
  [1740] = {.lex_state = 62},
  [1741] = {.lex_state = 0},
  [1742] = {.lex_state = 62},
  [1743] = {.lex_state = 62},
  [1744] = {.lex_state = 0},
  [1745] = {.lex_state = 62},
  [1746] = {.lex_state = 0},
  [1747] = {.lex_state = 62},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 0},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 0},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 0},
  [1756] = {.lex_state = 0},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 38},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 53},
  [1764] = {.lex_state = 0},
  [1765] = {.lex_state = 53},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 43},
  [1768] = {.lex_state = 38},
  [1769] = {.lex_state = 38},
  [1770] = {.lex_state = 53},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 62},
  [1773] = {.lex_state = 0},
  [1774] = {.lex_state = 0},
  [1775] = {.lex_state = 0},
  [1776] = {.lex_state = 0},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 0},
  [1779] = {.lex_state = 53},
  [1780] = {.lex_state = 0},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 53},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 0},
  [1786] = {.lex_state = 0},
  [1787] = {.lex_state = 0},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 53},
  [1792] = {.lex_state = 0},
  [1793] = {.lex_state = 0},
  [1794] = {.lex_state = 62},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 0},
  [1797] = {.lex_state = 0},
  [1798] = {.lex_state = 0},
  [1799] = {.lex_state = 0},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 62},
  [1803] = {.lex_state = 0},
  [1804] = {.lex_state = 62},
  [1805] = {.lex_state = 38},
  [1806] = {.lex_state = 62},
  [1807] = {.lex_state = 43},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 62},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0},
  [1814] = {.lex_state = 43},
  [1815] = {.lex_state = 62},
  [1816] = {.lex_state = 62},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 0},
  [1819] = {.lex_state = 0},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 143},
  [1825] = {.lex_state = 143},
  [1826] = {.lex_state = 143},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 53},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 143},
  [1831] = {.lex_state = 143},
  [1832] = {.lex_state = 0},
  [1833] = {.lex_state = 37},
  [1834] = {.lex_state = 143},
  [1835] = {.lex_state = 143},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 143},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 53},
  [1843] = {.lex_state = 143},
  [1844] = {.lex_state = 143},
  [1845] = {.lex_state = 37},
  [1846] = {.lex_state = 143},
  [1847] = {.lex_state = 143},
  [1848] = {.lex_state = 143},
  [1849] = {.lex_state = 62},
  [1850] = {.lex_state = 143},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 143},
  [1854] = {.lex_state = 37},
  [1855] = {.lex_state = 143},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 37},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 37},
  [1861] = {.lex_state = 37},
  [1862] = {.lex_state = 37},
  [1863] = {.lex_state = 62},
  [1864] = {.lex_state = 62},
  [1865] = {.lex_state = 143},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 143},
  [1868] = {.lex_state = 143},
  [1869] = {.lex_state = 0},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 0},
  [1876] = {.lex_state = 143},
  [1877] = {.lex_state = 62},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 0},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 143},
  [1883] = {.lex_state = 143},
  [1884] = {.lex_state = 143},
  [1885] = {.lex_state = 37},
  [1886] = {.lex_state = 53},
  [1887] = {.lex_state = 0},
  [1888] = {.lex_state = 37},
  [1889] = {.lex_state = 37},
  [1890] = {.lex_state = 37},
  [1891] = {.lex_state = 143},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 62},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 37},
  [1896] = {.lex_state = 37},
  [1897] = {.lex_state = 0},
  [1898] = {.lex_state = 0},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 0},
  [1901] = {.lex_state = 37},
  [1902] = {.lex_state = 143},
  [1903] = {.lex_state = 0},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 143},
  [1906] = {.lex_state = 37},
  [1907] = {.lex_state = 0},
  [1908] = {.lex_state = 0},
  [1909] = {.lex_state = 37},
  [1910] = {.lex_state = 0},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 37},
  [1913] = {.lex_state = 37},
  [1914] = {.lex_state = 0},
  [1915] = {.lex_state = 37},
  [1916] = {.lex_state = 62},
  [1917] = {.lex_state = 143},
  [1918] = {.lex_state = 62},
  [1919] = {.lex_state = 37},
  [1920] = {.lex_state = 37},
  [1921] = {.lex_state = 143},
  [1922] = {.lex_state = 62},
  [1923] = {.lex_state = 143},
  [1924] = {.lex_state = 143},
  [1925] = {.lex_state = 0},
  [1926] = {.lex_state = 62},
  [1927] = {.lex_state = 62},
  [1928] = {.lex_state = 38},
  [1929] = {.lex_state = 0},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 62},
  [1932] = {.lex_state = 0},
  [1933] = {.lex_state = 38},
  [1934] = {.lex_state = 38},
  [1935] = {.lex_state = 38},
  [1936] = {.lex_state = 38},
  [1937] = {.lex_state = 51},
  [1938] = {.lex_state = 0},
  [1939] = {.lex_state = 51},
  [1940] = {.lex_state = 0},
  [1941] = {.lex_state = 38},
  [1942] = {.lex_state = 51},
  [1943] = {.lex_state = 0},
  [1944] = {.lex_state = 38},
  [1945] = {.lex_state = 0},
  [1946] = {.lex_state = 38},
  [1947] = {.lex_state = 0},
  [1948] = {.lex_state = 38},
  [1949] = {.lex_state = 51},
  [1950] = {.lex_state = 38},
  [1951] = {.lex_state = 0},
  [1952] = {.lex_state = 38},
  [1953] = {.lex_state = 0},
  [1954] = {.lex_state = 38},
  [1955] = {.lex_state = 143},
  [1956] = {.lex_state = 51},
  [1957] = {.lex_state = 0},
  [1958] = {.lex_state = 62},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 0},
  [1961] = {.lex_state = 0},
  [1962] = {.lex_state = 62},
  [1963] = {.lex_state = 0},
  [1964] = {.lex_state = 0},
  [1965] = {.lex_state = 51},
  [1966] = {.lex_state = 62},
  [1967] = {.lex_state = 0},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 0},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 51},
  [1972] = {.lex_state = 51},
  [1973] = {.lex_state = 51},
  [1974] = {.lex_state = 51},
  [1975] = {.lex_state = 51},
  [1976] = {.lex_state = 62},
  [1977] = {.lex_state = 51},
  [1978] = {.lex_state = 0},
  [1979] = {.lex_state = 0},
  [1980] = {.lex_state = 51},
  [1981] = {.lex_state = 51},
  [1982] = {.lex_state = 0},
  [1983] = {.lex_state = 51},
  [1984] = {.lex_state = 38},
  [1985] = {.lex_state = 51},
  [1986] = {.lex_state = 51},
  [1987] = {.lex_state = 143},
  [1988] = {.lex_state = 0},
  [1989] = {.lex_state = 51},
  [1990] = {.lex_state = 38},
  [1991] = {.lex_state = 51},
  [1992] = {.lex_state = 51},
  [1993] = {.lex_state = 0},
  [1994] = {.lex_state = 0},
  [1995] = {.lex_state = 0},
  [1996] = {.lex_state = 0},
  [1997] = {.lex_state = 38},
  [1998] = {.lex_state = 51},
  [1999] = {.lex_state = 62},
  [2000] = {.lex_state = 62},
  [2001] = {.lex_state = 51},
  [2002] = {.lex_state = 51},
  [2003] = {.lex_state = 0},
  [2004] = {.lex_state = 0},
  [2005] = {.lex_state = 0},
  [2006] = {.lex_state = 0},
  [2007] = {.lex_state = 38},
  [2008] = {.lex_state = 62},
  [2009] = {.lex_state = 62},
  [2010] = {.lex_state = 38},
  [2011] = {.lex_state = 143},
  [2012] = {.lex_state = 0},
  [2013] = {.lex_state = 0},
  [2014] = {.lex_state = 0},
  [2015] = {.lex_state = 143},
  [2016] = {.lex_state = 62},
  [2017] = {.lex_state = 62},
  [2018] = {.lex_state = 0},
  [2019] = {.lex_state = 62},
  [2020] = {.lex_state = 51},
  [2021] = {.lex_state = 0},
  [2022] = {.lex_state = 0},
  [2023] = {.lex_state = 51},
  [2024] = {.lex_state = 62},
  [2025] = {.lex_state = 0},
  [2026] = {.lex_state = 0},
  [2027] = {.lex_state = 62},
  [2028] = {.lex_state = 62},
  [2029] = {.lex_state = 0},
  [2030] = {.lex_state = 51},
  [2031] = {.lex_state = 0},
  [2032] = {.lex_state = 51},
  [2033] = {.lex_state = 51},
  [2034] = {.lex_state = 0},
  [2035] = {.lex_state = 62},
  [2036] = {.lex_state = 38},
  [2037] = {.lex_state = 51},
  [2038] = {.lex_state = 0},
  [2039] = {.lex_state = 62},
  [2040] = {.lex_state = 51},
  [2041] = {.lex_state = 0},
  [2042] = {.lex_state = 51},
  [2043] = {.lex_state = 51},
  [2044] = {.lex_state = 38},
  [2045] = {.lex_state = 62},
  [2046] = {.lex_state = 0},
  [2047] = {.lex_state = 0},
  [2048] = {.lex_state = 0},
  [2049] = {.lex_state = 51},
  [2050] = {.lex_state = 51},
  [2051] = {.lex_state = 38},
  [2052] = {.lex_state = 0},
  [2053] = {.lex_state = 62},
  [2054] = {.lex_state = 62},
  [2055] = {.lex_state = 62},
  [2056] = {.lex_state = 0},
  [2057] = {.lex_state = 0},
  [2058] = {.lex_state = 0},
  [2059] = {.lex_state = 62},
  [2060] = {.lex_state = 51},
  [2061] = {.lex_state = 51},
  [2062] = {.lex_state = 0},
  [2063] = {.lex_state = 38},
  [2064] = {.lex_state = 0},
  [2065] = {.lex_state = 38},
  [2066] = {.lex_state = 38},
  [2067] = {.lex_state = 0},
  [2068] = {.lex_state = 38},
  [2069] = {.lex_state = 0},
  [2070] = {.lex_state = 62},
  [2071] = {.lex_state = 62},
  [2072] = {.lex_state = 0},
  [2073] = {.lex_state = 0},
  [2074] = {.lex_state = 62},
  [2075] = {.lex_state = 62},
  [2076] = {.lex_state = 62},
  [2077] = {.lex_state = 0},
  [2078] = {.lex_state = 0},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 0},
  [2081] = {.lex_state = 143},
  [2082] = {.lex_state = 0},
  [2083] = {.lex_state = 0},
  [2084] = {.lex_state = 143},
  [2085] = {.lex_state = 0},
  [2086] = {.lex_state = 0},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 0},
  [2090] = {.lex_state = 0},
  [2091] = {.lex_state = 0},
  [2092] = {.lex_state = 62},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 38},
  [2096] = {.lex_state = 0},
  [2097] = {.lex_state = 62},
  [2098] = {.lex_state = 38},
  [2099] = {.lex_state = 38},
  [2100] = {.lex_state = 51},
  [2101] = {.lex_state = 0},
  [2102] = {.lex_state = 0},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 62},
  [2105] = {.lex_state = 62},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 51},
  [2108] = {.lex_state = 51},
  [2109] = {.lex_state = 51},
  [2110] = {.lex_state = 51},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 38},
  [2114] = {.lex_state = 0},
  [2115] = {.lex_state = 51},
  [2116] = {.lex_state = 38},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 0},
  [2119] = {.lex_state = 51},
  [2120] = {.lex_state = 51},
  [2121] = {.lex_state = 0},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 38},
  [2124] = {.lex_state = 0},
  [2125] = {.lex_state = 0},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 0},
  [2128] = {.lex_state = 0},
  [2129] = {.lex_state = 0},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 0},
  [2132] = {.lex_state = 51},
  [2133] = {.lex_state = 143},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 51},
  [2136] = {.lex_state = 62},
  [2137] = {.lex_state = 62},
  [2138] = {.lex_state = 51},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 51},
  [2141] = {.lex_state = 62},
  [2142] = {.lex_state = 38},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 62},
  [2146] = {.lex_state = 0},
  [2147] = {.lex_state = 0},
  [2148] = {.lex_state = 62},
  [2149] = {.lex_state = 0},
  [2150] = {.lex_state = 0},
  [2151] = {.lex_state = 0},
  [2152] = {.lex_state = 51},
  [2153] = {.lex_state = 62},
  [2154] = {.lex_state = 62},
  [2155] = {.lex_state = 62},
  [2156] = {.lex_state = 51},
  [2157] = {.lex_state = 38},
  [2158] = {.lex_state = 0},
  [2159] = {.lex_state = 38},
  [2160] = {.lex_state = 143},
  [2161] = {.lex_state = 62},
  [2162] = {.lex_state = 51},
  [2163] = {.lex_state = 0},
  [2164] = {.lex_state = 0},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 38},
  [2167] = {.lex_state = 51},
  [2168] = {.lex_state = 0},
  [2169] = {.lex_state = 62},
  [2170] = {.lex_state = 0},
  [2171] = {.lex_state = 0},
  [2172] = {.lex_state = 62},
  [2173] = {.lex_state = 0},
  [2174] = {.lex_state = 0},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 0},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 62},
  [2180] = {.lex_state = 51},
  [2181] = {.lex_state = 51},
  [2182] = {.lex_state = 0},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 38},
  [2185] = {.lex_state = 0},
  [2186] = {.lex_state = 51},
  [2187] = {.lex_state = 0},
  [2188] = {.lex_state = 38},
  [2189] = {.lex_state = 0},
  [2190] = {.lex_state = 0},
  [2191] = {.lex_state = 0},
  [2192] = {.lex_state = 143},
  [2193] = {.lex_state = 143},
  [2194] = {.lex_state = 143},
  [2195] = {.lex_state = 62},
  [2196] = {.lex_state = 0},
  [2197] = {.lex_state = 0},
  [2198] = {.lex_state = 0},
  [2199] = {.lex_state = 143},
  [2200] = {.lex_state = 0},
  [2201] = {.lex_state = 0},
  [2202] = {.lex_state = 38},
  [2203] = {.lex_state = 143},
  [2204] = {.lex_state = 38},
  [2205] = {.lex_state = 0},
  [2206] = {.lex_state = 143},
  [2207] = {.lex_state = 143},
  [2208] = {.lex_state = 0},
  [2209] = {.lex_state = 143},
  [2210] = {.lex_state = 143},
  [2211] = {.lex_state = 0},
  [2212] = {.lex_state = 62},
  [2213] = {.lex_state = 143},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym___extension__] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym___attribute__] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym___declspec] = ACTIONS(1),
    [anon_sym___based] = ACTIONS(1),
    [anon_sym___cdecl] = ACTIONS(1),
    [anon_sym___clrcall] = ACTIONS(1),
    [anon_sym___stdcall] = ACTIONS(1),
    [anon_sym___fastcall] = ACTIONS(1),
    [anon_sym___thiscall] = ACTIONS(1),
    [anon_sym___vectorcall] = ACTIONS(1),
    [sym_ms_restrict_modifier] = ACTIONS(1),
    [sym_ms_unsigned_ptr_modifier] = ACTIONS(1),
    [sym_ms_signed_ptr_modifier] = ACTIONS(1),
    [anon_sym__unaligned] = ACTIONS(1),
    [anon_sym___unaligned] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_auto] = ACTIONS(1),
    [anon_sym_register] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym___inline] = ACTIONS(1),
    [anon_sym___inline__] = ACTIONS(1),
    [anon_sym___forceinline] = ACTIONS(1),
    [anon_sym_thread_local] = ACTIONS(1),
    [anon_sym___thread] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_constexpr] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_restrict] = ACTIONS(1),
    [anon_sym___restrict__] = ACTIONS(1),
    [anon_sym__Atomic] = ACTIONS(1),
    [anon_sym__Noreturn] = ACTIONS(1),
    [anon_sym_noreturn] = ACTIONS(1),
    [sym_primitive_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym___try] = ACTIONS(1),
    [anon_sym___except] = ACTIONS(1),
    [anon_sym___finally] = ACTIONS(1),
    [anon_sym___leave] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym___alignof__] = ACTIONS(1),
    [anon_sym___alignof] = ACTIONS(1),
    [anon_sym__alignof] = ACTIONS(1),
    [anon_sym_alignof] = ACTIONS(1),
    [anon_sym__Alignof] = ACTIONS(1),
    [anon_sym_offsetof] = ACTIONS(1),
    [anon_sym__Generic] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym___asm__] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_SQUOTE] = ACTIONS(1),
    [anon_sym_u_SQUOTE] = ACTIONS(1),
    [anon_sym_U_SQUOTE] = ACTIONS(1),
    [anon_sym_u8_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_nullptr] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_translation_unit] = STATE(2189),
    [sym_preproc_include] = STATE(53),
    [sym_preproc_def] = STATE(53),
    [sym_preproc_function_def] = STATE(53),
    [sym_preproc_call] = STATE(53),
    [sym_preproc_if] = STATE(53),
    [sym_preproc_ifdef] = STATE(53),
    [sym_function_definition] = STATE(53),
    [sym__old_style_function_definition] = STATE(475),
    [sym_declaration] = STATE(53),
    [sym_type_definition] = STATE(53),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1474),
    [sym_linkage_specification] = STATE(53),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(857),
    [sym_compound_statement] = STATE(53),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1123),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(53),
    [sym_labeled_statement] = STATE(53),
    [sym__top_level_expression_statement] = STATE(53),
    [sym_if_statement] = STATE(53),
    [sym_switch_statement] = STATE(53),
    [sym_case_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_do_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_return_statement] = STATE(53),
    [sym_break_statement] = STATE(53),
    [sym_continue_statement] = STATE(53),
    [sym_goto_statement] = STATE(53),
    [sym__expression] = STATE(1300),
    [sym__expression_not_binary] = STATE(1303),
    [sym_conditional_expression] = STATE(1303),
    [sym_assignment_expression] = STATE(1303),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(1303),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(1303),
    [sym_cast_expression] = STATE(1303),
    [sym_sizeof_expression] = STATE(1303),
    [sym_alignof_expression] = STATE(1303),
    [sym_offsetof_expression] = STATE(1303),
    [sym_generic_expression] = STATE(1303),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(1303),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(1303),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(1303),
    [sym_concatenated_string] = STATE(1303),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(1303),
    [sym__empty_declaration] = STATE(53),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_translation_unit_repeat1] = STATE(53),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(61),
    [anon_sym_default] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(91),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2135),
    [sym_preproc_elif] = STATE(2135),
    [sym_preproc_elifdef] = STATE(2135),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(109),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2138),
    [sym_preproc_elif] = STATE(2138),
    [sym_preproc_elifdef] = STATE(2138),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(161),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_preproc_include] = STATE(2),
    [sym_preproc_def] = STATE(2),
    [sym_preproc_function_def] = STATE(2),
    [sym_preproc_call] = STATE(2),
    [sym_preproc_if] = STATE(2),
    [sym_preproc_ifdef] = STATE(2),
    [sym_preproc_else] = STATE(2100),
    [sym_preproc_elif] = STATE(2100),
    [sym_preproc_elifdef] = STATE(2100),
    [sym_function_definition] = STATE(2),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(2),
    [sym_type_definition] = STATE(2),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(2),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(2),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(2),
    [sym_labeled_statement] = STATE(2),
    [sym_expression_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_switch_statement] = STATE(2),
    [sym_case_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_do_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_return_statement] = STATE(2),
    [sym_break_statement] = STATE(2),
    [sym_continue_statement] = STATE(2),
    [sym_goto_statement] = STATE(2),
    [sym_seh_try_statement] = STATE(2),
    [sym_seh_leave_statement] = STATE(2),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(2),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(2),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(163),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(1977),
    [sym_preproc_elif] = STATE(1977),
    [sym_preproc_elifdef] = STATE(1977),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(165),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2049),
    [sym_preproc_elif] = STATE(2049),
    [sym_preproc_elifdef] = STATE(2049),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_preproc_include] = STATE(3),
    [sym_preproc_def] = STATE(3),
    [sym_preproc_function_def] = STATE(3),
    [sym_preproc_call] = STATE(3),
    [sym_preproc_if] = STATE(3),
    [sym_preproc_ifdef] = STATE(3),
    [sym_preproc_else] = STATE(2162),
    [sym_preproc_elif] = STATE(2162),
    [sym_preproc_elifdef] = STATE(2162),
    [sym_function_definition] = STATE(3),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(3),
    [sym_type_definition] = STATE(3),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(3),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(3),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_case_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_goto_statement] = STATE(3),
    [sym_seh_try_statement] = STATE(3),
    [sym_seh_leave_statement] = STATE(3),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(3),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(3),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(169),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_preproc_include] = STATE(5),
    [sym_preproc_def] = STATE(5),
    [sym_preproc_function_def] = STATE(5),
    [sym_preproc_call] = STATE(5),
    [sym_preproc_if] = STATE(5),
    [sym_preproc_ifdef] = STATE(5),
    [sym_preproc_else] = STATE(1989),
    [sym_preproc_elif] = STATE(1989),
    [sym_preproc_elifdef] = STATE(1989),
    [sym_function_definition] = STATE(5),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(5),
    [sym_type_definition] = STATE(5),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(5),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(5),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(5),
    [sym_labeled_statement] = STATE(5),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_switch_statement] = STATE(5),
    [sym_case_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_goto_statement] = STATE(5),
    [sym_seh_try_statement] = STATE(5),
    [sym_seh_leave_statement] = STATE(5),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(5),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(5),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(171),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_preproc_else] = STATE(2109),
    [sym_preproc_elif] = STATE(2109),
    [sym_preproc_elifdef] = STATE(2109),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(173),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_preproc_include] = STATE(9),
    [sym_preproc_def] = STATE(9),
    [sym_preproc_function_def] = STATE(9),
    [sym_preproc_call] = STATE(9),
    [sym_preproc_if] = STATE(9),
    [sym_preproc_ifdef] = STATE(9),
    [sym_preproc_else] = STATE(2152),
    [sym_preproc_elif] = STATE(2152),
    [sym_preproc_elifdef] = STATE(2152),
    [sym_function_definition] = STATE(9),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(9),
    [sym_type_definition] = STATE(9),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(9),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(9),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_case_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_goto_statement] = STATE(9),
    [sym_seh_try_statement] = STATE(9),
    [sym_seh_leave_statement] = STATE(9),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(9),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(9),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(175),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_preproc_include] = STATE(6),
    [sym_preproc_def] = STATE(6),
    [sym_preproc_function_def] = STATE(6),
    [sym_preproc_call] = STATE(6),
    [sym_preproc_if] = STATE(6),
    [sym_preproc_ifdef] = STATE(6),
    [sym_preproc_else] = STATE(1956),
    [sym_preproc_elif] = STATE(1956),
    [sym_preproc_elifdef] = STATE(1956),
    [sym_function_definition] = STATE(6),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(6),
    [sym_type_definition] = STATE(6),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(6),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(6),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_case_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_goto_statement] = STATE(6),
    [sym_seh_try_statement] = STATE(6),
    [sym_seh_leave_statement] = STATE(6),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(6),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(6),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(101),
    [aux_sym_preproc_include_token1] = ACTIONS(103),
    [aux_sym_preproc_def_token1] = ACTIONS(105),
    [aux_sym_preproc_if_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token2] = ACTIONS(177),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(111),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(117),
    [sym_preproc_directive] = ACTIONS(119),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(127),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_preproc_include] = STATE(25),
    [sym_preproc_def] = STATE(25),
    [sym_preproc_function_def] = STATE(25),
    [sym_preproc_call] = STATE(25),
    [sym_preproc_if] = STATE(25),
    [sym_preproc_ifdef] = STATE(25),
    [sym_preproc_else] = STATE(2132),
    [sym_preproc_elif] = STATE(2132),
    [sym_function_definition] = STATE(25),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(25),
    [sym_type_definition] = STATE(25),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(25),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(25),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_case_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_goto_statement] = STATE(25),
    [sym_seh_try_statement] = STATE(25),
    [sym_seh_leave_statement] = STATE(25),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(25),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(25),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(187),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_preproc_include] = STATE(18),
    [sym_preproc_def] = STATE(18),
    [sym_preproc_function_def] = STATE(18),
    [sym_preproc_call] = STATE(18),
    [sym_preproc_if] = STATE(18),
    [sym_preproc_ifdef] = STATE(18),
    [sym_preproc_else] = STATE(2050),
    [sym_preproc_elif] = STATE(2050),
    [sym_function_definition] = STATE(18),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(18),
    [sym_type_definition] = STATE(18),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(18),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(18),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_case_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_goto_statement] = STATE(18),
    [sym_seh_try_statement] = STATE(18),
    [sym_seh_leave_statement] = STATE(18),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(18),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(18),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2120),
    [sym_preproc_elif] = STATE(2120),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(231),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2061),
    [sym_preproc_elif] = STATE(2061),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(233),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_preproc_include] = STATE(23),
    [sym_preproc_def] = STATE(23),
    [sym_preproc_function_def] = STATE(23),
    [sym_preproc_call] = STATE(23),
    [sym_preproc_if] = STATE(23),
    [sym_preproc_ifdef] = STATE(23),
    [sym_preproc_else] = STATE(2060),
    [sym_preproc_elif] = STATE(2060),
    [sym_function_definition] = STATE(23),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(23),
    [sym_type_definition] = STATE(23),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(23),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(23),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_case_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_goto_statement] = STATE(23),
    [sym_seh_try_statement] = STATE(23),
    [sym_seh_leave_statement] = STATE(23),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(23),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(23),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(235),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(1965),
    [sym_preproc_elif] = STATE(1965),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(237),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2033),
    [sym_preproc_elif] = STATE(2033),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(239),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_preproc_include] = STATE(21),
    [sym_preproc_def] = STATE(21),
    [sym_preproc_function_def] = STATE(21),
    [sym_preproc_call] = STATE(21),
    [sym_preproc_if] = STATE(21),
    [sym_preproc_ifdef] = STATE(21),
    [sym_preproc_else] = STATE(1992),
    [sym_preproc_elif] = STATE(1992),
    [sym_function_definition] = STATE(21),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(21),
    [sym_type_definition] = STATE(21),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(21),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(21),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_case_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_goto_statement] = STATE(21),
    [sym_seh_try_statement] = STATE(21),
    [sym_seh_leave_statement] = STATE(21),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(21),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(21),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(241),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_preproc_include] = STATE(14),
    [sym_preproc_def] = STATE(14),
    [sym_preproc_function_def] = STATE(14),
    [sym_preproc_call] = STATE(14),
    [sym_preproc_if] = STATE(14),
    [sym_preproc_ifdef] = STATE(14),
    [sym_preproc_else] = STATE(2140),
    [sym_preproc_elif] = STATE(2140),
    [sym_function_definition] = STATE(14),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(14),
    [sym_type_definition] = STATE(14),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(14),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(14),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_case_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_goto_statement] = STATE(14),
    [sym_seh_try_statement] = STATE(14),
    [sym_seh_leave_statement] = STATE(14),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(14),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(14),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(243),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(1949),
    [sym_preproc_elif] = STATE(1949),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(245),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_preproc_include] = STATE(15),
    [sym_preproc_def] = STATE(15),
    [sym_preproc_function_def] = STATE(15),
    [sym_preproc_call] = STATE(15),
    [sym_preproc_if] = STATE(15),
    [sym_preproc_ifdef] = STATE(15),
    [sym_preproc_else] = STATE(2110),
    [sym_preproc_elif] = STATE(2110),
    [sym_function_definition] = STATE(15),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(15),
    [sym_type_definition] = STATE(15),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(15),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(15),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_case_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_goto_statement] = STATE(15),
    [sym_seh_try_statement] = STATE(15),
    [sym_seh_leave_statement] = STATE(15),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(15),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(15),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(247),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(1991),
    [sym_preproc_elif] = STATE(1991),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(249),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_preproc_include] = STATE(17),
    [sym_preproc_def] = STATE(17),
    [sym_preproc_function_def] = STATE(17),
    [sym_preproc_call] = STATE(17),
    [sym_preproc_if] = STATE(17),
    [sym_preproc_ifdef] = STATE(17),
    [sym_preproc_else] = STATE(1983),
    [sym_preproc_elif] = STATE(1983),
    [sym_function_definition] = STATE(17),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(17),
    [sym_type_definition] = STATE(17),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(17),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(17),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_case_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_goto_statement] = STATE(17),
    [sym_seh_try_statement] = STATE(17),
    [sym_seh_leave_statement] = STATE(17),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(17),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(17),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(251),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(2156),
    [sym_preproc_elif] = STATE(2156),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(179),
    [aux_sym_preproc_include_token1] = ACTIONS(181),
    [aux_sym_preproc_def_token1] = ACTIONS(183),
    [aux_sym_preproc_if_token1] = ACTIONS(185),
    [aux_sym_preproc_if_token2] = ACTIONS(253),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(189),
    [aux_sym_preproc_else_token1] = ACTIONS(113),
    [aux_sym_preproc_elif_token1] = ACTIONS(115),
    [sym_preproc_directive] = ACTIONS(191),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(199),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(207),
    [anon_sym_default] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(137),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1478),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(852),
    [sym_compound_statement] = STATE(26),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1127),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(26),
    [sym_labeled_statement] = STATE(26),
    [sym_expression_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_switch_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_do_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_return_statement] = STATE(26),
    [sym_break_statement] = STATE(26),
    [sym_continue_statement] = STATE(26),
    [sym_goto_statement] = STATE(26),
    [sym_seh_try_statement] = STATE(26),
    [sym_seh_leave_statement] = STATE(26),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(255),
    [aux_sym_preproc_include_token1] = ACTIONS(258),
    [aux_sym_preproc_def_token1] = ACTIONS(261),
    [aux_sym_preproc_if_token1] = ACTIONS(264),
    [aux_sym_preproc_if_token2] = ACTIONS(267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(269),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(269),
    [aux_sym_preproc_else_token1] = ACTIONS(267),
    [aux_sym_preproc_elif_token1] = ACTIONS(267),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(267),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(267),
    [sym_preproc_directive] = ACTIONS(272),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym___extension__] = ACTIONS(290),
    [anon_sym_typedef] = ACTIONS(293),
    [anon_sym_extern] = ACTIONS(296),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(338),
    [anon_sym_case] = ACTIONS(341),
    [anon_sym_default] = ACTIONS(344),
    [anon_sym_while] = ACTIONS(347),
    [anon_sym_do] = ACTIONS(350),
    [anon_sym_for] = ACTIONS(353),
    [anon_sym_return] = ACTIONS(356),
    [anon_sym_break] = ACTIONS(359),
    [anon_sym_continue] = ACTIONS(362),
    [anon_sym_goto] = ACTIONS(365),
    [anon_sym___try] = ACTIONS(368),
    [anon_sym___leave] = ACTIONS(371),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(218),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1475),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(856),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1126),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym_seh_try_statement] = STATE(27),
    [sym_seh_leave_statement] = STATE(27),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(407),
    [aux_sym_preproc_include_token1] = ACTIONS(410),
    [aux_sym_preproc_def_token1] = ACTIONS(413),
    [aux_sym_preproc_if_token1] = ACTIONS(416),
    [aux_sym_preproc_if_token2] = ACTIONS(267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(419),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(419),
    [aux_sym_preproc_else_token1] = ACTIONS(267),
    [aux_sym_preproc_elif_token1] = ACTIONS(267),
    [sym_preproc_directive] = ACTIONS(422),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(425),
    [anon_sym___extension__] = ACTIONS(428),
    [anon_sym_typedef] = ACTIONS(431),
    [anon_sym_extern] = ACTIONS(434),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(437),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(443),
    [anon_sym_case] = ACTIONS(446),
    [anon_sym_default] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_do] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_return] = ACTIONS(461),
    [anon_sym_break] = ACTIONS(464),
    [anon_sym_continue] = ACTIONS(467),
    [anon_sym_goto] = ACTIONS(470),
    [anon_sym___try] = ACTIONS(473),
    [anon_sym___leave] = ACTIONS(476),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_preproc_include] = STATE(51),
    [sym_preproc_def] = STATE(51),
    [sym_preproc_function_def] = STATE(51),
    [sym_preproc_call] = STATE(51),
    [sym_preproc_if] = STATE(51),
    [sym_preproc_ifdef] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(51),
    [sym_type_definition] = STATE(51),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(51),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(51),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(51),
    [sym_labeled_statement] = STATE(51),
    [sym_expression_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_switch_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_do_statement] = STATE(51),
    [sym_for_statement] = STATE(51),
    [sym_return_statement] = STATE(51),
    [sym_break_statement] = STATE(51),
    [sym_continue_statement] = STATE(51),
    [sym_goto_statement] = STATE(51),
    [sym_seh_try_statement] = STATE(51),
    [sym_seh_leave_statement] = STATE(51),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(51),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(51),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_preproc_include] = STATE(42),
    [sym_preproc_def] = STATE(42),
    [sym_preproc_function_def] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym_preproc_if] = STATE(42),
    [sym_preproc_ifdef] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(42),
    [sym_type_definition] = STATE(42),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(42),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(42),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(42),
    [sym_labeled_statement] = STATE(42),
    [sym_expression_statement] = STATE(42),
    [sym_if_statement] = STATE(42),
    [sym_switch_statement] = STATE(42),
    [sym_case_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_do_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_return_statement] = STATE(42),
    [sym_break_statement] = STATE(42),
    [sym_continue_statement] = STATE(42),
    [sym_goto_statement] = STATE(42),
    [sym_seh_try_statement] = STATE(42),
    [sym_seh_leave_statement] = STATE(42),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(42),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(42),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_preproc_include] = STATE(50),
    [sym_preproc_def] = STATE(50),
    [sym_preproc_function_def] = STATE(50),
    [sym_preproc_call] = STATE(50),
    [sym_preproc_if] = STATE(50),
    [sym_preproc_ifdef] = STATE(50),
    [sym_function_definition] = STATE(50),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(50),
    [sym_type_definition] = STATE(50),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(50),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(50),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(50),
    [sym_labeled_statement] = STATE(50),
    [sym_expression_statement] = STATE(50),
    [sym_if_statement] = STATE(50),
    [sym_switch_statement] = STATE(50),
    [sym_case_statement] = STATE(50),
    [sym_while_statement] = STATE(50),
    [sym_do_statement] = STATE(50),
    [sym_for_statement] = STATE(50),
    [sym_return_statement] = STATE(50),
    [sym_break_statement] = STATE(50),
    [sym_continue_statement] = STATE(50),
    [sym_goto_statement] = STATE(50),
    [sym_seh_try_statement] = STATE(50),
    [sym_seh_leave_statement] = STATE(50),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(50),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(50),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(535),
    [aux_sym_preproc_include_token1] = ACTIONS(538),
    [aux_sym_preproc_def_token1] = ACTIONS(541),
    [aux_sym_preproc_if_token1] = ACTIONS(544),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(547),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(547),
    [sym_preproc_directive] = ACTIONS(550),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(553),
    [anon_sym___extension__] = ACTIONS(556),
    [anon_sym_typedef] = ACTIONS(559),
    [anon_sym_extern] = ACTIONS(562),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(565),
    [anon_sym_RBRACE] = ACTIONS(568),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(570),
    [anon_sym_switch] = ACTIONS(573),
    [anon_sym_case] = ACTIONS(576),
    [anon_sym_default] = ACTIONS(579),
    [anon_sym_while] = ACTIONS(582),
    [anon_sym_do] = ACTIONS(585),
    [anon_sym_for] = ACTIONS(588),
    [anon_sym_return] = ACTIONS(591),
    [anon_sym_break] = ACTIONS(594),
    [anon_sym_continue] = ACTIONS(597),
    [anon_sym_goto] = ACTIONS(600),
    [anon_sym___try] = ACTIONS(603),
    [anon_sym___leave] = ACTIONS(606),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(609),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(611),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_seh_try_statement] = STATE(34),
    [sym_seh_leave_statement] = STATE(34),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(34),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(34),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(613),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_preproc_include] = STATE(46),
    [sym_preproc_def] = STATE(46),
    [sym_preproc_function_def] = STATE(46),
    [sym_preproc_call] = STATE(46),
    [sym_preproc_if] = STATE(46),
    [sym_preproc_ifdef] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(46),
    [sym_type_definition] = STATE(46),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(46),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(46),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(46),
    [sym_labeled_statement] = STATE(46),
    [sym_expression_statement] = STATE(46),
    [sym_if_statement] = STATE(46),
    [sym_switch_statement] = STATE(46),
    [sym_case_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_do_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_return_statement] = STATE(46),
    [sym_break_statement] = STATE(46),
    [sym_continue_statement] = STATE(46),
    [sym_goto_statement] = STATE(46),
    [sym_seh_try_statement] = STATE(46),
    [sym_seh_leave_statement] = STATE(46),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(46),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(46),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(615),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(44),
    [sym_labeled_statement] = STATE(44),
    [sym_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym_seh_try_statement] = STATE(44),
    [sym_seh_leave_statement] = STATE(44),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(44),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(44),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(617),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(619),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_preproc_include] = STATE(38),
    [sym_preproc_def] = STATE(38),
    [sym_preproc_function_def] = STATE(38),
    [sym_preproc_call] = STATE(38),
    [sym_preproc_if] = STATE(38),
    [sym_preproc_ifdef] = STATE(38),
    [sym_function_definition] = STATE(38),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(38),
    [sym_type_definition] = STATE(38),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(38),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(38),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(38),
    [sym_labeled_statement] = STATE(38),
    [sym_expression_statement] = STATE(38),
    [sym_if_statement] = STATE(38),
    [sym_switch_statement] = STATE(38),
    [sym_case_statement] = STATE(38),
    [sym_while_statement] = STATE(38),
    [sym_do_statement] = STATE(38),
    [sym_for_statement] = STATE(38),
    [sym_return_statement] = STATE(38),
    [sym_break_statement] = STATE(38),
    [sym_continue_statement] = STATE(38),
    [sym_goto_statement] = STATE(38),
    [sym_seh_try_statement] = STATE(38),
    [sym_seh_leave_statement] = STATE(38),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(38),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(38),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(621),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_preproc_include] = STATE(29),
    [sym_preproc_def] = STATE(29),
    [sym_preproc_function_def] = STATE(29),
    [sym_preproc_call] = STATE(29),
    [sym_preproc_if] = STATE(29),
    [sym_preproc_ifdef] = STATE(29),
    [sym_function_definition] = STATE(29),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(29),
    [sym_type_definition] = STATE(29),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(29),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(29),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(29),
    [sym_labeled_statement] = STATE(29),
    [sym_expression_statement] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_switch_statement] = STATE(29),
    [sym_case_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_do_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_return_statement] = STATE(29),
    [sym_break_statement] = STATE(29),
    [sym_continue_statement] = STATE(29),
    [sym_goto_statement] = STATE(29),
    [sym_seh_try_statement] = STATE(29),
    [sym_seh_leave_statement] = STATE(29),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(29),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(29),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(623),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(625),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(627),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_preproc_include] = STATE(41),
    [sym_preproc_def] = STATE(41),
    [sym_preproc_function_def] = STATE(41),
    [sym_preproc_call] = STATE(41),
    [sym_preproc_if] = STATE(41),
    [sym_preproc_ifdef] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(41),
    [sym_type_definition] = STATE(41),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(41),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(41),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(41),
    [sym_labeled_statement] = STATE(41),
    [sym_expression_statement] = STATE(41),
    [sym_if_statement] = STATE(41),
    [sym_switch_statement] = STATE(41),
    [sym_case_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_do_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_return_statement] = STATE(41),
    [sym_break_statement] = STATE(41),
    [sym_continue_statement] = STATE(41),
    [sym_goto_statement] = STATE(41),
    [sym_seh_try_statement] = STATE(41),
    [sym_seh_leave_statement] = STATE(41),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(41),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(41),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(629),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(631),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_preproc_include] = STATE(45),
    [sym_preproc_def] = STATE(45),
    [sym_preproc_function_def] = STATE(45),
    [sym_preproc_call] = STATE(45),
    [sym_preproc_if] = STATE(45),
    [sym_preproc_ifdef] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym__old_style_function_definition] = STATE(403),
    [sym_declaration] = STATE(45),
    [sym_type_definition] = STATE(45),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1476),
    [sym_linkage_specification] = STATE(45),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(854),
    [sym_compound_statement] = STATE(45),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1120),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(45),
    [sym_labeled_statement] = STATE(45),
    [sym_expression_statement] = STATE(45),
    [sym_if_statement] = STATE(45),
    [sym_switch_statement] = STATE(45),
    [sym_case_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_do_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_return_statement] = STATE(45),
    [sym_break_statement] = STATE(45),
    [sym_continue_statement] = STATE(45),
    [sym_goto_statement] = STATE(45),
    [sym_seh_try_statement] = STATE(45),
    [sym_seh_leave_statement] = STATE(45),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(45),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(45),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(633),
    [aux_sym_preproc_include_token1] = ACTIONS(636),
    [aux_sym_preproc_def_token1] = ACTIONS(639),
    [aux_sym_preproc_if_token1] = ACTIONS(642),
    [aux_sym_preproc_if_token2] = ACTIONS(267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(645),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(645),
    [sym_preproc_directive] = ACTIONS(648),
    [anon_sym_LPAREN2] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym___extension__] = ACTIONS(654),
    [anon_sym_typedef] = ACTIONS(657),
    [anon_sym_extern] = ACTIONS(660),
    [anon_sym___attribute__] = ACTIONS(299),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(302),
    [anon_sym___declspec] = ACTIONS(305),
    [anon_sym___cdecl] = ACTIONS(308),
    [anon_sym___clrcall] = ACTIONS(308),
    [anon_sym___stdcall] = ACTIONS(308),
    [anon_sym___fastcall] = ACTIONS(308),
    [anon_sym___thiscall] = ACTIONS(308),
    [anon_sym___vectorcall] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_signed] = ACTIONS(314),
    [anon_sym_unsigned] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_auto] = ACTIONS(317),
    [anon_sym_register] = ACTIONS(317),
    [anon_sym_inline] = ACTIONS(317),
    [anon_sym___inline] = ACTIONS(317),
    [anon_sym___inline__] = ACTIONS(317),
    [anon_sym___forceinline] = ACTIONS(317),
    [anon_sym_thread_local] = ACTIONS(317),
    [anon_sym___thread] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(320),
    [anon_sym_constexpr] = ACTIONS(320),
    [anon_sym_volatile] = ACTIONS(320),
    [anon_sym_restrict] = ACTIONS(320),
    [anon_sym___restrict__] = ACTIONS(320),
    [anon_sym__Atomic] = ACTIONS(320),
    [anon_sym__Noreturn] = ACTIONS(320),
    [anon_sym_noreturn] = ACTIONS(320),
    [sym_primitive_type] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(326),
    [anon_sym_struct] = ACTIONS(329),
    [anon_sym_union] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(666),
    [anon_sym_switch] = ACTIONS(669),
    [anon_sym_case] = ACTIONS(672),
    [anon_sym_default] = ACTIONS(675),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_do] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(684),
    [anon_sym_return] = ACTIONS(687),
    [anon_sym_break] = ACTIONS(690),
    [anon_sym_continue] = ACTIONS(693),
    [anon_sym_goto] = ACTIONS(696),
    [anon_sym___try] = ACTIONS(699),
    [anon_sym___leave] = ACTIONS(702),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_sizeof] = ACTIONS(377),
    [anon_sym___alignof__] = ACTIONS(380),
    [anon_sym___alignof] = ACTIONS(380),
    [anon_sym__alignof] = ACTIONS(380),
    [anon_sym_alignof] = ACTIONS(380),
    [anon_sym__Alignof] = ACTIONS(380),
    [anon_sym_offsetof] = ACTIONS(383),
    [anon_sym__Generic] = ACTIONS(386),
    [anon_sym_asm] = ACTIONS(389),
    [anon_sym___asm__] = ACTIONS(389),
    [sym_number_literal] = ACTIONS(392),
    [anon_sym_L_SQUOTE] = ACTIONS(395),
    [anon_sym_u_SQUOTE] = ACTIONS(395),
    [anon_sym_U_SQUOTE] = ACTIONS(395),
    [anon_sym_u8_SQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_L_DQUOTE] = ACTIONS(398),
    [anon_sym_u_DQUOTE] = ACTIONS(398),
    [anon_sym_U_DQUOTE] = ACTIONS(398),
    [anon_sym_u8_DQUOTE] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [anon_sym_NULL] = ACTIONS(404),
    [anon_sym_nullptr] = ACTIONS(404),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(705),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_preproc_include] = STATE(49),
    [sym_preproc_def] = STATE(49),
    [sym_preproc_function_def] = STATE(49),
    [sym_preproc_call] = STATE(49),
    [sym_preproc_if] = STATE(49),
    [sym_preproc_ifdef] = STATE(49),
    [sym_function_definition] = STATE(49),
    [sym__old_style_function_definition] = STATE(403),
    [sym_declaration] = STATE(49),
    [sym_type_definition] = STATE(49),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1476),
    [sym_linkage_specification] = STATE(49),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(854),
    [sym_compound_statement] = STATE(49),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1120),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(49),
    [sym_labeled_statement] = STATE(49),
    [sym_expression_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_case_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_do_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_return_statement] = STATE(49),
    [sym_break_statement] = STATE(49),
    [sym_continue_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_seh_try_statement] = STATE(49),
    [sym_seh_leave_statement] = STATE(49),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(49),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(49),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(707),
    [aux_sym_preproc_include_token1] = ACTIONS(709),
    [aux_sym_preproc_def_token1] = ACTIONS(711),
    [aux_sym_preproc_if_token1] = ACTIONS(713),
    [aux_sym_preproc_if_token2] = ACTIONS(715),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(717),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(717),
    [sym_preproc_directive] = ACTIONS(719),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym___extension__] = ACTIONS(723),
    [anon_sym_typedef] = ACTIONS(725),
    [anon_sym_extern] = ACTIONS(727),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(731),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(735),
    [anon_sym_default] = ACTIONS(737),
    [anon_sym_while] = ACTIONS(739),
    [anon_sym_do] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_goto] = ACTIONS(751),
    [anon_sym___try] = ACTIONS(753),
    [anon_sym___leave] = ACTIONS(755),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_preproc_include] = STATE(33),
    [sym_preproc_def] = STATE(33),
    [sym_preproc_function_def] = STATE(33),
    [sym_preproc_call] = STATE(33),
    [sym_preproc_if] = STATE(33),
    [sym_preproc_ifdef] = STATE(33),
    [sym_function_definition] = STATE(33),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(33),
    [sym_type_definition] = STATE(33),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(33),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(33),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(33),
    [sym_labeled_statement] = STATE(33),
    [sym_expression_statement] = STATE(33),
    [sym_if_statement] = STATE(33),
    [sym_switch_statement] = STATE(33),
    [sym_case_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_do_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_return_statement] = STATE(33),
    [sym_break_statement] = STATE(33),
    [sym_continue_statement] = STATE(33),
    [sym_goto_statement] = STATE(33),
    [sym_seh_try_statement] = STATE(33),
    [sym_seh_leave_statement] = STATE(33),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(33),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(33),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(757),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_preproc_include] = STATE(45),
    [sym_preproc_def] = STATE(45),
    [sym_preproc_function_def] = STATE(45),
    [sym_preproc_call] = STATE(45),
    [sym_preproc_if] = STATE(45),
    [sym_preproc_ifdef] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym__old_style_function_definition] = STATE(403),
    [sym_declaration] = STATE(45),
    [sym_type_definition] = STATE(45),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1476),
    [sym_linkage_specification] = STATE(45),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(854),
    [sym_compound_statement] = STATE(45),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1120),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(45),
    [sym_labeled_statement] = STATE(45),
    [sym_expression_statement] = STATE(45),
    [sym_if_statement] = STATE(45),
    [sym_switch_statement] = STATE(45),
    [sym_case_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_do_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_return_statement] = STATE(45),
    [sym_break_statement] = STATE(45),
    [sym_continue_statement] = STATE(45),
    [sym_goto_statement] = STATE(45),
    [sym_seh_try_statement] = STATE(45),
    [sym_seh_leave_statement] = STATE(45),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(45),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(45),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(707),
    [aux_sym_preproc_include_token1] = ACTIONS(709),
    [aux_sym_preproc_def_token1] = ACTIONS(711),
    [aux_sym_preproc_if_token1] = ACTIONS(713),
    [aux_sym_preproc_if_token2] = ACTIONS(759),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(717),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(717),
    [sym_preproc_directive] = ACTIONS(719),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym___extension__] = ACTIONS(723),
    [anon_sym_typedef] = ACTIONS(725),
    [anon_sym_extern] = ACTIONS(727),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(731),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(735),
    [anon_sym_default] = ACTIONS(737),
    [anon_sym_while] = ACTIONS(739),
    [anon_sym_do] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_goto] = ACTIONS(751),
    [anon_sym___try] = ACTIONS(753),
    [anon_sym___leave] = ACTIONS(755),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(761),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(381),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1471),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(860),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1125),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(32),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym_seh_try_statement] = STATE(32),
    [sym_seh_leave_statement] = STATE(32),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [sym_identifier] = ACTIONS(479),
    [aux_sym_preproc_include_token1] = ACTIONS(481),
    [aux_sym_preproc_def_token1] = ACTIONS(483),
    [aux_sym_preproc_if_token1] = ACTIONS(485),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(487),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(487),
    [sym_preproc_directive] = ACTIONS(489),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(497),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(763),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_preproc_include] = STATE(52),
    [sym_preproc_def] = STATE(52),
    [sym_preproc_function_def] = STATE(52),
    [sym_preproc_call] = STATE(52),
    [sym_preproc_if] = STATE(52),
    [sym_preproc_ifdef] = STATE(52),
    [sym_function_definition] = STATE(52),
    [sym__old_style_function_definition] = STATE(475),
    [sym_declaration] = STATE(52),
    [sym_type_definition] = STATE(52),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1474),
    [sym_linkage_specification] = STATE(52),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(857),
    [sym_compound_statement] = STATE(52),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1123),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(52),
    [sym_labeled_statement] = STATE(52),
    [sym__top_level_expression_statement] = STATE(52),
    [sym_if_statement] = STATE(52),
    [sym_switch_statement] = STATE(52),
    [sym_case_statement] = STATE(52),
    [sym_while_statement] = STATE(52),
    [sym_do_statement] = STATE(52),
    [sym_for_statement] = STATE(52),
    [sym_return_statement] = STATE(52),
    [sym_break_statement] = STATE(52),
    [sym_continue_statement] = STATE(52),
    [sym_goto_statement] = STATE(52),
    [sym__expression] = STATE(1300),
    [sym__expression_not_binary] = STATE(1303),
    [sym_conditional_expression] = STATE(1303),
    [sym_assignment_expression] = STATE(1303),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(1303),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(1303),
    [sym_cast_expression] = STATE(1303),
    [sym_sizeof_expression] = STATE(1303),
    [sym_alignof_expression] = STATE(1303),
    [sym_offsetof_expression] = STATE(1303),
    [sym_generic_expression] = STATE(1303),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(1303),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(1303),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(1303),
    [sym_concatenated_string] = STATE(1303),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(1303),
    [sym__empty_declaration] = STATE(52),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_translation_unit_repeat1] = STATE(52),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [ts_builtin_sym_end] = ACTIONS(765),
    [sym_identifier] = ACTIONS(767),
    [aux_sym_preproc_include_token1] = ACTIONS(770),
    [aux_sym_preproc_def_token1] = ACTIONS(773),
    [aux_sym_preproc_if_token1] = ACTIONS(776),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(779),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(779),
    [sym_preproc_directive] = ACTIONS(782),
    [anon_sym_LPAREN2] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(791),
    [anon_sym_PLUS] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym___extension__] = ACTIONS(797),
    [anon_sym_typedef] = ACTIONS(800),
    [anon_sym_extern] = ACTIONS(803),
    [anon_sym___attribute__] = ACTIONS(806),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(809),
    [anon_sym___declspec] = ACTIONS(812),
    [anon_sym___cdecl] = ACTIONS(815),
    [anon_sym___clrcall] = ACTIONS(815),
    [anon_sym___stdcall] = ACTIONS(815),
    [anon_sym___fastcall] = ACTIONS(815),
    [anon_sym___thiscall] = ACTIONS(815),
    [anon_sym___vectorcall] = ACTIONS(815),
    [anon_sym_LBRACE] = ACTIONS(818),
    [anon_sym_signed] = ACTIONS(821),
    [anon_sym_unsigned] = ACTIONS(821),
    [anon_sym_long] = ACTIONS(821),
    [anon_sym_short] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(824),
    [anon_sym_auto] = ACTIONS(824),
    [anon_sym_register] = ACTIONS(824),
    [anon_sym_inline] = ACTIONS(824),
    [anon_sym___inline] = ACTIONS(824),
    [anon_sym___inline__] = ACTIONS(824),
    [anon_sym___forceinline] = ACTIONS(824),
    [anon_sym_thread_local] = ACTIONS(824),
    [anon_sym___thread] = ACTIONS(824),
    [anon_sym_const] = ACTIONS(827),
    [anon_sym_constexpr] = ACTIONS(827),
    [anon_sym_volatile] = ACTIONS(827),
    [anon_sym_restrict] = ACTIONS(827),
    [anon_sym___restrict__] = ACTIONS(827),
    [anon_sym__Atomic] = ACTIONS(827),
    [anon_sym__Noreturn] = ACTIONS(827),
    [anon_sym_noreturn] = ACTIONS(827),
    [sym_primitive_type] = ACTIONS(830),
    [anon_sym_enum] = ACTIONS(833),
    [anon_sym_struct] = ACTIONS(836),
    [anon_sym_union] = ACTIONS(839),
    [anon_sym_if] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(845),
    [anon_sym_case] = ACTIONS(848),
    [anon_sym_default] = ACTIONS(851),
    [anon_sym_while] = ACTIONS(854),
    [anon_sym_do] = ACTIONS(857),
    [anon_sym_for] = ACTIONS(860),
    [anon_sym_return] = ACTIONS(863),
    [anon_sym_break] = ACTIONS(866),
    [anon_sym_continue] = ACTIONS(869),
    [anon_sym_goto] = ACTIONS(872),
    [anon_sym_DASH_DASH] = ACTIONS(875),
    [anon_sym_PLUS_PLUS] = ACTIONS(875),
    [anon_sym_sizeof] = ACTIONS(878),
    [anon_sym___alignof__] = ACTIONS(881),
    [anon_sym___alignof] = ACTIONS(881),
    [anon_sym__alignof] = ACTIONS(881),
    [anon_sym_alignof] = ACTIONS(881),
    [anon_sym__Alignof] = ACTIONS(881),
    [anon_sym_offsetof] = ACTIONS(884),
    [anon_sym__Generic] = ACTIONS(887),
    [anon_sym_asm] = ACTIONS(890),
    [anon_sym___asm__] = ACTIONS(890),
    [sym_number_literal] = ACTIONS(893),
    [anon_sym_L_SQUOTE] = ACTIONS(896),
    [anon_sym_u_SQUOTE] = ACTIONS(896),
    [anon_sym_U_SQUOTE] = ACTIONS(896),
    [anon_sym_u8_SQUOTE] = ACTIONS(896),
    [anon_sym_SQUOTE] = ACTIONS(896),
    [anon_sym_L_DQUOTE] = ACTIONS(899),
    [anon_sym_u_DQUOTE] = ACTIONS(899),
    [anon_sym_U_DQUOTE] = ACTIONS(899),
    [anon_sym_u8_DQUOTE] = ACTIONS(899),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [sym_true] = ACTIONS(902),
    [sym_false] = ACTIONS(902),
    [anon_sym_NULL] = ACTIONS(905),
    [anon_sym_nullptr] = ACTIONS(905),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_preproc_include] = STATE(52),
    [sym_preproc_def] = STATE(52),
    [sym_preproc_function_def] = STATE(52),
    [sym_preproc_call] = STATE(52),
    [sym_preproc_if] = STATE(52),
    [sym_preproc_ifdef] = STATE(52),
    [sym_function_definition] = STATE(52),
    [sym__old_style_function_definition] = STATE(475),
    [sym_declaration] = STATE(52),
    [sym_type_definition] = STATE(52),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1474),
    [sym_linkage_specification] = STATE(52),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_ms_call_modifier] = STATE(857),
    [sym_compound_statement] = STATE(52),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1123),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(52),
    [sym_labeled_statement] = STATE(52),
    [sym__top_level_expression_statement] = STATE(52),
    [sym_if_statement] = STATE(52),
    [sym_switch_statement] = STATE(52),
    [sym_case_statement] = STATE(52),
    [sym_while_statement] = STATE(52),
    [sym_do_statement] = STATE(52),
    [sym_for_statement] = STATE(52),
    [sym_return_statement] = STATE(52),
    [sym_break_statement] = STATE(52),
    [sym_continue_statement] = STATE(52),
    [sym_goto_statement] = STATE(52),
    [sym__expression] = STATE(1300),
    [sym__expression_not_binary] = STATE(1303),
    [sym_conditional_expression] = STATE(1303),
    [sym_assignment_expression] = STATE(1303),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(1303),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(1303),
    [sym_cast_expression] = STATE(1303),
    [sym_sizeof_expression] = STATE(1303),
    [sym_alignof_expression] = STATE(1303),
    [sym_offsetof_expression] = STATE(1303),
    [sym_generic_expression] = STATE(1303),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(1303),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(1303),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(1303),
    [sym_concatenated_string] = STATE(1303),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(1303),
    [sym__empty_declaration] = STATE(52),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym_translation_unit_repeat1] = STATE(52),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [ts_builtin_sym_end] = ACTIONS(908),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(61),
    [anon_sym_default] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(91),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1494),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(913),
    [aux_sym_preproc_def_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token2] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(913),
    [aux_sym_preproc_else_token1] = ACTIONS(913),
    [aux_sym_preproc_elif_token1] = ACTIONS(913),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(913),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(913),
    [sym_preproc_directive] = ACTIONS(913),
    [anon_sym_LPAREN2] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(918),
    [anon_sym_TILDE] = ACTIONS(918),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(924),
    [anon_sym_AMP] = ACTIONS(924),
    [anon_sym_SEMI] = ACTIONS(927),
    [anon_sym___extension__] = ACTIONS(930),
    [anon_sym_typedef] = ACTIONS(933),
    [anon_sym_extern] = ACTIONS(936),
    [anon_sym___attribute__] = ACTIONS(939),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(942),
    [anon_sym___declspec] = ACTIONS(945),
    [anon_sym___cdecl] = ACTIONS(913),
    [anon_sym___clrcall] = ACTIONS(913),
    [anon_sym___stdcall] = ACTIONS(913),
    [anon_sym___fastcall] = ACTIONS(913),
    [anon_sym___thiscall] = ACTIONS(913),
    [anon_sym___vectorcall] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(948),
    [anon_sym_signed] = ACTIONS(951),
    [anon_sym_unsigned] = ACTIONS(951),
    [anon_sym_long] = ACTIONS(951),
    [anon_sym_short] = ACTIONS(951),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_auto] = ACTIONS(936),
    [anon_sym_register] = ACTIONS(936),
    [anon_sym_inline] = ACTIONS(936),
    [anon_sym___inline] = ACTIONS(936),
    [anon_sym___inline__] = ACTIONS(936),
    [anon_sym___forceinline] = ACTIONS(936),
    [anon_sym_thread_local] = ACTIONS(936),
    [anon_sym___thread] = ACTIONS(936),
    [anon_sym_const] = ACTIONS(954),
    [anon_sym_constexpr] = ACTIONS(954),
    [anon_sym_volatile] = ACTIONS(954),
    [anon_sym_restrict] = ACTIONS(954),
    [anon_sym___restrict__] = ACTIONS(954),
    [anon_sym__Atomic] = ACTIONS(954),
    [anon_sym__Noreturn] = ACTIONS(954),
    [anon_sym_noreturn] = ACTIONS(954),
    [sym_primitive_type] = ACTIONS(957),
    [anon_sym_enum] = ACTIONS(960),
    [anon_sym_struct] = ACTIONS(963),
    [anon_sym_union] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(969),
    [anon_sym_else] = ACTIONS(913),
    [anon_sym_switch] = ACTIONS(972),
    [anon_sym_case] = ACTIONS(913),
    [anon_sym_default] = ACTIONS(913),
    [anon_sym_while] = ACTIONS(975),
    [anon_sym_do] = ACTIONS(978),
    [anon_sym_for] = ACTIONS(981),
    [anon_sym_return] = ACTIONS(984),
    [anon_sym_break] = ACTIONS(987),
    [anon_sym_continue] = ACTIONS(990),
    [anon_sym_goto] = ACTIONS(993),
    [anon_sym___try] = ACTIONS(996),
    [anon_sym___leave] = ACTIONS(999),
    [anon_sym_DASH_DASH] = ACTIONS(1002),
    [anon_sym_PLUS_PLUS] = ACTIONS(1002),
    [anon_sym_sizeof] = ACTIONS(1005),
    [anon_sym___alignof__] = ACTIONS(1008),
    [anon_sym___alignof] = ACTIONS(1008),
    [anon_sym__alignof] = ACTIONS(1008),
    [anon_sym_alignof] = ACTIONS(1008),
    [anon_sym__Alignof] = ACTIONS(1008),
    [anon_sym_offsetof] = ACTIONS(1011),
    [anon_sym__Generic] = ACTIONS(1014),
    [anon_sym_asm] = ACTIONS(1017),
    [anon_sym___asm__] = ACTIONS(1017),
    [sym_number_literal] = ACTIONS(1020),
    [anon_sym_L_SQUOTE] = ACTIONS(1023),
    [anon_sym_u_SQUOTE] = ACTIONS(1023),
    [anon_sym_U_SQUOTE] = ACTIONS(1023),
    [anon_sym_u8_SQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1023),
    [anon_sym_L_DQUOTE] = ACTIONS(1026),
    [anon_sym_u_DQUOTE] = ACTIONS(1026),
    [anon_sym_U_DQUOTE] = ACTIONS(1026),
    [anon_sym_u8_DQUOTE] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1026),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [anon_sym_NULL] = ACTIONS(1032),
    [anon_sym_nullptr] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1494),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(1035),
    [aux_sym_preproc_include_token1] = ACTIONS(1037),
    [aux_sym_preproc_def_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token2] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1037),
    [aux_sym_preproc_else_token1] = ACTIONS(1037),
    [aux_sym_preproc_elif_token1] = ACTIONS(1037),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1037),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1037),
    [sym_preproc_directive] = ACTIONS(1037),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1037),
    [anon_sym___clrcall] = ACTIONS(1037),
    [anon_sym___stdcall] = ACTIONS(1037),
    [anon_sym___fastcall] = ACTIONS(1037),
    [anon_sym___thiscall] = ACTIONS(1037),
    [anon_sym___vectorcall] = ACTIONS(1037),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(1037),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(1037),
    [anon_sym_default] = ACTIONS(1037),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1494),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(1035),
    [aux_sym_preproc_include_token1] = ACTIONS(1039),
    [aux_sym_preproc_def_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token2] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1039),
    [aux_sym_preproc_else_token1] = ACTIONS(1039),
    [aux_sym_preproc_elif_token1] = ACTIONS(1039),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1039),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1039),
    [sym_preproc_directive] = ACTIONS(1039),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1039),
    [anon_sym___clrcall] = ACTIONS(1039),
    [anon_sym___stdcall] = ACTIONS(1039),
    [anon_sym___fastcall] = ACTIONS(1039),
    [anon_sym___thiscall] = ACTIONS(1039),
    [anon_sym___vectorcall] = ACTIONS(1039),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(1039),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(1039),
    [anon_sym_default] = ACTIONS(1039),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_declaration] = STATE(55),
    [sym_type_definition] = STATE(55),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1494),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(55),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(55),
    [sym_labeled_statement] = STATE(55),
    [sym_expression_statement] = STATE(55),
    [sym_if_statement] = STATE(55),
    [sym_switch_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_do_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_return_statement] = STATE(55),
    [sym_break_statement] = STATE(55),
    [sym_continue_statement] = STATE(55),
    [sym_goto_statement] = STATE(55),
    [sym_seh_try_statement] = STATE(55),
    [sym_seh_leave_statement] = STATE(55),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(1035),
    [aux_sym_preproc_include_token1] = ACTIONS(1041),
    [aux_sym_preproc_def_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token2] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1041),
    [aux_sym_preproc_else_token1] = ACTIONS(1041),
    [aux_sym_preproc_elif_token1] = ACTIONS(1041),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1041),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1041),
    [sym_preproc_directive] = ACTIONS(1041),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1041),
    [anon_sym___clrcall] = ACTIONS(1041),
    [anon_sym___stdcall] = ACTIONS(1041),
    [anon_sym___fastcall] = ACTIONS(1041),
    [anon_sym___thiscall] = ACTIONS(1041),
    [anon_sym___vectorcall] = ACTIONS(1041),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(1041),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_default] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1494),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym__expression] = STATE(1239),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2185),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(448),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(1035),
    [aux_sym_preproc_include_token1] = ACTIONS(1043),
    [aux_sym_preproc_def_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token2] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1043),
    [aux_sym_preproc_else_token1] = ACTIONS(1043),
    [aux_sym_preproc_elif_token1] = ACTIONS(1043),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1043),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1043),
    [sym_preproc_directive] = ACTIONS(1043),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym___extension__] = ACTIONS(123),
    [anon_sym_typedef] = ACTIONS(125),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1043),
    [anon_sym___clrcall] = ACTIONS(1043),
    [anon_sym___stdcall] = ACTIONS(1043),
    [anon_sym___fastcall] = ACTIONS(1043),
    [anon_sym___thiscall] = ACTIONS(1043),
    [anon_sym___vectorcall] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(129),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_else] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(1043),
    [anon_sym_default] = ACTIONS(1043),
    [anon_sym_while] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_goto] = ACTIONS(151),
    [anon_sym___try] = ACTIONS(153),
    [anon_sym___leave] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_declaration] = STATE(62),
    [sym_type_definition] = STATE(62),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1489),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(62),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(62),
    [sym_labeled_statement] = STATE(62),
    [sym_expression_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_switch_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_do_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_return_statement] = STATE(62),
    [sym_break_statement] = STATE(62),
    [sym_continue_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_seh_try_statement] = STATE(62),
    [sym_seh_leave_statement] = STATE(62),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(1043),
    [aux_sym_preproc_def_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token2] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1043),
    [aux_sym_preproc_else_token1] = ACTIONS(1043),
    [aux_sym_preproc_elif_token1] = ACTIONS(1043),
    [sym_preproc_directive] = ACTIONS(1043),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1043),
    [anon_sym___clrcall] = ACTIONS(1043),
    [anon_sym___stdcall] = ACTIONS(1043),
    [anon_sym___fastcall] = ACTIONS(1043),
    [anon_sym___thiscall] = ACTIONS(1043),
    [anon_sym___vectorcall] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(1043),
    [anon_sym_default] = ACTIONS(1043),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_declaration] = STATE(63),
    [sym_type_definition] = STATE(63),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1489),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(63),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(63),
    [sym_labeled_statement] = STATE(63),
    [sym_expression_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_switch_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_do_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_return_statement] = STATE(63),
    [sym_break_statement] = STATE(63),
    [sym_continue_statement] = STATE(63),
    [sym_goto_statement] = STATE(63),
    [sym_seh_try_statement] = STATE(63),
    [sym_seh_leave_statement] = STATE(63),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(63),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(1041),
    [aux_sym_preproc_def_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token2] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1041),
    [aux_sym_preproc_else_token1] = ACTIONS(1041),
    [aux_sym_preproc_elif_token1] = ACTIONS(1041),
    [sym_preproc_directive] = ACTIONS(1041),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1041),
    [anon_sym___clrcall] = ACTIONS(1041),
    [anon_sym___stdcall] = ACTIONS(1041),
    [anon_sym___fastcall] = ACTIONS(1041),
    [anon_sym___thiscall] = ACTIONS(1041),
    [anon_sym___vectorcall] = ACTIONS(1041),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(1041),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_default] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_declaration] = STATE(59),
    [sym_type_definition] = STATE(59),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1489),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(59),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(59),
    [sym_labeled_statement] = STATE(59),
    [sym_expression_statement] = STATE(59),
    [sym_if_statement] = STATE(59),
    [sym_switch_statement] = STATE(59),
    [sym_while_statement] = STATE(59),
    [sym_do_statement] = STATE(59),
    [sym_for_statement] = STATE(59),
    [sym_return_statement] = STATE(59),
    [sym_break_statement] = STATE(59),
    [sym_continue_statement] = STATE(59),
    [sym_goto_statement] = STATE(59),
    [sym_seh_try_statement] = STATE(59),
    [sym_seh_leave_statement] = STATE(59),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(59),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(1039),
    [aux_sym_preproc_def_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token2] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1039),
    [aux_sym_preproc_else_token1] = ACTIONS(1039),
    [aux_sym_preproc_elif_token1] = ACTIONS(1039),
    [sym_preproc_directive] = ACTIONS(1039),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1039),
    [anon_sym___clrcall] = ACTIONS(1039),
    [anon_sym___stdcall] = ACTIONS(1039),
    [anon_sym___fastcall] = ACTIONS(1039),
    [anon_sym___thiscall] = ACTIONS(1039),
    [anon_sym___vectorcall] = ACTIONS(1039),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(1039),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(1039),
    [anon_sym_default] = ACTIONS(1039),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_declaration] = STATE(62),
    [sym_type_definition] = STATE(62),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1489),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(62),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(62),
    [sym_labeled_statement] = STATE(62),
    [sym_expression_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_switch_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_do_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_return_statement] = STATE(62),
    [sym_break_statement] = STATE(62),
    [sym_continue_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_seh_try_statement] = STATE(62),
    [sym_seh_leave_statement] = STATE(62),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(1047),
    [aux_sym_preproc_include_token1] = ACTIONS(913),
    [aux_sym_preproc_def_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token2] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(913),
    [aux_sym_preproc_else_token1] = ACTIONS(913),
    [aux_sym_preproc_elif_token1] = ACTIONS(913),
    [sym_preproc_directive] = ACTIONS(913),
    [anon_sym_LPAREN2] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(918),
    [anon_sym_TILDE] = ACTIONS(918),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(924),
    [anon_sym_AMP] = ACTIONS(924),
    [anon_sym_SEMI] = ACTIONS(1050),
    [anon_sym___extension__] = ACTIONS(1053),
    [anon_sym_typedef] = ACTIONS(1056),
    [anon_sym_extern] = ACTIONS(936),
    [anon_sym___attribute__] = ACTIONS(939),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(942),
    [anon_sym___declspec] = ACTIONS(945),
    [anon_sym___cdecl] = ACTIONS(913),
    [anon_sym___clrcall] = ACTIONS(913),
    [anon_sym___stdcall] = ACTIONS(913),
    [anon_sym___fastcall] = ACTIONS(913),
    [anon_sym___thiscall] = ACTIONS(913),
    [anon_sym___vectorcall] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(1059),
    [anon_sym_signed] = ACTIONS(951),
    [anon_sym_unsigned] = ACTIONS(951),
    [anon_sym_long] = ACTIONS(951),
    [anon_sym_short] = ACTIONS(951),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_auto] = ACTIONS(936),
    [anon_sym_register] = ACTIONS(936),
    [anon_sym_inline] = ACTIONS(936),
    [anon_sym___inline] = ACTIONS(936),
    [anon_sym___inline__] = ACTIONS(936),
    [anon_sym___forceinline] = ACTIONS(936),
    [anon_sym_thread_local] = ACTIONS(936),
    [anon_sym___thread] = ACTIONS(936),
    [anon_sym_const] = ACTIONS(954),
    [anon_sym_constexpr] = ACTIONS(954),
    [anon_sym_volatile] = ACTIONS(954),
    [anon_sym_restrict] = ACTIONS(954),
    [anon_sym___restrict__] = ACTIONS(954),
    [anon_sym__Atomic] = ACTIONS(954),
    [anon_sym__Noreturn] = ACTIONS(954),
    [anon_sym_noreturn] = ACTIONS(954),
    [sym_primitive_type] = ACTIONS(957),
    [anon_sym_enum] = ACTIONS(960),
    [anon_sym_struct] = ACTIONS(963),
    [anon_sym_union] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(1062),
    [anon_sym_else] = ACTIONS(913),
    [anon_sym_switch] = ACTIONS(1065),
    [anon_sym_case] = ACTIONS(913),
    [anon_sym_default] = ACTIONS(913),
    [anon_sym_while] = ACTIONS(1068),
    [anon_sym_do] = ACTIONS(1071),
    [anon_sym_for] = ACTIONS(1074),
    [anon_sym_return] = ACTIONS(1077),
    [anon_sym_break] = ACTIONS(1080),
    [anon_sym_continue] = ACTIONS(1083),
    [anon_sym_goto] = ACTIONS(1086),
    [anon_sym___try] = ACTIONS(1089),
    [anon_sym___leave] = ACTIONS(1092),
    [anon_sym_DASH_DASH] = ACTIONS(1002),
    [anon_sym_PLUS_PLUS] = ACTIONS(1002),
    [anon_sym_sizeof] = ACTIONS(1005),
    [anon_sym___alignof__] = ACTIONS(1008),
    [anon_sym___alignof] = ACTIONS(1008),
    [anon_sym__alignof] = ACTIONS(1008),
    [anon_sym_alignof] = ACTIONS(1008),
    [anon_sym__Alignof] = ACTIONS(1008),
    [anon_sym_offsetof] = ACTIONS(1011),
    [anon_sym__Generic] = ACTIONS(1014),
    [anon_sym_asm] = ACTIONS(1017),
    [anon_sym___asm__] = ACTIONS(1017),
    [sym_number_literal] = ACTIONS(1020),
    [anon_sym_L_SQUOTE] = ACTIONS(1023),
    [anon_sym_u_SQUOTE] = ACTIONS(1023),
    [anon_sym_U_SQUOTE] = ACTIONS(1023),
    [anon_sym_u8_SQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1023),
    [anon_sym_L_DQUOTE] = ACTIONS(1026),
    [anon_sym_u_DQUOTE] = ACTIONS(1026),
    [anon_sym_U_DQUOTE] = ACTIONS(1026),
    [anon_sym_u8_DQUOTE] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1026),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [anon_sym_NULL] = ACTIONS(1032),
    [anon_sym_nullptr] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_declaration] = STATE(62),
    [sym_type_definition] = STATE(62),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1489),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(62),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(62),
    [sym_labeled_statement] = STATE(62),
    [sym_expression_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_switch_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_do_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_return_statement] = STATE(62),
    [sym_break_statement] = STATE(62),
    [sym_continue_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_seh_try_statement] = STATE(62),
    [sym_seh_leave_statement] = STATE(62),
    [sym__expression] = STATE(1199),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2083),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(452),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(1045),
    [aux_sym_preproc_include_token1] = ACTIONS(1037),
    [aux_sym_preproc_def_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token2] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1037),
    [aux_sym_preproc_else_token1] = ACTIONS(1037),
    [aux_sym_preproc_elif_token1] = ACTIONS(1037),
    [sym_preproc_directive] = ACTIONS(1037),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym___extension__] = ACTIONS(195),
    [anon_sym_typedef] = ACTIONS(197),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1037),
    [anon_sym___clrcall] = ACTIONS(1037),
    [anon_sym___stdcall] = ACTIONS(1037),
    [anon_sym___fastcall] = ACTIONS(1037),
    [anon_sym___thiscall] = ACTIONS(1037),
    [anon_sym___vectorcall] = ACTIONS(1037),
    [anon_sym_LBRACE] = ACTIONS(201),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(1037),
    [anon_sym_switch] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(1037),
    [anon_sym_default] = ACTIONS(1037),
    [anon_sym_while] = ACTIONS(211),
    [anon_sym_do] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_break] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(221),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym___try] = ACTIONS(225),
    [anon_sym___leave] = ACTIONS(227),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_declaration] = STATE(68),
    [sym_type_definition] = STATE(68),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(68),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(68),
    [sym_labeled_statement] = STATE(68),
    [sym_expression_statement] = STATE(68),
    [sym_if_statement] = STATE(68),
    [sym_switch_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_do_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_return_statement] = STATE(68),
    [sym_break_statement] = STATE(68),
    [sym_continue_statement] = STATE(68),
    [sym_goto_statement] = STATE(68),
    [sym_seh_try_statement] = STATE(68),
    [sym_seh_leave_statement] = STATE(68),
    [sym__expression] = STATE(1237),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2079),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(68),
    [ts_builtin_sym_end] = ACTIONS(1095),
    [sym_identifier] = ACTIONS(1097),
    [aux_sym_preproc_include_token1] = ACTIONS(1039),
    [aux_sym_preproc_def_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1039),
    [sym_preproc_directive] = ACTIONS(1039),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1099),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1039),
    [anon_sym___clrcall] = ACTIONS(1039),
    [anon_sym___stdcall] = ACTIONS(1039),
    [anon_sym___fastcall] = ACTIONS(1039),
    [anon_sym___thiscall] = ACTIONS(1039),
    [anon_sym___vectorcall] = ACTIONS(1039),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(1039),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(1039),
    [anon_sym_default] = ACTIONS(1039),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(1103),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_declaration] = STATE(66),
    [sym_type_definition] = STATE(66),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1496),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(66),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(66),
    [sym_labeled_statement] = STATE(66),
    [sym_expression_statement] = STATE(66),
    [sym_if_statement] = STATE(66),
    [sym_switch_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_do_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_return_statement] = STATE(66),
    [sym_break_statement] = STATE(66),
    [sym_continue_statement] = STATE(66),
    [sym_goto_statement] = STATE(66),
    [sym_seh_try_statement] = STATE(66),
    [sym_seh_leave_statement] = STATE(66),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(1105),
    [aux_sym_preproc_include_token1] = ACTIONS(1041),
    [aux_sym_preproc_def_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token2] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1041),
    [sym_preproc_directive] = ACTIONS(1041),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym___extension__] = ACTIONS(723),
    [anon_sym_typedef] = ACTIONS(725),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1041),
    [anon_sym___clrcall] = ACTIONS(1041),
    [anon_sym___stdcall] = ACTIONS(1041),
    [anon_sym___fastcall] = ACTIONS(1041),
    [anon_sym___thiscall] = ACTIONS(1041),
    [anon_sym___vectorcall] = ACTIONS(1041),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(731),
    [anon_sym_else] = ACTIONS(1041),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_default] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(739),
    [anon_sym_do] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_goto] = ACTIONS(751),
    [anon_sym___try] = ACTIONS(753),
    [anon_sym___leave] = ACTIONS(755),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_declaration] = STATE(77),
    [sym_type_definition] = STATE(77),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1496),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(77),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(77),
    [sym_labeled_statement] = STATE(77),
    [sym_expression_statement] = STATE(77),
    [sym_if_statement] = STATE(77),
    [sym_switch_statement] = STATE(77),
    [sym_while_statement] = STATE(77),
    [sym_do_statement] = STATE(77),
    [sym_for_statement] = STATE(77),
    [sym_return_statement] = STATE(77),
    [sym_break_statement] = STATE(77),
    [sym_continue_statement] = STATE(77),
    [sym_goto_statement] = STATE(77),
    [sym_seh_try_statement] = STATE(77),
    [sym_seh_leave_statement] = STATE(77),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(77),
    [sym_identifier] = ACTIONS(1105),
    [aux_sym_preproc_include_token1] = ACTIONS(1037),
    [aux_sym_preproc_def_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token2] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1037),
    [sym_preproc_directive] = ACTIONS(1037),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym___extension__] = ACTIONS(723),
    [anon_sym_typedef] = ACTIONS(725),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1037),
    [anon_sym___clrcall] = ACTIONS(1037),
    [anon_sym___stdcall] = ACTIONS(1037),
    [anon_sym___fastcall] = ACTIONS(1037),
    [anon_sym___thiscall] = ACTIONS(1037),
    [anon_sym___vectorcall] = ACTIONS(1037),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(731),
    [anon_sym_else] = ACTIONS(1037),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(1037),
    [anon_sym_default] = ACTIONS(1037),
    [anon_sym_while] = ACTIONS(739),
    [anon_sym_do] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_goto] = ACTIONS(751),
    [anon_sym___try] = ACTIONS(753),
    [anon_sym___leave] = ACTIONS(755),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_declaration] = STATE(70),
    [sym_type_definition] = STATE(70),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(70),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(70),
    [sym_labeled_statement] = STATE(70),
    [sym_expression_statement] = STATE(70),
    [sym_if_statement] = STATE(70),
    [sym_switch_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_do_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_return_statement] = STATE(70),
    [sym_break_statement] = STATE(70),
    [sym_continue_statement] = STATE(70),
    [sym_goto_statement] = STATE(70),
    [sym_seh_try_statement] = STATE(70),
    [sym_seh_leave_statement] = STATE(70),
    [sym__expression] = STATE(1237),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2079),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(1107),
    [sym_identifier] = ACTIONS(1097),
    [aux_sym_preproc_include_token1] = ACTIONS(1041),
    [aux_sym_preproc_def_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1041),
    [sym_preproc_directive] = ACTIONS(1041),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1099),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1041),
    [anon_sym___clrcall] = ACTIONS(1041),
    [anon_sym___stdcall] = ACTIONS(1041),
    [anon_sym___fastcall] = ACTIONS(1041),
    [anon_sym___thiscall] = ACTIONS(1041),
    [anon_sym___vectorcall] = ACTIONS(1041),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(1041),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_default] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(1103),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym__expression] = STATE(1237),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2079),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(1109),
    [sym_identifier] = ACTIONS(1097),
    [aux_sym_preproc_include_token1] = ACTIONS(1043),
    [aux_sym_preproc_def_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1043),
    [sym_preproc_directive] = ACTIONS(1043),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1099),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1043),
    [anon_sym___clrcall] = ACTIONS(1043),
    [anon_sym___stdcall] = ACTIONS(1043),
    [anon_sym___fastcall] = ACTIONS(1043),
    [anon_sym___thiscall] = ACTIONS(1043),
    [anon_sym___vectorcall] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(1043),
    [anon_sym_default] = ACTIONS(1043),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(1103),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym__expression] = STATE(1237),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2079),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(1111),
    [sym_identifier] = ACTIONS(1113),
    [aux_sym_preproc_include_token1] = ACTIONS(913),
    [aux_sym_preproc_def_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(913),
    [sym_preproc_directive] = ACTIONS(913),
    [anon_sym_LPAREN2] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(918),
    [anon_sym_TILDE] = ACTIONS(918),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(924),
    [anon_sym_AMP] = ACTIONS(924),
    [anon_sym_SEMI] = ACTIONS(1116),
    [anon_sym___extension__] = ACTIONS(1119),
    [anon_sym_typedef] = ACTIONS(1122),
    [anon_sym_extern] = ACTIONS(936),
    [anon_sym___attribute__] = ACTIONS(939),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(942),
    [anon_sym___declspec] = ACTIONS(945),
    [anon_sym___cdecl] = ACTIONS(913),
    [anon_sym___clrcall] = ACTIONS(913),
    [anon_sym___stdcall] = ACTIONS(913),
    [anon_sym___fastcall] = ACTIONS(913),
    [anon_sym___thiscall] = ACTIONS(913),
    [anon_sym___vectorcall] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(1125),
    [anon_sym_signed] = ACTIONS(951),
    [anon_sym_unsigned] = ACTIONS(951),
    [anon_sym_long] = ACTIONS(951),
    [anon_sym_short] = ACTIONS(951),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_auto] = ACTIONS(936),
    [anon_sym_register] = ACTIONS(936),
    [anon_sym_inline] = ACTIONS(936),
    [anon_sym___inline] = ACTIONS(936),
    [anon_sym___inline__] = ACTIONS(936),
    [anon_sym___forceinline] = ACTIONS(936),
    [anon_sym_thread_local] = ACTIONS(936),
    [anon_sym___thread] = ACTIONS(936),
    [anon_sym_const] = ACTIONS(954),
    [anon_sym_constexpr] = ACTIONS(954),
    [anon_sym_volatile] = ACTIONS(954),
    [anon_sym_restrict] = ACTIONS(954),
    [anon_sym___restrict__] = ACTIONS(954),
    [anon_sym__Atomic] = ACTIONS(954),
    [anon_sym__Noreturn] = ACTIONS(954),
    [anon_sym_noreturn] = ACTIONS(954),
    [sym_primitive_type] = ACTIONS(957),
    [anon_sym_enum] = ACTIONS(960),
    [anon_sym_struct] = ACTIONS(963),
    [anon_sym_union] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(1128),
    [anon_sym_else] = ACTIONS(913),
    [anon_sym_switch] = ACTIONS(1131),
    [anon_sym_case] = ACTIONS(913),
    [anon_sym_default] = ACTIONS(913),
    [anon_sym_while] = ACTIONS(1134),
    [anon_sym_do] = ACTIONS(1137),
    [anon_sym_for] = ACTIONS(1140),
    [anon_sym_return] = ACTIONS(1143),
    [anon_sym_break] = ACTIONS(1146),
    [anon_sym_continue] = ACTIONS(1149),
    [anon_sym_goto] = ACTIONS(1152),
    [anon_sym___try] = ACTIONS(1155),
    [anon_sym___leave] = ACTIONS(1158),
    [anon_sym_DASH_DASH] = ACTIONS(1002),
    [anon_sym_PLUS_PLUS] = ACTIONS(1002),
    [anon_sym_sizeof] = ACTIONS(1005),
    [anon_sym___alignof__] = ACTIONS(1008),
    [anon_sym___alignof] = ACTIONS(1008),
    [anon_sym__alignof] = ACTIONS(1008),
    [anon_sym_alignof] = ACTIONS(1008),
    [anon_sym__Alignof] = ACTIONS(1008),
    [anon_sym_offsetof] = ACTIONS(1011),
    [anon_sym__Generic] = ACTIONS(1014),
    [anon_sym_asm] = ACTIONS(1017),
    [anon_sym___asm__] = ACTIONS(1017),
    [sym_number_literal] = ACTIONS(1020),
    [anon_sym_L_SQUOTE] = ACTIONS(1023),
    [anon_sym_u_SQUOTE] = ACTIONS(1023),
    [anon_sym_U_SQUOTE] = ACTIONS(1023),
    [anon_sym_u8_SQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1023),
    [anon_sym_L_DQUOTE] = ACTIONS(1026),
    [anon_sym_u_DQUOTE] = ACTIONS(1026),
    [anon_sym_U_DQUOTE] = ACTIONS(1026),
    [anon_sym_u8_DQUOTE] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1026),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [anon_sym_NULL] = ACTIONS(1032),
    [anon_sym_nullptr] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym__expression] = STATE(1237),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2079),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(423),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(1161),
    [sym_identifier] = ACTIONS(1097),
    [aux_sym_preproc_include_token1] = ACTIONS(1037),
    [aux_sym_preproc_def_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1037),
    [sym_preproc_directive] = ACTIONS(1037),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1099),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1037),
    [anon_sym___clrcall] = ACTIONS(1037),
    [anon_sym___stdcall] = ACTIONS(1037),
    [anon_sym___fastcall] = ACTIONS(1037),
    [anon_sym___thiscall] = ACTIONS(1037),
    [anon_sym___vectorcall] = ACTIONS(1037),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_else] = ACTIONS(1037),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(1037),
    [anon_sym_default] = ACTIONS(1037),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(1103),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_declaration] = STATE(74),
    [sym_type_definition] = STATE(74),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1480),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(74),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(74),
    [sym_labeled_statement] = STATE(74),
    [sym_expression_statement] = STATE(74),
    [sym_if_statement] = STATE(74),
    [sym_switch_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_do_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_return_statement] = STATE(74),
    [sym_break_statement] = STATE(74),
    [sym_continue_statement] = STATE(74),
    [sym_goto_statement] = STATE(74),
    [sym_seh_try_statement] = STATE(74),
    [sym_seh_leave_statement] = STATE(74),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(1163),
    [aux_sym_preproc_include_token1] = ACTIONS(1043),
    [aux_sym_preproc_def_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1043),
    [sym_preproc_directive] = ACTIONS(1043),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1043),
    [anon_sym___clrcall] = ACTIONS(1043),
    [anon_sym___stdcall] = ACTIONS(1043),
    [anon_sym___fastcall] = ACTIONS(1043),
    [anon_sym___thiscall] = ACTIONS(1043),
    [anon_sym___vectorcall] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1109),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(1043),
    [anon_sym_default] = ACTIONS(1043),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_declaration] = STATE(74),
    [sym_type_definition] = STATE(74),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1480),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(74),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(74),
    [sym_labeled_statement] = STATE(74),
    [sym_expression_statement] = STATE(74),
    [sym_if_statement] = STATE(74),
    [sym_switch_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_do_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_return_statement] = STATE(74),
    [sym_break_statement] = STATE(74),
    [sym_continue_statement] = STATE(74),
    [sym_goto_statement] = STATE(74),
    [sym_seh_try_statement] = STATE(74),
    [sym_seh_leave_statement] = STATE(74),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(1163),
    [aux_sym_preproc_include_token1] = ACTIONS(1037),
    [aux_sym_preproc_def_token1] = ACTIONS(1037),
    [aux_sym_preproc_if_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1037),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1037),
    [sym_preproc_directive] = ACTIONS(1037),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1037),
    [anon_sym___clrcall] = ACTIONS(1037),
    [anon_sym___stdcall] = ACTIONS(1037),
    [anon_sym___fastcall] = ACTIONS(1037),
    [anon_sym___thiscall] = ACTIONS(1037),
    [anon_sym___vectorcall] = ACTIONS(1037),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1161),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(1037),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(1037),
    [anon_sym_default] = ACTIONS(1037),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_declaration] = STATE(78),
    [sym_type_definition] = STATE(78),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1496),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(78),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(78),
    [sym_labeled_statement] = STATE(78),
    [sym_expression_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_switch_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_do_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_return_statement] = STATE(78),
    [sym_break_statement] = STATE(78),
    [sym_continue_statement] = STATE(78),
    [sym_goto_statement] = STATE(78),
    [sym_seh_try_statement] = STATE(78),
    [sym_seh_leave_statement] = STATE(78),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(78),
    [sym_identifier] = ACTIONS(1105),
    [aux_sym_preproc_include_token1] = ACTIONS(1039),
    [aux_sym_preproc_def_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token2] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1039),
    [sym_preproc_directive] = ACTIONS(1039),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym___extension__] = ACTIONS(723),
    [anon_sym_typedef] = ACTIONS(725),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1039),
    [anon_sym___clrcall] = ACTIONS(1039),
    [anon_sym___stdcall] = ACTIONS(1039),
    [anon_sym___fastcall] = ACTIONS(1039),
    [anon_sym___thiscall] = ACTIONS(1039),
    [anon_sym___vectorcall] = ACTIONS(1039),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(731),
    [anon_sym_else] = ACTIONS(1039),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(1039),
    [anon_sym_default] = ACTIONS(1039),
    [anon_sym_while] = ACTIONS(739),
    [anon_sym_do] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_goto] = ACTIONS(751),
    [anon_sym___try] = ACTIONS(753),
    [anon_sym___leave] = ACTIONS(755),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_declaration] = STATE(74),
    [sym_type_definition] = STATE(74),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1480),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(74),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(74),
    [sym_labeled_statement] = STATE(74),
    [sym_expression_statement] = STATE(74),
    [sym_if_statement] = STATE(74),
    [sym_switch_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_do_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_return_statement] = STATE(74),
    [sym_break_statement] = STATE(74),
    [sym_continue_statement] = STATE(74),
    [sym_goto_statement] = STATE(74),
    [sym_seh_try_statement] = STATE(74),
    [sym_seh_leave_statement] = STATE(74),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(1165),
    [aux_sym_preproc_include_token1] = ACTIONS(913),
    [aux_sym_preproc_def_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(913),
    [sym_preproc_directive] = ACTIONS(913),
    [anon_sym_LPAREN2] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(918),
    [anon_sym_TILDE] = ACTIONS(918),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(924),
    [anon_sym_AMP] = ACTIONS(924),
    [anon_sym_SEMI] = ACTIONS(1168),
    [anon_sym___extension__] = ACTIONS(1171),
    [anon_sym_typedef] = ACTIONS(1174),
    [anon_sym_extern] = ACTIONS(936),
    [anon_sym___attribute__] = ACTIONS(939),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(942),
    [anon_sym___declspec] = ACTIONS(945),
    [anon_sym___cdecl] = ACTIONS(913),
    [anon_sym___clrcall] = ACTIONS(913),
    [anon_sym___stdcall] = ACTIONS(913),
    [anon_sym___fastcall] = ACTIONS(913),
    [anon_sym___thiscall] = ACTIONS(913),
    [anon_sym___vectorcall] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(1177),
    [anon_sym_RBRACE] = ACTIONS(1111),
    [anon_sym_signed] = ACTIONS(951),
    [anon_sym_unsigned] = ACTIONS(951),
    [anon_sym_long] = ACTIONS(951),
    [anon_sym_short] = ACTIONS(951),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_auto] = ACTIONS(936),
    [anon_sym_register] = ACTIONS(936),
    [anon_sym_inline] = ACTIONS(936),
    [anon_sym___inline] = ACTIONS(936),
    [anon_sym___inline__] = ACTIONS(936),
    [anon_sym___forceinline] = ACTIONS(936),
    [anon_sym_thread_local] = ACTIONS(936),
    [anon_sym___thread] = ACTIONS(936),
    [anon_sym_const] = ACTIONS(954),
    [anon_sym_constexpr] = ACTIONS(954),
    [anon_sym_volatile] = ACTIONS(954),
    [anon_sym_restrict] = ACTIONS(954),
    [anon_sym___restrict__] = ACTIONS(954),
    [anon_sym__Atomic] = ACTIONS(954),
    [anon_sym__Noreturn] = ACTIONS(954),
    [anon_sym_noreturn] = ACTIONS(954),
    [sym_primitive_type] = ACTIONS(957),
    [anon_sym_enum] = ACTIONS(960),
    [anon_sym_struct] = ACTIONS(963),
    [anon_sym_union] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(1180),
    [anon_sym_else] = ACTIONS(913),
    [anon_sym_switch] = ACTIONS(1183),
    [anon_sym_case] = ACTIONS(913),
    [anon_sym_default] = ACTIONS(913),
    [anon_sym_while] = ACTIONS(1186),
    [anon_sym_do] = ACTIONS(1189),
    [anon_sym_for] = ACTIONS(1192),
    [anon_sym_return] = ACTIONS(1195),
    [anon_sym_break] = ACTIONS(1198),
    [anon_sym_continue] = ACTIONS(1201),
    [anon_sym_goto] = ACTIONS(1204),
    [anon_sym___try] = ACTIONS(1207),
    [anon_sym___leave] = ACTIONS(1210),
    [anon_sym_DASH_DASH] = ACTIONS(1002),
    [anon_sym_PLUS_PLUS] = ACTIONS(1002),
    [anon_sym_sizeof] = ACTIONS(1005),
    [anon_sym___alignof__] = ACTIONS(1008),
    [anon_sym___alignof] = ACTIONS(1008),
    [anon_sym__alignof] = ACTIONS(1008),
    [anon_sym_alignof] = ACTIONS(1008),
    [anon_sym__Alignof] = ACTIONS(1008),
    [anon_sym_offsetof] = ACTIONS(1011),
    [anon_sym__Generic] = ACTIONS(1014),
    [anon_sym_asm] = ACTIONS(1017),
    [anon_sym___asm__] = ACTIONS(1017),
    [sym_number_literal] = ACTIONS(1020),
    [anon_sym_L_SQUOTE] = ACTIONS(1023),
    [anon_sym_u_SQUOTE] = ACTIONS(1023),
    [anon_sym_U_SQUOTE] = ACTIONS(1023),
    [anon_sym_u8_SQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1023),
    [anon_sym_L_DQUOTE] = ACTIONS(1026),
    [anon_sym_u_DQUOTE] = ACTIONS(1026),
    [anon_sym_U_DQUOTE] = ACTIONS(1026),
    [anon_sym_u8_DQUOTE] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1026),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [anon_sym_NULL] = ACTIONS(1032),
    [anon_sym_nullptr] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_declaration] = STATE(72),
    [sym_type_definition] = STATE(72),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1480),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(72),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(72),
    [sym_labeled_statement] = STATE(72),
    [sym_expression_statement] = STATE(72),
    [sym_if_statement] = STATE(72),
    [sym_switch_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_do_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_return_statement] = STATE(72),
    [sym_break_statement] = STATE(72),
    [sym_continue_statement] = STATE(72),
    [sym_goto_statement] = STATE(72),
    [sym_seh_try_statement] = STATE(72),
    [sym_seh_leave_statement] = STATE(72),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(1163),
    [aux_sym_preproc_include_token1] = ACTIONS(1041),
    [aux_sym_preproc_def_token1] = ACTIONS(1041),
    [aux_sym_preproc_if_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1041),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1041),
    [sym_preproc_directive] = ACTIONS(1041),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1041),
    [anon_sym___clrcall] = ACTIONS(1041),
    [anon_sym___stdcall] = ACTIONS(1041),
    [anon_sym___fastcall] = ACTIONS(1041),
    [anon_sym___thiscall] = ACTIONS(1041),
    [anon_sym___vectorcall] = ACTIONS(1041),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1107),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(1041),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(1041),
    [anon_sym_default] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_declaration] = STATE(71),
    [sym_type_definition] = STATE(71),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1480),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(71),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(71),
    [sym_labeled_statement] = STATE(71),
    [sym_expression_statement] = STATE(71),
    [sym_if_statement] = STATE(71),
    [sym_switch_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_do_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_return_statement] = STATE(71),
    [sym_break_statement] = STATE(71),
    [sym_continue_statement] = STATE(71),
    [sym_goto_statement] = STATE(71),
    [sym_seh_try_statement] = STATE(71),
    [sym_seh_leave_statement] = STATE(71),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(429),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(1163),
    [aux_sym_preproc_include_token1] = ACTIONS(1039),
    [aux_sym_preproc_def_token1] = ACTIONS(1039),
    [aux_sym_preproc_if_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1039),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1039),
    [sym_preproc_directive] = ACTIONS(1039),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(493),
    [anon_sym_typedef] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1039),
    [anon_sym___clrcall] = ACTIONS(1039),
    [anon_sym___stdcall] = ACTIONS(1039),
    [anon_sym___fastcall] = ACTIONS(1039),
    [anon_sym___thiscall] = ACTIONS(1039),
    [anon_sym___vectorcall] = ACTIONS(1039),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(1095),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(1039),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(1039),
    [anon_sym_default] = ACTIONS(1039),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_goto] = ACTIONS(523),
    [anon_sym___try] = ACTIONS(525),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_declaration] = STATE(77),
    [sym_type_definition] = STATE(77),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1496),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(77),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(77),
    [sym_labeled_statement] = STATE(77),
    [sym_expression_statement] = STATE(77),
    [sym_if_statement] = STATE(77),
    [sym_switch_statement] = STATE(77),
    [sym_while_statement] = STATE(77),
    [sym_do_statement] = STATE(77),
    [sym_for_statement] = STATE(77),
    [sym_return_statement] = STATE(77),
    [sym_break_statement] = STATE(77),
    [sym_continue_statement] = STATE(77),
    [sym_goto_statement] = STATE(77),
    [sym_seh_try_statement] = STATE(77),
    [sym_seh_leave_statement] = STATE(77),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(77),
    [sym_identifier] = ACTIONS(1213),
    [aux_sym_preproc_include_token1] = ACTIONS(913),
    [aux_sym_preproc_def_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token1] = ACTIONS(913),
    [aux_sym_preproc_if_token2] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(913),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(913),
    [sym_preproc_directive] = ACTIONS(913),
    [anon_sym_LPAREN2] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(918),
    [anon_sym_TILDE] = ACTIONS(918),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(924),
    [anon_sym_AMP] = ACTIONS(924),
    [anon_sym_SEMI] = ACTIONS(1216),
    [anon_sym___extension__] = ACTIONS(1219),
    [anon_sym_typedef] = ACTIONS(1222),
    [anon_sym_extern] = ACTIONS(936),
    [anon_sym___attribute__] = ACTIONS(939),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(942),
    [anon_sym___declspec] = ACTIONS(945),
    [anon_sym___cdecl] = ACTIONS(913),
    [anon_sym___clrcall] = ACTIONS(913),
    [anon_sym___stdcall] = ACTIONS(913),
    [anon_sym___fastcall] = ACTIONS(913),
    [anon_sym___thiscall] = ACTIONS(913),
    [anon_sym___vectorcall] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(1225),
    [anon_sym_signed] = ACTIONS(951),
    [anon_sym_unsigned] = ACTIONS(951),
    [anon_sym_long] = ACTIONS(951),
    [anon_sym_short] = ACTIONS(951),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_auto] = ACTIONS(936),
    [anon_sym_register] = ACTIONS(936),
    [anon_sym_inline] = ACTIONS(936),
    [anon_sym___inline] = ACTIONS(936),
    [anon_sym___inline__] = ACTIONS(936),
    [anon_sym___forceinline] = ACTIONS(936),
    [anon_sym_thread_local] = ACTIONS(936),
    [anon_sym___thread] = ACTIONS(936),
    [anon_sym_const] = ACTIONS(954),
    [anon_sym_constexpr] = ACTIONS(954),
    [anon_sym_volatile] = ACTIONS(954),
    [anon_sym_restrict] = ACTIONS(954),
    [anon_sym___restrict__] = ACTIONS(954),
    [anon_sym__Atomic] = ACTIONS(954),
    [anon_sym__Noreturn] = ACTIONS(954),
    [anon_sym_noreturn] = ACTIONS(954),
    [sym_primitive_type] = ACTIONS(957),
    [anon_sym_enum] = ACTIONS(960),
    [anon_sym_struct] = ACTIONS(963),
    [anon_sym_union] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(1228),
    [anon_sym_else] = ACTIONS(913),
    [anon_sym_switch] = ACTIONS(1231),
    [anon_sym_case] = ACTIONS(913),
    [anon_sym_default] = ACTIONS(913),
    [anon_sym_while] = ACTIONS(1234),
    [anon_sym_do] = ACTIONS(1237),
    [anon_sym_for] = ACTIONS(1240),
    [anon_sym_return] = ACTIONS(1243),
    [anon_sym_break] = ACTIONS(1246),
    [anon_sym_continue] = ACTIONS(1249),
    [anon_sym_goto] = ACTIONS(1252),
    [anon_sym___try] = ACTIONS(1255),
    [anon_sym___leave] = ACTIONS(1258),
    [anon_sym_DASH_DASH] = ACTIONS(1002),
    [anon_sym_PLUS_PLUS] = ACTIONS(1002),
    [anon_sym_sizeof] = ACTIONS(1005),
    [anon_sym___alignof__] = ACTIONS(1008),
    [anon_sym___alignof] = ACTIONS(1008),
    [anon_sym__alignof] = ACTIONS(1008),
    [anon_sym_alignof] = ACTIONS(1008),
    [anon_sym__Alignof] = ACTIONS(1008),
    [anon_sym_offsetof] = ACTIONS(1011),
    [anon_sym__Generic] = ACTIONS(1014),
    [anon_sym_asm] = ACTIONS(1017),
    [anon_sym___asm__] = ACTIONS(1017),
    [sym_number_literal] = ACTIONS(1020),
    [anon_sym_L_SQUOTE] = ACTIONS(1023),
    [anon_sym_u_SQUOTE] = ACTIONS(1023),
    [anon_sym_U_SQUOTE] = ACTIONS(1023),
    [anon_sym_u8_SQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1023),
    [anon_sym_L_DQUOTE] = ACTIONS(1026),
    [anon_sym_u_DQUOTE] = ACTIONS(1026),
    [anon_sym_U_DQUOTE] = ACTIONS(1026),
    [anon_sym_u8_DQUOTE] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1026),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [anon_sym_NULL] = ACTIONS(1032),
    [anon_sym_nullptr] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_declaration] = STATE(77),
    [sym_type_definition] = STATE(77),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1496),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(77),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(77),
    [sym_labeled_statement] = STATE(77),
    [sym_expression_statement] = STATE(77),
    [sym_if_statement] = STATE(77),
    [sym_switch_statement] = STATE(77),
    [sym_while_statement] = STATE(77),
    [sym_do_statement] = STATE(77),
    [sym_for_statement] = STATE(77),
    [sym_return_statement] = STATE(77),
    [sym_break_statement] = STATE(77),
    [sym_continue_statement] = STATE(77),
    [sym_goto_statement] = STATE(77),
    [sym_seh_try_statement] = STATE(77),
    [sym_seh_leave_statement] = STATE(77),
    [sym__expression] = STATE(1203),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2003),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(408),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(77),
    [sym_identifier] = ACTIONS(1105),
    [aux_sym_preproc_include_token1] = ACTIONS(1043),
    [aux_sym_preproc_def_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token1] = ACTIONS(1043),
    [aux_sym_preproc_if_token2] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1043),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1043),
    [sym_preproc_directive] = ACTIONS(1043),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym___extension__] = ACTIONS(723),
    [anon_sym_typedef] = ACTIONS(725),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(1043),
    [anon_sym___clrcall] = ACTIONS(1043),
    [anon_sym___stdcall] = ACTIONS(1043),
    [anon_sym___fastcall] = ACTIONS(1043),
    [anon_sym___thiscall] = ACTIONS(1043),
    [anon_sym___vectorcall] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(729),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(731),
    [anon_sym_else] = ACTIONS(1043),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_case] = ACTIONS(1043),
    [anon_sym_default] = ACTIONS(1043),
    [anon_sym_while] = ACTIONS(739),
    [anon_sym_do] = ACTIONS(741),
    [anon_sym_for] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_goto] = ACTIONS(751),
    [anon_sym___try] = ACTIONS(753),
    [anon_sym___leave] = ACTIONS(755),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_declaration] = STATE(80),
    [sym_type_definition] = STATE(80),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(80),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(80),
    [sym_labeled_statement] = STATE(80),
    [sym_expression_statement] = STATE(80),
    [sym_if_statement] = STATE(80),
    [sym_switch_statement] = STATE(80),
    [sym_while_statement] = STATE(80),
    [sym_do_statement] = STATE(80),
    [sym_for_statement] = STATE(80),
    [sym_return_statement] = STATE(80),
    [sym_break_statement] = STATE(80),
    [sym_continue_statement] = STATE(80),
    [sym_goto_statement] = STATE(80),
    [sym_seh_try_statement] = STATE(80),
    [sym_seh_leave_statement] = STATE(80),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(425),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(80),
    [sym_identifier] = ACTIONS(1261),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [sym_primitive_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_struct] = ACTIONS(53),
    [anon_sym_union] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(1263),
    [anon_sym_else] = ACTIONS(1037),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(1265),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(1267),
    [anon_sym_return] = ACTIONS(71),
    [anon_sym_break] = ACTIONS(73),
    [anon_sym_continue] = ACTIONS(75),
    [anon_sym_goto] = ACTIONS(77),
    [anon_sym___try] = ACTIONS(1269),
    [anon_sym___leave] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_sizeof] = ACTIONS(81),
    [anon_sym___alignof__] = ACTIONS(83),
    [anon_sym___alignof] = ACTIONS(83),
    [anon_sym__alignof] = ACTIONS(83),
    [anon_sym_alignof] = ACTIONS(83),
    [anon_sym__Alignof] = ACTIONS(83),
    [anon_sym_offsetof] = ACTIONS(85),
    [anon_sym__Generic] = ACTIONS(87),
    [anon_sym_asm] = ACTIONS(89),
    [anon_sym___asm__] = ACTIONS(89),
    [sym_number_literal] = ACTIONS(157),
    [anon_sym_L_SQUOTE] = ACTIONS(93),
    [anon_sym_u_SQUOTE] = ACTIONS(93),
    [anon_sym_U_SQUOTE] = ACTIONS(93),
    [anon_sym_u8_SQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [anon_sym_L_DQUOTE] = ACTIONS(95),
    [anon_sym_u_DQUOTE] = ACTIONS(95),
    [anon_sym_U_DQUOTE] = ACTIONS(95),
    [anon_sym_u8_DQUOTE] = ACTIONS(95),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [anon_sym_NULL] = ACTIONS(99),
    [anon_sym_nullptr] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_declaration] = STATE(80),
    [sym_type_definition] = STATE(80),
    [sym__declaration_modifiers] = STATE(869),
    [sym__declaration_specifiers] = STATE(1483),
    [sym_attribute_specifier] = STATE(869),
    [sym_attribute_declaration] = STATE(504),
    [sym_ms_declspec_modifier] = STATE(869),
    [sym_compound_statement] = STATE(80),
    [sym_storage_class_specifier] = STATE(869),
    [sym_type_qualifier] = STATE(869),
    [sym__type_specifier] = STATE(1074),
    [sym_sized_type_specifier] = STATE(1099),
    [sym_enum_specifier] = STATE(1099),
    [sym_struct_specifier] = STATE(1099),
    [sym_union_specifier] = STATE(1099),
    [sym_attributed_statement] = STATE(80),
    [sym_labeled_statement] = STATE(80),
    [sym_expression_statement] = STATE(80),
    [sym_if_statement] = STATE(80),
    [sym_switch_statement] = STATE(80),
    [sym_while_statement] = STATE(80),
    [sym_do_statement] = STATE(80),
    [sym_for_statement] = STATE(80),
    [sym_return_statement] = STATE(80),
    [sym_break_statement] = STATE(80),
    [sym_continue_statement] = STATE(80),
    [sym_goto_statement] = STATE(80),
    [sym_seh_try_statement] = STATE(80),
    [sym_seh_leave_statement] = STATE(80),
    [sym__expression] = STATE(1235),
    [sym__expression_not_binary] = STATE(824),
    [sym_comma_expression] = STATE(2176),
    [sym_conditional_expression] = STATE(824),
    [sym_assignment_expression] = STATE(824),
    [sym_pointer_expression] = STATE(922),
    [sym_unary_expression] = STATE(824),
    [sym_binary_expression] = STATE(824),
    [sym_update_expression] = STATE(824),
    [sym_cast_expression] = STATE(824),
    [sym_sizeof_expression] = STATE(824),
    [sym_alignof_expression] = STATE(824),
    [sym_offsetof_expression] = STATE(824),
    [sym_generic_expression] = STATE(824),
    [sym_subscript_expression] = STATE(922),
    [sym_call_expression] = STATE(922),
    [sym_gnu_asm_expression] = STATE(824),
    [sym_field_expression] = STATE(922),
    [sym_compound_literal_expression] = STATE(824),
    [sym_parenthesized_expression] = STATE(922),
    [sym_char_literal] = STATE(824),
    [sym_concatenated_string] = STATE(824),
    [sym_string_literal] = STATE(774),
    [sym_null] = STATE(824),
    [sym_macro_type_specifier] = STATE(1099),
    [aux_sym__declaration_specifiers_repeat1] = STATE(869),
    [aux_sym_attributed_declarator_repeat1] = STATE(425),
    [aux_sym_sized_type_specifier_repeat1] = STATE(1109),
    [aux_sym_case_statement_repeat1] = STATE(80),
    [sym_identifier] = ACTIONS(1271),
    [anon_sym_LPAREN2] = ACTIONS(915),
    [anon_sym_BANG] = ACTIONS(918),
    [anon_sym_TILDE] = ACTIONS(918),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(924),
    [anon_sym_AMP] = ACTIONS(924),
    [anon_sym_SEMI] = ACTIONS(1168),
    [anon_sym___extension__] = ACTIONS(1119),
    [anon_sym_typedef] = ACTIONS(1122),
    [anon_sym_extern] = ACTIONS(936),
    [anon_sym___attribute__] = ACTIONS(939),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(942),
    [anon_sym___declspec] = ACTIONS(945),
    [anon_sym_LBRACE] = ACTIONS(1125),
    [anon_sym_signed] = ACTIONS(951),
    [anon_sym_unsigned] = ACTIONS(951),
    [anon_sym_long] = ACTIONS(951),
    [anon_sym_short] = ACTIONS(951),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_auto] = ACTIONS(936),
    [anon_sym_register] = ACTIONS(936),
    [anon_sym_inline] = ACTIONS(936),
    [anon_sym___inline] = ACTIONS(936),
    [anon_sym___inline__] = ACTIONS(936),
    [anon_sym___forceinline] = ACTIONS(936),
    [anon_sym_thread_local] = ACTIONS(936),
    [anon_sym___thread] = ACTIONS(936),
    [anon_sym_const] = ACTIONS(954),
    [anon_sym_constexpr] = ACTIONS(954),
    [anon_sym_volatile] = ACTIONS(954),
    [anon_sym_restrict] = ACTIONS(954),
    [anon_sym___restrict__] = ACTIONS(954),
    [anon_sym__Atomic] = ACTIONS(954),
    [anon_sym__Noreturn] = ACTIONS(954),
    [anon_sym_noreturn] = ACTIONS(954),
    [sym_primitive_type] = ACTIONS(95