  $ cat <<'EOF' >> $HGRCPATH
  > [ui]
  > interactive = True
  > nontty = True
  > [extensions]
  > tortoisehg.util.pipeui =
  > EOF

  $ cat <<'EOF' > testui.py
  > from mercurial import registrar
  > cmdtable = {}
  > command = registrar.command(cmdtable)
  > @command('testwrite', norepo=True)
  > def testwrite(ui):
  >     ui.debug('debug\n')
  >     ui.status('status\n')
  >     ui.warn('warn\n')
  > @command('testprogress', norepo=True)
  > def testprogress(ui):
  >     ui.progress('topic', 0, 'item', 'unit', total=1)
  >     ui.progress('topic', None)
  > @command('testprompt', norepo=True)
  > def testprompt(ui):
  >     ui.prompt('prompt:')
  > @command('testpromptchoice', norepo=True)
  > def testpromptchoice(ui):
  >     ui.promptchoice('promptchoice$$ &foo $$ &bar')
  > @command('testgetpass', norepo=True)
  > def testgetpass(ui):
  >     ui.getpass('getpass: ')
  > EOF
  $ echo 'testui = testui.py' >> $HGRCPATH

  $ hg testwrite --debug
  \x01 ui.debug (esc)
  debug
  \x01 ui.status (esc)
  status
  \x01 ui.warning (esc)
  warn

  $ hg testprogress
  \x01ui.progress (esc)
  topic\x000\x00item\x00unit\x001\x01ui.progress (esc)
  topic\x00\x00\x00\x00 (no-eol) (esc)

  $ echo y | hg testprompt
  \x01ui.prompt (esc)
  prompt:\x00y y (esc)

  $ echo b | hg testpromptchoice
  \x01ui.promptchoice ui.prompt (esc)
  promptchoice$$ &foo $$ &bar\x00f b (esc)

  $ echo 1234 | hg testgetpass
  \x01ui.getpass ui.prompt (esc)
  getpass:  (no-eol)
