"""Test for compatibility with Mercurial API"""

import inspect
from nose.tools import *

from tortoisehg.hgqt import thread

def assert_same_argspec(f, g):
    fa, ga = inspect.getargspec(f), inspect.getargspec(g)
    assert_equals(fa, ga,
                  '%s != %s' % (inspect.formatargspec(*fa),
                                inspect.formatargspec(*ga)))

def overridden_methods(cls):
    basemethods = inspect.getmembers(cls.__base__, inspect.ismethod)
    return [(name, basemeth, getattr(cls, name))
            for name, basemeth in basemethods
            if basemeth.im_func is not getattr(cls, name).im_func]


def test_cmdthread_qtui():
    for name, basemeth, meth in overridden_methods(thread.QtUi):
        if name == '__init__':
            continue
        yield assert_same_argspec, basemeth, meth
