/* netinfo.h -- generated by Trunnel v1.5.2.
 * https://gitweb.torproject.org/trunnel.git
 * You probably shouldn't edit this file.
 */
#ifndef TRUNNEL_NETINFO_H
#define TRUNNEL_NETINFO_H

#include <stdint.h>
#include "trunnel.h"

#define NETINFO_ADDR_TYPE_IPV4 4
#define NETINFO_ADDR_TYPE_IPV6 6
#if !defined(TRUNNEL_OPAQUE) && !defined(TRUNNEL_OPAQUE_NETINFO_ADDR)
struct netinfo_addr_st {
  uint8_t addr_type;
  uint8_t len;
  uint32_t addr_ipv4;
  uint8_t addr_ipv6[16];
  uint8_t trunnel_error_code_;
};
#endif
typedef struct netinfo_addr_st netinfo_addr_t;
#if !defined(TRUNNEL_OPAQUE) && !defined(TRUNNEL_OPAQUE_NETINFO_CELL)
struct netinfo_cell_st {
  uint32_t timestamp;
  struct netinfo_addr_st *other_addr;
  uint8_t n_my_addrs;
  TRUNNEL_DYNARRAY_HEAD(, struct netinfo_addr_st *) my_addrs;
  uint8_t trunnel_error_code_;
};
#endif
typedef struct netinfo_cell_st netinfo_cell_t;
/** Return a newly allocated netinfo_addr with all elements set to
 * zero.
 */
netinfo_addr_t *netinfo_addr_new(void);
/** Release all storage held by the netinfo_addr in 'victim'. (Do
 * nothing if 'victim' is NULL.)
 */
void netinfo_addr_free(netinfo_addr_t *victim);
/** Try to parse a netinfo_addr from the buffer in 'input', using up
 * to 'len_in' bytes from the input buffer. On success, return the
 * number of bytes consumed and set *output to the newly allocated
 * netinfo_addr_t. On failure, return -2 if the input appears
 * truncated, and -1 if the input is otherwise invalid.
 */
ssize_t netinfo_addr_parse(netinfo_addr_t **output, const uint8_t *input, const size_t len_in);
/** Return the number of bytes we expect to need to encode the
 * netinfo_addr in 'obj'. On failure, return a negative value. Note
 * that this value may be an overestimate, and can even be an
 * underestimate for certain unencodeable objects.
 */
ssize_t netinfo_addr_encoded_len(const netinfo_addr_t *obj);
/** Try to encode the netinfo_addr from 'input' into the buffer at
 * 'output', using up to 'avail' bytes of the output buffer. On
 * success, return the number of bytes used. On failure, return -2 if
 * the buffer was not long enough, and -1 if the input was invalid.
 */
ssize_t netinfo_addr_encode(uint8_t *output, size_t avail, const netinfo_addr_t *input);
/** Check whether the internal state of the netinfo_addr in 'obj' is
 * consistent. Return NULL if it is, and a short message if it is not.
 */
const char *netinfo_addr_check(const netinfo_addr_t *obj);
/** Clear any errors that were set on the object 'obj' by its setter
 * functions. Return true iff errors were cleared.
 */
int netinfo_addr_clear_errors(netinfo_addr_t *obj);
/** Return the value of the addr_type field of the netinfo_addr_t in
 * 'inp'
 */
uint8_t netinfo_addr_get_addr_type(const netinfo_addr_t *inp);
/** Set the value of the addr_type field of the netinfo_addr_t in
 * 'inp' to 'val'. Return 0 on success; return -1 and set the error
 * code on 'inp' on failure.
 */
int netinfo_addr_set_addr_type(netinfo_addr_t *inp, uint8_t val);
/** Return the value of the len field of the netinfo_addr_t in 'inp'
 */
uint8_t netinfo_addr_get_len(const netinfo_addr_t *inp);
/** Set the value of the len field of the netinfo_addr_t in 'inp' to
 * 'val'. Return 0 on success; return -1 and set the error code on
 * 'inp' on failure.
 */
int netinfo_addr_set_len(netinfo_addr_t *inp, uint8_t val);
/** Return the value of the addr_ipv4 field of the netinfo_addr_t in
 * 'inp'
 */
uint32_t netinfo_addr_get_addr_ipv4(const netinfo_addr_t *inp);
/** Set the value of the addr_ipv4 field of the netinfo_addr_t in
 * 'inp' to 'val'. Return 0 on success; return -1 and set the error
 * code on 'inp' on failure.
 */
int netinfo_addr_set_addr_ipv4(netinfo_addr_t *inp, uint32_t val);
/** Return the (constant) length of the array holding the addr_ipv6
 * field of the netinfo_addr_t in 'inp'.
 */
size_t netinfo_addr_getlen_addr_ipv6(const netinfo_addr_t *inp);
/** Return the element at position 'idx' of the fixed array field
 * addr_ipv6 of the netinfo_addr_t in 'inp'.
 */
uint8_t netinfo_addr_get_addr_ipv6(netinfo_addr_t *inp, size_t idx);
/** As netinfo_addr_get_addr_ipv6, but take and return a const pointer
 */
uint8_t netinfo_addr_getconst_addr_ipv6(const netinfo_addr_t *inp, size_t idx);
/** Change the element at position 'idx' of the fixed array field
 * addr_ipv6 of the netinfo_addr_t in 'inp', so that it will hold the
 * value 'elt'.
 */
int netinfo_addr_set_addr_ipv6(netinfo_addr_t *inp, size_t idx, uint8_t elt);
/** Return a pointer to the 16-element array field addr_ipv6 of 'inp'.
 */
uint8_t * netinfo_addr_getarray_addr_ipv6(netinfo_addr_t *inp);
/** As netinfo_addr_get_addr_ipv6, but take and return a const pointer
 */
const uint8_t  * netinfo_addr_getconstarray_addr_ipv6(const netinfo_addr_t *inp);
/** Return a newly allocated netinfo_cell with all elements set to
 * zero.
 */
netinfo_cell_t *netinfo_cell_new(void);
/** Release all storage held by the netinfo_cell in 'victim'. (Do
 * nothing if 'victim' is NULL.)
 */
void netinfo_cell_free(netinfo_cell_t *victim);
/** Try to parse a netinfo_cell from the buffer in 'input', using up
 * to 'len_in' bytes from the input buffer. On success, return the
 * number of bytes consumed and set *output to the newly allocated
 * netinfo_cell_t. On failure, return -2 if the input appears
 * truncated, and -1 if the input is otherwise invalid.
 */
ssize_t netinfo_cell_parse(netinfo_cell_t **output, const uint8_t *input, const size_t len_in);
/** Return the number of bytes we expect to need to encode the
 * netinfo_cell in 'obj'. On failure, return a negative value. Note
 * that this value may be an overestimate, and can even be an
 * underestimate for certain unencodeable objects.
 */
ssize_t netinfo_cell_encoded_len(const netinfo_cell_t *obj);
/** Try to encode the netinfo_cell from 'input' into the buffer at
 * 'output', using up to 'avail' bytes of the output buffer. On
 * success, return the number of bytes used. On failure, return -2 if
 * the buffer was not long enough, and -1 if the input was invalid.
 */
ssize_t netinfo_cell_encode(uint8_t *output, size_t avail, const netinfo_cell_t *input);
/** Check whether the internal state of the netinfo_cell in 'obj' is
 * consistent. Return NULL if it is, and a short message if it is not.
 */
const char *netinfo_cell_check(const netinfo_cell_t *obj);
/** Clear any errors that were set on the object 'obj' by its setter
 * functions. Return true iff errors were cleared.
 */
int netinfo_cell_clear_errors(netinfo_cell_t *obj);
/** Return the value of the timestamp field of the netinfo_cell_t in
 * 'inp'
 */
uint32_t netinfo_cell_get_timestamp(const netinfo_cell_t *inp);
/** Set the value of the timestamp field of the netinfo_cell_t in
 * 'inp' to 'val'. Return 0 on success; return -1 and set the error
 * code on 'inp' on failure.
 */
int netinfo_cell_set_timestamp(netinfo_cell_t *inp, uint32_t val);
/** Return the value of the other_addr field of the netinfo_cell_t in
 * 'inp'
 */
struct netinfo_addr_st * netinfo_cell_get_other_addr(netinfo_cell_t *inp);
/** As netinfo_cell_get_other_addr, but take and return a const
 * pointer
 */
const struct netinfo_addr_st * netinfo_cell_getconst_other_addr(const netinfo_cell_t *inp);
/** Set the value of the other_addr field of the netinfo_cell_t in
 * 'inp' to 'val'. Free the old value if any. Steals the referenceto
 * 'val'.Return 0 on success; return -1 and set the error code on
 * 'inp' on failure.
 */
int netinfo_cell_set_other_addr(netinfo_cell_t *inp, struct netinfo_addr_st *val);
/** As netinfo_cell_set_other_addr, but does not free the previous
 * value.
 */
int netinfo_cell_set0_other_addr(netinfo_cell_t *inp, struct netinfo_addr_st *val);
/** Return the value of the n_my_addrs field of the netinfo_cell_t in
 * 'inp'
 */
uint8_t netinfo_cell_get_n_my_addrs(const netinfo_cell_t *inp);
/** Set the value of the n_my_addrs field of the netinfo_cell_t in
 * 'inp' to 'val'. Return 0 on success; return -1 and set the error
 * code on 'inp' on failure.
 */
int netinfo_cell_set_n_my_addrs(netinfo_cell_t *inp, uint8_t val);
/** Return the length of the dynamic array holding the my_addrs field
 * of the netinfo_cell_t in 'inp'.
 */
size_t netinfo_cell_getlen_my_addrs(const netinfo_cell_t *inp);
/** Return the element at position 'idx' of the dynamic array field
 * my_addrs of the netinfo_cell_t in 'inp'.
 */
struct netinfo_addr_st * netinfo_cell_get_my_addrs(netinfo_cell_t *inp, size_t idx);
/** As netinfo_cell_get_my_addrs, but take and return a const pointer
 */
 const struct netinfo_addr_st * netinfo_cell_getconst_my_addrs(const netinfo_cell_t *inp, size_t idx);
/** Change the element at position 'idx' of the dynamic array field
 * my_addrs of the netinfo_cell_t in 'inp', so that it will hold the
 * value 'elt'. Free the previous value, if any.
 */
int netinfo_cell_set_my_addrs(netinfo_cell_t *inp, size_t idx, struct netinfo_addr_st * elt);
/** As netinfo_cell_set_my_addrs, but does not free the previous
 * value.
 */
int netinfo_cell_set0_my_addrs(netinfo_cell_t *inp, size_t idx, struct netinfo_addr_st * elt);
/** Append a new element 'elt' to the dynamic array field my_addrs of
 * the netinfo_cell_t in 'inp'.
 */
int netinfo_cell_add_my_addrs(netinfo_cell_t *inp, struct netinfo_addr_st * elt);
/** Return a pointer to the variable-length array field my_addrs of
 * 'inp'.
 */
struct netinfo_addr_st * * netinfo_cell_getarray_my_addrs(netinfo_cell_t *inp);
/** As netinfo_cell_get_my_addrs, but take and return a const pointer
 */
const struct netinfo_addr_st *  const  * netinfo_cell_getconstarray_my_addrs(const netinfo_cell_t *inp);
/** Change the length of the variable-length array field my_addrs of
 * 'inp' to 'newlen'.Fill extra elements with NULL; free removed
 * elements. Return 0 on success; return -1 and set the error code on
 * 'inp' on failure.
 */
int netinfo_cell_setlen_my_addrs(netinfo_cell_t *inp, size_t newlen);


#endif
