/* Generated by TOM (version 2.5): Do not edit this file *//*
 * Copyright (c) 2000-2007, INRIA
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 
 *	- Redistributions of source code must retain the above copyright
 *	notice, this list of conditions and the following disclaimer.  
 *	- Redistributions in binary form must reproduce the above copyright
 *	notice, this list of conditions and the following disclaimer in the
 *	documentation and/or other materials provided with the distribution.
 *	- Neither the name of the INRIA nor the names of its
 *	contributors may be used to endorse or promote products derived from
 *	this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package tom.library.bytecode;

import java.util.HashMap;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

import tom.library.adt.bytecode.*;
import tom.library.adt.bytecode.types.*;

public class ToolBox {
  /* Generated by TOM (version 2.5): Do not edit this file */private static boolean tom_equal_term_Strategy(Object t1, Object t2) { return t1.equals(t2);}private static boolean tom_is_sort_Strategy(Object t) { return  t instanceof tom.library.sl.Strategy ;}/* Generated by TOM (version 2.5): Do not edit this file *//* Generated by TOM (version 2.5): Do not edit this file */private static boolean tom_equal_term_int(int t1, int t2) { return  (t1==t2) ;}private static boolean tom_is_sort_int(int t) { return  true ;} /* Generated by TOM (version 2.5): Do not edit this file *//* Generated by TOM (version 2.5): Do not edit this file */ private static boolean tom_equal_term_String(String t1, String t2) { return  (t1.equals(t2)) ;}private static boolean tom_is_sort_String(String t) { return  t instanceof String ;}  private static  tom.library.sl.Strategy  tom_make_mu( tom.library.sl.Strategy  var,  tom.library.sl.Strategy  v) { return  new tom.library.sl.Mu(var,v) ; }private static  tom.library.sl.Strategy  tom_make_MuVar( String  name) { return  new tom.library.sl.MuVar(name) ; }private static  tom.library.sl.Strategy  tom_make_Identity() { return  new tom.library.sl.Identity() ; }private static  tom.library.sl.Strategy  tom_make_All( tom.library.sl.Strategy  v) { return  new tom.library.sl.All(v) ; }private static boolean tom_is_fun_sym_Sequence( tom.library.sl.Strategy  t) { return  (t instanceof tom.library.sl.Sequence) ;}private static  tom.library.sl.Strategy  tom_empty_list_Sequence() { return  null ; }private static  tom.library.sl.Strategy  tom_cons_list_Sequence( tom.library.sl.Strategy  head,  tom.library.sl.Strategy  tail) { return  (tail==null)?head:new tom.library.sl.Sequence(head,tail) ; }private static  tom.library.sl.Strategy  tom_get_head_Sequence_Strategy( tom.library.sl.Strategy  t) { return  (tom.library.sl.Strategy)t.getChildAt(tom.library.sl.Sequence.FIRST) ;}private static  tom.library.sl.Strategy  tom_get_tail_Sequence_Strategy( tom.library.sl.Strategy  t) { return  (tom.library.sl.Strategy)t.getChildAt(tom.library.sl.Sequence.THEN) ;}private static boolean tom_is_empty_Sequence_Strategy( tom.library.sl.Strategy  t) { return  t == null ;}   private static   tom.library.sl.Strategy  tom_append_list_Sequence( tom.library.sl.Strategy l1,  tom.library.sl.Strategy  l2) {     if(tom_is_empty_Sequence_Strategy(l1)) {       return l2;     } else if(tom_is_empty_Sequence_Strategy(l2)) {       return l1;     } else if(tom_is_fun_sym_Sequence(l1)) {       if(tom_is_empty_Sequence_Strategy(((tom_is_fun_sym_Sequence(l1))?tom_get_tail_Sequence_Strategy(l1):tom_empty_list_Sequence()))) {         return ( tom.library.sl.Strategy )tom_cons_list_Sequence(((tom_is_fun_sym_Sequence(l1))?tom_get_head_Sequence_Strategy(l1):l1),l2);       } else {         return ( tom.library.sl.Strategy )tom_cons_list_Sequence(((tom_is_fun_sym_Sequence(l1))?tom_get_head_Sequence_Strategy(l1):l1),tom_append_list_Sequence(((tom_is_fun_sym_Sequence(l1))?tom_get_tail_Sequence_Strategy(l1):tom_empty_list_Sequence()),l2));       }     } else {       return ( tom.library.sl.Strategy )tom_cons_list_Sequence(l1, l2);     }   }   private static   tom.library.sl.Strategy  tom_get_slice_Sequence( tom.library.sl.Strategy  begin,  tom.library.sl.Strategy  end, tom.library.sl.Strategy  tail) {     if(tom_equal_term_Strategy(begin,end)) {       return tail;     } else {       return ( tom.library.sl.Strategy )tom_cons_list_Sequence(((tom_is_fun_sym_Sequence(begin))?tom_get_head_Sequence_Strategy(begin):begin),( tom.library.sl.Strategy )tom_get_slice_Sequence(((tom_is_fun_sym_Sequence(begin))?tom_get_tail_Sequence_Strategy(begin):tom_empty_list_Sequence()),end,tail));     }   }    /* Generated by TOM (version 2.5): Do not edit this file */ /* Generated by TOM (version 2.5): Do not edit this file */private static  tom.library.sl.Strategy  tom_make_TopDown( tom.library.sl.Strategy  v) { return tom_make_mu(tom_make_MuVar("_x"),tom_cons_list_Sequence(v,tom_cons_list_Sequence(tom_make_All(tom_make_MuVar("_x")),tom_empty_list_Sequence()))) ; }   /* Generated by TOM (version 2.5): Do not edit this file *//* Generated by TOM (version 2.5): Do not edit this file */private static boolean tom_equal_term_double(double t1, double t2) { return  (t1==t2) ;}private static boolean tom_is_sort_double(double t) { return  true ;} /* Generated by TOM (version 2.5): Do not edit this file */private static boolean tom_equal_term_long(long t1, long t2) { return  (t1==t2) ;}private static boolean tom_is_sort_long(long t) { return  true ;} /* Generated by TOM (version 2.5): Do not edit this file */private static boolean tom_equal_term_float(Object t1, Object t2) { return  (t1==t2) ;}private static boolean tom_is_sort_float(Object t) { return  true ;} private static boolean tom_equal_term_TSignature(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TSignature(Object t) { return  t instanceof tom.library.adt.bytecode.types.TSignature ;}private static boolean tom_equal_term_TAccess(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TAccess(Object t) { return  t instanceof tom.library.adt.bytecode.types.TAccess ;}private static boolean tom_equal_term_TReturnDescriptor(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TReturnDescriptor(Object t) { return  t instanceof tom.library.adt.bytecode.types.TReturnDescriptor ;}private static boolean tom_equal_term_TStringList(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TStringList(Object t) { return  t instanceof tom.library.adt.bytecode.types.TStringList ;}private static boolean tom_equal_term_TValue(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TValue(Object t) { return  t instanceof tom.library.adt.bytecode.types.TValue ;}private static boolean tom_equal_term_TType(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TType(Object t) { return  t instanceof tom.library.adt.bytecode.types.TType ;}private static boolean tom_equal_term_TAccessList(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TAccessList(Object t) { return  t instanceof tom.library.adt.bytecode.types.TAccessList ;}private static boolean tom_equal_term_TMethodDescriptor(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TMethodDescriptor(Object t) { return  t instanceof tom.library.adt.bytecode.types.TMethodDescriptor ;}private static boolean tom_equal_term_TFieldDescriptor(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TFieldDescriptor(Object t) { return  t instanceof tom.library.adt.bytecode.types.TFieldDescriptor ;}private static boolean tom_equal_term_TintList(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TintList(Object t) { return  t instanceof tom.library.adt.bytecode.types.TintList ;}private static boolean tom_equal_term_TFieldDescriptorList(Object t1, Object t2) { return  t1.equals(t2) ;}private static boolean tom_is_sort_TFieldDescriptorList(Object t) { return  t instanceof tom.library.adt.bytecode.types.TFieldDescriptorList ;}private static boolean tom_is_fun_sym_Signature( tom.library.adt.bytecode.types.TSignature  t) { return  t instanceof tom.library.adt.bytecode.types.tsignature.Signature ;}private static  String  tom_get_slot_Signature_sig( tom.library.adt.bytecode.types.TSignature  t) { return  t.getsig() ;}private static  tom.library.adt.bytecode.types.TAccess  tom_make_ABSTRACT() { return  tom.library.adt.bytecode.types.taccess.ABSTRACT.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_ANNOTATION() { return  tom.library.adt.bytecode.types.taccess.ANNOTATION.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_BRIDGE() { return  tom.library.adt.bytecode.types.taccess.BRIDGE.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_DEPRECATED() { return  tom.library.adt.bytecode.types.taccess.DEPRECATED.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_ENUM() { return  tom.library.adt.bytecode.types.taccess.ENUM.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_FINAL() { return  tom.library.adt.bytecode.types.taccess.FINAL.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_INTERFACE() { return  tom.library.adt.bytecode.types.taccess.INTERFACE.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_NATIVE() { return  tom.library.adt.bytecode.types.taccess.NATIVE.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_PRIVATE() { return  tom.library.adt.bytecode.types.taccess.PRIVATE.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_PROTECTED() { return  tom.library.adt.bytecode.types.taccess.PROTECTED.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_PUBLIC() { return  tom.library.adt.bytecode.types.taccess.PUBLIC.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_STATIC() { return  tom.library.adt.bytecode.types.taccess.STATIC.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_STRICT() { return  tom.library.adt.bytecode.types.taccess.STRICT.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_SUPER() { return  tom.library.adt.bytecode.types.taccess.SUPER.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_SYNCHRONIZED() { return  tom.library.adt.bytecode.types.taccess.SYNCHRONIZED.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_SYNTHETIC() { return  tom.library.adt.bytecode.types.taccess.SYNTHETIC.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_TRANSIENT() { return  tom.library.adt.bytecode.types.taccess.TRANSIENT.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_VARARGS() { return  tom.library.adt.bytecode.types.taccess.VARARGS.make() ; }private static  tom.library.adt.bytecode.types.TAccess  tom_make_VOLATILE() { return  tom.library.adt.bytecode.types.taccess.VOLATILE.make() ; }private static  tom.library.adt.bytecode.types.TReturnDescriptor  tom_make_ReturnDescriptor( tom.library.adt.bytecode.types.TFieldDescriptor  t0) { return  tom.library.adt.bytecode.types.treturndescriptor.ReturnDescriptor.make(t0) ; }private static boolean tom_is_fun_sym_Void( tom.library.adt.bytecode.types.TReturnDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.treturndescriptor.Void ;}private static  tom.library.adt.bytecode.types.TReturnDescriptor  tom_make_Void() { return  tom.library.adt.bytecode.types.treturndescriptor.Void.make() ; }private static  tom.library.adt.bytecode.types.TStringList  tom_make_ConsStringList( String  t0,  tom.library.adt.bytecode.types.TStringList  t1) { return  tom.library.adt.bytecode.types.tstringlist.ConsStringList.make(t0, t1) ; }private static boolean tom_is_fun_sym_StringValue( tom.library.adt.bytecode.types.TValue  t) { return  t instanceof tom.library.adt.bytecode.types.tvalue.StringValue ;}private static  tom.library.adt.bytecode.types.TValue  tom_make_StringValue( String  t0) { return  tom.library.adt.bytecode.types.tvalue.StringValue.make(t0) ; }private static  String  tom_get_slot_StringValue_s( tom.library.adt.bytecode.types.TValue  t) { return  t.gets() ;}private static boolean tom_is_fun_sym_IntValue( tom.library.adt.bytecode.types.TValue  t) { return  t instanceof tom.library.adt.bytecode.types.tvalue.IntValue ;}private static  tom.library.adt.bytecode.types.TValue  tom_make_IntValue( int  t0) { return  tom.library.adt.bytecode.types.tvalue.IntValue.make(t0) ; }private static  int  tom_get_slot_IntValue_i( tom.library.adt.bytecode.types.TValue  t) { return  t.geti() ;}private static boolean tom_is_fun_sym_LongValue( tom.library.adt.bytecode.types.TValue  t) { return  t instanceof tom.library.adt.bytecode.types.tvalue.LongValue ;}private static  tom.library.adt.bytecode.types.TValue  tom_make_LongValue( long  t0) { return  tom.library.adt.bytecode.types.tvalue.LongValue.make(t0) ; }private static  long  tom_get_slot_LongValue_l( tom.library.adt.bytecode.types.TValue  t) { return  t.getl() ;}private static boolean tom_is_fun_sym_FloatValue( tom.library.adt.bytecode.types.TValue  t) { return  t instanceof tom.library.adt.bytecode.types.tvalue.FloatValue ;}private static  tom.library.adt.bytecode.types.TValue  tom_make_FloatValue( float  t0) { return  tom.library.adt.bytecode.types.tvalue.FloatValue.make(t0) ; }private static  float  tom_get_slot_FloatValue_f( tom.library.adt.bytecode.types.TValue  t) { return  t.getf() ;}private static boolean tom_is_fun_sym_DoubleValue( tom.library.adt.bytecode.types.TValue  t) { return  t instanceof tom.library.adt.bytecode.types.tvalue.DoubleValue ;}private static  tom.library.adt.bytecode.types.TValue  tom_make_DoubleValue( double  t0) { return  tom.library.adt.bytecode.types.tvalue.DoubleValue.make(t0) ; }private static  double  tom_get_slot_DoubleValue_d( tom.library.adt.bytecode.types.TValue  t) { return  t.getd() ;}private static  tom.library.adt.bytecode.types.TType  tom_make_ARRAY() { return  tom.library.adt.bytecode.types.ttype.ARRAY.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_BOOLEAN() { return  tom.library.adt.bytecode.types.ttype.BOOLEAN.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_BYTE() { return  tom.library.adt.bytecode.types.ttype.BYTE.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_CHAR() { return  tom.library.adt.bytecode.types.ttype.CHAR.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_DOUBLE() { return  tom.library.adt.bytecode.types.ttype.DOUBLE.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_FLOAT() { return  tom.library.adt.bytecode.types.ttype.FLOAT.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_INT() { return  tom.library.adt.bytecode.types.ttype.INT.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_LONG() { return  tom.library.adt.bytecode.types.ttype.LONG.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_OBJECT() { return  tom.library.adt.bytecode.types.ttype.OBJECT.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_SHORT() { return  tom.library.adt.bytecode.types.ttype.SHORT.make() ; }private static  tom.library.adt.bytecode.types.TType  tom_make_VOID() { return  tom.library.adt.bytecode.types.ttype.VOID.make() ; }private static  tom.library.adt.bytecode.types.TAccessList  tom_make_ConsAccessList( tom.library.adt.bytecode.types.TAccess  t0,  tom.library.adt.bytecode.types.TAccessList  t1) { return  tom.library.adt.bytecode.types.taccesslist.ConsAccessList.make(t0, t1) ; }private static  tom.library.adt.bytecode.types.TMethodDescriptor  tom_make_MethodDescriptor( tom.library.adt.bytecode.types.TFieldDescriptorList  t0,  tom.library.adt.bytecode.types.TReturnDescriptor  t1) { return  tom.library.adt.bytecode.types.tmethoddescriptor.MethodDescriptor.make(t0, t1) ; }private static boolean tom_is_fun_sym_ObjectType( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.ObjectType ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_ObjectType( String  t0) { return  tom.library.adt.bytecode.types.tfielddescriptor.ObjectType.make(t0) ; }private static  String  tom_get_slot_ObjectType_className( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t.getclassName() ;}private static boolean tom_is_fun_sym_ArrayType( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.ArrayType ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_ArrayType( tom.library.adt.bytecode.types.TFieldDescriptor  t0) { return  tom.library.adt.bytecode.types.tfielddescriptor.ArrayType.make(t0) ; }private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_get_slot_ArrayType_arrayType( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t.getarrayType() ;}private static boolean tom_is_fun_sym_B( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.B ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_B() { return  tom.library.adt.bytecode.types.tfielddescriptor.B.make() ; }private static boolean tom_is_fun_sym_C( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.C ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_C() { return  tom.library.adt.bytecode.types.tfielddescriptor.C.make() ; }private static boolean tom_is_fun_sym_D( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.D ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_D() { return  tom.library.adt.bytecode.types.tfielddescriptor.D.make() ; }private static boolean tom_is_fun_sym_F( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.F ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_F() { return  tom.library.adt.bytecode.types.tfielddescriptor.F.make() ; }private static boolean tom_is_fun_sym_I( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.I ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_I() { return  tom.library.adt.bytecode.types.tfielddescriptor.I.make() ; }private static boolean tom_is_fun_sym_J( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.J ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_J() { return  tom.library.adt.bytecode.types.tfielddescriptor.J.make() ; }private static boolean tom_is_fun_sym_S( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.S ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_S() { return  tom.library.adt.bytecode.types.tfielddescriptor.S.make() ; }private static boolean tom_is_fun_sym_Z( tom.library.adt.bytecode.types.TFieldDescriptor  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptor.Z ;}private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_make_Z() { return  tom.library.adt.bytecode.types.tfielddescriptor.Z.make() ; }private static  tom.library.adt.bytecode.types.TintList  tom_make_ConsintList( int  t0,  tom.library.adt.bytecode.types.TintList  t1) { return  tom.library.adt.bytecode.types.tintlist.ConsintList.make(t0, t1) ; }private static boolean tom_is_fun_sym_StringList( tom.library.adt.bytecode.types.TStringList  t) { return  t instanceof tom.library.adt.bytecode.types.tstringlist.ConsStringList || t instanceof tom.library.adt.bytecode.types.tstringlist.EmptyStringList ;}private static  tom.library.adt.bytecode.types.TStringList  tom_empty_list_StringList() { return  tom.library.adt.bytecode.types.tstringlist.EmptyStringList.make() ; }private static  tom.library.adt.bytecode.types.TStringList  tom_cons_list_StringList( String  e,  tom.library.adt.bytecode.types.TStringList  l) { return  tom.library.adt.bytecode.types.tstringlist.ConsStringList.make(e,l) ; }private static  String  tom_get_head_StringList_TStringList( tom.library.adt.bytecode.types.TStringList  l) { return  l.getHeadStringList() ;}private static  tom.library.adt.bytecode.types.TStringList  tom_get_tail_StringList_TStringList( tom.library.adt.bytecode.types.TStringList  l) { return  l.getTailStringList() ;}private static boolean tom_is_empty_StringList_TStringList( tom.library.adt.bytecode.types.TStringList  l) { return  l.isEmptyStringList() ;}   private static   tom.library.adt.bytecode.types.TStringList  tom_append_list_StringList( tom.library.adt.bytecode.types.TStringList l1,  tom.library.adt.bytecode.types.TStringList  l2) {     if(tom_is_empty_StringList_TStringList(l1)) {       return l2;     } else if(tom_is_empty_StringList_TStringList(l2)) {       return l1;     } else if(tom_is_empty_StringList_TStringList(tom_get_tail_StringList_TStringList(l1))) {       return ( tom.library.adt.bytecode.types.TStringList )tom_cons_list_StringList(tom_get_head_StringList_TStringList(l1),l2);     } else {       return ( tom.library.adt.bytecode.types.TStringList )tom_cons_list_StringList(tom_get_head_StringList_TStringList(l1),tom_append_list_StringList(tom_get_tail_StringList_TStringList(l1),l2));     }   }   private static   tom.library.adt.bytecode.types.TStringList  tom_get_slice_StringList( tom.library.adt.bytecode.types.TStringList  begin,  tom.library.adt.bytecode.types.TStringList  end, tom.library.adt.bytecode.types.TStringList  tail) {     if(tom_equal_term_TStringList(begin,end)) {       return tail;     } else {       return ( tom.library.adt.bytecode.types.TStringList )tom_cons_list_StringList(tom_get_head_StringList_TStringList(begin),( tom.library.adt.bytecode.types.TStringList )tom_get_slice_StringList(tom_get_tail_StringList_TStringList(begin),end,tail));     }   }   private static boolean tom_is_fun_sym_AccessList( tom.library.adt.bytecode.types.TAccessList  t) { return  t instanceof tom.library.adt.bytecode.types.taccesslist.ConsAccessList || t instanceof tom.library.adt.bytecode.types.taccesslist.EmptyAccessList ;}private static  tom.library.adt.bytecode.types.TAccessList  tom_empty_list_AccessList() { return  tom.library.adt.bytecode.types.taccesslist.EmptyAccessList.make() ; }private static  tom.library.adt.bytecode.types.TAccessList  tom_cons_list_AccessList( tom.library.adt.bytecode.types.TAccess  e,  tom.library.adt.bytecode.types.TAccessList  l) { return  tom.library.adt.bytecode.types.taccesslist.ConsAccessList.make(e,l) ; }private static  tom.library.adt.bytecode.types.TAccess  tom_get_head_AccessList_TAccessList( tom.library.adt.bytecode.types.TAccessList  l) { return  l.getHeadAccessList() ;}private static  tom.library.adt.bytecode.types.TAccessList  tom_get_tail_AccessList_TAccessList( tom.library.adt.bytecode.types.TAccessList  l) { return  l.getTailAccessList() ;}private static boolean tom_is_empty_AccessList_TAccessList( tom.library.adt.bytecode.types.TAccessList  l) { return  l.isEmptyAccessList() ;}   private static   tom.library.adt.bytecode.types.TAccessList  tom_append_list_AccessList( tom.library.adt.bytecode.types.TAccessList l1,  tom.library.adt.bytecode.types.TAccessList  l2) {     if(tom_is_empty_AccessList_TAccessList(l1)) {       return l2;     } else if(tom_is_empty_AccessList_TAccessList(l2)) {       return l1;     } else if(tom_is_empty_AccessList_TAccessList(tom_get_tail_AccessList_TAccessList(l1))) {       return ( tom.library.adt.bytecode.types.TAccessList )tom_cons_list_AccessList(tom_get_head_AccessList_TAccessList(l1),l2);     } else {       return ( tom.library.adt.bytecode.types.TAccessList )tom_cons_list_AccessList(tom_get_head_AccessList_TAccessList(l1),tom_append_list_AccessList(tom_get_tail_AccessList_TAccessList(l1),l2));     }   }   private static   tom.library.adt.bytecode.types.TAccessList  tom_get_slice_AccessList( tom.library.adt.bytecode.types.TAccessList  begin,  tom.library.adt.bytecode.types.TAccessList  end, tom.library.adt.bytecode.types.TAccessList  tail) {     if(tom_equal_term_TAccessList(begin,end)) {       return tail;     } else {       return ( tom.library.adt.bytecode.types.TAccessList )tom_cons_list_AccessList(tom_get_head_AccessList_TAccessList(begin),( tom.library.adt.bytecode.types.TAccessList )tom_get_slice_AccessList(tom_get_tail_AccessList_TAccessList(begin),end,tail));     }   }   private static boolean tom_is_fun_sym_intList( tom.library.adt.bytecode.types.TintList  t) { return  t instanceof tom.library.adt.bytecode.types.tintlist.ConsintList || t instanceof tom.library.adt.bytecode.types.tintlist.EmptyintList ;}private static  tom.library.adt.bytecode.types.TintList  tom_empty_list_intList() { return  tom.library.adt.bytecode.types.tintlist.EmptyintList.make() ; }private static  tom.library.adt.bytecode.types.TintList  tom_cons_list_intList( int  e,  tom.library.adt.bytecode.types.TintList  l) { return  tom.library.adt.bytecode.types.tintlist.ConsintList.make(e,l) ; }private static  int  tom_get_head_intList_TintList( tom.library.adt.bytecode.types.TintList  l) { return  l.getHeadintList() ;}private static  tom.library.adt.bytecode.types.TintList  tom_get_tail_intList_TintList( tom.library.adt.bytecode.types.TintList  l) { return  l.getTailintList() ;}private static boolean tom_is_empty_intList_TintList( tom.library.adt.bytecode.types.TintList  l) { return  l.isEmptyintList() ;}   private static   tom.library.adt.bytecode.types.TintList  tom_append_list_intList( tom.library.adt.bytecode.types.TintList l1,  tom.library.adt.bytecode.types.TintList  l2) {     if(tom_is_empty_intList_TintList(l1)) {       return l2;     } else if(tom_is_empty_intList_TintList(l2)) {       return l1;     } else if(tom_is_empty_intList_TintList(tom_get_tail_intList_TintList(l1))) {       return ( tom.library.adt.bytecode.types.TintList )tom_cons_list_intList(tom_get_head_intList_TintList(l1),l2);     } else {       return ( tom.library.adt.bytecode.types.TintList )tom_cons_list_intList(tom_get_head_intList_TintList(l1),tom_append_list_intList(tom_get_tail_intList_TintList(l1),l2));     }   }   private static   tom.library.adt.bytecode.types.TintList  tom_get_slice_intList( tom.library.adt.bytecode.types.TintList  begin,  tom.library.adt.bytecode.types.TintList  end, tom.library.adt.bytecode.types.TintList  tail) {     if(tom_equal_term_TintList(begin,end)) {       return tail;     } else {       return ( tom.library.adt.bytecode.types.TintList )tom_cons_list_intList(tom_get_head_intList_TintList(begin),( tom.library.adt.bytecode.types.TintList )tom_get_slice_intList(tom_get_tail_intList_TintList(begin),end,tail));     }   }   private static boolean tom_is_fun_sym_FieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptorList  t) { return  t instanceof tom.library.adt.bytecode.types.tfielddescriptorlist.ConsFieldDescriptorList || t instanceof tom.library.adt.bytecode.types.tfielddescriptorlist.EmptyFieldDescriptorList ;}private static  tom.library.adt.bytecode.types.TFieldDescriptorList  tom_empty_list_FieldDescriptorList() { return  tom.library.adt.bytecode.types.tfielddescriptorlist.EmptyFieldDescriptorList.make() ; }private static  tom.library.adt.bytecode.types.TFieldDescriptorList  tom_cons_list_FieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptor  e,  tom.library.adt.bytecode.types.TFieldDescriptorList  l) { return  tom.library.adt.bytecode.types.tfielddescriptorlist.ConsFieldDescriptorList.make(e,l) ; }private static  tom.library.adt.bytecode.types.TFieldDescriptor  tom_get_head_FieldDescriptorList_TFieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptorList  l) { return  l.getHeadFieldDescriptorList() ;}private static  tom.library.adt.bytecode.types.TFieldDescriptorList  tom_get_tail_FieldDescriptorList_TFieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptorList  l) { return  l.getTailFieldDescriptorList() ;}private static boolean tom_is_empty_FieldDescriptorList_TFieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptorList  l) { return  l.isEmptyFieldDescriptorList() ;}   private static   tom.library.adt.bytecode.types.TFieldDescriptorList  tom_append_list_FieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptorList l1,  tom.library.adt.bytecode.types.TFieldDescriptorList  l2) {     if(tom_is_empty_FieldDescriptorList_TFieldDescriptorList(l1)) {       return l2;     } else if(tom_is_empty_FieldDescriptorList_TFieldDescriptorList(l2)) {       return l1;     } else if(tom_is_empty_FieldDescriptorList_TFieldDescriptorList(tom_get_tail_FieldDescriptorList_TFieldDescriptorList(l1))) {       return ( tom.library.adt.bytecode.types.TFieldDescriptorList )tom_cons_list_FieldDescriptorList(tom_get_head_FieldDescriptorList_TFieldDescriptorList(l1),l2);     } else {       return ( tom.library.adt.bytecode.types.TFieldDescriptorList )tom_cons_list_FieldDescriptorList(tom_get_head_FieldDescriptorList_TFieldDescriptorList(l1),tom_append_list_FieldDescriptorList(tom_get_tail_FieldDescriptorList_TFieldDescriptorList(l1),l2));     }   }   private static   tom.library.adt.bytecode.types.TFieldDescriptorList  tom_get_slice_FieldDescriptorList( tom.library.adt.bytecode.types.TFieldDescriptorList  begin,  tom.library.adt.bytecode.types.TFieldDescriptorList  end, tom.library.adt.bytecode.types.TFieldDescriptorList  tail) {     if(tom_equal_term_TFieldDescriptorList(begin,end)) {       return tail;     } else {       return ( tom.library.adt.bytecode.types.TFieldDescriptorList )tom_cons_list_FieldDescriptorList(tom_get_head_FieldDescriptorList_TFieldDescriptorList(begin),( tom.library.adt.bytecode.types.TFieldDescriptorList )tom_get_slice_FieldDescriptorList(tom_get_tail_FieldDescriptorList_TFieldDescriptorList(begin),end,tail));     }   }    


  private final static int[] accessFlags = {
    Opcodes.ACC_ABSTRACT,
    Opcodes.ACC_ANNOTATION,
    Opcodes.ACC_BRIDGE,
    Opcodes.ACC_DEPRECATED,
    Opcodes.ACC_ENUM,
    Opcodes.ACC_FINAL,
    Opcodes.ACC_INTERFACE,
    Opcodes.ACC_NATIVE,
    Opcodes.ACC_PRIVATE,
    Opcodes.ACC_PROTECTED,
    Opcodes.ACC_PUBLIC,
    Opcodes.ACC_STATIC,
    Opcodes.ACC_STRICT,
    Opcodes.ACC_SUPER,
    Opcodes.ACC_SYNCHRONIZED,
    Opcodes.ACC_SYNTHETIC,
    Opcodes.ACC_TRANSIENT,
    Opcodes.ACC_VARARGS,
    Opcodes.ACC_VOLATILE
  };
  private final static TAccess[] accessObj = {
    tom_make_ABSTRACT(),
    tom_make_ANNOTATION(),
    tom_make_BRIDGE(),
    tom_make_DEPRECATED(),
    tom_make_ENUM(),
    tom_make_FINAL(),
    tom_make_INTERFACE(),
    tom_make_NATIVE(),
    tom_make_PRIVATE(),
    tom_make_PROTECTED(),
    tom_make_PUBLIC(),
    tom_make_STATIC(),
    tom_make_STRICT(),
    tom_make_SUPER(),
    tom_make_SYNCHRONIZED(),
    tom_make_SYNTHETIC(),
    tom_make_TRANSIENT(),
    tom_make_VARARGS(),
    tom_make_VOLATILE()
  };

  public static TAccessList buildTAccess(int access) {
    TAccessList list = tom_empty_list_AccessList();
    
    for(int i = 0; i < accessFlags.length; i++) {
      if((access & accessFlags[i]) != 0)
        list = tom_make_ConsAccessList(accessObj[i],list);
    }

    return list;
  }


  public static int buildAccessValue(TAccessList list){
    int value =0;
    HashMap map = new HashMap();
    for(int i =0;i<accessObj.length;i++){
      map.put(accessObj[i],new Integer(accessFlags[i]));
    }

    if (tom_is_sort_TAccessList(list)) {{  tom.library.adt.bytecode.types.TAccessList  tomMatch500NameNumberfreshSubject_1=(( tom.library.adt.bytecode.types.TAccessList )list);if (tom_is_fun_sym_AccessList(tomMatch500NameNumberfreshSubject_1)) {{  tom.library.adt.bytecode.types.TAccessList  tomMatch500NameNumber_freshVar_0=tomMatch500NameNumberfreshSubject_1;{  tom.library.adt.bytecode.types.TAccessList  tomMatch500NameNumber_begin_2=tomMatch500NameNumber_freshVar_0;{  tom.library.adt.bytecode.types.TAccessList  tomMatch500NameNumber_end_3=tomMatch500NameNumber_freshVar_0;do {{{  tom.library.adt.bytecode.types.TAccessList  tomMatch500NameNumber_freshVar_1=tomMatch500NameNumber_end_3;if (!(tom_is_empty_AccessList_TAccessList(tomMatch500NameNumber_freshVar_1))) {{  tom.library.adt.bytecode.types.TAccessList  tomMatch500NameNumber_freshVar_4=tom_get_tail_AccessList_TAccessList(tomMatch500NameNumber_freshVar_1);if ( true ) {

        value = value | ((Integer)map.get(tom_get_head_AccessList_TAccessList(tomMatch500NameNumber_freshVar_1))).intValue();
      }}}}if (tom_is_empty_AccessList_TAccessList(tomMatch500NameNumber_end_3)) {tomMatch500NameNumber_end_3=tomMatch500NameNumber_begin_2;} else {tomMatch500NameNumber_end_3=tom_get_tail_AccessList_TAccessList(tomMatch500NameNumber_end_3);}}} while(!(tom_equal_term_TAccessList(tomMatch500NameNumber_end_3, tomMatch500NameNumber_begin_2)));}}}}}}

    return value;   
  }

  public static String buildSignature(TSignature signature){
    String sig = null;
    if (tom_is_sort_TSignature(signature)) {{  tom.library.adt.bytecode.types.TSignature  tomMatch501NameNumberfreshSubject_1=(( tom.library.adt.bytecode.types.TSignature )signature);if (tom_is_fun_sym_Signature(tomMatch501NameNumberfreshSubject_1)) {{  String  tomMatch501NameNumber_freshVar_0=tom_get_slot_Signature_sig(tomMatch501NameNumberfreshSubject_1);if ( true ) {
sig=tomMatch501NameNumber_freshVar_0;}}}}}

    return sig;
  }

  public static TValue buildTValue(Object v) {
    if(v instanceof String)
      return tom_make_StringValue((String)v);
    else if(v instanceof Integer)
      return tom_make_IntValue(((Integer)v).intValue());
    else if(v instanceof Long)
      return tom_make_LongValue(((Long)v).longValue());
    else if(v instanceof Float)
      return tom_make_FloatValue(((Float)v).floatValue());
    else if(v instanceof Double)
      return tom_make_DoubleValue(((Double)v).doubleValue());

    return null;
  }

  public static Object buildConstant(TValue value) {
      if (tom_is_sort_TValue(value)) {{  tom.library.adt.bytecode.types.TValue  tomMatch502NameNumberfreshSubject_1=(( tom.library.adt.bytecode.types.TValue )value);if (tom_is_fun_sym_StringValue(tomMatch502NameNumberfreshSubject_1)) {{  String  tomMatch502NameNumber_freshVar_0=tom_get_slot_StringValue_s(tomMatch502NameNumberfreshSubject_1);if ( true ) {
 return tomMatch502NameNumber_freshVar_0;}}}if (tom_is_fun_sym_IntValue(tomMatch502NameNumberfreshSubject_1)) {{  int  tomMatch502NameNumber_freshVar_1=tom_get_slot_IntValue_i(tomMatch502NameNumberfreshSubject_1);if ( true ) {
return new Integer(tomMatch502NameNumber_freshVar_1);}}}if (tom_is_fun_sym_LongValue(tomMatch502NameNumberfreshSubject_1)) {{  long  tomMatch502NameNumber_freshVar_2=tom_get_slot_LongValue_l(tomMatch502NameNumberfreshSubject_1);if ( true ) {
return new Long(tomMatch502NameNumber_freshVar_2);}}}if (tom_is_fun_sym_FloatValue(tomMatch502NameNumberfreshSubject_1)) {{  float  tomMatch502NameNumber_freshVar_3=tom_get_slot_FloatValue_f(tomMatch502NameNumberfreshSubject_1);if ( true ) {
return new Float(tomMatch502NameNumber_freshVar_3);}}}if (tom_is_fun_sym_DoubleValue(tomMatch502NameNumberfreshSubject_1)) {{  double  tomMatch502NameNumber_freshVar_4=tom_get_slot_DoubleValue_d(tomMatch502NameNumberfreshSubject_1);if ( true ) {
return new Double(tomMatch502NameNumber_freshVar_4);}}}}}

      return null;
  }

  public static TStringList buildTStringList(String[] array) {
    TStringList list = tom_empty_list_StringList();
    if(array != null) {
      for(int i = array.length - 1; i >= 0; i--)
        list = tom_make_ConsStringList(array[i],list);
    }

    return list;
  }

  public static TintList buildTintList(int[] array) {
    TintList list = tom_empty_list_intList();
    if(array != null) {
      for(int i = array.length - 1; i >= 0; i--) {
        list = tom_make_ConsintList(array[i],list);
      }
    }

    return list;
  }

  public static TType buildTType(String type) {
    int t = Type.getType(type).getSort();
    TType ret = null;
    switch(t) {
      case Type.ARRAY:
        ret = tom_make_ARRAY();
        break;
      case Type.BOOLEAN:
        ret = tom_make_BOOLEAN();
        break;
      case Type.BYTE:
        ret = tom_make_BYTE();
        break;
      case Type.CHAR:
        ret = tom_make_CHAR();
        break;
      case Type.DOUBLE:
        ret = tom_make_DOUBLE();
        break;
      case Type.FLOAT:
        ret = tom_make_FLOAT();
        break;
      case Type.INT:
        ret = tom_make_INT();
        break;
      case Type.LONG:
        ret = tom_make_LONG();
        break;
      case Type.OBJECT:
        ret = tom_make_OBJECT();
        break;
      case Type.SHORT:
        ret = tom_make_SHORT();
        break;
      case Type.VOID:
        ret = tom_make_VOID();
        break;
    }

    return ret;
  }

  private static class Counter { public int count = 0; }
  public static TFieldDescriptor buildTFieldDescriptor(String desc) {
    Counter count = new Counter();
    TFieldDescriptor fDesc = buildTFieldDescriptorFrom(desc, count);
    if(count.count != desc.length())
      System.err.println("Malformed descriptor : " + desc);
    return fDesc;
  }

  private static TFieldDescriptor buildTFieldDescriptorFrom(String desc, Counter count) {
    TFieldDescriptor fDesc = null;
    switch(desc.charAt(count.count)) {
      case 'L':
        count.count++;
        int j = desc.indexOf(';', count.count);
        if(j == -1)
          System.err.println("Malformed descriptor : " + desc);
        String className = desc.substring(count.count, j);
        count.count += className.length() + 1;
        fDesc = tom_make_ObjectType(className);
        break;
      case '[':
        count.count++;
        fDesc = tom_make_ArrayType(buildTFieldDescriptorFrom(desc,count));
        break;
      case 'B':
        count.count++;
        fDesc = tom_make_B();
        break;
      case 'C':
        count.count++;
        fDesc = tom_make_C();
        break;
      case 'D':
        count.count++;
        fDesc = tom_make_D();
        break;
      case 'F':
        count.count++;
        fDesc = tom_make_F();
        break;
      case 'I':
        count.count++;
        fDesc = tom_make_I();
        break;
      case 'J':
        count.count++;
        fDesc = tom_make_J();
        break;
      case 'S':
        count.count++;
        fDesc = tom_make_S();
        break;
      case 'Z':
        count.count++;
        fDesc = tom_make_Z();
        break;
    }
    if(fDesc == null)
      System.err.println("Malformed descriptor : " + desc);
    return fDesc;
  }

  public static TReturnDescriptor buildTReturnDescriptor(String desc) {
    if(desc.charAt(0) == 'V' && desc.length() == 1)
      return tom_make_Void();
    return tom_make_ReturnDescriptor(buildTFieldDescriptor(desc));
  }

  public static TMethodDescriptor buildTMethodDescriptor(String desc) {
    int endParam = desc.indexOf(')', 1);
    if(desc.charAt(0) != '(' || endParam == -1)
      System.err.println("Malformed descriptor : " + desc);

    TFieldDescriptorList fList = tom_empty_list_FieldDescriptorList();
    Counter count = new Counter();
    count.count++;
    while(count.count < endParam)
      fList = tom_append_list_FieldDescriptorList(fList,tom_cons_list_FieldDescriptorList(buildTFieldDescriptorFrom(desc,count),tom_empty_list_FieldDescriptorList()));
    if(count.count != endParam)
      System.err.println("Malformed descriptor : " + desc);
    TReturnDescriptor ret = buildTReturnDescriptor(desc.substring(count.count + 1));
    return tom_make_MethodDescriptor(fList,ret);
  }

  private static boolean tom_is_sort_StringBuffer(Object t) { return 

 t instanceof StringBuffer ;}private static class BuildDescriptor extends  tom.library.adt.bytecode.BytecodeBasicStrategy  {private  StringBuffer  sb; public BuildDescriptor( StringBuffer  sb) { super(tom_make_Identity());this.sb=sb;}public  StringBuffer  getsb() { return sb;}public tom.library.sl.Visitable[] getChildren() {tom.library.sl.Visitable[] stratChilds = new tom.library.sl.Visitable[getChildCount()];for (int i = 0; i < getChildCount(); i++) {stratChilds[i]=getChildAt(i);}return stratChilds;}public tom.library.sl.Visitable setChildren(tom.library.sl.Visitable[] children) {for (int i = 0; i < getChildCount(); i++) {setChildAt(i,children[i]);}return this;}public int getChildCount() { return 1; }public tom.library.sl.Visitable getChildAt(int index) {switch (index) {case 0: return super.getChildAt(0);default: throw new IndexOutOfBoundsException();}}public tom.library.sl.Visitable setChildAt(int index, tom.library.sl.Visitable child) {switch (index) {case 0: return super.setChildAt(0, child);default: throw new IndexOutOfBoundsException();}}public  tom.library.adt.bytecode.types.TFieldDescriptor  visit_TFieldDescriptor( tom.library.adt.bytecode.types.TFieldDescriptor  tom__arg) throws tom.library.sl.VisitFailure {if (tom_is_sort_TFieldDescriptor(tom__arg)) {{  tom.library.adt.bytecode.types.TFieldDescriptor  tomMatch503NameNumberfreshSubject_1=(( tom.library.adt.bytecode.types.TFieldDescriptor )tom__arg);if (tom_is_fun_sym_ObjectType(tomMatch503NameNumberfreshSubject_1)) {{  String  tomMatch503NameNumber_freshVar_0=tom_get_slot_ObjectType_className(tomMatch503NameNumberfreshSubject_1);if ( true ) {



 sb.append("L" + tomMatch503NameNumber_freshVar_0+ ";"); }}}if (tom_is_fun_sym_ArrayType(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('['); }}if (tom_is_fun_sym_B(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('B'); }}if (tom_is_fun_sym_C(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('C'); }}if (tom_is_fun_sym_D(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('D'); }}if (tom_is_fun_sym_F(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('F'); }}if (tom_is_fun_sym_I(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('I'); }}if (tom_is_fun_sym_J(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('J'); }}if (tom_is_fun_sym_S(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('S'); }}if (tom_is_fun_sym_Z(tomMatch503NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('Z'); }}}}return super.visit_TFieldDescriptor(tom__arg); }public  tom.library.adt.bytecode.types.TMethodDescriptor  visit_TMethodDescriptor( tom.library.adt.bytecode.types.TMethodDescriptor  tom__arg) throws tom.library.sl.VisitFailure {if (tom_is_sort_TMethodDescriptor(tom__arg)) {{  tom.library.adt.bytecode.types.TMethodDescriptor  tomMatch504NameNumberfreshSubject_1=(( tom.library.adt.bytecode.types.TMethodDescriptor )tom__arg);if ( true ) {



 sb.append('('); }}}return super.visit_TMethodDescriptor(tom__arg); }public  tom.library.adt.bytecode.types.TReturnDescriptor  visit_TReturnDescriptor( tom.library.adt.bytecode.types.TReturnDescriptor  tom__arg) throws tom.library.sl.VisitFailure {if (tom_is_sort_TReturnDescriptor(tom__arg)) {{  tom.library.adt.bytecode.types.TReturnDescriptor  tomMatch505NameNumberfreshSubject_1=(( tom.library.adt.bytecode.types.TReturnDescriptor )tom__arg);if ( true ) {



 sb.append(')'); }if (tom_is_fun_sym_Void(tomMatch505NameNumberfreshSubject_1)) {if ( true ) {
 sb.append('V'); }}}}return super.visit_TReturnDescriptor(tom__arg); }}private static  tom.library.sl.Strategy  tom_make_BuildDescriptor( StringBuffer  t0) { return new BuildDescriptor(t0); }



  public static String buildDescriptor(TFieldDescriptor desc) {
    StringBuffer sb = new StringBuffer();
    try {
      tom_make_TopDown(tom_make_BuildDescriptor(sb)).visitLight(desc);
    } catch(tom.library.sl.VisitFailure e) { }
    return sb.toString();
  }
  public static String buildDescriptor(TMethodDescriptor desc) {
    StringBuffer sb = new StringBuffer();
    try {
      tom_make_TopDown(tom_make_BuildDescriptor(sb)).visitLight(desc);
    } catch(tom.library.sl.VisitFailure e) { }
    return sb.toString();
  }
}

