/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import antlr.CommonToken;
import antlr.Token;
import org.antlr.Tool;
import org.antlr.codegen.ActionTranslatorLexer;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Message;

public class TestTemplates
extends BaseTest {
    private static final String LINE_SEP = System.getProperty("line.separator");

    public void testTemplateConstructor() throws Exception {
        String string = "x = %foo(name={$ID.text});";
        String string2 = "x = templateLib.getInstanceOf(\"foo\"," + LINE_SEP + "  new STAttrMap().put(\"name\", ID1.getText()));";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        this.assertNoErrors(errorQueue);
        TestTemplates.assertEquals((String)string2, (String)string4);
    }

    public void testTemplateConstructorNoArgs() throws Exception {
        String string = "x = %foo();";
        String string2 = "x = templateLib.getInstanceOf(\"foo\");";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        this.assertNoErrors(errorQueue);
        TestTemplates.assertEquals((String)string2, (String)string4);
    }

    public void testIndirectTemplateConstructor() throws Exception {
        String string = "x = %({\"foo\"})(name={$ID.text});";
        String string2 = "x = templateLib.getInstanceOf(\"foo\"," + LINE_SEP + "  new STAttrMap().put(\"name\", ID1.getText()));";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        this.assertNoErrors(errorQueue);
        TestTemplates.assertEquals((String)string2, (String)string4);
    }

    public void testStringConstructor() throws Exception {
        String string = "x = %{$ID.text};";
        String string2 = "x = new StringTemplate(templateLib,ID1.getText());";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        this.assertNoErrors(errorQueue);
        TestTemplates.assertEquals((String)string2, (String)string4);
    }

    public void testSetAttr() throws Exception {
        String string = "%x.y = z;";
        String string2 = "(x).setAttribute(\"y\", z);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        this.assertNoErrors(errorQueue);
        TestTemplates.assertEquals((String)string2, (String)string4);
    }

    public void testSetAttrOfExpr() throws Exception {
        String string = "%{foo($ID.text).getST()}.y = z;";
        String string2 = "(foo(ID1.getText()).getST()).setAttribute(\"y\", z);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        this.assertNoErrors(errorQueue);
        TestTemplates.assertEquals((String)string2, (String)string4);
    }

    public void testCannotHaveSpaceBeforeDot() throws Exception {
        String string = "%x .y = z;";
        Object var2_2 = null;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 146;
        String string2 = "%x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testCannotHaveSpaceAfterDot() throws Exception {
        String string = "%x. y = z;";
        Object var2_2 = null;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {\n    output=template;\n}\n\na : ID {" + string + "}\n" + "  ;\n" + "\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 146;
        String string2 = "%x.";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    protected void checkError(ErrorQueue errorQueue, GrammarSemanticsMessage grammarSemanticsMessage) throws Exception {
        Message message = null;
        for (int i = 0; i < errorQueue.errors.size(); ++i) {
            Message message2 = (Message)errorQueue.errors.get(i);
            if (message2.msgID != grammarSemanticsMessage.msgID) continue;
            message = message2;
        }
        TestTemplates.assertTrue((String)("no error; " + grammarSemanticsMessage.msgID + " expected"), (errorQueue.errors.size() > 0 ? 1 : 0) != 0);
        TestTemplates.assertTrue((String)("too many errors; " + errorQueue.errors), (errorQueue.errors.size() <= 1 ? 1 : 0) != 0);
        TestTemplates.assertTrue((String)("couldn't find expected error: " + grammarSemanticsMessage.msgID), (message != null ? 1 : 0) != 0);
        TestTemplates.assertTrue((String)"error is not a GrammarSemanticsMessage", (boolean)(message instanceof GrammarSemanticsMessage));
        TestTemplates.assertEquals((Object)grammarSemanticsMessage.arg, (Object)message.arg);
        TestTemplates.assertEquals((Object)grammarSemanticsMessage.arg2, (Object)message.arg2);
    }

    private void assertNoErrors(ErrorQueue errorQueue) {
        TestTemplates.assertTrue((String)("unexpected errors: " + errorQueue), (errorQueue.errors.size() == 0 ? 1 : 0) != 0);
    }
}

