/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestSyntacticPredicateEvaluation
extends BaseTest {
    public void testTwoPredsWithNakedAlt() throws Exception {
        String string = "grammar t;\ns : (a ';')+ ;\na\noptions {\n  k=1;\n}\n  : (b '.')=> b '.' {System.out.println(\"alt 1\");}\n  | (b)=> b {System.out.println(\"alt 2\");}\n  | c       {System.out.println(\"alt 3\");}\n  ;\nb\n@init {System.out.println(\"enter b\");}\n   : '(' 'x' ')' ;\nc\n@init {System.out.println(\"enter c\");}\n   : '(' c ')' | 'x' ;\nWS : (' '|'\\n')+ {$channel=HIDDEN;}\n   ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "(x) ;", false);
        String string3 = "enter b\nenter b\nenter b\nalt 2\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
        string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "(x). ;", false);
        string3 = "enter b\nenter b\nalt 1\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
        string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "((x)) ;", false);
        string3 = "enter b\nenter b\nenter c\nenter c\nenter c\nalt 3\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
    }

    public void testTwoPredsWithNakedAltNotLast() throws Exception {
        String string = "grammar t;\ns : (a ';')+ ;\na\noptions {\n  k=1;\n}\n  : (b '.')=> b '.' {System.out.println(\"alt 1\");}\n  | c       {System.out.println(\"alt 2\");}\n  | (b)=> b {System.out.println(\"alt 3\");}\n  ;\nb\n@init {System.out.println(\"enter b\");}\n   : '(' 'x' ')' ;\nc\n@init {System.out.println(\"enter c\");}\n   : '(' c ')' | 'x' ;\nWS : (' '|'\\n')+ {$channel=HIDDEN;}\n   ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "(x) ;", false);
        String string3 = "enter b\nenter c\nenter c\nalt 2\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
        string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "(x). ;", false);
        string3 = "enter b\nenter b\nalt 1\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
        string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "((x)) ;", false);
        string3 = "enter b\nenter c\nenter c\nenter c\nalt 2\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
    }

    public void testLexerPred() throws Exception {
        String string = "grammar t;\ns : A ;\nA options {k=1;}\n  : (B '.')=>B '.' {System.out.println(\"alt1\");}\n  | B {System.out.println(\"alt2\");}  ;\nfragment\nB : 'x'+ ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "s", "xxx", false);
        TestSyntacticPredicateEvaluation.assertEquals((String)"alt2\n", (String)string2);
        string2 = this.execParser("t.g", string, "tParser", "tLexer", "s", "xxx.", false);
        TestSyntacticPredicateEvaluation.assertEquals((String)"alt1\n", (String)string2);
    }

    public void testLexerPredCyclicPrediction() throws Exception {
        String string = "grammar t;\ns : A ;\nA : (B)=>(B|'y'+) {System.out.println(\"alt1\");}\n  | B {System.out.println(\"alt2\");}\n  | 'y'+ ';'  ;\nfragment\nB : 'x'+ ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "s", "xxx", false);
        TestSyntacticPredicateEvaluation.assertEquals((String)"alt1\n", (String)string2);
    }

    public void testLexerPredCyclicPrediction2() throws Exception {
        String string = "grammar t;\ns : A ;\nA : (B '.')=>(B|'y'+) {System.out.println(\"alt1\");}\n  | B {System.out.println(\"alt2\");}\n  | 'y'+ ';'  ;\nfragment\nB : 'x'+ ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "s", "xxx", false);
        TestSyntacticPredicateEvaluation.assertEquals((String)"alt2\n", (String)string2);
    }

    public void testSimpleNestedPred() throws Exception {
        String string = "grammar t;\ns : (expr ';')+ ;\nexpr\noptions {\n  k=1;\n}\n@init {System.out.println(\"enter expr \"+input.LT(1).getText());}\n  : (atom 'x') => atom 'x'\n  | atom\n;\natom\n@init {System.out.println(\"enter atom \"+input.LT(1).getText());}\n   : '(' expr ')'\n   | INT\n   ;\nINT: '0'..'9'+ ;\nWS : (' '|'\\n')+ {$channel=HIDDEN;}\n   ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "s", "(34)x;", false);
        String string3 = "enter expr (\nenter atom (\nenter expr 34\nenter atom 34\nenter atom 34\nenter atom (\nenter expr 34\nenter atom 34\nenter atom 34\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
    }

    public void testTripleNestedPredInLexer() throws Exception {
        String string = "grammar t;\ns : (.)+ {System.out.println(\"done\");} ;\nEXPR\noptions {\n  k=1;\n}\n@init {System.out.println(\"enter expr \"+(char)input.LT(1));}\n  : (ATOM 'x') => ATOM 'x' {System.out.println(\"ATOM x\");}\n  | ATOM {System.out.println(\"ATOM \"+$ATOM.text);}\n;\nfragment ATOM\n@init {System.out.println(\"enter atom \"+(char)input.LT(1));}\n   : '(' EXPR ')'\n   | INT\n   ;\nfragment INT: '0'..'9'+ ;\nfragment WS : (' '|'\\n')+ \n   ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "s", "((34)x)x", false);
        String string3 = "enter expr (\nenter atom (\nenter expr (\nenter atom (\nenter expr 3\nenter atom 3\nenter atom 3\nenter atom (\nenter expr 3\nenter atom 3\nenter atom 3\nenter atom (\nenter expr (\nenter atom (\nenter expr 3\nenter atom 3\nenter atom 3\nenter atom (\nenter expr 3\nenter atom 3\nenter atom 3\nATOM 34\nATOM x\nATOM x\ndone\n";
        TestSyntacticPredicateEvaluation.assertEquals((String)string3, (String)string2);
    }

    public void testTreeParserWithSynPred() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT+ (PERIOD|SEMI);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nSEMI : ';' ;\nPERIOD : '.' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {k=1; backtrack=true; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID INT+ PERIOD {System.out.print(\"alt 1\");}  | ID INT+ SEMI   {System.out.print(\"alt 2\");}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 1 2 3;");
        TestSyntacticPredicateEvaluation.assertEquals((String)"alt 2\n", (String)string3);
    }

    public void testTreeParserWithNestedSynPred() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT+ (PERIOD|SEMI);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nSEMI : ';' ;\nPERIOD : '.' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {k=1; backtrack=true; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID b {System.out.print(\" a:alt 1\");}  | ID INT+ SEMI   {System.out.print(\" a:alt 2\");}\n  ;\nb : INT PERIOD  {System.out.print(\"b:alt 1\");}  | INT+ PERIOD {System.out.print(\"b:alt 2\");}  ;";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 1 2 3.");
        TestSyntacticPredicateEvaluation.assertEquals((String)"b:alt 2 a:alt 1\n", (String)string3);
    }

    public void testSynPredWithOutputTemplate() throws Exception {
        String string = "grammar t;\noptions {output=template;}\na\noptions {\n  k=1;\n}\n  : ('x'+ 'y')=> 'x'+ 'y' -> template(a={$text}) <<1:<a>;>>\n  | 'x'+ 'z' -> template(a={$text}) <<2:<a>;>>\n  ;\nWS : (' '|'\\n')+ {$channel=HIDDEN;}\n   ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "xxxy", false);
        TestSyntacticPredicateEvaluation.assertEquals((String)"1:xxxy;\n", (String)string2);
    }

    public void testSynPredWithOutputAST() throws Exception {
        String string = "grammar t;\noptions {output=AST;}\na\noptions {\n  k=1;\n}\n  : ('x'+ 'y')=> 'x'+ 'y'\n  | 'x'+ 'z'\n  ;\nWS : (' '|'\\n')+ {$channel=HIDDEN;}\n   ;\n";
        String string2 = this.execParser("t.g", string, "tParser", "tLexer", "a", "xxxy", false);
        TestSyntacticPredicateEvaluation.assertEquals((String)"x x x y\n", (String)string2);
    }
}

