/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.tnode.types.tnode;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.tnode.TNodeAbstractType;
import tom.library.adt.tnode.types.TNode;
import tom.library.adt.tnode.types.TNodeList;
import tom.library.sl.Visitable;

public final class ElementNode
extends TNode
implements Visitable {
    private int hashCode;
    private static ElementNode proto = new ElementNode();
    private String _Name;
    private TNodeList _AttrList;
    private TNodeList _ChildList;

    private ElementNode() {
    }

    public static ElementNode make(String _Name, TNodeList _AttrList, TNodeList _ChildList) {
        proto.initHashCode(_Name, _AttrList, _ChildList);
        return (ElementNode)factory.build((SharedObject)proto);
    }

    private void init(String _Name, TNodeList _AttrList, TNodeList _ChildList, int hashCode) {
        this._Name = _Name.intern();
        this._AttrList = _AttrList;
        this._ChildList = _ChildList;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _Name, TNodeList _AttrList, TNodeList _ChildList) {
        this._Name = _Name.intern();
        this._AttrList = _AttrList;
        this._ChildList = _ChildList;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "ElementNode";
    }

    private int getArity() {
        return 3;
    }

    public SharedObject duplicate() {
        ElementNode clone = new ElementNode();
        clone.init(this._Name, this._AttrList, this._ChildList, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("ElementNode(");
        buffer.append('\"');
        block11: for (int i = 0; i < this._Name.length(); ++i) {
            char c = this._Name.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block11;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block11;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block11;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block11;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block11;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block11;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block11;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._AttrList.toStringBuffer(buffer);
        buffer.append(",");
        this._ChildList.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        TNodeAbstractType ao = (TNodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        ElementNode tco = (ElementNode)ao;
        int _NameCmp = this._Name.compareTo(tco._Name);
        if (_NameCmp != 0) {
            return _NameCmp;
        }
        int _AttrListCmp = this._AttrList.compareToLPO(tco._AttrList);
        if (_AttrListCmp != 0) {
            return _AttrListCmp;
        }
        int _ChildListCmp = this._ChildList.compareToLPO(tco._ChildList);
        if (_ChildListCmp != 0) {
            return _ChildListCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        TNodeAbstractType ao = (TNodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        ElementNode tco = (ElementNode)ao;
        int _NameCmp = this._Name.compareTo(tco._Name);
        if (_NameCmp != 0) {
            return _NameCmp;
        }
        int _AttrListCmp = this._AttrList.compareTo(tco._AttrList);
        if (_AttrListCmp != 0) {
            return _AttrListCmp;
        }
        int _ChildListCmp = this._ChildList.compareTo(tco._ChildList);
        if (_ChildListCmp != 0) {
            return _ChildListCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof ElementNode) {
            ElementNode peer = (ElementNode)obj;
            return this._Name == peer._Name && this._AttrList == peer._AttrList && this._ChildList == peer._ChildList;
        }
        return false;
    }

    public boolean isElementNode() {
        return true;
    }

    public String getName() {
        return this._Name;
    }

    public TNode setName(String set_arg) {
        return ElementNode.make(set_arg, this._AttrList, this._ChildList);
    }

    public TNodeList getAttrList() {
        return this._AttrList;
    }

    public TNode setAttrList(TNodeList set_arg) {
        return ElementNode.make(this._Name, set_arg, this._ChildList);
    }

    public TNodeList getChildList() {
        return this._ChildList;
    }

    public TNode setChildList(TNodeList set_arg) {
        return ElementNode.make(this._Name, this._AttrList, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getName(), 0, true)), this.getAttrList().toATerm(), this.getChildList().toATerm()});
    }

    public static TNode fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return ElementNode.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), TNodeList.fromTerm(appl.getArgument(1)), TNodeList.fromTerm(appl.getArgument(2)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 2;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._AttrList;
            }
            case 1: {
                return this._ChildList;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return ElementNode.make(this.getName(), (TNodeList)v, this._ChildList);
            }
            case 1: {
                return ElementNode.make(this.getName(), this._AttrList, (TNodeList)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 2) {
            return ElementNode.make(this.getName(), (TNodeList)childs[0], (TNodeList)childs[1]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._AttrList, this._ChildList};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = -1925614592;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._Name, (int)2) << 16;
        a += this._AttrList.hashCode() << 8;
        a += this._ChildList.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

