/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import antlr.CommonToken;
import antlr.Token;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.ActionTranslatorLexer;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Message;
import org.antlr.tool.Rule;

public class TestAttributes
extends BaseTest {
    public void testEscapedLessThanInAction() throws Exception {
        Grammar grammar = new Grammar();
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        String string = "i<3; '<xmltag>'";
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 0);
        String string2 = string;
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<action>");
        stringTemplate.setAttribute("action", (Object)string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testEscaped$InAction() throws Exception {
        String string = "int \\$n; \"\\$in string\\$\"";
        String string2 = "int $n; \"$in string$\"";
        Grammar grammar = new Grammar("parser grammar t;\n@members {" + string + "}\n" + "a[User u, int i]\n" + "        : {" + string + "}\n" + "        ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 0);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testArguments() throws Exception {
        String string = "$i; $i.x; $u; $u.x";
        String string2 = "i; i.x; u; u.x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[User u, int i]\n        : {" + string + "}\n" + "        ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRefToReturnValueBeforeRefToPredefinedAttr() throws Exception {
        String string = "$x.foo";
        String string2 = "x.foo";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : x=b {" + string + "} ;\n" + "b returns [int foo] : B {$b.start} ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testInvalidArguments() throws Exception {
        String string;
        String string2 = string = "$x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[User u, int i]\n        : {" + string + "}\n" + "        ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 114;
        String string5 = "x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testReturnValue() throws Exception {
        String string = "$x.i";
        String string2 = "x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na returns [int i]\n        : 'a'\n        ;\nb : x=a {" + string + "} ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReturnValueWithNumber() throws Exception {
        String string = "$x.i1";
        String string2 = "x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na returns [int i1]\n        : 'a'\n        ;\nb : x=a {" + string + "} ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReturnValues() throws Exception {
        String string = "$i; $i.x; $u; $u.x";
        String string2 = "retval.i; retval.i.x; retval.u; retval.u.x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na returns [User u, int i]\n        : {" + string + "}\n" + "        ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReturnWithMultipleRuleRefs() throws Exception {
        String string = "$obj = $rule2.obj;";
        String string2 = "$obj = $rule3.obj;";
        String string3 = "obj = rule21;";
        String string4 = "obj = rule32;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nrule1 returns [ Object obj ]\n:\trule2 { " + string + " }\n" + "|\trule3 { " + string2 + " }\n" + ";\n" + "rule2 returns [ Object obj ]\n" + ":\tfoo='foo' { $obj = $foo.text; }\n" + ";\n" + "rule3 returns [ Object obj ]\n" + ":\tbar='bar' { $obj = $bar.text; }\n" + ";");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 0;
        String string5 = string;
        String string6 = string3;
        do {
            ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule1", (Token)new CommonToken(38, string5), n + 1);
            String string7 = actionTranslatorLexer.translate();
            StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
            StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string7);
            String string8 = stringTemplate.toString();
            TestAttributes.assertEquals((String)string6, (String)string8);
            string5 = string2;
            string6 = string4;
        } while (n++ < 1);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testInvalidReturnValues() throws Exception {
        String string;
        String string2 = string = "$x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na returns [User u, int i]\n        : {" + string + "}\n" + "        ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 114;
        String string5 = "x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenLabels() throws Exception {
        String string = "$id; $f; $id.text; $id.getText(); $id.dork $id.type; $id.line; $id.pos; $id.channel; $id.index;";
        String string2 = "id; f; id.getText(); id.getText(); id.dork id.getType(); id.getLine(); id.getCharPositionInLine(); id.getChannel(); id.getTokenIndex();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : id=ID f=FLOAT {" + string + "}\n" + "  ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleLabels() throws Exception {
        String string = "$r.x; $r.start; $r.stop; $r.tree; $a.x; $a.stop;";
        String string2 = "r.x; ((Token)r.start); ((Token)r.stop); ((Object)r.tree); r.x; ((Token)r.stop);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na returns [int x]\n  :\n  ;\nb : r=a {###" + string + "!!!}\n" + "  ;");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleLabelsWithSpecialToken() throws Exception {
        String string = "$r.x; $r.start; $r.stop; $r.tree; $a.x; $a.stop;";
        String string2 = "r.x; ((MYTOKEN)r.start); ((MYTOKEN)r.stop); ((Object)r.tree); r.x; ((MYTOKEN)r.stop);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\noptions {TokenLabelType=MYTOKEN;}\na returns [int x]\n  :\n  ;\nb : r=a {###" + string + "!!!}\n" + "  ;");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testForwardRefRuleLabels() throws Exception {
        String string = "$r.x; $r.start; $r.stop; $r.tree; $a.x; $a.tree;";
        String string2 = "r.x; ((Token)r.start); ((Token)r.stop); ((Object)r.tree); r.x; ((Object)r.tree);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\nb : r=a {###" + string + "!!!}\n" + "  ;\n" + "a returns [int x]\n" + "  : ;\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testInvalidRuleLabelAccessesParameter() throws Exception {
        String string;
        String string2 = string = "$r.z";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[int z] returns [int x]\n  :\n  ;\nb : r=a[3] {" + string + "}\n" + "  ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 115;
        String string5 = "a";
        String string6 = "z";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testInvalidRuleLabelAccessesScopeAttribute() throws Exception {
        String string;
        String string2 = string = "$r.n";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na\nscope { int n; }\n  :\n  ;\nb : r=a[3] {" + string + "}\n" + "  ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 112;
        String string5 = "a";
        String string6 = "n";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testInvalidRuleAttribute() throws Exception {
        String string;
        String string2 = string = "$r.blort";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[int z] returns [int x]\n  :\n  ;\nb : r=a[3] {" + string + "}\n" + "  ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 116;
        String string5 = "a";
        String string6 = "blort";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testMissingRuleAttribute() throws Exception {
        String string;
        String string2 = string = "$r";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[int z] returns [int x]\n  :\n  ;\nb : r=a[3] {" + string + "}\n" + "  ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        int n = 117;
        String string4 = "r";
        Object var11_11 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string4, var11_11);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testMissingUnlabeledRuleAttribute() throws Exception {
        String string;
        String string2 = string = "$a";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na returns [int x]:\n  ;\nb : a {" + string + "}\n" + "  ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        int n = 117;
        String string4 = "a";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string4);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testNonDynamicAttributeOutsideRule() throws Exception {
        String string;
        String string2 = string = "public void foo() { $x; }";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\n@members {'+action+'}\na : ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, null, (Token)new CommonToken(38, string), 0);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 111;
        String string5 = "x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testNonDynamicAttributeOutsideRule2() throws Exception {
        String string;
        String string2 = string = "public void foo() { $x.y; }";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\n@members {'+action+'}\na : ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, null, (Token)new CommonToken(38, string), 0);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 111;
        String string5 = "x";
        String string6 = "y";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testBasicGlobalScope() throws Exception {
        String string = "$Symbols::names.add($id.text);";
        String string2 = "((Symbols_scope)Symbols_stack.peek()).names.add(id.getText());";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  int n;\n  List names;\n}\na scope Symbols; : (id=ID ';' {" + string + "} )+\n" + "  ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testUnknownGlobalScope() throws Exception {
        String string = "$Symbols::names.add($id.text);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na scope Symbols; : (id=ID ';' {" + string + "} )+\n" + "  ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)2, (int)errorQueue.errors.size());
        int n = 140;
        String string2 = "Symbols";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testIndexedGlobalScope() throws Exception {
        String string = "$Symbols[-1]::names.add($id.text);";
        String string2 = "((Symbols_scope)Symbols_stack.elementAt(Symbols_stack.size()-1-1)).names.add(id.getText());";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  int n;\n  List names;\n}\na scope Symbols; : (id=ID ';' {" + string + "} )+\n" + "  ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void test0IndexedGlobalScope() throws Exception {
        String string = "$Symbols[0]::names.add($id.text);";
        String string2 = "((Symbols_scope)Symbols_stack.elementAt(0)).names.add(id.getText());";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  int n;\n  List names;\n}\na scope Symbols; : (id=ID ';' {" + string + "} )+\n" + "  ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testAbsoluteIndexedGlobalScope() throws Exception {
        String string = "$Symbols[3]::names.add($id.text);";
        String string2 = "((Symbols_scope)Symbols_stack.elementAt(3)).names.add(id.getText());";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  int n;\n  List names;\n}\na scope Symbols; : (id=ID ';' {" + string + "} )+\n" + "  ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testScopeAndAttributeWithUnderscore() throws Exception {
        String string = "$foo_bar::a_b;";
        String string2 = "((foo_bar_scope)foo_bar_stack.peek()).a_b;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope foo_bar {\n  int a_b;\n}\na scope foo_bar; : (ID {" + string + "} )+\n" + "  ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testSharedGlobalScope() throws Exception {
        String string = "$Symbols::x;";
        String string2 = "((Symbols_scope)Symbols_stack.peek()).x;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  String x;\n}\na\nscope { int y; }\nscope Symbols;\n : b {" + string + "}\n" + " ;\n" + "b : ID {$Symbols::x=$ID.text} ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testGlobalScopeOutsideRule() throws Exception {
        String string = "public void foo() {$Symbols::names.add('foo');}";
        String string2 = "public void foo() {((Symbols_scope)Symbols_stack.peek()).names.add('foo');}";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  int n;\n  List names;\n}\n@members {'+action+'}\na : \n  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleScopeOutsideRule() throws Exception {
        String string = "public void foo() {$a::name;}";
        String string2 = "public void foo() {((a_scope)a_stack.peek()).name;}";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\n@members {" + string + "}\n" + "a\n" + "scope { int name; }\n" + "  : {foo();}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, null, (Token)new CommonToken(38, string), 0);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testBasicRuleScope() throws Exception {
        String string = "$a::n;";
        String string2 = "((a_scope)a_stack.peek()).n;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testUnqualifiedRuleScopeAccessInsideRule() throws Exception {
        String string;
        String string2 = string = "$n;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 142;
        String string3 = "n";
        Object var9_9 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3, var9_9);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testIsolatedDynamicRuleScopeRef() throws Exception {
        String string = "$a;";
        String string2 = "a_stack;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : b ;\nb : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testDynamicRuleScopeRefInSubrule() throws Exception {
        String string = "$a::n;";
        String string2 = "((a_scope)a_stack.peek()).n;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : b ;\nb : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testIsolatedGlobalScopeRef() throws Exception {
        String string = "$Symbols;";
        String string2 = "Symbols_stack;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  String x;\n}\na\nscope { int y; }\nscope Symbols;\n : b {" + string + "}\n" + " ;\n" + "b : ID {$Symbols::x=$ID.text} ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleScopeFromAnotherRule() throws Exception {
        String string = "$a::n;";
        String string2 = "((a_scope)a_stack.peek()).n;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : b\n  ;\nb : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testFullyQualifiedRefToCurrentRuleParameter() throws Exception {
        String string = "$a.i;";
        String string2 = "i;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na[int i]: {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testFullyQualifiedRefToCurrentRuleRetVal() throws Exception {
        String string = "$a.i;";
        String string2 = "retval.i;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na returns [int i, int j]: {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testSetFullyQualifiedRefToCurrentRuleRetVal() throws Exception {
        String string = "$a.i = 1;";
        String string2 = "retval.i = 1;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na returns [int i, int j]: {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testIsolatedRefToCurrentRule() throws Exception {
        String string = "$a;";
        String string2 = "";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : 'a' {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 117;
        String string3 = "a";
        Object var9_9 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3, var9_9);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testIsolatedRefToRule() throws Exception {
        String string = "$x;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : x=b {" + string + "}\n" + "  ;\n" + "b : 'b' ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 117;
        String string2 = "x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testFullyQualifiedRefToTemplateAttributeInCurrentRule() throws Exception {
        String string = "$a.st;";
        String string2 = "retval.st;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\noptions {output=template;}\na : (A->{$A.text}) {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleRefWhenRuleHasScope() throws Exception {
        String string = "$b.start;";
        String string2 = "((Token)b1.start);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : b {###" + string + "!!!} ;\n" + "b\n" + "scope {\n" + "  int n;\n" + "} : 'b' \n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testDynamicScopeRefOkEvenThoughRuleRefExists() throws Exception {
        String string = "$b::n;";
        String string2 = "((b_scope)b_stack.peek()).n;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\ns : b ;\nb\nscope {\n  int n;\n} : '(' b ')' {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRefToTemplateAttributeForCurrentRule() throws Exception {
        String string = "$st=null;";
        String string2 = "retval.st =null;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\noptions {output=template;}\na : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRefToTextAttributeForCurrentRule() throws Exception {
        String string = "$text";
        String string2 = "input.toString(retval.start,input.LT(-1))";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\noptions {output=template;}\na : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRefToStartAttributeForCurrentRule() throws Exception {
        String string = "$start;";
        String string2 = "((Token)retval.start);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : {###" + string + "!!!}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testTokenLabelFromMultipleAlts() throws Exception {
        String string = "$ID.text;";
        String string2 = "$INT.text;";
        String string3 = "ID1.getText();";
        String string4 = "INT2.getText();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ID {" + string + "}\n" + "  | INT {" + string2 + "}\n" + "  ;\n" + "ID : 'a';\n" + "INT : '0';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string5 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string5);
        String string6 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string3, (String)string6);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string2), 2);
        string5 = actionTranslatorLexer.translate();
        stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        stringTemplate = new StringTemplate(stringTemplateGroup, string5);
        string6 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string4, (String)string6);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleLabelFromMultipleAlts() throws Exception {
        String string = "$b.text;";
        String string2 = "$c.text;";
        String string3 = "input.toString(b1.start,b1.stop);";
        String string4 = "input.toString(c2.start,c2.stop);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : b {" + string + "}\n" + "  | c {" + string2 + "}\n" + "  ;\n" + "b : 'a';\n" + "c : '0';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string5 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string5);
        String string6 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string3, (String)string6);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string2), 2);
        string5 = actionTranslatorLexer.translate();
        stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        stringTemplate = new StringTemplate(stringTemplateGroup, string5);
        string6 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string4, (String)string6);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testUnknownDynamicAttribute() throws Exception {
        String string;
        String string2 = string = "$a::x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : {" + string + "}\n" + "  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 141;
        String string5 = "a";
        String string6 = "x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownGlobalDynamicAttribute() throws Exception {
        String string;
        String string2 = string = "$Symbols::x";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope Symbols {\n  int n;\n}\na : {'+action+'}\n  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 141;
        String string5 = "Symbols";
        String string6 = "x";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnqualifiedRuleScopeAttribute() throws Exception {
        String string = "$n;";
        String string2 = "$n;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\nscope {\n  int n;\n} : b\n  ;\nb : {'+action+'}\n  ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "b", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 114;
        String string5 = "n";
        Object var14_14 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, var14_14);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleAndTokenLabelTypeMismatch() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : id='foo' id=b\n  ;\nb : ;\n");
        int n = 125;
        String string = "id";
        String string2 = "rule!=token";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testListAndTokenLabelTypeMismatch() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ids+='a' ids='b'\n  ;\nb : ;\n");
        int n = 125;
        String string = "ids";
        String string2 = "token!=token-list";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testListAndRuleLabelTypeMismatch() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {output=AST;}\na : bs+=b bs=b\n  ;\nb : 'b';\n");
        int n = 125;
        String string = "bs";
        String string2 = "rule!=rule-list";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testArgReturnValueMismatch() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na[int i] returns [int x, int i]\n  : \n  ;\nb : ;\n");
        int n = 126;
        String string = "i";
        String string2 = "a";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testSimplePlusEqualLabel() throws Exception {
        String string = "$ids.size();";
        String string2 = "list_ids.size();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : ids+=ID ( COMMA ids+=ID {" + string + "})* ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testPlusEqualStringLabel() throws Exception {
        String string = "$ids.size();";
        String string2 = "list_ids.size();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ids+='if' ( ',' ids+=ID {" + string + "})* ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testPlusEqualSetLabel() throws Exception {
        String string = "$ids.size();";
        String string2 = "list_ids.size();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ids+=('a'|'b') ( ',' ids+=ID {" + string + "})* ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testPlusEqualWildcardLabel() throws Exception {
        String string = "$ids.size();";
        String string2 = "list_ids.size();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ids+=. ( ',' ids+=ID {" + string + "})* ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testImplicitTokenLabel() throws Exception {
        String string = "$ID; $ID.text; $ID.getText()";
        String string2 = "ID1; ID1.getText(); ID1.getText()";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ID {" + string + "} ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testImplicitRuleLabel() throws Exception {
        String string = "$r.start;";
        String string2 = "((Token)r1.start);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r {###" + string + "!!!} ;" + "r : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReuseExistingLabelWithImplicitRuleLabel() throws Exception {
        String string = "$r.start;";
        String string2 = "((Token)x.start);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : x=r {###" + string + "!!!} ;" + "r : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReuseExistingListLabelWithImplicitRuleLabel() throws Exception {
        String string = "$r.start;";
        String string2 = "((Token)x.start);";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\noptions {output=AST;}\na : x+=r {###" + string + "!!!} ;" + "r : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReuseExistingLabelWithImplicitTokenLabel() throws Exception {
        String string = "$ID.text;";
        String string2 = "x.getText();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : x=ID {" + string + "} ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testReuseExistingListLabelWithImplicitTokenLabel() throws Exception {
        String string = "$ID.text;";
        String string2 = "x.getText();";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : x+=ID {" + string + "} ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRuleLabelWithoutOutputOption() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar T;\ns : x+=a ;a : 'a';\nb : 'b';\nWS : ' '|'\n';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 134;
        String string = "x";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleLabelOnTwoDifferentRulesAST() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ns : x+=a x+=b {System.out.println($x);} ;a : 'a';\nb : 'b';\nWS : (' '|'\n') {skip();};\n";
        String string2 = "[a, b]\na b\n";
        String string3 = this.execParser("T.g", string, "TParser", "TLexer", "s", "a b", false);
        TestAttributes.assertEquals((String)string2, (String)string3);
    }

    public void testRuleLabelOnTwoDifferentRulesTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\ns : x+=a x+=b {System.out.println($x);} ;a : 'a' -> {%{\"hi\"}} ;\nb : 'b' -> {%{\"mom\"}} ;\nWS : (' '|'\n') {skip();};\n";
        String string2 = "[hi, mom]\n";
        String string3 = this.execParser("T.g", string, "TParser", "TLexer", "s", "a b", false);
        TestAttributes.assertEquals((String)string2, (String)string3);
    }

    public void testMissingArgs() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r ;r[int i] : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 129;
        String string = "r";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testArgsWhenNoneDefined() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r[32,34] ;r : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 130;
        String string = "r";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testReturnInitValue() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r ;\nr returns [int x=0] : 'a' {$x = 4;} ;\n");
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        Rule rule = grammar.getRule("r");
        AttributeScope attributeScope = rule.returnScope;
        List list = attributeScope.getAttributes();
        TestAttributes.assertNotNull((String)"missing return action", (Object)list);
        TestAttributes.assertEquals((int)1, (int)list.size());
        String string = list.get(0).toString();
        String string2 = "int x=0";
        TestAttributes.assertEquals((String)string2, (String)string);
    }

    public void testMultipleReturnInitValue() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r ;\nr returns [int x=0, int y, String s=new String(\"foo\")] : 'a' {$x = 4;} ;\n");
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        Rule rule = grammar.getRule("r");
        AttributeScope attributeScope = rule.returnScope;
        List list = attributeScope.getAttributes();
        TestAttributes.assertNotNull((String)"missing return action", (Object)list);
        TestAttributes.assertEquals((int)3, (int)list.size());
        TestAttributes.assertEquals((String)"int x=0", (String)list.get(0).toString());
        TestAttributes.assertEquals((String)"int y", (String)list.get(1).toString());
        TestAttributes.assertEquals((String)"String s=new String(\"foo\")", (String)list.get(2).toString());
    }

    public void testCStyleReturnInitValue() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r ;\nr returns [int (*x)()=NULL] : 'a' ;\n");
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        Rule rule = grammar.getRule("r");
        AttributeScope attributeScope = rule.returnScope;
        List list = attributeScope.getAttributes();
        TestAttributes.assertNotNull((String)"missing return action", (Object)list);
        TestAttributes.assertEquals((int)1, (int)list.size());
        String string = list.get(0).toString();
        String string2 = "int (*)() x=NULL";
        TestAttributes.assertEquals((String)string2, (String)string);
    }

    public void testArgsWithInitValues() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : r[32,34] ;r[int x, int y=3] : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 148;
        String string = "y";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testArgsOnToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ID[32,34] ;ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 131;
        String string = "ID";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testArgsOnTokenInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : 'z' ID[32,34] ;ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 130;
        String string = "ID";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testLabelOnRuleRefInLexer() throws Exception {
        String string = "$i.text";
        String string2 = "i.getText()";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : 'z' i=ID {" + string + "};" + "fragment ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "R", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRefToRuleRefInLexer() throws Exception {
        String string = "$ID.text";
        String string2 = "ID1.getText()";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : 'z' ID {" + string + "};" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "R", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRefToRuleRefInLexerNoAttribute() throws Exception {
        String string = "$ID";
        String string2 = "ID1";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : 'z' ID {" + string + "};" + "ID : 'a';\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "R", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testCharLabelInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : x='z' ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testCharListLabelInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : x+='z' ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testWildcardCharLabelInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : x=. ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testWildcardCharListLabelInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : x+=. ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testMissingArgsInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nA : R ;R[int i] : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 129;
        String string = "R";
        Object var7_7 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var7_7);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testLexerRulePropertyRefs() throws Exception {
        String string = "$text $type $line $pos $channel $index $start $stop";
        String string2 = "getText() _type _line _charPosition _channel -1 _start (getCharIndex()-1)";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : 'r' {" + string + "};\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "R", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testLexerLabelRefs() throws Exception {
        String string = "$a $b.text $c $d.text";
        String string2 = "a b.getText() c d.getText()";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : a='c' b='hi' c=. d=DUH {" + string + "};\n" + "DUH : 'd' ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "R", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testSettingLexerRulePropertyRefs() throws Exception {
        String string = "$text $type=1 $line=1 $pos=1 $channel=1 $index";
        String string2 = "getText() _type=1 _line=1 _charPosition=1 _channel=1 -1";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nR : 'r' {" + string + "};\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "R", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testArgsOnTokenInLexerRuleOfCombined() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : R;\nR : 'z' ID[32] ;\nID : 'a';\n");
        String string = grammar.getLexerGrammar();
        StringReader stringReader = new StringReader(string);
        Grammar grammar2 = new Grammar();
        grammar2.setFileName("<internally-generated-lexer>");
        grammar2.importTokenVocabulary(grammar);
        grammar2.setGrammarContent(stringReader);
        stringReader.close();
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar2, "Java");
        grammar2.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 130;
        String string2 = "ID";
        Object var10_10 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar2, null, string2, var10_10);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testMissingArgsOnTokenInLexerRuleOfCombined() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : R;\nR : 'z' ID ;\nID[int i] : 'a';\n");
        String string = grammar.getLexerGrammar();
        StringReader stringReader = new StringReader(string);
        Grammar grammar2 = new Grammar();
        grammar2.setFileName("<internally-generated-lexer>");
        grammar2.importTokenVocabulary(grammar);
        grammar2.setGrammarContent(stringReader);
        stringReader.close();
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar2, "Java");
        grammar2.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 129;
        String string2 = "ID";
        Object var10_10 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar2, null, string2, var10_10);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenLabelTreeProperty() throws Exception {
        String string = "$id.tree;";
        String string2 = "id_tree;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : id=ID {" + string + "} ;\n" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testTokenRefTreeProperty() throws Exception {
        String string = "$ID.tree;";
        String string2 = "ID1_tree;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ID {" + string + "} ;" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "a", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testAmbiguousTokenRef() throws Exception {
        String string = "$ID;";
        String string2 = "";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ID ID {" + string + "};" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 127;
        String string3 = "ID";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testAmbiguousTokenRefWithProp() throws Exception {
        String string = "$ID.text;";
        String string2 = "";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ID ID {" + string + "};" + "ID : 'a';\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 127;
        String string3 = "ID";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleRefWithDynamicScope() throws Exception {
        String string = "$field::x = $field.st;";
        String string2 = "((field_scope)field_stack.peek()).x = retval.st;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nfield\nscope { StringTemplate x; }\n    :   'y' {" + string + "}\n" + "    ;\n");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "field", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testAssignToOwnRulenameAttr() throws Exception {
        String string = "$rule.tree = null;";
        String string2 = "retval.tree = null;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nrule\n    : 'y' {" + string + "}\n" + "    ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testAssignToOwnParamAttr() throws Exception {
        String string = "$rule.i = 42; $i = 23;";
        String string2 = "i = 42; i = 23;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nrule[int i]\n    : 'y' {" + string + "}\n" + "    ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testIllegalAssignToOwnRulenameAttr() throws Exception {
        String string = "$rule.stop = 0;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nrule\n    : 'y' {" + string + "}\n" + "    ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string2 = actionTranslatorLexer.translate();
        int n = 151;
        String string3 = "rule";
        String string4 = "stop";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3, string4);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testIllegalAssignToLocalAttr() throws Exception {
        String string = "$tree = null; $st = null; $start = 0; $stop = 0; $text = 0;";
        String string2 = "retval.tree = null; retval.st = null;   ";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nrule\n    : 'y' {" + string + "}\n" + "    ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        int n = 151;
        ArrayList<GrammarSemanticsMessage> arrayList = new ArrayList<GrammarSemanticsMessage>(3);
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, "start", "");
        arrayList.add(grammarSemanticsMessage);
        GrammarSemanticsMessage grammarSemanticsMessage2 = new GrammarSemanticsMessage(n, grammar, null, "stop", "");
        arrayList.add(grammarSemanticsMessage2);
        GrammarSemanticsMessage grammarSemanticsMessage3 = new GrammarSemanticsMessage(n, grammar, null, "text", "");
        arrayList.add(grammarSemanticsMessage3);
        this.checkErrors(errorQueue, arrayList);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testIllegalAssignRuleRefAttr() throws Exception {
        String string = "$other.tree = null;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\noptions { output = AST;}otherrule\n    : 'y' ;rule\n    : other=otherrule {" + string + "}\n" + "    ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string2 = actionTranslatorLexer.translate();
        int n = 151;
        String string3 = "other";
        String string4 = "tree";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3, string4);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testIllegalAssignTokenRefAttr() throws Exception {
        String string = "$ID.text = \"test\";";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nID\n    : 'y' ;rule\n    : ID {" + string + "}\n" + "    ;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string2 = actionTranslatorLexer.translate();
        int n = 151;
        String string3 = "ID";
        String string4 = "text";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3, string4);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testAssignToTreeNodeAttribute() throws Exception {
        String string = "$tree.scope = localScope;";
        String string2 = "(()retval.tree).scope = localScope;";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\noptions { output=AST; }rule\n@init {\n   Scope localScope=null;\n}\n@finally {\n   $tree.scope = localScope;\n}\n   : 'a' -> ^('a')\n;");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "rule", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testDoNotTranslateAttributeCompare() throws Exception {
        String string = "$a.line == $b.line";
        String string2 = "a.getLine() == b.getLine()";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar a;\nRULE:\n     a=ID b=ID {" + string + "}" + "    ;\n" + "ID : 'id';");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "RULE", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, string3);
        String string4 = stringTemplate.toString();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testDoNotTranslateScopeAttributeCompare() throws Exception {
        Object object;
        String string = "if ($rule::foo == \"foo\" || 1) { System.out.println(\"ouch\"); }";
        String string2 = "if (((rule_scope)rule_stack.peek()).foo == \"foo\" || 1) { System.out.println(\"ouch\"); }";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar a;\nrule\nscope {\n   String foo;} :\n     twoIDs    ;\ntwoIDs:\n    ID ID {" + string + "}\n" + "    ;\n" + "ID : 'id';");
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        ActionTranslatorLexer actionTranslatorLexer = new ActionTranslatorLexer(codeGenerator, "twoIDs", (Token)new CommonToken(38, string), 1);
        String string3 = actionTranslatorLexer.translate();
        boolean bl = false;
        for (int i = 0; i < actionTranslatorLexer.chunks.size(); ++i) {
            object = actionTranslatorLexer.chunks.get(i);
            if (!(object instanceof StringTemplate) || !((StringTemplate)object).getName().equals("scopeSetAttributeRef")) continue;
            bl = true;
        }
        TestAttributes.assertFalse((String)"action translator used scopeSetAttributeRef template in comparison!", (boolean)bl);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(".", AngleBracketTemplateLexer.class);
        object = new StringTemplate(stringTemplateGroup, string3);
        String string4 = object.toString();
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        TestAttributes.assertEquals((String)string2, (String)string4);
    }

    public void testTreeRuleStopAttributeIsInvalid() throws Exception {
        String string = "$r.x; $r.start; $r.stop";
        String string2 = "r.x; ((CommonTree)r.start); $r.stop";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("tree grammar t;\noptions {ASTLabelType=CommonTree;}\na returns [int x]\n  :\n  ;\nb : r=a {###" + string + "!!!}\n" + "  ;");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        int n = 116;
        String string5 = "a";
        String string6 = "stop";
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string5, string6);
        System.out.println("equeue:" + errorQueue);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testRefToTextAttributeForCurrentTreeRule() throws Exception {
        String string = "$text";
        String string2 = "input.getTokenStream().toString(\n              input.getTreeAdaptor().getTokenStartIndex(retval.start),\n              input.getTreeAdaptor().getTokenStopIndex(retval.start))";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("tree grammar t;\noptions {ASTLabelType=CommonTree;}\na : {###" + string + "!!!}\n" + "  ;\n");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        StringTemplate stringTemplate = codeGenerator.getRecognizerST();
        String string3 = stringTemplate.toString();
        String string4 = string3.substring(string3.indexOf("###") + 3, string3.indexOf("!!!"));
        TestAttributes.assertEquals((String)string2, (String)string4);
        TestAttributes.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    protected void checkError(ErrorQueue errorQueue, GrammarSemanticsMessage grammarSemanticsMessage) throws Exception {
        Message message = null;
        for (int i = 0; i < errorQueue.errors.size(); ++i) {
            Message message2 = (Message)errorQueue.errors.get(i);
            if (message2.msgID != grammarSemanticsMessage.msgID) continue;
            message = message2;
        }
        TestAttributes.assertTrue((String)("no error; " + grammarSemanticsMessage.msgID + " expected"), (errorQueue.errors.size() > 0 ? 1 : 0) != 0);
        TestAttributes.assertNotNull((String)("couldn't find expected error: " + grammarSemanticsMessage.msgID), (Object)message);
        TestAttributes.assertTrue((String)"error is not a GrammarSemanticsMessage", (boolean)(message instanceof GrammarSemanticsMessage));
        TestAttributes.assertEquals((Object)grammarSemanticsMessage.arg, (Object)message.arg);
        TestAttributes.assertEquals((Object)grammarSemanticsMessage.arg2, (Object)message.arg2);
    }

    protected void checkErrors(ErrorQueue errorQueue, ArrayList arrayList) throws Exception {
        int n;
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>(errorQueue.errors.size());
        for (n = 0; n < errorQueue.errors.size(); ++n) {
            Message message = (Message)errorQueue.errors.get(n);
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                Message message2 = (Message)arrayList.get(i);
                if (message.msgID != message2.msgID || !message.arg.equals(message2.arg) || !message.arg2.equals(message2.arg2)) continue;
                bl = true;
            }
            if (bl) {
                arrayList2.add(n, Boolean.TRUE);
                continue;
            }
            arrayList2.add(n, Boolean.FALSE);
        }
        for (n = 0; n < errorQueue.errors.size(); ++n) {
            TestAttributes.assertTrue((String)("unexpected error:" + errorQueue.errors.get(n)), (boolean)((Boolean)arrayList2.get(n)));
        }
    }
}

