/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate();

    public abstract SemanticContext getGatedPredicateContext();

    public abstract StringTemplate genExpr(CodeGenerator var1, StringTemplateGroup var2, DFA var3);

    public abstract boolean isSyntacticPredicate();

    public void trackUseOfSyntacticPredicates(Grammar grammar) {
    }

    public static SemanticContext and(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == EMPTY_SEMANTIC_CONTEXT || semanticContext == null) {
            return semanticContext2;
        }
        if (semanticContext2 == EMPTY_SEMANTIC_CONTEXT || semanticContext2 == null) {
            return semanticContext;
        }
        if (semanticContext.equals(semanticContext2)) {
            return semanticContext;
        }
        return new AND(semanticContext, semanticContext2);
    }

    public static SemanticContext or(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == EMPTY_SEMANTIC_CONTEXT || semanticContext == null) {
            return semanticContext2;
        }
        if (semanticContext2 == EMPTY_SEMANTIC_CONTEXT || semanticContext2 == null) {
            return semanticContext;
        }
        if (semanticContext instanceof TruePredicate) {
            return semanticContext;
        }
        if (semanticContext2 instanceof TruePredicate) {
            return semanticContext2;
        }
        if (semanticContext instanceof NOT && semanticContext2 instanceof Predicate) {
            NOT nOT = (NOT)semanticContext;
            if (nOT.ctx.equals(semanticContext2)) {
                return new TruePredicate();
            }
        } else if (semanticContext2 instanceof NOT && semanticContext instanceof Predicate) {
            NOT nOT = (NOT)semanticContext2;
            if (nOT.ctx.equals(semanticContext)) {
                return new TruePredicate();
            }
        } else if (semanticContext.equals(semanticContext2)) {
            return semanticContext;
        }
        return new OR(semanticContext, semanticContext2);
    }

    public static SemanticContext not(SemanticContext semanticContext) {
        return new NOT(semanticContext);
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public NOT(SemanticContext semanticContext) {
            this.ctx = semanticContext;
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            StringTemplate stringTemplate = null;
            stringTemplate = stringTemplateGroup != null ? stringTemplateGroup.getInstanceOf("notPredicate") : new StringTemplate("?!($pred$)");
            stringTemplate.setAttribute("pred", (Object)this.ctx.genExpr(codeGenerator, stringTemplateGroup, dFA));
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext semanticContext = this.ctx.getGatedPredicateContext();
            if (semanticContext == null) {
                return null;
            }
            return new NOT(semanticContext);
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar grammar) {
            this.ctx.trackUseOfSyntacticPredicates(grammar);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NOT)) {
                return false;
            }
            return this.ctx.equals(((NOT)object).ctx);
        }

        public String toString() {
            return "!(" + this.ctx + ")";
        }
    }

    public static class OR
    extends SemanticContext {
        protected Set operands = new HashSet();

        public OR(SemanticContext semanticContext, SemanticContext semanticContext2) {
            if (semanticContext instanceof OR) {
                this.operands.addAll(((OR)semanticContext).operands);
            } else if (semanticContext != null) {
                this.operands.add(semanticContext);
            }
            if (semanticContext2 instanceof OR) {
                this.operands.addAll(((OR)semanticContext2).operands);
            } else if (semanticContext2 != null) {
                this.operands.add(semanticContext2);
            }
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            StringTemplate stringTemplate = null;
            stringTemplate = stringTemplateGroup != null ? stringTemplateGroup.getInstanceOf("orPredicates") : new StringTemplate("($first(operands)$$rest(operands):{o | ||$o$}$)");
            for (SemanticContext semanticContext : this.operands) {
                stringTemplate.setAttribute("operands", (Object)semanticContext.genExpr(codeGenerator, stringTemplateGroup, dFA));
            }
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext semanticContext = null;
            for (SemanticContext semanticContext2 : this.operands) {
                SemanticContext semanticContext3 = semanticContext2.getGatedPredicateContext();
                if (semanticContext3 == null) continue;
                semanticContext = OR.or(semanticContext, semanticContext3);
            }
            return semanticContext;
        }

        public boolean isSyntacticPredicate() {
            for (SemanticContext semanticContext : this.operands) {
                if (!semanticContext.isSyntacticPredicate()) continue;
                return true;
            }
            return false;
        }

        public void trackUseOfSyntacticPredicates(Grammar grammar) {
            for (SemanticContext semanticContext : this.operands) {
                semanticContext.trackUseOfSyntacticPredicates(grammar);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            int n = 0;
            for (SemanticContext semanticContext : this.operands) {
                if (n > 0) {
                    stringBuffer.append("||");
                }
                stringBuffer.append(semanticContext.toString());
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class AND
    extends SemanticContext {
        protected SemanticContext left;
        protected SemanticContext right;

        public AND(SemanticContext semanticContext, SemanticContext semanticContext2) {
            this.left = semanticContext;
            this.right = semanticContext2;
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            StringTemplate stringTemplate = null;
            stringTemplate = stringTemplateGroup != null ? stringTemplateGroup.getInstanceOf("andPredicates") : new StringTemplate("($left$&&$right$)");
            stringTemplate.setAttribute("left", (Object)this.left.genExpr(codeGenerator, stringTemplateGroup, dFA));
            stringTemplate.setAttribute("right", (Object)this.right.genExpr(codeGenerator, stringTemplateGroup, dFA));
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext semanticContext = this.left.getGatedPredicateContext();
            SemanticContext semanticContext2 = this.right.getGatedPredicateContext();
            if (semanticContext == null) {
                return semanticContext2;
            }
            if (semanticContext2 == null) {
                return semanticContext;
            }
            return new AND(semanticContext, semanticContext2);
        }

        public boolean isSyntacticPredicate() {
            return this.left.isSyntacticPredicate() || this.right.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar grammar) {
            this.left.trackUseOfSyntacticPredicates(grammar);
            this.right.trackUseOfSyntacticPredicates(grammar);
        }

        public String toString() {
            return "(" + this.left + "&&" + this.right + ")";
        }
    }

    public static class TruePredicate
    extends Predicate {
        public TruePredicate() {
            this.constantValue = 1;
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            if (stringTemplateGroup != null) {
                return stringTemplateGroup.getInstanceOf("true");
            }
            return new StringTemplate("true");
        }

        public String toString() {
            return "true";
        }
    }

    public static class Predicate
    extends SemanticContext {
        protected GrammarAST predicate;
        protected boolean gated = false;
        protected boolean synpred = false;
        public static final int INVALID_PRED_VALUE = -1;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = 1;
        protected int constantValue = -1;

        public Predicate() {
            this.predicate = new GrammarAST();
            this.gated = false;
        }

        public Predicate(GrammarAST grammarAST) {
            this.predicate = grammarAST;
            this.gated = grammarAST.getType() == 35;
            this.synpred = grammarAST.getType() == 36;
        }

        public Predicate(Predicate predicate) {
            this.predicate = predicate.predicate;
            this.gated = predicate.gated;
            this.synpred = predicate.synpred;
            this.constantValue = predicate.constantValue;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Predicate)) {
                return false;
            }
            return this.predicate.getText().equals(((Predicate)object).predicate.getText());
        }

        public int hashCode() {
            if (this.predicate == null) {
                return 0;
            }
            return this.predicate.getText().hashCode();
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            String string;
            StringTemplate stringTemplate = null;
            if (stringTemplateGroup != null) {
                if (this.synpred) {
                    stringTemplate = stringTemplateGroup.getInstanceOf("evalSynPredicate");
                } else {
                    stringTemplate = stringTemplateGroup.getInstanceOf("evalPredicate");
                    codeGenerator.grammar.decisionsWhoseDFAsUsesSemPreds.add(dFA);
                }
                string = this.predicate.getEnclosingRule();
                if (codeGenerator != null) {
                    stringTemplate.setAttribute("pred", (Object)codeGenerator.translateAction(string, this.predicate));
                }
            } else {
                stringTemplate = new StringTemplate("$pred$");
                stringTemplate.setAttribute("pred", (Object)this.toString());
                return stringTemplate;
            }
            if (codeGenerator != null) {
                string = codeGenerator.target.getTargetStringLiteralFromString(this.toString());
                stringTemplate.setAttribute("description", (Object)string);
            }
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean isSyntacticPredicate() {
            return this.predicate != null && this.predicate.getType() == 36;
        }

        public void trackUseOfSyntacticPredicates(Grammar grammar) {
            if (this.synpred) {
                grammar.synPredNamesUsedInDFA.add(this.predicate.getText());
            }
        }

        public String toString() {
            if (this.predicate == null) {
                return "<nopred>";
            }
            return this.predicate.getText();
        }
    }
}

