/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tmethodlist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TMethod;
import tom.library.adt.bytecode.types.TMethodList;
import tom.library.adt.bytecode.types.tmethodlist.ConsMethodList;
import tom.library.adt.bytecode.types.tmethodlist.EmptyMethodList;

public abstract class MethodList
extends TMethodList {
    public int length() {
        if (this instanceof ConsMethodList) {
            TMethodList tl = ((ConsMethodList)this).getTailMethodList();
            if (tl instanceof MethodList) {
                return 1 + ((MethodList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TMethod[] toArray() {
        TMethod[] array;
        if (this instanceof ConsMethodList) {
            TMethod h = ((ConsMethodList)this).getHeadMethodList();
            TMethodList tl = ((ConsMethodList)this).getTailMethodList();
            if (tl instanceof MethodList) {
                TMethod[] tailArray = ((MethodList)tl).toArray();
                array = new TMethod[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TMethod[]{h};
            }
        } else {
            array = new TMethod[]{};
        }
        return array;
    }

    public static TMethodList fromArray(TMethod[] array) {
        MethodList res = EmptyMethodList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsMethodList.make(array[--i], res);
        }
        return res;
    }

    public TMethodList reverse() {
        if (this instanceof ConsMethodList) {
            TMethodList cur = this;
            MethodList rev = EmptyMethodList.make();
            while (cur instanceof ConsMethodList) {
                rev = ConsMethodList.make(((ConsMethodList)cur).getHeadMethodList(), rev);
                cur = ((ConsMethodList)cur).getTailMethodList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("MethodList(");
        if (this instanceof ConsMethodList) {
            TMethodList cur = this;
            while (cur instanceof ConsMethodList) {
                TMethod elem = ((ConsMethodList)cur).getHeadMethodList();
                cur = ((ConsMethodList)cur).getTailMethodList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsMethodList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyMethodList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TMethodList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "MethodList".equals((appl = (ATermAppl)trm).getName())) {
            MethodList res = EmptyMethodList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TMethod elem = TMethod.fromTerm(array[i]);
                res = ConsMethodList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

