/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tmethodinfo;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TAccessList;
import tom.library.adt.bytecode.types.TMethodDescriptor;
import tom.library.adt.bytecode.types.TMethodInfo;
import tom.library.adt.bytecode.types.TSignature;
import tom.library.adt.bytecode.types.TStringList;
import tom.library.sl.Visitable;

public final class MethodInfo
extends TMethodInfo
implements Visitable {
    private int hashCode;
    private static MethodInfo proto = new MethodInfo();
    private String _owner;
    private TAccessList _access;
    private String _name;
    private TMethodDescriptor _desc;
    private TSignature _signature;
    private TStringList _exceptions;

    private MethodInfo() {
    }

    public static MethodInfo make(String _owner, TAccessList _access, String _name, TMethodDescriptor _desc, TSignature _signature, TStringList _exceptions) {
        proto.initHashCode(_owner, _access, _name, _desc, _signature, _exceptions);
        return (MethodInfo)factory.build((SharedObject)proto);
    }

    private void init(String _owner, TAccessList _access, String _name, TMethodDescriptor _desc, TSignature _signature, TStringList _exceptions, int hashCode) {
        this._owner = _owner.intern();
        this._access = _access;
        this._name = _name.intern();
        this._desc = _desc;
        this._signature = _signature;
        this._exceptions = _exceptions;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _owner, TAccessList _access, String _name, TMethodDescriptor _desc, TSignature _signature, TStringList _exceptions) {
        this._owner = _owner.intern();
        this._access = _access;
        this._name = _name.intern();
        this._desc = _desc;
        this._signature = _signature;
        this._exceptions = _exceptions;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "MethodInfo";
    }

    private int getArity() {
        return 6;
    }

    public SharedObject duplicate() {
        MethodInfo clone = new MethodInfo();
        clone.init(this._owner, this._access, this._name, this._desc, this._signature, this._exceptions, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        char c;
        int i;
        buffer.append("MethodInfo(");
        buffer.append('\"');
        block22: for (i = 0; i < this._owner.length(); ++i) {
            c = this._owner.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block22;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block22;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block22;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block22;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block22;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block22;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block22;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block22;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block22;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block22;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._access.toStringBuffer(buffer);
        buffer.append(",");
        buffer.append('\"');
        block23: for (i = 0; i < this._name.length(); ++i) {
            c = this._name.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block23;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block23;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block23;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block23;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block23;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block23;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block23;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block23;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block23;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block23;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._desc.toStringBuffer(buffer);
        buffer.append(",");
        this._signature.toStringBuffer(buffer);
        buffer.append(",");
        this._exceptions.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        MethodInfo tco = (MethodInfo)ao;
        int _ownerCmp = this._owner.compareTo(tco._owner);
        if (_ownerCmp != 0) {
            return _ownerCmp;
        }
        int _accessCmp = this._access.compareToLPO(tco._access);
        if (_accessCmp != 0) {
            return _accessCmp;
        }
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _descCmp = this._desc.compareToLPO(tco._desc);
        if (_descCmp != 0) {
            return _descCmp;
        }
        int _signatureCmp = this._signature.compareToLPO(tco._signature);
        if (_signatureCmp != 0) {
            return _signatureCmp;
        }
        int _exceptionsCmp = this._exceptions.compareToLPO(tco._exceptions);
        if (_exceptionsCmp != 0) {
            return _exceptionsCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        MethodInfo tco = (MethodInfo)ao;
        int _ownerCmp = this._owner.compareTo(tco._owner);
        if (_ownerCmp != 0) {
            return _ownerCmp;
        }
        int _accessCmp = this._access.compareTo(tco._access);
        if (_accessCmp != 0) {
            return _accessCmp;
        }
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _descCmp = this._desc.compareTo(tco._desc);
        if (_descCmp != 0) {
            return _descCmp;
        }
        int _signatureCmp = this._signature.compareTo(tco._signature);
        if (_signatureCmp != 0) {
            return _signatureCmp;
        }
        int _exceptionsCmp = this._exceptions.compareTo(tco._exceptions);
        if (_exceptionsCmp != 0) {
            return _exceptionsCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof MethodInfo) {
            MethodInfo peer = (MethodInfo)obj;
            return this._owner == peer._owner && this._access == peer._access && this._name == peer._name && this._desc == peer._desc && this._signature == peer._signature && this._exceptions == peer._exceptions;
        }
        return false;
    }

    public boolean isMethodInfo() {
        return true;
    }

    public String getowner() {
        return this._owner;
    }

    public TMethodInfo setowner(String set_arg) {
        return MethodInfo.make(set_arg, this._access, this._name, this._desc, this._signature, this._exceptions);
    }

    public TAccessList getaccess() {
        return this._access;
    }

    public TMethodInfo setaccess(TAccessList set_arg) {
        return MethodInfo.make(this._owner, set_arg, this._name, this._desc, this._signature, this._exceptions);
    }

    public String getname() {
        return this._name;
    }

    public TMethodInfo setname(String set_arg) {
        return MethodInfo.make(this._owner, this._access, set_arg, this._desc, this._signature, this._exceptions);
    }

    public TMethodDescriptor getdesc() {
        return this._desc;
    }

    public TMethodInfo setdesc(TMethodDescriptor set_arg) {
        return MethodInfo.make(this._owner, this._access, this._name, set_arg, this._signature, this._exceptions);
    }

    public TSignature getsignature() {
        return this._signature;
    }

    public TMethodInfo setsignature(TSignature set_arg) {
        return MethodInfo.make(this._owner, this._access, this._name, this._desc, set_arg, this._exceptions);
    }

    public TStringList getexceptions() {
        return this._exceptions;
    }

    public TMethodInfo setexceptions(TStringList set_arg) {
        return MethodInfo.make(this._owner, this._access, this._name, this._desc, this._signature, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getowner(), 0, true)), this.getaccess().toATerm(), atermFactory.makeAppl(atermFactory.makeAFun(this.getname(), 0, true)), this.getdesc().toATerm(), this.getsignature().toATerm(), this.getexceptions().toATerm()});
    }

    public static TMethodInfo fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return MethodInfo.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), TAccessList.fromTerm(appl.getArgument(1)), ((ATermAppl)appl.getArgument(2)).getAFun().getName(), TMethodDescriptor.fromTerm(appl.getArgument(3)), TSignature.fromTerm(appl.getArgument(4)), TStringList.fromTerm(appl.getArgument(5)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 4;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._access;
            }
            case 1: {
                return this._desc;
            }
            case 2: {
                return this._signature;
            }
            case 3: {
                return this._exceptions;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return MethodInfo.make(this.getowner(), (TAccessList)v, this.getname(), this._desc, this._signature, this._exceptions);
            }
            case 1: {
                return MethodInfo.make(this.getowner(), this._access, this.getname(), (TMethodDescriptor)v, this._signature, this._exceptions);
            }
            case 2: {
                return MethodInfo.make(this.getowner(), this._access, this.getname(), this._desc, (TSignature)v, this._exceptions);
            }
            case 3: {
                return MethodInfo.make(this.getowner(), this._access, this.getname(), this._desc, this._signature, (TStringList)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 4) {
            return MethodInfo.make(this.getowner(), (TAccessList)childs[0], this.getname(), (TMethodDescriptor)childs[1], (TSignature)childs[2], (TStringList)childs[3]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._access, this._desc, this._signature, this._exceptions};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 1969807616;
        int c = this.getArity();
        b += HashFunctions.stringHashFunction((String)this._owner, (int)5) << 8;
        a += HashFunctions.stringHashFunction((String)this._name, (int)3) << 24;
        a += this._desc.hashCode() << 16;
        a += this._signature.hashCode() << 8;
        a += this._exceptions.hashCode();
        a -= (b += this._access.hashCode());
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

