/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tlabellist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TLabel;
import tom.library.adt.bytecode.types.TLabelList;
import tom.library.adt.bytecode.types.tlabellist.ConsLabelList;
import tom.library.adt.bytecode.types.tlabellist.EmptyLabelList;

public abstract class LabelList
extends TLabelList {
    public int length() {
        if (this instanceof ConsLabelList) {
            TLabelList tl = ((ConsLabelList)this).getTailLabelList();
            if (tl instanceof LabelList) {
                return 1 + ((LabelList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TLabel[] toArray() {
        TLabel[] array;
        if (this instanceof ConsLabelList) {
            TLabel h = ((ConsLabelList)this).getHeadLabelList();
            TLabelList tl = ((ConsLabelList)this).getTailLabelList();
            if (tl instanceof LabelList) {
                TLabel[] tailArray = ((LabelList)tl).toArray();
                array = new TLabel[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TLabel[]{h};
            }
        } else {
            array = new TLabel[]{};
        }
        return array;
    }

    public static TLabelList fromArray(TLabel[] array) {
        LabelList res = EmptyLabelList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsLabelList.make(array[--i], res);
        }
        return res;
    }

    public TLabelList reverse() {
        if (this instanceof ConsLabelList) {
            TLabelList cur = this;
            LabelList rev = EmptyLabelList.make();
            while (cur instanceof ConsLabelList) {
                rev = ConsLabelList.make(((ConsLabelList)cur).getHeadLabelList(), rev);
                cur = ((ConsLabelList)cur).getTailLabelList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("LabelList(");
        if (this instanceof ConsLabelList) {
            TLabelList cur = this;
            while (cur instanceof ConsLabelList) {
                TLabel elem = ((ConsLabelList)cur).getHeadLabelList();
                cur = ((ConsLabelList)cur).getTailLabelList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsLabelList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyLabelList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TLabelList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "LabelList".equals((appl = (ATermAppl)trm).getName())) {
            LabelList res = EmptyLabelList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TLabel elem = TLabel.fromTerm(array[i]);
                res = ConsLabelList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

