/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tintlist;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import tom.library.adt.bytecode.types.TintList;
import tom.library.adt.bytecode.types.tintlist.ConsintList;
import tom.library.adt.bytecode.types.tintlist.EmptyintList;

public abstract class intList
extends TintList {
    public int length() {
        if (this instanceof ConsintList) {
            TintList tl = ((ConsintList)this).getTailintList();
            if (tl instanceof intList) {
                return 1 + ((intList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public int[] toArray() {
        int[] array;
        if (this instanceof ConsintList) {
            int h = ((ConsintList)this).getHeadintList();
            TintList tl = ((ConsintList)this).getTailintList();
            if (tl instanceof intList) {
                int[] tailArray = ((intList)tl).toArray();
                array = new int[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new int[]{h};
            }
        } else {
            array = new int[]{};
        }
        return array;
    }

    public static TintList fromArray(int[] array) {
        intList res = EmptyintList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsintList.make(array[--i], res);
        }
        return res;
    }

    public TintList reverse() {
        if (this instanceof ConsintList) {
            TintList cur = this;
            intList rev = EmptyintList.make();
            while (cur instanceof ConsintList) {
                rev = ConsintList.make(((ConsintList)cur).getHeadintList(), rev);
                cur = ((ConsintList)cur).getTailintList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("intList(");
        if (this instanceof ConsintList) {
            TintList cur = this;
            while (cur instanceof ConsintList) {
                int elem = ((ConsintList)cur).getHeadintList();
                cur = ((ConsintList)cur).getTailintList();
                buffer.append(elem);
                if (!(cur instanceof ConsintList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyintList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TintList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "intList".equals((appl = (ATermAppl)trm).getName())) {
            intList res = EmptyintList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                int elem = ((ATermInt)array[i]).getInt();
                res = ConsintList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

