/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tinstructionlist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TInstruction;
import tom.library.adt.bytecode.types.TInstructionList;
import tom.library.adt.bytecode.types.tinstructionlist.ConsInstructionList;
import tom.library.adt.bytecode.types.tinstructionlist.EmptyInstructionList;

public abstract class InstructionList
extends TInstructionList {
    public int length() {
        if (this instanceof ConsInstructionList) {
            TInstructionList tl = ((ConsInstructionList)this).getTailInstructionList();
            if (tl instanceof InstructionList) {
                return 1 + ((InstructionList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TInstruction[] toArray() {
        TInstruction[] array;
        if (this instanceof ConsInstructionList) {
            TInstruction h = ((ConsInstructionList)this).getHeadInstructionList();
            TInstructionList tl = ((ConsInstructionList)this).getTailInstructionList();
            if (tl instanceof InstructionList) {
                TInstruction[] tailArray = ((InstructionList)tl).toArray();
                array = new TInstruction[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TInstruction[]{h};
            }
        } else {
            array = new TInstruction[]{};
        }
        return array;
    }

    public static TInstructionList fromArray(TInstruction[] array) {
        InstructionList res = EmptyInstructionList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsInstructionList.make(array[--i], res);
        }
        return res;
    }

    public TInstructionList reverse() {
        if (this instanceof ConsInstructionList) {
            TInstructionList cur = this;
            InstructionList rev = EmptyInstructionList.make();
            while (cur instanceof ConsInstructionList) {
                rev = ConsInstructionList.make(((ConsInstructionList)cur).getHeadInstructionList(), rev);
                cur = ((ConsInstructionList)cur).getTailInstructionList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("InstructionList(");
        if (this instanceof ConsInstructionList) {
            TInstructionList cur = this;
            while (cur instanceof ConsInstructionList) {
                TInstruction elem = ((ConsInstructionList)cur).getHeadInstructionList();
                cur = ((ConsInstructionList)cur).getTailInstructionList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsInstructionList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyInstructionList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TInstructionList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "InstructionList".equals((appl = (ATermAppl)trm).getName())) {
            InstructionList res = EmptyInstructionList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TInstruction elem = TInstruction.fromTerm(array[i]);
                res = ConsInstructionList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

