/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tinstruction;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TInstruction;
import tom.library.sl.Visitable;

public final class Multianewarray
extends TInstruction
implements Visitable {
    private int hashCode;
    private static Multianewarray proto = new Multianewarray();
    private String _typeDesc;
    private int _dims;

    private Multianewarray() {
    }

    public static Multianewarray make(String _typeDesc, int _dims) {
        proto.initHashCode(_typeDesc, _dims);
        return (Multianewarray)factory.build((SharedObject)proto);
    }

    private void init(String _typeDesc, int _dims, int hashCode) {
        this._typeDesc = _typeDesc.intern();
        this._dims = _dims;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _typeDesc, int _dims) {
        this._typeDesc = _typeDesc.intern();
        this._dims = _dims;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "Multianewarray";
    }

    private int getArity() {
        return 2;
    }

    public SharedObject duplicate() {
        Multianewarray clone = new Multianewarray();
        clone.init(this._typeDesc, this._dims, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("Multianewarray(");
        buffer.append('\"');
        block11: for (int i = 0; i < this._typeDesc.length(); ++i) {
            char c = this._typeDesc.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block11;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block11;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block11;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block11;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block11;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block11;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block11;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        buffer.append(this._dims);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Multianewarray tco = (Multianewarray)ao;
        int _typeDescCmp = this._typeDesc.compareTo(tco._typeDesc);
        if (_typeDescCmp != 0) {
            return _typeDescCmp;
        }
        if (this._dims != tco._dims) {
            return this._dims < tco._dims ? -1 : 1;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Multianewarray tco = (Multianewarray)ao;
        int _typeDescCmp = this._typeDesc.compareTo(tco._typeDesc);
        if (_typeDescCmp != 0) {
            return _typeDescCmp;
        }
        if (this._dims != tco._dims) {
            return this._dims < tco._dims ? -1 : 1;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof Multianewarray) {
            Multianewarray peer = (Multianewarray)obj;
            return this._typeDesc == peer._typeDesc && this._dims == peer._dims;
        }
        return false;
    }

    public boolean isMultianewarray() {
        return true;
    }

    public String gettypeDesc() {
        return this._typeDesc;
    }

    public TInstruction settypeDesc(String set_arg) {
        return Multianewarray.make(set_arg, this._dims);
    }

    public int getdims() {
        return this._dims;
    }

    public TInstruction setdims(int set_arg) {
        return Multianewarray.make(this._typeDesc, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.gettypeDesc(), 0, true)), atermFactory.makeInt(this.getdims())});
    }

    public static TInstruction fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return Multianewarray.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), ((ATermInt)appl.getArgument(1)).getInt());
            }
        }
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            default: 
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            default: 
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 0) {
            return Multianewarray.make(this.gettypeDesc(), this.getdims());
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[0];
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 1473589248;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._typeDesc, (int)1) << 8;
        a += this._dims;
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

