/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types;

import aterm.ATerm;
import java.io.IOException;
import java.io.InputStream;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.BytecodeVisitor;
import tom.library.adt.bytecode.types.ttype.ARRAY;
import tom.library.adt.bytecode.types.ttype.BOOLEAN;
import tom.library.adt.bytecode.types.ttype.BYTE;
import tom.library.adt.bytecode.types.ttype.CHAR;
import tom.library.adt.bytecode.types.ttype.DOUBLE;
import tom.library.adt.bytecode.types.ttype.FLOAT;
import tom.library.adt.bytecode.types.ttype.INT;
import tom.library.adt.bytecode.types.ttype.LONG;
import tom.library.adt.bytecode.types.ttype.OBJECT;
import tom.library.adt.bytecode.types.ttype.SHORT;
import tom.library.adt.bytecode.types.ttype.VOID;
import tom.library.sl.VisitFailure;

public abstract class TType
extends BytecodeAbstractType {
    public BytecodeAbstractType accept(BytecodeVisitor v) throws VisitFailure {
        return v.visit_TType(this);
    }

    public boolean isARRAY() {
        return false;
    }

    public boolean isBOOLEAN() {
        return false;
    }

    public boolean isBYTE() {
        return false;
    }

    public boolean isCHAR() {
        return false;
    }

    public boolean isDOUBLE() {
        return false;
    }

    public boolean isFLOAT() {
        return false;
    }

    public boolean isINT() {
        return false;
    }

    public boolean isLONG() {
        return false;
    }

    public boolean isOBJECT() {
        return false;
    }

    public boolean isSHORT() {
        return false;
    }

    public boolean isVOID() {
        return false;
    }

    public static TType fromTerm(ATerm trm) {
        TType tmp = ARRAY.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = BOOLEAN.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = BYTE.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = CHAR.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = DOUBLE.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = FLOAT.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = INT.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = LONG.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = OBJECT.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = SHORT.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = VOID.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        throw new IllegalArgumentException("This is not a TType " + trm);
    }

    public static TType fromString(String s) {
        return TType.fromTerm(atermFactory.parse(s));
    }

    public static TType fromStream(InputStream stream) throws IOException {
        return TType.fromTerm(atermFactory.readFromFile(stream));
    }

    public int length() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }

    public TType reverse() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }
}

