/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types;

import aterm.ATerm;
import java.io.IOException;
import java.io.InputStream;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.BytecodeVisitor;
import tom.library.adt.bytecode.types.TLabel;
import tom.library.adt.bytecode.types.thandler.CatchHandler;
import tom.library.adt.bytecode.types.thandler.FinallyHandler;
import tom.library.sl.VisitFailure;

public abstract class THandler
extends BytecodeAbstractType {
    public BytecodeAbstractType accept(BytecodeVisitor v) throws VisitFailure {
        return v.visit_THandler(this);
    }

    public boolean isCatchHandler() {
        return false;
    }

    public boolean isFinallyHandler() {
        return false;
    }

    public TLabel gethandler() {
        throw new UnsupportedOperationException("This THandler has no handler");
    }

    public THandler sethandler(TLabel _arg) {
        throw new UnsupportedOperationException("This THandler has no handler");
    }

    public String gettype() {
        throw new UnsupportedOperationException("This THandler has no type");
    }

    public THandler settype(String _arg) {
        throw new UnsupportedOperationException("This THandler has no type");
    }

    public static THandler fromTerm(ATerm trm) {
        THandler tmp = CatchHandler.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = FinallyHandler.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        throw new IllegalArgumentException("This is not a THandler " + trm);
    }

    public static THandler fromString(String s) {
        return THandler.fromTerm(atermFactory.parse(s));
    }

    public static THandler fromStream(InputStream stream) throws IOException {
        return THandler.fromTerm(atermFactory.readFromFile(stream));
    }

    public int length() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }

    public THandler reverse() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }
}

