/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.InputParser;
import com.sun.xacml.ctx.Subject;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestCtx {
    private Set subjects = null;
    private Set resource = null;
    private Set action = null;
    private Set environment = null;
    private Node documentRoot = null;
    private String resourceContent;

    public RequestCtx(Set set, Set set2, Set set3, Set set4) {
        this(set, set2, set3, set4, null, null);
    }

    public RequestCtx(Set set, Set set2, Set set3, Set set4, Node node) {
        this(set, set2, set3, set4, node, null);
    }

    public RequestCtx(Set set, Set set2, Set set3, Set set4, String string) {
        this(set, set2, set3, set4, null, string);
    }

    public RequestCtx(Set set, Set set2, Set set3, Set set4, Node node, String string) throws IllegalArgumentException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Subject) continue;
            throw new IllegalArgumentException("Subjects input is not well formed");
        }
        this.subjects = Collections.unmodifiableSet(new HashSet(set));
        Iterator iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            if (iterator2.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Resource input is not well formed");
        }
        this.resource = Collections.unmodifiableSet(new HashSet(set2));
        Iterator iterator3 = set3.iterator();
        while (iterator3.hasNext()) {
            if (iterator3.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Action input is not well formed");
        }
        this.action = Collections.unmodifiableSet(new HashSet(set3));
        Iterator iterator4 = set4.iterator();
        while (iterator4.hasNext()) {
            if (iterator4.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Environment input is not well formed");
        }
        this.environment = Collections.unmodifiableSet(new HashSet(set4));
        this.documentRoot = node;
        this.resourceContent = string;
    }

    public static RequestCtx getInstance(Node node) throws ParsingException {
        HashSet<Subject> hashSet = new HashSet<Subject>();
        Set set = null;
        Set set2 = null;
        Set set3 = null;
        String string = node.getNodeName();
        if (!string.equals("Request")) {
            throw new ParsingException("Request cannot be constructed using type: " + node.getNodeName());
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("Subject")) {
                Node node3 = node2.getAttributes().getNamedItem("SubjectCategory");
                URI uRI = null;
                if (node3 != null) {
                    try {
                        uRI = new URI(node3.getNodeValue());
                    }
                    catch (Exception exception) {
                        throw new ParsingException("Invalid Category URI", exception);
                    }
                }
                Set set4 = RequestCtx.parseAttributes(node2);
                hashSet.add(new Subject(uRI, set4));
                continue;
            }
            if (string2.equals("Resource")) {
                set = RequestCtx.parseAttributes(node2);
                continue;
            }
            if (string2.equals("Action")) {
                set2 = RequestCtx.parseAttributes(node2);
                continue;
            }
            if (!string2.equals("Environment")) continue;
            set3 = RequestCtx.parseAttributes(node2);
        }
        if (set3 == null) {
            set3 = new HashSet();
        }
        return new RequestCtx(hashSet, set, set2, set3, node);
    }

    private static Set parseAttributes(Node node) throws ParsingException {
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("Attribute")) continue;
            hashSet.add(Attribute.getInstance(node2));
        }
        return hashSet;
    }

    public static RequestCtx getInstance(InputStream inputStream) throws ParsingException {
        return RequestCtx.getInstance(InputParser.parseInput(inputStream, "Request"));
    }

    public Set getSubjects() {
        return this.subjects;
    }

    public Set getResource() {
        return this.resource;
    }

    public Set getAction() {
        return this.action;
    }

    public Set getEnvironmentAttributes() {
        return this.environment;
    }

    public Node getDocumentRoot() {
        return this.documentRoot;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        printStream.println(string + "<Request>");
        indenter.in();
        String string2 = indenter.makeString();
        indenter.in();
        Iterator iterator = this.subjects.iterator();
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            printStream.print(string2 + "<Subject SubjectCategory=\"" + subject.getCategory().toString() + "\"");
            Set set = subject.getAttributes();
            if (set.size() == 0) {
                printStream.println("/>");
                continue;
            }
            printStream.println(">");
            this.encodeAttributes(set, printStream, indenter);
            printStream.println(string2 + "</Subject>");
        }
        if (this.resource.size() != 0 || this.resourceContent != null) {
            printStream.println(string2 + "<Resource>");
            if (this.resourceContent != null) {
                printStream.println(indenter.makeString() + "<ResourceContent>" + this.resourceContent + "</ResourceContent>");
            }
            this.encodeAttributes(this.resource, printStream, indenter);
            printStream.println(string2 + "</Resource>");
        } else {
            printStream.println(string2 + "<Resource/>");
        }
        if (this.action.size() != 0) {
            printStream.println(string2 + "<Action>");
            this.encodeAttributes(this.action, printStream, indenter);
            printStream.println(string2 + "</Action>");
        } else {
            printStream.println(string2 + "<Action/>");
        }
        if (this.environment.size() != 0) {
            printStream.println(string2 + "<Environment>");
            this.encodeAttributes(this.environment, printStream, indenter);
            printStream.println(string2 + "</Environment>");
        }
        indenter.out();
        indenter.out();
        printStream.println(string + "</Request>");
    }

    private void encodeAttributes(Set set, PrintStream printStream, Indenter indenter) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            attribute.encode(printStream, indenter);
        }
    }
}

