/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringNormalizeFunction
extends FunctionBase {
    public static final String NAME_STRING_NORMALIZE_SPACE = "urn:oasis:names:tc:xacml:1.0:function:string-normalize-space";
    public static final String NAME_STRING_NORMALIZE_TO_LOWER_CASE = "urn:oasis:names:tc:xacml:1.0:function:string-normalize-to-lower-case";
    private static final int ID_STRING_NORMALIZE_SPACE = 0;
    private static final int ID_STRING_NORMALIZE_TO_LOWER_CASE = 1;

    public StringNormalizeFunction(String string) {
        super(string, StringNormalizeFunction.getId(string), "http://www.w3.org/2001/XMLSchema#string", false, 1, "http://www.w3.org/2001/XMLSchema#string", false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_STRING_NORMALIZE_SPACE)) {
            return 0;
        }
        if (string.equals(NAME_STRING_NORMALIZE_TO_LOWER_CASE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown normalize function " + string);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_STRING_NORMALIZE_SPACE);
        hashSet.add(NAME_STRING_NORMALIZE_TO_LOWER_CASE);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        switch (this.getFunctionId()) {
            case 0: {
                int n;
                String string = ((StringAttribute)attributeValueArray[0]).getValue();
                int n2 = string.length() - 1;
                for (n = 0; n <= n2 && Character.isWhitespace(string.charAt(n)); ++n) {
                }
                while (n <= n2 && Character.isWhitespace(string.charAt(n2))) {
                    --n2;
                }
                String string2 = string.substring(n, n2 + 1);
                evaluationResult = new EvaluationResult(new StringAttribute(string2));
                break;
            }
            case 1: {
                String string = ((StringAttribute)attributeValueArray[0]).getValue();
                String string3 = string.toLowerCase();
                evaluationResult = new EvaluationResult(new StringAttribute(string3));
            }
        }
        return evaluationResult;
    }
}

