/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DoubleAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoundFunction
extends FunctionBase {
    public static final String NAME_ROUND = "urn:oasis:names:tc:xacml:1.0:function:round";

    public RoundFunction(String string) {
        super(NAME_ROUND, 0, "http://www.w3.org/2001/XMLSchema#double", false, 1, "http://www.w3.org/2001/XMLSchema#double", false);
        if (!string.equals(NAME_ROUND)) {
            throw new IllegalArgumentException("unknown round function: " + string);
        }
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_ROUND);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        double d;
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        double d2 = ((DoubleAttribute)attributeValueArray[0]).getValue();
        double d3 = Math.round(d2);
        double d4 = Math.floor(d2);
        if (d2 - d4 == (d = d4 + 1.0) - d2) {
            d3 = d4 % 2.0 == 0.0 ? d4 : d;
        }
        return new EvaluationResult(new DoubleAttribute(d3));
    }
}

