/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DoubleAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NumericConvertFunction
extends FunctionBase {
    public static final String NAME_DOUBLE_TO_INTEGER = "urn:oasis:names:tc:xacml:1.0:function:double-to-integer";
    public static final String NAME_INTEGER_TO_DOUBLE = "urn:oasis:names:tc:xacml:1.0:function:integer-to-double";
    private static final int ID_DOUBLE_TO_INTEGER = 0;
    private static final int ID_INTEGER_TO_DOUBLE = 1;

    public NumericConvertFunction(String string) {
        super(string, NumericConvertFunction.getId(string), NumericConvertFunction.getArgumentType(string), false, 1, NumericConvertFunction.getReturnType(string), false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_DOUBLE_TO_INTEGER)) {
            return 0;
        }
        if (string.equals(NAME_INTEGER_TO_DOUBLE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown convert function " + string);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_DOUBLE_TO_INTEGER);
        hashSet.add(NAME_INTEGER_TO_DOUBLE);
        return hashSet;
    }

    private static String getArgumentType(String string) {
        if (string.equals(NAME_DOUBLE_TO_INTEGER)) {
            return "http://www.w3.org/2001/XMLSchema#double";
        }
        return "http://www.w3.org/2001/XMLSchema#integer";
    }

    private static String getReturnType(String string) {
        if (string.equals(NAME_DOUBLE_TO_INTEGER)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        switch (this.getFunctionId()) {
            case 0: {
                double d = ((DoubleAttribute)attributeValueArray[0]).getValue();
                long l = (long)d;
                evaluationResult = new EvaluationResult(new IntegerAttribute(l));
                break;
            }
            case 1: {
                long l = ((IntegerAttribute)attributeValueArray[0]).getValue();
                double d = l;
                evaluationResult = new EvaluationResult(new DoubleAttribute(d));
            }
        }
        return evaluationResult;
    }
}

