/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LogicalFunction
extends FunctionBase {
    public static final String NAME_OR = "urn:oasis:names:tc:xacml:1.0:function:or";
    public static final String NAME_AND = "urn:oasis:names:tc:xacml:1.0:function:and";
    private static final int ID_OR = 0;
    private static final int ID_AND = 1;

    public LogicalFunction(String string) {
        super(string, LogicalFunction.getId(string), "http://www.w3.org/2001/XMLSchema#boolean", false, -1, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_OR)) {
            return 0;
        }
        if (string.equals(NAME_AND)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown logical function: " + string);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_OR);
        hashSet.add(NAME_AND);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Evaluatable evaluatable = (Evaluatable)iterator.next();
            EvaluationResult evaluationResult = evaluatable.evaluate(evaluationCtx);
            if (evaluationResult.indeterminate()) {
                return evaluationResult;
            }
            AttributeValue attributeValue = evaluationResult.getAttributeValue();
            boolean bl = ((BooleanAttribute)attributeValue).getValue();
            switch (this.getFunctionId()) {
                case 0: {
                    if (!bl) break;
                    return EvaluationResult.getTrueInstance();
                }
                case 1: {
                    if (bl) break;
                    return EvaluationResult.getFalseInstance();
                }
            }
        }
        if (this.getFunctionId() == 0) {
            return EvaluationResult.getFalseInstance();
        }
        return EvaluationResult.getTrueInstance();
    }
}

