/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HigherOrderFunction
implements Function {
    public static final String NAME_ANY_OF = "urn:oasis:names:tc:xacml:1.0:function:any-of";
    public static final String NAME_ALL_OF = "urn:oasis:names:tc:xacml:1.0:function:all-of";
    public static final String NAME_ANY_OF_ANY = "urn:oasis:names:tc:xacml:1.0:function:any-of-any";
    public static final String NAME_ALL_OF_ANY = "urn:oasis:names:tc:xacml:1.0:function:all-of-any";
    public static final String NAME_ANY_OF_ALL = "urn:oasis:names:tc:xacml:1.0:function:any-of-all";
    public static final String NAME_ALL_OF_ALL = "urn:oasis:names:tc:xacml:1.0:function:all-of-all";
    private static final int ID_ANY_OF = 0;
    private static final int ID_ALL_OF = 1;
    private static final int ID_ANY_OF_ANY = 2;
    private static final int ID_ALL_OF_ANY = 3;
    private static final int ID_ANY_OF_ALL = 4;
    private static final int ID_ALL_OF_ALL = 5;
    private static HashMap idMap;
    private int functionId;
    private URI identifier;
    private boolean secondIsBag;
    private static URI returnTypeURI;
    private static RuntimeException earlyException;

    public HigherOrderFunction(String string) {
        Integer n = (Integer)idMap.get(string);
        if (n == null) {
            throw new IllegalArgumentException("unknown function: " + string);
        }
        this.functionId = n;
        try {
            this.identifier = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("invalid URI");
        }
        this.secondIsBag = this.functionId != 0 && this.functionId != 1;
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(idMap.keySet());
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public URI getReturnType() {
        if (earlyException != null) {
            throw earlyException;
        }
        return returnTypeURI;
    }

    public boolean returnsBag() {
        return false;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        Iterator iterator = list.iterator();
        Function function = (Function)iterator.next();
        AttributeValue[] attributeValueArray = new AttributeValue[]{(AttributeValue)iterator.next(), (AttributeValue)iterator.next()};
        EvaluationResult evaluationResult = null;
        block0 : switch (this.functionId) {
            case 0: {
                evaluationResult = this.any(attributeValueArray[0], (BagAttribute)attributeValueArray[1], function, evaluationCtx, false);
                break;
            }
            case 1: {
                evaluationResult = this.all(attributeValueArray[0], (BagAttribute)attributeValueArray[1], function, evaluationCtx);
                break;
            }
            case 2: {
                Iterator iterator2 = ((BagAttribute)attributeValueArray[0]).iterator();
                BagAttribute bagAttribute = (BagAttribute)attributeValueArray[1];
                while (iterator2.hasNext()) {
                    AttributeValue attributeValue = (AttributeValue)iterator2.next();
                    evaluationResult = this.any(attributeValue, bagAttribute, function, evaluationCtx, false);
                    if (evaluationResult.indeterminate()) {
                        return evaluationResult;
                    }
                    if (!((BooleanAttribute)evaluationResult.getAttributeValue()).getValue()) continue;
                    break block0;
                }
                break;
            }
            case 3: {
                evaluationResult = this.allOfAny((BagAttribute)attributeValueArray[1], (BagAttribute)attributeValueArray[0], function, evaluationCtx);
                break;
            }
            case 4: {
                evaluationResult = this.anyOfAll((BagAttribute)attributeValueArray[0], (BagAttribute)attributeValueArray[1], function, evaluationCtx);
                break;
            }
            case 5: {
                Iterator iterator3 = ((BagAttribute)attributeValueArray[0]).iterator();
                BagAttribute bagAttribute = (BagAttribute)attributeValueArray[1];
                while (iterator3.hasNext()) {
                    AttributeValue attributeValue = (AttributeValue)iterator3.next();
                    evaluationResult = this.all((AttributeValue)iterator3.next(), bagAttribute, function, evaluationCtx);
                    if (evaluationResult.indeterminate()) {
                        return evaluationResult;
                    }
                    if (((BooleanAttribute)evaluationResult.getAttributeValue()).getValue()) continue;
                    break block0;
                }
                break;
            }
        }
        return evaluationResult;
    }

    public void checkInputs(List list) throws IllegalArgumentException {
        Object[] objectArray = list.toArray();
        if (objectArray.length != 3) {
            throw new IllegalArgumentException("requires three inputs");
        }
        if (!(objectArray[0] instanceof Function)) {
            throw new IllegalArgumentException("first arg to higher-order  function must be a function");
        }
        if (!((Function)objectArray[0]).getReturnType().toString().equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            throw new IllegalArgumentException("higher-order function must use a boolean function");
        }
        Evaluatable evaluatable = (Evaluatable)objectArray[1];
        Evaluatable evaluatable2 = (Evaluatable)objectArray[2];
        if (!evaluatable.getType().equals(evaluatable2.getType())) {
            throw new IllegalArgumentException("input types to the any/all functions must match");
        }
        if (this.secondIsBag && !evaluatable.evaluatesToBag()) {
            throw new IllegalArgumentException("first arg has to be a bag");
        }
        if (!evaluatable2.evaluatesToBag()) {
            throw new IllegalArgumentException("second arg has to be a bag");
        }
        ArrayList<Evaluatable> arrayList = new ArrayList<Evaluatable>();
        arrayList.add(evaluatable);
        arrayList.add(evaluatable2);
        ((Function)objectArray[0]).checkInputsNoBag(arrayList);
    }

    public void checkInputsNoBag(List list) throws IllegalArgumentException {
        throw new IllegalArgumentException("higher-order functions require use of bags");
    }

    private EvaluationResult any(AttributeValue attributeValue, BagAttribute bagAttribute, Function function, EvaluationCtx evaluationCtx, boolean bl) {
        return this.anyAndAllHelper(attributeValue, bagAttribute, function, evaluationCtx, false, bl);
    }

    private EvaluationResult all(AttributeValue attributeValue, BagAttribute bagAttribute, Function function, EvaluationCtx evaluationCtx) {
        return this.anyAndAllHelper(attributeValue, bagAttribute, function, evaluationCtx, true, false);
    }

    private EvaluationResult anyAndAllHelper(AttributeValue attributeValue, BagAttribute bagAttribute, Function function, EvaluationCtx evaluationCtx, boolean bl, boolean bl2) {
        BooleanAttribute booleanAttribute = BooleanAttribute.getInstance(bl);
        Iterator iterator = bagAttribute.iterator();
        while (iterator.hasNext()) {
            ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
            if (!bl2) {
                arrayList.add(attributeValue);
                arrayList.add((AttributeValue)iterator.next());
            } else {
                arrayList.add((AttributeValue)iterator.next());
                arrayList.add(attributeValue);
            }
            EvaluationResult evaluationResult = function.evaluate(arrayList, evaluationCtx);
            if (evaluationResult.indeterminate()) {
                return evaluationResult;
            }
            BooleanAttribute booleanAttribute2 = (BooleanAttribute)evaluationResult.getAttributeValue();
            if (booleanAttribute2.getValue() == bl) continue;
            booleanAttribute = booleanAttribute2;
            break;
        }
        return new EvaluationResult(booleanAttribute);
    }

    private EvaluationResult anyOfAll(BagAttribute bagAttribute, BagAttribute bagAttribute2, Function function, EvaluationCtx evaluationCtx) {
        return this.allAnyHelper(bagAttribute, bagAttribute2, function, evaluationCtx, true);
    }

    private EvaluationResult allOfAny(BagAttribute bagAttribute, BagAttribute bagAttribute2, Function function, EvaluationCtx evaluationCtx) {
        return this.allAnyHelper(bagAttribute, bagAttribute2, function, evaluationCtx, false);
    }

    private EvaluationResult allAnyHelper(BagAttribute bagAttribute, BagAttribute bagAttribute2, Function function, EvaluationCtx evaluationCtx, boolean bl) {
        Iterator iterator = bagAttribute2.iterator();
        while (iterator.hasNext()) {
            AttributeValue attributeValue = (AttributeValue)iterator.next();
            EvaluationResult evaluationResult = this.any(attributeValue, bagAttribute, function, evaluationCtx, bl);
            if (evaluationResult.indeterminate()) {
                return evaluationResult;
            }
            if (((BooleanAttribute)evaluationResult.getAttributeValue()).getValue()) continue;
            return evaluationResult;
        }
        return new EvaluationResult(BooleanAttribute.getTrueInstance());
    }

    static {
        try {
            returnTypeURI = new URI("http://www.w3.org/2001/XMLSchema#boolean");
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
        idMap = new HashMap();
        idMap.put(NAME_ANY_OF, new Integer(0));
        idMap.put(NAME_ALL_OF, new Integer(1));
        idMap.put(NAME_ANY_OF_ANY, new Integer(2));
        idMap.put(NAME_ALL_OF_ANY, new Integer(3));
        idMap.put(NAME_ANY_OF_ALL, new Integer(4));
        idMap.put(NAME_ALL_OF_ALL, new Integer(5));
    }
}

