/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.BagFunction;
import com.sun.xacml.cond.EvaluationResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneralBagFunction
extends BagFunction {
    private static final int ID_BASE_ONE_AND_ONLY = 0;
    private static final int ID_BASE_BAG_SIZE = 1;
    private static final int ID_BASE_BAG = 2;
    private static HashMap paramMap = new HashMap();
    private static Set supportedIds;

    public GeneralBagFunction(String string) {
        super(string, GeneralBagFunction.getId(string), GeneralBagFunction.getArgumentType(string), GeneralBagFunction.getIsBag(string), GeneralBagFunction.getNumArgs(string), GeneralBagFunction.getReturnType(string), GeneralBagFunction.getReturnsBag(string));
    }

    public GeneralBagFunction(String string, String string2, String string3) {
        super(string, GeneralBagFunction.getId(string3), string2, GeneralBagFunction.getIsBag(string3), GeneralBagFunction.getNumArgs(string3), GeneralBagFunction.getCustomReturnType(string3, string2), GeneralBagFunction.getReturnsBag(string3));
    }

    private static int getId(String string) {
        BagParameters bagParameters = (BagParameters)paramMap.get(string);
        if (bagParameters == null) {
            throw new IllegalArgumentException("unknown bag function: " + string);
        }
        return bagParameters.id;
    }

    private static String getArgumentType(String string) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)string)).arg;
    }

    private static boolean getIsBag(String string) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)string)).argIsBag;
    }

    private static int getNumArgs(String string) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)string)).params;
    }

    private static String getReturnType(String string) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)string)).returnType;
    }

    private static boolean getReturnsBag(String string) {
        return ((BagParameters)GeneralBagFunction.paramMap.get((Object)string)).returnsBag;
    }

    private static String getCustomReturnType(String string, String string2) {
        String string3 = ((BagParameters)GeneralBagFunction.paramMap.get((Object)string)).returnType;
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static Set getSupportedIdentifiers() {
        return supportedIds;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        AttributeValue attributeValue = null;
        switch (this.getFunctionId()) {
            case 0: {
                BagAttribute bagAttribute = (BagAttribute)attributeValueArray[0];
                if (bagAttribute.size() != 1) {
                    return GeneralBagFunction.makeProcessingError(this.getFunctionName() + " expects " + "a bag that contains a single " + "element, got a bag with " + bagAttribute.size() + " elements");
                }
                attributeValue = (AttributeValue)bagAttribute.iterator().next();
                break;
            }
            case 1: {
                BagAttribute bagAttribute = (BagAttribute)attributeValueArray[0];
                attributeValue = new IntegerAttribute(bagAttribute.size());
                break;
            }
            case 2: {
                List<AttributeValue> list2 = Arrays.asList(attributeValueArray);
                attributeValue = new BagAttribute(this.getReturnType(), list2);
            }
        }
        return new EvaluationResult(attributeValue);
    }

    static {
        for (int i = 0; i < baseTypes.length; ++i) {
            String string = baseTypes[i];
            String string2 = "urn:oasis:names:tc:xacml:1.0:function:" + simpleTypes[i];
            paramMap.put(string2 + "-one-and-only", new BagParameters(0, string, true, 1, string, false));
            paramMap.put(string2 + "-bag-size", new BagParameters(1, string, true, 1, "http://www.w3.org/2001/XMLSchema#integer", false));
            paramMap.put(string2 + "-bag", new BagParameters(2, string, false, -1, string, true));
        }
        supportedIds = Collections.unmodifiableSet(new HashSet(paramMap.keySet()));
        paramMap.put("-one-and-only", new BagParameters(0, null, true, 1, null, false));
        paramMap.put("-bag-size", new BagParameters(1, null, true, 1, "http://www.w3.org/2001/XMLSchema#integer", false));
        paramMap.put("-bag", new BagParameters(2, null, false, -1, null, true));
    }

    private static class BagParameters {
        public int id;
        public String arg;
        public boolean argIsBag;
        public int params;
        public String returnType;
        public boolean returnsBag;

        public BagParameters(int n, String string, boolean bl, int n2, String string2, boolean bl2) {
            this.id = n;
            this.arg = string;
            this.argIsBag = bl;
            this.params = n2;
            this.returnType = string2;
            this.returnsBag = bl2;
        }
    }
}

