/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateAttribute;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.DayTimeDurationAttribute;
import com.sun.xacml.attr.YearMonthDurationAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DateMathFunction
extends FunctionBase {
    public static final String NAME_DATETIME_ADD_DAYTIMEDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-add-dayTimeDuration";
    public static final String NAME_DATETIME_SUBTRACT_DAYTIMEDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-subtract-dayTimeDuration";
    public static final String NAME_DATETIME_ADD_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-add-yearMonthDuration";
    public static final String NAME_DATETIME_SUBTRACT_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-subtract-yearMonthDuration";
    public static final String NAME_DATE_ADD_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:date-add-yearMonthDuration";
    public static final String NAME_DATE_SUBTRACT_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:date-subtract-yearMonthDuration";
    private static final int ID_DATETIME_ADD_DAYTIMEDURATION = 0;
    private static final int ID_DATETIME_SUBTRACT_DAYTIMEDURATION = 1;
    private static final int ID_DATETIME_ADD_YEARMONTHDURATION = 2;
    private static final int ID_DATETIME_SUBTRACT_YEARMONTHDURATION = 3;
    private static final int ID_DATE_ADD_YEARMONTHDURATION = 4;
    private static final int ID_DATE_SUBTRACT_YEARMONTHDURATION = 5;
    private static final String[] dateTimeDayTimeDurationArgTypes = new String[]{"http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration"};
    private static final String[] dateTimeYearMonthDurationArgTypes = new String[]{"http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration"};
    private static final String[] dateYearMonthDurationArgTypes = new String[]{"http://www.w3.org/2001/XMLSchema#date", "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration"};
    private static final boolean[] bagParams = new boolean[]{false, false};
    private String[] argTypes = null;
    private static HashMap idMap = new HashMap();
    private static HashMap typeMap;

    public DateMathFunction(String string) {
        super(string, DateMathFunction.getId(string), DateMathFunction.getArgumentTypes(string), bagParams, DateMathFunction.getReturnType(string), false);
    }

    private static int getId(String string) {
        Integer n = (Integer)idMap.get(string);
        if (n == null) {
            throw new IllegalArgumentException("unknown datemath function " + string);
        }
        return n;
    }

    private static String[] getArgumentTypes(String string) {
        return (String[])typeMap.get(string);
    }

    private static String getReturnType(String string) {
        if (string.equals(NAME_DATE_ADD_YEARMONTHDURATION) || string.equals(NAME_DATE_SUBTRACT_YEARMONTHDURATION)) {
            return "http://www.w3.org/2001/XMLSchema#date";
        }
        return "http://www.w3.org/2001/XMLSchema#dateTime";
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(idMap.keySet());
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        AttributeValue attributeValue = null;
        switch (this.getFunctionId()) {
            case 0: 
            case 1: {
                DateTimeAttribute dateTimeAttribute = (DateTimeAttribute)attributeValueArray[0];
                DayTimeDurationAttribute dayTimeDurationAttribute = (DayTimeDurationAttribute)attributeValueArray[1];
                int n = 1;
                if (this.getFunctionId() == 1) {
                    n = -n;
                }
                if (dayTimeDurationAttribute.isNegative()) {
                    n = -n;
                }
                long l = (long)n * dayTimeDurationAttribute.getTotalSeconds();
                long l2 = dateTimeAttribute.getNanoseconds();
                if ((l2 += (long)(n * dayTimeDurationAttribute.getNanoseconds())) >= 1000000000L) {
                    l2 -= 1000000000L;
                    l += 1000L;
                }
                if (l2 < 0L) {
                    l2 += 1000000000L;
                    l -= 1000L;
                }
                attributeValue = new DateTimeAttribute(new Date(l += dateTimeAttribute.getValue().getTime()), (int)l2, dateTimeAttribute.getTimeZone(), dateTimeAttribute.getDefaultedTimeZone());
                break;
            }
            case 2: 
            case 3: {
                DateTimeAttribute dateTimeAttribute = (DateTimeAttribute)attributeValueArray[0];
                YearMonthDurationAttribute yearMonthDurationAttribute = (YearMonthDurationAttribute)attributeValueArray[1];
                int n = 1;
                if (this.getFunctionId() == 3) {
                    n = -n;
                }
                if (yearMonthDurationAttribute.isNegative()) {
                    n = -n;
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(dateTimeAttribute.getValue());
                long l = (long)n * yearMonthDurationAttribute.getYears();
                long l3 = (long)n * yearMonthDurationAttribute.getMonths();
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("years too large");
                }
                if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("months too large");
                }
                ((Calendar)gregorianCalendar).add(1, (int)l);
                ((Calendar)gregorianCalendar).add(2, (int)l3);
                attributeValue = new DateTimeAttribute(gregorianCalendar.getTime(), dateTimeAttribute.getNanoseconds(), dateTimeAttribute.getTimeZone(), dateTimeAttribute.getDefaultedTimeZone());
                break;
            }
            case 4: 
            case 5: {
                DateAttribute dateAttribute = (DateAttribute)attributeValueArray[0];
                YearMonthDurationAttribute yearMonthDurationAttribute = (YearMonthDurationAttribute)attributeValueArray[1];
                int n = 1;
                if (this.getFunctionId() == 5) {
                    n = -n;
                }
                if (yearMonthDurationAttribute.isNegative()) {
                    n = -n;
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(dateAttribute.getValue());
                long l = (long)n * yearMonthDurationAttribute.getYears();
                long l4 = (long)n * yearMonthDurationAttribute.getMonths();
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("years too large");
                }
                if (l4 > Integer.MAX_VALUE || l4 < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("months too large");
                }
                ((Calendar)gregorianCalendar).add(1, (int)l);
                ((Calendar)gregorianCalendar).add(2, (int)l4);
                attributeValue = new DateAttribute(gregorianCalendar.getTime(), dateAttribute.getTimeZone(), dateAttribute.getDefaultedTimeZone());
            }
        }
        return new EvaluationResult(attributeValue);
    }

    static {
        idMap.put(NAME_DATETIME_ADD_DAYTIMEDURATION, new Integer(0));
        idMap.put(NAME_DATETIME_SUBTRACT_DAYTIMEDURATION, new Integer(1));
        idMap.put(NAME_DATETIME_ADD_YEARMONTHDURATION, new Integer(2));
        idMap.put(NAME_DATETIME_SUBTRACT_YEARMONTHDURATION, new Integer(3));
        idMap.put(NAME_DATE_ADD_YEARMONTHDURATION, new Integer(4));
        idMap.put(NAME_DATE_SUBTRACT_YEARMONTHDURATION, new Integer(5));
        typeMap = new HashMap();
        typeMap.put(NAME_DATETIME_ADD_DAYTIMEDURATION, dateTimeDayTimeDurationArgTypes);
        typeMap.put(NAME_DATETIME_SUBTRACT_DAYTIMEDURATION, dateTimeDayTimeDurationArgTypes);
        typeMap.put(NAME_DATETIME_ADD_YEARMONTHDURATION, dateTimeYearMonthDurationArgTypes);
        typeMap.put(NAME_DATETIME_SUBTRACT_YEARMONTHDURATION, dateTimeYearMonthDurationArgTypes);
        typeMap.put(NAME_DATE_ADD_YEARMONTHDURATION, dateYearMonthDurationArgTypes);
        typeMap.put(NAME_DATE_SUBTRACT_YEARMONTHDURATION, dateYearMonthDurationArgTypes);
    }
}

